/*
 * UnixCW - Unix CW (Morse code) training program
 * Copyright (C) 2001  Simon Baldwin (simonb@caldera.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * XcwcpMultiLineEdit.h - Subclass of QMultiLineEdit for catching key events. 
 *
 */

#ifndef MULTILINEEDITEVENT_H
#define MULTILINEEDITEVENT_H

#include <qmultilineedit.h>

class	XcwcpApplication;
class	QWidget;
class	QKeyEvent;

class XcwcpMultiLineEdit: public QMultiLineEdit
{
	Q_OBJECT

private:
	XcwcpApplication
			*parent_xcwcp_reference;/* Reference to parent */

public:
	XcwcpMultiLineEdit (QWidget *parent = NULL, const char *name = NULL);
						/* Constructor */
	void		backspace();		/* Public backspace call */

protected:
	void		keyPressEvent (QKeyEvent *event);
	void		keyReleaseEvent (QKeyEvent *event);
						/* Catch key events */
	void		mousePressEvent (QMouseEvent *event);
	void		mouseDoubleClickEvent (QMouseEvent *event);
	void		mouseReleaseEvent (QMouseEvent *event);
						/* Catch mouse events */
};

#endif
