/*
 * UnixCW - Unix CW (Morse code) training program
 * Copyright (C) 2001  Simon Baldwin (simonb@caldera.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * cw.h - Header and definitions for morse code sender program.
 *        Include this file in any program that will need to
 *        interface with the sender.
 *
 */

#ifndef _CW_H
#define	_CW_H

/* General command and query introducers. */
#define	CW_CMD_ESCAPE		'@'	/* Command escape character */
#define	CW_CMD_QUERY		'?'	/* Query subcommand */
#define	CW_CMD_CWQUERY		'>'	/* Cw report query subcommand */
#define	CW_CMD_END		';'	/* Completes an embedded command */

/* Specific command value specifiers. */
#define	CW_CMDV_FREQUENCY	'T'	/* CW tone */
#define	CW_CMDV_SPEED		'W'	/* CW words-per-minute */
#define	CW_CMDV_GAP		'G'	/* CW extra gaps in sending */
#define	CW_CMDV_ECHO		'E'	/* CW echo chars to stdout */
#define	CW_CMDV_ERRORS		'M'	/* CW error msgs to stderr */
#define	CW_CMDV_SOUND		'S'	/* CW creates tones. otherwise silent */
#define	CW_CMDV_COMMANDS	'C'	/* CW responds to @... embedded cmds */
#define	CW_CMDV_COMBINATIONS	'O'	/* CW allows [..] combinations */
#define	CW_CMDV_COMMENTS	'P'	/* CW allows {..} combinations */
#define	CW_CMDV_QUIT		'Q'	/* CW program exit command */

/* Combination and comment start and end characters. */
#define	CW_COMBINATION_START	'['	/* Begin [..] */
#define	CW_COMBINATION_END	']'	/* End [..] */
#define	CW_COMMENT_START	'{'	/* Begin {..} */
#define	CW_COMMENT_END		'}'	/* End {..} */

/* Status values - first character of stderr messages. */
#define	CW_STATUS_OK		'='	/* =... command accepted */
#define	CW_STATUS_ERR		'?'	/* ?... error in command */

#endif /* _CW_H */
