#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# $Id: UltraPossum.py,v 1.1 2004/04/05 02:18:55 moriwaka Exp $

import UserDict
import os
import re

class UltraPossum:
    class Config(UserDict.UserDict):
        '''
        Lookup UltraPossum configuration
        >>> conf = UltraPossum.Config()
        >>> conf[key]
        '''
        MODULES = []
        configmatch = re.compile(r'([^=]+)="(.*)"')
        for line in os.popen("ultrapossum-config module").xreadlines():
            MODULES.append(line[:-1])

        def variables(mod):
            variables = []
            for line in os.popen("ultrapossum-config variable %s"
                                 % mod).xreadlines():
                variables.append(line[:-1])
            return variables

        VARIABLES = {}
        for m in MODULES:
            VARIABLES[m] = variables(m)

        def __init__(self):
            self.data = self.VARIABLES
            for line in os.popen("ultrapossum-config get").xreadlines():
                m = self.configmatch.match(line[:-1])
                assert m is not None
                self[m.group(1)] = m.group(2)

if __name__ == '__main__':
    for m in UltraPossum.Config.MODULES:
        print m
        for v in UltraPossum.Config.VARIABLES[m]:
            print "\t%s" % v

    conf = UltraPossum.Config()
    for key in conf.keys():
        print "%s -> %s" % (str(key), str(conf[key]))

