/* this is a first prerelease of desktop.h, the interface definition header
   for UDE's desktop library.please take a look at it and send us suggestions
   and improvements etc. NOTHING IS FIXED YET, there's enough space for your
   ideas, whishes and suggestions! and after all it's all you programmers out
   there who one day will use it, so please don't let us decide on our owns
   about your programming interface to ude. 
   send your suggestios to: arc@ude.org */

/* oh: although the file should be quite self-explaining and there can be some
   comments found about the most important things it's not really documented
   yet. of course you can send us any questions by mail (arc@ude.org), this will
   also let me know what needs to be doced. */
   
/* this file will be expanded in future */

#ifndef _UDE_DISPLAY_H
#define _UDE_DISPLAY_H

#include <X11/Xlib.h>
#include "desktop_internals.h"
#include "uwm/nodes.h" /* will have to implement a routine to insert an entry
                         somewhere into the middle of the list (before/after
                         a defined node.). */

#define UDE_MAXCOLORS 7
#define UDE_Back 0
#define UDE_Light 1
#define UDE_Shadow 2
#define UDE_StandardText 3
#define UDE_InactiveText 4
#define UDE_HighlightedText 5
#define UDE_HighlightedBack 6
typedef XColor UDEColors[UDE_MAXCOLORS];

typedef void (*UDEEventHandler)(XEvent *xevent,int type,void *GUIElement);

/*** structure available for each window in window's UDE_WINDOW_PROPERTY. ***/
typedef struct _UDEWin UDEWin;

struct _UDEWin {
  Display *disp;        /* guess we need this to identify the win and colors */
  Window win;
  short WorkSpace;
/*  UDEColors *Colors;     the array only needs to exist once per ws, we
                           just set a pointer to it for each window.
    moved to UDE_WORKSPACES_PROPERTY for technical reasons  */
  /* ... */
};

/*** global structure, available only once in root win's UDE_SETTINGS_PROPERTY.
                                                                            ***/
/** user preferences flags (item flags): **/
#define UDETransientMenus (1<<0) /* are menues transient or not? */
typedef struct _UDEDesktop UDEDesktop;

struct _UDEDesktop {
  Display *disp;        /* we need this to identify the gcs and fonts */
  short ActiveWorkSpace, WorkSpaces;
/*  char **WSpace;   an array containing the workspace names, NULL-termed 
    moved to UDE_WORKSPACES_PROPERTY             */
  unsigned int FrameBevelWidth;
  unsigned short flags;
  char StandardFont[256],HighlightFont[256],InactiveFont[256];
     /* font names to be passed to XLoadQueryFont() */
  /* ... */
};

/*** global array of structure available in root win's UDE_WORKSPACES_PROPERTY
                                                                            ***/
typedef struct _UDEWorkspaceExchange UDEWorkspaceExchange;

struct _UDEWorkspaceExchange {
  char name[32];
  UDEColors WorkspaceColors;
};

/*** basic-drawing prototypes ***/ 

/* drawing routines */

void UDEDrawBevel(Drawable win,int x1,int y1,int x2,int y2,int width,GC NW,GC SE);
void UDEDrawHexFieldBevel(Drawable win,int x,int y,int w,int h, GC NW,GC SE);
void UDEDrawHexBevel(Drawable win, int x, int y, int size, GC NW,GC SE);
   /* x: x-coord of the bevel's most left pixel ('middle left corner') 
      y: y-coord of the bevel's northern edge
      size: length of one outside edge of the hex.
      w,h: width and height of surrounding rectangle. */

Pixmap *UDECreateHexShape(int size, int *width, int *height);
   /* will create and return a bitmap of the desired size which can be used
      as shape for Hex elements. Will also return width and height of the
      bitmap, depth is always 1bpp
      the size argument can be calded from a width and height of an inside box 
      with UDECalcHexSize: */
int UDECalcHexSize(int width, int height);

Pixmap *UDECreateHexFieldShape(int width, int height);
   /* will create and return a bitmap of the desired size, not a perfect hex,
      but something similar fitting exactly into a rectangle of with and height.
      outside measurements can be calced from inside measurements with 
      UDECalcHexFieldMeasures: */
void UDECalcHexFieldMeasures(int *width, int *height);
      

/* X11-routine wraparounds, please use these instead of the original routines */
void UDEGrabServer();  /* wraparound for XGrabServer, will enable multilevel */
void UDEUngrabServer();/* grabbing */
void UDEGrabPointer(Window win,unsigned int mask, Cursor mouse);
                    /* wraparound for multilevel grabbing around XGrabPointer 
                        will not return until pointer grabbing succeeeds */
void UDEUngrabPointer();


UDEWin *UDECreateWinStructure(Display *disp,Window win);
/* will create an UDEWin structure for an already existing window */
UDEWin *UDECreateWin(Display *disp,Window parent,int x,int y,unsigned int width\
          ,unsigned int height,int depth,Visual *visual,unsigned long valuemask\
                                             ,XSetWindowAttributes *attributes);
/* will call XCreateWin and create an UDEWin structure for the new window */
/* same args as XCreateWindow, border_width is always 0
                               class is always InputOutput */

/*** event handling ***/

void (*UDEChangeEventHandler(int type,void (*handler)(XEvent *event)))\
                                                       (XEvent *event);
/* there is a library event handler and a program handler for each event. the
   program handlers will be called from the lib handler if needed, the lib
   handler is called from either HandleEventLoop or HandleWaitingEvents.
   ChangeEventHandler will return the old handler. A handler is called with
   a pointer to the XEvent structure describing the event and so should be of
   type:
     void handler(XEvent *event); */

/* to call internal library event handlers for a certain event */
void UDEHandleEvent(XEvent *event); /* This procedure will not call the
                     program event handler for the passed event but only perform
                     library related event handling.
                     must be called on any event removed from the queue with
                     plain X11 routines (no uwmlib wraparound) */

/* event handler loops */
void UDEHandleEventLoop(int (*cont()));
/* Event loop of type while(cont()){}; will return when cont() returns 0. */
void UDEHandleWaitingEvents();
/* will handle any events waiting in the queue and return when the queue is
  empty */

/* ude basic GUI feature routines and structures: */

/* all structures contain an element called handle which is a pointer to a
   private library structure describing the corresponding gui element. It is
   returned by the corresponding create-routine and needs to be set in any other
   lib calls on the corresponding gui element to identify the element. */

/* Buttons (hex and normal, also switches and radio button lists) */
/* UDEButton flags */
#define UDEButtonDown (1<<0) /* set if selected */
#define UDEButtonSelectable (1<<1) /* is button selectable or inactive? */
#define UDEButtonSwitch (1<<2) /* is button a switch or an action button? */
#define UDEButtonRadio (1<<3) /* does this button belong to a radio list? */
#define UDEButtonShaped (1<<4) /* is this button shaped? */
#define UDEButtonAutoBevelled (1<<5)      /* Shall bevels automatically be drawn
        around rectangular or hex icons (will draw biggest hex bevel possible if
                             'mask' is defined, rectangular bevel otherwise.) */
typedef struct _UDEButton {
   UDEWin *win;
   unsigned int flags;
   long x,y,width,height;
   Pixmap bmp,activebmp,mask;
   char *name; 
   UDEEventHandler PressHandler,ReleaseHandler;
        /* two handler routines that can be defined by the program and will be
           called when the button is pressed/released or NULL */
   struct _UDEButton *nextradio,*prevradio;
   void *data;     
        /* a pointer that can freely be used by the program to store private
           information related to the button. */
   /* ... */
   UDEInternalButton *handle;
 } UDEButton; 

void UDECreateButton(UDEButton *udebutton);
void UDEChangeButtonState(UDEButton *udebutton); 
void UDEDestroyButton(UDEInternalButton *handle);
UDEButton *UDEGetButtonState(UDEInternalButton *handle);
                                                    /* returns button's state */

/* Menus */

/* VERY RAW YET, just a concept, there still has to be done a lot of work on
   this. */

typedef struct _UDEMenu {
  char *name;
  int width,height;
  NodeList *items;  /* will have to include nodes.c / nodes.h into the lib
                       anyway... */
  void *data;  /* to be consequent, although i dont see much sense in it... */
  /* ... */
  UDEInternalMenu *handle;
} UDEMenu;

void UDECreateMenu(UDEMenu *udemenuitem);
void UDEChangeMenuState(UDEMenu *udemenuitem);
void UDEDestroyMenu(UDEInternalMenu *handle);
UDEMenu *UDEGetMenuState(UDEInternalMenu *handle);

#define UDEMenuItemDown (1<<0) /* set if held down or switched */
#define UDEMenuItemSelectable (1<<1) /* is item active or inactive? */
/* only one of the following can be chosen (none means UDEMenuItemStandard) */
#define UDEMenuItemStandard (0) /* normal item */
#define UDEMenuItemOnOff (1<<2) /* is menu item a switch? */
#define UDEMenuItemSubmenu (1<<3) /* will a submenu pop up? */
#define UDEMenuItemLine ((1<<4)|(1<<3)) /* is menu item a separation line? */
#define UDEMenuItemGfx ((1<<4)|(1<<3)) /* is there a user pixmap specified? */
typedef struct _UDEMenuItem {
  UDEMenu *menu;
  UDEMenu *submenu; /* pointer to a submenu or null if none should pop up */
  int width,height; /* width, height =-1 means: use names textwidth/height */
  Pixmap bmp,activebmp;
  char *name;
  char shortcut_letter;
  UDEEventHandler SelectHandler;  /* handler called when item is selected. */
  void *data;  /* user data */
  /* ... */
  UDEInternalMenuItem *handle;
} UDEMenuItem;

void UDECreateMenuItem(UDEMenuItem *udemenuitem);
void UDEChangeMenuItemState(UDEMenuItem *udemenuitem);
void UDEDestroyMenuItem(UDEInternalMenuItem *handle);
UDEMenuItem *UDEGetMenuItemState(UDEInternalMenuItem *handle);

UDEMenuItem *UDEStartMenu(UDEInternalMenu *handle,int x,int y);
/* will return a pointer to a structure describing the selected item or NULL.
   free mem of returned structure with free(); after use */

/* Dragbars */
#define UDEDragbarDown (1<<0) /* set if held down */
#define UDEDragbarSelectable (1<<1) /* is drabgar active or inactive? */
typedef struct _UDEDragbar {
   UDEWin *win;
   unsigned int flags;
   long x,y,width,height;  /* size and position of the drag field */
   float xpos,ypos,xbar,ybar;
     /* number between 0 and 1 (i.e. 0% and 100%) representing size and
        position of the bar relative to it's drag field - a size of 1 means that
        the bar cannot be moved in the corresponding direction */
   UDEEventHandler PressHandler,ReleaseHandler,DragHandler;
                                                   /* our handlers... */
   void *data;  /* a pointer to user data */
   UDEInternalDragbar *handle;
} UDEDragbar;

void UDECreateDragbar(UDEDragbar *dragbar);
void UDEChangeDragbarState(UDEDragbar *dragbar);
void UDEDestroyDragbar(UDEInternalDragbar *handle);
UDEDragbar *UDEGetDragbarState(UDEInternalDragbar *handle);
                                                   /* returns dragbar's state */
/* Listboxes (text input/output and output only, gfx output) */
#define UDEListboxSelectable (1<<1) /* active? */
#define UDEListboxNorthernDragbar (1<<2) /* northern dragbar available? */
#define UDEListboxEasternDragbar (1<<3) /* eastern dragbar available? */
#define UDEListboxSouthernDragbar (1<<4) /* eastern dragbar available? */
#define UDEListboxWesternDragbar (1<<5) /* eastern dragbar available? */

typedef struct _UDEListbox {
   UDEWin *win;
   unsigned int flags;
   Window BoxWin;      /* the window to be moved around in the bounding box */
   /* in case a window is given here all events are passed on to the defined
      handlers (ChangeEventHandler) except when the middle mouse button is
      pressed (used to drag the win around).
      However the lib is monitoring some of the events. */
   long x,y,width,height;  /* size and position of the bounding box */
   long xpos,ypos,boxwith,boxheight;
        /* size and position of the movable field, xpos, ypos are usu <=0,
	   usu boxwidth>=width; boxheight>=height */
   UDEEventHandler PressHandler,ReleaseHandler,DragHandler;
  /* our handlers... */
   void *data;  /* a pointer to user data */
   UDEInternalListbox *handle;
} UDEListbox;

void UDECreateListbox(UDEListbox *listbox);
void UDEChangeListbox(UDEListbox *listbox);
void UDEDestroyListbox(UDEInternalListbox *handle);
UDEListbox *UDEGetListboxState(UDEInternalListbox *handle);

/* Inputfields (single text input line with or w/o preselection menu); */
#define UDEInputfieldFocus (1<<0) /* kbd focus in input field or PSM active? */
#define UDEInputfieldSelectable (1<<1) /* active? */
#define UDEInputfiledPreselectionMenu (1<<2) /* preselection menu available? */

typedef struct _UDEInputfield {
   UDEWin *win;
   unsigned int flags;
   long x,y,width,height;  /* size and position of the input field, height <=0
                              means default height corresponding to font */
   UDEEventHandler TextChangeHandler,EnterHandler;
   char *ActualText,**PreselectionLines;
   void *data;
   UDEInternalInputfield *handle;
} UDEInputfield;

void UDECreateInputfield(UDEInputfield *inputfield);
void UDEChangeInputfield(UDEInputfield *inputfiled);
void UDEDestroyInputfield(UDEInputfield *inputfield);
UDEInputfield *UDEGetInputfieldState(UDEInternalInputfield *handle);

/* something that just came to my mind: do you think its easier for the program
   to keep its structures up to date (to perform changes) or shall we have a set
   of flags per structure (like Xlib has e.g. for XSetWindowAttributes) which
   tells the lib which elements of the passed structure are valid. */

/*** advanced routines ***/

/* in my opinion we could add such things as drag'n'drop items etc here.
   However e.g. Drag'n'Drop is a feature that also would affect e.g. the
   listboxes feature, so we should make a list of all the features we want
   to support here and not forget them while implementing the rest although
   they are not too urgent so we should be able to add them to later releases.
 So here's the start of the list:
  * drag'n'drop items
  * ... (add your ideas here)
   
   We could also have an extra library later, based upon libdesktop which will
   supply several kinds of oftenly used requesters, such things as toolbar
   windows etc. But of course we first must get libdesktop together. */

#endif
