#include <stddef.h>
#include <stdint.h>
#ifndef __WCHAR_ENABLED
#error __WCHAR_ENABLED not defined
#endif
#include "c8tables.h"
#include "wctables.h"
#include "lt_defines.h"
#include "locale_mmap.h"

static const __locale_mmap_t locale_mmap = {

{	/* tbl8ctype */
	0xee, 0xee, 0xee, 0xee, 0x06, 0x61, 0x66, 0x66, 
	0x66, 0x66, 0x66, 0x66, 0x66, 0x24, 0x24, 0x24, 
	0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x06, 
	   0,    0,    0,    0, 0x44, 0x26, 0x66, 0x66, 
	0x66, 0x64, 0x44, 0x44, 0x62, 0x66, 0x66, 0x66, 
	0x60, 0x62, 0x22, 0x22, 0x46, 0x42, 0x46, 0x66, 
	0x64, 0x64, 0x66, 0x46, 0x66, 0x24, 0x22, 0x66, 
	0x62, 0x62, 0x42, 0x22, 0x44, 0x44, 0x44, 0x44, 
	0x22, 0x22, 0x22, 0x22, 0x06, 0x26, 0x66, 0x66, 
	0x66, 0x60,    0,    0, 0x60, 0x66, 0x66, 0x66, 
	0x66, 0x66, 0x26, 0x66, 0x66, 0x60, 0x66, 0x66, 
	0x66, 0x66, 0x11, 0x61, 0x06,    0,    0,    0, 
	0x11, 0x11, 0x11, 0x11, 0x11, 0x01, 0x60, 0x06, 
	0xee, 0x26, 0x66, 0x66, 0x66, 0x64, 0xe4, 0xee, 
	0x6e, 0x66, 0x66, 0x66, 0x66, 0x62, 0xe2, 0x4e, 
	0x66, 0x61, 0x66, 0x66, 0x11, 0x11, 0x11, 0x22, 
	0x22, 0x22, 0x22, 0x62, 0x44, 0x44, 0x44, 0x64, 
	0x44, 0x44, 0x44, 0x24, 0x46, 0x44, 0x44, 0x64, 
	0x44, 0x44, 0x64, 0x44, 0x26, 0x22, 0x22, 0x62, 
	0x22, 0x22, 0x62, 0x22, 0x22, 0x22, 0x22, 0x12, 
	0x62, 0x62, 0x66, 0x26, 0x46, 0x62, 0x24, 0x64, 
	0x64, 0x24, 0x64, 0x46, 0x24, 0x24, 0x24, 0x46, 
	0x22, 0x42, 0x42, 0x22, 0x66, 0x66, 0x66, 0x64, 
	0x62, 0x61, 0x66, 0x66, 0x66, 0x66, 0x24, 0x66, 
	0x62, 0x61, 0x24, 0x64, 0x46, 0x42, 0x66, 0x64, 
	0x62, 0x64, 0x64, 0x42, 0x66, 0x24, 0x64, 0x66, 
	0x22, 0x62, 0x24, 0x24, 0x46, 0x46, 0x46, 0x64, 
	0x46, 0x44, 0x64, 0x44, 0x26, 0x26, 0x26, 0x62, 
	0x26, 0x22, 0x62, 0x22, 0x46, 0x66, 0x06, 0x64, 
	0x46, 0x44, 0x64, 0x40, 0x26, 0x66, 0x26, 0x62, 
	0x26, 0x22, 0x62, 0x20, 0x44, 0x04, 0x44, 0x44, 
	0x40, 0x44, 0x44, 0x64, 0x22, 0x02, 0x22, 0x22, 
	0x20, 0x22, 0x22, 0x62, 0x46, 0x41, 0x46, 0x64, 
	0x46, 0x44, 0x64, 0x64, 0x26, 0x22, 0x42, 0x22, 
	0x46, 0x44, 0x44, 0x44, 0x26, 0x22, 0x22, 0x22, 
	0x06,    0, 0x06,    0,    0,    0, 0x66,    0, 
	   0, 0x60,    0, 0x60, 0x10, 0x11, 0x11, 0x11, 
	0x11, 0x01,    0,    0, 0x11, 0x61, 0x66, 0x66, 
	0x66, 0x06,    0,    0, 0x66, 0x66,    0, 0x66, 
	0x66, 0x60, 0x66, 0x60, 0x44, 0x64, 0x64, 0x44, 
	0x41, 0x44, 0x44, 0x44, 0x44, 0x40, 0x44, 0x44, 
	0x44, 0x44, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 
	0x22, 0x22, 0x22, 0x02, 0x06, 0x66, 0x66, 0x66, 
	0x66, 0x66, 0x66, 0x06,    0,    0,    0, 0x60, 
	0x66, 0x26, 0x66, 0x66, 0x66, 0x46, 0x66, 0x66, 
	0x22, 0x46, 0x66, 0x66, 0x60, 0x62, 0x24, 0x04, 
	0x64, 0x66, 0x66, 0x66, 0x60, 0x60,    0,    0, 
	0x20, 0x24, 0x26, 0x66,    0, 0x60, 0x66, 0x06, 
	0x66, 0x46, 0x40, 0x66, 0x60, 0x60,    0, 0x60, 
	0x66, 0x26, 0x62, 0x22, 0x66, 0x46, 0x64, 0x44, 
	0x66, 0x66, 0x46, 0x66, 0x11, 0x11, 0x11, 0x61, 
	0x11, 0x01,    0, 0x60, 0x11, 0x11, 0x11, 0x16, 
	0x11, 0x66,    0,    0, 
},
{	/* tbl8uplow */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x7b, 0x7d,    0,    0, 
	   0, 0x7b,    0, 0x7f, 0x7f,    0,    0,    0, 
	   0,    0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff,    0,    0, 
	0xf0, 0xfe,    0, 0xfe,    0,    0,    0,    0, 
	   0,    0, 0xf0,    0, 0xf0, 0xf0, 0xf0, 0xf0, 
	0xf0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xff, 0xff, 0xe7,    0, 0xf1,    0,    0, 
	0xf0,    0, 0xf0,    0,    0,    0,    0, 0xf0, 
	   0,    0, 0xff, 0xff, 0xf1,    0,    0,    0, 
	0xf0,    0, 0xf0,    0, 0xe7, 0xff, 0xff, 0xf0, 
	0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 
	   0,    0, 0xf0,    0, 0xf0,    0,    0,    0, 
	   0,    0, 0xf0,    0, 0xf0,    0,    0, 0xa0, 
	   0,    0,    0,    0,    0,    0,    0, 0xa0, 
	0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,    0, 
	   0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,    0, 
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0,    0, 0xf0, 0xf0, 
	   0, 0xff, 0xff,    0, 0xff, 0xff, 0xfb,    0, 
	0xf0,    0, 0xf0, 0xfb, 0xf0,    0,    0, 0xb0, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff,    0, 0xfe, 
	0xf0, 0xfe, 0xf0, 0xfc, 0xf0, 0xff, 0xff, 0xfc, 
	0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xb0, 
	   0,    0,    0,    0,    0,    0, 0xfe,    0, 
	0xfe,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0xfc,    0,    0,    0, 
	0xfc,    0,    0,    0, 0xff, 0xff, 0xbf,    0, 
	0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xbf, 
	   0, 0xff, 0xff, 0xf0,    0,    0, 0xfe,    0, 
	0xfe,    0, 0xf0,    0, 0xfe,    0, 0xfe, 0xf0, 
	   0,    0, 0xf9, 0xf0, 0xfc,    0,    0,    0, 
	0xfc, 0xf9, 0xf0,    0, 0xff, 0xff, 0xbf, 0xf0, 
	   0, 0xf0,    0, 0xf0,    0, 0xf0, 0xf0,    0, 
	   0, 0xf0, 0xf0, 0xf0, 0xf0,    0, 0xf0, 0xf0, 
	   0, 0xf0,    0,    0,    0,    0, 0xf0,    0, 
	   0, 0x40, 0xf0, 0xf0, 0xf0,    0,    0, 0xf0, 
	   0, 0x90, 0xf0, 0xf0, 0xf0,    0,    0, 0xf0, 
	0xe0, 0xe0, 0xe0,    0, 0xe0, 0xe0, 0xe0, 0xe0, 
	   0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,    0, 
	   0, 0xf0, 0xf0, 0xf0, 0xf0,    0, 0xf0,    0, 
	   0, 0xf0, 0xf0, 0xf0, 0xf0, 0xfe, 0xf0, 0xfe, 
	   0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 
	0xb0, 0xb0, 0xb0, 0xb0, 0xb0,    0, 0xb0, 0xb0, 
	   0,    0,    0,    0,    0,    0, 0xda,    0, 
	0xdb, 0xdb, 0xdb,    0, 0xc0,    0, 0xc1, 0xc1, 
	   0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 
	0xe0, 0xe0,    0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 
	0xe0, 0xe0, 0xe0, 0xe0, 0xda, 0xdb, 0xdb, 0xdb, 
	0xe0, 0xe0, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 
	0xe0, 0xe0, 0xe0, 0xe0, 0xc0, 0xc1, 0xc1,    0, 
	0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x74, 0xe0,    0, 
	0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x4c, 0xe0,    0, 
	   0,    0,    0, 0x10,    0,    0,    0,    0, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
	0x10, 0x02,    0, 0x02,    0,    0,    0,    0, 
	   0,    0, 0x02,    0, 0x02, 0x01, 0x01,    0, 
	0x10,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0x01, 0x01, 0x10,    0, 0x10,    0,    0, 
	   0,    0,    0, 0x10,    0, 0x10,    0,    0, 
	   0,    0,    0, 0x10, 0x10,    0, 0x10, 0x10, 
	   0,    0,    0,    0,    0, 0x10,    0,    0, 
},
{	/* tbl8c2wc */
	0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 
	0x0088, 0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008e, 0x008f, 
	0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 
	0x0098, 0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f, 
	0x00a0,      0, 0x0587, 0x0589, 0x0029, 0x0028, 0x00bb, 0x00ab, 
	0x2014, 0x002e, 0x055d, 0x002c, 0x002d, 0x058a, 0x2026, 0x055c, 
	0x055b, 0x055e, 0x0531, 0x0561, 0x0532, 0x0562, 0x0533, 0x0563, 
	0x0534, 0x0564, 0x0535, 0x0565, 0x0536, 0x0566, 0x0537, 0x0567, 
	0x0538, 0x0568, 0x0539, 0x0569, 0x053a, 0x056a, 0x053b, 0x056b, 
	0x053c, 0x056c, 0x053d, 0x056d, 0x053e, 0x056e, 0x053f, 0x056f, 
	0x0540, 0x0570, 0x0541, 0x0571, 0x0542, 0x0572, 0x0543, 0x0573, 
	0x0544, 0x0574, 0x0545, 0x0575, 0x0546, 0x0576, 0x0547, 0x0577, 
	0x0548, 0x0578, 0x0549, 0x0579, 0x054a, 0x057a, 0x054b, 0x057b, 
	0x054c, 0x057c, 0x054d, 0x057d, 0x054e, 0x057e, 0x054f, 0x057f, 
	0x0550, 0x0580, 0x0551, 0x0581, 0x0552, 0x0582, 0x0553, 0x0583, 
	0x0554, 0x0584, 0x0555, 0x0585, 0x0556, 0x0586, 0x055a,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0402, 0x0403, 0x201a, 0x0453, 0x201e, 0x2026, 0x2020, 0x2021, 
	0x20ac, 0x2030, 0x0409, 0x2039, 0x040a, 0x040c, 0x040b, 0x040f, 
	0x0452, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	     0, 0x2122, 0x0459, 0x203a, 0x045a, 0x045c, 0x045b, 0x045f, 
	0x00a0, 0x040e, 0x045e, 0x0408, 0x00a4, 0x0490, 0x00a6, 0x00a7, 
	0x0401, 0x00a9, 0x0404, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x0407, 
	0x00b0, 0x00b1, 0x0406, 0x0456, 0x0491, 0x00b5, 0x00b6, 0x00b7, 
	0x0451, 0x2116, 0x0454, 0x00bb, 0x0458, 0x0405, 0x0455, 0x0457, 
	0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417, 
	0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f, 
	0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 
	0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f, 
	0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 
	0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f, 
	0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 
	0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f, 
	0x20ac,      0, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, 
	0x02c6, 0x2030,      0, 0x2039,      0,      0,      0,      0, 
	     0, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	0x02dc, 0x2122,      0, 0x203a,      0,      0,      0,      0, 
	0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x20aa, 0x00a5, 0x00a6, 0x00a7, 
	0x00a8, 0x00a9, 0x00d7, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 
	0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 
	0x00b8, 0x00b9, 0x00f7, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 
	0x05b0, 0x05b1, 0x05b2, 0x05b3, 0x05b4, 0x05b5, 0x05b6, 0x05b7, 
	0x05b8, 0x05b9,      0, 0x05bb, 0x05bc, 0x05bd, 0x05be, 0x05bf, 
	0x05c0, 0x05c1, 0x05c2, 0x05c3, 0x05f0, 0x05f1, 0x05f2, 0x05f3, 
	0x05f4,      0,      0,      0,      0,      0,      0,      0, 
	0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7, 
	0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df, 
	0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7, 
	0x05e8, 0x05e9, 0x05ea,      0,      0, 0x200e, 0x200f,      0, 
	0x0080, 0x0081, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, 
	0x02c6, 0x2030, 0x0160, 0x2039, 0x0152, 0x008d, 0x008e, 0x008f, 
	0x0090, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	0x02dc, 0x2122, 0x0161, 0x203a, 0x0153, 0x009d, 0x009e, 0x0178, 
	0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 
	0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 
	0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 
	0x10d0, 0x10d1, 0x10d2, 0x10d3, 0x10d4, 0x10d5, 0x10d6, 0x10f1, 
	0x10d7, 0x10d8, 0x10d9, 0x10da, 0x10db, 0x10dc, 0x10f2, 0x10dd, 
	0x10de, 0x10df, 0x10e0, 0x10e1, 0x10e2, 0x10f3, 0x10e3, 0x10e4, 
	0x10e5, 0x10e6, 0x10e7, 0x10e8, 0x10e9, 0x10ea, 0x10eb, 0x10ec, 
	0x10ed, 0x10ee, 0x10f4, 0x10ef, 0x10f0, 0x10f5, 0x00e6, 0x00e7, 
	0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef, 
	0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 
	0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff, 
	0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 
	0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 
	0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 
	0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df, 
	0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7, 
	0x00a0, 0x0104, 0x0112, 0x0122, 0x012a, 0x0128, 0x0136, 0x00a7, 
	0x013b, 0x0110, 0x0160, 0x0166, 0x017d, 0x00ad, 0x016a, 0x014a, 
	0x00b0, 0x0105, 0x0113, 0x0123, 0x012b, 0x0129, 0x0137, 0x00b7, 
	0x013c, 0x0111, 0x0161, 0x0167, 0x017e, 0x2015, 0x016b, 0x014b, 
	0x0100, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x012e, 
	0x010c, 0x00c9, 0x0118, 0x00cb, 0x0116, 0x00cd, 0x00ce, 0x00cf, 
	0x00d0, 0x0145, 0x014c, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x0168, 
	0x00d8, 0x0172, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df, 
	0x0101, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x012f, 
	0x010d, 0x00e9, 0x0119, 0x00eb, 0x0117, 0x00ed, 0x00ee, 0x00ef, 
	0x00f0, 0x0146, 0x014d, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x0169, 
	0x00f8, 0x0173, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x0138, 
	0x00a0, 0x201d, 0x00a2, 0x00a3, 0x00a4, 0x201e, 0x00a6, 0x00a7, 
	0x00d8, 0x00a9, 0x0156, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00c6, 
	0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x201c, 0x00b5, 0x00b6, 0x00b7, 
	0x00f8, 0x00b9, 0x0157, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00e6, 
	0x0104, 0x012e, 0x0100, 0x0106, 0x00c4, 0x00c5, 0x0118, 0x0112, 
	0x010c, 0x00c9, 0x0179, 0x0116, 0x0122, 0x0136, 0x012a, 0x013b, 
	0x0160, 0x0143, 0x0145, 0x00d3, 0x014c, 0x00d5, 0x00d6, 0x00d7, 
	0x0172, 0x0141, 0x015a, 0x016a, 0x00dc, 0x017b, 0x017d, 0x00df, 
	0x0105, 0x012f, 0x0101, 0x0107, 0x00e4, 0x00e5, 0x0119, 0x0113, 
	0x010d, 0x00e9, 0x017a, 0x0117, 0x0123, 0x0137, 0x012b, 0x013c, 
	0x0161, 0x0144, 0x0146, 0x00f3, 0x014d, 0x00f5, 0x00f6, 0x00f7, 
	0x0173, 0x0142, 0x015b, 0x016b, 0x00fc, 0x017c, 0x017e, 0x2019, 
	0x00a0, 0x1e02, 0x1e03, 0x00a3, 0x010a, 0x010b, 0x1e0a, 0x00a7, 
	0x1e80, 0x00a9, 0x1e82, 0x1e0b, 0x1ef2, 0x00ad, 0x00ae, 0x0178, 
	0x1e1e, 0x1e1f, 0x0120, 0x0121, 0x1e40, 0x1e41, 0x00b6, 0x1e56, 
	0x1e81, 0x1e57, 0x1e83, 0x1e60, 0x1ef3, 0x1e84, 0x1e85, 0x1e61, 
	0x0174, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x1e6a, 
	0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x0176, 0x00df, 
	0x0175, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x1e6b, 
	0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x0177, 0x00ff, 
	0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x20ac, 0x00a5, 0x0160, 0x00a7, 
	0x0161, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 
	0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x017d, 0x00b5, 0x00b6, 0x00b7, 
	0x017e, 0x00b9, 0x00ba, 0x00bb, 0x0152, 0x0153, 0x0178, 0x00bf, 
	0x00a0, 0x0104, 0x0105, 0x0141, 0x20ac, 0x00ab, 0x0160, 0x00a7, 
	0x0161, 0x00a9, 0x0218, 0x201e, 0x0179, 0x00ad, 0x017a, 0x017b, 
	0x00b0, 0x00b1, 0x010c, 0x0142, 0x017d, 0x201d, 0x00b6, 0x00b7, 
	0x017e, 0x010d, 0x0219, 0x00bb, 0x0152, 0x0153, 0x0178, 0x017c, 
	0x00c0, 0x00c1, 0x00c2, 0x0102, 0x00c4, 0x0106, 0x00c6, 0x00c7, 
	0x0110, 0x0143, 0x00d2, 0x00d3, 0x00d4, 0x0150, 0x00d6, 0x015a, 
	0x0170, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x0118, 0x021a, 0x00df, 
	0x00e0, 0x00e1, 0x00e2, 0x0103, 0x00e4, 0x0107, 0x00e6, 0x00e7, 
	0x0111, 0x0144, 0x00f2, 0x00f3, 0x00f4, 0x0151, 0x00f6, 0x015b, 
	0x0171, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x0119, 0x021b, 0x00ff, 
	0x00a0, 0x0104, 0x02d8, 0x0141, 0x00a4, 0x013d, 0x015a, 0x00a7, 
	0x00a8, 0x0160, 0x015e, 0x0164, 0x0179, 0x00ad, 0x017d, 0x017b, 
	0x00b0, 0x0105, 0x02db, 0x0142, 0x00b4, 0x013e, 0x015b, 0x02c7, 
	0x00b8, 0x0161, 0x015f, 0x0165, 0x017a, 0x02dd, 0x017e, 0x017c, 
	0x0154, 0x00c1, 0x00c2, 0x0102, 0x00c4, 0x0139, 0x0106, 0x00c7, 
	0x010c, 0x00c9, 0x0118, 0x00cb, 0x011a, 0x00cd, 0x00ce, 0x010e, 
	0x0110, 0x0143, 0x0147, 0x00d3, 0x00d4, 0x0150, 0x00d6, 0x00d7, 
	0x0158, 0x016e, 0x00da, 0x0170, 0x00dc, 0x00dd, 0x0162, 0x00df, 
	0x0155, 0x00e1, 0x00e2, 0x0103, 0x00e4, 0x013a, 0x0107, 0x00e7, 
	0x010d, 0x00e9, 0x0119, 0x00eb, 0x011b, 0x00ed, 0x00ee, 0x010f, 
	0x0111, 0x0144, 0x0148, 0x00f3, 0x00f4, 0x0151, 0x00f6, 0x00f7, 
	0x0159, 0x016f, 0x00fa, 0x0171, 0x00fc, 0x00fd, 0x0163, 0x02d9, 
	0x00a0, 0x0126, 0x02d8, 0x00a3, 0x00a4,      0, 0x0124, 0x00a7, 
	0x00a8, 0x0130, 0x015e, 0x011e, 0x0134, 0x00ad,      0, 0x017b, 
	0x00b0, 0x0127, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x0125, 0x00b7, 
	0x00b8, 0x0131, 0x015f, 0x011f, 0x0135, 0x00bd,      0, 0x017c, 
	0x00c0, 0x00c1, 0x00c2,      0, 0x00c4, 0x010a, 0x0108, 0x00c7, 
	     0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x0120, 0x00d6, 0x00d7, 
	0x011c, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x016c, 0x015c, 0x00df, 
	0x00e0, 0x00e1, 0x00e2,      0, 0x00e4, 0x010b, 0x0109, 0x00e7, 
	     0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x0121, 0x00f6, 0x00f7, 
	0x011d, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x016d, 0x015d, 0x02d9, 
	0x00a0, 0x0104, 0x0138, 0x0156, 0x00a4, 0x0128, 0x013b, 0x00a7, 
	0x00a8, 0x0160, 0x0112, 0x0122, 0x0166, 0x00ad, 0x017d, 0x00af, 
	0x00b0, 0x0105, 0x02db, 0x0157, 0x00b4, 0x0129, 0x013c, 0x02c7, 
	0x00b8, 0x0161, 0x0113, 0x0123, 0x0167, 0x014a, 0x017e, 0x014b, 
	0x010c, 0x00c9, 0x0118, 0x00cb, 0x0116, 0x00cd, 0x00ce, 0x012a, 
	0x0110, 0x0145, 0x014c, 0x0136, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 
	0x00d8, 0x0172, 0x00da, 0x00db, 0x00dc, 0x0168, 0x016a, 0x00df, 
	0x010d, 0x00e9, 0x0119, 0x00eb, 0x0117, 0x00ed, 0x00ee, 0x012b, 
	0x0111, 0x0146, 0x014d, 0x0137, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 
	0x00f8, 0x0173, 0x00fa, 0x00fb, 0x00fc, 0x0169, 0x016b, 0x02d9, 
	0x00a0, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407, 
	0x0408, 0x0409, 0x040a, 0x040b, 0x040c, 0x00ad, 0x040e, 0x040f, 
	0x2116, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 
	0x0458, 0x0459, 0x045a, 0x045b, 0x045c, 0x00a7, 0x045e, 0x045f, 
	0x00a0,      0,      0,      0, 0x00a4,      0,      0,      0, 
	     0,      0,      0,      0, 0x060c, 0x00ad,      0,      0, 
	     0,      0,      0, 0x061b,      0,      0,      0, 0x061f, 
	     0, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627, 
	0x0628, 0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f, 
	0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 
	0x0638, 0x0639, 0x063a,      0,      0,      0,      0,      0, 
	0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647, 
	0x0648, 0x0649, 0x064a, 0x064b, 0x064c, 0x064d, 0x064e, 0x064f, 
	0x0650, 0x0651, 0x0652,      0,      0,      0,      0,      0, 
	0x00a0, 0x2018, 0x2019, 0x00a3,      0,      0, 0x00a6, 0x00a7, 
	0x00a8, 0x00a9,      0, 0x00ab, 0x00ac, 0x00ad,      0, 0x2015, 
	0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x0384, 0x0385, 0x0386, 0x00b7, 
	0x0388, 0x0389, 0x038a, 0x00bb, 0x038c, 0x00bd, 0x038e, 0x038f, 
	0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 
	0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 
	0x03a0, 0x03a1,      0, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 
	0x03a8, 0x03a9, 0x03aa, 0x03ab, 0x03ac, 0x03ad, 0x03ae, 0x03af, 
	0x03b0, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 
	0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 
	0x03c0, 0x03c1, 0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 
	0x03c8, 0x03c9, 0x03ca, 0x03cb, 0x03cc, 0x03cd, 0x03ce,      0, 
	0x00a0,      0, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 
	0x00b8, 0x00b9, 0x00f7, 0x00bb, 0x00bc, 0x00bd, 0x00be,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x2017, 
	0x011e, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 
	0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x0130, 0x015e, 0x00df, 
	0x011f, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 
	0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x0131, 0x015f, 0x00ff, 
	0x2500, 0x2502, 0x250c, 0x2510, 0x2514, 0x2518, 0x251c, 0x2524, 
	0x252c, 0x2534, 0x253c, 0x2580, 0x2584, 0x2588, 0x258c, 0x2590, 
	0x2591, 0x2592, 0x2593, 0x2320, 0x25a0, 0x2219, 0x221a, 0x2248, 
	0x2264, 0x2265, 0x00a0, 0x2321, 0x00b0, 0x00b2, 0x00b7, 0x00f7, 
	0x2550, 0x2551, 0x2552, 0x0451, 0x2553, 0x2554, 0x2555, 0x2556, 
	0x2557, 0x2558, 0x2559, 0x255a, 0x255b, 0x255c, 0x255d, 0x255e, 
	0x255f, 0x2560, 0x2561, 0x0401, 0x2562, 0x2563, 0x2564, 0x2565, 
	0x2566, 0x2567, 0x2568, 0x2569, 0x256a, 0x256b, 0x256c, 0x00a9, 
	0x044e, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, 
	0x0445, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 
	0x043f, 0x044f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432, 
	0x044c, 0x044b, 0x0437, 0x0448, 0x044d, 0x0449, 0x0447, 0x044a, 
	0x042e, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, 
	0x0425, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 
	0x041f, 0x042f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412, 
	0x042c, 0x042b, 0x0417, 0x0428, 0x042d, 0x0429, 0x0427, 0x042a, 
	0x049b, 0x0493, 0x201a, 0x0492, 0x201e, 0x2026, 0x2020, 0x2021, 
	     0, 0x2030, 0x04b3, 0x2039, 0x04b2, 0x04b7, 0x04b6,      0, 
	0x049a, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	     0, 0x2122,      0, 0x203a,      0,      0,      0,      0, 
	     0, 0x04ef, 0x04ee, 0x0451, 0x00a4, 0x04e3, 0x00a6, 0x00a7, 
	     0,      0,      0, 0x00ab, 0x00ac, 0x00ad, 0x00ae,      0, 
	0x00b0, 0x00b1, 0x00b2, 0x0401,      0, 0x04e2, 0x00b6, 0x00b7, 
	     0, 0x2116,      0, 0x00bb,      0,      0,      0, 0x00a9, 
	0x2550, 0x2551, 0x2552, 0x0451, 0x0454, 0x2554, 0x0456, 0x0457, 
	0x2557, 0x2558, 0x2559, 0x255a, 0x255b, 0x0491, 0x255d, 0x255e, 
	0x255f, 0x2560, 0x2561, 0x0401, 0x0404, 0x2563, 0x0406, 0x0407, 
	0x2566, 0x2567, 0x2568, 0x2569, 0x256a, 0x0490, 0x256c, 0x00a9, 
	     0, 0x0e01, 0x0e02, 0x0e03, 0x0e04, 0x0e05, 0x0e06, 0x0e07, 
	0x0e08, 0x0e09, 0x0e0a, 0x0e0b, 0x0e0c, 0x0e0d, 0x0e0e, 0x0e0f, 
	0x0e10, 0x0e11, 0x0e12, 0x0e13, 0x0e14, 0x0e15, 0x0e16, 0x0e17, 
	0x0e18, 0x0e19, 0x0e1a, 0x0e1b, 0x0e1c, 0x0e1d, 0x0e1e, 0x0e1f, 
	0x0e20, 0x0e21, 0x0e22, 0x0e23, 0x0e24, 0x0e25, 0x0e26, 0x0e27, 
	0x0e28, 0x0e29, 0x0e2a, 0x0e2b, 0x0e2c, 0x0e2d, 0x0e2e, 0x0e2f, 
	0x0e30, 0x0e31, 0x0e32, 0x0e33, 0x0e34, 0x0e35, 0x0e36, 0x0e37, 
	0x0e38, 0x0e39, 0x0e3a,      0,      0,      0,      0, 0x0e3f, 
	0x0e40, 0x0e41, 0x0e42, 0x0e43, 0x0e44, 0x0e45, 0x0e46, 0x0e47, 
	0x0e48, 0x0e49, 0x0e4a, 0x0e4b, 0x0e4c, 0x0e4d, 0x0e4e, 0x0e4f, 
	0x0e50, 0x0e51, 0x0e52, 0x0e53, 0x0e54, 0x0e55, 0x0e56, 0x0e57, 
	0x0e58, 0x0e59, 0x0e5a, 0x0e5b,      0,      0,      0,      0, 
},
{	/* tbl8wc2c */
	   0,    0, 0x01,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x04, 0x05,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 0x06, 0x07, 0x08, 0x09, 0x0a, 
	0x0b,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0x0c, 0x0d,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0x0e, 0x0f,    0,    0,    0,    0, 
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15,    0,    0, 
	   0, 0x16,    0,    0,    0,    0,    0,    0, 
	   0, 0x17, 0x18, 0x19,    0,    0,    0,    0, 
	   0,    0, 0x1a,    0,    0,    0,    0,    0, 
	   0, 0x1b, 0x1c,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0x1d, 0x1e,    0, 0x1f,    0, 0x20, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0x21,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x22, 0x23,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 0x24, 0x25, 0x13, 0x26, 0x27, 
	0x28, 0x17, 0x18, 0x19,    0,    0,    0,    0, 
	   0,    0, 0x29,    0,    0,    0,    0,    0, 
	   0,    0, 0x1c,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x2a, 0x2b, 0x2c, 0x2d,    0,    0, 0x2e, 0x14, 
	   0,    0,    0,    0,    0, 0x2f, 0x30, 0x31, 
	   0, 0x21,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0x32, 0x33, 0x34, 
	   0, 0x17, 0x18, 0x19,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x2c, 0x2d, 0x11, 0x12, 0x13, 0x14, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 
	0x3b, 0x3c, 0x3d, 0x3e, 0x3f,    0, 0x40, 0x41, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0x42,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 
	0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0x51,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x52, 0x53, 0x11, 0x54, 0x13, 0x55, 
	0x56,    0, 0x57,    0,    0,    0,    0, 0x58, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x59, 0x5a,    0,    0, 0x5b, 0x5c, 0x5d,    0, 
	0x5e,    0,    0,    0,    0,    0,    0, 0x5f, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x60, 0x61, 0x11, 0x12, 0x13, 0x14, 
	   0,    0,    0,    0,    0, 0x62, 0x63, 0x64, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0x65,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 
	0x6c, 0x6d,    0,    0, 0x6e, 0x6f, 0x63, 0x70, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0x71,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0x72,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0x65,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 
	0x79, 0x7a,    0, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x80, 0x81,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 
	0x88, 0x89, 0x8a, 0x8b,    0, 0x8c, 0x8d, 0x8e, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0x8f,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x90, 0x74, 0x91, 0x92, 0x93, 0x94, 
	0x3b, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x80, 0x9c,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x9d,    0,    0,    0,    0,    0, 
	0x9e, 0x2d, 0x11, 0x12, 0x13, 0x9f,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xa0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0xa1,    0,    0,    0,    0,    0, 
	0xa2, 0xa3, 0xa4, 0xa5, 0x13, 0xa6,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0xa7, 0xa8,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa9, 0x11, 0xaa, 0x13, 0xab,    0,    0,    0, 
	   0, 0xac,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0xad, 0xae,    0, 0x1f,    0, 0x20, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0x13, 0x26,    0, 
	0x28, 0xaf,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x02, 0x03, 0x2c, 0x2d, 0x11, 0xb0, 0x13, 0xb1, 
	   0, 0xb2,    0, 0xb3,    0, 0xb4,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xb5, 0xb6,    0,    0,    0, 0xb7, 
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xbe,    0,    0, 0xbf,    0, 0xc0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xc1,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xc2, 0xc3, 0xc4, 0xc5,    0, 0xc6, 0xc7,    0, 
	0xc8, 0xc9, 0xca,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xcb, 0xcc,    0,    0,    0,    0, 
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd,    0,    0, 
	   0, 0xcd,    0, 0xce,    0,    0, 0xcf,    0, 
	0xd0, 0xb9, 0xba, 0xbb, 0xbc, 0xd1,    0,    0, 
	   0, 0xd2,    0,    0,    0,    0,    0,    0, 
	0xc2, 0xc3, 0xc4, 0xc5,    0, 0xd3, 0xd4,    0, 
	0xc8, 0xc9, 0xca,    0,    0,    0,    0,    0, 
	0xd5, 0x2d, 0x11, 0xd6, 0x13, 0xd7,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa5, 0xa4,    0,    0, 0xab, 0xac, 0xa9,    0, 
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f, 
	0xa0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 0xa7,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 0xa6,    0,    0,    0,    0, 
	   0, 0xb2, 0xb4, 0xb6, 0xb8, 0xba, 0xbc, 0xbe, 
	0xc0, 0xc2, 0xc4, 0xc6, 0xc8, 0xca, 0xcc, 0xce, 
	0xd0, 0xd2, 0xd4, 0xd6, 0xd8, 0xda, 0xdc, 0xde, 
	0xe0, 0xe2, 0xe4, 0xe6, 0xe8, 0xea, 0xec, 0xee, 
	0xf0, 0xf2, 0xf4, 0xf6, 0xf8, 0xfa, 0xfc,    0, 
	   0,    0, 0xfe, 0xb0, 0xaf, 0xaa, 0xb1,    0, 
	   0, 0xb3, 0xb5, 0xb7, 0xb9, 0xbb, 0xbd, 0xbf, 
	0xc1, 0xc3, 0xc5, 0xc7, 0xc9, 0xcb, 0xcd, 0xcf, 
	0xd1, 0xd3, 0xd5, 0xd7, 0xd9, 0xdb, 0xdd, 0xdf, 
	0xe1, 0xe3, 0xe5, 0xe7, 0xe9, 0xeb, 0xed, 0xef, 
	0xf1, 0xf3, 0xf5, 0xf7, 0xf9, 0xfb, 0xfd, 0xa2, 
	   0, 0xa3, 0xad,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0xa8,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xae,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa0,    0,    0,    0, 0xa4,    0, 0xa6, 0xa7, 
	   0, 0xa9,    0, 0xab, 0xac, 0xad, 0xae,    0, 
	0xb0, 0xb1,    0,    0,    0, 0xb5, 0xb6, 0xb7, 
	   0,    0,    0, 0xbb,    0,    0,    0,    0, 
	   0, 0xa8, 0x80, 0x81, 0xaa, 0xbd, 0xb2, 0xaf, 
	0xa3, 0x8a, 0x8c, 0x8e, 0x8d,    0, 0xa1, 0x8f, 
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff, 
	   0, 0xb8, 0x90, 0x83, 0xba, 0xbe, 0xb3, 0xbf, 
	0xbc, 0x9a, 0x9c, 0x9e, 0x9d,    0, 0xa2, 0x9f, 
	0xa5, 0xb4,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 0x96, 0x97,    0,    0,    0, 
	0x91, 0x92, 0x82,    0, 0x93, 0x94, 0x84,    0, 
	0x86, 0x87, 0x95,    0,    0,    0, 0x85,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x89,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0x8b, 0x9b,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x88,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xb9,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0x99,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa0, 0xa1, 0xa2, 0xa3,    0, 0xa5, 0xa6, 0xa7, 
	0xa8, 0xa9,    0, 0xab, 0xac, 0xad, 0xae, 0xaf, 
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 
	0xb8, 0xb9,    0, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf, 
	   0,    0,    0,    0,    0,    0,    0, 0xaa, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0, 0xba, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0x83,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0x88,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x98,    0,    0,    0, 
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 
	0xc8, 0xc9,    0, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 
	0xd0, 0xd1, 0xd2, 0xd3,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 
	0xf8, 0xf9, 0xfa,    0,    0,    0,    0,    0, 
	0xd4, 0xd5, 0xd6, 0xd7, 0xd8,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xfd, 0xfe, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xa4,    0, 0x80,    0,    0,    0, 
	0x80, 0x81,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0x8d, 0x8e, 0x8f, 
	0x90,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0x9d, 0x9e,    0, 
	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf, 
	   0,    0,    0,    0,    0,    0, 0xe6, 0xe7, 
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 
	   0,    0, 0x8c, 0x9c,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x8a, 0x9a,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x9f,    0,    0,    0,    0,    0,    0,    0, 
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc8, 
	0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xcf, 0xd0, 0xd1, 
	0xd2, 0xd3, 0xd4, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 
	0xdb, 0xdc, 0xdd, 0xde, 0xdf, 0xe0, 0xe1, 0xe3, 
	0xe4, 0xc7, 0xce, 0xd5, 0xe2, 0xe5,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa0,    0,    0,    0,    0,    0,    0, 0xa7, 
	   0,    0,    0,    0,    0, 0xad,    0,    0, 
	0xb0,    0,    0,    0,    0,    0,    0, 0xb7, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6,    0, 
	   0, 0xc9,    0, 0xcb,    0, 0xcd, 0xce, 0xcf, 
	0xd0,    0,    0, 0xd3, 0xd4, 0xd5, 0xd6,    0, 
	0xd8,    0, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 
	   0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6,    0, 
	   0, 0xe9,    0, 0xeb,    0, 0xed, 0xee, 0xef, 
	0xf0,    0,    0, 0xf3, 0xf4, 0xf5, 0xf6,    0, 
	0xf8,    0, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe,    0, 
	0xc0, 0xe0,    0,    0, 0xa1, 0xb1,    0,    0, 
	   0,    0,    0,    0, 0xc8, 0xe8,    0,    0, 
	0xa9, 0xb9, 0xa2, 0xb2,    0,    0, 0xcc, 0xec, 
	0xca, 0xea,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xa3, 0xb3,    0,    0,    0,    0, 
	0xa5, 0xb5, 0xa4, 0xb4,    0,    0, 0xc7, 0xe7, 
	   0,    0,    0,    0,    0,    0, 0xa6, 0xb6, 
	0xff,    0,    0, 0xa8, 0xb8,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0xd1, 0xf1,    0, 
	   0,    0, 0xaf, 0xbf, 0xd2, 0xf2,    0,    0, 
	0xaa, 0xba,    0,    0,    0,    0, 0xab, 0xbb, 
	0xd7, 0xf7, 0xae, 0xbe,    0,    0,    0,    0, 
	   0,    0, 0xd9, 0xf9,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0xac, 0xbc,    0, 
	   0,    0,    0,    0,    0, 0xbd,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa0,    0, 0xa2, 0xa3, 0xa4,    0, 0xa6, 0xa7, 
	   0, 0xa9,    0, 0xab, 0xac, 0xad, 0xae,    0, 
	0xb0, 0xb1, 0xb2, 0xb3,    0, 0xb5, 0xb6, 0xb7, 
	   0, 0xb9,    0, 0xbb, 0xbc, 0xbd, 0xbe,    0, 
	   0,    0,    0,    0, 0xc4, 0xc5, 0xaf,    0, 
	   0, 0xc9,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 0xd3,    0, 0xd5, 0xd6, 0xd7, 
	0xa8,    0,    0,    0, 0xdc,    0,    0, 0xdf, 
	   0,    0,    0,    0, 0xe4, 0xe5, 0xbf,    0, 
	   0, 0xe9,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 0xf3,    0, 0xf5, 0xf6, 0xf7, 
	0xb8,    0,    0,    0, 0xfc,    0,    0,    0, 
	0xc2, 0xe2,    0,    0, 0xc0, 0xe0, 0xc3, 0xe3, 
	   0,    0,    0,    0, 0xc8, 0xe8,    0,    0, 
	   0,    0, 0xc7, 0xe7,    0,    0, 0xcb, 0xeb, 
	0xc6, 0xe6,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xcc, 0xec,    0,    0,    0,    0, 
	   0,    0, 0xce, 0xee,    0,    0, 0xc1, 0xe1, 
	   0,    0,    0,    0,    0,    0, 0xcd, 0xed, 
	   0,    0,    0, 0xcf, 0xef,    0,    0,    0, 
	   0, 0xd9, 0xf9, 0xd1, 0xf1, 0xd2, 0xf2,    0, 
	   0,    0,    0,    0, 0xd4, 0xf4,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xaa, 0xba, 
	   0,    0, 0xda, 0xfa,    0,    0,    0,    0, 
	0xd0, 0xf0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xdb, 0xfb,    0,    0,    0,    0, 
	   0,    0, 0xd8, 0xf8,    0,    0,    0,    0, 
	   0, 0xca, 0xea, 0xdd, 0xfd, 0xde, 0xfe,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xff,    0,    0, 0xb4, 0xa1, 0xa5,    0, 
	0xa0,    0,    0, 0xa3,    0,    0,    0, 0xa7, 
	   0, 0xa9,    0,    0,    0, 0xad, 0xae,    0, 
	   0,    0,    0,    0,    0,    0, 0xb6,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6,    0, 
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd,    0, 0xdf, 
	   0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6,    0, 
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd,    0, 0xff, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xa4, 0xa5,    0,    0,    0,    0, 
	0xb2, 0xb3,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0xd0, 0xf0, 0xde, 0xfe, 
	0xaf,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xa1, 0xa2,    0,    0,    0,    0, 
	   0,    0, 0xa6, 0xab,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xb0, 0xb1, 
	0xb4, 0xb5,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xb7, 0xb9, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xbb, 0xbf,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xd7, 0xf7,    0,    0,    0,    0, 
	0xa8, 0xb8, 0xaa, 0xba, 0xbd, 0xbe,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xac, 0xbc,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa0, 0xa1, 0xa2, 0xa3,    0, 0xa5,    0, 0xa7, 
	   0, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 
	0xb0, 0xb1, 0xb2, 0xb3,    0, 0xb5, 0xb6, 0xb7, 
	   0, 0xb9, 0xba, 0xbb,    0,    0,    0, 0xbf, 
	   0,    0, 0xbc, 0xbd,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa6, 0xa8,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xbe,    0,    0,    0,    0, 0xb4, 0xb8,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0xa4,    0,    0,    0, 
	0xa0,    0,    0,    0,    0,    0,    0, 0xa7, 
	   0, 0xa9,    0, 0xa5,    0, 0xad,    0,    0, 
	0xb0, 0xb1,    0,    0,    0,    0, 0xb6, 0xb7, 
	   0,    0,    0, 0xbb,    0,    0,    0,    0, 
	0xc0, 0xc1, 0xc2,    0, 0xc4,    0, 0xc6, 0xc7, 
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 
	   0,    0, 0xd2, 0xd3, 0xd4,    0, 0xd6,    0, 
	   0, 0xd9, 0xda, 0xdb, 0xdc,    0,    0, 0xdf, 
	0xe0, 0xe1, 0xe2,    0, 0xe4,    0, 0xe6, 0xe7, 
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 
	   0,    0, 0xf2, 0xf3, 0xf4,    0, 0xf6,    0, 
	   0, 0xf9, 0xfa, 0xfb, 0xfc,    0,    0, 0xff, 
	   0,    0, 0xc3, 0xe3, 0xa1, 0xa2, 0xc5, 0xe5, 
	   0,    0,    0,    0, 0xb2, 0xb9,    0,    0, 
	0xd0, 0xf0,    0,    0,    0,    0,    0,    0, 
	0xdd, 0xfd,    0,    0,    0,    0,    0,    0, 
	   0, 0xa3, 0xb3, 0xd1, 0xf1,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xd5, 0xf5, 0xbc, 0xbd,    0,    0,    0,    0, 
	   0,    0, 0xd7, 0xf7,    0,    0,    0,    0, 
	0xd8, 0xf8,    0,    0,    0,    0,    0,    0, 
	0xbe, 0xac, 0xae, 0xaf, 0xbf, 0xb4, 0xb8,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xaa, 0xba, 0xde, 0xfe,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0xb5, 0xab,    0, 
	0xa0,    0,    0,    0, 0xa4,    0,    0, 0xa7, 
	0xa8,    0,    0,    0,    0, 0xad,    0,    0, 
	0xb0,    0,    0,    0, 0xb4,    0,    0,    0, 
	0xb8,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xc1, 0xc2,    0, 0xc4,    0,    0, 0xc7, 
	   0, 0xc9,    0, 0xcb,    0, 0xcd, 0xce,    0, 
	   0,    0,    0, 0xd3, 0xd4,    0, 0xd6, 0xd7, 
	   0,    0, 0xda,    0, 0xdc, 0xdd,    0, 0xdf, 
	   0, 0xe1, 0xe2,    0, 0xe4,    0,    0, 0xe7, 
	   0, 0xe9,    0, 0xeb,    0, 0xed, 0xee,    0, 
	   0,    0,    0, 0xf3, 0xf4,    0, 0xf6, 0xf7, 
	   0,    0, 0xfa,    0, 0xfc, 0xfd,    0,    0, 
	   0,    0, 0xc3, 0xe3, 0xa1, 0xb1, 0xc6, 0xe6, 
	   0,    0,    0,    0, 0xc8, 0xe8, 0xcf, 0xef, 
	0xd0, 0xf0,    0,    0,    0,    0,    0,    0, 
	0xca, 0xea, 0xcc, 0xec,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xc5, 0xe5,    0,    0, 0xa5, 0xb5,    0, 
	   0, 0xa3, 0xb3, 0xd1, 0xf1,    0,    0, 0xd2, 
	0xf2,    0,    0,    0,    0,    0,    0,    0, 
	0xd5, 0xf5,    0,    0, 0xc0, 0xe0,    0,    0, 
	0xd8, 0xf8, 0xa6, 0xb6,    0,    0, 0xaa, 0xba, 
	0xa9, 0xb9, 0xde, 0xfe, 0xab, 0xbb,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xd9, 0xf9, 
	0xdb, 0xfb,    0,    0,    0,    0,    0,    0, 
	   0, 0xac, 0xbc, 0xaf, 0xbf, 0xae, 0xbe,    0, 
	   0,    0,    0,    0,    0,    0,    0, 0xb7, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa2, 0xff,    0, 0xb2,    0, 0xbd,    0,    0, 
	0xa0,    0,    0, 0xa3, 0xa4,    0,    0, 0xa7, 
	0xa8,    0,    0,    0,    0, 0xad,    0,    0, 
	0xb0,    0, 0xb2, 0xb3, 0xb4, 0xb5,    0, 0xb7, 
	0xb8,    0,    0,    0,    0, 0xbd,    0,    0, 
	0xc0, 0xc1, 0xc2,    0, 0xc4,    0,    0, 0xc7, 
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 
	   0, 0xd1, 0xd2, 0xd3, 0xd4,    0, 0xd6, 0xd7, 
	   0, 0xd9, 0xda, 0xdb, 0xdc,    0,    0, 0xdf, 
	0xe0, 0xe1, 0xe2,    0, 0xe4,    0,    0, 0xe7, 
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 
	   0, 0xf1, 0xf2, 0xf3, 0xf4,    0, 0xf6, 0xf7, 
	   0, 0xf9, 0xfa, 0xfb, 0xfc,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xc6, 0xe6, 0xc5, 0xe5,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0xd8, 0xf8, 0xab, 0xbb, 
	0xd5, 0xf5,    0,    0, 0xa6, 0xb6, 0xa1, 0xb1, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa9, 0xb9,    0,    0, 0xac, 0xbc,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0xde, 0xfe, 0xaa, 0xba, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0xdd, 0xfd,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 0xaf, 0xbf,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa2, 0xff,    0,    0,    0,    0,    0,    0, 
	0xa0,    0,    0,    0, 0xa4,    0,    0, 0xa7, 
	0xa8,    0,    0,    0,    0, 0xad,    0, 0xaf, 
	   0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6,    0, 
	   0, 0xc9,    0, 0xcb,    0, 0xcd, 0xce,    0, 
	   0,    0,    0,    0, 0xd4, 0xd5, 0xd6, 0xd7, 
	0xd8,    0, 0xda, 0xdb, 0xdc,    0,    0, 0xdf, 
	   0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6,    0, 
	   0, 0xe9,    0, 0xeb,    0, 0xed, 0xee,    0, 
	   0,    0,    0,    0, 0xf4, 0xf5, 0xf6, 0xf7, 
	0xf8,    0, 0xfa, 0xfb, 0xfc,    0,    0,    0, 
	0xd0, 0xf0, 0xaa, 0xba,    0,    0, 0xcc, 0xec, 
	0xca, 0xea,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xab, 0xbb,    0,    0,    0,    0, 
	0xa5, 0xb5, 0xcf, 0xef,    0,    0, 0xc7, 0xe7, 
	   0,    0,    0,    0,    0,    0, 0xd3, 0xf3, 
	0xa2,    0,    0, 0xa6, 0xb6,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0xd1, 0xf1,    0, 
	   0,    0, 0xbd, 0xbf, 0xd2, 0xf2,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xa3, 0xb3, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa9, 0xb9,    0,    0,    0,    0, 0xac, 0xbc, 
	0xdd, 0xfd, 0xde, 0xfe,    0,    0,    0,    0, 
	   0,    0, 0xd9, 0xf9,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0xae, 0xbe,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xff,    0, 0xb2,    0,    0,    0,    0, 
	0xa0,    0,    0,    0,    0,    0,    0, 0xfd, 
	   0,    0,    0,    0,    0, 0xad,    0,    0, 
	   0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 
	0xa8, 0xa9, 0xaa, 0xab, 0xac,    0, 0xae, 0xaf, 
	   0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc,    0, 0xfe, 0xff, 
	   0,    0,    0,    0,    0,    0, 0xf0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa0,    0,    0,    0, 0xa4,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0xad,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0xac,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 0xbb,    0,    0,    0, 0xbf, 
	   0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 
	0xd8, 0xd9, 0xda,    0,    0,    0,    0,    0, 
	0xf0, 0xf1, 0xf2,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa0,    0,    0, 0xa3,    0,    0, 0xa6, 0xa7, 
	0xa8, 0xa9,    0, 0xab, 0xac, 0xad,    0,    0, 
	0xb0, 0xb1, 0xb2, 0xb3,    0,    0,    0, 0xb7, 
	   0,    0,    0, 0xbb,    0, 0xbd,    0,    0, 
	   0,    0,    0,    0, 0xb4, 0xb5, 0xb6,    0, 
	0xb8, 0xb9, 0xba,    0, 0xbc,    0, 0xbe, 0xbf, 
	0xd0, 0xd1,    0, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe,    0, 
	   0,    0,    0,    0,    0, 0xaf,    0,    0, 
	0xa1, 0xa2,    0,    0,    0,    0,    0,    0, 
	0xa0,    0, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 
	0xa8, 0xa9,    0, 0xab, 0xac, 0xad, 0xae, 0xaf, 
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 
	0xb8, 0xb9,    0, 0xbb, 0xbc, 0xbd, 0xbe,    0, 
	   0,    0,    0,    0,    0,    0,    0, 0xdf, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 
	0xd8, 0xd9, 0xda, 0xdb, 0xdc,    0,    0, 0xdf, 
	   0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc,    0,    0, 0xff, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xd0, 0xf0, 
	0xdd, 0xfd,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xde, 0xfe, 
	0x9a,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xbf,    0,    0,    0,    0,    0,    0, 
	0x9c,    0, 0x9d,    0,    0,    0,    0, 0x9e, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0, 0x9f, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xb3,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xe1, 0xe2, 0xf7, 0xe7, 0xe4, 0xe5, 0xf6, 0xfa, 
	0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 
	0xf2, 0xf3, 0xf4, 0xf5, 0xe6, 0xe8, 0xe3, 0xfe, 
	0xfb, 0xfd, 0xff, 0xf9, 0xf8, 0xfc, 0xe0, 0xf1, 
	0xc1, 0xc2, 0xd7, 0xc7, 0xc4, 0xc5, 0xd6, 0xda, 
	0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 
	0xd2, 0xd3, 0xd4, 0xd5, 0xc6, 0xc8, 0xc3, 0xde, 
	0xdb, 0xdd, 0xdf, 0xd9, 0xd8, 0xdc, 0xc0, 0xd1, 
	   0, 0xa3,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0x95, 0x96,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x97,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x98, 0x99,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x93, 0x9b,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x80,    0, 0x81,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x82,    0,    0,    0, 
	0x83,    0,    0,    0, 0x84,    0,    0,    0, 
	0x85,    0,    0,    0, 0x86,    0,    0,    0, 
	   0,    0,    0,    0, 0x87,    0,    0,    0, 
	   0,    0,    0,    0, 0x88,    0,    0,    0, 
	   0,    0,    0,    0, 0x89,    0,    0,    0, 
	   0,    0,    0,    0, 0x8a,    0,    0,    0, 
	0xa0, 0xa1, 0xa2, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 
	0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 
	0xb1, 0xb2, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 
	0xba, 0xbb, 0xbc, 0xbd, 0xbe,    0,    0,    0, 
	0x8b,    0,    0,    0, 0x8c,    0,    0,    0, 
	0x8d,    0,    0,    0, 0x8e,    0,    0,    0, 
	0x8f, 0x90, 0x91, 0x92,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x94,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0xa4,    0, 0xa6, 0xa7, 
	   0, 0xbf,    0, 0xab, 0xac, 0xad, 0xae,    0, 
	0xb0, 0xb1, 0xb2,    0,    0,    0, 0xb6, 0xb7, 
	   0,    0,    0, 0xbb,    0,    0,    0,    0, 
	   0,    0, 0x83, 0x81,    0,    0,    0,    0, 
	   0,    0, 0x90, 0x80,    0,    0,    0,    0, 
	   0,    0, 0x8c, 0x8a,    0,    0, 0x8e, 0x8d, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0xb5, 0xa5,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0xa2, 0xa1, 
	   0, 0xb3,    0,    0, 0xb4,    0, 0xb6, 0xb7, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0xa3,    0,    0, 0xa4,    0, 0xa6, 0xa7, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xbd, 0xad,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa0, 0xa1, 0xa2,    0, 0xa5,    0,    0, 0xa8, 
	0xa9, 0xaa, 0xab, 0xac,    0, 0xae, 0xaf, 0xb0, 
	0xb1, 0xb2,    0, 0xb5,    0,    0, 0xb8, 0xb9, 
	0xba, 0xbb, 0xbc,    0, 0xbe,    0,    0,    0, 
	   0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 
	0xd8, 0xd9, 0xda,    0,    0,    0,    0, 0xdf, 
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 
	0xf8, 0xf9, 0xfa, 0xfb,    0,    0,    0,    0, 
},
{	/* tblwctype */
	0x3a, 0x21, 0x1f, 0x32, 0x23, 0x1e, 0x02, 0x2c, 
	   0, 0x27, 0x04, 0x25, 0x26, 0x05, 0x07, 0x29, 
	0x0f, 0x12, 0x09, 0x0c, 0x06, 0x19, 0x1a, 0x0b, 
	0x2b,    0,    0,    0,    0,    0, 0x20, 0x1d, 
	0x39, 0x2a, 0x37, 0x34, 0x30, 0x37, 0x2e, 0x24, 
	0x37, 0x37, 0x37,    0,    0,    0, 0x01, 0x35, 
	0x38, 0x03, 0x2f, 0x33, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x17, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x16, 
	0x19, 0x19, 0x19, 0x19, 0x13,    0,    0,    0, 
	   0,    0,    0,    0, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x14, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
	0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
	0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
	0x37, 0x19, 0x10, 0x08, 0x19, 0x1b, 0x2d, 0x28, 
	   0,    0,    0, 0x0e, 0x22,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x36, 0x31,    0,    0, 0x11, 0x0a, 0x15, 0x1c, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x18,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x19, 0x19, 0x0d,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xe4, 0xe4, 0xe4, 0xcd, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xd0,    0, 
	   0, 0x07,    0, 0x1a, 0x35, 0x55, 0x55, 0x3e, 
	0x55, 0x6a, 0xde,    0, 0x55, 0x6f, 0x76, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x5a, 0xe4, 0xda, 0xde, 0x55, 0x5c, 
	0x08, 0x55, 0x55, 0x55, 0x55, 0x49, 0x35, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x53, 0xe4, 0xe4, 0x55, 0x55, 0x55,    0, 
	   0,    0,    0,    0,    0,    0, 0x55, 0x55, 
	0x12, 0x3f, 0x23, 0x55, 0x55, 0x28, 0x25, 0x3b, 
	0xc4, 0x2d,    0, 0x32, 0x03, 0x55, 0xc7,    0, 
	0xb6, 0x50, 0x47, 0x55, 0x55, 0x28, 0x26, 0x3d, 
	0xe3, 0xcc, 0x1f,    0, 0x20, 0x55,    0,    0, 
	0x1d, 0x4c, 0x28, 0x55, 0x55, 0x28, 0x55, 0x3a, 
	0xd2, 0x2e, 0x04,    0, 0x39, 0x55,    0,    0, 
	0x1d, 0x55, 0x53, 0x17, 0x55, 0x55, 0x47, 0x4f, 
	0x53, 0x11, 0xd5, 0xe4,    0,    0, 0x1c,    0, 
	0x35, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x35, 0x55, 0x55, 0x55, 0x55, 0x58, 0x55, 0x41, 
	0x56, 0x58, 0x55, 0x6b,    0,    0,    0,    0, 
	0x2f, 0x22, 0x0b, 0x35, 0x34, 0x16, 0xbc, 0xcb, 
	0x4a, 0xde, 0x55, 0x3c,    0,    0,    0,    0, 
	0x53,    0, 0x14, 0x09, 0x55, 0xbb, 0x53, 0x4a, 
	0x44, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x37,    0, 
	   0,    0, 0x14, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x53, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x53, 0x27, 0x53, 0x27, 0x55, 0x55, 0x55, 0x55, 
	0x53, 0x27, 0x55, 0x55, 0x55, 0x53, 0x27, 0x53, 
	0x27, 0x53, 0x53, 0x55, 0x55, 0x53, 0x55, 0x55, 
	0x54, 0x42, 0x4c, 0x4c, 0x55, 0x55, 0x55, 0x46, 
	0x4a, 0x17, 0x28, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x4c, 0x6d,    0, 0x55, 0x55, 0x6e,    0, 
	0x55, 0x55, 0x6b,    0, 0x55, 0x4c, 0x2a,    0, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x60, 0xe4, 
	0xe4, 0xe4, 0xe2, 0xd3, 0x55, 0x37,    0,    0, 
	0x55, 0x53, 0x27, 0x53, 0x55, 0x55, 0x55, 0x55, 
	0x53, 0x55, 0x55, 0x3e, 0xb9, 0x76, 0x70, 0xd4, 
	   0,    0,    0,    0, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x49,    0, 
	0x55, 0x55, 0x55, 0x52,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x55, 0x55, 0x55, 0x53, 0xd0,    0, 0x55, 0x55, 
	0x55, 0x3e,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x55, 0x55, 0x55, 0x55, 0x47, 0x31, 0xc5, 0xc0, 
	0x55, 0x70, 0x59, 0xc0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x55, 0x55, 0x55, 0x55, 
	0x52,    0, 0x55, 0x55, 0x55, 0x55, 0x55, 0x29, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x52, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x3e,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x4c, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x4c, 0x10, 0x33, 0x55, 0x45, 
	0x26, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x38, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x3e, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x37, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x49, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe0,    0,    0,    0,    0,    0,    0,    0, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x48,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x48, 0x55, 0x55, 0x55, 
	0xbb, 0x55, 0x55, 0x68, 0x55, 0x55, 0x55, 0x68, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x52,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x52,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x53,    0,    0,    0,    0,    0, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x5e, 0x53,    0, 
	0x78, 0x55, 0x55, 0x67, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x69, 0x1f,    0, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x59, 
	   0,    0, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x17, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55,    0,    0,    0,    0,    0, 0x55, 0x4e, 
	0x55, 0x55, 0x5d, 0x55, 0x55, 0x55, 0x5d, 0x55, 
	0x55, 0x58, 0x55, 0x55, 0x55, 0x58, 0x55, 0x55, 
	0x55, 0xbb, 0x55, 0x55, 0x55, 0xbb, 0x55, 0x55, 
	0x68, 0x39, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x86, 0xaa, 0x83, 0xa7, 0x86, 0xaa, 0x86, 0xaa, 
	0x83, 0xa7, 0x7b, 0x96, 0x86, 0xaa, 0x86, 0x83, 
	0x86, 0xaa, 0x86, 0xaa, 0x86, 0xaa, 0x82, 0xae, 
	0xc9, 0xaf, 0x7d, 0xac, 0x7f, 0xaf, 0x19, 0xad, 
	0x92, 0x92,    0,    0,    0,    0, 0x97, 0xaa, 
	0xaa, 0xaa, 0xa8, 0x36, 0x79, 0x86, 0x86, 0x86, 
	0x85, 0xb4, 0xb9, 0xe4, 0xcd, 0xe4, 0xe4, 0xcd, 
	0xd4,    0, 0x55, 0x55, 0x55, 0x3e, 0x67,    0, 
	0x92, 0x92, 0x92, 0x92, 0x2b, 0x92, 0x8f,    0, 
	   0,    0, 0x65, 0x7a, 0x71, 0x7e, 0x62, 0x55, 
	0x71, 0x72, 0x61, 0x55, 0x55, 0x52, 0x55, 0xbd, 
	0x70, 0xe4, 0x70, 0xe4, 0x5f, 0xdf,    0,    0, 
	0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 
	0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 
	0x92, 0x92, 0x91, 0x64, 0x92, 0x92, 0x92, 0x92, 
	0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x8c, 
	0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x9a, 
	0x9f, 0x73, 0x92, 0x92, 0x92, 0x92, 0x92, 0xa5, 
	0x99, 0xa0, 0xa4, 0x8e, 0x93, 0x9c, 0xa1, 0x8d, 
	0x5b, 0x8b, 0x9f, 0x9d, 0x92, 0x92, 0x98, 0x92, 
	0xaa, 0xaa, 0xaa, 0xaa, 0xa7, 0x86, 0x86, 0x86, 
	0x86, 0x83,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x86, 0x86, 
	0x86, 0x86, 0x86, 0x86, 0x92, 0x92, 0x92, 0x92, 
	0x94, 0xca, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 
	0x9a, 0x9e, 0x92, 0x92, 0x92, 0x92, 0x90, 0x8c, 
	0xb5, 0xc1, 0xe4, 0xe4, 0xe4, 0xb9, 0xe4, 0xe4, 
	0xe4, 0xdc, 0xc3, 0xe0, 0xb9, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xd4, 0xe4, 0xe4, 0xe4, 0xb9, 0xe0, 
	   0,    0, 0xe4, 0xe4, 0xe4, 0xd0, 0xe4, 0xe4, 
	0xb6, 0x4b, 0x23, 0x55, 0x55, 0x28, 0x24, 0x3d, 
	0xd1, 0x2d, 0x05, 0x0a, 0x39, 0x55, 0x2c,    0, 
	0x18, 0x40, 0x27, 0x30, 0x13, 0x40, 0x54, 0x3a, 
	0xc5, 0x2e, 0x04,    0, 0x02, 0x55, 0xc2,    0, 
	0xb6, 0x4c, 0x28, 0x55, 0x55, 0x28, 0x51, 0x3a, 
	0xd7, 0x2e, 0x0c,    0, 0x39, 0x55,    0,    0, 
	0x1d, 0x4c, 0x28, 0x55, 0x55, 0x28, 0x51, 0x3a, 
	0xd7, 0x2e, 0x0c, 0x01, 0x39, 0x55,    0,    0, 
	0xb6, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3d, 
	0xe4, 0xde, 0xbe, 0x55, 0x6f, 0x55, 0x2c,    0, 
	0xb6, 0x4b, 0x23, 0x55, 0x55, 0x28, 0x21, 0x3b, 
	0xd6, 0x2d, 0x04, 0x0a, 0x6c, 0x55, 0x70, 0xc2, 
	0xb9, 0xe4, 0x55, 0x70, 0xb1, 0xaa, 0xaa, 0xb0, 
	0x95, 0x86, 0x86, 0x88, 0xe1, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x53, 
	0x17, 0x17, 0x17, 0x15, 0xe0, 0xe0,    0, 0xb8, 
	0xbf, 0xe4, 0xe4, 0xe4, 0x55, 0x70, 0xe4, 0xe4, 
	0x55, 0x35, 0x55, 0x55, 0x55, 0x3e, 0xb9, 0xe4, 
	0xe4, 0x48, 0xe4, 0xb9, 0xe4, 0xe4, 0xe4, 0xd7, 
	0xe4, 0xd6,    0,    0,    0,    0,    0,    0, 
	0xce, 0xc8, 0x5a, 0x77, 0xdd, 0x66, 0x63, 0x43, 
	0xd9, 0x6b, 0x1b, 0xe4, 0xaa, 0xaa, 0x86, 0x86, 
	0x48,    0, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe0, 0x55, 0x37, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,    0, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0xba,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xe4, 0xe3, 0xbb, 0x55, 0x55, 0x49, 0xe4, 0xe4, 
	0xe4, 0xc2,    0,    0,    0,    0,    0,    0, 
	0x55, 0x55, 0x55, 0x55, 0x59, 0xe4, 0x74,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xe4, 0xe4,    0,    0, 0xd0,    0, 0xe4, 0xe4, 
	0xe5, 0xb9, 0xc6, 0xe4, 0xe0, 0xd0, 0x4c, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x4d, 
	0xe4, 0xe4, 0xd2, 0xb9, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xde, 
	0xe4, 0xc0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xe4, 0xe4, 0xe4, 0xd4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xd0,    0, 0xb9, 0xe4, 0xe4, 0xe4, 0xe4, 0xd1, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xd0, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe0, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe0,    0,    0,    0, 
	0xe4, 0xc2,    0,    0, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xd8, 0x55, 0x55, 0x57, 0xaa, 
	0xaa, 0xaa, 0x86, 0x86, 0x86, 0x8a, 0xe4, 0xe0, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe0, 0x1e, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xde,    0,    0,    0,    0, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xdb, 0xe4,    0,    0, 0xe4, 0xe4, 0x0d, 0x0f, 
	0x0e, 0xa2, 0x9b, 0xaa, 0xa3, 0xa6, 0x7c, 0x86, 
	0x86, 0x84, 0x80, 0x92, 0x92, 0x92, 0x81,    0, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe0, 0x1b, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xde, 0xe4, 0xe4, 0xe4, 0xe0, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe0,    0,    0,    0,    0,    0,    0, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xde,    0,    0,    0, 0xe4, 0xd0, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xde,    0, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 
	0xe6, 0xe4, 0xe4, 0xe4, 0x76, 0x70, 0x77, 0x5f, 
	0x35, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x53, 0xb7, 0x76, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x68, 
	0xe9, 0xe8, 0xe4, 0xe4, 0xe4, 0xea, 0xe4, 0xe4, 
	0xe4, 0xe4, 0xc4, 0x06, 0xd0, 0x1e, 0x75, 0xe2, 
	0xe4, 0xe0,    0,    0, 0xe4, 0xe4, 0xc0,    0, 
	   0,    0, 0xe4, 0xe4, 0xe4, 0xc2,    0,    0, 
	0xec, 0xeb, 0xec, 0xec, 0xe7, 0xe4, 0xb2, 0xb3, 
	0xb1, 0xaa, 0xaa, 0xb0, 0x95, 0x86, 0x86, 0x89, 
	0xec, 0xec, 0xec, 0xec, 0xe4, 0xcf, 0xdb, 0xcf, 
	0xaa, 0xaa, 0xab, 0xa9, 0x86, 0x86, 0x87, 0x86, 
	   0,    0,    0,    0,    0,    0,    0, 0x01, 
	   0,    0,    0, 0x10,    0,    0,    0, 0x11, 
	   0,    0,    0, 0x60,    0,    0,    0, 0x66, 
	   0,    0,    0, 0x90,    0,    0, 0x06,    0, 
	   0,    0, 0x10, 0x11,    0,    0, 0x10, 0x16, 
	   0,    0, 0x11, 0x10,    0,    0, 0x11, 0x11, 
	   0,    0, 0x60, 0x06,    0,    0, 0x66,    0, 
	   0,    0, 0x66, 0x64,    0, 0x01,    0, 0x06, 
	   0, 0x01, 0x10, 0x01,    0, 0x06,    0, 0x60, 
	   0, 0x06, 0x10, 0x11,    0, 0x10, 0x01,    0, 
	   0, 0x10, 0x11, 0x11,    0, 0x11, 0x01,    0, 
	   0, 0x11, 0x10, 0x11,    0, 0x11, 0x11, 0x11, 
	   0, 0x16, 0x10, 0x11,    0, 0x21, 0x01, 0x11, 
	   0, 0x60,    0, 0x60,    0, 0x60, 0x66, 0x66, 
	   0, 0x66, 0x06,    0,    0, 0x66, 0x10, 0x11, 
	   0, 0x66, 0x66, 0x66, 0x01,    0,    0,    0, 
	0x01,    0,    0, 0x11, 0x01, 0x01,    0, 0x11, 
	0x01, 0x01, 0x10,    0, 0x01, 0x10, 0x11, 0x11, 
	0x01, 0x11,    0, 0x11, 0x01, 0x11, 0x10, 0x01, 
	0x01, 0x11, 0x10, 0x11, 0x01, 0x11, 0x11,    0, 
	0x01, 0x11, 0x11, 0x11, 0x01, 0x60,    0,    0, 
	0x01, 0x66,    0,    0, 0x04, 0x24, 0x24, 0x24, 
	0x06,    0,    0,    0, 0x06, 0x60, 0x66,    0, 
	0x06, 0x66, 0x66,    0, 0x10, 0x01, 0x01, 0x10, 
	0x10, 0x01, 0x01, 0x11, 0x10, 0x01, 0x66, 0x66, 
	0x10, 0x11, 0x01, 0x01, 0x10, 0x11, 0x01, 0x11, 
	0x10, 0x11, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 
	0x10, 0x66, 0x66, 0x66, 0x11,    0,    0,    0, 
	0x11,    0,    0, 0x10, 0x11,    0,    0, 0x11, 
	0x11,    0,    0, 0x66, 0x11,    0, 0x06, 0x66, 
	0x11,    0, 0x11,    0, 0x11,    0, 0x16, 0x66, 
	0x11, 0x01,    0,    0, 0x11, 0x01,    0, 0x10, 
	0x11, 0x01,    0, 0x11, 0x11, 0x01,    0, 0x60, 
	0x11, 0x01, 0x10, 0x11, 0x11, 0x06, 0x10, 0x11, 
	0x11, 0x10, 0x01, 0x11, 0x11, 0x10, 0x10, 0x11, 
	0x11, 0x10, 0x11, 0x01, 0x11, 0x10, 0x11, 0x11, 
	0x11, 0x11,    0,    0, 0x11, 0x11, 0x01,    0, 
	0x11, 0x11, 0x01, 0x01, 0x11, 0x11, 0x01, 0x10, 
	0x11, 0x11, 0x01, 0x11, 0x11, 0x11, 0x01, 0x60, 
	0x11, 0x11, 0x06,    0, 0x11, 0x11, 0x10,    0, 
	0x11, 0x11, 0x10, 0x10, 0x11, 0x11, 0x10, 0x11, 
	0x11, 0x11, 0x11,    0, 0x11, 0x11, 0x11, 0x01, 
	0x11, 0x11, 0x11, 0x10, 0x11, 0x11, 0x11, 0x11, 
	0x11, 0x11, 0x11, 0x16, 0x11, 0x11, 0x11, 0x44, 
	0x11, 0x11, 0x11, 0x61, 0x11, 0x11, 0x11, 0x66, 
	0x11, 0x11, 0x16, 0x66, 0x11, 0x11, 0x34, 0x42, 
	0x11, 0x11, 0x61, 0x06, 0x11, 0x11, 0x61, 0x11, 
	0x11, 0x11, 0x61, 0x16, 0x11, 0x11, 0x61, 0x66, 
	0x11, 0x11, 0x66, 0x66, 0x11, 0x12, 0x11, 0x11, 
	0x11, 0x12, 0x21, 0x11, 0x11, 0x16, 0x11, 0x11, 
	0x11, 0x21,    0,    0, 0x11, 0x21, 0x12, 0x22, 
	0x11, 0x44, 0x11, 0x16, 0x11, 0x61, 0x06,    0, 
	0x11, 0x61, 0x11, 0x11, 0x11, 0x61, 0x66, 0x11, 
	0x11, 0x61, 0x66, 0x66, 0x11, 0x66,    0,    0, 
	0x11, 0x66,    0, 0x11, 0x11, 0x66, 0x06,    0, 
	0x11, 0x66, 0x66, 0x06, 0x11, 0x66, 0x66, 0x11, 
	0x11, 0x66, 0x66, 0x66, 0x12, 0x21, 0x11, 0x11, 
	0x12, 0x22, 0x11, 0x11, 0x12, 0x24, 0x24, 0x24, 
	0x16,    0,    0,    0, 0x16,    0, 0x66, 0x66, 
	0x16, 0x11, 0x11, 0x11, 0x16, 0x11, 0x11, 0x66, 
	0x19, 0x11, 0x11, 0x11, 0x20, 0x22, 0x22, 0x22, 
	0x21, 0x21, 0x11, 0x11, 0x21, 0x21, 0x21, 0x21, 
	0x21, 0x22, 0x22, 0x22, 0x22, 0x11,    0, 0x11, 
	0x22, 0x11, 0x11, 0x21, 0x22, 0x11, 0x21, 0x11, 
	0x22, 0x11, 0x21, 0x12, 0x22, 0x12, 0x24, 0x06, 
	0x22, 0x21, 0x01, 0x11, 0x22, 0x22, 0x22,    0, 
	0x22, 0x22, 0x22, 0x02, 0x22, 0x22, 0x22, 0x12, 
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x62, 
	0x22, 0x62, 0x66, 0x66, 0x22, 0x62, 0x66, 0xe6, 
	0x22, 0x66, 0x66, 0x66, 0x23, 0x34, 0x42, 0x42, 
	0x24,    0,    0,    0, 0x24, 0x11, 0x24, 0x21, 
	0x24, 0x11, 0x44, 0x42, 0x24, 0x24,    0,    0, 
	0x24, 0x24, 0x24,    0, 0x24, 0x24, 0x24, 0x11, 
	0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x44, 
	0x24, 0x66, 0x66, 0x06, 0x26, 0x22, 0x22, 0x22, 
	0x40, 0x40, 0x40, 0x40, 0x40, 0x44, 0x44, 0x44, 
	0x41, 0x23, 0x24, 0x44, 0x41, 0x24, 0x24, 0x44, 
	0x41, 0x42, 0x42, 0x42, 0x41, 0x44, 0x44, 0x44, 
	0x42, 0x11, 0x24, 0x44, 0x42, 0x42, 0x22, 0x24, 
	0x42, 0x42, 0x42, 0x02, 0x42, 0x42, 0x42, 0x42, 
	0x42, 0x44, 0x12, 0x44, 0x42, 0x44, 0x42, 0x42, 
	0x44, 0x04, 0x04, 0x44, 0x44, 0x40, 0x44, 0x44, 
	0x44, 0x42, 0x24, 0x44, 0x44, 0x42, 0x42, 0x22, 
	0x44, 0x44, 0x22, 0x22, 0x44, 0x44, 0x44,    0, 
	0x44, 0x44, 0x44, 0x04, 0x44, 0x44, 0x44, 0x24, 
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x64, 
	0x44, 0x44, 0x60, 0x66, 0x44, 0x44, 0x64, 0x06, 
	0x44, 0x44, 0x64, 0x62, 0x44, 0x44, 0x64, 0x66, 
	0x44, 0x64, 0x66, 0x66, 0x46, 0x44, 0x44, 0x44, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x66, 0x66, 0x66, 
	0x60, 0x06,    0,    0, 0x60, 0x66, 0x06, 0x66, 
	0x60, 0x66, 0x10, 0x11, 0x60, 0x66, 0x16, 0x11, 
	0x60, 0x66, 0x66,    0, 0x60, 0x66, 0x66, 0x66, 
	0x61,    0,    0,    0, 0x61, 0x11, 0x11, 0x11, 
	0x61, 0x11, 0x66, 0x66, 0x61, 0x16, 0x11, 0x11, 
	0x61, 0x66, 0x06,    0, 0x61, 0x66, 0x66, 0x66, 
	0x66,    0,    0,    0, 0x66,    0, 0x66, 0x66, 
	0x66, 0x06,    0,    0, 0x66, 0x06,    0, 0x06, 
	0x66, 0x06,    0, 0x60, 0x66, 0x06,    0, 0x66, 
	0x66, 0x06, 0x66, 0x66, 0x66, 0x11, 0x01,    0, 
	0x66, 0x11, 0x11, 0x11, 0x66, 0x21, 0x01, 0x11, 
	0x66, 0x24, 0x24, 0x24, 0x66, 0x60, 0x16,    0, 
	0x66, 0x60, 0x66,    0, 0x66, 0x60, 0x66, 0x66, 
	0x66, 0x61, 0x66, 0x16, 0x66, 0x61, 0x66, 0x66, 
	0x66, 0x66,    0,    0, 0x66, 0x66,    0, 0x60, 
	0x66, 0x66,    0, 0x66, 0x66, 0x66, 0x01,    0, 
	0x66, 0x66, 0x06,    0, 0x66, 0x66, 0x06, 0x06, 
	0x66, 0x66, 0x06, 0x60, 0x66, 0x66, 0x06, 0x66, 
	0x66, 0x66, 0x11, 0x11, 0x66, 0x66, 0x16, 0x11, 
	0x66, 0x66, 0x16, 0x61, 0x66, 0x66, 0x26, 0x66, 
	0x66, 0x66, 0x60, 0x60, 0x66, 0x66, 0x61, 0x64, 
	0x66, 0x66, 0x66,    0, 0x66, 0x66, 0x66, 0x01, 
	0x66, 0x66, 0x66, 0x06, 0x66, 0x66, 0x66, 0x11, 
	0x66, 0x66, 0x66, 0x16, 0x66, 0x66, 0x66, 0x60, 
	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x76, 0x07, 
	0x69, 0x66, 0x16, 0x11, 0x69, 0x66, 0x66, 0x66, 
	0x99, 0x99, 0x66, 0x66, 0x99, 0x99, 0x99, 0x69, 
	0xcc, 0x66, 0x66, 0x66, 0xde, 0xcc, 0xcc, 0xee, 
	0xee, 0xee, 0xee, 0xee, 
},
{	/* tblwuplow */
	0x04, 0x06, 0x07,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0, 0x05, 
	0x01,    0, 0x03,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0, 0x02, 
	   0,    0, 0x08,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x02, 0x0d,    0,    0, 
	   0,    0,    0,    0, 0x51, 0x51, 0x52, 0x52, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x0e, 0x1b, 0x1b, 0x19, 
	0x0f, 0x1f, 0x1f, 0x1d,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0x03, 0x53, 
	0x53, 0x53, 0x55, 0x55, 0x55, 0x54,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x0e, 0x1b, 0x1b, 0x19, 0x0f, 0x1f, 0x1f, 0x1d, 
	   0,    0,    0,    0,    0,    0, 0x04,    0, 
	0x1b, 0x1b, 0x1a, 0x1a, 0x1f, 0x1f, 0x1e, 0x20, 
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x31, 0x10, 
	0x2c, 0x2a, 0x28, 0x28, 0x28, 0x28, 0x28, 0x32, 
	0x11, 0x2e, 0x33, 0x25, 0x29, 0x2f, 0x30, 0x24, 
	0x06, 0x34, 0x2c, 0x2d, 0x28, 0x28, 0x12, 0x28, 
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 
	0x28, 0x28, 0x27, 0x08, 0x28, 0x28, 0x28, 0x28, 
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x23, 
	0x47, 0x49, 0x46, 0x48, 0x47, 0x49, 0x47, 0x49, 
	0x46, 0x48, 0x16, 0x17, 0x47, 0x49, 0x4d, 0x4e, 
	0x47, 0x49, 0x47, 0x49, 0x47, 0x49, 0x45, 0x4a, 
	0x09, 0x4f, 0x43, 0x4b, 0x44, 0x4c, 0x09, 0x50, 
	0x28, 0x28, 0x28, 0x28, 0x35, 0x28, 0x26,    0, 
	   0,    0, 0x07, 0x13, 0x36, 0x37, 0x0b,    0, 
	0x38, 0x39, 0x0c,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x05,    0,    0,    0,    0,    0,    0,    0, 
	0x01, 0x3a, 0x0e, 0x1b, 0x18, 0x1c, 0x0f, 0x1f, 
	0x22, 0x21, 0x3b, 0x28, 0x28, 0x28, 0x3c,    0, 
	0x3e, 0x3e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1f, 0x1f, 
	0x1f, 0x1f, 0x3d, 0x3d, 0x28, 0x28, 0x28, 0x28, 
	0x23, 0x0a, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 
	0x10, 0x2b, 0x28, 0x28, 0x28, 0x28, 0x27, 0x23, 
	0x28, 0x28,    0,    0,    0,    0, 0x14, 0x40, 
	0x40, 0x40, 0x3f,    0, 0x15, 0x42, 0x42, 0x42, 
	0x41,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x57, 0x57, 0x57, 0x57, 0x56, 0x59, 0x59, 0x59, 
	0x59, 0x58,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0x31,    0, 
	   0,    0,    0,    0,    0,    0, 0x59,    0, 
	   0,    0,    0,    0,    0,    0, 0x5e, 0x5e, 
	   0,    0,    0,    0,    0, 0x03,    0,    0, 
	   0,    0,    0,    0,    0, 0x30,    0,    0, 
	   0,    0,    0,    0, 0x1c, 0x1d, 0x1e, 0x1c, 
	   0,    0,    0, 0x23, 0x24,    0, 0x25, 0x25, 
	   0,    0,    0, 0x45,    0,    0,    0,    0, 
	   0,    0,    0, 0x4e,    0,    0,    0,    0, 
	   0,    0, 0x05, 0x06, 0x05, 0x06, 0x05, 0x06, 
	   0,    0, 0x2b,    0,    0, 0x2c,    0,    0, 
	   0,    0, 0x2f,    0,    0,    0,    0,    0, 
	   0,    0, 0x5a, 0x5b,    0,    0,    0,    0, 
	   0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	   0, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
	   0, 0x05, 0x06, 0x05, 0x06, 0x05, 0x06, 0x05, 
	   0, 0x0b, 0x05, 0x06, 0x05, 0x06, 0x0c, 0x05, 
	   0, 0x1c, 0x1d, 0x1e, 0x05, 0x06, 0x20, 0x21, 
	   0, 0x26,    0, 0x27,    0,    0,    0,    0, 
	   0, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 
	   0, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 
	   0, 0x46,    0, 0x46,    0, 0x46,    0, 0x46, 
	   0, 0x47,    0, 0x47,    0, 0x47,    0, 0x47, 
	0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01,    0,    0,    0,    0,    0, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x35, 0x36, 0x36, 0x36, 
	0x02, 0x02, 0x02,    0,    0,    0,    0,    0, 
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,    0, 
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 
	0x02, 0x02, 0x02, 0x02, 0x38, 0x39, 0x39,    0, 
	0x02, 0x02, 0x37, 0x02, 0x02, 0x02, 0x02, 0x02, 
	0x05, 0x06,    0,    0,    0,    0,    0,    0, 
	0x05, 0x06,    0,    0, 0x05, 0x06,    0, 0x1b, 
	0x05, 0x06,    0,    0, 0x13, 0x15, 0x16, 0x17, 
	0x05, 0x06, 0x05, 0x06,    0,    0,    0,    0, 
	0x05, 0x06, 0x05, 0x06, 0x05, 0x06,    0,    0, 
	0x05, 0x06, 0x05, 0x06, 0x05, 0x06, 0x05, 0x06, 
	0x05, 0x06, 0x05, 0x06, 0x05, 0x06, 0x18, 0x05, 
	0x06,    0, 0x05, 0x06, 0x05, 0x06, 0x05, 0x06, 
	0x06, 0x05, 0x06, 0x05, 0x06, 0x05, 0x06,    0, 
	0x06, 0x05, 0x06, 0x05, 0x06, 0x05, 0x06, 0x05, 
	0x06, 0x05, 0x06, 0x05, 0x06, 0x1f, 0x05, 0x06, 
	0x06, 0x0d, 0x0d, 0x05, 0x06,    0, 0x0e, 0x0f, 
	0x06, 0x18,    0,    0, 0x05, 0x06, 0x18, 0x05, 
	0x06, 0x19, 0x19, 0x05, 0x06, 0x05, 0x06, 0x1a, 
	0x07, 0x08, 0x05, 0x06, 0x05, 0x06, 0x05, 0x06, 
	0x09, 0x05, 0x06, 0x05, 0x06, 0x05, 0x06, 0x0a, 
	0x10, 0x05, 0x06, 0x0d, 0x11, 0x12, 0x13, 0x14, 
	0x1d, 0x1e, 0x1c, 0x1d, 0x1e, 0x05, 0x06, 0x05, 
	0x22,    0, 0x05, 0x06, 0x05, 0x06, 0x05, 0x06, 
	0x25,    0,    0, 0x28,    0,    0,    0,    0, 
	0x29, 0x2a,    0,    0,    0,    0,    0, 0x2a, 
	0x2d,    0,    0, 0x2d,    0,    0,    0,    0, 
	0x2d,    0, 0x2e, 0x2e,    0,    0,    0,    0, 
	0x32, 0x32, 0x32,    0, 0x33,    0, 0x34, 0x34, 
	0x3a, 0x3b,    0,    0,    0, 0x3c, 0x3d,    0, 
	0x3e, 0x3f, 0x1f,    0, 0x40, 0x41,    0,    0, 
	0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 
	0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43,    0, 
	0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,    0, 
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 
	0x46, 0x46,    0,    0,    0,    0,    0,    0, 
	0x46, 0x46,    0,    0,    0, 0x54,    0,    0, 
	0x46, 0x46,    0, 0x4e,    0,    0,    0,    0, 
	0x46, 0x46, 0x46, 0x46, 0x46, 0x46,    0,    0, 
	0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 
	0x47, 0x47, 0x47, 0x47, 0x47, 0x47,    0,    0, 
	0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 
	0x47, 0x47, 0x4f, 0x4f, 0x50,    0, 0x51,    0, 
	0x47, 0x47, 0x53, 0x53,    0,    0,    0,    0, 
	0x47, 0x47, 0x55, 0x55, 0x56,    0,    0,    0, 
	0x48, 0x48, 0x49, 0x49, 0x49, 0x49, 0x4a, 0x4a, 
	0x4b, 0x4b, 0x4c, 0x4c, 0x4d, 0x4d,    0,    0, 
	0x52, 0x52, 0x52, 0x52, 0x50,    0,    0,    0, 
	0x57, 0x57, 0x58, 0x58, 0x50,    0,    0,    0, 
	0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 
	0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 
	0x5e, 0x5e, 0x5e, 0x5e, 0x5e, 0x5e, 0x5e, 0x5e, 
	0x5f, 0x5f,    0,    0,    0,    0,    0,    0, 
	0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60,    0,    0, 
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 
	0x61, 0x61, 0x61, 0x61, 0x61, 0x61,    0,    0, 
	0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 
},
{	/* tblwuplow_diff */
	     0,      0,      0,     32,    -32,      0,    743,      0, 
	   121,      0,      0,      1,     -1,      0,      0,   -199, 
	  -232,      0,      0,   -121,   -300,      0,      0,    210, 
	     0,    206,      0,    205,      0,     79,      0,    202, 
	     0,    203,      0,    207,     97,      0,      0,    211, 
	     0,    209,      0,    213,    130,      0,      0,    214, 
	     0,    218,      0,    217,      0,    219,     56,      0, 
	     0,      2,     -1,      1,     -2,      0,    -79,      0, 
	     0,    -97,      0,    -56,      0,   -130,   -210,      0, 
	  -206,      0,   -205,      0,   -202,      0,   -203,      0, 
	  -207,      0,   -209,      0,   -211,      0,   -213,      0, 
	  -214,      0,   -218,      0,   -217,      0,   -219,      0, 
	    84,      0,      0,     38,      0,     37,      0,     64, 
	     0,     63,    -38,      0,    -37,      0,    -31,      0, 
	   -64,      0,    -63,      0,    -62,      0,    -57,      0, 
	   -47,      0,    -54,      0,    -86,      0,    -80,      0, 
	     0,    -60,    -96,      0,      0,     80,      0,     48, 
	   -48,      0,    -59,      0,      8,      0,      0,     -8, 
	    74,      0,     86,      0,    100,      0,    128,      0, 
	   112,      0,    126,      0,      9,      0,      0,    -74, 
	     0,     -9,  -7205,      0,      0,    -86,      0,   -100, 
	     7,      0,      0,   -112,      0,     -7,      0,   -128, 
	     0,   -126,      0,  -7517,      0,  -8383,      0,  -8262, 
	     0,     16,    -16,      0,      0,     26,    -26,      0, 
	     0,     40,    -40,      0, 
},
{	/* lc_ctype_data */
	   0, 0x30,    0, 0x31,    0, 0x32,    0, 0x33, 
	   0, 0x34,    0, 0x35,    0, 0x36,    0, 0x37, 
	   0, 0x38,    0, 0x39,    0, 0xdb, 0xb0,    0, 
	0xdb, 0xb1,    0, 0xdb, 0xb2,    0, 0xdb, 0xb3, 
	   0, 0xdb, 0xb4,    0, 0xdb, 0xb5,    0, 0xdb, 
	0xb6,    0, 0xdb, 0xb7,    0, 0xdb, 0xb8,    0, 
	0xdb, 0xb9,    0, 
},
{	/* lc_numeric_data */
	   0, 0x2e,    0, 0x2c,    0, 0x03,    0, 0x03, 
	0x02,    0, 0xa0,    0, 0xc2, 0xa0,    0, 0x20, 
	   0, 0xd9, 0xab,    0, 0xd9, 0xac,    0, 0x27, 
	   0, 0x02, 0x03,    0, 
},
{	/* lc_monetary_data */
	   0, 0x7f,    0, 0x2d,    0, 0x5a, 0x41, 0x52, 
	0x20,    0, 0x52,    0, 0x2c,    0, 0x2e,    0, 
	0x03,    0, 0x02,    0, 0x01,    0, 0x2d, 0x52, 
	   0, 0x45, 0x54, 0x42, 0x20,    0, 0x24,    0, 
	0x2d, 0x24,    0, 0x41, 0x45, 0x44, 0x20,    0, 
	0xcf, 0x2e, 0xc5, 0x2e,    0, 0x2d, 0xcf, 0x2e, 
	0xc5, 0x2e,    0, 0xd8, 0xaf, 0x2e, 0xd8, 0xa5, 
	0x2e,    0, 0x2d, 0xd8, 0xaf, 0x2e, 0xd8, 0xa5, 
	0x2e,    0, 0x42, 0x48, 0x44, 0x20,    0, 0xcf, 
	0x2e, 0xc8, 0x2e,    0, 0x2d, 0xcf, 0x2e, 0xc8, 
	0x2e,    0, 0xd8, 0xaf, 0x2e, 0xd8, 0xa8, 0x2e, 
	   0, 0x2d, 0xd8, 0xaf, 0x2e, 0xd8, 0xa8, 0x2e, 
	   0, 0x44, 0x5a, 0x44, 0x20,    0, 0xcf, 0x2e, 
	0xcc, 0x2e,    0, 0x2d, 0xcf, 0x2e, 0xcc, 0x2e, 
	   0, 0xd8, 0xaf, 0x2e, 0xd8, 0xac, 0x2e,    0, 
	0x2d, 0xd8, 0xaf, 0x2e, 0xd8, 0xac, 0x2e,    0, 
	0x45, 0x47, 0x50, 0x20,    0, 0xcc, 0x2e, 0xe5, 
	0x2e,    0, 0x2d, 0xcc, 0x2e, 0xe5, 0x2e,    0, 
	0xd8, 0xac, 0x2e, 0xd9, 0x85, 0x2e,    0, 0x2d, 
	0xd8, 0xac, 0x2e, 0xd9, 0x85, 0x2e,    0, 0x49, 
	0x4e, 0x52, 0x20,    0, 0xe2, 0x82, 0xa8,    0, 
	0x03, 0x02,    0, 0x2d, 0xe2, 0x82, 0xa8,    0, 
	0x49, 0x51, 0x44, 0x20,    0, 0xcf, 0x2e, 0xd9, 
	0x2e,    0, 0x2d, 0xcf, 0x2e, 0xd9, 0x2e,    0, 
	0xd8, 0xaf, 0x2e, 0xd8, 0xb9, 0x2e,    0, 0x2d, 
	0xd8, 0xaf, 0x2e, 0xd8, 0xb9, 0x2e,    0, 0x4a, 
	0x4f, 0x44, 0x20,    0, 0xcf, 0x2e, 0xc3, 0x2e, 
	   0, 0x2d, 0xcf, 0x2e, 0xc3, 0x2e,    0, 0xd8, 
	0xaf, 0x2e, 0xd8, 0xa3, 0x2e,    0, 0x2d, 0xd8, 
	0xaf, 0x2e, 0xd8, 0xa3, 0x2e,    0, 0x4b, 0x57, 
	0x44, 0x20,    0, 0xcf, 0x2e, 0xe3, 0x2e,    0, 
	0x2d, 0xcf, 0x2e, 0xe3, 0x2e,    0, 0xd8, 0xaf, 
	0x2e, 0xd9, 0x83, 0x2e,    0, 0x2d, 0xd8, 0xaf, 
	0x2e, 0xd9, 0x83, 0x2e,    0, 0x4c, 0x42, 0x50, 
	0x20,    0, 0xe4, 0x2e, 0xe4, 0x2e,    0, 0x2d, 
	0xe4, 0x2e, 0xe4, 0x2e,    0, 0xd9, 0x84, 0x2e, 
	0xd9, 0x84, 0x2e,    0, 0x2d, 0xd9, 0x84, 0x2e, 
	0xd9, 0x84, 0x2e,    0, 0x4c, 0x59, 0x44, 0x20, 
	   0, 0xcf, 0x2e, 0xe4, 0x2e,    0, 0x2d, 0xcf, 
	0x2e, 0xe4, 0x2e,    0, 0xd8, 0xaf, 0x2e, 0xd9, 
	0x84, 0x2e,    0, 0x2d, 0xd8, 0xaf, 0x2e, 0xd9, 
	0x84, 0x2e,    0, 0x4d, 0x41, 0x44, 0x20,    0, 
	0xcf, 0x2e, 0xe5, 0x2e,    0, 0x2d, 0xcf, 0x2e, 
	0xe5, 0x2e,    0, 0xd8, 0xaf, 0x2e, 0xd9, 0x85, 
	0x2e,    0, 0x2d, 0xd8, 0xaf, 0x2e, 0xd9, 0x85, 
	0x2e,    0, 0x4f, 0x4d, 0x52, 0x20,    0, 0xd1, 
	0x2e, 0xd9, 0x2e,    0, 0x2d, 0xd1, 0x2e, 0xd9, 
	0x2e,    0, 0xd8, 0xb1, 0x2e, 0xd8, 0xb9, 0x2e, 
	   0, 0x2d, 0xd8, 0xb1, 0x2e, 0xd8, 0xb9, 0x2e, 
	   0, 0x51, 0x41, 0x52, 0x20,    0, 0xd1, 0x2e, 
	0xe2, 0x2e,    0, 0x2d, 0xd1, 0x2e, 0xe2, 0x2e, 
	   0, 0xd8, 0xb1, 0x2e, 0xd9, 0x82, 0x2e,    0, 
	0x2d, 0xd8, 0xb1, 0x2e, 0xd9, 0x82, 0x2e,    0, 
	0x53, 0x41, 0x52, 0x20,    0, 0xd1, 0xea, 0xc7, 
	0xe4,    0, 0x2b, 0xd1, 0xea, 0xc7, 0xe4,    0, 
	0xd8, 0xb1, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x84, 
	   0, 0x2b, 0xd8, 0xb1, 0xd9, 0x8a, 0xd8, 0xa7, 
	0xd9, 0x84,    0, 0x53, 0x44, 0x50, 0x20,    0, 
	0xcc, 0x2e, 0xd3, 0x2e,    0, 0x2d, 0xcc, 0x2e, 
	0xd3, 0x2e,    0, 0xd8, 0xac, 0x2e, 0xd8, 0xb3, 
	0x2e,    0, 0x2d, 0xd8, 0xac, 0x2e, 0xd8, 0xb3, 
	0x2e,    0, 0x53, 0x59, 0x50, 0x20,    0, 0xe4, 
	0x2e, 0xd3, 0x2e,    0, 0x2d, 0xe4, 0x2e, 0xd3, 
	0x2e,    0, 0xd9, 0x84, 0x2e, 0xd8, 0xb3, 0x2e, 
	   0, 0x2d, 0xd9, 0x84, 0x2e, 0xd8, 0xb3, 0x2e, 
	   0, 0x54, 0x4e, 0x44, 0x20,    0, 0xcf, 0x2e, 
	0xca, 0x2e,    0, 0x2d, 0xcf, 0x2e, 0xca, 0x2e, 
	   0, 0xd8, 0xaf, 0x2e, 0xd8, 0xaa, 0x2e,    0, 
	0x2d, 0xd8, 0xaf, 0x2e, 0xd8, 0xaa, 0x2e,    0, 
	0x59, 0x45, 0x52, 0x20,    0, 0xd1, 0x2e, 0xea, 
	0x2e,    0, 0x2d, 0xd1, 0x2e, 0xea, 0x2e,    0, 
	0xd8, 0xb1, 0x2e, 0xd9, 0x8a, 0x2e,    0, 0x2d, 
	0xd8, 0xb1, 0x2e, 0xd9, 0x8a, 0x2e,    0, 0x41, 
	0x5a, 0x4d, 0x20,    0, 0x6d, 0x61, 0x6e, 0x2e, 
	   0, 0x20,    0, 0x2b, 0x6d, 0x61, 0x6e, 0x2e, 
	   0, 0x42, 0x59, 0x52, 0x20,    0, 0xf0, 0xf3, 
	0xe1,    0, 0x2b, 0xf0, 0xf3, 0xe1,    0, 0xd1, 
	0x80, 0xd1, 0x83, 0xd0, 0xb1,    0, 0x2b, 0xd1, 
	0x80, 0xd1, 0x83, 0xd0, 0xb1,    0, 0x42, 0x47, 
	0x4c, 0x20,    0, 0xeb, 0xe2,    0, 0xa0,    0, 
	0x2b, 0xeb, 0xe2,    0, 0xd0, 0xbb, 0xd0, 0xb2, 
	   0, 0xc2, 0xa0,    0, 0x2b, 0xd0, 0xbb, 0xd0, 
	0xb2,    0, 0xe0, 0xa7, 0xb3,    0, 0x2d, 0xe0, 
	0xa7, 0xb3,    0, 0xe0, 0xa6, 0x9f, 0xe0, 0xa6, 
	0xbe, 0xe0, 0xa6, 0x95, 0xe0, 0xa6, 0xbe,    0, 
	0x02, 0x03,    0, 0x2d, 0xe0, 0xa6, 0x9f, 0xe0, 
	0xa6, 0xbe, 0xe0, 0xa6, 0x95, 0xe0, 0xa6, 0xbe, 
	   0, 0x45, 0x55, 0x52, 0x20,    0, 0x45, 0x55, 
	0x52,    0, 0x2b, 0x45, 0x55, 0x52,    0, 0xe2, 
	0x82, 0xac,    0, 0x2b, 0xe2, 0x82, 0xac,    0, 
	0x42, 0x41, 0x4b, 0x20,    0, 0x4b, 0x4d,    0, 
	0x2d, 0x4b, 0x4d,    0, 0x2d, 0x45, 0x55, 0x52, 
	   0, 0x2d, 0xe2, 0x82, 0xac,    0, 0xa4,    0, 
	0x2d, 0xa4,    0, 0x43, 0x5a, 0x4b, 0x20,    0, 
	0x4b, 0xe8,    0, 0x2b, 0x4b, 0xe8,    0, 0x4b, 
	0xc4, 0x8d,    0, 0x2b, 0x4b, 0xc4, 0x8d,    0, 
	0x47, 0x42, 0x50, 0x20,    0, 0xa3,    0, 0x2d, 
	0xa3,    0, 0xc2, 0xa3,    0, 0x2d, 0xc2, 0xa3, 
	   0, 0x44, 0x4b, 0x4b, 0x20,    0, 0x6b, 0x72, 
	   0, 0x04,    0, 0x2d, 0x6b, 0x72,    0, 0x43, 
	0x48, 0x46, 0x20,    0, 0x46, 0x72, 0x2e,    0, 
	0x2d, 0x46, 0x72, 0x2e,    0, 0x2b, 0xa4,    0, 
	0x41, 0x55, 0x44, 0x20,    0, 0x42, 0x57, 0x50, 
	0x20,    0, 0x50, 0x75,    0, 0x2d, 0x50, 0x75, 
	   0, 0x43, 0x41, 0x44, 0x20,    0, 0xc2, 0xa4, 
	   0, 0x2d, 0xc2, 0xa4,    0, 0x48, 0x4b, 0x44, 
	0x20,    0, 0x48, 0x4b, 0x24,    0, 0x2d, 0x48, 
	0x4b, 0x24,    0, 0x4e, 0x5a, 0x44, 0x20,    0, 
	0x50, 0x48, 0x50, 0x20,    0, 0x50, 0x68, 0x70, 
	   0, 0x2d, 0x50, 0x68, 0x70,    0, 0x53, 0x47, 
	0x44, 0x20,    0, 0x55, 0x53, 0x44, 0x20,    0, 
	0x5a, 0x57, 0x44, 0x20,    0, 0x5a, 0x24,    0, 
	0x2d, 0x5a, 0x24,    0, 0x2d, 0x45, 0x55, 0x52, 
	0x20,    0, 0x41, 0x52, 0x53, 0x20,    0, 0x42, 
	0x4f, 0x42, 0x20,    0, 0x24, 0x62,    0, 0x2d, 
	0x24, 0x62,    0, 0x43, 0x4c, 0x50, 0x20,    0, 
	0x43, 0x4f, 0x50, 0x20,    0, 0x43, 0x52, 0x43, 
	0x20,    0, 0x43,    0, 0x2d, 0x43,    0, 0x44, 
	0x4f, 0x50, 0x20,    0, 0x45, 0x43, 0x53, 0x20, 
	   0, 0x47, 0x54, 0x51, 0x20,    0, 0x51,    0, 
	0x2d, 0x51,    0, 0x48, 0x4e, 0x4c, 0x20,    0, 
	0x4c, 0x2e,    0, 0x2d, 0x4c, 0x2e,    0, 0x4d, 
	0x58, 0x50, 0x20,    0, 0x4e, 0x49, 0x4f, 0x20, 
	   0, 0x24, 0x43,    0, 0x2d, 0x24, 0x43,    0, 
	0x50, 0x41, 0x42, 0x20,    0, 0x42, 0x2f,    0, 
	0x2d, 0x42, 0x2f,    0, 0x50, 0x45, 0x4e, 0x20, 
	   0, 0x53, 0x2f,    0, 0x2d, 0x53, 0x2f,    0, 
	0x50, 0x59, 0x47, 0x20,    0, 0x47, 0x73, 0x2e, 
	   0, 0x2d, 0x47, 0x73, 0x2e,    0, 0x53, 0x56, 
	0x43, 0x20,    0, 0xa2,    0, 0x2d, 0xa2,    0, 
	0xc2, 0xa2,    0, 0x2d, 0xc2, 0xa2,    0, 0x55, 
	0x59, 0x55, 0x20,    0, 0x4e, 0x24,    0, 0x2d, 
	0x4e, 0x24,    0, 0x56, 0x45, 0x42, 0x20,    0, 
	0x42, 0x73, 0x2e,    0, 0x2d, 0x42, 0x73, 0x2e, 
	   0, 0x45, 0x45, 0x4b, 0x20,    0, 0x49, 0x52, 
	0x52, 0x20,    0, 0xd8, 0xb1, 0xdb, 0x8c, 0xd8, 
	0xa7, 0xd9, 0x84,    0, 0xd9, 0xab,    0, 0xd9, 
	0xac,    0, 0x2b, 0xd8, 0xb1, 0xdb, 0x8c, 0xd8, 
	0xa7, 0xd9, 0x84,    0, 0x2b, 0x24,    0, 0x49, 
	0x4c, 0x53, 0x20,    0, 0xf9, 0xe7,    0, 0x2d, 
	0xf9, 0xe7,    0, 0xd7, 0xa9, 0xd7, 0x97,    0, 
	0x2d, 0xd7, 0xa9, 0xd7, 0x97,    0, 0xe0, 0xa4, 
	0xb0, 0xe0, 0xa5, 0x82,    0, 0x2d, 0xe0, 0xa4, 
	0xb0, 0xe0, 0xa5, 0x82,    0, 0x48, 0x52, 0x4b, 
	0x20,    0, 0x4b, 0x6e,    0, 0x2d, 0x4b, 0x6e, 
	   0, 0x48, 0x55, 0x46, 0x20,    0, 0x46, 0x74, 
	   0, 0x2b, 0x46, 0x74,    0, 0x41, 0x4d, 0x44, 
	0x20,    0, 0xb8,    0, 0x2d, 0xb8,    0, 0xd4, 
	0xb4,    0, 0x2d, 0xd4, 0xb4,    0, 0x49, 0x44, 
	0x52, 0x20,    0, 0x52, 0x70,    0, 0x2d, 0x52, 
	0x70,    0, 0x49, 0x53, 0x4b, 0x20,    0, 0x2b, 
	0x6b, 0x72,    0, 0x4a, 0x50, 0x59, 0x20,    0, 
	0xef, 0xbf, 0xa5,    0, 0x2d, 0xef, 0xbf, 0xa5, 
	   0, 0x47, 0x45, 0x4c, 0x20,    0, 0xcb,    0, 
	0x2d, 0xcb,    0, 0xe1, 0x83, 0x9a,    0, 0x2d, 
	0xe1, 0x83, 0x9a,    0, 0x4b, 0x52, 0x57, 0x20, 
	   0, 0xef, 0xbf, 0xa6,    0, 0x2d, 0xef, 0xbf, 
	0xa6,    0, 0x4c, 0x54, 0x4c, 0x20,    0, 0x4c, 
	0x74,    0, 0x2b, 0x4c, 0x74,    0, 0x4c, 0x56, 
	0x4c, 0x20,    0, 0x4c, 0x73,    0, 0x2d, 0x4c, 
	0x73,    0, 0x4d, 0x4b, 0x44, 0x20,    0, 0xd4, 
	0xd5, 0xdd,    0, 0x2b, 0xd4, 0xd5, 0xdd,    0, 
	0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbd,    0, 0x2b, 
	0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbd,    0, 0xe0, 
	0xa4, 0xb0, 0xe0, 0xa5, 0x81,    0, 0x2d, 0xe0, 
	0xa4, 0xb0, 0xe0, 0xa5, 0x81,    0, 0x4d, 0x59, 
	0x52, 0x20,    0, 0x52, 0x4d,    0, 0x2d, 0x52, 
	0x4d,    0, 0x4d, 0x54, 0x4c, 0x20,    0, 0x4c, 
	0x6d,    0, 0x2d, 0x4c, 0x6d,    0, 0x4e, 0x4f, 
	0x4b, 0x20,    0, 0x50, 0x4c, 0x4e, 0x20,    0, 
	0x5a, 0xb3,    0, 0x2d, 0x5a, 0xb3,    0, 0x5a, 
	0xc5, 0x82,    0, 0x2d, 0x5a, 0xc5, 0x82,    0, 
	0x42, 0x52, 0x4c, 0x20,    0, 0x52, 0x24,    0, 
	0x2b, 0x52, 0x24,    0, 0x52, 0x4f, 0x4c, 0x20, 
	   0, 0x4c, 0x65, 0x69,    0, 0x2d, 0x4c, 0x65, 
	0x69,    0, 0x52, 0x55, 0x52, 0x20,    0, 0xd2, 
	0xd5, 0xc2,    0, 0x2b, 0xd2, 0xd5, 0xc2,    0, 
	0xe0, 0xe3, 0xd1,    0, 0x2b, 0xe0, 0xe3, 0xd1, 
	   0, 0x55, 0x41, 0x48, 0x20,    0, 0xc7, 0xd2, 
	   0, 0x2b, 0xc7, 0xd2,    0, 0xd0, 0xb3, 0xd1, 
	0x80,    0, 0x2b, 0xd0, 0xb3, 0xd1, 0x80,    0, 
	0x20, 0x72, 0x75,    0, 0x2d, 0x20, 0x72, 0x75, 
	   0, 0x53, 0x4b, 0x4b, 0x20,    0, 0x53, 0x6b, 
	   0, 0x2b, 0x53, 0x6b,    0, 0x53, 0x49, 0x54, 
	0x20,    0, 0x53, 0x49, 0x54,    0, 0x2b, 0x53, 
	0x49, 0x54,    0, 0x41, 0x4c, 0x4c, 0x20,    0, 
	0x4c, 0x65, 0x6b,    0, 0x2d, 0x4c, 0x65, 0x6b, 
	   0, 0x59, 0x55, 0x4e, 0x20,    0, 0x64, 0x69, 
	0x6e,    0, 0x2d, 0x64, 0x69, 0x6e,    0, 0xd4, 
	0xd8, 0xdd,    0, 0x2d, 0xd4, 0xd8, 0xdd,    0, 
	0xd0, 0xb4, 0xd0, 0xb8, 0xd0, 0xbd,    0, 0x2d, 
	0xd0, 0xb4, 0xd0, 0xb8, 0xd0, 0xbd,    0, 0x53, 
	0x45, 0x4b, 0x20,    0, 0x54, 0x48, 0x42, 0x20, 
	   0, 0xdf,    0, 0x2d, 0xdf,    0, 0xe0, 0xb8, 
	0xbf,    0, 0x2d, 0xe0, 0xb8, 0xbf,    0, 0x45, 
	0x52, 0x42, 0x20,    0, 0x50, 0x68, 0x50,    0, 
	0x2d, 0x50, 0x68, 0x50,    0, 0x54, 0x52, 0x4c, 
	0x20,    0, 0x54, 0x4c,    0, 0x2b, 0x54, 0x4c, 
	   0, 0x50, 0x4b, 0x52, 0x20,    0, 0x52, 0x73, 
	   0, 0x2d, 0x52, 0x73,    0, 0x55, 0x5a, 0x53, 
	0x20,    0, 0x73, 0x6f, 0x27, 0x6d,    0, 0x2d, 
	0x73, 0x6f, 0x27, 0x6d,    0, 0x56, 0x4e, 0x44, 
	0x20,    0, 0xe2, 0x82, 0xab,    0, 0x2b, 0xe2, 
	0x82, 0xab,    0, 0x43, 0x4e, 0x59, 0x20,    0, 
	0x54, 0x57, 0x44, 0x20,    0, 0x4e, 0x54, 0x24, 
	   0, 0x2d, 0x4e, 0x54, 0x24,    0, 
},
{	/* lc_time_data */
	   0, 0x53, 0x75, 0x6e,    0, 0x4d, 0x6f, 0x6e, 
	   0, 0x54, 0x75, 0x65,    0, 0x57, 0x65, 0x64, 
	   0, 0x54, 0x68, 0x75,    0, 0x46, 0x72, 0x69, 
	   0, 0x53, 0x61, 0x74,    0, 0x53, 0x75, 0x6e, 
	0x64, 0x61, 0x79,    0, 0x4d, 0x6f, 0x6e, 0x64, 
	0x61, 0x79,    0, 0x54, 0x75, 0x65, 0x73, 0x64, 
	0x61, 0x79,    0, 0x57, 0x65, 0x64, 0x6e, 0x65, 
	0x73, 0x64, 0x61, 0x79,    0, 0x54, 0x68, 0x75, 
	0x72, 0x73, 0x64, 0x61, 0x79,    0, 0x46, 0x72, 
	0x69, 0x64, 0x61, 0x79,    0, 0x53, 0x61, 0x74, 
	0x75, 0x72, 0x64, 0x61, 0x79,    0, 0x4a, 0x61, 
	0x6e,    0, 0x46, 0x65, 0x62,    0, 0x4d, 0x61, 
	0x72,    0, 0x41, 0x70, 0x72,    0, 0x4d, 0x61, 
	0x79,    0, 0x4a, 0x75, 0x6e,    0, 0x4a, 0x75, 
	0x6c,    0, 0x41, 0x75, 0x67,    0, 0x53, 0x65, 
	0x70,    0, 0x4f, 0x63, 0x74,    0, 0x4e, 0x6f, 
	0x76,    0, 0x44, 0x65, 0x63,    0, 0x4a, 0x61, 
	0x6e, 0x75, 0x61, 0x72, 0x79,    0, 0x46, 0x65, 
	0x62, 0x72, 0x75, 0x61, 0x72, 0x79,    0, 0x4d, 
	0x61, 0x72, 0x63, 0x68,    0, 0x41, 0x70, 0x72, 
	0x69, 0x6c,    0, 0x4a, 0x75, 0x6e, 0x65,    0, 
	0x4a, 0x75, 0x6c, 0x79,    0, 0x41, 0x75, 0x67, 
	0x75, 0x73, 0x74,    0, 0x53, 0x65, 0x70, 0x74, 
	0x65, 0x6d, 0x62, 0x65, 0x72,    0, 0x4f, 0x63, 
	0x74, 0x6f, 0x62, 0x65, 0x72,    0, 0x4e, 0x6f, 
	0x76, 0x65, 0x6d, 0x62, 0x65, 0x72,    0, 0x44, 
	0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72,    0, 
	0x41, 0x4d,    0, 0x50, 0x4d,    0, 0x25, 0x61, 
	0x20, 0x25, 0x62, 0x20, 0x25, 0x65, 0x20, 0x25, 
	0x48, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 
	0x25, 0x59,    0, 0x25, 0x6d, 0x2f, 0x25, 0x64, 
	0x2f, 0x25, 0x79,    0, 0x25, 0x48, 0x3a, 0x25, 
	0x4d, 0x3a, 0x25, 0x53,    0, 0x25, 0x49, 0x3a, 
	0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 0x25, 0x70, 
	   0, 0x53, 0x6f,    0, 0x4d, 0x61,    0, 0x44, 
	0x69,    0, 0x57, 0x6f,    0, 0x44, 0x6f,    0, 
	0x56, 0x72,    0, 0x53, 0x61,    0, 0x53, 0x6f, 
	0x6e, 0x64, 0x61, 0x67,    0, 0x4d, 0x61, 0x61, 
	0x6e, 0x64, 0x61, 0x67,    0, 0x44, 0x69, 0x6e, 
	0x73, 0x64, 0x61, 0x67,    0, 0x57, 0x6f, 0x65, 
	0x6e, 0x73, 0x64, 0x61, 0x67,    0, 0x44, 0x6f, 
	0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67,    0, 
	0x56, 0x72, 0x79, 0x64, 0x61, 0x67,    0, 0x53, 
	0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67,    0, 
	0x4d, 0x65, 0x69,    0, 0x4f, 0x6b, 0x74,    0, 
	0x44, 0x65, 0x73,    0, 0x4a, 0x61, 0x6e, 0x75, 
	0x61, 0x72, 0x69, 0x65,    0, 0x46, 0x65, 0x62, 
	0x72, 0x75, 0x61, 0x72, 0x69, 0x65,    0, 0x4d, 
	0x61, 0x61, 0x72, 0x74,    0, 0x4a, 0x75, 0x6e, 
	0x69, 0x65,    0, 0x4a, 0x75, 0x6c, 0x69, 0x65, 
	   0, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 
	0x73,    0, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 
	0x72,    0, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 
	0x65, 0x72,    0, 0x56, 0x4d,    0, 0x4e, 0x4d, 
	   0, 0x25, 0x61, 0x20, 0x25, 0x64, 0x20, 0x25, 
	0x62, 0x20, 0x25, 0x59, 0x20, 0x25, 0x54, 0x20, 
	0x25, 0x5a,    0, 0x25, 0x64, 0x2f, 0x25, 0x6d, 
	0x2f, 0x25, 0x79,    0, 0x25, 0x54,    0, 0xe1, 
	0x8a, 0xa5, 0xe1, 0x88, 0x91, 0xe1, 0x8b, 0xb5, 
	   0, 0xe1, 0x88, 0xb0, 0xe1, 0x8a, 0x9e,    0, 
	0xe1, 0x88, 0x9b, 0xe1, 0x8a, 0xad, 0xe1, 0x88, 
	0xb0, 0xe1, 0x8a, 0x9e,    0, 0xe1, 0x88, 0xa8, 
	0xe1, 0x89, 0xa1, 0xe1, 0x8b, 0x95,    0, 0xe1, 
	0x88, 0x90, 0xe1, 0x88, 0x99, 0xe1, 0x88, 0xb5, 
	   0, 0xe1, 0x8b, 0x93, 0xe1, 0x88, 0xad, 0xe1, 
	0x89, 0xa5,    0, 0xe1, 0x89, 0x85, 0xe1, 0x8b, 
	0xb3, 0xe1, 0x88, 0x9c,    0, 0xe1, 0x8c, 0x83, 
	0xe1, 0x8a, 0x95, 0xe1, 0x8b, 0xa9,    0, 0xe1, 
	0x8d, 0x8c, 0xe1, 0x89, 0xa5, 0xe1, 0x88, 0xa9, 
	   0, 0xe1, 0x88, 0x9b, 0xe1, 0x88, 0xad, 0xe1, 
	0x89, 0xbd,    0, 0xe1, 0x8a, 0xa4, 0xe1, 0x8d, 
	0x95, 0xe1, 0x88, 0xa8,    0, 0xe1, 0x88, 0x9c, 
	0xe1, 0x8b, 0xad,    0, 0xe1, 0x8c, 0x81, 0xe1, 
	0x8a, 0x95,    0, 0xe1, 0x8c, 0x81, 0xe1, 0x88, 
	0x8b, 0xe1, 0x8b, 0xad,    0, 0xe1, 0x8a, 0xa6, 
	0xe1, 0x8c, 0x88, 0xe1, 0x88, 0xb5,    0, 0xe1, 
	0x88, 0xb4, 0xe1, 0x8d, 0x95, 0xe1, 0x89, 0xb4, 
	   0, 0xe1, 0x8a, 0xa6, 0xe1, 0x8a, 0xad, 0xe1, 
	0x89, 0xb0,    0, 0xe1, 0x8a, 0x96, 0xe1, 0x89, 
	0xac, 0xe1, 0x88, 0x9d,    0, 0xe1, 0x8b, 0xb2, 
	0xe1, 0x88, 0xb4, 0xe1, 0x88, 0x9d,    0, 0xe1, 
	0x8c, 0x83, 0xe1, 0x8a, 0x95, 0xe1, 0x8b, 0xa9, 
	0xe1, 0x8b, 0x88, 0xe1, 0x88, 0xaa,    0, 0xe1, 
	0x8d, 0x8c, 0xe1, 0x89, 0xa5, 0xe1, 0x88, 0xa9, 
	0xe1, 0x8b, 0x88, 0xe1, 0x88, 0xaa,    0, 0xe1, 
	0x8a, 0xa4, 0xe1, 0x8d, 0x95, 0xe1, 0x88, 0xa8, 
	0xe1, 0x88, 0x8d,    0, 0xe1, 0x8a, 0xa6, 0xe1, 
	0x8c, 0x88, 0xe1, 0x88, 0xb5, 0xe1, 0x89, 0xb5, 
	   0, 0xe1, 0x88, 0xb4, 0xe1, 0x8d, 0x95, 0xe1, 
	0x89, 0xb4, 0xe1, 0x88, 0x9d, 0xe1, 0x89, 0xa0, 
	0xe1, 0x88, 0xad,    0, 0xe1, 0x8a, 0xa6, 0xe1, 
	0x8a, 0xad, 0xe1, 0x89, 0xb0, 0xe1, 0x8b, 0x8d, 
	0xe1, 0x89, 0xa0, 0xe1, 0x88, 0xad,    0, 0xe1, 
	0x8a, 0x96, 0xe1, 0x89, 0xac, 0xe1, 0x88, 0x9d, 
	0xe1, 0x89, 0xa0, 0xe1, 0x88, 0xad,    0, 0xe1, 
	0x8b, 0xb2, 0xe1, 0x88, 0xb4, 0xe1, 0x88, 0x9d, 
	0xe1, 0x89, 0xa0, 0xe1, 0x88, 0xad,    0, 0xe1, 
	0x8c, 0xa0, 0xe1, 0x8b, 0x8b, 0xe1, 0x89, 0xb5, 
	   0, 0xe1, 0x8a, 0xa8, 0xe1, 0x88, 0xb3, 0xe1, 
	0x8b, 0x93, 0xe1, 0x89, 0xb5,    0, 0x25, 0x41, 
	0xe1, 0x8d, 0xa3, 0x20, 0x25, 0x62, 0x20, 0x25, 
	0x65, 0x20, 0xe1, 0x89, 0x80, 0xe1, 0x8a, 0x95, 
	0x20, 0x25, 0x6c, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 
	0x53, 0x20, 0x25, 0x5a, 0x20, 0x25, 0x59,    0, 
	0x25, 0x64, 0x2f, 0x25, 0x6d, 0x2f, 0x25, 0x59, 
	   0, 0x25, 0x72,    0, 0xcd,    0, 0xe6,    0, 
	0xcb,    0, 0xd1,    0, 0xce,    0, 0xcc,    0, 
	0xd3,    0, 0xc7, 0xe4, 0xc3, 0xcd, 0xcf,    0, 
	0xc7, 0xe4, 0xc7, 0xcb, 0xe6, 0xea, 0xe6,    0, 
	0xc7, 0xe4, 0xcb, 0xe4, 0xc7, 0xcb, 0xc7, 0xc1, 
	   0, 0xc7, 0xe4, 0xc3, 0xd1, 0xc8, 0xd9, 0xc7, 
	0xc1,    0, 0xc7, 0xe4, 0xce, 0xe5, 0xea, 0xd3, 
	   0, 0xc7, 0xe4, 0xcc, 0xe5, 0xd9, 0xc9,    0, 
	0xc7, 0xe4, 0xd3, 0xc8, 0xca, 0x20,    0, 0xea, 
	0xe6, 0xc7,    0, 0xe1, 0xc8, 0xd1,    0, 0xe5, 
	0xc7, 0xd1,    0, 0xc3, 0xc8, 0xd1,    0, 0xe5, 
	0xc7, 0xea,    0, 0xea, 0xe8, 0xe6,    0, 0xea, 
	0xe8, 0xe4,    0, 0xc3, 0xda, 0xd3,    0, 0xd3, 
	0xc8, 0xca,    0, 0xc3, 0xe3, 0xca,    0, 0xe6, 
	0xe8, 0xe1,    0, 0xcf, 0xea, 0xd3,    0, 0xea, 
	0xe6, 0xc7, 0xea, 0xd1,    0, 0xe1, 0xc8, 0xd1, 
	0xc7, 0xea, 0xd1,    0, 0xe5, 0xc7, 0xd1, 0xd3, 
	   0, 0xc3, 0xc8, 0xd1, 0xea, 0xe4,    0, 0xe5, 
	0xc7, 0xea, 0xe8,    0, 0xea, 0xe8, 0xe6, 0xea, 
	0xe8,    0, 0xea, 0xe8, 0xe4, 0xea, 0xe8,    0, 
	0xc3, 0xda, 0xd3, 0xd7, 0xd3,    0, 0xd3, 0xc8, 
	0xca, 0xe5, 0xc8, 0xd1,    0, 0xc3, 0xe3, 0xca, 
	0xe8, 0xc8, 0xd1,    0, 0xe6, 0xe8, 0xe1, 0xe5, 
	0xc8, 0xd1,    0, 0xcf, 0xea, 0xd3, 0xe5, 0xc8, 
	0xd1,    0, 0xd5,    0, 0xe5,    0, 0x25, 0x64, 
	0x20, 0x25, 0x62, 0x2c, 0x20, 0x25, 0x59, 0x20, 
	0x25, 0x5a, 0x20, 0x25, 0x49, 0x3a, 0x25, 0x4d, 
	0x3a, 0x25, 0x53, 0x20, 0x25, 0x70,    0, 0x25, 
	0x64, 0x20, 0x25, 0x62, 0x2c, 0x20, 0x25, 0x59, 
	   0, 0x25, 0x5a, 0x20, 0x25, 0x49, 0x3a, 0x25, 
	0x4d, 0x3a, 0x25, 0x53, 0x20,    0, 0x25, 0x5a, 
	0x20, 0x25, 0x49, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 
	0x53, 0x20, 0x25, 0x70,    0, 0xd8, 0xad,    0, 
	0xd9, 0x86,    0, 0xd8, 0xab,    0, 0xd8, 0xb1, 
	   0, 0xd8, 0xae,    0, 0xd8, 0xac,    0, 0xd8, 
	0xb3,    0, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 
	0xd8, 0xad, 0xd8, 0xaf,    0, 0xd8, 0xa7, 0xd9, 
	0x84, 0xd8, 0xa7, 0xd8, 0xab, 0xd9, 0x86, 0xd9, 
	0x8a, 0xd9, 0x86,    0, 0xd8, 0xa7, 0xd9, 0x84, 
	0xd8, 0xab, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xab, 
	0xd8, 0xa7, 0xd8, 0xa1,    0, 0xd8, 0xa7, 0xd9, 
	0x84, 0xd8, 0xa3, 0xd8, 0xb1, 0xd8, 0xa8, 0xd8, 
	0xb9, 0xd8, 0xa7, 0xd8, 0xa1,    0, 0xd8, 0xa7, 
	0xd9, 0x84, 0xd8, 0xae, 0xd9, 0x85, 0xd9, 0x8a, 
	0xd8, 0xb3,    0, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 
	0xac, 0xd9, 0x85, 0xd8, 0xb9, 0xd8, 0xa9,    0, 
	0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd8, 0xa8, 
	0xd8, 0xaa, 0x20,    0, 0xd9, 0x8a, 0xd9, 0x86, 
	0xd8, 0xa7,    0, 0xd9, 0x81, 0xd8, 0xa8, 0xd8, 
	0xb1,    0, 0xd9, 0x85, 0xd8, 0xa7, 0xd8, 0xb1, 
	   0, 0xd8, 0xa3, 0xd8, 0xa8, 0xd8, 0xb1,    0, 
	0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x8a,    0, 0xd9, 
	0x8a, 0xd9, 0x88, 0xd9, 0x86,    0, 0xd9, 0x8a, 
	0xd9, 0x88, 0xd9, 0x84,    0, 0xd8, 0xa3, 0xd8, 
	0xba, 0xd8, 0xb3,    0, 0xd8, 0xb3, 0xd8, 0xa8, 
	0xd8, 0xaa,    0, 0xd8, 0xa3, 0xd9, 0x83, 0xd8, 
	0xaa,    0, 0xd9, 0x86, 0xd9, 0x88, 0xd9, 0x81, 
	   0, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xb3,    0, 
	0xd9, 0x8a, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x8a, 
	0xd8, 0xb1,    0, 0xd9, 0x81, 0xd8, 0xa8, 0xd8, 
	0xb1, 0xd8, 0xa7, 0xd9, 0x8a, 0xd8, 0xb1,    0, 
	0xd9, 0x85, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xb3, 
	   0, 0xd8, 0xa3, 0xd8, 0xa8, 0xd8, 0xb1, 0xd9, 
	0x8a, 0xd9, 0x84,    0, 0xd9, 0x85, 0xd8, 0xa7, 
	0xd9, 0x8a, 0xd9, 0x88,    0, 0xd9, 0x8a, 0xd9, 
	0x88, 0xd9, 0x86, 0xd9, 0x8a, 0xd9, 0x88,    0, 
	0xd9, 0x8a, 0xd9, 0x88, 0xd9, 0x84, 0xd9, 0x8a, 
	0xd9, 0x88,    0, 0xd8, 0xa3, 0xd8, 0xba, 0xd8, 
	0xb3, 0xd8, 0xb7, 0xd8, 0xb3,    0, 0xd8, 0xb3, 
	0xd8, 0xa8, 0xd8, 0xaa, 0xd9, 0x85, 0xd8, 0xa8, 
	0xd8, 0xb1,    0, 0xd8, 0xa3, 0xd9, 0x83, 0xd8, 
	0xaa, 0xd9, 0x88, 0xd8, 0xa8, 0xd8, 0xb1,    0, 
	0xd9, 0x86, 0xd9, 0x88, 0xd9, 0x81, 0xd9, 0x85, 
	0xd8, 0xa8, 0xd8, 0xb1,    0, 0xd8, 0xaf, 0xd9, 
	0x8a, 0xd8, 0xb3, 0xd9, 0x85, 0xd8, 0xa8, 0xd8, 
	0xb1,    0, 0xd8, 0xb5,    0, 0xd9, 0x85,    0, 
	0xc7, 0xe4, 0xd3, 0xc8, 0xca,    0, 0xd8, 0xa7, 
	0xd9, 0x84, 0xd8, 0xb3, 0xd8, 0xa8, 0xd8, 0xaa, 
	   0, 0x25, 0x41, 0x20, 0x25, 0x64, 0x20, 0x25, 
	0x42, 0x20, 0x25, 0x59, 0x20, 0x25, 0x49, 0x3a, 
	0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 0x25, 0x70, 
	0x20, 0x25, 0x5a,    0, 0x25, 0x41, 0x20, 0x25, 
	0x64, 0x20, 0x25, 0x42, 0x20, 0x25, 0x59,    0, 
	0x25, 0x49, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53, 
	0x20, 0x20, 0x25, 0x5a,    0, 0x25, 0x49, 0x3a, 
	0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 0x25, 0x70, 
	0x20, 0x25, 0x5a,    0, 0xe3, 0xc7, 0xe6, 0xe8, 
	0xe6, 0x20, 0xc7, 0xe4, 0xcb, 0xc7, 0xe6, 0xea, 
	   0, 0xd4, 0xc8, 0xc7, 0xd7,    0, 0xc2, 0xd0, 
	0xc7, 0xd1,    0, 0xe6, 0xea, 0xd3, 0xc7, 0xe6, 
	   0, 0xe6, 0xe8, 0xc7, 0xd1,    0, 0xcd, 0xd2, 
	0xea, 0xd1, 0xc7, 0xe6,    0, 0xca, 0xe5, 0xe8, 
	0xd2,    0, 0xc2, 0xc8,    0, 0xc3, 0xea, 0xe4, 
	0xe8, 0xe4,    0, 0xca, 0xd4, 0xd1, 0xea, 0xe6, 
	0x20, 0xc7, 0xe4, 0xc3, 0xe8, 0xe4,    0, 0xca, 
	0xd4, 0xd1, 0xea, 0xe6, 0x20, 0xc7, 0xe4, 0xcb, 
	0xc7, 0xe6, 0xea,    0, 0xe3, 0xc7, 0xe6, 0xe8, 
	0xe6, 0x20, 0xc7, 0xe4, 0xc3, 0xe8, 0xe4,    0, 
	0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x86, 0xd9, 0x88, 
	0xd9, 0x86, 0x20, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 
	0xab, 0xd8, 0xa7, 0xd9, 0x86, 0xd9, 0x8a,    0, 
	0xd8, 0xb4, 0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xb7, 
	   0, 0xd8, 0xa2, 0xd8, 0xb0, 0xd8, 0xa7, 0xd8, 
	0xb1,    0, 0xd9, 0x86, 0xd9, 0x8a, 0xd8, 0xb3, 
	0xd8, 0xa7, 0xd9, 0x86,    0, 0xd9, 0x86, 0xd9, 
	0x88, 0xd8, 0xa7, 0xd8, 0xb1,    0, 0xd8, 0xad, 
	0xd8, 0xb2, 0xd9, 0x8a, 0xd8, 0xb1, 0xd8, 0xa7, 
	0xd9, 0x86,    0, 0xd8, 0xaa, 0xd9, 0x85, 0xd9, 
	0x88, 0xd8, 0xb2,    0, 0xd8, 0xa2, 0xd8, 0xa8, 
	   0, 0xd8, 0xa3, 0xd9, 0x8a, 0xd9, 0x84, 0xd9, 
	0x88, 0xd9, 0x84,    0, 0xd8, 0xaa, 0xd8, 0xb4, 
	0xd8, 0xb1, 0xd9, 0x8a, 0xd9, 0x86, 0x20, 0xd8, 
	0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd9, 0x88, 0xd9, 
	0x84,    0, 0xd8, 0xaa, 0xd8, 0xb4, 0xd8, 0xb1, 
	0xd9, 0x8a, 0xd9, 0x86, 0x20, 0xd8, 0xa7, 0xd9, 
	0x84, 0xd8, 0xab, 0xd8, 0xa7, 0xd9, 0x86, 0xd9, 
	0x8a,    0, 0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x86, 
	0xd9, 0x88, 0xd9, 0x86, 0x20, 0xd8, 0xa7, 0xd9, 
	0x84, 0xd8, 0xa3, 0xd9, 0x88, 0xd9, 0x84,    0, 
	0xc7, 0xe4, 0xc5, 0xcb, 0xe6, 0xea, 0xe6,    0, 
	0xc7, 0xe4, 0xcc, 0xe5, 0xd9, 0xe0, 0xc9,    0, 
	0xe6, 0xea, 0xd3, 0xe0, 0xc7, 0xe6,    0, 0xc3, 
	0xea, 0xc7, 0xd1,    0, 0xca, 0xe0, 0xe5, 0xe0, 
	0xe8, 0xd2,    0, 0x25, 0x41, 0x20, 0x25, 0x2e, 
	0x31, 0x64, 0x20, 0x25, 0x42, 0x20, 0x25, 0x59, 
	0x20, 0x20, 0x25, 0x2e, 0x31, 0x48, 0x3a, 0x25, 
	0x4d, 0x3a, 0x25, 0x53,    0, 0x25, 0x41, 0x20, 
	0x25, 0x2e, 0x31, 0x64, 0x20, 0x25, 0x42, 0x20, 
	0x25, 0x59,    0, 0x25, 0x2e, 0x31, 0x48, 0x3a, 
	0x25, 0x4d, 0x3a, 0x25, 0x53,    0, 0xd8, 0xa7, 
	0xd9, 0x84, 0xd8, 0xa5, 0xd8, 0xab, 0xd9, 0x86, 
	0xd9, 0x8a, 0xd9, 0x86,    0, 0xd8, 0xa7, 0xd9, 
	0x84, 0xd8, 0xac, 0xd9, 0x85, 0xd8, 0xb9, 0xd9, 
	0x80, 0xd8, 0xa9,    0, 0xd9, 0x86, 0xd9, 0x8a, 
	0xd8, 0xb3, 0xd9, 0x80, 0xd8, 0xa7, 0xd9, 0x86, 
	   0, 0xd8, 0xa3, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 
	0xb1,    0, 0xd8, 0xaa, 0xd9, 0x80, 0xd9, 0x85, 
	0xd9, 0x80, 0xd9, 0x88, 0xd8, 0xb2,    0, 0xe6, 
	0xe8, 0xc7, 0xd1, 0xc7, 0xe6,    0, 0xcd, 0xd2, 
	0xea, 0xd1,    0, 0xd9, 0x86, 0xd9, 0x88, 0xd8, 
	0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x86,    0, 
	0xd8, 0xad, 0xd8, 0xb2, 0xd9, 0x8a, 0xd8, 0xb1, 
	   0, 0x62, 0x61, 0x7a,    0, 0x62, 0x69, 0x72, 
	   0, 0x69, 0x6b, 0x69,    0, 0xfc, 0xe7, 0xfc, 
	   0, 0x64, 0xf6, 0x72,    0, 0x62, 0x65, 0xfe, 
	   0, 0x61, 0x6c, 0x74,    0, 0x62, 0x61, 0x7a, 
	0x61, 0x72, 0x20, 0x67, 0xfc, 0x6e, 0xfc,    0, 
	0x62, 0x69, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x20, 
	0x67, 0xfc, 0x6e,    0, 0x69, 0x6b, 0x69, 0x6e, 
	0x63, 0x69, 0x20, 0x67, 0xfc, 0x6e,    0, 0xfc, 
	0xe7, 0xfc, 0x6e, 0x63, 0xfc, 0x20, 0x67, 0xfc, 
	0x6e,    0, 0x64, 0xf6, 0x72, 0x64, 0xfc, 0x6e, 
	0x63, 0xfc, 0x20, 0x67, 0xfc, 0x6e,    0, 0x62, 
	0x65, 0xfe, 0x69, 0x6e, 0x63, 0x69, 0x20, 0x67, 
	0xfc, 0x6e,    0, 0x61, 0x6c, 0x74, 0xfd, 0x6e, 
	0x63, 0xfd, 0x20, 0x67, 0xfc, 0x6e,    0, 0x59, 
	0x61, 0x6e,    0, 0x46, 0x65, 0x76,    0, 0xdd, 
	0x79, 0x6e,    0, 0xdd, 0x79, 0x6c,    0, 0x41, 
	0x76, 0x71,    0, 0x53, 0x65, 0x6e,    0, 0x4e, 
	0x6f, 0x79,    0, 0x44, 0x65, 0x6b,    0, 0x79, 
	0x61, 0x6e, 0x76, 0x61, 0x72,    0, 0x66, 0x65, 
	0x76, 0x72, 0x61, 0x6c,    0, 0x6d, 0x61, 0x72, 
	0x74,    0, 0x61, 0x70, 0x72, 0x65, 0x6c,    0, 
	0x6d, 0x61, 0x79,    0, 0x69, 0x79, 0x75, 0x6e, 
	   0, 0x69, 0x79, 0x75, 0x6c,    0, 0x61, 0x76, 
	0x71, 0x75, 0x73, 0x74,    0, 0x73, 0x65, 0x6e, 
	0x74, 0x79, 0x61, 0x62, 0x72,    0, 0x6f, 0x6b, 
	0x74, 0x79, 0x61, 0x62, 0x72,    0, 0x6e, 0x6f, 
	0x79, 0x61, 0x62, 0x72,    0, 0x64, 0x65, 0x6b, 
	0x61, 0x62, 0x72,    0, 0x25, 0x41, 0x2c, 0x20, 
	0x25, 0x64, 0x20, 0x25, 0x42, 0x20, 0x25, 0x59, 
	0x20, 0x25, 0x54,    0, 0x25, 0x64, 0x2e, 0x25, 
	0x6d, 0x2e, 0x25, 0x59,    0, 0xc3, 0xbc, 0xc3, 
	0xa7, 0xc3, 0xbc,    0, 0x64, 0xc3, 0xb6, 0x72, 
	   0, 0x62, 0x65, 0xc5, 0x9f,    0, 0x62, 0x61, 
	0x7a, 0x61, 0x72, 0x20, 0x67, 0xc3, 0xbc, 0x6e, 
	0xc3, 0xbc,    0, 0x62, 0x69, 0x72, 0x69, 0x6e, 
	0x63, 0x69, 0x20, 0x67, 0xc3, 0xbc, 0x6e,    0, 
	0x69, 0x6b, 0x69, 0x6e, 0x63, 0x69, 0x20, 0x67, 
	0xc3, 0xbc, 0x6e,    0, 0xc3, 0xbc, 0xc3, 0xa7, 
	0xc3, 0xbc, 0x6e, 0x63, 0xc3, 0xbc, 0x20, 0x67, 
	0xc3, 0xbc, 0x6e,    0, 0x64, 0xc3, 0xb6, 0x72, 
	0x64, 0xc3, 0xbc, 0x6e, 0x63, 0xc3, 0xbc, 0x20, 
	0x67, 0xc3, 0xbc, 0x6e,    0, 0x62, 0x65, 0xc5, 
	0x9f, 0x69, 0x6e, 0x63, 0x69, 0x20, 0x67, 0xc3, 
	0xbc, 0x6e,    0, 0x61, 0x6c, 0x74, 0xc4, 0xb1, 
	0x6e, 0x63, 0xc4, 0xb1, 0x20, 0x67, 0xc3, 0xbc, 
	0x6e,    0, 0xc4, 0xb0, 0x79, 0x6e,    0, 0xc4, 
	0xb0, 0x79, 0x6c,    0, 0xcd, 0xff, 0xe4,    0, 
	0xcf, 0xe0, 0xed,    0, 0xc0, 0xa2, 0xf2,    0, 
	0xd1, 0xf0, 0xe4,    0, 0xd7, 0xf6, 0xe2,    0, 
	0xcf, 0xff, 0xf2,    0, 0xd1, 0xf3, 0xe1,    0, 
	0xcd, 0xff, 0xe4, 0xe7, 0xe5, 0xeb, 0xff,    0, 
	0xcf, 0xe0, 0xed, 0xff, 0xe4, 0xe7, 0xe5, 0xeb, 
	0xe0, 0xea,    0, 0xc0, 0xa2, 0xf2, 0xee, 0xf0, 
	0xe0, 0xea,    0, 0xd1, 0xe5, 0xf0, 0xe0, 0xe4, 
	0xe0,    0, 0xd7, 0xe0, 0xf6, 0xe2, 0xe5, 0xf0, 
	   0, 0xcf, 0xff, 0xf2, 0xed, 0xb3, 0xf6, 0xe0, 
	   0, 0xd1, 0xf3, 0xe1, 0xee, 0xf2, 0xe0,    0, 
	0xd1, 0xf2, 0xe4,    0, 0xcb, 0xfe, 0xf2,    0, 
	0xd1, 0xe0, 0xea,    0, 0xca, 0xf0, 0xf1,    0, 
	0xd2, 0xf0, 0xe0,    0, 0xd7, 0xfd, 0xf0,    0, 
	0xcb, 0xb3, 0xef,    0, 0xc6, 0xed, 0xe2,    0, 
	0xc2, 0xf0, 0xf1,    0, 0xca, 0xf1, 0xf2,    0, 
	0xcb, 0xb3, 0xf1,    0, 0xd1, 0xed, 0xe6,    0, 
	0xd1, 0xf2, 0xf3, 0xe4, 0xe7, 0xe5, 0xed, 0xfc, 
	   0, 0xcb, 0xfe, 0xf2, 0xfb,    0, 0xd1, 0xe0, 
	0xea, 0xe0, 0xe2, 0xb3, 0xea,    0, 0xca, 0xf0, 
	0xe0, 0xf1, 0xe0, 0xe2, 0xb3, 0xea,    0, 0xd2, 
	0xf0, 0xe0, 0xe2, 0xe5, 0xed, 0xfc,    0, 0xd7, 
	0xfd, 0xf0, 0xe2, 0xe5, 0xed, 0xfc,    0, 0xcb, 
	0xb3, 0xef, 0xe5, 0xed, 0xfc,    0, 0xc6, 0xed, 
	0xb3, 0xe2, 0xe5, 0xed, 0xfc,    0, 0xc2, 0xe5, 
	0xf0, 0xe0, 0xf1, 0xe5, 0xed, 0xfc,    0, 0xca, 
	0xe0, 0xf1, 0xf2, 0xf0, 0xfb, 0xf7, 0xed, 0xb3, 
	0xea,    0, 0xcb, 0xb3, 0xf1, 0xf2, 0xe0, 0xef, 
	0xe0, 0xe4,    0, 0xd1, 0xed, 0xe5, 0xe6, 0xe0, 
	0xed, 0xfc,    0, 0x25, 0x61, 0x20, 0x25, 0x64, 
	0x20, 0x25, 0x62, 0x20, 0x25, 0x59, 0x20, 0x25, 
	0x54,    0, 0xd0, 0x9d, 0xd1, 0x8f, 0xd0, 0xb4, 
	   0, 0xd0, 0x9f, 0xd0, 0xb0, 0xd0, 0xbd,    0, 
	0xd0, 0x90, 0xd1, 0x9e, 0xd1, 0x82,    0, 0xd0, 
	0xa1, 0xd1, 0x80, 0xd0, 0xb4,    0, 0xd0, 0xa7, 
	0xd1, 0x86, 0xd0, 0xb2,    0, 0xd0, 0x9f, 0xd1, 
	0x8f, 0xd1, 0x82,    0, 0xd0, 0xa1, 0xd1, 0x83, 
	0xd0, 0xb1,    0, 0xd0, 0x9d, 0xd1, 0x8f, 0xd0, 
	0xb4, 0xd0, 0xb7, 0xd0, 0xb5, 0xd0, 0xbb, 0xd1, 
	0x8f,    0, 0xd0, 0x9f, 0xd0, 0xb0, 0xd0, 0xbd, 
	0xd1, 0x8f, 0xd0, 0xb4, 0xd0, 0xb7, 0xd0, 0xb5, 
	0xd0, 0xbb, 0xd0, 0xb0, 0xd0, 0xba,    0, 0xd0, 
	0x90, 0xd1, 0x9e, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 
	0x80, 0xd0, 0xb0, 0xd0, 0xba,    0, 0xd0, 0xa1, 
	0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb4, 
	0xd0, 0xb0,    0, 0xd0, 0xa7, 0xd0, 0xb0, 0xd1, 
	0x86, 0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x80,    0, 
	0xd0, 0x9f, 0xd1, 0x8f, 0xd1, 0x82, 0xd0, 0xbd, 
	0xd1, 0x96, 0xd1, 0x86, 0xd0, 0xb0,    0, 0xd0, 
	0xa1, 0xd1, 0x83, 0xd0, 0xb1, 0xd0, 0xbe, 0xd1, 
	0x82, 0xd0, 0xb0,    0, 0xd0, 0xa1, 0xd1, 0x82, 
	0xd0, 0xb4,    0, 0xd0, 0x9b, 0xd1, 0x8e, 0xd1, 
	0x82,    0, 0xd0, 0xa1, 0xd0, 0xb0, 0xd0, 0xba, 
	   0, 0xd0, 0x9a, 0xd1, 0x80, 0xd1, 0x81,    0, 
	0xd0, 0xa2, 0xd1, 0x80, 0xd0, 0xb0,    0, 0xd0, 
	0xa7, 0xd1, 0x8d, 0xd1, 0x80,    0, 0xd0, 0x9b, 
	0xd1, 0x96, 0xd0, 0xbf,    0, 0xd0, 0x96, 0xd0, 
	0xbd, 0xd0, 0xb2,    0, 0xd0, 0x92, 0xd1, 0x80, 
	0xd1, 0x81,    0, 0xd0, 0x9a, 0xd1, 0x81, 0xd1, 
	0x82,    0, 0xd0, 0x9b, 0xd1, 0x96, 0xd1, 0x81, 
	   0, 0xd0, 0xa1, 0xd0, 0xbd, 0xd0, 0xb6,    0, 
	0xd0, 0xa1, 0xd1, 0x82, 0xd1, 0x83, 0xd0, 0xb4, 
	0xd0, 0xb7, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 
	   0, 0xd0, 0x9b, 0xd1, 0x8e, 0xd1, 0x82, 0xd1, 
	0x8b,    0, 0xd0, 0xa1, 0xd0, 0xb0, 0xd0, 0xba, 
	0xd0, 0xb0, 0xd0, 0xb2, 0xd1, 0x96, 0xd0, 0xba, 
	   0, 0xd0, 0x9a, 0xd1, 0x80, 0xd0, 0xb0, 0xd1, 
	0x81, 0xd0, 0xb0, 0xd0, 0xb2, 0xd1, 0x96, 0xd0, 
	0xba,    0, 0xd0, 0xa2, 0xd1, 0x80, 0xd0, 0xb0, 
	0xd0, 0xb2, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 
	   0, 0xd0, 0xa7, 0xd1, 0x8d, 0xd1, 0x80, 0xd0, 
	0xb2, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c,    0, 
	0xd0, 0x9b, 0xd1, 0x96, 0xd0, 0xbf, 0xd0, 0xb5, 
	0xd0, 0xbd, 0xd1, 0x8c,    0, 0xd0, 0x96, 0xd0, 
	0xbd, 0xd1, 0x96, 0xd0, 0xb2, 0xd0, 0xb5, 0xd0, 
	0xbd, 0xd1, 0x8c,    0, 0xd0, 0x92, 0xd0, 0xb5, 
	0xd1, 0x80, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xb5, 
	0xd0, 0xbd, 0xd1, 0x8c,    0, 0xd0, 0x9a, 0xd0, 
	0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd1, 
	0x8b, 0xd1, 0x87, 0xd0, 0xbd, 0xd1, 0x96, 0xd0, 
	0xba,    0, 0xd0, 0x9b, 0xd1, 0x96, 0xd1, 0x81, 
	0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xbf, 0xd0, 0xb0, 
	0xd0, 0xb4,    0, 0xd0, 0xa1, 0xd0, 0xbd, 0xd0, 
	0xb5, 0xd0, 0xb6, 0xd0, 0xb0, 0xd0, 0xbd, 0xd1, 
	0x8c,    0, 0xed, 0xe4,    0, 0xef, 0xed,    0, 
	0xe2, 0xf2,    0, 0xf1, 0xf0,    0, 0xf7, 0xf2, 
	   0, 0xef, 0xf2,    0, 0xf1, 0xe1,    0, 0xed, 
	0xe5, 0xe4, 0xe5, 0xeb, 0xff,    0, 0xef, 0xee, 
	0xed, 0xe5, 0xe4, 0xe5, 0xeb, 0xed, 0xe8, 0xea, 
	   0, 0xe2, 0xf2, 0xee, 0xf0, 0xed, 0xe8, 0xea, 
	   0, 0xf1, 0xf0, 0xff, 0xe4, 0xe0,    0, 0xf7, 
	0xe5, 0xf2, 0xe2, 0xfa, 0xf0, 0xf2, 0xfa, 0xea, 
	   0, 0xef, 0xe5, 0xf2, 0xfa, 0xea,    0, 0xf1, 
	0xfa, 0xe1, 0xee, 0xf2, 0xe0,    0, 0xff, 0xed, 
	0xf3,    0, 0xf4, 0xe5, 0xe2,    0, 0xec, 0xe0, 
	0xf0,    0, 0xe0, 0xef, 0xf0,    0, 0xec, 0xe0, 
	0xe9,    0, 0xfe, 0xed, 0xe8,    0, 0xfe, 0xeb, 
	0xe8,    0, 0xe0, 0xe2, 0xe3,    0, 0xf1, 0xe5, 
	0xef,    0, 0xee, 0xea, 0xf2,    0, 0xed, 0xee, 
	0xe5,    0, 0xe4, 0xe5, 0xea,    0, 0xff, 0xed, 
	0xf3, 0xe0, 0xf0, 0xe8,    0, 0xf4, 0xe5, 0xe2, 
	0xf0, 0xf3, 0xe0, 0xf0, 0xe8,    0, 0xec, 0xe0, 
	0xf0, 0xf2,    0, 0xe0, 0xef, 0xf0, 0xe8, 0xeb, 
	   0, 0xe0, 0xe2, 0xe3, 0xf3, 0xf1, 0xf2,    0, 
	0xf1, 0xe5, 0xef, 0xf2, 0xe5, 0xec, 0xe2, 0xf0, 
	0xe8,    0, 0xee, 0xea, 0xf2, 0xee, 0xec, 0xe2, 
	0xf0, 0xe8,    0, 0xed, 0xee, 0xe5, 0xec, 0xe2, 
	0xf0, 0xe8,    0, 0xe4, 0xe5, 0xea, 0xe5, 0xec, 
	0xe2, 0xf0, 0xe8,    0, 0x25, 0x78, 0x20, 0x28, 
	0x25, 0x61, 0x29, 0x20, 0x25, 0x58, 0x20, 0x25, 
	0x5a,    0, 0x25, 0x65, 0x2e, 0x25, 0x6d, 0x2e, 
	0x25, 0x59,    0, 0x25, 0x6b, 0x2c, 0x25, 0x4d, 
	0x2c, 0x25, 0x53,    0, 0x25, 0x6c, 0x2c, 0x25, 
	0x4d, 0x2c, 0x25, 0x53,    0, 0xd0, 0xbd, 0xd0, 
	0xb4,    0, 0xd0, 0xbf, 0xd0, 0xbd,    0, 0xd0, 
	0xb2, 0xd1, 0x82,    0, 0xd1, 0x81, 0xd1, 0x80, 
	   0, 0xd1, 0x87, 0xd1, 0x82,    0, 0xd0, 0xbf, 
	0xd1, 0x82,    0, 0xd1, 0x81, 0xd0, 0xb1,    0, 
	0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xb5, 
	0xd0, 0xbb, 0xd1, 0x8f,    0, 0xd0, 0xbf, 0xd0, 
	0xbe, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 
	0xb5, 0xd0, 0xbb, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 
	0xba,    0, 0xd0, 0xb2, 0xd1, 0x82, 0xd0, 0xbe, 
	0xd1, 0x80, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xba, 
	   0, 0xd1, 0x81, 0xd1, 0x80, 0xd1, 0x8f, 0xd0, 
	0xb4, 0xd0, 0xb0,    0, 0xd1, 0x87, 0xd0, 0xb5, 
	0xd1, 0x82, 0xd0, 0xb2, 0xd1, 0x8a, 0xd1, 0x80, 
	0xd1, 0x82, 0xd1, 0x8a, 0xd0, 0xba,    0, 0xd0, 
	0xbf, 0xd0, 0xb5, 0xd1, 0x82, 0xd1, 0x8a, 0xd0, 
	0xba,    0, 0xd1, 0x81, 0xd1, 0x8a, 0xd0, 0xb1, 
	0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xb0,    0, 0xd1, 
	0x8f, 0xd0, 0xbd, 0xd1, 0x83,    0, 0xd1, 0x84, 
	0xd0, 0xb5, 0xd0, 0xb2,    0, 0xd0, 0xbc, 0xd0, 
	0xb0, 0xd1, 0x80,    0, 0xd0, 0xb0, 0xd0, 0xbf, 
	0xd1, 0x80,    0, 0xd0, 0xbc, 0xd0, 0xb0, 0xd0, 
	0xb9,    0, 0xd1, 0x8e, 0xd0, 0xbd, 0xd0, 0xb8, 
	   0, 0xd1, 0x8e, 0xd0, 0xbb, 0xd0, 0xb8,    0, 
	0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xb3,    0, 0xd1, 
	0x81, 0xd0, 0xb5, 0xd0, 0xbf,    0, 0xd0, 0xbe, 
	0xd0, 0xba, 0xd1, 0x82,    0, 0xd0, 0xbd, 0xd0, 
	0xbe, 0xd0, 0xb5,    0, 0xd0, 0xb4, 0xd0, 0xb5, 
	0xd0, 0xba,    0, 0xd1, 0x8f, 0xd0, 0xbd, 0xd1, 
	0x83, 0xd0, 0xb0, 0xd1, 0x80, 0xd0, 0xb8,    0, 
	0xd1, 0x84, 0xd0, 0xb5, 0xd0, 0xb2, 0xd1, 0x80, 
	0xd1, 0x83, 0xd0, 0xb0, 0xd1, 0x80, 0xd0, 0xb8, 
	   0, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 
	0x82,    0, 0xd0, 0xb0, 0xd0, 0xbf, 0xd1, 0x80, 
	0xd0, 0xb8, 0xd0, 0xbb,    0, 0xd0, 0xb0, 0xd0, 
	0xb2, 0xd0, 0xb3, 0xd1, 0x83, 0xd1, 0x81, 0xd1, 
	0x82,    0, 0xd1, 0x81, 0xd0, 0xb5, 0xd0, 0xbf, 
	0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 0xb2, 
	0xd1, 0x80, 0xd0, 0xb8,    0, 0xd0, 0xbe, 0xd0, 
	0xba, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 
	0xb2, 0xd1, 0x80, 0xd0, 0xb8,    0, 0xd0, 0xbd, 
	0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 0xb2, 
	0xd1, 0x80, 0xd0, 0xb8,    0, 0xd0, 0xb4, 0xd0, 
	0xb5, 0xd0, 0xba, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 
	0xb2, 0xd1, 0x80, 0xd0, 0xb8,    0, 0xe0, 0xa6, 
	0xb0, 0xe0, 0xa6, 0xac, 0xe0, 0xa6, 0xbf,    0, 
	0xe0, 0xa6, 0xb8, 0xe0, 0xa7, 0x8b, 0xe0, 0xa6, 
	0xae,    0, 0xe0, 0xa6, 0xae, 0xe0, 0xa6, 0x99, 
	0xe0, 0xa6, 0x97, 0xe0, 0xa6, 0xb2,    0, 0xe0, 
	0xa6, 0xac, 0xe0, 0xa7, 0x81, 0xe0, 0xa6, 0xa7, 
	   0, 0xe0, 0xa6, 0xac, 0xe0, 0xa7, 0x83, 0xe0, 
	0xa6, 0xb9, 0xe0, 0xa6, 0xb8, 0xe0, 0xa7, 0x8d, 
	0xe0, 0xa6, 0xaa, 0xe0, 0xa6, 0xa4, 0xe0, 0xa6, 
	0xbf,    0, 0xe0, 0xa6, 0xb6, 0xe0, 0xa7, 0x81, 
	0xe0, 0xa6, 0x95, 0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 
	0xb0,    0, 0xe0, 0xa6, 0xb6, 0xe0, 0xa6, 0xa8, 
	0xe0, 0xa6, 0xbf,    0, 0xe0, 0xa6, 0xb0, 0xe0, 
	0xa6, 0xac, 0xe0, 0xa6, 0xbf, 0xe0, 0xa6, 0xac, 
	0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0xb0,    0, 0xe0, 
	0xa6, 0xb8, 0xe0, 0xa7, 0x8b, 0xe0, 0xa6, 0xae, 
	0xe0, 0xa6, 0xac, 0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 
	0xb0,    0, 0xe0, 0xa6, 0xae, 0xe0, 0xa6, 0x99, 
	0xe0, 0xa6, 0x97, 0xe0, 0xa6, 0xb2, 0xe0, 0xa6, 
	0xac, 0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0xb0,    0, 
	0xe0, 0xa6, 0xac, 0xe0, 0xa7, 0x81, 0xe0, 0xa6, 
	0xa7, 0xe0, 0xa6, 0xac, 0xe0, 0xa6, 0xbe, 0xe0, 
	0xa6, 0xb0,    0, 0xe0, 0xa6, 0xac, 0xe0, 0xa7, 
	0x83, 0xe0, 0xa6, 0xb9, 0xe0, 0xa6, 0xb8, 0xe0, 
	0xa7, 0x8d, 0xe0, 0xa6, 0xaa, 0xe0, 0xa6, 0xa4, 
	0xe0, 0xa6, 0xbf, 0xe0, 0xa6, 0xac, 0xe0, 0xa6, 
	0xbe, 0xe0, 0xa6, 0xb0,    0, 0xe0, 0xa6, 0xb6, 
	0xe0, 0xa7, 0x81, 0xe0, 0xa6, 0x95, 0xe0, 0xa7, 
	0x8d, 0xe0, 0xa6, 0xb0, 0xe0, 0xa6, 0xac, 0xe0, 
	0xa6, 0xbe, 0xe0, 0xa6, 0xb0,    0, 0xe0, 0xa6, 
	0xb6, 0xe0, 0xa6, 0xa8, 0xe0, 0xa6, 0xbf, 0xe0, 
	0xa6, 0xac, 0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0xb0, 
	   0, 0xe0, 0xa6, 0x9c, 0xe0, 0xa6, 0xbe, 0xe0, 
	0xa6, 0xa8,    0, 0xe0, 0xa6, 0xab, 0xe0, 0xa7, 
	0x87, 0xe0, 0xa6, 0xac,    0, 0xe0, 0xa6, 0xae, 
	0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0xb0,    0, 0xe0, 
	0xa6, 0x8f, 0xe0, 0xa6, 0xaa, 0xe0, 0xa7, 0x8d, 
	0xe0, 0xa6, 0xb0,    0, 0xe0, 0xa6, 0xae, 0xe0, 
	0xa7, 0x87,    0, 0xe0, 0xa6, 0x9c, 0xe0, 0xa7, 
	0x81, 0xe0, 0xa6, 0xa8,    0, 0xe0, 0xa6, 0x9c, 
	0xe0, 0xa7, 0x81, 0xe0, 0xa6, 0xb2,    0, 0xe0, 
	0xa6, 0x86, 0xe0, 0xa6, 0x97,    0, 0xe0, 0xa6, 
	0xb8, 0xe0, 0xa7, 0x87, 0xe0, 0xa6, 0xaa,    0, 
	0xe0, 0xa6, 0x85, 0xe0, 0xa6, 0x95, 0xe0, 0xa7, 
	0x8d, 0xe0, 0xa6, 0x9f, 0xe0, 0xa7, 0x8b, 0xe0, 
	0xa6, 0xac, 0xe0, 0xa6, 0xb0,    0, 0xe0, 0xa6, 
	0xa8, 0xe0, 0xa6, 0xad, 0xe0, 0xa7, 0x87, 0xe0, 
	0xa6, 0xae, 0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 0xac, 
	0xe0, 0xa6, 0xb0,    0, 0xe0, 0xa6, 0xa1, 0xe0, 
	0xa6, 0xbf, 0xe0, 0xa6, 0xb8, 0xe0, 0xa7, 0x87, 
	0xe0, 0xa6, 0xae, 0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 
	0xac, 0xe0, 0xa6, 0xb0,    0, 0xe0, 0xa6, 0x9c, 
	0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0xa8, 0xe0, 0xa7, 
	0x81, 0xe0, 0xa7, 0x9f, 0xe0, 0xa6, 0xbe, 0xe0, 
	0xa6, 0xb0, 0xe0, 0xa7, 0x80,    0, 0xe0, 0xa6, 
	0xab, 0xe0, 0xa7, 0x87, 0xe0, 0xa6, 0xac, 0xe0, 
	0xa7, 0x8d, 0xe0, 0xa6, 0xb0, 0xe0, 0xa7, 0x81, 
	0xe0, 0xa7, 0x9f, 0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 
	0xb0, 0xe0, 0xa7, 0x80,    0, 0xe0, 0xa6, 0xae, 
	0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0xb0, 0xe0, 0xa7, 
	0x8d, 0xe0, 0xa6, 0x9a,    0, 0xe0, 0xa6, 0x8f, 
	0xe0, 0xa6, 0xaa, 0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 
	0xb0, 0xe0, 0xa6, 0xbf, 0xe0, 0xa6, 0xb2,    0, 
	0xe0, 0xa6, 0x9c, 0xe0, 0xa7, 0x81, 0xe0, 0xa6, 
	0xb2, 0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0x87,    0, 
	0xe0, 0xa6, 0x86, 0xe0, 0xa6, 0x97, 0xe0, 0xa6, 
	0xb8, 0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 0x9f,    0, 
	0xe0, 0xa6, 0xb8, 0xe0, 0xa7, 0x87, 0xe0, 0xa6, 
	0xaa, 0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 0x9f, 0xe0, 
	0xa7, 0x87, 0xe0, 0xa6, 0xae, 0xe0, 0xa7, 0x8d, 
	0xe0, 0xa6, 0xac, 0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 
	0xb0,    0, 0xe0, 0xa6, 0x85, 0xe0, 0xa6, 0x95, 
	0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 0x9f, 0xe0, 0xa7, 
	0x8b, 0xe0, 0xa6, 0xac, 0xe0, 0xa6, 0xbe, 0xe0, 
	0xa6, 0xb0,    0, 0xe0, 0xa6, 0xa8, 0xe0, 0xa6, 
	0xad, 0xe0, 0xa7, 0x87, 0xe0, 0xa6, 0xae, 0xe0, 
	0xa7, 0x8d, 0xe0, 0xa6, 0xac, 0xe0, 0xa6, 0xbe, 
	0xe0, 0xa6, 0xb0,    0, 0xe0, 0xa6, 0xa1, 0xe0, 
	0xa6, 0xbf, 0xe0, 0xa6, 0xb8, 0xe0, 0xa7, 0x87, 
	0xe0, 0xa6, 0xae, 0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 
	0xac, 0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0xb0,    0, 
	0xe0, 0xa6, 0xb8, 0xe0, 0xa6, 0x95, 0xe0, 0xa6, 
	0xbe, 0xe0, 0xa6, 0xb2,    0, 0xe0, 0xa6, 0xac, 
	0xe0, 0xa6, 0xbf, 0xe0, 0xa6, 0x95, 0xe0, 0xa6, 
	0xbe, 0xe0, 0xa6, 0xb2,    0, 0x25, 0x41, 0x20, 
	0x25, 0x64, 0x20, 0x25, 0x62, 0x20, 0x25, 0x59, 
	0x20, 0x25, 0x49, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 
	0x53, 0x20, 0x25, 0x70, 0x20, 0x25, 0x5a,    0, 
	0x25, 0x41, 0x20, 0x25, 0x64, 0x20, 0x25, 0x62, 
	0x20, 0x25, 0x59,    0, 0xe0, 0xa6, 0xb8, 0xe0, 
	0xa7, 0x87, 0xe0, 0xa6, 0xaa, 0xe0, 0xa7, 0x8d, 
	0xe0, 0xa6, 0x9f, 0xe0, 0xa7, 0x87, 0xe0, 0xa6, 
	0xae, 0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 0xac, 0xe0, 
	0xa6, 0xb0,    0, 0xe0, 0xa6, 0xaa, 0xe0, 0xa7, 
	0x82, 0xe0, 0xa6, 0xb0, 0xe0, 0xa7, 0x8d, 0xe0, 
	0xa6, 0xac, 0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0xb9, 
	0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 0xa3,    0, 0xe0, 
	0xa6, 0x85, 0xe0, 0xa6, 0xaa, 0xe0, 0xa6, 0xb0, 
	0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0xb9, 0xe0, 0xa7, 
	0x8d, 0xe0, 0xa6, 0xa3,    0, 0x73, 0x75, 0x6c, 
	   0, 0x6c, 0x75, 0x6e,    0, 0x6d, 0x65, 0x75, 
	   0, 0x6d, 0x65, 0x72,    0, 0x79, 0x61, 0x6f, 
	   0, 0x67, 0x77, 0x65,    0, 0x73, 0x61, 0x64, 
	   0, 0x6d, 0x65, 0x75, 0x72, 0x7a, 0x68,    0, 
	0x6d, 0x65, 0x72, 0x63, 0x27, 0x68, 0x65, 0x72, 
	   0, 0x79, 0x61, 0x6f, 0x75,    0, 0x67, 0x77, 
	0x65, 0x6e, 0x65, 0x72,    0, 0x73, 0x61, 0x64, 
	0x6f, 0x72, 0x6e,    0, 0x47, 0x65, 0x6e, 0x20, 
	   0, 0x43, 0x27, 0x68, 0x77,    0, 0x4d, 0x65, 
	0x75, 0x20,    0, 0x45, 0x62, 0x72, 0x20,    0, 
	0x4d, 0x61, 0x65, 0x20,    0, 0x45, 0x76, 0x65, 
	0x20,    0, 0x47, 0x6f, 0x75, 0x20,    0, 0x45, 
	0x6f, 0x73, 0x20,    0, 0x47, 0x77, 0x65, 0x20, 
	   0, 0x48, 0x65, 0x72, 0x20,    0, 0x44, 0x75, 
	0x20, 0x20,    0, 0x4b, 0x65, 0x72, 0x20,    0, 
	0x47, 0x65, 0x6e, 0x76, 0x65, 0x72,    0, 0x43, 
	0x27, 0x68, 0x77, 0x65, 0x76, 0x72, 0x65, 0x72, 
	   0, 0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68,    0, 
	0x45, 0x62, 0x72, 0x65, 0x6c,    0, 0x4d, 0x61, 
	0x65,    0, 0x4d, 0x65, 0x7a, 0x68, 0x65, 0x76, 
	0x65, 0x6e,    0, 0x47, 0x6f, 0x75, 0x65, 0x72, 
	0x65,    0, 0x45, 0x6f, 0x73, 0x74,    0, 0x47, 
	0x77, 0x65, 0x6e, 0x67, 0x6f, 0x6c, 0x6f,    0, 
	0x48, 0x65, 0x72, 0x65,    0, 0x44, 0x75,    0, 
	0x4b, 0x65, 0x72, 0x7a, 0x75,    0, 0x20,    0, 
	0x44, 0x27, 0x61, 0x72, 0x20, 0x25, 0x41, 0x20, 
	0x25, 0x64, 0x20, 0x61, 0x20, 0x76, 0x69, 0x7a, 
	0x20, 0x25, 0x42, 0x20, 0x25, 0x59,    0, 0x25, 
	0x49, 0x65, 0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 
	0x25, 0x70,    0, 0x4e, 0x65, 0x64,    0, 0x50, 
	0x6f, 0x6e,    0, 0x55, 0x74, 0x6f,    0, 0x53, 
	0x72, 0x69,    0, 0xc8, 0x65, 0x74,    0, 0x50, 
	0x65, 0x74,    0, 0x53, 0x75, 0x62,    0, 0x4e, 
	0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61,    0, 
	0x50, 0x6f, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 
	0x6a, 0x61, 0x6b,    0, 0x55, 0x74, 0x6f, 0x72, 
	0x61, 0x6b,    0, 0x53, 0x72, 0x69, 0x6a, 0x65, 
	0x64, 0x61,    0, 0xc8, 0x65, 0x74, 0x76, 0x72, 
	0x74, 0x61, 0x6b,    0, 0x50, 0x65, 0x74, 0x61, 
	0x6b,    0, 0x53, 0x75, 0x62, 0x6f, 0x74, 0x61, 
	   0, 0x4d, 0x61, 0x6a,    0, 0x4a, 0x61, 0x6e, 
	0x75, 0x61, 0x72,    0, 0x46, 0x65, 0x62, 0x72, 
	0x75, 0x61, 0x72,    0, 0x4d, 0x61, 0x72, 0x74, 
	   0, 0x4a, 0x75, 0x6e, 0x69,    0, 0x4a, 0x75, 
	0x6c, 0x69,    0, 0x53, 0x65, 0x70, 0x74, 0x65, 
	0x6d, 0x62, 0x61, 0x72,    0, 0x4f, 0x6b, 0x74, 
	0x6f, 0x62, 0x61, 0x72,    0, 0x4e, 0x6f, 0x76, 
	0x65, 0x6d, 0x62, 0x61, 0x72,    0, 0x44, 0x65, 
	0x63, 0x65, 0x6d, 0x62, 0x61, 0x72,    0, 0xc4, 
	0x8c, 0x65, 0x74,    0, 0xc4, 0x8c, 0x65, 0x74, 
	0x76, 0x72, 0x74, 0x61, 0x6b,    0, 0x64, 0x67, 
	   0, 0x64, 0x6c,    0, 0x64, 0x74,    0, 0x64, 
	0x63,    0, 0x64, 0x6a,    0, 0x64, 0x76,    0, 
	0x64, 0x73,    0, 0x64, 0x69, 0x75, 0x6d, 0x65, 
	0x6e, 0x67, 0x65,    0, 0x64, 0x69, 0x6c, 0x6c, 
	0x75, 0x6e, 0x73,    0, 0x64, 0x69, 0x6d, 0x61, 
	0x72, 0x74, 0x73,    0, 0x64, 0x69, 0x6d, 0x65, 
	0x63, 0x72, 0x65, 0x73,    0, 0x64, 0x69, 0x6a, 
	0x6f, 0x75, 0x73,    0, 0x64, 0x69, 0x76, 0x65, 
	0x6e, 0x64, 0x72, 0x65, 0x73,    0, 0x64, 0x69, 
	0x73, 0x73, 0x61, 0x62, 0x74, 0x65,    0, 0x67, 
	0x65, 0x6e,    0, 0x66, 0x65, 0x62,    0, 0x6d, 
	0x61, 0x72,    0, 0x61, 0x62, 0x72,    0, 0x6d, 
	0x61, 0x69,    0, 0x6a, 0x75, 0x6e,    0, 0x6a, 
	0x75, 0x6c,    0, 0x61, 0x67, 0x6f,    0, 0x73, 
	0x65, 0x74,    0, 0x6f, 0x63, 0x74,    0, 0x6e, 
	0x6f, 0x76,    0, 0x64, 0x65, 0x73,    0, 0x67, 
	0x65, 0x6e, 0x65, 0x72,    0, 0x66, 0x65, 0x62, 
	0x72, 0x65, 0x72,    0, 0x6d, 0x61, 0x72, 0xe7, 
	   0, 0x61, 0x62, 0x72, 0x69, 0x6c,    0, 0x6d, 
	0x61, 0x69, 0x67,    0, 0x6a, 0x75, 0x6e, 0x79, 
	   0, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x6c,    0, 
	0x61, 0x67, 0x6f, 0x73, 0x74,    0, 0x73, 0x65, 
	0x74, 0x65, 0x6d, 0x62, 0x72, 0x65,    0, 0x6f, 
	0x63, 0x74, 0x75, 0x62, 0x72, 0x65,    0, 0x6e, 
	0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65,    0, 
	0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x72, 0x65, 
	   0, 0x6d, 0x61, 0x72, 0xc3, 0xa7,    0, 0x4e, 
	0x65,    0, 0x50, 0x6f,    0, 0xda, 0x74,    0, 
	0x53, 0x74,    0, 0xc8, 0x74,    0, 0x50, 0xe1, 
	   0, 0x4e, 0x65, 0x64, 0xec, 0x6c, 0x65,    0, 
	0x50, 0x6f, 0x6e, 0x64, 0xec, 0x6c, 0xed,    0, 
	0xda, 0x74, 0x65, 0x72, 0xfd,    0, 0x53, 0x74, 
	0xf8, 0x65, 0x64, 0x61,    0, 0xc8, 0x74, 0x76, 
	0x72, 0x74, 0x65, 0x6b,    0, 0x50, 0xe1, 0x74, 
	0x65, 0x6b,    0, 0x53, 0x6f, 0x62, 0x6f, 0x74, 
	0x61,    0, 0x6c, 0x65, 0x64,    0, 0xfa, 0x6e, 
	0x6f,    0, 0x62, 0xf8, 0x65,    0, 0x64, 0x75, 
	0x62,    0, 0x6b, 0x76, 0xec,    0, 0xe8, 0x65, 
	0x6e,    0, 0xe8, 0x65, 0x63,    0, 0x73, 0x72, 
	0x70,    0, 0x7a, 0xe1, 0xf8,    0, 0xf8, 0xed, 
	0x6a,    0, 0x6c, 0x69, 0x73,    0, 0x70, 0x72, 
	0x6f,    0, 0x6c, 0x65, 0x64, 0x65, 0x6e,    0, 
	0xfa, 0x6e, 0x6f, 0x72,    0, 0x62, 0xf8, 0x65, 
	0x7a, 0x65, 0x6e,    0, 0x64, 0x75, 0x62, 0x65, 
	0x6e,    0, 0x6b, 0x76, 0xec, 0x74, 0x65, 0x6e, 
	   0, 0xe8, 0x65, 0x72, 0x76, 0x65, 0x6e,    0, 
	0xe8, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x65, 0x63, 
	   0, 0x73, 0x72, 0x70, 0x65, 0x6e,    0, 0x7a, 
	0xe1, 0xf8, 0xed,    0, 0xf8, 0xed, 0x6a, 0x65, 
	0x6e,    0, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 
	0x61, 0x64,    0, 0x70, 0x72, 0x6f, 0x73, 0x69, 
	0x6e, 0x65, 0x63,    0, 0x25, 0x61, 0xa0, 0x25, 
	0x65, 0x2e, 0xa0, 0x25, 0x42, 0xa0, 0x25, 0x59, 
	0x2c, 0xa0, 0x25, 0x48, 0x3a, 0x25, 0x4d, 0x3a, 
	0x25, 0x53, 0xa0, 0x25, 0x5a,    0, 0x25, 0x49, 
	0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53,    0, 0xc3, 
	0x9a, 0x74,    0, 0xc4, 0x8c, 0x74,    0, 0x50, 
	0xc3, 0xa1,    0, 0x4e, 0x65, 0x64, 0xc4, 0x9b, 
	0x6c, 0x65,    0, 0x50, 0x6f, 0x6e, 0x64, 0xc4, 
	0x9b, 0x6c, 0xc3, 0xad,    0, 0xc3, 0x9a, 0x74, 
	0x65, 0x72, 0xc3, 0xbd,    0, 0x53, 0x74, 0xc5, 
	0x99, 0x65, 0x64, 0x61,    0, 0xc4, 0x8c, 0x74, 
	0x76, 0x72, 0x74, 0x65, 0x6b,    0, 0x50, 0xc3, 
	0xa1, 0x74, 0x65, 0x6b,    0, 0xc3, 0xba, 0x6e, 
	0x6f,    0, 0x62, 0xc5, 0x99, 0x65,    0, 0x6b, 
	0x76, 0xc4, 0x9b,    0, 0xc4, 0x8d, 0x65, 0x6e, 
	   0, 0xc4, 0x8d, 0x65, 0x63,    0, 0x7a, 0xc3, 
	0xa1, 0xc5, 0x99,    0, 0xc5, 0x99, 0xc3, 0xad, 
	0x6a,    0, 0xc3, 0xba, 0x6e, 0x6f, 0x72,    0, 
	0x62, 0xc5, 0x99, 0x65, 0x7a, 0x65, 0x6e,    0, 
	0x6b, 0x76, 0xc4, 0x9b, 0x74, 0x65, 0x6e,    0, 
	0xc4, 0x8d, 0x65, 0x72, 0x76, 0x65, 0x6e,    0, 
	0xc4, 0x8d, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x65, 
	0x63,    0, 0x7a, 0xc3, 0xa1, 0xc5, 0x99, 0xc3, 
	0xad,    0, 0xc5, 0x99, 0xc3, 0xad, 0x6a, 0x65, 
	0x6e,    0, 0x25, 0x61, 0xc2, 0xa0, 0x25, 0x65, 
	0x2e, 0xc2, 0xa0, 0x25, 0x42, 0xc2, 0xa0, 0x25, 
	0x59, 0x2c, 0xc2, 0xa0, 0x25, 0x48, 0x3a, 0x25, 
	0x4d, 0x3a, 0x25, 0x53, 0xc2, 0xa0, 0x25, 0x5a, 
	   0, 0x53, 0x75, 0x6c,    0, 0x4c, 0x6c, 0x75, 
	   0, 0x4d, 0x61, 0x77,    0, 0x4d, 0x65, 0x72, 
	   0, 0x49, 0x61, 0x75,    0, 0x47, 0x77, 0x65, 
	   0, 0x53, 0x61, 0x64,    0, 0x4c, 0x6c, 0x75, 
	0x6e,    0, 0x4d, 0x61, 0x77, 0x72, 0x74, 0x68, 
	   0, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x65, 0x72, 
	   0, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72,    0, 
	0x53, 0x61, 0x64, 0x77, 0x72, 0x6e,    0, 0x49, 
	0x6f, 0x6e,    0, 0x43, 0x68, 0x77,    0, 0x45, 
	0x62, 0x72,    0, 0x4d, 0x61, 0x69,    0, 0x4d, 
	0x65, 0x68,    0, 0x47, 0x6f, 0x72,    0, 0x41, 
	0x77, 0x73,    0, 0x4d, 0x65, 0x64,    0, 0x48, 
	0x79, 0x64,    0, 0x54, 0x61, 0x63, 0x68,    0, 
	0x52, 0x68, 0x61,    0, 0x49, 0x6f, 0x6e, 0x61, 
	0x77, 0x72,    0, 0x43, 0x68, 0x77, 0x65, 0x66, 
	0x72, 0x6f, 0x72,    0, 0x45, 0x62, 0x72, 0x69, 
	0x6c, 0x6c,    0, 0x4d, 0x65, 0x68, 0x65, 0x66, 
	0x69, 0x6e,    0, 0x47, 0x6f, 0x72, 0x66, 0x66, 
	0x65, 0x6e, 0x6e, 0x61, 0x66,    0, 0x41, 0x77, 
	0x73, 0x74,    0, 0x4d, 0x65, 0x64, 0x69,    0, 
	0x48, 0x79, 0x64, 0x72, 0x65, 0x66,    0, 0x54, 
	0x61, 0x63, 0x68, 0x77, 0x65, 0x64, 0x64,    0, 
	0x52, 0x68, 0x61, 0x67, 0x66, 0x79, 0x72,    0, 
	0x44, 0x79, 0x64, 0x64, 0x20, 0x25, 0x41, 0x20, 
	0x25, 0x64, 0x20, 0x61, 0x20, 0x76, 0x69, 0x7a, 
	0x20, 0x25, 0x42, 0x20, 0x25, 0x59, 0x20, 0x25, 
	0x54, 0x20, 0x25, 0x5a,    0, 0x25, 0x64, 0x2e, 
	0x25, 0x6d, 0x2e, 0x25, 0x79,    0, 0x73, 0xf8, 
	0x6e,    0, 0x6d, 0x61, 0x6e,    0, 0x74, 0x69, 
	0x72,    0, 0x6f, 0x6e, 0x73,    0, 0x74, 0x6f, 
	0x72,    0, 0x66, 0x72, 0x65,    0, 0x6c, 0xf8, 
	0x72,    0, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 
	   0, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x67,    0, 
	0x74, 0x69, 0x72, 0x73, 0x64, 0x61, 0x67,    0, 
	0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67,    0, 0x74, 
	0x6f, 0x72, 0x73, 0x64, 0x61, 0x67,    0, 0x66, 
	0x72, 0x65, 0x64, 0x61, 0x67,    0, 0x6c, 0xf8, 
	0x72, 0x64, 0x61, 0x67,    0, 0x6a, 0x61, 0x6e, 
	   0, 0x61, 0x70, 0x72,    0, 0x6d, 0x61, 0x6a, 
	   0, 0x61, 0x75, 0x67,    0, 0x73, 0x65, 0x70, 
	   0, 0x6f, 0x6b, 0x74,    0, 0x64, 0x65, 0x63, 
	   0, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72,    0, 
	0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72,    0, 
	0x6d, 0x61, 0x72, 0x74, 0x73,    0, 0x61, 0x70, 
	0x72, 0x69, 0x6c,    0, 0x6a, 0x75, 0x6e, 0x69, 
	   0, 0x6a, 0x75, 0x6c, 0x69,    0, 0x61, 0x75, 
	0x67, 0x75, 0x73, 0x74,    0, 0x73, 0x65, 0x70, 
	0x74, 0x65, 0x6d, 0x62, 0x65, 0x72,    0, 0x6f, 
	0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72,    0, 0x6e, 
	0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72,    0, 
	0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 
	   0, 0x25, 0x64, 0x2d, 0x25, 0x6d, 0x2d, 0x25, 
	0x59,    0, 0x73, 0xc3, 0xb8, 0x6e,    0, 0x6c, 
	0xc3, 0xb8, 0x72,    0, 0x73, 0xc3, 0xb8, 0x6e, 
	0x64, 0x61, 0x67,    0, 0x6c, 0xc3, 0xb8, 0x72, 
	0x64, 0x61, 0x67,    0, 0x53, 0x6f, 0x6e,    0, 
	0x44, 0x69, 0x65,    0, 0x4d, 0x69, 0x74,    0, 
	0x44, 0x6f, 0x6e,    0, 0x46, 0x72, 0x65,    0, 
	0x53, 0x61, 0x6d,    0, 0x53, 0x6f, 0x6e, 0x6e, 
	0x74, 0x61, 0x67,    0, 0x4d, 0x6f, 0x6e, 0x74, 
	0x61, 0x67,    0, 0x44, 0x69, 0x65, 0x6e, 0x73, 
	0x74, 0x61, 0x67,    0, 0x4d, 0x69, 0x74, 0x74, 
	0x77, 0x6f, 0x63, 0x68,    0, 0x44, 0x6f, 0x6e, 
	0x6e, 0x65, 0x72, 0x73, 0x74, 0x61, 0x67,    0, 
	0x46, 0x72, 0x65, 0x69, 0x74, 0x61, 0x67,    0, 
	0x53, 0x61, 0x6d, 0x73, 0x74, 0x61, 0x67,    0, 
	0x4a, 0xe4, 0x6e,    0, 0x4d, 0xe4, 0x72,    0, 
	0x44, 0x65, 0x7a,    0, 0x4a, 0xe4, 0x6e, 0x6e, 
	0x65, 0x72,    0, 0x46, 0x65, 0x62, 0x65, 0x72, 
	   0, 0x4d, 0xe4, 0x72, 0x7a,    0, 0x44, 0x65, 
	0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72,    0, 0x25, 
	0x59, 0x2d, 0x25, 0x6d, 0x2d, 0x25, 0x64,    0, 
	0x4a, 0xc3, 0xa4, 0x6e,    0, 0x4d, 0xc3, 0xa4, 
	0x72,    0, 0x4a, 0xc3, 0xa4, 0x6e, 0x6e, 0x65, 
	0x72,    0, 0x4d, 0xc3, 0xa4, 0x72, 0x7a,    0, 
	0xca, 0xf5, 0xf1,    0, 0xc4, 0xe5, 0xf5,    0, 
	0xd4, 0xf1, 0xe9,    0, 0xd4, 0xe5, 0xf4,    0, 
	0xd0, 0xe5, 0xec,    0, 0xd0, 0xe1, 0xf1,    0, 
	0xd3, 0xe1, 0xe2,    0, 0xca, 0xf5, 0xf1, 0xe9, 
	0xe1, 0xea, 0xde,    0, 0xc4, 0xe5, 0xf5, 0xf4, 
	0xdd, 0xf1, 0xe1,    0, 0xd4, 0xf1, 0xdf, 0xf4, 
	0xe7,    0, 0xd4, 0xe5, 0xf4, 0xdc, 0xf1, 0xf4, 
	0xe7,    0, 0xd0, 0xdd, 0xec, 0xf0, 0xf4, 0xe7, 
	   0, 0xd0, 0xe1, 0xf1, 0xe1, 0xf3, 0xea, 0xe5, 
	0xf5, 0xde,    0, 0xd3, 0xdc, 0xe2, 0xe2, 0xe1, 
	0xf4, 0xef,    0, 0xc9, 0xe1, 0xed,    0, 0xd6, 
	0xe5, 0xe2,    0, 0xcc, 0xdc, 0xf1,    0, 0xc1, 
	0xf0, 0xf1,    0, 0xcc, 0xdc, 0xe9,    0, 0xc9, 
	0xef, 0xfd, 0xed,    0, 0xc9, 0xef, 0xfd, 0xeb, 
	   0, 0xc1, 0xfd, 0xe3,    0, 0xd3, 0xe5, 0xf0, 
	   0, 0xcf, 0xea, 0xf4,    0, 0xcd, 0xef, 0xdd, 
	   0, 0xc4, 0xe5, 0xea,    0, 0xc9, 0xe1, 0xed, 
	0xef, 0xf5, 0xdc, 0xf1, 0xe9, 0xef, 0xf2,    0, 
	0xd6, 0xe5, 0xe2, 0xf1, 0xef, 0xf5, 0xdc, 0xf1, 
	0xe9, 0xef, 0xf2,    0, 0xcc, 0xdc, 0xf1, 0xf4, 
	0xe9, 0xef, 0xf2,    0, 0xc1, 0xf0, 0xf1, 0xdf, 
	0xeb, 0xe9, 0xef, 0xf2,    0, 0xcc, 0xdc, 0xe9, 
	0xef, 0xf2,    0, 0xc9, 0xef, 0xfd, 0xed, 0xe9, 
	0xef, 0xf2,    0, 0xc9, 0xef, 0xfd, 0xeb, 0xe9, 
	0xef, 0xf2,    0, 0xc1, 0xfd, 0xe3, 0xef, 0xf5, 
	0xf3, 0xf4, 0xef, 0xf2,    0, 0xd3, 0xe5, 0xf0, 
	0xf4, 0xdd, 0xec, 0xe2, 0xf1, 0xe9, 0xef, 0xf2, 
	   0, 0xcf, 0xea, 0xf4, 0xfe, 0xe2, 0xf1, 0xe9, 
	0xef, 0xf2,    0, 0xcd, 0xef, 0xdd, 0xec, 0xe2, 
	0xf1, 0xe9, 0xef, 0xf2,    0, 0xc4, 0xe5, 0xea, 
	0xdd, 0xec, 0xe2, 0xf1, 0xe9, 0xef, 0xf2,    0, 
	0xce, 0x9a, 0xcf, 0x85, 0xcf, 0x81,    0, 0xce, 
	0x94, 0xce, 0xb5, 0xcf, 0x85,    0, 0xce, 0xa4, 
	0xcf, 0x81, 0xce, 0xb9,    0, 0xce, 0xa4, 0xce, 
	0xb5, 0xcf, 0x84,    0, 0xce, 0xa0, 0xce, 0xb5, 
	0xce, 0xbc,    0, 0xce, 0xa0, 0xce, 0xb1, 0xcf, 
	0x81,    0, 0xce, 0xa3, 0xce, 0xb1, 0xce, 0xb2, 
	   0, 0xce, 0x9a, 0xcf, 0x85, 0xcf, 0x81, 0xce, 
	0xb9, 0xce, 0xb1, 0xce, 0xba, 0xce, 0xae,    0, 
	0xce, 0x94, 0xce, 0xb5, 0xcf, 0x85, 0xcf, 0x84, 
	0xce, 0xad, 0xcf, 0x81, 0xce, 0xb1,    0, 0xce, 
	0xa4, 0xcf, 0x81, 0xce, 0xaf, 0xcf, 0x84, 0xce, 
	0xb7,    0, 0xce, 0xa4, 0xce, 0xb5, 0xcf, 0x84, 
	0xce, 0xac, 0xcf, 0x81, 0xcf, 0x84, 0xce, 0xb7, 
	   0, 0xce, 0xa0, 0xce, 0xad, 0xce, 0xbc, 0xcf, 
	0x80, 0xcf, 0x84, 0xce, 0xb7,    0, 0xce, 0xa0, 
	0xce, 0xb1, 0xcf, 0x81, 0xce, 0xb1, 0xcf, 0x83, 
	0xce, 0xba, 0xce, 0xb5, 0xcf, 0x85, 0xce, 0xae, 
	   0, 0xce, 0xa3, 0xce, 0xac, 0xce, 0xb2, 0xce, 
	0xb2, 0xce, 0xb1, 0xcf, 0x84, 0xce, 0xbf,    0, 
	0xce, 0x99, 0xce, 0xb1, 0xce, 0xbd,    0, 0xce, 
	0xa6, 0xce, 0xb5, 0xce, 0xb2,    0, 0xce, 0x9c, 
	0xce, 0xac, 0xcf, 0x81,    0, 0xce, 0x91, 0xcf, 
	0x80, 0xcf, 0x81,    0, 0xce, 0x9c, 0xce, 0xac, 
	0xce, 0xb9,    0, 0xce, 0x99, 0xce, 0xbf, 0xcf, 
	0x8d, 0xce, 0xbd,    0, 0xce, 0x99, 0xce, 0xbf, 
	0xcf, 0x8d, 0xce, 0xbb,    0, 0xce, 0x91, 0xcf, 
	0x8d, 0xce, 0xb3,    0, 0xce, 0xa3, 0xce, 0xb5, 
	0xcf, 0x80,    0, 0xce, 0x9f, 0xce, 0xba, 0xcf, 
	0x84,    0, 0xce, 0x9d, 0xce, 0xbf, 0xce, 0xad, 
	   0, 0xce, 0x94, 0xce, 0xb5, 0xce, 0xba,    0, 
	0xce, 0x99, 0xce, 0xb1, 0xce, 0xbd, 0xce, 0xbf, 
	0xcf, 0x85, 0xce, 0xac, 0xcf, 0x81, 0xce, 0xb9, 
	0xce, 0xbf, 0xcf, 0x82,    0, 0xce, 0xa6, 0xce, 
	0xb5, 0xce, 0xb2, 0xcf, 0x81, 0xce, 0xbf, 0xcf, 
	0x85, 0xce, 0xac, 0xcf, 0x81, 0xce, 0xb9, 0xce, 
	0xbf, 0xcf, 0x82,    0, 0xce, 0x9c, 0xce, 0xac, 
	0xcf, 0x81, 0xcf, 0x84, 0xce, 0xb9, 0xce, 0xbf, 
	0xcf, 0x82,    0, 0xce, 0x91, 0xcf, 0x80, 0xcf, 
	0x81, 0xce, 0xaf, 0xce, 0xbb, 0xce, 0xb9, 0xce, 
	0xbf, 0xcf, 0x82,    0, 0xce, 0x9c, 0xce, 0xac, 
	0xce, 0xb9, 0xce, 0xbf, 0xcf, 0x82,    0, 0xce, 
	0x99, 0xce, 0xbf, 0xcf, 0x8d, 0xce, 0xbd, 0xce, 
	0xb9, 0xce, 0xbf, 0xcf, 0x82,    0, 0xce, 0x99, 
	0xce, 0xbf, 0xcf, 0x8d, 0xce, 0xbb, 0xce, 0xb9, 
	0xce, 0xbf, 0xcf, 0x82,    0, 0xce, 0x91, 0xcf, 
	0x8d, 0xce, 0xb3, 0xce, 0xbf, 0xcf, 0x85, 0xcf, 
	0x83, 0xcf, 0x84, 0xce, 0xbf, 0xcf, 0x82,    0, 
	0xce, 0xa3, 0xce, 0xb5, 0xcf, 0x80, 0xcf, 0x84, 
	0xce, 0xad, 0xce, 0xbc, 0xce, 0xb2, 0xcf, 0x81, 
	0xce, 0xb9, 0xce, 0xbf, 0xcf, 0x82,    0, 0xce, 
	0x9f, 0xce, 0xba, 0xcf, 0x84, 0xcf, 0x8e, 0xce, 
	0xb2, 0xcf, 0x81, 0xce, 0xb9, 0xce, 0xbf, 0xcf, 
	0x82,    0, 0xce, 0x9d, 0xce, 0xbf, 0xce, 0xad, 
	0xce, 0xbc, 0xce, 0xb2, 0xcf, 0x81, 0xce, 0xb9, 
	0xce, 0xbf, 0xcf, 0x82,    0, 0xce, 0x94, 0xce, 
	0xb5, 0xce, 0xba, 0xce, 0xad, 0xce, 0xbc, 0xce, 
	0xb2, 0xcf, 0x81, 0xce, 0xb9, 0xce, 0xbf, 0xcf, 
	0x82,    0, 0x25, 0x61, 0x20, 0x25, 0x64, 0x20, 
	0x25, 0x62, 0x20, 0x25, 0x59, 0x20, 0x25, 0x72, 
	0x20, 0x25, 0x5a,    0, 0x25, 0x59, 0x2d, 0x25, 
	0x6d, 0x2d, 0x25, 0x64, 0x54, 0x25, 0x54, 0x20, 
	0x25, 0x5a,    0, 0x25, 0x41, 0x2c, 0x20, 0x25, 
	0x42, 0x20, 0x25, 0x64, 0x2c, 0x20, 0x25, 0x59, 
	0x20, 0x25, 0x70, 0x25, 0x49, 0x3a, 0x25, 0x4d, 
	0x3a, 0x25, 0x53, 0x20, 0x25, 0x5a,    0, 0x25, 
	0x41, 0x2c, 0x20, 0x25, 0x42, 0x20, 0x25, 0x64, 
	0x2c, 0x20, 0x25, 0x59,    0, 0x25, 0x49, 0x3a, 
	0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 0x25, 0x5a, 
	   0, 0x25, 0x70, 0x25, 0x49, 0x3a, 0x25, 0x4d, 
	0x3a, 0x25, 0x53, 0x20, 0x25, 0x5a,    0, 0x25, 
	0x41, 0x2c, 0x20, 0x25, 0x64, 0x20, 0x25, 0x42, 
	0x2c, 0x20, 0x25, 0x59, 0x20, 0x25, 0x49, 0x3a, 
	0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 0x25, 0x70, 
	0x20, 0x25, 0x5a,    0, 0x25, 0x41, 0x2c, 0x20, 
	0x25, 0x64, 0x20, 0x25, 0x42, 0x2c, 0x20, 0x25, 
	0x59,    0, 0x25, 0x41, 0x20, 0x25, 0x64, 0x2c, 
	0x25, 0x42, 0x2c, 0x25, 0x59, 0x20, 0x25, 0x49, 
	0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 0x25, 
	0x70, 0x20, 0x25, 0x5a,    0, 0x25, 0x41, 0x20, 
	0x25, 0x64, 0x2c, 0x25, 0x42, 0x2c, 0x25, 0x59, 
	   0, 0x25, 0x6d, 0x2f, 0x25, 0x64, 0x2f, 0x25, 
	0x59,    0, 0x64, 0x69, 0x6d,    0, 0xc4, 0xb5, 
	0x61, 0xc5, 0xad,    0, 0x76, 0x65, 0x6e,    0, 
	0x73, 0x61, 0x62,    0, 0x64, 0x69, 0x6d, 0x61, 
	0x6e, 0xc4, 0x89, 0x6f,    0, 0x6c, 0x75, 0x6e, 
	0x64, 0x6f,    0, 0x6d, 0x61, 0x72, 0x64, 0x6f, 
	   0, 0x6d, 0x65, 0x72, 0x6b, 0x72, 0x65, 0x64, 
	0x6f,    0, 0xc4, 0xb5, 0x61, 0xc5, 0xad, 0x64, 
	0x6f,    0, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 
	0x64, 0x6f,    0, 0x73, 0x61, 0x62, 0x61, 0x74, 
	0x6f,    0, 0x41, 0xc5, 0xad, 0x67,    0, 0x4a, 
	0x61, 0x6e, 0x75, 0x61, 0x72, 0x6f,    0, 0x46, 
	0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x6f,    0, 
	0x4d, 0x61, 0x72, 0x74, 0x6f,    0, 0x41, 0x70, 
	0x72, 0x69, 0x6c, 0x6f,    0, 0x4d, 0x61, 0x6a, 
	0x6f,    0, 0x4a, 0x75, 0x6e, 0x69, 0x6f,    0, 
	0x4a, 0x75, 0x6c, 0x69, 0x6f,    0, 0x41, 0xc5, 
	0xad, 0x67, 0x75, 0x73, 0x74, 0x6f,    0, 0x53, 
	0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 
	   0, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x6f, 
	   0, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 
	0x6f,    0, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 
	0x72, 0x6f,    0, 0x25, 0x61, 0x20, 0x25, 0x64, 
	0x20, 0x25, 0x62, 0x20, 0x25, 0x59, 0x20, 0x25, 
	0x54, 0x20, 0x25, 0x7a,    0, 0x64, 0x6f, 0x6d, 
	   0, 0x6d, 0x69, 0xe9,    0, 0x6a, 0x75, 0x65, 
	   0, 0x76, 0x69, 0x65,    0, 0x73, 0xe1, 0x62, 
	   0, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 
	   0, 0x6c, 0x75, 0x6e, 0x65, 0x73,    0, 0x6d, 
	0x61, 0x72, 0x74, 0x65, 0x73,    0, 0x6d, 0x69, 
	0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73,    0, 
	0x6a, 0x75, 0x65, 0x76, 0x65, 0x73,    0, 0x76, 
	0x69, 0x65, 0x72, 0x6e, 0x65, 0x73,    0, 0x73, 
	0xe1, 0x62, 0x61, 0x64, 0x6f,    0, 0x65, 0x6e, 
	0x65,    0, 0x64, 0x69, 0x63,    0, 0x65, 0x6e, 
	0x65, 0x72, 0x6f,    0, 0x66, 0x65, 0x62, 0x72, 
	0x65, 0x72, 0x6f,    0, 0x6d, 0x61, 0x72, 0x7a, 
	0x6f,    0, 0x6d, 0x61, 0x79, 0x6f,    0, 0x6a, 
	0x75, 0x6e, 0x69, 0x6f,    0, 0x6a, 0x75, 0x6c, 
	0x69, 0x6f,    0, 0x61, 0x67, 0x6f, 0x73, 0x74, 
	0x6f,    0, 0x73, 0x65, 0x70, 0x74, 0x69, 0x65, 
	0x6d, 0x62, 0x72, 0x65,    0, 0x6e, 0x6f, 0x76, 
	0x69, 0x65, 0x6d, 0x62, 0x72, 0x65,    0, 0x64, 
	0x69, 0x63, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 
	   0, 0x6d, 0x69, 0xc3, 0xa9,    0, 0x73, 0xc3, 
	0xa1, 0x62,    0, 0x6d, 0x69, 0xc3, 0xa9, 0x72, 
	0x63, 0x6f, 0x6c, 0x65, 0x73,    0, 0x73, 0xc3, 
	0xa1, 0x62, 0x61, 0x64, 0x6f,    0, 0x50,    0, 
	0x45,    0, 0x54,    0, 0x4b,    0, 0x4e,    0, 
	0x52,    0, 0x4c,    0, 0x70, 0xfc, 0x68, 0x61, 
	0x70, 0xe4, 0x65, 0x76,    0, 0x65, 0x73, 0x6d, 
	0x61, 0x73, 0x70, 0xe4, 0x65, 0x76,    0, 0x74, 
	0x65, 0x69, 0x73, 0x69, 0x70, 0xe4, 0x65, 0x76, 
	   0, 0x6b, 0x6f, 0x6c, 0x6d, 0x61, 0x70, 0xe4, 
	0x65, 0x76,    0, 0x6e, 0x65, 0x6c, 0x6a, 0x61, 
	0x70, 0xe4, 0x65, 0x76,    0, 0x72, 0x65, 0x65, 
	0x64, 0x65,    0, 0x6c, 0x61, 0x75, 0x70, 0xe4, 
	0x65, 0x76,    0, 0x6a, 0x61, 0x61, 0x6e, 0x20, 
	   0, 0x76, 0x65, 0x65, 0x62, 0x72,    0, 0x6d, 
	0xe4, 0x72, 0x74, 0x73,    0, 0x61, 0x70, 0x72, 
	0x20, 0x20,    0, 0x6d, 0x61, 0x69, 0x20, 0x20, 
	   0, 0x6a, 0x75, 0x75, 0x6e, 0x69,    0, 0x6a, 
	0x75, 0x75, 0x6c, 0x69,    0, 0x61, 0x75, 0x67, 
	0x20, 0x20,    0, 0x73, 0x65, 0x70, 0x74, 0x20, 
	   0, 0x6f, 0x6b, 0x74, 0x20, 0x20,    0, 0x6e, 
	0x6f, 0x76, 0x20, 0x20,    0, 0x64, 0x65, 0x74, 
	0x73, 0x20,    0, 0x6a, 0x61, 0x61, 0x6e, 0x75, 
	0x61, 0x72,    0, 0x76, 0x65, 0x65, 0x62, 0x72, 
	0x75, 0x61, 0x72,    0, 0x61, 0x70, 0x72, 0x69, 
	0x6c, 0x6c,    0, 0x6f, 0x6b, 0x74, 0x6f, 0x6f, 
	0x62, 0x65, 0x72,    0, 0x64, 0x65, 0x74, 0x73, 
	0x65, 0x6d, 0x62, 0x65, 0x72,    0, 0x70, 0xc3, 
	0xbc, 0x68, 0x61, 0x70, 0xc3, 0xa4, 0x65, 0x76, 
	   0, 0x65, 0x73, 0x6d, 0x61, 0x73, 0x70, 0xc3, 
	0xa4, 0x65, 0x76,    0, 0x74, 0x65, 0x69, 0x73, 
	0x69, 0x70, 0xc3, 0xa4, 0x65, 0x76,    0, 0x6b, 
	0x6f, 0x6c, 0x6d, 0x61, 0x70, 0xc3, 0xa4, 0x65, 
	0x76,    0, 0x6e, 0x65, 0x6c, 0x6a, 0x61, 0x70, 
	0xc3, 0xa4, 0x65, 0x76,    0, 0x6c, 0x61, 0x75, 
	0x70, 0xc3, 0xa4, 0x65, 0x76,    0, 0x6d, 0xc3, 
	0xa4, 0x72, 0x74, 0x73,    0, 0x69, 0x67, 0x2e, 
	   0, 0x61, 0x6c, 0x2e,    0, 0x61, 0x72, 0x2e, 
	   0, 0x61, 0x7a, 0x2e,    0, 0x6f, 0x67, 0x2e, 
	   0, 0x6f, 0x72, 0x2e,    0, 0x6c, 0x72, 0x2e, 
	   0, 0x69, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x61, 
	   0, 0x61, 0x73, 0x74, 0x65, 0x6c, 0x65, 0x68, 
	0x65, 0x6e, 0x61,    0, 0x61, 0x73, 0x74, 0x65, 
	0x61, 0x72, 0x74, 0x65, 0x61,    0, 0x61, 0x73, 
	0x74, 0x65, 0x61, 0x7a, 0x6b, 0x65, 0x6e, 0x61, 
	   0, 0x6f, 0x73, 0x74, 0x65, 0x67, 0x75, 0x6e, 
	0x61,    0, 0x6f, 0x73, 0x74, 0x69, 0x72, 0x61, 
	0x6c, 0x61,    0, 0x6c, 0x61, 0x72, 0x75, 0x6e, 
	0x62, 0x61, 0x74, 0x61,    0, 0x75, 0x72, 0x74, 
	   0, 0x6f, 0x74, 0x73,    0, 0x61, 0x70, 0x69, 
	   0, 0x65, 0x6b, 0x61,    0, 0x75, 0x7a, 0x74, 
	   0, 0x61, 0x62, 0x75,    0, 0x69, 0x72, 0x61, 
	   0, 0x75, 0x72, 0x72,    0, 0x61, 0x7a, 0x61, 
	   0, 0x61, 0x62, 0x65,    0, 0x75, 0x72, 0x74, 
	0x61, 0x72, 0x72, 0x69, 0x6c, 0x61,    0, 0x6f, 
	0x74, 0x73, 0x61, 0x69, 0x6c, 0x61,    0, 0x6d, 
	0x61, 0x72, 0x74, 0x78, 0x6f, 0x61,    0, 0x61, 
	0x70, 0x69, 0x72, 0x69, 0x6c, 0x61,    0, 0x6d, 
	0x61, 0x69, 0x61, 0x74, 0x7a, 0x61,    0, 0x65, 
	0x6b, 0x61, 0x69, 0x6e, 0x61,    0, 0x75, 0x7a, 
	0x74, 0x61, 0x69, 0x6c, 0x61,    0, 0x61, 0x62, 
	0x75, 0x7a, 0x74, 0x75, 0x61,    0, 0x69, 0x72, 
	0x61, 0x69, 0x6c, 0x61,    0, 0x75, 0x72, 0x72, 
	0x69, 0x61,    0, 0x61, 0x7a, 0x61, 0x72, 0x6f, 
	0x61,    0, 0x61, 0x62, 0x65, 0x6e, 0x64, 0x75, 
	0x61,    0, 0x25, 0x79, 0x2d, 0x25, 0x6d, 0x2d, 
	0x25, 0x64, 0x20, 0x25, 0x54, 0x20, 0x25, 0x5a, 
	   0, 0x25, 0x61, 0x2c, 0x20, 0x25, 0x59, 0x2e, 
	0x65, 0x6b, 0x6f, 0x20, 0x25, 0x62, 0x72, 0x65, 
	0x6e, 0x20, 0x25, 0x64, 0x61,    0, 0xdb, 0x8c, 
	0x2e,    0, 0xd8, 0xaf, 0x2e,    0, 0xd8, 0xb3, 
	0x2e,    0, 0xda, 0x86, 0x2e,    0, 0xd9, 0xbe, 
	0x2e,    0, 0xd8, 0xac, 0x2e,    0, 0xd8, 0xb4, 
	0x2e,    0, 0xdb, 0x8c, 0xda, 0xa9, 0xe2, 0x80, 
	0x8c, 0xd8, 0xb4, 0xd9, 0x86, 0xd8, 0xa8, 0xd9, 
	0x87,    0, 0xd8, 0xaf, 0xd9, 0x88, 0xd8, 0xb4, 
	0xd9, 0x86, 0xd8, 0xa8, 0xd9, 0x87,    0, 0xd8, 
	0xb3, 0xd9, 0x87, 0xe2, 0x80, 0x8c, 0xd8, 0xb4, 
	0xd9, 0x86, 0xd8, 0xa8, 0xd9, 0x87,    0, 0xda, 
	0x86, 0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 
	0xb4, 0xd9, 0x86, 0xd8, 0xa8, 0xd9, 0x87,    0, 
	0xd9, 0xbe, 0xd9, 0x86, 0xd8, 0xac, 0xe2, 0x80, 
	0x8c, 0xd8, 0xb4, 0xd9, 0x86, 0xd8, 0xa8, 0xd9, 
	0x87,    0, 0xd8, 0xac, 0xd9, 0x85, 0xd8, 0xb9, 
	0xd9, 0x87,    0, 0xd8, 0xb4, 0xd9, 0x86, 0xd8, 
	0xa8, 0xd9, 0x87,    0, 0xda, 0x98, 0xd8, 0xa7, 
	0xd9, 0x86,    0, 0xd9, 0x81, 0xd9, 0x88, 0xd8, 
	0xb1,    0, 0xd8, 0xa2, 0xd9, 0x88, 0xd8, 0xb1, 
	   0, 0xd9, 0x85, 0xd9, 0x80, 0xd9, 0x87,    0, 
	0xda, 0x98, 0xd9, 0x88, 0xd9, 0x86,    0, 0xda, 
	0x98, 0xd9, 0x88, 0xdb, 0x8c,    0, 0xd8, 0xa7, 
	0xd9, 0x88, 0xd8, 0xaa,    0, 0xd8, 0xb3, 0xd9, 
	0xbe, 0xd8, 0xaa,    0, 0xd8, 0xa7, 0xd9, 0x83, 
	0xd8, 0xaa,    0, 0xd9, 0x86, 0xd9, 0x88, 0xd8, 
	0xa7,    0, 0xd8, 0xaf, 0xd8, 0xb3, 0xd8, 0xa7, 
	   0, 0xda, 0x98, 0xd8, 0xa7, 0xd9, 0x86, 0xd9, 
	0x88, 0xdb, 0x8c, 0xd9, 0x87,    0, 0xd9, 0x81, 
	0xd9, 0x88, 0xd8, 0xb1, 0xdb, 0x8c, 0xd9, 0x87, 
	   0, 0xd8, 0xa2, 0xd9, 0x88, 0xd8, 0xb1, 0xdb, 
	0x8c, 0xd9, 0x84,    0, 0xd9, 0x85, 0xd9, 0x87, 
	   0, 0xda, 0x98, 0xd9, 0x88, 0xd8, 0xa6, 0xd9, 
	0x86,    0, 0xda, 0x98, 0xd9, 0x88, 0xd8, 0xa6, 
	0xdb, 0x8c, 0xd9, 0x87,    0, 0xd8, 0xb3, 0xd9, 
	0xbe, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 
	0xa8, 0xd8, 0xb1,    0, 0xd8, 0xa7, 0xd9, 0x83, 
	0xd8, 0xaa, 0xd8, 0xa8, 0xd8, 0xb1,    0, 0xd9, 
	0x86, 0xd9, 0x88, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 
	0xa8, 0xd8, 0xb1,    0, 0xd8, 0xaf, 0xd8, 0xb3, 
	0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xa8, 0xd8, 0xb1, 
	   0, 0xd8, 0xb5, 0xd8, 0xa8, 0xd8, 0xad,    0, 
	0xd8, 0xb9, 0xd8, 0xb5, 0xd8, 0xb1,    0, 0xe2, 
	0x80, 0xab, 0x25, 0x41, 0x20, 0x25, 0x65, 0x20, 
	0x25, 0x42, 0x20, 0x25, 0x59, 0xd8, 0x8c, 0x20, 
	0x25, 0x49, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53, 
	0x20, 0x25, 0x70, 0xe2, 0x80, 0xac,    0, 0x25, 
	0x59, 0x2f, 0x25, 0x6d, 0x2f, 0x25, 0x64,    0, 
	0xe2, 0x80, 0xab, 0x25, 0x49, 0x3a, 0x25, 0x4d, 
	0x3a, 0x25, 0x53, 0x20, 0x25, 0x70, 0xe2, 0x80, 
	0xac,    0, 0x73, 0x75,    0, 0x6d, 0x61,    0, 
	0x74, 0x69,    0, 0x6b, 0x65,    0, 0x74, 0x6f, 
	   0, 0x70, 0x65,    0, 0x6c, 0x61,    0, 0x73, 
	0x75, 0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 
	   0, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74, 
	0x61, 0x69,    0, 0x74, 0x69, 0x69, 0x73, 0x74, 
	0x61, 0x69,    0, 0x6b, 0x65, 0x73, 0x6b, 0x69, 
	0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f,    0, 0x74, 
	0x6f, 0x72, 0x73, 0x74, 0x61, 0x69,    0, 0x70, 
	0x65, 0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 
	   0, 0x6c, 0x61, 0x75, 0x61, 0x6e, 0x74, 0x61, 
	0x69,    0, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0xa0, 
	   0, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0xa0,    0, 
	0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73,    0, 0x68, 
	0x75, 0x68, 0x74, 0x69, 0xa0,    0, 0x74, 0x6f, 
	0x75, 0x6b, 0x6f, 0xa0,    0, 0x6b, 0x65, 0x73, 
	0xe4, 0xa0, 0xa0,    0, 0x68, 0x65, 0x69, 0x6e, 
	0xe4, 0xa0,    0, 0x65, 0x6c, 0x6f, 0xa0, 0xa0, 
	0xa0,    0, 0x73, 0x79, 0x79, 0x73, 0xa0, 0xa0, 
	   0, 0x6c, 0x6f, 0x6b, 0x61, 0xa0, 0xa0,    0, 
	0x6d, 0x61, 0x72, 0x72, 0x61, 0x73,    0, 0x6a, 
	0x6f, 0x75, 0x6c, 0x75, 0xa0,    0, 0x74, 0x61, 
	0x6d, 0x6d, 0x69, 0x6b, 0x75, 0x75,    0, 0x68, 
	0x65, 0x6c, 0x6d, 0x69, 0x6b, 0x75, 0x75,    0, 
	0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x6b, 0x75, 
	0x75,    0, 0x68, 0x75, 0x68, 0x74, 0x69, 0x6b, 
	0x75, 0x75,    0, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 
	0x6b, 0x75, 0x75,    0, 0x6b, 0x65, 0x73, 0xe4, 
	0x6b, 0x75, 0x75,    0, 0x68, 0x65, 0x69, 0x6e, 
	0xe4, 0x6b, 0x75, 0x75,    0, 0x65, 0x6c, 0x6f, 
	0x6b, 0x75, 0x75,    0, 0x73, 0x79, 0x79, 0x73, 
	0x6b, 0x75, 0x75,    0, 0x6c, 0x6f, 0x6b, 0x61, 
	0x6b, 0x75, 0x75,    0, 0x6d, 0x61, 0x72, 0x72, 
	0x61, 0x73, 0x6b, 0x75, 0x75,    0, 0x6a, 0x6f, 
	0x75, 0x6c, 0x75, 0x6b, 0x75, 0x75,    0, 0x25, 
	0x61, 0x20, 0x25, 0x65, 0x20, 0x25, 0x42, 0x20, 
	0x25, 0x59, 0x20, 0x25, 0x54,    0, 0x74, 0x61, 
	0x6d, 0x6d, 0x69, 0xc2, 0xa0,    0, 0x68, 0x65, 
	0x6c, 0x6d, 0x69, 0xc2, 0xa0,    0, 0x68, 0x75, 
	0x68, 0x74, 0x69, 0xc2, 0xa0,    0, 0x74, 0x6f, 
	0x75, 0x6b, 0x6f, 0xc2, 0xa0,    0, 0x6b, 0x65, 
	0x73, 0xc3, 0xa4, 0xc2, 0xa0, 0xc2, 0xa0,    0, 
	0x68, 0x65, 0x69, 0x6e, 0xc3, 0xa4, 0xc2, 0xa0, 
	   0, 0x65, 0x6c, 0x6f, 0xc2, 0xa0, 0xc2, 0xa0, 
	0xc2, 0xa0,    0, 0x73, 0x79, 0x79, 0x73, 0xc2, 
	0xa0, 0xc2, 0xa0,    0, 0x6c, 0x6f, 0x6b, 0x61, 
	0xc2, 0xa0, 0xc2, 0xa0,    0, 0x6a, 0x6f, 0x75, 
	0x6c, 0x75, 0xc2, 0xa0,    0, 0x6b, 0x65, 0x73, 
	0xc3, 0xa4, 0x6b, 0x75, 0x75,    0, 0x68, 0x65, 
	0x69, 0x6e, 0xc3, 0xa4, 0x6b, 0x75, 0x75,    0, 
	0x73, 0x75, 0x6e,    0, 0x6d, 0xe1, 0x6e,    0, 
	0x74, 0xfd, 0x73,    0, 0x6d, 0x69, 0x6b,    0, 
	0x68, 0xf3, 0x73,    0, 0x66, 0x72, 0xed,    0, 
	0x6c, 0x65, 0x79,    0, 0x73, 0x75, 0x6e, 0x6e, 
	0x75, 0x64, 0x61, 0x67, 0x75, 0x72,    0, 0x6d, 
	0xe1, 0x6e, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 
	   0, 0x74, 0xfd, 0x73, 0x64, 0x61, 0x67, 0x75, 
	0x72,    0, 0x6d, 0x69, 0x6b, 0x75, 0x64, 0x61, 
	0x67, 0x75, 0x72,    0, 0x68, 0xf3, 0x73, 0x64, 
	0x61, 0x67, 0x75, 0x72,    0, 0x66, 0x72, 0xed, 
	0x67, 0x67, 0x6a, 0x61, 0x64, 0x61, 0x67, 0x75, 
	0x72,    0, 0x6c, 0x65, 0x79, 0x67, 0x61, 0x72, 
	0x64, 0x61, 0x67, 0x75, 0x72,    0, 0x6d, 0x61, 
	0x72, 0x73,    0, 0x61, 0x70, 0x72, 0xed, 0x6c, 
	   0, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 
	0x72,    0, 0x25, 0x64, 0x2f, 0x25, 0x6d, 0x2d, 
	0x25, 0x59,    0, 0x6d, 0xc3, 0xa1, 0x6e,    0, 
	0x74, 0xc3, 0xbd, 0x73,    0, 0x68, 0xc3, 0xb3, 
	0x73,    0, 0x66, 0x72, 0xc3, 0xad,    0, 0x6d, 
	0xc3, 0xa1, 0x6e, 0x61, 0x64, 0x61, 0x67, 0x75, 
	0x72,    0, 0x74, 0xc3, 0xbd, 0x73, 0x64, 0x61, 
	0x67, 0x75, 0x72,    0, 0x68, 0xc3, 0xb3, 0x73, 
	0x64, 0x61, 0x67, 0x75, 0x72,    0, 0x66, 0x72, 
	0xc3, 0xad, 0x67, 0x67, 0x6a, 0x61, 0x64, 0x61, 
	0x67, 0x75, 0x72,    0, 0x61, 0x70, 0x72, 0xc3, 
	0xad, 0x6c,    0, 0x6a, 0x65, 0x75,    0, 0x73, 
	0x61, 0x6d,    0, 0x64, 0x69, 0x6d, 0x61, 0x6e, 
	0x63, 0x68, 0x65,    0, 0x6c, 0x75, 0x6e, 0x64, 
	0x69,    0, 0x6d, 0x61, 0x72, 0x64, 0x69,    0, 
	0x6d, 0x65, 0x72, 0x63, 0x72, 0x65, 0x64, 0x69, 
	   0, 0x6a, 0x65, 0x75, 0x64, 0x69,    0, 0x76, 
	0x65, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69,    0, 
	0x73, 0x61, 0x6d, 0x65, 0x64, 0x69,    0, 0x66, 
	0xe9, 0x76,    0, 0x61, 0x76, 0x72,    0, 0x6a, 
	0x75, 0x69,    0, 0x61, 0x6f, 0xfb,    0, 0x64, 
	0xe9, 0x63,    0, 0x6a, 0x61, 0x6e, 0x76, 0x69, 
	0x65, 0x72,    0, 0x66, 0xe9, 0x76, 0x72, 0x69, 
	0x65, 0x72,    0, 0x61, 0x76, 0x72, 0x69, 0x6c, 
	   0, 0x6a, 0x75, 0x69, 0x6e,    0, 0x6a, 0x75, 
	0x69, 0x6c, 0x6c, 0x65, 0x74,    0, 0x61, 0x6f, 
	0xfb, 0x74,    0, 0x73, 0x65, 0x70, 0x74, 0x65, 
	0x6d, 0x62, 0x72, 0x65,    0, 0x6f, 0x63, 0x74, 
	0x6f, 0x62, 0x72, 0x65,    0, 0x64, 0xe9, 0x63, 
	0x65, 0x6d, 0x62, 0x72, 0x65,    0, 0x66, 0xc3, 
	0xa9, 0x76,    0, 0x61, 0x6f, 0xc3, 0xbb,    0, 
	0x64, 0xc3, 0xa9, 0x63,    0, 0x66, 0xc3, 0xa9, 
	0x76, 0x72, 0x69, 0x65, 0x72,    0, 0x61, 0x6f, 
	0xc3, 0xbb, 0x74,    0, 0x64, 0xc3, 0xa9, 0x63, 
	0x65, 0x6d, 0x62, 0x72, 0x65,    0, 0x25, 0x64, 
	0x2e, 0x20, 0x25, 0x6d, 0x2e, 0x20, 0x25, 0x79, 
	   0, 0x44, 0x6f, 0x6d, 0x68,    0, 0x4c, 0x75, 
	0x61, 0x6e,    0, 0x4d, 0xe1, 0x69, 0x72, 0x74, 
	   0, 0x43, 0xe9, 0x61, 0x64,    0, 0x44, 0xe9, 
	0x61, 0x72,    0, 0x41, 0x6f, 0x69, 0x6e, 0x65, 
	   0, 0x53, 0x61, 0x74, 0x68,    0, 0x44, 0xe9, 
	0x20, 0x44, 0x6f, 0x6d, 0x68, 0x6e, 0x61, 0x69, 
	0x67, 0x68,    0, 0x44, 0xe9, 0x20, 0x4c, 0x75, 
	0x61, 0x69, 0x6e,    0, 0x44, 0xe9, 0x20, 0x4d, 
	0xe1, 0x69, 0x72, 0x74,    0, 0x44, 0xe9, 0x20, 
	0x43, 0xe9, 0x61, 0x64, 0x61, 0x6f, 0x69, 0x6e, 
	   0, 0x44, 0xe9, 0x61, 0x72, 0x64, 0x61, 0x6f, 
	0x69, 0x6e,    0, 0x44, 0xe9, 0x20, 0x68, 0x41, 
	0x6f, 0x69, 0x6e, 0x65,    0, 0x44, 0xe9, 0x20, 
	0x53, 0x61, 0x74, 0x68, 0x61, 0x69, 0x72, 0x6e, 
	   0, 0x45, 0x61, 0x6e,    0, 0x46, 0x65, 0x61, 
	0x62, 0x68,    0, 0x4d, 0xe1, 0x72, 0x74, 0x61, 
	   0, 0x41, 0x69, 0x62,    0, 0x42, 0x65, 0x61, 
	0x6c,    0, 0x4d, 0x65, 0x69, 0x74, 0x68,    0, 
	0x49, 0xfa, 0x69, 0x6c,    0, 0x4c, 0xfa, 0x6e, 
	   0, 0x4d, 0x46, 0xf3, 0x6d, 0x68,    0, 0x44, 
	0x46, 0xf3, 0x6d, 0x68,    0, 0x53, 0x61, 0x6d, 
	0x68,    0, 0x4e, 0x6f, 0x6c, 0x6c,    0, 0x45, 
	0x61, 0x6e, 0xe1, 0x69, 0x72,    0, 0x46, 0x65, 
	0x61, 0x62, 0x68, 0x72, 0x61,    0, 0x41, 0x69, 
	0x62, 0x72, 0x65, 0xe1, 0x6e,    0, 0x4d, 0xed, 
	0x20, 0x6e, 0x61, 0x20, 0x42, 0x65, 0x61, 0x6c, 
	0x74, 0x61, 0x69, 0x6e, 0x65,    0, 0x4c, 0xfa, 
	0x6e, 0x61, 0x73, 0x61,    0, 0x4d, 0x65, 0xe1, 
	0x6e, 0x20, 0x46, 0xf3, 0x6d, 0x68, 0x61, 0x69, 
	0x72,    0, 0x44, 0x65, 0x69, 0x72, 0x65, 0x61, 
	0x64, 0x68, 0x20, 0x46, 0xf3, 0x6d, 0x68, 0x61, 
	0x69, 0x72,    0, 0x4d, 0xed, 0x20, 0x6e, 0x61, 
	0x20, 0x53, 0x61, 0x6d, 0x68, 0x6e, 0x61,    0, 
	0x4d, 0xed, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6f, 
	0x6c, 0x6c, 0x61, 0x67,    0, 0x4d, 0xc3, 0xa1, 
	0x69, 0x72, 0x74,    0, 0x43, 0xc3, 0xa9, 0x61, 
	0x64,    0, 0x44, 0xc3, 0xa9, 0x61, 0x72,    0, 
	0x44, 0xc3, 0xa9, 0x20, 0x44, 0x6f, 0x6d, 0x68, 
	0x6e, 0x61, 0x69, 0x67, 0x68,    0, 0x44, 0xc3, 
	0xa9, 0x20, 0x4c, 0x75, 0x61, 0x69, 0x6e,    0, 
	0x44, 0xc3, 0xa9, 0x20, 0x4d, 0xc3, 0xa1, 0x69, 
	0x72, 0x74,    0, 0x44, 0xc3, 0xa9, 0x20, 0x43, 
	0xc3, 0xa9, 0x61, 0x64, 0x61, 0x6f, 0x69, 0x6e, 
	   0, 0x44, 0xc3, 0xa9, 0x61, 0x72, 0x64, 0x61, 
	0x6f, 0x69, 0x6e,    0, 0x44, 0xc3, 0xa9, 0x20, 
	0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65,    0, 0x44, 
	0xc3, 0xa9, 0x20, 0x53, 0x61, 0x74, 0x68, 0x61, 
	0x69, 0x72, 0x6e,    0, 0x4d, 0xc3, 0xa1, 0x72, 
	0x74, 0x61,    0, 0x49, 0xc3, 0xba, 0x69, 0x6c, 
	   0, 0x4c, 0xc3, 0xba, 0x6e,    0, 0x4d, 0x46, 
	0xc3, 0xb3, 0x6d, 0x68,    0, 0x44, 0x46, 0xc3, 
	0xb3, 0x6d, 0x68,    0, 0x45, 0x61, 0x6e, 0xc3, 
	0xa1, 0x69, 0x72,    0, 0x41, 0x69, 0x62, 0x72, 
	0x65, 0xc3, 0xa1, 0x6e,    0, 0x4d, 0xc3, 0xad, 
	0x20, 0x6e, 0x61, 0x20, 0x42, 0x65, 0x61, 0x6c, 
	0x74, 0x61, 0x69, 0x6e, 0x65,    0, 0x4c, 0xc3, 
	0xba, 0x6e, 0x61, 0x73, 0x61,    0, 0x4d, 0x65, 
	0xc3, 0xa1, 0x6e, 0x20, 0x46, 0xc3, 0xb3, 0x6d, 
	0x68, 0x61, 0x69, 0x72,    0, 0x44, 0x65, 0x69, 
	0x72, 0x65, 0x61, 0x64, 0x68, 0x20, 0x46, 0xc3, 
	0xb3, 0x6d, 0x68, 0x61, 0x69, 0x72,    0, 0x4d, 
	0xc3, 0xad, 0x20, 0x6e, 0x61, 0x20, 0x53, 0x61, 
	0x6d, 0x68, 0x6e, 0x61,    0, 0x4d, 0xc3, 0xad, 
	0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6f, 0x6c, 0x6c, 
	0x61, 0x67,    0, 0x44, 0x69, 0x64, 0x6f,    0, 
	0x44, 0x69, 0x6c, 0x75,    0, 0x44, 0x69, 0x6d, 
	   0, 0x44, 0x69, 0x63,    0, 0x44, 0x69, 0x61, 
	0x72,    0, 0x44, 0x69, 0x68, 0x61,    0, 0x44, 
	0x69, 0x73, 0x61,    0, 0x44, 0x69, 0x64, 0xf2, 
	0x6d, 0x68, 0x6e, 0x61, 0x69, 0x63, 0x68,    0, 
	0x44, 0x69, 0x6c, 0x75, 0x61, 0x69, 0x6e,    0, 
	0x44, 0x69, 0x6d, 0xe0, 0x69, 0x72, 0x74,    0, 
	0x44, 0x69, 0x63, 0x69, 0x61, 0x64, 0x61, 0x69, 
	0x6e,    0, 0x44, 0x69, 0x61, 0x72, 0x64, 0x61, 
	0x6f, 0x69, 0x6e,    0, 0x44, 0x69, 0x68, 0x61, 
	0x6f, 0x69, 0x6e, 0x65,    0, 0x44, 0x69, 0x73, 
	0x61, 0x74, 0x68, 0x61, 0x69, 0x72, 0x6e, 0x65, 
	   0, 0x46, 0x61, 0x6f,    0, 0x47, 0x65, 0x61, 
	   0, 0x4d, 0xe0, 0x72,    0, 0x47, 0x69, 0x62, 
	   0, 0x4d, 0x68, 0xe0,    0, 0x4f, 0x67, 0x4d, 
	   0, 0x6c, 0x75, 0x63,    0, 0x4c, 0xf9, 0x6e, 
	   0, 0x44, 0x61, 0x6d,    0, 0x44, 0xf9, 0x62, 
	   0, 0x41, 0x6d, 0x20, 0x46, 0x61, 0x6f, 0x69, 
	0x6c, 0x74, 0x65, 0x61, 0x63, 0x68,    0, 0x41, 
	0x6e, 0x20, 0x47, 0x65, 0x61, 0x72, 0x72, 0x61, 
	0x6e,    0, 0x41, 0x6d, 0x20, 0x4d, 0xe0, 0x72, 
	0x74,    0, 0x41, 0x6e, 0x20, 0x47, 0x69, 0x62, 
	0x6c, 0x65, 0x61, 0x6e,    0, 0x41, 0x27, 0x20, 
	0x4d, 0x68, 0xe0, 0x69, 0x67, 0x68,    0, 0x41, 
	0x6e, 0x20, 0x74, 0x2d, 0x4d, 0x68, 0xec, 0x6f, 
	0x73,    0, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x6c, 
	0x75, 0x63, 0x68, 0x61, 0x72,    0, 0x41, 0x6e, 
	0x20, 0x4c, 0xf9, 0x6e, 0x61, 0x73, 0x64, 0x61, 
	0x6c,    0, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x53, 
	0x75, 0x6c, 0x74, 0x61, 0x69, 0x6e,    0, 0x41, 
	0x6e, 0x20, 0x44, 0x61, 0x6d, 0x68, 0x61, 0x69, 
	0x72,    0, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x53, 
	0x61, 0x6d, 0x68, 0x61, 0x69, 0x6e,    0, 0x41, 
	0x6e, 0x20, 0x44, 0xf9, 0x62, 0x68, 0x6c, 0x61, 
	0x63, 0x68, 0x64,    0, 0x44, 0x69, 0x64, 0xc3, 
	0xb2, 0x6d, 0x68, 0x6e, 0x61, 0x69, 0x63, 0x68, 
	   0, 0x44, 0x69, 0x6d, 0xc3, 0xa0, 0x69, 0x72, 
	0x74,    0, 0x4d, 0xc3, 0xa0, 0x72,    0, 0x4d, 
	0x68, 0xc3, 0xa0,    0, 0x4c, 0xc3, 0xb9, 0x6e, 
	   0, 0x44, 0xc3, 0xb9, 0x62,    0, 0x41, 0x6d, 
	0x20, 0x4d, 0xc3, 0xa0, 0x72, 0x74,    0, 0x41, 
	0x27, 0x20, 0x4d, 0x68, 0xc3, 0xa0, 0x69, 0x67, 
	0x68,    0, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x4d, 
	0x68, 0xc3, 0xac, 0x6f, 0x73,    0, 0x41, 0x6e, 
	0x20, 0x4c, 0xc3, 0xb9, 0x6e, 0x61, 0x73, 0x64, 
	0x61, 0x6c,    0, 0x41, 0x6e, 0x20, 0x44, 0xc3, 
	0xb9, 0x62, 0x68, 0x6c, 0x61, 0x63, 0x68, 0x64, 
	   0, 0x44, 0x6f, 0x6d,    0, 0x4c, 0x75, 0x6e, 
	   0, 0x4d, 0xe9, 0x72,    0, 0x58, 0x6f, 0x76, 
	   0, 0x56, 0x65, 0x6e,    0, 0x53, 0xe1, 0x62, 
	   0, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 
	   0, 0x4c, 0x75, 0x6e, 0x73,    0, 0x4d, 0x61, 
	0x72, 0x74, 0x65, 0x73,    0, 0x4d, 0xe9, 0x72, 
	0x63, 0x6f, 0x72, 0x65, 0x73,    0, 0x58, 0x6f, 
	0x76, 0x65, 0x73,    0, 0x56, 0x65, 0x6e, 0x72, 
	0x65, 0x73,    0, 0x53, 0xe1, 0x62, 0x61, 0x64, 
	0x6f,    0, 0x58, 0x61, 0x6e,    0, 0x41, 0x62, 
	0x72,    0, 0x58, 0x75, 0xf1,    0, 0x58, 0x75, 
	0x6c,    0, 0x41, 0x67, 0x6f,    0, 0x53, 0x65, 
	0x74,    0, 0x4f, 0x75, 0x74,    0, 0x58, 0x61, 
	0x6e, 0x65, 0x69, 0x72, 0x6f,    0, 0x46, 0x65, 
	0x62, 0x72, 0x65, 0x69, 0x72, 0x6f,    0, 0x4d, 
	0x61, 0x72, 0x7a, 0x6f,    0, 0x41, 0x62, 0x72, 
	0x69, 0x6c,    0, 0x4d, 0x61, 0x69, 0x6f,    0, 
	0x58, 0x75, 0xf1, 0x6f,    0, 0x58, 0x75, 0x6c, 
	0x6c, 0x6f,    0, 0x41, 0x67, 0x6f, 0x73, 0x74, 
	0x6f,    0, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 
	0x72, 0x6f,    0, 0x4f, 0x75, 0x74, 0x75, 0x62, 
	0x72, 0x6f,    0, 0x4d, 0xc3, 0xa9, 0x72,    0, 
	0x53, 0xc3, 0xa1, 0x62,    0, 0x4d, 0xc3, 0xa9, 
	0x72, 0x63, 0x6f, 0x72, 0x65, 0x73,    0, 0x53, 
	0xc3, 0xa1, 0x62, 0x61, 0x64, 0x6f,    0, 0x58, 
	0x75, 0xc3, 0xb1,    0, 0x58, 0x75, 0xc3, 0xb1, 
	0x6f,    0, 0x4a, 0x65, 0x64,    0, 0x4a, 0x65, 
	0x6c,    0, 0x4a, 0x65, 0x6d,    0, 0x4a, 0x65, 
	0x72, 0x63,    0, 0x4a, 0x65, 0x72, 0x64,    0, 
	0x4a, 0x65, 0x68,    0, 0x4a, 0x65, 0x73,    0, 
	0x4a, 0x65, 0x64, 0x6f, 0x6f, 0x6e, 0x65, 0x65, 
	   0, 0x4a, 0x65, 0x6c, 0x68, 0x65, 0x69, 0x6e, 
	   0, 0x4a, 0x65, 0x6d, 0x61, 0x79, 0x72, 0x74, 
	   0, 0x4a, 0x65, 0x72, 0x63, 0x65, 0x61, 0x6e, 
	   0, 0x4a, 0x65, 0x72, 0x64, 0x65, 0x69, 0x6e, 
	   0, 0x4a, 0x65, 0x68, 0x65, 0x69, 0x6e, 0x65, 
	0x79,    0, 0x4a, 0x65, 0x73, 0x61, 0x72, 0x6e, 
	   0, 0x4a, 0x2d, 0x67, 0x75, 0x65, 0x72,    0, 
	0x54, 0x2d, 0x61, 0x72, 0x72, 0x65, 0x65,    0, 
	0x4d, 0x61, 0x79, 0x72, 0x6e, 0x74,    0, 0x41, 
	0x76, 0x72, 0x72, 0x69, 0x6c,    0, 0x42, 0x6f, 
	0x61, 0x6c, 0x64, 0x79, 0x6e,    0, 0x4d, 0x2d, 
	0x73, 0x6f, 0x75, 0x72, 0x65, 0x65,    0, 0x4a, 
	0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65,    0, 
	0x4c, 0x75, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x79, 
	0x6e,    0, 0x4d, 0x2d, 0x66, 0x6f, 0x75, 0x79, 
	0x69, 0x72,    0, 0x4a, 0x2d, 0x66, 0x6f, 0x75, 
	0x79, 0x69, 0x72,    0, 0x4d, 0x2e, 0x48, 0x6f, 
	0x75, 0x6e, 0x65, 0x79,    0, 0x4d, 0x2e, 0x4e, 
	0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b,    0, 0x4a, 
	0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x67, 0x65, 
	0x75, 0x72, 0x65, 0x65,    0, 0x54, 0x6f, 0x73, 
	0x68, 0x69, 0x61, 0x67, 0x68, 0x74, 0x2d, 0x61, 
	0x72, 0x72, 0x65, 0x65,    0, 0x41, 0x76, 0x65, 
	0x72, 0x69, 0x6c,    0, 0x4d, 0x65, 0x61, 0x6e, 
	0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65,    0, 
	0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x73, 
	0x6f, 0x75, 0x72, 0x65, 0x65,    0, 0x4d, 0x65, 
	0x61, 0x6e, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 
	0x72,    0, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 
	0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72,    0, 
	0x4d, 0x65, 0x65, 0x20, 0x48, 0x6f, 0x75, 0x6e, 
	0x65, 0x79,    0, 0x4d, 0x65, 0x65, 0x20, 0x6e, 
	0x79, 0x20, 0x4e, 0x6f, 0x6c, 0x6c, 0x69, 0x63, 
	0x6b,    0, 0xe0, 0x27,    0, 0xe1, 0x27,    0, 
	0xe2, 0x27,    0, 0xe3, 0x27,    0, 0xe4, 0x27, 
	   0, 0xe5, 0x27,    0, 0xf9, 0x27,    0, 0xf8, 
	0xe0, 0xf9, 0xe5, 0xef,    0, 0xf9, 0xf0, 0xe9, 
	   0, 0xf9, 0xec, 0xe9, 0xf9, 0xe9,    0, 0xf8, 
	0xe1, 0xe9, 0xf2, 0xe9,    0, 0xe7, 0xee, 0xe9, 
	0xf9, 0xe9,    0, 0xf9, 0xe9, 0xf9, 0xe9,    0, 
	0xf9, 0xe1, 0xfa,    0, 0xe9, 0xf0, 0xe5,    0, 
	0xf4, 0xe1, 0xf8,    0, 0xee, 0xf8, 0xf5,    0, 
	0xe0, 0xf4, 0xf8,    0, 0xee, 0xe0, 0xe9,    0, 
	0xe9, 0xe5, 0xf0,    0, 0xe9, 0xe5, 0xec,    0, 
	0xe0, 0xe5, 0xe2,    0, 0xf1, 0xf4, 0xe8,    0, 
	0xe0, 0xe5, 0xf7,    0, 0xf0, 0xe5, 0xe1,    0, 
	0xe3, 0xf6, 0xee,    0, 0xe9, 0xf0, 0xe5, 0xe0, 
	0xf8,    0, 0xf4, 0xe1, 0xf8, 0xe5, 0xe0, 0xf8, 
	   0, 0xe0, 0xf4, 0xf8, 0xe9, 0xec,    0, 0xe9, 
	0xe5, 0xf0, 0xe9,    0, 0xe9, 0xe5, 0xec, 0xe9, 
	   0, 0xe0, 0xe5, 0xe2, 0xe5, 0xf1, 0xe8,    0, 
	0xf1, 0xf4, 0xe8, 0xee, 0xe1, 0xf8,    0, 0xe0, 
	0xe5, 0xf7, 0xe8, 0xe5, 0xe1, 0xf8,    0, 0xf0, 
	0xe5, 0xe1, 0xee, 0xe1, 0xf8,    0, 0xe3, 0xf6, 
	0xee, 0xe1, 0xf8,    0, 0x25, 0x5a, 0x20, 0x25, 
	0x48, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 
	0x25, 0x59, 0x20, 0x25, 0x62, 0x20, 0x25, 0x64, 
	0x20, 0x25, 0x61,    0, 0x25, 0x49, 0x3a, 0x25, 
	0x4d, 0x3a, 0x25, 0x53, 0x20, 0x25, 0x50,    0, 
	0xd7, 0x90, 0x27,    0, 0xd7, 0x91, 0x27,    0, 
	0xd7, 0x92, 0x27,    0, 0xd7, 0x93, 0x27,    0, 
	0xd7, 0x94, 0x27,    0, 0xd7, 0x95, 0x27,    0, 
	0xd7, 0xa9, 0x27,    0, 0xd7, 0xa8, 0xd7, 0x90, 
	0xd7, 0xa9, 0xd7, 0x95, 0xd7, 0x9f,    0, 0xd7, 
	0xa9, 0xd7, 0xa0, 0xd7, 0x99,    0, 0xd7, 0xa9, 
	0xd7, 0x9c, 0xd7, 0x99, 0xd7, 0xa9, 0xd7, 0x99, 
	   0, 0xd7, 0xa8, 0xd7, 0x91, 0xd7, 0x99, 0xd7, 
	0xa2, 0xd7, 0x99,    0, 0xd7, 0x97, 0xd7, 0x9e, 
	0xd7, 0x99, 0xd7, 0xa9, 0xd7, 0x99,    0, 0xd7, 
	0xa9, 0xd7, 0x99, 0xd7, 0xa9, 0xd7, 0x99,    0, 
	0xd7, 0xa9, 0xd7, 0x91, 0xd7, 0xaa,    0, 0xd7, 
	0x99, 0xd7, 0xa0, 0xd7, 0x95,    0, 0xd7, 0xa4, 
	0xd7, 0x91, 0xd7, 0xa8,    0, 0xd7, 0x9e, 0xd7, 
	0xa8, 0xd7, 0xa5,    0, 0xd7, 0x90, 0xd7, 0xa4, 
	0xd7, 0xa8,    0, 0xd7, 0x9e, 0xd7, 0x90, 0xd7, 
	0x99,    0, 0xd7, 0x99, 0xd7, 0x95, 0xd7, 0xa0, 
	   0, 0xd7, 0x99, 0xd7, 0x95, 0xd7, 0x9c,    0, 
	0xd7, 0x90, 0xd7, 0x95, 0xd7, 0x92,    0, 0xd7, 
	0xa1, 0xd7, 0xa4, 0xd7, 0x98,    0, 0xd7, 0x90, 
	0xd7, 0x95, 0xd7, 0xa7,    0, 0xd7, 0xa0, 0xd7, 
	0x95, 0xd7, 0x91,    0, 0xd7, 0x93, 0xd7, 0xa6, 
	0xd7, 0x9e,    0, 0xd7, 0x99, 0xd7, 0xa0, 0xd7, 
	0x95, 0xd7, 0x90, 0xd7, 0xa8,    0, 0xd7, 0xa4, 
	0xd7, 0x91, 0xd7, 0xa8, 0xd7, 0x95, 0xd7, 0x90, 
	0xd7, 0xa8,    0, 0xd7, 0x90, 0xd7, 0xa4, 0xd7, 
	0xa8, 0xd7, 0x99, 0xd7, 0x9c,    0, 0xd7, 0x99, 
	0xd7, 0x95, 0xd7, 0xa0, 0xd7, 0x99,    0, 0xd7, 
	0x99, 0xd7, 0x95, 0xd7, 0x9c, 0xd7, 0x99,    0, 
	0xd7, 0x90, 0xd7, 0x95, 0xd7, 0x92, 0xd7, 0x95, 
	0xd7, 0xa1, 0xd7, 0x98,    0, 0xd7, 0xa1, 0xd7, 
	0xa4, 0xd7, 0x98, 0xd7, 0x9e, 0xd7, 0x91, 0xd7, 
	0xa8,    0, 0xd7, 0x90, 0xd7, 0x95, 0xd7, 0xa7, 
	0xd7, 0x98, 0xd7, 0x95, 0xd7, 0x91, 0xd7, 0xa8, 
	   0, 0xd7, 0xa0, 0xd7, 0x95, 0xd7, 0x91, 0xd7, 
	0x9e, 0xd7, 0x91, 0xd7, 0xa8,    0, 0xd7, 0x93, 
	0xd7, 0xa6, 0xd7, 0x9e, 0xd7, 0x91, 0xd7, 0xa8, 
	   0, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 
	0xa4, 0xbf, 0x20,    0, 0xe0, 0xa4, 0xb8, 0xe0, 
	0xa5, 0x8b, 0xe0, 0xa4, 0xae, 0x20,    0, 0xe0, 
	0xa4, 0xae, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97, 
	0xe0, 0xa4, 0xb2, 0x20,    0, 0xe0, 0xa4, 0xac, 
	0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xa7, 0x20,    0, 
	0xe0, 0xa4, 0x97, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 
	0xb0, 0xe0, 0xa5, 0x81, 0x20,    0, 0xe0, 0xa4, 
	0xb6, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x95, 0xe0, 
	0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0x20,    0, 0xe0, 
	0xa4, 0xb6, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbf, 
	0x20,    0, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 
	0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 
	0xbe, 0xe0, 0xa4, 0xb0, 0x20,    0, 0xe0, 0xa4, 
	0xb8, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xae, 0xe0, 
	0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 
	0x20,    0, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0x82, 
	0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 
	0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0x20, 
	   0, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x81, 0xe0, 
	0xa4, 0xa7, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 
	0xe0, 0xa4, 0xb0, 0x20,    0, 0xe0, 0xa4, 0x97, 
	0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 
	0x81, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 
	0xa4, 0xb0, 0x20,    0, 0xe0, 0xa4, 0xb6, 0xe0, 
	0xa5, 0x81, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 
	0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 
	0xbe, 0xe0, 0xa4, 0xb0, 0x20,    0, 0xe0, 0xa4, 
	0xb6, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbf, 0xe0, 
	0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 
	0x20,    0, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xa8, 
	0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 
	0x80,    0, 0xe0, 0xa4, 0xab, 0xe0, 0xa4, 0xbc, 
	0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 
	0xb0, 0xe0, 0xa5, 0x80,    0, 0xe0, 0xa4, 0xae, 
	0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 
	0x8d, 0xe0, 0xa4, 0x9a,    0, 0xe0, 0xa4, 0x85, 
	0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 
	0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb2,    0, 
	0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0x88,    0, 0xe0, 
	0xa4, 0x9c, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xa8, 
	   0, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x81, 0xe0, 
	0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x88, 
	   0, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0x97, 0xe0, 
	0xa4, 0xb8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 
	   0, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbf, 0xe0, 
	0xa4, 0xa4, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x8d, 
	0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xb0,    0, 0xe0, 
	0xa4, 0x85, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 
	0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 
	0xac, 0xe0, 0xa4, 0xb0,    0, 0xe0, 0xa4, 0xa8, 
	0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 
	0x8d, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xb0,    0, 
	0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 
	0xb8, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x8d, 0xe0, 
	0xa4, 0xac, 0xe0, 0xa4, 0xb0,    0, 0xe0, 0xa4, 
	0xaa, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 
	0xa5, 0x8d, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 
	0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 
	0xa8,    0, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xaa, 
	0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 
	0xb9, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa8,    0, 
	0x53, 0x69, 0x6a,    0, 0x56, 0x65, 0x6c,    0, 
	0x4f, 0xbe, 0x75,    0, 0x54, 0x72, 0x61,    0, 
	0x53, 0x76, 0x69,    0, 0x4c, 0x69, 0x70,    0, 
	0x53, 0x72, 0x70,    0, 0x4b, 0x6f, 0x6c,    0, 
	0x52, 0x75, 0x6a,    0, 0x4c, 0x69, 0x73,    0, 
	0x53, 0x74, 0x75,    0, 0x50, 0x72, 0x6f,    0, 
	0x53, 0x69, 0x6a, 0x65, 0xe8, 0x61, 0x6e, 0x6a, 
	   0, 0x56, 0x65, 0x6c, 0x6a, 0x61, 0xe8, 0x61, 
	   0, 0x4f, 0xbe, 0x75, 0x6a, 0x61, 0x6b,    0, 
	0x54, 0x72, 0x61, 0x76, 0x61, 0x6e, 0x6a,    0, 
	0x53, 0x76, 0x69, 0x62, 0x61, 0x6e, 0x6a,    0, 
	0x4c, 0x69, 0x70, 0x61, 0x6e, 0x6a,    0, 0x53, 
	0x72, 0x70, 0x61, 0x6e, 0x6a,    0, 0x4b, 0x6f, 
	0x6c, 0x6f, 0x76, 0x6f, 0x7a,    0, 0x52, 0x75, 
	0x6a, 0x61, 0x6e,    0, 0x4c, 0x69, 0x73, 0x74, 
	0x6f, 0x70, 0x61, 0x64,    0, 0x53, 0x74, 0x75, 
	0x64, 0x65, 0x6e, 0x69,    0, 0x50, 0x72, 0x6f, 
	0x73, 0x69, 0x6e, 0x61, 0x63,    0, 0x4f, 0xc5, 
	0xbe, 0x75,    0, 0x53, 0x69, 0x6a, 0x65, 0xc4, 
	0x8d, 0x61, 0x6e, 0x6a,    0, 0x56, 0x65, 0x6c, 
	0x6a, 0x61, 0xc4, 0x8d, 0x61,    0, 0x4f, 0xc5, 
	0xbe, 0x75, 0x6a, 0x61, 0x6b,    0, 0x76,    0, 
	0x68,    0, 0x6b,    0, 0x73, 0x7a, 0x65,    0, 
	0x63, 0x73,    0, 0x70,    0, 0x73, 0x7a, 0x6f, 
	   0, 0x76, 0x61, 0x73, 0xe1, 0x72, 0x6e, 0x61, 
	0x70,    0, 0x68, 0xe9, 0x74, 0x66, 0xf5,    0, 
	0x6b, 0x65, 0x64, 0x64,    0, 0x73, 0x7a, 0x65, 
	0x72, 0x64, 0x61,    0, 0x63, 0x73, 0xfc, 0x74, 
	0xf6, 0x72, 0x74, 0xf6, 0x6b,    0, 0x70, 0xe9, 
	0x6e, 0x74, 0x65, 0x6b,    0, 0x73, 0x7a, 0x6f, 
	0x6d, 0x62, 0x61, 0x74,    0, 0x6d, 0xe1, 0x72, 
	   0, 0xe1, 0x70, 0x72,    0, 0x6d, 0xe1, 0x6a, 
	   0, 0x6a, 0xfa, 0x6e,    0, 0x6a, 0xfa, 0x6c, 
	   0, 0x6a, 0x61, 0x6e, 0x75, 0xe1, 0x72,    0, 
	0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72,    0, 
	0x6d, 0xe1, 0x72, 0x63, 0x69, 0x75, 0x73,    0, 
	0xe1, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x73,    0, 
	0x6d, 0xe1, 0x6a, 0x75, 0x73,    0, 0x6a, 0xfa, 
	0x6e, 0x69, 0x75, 0x73,    0, 0x6a, 0xfa, 0x6c, 
	0x69, 0x75, 0x73,    0, 0x61, 0x75, 0x67, 0x75, 
	0x73, 0x7a, 0x74, 0x75, 0x73,    0, 0x73, 0x7a, 
	0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 
	   0, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x65, 0x72, 
	   0, 0x25, 0x59, 0x2e, 0x20, 0x25, 0x62, 0x2e, 
	0x20, 0x25, 0x65, 0x2e, 0x2c, 0x20, 0x25, 0x41, 
	0x2c, 0x20, 0x25, 0x48, 0x2e, 0x25, 0x4d, 0x2e, 
	0x25, 0x53, 0x20, 0x25, 0x5a,    0, 0x25, 0x48, 
	0x2e, 0x25, 0x4d, 0x2e, 0x25, 0x53,    0, 0x76, 
	0x61, 0x73, 0xc3, 0xa1, 0x72, 0x6e, 0x61, 0x70, 
	   0, 0x68, 0xc3, 0xa9, 0x74, 0x66, 0xc5, 0x91, 
	   0, 0x63, 0x73, 0xc3, 0xbc, 0x74, 0xc3, 0xb6, 
	0x72, 0x74, 0xc3, 0xb6, 0x6b,    0, 0x70, 0xc3, 
	0xa9, 0x6e, 0x74, 0x65, 0x6b,    0, 0x6d, 0xc3, 
	0xa1, 0x72,    0, 0xc3, 0xa1, 0x70, 0x72,    0, 
	0x6d, 0xc3, 0xa1, 0x6a,    0, 0x6a, 0xc3, 0xba, 
	0x6e,    0, 0x6a, 0xc3, 0xba, 0x6c,    0, 0x6a, 
	0x61, 0x6e, 0x75, 0xc3, 0xa1, 0x72,    0, 0x66, 
	0x65, 0x62, 0x72, 0x75, 0xc3, 0xa1, 0x72,    0, 
	0x6d, 0xc3, 0xa1, 0x72, 0x63, 0x69, 0x75, 0x73, 
	   0, 0xc3, 0xa1, 0x70, 0x72, 0x69, 0x6c, 0x69, 
	0x73,    0, 0x6d, 0xc3, 0xa1, 0x6a, 0x75, 0x73, 
	   0, 0x6a, 0xc3, 0xba, 0x6e, 0x69, 0x75, 0x73, 
	   0, 0x6a, 0xc3, 0xba, 0x6c, 0x69, 0x75, 0x73, 
	   0, 0x6f, 0x6b, 0x74, 0xc3, 0xb3, 0x62, 0x65, 
	0x72,    0, 0xce, 0xf1, 0xcf,    0, 0xba, 0xf1, 
	0xcf,    0, 0xba, 0xf1, 0xf9,    0, 0xe2, 0xf1, 
	0xf9,    0, 0xd0, 0xdd, 0xb7,    0, 0xe0, 0xf5, 
	0xf1,    0, 0xde, 0xb5, 0xc3,    0, 0xce, 0xc7, 
	0xf1, 0xb3, 0xcf, 0xc7,    0, 0xba, 0xf1, 0xcf, 
	0xe1, 0xf5, 0xdf, 0xb3, 0xb5, 0xc3, 0xc7,    0, 
	0xba, 0xf1, 0xbb, 0xf9, 0xdf, 0xb3, 0xb5, 0xc3, 
	0xc7,    0, 0xe2, 0xe1, 0xf1, 0xbb, 0xf9, 0xdf, 
	0xb3, 0xb5, 0xc3, 0xc7,    0, 0xd0, 0xc7, 0xdd, 
	0xb7, 0xdf, 0xb3, 0xb5, 0xc3, 0xc7,    0, 0xe0, 
	0xf5, 0xf1, 0xb5, 0xb3, 0xc3,    0, 0xde, 0xb3, 
	0xb5, 0xb3, 0xc3,    0, 0xd0, 0xdd, 0xed,    0, 
	0xf6, 0xef, 0xf1,    0, 0xd8, 0xb3, 0xf1,    0, 
	0xb2, 0xe5, 0xf1,    0, 0xd8, 0xb3, 0xdb,    0, 
	0xd0, 0xdd, 0xeb,    0, 0xd0, 0xc9, 0xeb,    0, 
	0xfa, 0xb7, 0xeb,    0, 0xea, 0xbb, 0xe5,    0, 
	0xd0, 0xe1, 0xcf,    0, 0xdc, 0xd9, 0xb5,    0, 
	0xb8, 0xbb, 0xcf,    0, 0xd0, 0xe1, 0xf5, 0xdd, 
	0xed, 0xb3, 0xf1, 0xc7,    0, 0xf6, 0xbb, 0xef, 
	0xf1, 0xed, 0xb3, 0xf1, 0xc7,    0, 0xd8, 0xb3, 
	0xf1, 0xef, 0xc7,    0, 0xb2, 0xe5, 0xf1, 0xc7, 
	0xc9, 0xc7,    0, 0xd8, 0xb3, 0xdb, 0xc7, 0xeb, 
	0xc7,    0, 0xd0, 0xe1, 0xf5, 0xdd, 0xc7, 0xeb, 
	0xc7,    0, 0xd0, 0xe1, 0xf5, 0xc9, 0xc7, 0xeb, 
	0xc7,    0, 0xfa, 0xb7, 0xe1, 0xeb, 0xef, 0xe1, 
	0xeb, 0xc7,    0, 0xea, 0xbb, 0xe5, 0xef, 0xbb, 
	0xd9, 0xb5, 0xbb, 0xf1, 0xc7,    0, 0xd0, 0xe1, 
	0xcf, 0xef, 0xbb, 0xd9, 0xb5, 0xbb, 0xf1, 0xc7, 
	   0, 0xdc, 0xe1, 0xdb, 0xbb, 0xd9, 0xb5, 0xbb, 
	0xf1, 0xc7,    0, 0xb8, 0xbb, 0xcf, 0xef, 0xbb, 
	0xd9, 0xb5, 0xbb, 0xf1, 0xc7,    0, 0xd4, 0xbf, 
	0xd6, 0x80, 0xd5, 0xaf,    0, 0xd4, 0xb5, 0xd6, 
	0x80, 0xd5, 0xaf,    0, 0xd4, 0xb5, 0xd6, 0x80, 
	0xd6, 0x84,    0, 0xd5, 0x89, 0xd6, 0x80, 0xd6, 
	0x84,    0, 0xd5, 0x80, 0xd5, 0xb6, 0xd5, 0xa3, 
	   0, 0xd5, 0x88, 0xd6, 0x82, 0xd6, 0x80,    0, 
	0xd5, 0x87, 0xd5, 0xa2, 0xd5, 0xa9,    0, 0xd4, 
	0xbf, 0xd5, 0xab, 0xd6, 0x80, 0xd5, 0xa1, 0xd5, 
	0xaf, 0xd5, 0xab,    0, 0xd4, 0xb5, 0xd6, 0x80, 
	0xd5, 0xaf, 0xd5, 0xb8, 0xd6, 0x82, 0xd5, 0xb7, 
	0xd5, 0xa1, 0xd5, 0xa2, 0xd5, 0xa9, 0xd5, 0xab, 
	   0, 0xd4, 0xb5, 0xd6, 0x80, 0xd5, 0xa5, 0xd6, 
	0x84, 0xd5, 0xb7, 0xd5, 0xa1, 0xd5, 0xa2, 0xd5, 
	0xa9, 0xd5, 0xab,    0, 0xd5, 0x89, 0xd5, 0xb8, 
	0xd6, 0x80, 0xd5, 0xa5, 0xd6, 0x84, 0xd5, 0xb7, 
	0xd5, 0xa1, 0xd5, 0xa2, 0xd5, 0xa9, 0xd5, 0xab, 
	   0, 0xd5, 0x80, 0xd5, 0xab, 0xd5, 0xb6, 0xd5, 
	0xa3, 0xd5, 0xb7, 0xd5, 0xa1, 0xd5, 0xa2, 0xd5, 
	0xa9, 0xd5, 0xab,    0, 0xd5, 0x88, 0xd6, 0x82, 
	0xd6, 0x80, 0xd5, 0xa2, 0xd5, 0xa1, 0xd5, 0xa9, 
	   0, 0xd5, 0x87, 0xd5, 0xa1, 0xd5, 0xa2, 0xd5, 
	0xa1, 0xd5, 0xa9,    0, 0xd5, 0x80, 0xd5, 0xb6, 
	0xd5, 0xbe,    0, 0xd5, 0x93, 0xd5, 0xbf, 0xd6, 
	0x80,    0, 0xd5, 0x84, 0xd5, 0xa1, 0xd6, 0x80, 
	   0, 0xd4, 0xb1, 0xd5, 0xba, 0xd6, 0x80,    0, 
	0xd5, 0x84, 0xd5, 0xa1, 0xd5, 0xb5,    0, 0xd5, 
	0x80, 0xd5, 0xb6, 0xd5, 0xbd,    0, 0xd5, 0x80, 
	0xd5, 0xac, 0xd5, 0xbd,    0, 0xd5, 0x95, 0xd5, 
	0xa3, 0xd5, 0xbd,    0, 0xd5, 0x8d, 0xd5, 0xa5, 
	0xd5, 0xba,    0, 0xd5, 0x80, 0xd5, 0xb8, 0xd5, 
	0xaf,    0, 0xd5, 0x86, 0xd5, 0xb4, 0xd5, 0xa2, 
	   0, 0xd4, 0xb4, 0xd5, 0xa5, 0xd5, 0xaf,    0, 
	0xd5, 0x80, 0xd5, 0xb8, 0xd6, 0x82, 0xd5, 0xb6, 
	0xd5, 0xbe, 0xd5, 0xa1, 0xd6, 0x80, 0xd5, 0xab, 
	   0, 0xd5, 0x93, 0xd5, 0xa5, 0xd5, 0xbf, 0xd6, 
	0x80, 0xd5, 0xbe, 0xd5, 0xa1, 0xd6, 0x80, 0xd5, 
	0xab,    0, 0xd5, 0x84, 0xd5, 0xa1, 0xd6, 0x80, 
	0xd5, 0xbf, 0xd5, 0xab,    0, 0xd4, 0xb1, 0xd5, 
	0xba, 0xd6, 0x80, 0xd5, 0xab, 0xd5, 0xac, 0xd5, 
	0xab,    0, 0xd5, 0x84, 0xd5, 0xa1, 0xd5, 0xb5, 
	0xd5, 0xab, 0xd5, 0xbd, 0xd5, 0xab,    0, 0xd5, 
	0x80, 0xd5, 0xb8, 0xd6, 0x82, 0xd5, 0xb6, 0xd5, 
	0xab, 0xd5, 0xbd, 0xd5, 0xab,    0, 0xd5, 0x80, 
	0xd5, 0xb8, 0xd6, 0x82, 0xd5, 0xac, 0xd5, 0xab, 
	0xd5, 0xbd, 0xd5, 0xab,    0, 0xd5, 0x95, 0xd5, 
	0xa3, 0xd5, 0xb8, 0xd5, 0xbd, 0xd5, 0xbf, 0xd5, 
	0xb8, 0xd5, 0xbd, 0xd5, 0xab,    0, 0xd5, 0x8d, 
	0xd5, 0xa5, 0xd5, 0xba, 0xd5, 0xbf, 0xd5, 0xa5, 
	0xd5, 0xb4, 0xd5, 0xa2, 0xd5, 0xa5, 0xd6, 0x80, 
	0xd5, 0xab,    0, 0xd5, 0x80, 0xd5, 0xb8, 0xd5, 
	0xaf, 0xd5, 0xbf, 0xd5, 0xa5, 0xd5, 0xb4, 0xd5, 
	0xa2, 0xd5, 0xa5, 0xd6, 0x80, 0xd5, 0xab,    0, 
	0xd5, 0x86, 0xd5, 0xb8, 0xd5, 0xb5, 0xd5, 0xa5, 
	0xd5, 0xb4, 0xd5, 0xa2, 0xd5, 0xa5, 0xd6, 0x80, 
	0xd5, 0xab,    0, 0xd4, 0xb4, 0xd5, 0xa5, 0xd5, 
	0xaf, 0xd5, 0xbf, 0xd5, 0xa5, 0xd5, 0xb4, 0xd5, 
	0xa2, 0xd5, 0xa5, 0xd6, 0x80, 0xd5, 0xab,    0, 
	0x4d, 0x69, 0x6e,    0, 0x53, 0x65, 0x6c,    0, 
	0x52, 0x61, 0x62,    0, 0x4b, 0x61, 0x6d,    0, 
	0x4a, 0x75, 0x6d,    0, 0x53, 0x61, 0x62,    0, 
	0x4d, 0x69, 0x6e, 0x67, 0x67, 0x75,    0, 0x53, 
	0x65, 0x6e, 0x69, 0x6e,    0, 0x53, 0x65, 0x6c, 
	0x61, 0x73, 0x61,    0, 0x52, 0x61, 0x62, 0x75, 
	   0, 0x4b, 0x61, 0x6d, 0x69, 0x73,    0, 0x4a, 
	0x75, 0x6d, 0x61, 0x74,    0, 0x53, 0x61, 0x62, 
	0x74, 0x75,    0, 0x50, 0x65, 0x62,    0, 0x41, 
	0x67, 0x75,    0, 0x4a, 0x61, 0x6e, 0x75, 0x61, 
	0x72, 0x69,    0, 0x50, 0x65, 0x62, 0x72, 0x75, 
	0x61, 0x72, 0x69,    0, 0x4d, 0x61, 0x72, 0x65, 
	0x74,    0, 0x41, 0x67, 0x75, 0x73, 0x74, 0x75, 
	0x73,    0, 0x4d, 0xe1, 0x6e,    0, 0xde, 0x72, 
	0x69,    0, 0x4d, 0x69, 0xf0,    0, 0x46, 0x69, 
	0x6d,    0, 0x46, 0xf6, 0x73,    0, 0x4c, 0x61, 
	0x75,    0, 0x53, 0x75, 0x6e, 0x6e, 0x75, 0x64, 
	0x61, 0x67, 0x75, 0x72,    0, 0x4d, 0xe1, 0x6e, 
	0x75, 0x64, 0x61, 0x67, 0x75, 0x72,    0, 0xde, 
	0x72, 0x69, 0xf0, 0x6a, 0x75, 0x64, 0x61, 0x67, 
	0x75, 0x72,    0, 0x4d, 0x69, 0xf0, 0x76, 0x69, 
	0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72,    0, 
	0x46, 0x69, 0x6d, 0x6d, 0x74, 0x75, 0x64, 0x61, 
	0x67, 0x75, 0x72,    0, 0x46, 0xf6, 0x73, 0x74, 
	0x75, 0x64, 0x61, 0x67, 0x75, 0x72,    0, 0x4c, 
	0x61, 0x75, 0x67, 0x61, 0x72, 0x64, 0x61, 0x67, 
	0x75, 0x72,    0, 0x4d, 0x61, 0xed,    0, 0x4a, 
	0xfa, 0x6e,    0, 0x4a, 0xfa, 0x6c,    0, 0xc1, 
	0x67, 0xfa,    0, 0x4e, 0xf3, 0x76,    0, 0x4a, 
	0x61, 0x6e, 0xfa, 0x61, 0x72,    0, 0x46, 0x65, 
	0x62, 0x72, 0xfa, 0x61, 0x72,    0, 0x4d, 0x61, 
	0x72, 0x73,    0, 0x41, 0x70, 0x72, 0xed, 0x6c, 
	   0, 0x4a, 0xfa, 0x6e, 0xed,    0, 0x4a, 0xfa, 
	0x6c, 0xed,    0, 0xc1, 0x67, 0xfa, 0x73, 0x74, 
	   0, 0x4f, 0x6b, 0x74, 0xf3, 0x62, 0x65, 0x72, 
	   0, 0x4e, 0xf3, 0x76, 0x65, 0x6d, 0x62, 0x65, 
	0x72,    0, 0x66, 0x68,    0, 0x65, 0x68,    0, 
	0x25, 0x61, 0x20, 0x25, 0x65, 0x2e, 0x25, 0x62, 
	0x20, 0x25, 0x59, 0x2c, 0x20, 0x25, 0x54, 0x20, 
	0x25, 0x5a,    0, 0x25, 0x61, 0x20, 0x25, 0x65, 
	0x2e, 0x25, 0x62, 0x20, 0x25, 0x59,    0, 0x4d, 
	0xc3, 0xa1, 0x6e,    0, 0xc3, 0x9e, 0x72, 0x69, 
	   0, 0x4d, 0x69, 0xc3, 0xb0,    0, 0x46, 0xc3, 
	0xb6, 0x73,    0, 0x4d, 0xc3, 0xa1, 0x6e, 0x75, 
	0x64, 0x61, 0x67, 0x75, 0x72,    0, 0xc3, 0x9e, 
	0x72, 0x69, 0xc3, 0xb0, 0x6a, 0x75, 0x64, 0x61, 
	0x67, 0x75, 0x72,    0, 0x4d, 0x69, 0xc3, 0xb0, 
	0x76, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 
	0x72,    0, 0x46, 0xc3, 0xb6, 0x73, 0x74, 0x75, 
	0x64, 0x61, 0x67, 0x75, 0x72,    0, 0x4d, 0x61, 
	0xc3, 0xad,    0, 0x4a, 0xc3, 0xba, 0x6e,    0, 
	0x4a, 0xc3, 0xba, 0x6c,    0, 0xc3, 0x81, 0x67, 
	0xc3, 0xba,    0, 0x4e, 0xc3, 0xb3, 0x76,    0, 
	0x4a, 0x61, 0x6e, 0xc3, 0xba, 0x61, 0x72,    0, 
	0x46, 0x65, 0x62, 0x72, 0xc3, 0xba, 0x61, 0x72, 
	   0, 0x41, 0x70, 0x72, 0xc3, 0xad, 0x6c,    0, 
	0x4a, 0xc3, 0xba, 0x6e, 0xc3, 0xad,    0, 0x4a, 
	0xc3, 0xba, 0x6c, 0xc3, 0xad,    0, 0xc3, 0x81, 
	0x67, 0xc3, 0xba, 0x73, 0x74,    0, 0x4f, 0x6b, 
	0x74, 0xc3, 0xb3, 0x62, 0x65, 0x72,    0, 0x4e, 
	0xc3, 0xb3, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 
	   0, 0x67, 0x69, 0x6f,    0, 0x64, 0x6f, 0x6d, 
	0x65, 0x6e, 0x69, 0x63, 0x61,    0, 0x6c, 0x75, 
	0x6e, 0x65, 0x64, 0xec,    0, 0x6d, 0x61, 0x72, 
	0x74, 0x65, 0x64, 0xec,    0, 0x6d, 0x65, 0x72, 
	0x63, 0x6f, 0x6c, 0x65, 0x64, 0xec,    0, 0x67, 
	0x69, 0x6f, 0x76, 0x65, 0x64, 0xec,    0, 0x76, 
	0x65, 0x6e, 0x65, 0x72, 0x64, 0xec,    0, 0x6d, 
	0x61, 0x67,    0, 0x67, 0x69, 0x75,    0, 0x6c, 
	0x75, 0x67,    0, 0x6f, 0x74, 0x74,    0, 0x67, 
	0x65, 0x6e, 0x6e, 0x61, 0x69, 0x6f,    0, 0x66, 
	0x65, 0x62, 0x62, 0x72, 0x61, 0x69, 0x6f,    0, 
	0x61, 0x70, 0x72, 0x69, 0x6c, 0x65,    0, 0x6d, 
	0x61, 0x67, 0x67, 0x69, 0x6f,    0, 0x67, 0x69, 
	0x75, 0x67, 0x6e, 0x6f,    0, 0x6c, 0x75, 0x67, 
	0x6c, 0x69, 0x6f,    0, 0x73, 0x65, 0x74, 0x74, 
	0x65, 0x6d, 0x62, 0x72, 0x65,    0, 0x6f, 0x74, 
	0x74, 0x6f, 0x62, 0x72, 0x65,    0, 0x64, 0x69, 
	0x63, 0x65, 0x6d, 0x62, 0x72, 0x65,    0, 0x6c, 
	0x75, 0x6e, 0x65, 0x64, 0xc3, 0xac,    0, 0x6d, 
	0x61, 0x72, 0x74, 0x65, 0x64, 0xc3, 0xac,    0, 
	0x6d, 0x65, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x64, 
	0xc3, 0xac,    0, 0x67, 0x69, 0x6f, 0x76, 0x65, 
	0x64, 0xc3, 0xac,    0, 0x76, 0x65, 0x6e, 0x65, 
	0x72, 0x64, 0xc3, 0xac,    0, 0xe6, 0x97, 0xa5, 
	   0, 0xe6, 0x9c, 0x88,    0, 0xe7, 0x81, 0xab, 
	   0, 0xe6, 0xb0, 0xb4,    0, 0xe6, 0x9c, 0xa8, 
	   0, 0xe9, 0x87, 0x91,    0, 0xe5, 0x9c, 0x9f, 
	   0, 0xe6, 0x97, 0xa5, 0xe6, 0x9b, 0x9c, 0xe6, 
	0x97, 0xa5,    0, 0xe6, 0x9c, 0x88, 0xe6, 0x9b, 
	0x9c, 0xe6, 0x97, 0xa5,    0, 0xe7, 0x81, 0xab, 
	0xe6, 0x9b, 0x9c, 0xe6, 0x97, 0xa5,    0, 0xe6, 
	0xb0, 0xb4, 0xe6, 0x9b, 0x9c, 0xe6, 0x97, 0xa5, 
	   0, 0xe6, 0x9c, 0xa8, 0xe6, 0x9b, 0x9c, 0xe6, 
	0x97, 0xa5,    0, 0xe9, 0x87, 0x91, 0xe6, 0x9b, 
	0x9c, 0xe6, 0x97, 0xa5,    0, 0xe5, 0x9c, 0x9f, 
	0xe6, 0x9b, 0x9c, 0xe6, 0x97, 0xa5,    0, 0x20, 
	0x31, 0xe6, 0x9c, 0x88,    0, 0x20, 0x32, 0xe6, 
	0x9c, 0x88,    0, 0x20, 0x33, 0xe6, 0x9c, 0x88, 
	   0, 0x20, 0x34, 0xe6, 0x9c, 0x88,    0, 0x20, 
	0x35, 0xe6, 0x9c, 0x88,    0, 0x20, 0x36, 0xe6, 
	0x9c, 0x88,    0, 0x20, 0x37, 0xe6, 0x9c, 0x88, 
	   0, 0x20, 0x38, 0xe6, 0x9c, 0x88,    0, 0x20, 
	0x39, 0xe6, 0x9c, 0x88,    0, 0x31, 0x30, 0xe6, 
	0x9c, 0x88,    0, 0x31, 0x31, 0xe6, 0x9c, 0x88, 
	   0, 0x31, 0x32, 0xe6, 0x9c, 0x88,    0, 0x31, 
	0xe6, 0x9c, 0x88,    0, 0x32, 0xe6, 0x9c, 0x88, 
	   0, 0x33, 0xe6, 0x9c, 0x88,    0, 0x34, 0xe6, 
	0x9c, 0x88,    0, 0x35, 0xe6, 0x9c, 0x88,    0, 
	0x36, 0xe6, 0x9c, 0x88,    0, 0x37, 0xe6, 0x9c, 
	0x88,    0, 0x38, 0xe6, 0x9c, 0x88,    0, 0x39, 
	0xe6, 0x9c, 0x88,    0, 0xe5, 0x8d, 0x88, 0xe5, 
	0x89, 0x8d,    0, 0xe5, 0x8d, 0x88, 0xe5, 0xbe, 
	0x8c,    0, 0x25, 0x59, 0xe5, 0xb9, 0xb4, 0x25, 
	0x6d, 0xe6, 0x9c, 0x88, 0x25, 0x64, 0xe6, 0x97, 
	0xa5, 0x20, 0x25, 0x48, 0xe6, 0x99, 0x82, 0x25, 
	0x4d, 0xe5, 0x88, 0x86, 0x25, 0x53, 0xe7, 0xa7, 
	0x92,    0, 0x25, 0x59, 0xe5, 0xb9, 0xb4, 0x25, 
	0x6d, 0xe6, 0x9c, 0x88, 0x25, 0x64, 0xe6, 0x97, 
	0xa5,    0, 0x25, 0x48, 0xe6, 0x99, 0x82, 0x25, 
	0x4d, 0xe5, 0x88, 0x86, 0x25, 0x53, 0xe7, 0xa7, 
	0x92,    0, 0x25, 0x70, 0x25, 0x49, 0xe6, 0x99, 
	0x82, 0x25, 0x4d, 0xe5, 0x88, 0x86, 0x25, 0x53, 
	0xe7, 0xa7, 0x92,    0, 0x2b, 0x3a, 0x32, 0x3a, 
	0x31, 0x39, 0x39, 0x30, 0x2f, 0x30, 0x31, 0x2f, 
	0x30, 0x31, 0x3a, 0x2b, 0x2a, 0x3a, 0xe5, 0xb9, 
	0xb3, 0xe6, 0x88, 0x90, 0x3a, 0x25, 0x45, 0x43, 
	0x25, 0x45, 0x79, 0xe5, 0xb9, 0xb4,    0, 0x2b, 
	0x3a, 0x31, 0x3a, 0x31, 0x39, 0x38, 0x39, 0x2f, 
	0x30, 0x31, 0x2f, 0x30, 0x38, 0x3a, 0x31, 0x39, 
	0x38, 0x39, 0x2f, 0x31, 0x32, 0x2f, 0x33, 0x31, 
	0x3a, 0xe5, 0xb9, 0xb3, 0xe6, 0x88, 0x90, 0x3a, 
	0x25, 0x45, 0x43, 0xe5, 0x85, 0x83, 0xe5, 0xb9, 
	0xb4,    0, 0x2b, 0x3a, 0x32, 0x3a, 0x31, 0x39, 
	0x32, 0x37, 0x2f, 0x30, 0x31, 0x2f, 0x30, 0x31, 
	0x3a, 0x31, 0x39, 0x38, 0x39, 0x2f, 0x30, 0x31, 
	0x2f, 0x30, 0x37, 0x3a, 0xe6, 0x98, 0xad, 0xe5, 
	0x92, 0x8c, 0x3a, 0x25, 0x45, 0x43, 0x25, 0x45, 
	0x79, 0xe5, 0xb9, 0xb4,    0, 0x2b, 0x3a, 0x31, 
	0x3a, 0x31, 0x39, 0x32, 0x36, 0x2f, 0x31, 0x32, 
	0x2f, 0x32, 0x35, 0x3a, 0x31, 0x39, 0x32, 0x36, 
	0x2f, 0x31, 0x32, 0x2f, 0x33, 0x31, 0x3a, 0xe6, 
	0x98, 0xad, 0xe5, 0x92, 0x8c, 0x3a, 0x25, 0x45, 
	0x43, 0xe5, 0x85, 0x83, 0xe5, 0xb9, 0xb4,    0, 
	0x2b, 0x3a, 0x32, 0x3a, 0x31, 0x39, 0x31, 0x33, 
	0x2f, 0x30, 0x31, 0x2f, 0x30, 0x31, 0x3a, 0x31, 
	0x39, 0x32, 0x36, 0x2f, 0x31, 0x32, 0x2f, 0x32, 
	0x34, 0x3a, 0xe5, 0xa4, 0xa7, 0xe6, 0xad, 0xa3, 
	0x3a, 0x25, 0x45, 0x43, 0x25, 0x45, 0x79, 0xe5, 
	0xb9, 0xb4,    0, 0x2b, 0x3a, 0x32, 0x3a, 0x31, 
	0x39, 0x31, 0x32, 0x2f, 0x30, 0x37, 0x2f, 0x33, 
	0x30, 0x3a, 0x31, 0x39, 0x31, 0x32, 0x2f, 0x31, 
	0x32, 0x2f, 0x33, 0x31, 0x3a, 0xe5, 0xa4, 0xa7, 
	0xe6, 0xad, 0xa3, 0x3a, 0x25, 0x45, 0x43, 0xe5, 
	0x85, 0x83, 0xe5, 0xb9, 0xb4,    0, 0x2b, 0x3a, 
	0x36, 0x3a, 0x31, 0x38, 0x37, 0x33, 0x2f, 0x30, 
	0x31, 0x2f, 0x30, 0x31, 0x3a, 0x31, 0x39, 0x31, 
	0x32, 0x2f, 0x30, 0x37, 0x2f, 0x32, 0x39, 0x3a, 
	0xe6, 0x98, 0x8e, 0xe6, 0xb2, 0xbb, 0x3a, 0x25, 
	0x45, 0x43, 0x25, 0x45, 0x79, 0xe5, 0xb9, 0xb4, 
	   0, 0x2b, 0x3a, 0x31, 0x3a, 0x30, 0x30, 0x30, 
	0x31, 0x2f, 0x30, 0x31, 0x2f, 0x30, 0x31, 0x3a, 
	0x31, 0x38, 0x37, 0x32, 0x2f, 0x31, 0x32, 0x2f, 
	0x33, 0x31, 0x3a, 0xe8, 0xa5, 0xbf, 0xe6, 0x9a, 
	0xa6, 0x3a, 0x25, 0x45, 0x43, 0x25, 0x45, 0x79, 
	0xe5, 0xb9, 0xb4,    0, 0x2b, 0x3a, 0x31, 0x3a, 
	0x2d, 0x30, 0x30, 0x30, 0x31, 0x2f, 0x31, 0x32, 
	0x2f, 0x33, 0x31, 0x3a, 0x2d, 0x2a, 0x3a, 0xe7, 
	0xb4, 0x80, 0xe5, 0x85, 0x83, 0xe5, 0x89, 0x8d, 
	0x3a, 0x25, 0x45, 0x43, 0x25, 0x45, 0x79, 0xe5, 
	0xb9, 0xb4,    0,    0, 0x25, 0x45, 0x59, 0x25, 
	0x6d, 0xe6, 0x9c, 0x88, 0x25, 0x64, 0xe6, 0x97, 
	0xa5,    0, 0xe3, 0x80, 0x87,    0, 0xe4, 0xb8, 
	0x80,    0, 0xe4, 0xba, 0x8c,    0, 0xe4, 0xb8, 
	0x89,    0, 0xe5, 0x9b, 0x9b,    0, 0xe4, 0xba, 
	0x94,    0, 0xe5, 0x85, 0xad,    0, 0xe4, 0xb8, 
	0x83,    0, 0xe5, 0x85, 0xab,    0, 0xe4, 0xb9, 
	0x9d,    0, 0xe5, 0x8d, 0x81,    0, 0xe5, 0x8d, 
	0x81, 0xe4, 0xb8, 0x80,    0, 0xe5, 0x8d, 0x81, 
	0xe4, 0xba, 0x8c,    0, 0xe5, 0x8d, 0x81, 0xe4, 
	0xb8, 0x89,    0, 0xe5, 0x8d, 0x81, 0xe5, 0x9b, 
	0x9b,    0, 0xe5, 0x8d, 0x81, 0xe4, 0xba, 0x94, 
	   0, 0xe5, 0x8d, 0x81, 0xe5, 0x85, 0xad,    0, 
	0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x83,    0, 0xe5, 
	0x8d, 0x81, 0xe5, 0x85, 0xab,    0, 0xe5, 0x8d, 
	0x81, 0xe4, 0xb9, 0x9d,    0, 0xe4, 0xba, 0x8c, 
	0xe5, 0x8d, 0x81,    0, 0xe4, 0xba, 0x8c, 0xe5, 
	0x8d, 0x81, 0xe4, 0xb8, 0x80,    0, 0xe4, 0xba, 
	0x8c, 0xe5, 0x8d, 0x81, 0xe4, 0xba, 0x8c,    0, 
	0xe4, 0xba, 0x8c, 0xe5, 0x8d, 0x81, 0xe4, 0xb8, 
	0x89,    0, 0xe4, 0xba, 0x8c, 0xe5, 0x8d, 0x81, 
	0xe5, 0x9b, 0x9b,    0, 0xe4, 0xba, 0x8c, 0xe5, 
	0x8d, 0x81, 0xe4, 0xba, 0x94,    0, 0xe4, 0xba, 
	0x8c, 0xe5, 0x8d, 0x81, 0xe5, 0x85, 0xad,    0, 
	0xe4, 0xba, 0x8c, 0xe5, 0x8d, 0x81, 0xe4, 0xb8, 
	0x83,    0, 0xe4, 0xba, 0x8c, 0xe5, 0x8d, 0x81, 
	0xe5, 0x85, 0xab,    0, 0xe4, 0xba, 0x8c, 0xe5, 
	0x8d, 0x81, 0xe4, 0xb9, 0x9d,    0, 0xe4, 0xb8, 
	0x89, 0xe5, 0x8d, 0x81,    0, 0xe4, 0xb8, 0x89, 
	0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x80,    0, 0xe4, 
	0xb8, 0x89, 0xe5, 0x8d, 0x81, 0xe4, 0xba, 0x8c, 
	   0, 0xe4, 0xb8, 0x89, 0xe5, 0x8d, 0x81, 0xe4, 
	0xb8, 0x89,    0, 0xe4, 0xb8, 0x89, 0xe5, 0x8d, 
	0x81, 0xe5, 0x9b, 0x9b,    0, 0xe4, 0xb8, 0x89, 
	0xe5, 0x8d, 0x81, 0xe4, 0xba, 0x94,    0, 0xe4, 
	0xb8, 0x89, 0xe5, 0x8d, 0x81, 0xe5, 0x85, 0xad, 
	   0, 0xe4, 0xb8, 0x89, 0xe5, 0x8d, 0x81, 0xe4, 
	0xb8, 0x83,    0, 0xe4, 0xb8, 0x89, 0xe5, 0x8d, 
	0x81, 0xe5, 0x85, 0xab,    0, 0xe4, 0xb8, 0x89, 
	0xe5, 0x8d, 0x81, 0xe4, 0xb9, 0x9d,    0, 0xe5, 
	0x9b, 0x9b, 0xe5, 0x8d, 0x81,    0, 0xe5, 0x9b, 
	0x9b, 0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x80,    0, 
	0xe5, 0x9b, 0x9b, 0xe5, 0x8d, 0x81, 0xe4, 0xba, 
	0x8c,    0, 0xe5, 0x9b, 0x9b, 0xe5, 0x8d, 0x81, 
	0xe4, 0xb8, 0x89,    0, 0xe5, 0x9b, 0x9b, 0xe5, 
	0x8d, 0x81, 0xe5, 0x9b, 0x9b,    0, 0xe5, 0x9b, 
	0x9b, 0xe5, 0x8d, 0x81, 0xe4, 0xba, 0x94,    0, 
	0xe5, 0x9b, 0x9b, 0xe5, 0x8d, 0x81, 0xe5, 0x85, 
	0xad,    0, 0xe5, 0x9b, 0x9b, 0xe5, 0x8d, 0x81, 
	0xe4, 0xb8, 0x83,    0, 0xe5, 0x9b, 0x9b, 0xe5, 
	0x8d, 0x81, 0xe5, 0x85, 0xab,    0, 0xe5, 0x9b, 
	0x9b, 0xe5, 0x8d, 0x81, 0xe4, 0xb9, 0x9d,    0, 
	0xe4, 0xba, 0x94, 0xe5, 0x8d, 0x81,    0, 0xe4, 
	0xba, 0x94, 0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x80, 
	   0, 0xe4, 0xba, 0x94, 0xe5, 0x8d, 0x81, 0xe4, 
	0xba, 0x8c,    0, 0xe4, 0xba, 0x94, 0xe5, 0x8d, 
	0x81, 0xe4, 0xb8, 0x89,    0, 0xe4, 0xba, 0x94, 
	0xe5, 0x8d, 0x81, 0xe5, 0x9b, 0x9b,    0, 0xe4, 
	0xba, 0x94, 0xe5, 0x8d, 0x81, 0xe4, 0xba, 0x94, 
	   0, 0xe4, 0xba, 0x94, 0xe5, 0x8d, 0x81, 0xe5, 
	0x85, 0xad,    0, 0xe4, 0xba, 0x94, 0xe5, 0x8d, 
	0x81, 0xe4, 0xb8, 0x83,    0, 0xe4, 0xba, 0x94, 
	0xe5, 0x8d, 0x81, 0xe5, 0x85, 0xab,    0, 0xe4, 
	0xba, 0x94, 0xe5, 0x8d, 0x81, 0xe4, 0xb9, 0x9d, 
	   0, 0xe5, 0x85, 0xad, 0xe5, 0x8d, 0x81,    0, 
	0xe5, 0x85, 0xad, 0xe5, 0x8d, 0x81, 0xe4, 0xb8, 
	0x80,    0, 0xe5, 0x85, 0xad, 0xe5, 0x8d, 0x81, 
	0xe4, 0xba, 0x8c,    0, 0xe5, 0x85, 0xad, 0xe5, 
	0x8d, 0x81, 0xe4, 0xb8, 0x89,    0, 0xe5, 0x85, 
	0xad, 0xe5, 0x8d, 0x81, 0xe5, 0x9b, 0x9b,    0, 
	0xe5, 0x85, 0xad, 0xe5, 0x8d, 0x81, 0xe4, 0xba, 
	0x94,    0, 0xe5, 0x85, 0xad, 0xe5, 0x8d, 0x81, 
	0xe5, 0x85, 0xad,    0, 0xe5, 0x85, 0xad, 0xe5, 
	0x8d, 0x81, 0xe4, 0xb8, 0x83,    0, 0xe5, 0x85, 
	0xad, 0xe5, 0x8d, 0x81, 0xe5, 0x85, 0xab,    0, 
	0xe5, 0x85, 0xad, 0xe5, 0x8d, 0x81, 0xe4, 0xb9, 
	0x9d,    0, 0xe4, 0xb8, 0x83, 0xe5, 0x8d, 0x81, 
	   0, 0xe4, 0xb8, 0x83, 0xe5, 0x8d, 0x81, 0xe4, 
	0xb8, 0x80,    0, 0xe4, 0xb8, 0x83, 0xe5, 0x8d, 
	0x81, 0xe4, 0xba, 0x8c,    0, 0xe4, 0xb8, 0x83, 
	0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x89,    0, 0xe4, 
	0xb8, 0x83, 0xe5, 0x8d, 0x81, 0xe5, 0x9b, 0x9b, 
	   0, 0xe4, 0xb8, 0x83, 0xe5, 0x8d, 0x81, 0xe4, 
	0xba, 0x94,    0, 0xe4, 0xb8, 0x83, 0xe5, 0x8d, 
	0x81, 0xe5, 0x85, 0xad,    0, 0xe4, 0xb8, 0x83, 
	0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x83,    0, 0xe4, 
	0xb8, 0x83, 0xe5, 0x8d, 0x81, 0xe5, 0x85, 0xab, 
	   0, 0xe4, 0xb8, 0x83, 0xe5, 0x8d, 0x81, 0xe4, 
	0xb9, 0x9d,    0, 0xe5, 0x85, 0xab, 0xe5, 0x8d, 
	0x81,    0, 0xe5, 0x85, 0xab, 0xe5, 0x8d, 0x81, 
	0xe4, 0xb8, 0x80,    0, 0xe5, 0x85, 0xab, 0xe5, 
	0x8d, 0x81, 0xe4, 0xba, 0x8c,    0, 0xe5, 0x85, 
	0xab, 0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x89,    0, 
	0xe5, 0x85, 0xab, 0xe5, 0x8d, 0x81, 0xe5, 0x9b, 
	0x9b,    0, 0xe5, 0x85, 0xab, 0xe5, 0x8d, 0x81, 
	0xe4, 0xba, 0x94,    0, 0xe5, 0x85, 0xab, 0xe5, 
	0x8d, 0x81, 0xe5, 0x85, 0xad,    0, 0xe5, 0x85, 
	0xab, 0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x83,    0, 
	0xe5, 0x85, 0xab, 0xe5, 0x8d, 0x81, 0xe5, 0x85, 
	0xab,    0, 0xe5, 0x85, 0xab, 0xe5, 0x8d, 0x81, 
	0xe4, 0xb9, 0x9d,    0, 0xe4, 0xb9, 0x9d, 0xe5, 
	0x8d, 0x81,    0, 0xe4, 0xb9, 0x9d, 0xe5, 0x8d, 
	0x81, 0xe4, 0xb8, 0x80,    0, 0xe4, 0xb9, 0x9d, 
	0xe5, 0x8d, 0x81, 0xe4, 0xba, 0x8c,    0, 0xe4, 
	0xb9, 0x9d, 0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x89, 
	   0, 0xe4, 0xb9, 0x9d, 0xe5, 0x8d, 0x81, 0xe5, 
	0x9b, 0x9b,    0, 0xe4, 0xb9, 0x9d, 0xe5, 0x8d, 
	0x81, 0xe4, 0xba, 0x94,    0, 0xe4, 0xb9, 0x9d, 
	0xe5, 0x8d, 0x81, 0xe5, 0x85, 0xad,    0, 0xe4, 
	0xb9, 0x9d, 0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x83, 
	   0, 0xe4, 0xb9, 0x9d, 0xe5, 0x8d, 0x81, 0xe5, 
	0x85, 0xab,    0, 0xe4, 0xb9, 0x9d, 0xe5, 0x8d, 
	0x81, 0xe4, 0xb9, 0x9d,    0, 0x25, 0x45, 0x59, 
	0x25, 0x6d, 0xe6, 0x9c, 0x88, 0x25, 0x64, 0xe6, 
	0x97, 0xa5, 0x20, 0x25, 0x48, 0xe6, 0x99, 0x82, 
	0x25, 0x4d, 0xe5, 0x88, 0x86, 0x25, 0x53, 0xe7, 
	0xa7, 0x92,    0, 0xca, 0xc5, 0xc9,    0, 0xcf, 
	0xd2, 0xdb,    0, 0xd3, 0xc0, 0xcc,    0, 0xcf, 
	0xc8, 0xe1,    0, 0xe1, 0xd6, 0xc8,    0, 0xd0, 
	0xc0, 0xd2,    0, 0xdb, 0xc0, 0xc1,    0, 0xca, 
	0xc5, 0xc9, 0xd2, 0xc0,    0, 0xcf, 0xd2, 0xdb, 
	0xc0, 0xc1, 0xc0, 0xc8, 0xc9,    0, 0xd3, 0xc0, 
	0xcc, 0xdb, 0xc0, 0xc1, 0xc0, 0xc8, 0xc9,    0, 
	0xcf, 0xc8, 0xe1, 0xdb, 0xc0, 0xc1, 0xc0, 0xc8, 
	0xc9,    0, 0xe1, 0xd6, 0xc8, 0xdb, 0xc0, 0xc1, 
	0xc0, 0xc8, 0xc9,    0, 0xd0, 0xc0, 0xd2, 0xc0, 
	0xd3, 0xca, 0xc4, 0xc5, 0xc9,    0, 0xdb, 0xc0, 
	0xc1, 0xc0, 0xc8, 0xc9,    0, 0xc9, 0xc0, 0xcd, 
	   0, 0xc8, 0xc4, 0xc1,    0, 0xcc, 0xc0, 0xd2, 
	   0, 0xc0, 0xd0, 0xd2,    0, 0xcc, 0xc0, 0xc9, 
	   0, 0xc9, 0xc5, 0xcd,    0, 0xc9, 0xc5, 0xcb, 
	   0, 0xc0, 0xc2, 0xc5,    0, 0xd3, 0xc4, 0xd8, 
	   0, 0xcf, 0xd8, 0xd4,    0, 0xcd, 0xcf, 0xc4, 
	   0, 0xc3, 0xc4, 0xca,    0, 0xc9, 0xc0, 0xcd, 
	0xc5, 0xc0, 0xd2, 0xc9,    0, 0xc8, 0xc4, 0xc1, 
	0xc4, 0xd2, 0xc5, 0xc0, 0xcb, 0xc9,    0, 0xcc, 
	0xc0, 0xd2, 0xd4, 0xc9,    0, 0xc0, 0xd0, 0xd2, 
	0xc9, 0xcb, 0xc9,    0, 0xcc, 0xc0, 0xc9, 0xd3, 
	0xc9,    0, 0xc9, 0xc5, 0xcd, 0xc9, 0xd3, 0xc9, 
	   0, 0xc9, 0xc5, 0xcb, 0xc9, 0xd3, 0xc9,    0, 
	0xc0, 0xc2, 0xc5, 0xc9, 0xd3, 0xd4, 0xcf,    0, 
	0xd3, 0xc4, 0xd8, 0xd4, 0xc4, 0xcc, 0xc1, 0xc4, 
	0xd2, 0xc9,    0, 0xcf, 0xd8, 0xd4, 0xcf, 0xcc, 
	0xc1, 0xc4, 0xd2, 0xc9,    0, 0xcd, 0xcf, 0xc4, 
	0xcc, 0xc1, 0xc4, 0xd2, 0xc9,    0, 0xc3, 0xc4, 
	0xca, 0xc4, 0xcc, 0xc1, 0xc4, 0xd2, 0xc9,    0, 
	0x25, 0x59, 0x20, 0xdf, 0xcb, 0xc9, 0xd3, 0x20, 
	0x25, 0x64, 0x20, 0x25, 0x42, 0x2c, 0x20, 0x25, 
	0x54, 0x20, 0x25, 0x5a,    0, 0xe1, 0x83, 0x99, 
	0xe1, 0x83, 0x95, 0xe1, 0x83, 0x98,    0, 0xe1, 
	0x83, 0x9d, 0xe1, 0x83, 0xa0, 0xe1, 0x83, 0xa8, 
	   0, 0xe1, 0x83, 0xa1, 0xe1, 0x83, 0x90, 0xe1, 
	0x83, 0x9b,    0, 0xe1, 0x83, 0x9d, 0xe1, 0x83, 
	0x97, 0xe1, 0x83, 0xae,    0, 0xe1, 0x83, 0xae, 
	0xe1, 0x83, 0xa3, 0xe1, 0x83, 0x97,    0, 0xe1, 
	0x83, 0x9e, 0xe1, 0x83, 0x90, 0xe1, 0x83, 0xa0, 
	   0, 0xe1, 0x83, 0xa8, 0xe1, 0x83, 0x90, 0xe1, 
	0x83, 0x91,    0, 0xe1, 0x83, 0x99, 0xe1, 0x83, 
	0x95, 0xe1, 0x83, 0x98, 0xe1, 0x83, 0xa0, 0xe1, 
	0x83, 0x90,    0, 0xe1, 0x83, 0x9d, 0xe1, 0x83, 
	0xa0, 0xe1, 0x83, 0xa8, 0xe1, 0x83, 0x90, 0xe1, 
	0x83, 0x91, 0xe1, 0x83, 0x90, 0xe1, 0x83, 0x97, 
	0xe1, 0x83, 0x98,    0, 0xe1, 0x83, 0xa1, 0xe1, 
	0x83, 0x90, 0xe1, 0x83, 0x9b, 0xe1, 0x83, 0xa8, 
	0xe1, 0x83, 0x90, 0xe1, 0x83, 0x91, 0xe1, 0x83, 
	0x90, 0xe1, 0x83, 0x97, 0xe1, 0x83, 0x98,    0, 
	0xe1, 0x83, 0x9d, 0xe1, 0x83, 0x97, 0xe1, 0x83, 
	0xae, 0xe1, 0x83, 0xa8, 0xe1, 0x83, 0x90, 0xe1, 
	0x83, 0x91, 0xe1, 0x83, 0x90, 0xe1, 0x83, 0x97, 
	0xe1, 0x83, 0x98,    0, 0xe1, 0x83, 0xae, 0xe1, 
	0x83, 0xa3, 0xe1, 0x83, 0x97, 0xe1, 0x83, 0xa8, 
	0xe1, 0x83, 0x90, 0xe1, 0x83, 0x91, 0xe1, 0x83, 
	0x90, 0xe1, 0x83, 0x97, 0xe1, 0x83, 0x98,    0, 
	0xe1, 0x83, 0x9e, 0xe1, 0x83, 0x90, 0xe1, 0x83, 
	0xa0, 0xe1, 0x83, 0x90, 0xe1, 0x83, 0xa1, 0xe1, 
	0x83, 0x99, 0xe1, 0x83, 0x94, 0xe1, 0x83, 0x95, 
	0xe1, 0x83, 0x98,    0, 0xe1, 0x83, 0xa8, 0xe1, 
	0x83, 0x90, 0xe1, 0x83, 0x91, 0xe1, 0x83, 0x90, 
	0xe1, 0x83, 0x97, 0xe1, 0x83, 0x98,    0, 0xe1, 
	0x83, 0x98, 0xe1, 0x83, 0x90, 0xe1, 0x83, 0x9c, 
	   0, 0xe1, 0x83, 0x97, 0xe1, 0x83, 0x94, 0xe1, 
	0x83, 0x91,    0, 0xe1, 0x83, 0x9b, 0xe1, 0x83, 
	0x90, 0xe1, 0x83, 0xa0,    0, 0xe1, 0x83, 0x90, 
	0xe1, 0x83, 0x9e, 0xe1, 0x83, 0xa0,    0, 0xe1, 
	0x83, 0x9b, 0xe1, 0x83, 0x90, 0xe1, 0x83, 0x98, 
	   0, 0xe1, 0x83, 0x98, 0xe1, 0x83, 0x95, 0xe1, 
	0x83, 0x9c,    0, 0xe1, 0x83, 0x98, 0xe1, 0x83, 
	0x95, 0xe1, 0x83, 0x9a,    0, 0xe1, 0x83, 0x90, 
	0xe1, 0x83, 0x92, 0xe1, 0x83, 0x95,    0, 0xe1, 
	0x83, 0xa1, 0xe1, 0x83, 0x94, 0xe1, 0x83, 0xa5, 
	   0, 0xe1, 0x83, 0x9d, 0xe1, 0x83, 0xa5, 0xe1, 
	0x83, 0xa2,    0, 0xe1, 0x83, 0x9c, 0xe1, 0x83, 
	0x9d, 0xe1, 0x83, 0x94,    0, 0xe1, 0x83, 0x93, 
	0xe1, 0x83, 0x94, 0xe1, 0x83, 0x99,    0, 0xe1, 
	0x83, 0x98, 0xe1, 0x83, 0x90, 0xe1, 0x83, 0x9c, 
	0xe1, 0x83, 0x95, 0xe1, 0x83, 0x90, 0xe1, 0x83, 
	0xa0, 0xe1, 0x83, 0x98,    0, 0xe1, 0x83, 0x97, 
	0xe1, 0x83, 0x94, 0xe1, 0x83, 0x91, 0xe1, 0x83, 
	0x94, 0xe1, 0x83, 0xa0, 0xe1, 0x83, 0x95, 0xe1, 
	0x83, 0x90, 0xe1, 0x83, 0x9a, 0xe1, 0x83, 0x98, 
	   0, 0xe1, 0x83, 0x9b, 0xe1, 0x83, 0x90, 0xe1, 
	0x83, 0xa0, 0xe1, 0x83, 0xa2, 0xe1, 0x83, 0x98, 
	   0, 0xe1, 0x83, 0x90, 0xe1, 0x83, 0x9e, 0xe1, 
	0x83, 0xa0, 0xe1, 0x83, 0x98, 0xe1, 0x83, 0x9a, 
	0xe1, 0x83, 0x98,    0, 0xe1, 0x83, 0x9b, 0xe1, 
	0x83, 0x90, 0xe1, 0x83, 0x98, 0xe1, 0x83, 0xa1, 
	0xe1, 0x83, 0x98,    0, 0xe1, 0x83, 0x98, 0xe1, 
	0x83, 0x95, 0xe1, 0x83, 0x9c, 0xe1, 0x83, 0x98, 
	0xe1, 0x83, 0xa1, 0xe1, 0x83, 0x98,    0, 0xe1, 
	0x83, 0x98, 0xe1, 0x83, 0x95, 0xe1, 0x83, 0x9a, 
	0xe1, 0x83, 0x98, 0xe1, 0x83, 0xa1, 0xe1, 0x83, 
	0x98,    0, 0xe1, 0x83, 0x90, 0xe1, 0x83, 0x92, 
	0xe1, 0x83, 0x95, 0xe1, 0x83, 0x98, 0xe1, 0x83, 
	0xa1, 0xe1, 0x83, 0xa2, 0xe1, 0x83, 0x9d,    0, 
	0xe1, 0x83, 0xa1, 0xe1, 0x83, 0x94, 0xe1, 0x83, 
	0xa5, 0xe1, 0x83, 0xa2, 0xe1, 0x83, 0x94, 0xe1, 
	0x83, 0x9b, 0xe1, 0x83, 0x91, 0xe1, 0x83, 0x94, 
	0xe1, 0x83, 0xa0, 0xe1, 0x83, 0x98,    0, 0xe1, 
	0x83, 0x9d, 0xe1, 0x83, 0xa5, 0xe1, 0x83, 0xa2, 
	0xe1, 0x83, 0x9d, 0xe1, 0x83, 0x9b, 0xe1, 0x83, 
	0x91, 0xe1, 0x83, 0x94, 0xe1, 0x83, 0xa0, 0xe1, 
	0x83, 0x98,    0, 0xe1, 0x83, 0x9c, 0xe1, 0x83, 
	0x9d, 0xe1, 0x83, 0x94, 0xe1, 0x83, 0x9b, 0xe1, 
	0x83, 0x91, 0xe1, 0x83, 0x94, 0xe1, 0x83, 0xa0, 
	0xe1, 0x83, 0x98,    0, 0xe1, 0x83, 0x93, 0xe1, 
	0x83, 0x94, 0xe1, 0x83, 0x99, 0xe1, 0x83, 0x94, 
	0xe1, 0x83, 0x9b, 0xe1, 0x83, 0x91, 0xe1, 0x83, 
	0x94, 0xe1, 0x83, 0xa0, 0xe1, 0x83, 0x98,    0, 
	0x25, 0x59, 0x20, 0xe1, 0x83, 0xac, 0xe1, 0x83, 
	0x9a, 0xe1, 0x83, 0x98, 0xe1, 0x83, 0xa1, 0x20, 
	0x25, 0x64, 0x20, 0x25, 0x42, 0x2c, 0x20, 0x25, 
	0x54, 0x20, 0x25, 0x5a,    0, 0x61, 0x74, 0x61, 
	   0, 0x70, 0x69, 0x6e,    0, 0x73, 0x69, 0x73, 
	   0, 0x74, 0x61, 0x6c,    0, 0x61, 0x72, 0x66, 
	   0, 0x73, 0x61, 0x62, 0x61, 0x61, 0x74,    0, 
	0x61, 0x74, 0x61, 0x61, 0x73, 0x69, 0x6e, 0x6e, 
	0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71,    0, 0x6d, 
	0x61, 0x72, 0x6c, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 
	0x72, 0x6e, 0x65, 0x71,    0, 0x70, 0x69, 0x6e, 
	0x67, 0x61, 0x73, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 
	0x72, 0x6e, 0x65, 0x71,    0, 0x73, 0x69, 0x73, 
	0x61, 0x6d, 0x61, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 
	0x6e, 0x65, 0x71,    0, 0x74, 0x61, 0x6c, 0x6c, 
	0x69, 0x6d, 0x61, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 
	0x6e, 0x65, 0x71,    0, 0x61, 0x72, 0x66, 0x69, 
	0x6e, 0x69, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 
	0x65, 0x71,    0, 0x6a, 0x61, 0x6e, 0x75, 0x61, 
	0x72, 0x69,    0, 0x66, 0x65, 0x62, 0x72, 0x75, 
	0x61, 0x72, 0x69,    0, 0x6d, 0x61, 0x72, 0x74, 
	0x73, 0x69,    0, 0x61, 0x70, 0x72, 0x69, 0x6c, 
	0x69,    0, 0x6d, 0x61, 0x6a, 0x69,    0, 0x61, 
	0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x69, 
	   0, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 
	0x65, 0x72, 0x69,    0, 0x6f, 0x6b, 0x74, 0x6f, 
	0x62, 0x65, 0x72, 0x69,    0, 0x6e, 0x6f, 0x76, 
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x69,    0, 0x64, 
	0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x69, 
	   0, 0x25, 0x64, 0x20, 0x25, 0x62, 0x20, 0x25, 
	0x59,    0, 0xec, 0x9d, 0xbc,    0, 0xec, 0x9b, 
	0x94,    0, 0xed, 0x99, 0x94,    0, 0xec, 0x88, 
	0x98,    0, 0xeb, 0xaa, 0xa9,    0, 0xea, 0xb8, 
	0x88,    0, 0xed, 0x86, 0xa0,    0, 0xec, 0x9d, 
	0xbc, 0xec, 0x9a, 0x94, 0xec, 0x9d, 0xbc,    0, 
	0xec, 0x9b, 0x94, 0xec, 0x9a, 0x94, 0xec, 0x9d, 
	0xbc,    0, 0xed, 0x99, 0x94, 0xec, 0x9a, 0x94, 
	0xec, 0x9d, 0xbc,    0, 0xec, 0x88, 0x98, 0xec, 
	0x9a, 0x94, 0xec, 0x9d, 0xbc,    0, 0xeb, 0xaa, 
	0xa9, 0xec, 0x9a, 0x94, 0xec, 0x9d, 0xbc,    0, 
	0xea, 0xb8, 0x88, 0xec, 0x9a, 0x94, 0xec, 0x9d, 
	0xbc,    0, 0xed, 0x86, 0xa0, 0xec, 0x9a, 0x94, 
	0xec, 0x9d, 0xbc,    0, 0x20, 0x31, 0xec, 0x9b, 
	0x94,    0, 0x20, 0x32, 0xec, 0x9b, 0x94,    0, 
	0x20, 0x33, 0xec, 0x9b, 0x94,    0, 0x20, 0x34, 
	0xec, 0x9b, 0x94,    0, 0x20, 0x35, 0xec, 0x9b, 
	0x94,    0, 0x20, 0x36, 0xec, 0x9b, 0x94,    0, 
	0x20, 0x37, 0xec, 0x9b, 0x94,    0, 0x20, 0x38, 
	0xec, 0x9b, 0x94,    0, 0x20, 0x39, 0xec, 0x9b, 
	0x94,    0, 0x31, 0x30, 0xec, 0x9b, 0x94,    0, 
	0x31, 0x31, 0xec, 0x9b, 0x94,    0, 0x31, 0x32, 
	0xec, 0x9b, 0x94,    0, 0xec, 0x9d, 0xbc, 0xec, 
	0x9b, 0x94,    0, 0xec, 0x9d, 0xb4, 0xec, 0x9b, 
	0x94,    0, 0xec, 0x82, 0xbc, 0xec, 0x9b, 0x94, 
	   0, 0xec, 0x82, 0xac, 0xec, 0x9b, 0x94,    0, 
	0xec, 0x98, 0xa4, 0xec, 0x9b, 0x94,    0, 0xec, 
	0x9c, 0xa0, 0xec, 0x9b, 0x94,    0, 0xec, 0xb9, 
	0xa0, 0xec, 0x9b, 0x94,    0, 0xed, 0x8c, 0x94, 
	0xec, 0x9b, 0x94,    0, 0xea, 0xb5, 0xac, 0xec, 
	0x9b, 0x94,    0, 0xec, 0x8b, 0x9c, 0xec, 0x9b, 
	0x94,    0, 0xec, 0x8b, 0xad, 0xec, 0x9d, 0xbc, 
	0xec, 0x9b, 0x94,    0, 0xec, 0x8b, 0xad, 0xec, 
	0x9d, 0xb4, 0xec, 0x9b, 0x94,    0, 0xec, 0x98, 
	0xa4, 0xec, 0xa0, 0x84,    0, 0xec, 0x98, 0xa4, 
	0xed, 0x9b, 0x84,    0, 0x25, 0x78, 0x20, 0x28, 
	0x25, 0x61, 0x29, 0x20, 0x25, 0x72,    0, 0x25, 
	0x59, 0xeb, 0x85, 0x84, 0x20, 0x25, 0x6d, 0xec, 
	0x9b, 0x94, 0x20, 0x25, 0x64, 0xec, 0x9d, 0xbc, 
	   0, 0x25, 0x48, 0xec, 0x8b, 0x9c, 0x20, 0x25, 
	0x4d, 0xeb, 0xb6, 0x84, 0x20, 0x25, 0x53, 0xec, 
	0xb4, 0x88,    0, 0x25, 0x70, 0x20, 0x25, 0x49, 
	0xec, 0x8b, 0x9c, 0x20, 0x25, 0x4d, 0xeb, 0xb6, 
	0x84, 0x20, 0x25, 0x53, 0xec, 0xb4, 0x88,    0, 
	0x4d, 0x74, 0x68,    0, 0x4d, 0x68, 0x72,    0, 
	0x59, 0x6f, 0x77,    0, 0x44, 0x65, 0x20, 0x53, 
	0x75, 0x6c,    0, 0x44, 0x65, 0x20, 0x4c, 0x75, 
	0x6e,    0, 0x44, 0x65, 0x20, 0x4d, 0x65, 0x72, 
	0x74, 0x68,    0, 0x44, 0x65, 0x20, 0x4d, 0x65, 
	0x72, 0x68, 0x65, 0x72,    0, 0x44, 0x65, 0x20, 
	0x59, 0x6f, 0x77,    0, 0x44, 0x65, 0x20, 0x47, 
	0x77, 0x65, 0x6e, 0x65, 0x72,    0, 0x44, 0x65, 
	0x20, 0x53, 0x61, 0x64, 0x6f, 0x72, 0x6e,    0, 
	0x47, 0x65, 0x6e,    0, 0x57, 0x68, 0x65, 0x3e, 
	   0, 0x4d, 0x65,    0, 0x45, 0x76, 0x6e,    0, 
	0x45, 0x73, 0x74,    0, 0x47, 0x77, 0x6e,    0, 
	0x48, 0x65, 0x64,    0, 0x4b, 0x65, 0x76,    0, 
	0x4d, 0x79, 0x73, 0x20, 0x47, 0x65, 0x6e, 0x76, 
	0x65, 0x72,    0, 0x4d, 0x79, 0x73, 0x20, 0x57, 
	0x68, 0x65, 0x76, 0x72, 0x65, 0x6c,    0, 0x4d, 
	0x79, 0x73, 0x20, 0x4d, 0x65, 0x72, 0x74, 0x68, 
	   0, 0x4d, 0x79, 0x73, 0x20, 0x45, 0x62, 0x72, 
	0x65, 0x6c,    0, 0x4d, 0x79, 0x73, 0x20, 0x4d, 
	0x65,    0, 0x4d, 0x79, 0x73, 0x20, 0x45, 0x76, 
	0x61, 0x6e,    0, 0x4d, 0x79, 0x73, 0x20, 0x47, 
	0x6f, 0x72, 0x74, 0x68, 0x65, 0x72, 0x65, 0x6e, 
	   0, 0x4d, 0x79, 0x65, 0x20, 0x45, 0x73, 0x74, 
	   0, 0x4d, 0x79, 0x73, 0x20, 0x47, 0x77, 0x79, 
	0x6e, 0x67, 0x61, 0x6c, 0x61,    0, 0x4d, 0x79, 
	0x73, 0x20, 0x48, 0x65, 0x64, 0x72, 0x61,    0, 
	0x4d, 0x79, 0x73, 0x20, 0x44, 0x75,    0, 0x4d, 
	0x79, 0x73, 0x20, 0x4b, 0x65, 0x76, 0x61, 0x72, 
	0x64, 0x68, 0x75,    0, 0x53, 0x6b,    0, 0x50, 
	0x72,    0, 0x41, 0x6e,    0, 0x54, 0x72,    0, 
	0x4b, 0x74,    0, 0x50, 0x6e,    0, 0xd0, 0x74, 
	   0, 0x53, 0x65, 0x6b, 0x6d, 0x61, 0x64, 0x69, 
	0x65, 0x6e, 0x69, 0x73,    0, 0x50, 0x69, 0x72, 
	0x6d, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 
	   0, 0x41, 0x6e, 0x74, 0x72, 0x61, 0x64, 0x69, 
	0x65, 0x6e, 0x69, 0x73,    0, 0x54, 0x72, 0x65, 
	0xe8, 0x69, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 
	0x73,    0, 0x4b, 0x65, 0x74, 0x76, 0x69, 0x72, 
	0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 
	   0, 0x50, 0x65, 0x6e, 0x6b, 0x74, 0x61, 0x64, 
	0x69, 0x65, 0x6e, 0x69, 0x73,    0, 0xd0, 0x65, 
	0xf0, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 
	0x73,    0, 0x53, 0x61, 0x75,    0, 0x56, 0x61, 
	0x73,    0, 0x4b, 0x6f, 0x76,    0, 0x42, 0x61, 
	0x6c,    0, 0x47, 0x65, 0x67,    0, 0x42, 0x69, 
	0x72,    0, 0x4c, 0x69, 0x65,    0, 0x52, 0x67, 
	0x70,    0, 0x52, 0x67, 0x73,    0, 0x53, 0x70, 
	0x61,    0, 0x4c, 0x61, 0x70,    0, 0x47, 0x72, 
	0x64,    0, 0x73, 0x61, 0x75, 0x73, 0x69, 0x6f, 
	   0, 0x76, 0x61, 0x73, 0x61, 0x72, 0x69, 0x6f, 
	   0, 0x6b, 0x6f, 0x76, 0x6f,    0, 0x62, 0x61, 
	0x6c, 0x61, 0x6e, 0x64, 0xfe, 0x69, 0x6f,    0, 
	0x67, 0x65, 0x67, 0x75, 0xfe, 0xeb, 0x73,    0, 
	0x62, 0x69, 0x72, 0xfe, 0x65, 0x6c, 0x69, 0x6f, 
	   0, 0x6c, 0x69, 0x65, 0x70, 0x6f, 0x73,    0, 
	0x72, 0x75, 0x67, 0x70, 0x6a, 0xfb, 0xe8, 0x69, 
	0x6f,    0, 0x72, 0x75, 0x67, 0x73, 0xeb, 0x6a, 
	0x6f,    0, 0x73, 0x70, 0x61, 0x6c, 0x69, 0x6f, 
	   0, 0x6c, 0x61, 0x70, 0x6b, 0x72, 0x69, 0xe8, 
	0x69, 0x6f,    0, 0x67, 0x72, 0x75, 0x6f, 0x64, 
	0xfe, 0x69, 0x6f,    0, 0x25, 0x59, 0x20, 0x6d, 
	0x2e, 0x20, 0x25, 0x42, 0x20, 0x25, 0x64, 0x20, 
	0x64, 0x2e, 0x20, 0x25, 0x54,    0, 0x25, 0x59, 
	0x2e, 0x25, 0x6d, 0x2e, 0x25, 0x64,    0, 0xc5, 
	0xa0, 0x74,    0, 0x54, 0x72, 0x65, 0xc4, 0x8d, 
	0x69, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 
	   0, 0xc5, 0xa0, 0x65, 0xc5, 0xa1, 0x74, 0x61, 
	0x64, 0x69, 0x65, 0x6e, 0x69, 0x73,    0, 0x62, 
	0x61, 0x6c, 0x61, 0x6e, 0x64, 0xc5, 0xbe, 0x69, 
	0x6f,    0, 0x67, 0x65, 0x67, 0x75, 0xc5, 0xbe, 
	0xc4, 0x97, 0x73,    0, 0x62, 0x69, 0x72, 0xc5, 
	0xbe, 0x65, 0x6c, 0x69, 0x6f,    0, 0x72, 0x75, 
	0x67, 0x70, 0x6a, 0xc5, 0xab, 0xc4, 0x8d, 0x69, 
	0x6f,    0, 0x72, 0x75, 0x67, 0x73, 0xc4, 0x97, 
	0x6a, 0x6f,    0, 0x6c, 0x61, 0x70, 0x6b, 0x72, 
	0x69, 0xc4, 0x8d, 0x69, 0x6f,    0, 0x67, 0x72, 
	0x75, 0x6f, 0x64, 0xc5, 0xbe, 0x69, 0x6f,    0, 
	0x53, 0x76,    0, 0x50, 0xa0,    0, 0x4f, 0xa0, 
	   0, 0x54, 0xa0,    0, 0x43, 0xa0,    0, 0x50, 
	0x6b,    0, 0x53, 0xa0,    0, 0x73, 0x76, 0xe7, 
	0x74, 0x64, 0x69, 0x65, 0x6e, 0x61,    0, 0x70, 
	0x69, 0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e, 0x61, 
	   0, 0x6f, 0x74, 0x72, 0x64, 0x69, 0x65, 0x6e, 
	0x61,    0, 0x74, 0x72, 0x65, 0xf0, 0x64, 0x69, 
	0x65, 0x6e, 0x61,    0, 0x63, 0x65, 0x74, 0x75, 
	0x72, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61,    0, 
	0x70, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x69, 0x65, 
	0x6e, 0x61,    0, 0x73, 0x65, 0x73, 0x74, 0x64, 
	0x69, 0x65, 0x6e, 0x61,    0, 0x6a, 0xfb, 0x6e, 
	   0, 0x6a, 0xfb, 0x6c,    0, 0x6a, 0x61, 0x6e, 
	0x76, 0xe2, 0x72, 0x69, 0x73,    0, 0x66, 0x65, 
	0x62, 0x72, 0x75, 0xe2, 0x72, 0x69, 0x73,    0, 
	0x61, 0x70, 0x72, 0xee, 0x6c, 0x69, 0x73,    0, 
	0x6d, 0x61, 0x69, 0x6a, 0x73,    0, 0x6a, 0xfb, 
	0x6e, 0x69, 0x6a, 0x73,    0, 0x6a, 0xfb, 0x6c, 
	0x69, 0x6a, 0x73,    0, 0x61, 0x75, 0x67, 0x75, 
	0x73, 0x74, 0x73,    0, 0x73, 0x65, 0x70, 0x74, 
	0x65, 0x6d, 0x62, 0x72, 0x69, 0x73,    0, 0x6f, 
	0x6b, 0x74, 0x6f, 0x62, 0x72, 0x69, 0x73,    0, 
	0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x69, 
	0x73,    0, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 
	0x72, 0x69, 0x73,    0, 0x25, 0x41, 0x2c, 0x20, 
	0x25, 0x59, 0x2e, 0x20, 0x67, 0x61, 0x64, 0x61, 
	0x20, 0x25, 0x65, 0x2e, 0x20, 0x25, 0x42, 0x2c, 
	0x20, 0x70, 0x6c, 0x6b, 0x73, 0x74, 0x2e, 0x20, 
	0x25, 0x48, 0x20, 0x75, 0x6e, 0x20, 0x25, 0x4d, 
	   0, 0x25, 0x59, 0x2e, 0x25, 0x6d, 0x2e, 0x25, 
	0x64, 0x2e,    0, 0x50, 0xc2, 0xa0,    0, 0x4f, 
	0xc2, 0xa0,    0, 0x54, 0xc2, 0xa0,    0, 0x43, 
	0xc2, 0xa0,    0, 0x53, 0xc2, 0xa0,    0, 0x73, 
	0x76, 0xc4, 0x93, 0x74, 0x64, 0x69, 0x65, 0x6e, 
	0x61,    0, 0x74, 0x72, 0x65, 0xc5, 0xa1, 0x64, 
	0x69, 0x65, 0x6e, 0x61,    0, 0x6a, 0xc5, 0xab, 
	0x6e,    0, 0x6a, 0xc5, 0xab, 0x6c,    0, 0x6a, 
	0x61, 0x6e, 0x76, 0xc4, 0x81, 0x72, 0x69, 0x73, 
	   0, 0x66, 0x65, 0x62, 0x72, 0x75, 0xc4, 0x81, 
	0x72, 0x69, 0x73,    0, 0x61, 0x70, 0x72, 0xc4, 
	0xab, 0x6c, 0x69, 0x73,    0, 0x6a, 0xc5, 0xab, 
	0x6e, 0x69, 0x6a, 0x73,    0, 0x6a, 0xc5, 0xab, 
	0x6c, 0x69, 0x6a, 0x73,    0, 0x54, 0x61,    0, 
	0x54, 0xfb,    0, 0x57, 0x65,    0, 0x54, 0xe2, 
	0x69,    0, 0x50, 0x61,    0, 0x48, 0xe2,    0, 
	0x52, 0xe2, 0x74, 0x61, 0x70, 0x75,    0, 0x4d, 
	0x61, 0x6e, 0x65,    0, 0x54, 0xfb, 0x72, 0x65, 
	0x69,    0, 0x57, 0x65, 0x6e, 0x65, 0x72, 0x65, 
	0x69,    0, 0x54, 0xe2, 0x69, 0x74, 0x65,    0, 
	0x50, 0x61, 0x72, 0x61, 0x69, 0x72, 0x65,    0, 
	0x48, 0xe2, 0x74, 0x61, 0x72, 0x65, 0x69,    0, 
	0x4b, 0x6f, 0x68, 0x69,    0, 0x48, 0x75, 0x69, 
	   0, 0x50, 0x6f, 0x75,    0, 0x50, 0x61, 0x65, 
	   0, 0x48, 0x61, 0x72, 0x61,    0, 0x50, 0x69, 
	0x70, 0x69,    0, 0x48, 0xf4, 0x6e, 0x67, 0x6f, 
	0x69,    0, 0x4d, 0x61, 0x68, 0x75,    0, 0x57, 
	0x68, 0x69, 0x2d, 0x6e, 0x75,    0, 0x57, 0x68, 
	0x69, 0x2d, 0x72, 0x61,    0, 0x48, 0x61, 0x6b, 
	0x69,    0, 0x4b, 0x6f, 0x68, 0x69, 0x2d, 0x74, 
	0xe2, 0x74, 0x65, 0x61,    0, 0x48, 0x75, 0x69, 
	0x2d, 0x74, 0x61, 0x6e, 0x67, 0x75, 0x72, 0x75, 
	   0, 0x50, 0x6f, 0x75, 0x74, 0xfb, 0x2d, 0x74, 
	0x65, 0x2d, 0x72, 0x61, 0x6e, 0x67, 0x69,    0, 
	0x50, 0x61, 0x65, 0x6e, 0x67, 0x61, 0x2d, 0x77, 
	0x68, 0xe2, 0x77, 0x68, 0xe2,    0, 0x48, 0x61, 
	0x72, 0x61, 0x74, 0x75, 0x61,    0, 0x50, 0x69, 
	0x70, 0x69, 0x72, 0x69,    0, 0x48, 0xf4, 0x6e, 
	0x67, 0x6f, 0x69, 0x6e, 0x67, 0x6f, 0x69,    0, 
	0x48, 0x65, 0x72, 0x65, 0x2d, 0x74, 0x75, 0x72, 
	0x69, 0x2d, 0x6b, 0xf4, 0x6b, 0xe2,    0, 0x4d, 
	0x61, 0x68, 0x75, 0x72, 0x75,    0, 0x57, 0x68, 
	0x69, 0x72, 0x69, 0x6e, 0x67, 0x61, 0x2d, 0xe2, 
	0x2d, 0x6e, 0x75, 0x6b, 0x75,    0, 0x57, 0x68, 
	0x69, 0x72, 0x69, 0x6e, 0x67, 0x61, 0x2d, 0xe2, 
	0x2d, 0x72, 0x61, 0x6e, 0x67, 0x69,    0, 0x48, 
	0x61, 0x6b, 0x69, 0x68, 0x65, 0x61,    0, 0x54, 
	0x65, 0x20, 0x25, 0x41, 0x2c, 0x20, 0x74, 0x65, 
	0x20, 0x25, 0x64, 0x20, 0x6f, 0x20, 0x25, 0x42, 
	0x2c, 0x20, 0x25, 0x59, 0x20, 0x25, 0x54, 0x20, 
	0x25, 0x5a,    0, 0x54, 0xc5, 0xab,    0, 0x54, 
	0xc4, 0x81, 0x69,    0, 0x48, 0xc4, 0x81,    0, 
	0x52, 0xc4, 0x81, 0x74, 0x61, 0x70, 0x75,    0, 
	0x54, 0xc5, 0xab, 0x72, 0x65, 0x69,    0, 0x54, 
	0xc4, 0x81, 0x69, 0x74, 0x65,    0, 0x48, 0xc4, 
	0x81, 0x74, 0x61, 0x72, 0x65, 0x69,    0, 0x48, 
	0xc5, 0x8d, 0x6e, 0x67, 0x6f, 0x69,    0, 0x4b, 
	0x6f, 0x68, 0x69, 0x2d, 0x74, 0xc4, 0x81, 0x74, 
	0x65, 0x61,    0, 0x50, 0x6f, 0x75, 0x74, 0xc5, 
	0xab, 0x2d, 0x74, 0x65, 0x2d, 0x72, 0x61, 0x6e, 
	0x67, 0x69,    0, 0x50, 0x61, 0x65, 0x6e, 0x67, 
	0x61, 0x2d, 0x77, 0x68, 0xc4, 0x81, 0x77, 0x68, 
	0xc4, 0x81,    0, 0x48, 0xc5, 0x8d, 0x6e, 0x67, 
	0x6f, 0x69, 0x6e, 0x67, 0x6f, 0x69,    0, 0x48, 
	0x65, 0x72, 0x65, 0x2d, 0x74, 0x75, 0x72, 0x69, 
	0x2d, 0x6b, 0xc5, 0x8d, 0x6b, 0xc4, 0x81,    0, 
	0x57, 0x68, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x61, 
	0x2d, 0xc4, 0x81, 0x2d, 0x6e, 0x75, 0x6b, 0x75, 
	   0, 0x57, 0x68, 0x69, 0x72, 0x69, 0x6e, 0x67, 
	0x61, 0x2d, 0xc4, 0x81, 0x2d, 0x72, 0x61, 0x6e, 
	0x67, 0x69,    0, 0xdd, 0xd5, 0xd4,    0, 0xdf, 
	0xde, 0xdd,    0, 0xd2, 0xe2, 0xde,    0, 0xe1, 
	0xe0, 0xd5,    0, 0xe7, 0xd5, 0xe2,    0, 0xdf, 
	0xd5, 0xe2,    0, 0xe1, 0xd0, 0xd1,    0, 0xdd, 
	0xd5, 0xd4, 0xd5, 0xdb, 0xd0,    0, 0xdf, 0xde, 
	0xdd, 0xd5, 0xd4, 0xd5, 0xdb, 0xdd, 0xd8, 0xda, 
	   0, 0xd2, 0xe2, 0xde, 0xe0, 0xdd, 0xd8, 0xda, 
	   0, 0xe1, 0xe0, 0xd5, 0xd4, 0xd0,    0, 0xe7, 
	0xd5, 0xe2, 0xd2, 0xe0, 0xe2, 0xde, 0xda,    0, 
	0xdf, 0xd5, 0xe2, 0xde, 0xda,    0, 0xe1, 0xd0, 
	0xd1, 0xde, 0xe2, 0xd0,    0, 0xf8, 0xd0, 0xdd, 
	   0, 0xe4, 0xd5, 0xd2,    0, 0xdc, 0xd0, 0xe0, 
	   0, 0xd0, 0xdf, 0xe0,    0, 0xdc, 0xd0, 0xf8, 
	   0, 0xf8, 0xe3, 0xdd,    0, 0xf8, 0xe3, 0xdb, 
	   0, 0xd0, 0xd2, 0xd3,    0, 0xe1, 0xd5, 0xdf, 
	   0, 0xde, 0xda, 0xe2,    0, 0xdd, 0xde, 0xd5, 
	   0, 0xd4, 0xd5, 0xda,    0, 0xf8, 0xd0, 0xdd, 
	0xe3, 0xd0, 0xe0, 0xd8,    0, 0xe4, 0xd5, 0xd2, 
	0xe0, 0xe3, 0xd0, 0xe0, 0xd8,    0, 0xdc, 0xd0, 
	0xe0, 0xe2,    0, 0xd0, 0xdf, 0xe0, 0xd8, 0xdb, 
	   0, 0xf8, 0xe3, 0xdd, 0xd8,    0, 0xf8, 0xe3, 
	0xdb, 0xd8,    0, 0xd0, 0xd2, 0xd3, 0xe3, 0xe1, 
	0xe2,    0, 0xe1, 0xd5, 0xdf, 0xe2, 0xd5, 0xdc, 
	0xd2, 0xe0, 0xd8,    0, 0xde, 0xda, 0xe2, 0xde, 
	0xdc, 0xd2, 0xe0, 0xd8,    0, 0xdd, 0xde, 0xd5, 
	0xdc, 0xd2, 0xe0, 0xd8,    0, 0xd4, 0xd5, 0xda, 
	0xd5, 0xdc, 0xd2, 0xe0, 0xd8,    0, 0x25, 0x61, 
	0x2c, 0x20, 0x25, 0x64, 0x20, 0x25, 0x62, 0x20, 
	0x25, 0x59, 0x20, 0x25, 0x54, 0x20, 0x25, 0x5a, 
	   0, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb4,    0, 
	0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xbd,    0, 0xd0, 
	0xb2, 0xd1, 0x82, 0xd0, 0xbe,    0, 0xd1, 0x81, 
	0xd1, 0x80, 0xd0, 0xb5,    0, 0xd1, 0x87, 0xd0, 
	0xb5, 0xd1, 0x82,    0, 0xd0, 0xbf, 0xd0, 0xb5, 
	0xd1, 0x82,    0, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 
	0xb1,    0, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb4, 
	0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xb0,    0, 0xd1, 
	0x81, 0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 
	0xb0,    0, 0xd1, 0x87, 0xd0, 0xb5, 0xd1, 0x82, 
	0xd0, 0xb2, 0xd1, 0x80, 0xd1, 0x82, 0xd0, 0xbe, 
	0xd0, 0xba,    0, 0xd0, 0xbf, 0xd0, 0xb5, 0xd1, 
	0x82, 0xd0, 0xbe, 0xd0, 0xba,    0, 0xd1, 0x81, 
	0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xbe, 0xd1, 0x82, 
	0xd0, 0xb0,    0, 0xd1, 0x98, 0xd0, 0xb0, 0xd0, 
	0xbd,    0, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x98, 
	   0, 0xd1, 0x98, 0xd1, 0x83, 0xd0, 0xbd,    0, 
	0xd1, 0x98, 0xd1, 0x83, 0xd0, 0xbb,    0, 0xd1, 
	0x98, 0xd0, 0xb0, 0xd0, 0xbd, 0xd1, 0x83, 0xd0, 
	0xb0, 0xd1, 0x80, 0xd0, 0xb8,    0, 0xd1, 0x98, 
	0xd1, 0x83, 0xd0, 0xbd, 0xd0, 0xb8,    0, 0xd1, 
	0x98, 0xd1, 0x83, 0xd0, 0xbb, 0xd0, 0xb8,    0, 
	0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 
	0xbf,    0, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8b, 
	0xe0, 0xa4, 0xae,    0, 0xe0, 0xa4, 0xae, 0xe0, 
	0xa4, 0x82, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb3, 
	   0, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x81, 0xe0, 
	0xa4, 0xa7,    0, 0xe0, 0xa4, 0x97, 0xe0, 0xa5, 
	0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x81,    0, 
	0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 
	0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0,    0, 
	0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 
	0xbf,    0, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 
	0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 
	0xbe, 0xe0, 0xa4, 0xb0,    0, 0xe0, 0xa4, 0xb8, 
	0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 
	0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0,    0, 
	0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 
	0x97, 0xe0, 0xa4, 0xb3, 0xe0, 0xa4, 0xb5, 0xe0, 
	0xa4, 0xbe, 0xe0, 0xa4, 0xb0,    0, 0xe0, 0xa4, 
	0x97, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 
	0xa5, 0x81, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 
	0xe0, 0xa4, 0xb0,    0, 0xe0, 0xa4, 0xb6, 0xe0, 
	0xa5, 0x81, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 
	0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 
	0xbe, 0xe0, 0xa4, 0xb0,    0, 0xe0, 0xa4, 0xb6, 
	0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 
	0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0,    0, 
	0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 
	0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb5, 0xe0, 
	0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 
	   0, 0xe0, 0xa4, 0xab, 0xe0, 0xa5, 0x87, 0xe0, 
	0xa4, 0xac, 0xe0, 0xa5, 0x83, 0xe0, 0xa4, 0xb5, 
	0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 
	0x80,    0, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0xaa, 
	0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 
	0xbf, 0xe0, 0xa4, 0xb2,    0, 0xe0, 0xa4, 0xae, 
	0xe0, 0xa5, 0x87,    0, 0xe0, 0xa4, 0x9c, 0xe0, 
	0xa5, 0x81, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x88, 
	   0, 0xe0, 0xa4, 0x93, 0xe0, 0xa4, 0x97, 0xe0, 
	0xa4, 0xb8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9f, 
	   0, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 
	0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9f, 
	0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 
	0xac, 0xe0, 0xa4, 0xb0,    0, 0xe0, 0xa4, 0x93, 
	0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 
	0x9f, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xac, 0xe0, 
	0xa4, 0xb0,    0, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 
	0x8b, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x8d, 0xe0, 
	0xa4, 0xb9, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 
	0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xb0,    0, 0xe0, 
	0xa4, 0xa1, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb8, 
	0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 
	0xac, 0xe0, 0xa4, 0xb0,    0, 0xe0, 0xa4, 0xae, 
	0x2e, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x82, 0x2e, 
	   0, 0xe0, 0xa4, 0xae, 0x2e, 0xe0, 0xa4, 0xa8, 
	0xe0, 0xa4, 0x82, 0x2e,    0, 0x41, 0x68, 0x64, 
	   0, 0x49, 0x73, 0x6e,    0, 0x4b, 0x68, 0x61, 
	   0, 0x41, 0x68, 0x61, 0x64,    0, 0x49, 0x73, 
	0x6e, 0x69, 0x6e,    0, 0x4b, 0x68, 0x61, 0x6d, 
	0x69, 0x73,    0, 0x4a, 0x75, 0x6d, 0x61, 0x61, 
	0x74,    0, 0x4d, 0x61, 0x63,    0, 0x4f, 0x67, 
	0x6f, 0x73,    0, 0x44, 0x69, 0x73,    0, 0x46, 
	0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69,    0, 
	0x4a, 0x75, 0x6c, 0x61, 0x69,    0, 0x44, 0x69, 
	0x73, 0x65, 0x6d, 0x62, 0x65, 0x72,    0, 0xa1, 
	0x61, 0x64,    0, 0x54, 0x6e, 0x65,    0, 0x54, 
	0x6c, 0x69,    0, 0x45, 0x72, 0x62,    0, 0xa1, 
	0x61, 0x6d,    0, 0xd5, 0x69, 0x6d,    0, 0x53, 
	0x69, 0x62,    0, 0x69, 0x6c, 0x2d, 0xa1, 0x61, 
	0x64, 0x64,    0, 0x69, 0x74, 0x2d, 0x54, 0x6e, 
	0x65, 0x6a, 0x6e,    0, 0x69, 0x74, 0x2d, 0x54, 
	0x6c, 0x69, 0x65, 0x74, 0x61,    0, 0x6c, 0x2d, 
	0x45, 0x72, 0x62, 0x67, 0xb1, 0x61,    0, 0x69, 
	0x6c, 0x2d, 0xa1, 0x61, 0x6d, 0x69, 0x73,    0, 
	0x69, 0x6c, 0x2d, 0xd5, 0x69, 0x6d, 0x67, 0xb1, 
	0x61,    0, 0x69, 0x73, 0x2d, 0x53, 0x69, 0x62, 
	0x74,    0, 0x46, 0x72, 0x61,    0, 0x4d, 0x65, 
	0x6a,    0, 0xd5, 0x75, 0x6e,    0, 0x4c, 0x75, 
	0x6c,    0, 0x41, 0x77, 0x69,    0, 0x4f, 0x74, 
	0x74,    0, 0x44, 0x69, 0xe5,    0, 0x4a, 0x61, 
	0x6e, 0x6e, 0x61, 0x72,    0, 0x46, 0x72, 0x61, 
	0x72,    0, 0x4d, 0x61, 0x72, 0x7a, 0x75,    0, 
	0x4d, 0x65, 0x6a, 0x6a, 0x75,    0, 0xd5, 0x75, 
	0x6e, 0x6a, 0x75,    0, 0x4c, 0x75, 0x6c, 0x6a, 
	0x75,    0, 0x41, 0x77, 0x69, 0x73, 0x73, 0x75, 
	   0, 0x53, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 
	0x72, 0x75,    0, 0x4f, 0x74, 0x74, 0x75, 0x62, 
	0x72, 0x75,    0, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 
	0x62, 0x72, 0x75,    0, 0x44, 0x69, 0xe5, 0x65, 
	0x6d, 0x62, 0x72, 0x75, 0x20,    0, 0x25, 0x41, 
	0x2c, 0x20, 0x25, 0x64, 0x20, 0x74, 0x61, 0x20, 
	0x25, 0x62, 0x2c, 0x20, 0x25, 0x59, 0x20, 0x25, 
	0x49, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 
	0x25, 0x70, 0x20, 0x25, 0x5a,    0, 0x25, 0x41, 
	0x2c, 0x20, 0x25, 0x64, 0x20, 0x74, 0x61, 0x20, 
	0x25, 0x62, 0x2c, 0x20, 0x25, 0x59,    0, 0xc4, 
	0xa6, 0x61, 0x64,    0, 0xc4, 0xa6, 0x61, 0x6d, 
	   0, 0xc4, 0xa0, 0x69, 0x6d,    0, 0x69, 0x6c, 
	0x2d, 0xc4, 0xa6, 0x61, 0x64, 0x64,    0, 0x6c, 
	0x2d, 0x45, 0x72, 0x62, 0x67, 0xc4, 0xa7, 0x61, 
	   0, 0x69, 0x6c, 0x2d, 0xc4, 0xa6, 0x61, 0x6d, 
	0x69, 0x73,    0, 0x69, 0x6c, 0x2d, 0xc4, 0xa0, 
	0x69, 0x6d, 0x67, 0xc4, 0xa7, 0x61,    0, 0xc4, 
	0xa0, 0x75, 0x6e,    0, 0x44, 0x69, 0xc4, 0x8b, 
	   0, 0xc4, 0xa0, 0x75, 0x6e, 0x6a, 0x75,    0, 
	0x44, 0x69, 0xc4, 0x8b, 0x65, 0x6d, 0x62, 0x72, 
	0x75, 0x20,    0, 0x7a, 0x6f,    0, 0x64, 0x69, 
	   0, 0x77, 0x6f,    0, 0x64, 0x6f,    0, 0x76, 
	0x72,    0, 0x7a, 0x61,    0, 0x7a, 0x6f, 0x6e, 
	0x64, 0x61, 0x67,    0, 0x6d, 0x61, 0x61, 0x6e, 
	0x64, 0x61, 0x67,    0, 0x64, 0x69, 0x6e, 0x73, 
	0x64, 0x61, 0x67,    0, 0x77, 0x6f, 0x65, 0x6e, 
	0x73, 0x64, 0x61, 0x67,    0, 0x64, 0x6f, 0x6e, 
	0x64, 0x65, 0x72, 0x64, 0x61, 0x67,    0, 0x76, 
	0x72, 0x69, 0x6a, 0x64, 0x61, 0x67,    0, 0x7a, 
	0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67,    0, 
	0x6d, 0x72, 0x74,    0, 0x6d, 0x65, 0x69,    0, 
	0x6d, 0x61, 0x61, 0x72, 0x74,    0, 0x61, 0x75, 
	0x67, 0x75, 0x73, 0x74, 0x75, 0x73,    0, 0x25, 
	0x64, 0x2d, 0x25, 0x6d, 0x2d, 0x25, 0x79,    0, 
	0x73, 0x75, 0x20,    0, 0x6d, 0xe5, 0x20,    0, 
	0x74, 0x79, 0x20,    0, 0x6f, 0x6e, 0x20,    0, 
	0x74, 0x6f, 0x20,    0, 0x66, 0x72, 0x20,    0, 
	0x6c, 0x61, 0x75, 0x20,    0, 0x73, 0x75, 0x6e, 
	0x64, 0x61, 0x67, 0x20,    0, 0x6d, 0xe5, 0x6e, 
	0x64, 0x61, 0x67, 0x20,    0, 0x74, 0x79, 0x73, 
	0x64, 0x61, 0x67, 0x20,    0, 0x6f, 0x6e, 0x73, 
	0x64, 0x61, 0x67, 0x20,    0, 0x74, 0x6f, 0x72, 
	0x73, 0x64, 0x61, 0x67, 0x20,    0, 0x66, 0x72, 
	0x65, 0x64, 0x61, 0x67, 0x20,    0, 0x6c, 0x61, 
	0x75, 0x72, 0x64, 0x61, 0x67, 0x20,    0, 0x25, 
	0x64, 0x2e, 0x20, 0x25, 0x62, 0x20, 0x25, 0x59, 
	0x20, 0x6b, 0x6c, 0x20, 0x25, 0x48, 0x2e, 0x25, 
	0x4d, 0x20, 0x25, 0x5a,    0, 0x25, 0x64, 0x2e, 
	0x20, 0x25, 0x62, 0x20, 0x25, 0x59,    0, 0x6b, 
	0x6c, 0x20, 0x25, 0x48, 0x2e, 0x25, 0x4d, 0x20, 
	0x25, 0x5a,    0, 0x6d, 0xc3, 0xa5, 0x20,    0, 
	0x6d, 0xc3, 0xa5, 0x6e, 0x64, 0x61, 0x67, 0x20, 
	   0, 0x25, 0x61, 0x20, 0x25, 0x64, 0x2d, 0x25, 
	0x6d, 0x2d, 0x25, 0x59, 0x20, 0x25, 0x54, 0x20, 
	0x25, 0x5a,    0, 0x6d, 0x65, 0x63,    0, 0x6a, 
	0xf3, 0x75,    0, 0x64, 0x69, 0x6d, 0x65, 0x6e, 
	0x67, 0x65,    0, 0x64, 0x69, 0x6c, 0x75, 0x6e, 
	0x73,    0, 0x64, 0x69, 0x6d, 0x61, 0x72, 0x73, 
	   0, 0x64, 0x69, 0x6a, 0xf3, 0x75, 0x73,    0, 
	0x64, 0x69, 0x73, 0x61, 0x62, 0x74, 0x65,    0, 
	0x61, 0x67, 0xf3,    0, 0x67, 0x65, 0x6e, 0x69, 
	0xe8, 0x72,    0, 0x66, 0x65, 0x62, 0x72, 0x69, 
	0xe8, 0x72,    0, 0x61, 0x62, 0x72, 0x69, 0x61, 
	0x6c,    0, 0x6a, 0x75, 0x6e, 0x68,    0, 0x6a, 
	0x75, 0x6c, 0x68, 0x65, 0x74,    0, 0x61, 0x67, 
	0xf3, 0x73, 0x74,    0, 0x64, 0x65, 0x63, 0x65, 
	0x6d, 0x62, 0x72, 0x65,    0, 0x6a, 0xc3, 0xb3, 
	0x75,    0, 0x64, 0x69, 0x6a, 0xc3, 0xb3, 0x75, 
	0x73,    0, 0x61, 0x67, 0xc3, 0xb3,    0, 0x67, 
	0x65, 0x6e, 0x69, 0xc3, 0xa8, 0x72,    0, 0x66, 
	0x65, 0x62, 0x72, 0x69, 0xc3, 0xa8, 0x72,    0, 
	0x61, 0x67, 0xc3, 0xb3, 0x73, 0x74,    0, 0x6e, 
	0x69, 0x65,    0, 0x70, 0x6f, 0x6e,    0, 0x77, 
	0x74, 0x6f,    0, 0xb6, 0x72, 0x6f,    0, 0x63, 
	0x7a, 0x77,    0, 0x70, 0x69, 0xb1,    0, 0x73, 
	0x6f, 0x62,    0, 0x6e, 0x69, 0x65, 0x64, 0x7a, 
	0x69, 0x65, 0x6c, 0x61,    0, 0x70, 0x6f, 0x6e, 
	0x69, 0x65, 0x64, 0x7a, 0x69, 0x61, 0xb3, 0x65, 
	0x6b,    0, 0x77, 0x74, 0x6f, 0x72, 0x65, 0x6b, 
	   0, 0xb6, 0x72, 0x6f, 0x64, 0x61,    0, 0x63, 
	0x7a, 0x77, 0x61, 0x72, 0x74, 0x65, 0x6b,    0, 
	0x70, 0x69, 0xb1, 0x74, 0x65, 0x6b,    0, 0x73, 
	0x6f, 0x62, 0x6f, 0x74, 0x61,    0, 0x73, 0x74, 
	0x79,    0, 0x6c, 0x75, 0x74,    0, 0x6b, 0x77, 
	0x69,    0, 0x63, 0x7a, 0x65,    0, 0x6c, 0x69, 
	0x70,    0, 0x73, 0x69, 0x65,    0, 0x77, 0x72, 
	0x7a,    0, 0x70, 0x61, 0xbc,    0, 0x67, 0x72, 
	0x75,    0, 0x73, 0x74, 0x79, 0x63, 0x7a, 0x65, 
	0xf1,    0, 0x6c, 0x75, 0x74, 0x79,    0, 0x6d, 
	0x61, 0x72, 0x7a, 0x65, 0x63,    0, 0x6b, 0x77, 
	0x69, 0x65, 0x63, 0x69, 0x65, 0xf1,    0, 0x63, 
	0x7a, 0x65, 0x72, 0x77, 0x69, 0x65, 0x63,    0, 
	0x6c, 0x69, 0x70, 0x69, 0x65, 0x63,    0, 0x73, 
	0x69, 0x65, 0x72, 0x70, 0x69, 0x65, 0xf1,    0, 
	0x77, 0x72, 0x7a, 0x65, 0x73, 0x69, 0x65, 0xf1, 
	   0, 0x70, 0x61, 0xbc, 0x64, 0x7a, 0x69, 0x65, 
	0x72, 0x6e, 0x69, 0x6b,    0, 0x67, 0x72, 0x75, 
	0x64, 0x7a, 0x69, 0x65, 0xf1,    0, 0xc5, 0x9b, 
	0x72, 0x6f,    0, 0x70, 0x69, 0xc4, 0x85,    0, 
	0x70, 0x6f, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x69, 
	0x61, 0xc5, 0x82, 0x65, 0x6b,    0, 0xc5, 0x9b, 
	0x72, 0x6f, 0x64, 0x61,    0, 0x70, 0x69, 0xc4, 
	0x85, 0x74, 0x65, 0x6b,    0, 0x70, 0x61, 0xc5, 
	0xba,    0, 0x73, 0x74, 0x79, 0x63, 0x7a, 0x65, 
	0xc5, 0x84,    0, 0x6b, 0x77, 0x69, 0x65, 0x63, 
	0x69, 0x65, 0xc5, 0x84,    0, 0x73, 0x69, 0x65, 
	0x72, 0x70, 0x69, 0x65, 0xc5, 0x84,    0, 0x77, 
	0x72, 0x7a, 0x65, 0x73, 0x69, 0x65, 0xc5, 0x84, 
	   0, 0x70, 0x61, 0xc5, 0xba, 0x64, 0x7a, 0x69, 
	0x65, 0x72, 0x6e, 0x69, 0x6b,    0, 0x67, 0x72, 
	0x75, 0x64, 0x7a, 0x69, 0x65, 0xc5, 0x84,    0, 
	0x53, 0x65, 0x67,    0, 0x54, 0x65, 0x72,    0, 
	0x51, 0x75, 0x61,    0, 0x51, 0x75, 0x69,    0, 
	0x53, 0x65, 0x78,    0, 0x73, 0x65, 0x67, 0x75, 
	0x6e, 0x64, 0x61,    0, 0x74, 0x65, 0x72, 0xe7, 
	0x61,    0, 0x71, 0x75, 0x61, 0x72, 0x74, 0x61, 
	   0, 0x71, 0x75, 0x69, 0x6e, 0x74, 0x61,    0, 
	0x73, 0x65, 0x78, 0x74, 0x61,    0, 0x6a, 0x61, 
	0x6e, 0x65, 0x69, 0x72, 0x6f,    0, 0x66, 0x65, 
	0x76, 0x65, 0x72, 0x65, 0x69, 0x72, 0x6f,    0, 
	0x6d, 0x61, 0x72, 0xe7, 0x6f,    0, 0x6d, 0x61, 
	0x69, 0x6f,    0, 0x6a, 0x75, 0x6e, 0x68, 0x6f, 
	   0, 0x6a, 0x75, 0x6c, 0x68, 0x6f,    0, 0x73, 
	0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f,    0, 
	0x6f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f,    0, 
	0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 
	   0, 0x64, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x72, 
	0x6f,    0, 0x74, 0x65, 0x72, 0xc3, 0xa7, 0x61, 
	   0, 0x6d, 0x61, 0x72, 0xc3, 0xa7, 0x6f,    0, 
	0x53, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x61,    0, 
	0x54, 0x65, 0x72, 0xe7, 0x61,    0, 0x51, 0x75, 
	0x61, 0x72, 0x74, 0x61,    0, 0x51, 0x75, 0x69, 
	0x6e, 0x74, 0x61,    0, 0x53, 0x65, 0x78, 0x74, 
	0x61,    0, 0x4a, 0x61, 0x6e, 0x65, 0x69, 0x72, 
	0x6f,    0, 0x46, 0x65, 0x76, 0x65, 0x72, 0x65, 
	0x69, 0x72, 0x6f,    0, 0x4d, 0x61, 0x72, 0xe7, 
	0x6f,    0, 0x4a, 0x75, 0x6e, 0x68, 0x6f,    0, 
	0x4a, 0x75, 0x6c, 0x68, 0x6f,    0, 0x44, 0x65, 
	0x7a, 0x65, 0x6d, 0x62, 0x72, 0x6f,    0, 0x54, 
	0x65, 0x72, 0xc3, 0xa7, 0x61,    0, 0x4d, 0x61, 
	0x72, 0xc3, 0xa7, 0x6f,    0, 0x4c, 0x75,    0, 
	0x4d, 0x69,    0, 0x4a, 0x6f,    0, 0x56, 0x69, 
	   0, 0x53, 0xee,    0, 0x44, 0x75, 0x6d, 0x69, 
	0x6e, 0x69, 0x63, 0xc3,    0, 0x4c, 0x75, 0x6e, 
	0x69,    0, 0x4d, 0x61, 0x72, 0xfe, 0x69,    0, 
	0x4d, 0x69, 0x65, 0x72, 0x63, 0x75, 0x72, 0x69, 
	   0, 0x4a, 0x6f, 0x69,    0, 0x56, 0x69, 0x6e, 
	0x65, 0x72, 0x69,    0, 0x53, 0xee, 0x6d, 0x62, 
	0xc3, 0x74, 0xc3,    0, 0x69, 0x61, 0x6e,    0, 
	0x69, 0x75, 0x6e,    0, 0x69, 0x75, 0x6c,    0, 
	0x49, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x65, 
	   0, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x65,    0, 
	0x41, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x65,    0, 
	0x49, 0x75, 0x6e, 0x69, 0x65,    0, 0x49, 0x75, 
	0x6c, 0x69, 0x65,    0, 0x53, 0x65, 0x70, 0x74, 
	0x65, 0x6d, 0x62, 0x72, 0x69, 0x65,    0, 0x4f, 
	0x63, 0x74, 0x6f, 0x6d, 0x62, 0x72, 0x69, 0x65, 
	   0, 0x4e, 0x6f, 0x69, 0x65, 0x6d, 0x62, 0x72, 
	0x69, 0x65,    0, 0x44, 0x65, 0x63, 0x65, 0x6d, 
	0x62, 0x72, 0x69, 0x65,    0, 0x53, 0xc3, 0xae, 
	   0, 0x44, 0x75, 0x6d, 0x69, 0x6e, 0x69, 0x63, 
	0xc4, 0x82,    0, 0x4d, 0x61, 0x72, 0xc5, 0xa3, 
	0x69,    0, 0x53, 0xc3, 0xae, 0x6d, 0x62, 0xc4, 
	0x82, 0x74, 0xc4, 0x82,    0, 0xf7, 0xd3, 0xcb, 
	   0, 0xf0, 0xce, 0xc4,    0, 0xf7, 0xd4, 0xd2, 
	   0, 0xf3, 0xd2, 0xc4,    0, 0xfe, 0xd4, 0xd7, 
	   0, 0xf0, 0xd4, 0xce,    0, 0xf3, 0xc2, 0xd4, 
	   0, 0xf7, 0xcf, 0xd3, 0xcb, 0xd2, 0xc5, 0xd3, 
	0xc5, 0xce, 0xd8, 0xc5,    0, 0xf0, 0xcf, 0xce, 
	0xc5, 0xc4, 0xc5, 0xcc, 0xd8, 0xce, 0xc9, 0xcb, 
	   0, 0xf7, 0xd4, 0xcf, 0xd2, 0xce, 0xc9, 0xcb, 
	   0, 0xf3, 0xd2, 0xc5, 0xc4, 0xc1,    0, 0xfe, 
	0xc5, 0xd4, 0xd7, 0xc5, 0xd2, 0xc7,    0, 0xf0, 
	0xd1, 0xd4, 0xce, 0xc9, 0xc3, 0xc1,    0, 0xf3, 
	0xd5, 0xc2, 0xc2, 0xcf, 0xd4, 0xc1,    0, 0xf1, 
	0xce, 0xd7,    0, 0xe6, 0xc5, 0xd7,    0, 0xed, 
	0xc1, 0xd2,    0, 0xe1, 0xd0, 0xd2,    0, 0xed, 
	0xc1, 0xca,    0, 0xe9, 0xc0, 0xce,    0, 0xe9, 
	0xc0, 0xcc,    0, 0xe1, 0xd7, 0xc7,    0, 0xf3, 
	0xc5, 0xce,    0, 0xef, 0xcb, 0xd4,    0, 0xee, 
	0xcf, 0xd1,    0, 0xe4, 0xc5, 0xcb,    0, 0xf1, 
	0xce, 0xd7, 0xc1, 0xd2, 0xd1,    0, 0xe6, 0xc5, 
	0xd7, 0xd2, 0xc1, 0xcc, 0xd1,    0, 0xed, 0xc1, 
	0xd2, 0xd4, 0xc1,    0, 0xe1, 0xd0, 0xd2, 0xc5, 
	0xcc, 0xd1,    0, 0xed, 0xc1, 0xd1,    0, 0xe9, 
	0xc0, 0xce, 0xd1,    0, 0xe9, 0xc0, 0xcc, 0xd1, 
	   0, 0xe1, 0xd7, 0xc7, 0xd5, 0xd3, 0xd4, 0xc1, 
	   0, 0xf3, 0xc5, 0xce, 0xd4, 0xd1, 0xc2, 0xd2, 
	0xd1,    0, 0xef, 0xcb, 0xd4, 0xd1, 0xc2, 0xd2, 
	0xd1,    0, 0xee, 0xcf, 0xd1, 0xc2, 0xd2, 0xd1, 
	   0, 0xe4, 0xc5, 0xcb, 0xc1, 0xc2, 0xd2, 0xd1, 
	   0, 0xb2, 0xe1, 0xda,    0, 0xbf, 0xdd, 0xd4, 
	   0, 0xb2, 0xe2, 0xe0,    0, 0xc1, 0xe0, 0xd4, 
	   0, 0xc7, 0xe2, 0xd2,    0, 0xbf, 0xe2, 0xdd, 
	   0, 0xc1, 0xd1, 0xe2,    0, 0xb2, 0xde, 0xe1, 
	0xda, 0xe0, 0xd5, 0xe1, 0xd5, 0xdd, 0xec, 0xd5, 
	   0, 0xbf, 0xde, 0xdd, 0xd5, 0xd4, 0xd5, 0xdb, 
	0xec, 0xdd, 0xd8, 0xda,    0, 0xb2, 0xe2, 0xde, 
	0xe0, 0xdd, 0xd8, 0xda,    0, 0xc1, 0xe0, 0xd5, 
	0xd4, 0xd0,    0, 0xc7, 0xd5, 0xe2, 0xd2, 0xd5, 
	0xe0, 0xd3,    0, 0xbf, 0xef, 0xe2, 0xdd, 0xd8, 
	0xe6, 0xd0,    0, 0xc1, 0xe3, 0xd1, 0xd1, 0xde, 
	0xe2, 0xd0,    0, 0xcf, 0xdd, 0xd2,    0, 0xc4, 
	0xd5, 0xd2,    0, 0xbc, 0xd0, 0xe0,    0, 0xb0, 
	0xdf, 0xe0,    0, 0xbc, 0xd0, 0xd9,    0, 0xb8, 
	0xee, 0xdd,    0, 0xb8, 0xee, 0xdb,    0, 0xb0, 
	0xd2, 0xd3,    0, 0xc1, 0xd5, 0xdd,    0, 0xbe, 
	0xda, 0xe2,    0, 0xbd, 0xde, 0xef,    0, 0xb4, 
	0xd5, 0xda,    0, 0xcf, 0xdd, 0xd2, 0xd0, 0xe0, 
	0xef,    0, 0xc4, 0xd5, 0xd2, 0xe0, 0xd0, 0xdb, 
	0xef,    0, 0xbc, 0xd0, 0xe0, 0xe2, 0xd0,    0, 
	0xb0, 0xdf, 0xe0, 0xd5, 0xdb, 0xef,    0, 0xbc, 
	0xd0, 0xef,    0, 0xb8, 0xee, 0xdd, 0xef,    0, 
	0xb8, 0xee, 0xdb, 0xef,    0, 0xb0, 0xd2, 0xd3, 
	0xe3, 0xe1, 0xe2, 0xd0,    0, 0xc1, 0xd5, 0xdd, 
	0xe2, 0xef, 0xd1, 0xe0, 0xef,    0, 0xbe, 0xda, 
	0xe2, 0xef, 0xd1, 0xe0, 0xef,    0, 0xbd, 0xde, 
	0xef, 0xd1, 0xe0, 0xef,    0, 0xb4, 0xd5, 0xda, 
	0xd0, 0xd1, 0xe0, 0xef,    0, 0xd0, 0x92, 0xd1, 
	0x81, 0xd0, 0xba,    0, 0xd0, 0x9f, 0xd0, 0xbd, 
	0xd0, 0xb4,    0, 0xd0, 0x92, 0xd1, 0x82, 0xd1, 
	0x80,    0, 0xd0, 0xa7, 0xd1, 0x82, 0xd0, 0xb2, 
	   0, 0xd0, 0x9f, 0xd1, 0x82, 0xd0, 0xbd,    0, 
	0xd0, 0xa1, 0xd0, 0xb1, 0xd1, 0x82,    0, 0xd0, 
	0x92, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xba, 0xd1, 
	0x80, 0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xb5, 0xd0, 
	0xbd, 0xd1, 0x8c, 0xd0, 0xb5,    0, 0xd0, 0x9f, 
	0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb4, 
	0xd0, 0xb5, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0, 0xbd, 
	0xd0, 0xb8, 0xd0, 0xba,    0, 0xd0, 0x92, 0xd1, 
	0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbd, 0xd0, 
	0xb8, 0xd0, 0xba,    0, 0xd0, 0xa1, 0xd1, 0x80, 
	0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xb0,    0, 0xd0, 
	0xa7, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 
	0xb5, 0xd1, 0x80, 0xd0, 0xb3,    0, 0xd0, 0x9f, 
	0xd1, 0x8f, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xb8, 
	0xd1, 0x86, 0xd0, 0xb0,    0, 0xd0, 0xa1, 0xd1, 
	0x83, 0xd0, 0xb1, 0xd0, 0xb1, 0xd0, 0xbe, 0xd1, 
	0x82, 0xd0, 0xb0,    0, 0xd0, 0xaf, 0xd0, 0xbd, 
	0xd0, 0xb2,    0, 0xd0, 0xa4, 0xd0, 0xb5, 0xd0, 
	0xb2,    0, 0xd0, 0x9c, 0xd0, 0xb0, 0xd1, 0x80, 
	   0, 0xd0, 0x90, 0xd0, 0xbf, 0xd1, 0x80,    0, 
	0xd0, 0x9c, 0xd0, 0xb0, 0xd0, 0xb9,    0, 0xd0, 
	0x98, 0xd1, 0x8e, 0xd0, 0xbd,    0, 0xd0, 0x98, 
	0xd1, 0x8e, 0xd0, 0xbb,    0, 0xd0, 0x90, 0xd0, 
	0xb2, 0xd0, 0xb3,    0, 0xd0, 0xa1, 0xd0, 0xb5, 
	0xd0, 0xbd,    0, 0xd0, 0x9e, 0xd0, 0xba, 0xd1, 
	0x82,    0, 0xd0, 0x9d, 0xd0, 0xbe, 0xd1, 0x8f, 
	   0, 0xd0, 0x94, 0xd0, 0xb5, 0xd0, 0xba,    0, 
	0xd0, 0xaf, 0xd0, 0xbd, 0xd0, 0xb2, 0xd0, 0xb0, 
	0xd1, 0x80, 0xd1, 0x8f,    0, 0xd0, 0xa4, 0xd0, 
	0xb5, 0xd0, 0xb2, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 
	0xbb, 0xd1, 0x8f,    0, 0xd0, 0x9c, 0xd0, 0xb0, 
	0xd1, 0x80, 0xd1, 0x82, 0xd0, 0xb0,    0, 0xd0, 
	0x90, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb5, 0xd0, 
	0xbb, 0xd1, 0x8f,    0, 0xd0, 0x9c, 0xd0, 0xb0, 
	0xd1, 0x8f,    0, 0xd0, 0x98, 0xd1, 0x8e, 0xd0, 
	0xbd, 0xd1, 0x8f,    0, 0xd0, 0x98, 0xd1, 0x8e, 
	0xd0, 0xbb, 0xd1, 0x8f,    0, 0xd0, 0x90, 0xd0, 
	0xb2, 0xd0, 0xb3, 0xd1, 0x83, 0xd1, 0x81, 0xd1, 
	0x82, 0xd0, 0xb0,    0, 0xd0, 0xa1, 0xd0, 0xb5, 
	0xd0, 0xbd, 0xd1, 0x82, 0xd1, 0x8f, 0xd0, 0xb1, 
	0xd1, 0x80, 0xd1, 0x8f,    0, 0xd0, 0x9e, 0xd0, 
	0xba, 0xd1, 0x82, 0xd1, 0x8f, 0xd0, 0xb1, 0xd1, 
	0x80, 0xd1, 0x8f,    0, 0xd0, 0x9d, 0xd0, 0xbe, 
	0xd1, 0x8f, 0xd0, 0xb1, 0xd1, 0x80, 0xd1, 0x8f, 
	   0, 0xd0, 0x94, 0xd0, 0xb5, 0xd0, 0xba, 0xd0, 
	0xb0, 0xd0, 0xb1, 0xd1, 0x80, 0xd1, 0x8f,    0, 
	0xf7, 0xd4, 0xcf,    0, 0xf3, 0xd5, 0xc2,    0, 
	0xf1, 0xce, 0xd7, 0xc1, 0xd2, 0xd8,    0, 0xe6, 
	0xc5, 0xd7, 0xd2, 0xc1, 0xcc, 0xd8,    0, 0xed, 
	0xc1, 0xd2, 0xd4,    0, 0xe1, 0xd0, 0xd2, 0xc5, 
	0xcc, 0xd8,    0, 0xe9, 0xc0, 0xce, 0xd8,    0, 
	0xe9, 0xc0, 0xcc, 0xd8,    0, 0xe1, 0xd7, 0xc7, 
	0xd5, 0xd3, 0xd4,    0, 0xf3, 0xc5, 0xce, 0xd4, 
	0xd1, 0xc2, 0xd2, 0xd8,    0, 0xef, 0xcb, 0xd4, 
	0xd1, 0xc2, 0xd2, 0xd8,    0, 0xee, 0xcf, 0xd1, 
	0xc2, 0xd2, 0xd8,    0, 0xe4, 0xc5, 0xcb, 0xc1, 
	0xc2, 0xd2, 0xd8,    0, 0xd0, 0x92, 0xd1, 0x82, 
	0xd0, 0xbe,    0, 0xd0, 0xaf, 0xd0, 0xbd, 0xd0, 
	0xb2, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x8c,    0, 
	0xd0, 0xa4, 0xd0, 0xb5, 0xd0, 0xb2, 0xd1, 0x80, 
	0xd0, 0xb0, 0xd0, 0xbb, 0xd1, 0x8c,    0, 0xd0, 
	0x9c, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x82,    0, 
	0xd0, 0x90, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb5, 
	0xd0, 0xbb, 0xd1, 0x8c,    0, 0xd0, 0x98, 0xd1, 
	0x8e, 0xd0, 0xbd, 0xd1, 0x8c,    0, 0xd0, 0x98, 
	0xd1, 0x8e, 0xd0, 0xbb, 0xd1, 0x8c,    0, 0xd0, 
	0x90, 0xd0, 0xb2, 0xd0, 0xb3, 0xd1, 0x83, 0xd1, 
	0x81, 0xd1, 0x82,    0, 0xd0, 0xa1, 0xd0, 0xb5, 
	0xd0, 0xbd, 0xd1, 0x82, 0xd1, 0x8f, 0xd0, 0xb1, 
	0xd1, 0x80, 0xd1, 0x8c,    0, 0xd0, 0x9e, 0xd0, 
	0xba, 0xd1, 0x82, 0xd1, 0x8f, 0xd0, 0xb1, 0xd1, 
	0x80, 0xd1, 0x8c,    0, 0xd0, 0x9d, 0xd0, 0xbe, 
	0xd1, 0x8f, 0xd0, 0xb1, 0xd1, 0x80, 0xd1, 0x8c, 
	   0, 0xd0, 0x94, 0xd0, 0xb5, 0xd0, 0xba, 0xd0, 
	0xb0, 0xd0, 0xb1, 0xd1, 0x80, 0xd1, 0x8c,    0, 
	0x73, 0x6f, 0x74, 0x6e,    0, 0x76, 0x75, 0x6f, 
	0x73,    0, 0x6d, 0x61, 0xc5, 0x8b,    0, 0x67, 
	0x61, 0x73, 0x6b,    0, 0x64, 0x75, 0x6f, 0x72, 
	   0, 0x62, 0x65, 0x61, 0x72,    0, 0x6c, 0xc3, 
	0xa1, 0x76,    0, 0x73, 0x6f, 0x74, 0x6e, 0x61, 
	0x62, 0x65, 0x61, 0x69, 0x76, 0x69,    0, 0x76, 
	0x75, 0x6f, 0x73, 0x73, 0xc3, 0xa1, 0x72, 0x67, 
	0x61,    0, 0x6d, 0x61, 0xc5, 0x8b, 0xc5, 0x8b, 
	0x65, 0x62, 0x61, 0x72, 0x67, 0x61,    0, 0x67, 
	0x61, 0x73, 0x6b, 0x61, 0x76, 0x61, 0x68, 0x6b, 
	0x6b, 0x75,    0, 0x64, 0x75, 0x6f, 0x72, 0x61, 
	0x73, 0x64, 0x61, 0x74,    0, 0x62, 0x65, 0x61, 
	0x72, 0x6a, 0x61, 0x64, 0x61, 0x74,    0, 0x6c, 
	0xc3, 0xa1, 0x76, 0x76, 0x61, 0x72, 0x64, 0x61, 
	0x74,    0, 0x6f, 0xc4, 0x91, 0xc4, 0x91, 0x6a, 
	   0, 0x67, 0x75, 0x6f, 0x76,    0, 0x6e, 0x6a, 
	0x75, 0x6b,    0, 0x63, 0x75, 0x6f, 0xc5, 0x8b, 
	   0, 0x6d, 0x69, 0x65, 0x73,    0, 0x67, 0x65, 
	0x61, 0x73,    0, 0x73, 0x75, 0x6f, 0x69,    0, 
	0x62, 0x6f, 0x72, 0x67,    0, 0xc4, 0x8d, 0x61, 
	0x6b, 0xc4, 0x8d,    0, 0x67, 0x6f, 0x6c, 0x67, 
	   0, 0x73, 0x6b, 0xc3, 0xa1, 0x62,    0, 0x6a, 
	0x75, 0x6f, 0x76,    0, 0x6f, 0xc4, 0x91, 0xc4, 
	0x91, 0x61, 0x6a, 0x61, 0x67, 0x65, 0x6d, 0xc3, 
	0xa1, 0x6e, 0x75,    0, 0x67, 0x75, 0x6f, 0x76, 
	0x76, 0x61, 0x6d, 0xc3, 0xa1, 0x6e, 0x75,    0, 
	0x6e, 0x6a, 0x75, 0x6b, 0xc4, 0x8d, 0x61, 0x6d, 
	0xc3, 0xa1, 0x6e, 0x75,    0, 0x63, 0x75, 0x6f, 
	0xc5, 0x8b, 0x6f, 0x6d, 0xc3, 0xa1, 0x6e, 0x75, 
	   0, 0x6d, 0x69, 0x65, 0x73, 0x73, 0x65, 0x6d, 
	0xc3, 0xa1, 0x6e, 0x75,    0, 0x67, 0x65, 0x61, 
	0x73, 0x73, 0x65, 0x6d, 0xc3, 0xa1, 0x6e, 0x75, 
	   0, 0x73, 0x75, 0x6f, 0x69, 0x64, 0x6e, 0x65, 
	0x6d, 0xc3, 0xa1, 0x6e, 0x75,    0, 0x62, 0x6f, 
	0x72, 0x67, 0x65, 0x6d, 0xc3, 0xa1, 0x6e, 0x75, 
	   0, 0xc4, 0x8d, 0x61, 0x6b, 0xc4, 0x8d, 0x61, 
	0x6d, 0xc3, 0xa1, 0x6e, 0x75,    0, 0x67, 0x6f, 
	0x6c, 0x67, 0x67, 0x6f, 0x74, 0x6d, 0xc3, 0xa1, 
	0x6e, 0x75,    0, 0x73, 0x6b, 0xc3, 0xa1, 0x62, 
	0x6d, 0x61, 0x6d, 0xc3, 0xa1, 0x6e, 0x75,    0, 
	0x6a, 0x75, 0x6f, 0x76, 0x6c, 0x61, 0x6d, 0xc3, 
	0xa1, 0x6e, 0x75,    0, 0x25, 0x61, 0x2c, 0x20, 
	0x25, 0x62, 0x20, 0x25, 0x65, 0x2e, 0x20, 0x62, 
	0x2e, 0x20, 0x25, 0x59, 0x20, 0x25, 0x54, 0x20, 
	0x25, 0x5a,    0, 0x55, 0x74,    0, 0xa9, 0x74, 
	   0, 0x50, 0x69,    0, 0x4e, 0x65, 0x64, 0x65, 
	0xb5, 0x61,    0, 0x50, 0x6f, 0x6e, 0x64, 0x65, 
	0x6c, 0x6f, 0x6b,    0, 0x55, 0x74, 0x6f, 0x72, 
	0x6f, 0x6b,    0, 0x53, 0x74, 0x72, 0x65, 0x64, 
	0x61,    0, 0xa9, 0x74, 0x76, 0x72, 0x74, 0x6f, 
	0x6b,    0, 0x50, 0x69, 0x61, 0x74, 0x6f, 0x6b, 
	   0, 0x6d, 0x61, 0x72, 0x65, 0x63,    0, 0x4e, 
	0x65, 0x64, 0x65, 0xc4, 0xbe, 0x61,    0, 0xc5, 
	0xa0, 0x74, 0x76, 0x72, 0x74, 0x6f, 0x6b,    0, 
	0x6e, 0x65, 0x64,    0, 0x73, 0x72, 0x65,    0, 
	0xe8, 0x65, 0x74,    0, 0x70, 0x65, 0x74,    0, 
	0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61,    0, 
	0x70, 0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 
	0x65, 0x6b,    0, 0x74, 0x6f, 0x72, 0x65, 0x6b, 
	   0, 0x73, 0x72, 0x65, 0x64, 0x61,    0, 0xe8, 
	0x65, 0x74, 0x72, 0x74, 0x65, 0x6b,    0, 0x70, 
	0x65, 0x74, 0x65, 0x6b,    0, 0x61, 0x76, 0x67, 
	   0, 0x6a, 0x75, 0x6e, 0x69, 0x6a,    0, 0x6a, 
	0x75, 0x6c, 0x69, 0x6a,    0, 0x61, 0x76, 0x67, 
	0x75, 0x73, 0x74,    0, 0xc4, 0x8d, 0x65, 0x74, 
	   0, 0xc4, 0x8d, 0x65, 0x74, 0x72, 0x74, 0x65, 
	0x6b,    0, 0x44, 0x69, 0x65, 0x20,    0, 0x48, 
	0xeb, 0x6e, 0x20,    0, 0x4d, 0x61, 0x72, 0x20, 
	   0, 0x4d, 0xeb, 0x72, 0x20,    0, 0x45, 0x6e, 
	0x6a, 0x20,    0, 0x50, 0x72, 0x65, 0x20,    0, 
	0x53, 0x68, 0x74, 0x20,    0, 0x65, 0x20, 0x64, 
	0x69, 0x65, 0x6c, 0x20,    0, 0x65, 0x20, 0x68, 
	0xeb, 0x6e, 0xeb, 0x20,    0, 0x65, 0x20, 0x6d, 
	0x61, 0x72, 0x74, 0xeb, 0x20,    0, 0x65, 0x20, 
	0x6d, 0xeb, 0x72, 0x6b, 0x75, 0x72, 0xeb, 0x20, 
	   0, 0x65, 0x20, 0x65, 0x6e, 0x6a, 0x74, 0x65, 
	0x20,    0, 0x65, 0x20, 0x70, 0x72, 0x65, 0x6d, 
	0x74, 0x65, 0x20,    0, 0x65, 0x20, 0x73, 0x68, 
	0x74, 0x75, 0x6e, 0xeb, 0x20,    0, 0x53, 0x68, 
	0x6b,    0, 0x50, 0x72, 0x69,    0, 0x51, 0x65, 
	0x72,    0, 0x4b, 0x6f, 0x72,    0, 0x47, 0x73, 
	0x68,    0, 0x53, 0x68, 0x74,    0, 0x54, 0x65, 
	0x74,    0, 0x4e, 0xeb, 0x6e,    0, 0x44, 0x68, 
	0x6a,    0, 0x6a, 0x61, 0x6e, 0x61, 0x72,    0, 
	0x73, 0x68, 0x6b, 0x75, 0x72, 0x74,    0, 0x70, 
	0x72, 0x69, 0x6c, 0x6c,    0, 0x71, 0x65, 0x72, 
	0x73, 0x68, 0x6f, 0x72,    0, 0x6b, 0x6f, 0x72, 
	0x72, 0x69, 0x6b,    0, 0x67, 0x75, 0x73, 0x68, 
	0x74,    0, 0x73, 0x68, 0x74, 0x61, 0x74, 0x6f, 
	0x72,    0, 0x74, 0x65, 0x74, 0x6f, 0x72,    0, 
	0x6e, 0xeb, 0x6e, 0x74, 0x6f, 0x72,    0, 0x64, 
	0x68, 0x6a, 0x65, 0x74, 0x6f, 0x72,    0, 0x50, 
	0x44,    0, 0x4d, 0x44,    0, 0x25, 0x59, 0x2d, 
	0x25, 0x62, 0x2d, 0x25, 0x64, 0x20, 0x25, 0x49, 
	0x2e, 0x25, 0x4d, 0x2e, 0x25, 0x53, 0x2e, 0x25, 
	0x70, 0x20, 0x25, 0x5a,    0, 0x25, 0x59, 0x2d, 
	0x25, 0x62, 0x2d, 0x25, 0x64,    0, 0x25, 0x49, 
	0x2e, 0x25, 0x4d, 0x2e, 0x25, 0x53, 0x2e, 0x20, 
	0x25, 0x5a,    0, 0x25, 0x49, 0x2e, 0x25, 0x4d, 
	0x2e, 0x25, 0x53, 0x2e, 0x25, 0x70, 0x20, 0x25, 
	0x5a,    0, 0x48, 0xc3, 0xab, 0x6e, 0x20,    0, 
	0x4d, 0xc3, 0xab, 0x72, 0x20,    0, 0x65, 0x20, 
	0x68, 0xc3, 0xab, 0x6e, 0xc3, 0xab, 0x20,    0, 
	0x65, 0x20, 0x6d, 0x61, 0x72, 0x74, 0xc3, 0xab, 
	0x20,    0, 0x65, 0x20, 0x6d, 0xc3, 0xab, 0x72, 
	0x6b, 0x75, 0x72, 0xc3, 0xab, 0x20,    0, 0x65, 
	0x20, 0x73, 0x68, 0x74, 0x75, 0x6e, 0xc3, 0xab, 
	0x20,    0, 0x4e, 0xc3, 0xab, 0x6e,    0, 0x6e, 
	0xc3, 0xab, 0x6e, 0x74, 0x6f, 0x72,    0, 0x75, 
	0x74, 0x6f,    0, 0x73, 0x75, 0x62,    0, 0x70, 
	0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 
	0x6b,    0, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 
	   0, 0xe8, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 
	0x6b,    0, 0x70, 0x65, 0x74, 0x61, 0x6b,    0, 
	0x73, 0x75, 0x62, 0x6f, 0x74, 0x61,    0, 0x73, 
	0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 
	   0, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 
	   0, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 
	0x72,    0, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 
	0x61, 0x72,    0, 0x25, 0x64, 0x2d, 0x25, 0x6d, 
	0x2d, 0x25, 0x59, 0x2e,    0, 0xc4, 0x8d, 0x65, 
	0x74, 0x76, 0x72, 0x74, 0x61, 0x6b,    0, 0xe3, 
	0xe2, 0xde,    0, 0xe1, 0xe3, 0xd1,    0, 0xdd, 
	0xd5, 0xd4, 0xd5, 0xf9, 0x61,    0, 0xdf, 0xde, 
	0xdd, 0xd5, 0xd4, 0xd5, 0xf9, 0xd0, 0xda,    0, 
	0xe3, 0xe2, 0xde, 0xe0, 0xd0, 0xda,    0, 0xe7, 
	0xd5, 0xe2, 0xd2, 0xe0, 0xe2, 0xd0, 0xda,    0, 
	0xdf, 0xd5, 0xe2, 0xd0, 0xda,    0, 0xe1, 0xe3, 
	0xd1, 0xde, 0xe2, 0xd0,    0, 0xe4, 0xd5, 0xd1, 
	   0, 0xdd, 0xde, 0xd2,    0, 0xd4, 0xd5, 0xe6, 
	   0, 0xf8, 0xd0, 0xdd, 0xe3, 0xd0, 0xe0,    0, 
	0xe4, 0xd5, 0xd1, 0xe0, 0xe3, 0xd0, 0xe0,    0, 
	0xe1, 0xd5, 0xdf, 0xe2, 0xd5, 0xdc, 0xd1, 0xd0, 
	0xe0,    0, 0xde, 0xda, 0xe2, 0xde, 0xd1, 0xd0, 
	0xe0,    0, 0xdd, 0xde, 0xd2, 0xd5, 0xdc, 0xd1, 
	0xd0, 0xe0,    0, 0xd4, 0xd5, 0xe6, 0xd5, 0xdc, 
	0xd1, 0xd0, 0xe0,    0, 0x2b, 0x25, 0x61, 0x20, 
	0x25, 0x64, 0x20, 0x25, 0x62, 0x20, 0x25, 0x59, 
	0x20, 0x25, 0x54, 0x20, 0x25, 0x5a,    0, 0xd1, 
	0x83, 0xd1, 0x82, 0xd0, 0xbe,    0, 0xd1, 0x81, 
	0xd1, 0x83, 0xd0, 0xb1,    0, 0xd0, 0xbd, 0xd0, 
	0xb5, 0xd0, 0xb4, 0xd0, 0xb5, 0xd1, 0x99, 0x61, 
	   0, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 
	0xb5, 0xd0, 0xb4, 0xd0, 0xb5, 0xd1, 0x99, 0xd0, 
	0xb0, 0xd0, 0xba,    0, 0xd1, 0x83, 0xd1, 0x82, 
	0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xba, 
	   0, 0xd1, 0x87, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 
	0xb2, 0xd1, 0x80, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 
	0xba,    0, 0xd0, 0xbf, 0xd0, 0xb5, 0xd1, 0x82, 
	0xd0, 0xb0, 0xd0, 0xba,    0, 0xd1, 0x81, 0xd1, 
	0x83, 0xd0, 0xb1, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 
	0xb0,    0, 0xd1, 0x84, 0xd0, 0xb5, 0xd0, 0xb1, 
	   0, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb2,    0, 
	0xd0, 0xb4, 0xd0, 0xb5, 0xd1, 0x86,    0, 0xd1, 
	0x98, 0xd0, 0xb0, 0xd0, 0xbd, 0xd1, 0x83, 0xd0, 
	0xb0, 0xd1, 0x80,    0, 0xd1, 0x84, 0xd0, 0xb5, 
	0xd0, 0xb1, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xb0, 
	0xd1, 0x80,    0, 0xd1, 0x81, 0xd0, 0xb5, 0xd0, 
	0xbf, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 
	0xb1, 0xd0, 0xb0, 0xd1, 0x80,    0, 0xd0, 0xbe, 
	0xd0, 0xba, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb1, 
	0xd0, 0xb0, 0xd1, 0x80,    0, 0xd0, 0xbd, 0xd0, 
	0xbe, 0xd0, 0xb2, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 
	0xb1, 0xd0, 0xb0, 0xd1, 0x80,    0, 0xd0, 0xb4, 
	0xd0, 0xb5, 0xd1, 0x86, 0xd0, 0xb5, 0xd0, 0xbc, 
	0xd0, 0xb1, 0xd0, 0xb0, 0xd1, 0x80,    0, 0x73, 
	0xf6, 0x6e,    0, 0x6d, 0xe5, 0x6e,    0, 0x74, 
	0x69, 0x73,    0, 0x6c, 0xf6, 0x72,    0, 0x73, 
	0xf6, 0x6e, 0x64, 0x61, 0x67,    0, 0x6d, 0xe5, 
	0x6e, 0x64, 0x61, 0x67,    0, 0x74, 0x69, 0x73, 
	0x64, 0x61, 0x67,    0, 0x6c, 0xf6, 0x72, 0x64, 
	0x61, 0x67,    0, 0x61, 0x75, 0x67, 0x75, 0x73, 
	0x74, 0x69,    0, 0x25, 0x61, 0x20, 0x25, 0x65, 
	0x20, 0x25, 0x62, 0x20, 0x25, 0x59, 0x20, 0x25, 
	0x48, 0x2e, 0x25, 0x4d, 0x2e, 0x25, 0x53,    0, 
	0x73, 0xc3, 0xb6, 0x6e,    0, 0x6d, 0xc3, 0xa5, 
	0x6e,    0, 0x6c, 0xc3, 0xb6, 0x72,    0, 0x73, 
	0xc3, 0xb6, 0x6e, 0x64, 0x61, 0x67,    0, 0x6d, 
	0xc3, 0xa5, 0x6e, 0x64, 0x61, 0x67,    0, 0x6c, 
	0xc3, 0xb6, 0x72, 0x64, 0x61, 0x67,    0, 0xe0, 
	0xae, 0x9e,    0, 0xe0, 0xae, 0xa4,    0, 0xe0, 
	0xae, 0x9a,    0, 0xe0, 0xae, 0xaa,    0, 0xe0, 
	0xae, 0xb5,    0, 0xe0, 0xae, 0x9e, 0xe0, 0xae, 
	0xbe, 0xe0, 0xae, 0xaf, 0xe0, 0xae, 0xbf, 0xe0, 
	0xae, 0xb1, 0xe0, 0xaf, 0x81,    0, 0xe0, 0xae, 
	0xa4, 0xe0, 0xae, 0xbf, 0xe0, 0xae, 0x99, 0xe0, 
	0xaf, 0x8d, 0xe0, 0xae, 0x95, 0xe0, 0xae, 0xb3, 
	0xe0, 0xaf, 0x8d,    0, 0xe0, 0xae, 0x9a, 0xe0, 
	0xaf, 0x86, 0xe0, 0xae, 0xb5, 0xe0, 0xaf, 0x8d, 
	0xe0, 0xae, 0xb5, 0xe0, 0xae, 0xbe, 0xe0, 0xae, 
	0xaf, 0xe0, 0xaf, 0x8d,    0, 0xe0, 0xae, 0xaa, 
	0xe0, 0xaf, 0x81, 0xe0, 0xae, 0xa4, 0xe0, 0xae, 
	0xa9, 0xe0, 0xaf, 0x8d,    0, 0xe0, 0xae, 0xb5, 
	0xe0, 0xae, 0xbf, 0xe0, 0xae, 0xaf, 0xe0, 0xae, 
	0xbe, 0xe0, 0xae, 0xb4, 0xe0, 0xae, 0xa9, 0xe0, 
	0xaf, 0x8d,    0, 0xe0, 0xae, 0xb5, 0xe0, 0xaf, 
	0x86, 0xe0, 0xae, 0xb3, 0xe0, 0xaf, 0x8d, 0xe0, 
	0xae, 0xb3, 0xe0, 0xae, 0xbf,    0, 0xe0, 0xae, 
	0x9a, 0xe0, 0xae, 0xa9, 0xe0, 0xae, 0xbf,    0, 
	0xe0, 0xae, 0x9c, 0xe0, 0xae, 0xa9, 0xe0, 0xae, 
	0xb5, 0xe0, 0xae, 0xb0, 0xe0, 0xae, 0xbf,    0, 
	0xe0, 0xae, 0xaa, 0xe0, 0xaf, 0x86, 0xe0, 0xae, 
	0xaa, 0xe0, 0xaf, 0x8d, 0xe0, 0xae, 0xb0, 0xe0, 
	0xae, 0xb5, 0xe0, 0xae, 0xb0, 0xe0, 0xae, 0xbf, 
	   0, 0xe0, 0xae, 0xae, 0xe0, 0xae, 0xbe, 0xe0, 
	0xae, 0xb0, 0xe0, 0xaf, 0x8d, 0xe0, 0xae, 0x9a, 
	0xe0, 0xaf, 0x8d,    0, 0xe0, 0xae, 0x8f, 0xe0, 
	0xae, 0xaa, 0xe0, 0xaf, 0x8d, 0xe0, 0xae, 0xb0, 
	0xe0, 0xae, 0xb2, 0xe0, 0xaf, 0x8d,    0, 0xe0, 
	0xae, 0xae, 0xe0, 0xaf, 0x87,    0, 0xe0, 0xae, 
	0x9c, 0xe0, 0xaf, 0x82, 0xe0, 0xae, 0xa9, 0xe0, 
	0xaf, 0x8d,    0, 0xe0, 0xae, 0x9c, 0xe0, 0xaf, 
	0x82, 0xe0, 0xae, 0xb2, 0xe0, 0xaf, 0x88,    0, 
	0xe0, 0xae, 0x86, 0xe0, 0xae, 0x95, 0xe0, 0xae, 
	0xb8, 0xe0, 0xaf, 0x8d, 0xe0, 0xae, 0x9f, 0xe0, 
	0xaf, 0x8d,    0, 0xe0, 0xae, 0x9a, 0xe0, 0xaf, 
	0x86, 0xe0, 0xae, 0xaa, 0xe0, 0xaf, 0x8d, 0xe0, 
	0xae, 0x9f, 0xe0, 0xae, 0xae, 0xe0, 0xaf, 0x8d, 
	0xe0, 0xae, 0xaa, 0xe0, 0xae, 0xb0, 0xe0, 0xaf, 
	0x8d,    0, 0xe0, 0xae, 0x85, 0xe0, 0xae, 0x95, 
	0xe0, 0xaf, 0x8d, 0xe0, 0xae, 0x9f, 0xe0, 0xaf, 
	0x8b, 0xe0, 0xae, 0xaa, 0xe0, 0xae, 0xb0, 0xe0, 
	0xaf, 0x8d,    0, 0xe0, 0xae, 0xa8, 0xe0, 0xae, 
	0xb5, 0xe0, 0xae, 0xae, 0xe0, 0xaf, 0x8d, 0xe0, 
	0xae, 0xaa, 0xe0, 0xae, 0xb0, 0xe0, 0xaf, 0x8d, 
	   0, 0xe0, 0xae, 0x9f, 0xe0, 0xae, 0xbf, 0xe0, 
	0xae, 0x9a, 0xe0, 0xae, 0xae, 0xe0, 0xaf, 0x8d, 
	0xe0, 0xae, 0xaa, 0xe0, 0xae, 0xb0, 0xe0, 0xaf, 
	0x8d, 0x72,    0, 0xe0, 0xae, 0x95, 0xe0, 0xae, 
	0xbe, 0xe0, 0xae, 0xb2, 0xe0, 0xaf, 0x88,    0, 
	0xe0, 0xae, 0xae, 0xe0, 0xae, 0xbe, 0xe0, 0xae, 
	0xb2, 0xe0, 0xaf, 0x88,    0, 0xe0, 0xb0, 0x86, 
	0xe0, 0xb0, 0xa6, 0xe0, 0xb0, 0xbf,    0, 0xe0, 
	0xb0, 0xb8, 0xe0, 0xb1, 0x8b, 0xe0, 0xb0, 0xae, 
	   0, 0xe0, 0xb0, 0xae, 0xe0, 0xb0, 0x82, 0xe0, 
	0xb0, 0x97, 0xe0, 0xb0, 0xb3,    0, 0xe0, 0xb0, 
	0xac, 0xe0, 0xb1, 0x81, 0xe0, 0xb0, 0xa7,    0, 
	0xe0, 0xb0, 0x97, 0xe0, 0xb1, 0x81, 0xe0, 0xb0, 
	0xb0, 0xe0, 0xb1, 0x81,    0, 0xe0, 0xb0, 0xb6, 
	0xe0, 0xb1, 0x81, 0xe0, 0xb0, 0x95, 0xe0, 0xb1, 
	0x8d, 0xe0, 0xb0, 0xb0,    0, 0xe0, 0xb0, 0xb6, 
	0xe0, 0xb0, 0xa8, 0xe0, 0xb0, 0xbf,    0, 0xe0, 
	0xb0, 0x86, 0xe0, 0xb0, 0xa6, 0xe0, 0xb0, 0xbf, 
	0xe0, 0xb0, 0xb5, 0xe0, 0xb0, 0xbe, 0xe0, 0xb0, 
	0xb0, 0xe0, 0xb0, 0x82,    0, 0xe0, 0xb0, 0xb8, 
	0xe0, 0xb1, 0x8b, 0xe0, 0xb0, 0xae, 0xe0, 0xb0, 
	0xb5, 0xe0, 0xb0, 0xbe, 0xe0, 0xb0, 0xb0, 0xe0, 
	0xb0, 0x82,    0, 0xe0, 0xb0, 0xae, 0xe0, 0xb0, 
	0x82, 0xe0, 0xb0, 0x97, 0xe0, 0xb0, 0xb3, 0xe0, 
	0xb0, 0xb5, 0xe0, 0xb0, 0xbe, 0xe0, 0xb0, 0xb0, 
	0xe0, 0xb0, 0x82,    0, 0xe0, 0xb0, 0xac, 0xe0, 
	0xb1, 0x81, 0xe0, 0xb0, 0xa7, 0xe0, 0xb0, 0xb5, 
	0xe0, 0xb0, 0xbe, 0xe0, 0xb0, 0xb0, 0xe0, 0xb0, 
	0x82,    0, 0xe0, 0xb0, 0x97, 0xe0, 0xb1, 0x81, 
	0xe0, 0xb0, 0xb0, 0xe0, 0xb1, 0x81, 0xe0, 0xb0, 
	0xb5, 0xe0, 0xb0, 0xbe, 0xe0, 0xb0, 0xb0, 0xe0, 
	0xb0, 0x82,    0, 0xe0, 0xb0, 0xb6, 0xe0, 0xb1, 
	0x81, 0xe0, 0xb0, 0x95, 0xe0, 0xb1, 0x8d, 0xe0, 
	0xb0, 0xb0, 0xe0, 0xb0, 0xb5, 0xe0, 0xb0, 0xbe, 
	0xe0, 0xb0, 0xb0, 0xe0, 0xb0, 0x82,    0, 0xe0, 
	0xb0, 0xb6, 0xe0, 0xb0, 0xa8, 0xe0, 0xb0, 0xbf, 
	0xe0, 0xb0, 0xb5, 0xe0, 0xb0, 0xbe, 0xe0, 0xb0, 
	0xb0, 0xe0, 0xb0, 0x82,    0, 0xe0, 0xb0, 0x9c, 
	0xe0, 0xb0, 0xa8, 0xe0, 0xb0, 0xb5, 0xe0, 0xb0, 
	0xb0, 0xe0, 0xb0, 0xbf,    0, 0xe0, 0xb0, 0xab, 
	0xe0, 0xb0, 0xbf, 0xe0, 0xb0, 0xac, 0xe0, 0xb1, 
	0x8d, 0xe0, 0xb0, 0xb0, 0xe0, 0xb0, 0xb5, 0xe0, 
	0xb0, 0xb0, 0xe0, 0xb0, 0xbf,    0, 0xe0, 0xb0, 
	0xae, 0xe0, 0xb0, 0xbe, 0xe0, 0xb0, 0xb0, 0xe0, 
	0xb1, 0x8d, 0xe0, 0xb0, 0x9a, 0xe0, 0xb0, 0xbf, 
	   0, 0xe0, 0xb0, 0x8f, 0xe0, 0xb0, 0xaa, 0xe0, 
	0xb1, 0x8d, 0xe0, 0xb0, 0xb0, 0xe0, 0xb0, 0xbf, 
	0xe0, 0xb0, 0xb2, 0xe0, 0xb1, 0x8d,    0, 0xe0, 
	0xb0, 0xae, 0xe0, 0xb1, 0x87,    0, 0xe0, 0xb0, 
	0x9c, 0xe0, 0xb1, 0x82, 0xe0, 0xb0, 0xa8, 0xe0, 
	0xb1, 0x8d,    0, 0xe0, 0xb0, 0x9c, 0xe0, 0xb1, 
	0x82, 0xe0, 0xb0, 0xb2, 0xe0, 0xb1, 0x88,    0, 
	0xe0, 0xb0, 0x86, 0xe0, 0xb0, 0x97, 0xe0, 0xb0, 
	0xb8, 0xe0, 0xb1, 0x8d, 0xe0, 0xb0, 0x9f, 0xe0, 
	0xb1, 0x81,    0, 0xe0, 0xb0, 0xb8, 0xe0, 0xb1, 
	0x86, 0xe0, 0xb0, 0xaa, 0xe0, 0xb1, 0x8d, 0xe0, 
	0xb0, 0x9f, 0xe0, 0xb1, 0x86, 0xe0, 0xb0, 0x82, 
	0xe0, 0xb0, 0xac, 0xe0, 0xb0, 0xb0, 0xe0, 0xb1, 
	0x8d,    0, 0xe0, 0xb0, 0x85, 0xe0, 0xb0, 0x95, 
	0xe0, 0xb1, 0x8d, 0xe0, 0xb0, 0x9f, 0xe0, 0xb1, 
	0x8b, 0xe0, 0xb0, 0xac, 0xe0, 0xb0, 0xb0, 0xe0, 
	0xb1, 0x8d,    0, 0xe0, 0xb0, 0xa8, 0xe0, 0xb0, 
	0xb5, 0xe0, 0xb0, 0x82, 0xe0, 0xb0, 0xac, 0xe0, 
	0xb0, 0xb0, 0xe0, 0xb1, 0x8d,    0, 0xe0, 0xb0, 
	0xa1, 0xe0, 0xb0, 0xbf, 0xe0, 0xb0, 0xb8, 0xe0, 
	0xb1, 0x86, 0xe0, 0xb0, 0x82, 0xe0, 0xb0, 0xac, 
	0xe0, 0xb0, 0xb0, 0xe0, 0xb1, 0x8d,    0, 0xe0, 
	0xb0, 0xaa, 0xe0, 0xb1, 0x82, 0xe0, 0xb0, 0xb0, 
	0xe0, 0xb1, 0x8d, 0xe0, 0xb0, 0xb5, 0xe0, 0xb0, 
	0xbe, 0xe0, 0xb0, 0xb9, 0xe0, 0xb1, 0x8d, 0xe0, 
	0xb0, 0xa8,    0, 0xe0, 0xb0, 0x85, 0xe0, 0xb0, 
	0xaa, 0xe0, 0xb0, 0xb0, 0xe0, 0xb0, 0xbe, 0xe0, 
	0xb0, 0xb9, 0xe0, 0xb1, 0x8d, 0xe0, 0xb0, 0xa8, 
	   0, 0xcd, 0xd2, 0x2e,    0, 0xa8, 0x2e,    0, 
	0xcd, 0x2e,    0, 0xbe, 0x2e,    0, 0xbe, 0xc4, 
	0x2e,    0, 0xc8, 0x2e,    0, 0xca, 0x2e,    0, 
	0xcd, 0xd2, 0xb7, 0xd4, 0xb5, 0xc2, 0xec,    0, 
	0xa8, 0xd1, 0xb9, 0xb7, 0xc3, 0xec,    0, 0xcd, 
	0xd1, 0xa7, 0xa4, 0xd2, 0xc3,    0, 0xbe, 0xd8, 
	0xb8,    0, 0xbe, 0xc4, 0xcb, 0xd1, 0xca, 0xba, 
	0xb4, 0xd5,    0, 0xc8, 0xd8, 0xa1, 0xc3, 0xec, 
	   0, 0xe0, 0xca, 0xd2, 0xc3, 0xec,    0, 0xc1, 
	0x2e, 0xa4, 0x2e,    0, 0xa1, 0x2e, 0xbe, 0x2e, 
	   0, 0xc1, 0xd5, 0x2e, 0xa4, 0x2e,    0, 0xe0, 
	0xc1, 0x2e, 0xc2, 0x2e,    0, 0xbe, 0x2e, 0xa4, 
	0x2e,    0, 0xc1, 0xd4, 0x2e, 0xc2, 0x2e,    0, 
	0xa1, 0x2e, 0xa4, 0x2e,    0, 0xca, 0x2e, 0xa4, 
	0x2e,    0, 0xa1, 0x2e, 0xc2, 0x2e,    0, 0xb5, 
	0x2e, 0xa4, 0x2e,    0, 0xbe, 0x2e, 0xc2, 0x2e, 
	   0, 0xb8, 0x2e, 0xa4, 0x2e,    0, 0xc1, 0xa1, 
	0xc3, 0xd2, 0xa4, 0xc1,    0, 0xa1, 0xd8, 0xc1, 
	0xc0, 0xd2, 0xbe, 0xd1, 0xb9, 0xb8, 0xec,    0, 
	0xc1, 0xd5, 0xb9, 0xd2, 0xa4, 0xc1,    0, 0xe0, 
	0xc1, 0xc9, 0xd2, 0xc2, 0xb9,    0, 0xbe, 0xc4, 
	0xc9, 0xc0, 0xd2, 0xa4, 0xc1,    0, 0xc1, 0xd4, 
	0xb6, 0xd8, 0xb9, 0xd2, 0xc2, 0xb9,    0, 0xa1, 
	0xc3, 0xa1, 0xae, 0xd2, 0xa4, 0xc1,    0, 0xca, 
	0xd4, 0xa7, 0xcb, 0xd2, 0xa4, 0xc1,    0, 0xa1, 
	0xd1, 0xb9, 0xc2, 0xd2, 0xc2, 0xb9,    0, 0xb5, 
	0xd8, 0xc5, 0xd2, 0xa4, 0xc1,    0, 0xbe, 0xc4, 
	0xc8, 0xa8, 0xd4, 0xa1, 0xd2, 0xc2, 0xb9,    0, 
	0xb8, 0xd1, 0xb9, 0xc7, 0xd2, 0xa4, 0xc1,    0, 
	0x25, 0x61, 0x20, 0x25, 0x65, 0x20, 0x25, 0x62, 
	0x20, 0x25, 0x45, 0x79, 0x2c, 0x20, 0x25, 0x48, 
	0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53,    0, 0x25, 
	0x64, 0x2f, 0x25, 0x6d, 0x2f, 0x25, 0x45, 0x79, 
	   0, 0x2b, 0x3a, 0x31, 0x3a, 0x2d, 0x35, 0x34, 
	0x33, 0x2f, 0x30, 0x31, 0x2f, 0x30, 0x31, 0x3a, 
	0x2b, 0x2a, 0x3a, 0xbe, 0x2e, 0xc8, 0x2e, 0x3a, 
	0x25, 0x45, 0x43, 0x20, 0x25, 0x45, 0x79,    0, 
	   0, 0x25, 0x65, 0x20, 0x25, 0x62, 0x20, 0x25, 
	0x45, 0x79,    0, 0xc7, 0xd1, 0xb9, 0x25, 0x41, 
	0xb7, 0xd5, 0xe8, 0x20, 0x25, 0x65, 0x20, 0x25, 
	0x42, 0x20, 0x25, 0x45, 0x43, 0x20, 0x25, 0x45, 
	0x79, 0x2c, 0x20, 0x25, 0x48, 0x2e, 0x25, 0x4d, 
	0x2e, 0x25, 0x53, 0x20, 0xb9, 0x2e,    0, 0x25, 
	0x48, 0x2e, 0x25, 0x4d, 0x2e, 0x25, 0x53, 0x20, 
	0xb9, 0x2e,    0, 0xe0, 0xb8, 0xad, 0xe0, 0xb8, 
	0xb2, 0x2e,    0, 0xe0, 0xb8, 0x88, 0x2e,    0, 
	0xe0, 0xb8, 0xad, 0x2e,    0, 0xe0, 0xb8, 0x9e, 
	0x2e,    0, 0xe0, 0xb8, 0x9e, 0xe0, 0xb8, 0xa4, 
	0x2e,    0, 0xe0, 0xb8, 0xa8, 0x2e,    0, 0xe0, 
	0xb8, 0xaa, 0x2e,    0, 0xe0, 0xb8, 0xad, 0xe0, 
	0xb8, 0xb2, 0xe0, 0xb8, 0x97, 0xe0, 0xb8, 0xb4, 
	0xe0, 0xb8, 0x95, 0xe0, 0xb8, 0xa2, 0xe0, 0xb9, 
	0x8c,    0, 0xe0, 0xb8, 0x88, 0xe0, 0xb8, 0xb1, 
	0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0x97, 0xe0, 0xb8, 
	0xa3, 0xe0, 0xb9, 0x8c,    0, 0xe0, 0xb8, 0xad, 
	0xe0, 0xb8, 0xb1, 0xe0, 0xb8, 0x87, 0xe0, 0xb8, 
	0x84, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0xa3,    0, 
	0xe0, 0xb8, 0x9e, 0xe0, 0xb8, 0xb8, 0xe0, 0xb8, 
	0x98,    0, 0xe0, 0xb8, 0x9e, 0xe0, 0xb8, 0xa4, 
	0xe0, 0xb8, 0xab, 0xe0, 0xb8, 0xb1, 0xe0, 0xb8, 
	0xaa, 0xe0, 0xb8, 0x9a, 0xe0, 0xb8, 0x94, 0xe0, 
	0xb8, 0xb5,    0, 0xe0, 0xb8, 0xa8, 0xe0, 0xb8, 
	0xb8, 0xe0, 0xb8, 0x81, 0xe0, 0xb8, 0xa3, 0xe0, 
	0xb9, 0x8c,    0, 0xe0, 0xb9, 0x80, 0xe0, 0xb8, 
	0xaa, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0xa3, 0xe0, 
	0xb9, 0x8c,    0, 0xe0, 0xb8, 0xa1, 0x2e, 0xe0, 
	0xb8, 0x84, 0x2e,    0, 0xe0, 0xb8, 0x81, 0x2e, 
	0xe0, 0xb8, 0x9e, 0x2e,    0, 0xe0, 0xb8, 0xa1, 
	0xe0, 0xb8, 0xb5, 0x2e, 0xe0, 0xb8, 0x84, 0x2e, 
	   0, 0xe0, 0xb9, 0x80, 0xe0, 0xb8, 0xa1, 0x2e, 
	0xe0, 0xb8, 0xa2, 0x2e,    0, 0xe0, 0xb8, 0x9e, 
	0x2e, 0xe0, 0xb8, 0x84, 0x2e,    0, 0xe0, 0xb8, 
	0xa1, 0xe0, 0xb8, 0xb4, 0x2e, 0xe0, 0xb8, 0xa2, 
	0x2e,    0, 0xe0, 0xb8, 0x81, 0x2e, 0xe0, 0xb8, 
	0x84, 0x2e,    0, 0xe0, 0xb8, 0xaa, 0x2e, 0xe0, 
	0xb8, 0x84, 0x2e,    0, 0xe0, 0xb8, 0x81, 0x2e, 
	0xe0, 0xb8, 0xa2, 0x2e,    0, 0xe0, 0xb8, 0x95, 
	0x2e, 0xe0, 0xb8, 0x84, 0x2e,    0, 0xe0, 0xb8, 
	0x9e, 0x2e, 0xe0, 0xb8, 0xa2, 0x2e,    0, 0xe0, 
	0xb8, 0x98, 0x2e, 0xe0, 0xb8, 0x84, 0x2e,    0, 
	0xe0, 0xb8, 0xa1, 0xe0, 0xb8, 0x81, 0xe0, 0xb8, 
	0xa3, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0x84, 0xe0, 
	0xb8, 0xa1,    0, 0xe0, 0xb8, 0x81, 0xe0, 0xb8, 
	0xb8, 0xe0, 0xb8, 0xa1, 0xe0, 0xb8, 0xa0, 0xe0, 
	0xb8, 0xb2, 0xe0, 0xb8, 0x9e, 0xe0, 0xb8, 0xb1, 
	0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0x98, 0xe0, 0xb9, 
	0x8c,    0, 0xe0, 0xb8, 0xa1, 0xe0, 0xb8, 0xb5, 
	0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 
	0x84, 0xe0, 0xb8, 0xa1,    0, 0xe0, 0xb9, 0x80, 
	0xe0, 0xb8, 0xa1, 0xe0, 0xb8, 0xa9, 0xe0, 0xb8, 
	0xb2, 0xe0, 0xb8, 0xa2, 0xe0, 0xb8, 0x99,    0, 
	0xe0, 0xb8, 0x9e, 0xe0, 0xb8, 0xa4, 0xe0, 0xb8, 
	0xa9, 0xe0, 0xb8, 0xa0, 0xe0, 0xb8, 0xb2, 0xe0, 
	0xb8, 0x84, 0xe0, 0xb8, 0xa1,    0, 0xe0, 0xb8, 
	0xa1, 0xe0, 0xb8, 0xb4, 0xe0, 0xb8, 0x96, 0xe0, 
	0xb8, 0xb8, 0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0xb2, 
	0xe0, 0xb8, 0xa2, 0xe0, 0xb8, 0x99,    0, 0xe0, 
	0xb8, 0x81, 0xe0, 0xb8, 0xa3, 0xe0, 0xb8, 0x81, 
	0xe0, 0xb8, 0x8e, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 
	0x84, 0xe0, 0xb8, 0xa1,    0, 0xe0, 0xb8, 0xaa, 
	0xe0, 0xb8, 0xb4, 0xe0, 0xb8, 0x87, 0xe0, 0xb8, 
	0xab, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0x84, 0xe0, 
	0xb8, 0xa1,    0, 0xe0, 0xb8, 0x81, 0xe0, 0xb8, 
	0xb1, 0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0xa2, 0xe0, 
	0xb8, 0xb2, 0xe0, 0xb8, 0xa2, 0xe0, 0xb8, 0x99, 
	   0, 0xe0, 0xb8, 0x95, 0xe0, 0xb8, 0xb8, 0xe0, 
	0xb8, 0xa5, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0x84, 
	0xe0, 0xb8, 0xa1,    0, 0xe0, 0xb8, 0x9e, 0xe0, 
	0xb8, 0xa4, 0xe0, 0xb8, 0xa8, 0xe0, 0xb8, 0x88, 
	0xe0, 0xb8, 0xb4, 0xe0, 0xb8, 0x81, 0xe0, 0xb8, 
	0xb2, 0xe0, 0xb8, 0xa2, 0xe0, 0xb8, 0x99,    0, 
	0xe0, 0xb8, 0x98, 0xe0, 0xb8, 0xb1, 0xe0, 0xb8, 
	0x99, 0xe0, 0xb8, 0xa7, 0xe0, 0xb8, 0xb2, 0xe0, 
	0xb8, 0x84, 0xe0, 0xb8, 0xa1,    0, 0x2b, 0x3a, 
	0x31, 0x3a, 0x2d, 0x35, 0x34, 0x33, 0x2f, 0x30, 
	0x31, 0x2f, 0x30, 0x31, 0x3a, 0x2b, 0x2a, 0x3a, 
	0xe0, 0xb8, 0x9e, 0x2e, 0xe0, 0xb8, 0xa8, 0x2e, 
	0x3a, 0x25, 0x45, 0x43, 0x20, 0x25, 0x45, 0x79, 
	   0,    0, 0xe0, 0xb8, 0xa7, 0xe0, 0xb8, 0xb1, 
	0xe0, 0xb8, 0x99, 0x25, 0x41, 0xe0, 0xb8, 0x97, 
	0xe0, 0xb8, 0xb5, 0xe0, 0xb9, 0x88, 0x20, 0x25, 
	0x65, 0x20, 0x25, 0x42, 0x20, 0x25, 0x45, 0x43, 
	0x20, 0x25, 0x45, 0x79, 0x2c, 0x20, 0x25, 0x48, 
	0x2e, 0x25, 0x4d, 0x2e, 0x25, 0x53, 0x20, 0xe0, 
	0xb8, 0x99, 0x2e,    0, 0x25, 0x48, 0x2e, 0x25, 
	0x4d, 0x2e, 0x25, 0x53, 0x20, 0xe0, 0xb8, 0x99, 
	0x2e,    0, 0xe1, 0x88, 0xb0, 0xe1, 0x8a, 0x95, 
	0xe1, 0x89, 0xa0, 0xe1, 0x89, 0xb5,    0, 0xe1, 
	0x88, 0xb0, 0xe1, 0x8a, 0x91, 0xe1, 0x8b, 0xad, 
	   0, 0xe1, 0x88, 0xb0, 0xe1, 0x88, 0x89, 0xe1, 
	0x88, 0xb5,    0, 0xe1, 0x88, 0x93, 0xe1, 0x88, 
	0x99, 0xe1, 0x88, 0xb5,    0, 0xe1, 0x8b, 0x93, 
	0xe1, 0x88, 0xad, 0xe1, 0x89, 0xa2,    0, 0xe1, 
	0x89, 0x80, 0xe1, 0x8b, 0xb3, 0xe1, 0x88, 0x9d, 
	   0, 0xe1, 0x8c, 0xa5, 0xe1, 0x88, 0xaa,    0, 
	0xe1, 0x88, 0x88, 0xe1, 0x8a, 0xab, 0xe1, 0x89, 
	0xb2,    0, 0xe1, 0x88, 0x98, 0xe1, 0x8c, 0x8b, 
	0xe1, 0x89, 0xa2,    0, 0xe1, 0x88, 0x9a, 0xe1, 
	0x8b, 0xab, 0xe1, 0x8b, 0x9d,    0, 0xe1, 0x8c, 
	0x8d, 0xe1, 0x8a, 0x95, 0xe1, 0x89, 0xa6,    0, 
	0xe1, 0x88, 0xb0, 0xe1, 0x8a, 0x90,    0, 0xe1, 
	0x88, 0x93, 0xe1, 0x88, 0x9d, 0xe1, 0x88, 0x88, 
	   0, 0xe1, 0x8a, 0x90, 0xe1, 0x88, 0x93, 0xe1, 
	0x88, 0xb0,    0, 0xe1, 0x88, 0x98, 0xe1, 0x88, 
	0xb5, 0xe1, 0x8a, 0xa8,    0, 0xe1, 0x8c, 0xa5, 
	0xe1, 0x89, 0x85, 0xe1, 0x88, 0x9d,    0, 0xe1, 
	0x88, 0x95, 0xe1, 0x8b, 0xb3, 0xe1, 0x88, 0xad, 
	   0, 0xe1, 0x89, 0xb3, 0xe1, 0x88, 0x95, 0xe1, 
	0x88, 0xb3,    0, 0xe1, 0x88, 0x88, 0xe1, 0x8a, 
	0xab, 0xe1, 0x89, 0xb2, 0xe1, 0x89, 0xb5,    0, 
	0xe1, 0x88, 0x98, 0xe1, 0x8c, 0x8b, 0xe1, 0x89, 
	0xa2, 0xe1, 0x89, 0xb5,    0, 0xe1, 0x88, 0x9a, 
	0xe1, 0x8b, 0xab, 0xe1, 0x8b, 0x9d, 0xe1, 0x8b, 
	0xab,    0, 0xe1, 0x8c, 0x8d, 0xe1, 0x8a, 0x95, 
	0xe1, 0x89, 0xa6, 0xe1, 0x89, 0xb5,    0, 0xe1, 
	0x88, 0x98, 0xe1, 0x88, 0xb5, 0xe1, 0x8a, 0xa8, 
	0xe1, 0x88, 0xa8, 0xe1, 0x88, 0x9d,    0, 0xe1, 
	0x8c, 0xa5, 0xe1, 0x89, 0x85, 0xe1, 0x88, 0x9d, 
	0xe1, 0x89, 0xb2,    0, 0xe1, 0x89, 0xb3, 0xe1, 
	0x88, 0x95, 0xe1, 0x88, 0xb3, 0xe1, 0x88, 0xb5, 
	   0, 0xe1, 0x8a, 0x95, 0xe1, 0x8c, 0x89, 0xe1, 
	0x88, 0x86, 0x20, 0xe1, 0x88, 0xb0, 0xe1, 0x8b, 
	0x93, 0xe1, 0x89, 0xb0,    0, 0xe1, 0x8b, 0xb5, 
	0xe1, 0x88, 0x95, 0xe1, 0x88, 0xad, 0x20, 0xe1, 
	0x88, 0xb0, 0xe1, 0x8b, 0x93, 0xe1, 0x89, 0xb5, 
	   0, 0x25, 0x41, 0xe1, 0x8d, 0xa3, 0x20, 0x25, 
	0x62, 0x20, 0x25, 0x65, 0x20, 0xe1, 0x88, 0x98, 
	0xe1, 0x8b, 0x93, 0xe1, 0x88, 0x8d, 0xe1, 0x89, 
	0xb2, 0x20, 0x25, 0x6c, 0x3a, 0x25, 0x4d, 0x3a, 
	0x25, 0x53, 0x20, 0x25, 0x5a, 0x20, 0x25, 0x59, 
	   0, 0x4c, 0x69, 0x6e,    0, 0x4d, 0x69, 0x79, 
	   0, 0x48, 0x75, 0x77,    0, 0x42, 0x69, 0x79, 
	   0, 0x4c, 0x69, 0x6e, 0x67, 0x67, 0x6f,    0, 
	0x4c, 0x75, 0x6e, 0x65, 0x73,    0, 0x4d, 0x69, 
	0x79, 0x65, 0x72, 0x6b, 0x6f, 0x6c, 0x65, 0x73, 
	   0, 0x48, 0x75, 0x77, 0x65, 0x62, 0x65, 0x73, 
	   0, 0x42, 0x69, 0x79, 0x65, 0x72, 0x6e, 0x65, 
	0x73,    0, 0x53, 0x61, 0x62, 0x61, 0x64, 0x6f, 
	   0, 0x45, 0x6e, 0x65,    0, 0x48, 0x75, 0x6e, 
	   0, 0x48, 0x75, 0x6c,    0, 0x4e, 0x6f, 0x62, 
	   0, 0x45, 0x6e, 0x65, 0x72, 0x6f,    0, 0x50, 
	0x65, 0x62, 0x72, 0x65, 0x72, 0x6f,    0, 0x4d, 
	0x61, 0x72, 0x73, 0x6f,    0, 0x4d, 0x61, 0x79, 
	0x6f,    0, 0x48, 0x75, 0x6e, 0x79, 0x6f,    0, 
	0x48, 0x75, 0x6c, 0x79, 0x6f,    0, 0x53, 0x65, 
	0x70, 0x74, 0x69, 0x79, 0x65, 0x6d, 0x62, 0x72, 
	0x65,    0, 0x4f, 0x6b, 0x74, 0x75, 0x62, 0x72, 
	0x65,    0, 0x4e, 0x6f, 0x62, 0x69, 0x79, 0x65, 
	0x6d, 0x62, 0x72, 0x65,    0, 0x44, 0x69, 0x73, 
	0x79, 0x65, 0x6d, 0x62, 0x72, 0x65,    0, 0x50, 
	0x61, 0x7a,    0, 0x50, 0x7a, 0x74,    0, 0x53, 
	0x61, 0x6c,    0, 0xc7, 0x72, 0xfe,    0, 0x50, 
	0x72, 0xfe,    0, 0x43, 0x75, 0x6d,    0, 0x43, 
	0x74, 0x73,    0, 0x50, 0x61, 0x7a, 0x61, 0x72, 
	   0, 0x50, 0x61, 0x7a, 0x61, 0x72, 0x74, 0x65, 
	0x73, 0x69,    0, 0x53, 0x61, 0x6c, 0xfd,    0, 
	0xc7, 0x61, 0x72, 0xfe, 0x61, 0x6d, 0x62, 0x61, 
	   0, 0x50, 0x65, 0x72, 0xfe, 0x65, 0x6d, 0x62, 
	0x65,    0, 0x43, 0x75, 0x6d, 0x61,    0, 0x43, 
	0x75, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x69, 
	   0, 0x4f, 0x63, 0x61,    0, 0xde, 0x75, 0x62, 
	   0, 0x4e, 0x69, 0x73,    0, 0x48, 0x61, 0x7a, 
	   0, 0x54, 0x65, 0x6d,    0, 0x41, 0xf0, 0x75, 
	   0, 0x45, 0x79, 0x6c,    0, 0x45, 0x6b, 0x69, 
	   0, 0x4b, 0x61, 0x73,    0, 0x41, 0x72, 0x61, 
	   0, 0x4f, 0x63, 0x61, 0x6b,    0, 0xde, 0x75, 
	0x62, 0x61, 0x74,    0, 0x4e, 0x69, 0x73, 0x61, 
	0x6e,    0, 0x4d, 0x61, 0x79, 0xfd, 0x73,    0, 
	0x48, 0x61, 0x7a, 0x69, 0x72, 0x61, 0x6e,    0, 
	0x54, 0x65, 0x6d, 0x6d, 0x75, 0x7a,    0, 0x41, 
	0xf0, 0x75, 0x73, 0x74, 0x6f, 0x73,    0, 0x45, 
	0x79, 0x6c, 0xfc, 0x6c,    0, 0x45, 0x6b, 0x69, 
	0x6d,    0, 0x4b, 0x61, 0x73, 0xfd, 0x6d,    0, 
	0x41, 0x72, 0x61, 0x6c, 0xfd, 0x6b,    0, 0xd6, 
	0xd6,    0, 0xd6, 0x53,    0, 0xc3, 0x87, 0x72, 
	0xc5, 0x9f,    0, 0x50, 0x72, 0xc5, 0x9f,    0, 
	0x53, 0x61, 0x6c, 0xc4, 0xb1,    0, 0xc3, 0x87, 
	0x61, 0x72, 0xc5, 0x9f, 0x61, 0x6d, 0x62, 0x61, 
	   0, 0x50, 0x65, 0x72, 0xc5, 0x9f, 0x65, 0x6d, 
	0x62, 0x65,    0, 0xc5, 0x9e, 0x75, 0x62,    0, 
	0x41, 0xc4, 0x9f, 0x75,    0, 0xc5, 0x9e, 0x75, 
	0x62, 0x61, 0x74,    0, 0x4d, 0x61, 0x79, 0xc4, 
	0xb1, 0x73,    0, 0x41, 0xc4, 0x9f, 0x75, 0x73, 
	0x74, 0x6f, 0x73,    0, 0x45, 0x79, 0x6c, 0xc3, 
	0xbc, 0x6c,    0, 0x4b, 0x61, 0x73, 0xc4, 0xb1, 
	0x6d,    0, 0x41, 0x72, 0x61, 0x6c, 0xc4, 0xb1, 
	0x6b,    0, 0xc3, 0x96, 0xc3, 0x96,    0, 0xc3, 
	0x96, 0x53,    0, 0xd0, 0xaf, 0xd0, 0xba, 0xd1, 
	0x88,    0, 0xd0, 0x94, 0xd1, 0x8b, 0xd1, 0x88, 
	   0, 0xd0, 0xa1, 0xd0, 0xb8, 0xd1, 0x88,    0, 
	0xd0, 0xa7, 0xd3, 0x99, 0xd1, 0x80, 0xd1, 0x88, 
	   0, 0xd0, 0x9f, 0xd3, 0x99, 0xd0, 0xbd, 0xd2, 
	0x97,    0, 0xd2, 0x96, 0xd0, 0xbe, 0xd0, 0xbc, 
	   0, 0xd0, 0xa8, 0xd0, 0xb8, 0xd0, 0xbc,    0, 
	0xd0, 0xaf, 0xd0, 0xba, 0xd1, 0x88, 0xd3, 0x99, 
	0xd0, 0xbc, 0xd0, 0xb1, 0xd0, 0xb5,    0, 0xd0, 
	0x94, 0xd1, 0x8b, 0xd1, 0x88, 0xd3, 0x99, 0xd0, 
	0xbc, 0xd0, 0xb1, 0xd0, 0xb5,    0, 0xd0, 0xa1, 
	0xd0, 0xb8, 0xd1, 0x88, 0xd3, 0x99, 0xd0, 0xbc, 
	0xd0, 0xb1, 0xd0, 0xb5,    0, 0xd0, 0xa7, 0xd3, 
	0x99, 0xd1, 0x80, 0xd1, 0x88, 0xd3, 0x99, 0xd3, 
	0x99, 0xd0, 0xbc, 0xd0, 0xb1, 0xd0, 0xb5,    0, 
	0xd0, 0x9f, 0xd3, 0x99, 0xd0, 0xbd, 0xd2, 0x97, 
	0xd0, 0xb5, 0xd1, 0x88, 0xd0, 0xbc, 0xd0, 0xb1, 
	0xd0, 0xb5,    0, 0xd2, 0x96, 0xd0, 0xbe, 0xd0, 
	0xbc, 0xd0, 0xb3, 0xd0, 0xb0,    0, 0xd0, 0xa8, 
	0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb1, 0xd3, 0x99, 
	   0, 0xee, 0xc4, 0xcc,    0, 0xee, 0xc5, 0xc4, 
	0xa6, 0xcc, 0xd1,    0, 0xf0, 0xcf, 0xce, 0xc5, 
	0xc4, 0xa6, 0xcc, 0xcf, 0xcb,    0, 0xf7, 0xa6, 
	0xd7, 0xd4, 0xcf, 0xd2, 0xcf, 0xcb,    0, 0xf3, 
	0xc5, 0xd2, 0xc5, 0xc4, 0xc1,    0, 0xfe, 0xc5, 
	0xd4, 0xd7, 0xc5, 0xd2,    0, 0xf0, 0x27, 0xd1, 
	0xd4, 0xce, 0xc9, 0xc3, 0xd1,    0, 0xf3, 0xd5, 
	0xc2, 0xcf, 0xd4, 0xc1,    0, 0xf3, 0xa6, 0xde, 
	   0, 0xec, 0xc0, 0xd4,    0, 0xe2, 0xc5, 0xd2, 
	   0, 0xeb, 0xd7, 0xa6,    0, 0xf4, 0xd2, 0xc1, 
	   0, 0xfe, 0xc5, 0xd2,    0, 0xec, 0xc9, 0xd0, 
	   0, 0xf3, 0xc5, 0xd2,    0, 0xf7, 0xc5, 0xd2, 
	   0, 0xf6, 0xcf, 0xd7,    0, 0xec, 0xc9, 0xd3, 
	   0, 0xe7, 0xd2, 0xd5,    0, 0xf3, 0xa6, 0xde, 
	0xc5, 0xce, 0xd8,    0, 0xec, 0xc0, 0xd4, 0xc9, 
	0xca,    0, 0xe2, 0xc5, 0xd2, 0xc5, 0xda, 0xc5, 
	0xce, 0xd8,    0, 0xeb, 0xd7, 0xa6, 0xd4, 0xc5, 
	0xce, 0xd8,    0, 0xf4, 0xd2, 0xc1, 0xd7, 0xc5, 
	0xce, 0xd8,    0, 0xfe, 0xc5, 0xd2, 0xd7, 0xc5, 
	0xce, 0xd8,    0, 0xec, 0xc9, 0xd0, 0xc5, 0xce, 
	0xd8,    0, 0xf3, 0xc5, 0xd2, 0xd0, 0xc5, 0xce, 
	0xd8,    0, 0xf7, 0xc5, 0xd2, 0xc5, 0xd3, 0xc5, 
	0xce, 0xd8,    0, 0xf6, 0xcf, 0xd7, 0xd4, 0xc5, 
	0xce, 0xd8,    0, 0xec, 0xc9, 0xd3, 0xd4, 0xcf, 
	0xd0, 0xc1, 0xc4,    0, 0xe7, 0xd2, 0xd5, 0xc4, 
	0xc5, 0xce, 0xd8,    0, 0xd0, 0x9d, 0xd0, 0xb4, 
	0xd0, 0xbb,    0, 0xd0, 0x9d, 0xd0, 0xb5, 0xd0, 
	0xb4, 0xd1, 0x96, 0xd0, 0xbb, 0xd1, 0x8f,    0, 
	0xd0, 0x9f, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb5, 
	0xd0, 0xb4, 0xd1, 0x96, 0xd0, 0xbb, 0xd0, 0xbe, 
	0xd0, 0xba,    0, 0xd0, 0x92, 0xd1, 0x96, 0xd0, 
	0xb2, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 
	0xbe, 0xd0, 0xba,    0, 0xd0, 0xa1, 0xd0, 0xb5, 
	0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xb0, 
	   0, 0xd0, 0xa7, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 
	0xb2, 0xd0, 0xb5, 0xd1, 0x80,    0, 0xd0, 0x9f, 
	0x27, 0xd1, 0x8f, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 
	0xb8, 0xd1, 0x86, 0xd1, 0x8f,    0, 0xd0, 0xa1, 
	0xd1, 0x96, 0xd1, 0x87,    0, 0xd0, 0x91, 0xd0, 
	0xb5, 0xd1, 0x80,    0, 0xd0, 0x9a, 0xd0, 0xb2, 
	0xd1, 0x96,    0, 0xd0, 0xa7, 0xd0, 0xb5, 0xd1, 
	0x80,    0, 0xd0, 0x9b, 0xd0, 0xb8, 0xd0, 0xbf, 
	   0, 0xd0, 0xa1, 0xd0, 0xb5, 0xd1, 0x80,    0, 
	0xd0, 0x92, 0xd0, 0xb5, 0xd1, 0x80,    0, 0xd0, 
	0x96, 0xd0, 0xbe, 0xd0, 0xb2,    0, 0xd0, 0x9b, 
	0xd0, 0xb8, 0xd1, 0x81,    0, 0xd0, 0x93, 0xd1, 
	0x80, 0xd1, 0x83,    0, 0xd0, 0xa1, 0xd1, 0x96, 
	0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 
	   0, 0xd0, 0x9b, 0xd1, 0x8e, 0xd1, 0x82, 0xd0, 
	0xb8, 0xd0, 0xb9,    0, 0xd0, 0x91, 0xd0, 0xb5, 
	0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb7, 0xd0, 0xb5, 
	0xd0, 0xbd, 0xd1, 0x8c,    0, 0xd0, 0x9a, 0xd0, 
	0xb2, 0xd1, 0x96, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 
	0xbd, 0xd1, 0x8c,    0, 0xd0, 0xa7, 0xd0, 0xb5, 
	0xd1, 0x80, 0xd0, 0xb2, 0xd0, 0xb5, 0xd0, 0xbd, 
	0xd1, 0x8c,    0, 0xd0, 0x9b, 0xd0, 0xb8, 0xd0, 
	0xbf, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c,    0, 
	0xd0, 0xa1, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xbf, 
	0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c,    0, 0xd0, 
	0x92, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb5, 0xd1, 
	0x81, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c,    0, 
	0xd0, 0x96, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x82, 
	0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c,    0, 0xd0, 
	0x9b, 0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 
	0xbe, 0xd0, 0xbf, 0xd0, 0xb0, 0xd0, 0xb4,    0, 
	0xd0, 0x93, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xb4, 
	0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c,    0, 0xd8, 
	0xa7, 0xd8, 0xaa, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 
	0xb1,    0, 0xd9, 0xbe, 0xd9, 0x8a, 0xd8, 0xb1, 
	   0, 0xd9, 0x85, 0xd9, 0x86, 0xda, 0xaf, 0xd9, 
	0x84,    0, 0xd8, 0xa8, 0xd8, 0xaf, 0xda, 0xbe, 
	   0, 0xd8, 0xac, 0xd9, 0x85, 0xd8, 0xb9, 0xd8, 
	0xb1, 0xd8, 0xa7, 0xd8, 0xaa,    0, 0xd9, 0x87, 
	0xd9, 0x81, 0xd8, 0xaa, 0xd9, 0x87,    0, 0xd8, 
	0xac, 0xd9, 0x86, 0xd9, 0x88, 0xd8, 0xb1, 0xd9, 
	0x8a,    0, 0xd9, 0x81, 0xd8, 0xb1, 0xd9, 0x88, 
	0xd8, 0xb1, 0xd9, 0x8a,    0, 0xd9, 0x85, 0xd8, 
	0xa7, 0xd8, 0xb1, 0xda, 0x86,    0, 0xd8, 0xa7, 
	0xd9, 0xbe, 0xd8, 0xb1, 0xd9, 0x8a, 0xd9, 0x84, 
	   0, 0xd9, 0x85, 0xd9, 0x93, 0xdb, 0x8c,    0, 
	0xd8, 0xac, 0xd9, 0x88, 0xd9, 0x86,    0, 0xd8, 
	0xac, 0xd9, 0x88, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 
	0x8a,    0, 0xd8, 0xa7, 0xda, 0xaf, 0xd8, 0xb3, 
	0xd8, 0xaa,    0, 0xd8, 0xb3, 0xd8, 0xaa, 0xd9, 
	0x85, 0xd8, 0xa8, 0xd8, 0xb1,    0, 0xd8, 0xa7, 
	0xd9, 0x83, 0xd8, 0xaa, 0xd9, 0x88, 0xd8, 0xa8, 
	0xd8, 0xb1,    0, 0xd9, 0x86, 0xd9, 0x88, 0xd9, 
	0x85, 0xd8, 0xa8, 0xd8, 0xb1,    0, 0xd8, 0xaf, 
	0xd8, 0xb3, 0xd9, 0x85, 0xd8, 0xa8, 0xd8, 0xb1, 
	   0, 0xd8, 0xb4,    0, 0xd9, 0x88, 0x20, 0x25, 
	0x48, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53, 0x20, 
	0x25, 0x5a, 0x20, 0xd8, 0xaa, 0x20, 0x25, 0x64, 
	0x20, 0x25, 0x42, 0x20, 0x25, 0x59,    0, 0x25, 
	0x50, 0x20, 0x25, 0x49, 0x3a, 0x25, 0x4d, 0x3a, 
	0x25, 0x53,    0, 0x59, 0x61, 0x6b,    0, 0x53, 
	0x65,    0, 0x43, 0x68, 0x6f,    0, 0x50, 0x61, 
	0x79,    0, 0x4a, 0x75,    0, 0x53, 0x68, 0x61, 
	   0, 0x79, 0x61, 0x6b, 0x73, 0x68, 0x61, 0x6e, 
	0x62, 0x61,    0, 0x64, 0x75, 0x73, 0x68, 0x61, 
	0x6e, 0x62, 0x61,    0, 0x73, 0x65, 0x73, 0x68, 
	0x61, 0x6e, 0x62, 0x61,    0, 0x63, 0x68, 0x6f, 
	0x72, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61,    0, 
	0x70, 0x61, 0x79, 0x73, 0x68, 0x61, 0x6e, 0x62, 
	0x61,    0, 0x6a, 0x75, 0x6d, 0x61,    0, 0x73, 
	0x68, 0x61, 0x6e, 0x62, 0x61,    0, 0x59, 0x61, 
	0x76,    0, 0x49, 0x79, 0x6e,    0, 0x49, 0x79, 
	0x6c,    0, 0x41, 0x76, 0x67,    0, 0x73, 0x65, 
	0x6e, 0x79, 0x61, 0x62, 0x72,    0, 0x25, 0x54, 
	0x2c, 0x20, 0x25, 0x64, 0x20, 0x25, 0x42, 0x2c, 
	0x20, 0x25, 0x59, 0x20, 0x79, 0x69, 0x6c, 0x2c, 
	0x20, 0x25, 0x41,    0, 0x43, 0x4e, 0x20,    0, 
	0x54, 0x68, 0x20, 0x32, 0x20,    0, 0x54, 0x68, 
	0x20, 0x33, 0x20,    0, 0x54, 0x68, 0x20, 0x34, 
	0x20,    0, 0x54, 0x68, 0x20, 0x35, 0x20,    0, 
	0x54, 0x68, 0x20, 0x36, 0x20,    0, 0x54, 0x68, 
	0x20, 0x37, 0x20,    0, 0x43, 0x68, 0x75, 0xcc, 
	0x89, 0x20, 0x6e, 0x68, 0xc3, 0xa2, 0xcc, 0xa3, 
	0x74, 0x20,    0, 0x54, 0x68, 0xc6, 0xb0, 0xcc, 
	0x81, 0x20, 0x68, 0x61, 0x69, 0x20,    0, 0x54, 
	0x68, 0xc6, 0xb0, 0xcc, 0x81, 0x20, 0x62, 0x61, 
	0x20,    0, 0x54, 0x68, 0xc6, 0xb0, 0xcc, 0x81, 
	0x20, 0x74, 0xc6, 0xb0, 0x20,    0, 0x54, 0x68, 
	0xc6, 0xb0, 0xcc, 0x81, 0x20, 0x6e, 0xc4, 0x83, 
	0x6d, 0x20,    0, 0x54, 0x68, 0xc6, 0xb0, 0xcc, 
	0x81, 0x20, 0x73, 0xc3, 0xa1, 0x75, 0x20,    0, 
	0x54, 0x68, 0xc6, 0xb0, 0xcc, 0x81, 0x20, 0x62, 
	0x61, 0xcc, 0x89, 0x79, 0x20,    0, 0x54, 0x68, 
	0x67, 0x20, 0x31,    0, 0x54, 0x68, 0x67, 0x20, 
	0x32,    0, 0x54, 0x68, 0x67, 0x20, 0x33,    0, 
	0x54, 0x68, 0x67, 0x20, 0x34,    0, 0x54, 0x68, 
	0x67, 0x20, 0x35,    0, 0x54, 0x68, 0x67, 0x20, 
	0x36,    0, 0x54, 0x68, 0x67, 0x20, 0x37,    0, 
	0x54, 0x68, 0x67, 0x20, 0x38,    0, 0x54, 0x68, 
	0x67, 0x20, 0x39,    0, 0x54, 0x68, 0x67, 0x20, 
	0x31, 0x30,    0, 0x54, 0x68, 0x67, 0x20, 0x31, 
	0x31,    0, 0x54, 0x68, 0x67, 0x20, 0x31, 0x32, 
	   0, 0x54, 0x68, 0xc3, 0xa1, 0x6e, 0x67, 0x20, 
	0x6d, 0xc3, 0xb4, 0xcc, 0xa3, 0x74,    0, 0x54, 
	0x68, 0xc3, 0xa1, 0x6e, 0x67, 0x20, 0x68, 0x61, 
	0x69,    0, 0x54, 0x68, 0xc3, 0xa1, 0x6e, 0x67, 
	0x20, 0x62, 0x61,    0, 0x54, 0x68, 0xc3, 0xa1, 
	0x6e, 0x67, 0x20, 0x74, 0xc6, 0xb0,    0, 0x54, 
	0x68, 0xc3, 0xa1, 0x6e, 0x67, 0x20, 0x6e, 0xc4, 
	0x83, 0x6d,    0, 0x54, 0x68, 0xc3, 0xa1, 0x6e, 
	0x67, 0x20, 0x73, 0xc3, 0xa1, 0x75,    0, 0x54, 
	0x68, 0xc3, 0xa1, 0x6e, 0x67, 0x20, 0x62, 0x61, 
	0xcc, 0x89, 0x79,    0, 0x54, 0x68, 0xc3, 0xa1, 
	0x6e, 0x67, 0x20, 0x74, 0xc3, 0xa1, 0x6d,    0, 
	0x54, 0x68, 0xc3, 0xa1, 0x6e, 0x67, 0x20, 0x63, 
	0x68, 0xc3, 0xad, 0x6e,    0, 0x54, 0x68, 0xc3, 
	0xa1, 0x6e, 0x67, 0x20, 0x6d, 0xc6, 0xb0, 0xc6, 
	0xa1, 0xcc, 0x80, 0x69,    0, 0x54, 0x68, 0xc3, 
	0xa1, 0x6e, 0x67, 0x20, 0x6d, 0xc6, 0xb0, 0xc6, 
	0xa1, 0xcc, 0x80, 0x69, 0x20, 0x6d, 0xc3, 0xb4, 
	0xcc, 0xa3, 0x74,    0, 0x54, 0x68, 0xc3, 0xa1, 
	0x6e, 0x67, 0x20, 0x6d, 0xc6, 0xb0, 0xc6, 0xa1, 
	0xcc, 0x80, 0x69, 0x20, 0x68, 0x61, 0x69,    0, 
	0x25, 0x48, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53, 
	0x20, 0x25, 0x5a, 0x20, 0x25, 0x41, 0x20, 0x25, 
	0x64, 0x20, 0x25, 0x62, 0x20, 0x25, 0x59,    0, 
	0x25, 0x48, 0x3a, 0x25, 0x4d, 0x3a, 0x25, 0x53, 
	0x20, 0x25, 0x5a,    0, 0x64, 0xee, 0x6d,    0, 
	0x6c, 0x6f, 0x6e,    0, 0x6d, 0xe5, 0x72,    0, 
	0x64, 0x6a, 0x75,    0, 0x76, 0x69, 0x6e,    0, 
	0x73, 0x65, 0x6d,    0, 0x64, 0xee, 0x6d, 0x65, 
	0x67, 0x6e, 0x65,    0, 0x6c, 0x6f, 0x6e, 0x64, 
	0x69,    0, 0x6d, 0xe5, 0x72, 0x64, 0x69,    0, 
	0x6d, 0x65, 0x72, 0x6b, 0x69, 0x64, 0x69,    0, 
	0x64, 0x6a, 0x75, 0x64, 0x69,    0, 0x76, 0x69, 
	0x6e, 0x72, 0x64, 0x69,    0, 0x73, 0x65, 0x6d, 
	0x64, 0x69,    0, 0x64, 0x6a, 0x61,    0, 0x66, 
	0x65, 0x76,    0, 0x6d, 0xe5, 0x73,    0, 0x64, 
	0x6a, 0x6e,    0, 0x64, 0x6a, 0x6c,    0, 0x61, 
	0x77, 0x6f,    0, 0x6e, 0xf4, 0x76,    0, 0x64, 
	0x6a, 0x61, 0x6e, 0x76, 0xee,    0, 0x66, 0x65, 
	0x76, 0x72, 0xee,    0, 0x6d, 0xe5, 0x73, 0x73, 
	   0, 0x61, 0x76, 0x72, 0x69,    0, 0x64, 0x6a, 
	0x75, 0x6e,    0, 0x64, 0x6a, 0x75, 0x6c, 0x65, 
	0x74, 0x65,    0, 0x61, 0x77, 0x6f, 0x75, 0x73, 
	0x73, 0x65,    0, 0x73, 0x65, 0x74, 0x69, 0x6d, 
	0x62, 0x65,    0, 0x6f, 0x63, 0x74, 0xf4, 0x62, 
	0x65,    0, 0x6e, 0xf4, 0x76, 0x69, 0x6d, 0x62, 
	0x65,    0, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x62, 
	0x65,    0, 0x4c, 0x69, 0x20, 0x25, 0x41, 0x20, 
	0x25, 0x64, 0x20, 0x64, 0x69, 0x20, 0x25, 0x42, 
	0x20, 0x25, 0x59, 0x20, 0x25, 0x54, 0x20, 0x25, 
	0x5a,    0, 0x64, 0xc3, 0xae, 0x6d,    0, 0x6d, 
	0xc3, 0xa5, 0x72,    0, 0x64, 0xc3, 0xae, 0x6d, 
	0x65, 0x67, 0x6e, 0x65,    0, 0x6d, 0xc3, 0xa5, 
	0x72, 0x64, 0x69,    0, 0x6d, 0xc3, 0xa5, 0x73, 
	   0, 0x6e, 0xc3, 0xb4, 0x76,    0, 0x64, 0x6a, 
	0x61, 0x6e, 0x76, 0xc3, 0xae,    0, 0x66, 0x65, 
	0x76, 0x72, 0xc3, 0xae,    0, 0x6d, 0xc3, 0xa5, 
	0x73, 0x73,    0, 0x6f, 0x63, 0x74, 0xc3, 0xb4, 
	0x62, 0x65,    0, 0x6e, 0xc3, 0xb4, 0x76, 0x69, 
	0x6d, 0x62, 0x65,    0, 0xe6, 0xe5, 0xf0, 0x27, 
	   0, 0xee, 0xe0, 0xc8, 0xf0, 0x27,    0, 0xe3, 
	0xe9, 0xf0, 0x27,    0, 0xee, 0xe9, 0xe8, 0x27, 
	   0, 0xe3, 0xe0, 0xc8, 0xf0, 0x27,    0, 0xf4, 
	0xcf, 0xf8, 0xd6, 0xc7, 0x27,    0, 0xe6, 0xe5, 
	0xf0, 0xe8, 0xe9, 0xf7,    0, 0xee, 0xe0, 0xc8, 
	0xf0, 0xe8, 0xe9, 0xf7,    0, 0xe3, 0xe9, 0xf0, 
	0xf1, 0xe8, 0xe9, 0xf7,    0, 0xee, 0xe9, 0xe8, 
	0xd4, 0xe0, 0xc8, 0xea,    0, 0xe3, 0xe0, 0xc8, 
	0xf0, 0xf2, 0xf8, 0xf9, 0xe8, 0xe9, 0xf7,    0, 
	0xf4, 0xcf, 0xf8, 0xd6, 0xc7, 0xe8, 0xe9, 0xf7, 
	   0, 0xe9, 0xe0, 0xc7, 0xf0, 0x27,    0, 0xf4, 
	0xcf, 0xf2, 0xe1, 0x27,    0, 0xee, 0xe0, 0xc7, 
	0xf8, 0x27,    0, 0xe0, 0xc7, 0xf4, 0xcc, 0xf8, 
	0x27,    0, 0xee, 0xd6, 0xc7,    0, 0xe9, 0xe5, 
	0xf0, 0x27,    0, 0xe9, 0xe5, 0xec, 0x27,    0, 
	0xe0, 0xd5, 0xe2, 0x27,    0, 0xf1, 0xf2, 0xf4, 
	0xcc, 0x27,    0, 0xe0, 0xc8, 0xf7, 0xe8, 0x27, 
	   0, 0xf0, 0xe0, 0xc8, 0xd4, 0x27,    0, 0xe3, 
	0xf2, 0xf6, 0x27,    0, 0xe9, 0xe0, 0xc7, 0xf0, 
	0xe5, 0xe0, 0xc7, 0xf8,    0, 0xf4, 0xcf, 0xf2, 
	0xe1, 0xf8, 0xe5, 0xe0, 0xc7, 0xf8,    0, 0xee, 
	0xe0, 0xc7, 0xf8, 0xf5,    0, 0xe0, 0xc7, 0xf4, 
	0xcc, 0xf8, 0xe9, 0xec,    0, 0xe0, 0xd5, 0xe2, 
	0xf1, 0xe8,    0, 0xf1, 0xf2, 0xf4, 0xcc, 0xe8, 
	0xf2, 0xee, 0xe1, 0xf2, 0xf8,    0, 0xe0, 0xc8, 
	0xf7, 0xe8, 0xe0, 0xc8, 0xe1, 0xf2, 0xf8,    0, 
	0xf0, 0x41, 0xc8, 0xd4, 0xf2, 0xee, 0xe1, 0xf2, 
	0xf8,    0, 0xd7, 0x96, 0xd7, 0x95, 0xd7, 0xa0, 
	0x27,    0, 0xd7, 0x9e, 0xd7, 0x90, 0xd6, 0xb8, 
	0xd7, 0xa0, 0x27,    0, 0xd7, 0x93, 0xd7, 0x99, 
	0xd7, 0xa0, 0x27,    0, 0xd7, 0x9e, 0xd7, 0x99, 
	0xd7, 0x98, 0x27,    0, 0xd7, 0x93, 0xd7, 0x90, 
	0xd6, 0xb8, 0xd7, 0xa0, 0x27,    0, 0xd7, 0xa4, 
	0xd6, 0xbf, 0xd7, 0xa8, 0xd7, 0xb2, 0xd6, 0xb7, 
	0x27,    0, 0xd7, 0x96, 0xd7, 0x95, 0xd7, 0xa0, 
	0xd7, 0x98, 0xd7, 0x99, 0xd7, 0xa7,    0, 0xd7, 
	0x9e, 0xd7, 0x90, 0xd6, 0xb8, 0xd7, 0xa0, 0xd7, 
	0x98, 0xd7, 0x99, 0xd7, 0xa7,    0, 0xd7, 0x93, 
	0xd7, 0x99, 0xd7, 0xa0, 0xd7, 0xa1, 0xd7, 0x98, 
	0xd7, 0x99, 0xd7, 0xa7,    0, 0xd7, 0x9e, 0xd7, 
	0x99, 0xd7, 0x98, 0xd7, 0xb0, 0xd7, 0x90, 0xd6, 
	0xb8, 0xd7, 0x9a,    0, 0xd7, 0x93, 0xd7, 0x90, 
	0xd6, 0xb8, 0xd7, 0xa0, 0xd7, 0xa2, 0xd7, 0xa8, 
	0xd7, 0xa9, 0xd7, 0x98, 0xd7, 0x99, 0xd7, 0xa7, 
	   0, 0xd7, 0xa4, 0xd6, 0xbf, 0xd7, 0xa8, 0xd7, 
	0xb2, 0xd6, 0xb7, 0xd7, 0x98, 0xd7, 0x99, 0xd7, 
	0xa7,    0, 0xd7, 0x99, 0xd7, 0x90, 0xd6, 0xb7, 
	0xd7, 0xa0, 0x27,    0, 0xd7, 0xa4, 0xd6, 0xbf, 
	0xd7, 0xa2, 0xd7, 0x91, 0x27,    0, 0xd7, 0x9e, 
	0xd7, 0x90, 0xd6, 0xb7, 0xd7, 0xa8, 0x27,    0, 
	0xd7, 0x90, 0xd6, 0xb7, 0xd7, 0xa4, 0xd6, 0xbc, 
	0xd7, 0xa8, 0x27,    0, 0xd7, 0x9e, 0xd7, 0xb2, 
	0xd6, 0xb7,    0, 0xd7, 0x99, 0xd7, 0x95, 0xd7, 
	0xa0, 0x27,    0, 0xd7, 0x99, 0xd7, 0x95, 0xd7, 
	0x9c, 0x27,    0, 0xd7, 0x90, 0xd7, 0xb1, 0xd7, 
	0x92, 0x27,    0, 0xd7, 0xa1, 0xd7, 0xa2, 0xd7, 
	0xa4, 0xd6, 0xbc, 0x27,    0, 0xd7, 0x90, 0xd6, 
	0xb8, 0xd7, 0xa7, 0xd7, 0x98, 0x27,    0, 0xd7, 
	0xa0, 0xd7, 0x90, 0xd6, 0xb8, 0xd7, 0xb0, 0x27, 
	   0, 0xd7, 0x93, 0xd7, 0xa2, 0xd7, 0xa6, 0x27, 
	   0, 0xd7, 0x99, 0xd7, 0x90, 0xd6, 0xb7, 0xd7, 
	0xa0, 0xd7, 0x95, 0xd7, 0x90, 0xd6, 0xb7, 0xd7, 
	0xa8,    0, 0xd7, 0xa4, 0xd6, 0xbf, 0xd7, 0xa2, 
	0xd7, 0x91, 0xd7, 0xa8, 0xd7, 0x95, 0xd7, 0x90, 
	0xd6, 0xb7, 0xd7, 0xa8,    0, 0xd7, 0x9e, 0xd7, 
	0x90, 0xd6, 0xb7, 0xd7, 0xa8, 0xd7, 0xa5,    0, 
	0xd7, 0x90, 0xd6, 0xb7, 0xd7, 0xa4, 0xd6, 0xbc, 
	0xd7, 0xa8, 0xd7, 0x99, 0xd7, 0x9c,    0, 0xd7, 
	0x90, 0xd7, 0xb1, 0xd7, 0x92, 0xd7, 0xa1, 0xd7, 
	0x98,    0, 0xd7, 0xa1, 0xd7, 0xa2, 0xd7, 0xa4, 
	0xd6, 0xbc, 0xd7, 0x98, 0xd7, 0xa2, 0xd7, 0x9e, 
	0xd7, 0x91, 0xd7, 0xa2, 0xd7, 0xa8,    0, 0xd7, 
	0x90, 0xd6, 0xb8, 0xd7, 0xa7, 0xd7, 0x98, 0xd7, 
	0x90, 0xd6, 0xb8, 0xd7, 0x91, 0xd7, 0xa2, 0xd7, 
	0xa8,    0, 0xd7, 0xa0, 0x41, 0xd6, 0xb8, 0xd7, 
	0xb0, 0xd7, 0xa2, 0xd7, 0x9e, 0xd7, 0x91, 0xd7, 
	0xa2, 0xd7, 0xa8,    0, 0xe4, 0xb8, 0x80,    0, 
	0xe4, 0xba, 0x8c,    0, 0xe4, 0xb8, 0x89,    0, 
	0xe5, 0x9b, 0x9b,    0, 0xe4, 0xba, 0x94,    0, 
	0xe5, 0x85, 0xad,    0, 0xe6, 0x98, 0x9f, 0xe6, 
	0x9c, 0x9f, 0xe6, 0x97, 0xa5,    0, 0xe6, 0x98, 
	0x9f, 0xe6, 0x9c, 0x9f, 0xe4, 0xb8, 0x80,    0, 
	0xe6, 0x98, 0x9f, 0xe6, 0x9c, 0x9f, 0xe4, 0xba, 
	0x8c,    0, 0xe6, 0x98, 0x9f, 0xe6, 0x9c, 0x9f, 
	0xe4, 0xb8, 0x89,    0, 0xe6, 0x98, 0x9f, 0xe6, 
	0x9c, 0x9f, 0xe5, 0x9b, 0x9b,    0, 0xe6, 0x98, 
	0x9f, 0xe6, 0x9c, 0x9f, 0xe4, 0xba, 0x94,    0, 
	0xe6, 0x98, 0x9f, 0xe6, 0x9c, 0x9f, 0xe5, 0x85, 
	0xad,    0, 0xe4, 0xb8, 0x80, 0xe6, 0x9c, 0x88, 
	   0, 0xe4, 0xba, 0x8c, 0xe6, 0x9c, 0x88,    0, 
	0xe4, 0xb8, 0x89, 0xe6, 0x9c, 0x88,    0, 0xe5, 
	0x9b, 0x9b, 0xe6, 0x9c, 0x88,    0, 0xe4, 0xba, 
	0x94, 0xe6, 0x9c, 0x88,    0, 0xe5, 0x85, 0xad, 
	0xe6, 0x9c, 0x88,    0, 0xe4, 0xb8, 0x83, 0xe6, 
	0x9c, 0x88,    0, 0xe5, 0x85, 0xab, 0xe6, 0x9c, 
	0x88,    0, 0xe4, 0xb9, 0x9d, 0xe6, 0x9c, 0x88, 
	   0, 0xe5, 0x8d, 0x81, 0xe6, 0x9c, 0x88,    0, 
	0xe5, 0x8d, 0x81, 0xe4, 0xb8, 0x80, 0xe6, 0x9c, 
	0x88,    0, 0xe5, 0x8d, 0x81, 0xe4, 0xba, 0x8c, 
	0xe6, 0x9c, 0x88,    0, 0xe4, 0xb8, 0x8a, 0xe5, 
	0x8d, 0x88,    0, 0xe4, 0xb8, 0x8b, 0xe5, 0x8d, 
	0x88,    0, 0x25, 0x59, 0xe5, 0xb9, 0xb4, 0x25, 
	0x6d, 0xe6, 0x9c, 0x88, 0x25, 0x64, 0xe6, 0x97, 
	0xa5, 0x20, 0x25, 0x41, 0x20, 0x25, 0x48, 0xe6, 
	0x97, 0xb6, 0x25, 0x4d, 0xe5, 0x88, 0x86, 0x25, 
	0x53, 0xe7, 0xa7, 0x92,    0, 0x25, 0x48, 0xe6, 
	0x97, 0xb6, 0x25, 0x4d, 0xe5, 0x88, 0x86, 0x25, 
	0x53, 0xe7, 0xa7, 0x92,    0, 0x25, 0x70, 0x20, 
	0x25, 0x49, 0xe6, 0x97, 0xb6, 0x25, 0x4d, 0xe5, 
	0x88, 0x86, 0x25, 0x53, 0xe7, 0xa7, 0x92,    0, 
	0x25, 0x59, 0xe5, 0xb9, 0xb4, 0x25, 0x6d, 0xe6, 
	0x9c, 0x88, 0x25, 0x64, 0xe6, 0x97, 0xa5, 0x20, 
	0x25, 0x41, 0x20, 0x25, 0x48, 0x3a, 0x25, 0x4d, 
	0x3a, 0x25, 0x53,    0, 0x25, 0x59, 0xe5, 0xb9, 
	0xb4, 0x25, 0x6d, 0xe6, 0x9c, 0x88, 0x25, 0x64, 
	0xe6, 0x97, 0xa5, 0x20, 0x25, 0x41,    0, 0x25, 
	0x49, 0xe6, 0x99, 0x82, 0x25, 0x4d, 0xe5, 0x88, 
	0x86, 0x25, 0x53, 0xe7, 0xa7, 0x92, 0x20, 0x25, 
	0x5a,    0, 0x25, 0x70, 0x20, 0x25, 0x49, 0x3a, 
	0x25, 0x4d, 0x3a, 0x25, 0x53,    0, 0x25, 0x59, 
	0xe5, 0xb9, 0xb4, 0x25, 0x6d, 0xe6, 0x9c, 0x88, 
	0x25, 0x64, 0xe6, 0x97, 0xa5, 0x20, 0x25, 0x48, 
	0xe6, 0x97, 0xb6, 0x25, 0x4d, 0xe5, 0x88, 0x86, 
	0x25, 0x53, 0xe7, 0xa7, 0x92, 0x20, 0x25, 0x5a, 
	   0, 0x25, 0x48, 0xe6, 0x97, 0xb6, 0x25, 0x4d, 
	0xe5, 0x88, 0x86, 0x25, 0x53, 0xe7, 0xa7, 0x92, 
	0x20, 0x25, 0x5a,    0, 0xe9, 0x80, 0xb1, 0xe6, 
	0x97, 0xa5,    0, 0xe9, 0x80, 0xb1, 0xe4, 0xb8, 
	0x80,    0, 0xe9, 0x80, 0xb1, 0xe4, 0xba, 0x8c, 
	   0, 0xe9, 0x80, 0xb1, 0xe4, 0xb8, 0x89,    0, 
	0xe9, 0x80, 0xb1, 0xe5, 0x9b, 0x9b,    0, 0xe9, 
	0x80, 0xb1, 0xe4, 0xba, 0x94,    0, 0xe9, 0x80, 
	0xb1, 0xe5, 0x85, 0xad,    0, 0xe8, 0xa5, 0xbf, 
	0xe5, 0x85, 0x83, 0x25, 0x59, 0xe5, 0xb9, 0xb4, 
	0x25, 0x6d, 0xe6, 0x9c, 0x88, 0x25, 0x64, 0xe6, 
	0x97, 0xa5, 0x20, 0x28, 0x25, 0x41, 0x29, 0x20, 
	0x25, 0x48, 0xe6, 0x99, 0x82, 0x25, 0x4d, 0xe5, 
	0x88, 0x86, 0x25, 0x53, 0xe7, 0xa7, 0x92,    0, 
	0xe8, 0xa5, 0xbf, 0xe5, 0x85, 0x83, 0x25, 0x59, 
	0xe5, 0xb9, 0xb4, 0x25, 0x6d, 0xe6, 0x9c, 0x88, 
	0x25, 0x64, 0xe6, 0x97, 0xa5,    0, 0x25, 0x70, 
	0x20, 0x25, 0x49, 0xe6, 0x99, 0x82, 0x25, 0x4d, 
	0xe5, 0x88, 0x86, 0x25, 0x53, 0xe7, 0xa7, 0x92, 
	   0, 
},
{	/* lc_messages_data */
	   0, 0x5e, 0x5b, 0x79, 0x59, 0x5d,    0, 0x5e, 
	0x5b, 0x6e, 0x4e, 0x5d,    0, 0x5b, 0x6a, 0x4a, 
	0x5d, 0x2e, 0x2a,    0, 0x5b, 0x6e, 0x4e, 0x5d, 
	0x2e, 0x2a,    0, 0x5e, 0x5b, 0x79, 0x59, 0x5d, 
	0x2e, 0x2a,    0, 0x5e, 0x5b, 0x6e, 0x4e, 0x5d, 
	0x2e, 0x2a,    0, 0x5e, 0x5b, 0xe6, 0x5d, 0x2e, 
	0x2a,    0, 0x5e, 0x5b, 0xe4, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0xd9, 0x86, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0xd9, 0x84, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0xd9, 0x86, 0x5d,    0, 0x5e, 
	0x5b, 0xd9, 0x84, 0x5d,    0, 0xd9, 0x86, 0xd8, 
	0xb9, 0xd9, 0x85,    0, 0xd9, 0x84, 0xd8, 0xa7, 
	   0, 0x5e, 0x28, 0xe6, 0x7c, 0xe6, 0xd9, 0xe5, 
	0x29,    0, 0x5e, 0x28, 0xe4, 0x7c, 0xe4, 0xc7, 
	0x29,    0, 0xe6, 0xd9, 0xe5,    0, 0xe4, 0xc7, 
	   0, 0x5e, 0x28, 0xd9, 0x86, 0x7c, 0xd9, 0x86, 
	0xd8, 0xb9, 0xd9, 0x85, 0x29,    0, 0x5e, 0x28, 
	0xd9, 0x84, 0x7c, 0xd9, 0x84, 0xd8, 0xa7, 0x29, 
	   0, 0x5e, 0x5b, 0x42, 0x62, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x59, 0x79, 0x4e, 0x6e, 0x5d, 
	0x2e, 0x2a,    0, 0x79, 0x6f, 0x78,    0, 0x62, 
	0xc9, 0x99, 0x6c, 0x69,    0, 0x5e, 0x5b, 0xc4, 
	0xe4, 0x59, 0x79, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0xcd, 0xed, 0x4e, 0x6e, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0xd0, 0x94, 0xd0, 0xb4, 0x59, 
	0x79, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0xd0, 
	0x9d, 0xd0, 0xbd, 0x4e, 0x6e, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x2b, 0x31, 0xc4, 0xe4, 0x44, 
	0x64, 0x59, 0x79, 0x4f, 0x6f, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x2d, 0x30, 0xcd, 0xed, 0x4e, 
	0x6e, 0x4b, 0x6b, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0x2b, 0x31, 0xd0, 0x94, 0xd0, 0xb4, 0x44, 
	0x64, 0x59, 0x79, 0x4f, 0x6f, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x2d, 0x30, 0xd0, 0x9d, 0xd0, 
	0xbd, 0x4e, 0x6e, 0x4b, 0x6b, 0x5d, 0x2e, 0x2a, 
	   0, 0x5b, 0x79, 0x59, 0x73, 0x53, 0xd5, 0xa1, 
	0xd4, 0xb1, 0x5d, 0x2e, 0x2a,    0, 0x5b, 0x6e, 
	0x4e, 0xd5, 0xb8, 0xd5, 0x88, 0x5d, 0x2e, 0x2a, 
	   0, 0xd5, 0xa1, 0xd5, 0xb5, 0xd5, 0xb8,    0, 
	0xd5, 0xb8, 0xd5, 0xb9,    0, 0x5e, 0x5b, 0xe0, 
	0xa6, 0xb9, 0xe0, 0xa7, 0x8d, 0xe0, 0xa6, 0xaf, 
	0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 0x81, 0x5d,    0, 
	0x5e, 0x5b, 0xe0, 0xa6, 0xa8, 0xe0, 0xa6, 0xbe, 
	0x5d,    0, 0xe0, 0xa6, 0xb9, 0xe0, 0xa7, 0x8d, 
	0xe0, 0xa6, 0xaf, 0xe0, 0xa6, 0xbe, 0xe0, 0xa6, 
	0x81,    0, 0xe0, 0xa6, 0xa8, 0xe0, 0xa6, 0xbe, 
	   0, 0x5b, 0x6f, 0x4f, 0x79, 0x59, 0x5d, 0x2e, 
	0x2a,    0, 0x5e, 0x5b, 0x64, 0x44, 0x79, 0x59, 
	0x5d, 0x2a, 0x2e,    0, 0x5e, 0x5b, 0x6e, 0x4e, 
	0x5d, 0x2a, 0x2e,    0, 0x5b, 0x73, 0x53, 0x79, 
	0x59, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0x61, 
	0x41, 0x79, 0x59, 0x5d, 0x2e, 0x2a,    0, 0x61, 
	0x6e, 0x6f,    0, 0x6e, 0x65,    0, 0x5b, 0x69, 
	0x49, 0x74, 0x54, 0x79, 0x59, 0x5d, 0x2e, 0x2a, 
	   0, 0x69, 0x65,    0, 0x6e, 0x61,    0, 0x5e, 
	0x5b, 0x31, 0x4a, 0x6a, 0x59, 0x79, 0x5d, 0x2e, 
	0x2a,    0, 0x5e, 0x5b, 0x30, 0x4e, 0x6e, 0x5d, 
	0x2e, 0x2a,    0, 0x5e, 0x5b, 0x6a, 0x4a, 0x79, 
	0x59, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0xed, 
	0xcd, 0x79, 0x59, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0xef, 0xcf, 0x6e, 0x4e, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0xce, 0xbd, 0xce, 0x9d, 0x79, 
	0x59, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0xce, 
	0xbf, 0xce, 0x9f, 0x6e, 0x4e, 0x5d, 0x2e, 0x2a, 
	   0, 0x5b, 0x79, 0x59, 0x5d, 0x2e, 0x2a,    0, 
	0x5e, 0x5b, 0x79, 0x59, 0x6f, 0x4f, 0x5d, 0x2e, 
	0x2a,    0, 0x5e, 0x5b, 0x31, 0x4a, 0x6a, 0x73, 
	0x53, 0x79, 0x59, 0x6f, 0x4f, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x30, 0x6e, 0x4e, 0x5d, 0x2e, 
	0x2a,    0, 0x59, 0x65, 0x73,    0, 0x4e, 0x6f, 
	   0, 0x5e, 0x5b, 0x4a, 0x6a, 0x59, 0x79, 0x5d, 
	0x2e, 0x2a,    0, 0x5e, 0x5b, 0x73, 0x53, 0x79, 
	0x59, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0x45, 
	0x65, 0x4e, 0x6e, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0x62, 0x42, 0x73, 0x53, 0x79, 0x59, 0x5d, 
	0x2e, 0x2a,    0, 0x5e, 0x5b, 0x65, 0x45, 0x6e, 
	0x4e, 0x5d, 0x2e, 0x2a,    0, 0x5b, 0x79, 0x59, 
	0xd8, 0xa8, 0x66, 0x5d, 0x2e, 0x2a,    0, 0x5b, 
	0x6e, 0x4e, 0xd8, 0xae, 0xd9, 0x86, 0x6f, 0x5d, 
	0x2e, 0x2a,    0, 0x5e, 0x5b, 0x4b, 0x6b, 0x4a, 
	0x6a, 0x59, 0x79, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0x4e, 0x6e, 0x45, 0x65, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x4e, 0x6e, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x6f, 0x4f, 0x6a, 0x4a, 0x79, 
	0x59, 0x31, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 
	0x6e, 0x4e, 0x30, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0x6f, 0x4f, 0x79, 0x59, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x4f, 0x6f, 0x6a, 0x4a, 0x73, 
	0x53, 0x79, 0x59, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0x74, 0x54, 0x79, 0x59, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x59, 0x79, 0xeb, 0x5d, 0x2e, 
	0x2a,    0, 0x5e, 0x5b, 0x4e, 0x6e, 0xec, 0x5d, 
	0x2e, 0x2a,    0, 0x5e, 0x5b, 0x59, 0x79, 0xd7, 
	0x9b, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0x4e, 
	0x6e, 0xd7, 0x9c, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0x64, 0x44, 0x79, 0x59, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x49, 0x69, 0x59, 0x79, 0x5d, 
	0x2e, 0x2a,    0, 0x5b, 0x79, 0x59, 0x73, 0x53, 
	0xb3, 0xb2, 0x5d, 0x2e, 0x2a,    0, 0x5b, 0x6e, 
	0x4e, 0xe1, 0xe0, 0x5d, 0x2e, 0x2a,    0, 0xb3, 
	0xdb, 0xe1,    0, 0xe1, 0xe3,    0, 0x5b, 0x74, 
	0x54, 0x6e, 0x4e, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0x73, 0x53, 0x6a, 0x4a, 0x6f, 0x4f, 0x79, 
	0x59, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x28, 0x5b, 
	0x79, 0x59, 0xef, 0xbd, 0x99, 0xef, 0xbc, 0xb9, 
	0x5d, 0x7c, 0xe3, 0x81, 0xaf, 0xe3, 0x81, 0x84, 
	0x7c, 0xe3, 0x83, 0x8f, 0xe3, 0x82, 0xa4, 0x29, 
	   0, 0x5e, 0x28, 0x5b, 0x6e, 0x4e, 0xef, 0xbd, 
	0x8e, 0xef, 0xbc, 0xae, 0x5d, 0x7c, 0xe3, 0x81, 
	0x84, 0xe3, 0x81, 0x84, 0xe3, 0x81, 0x88, 0x7c, 
	0xe3, 0x82, 0xa4, 0xe3, 0x82, 0xa4, 0xe3, 0x82, 
	0xa8, 0x29,    0, 0xe3, 0x81, 0xaf, 0xe3, 0x81, 
	0x84,    0, 0xe3, 0x81, 0x84, 0xe3, 0x81, 0x84, 
	0xe3, 0x81, 0x88,    0, 0x5b, 0x31, 0x79, 0x59, 
	0x6b, 0x4b, 0x78, 0x58, 0xe1, 0x5d, 0x2e, 0x2a, 
	   0, 0x5b, 0x30, 0x6e, 0x4e, 0x61, 0x41, 0xc0, 
	0x5d, 0x2e, 0x2a,    0, 0x5b, 0x31, 0x79, 0x59, 
	0x6b, 0x4b, 0x78, 0x58, 0xe1, 0x83, 0xae, 0x5d, 
	0x2e, 0x2a,    0, 0x5b, 0x30, 0x6e, 0x4e, 0x61, 
	0x41, 0xe1, 0x83, 0x90, 0x5d, 0x2e, 0x2a,    0, 
	0x5e, 0x5b, 0x4a, 0x6a, 0x59, 0x79, 0x41, 0x61, 
	0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0x79, 0x59, 
	0xec, 0x98, 0x88, 0x5d,    0, 0x5e, 0x5b, 0x6e, 
	0x4e, 0xec, 0x95, 0x84, 0xeb, 0x8b, 0x88, 0xec, 
	0x98, 0xa4, 0x5d,    0, 0x5b, 0x65, 0x45, 0x5d, 
	0x2e, 0x2a,    0, 0x5e, 0x5b, 0x54, 0x74, 0x59, 
	0x79, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0x31, 
	0x79, 0x59, 0xe2, 0xc2, 0xe4, 0xc4, 0x61, 0x41, 
	0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0x30, 0x6e, 
	0x4e, 0x6b, 0x4b, 0x5d, 0x2e, 0x2a,    0, 0xe2, 
	0x65,    0, 0x6b, 0xe2, 0x6f, 0x72, 0x65,    0, 
	0x5e, 0x5b, 0x31, 0x79, 0x59, 0xc4, 0x81, 0xc4, 
	0x80, 0xc3, 0xa4, 0xc3, 0x84, 0x61, 0x41, 0x5d, 
	0x2e, 0x2a,    0, 0xc4, 0x81, 0x65,    0, 0x6b, 
	0xc4, 0x81, 0x6f, 0x72, 0x65,    0, 0x5b, 0xb4, 
	0xd4, 0x44, 0x64, 0x59, 0x79, 0x31, 0x5d, 0x2e, 
	0x2a,    0, 0x5b, 0xbd, 0xdd, 0x4e, 0x6e, 0x30, 
	0x5d, 0x2e, 0x2a,    0, 0xd4, 0xd0,    0, 0xdd, 
	0xd5,    0, 0x5b, 0xd0, 0x94, 0xd0, 0xb4, 0x44, 
	0x64, 0x59, 0x79, 0x31, 0x5d, 0x2e, 0x2a,    0, 
	0x5b, 0xd0, 0x9d, 0xd0, 0xbd, 0x4e, 0x6e, 0x30, 
	0x5d, 0x2e, 0x2a,    0, 0xd0, 0xb4, 0xd0, 0xb0, 
	   0, 0xd0, 0xbd, 0xd0, 0xb5,    0, 0x5e, 0x28, 
	0x59, 0x65, 0x73, 0x7c, 0x5b, 0x79, 0x59, 0x5d, 
	0x29,    0, 0x5e, 0x28, 0x4e, 0x6f, 0x7c, 0x5b, 
	0x6e, 0x4e, 0x5d, 0x29,    0, 0x5e, 0x5b, 0x74, 
	0x54, 0x5d,    0, 0x59, 0x61,    0, 0x54, 0x69, 
	0x64, 0x61, 0x6b,    0, 0x5b, 0x6f, 0x4f, 0x73, 
	0x53, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0x53, 
	0x73, 0x79, 0x59, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0x44, 0x64, 0x59, 0x79, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0xe4, 0xc4, 0x59, 0x79, 0x5d, 
	0x2e, 0x2a,    0, 0x5e, 0x5b, 0xee, 0xce, 0x4e, 
	0x6e, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0xb4, 
	0xd4, 0x59, 0x79, 0x5d, 0x2e, 0x2a,    0, 0x5e, 
	0x5b, 0xbd, 0xdd, 0x4e, 0x6e, 0x5d, 0x2e, 0x2a, 
	   0, 0x5b, 0xe4, 0xc4, 0x59, 0x79, 0x5d, 0x2e, 
	0x2a,    0, 0x5b, 0xee, 0xce, 0x4e, 0x6e, 0x5d, 
	0x2e, 0x2a,    0, 0x5b, 0xd0, 0x94, 0xd0, 0xb4, 
	0x59, 0x79, 0x5d, 0x2e, 0x2a,    0, 0x5b, 0xd0, 
	0x9d, 0xd0, 0xbd, 0x4e, 0x6e, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x49, 0x69, 0x5d, 0x2e, 0x2a, 
	   0, 0x5b, 0x61, 0x41, 0xe1, 0xc1, 0x79, 0x59, 
	0x5d, 0x2e, 0x2a,    0, 0xe1, 0x6e, 0x6f,    0, 
	0x6e, 0x69, 0x65,    0, 0x5b, 0x61, 0x41, 0xc3, 
	0xa1, 0xc3, 0x81, 0x79, 0x59, 0x5d, 0x2e, 0x2a, 
	   0, 0xc3, 0xa1, 0x6e, 0x6f,    0, 0x5e, 0x5b, 
	0x59, 0x79, 0x4a, 0x6a, 0x5d, 0x2e, 0x2a,    0, 
	0x5b, 0x64, 0x44, 0x79, 0x59, 0x31, 0x5d, 0x2e, 
	0x2a,    0, 0x5b, 0x6e, 0x4e, 0x30, 0x5d, 0x2e, 
	0x2a,    0, 0x5b, 0xb4, 0xd4, 0x59, 0x79, 0x5d, 
	0x2e, 0x2a,    0, 0x5b, 0xbd, 0xdd, 0x4e, 0x6e, 
	0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0xe0, 0xae, 
	0x86, 0xe0, 0xae, 0xae, 0xe0, 0xaf, 0x8d, 0x5d, 
	   0, 0x5e, 0x5b, 0xe0, 0xae, 0x87, 0xe0, 0xae, 
	0xb2, 0xe0, 0xaf, 0x8d, 0xe0, 0xae, 0xb2, 0xe0, 
	0xaf, 0x88, 0x5d,    0, 0xe0, 0xae, 0x86, 0xe0, 
	0xae, 0xae, 0xe0, 0xaf, 0x8d,    0, 0xe0, 0xae, 
	0x87, 0xe0, 0xae, 0xb2, 0xe0, 0xaf, 0x8d, 0xe0, 
	0xae, 0xb2, 0xe0, 0xaf, 0x88,    0, 0x5e, 0x5b, 
	0xe0, 0xb0, 0x85, 0x5d,    0, 0x5e, 0x5b, 0xe0, 
	0xb0, 0x95, 0x5d,    0, 0xe0, 0xb0, 0x85, 0xe0, 
	0xb0, 0xb5, 0xe0, 0xb0, 0xa8, 0xe0, 0xb1, 0x81, 
	   0, 0xe0, 0xb0, 0x95, 0xe0, 0xb0, 0xbe, 0xe0, 
	0xb0, 0xa6, 0xe0, 0xb1, 0x81,    0, 0xc4, 0xc1, 
	   0, 0xce, 0xc5, 0xd4,    0, 0xd0, 0xbd, 0xd0, 
	0xb5, 0xd1, 0x82,    0, 0x5e, 0x5b, 0x79, 0x59, 
	0xaa, 0x5d,    0, 0x5e, 0x5b, 0x6e, 0x4e, 0xc1, 
	0x5d,    0, 0xe3, 0xaa, 0xe8,    0, 0xe4, 0xc1, 
	0xe8, 0xe3, 0xaa, 0xe8,    0, 0x5e, 0x5b, 0x79, 
	0x59, 0xe0, 0xb8, 0x8a, 0x5d,    0, 0x5e, 0x5b, 
	0x6e, 0x4e, 0xe0, 0xb8, 0xa1, 0x5d,    0, 0xe0, 
	0xb9, 0x83, 0xe0, 0xb8, 0x8a, 0xe0, 0xb9, 0x88, 
	   0, 0xe0, 0xb9, 0x84, 0xe0, 0xb8, 0xa1, 0xe0, 
	0xb9, 0x88, 0xe0, 0xb9, 0x83, 0xe0, 0xb8, 0x8a, 
	0xe0, 0xb9, 0x88,    0, 0x5e, 0x5b, 0x65, 0x45, 
	0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0x68, 0x48, 
	0x5d, 0x2e, 0x2a,    0, 0x65, 0x76, 0x65, 0x74, 
	   0, 0x68, 0x61, 0x79, 0xfd, 0x72,    0, 0x68, 
	0x61, 0x79, 0xc4, 0xb1, 0x72,    0, 0xd3, 0x98, 
	0xd0, 0xb9, 0xd0, 0xb5,    0, 0xd0, 0xae, 0xd0, 
	0xba,    0, 0x5b, 0xf4, 0xd4, 0x59, 0x79, 0x5d, 
	0x2e, 0x2a,    0, 0x5b, 0xd0, 0xa2, 0xd1, 0x82, 
	0x59, 0x79, 0x5d, 0x2e, 0x2a,    0, 0x5b, 0x79, 
	0x59, 0xd9, 0x87, 0xd8, 0xa8, 0x66, 0x5d, 0x2e, 
	0x2a,    0, 0x5b, 0x6e, 0x4e, 0xd9, 0x86, 0x6f, 
	0x5d, 0x2e, 0x2a,    0, 0xd8, 0xa8, 0xd9, 0x84, 
	0xd9, 0x83, 0xd9, 0x84,    0, 0xd9, 0x86, 0xd9, 
	0x87, 0xd9, 0x8a, 0xda, 0xba,    0, 0x5e, 0x5b, 
	0x59, 0x79, 0x48, 0x68, 0x5d, 0x2e, 0x2a,    0, 
	0x5e, 0x5b, 0x4a, 0x6a, 0x4e, 0x6e, 0x5d, 0x2e, 
	0x2a,    0, 0x48, 0x61,    0, 0x59, 0x6f, 0x27, 
	0x71,    0, 0x5b, 0x6f, 0x4f, 0x79, 0x59, 0x61, 
	0x41, 0x77, 0x57, 0x5d, 0x2e, 0x2a,    0, 0x4f, 
	0x79, 0x69,    0, 0x4e, 0x65, 0x6e, 0x69,    0, 
	0x5e, 0x5b, 0x59, 0x79, 0xe9, 0x5d, 0x2e, 0x2a, 
	   0, 0x5e, 0x5b, 0x4e, 0x6e, 0xf0, 0xf7, 0x5d, 
	0x2e, 0x2a,    0, 0xe9, 0xe0, 0xc7,    0, 0xf7, 
	0xd6, 0xef,    0, 0x5e, 0x5b, 0x59, 0x79, 0xd7, 
	0x99, 0x5d, 0x2e, 0x2a,    0, 0x5e, 0x5b, 0x4e, 
	0x6e, 0xd7, 0xa0, 0xd7, 0xa7, 0x5d, 0x2e, 0x2a, 
	   0, 0xd7, 0x99, 0xd7, 0x90, 0xd6, 0xb7,    0, 
	0xd7, 0xa7, 0xd7, 0xb2, 0xd7, 0x9f,    0, 0x5e, 
	0x5b, 0x79, 0x59, 0xe6, 0x98, 0xaf, 0x5d,    0, 
	0x5e, 0x5b, 0x6e, 0x4e, 0xe4, 0xb8, 0x8d, 0xe5, 
	0x90, 0xa6, 0x5d,    0, 
},
{ /* codeset_8_bit array */
{ /* codeset_8_bit[0] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x01, 0x02, 0x03, 0x04, 
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x01, 0x02, 0x03, 0x04, 
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 
},
{	/* idx8wc2c */
	   0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[1] */
{	/* idx8ctype */
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
},
{	/* idx8uplow */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
},
{	/* idx8c2wc */
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
},
{	/* idx8wc2c */
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[2] */
{	/* idx8ctype */
	0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 
	0x0f, 0x0f, 0x0f, 0x0f, 0x10, 0x10, 0x10, 0x10, 
},
{	/* idx8uplow */
	0x06, 0x07, 0x08, 0x07, 0x09, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 
},
{	/* idx8c2wc */
	0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 
	0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 
},
{	/* idx8wc2c */
	0x04, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x06, 0x07, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[3] */
{	/* idx8ctype */
	0x11, 0x12, 0x13, 0x12, 0x02, 0x02, 0x14, 0x02, 
	0x02, 0x15, 0x16, 0x17, 0x18, 0x18, 0x18, 0x19, 
},
{	/* idx8uplow */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
},
{	/* idx8c2wc */
	0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 
	0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 
},
{	/* idx8wc2c */
	0x08, 0x09, 0x0a, 0x01, 0x01, 0x0b, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x0c, 0x0d, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[4] */
{	/* idx8ctype */
	0x1a, 0x1b, 0x1c, 0x1d, 0x02, 0x1e, 0x14, 0x1e, 
	0x18, 0x18, 0x18, 0x18, 0x1f, 0x10, 0x20, 0x10, 
},
{	/* idx8uplow */
	   0, 0x0e,    0, 0x0f,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0, 0x10, 
},
{	/* idx8c2wc */
	0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x27, 0x37, 
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
},
{	/* idx8wc2c */
	0x0e, 0x0f, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x11, 0x0d, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[5] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x02, 0x1e, 0x14, 0x1e, 
	0x0f, 0x0f, 0x21, 0x22, 0x10, 0x10, 0x20, 0x10, 
},
{	/* idx8uplow */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x0d, 0x0d, 0x11, 0x11, 0x0d, 0x0d, 0x11, 0x11, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x35, 0x36, 0x27, 0x37, 
	0x40, 0x41, 0x42, 0x43, 0x44, 0x3d, 0x3e, 0x3f, 
},
{	/* idx8wc2c */
	0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[6] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x23, 0x24, 0x25, 0x26, 
	0x0f, 0x0f, 0x0f, 0x22, 0x10, 0x10, 0x10, 0x27, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x12, 0x13, 0x12, 0x13, 
	0x0d, 0x0d, 0x0d, 0x11, 0x0d, 0x0d, 0x0d, 0x11, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x45, 0x46, 0x47, 0x48, 
	0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 
},
{	/* idx8wc2c */
	0x13, 0x14, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[7] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x02, 0x0c, 0x14, 0x28, 
	0x0f, 0x0f, 0x21, 0x22, 0x10, 0x10, 0x20, 0x20, 
},
{	/* idx8uplow */
	   0,    0,    0,    0,    0, 0x0a,    0, 0x0a, 
	0x0d, 0x0d, 0x11, 0x11, 0x0d, 0x0d, 0x11, 0x11, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x51, 0x52, 0x53, 0x54, 
	0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 
},
{	/* idx8wc2c */
	0x16, 0x17, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x18, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[8] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x29, 0x2a, 0x2b, 0x2c, 
	0x0f, 0x0f, 0x0f, 0x22, 0x10, 0x10, 0x10, 0x10, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x14, 0x15, 0x16, 0x17, 
	0x0d, 0x0d, 0x0d, 0x11, 0x0d, 0x0d, 0x0d, 0x18, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x5d, 0x5e, 0x5f, 0x60, 
	0x40, 0x41, 0x61, 0x62, 0x44, 0x3d, 0x63, 0x64, 
},
{	/* idx8wc2c */
	0x19, 0x1a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1b, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[9] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x2d, 0x2e, 0x2f, 0x30, 
	0x0f, 0x0f, 0x21, 0x22, 0x10, 0x10, 0x20, 0x10, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x19, 0x1a, 0x1b, 0x1c, 
	0x0d, 0x0d, 0x11, 0x11, 0x0d, 0x0d, 0x11, 0x1d, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x65, 0x66, 0x67, 0x68, 
	0x40, 0x41, 0x42, 0x43, 0x44, 0x3d, 0x3e, 0x3f, 
},
{	/* idx8wc2c */
	0x1c, 0x1d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x1e, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[10] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x31, 0x32, 0x33, 0x34, 
	0x0f, 0x0f, 0x0f, 0x22, 0x10, 0x10, 0x10, 0x10, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x1e, 0x1f, 0x20, 0x21, 
	0x0d, 0x0d, 0x0d, 0x11, 0x0d, 0x0d, 0x0d, 0x1d, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x69, 0x6a, 0x6b, 0x6c, 
	0x6d, 0x41, 0x6e, 0x6f, 0x70, 0x3d, 0x71, 0x72, 
},
{	/* idx8wc2c */
	0x1f, 0x20, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[11] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x35, 0x36, 0x37, 0x38, 
	0x0f, 0x0f, 0x21, 0x22, 0x10, 0x10, 0x20, 0x20, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x22, 0x23, 0x22, 0x23, 
	0x0d, 0x0d, 0x11, 0x11, 0x0d, 0x0d, 0x11, 0x11, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x73, 0x74, 0x75, 0x76, 
	0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 
},
{	/* idx8wc2c */
	0x23, 0x24, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[12] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x39, 0x3a, 0x3b, 0x3c, 
	0x3d, 0x0f, 0x3e, 0x22, 0x3f, 0x10, 0x40, 0x20, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x24, 0x25, 0x24, 0x26, 
	0x27, 0x0d, 0x28, 0x11, 0x27, 0x0d, 0x28, 0x11, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x7f, 0x80, 0x81, 0x82, 
	0x83, 0x41, 0x84, 0x85, 0x86, 0x3d, 0x87, 0x88, 
},
{	/* idx8wc2c */
	0x26, 0x27, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[13] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x41, 0x42, 0x37, 0x43, 
	0x0f, 0x0f, 0x21, 0x22, 0x10, 0x10, 0x20, 0x20, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x22, 0x29, 0x22, 0x2a, 
	0x0d, 0x0d, 0x11, 0x11, 0x0d, 0x0d, 0x11, 0x11, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x89, 0x8a, 0x8b, 0x8c, 
	0x49, 0x8d, 0x8e, 0x8f, 0x4d, 0x90, 0x91, 0x92, 
},
{	/* idx8wc2c */
	0x29, 0x2a, 0x2b, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[14] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x44, 0x24, 0x0f, 0x0f, 
	0x0f, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x45, 0x26, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x2b, 0x2c, 0x0d, 0x0d, 
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x2b, 0x2c, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x93, 0x94, 0x19, 0x1a, 
	0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x95, 0x96, 
},
{	/* idx8wc2c */
	0x2c, 0x01, 0x01, 0x01, 0x2d, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x2e, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[15] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x46, 0x47, 0x06, 0x48, 
	0x49, 0x18, 0x18, 0x4a, 0x18, 0x4b, 0x4c, 0x06, 
},
{	/* idx8uplow */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x97, 0x98, 0x10, 0x99, 
	0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f, 0xa0, 0x10, 
},
{	/* idx8wc2c */
	0x2f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[16] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x4d, 0x4e, 0x2d, 0x4f, 
	0x50, 0x0f, 0x51, 0x52, 0x53, 0x10, 0x10, 0x54, 
},
{	/* idx8uplow */
	   0,    0,    0,    0,    0,    0, 0x2d, 0x2e, 
	0x2f, 0x0d, 0x30, 0x31, 0x2f, 0x0d, 0x32, 0x33, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0xa1, 0xa2, 0xa3, 0xa4, 
	0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 
},
{	/* idx8wc2c */
	0x31, 0x01, 0x01, 0x32, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x33, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[17] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x55, 0x02, 0x14, 0x56, 
	0x06, 0x06, 0x06, 0x57, 0x18, 0x18, 0x18, 0x19, 
},
{	/* idx8uplow */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0xad, 0x26, 0x27, 0xae, 
	0x10, 0x10, 0x10, 0xaf, 0x2d, 0x2e, 0x2f, 0x30, 
},
{	/* idx8wc2c */
	0x34, 0x01, 0x01, 0x01, 0x01, 0x35, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x36, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[18] */
{	/* idx8ctype */
	   0,    0,    0,    0, 0x02, 0x1e, 0x14, 0x1e, 
	0x0f, 0x0f, 0x21, 0x22, 0x10, 0x10, 0x20, 0x10, 
},
{	/* idx8uplow */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x0d, 0x0d, 0x11, 0x34, 0x0d, 0x0d, 0x11, 0x35, 
},
{	/* idx8c2wc */
	   0, 0x01, 0x02, 0x03, 0x35, 0x36, 0x27, 0x37, 
	0x40, 0x41, 0xb0, 0xb1, 0x44, 0x3d, 0xb2, 0xb3, 
},
{	/* idx8wc2c */
	0x37, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[19] */
{	/* idx8ctype */
	0x02, 0x02, 0x02, 0x02, 0x58, 0x02, 0x59, 0x02, 
	0x10, 0x10, 0x10, 0x10, 0x0f, 0x0f, 0x0f, 0x0f, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x36,    0, 0x36,    0, 
	0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
},
{	/* idx8c2wc */
	0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 
	0xbc, 0xbd, 0xbe, 0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 
},
{	/* idx8wc2c */
	0x39, 0x01, 0x01, 0x01, 0x3a, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x3b, 0x3c, 0x01, 0x3d, 
},
},
{ /* codeset_8_bit[20] */
{	/* idx8ctype */
	0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 
	0x10, 0x10, 0x10, 0x10, 0x0f, 0x0f, 0x0f, 0x0f, 
},
{	/* idx8uplow */
	0x38, 0x39, 0x3a,    0, 0x3b,    0, 0x3c,    0, 
	0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
},
{	/* idx8c2wc */
	0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 
	0xbc, 0xbd, 0xbe, 0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 
},
{	/* idx8wc2c */
	0x3e, 0x01, 0x01, 0x01, 0x3f, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x11, 0x07, 0x01, 0x01, 0x01, 0x01, 
},
},
{ /* codeset_8_bit[21] */
{	/* idx8ctype */
	0x02, 0x02, 0x02, 0x02, 0x62, 0x14, 0x63, 0x64, 
	0x10, 0x10, 0x10, 0x10, 0x0f, 0x0f, 0x0f, 0x0f, 
},
{	/* idx8uplow */
	   0,    0,    0,    0, 0x3d, 0x3e, 0x3d, 0x3e, 
	0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
},
{	/* idx8c2wc */
	0xb4, 0xb5, 0xb6, 0xb7, 0xcc, 0xcd, 0xce, 0xcf, 
	0xbc, 0xbd, 0xbe, 0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 
},
{	/* idx8wc2c */
	0x39, 0x01, 0x01, 0x01, 0x40, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x3b, 0x3c, 0x01, 0x41, 
},
},
{ /* codeset_8_bit[22] */
{	/* idx8ctype */
	0x06, 0x06, 0x06, 0x06, 0x49, 0x18, 0x18, 0x18, 
	0x18, 0x65, 0x18, 0x66, 0x67, 0x65, 0x18, 0x68, 
},
{	/* idx8uplow */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
},
{	/* idx8c2wc */
	0x10, 0x10, 0x10, 0x10, 0xd0, 0xd1, 0xd2, 0xd3, 
	0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 
},
{	/* idx8wc2c */
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
},
},
},
{	/* lc_ctype_rows */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
},
{	/* lc_ctype_item_offsets */
	     0, 0x0002, 0x0004, 0x0006, 0x0008, 0x000a, 0x000c, 0x000e, 
	0x0010, 0x0012, 
},
{	/* lc_ctype_item_idx */
	0x0001, 0x0015, 0x0003, 0x0018, 0x0005, 0x001b, 0x0007, 0x001e, 
	0x0009, 0x0021, 0x000b, 0x0024, 0x000d, 0x0027, 0x000f, 0x002a, 
	0x0011, 0x002d, 0x0013, 0x0030, 
},
{	/* lc_numeric_rows */
	   0,    0,    0, 0x01, 0x01, 0x01,    0, 0x02, 
	0x01,    0, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	   0,    0, 0x01, 0x03, 0x01, 0x01, 0x04, 0x01, 
	   0, 0x05, 0x01, 0x01, 0x01,    0, 0x02, 0x06, 
	0x01, 0x01, 0x05,    0, 0x01, 0x07, 0x01, 0x01, 
	0x05, 0x01,    0, 0x02, 0x03, 
},
{	/* lc_numeric_item_offsets */
	     0, 0x0003, 0x000b, 
},
{	/* lc_numeric_item_idx */
	0x0001, 0x0003, 0x0011,      0, 0x0001, 0x0003, 0x000a, 0x000c, 
	0x000f, 0x0014, 0x0017,      0, 0x0005, 0x0007, 0x0019, 
},
{	/* lc_monetary_rows */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x02, 0x03, 0x03, 0x02, 0x02, 0x01,    0, 
	0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x03, 
	0x03, 0x04, 0x02, 0x02, 0x01,    0, 0x01, 0x02, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x04, 0x04, 0x05, 
	0x02, 0x02, 0x01,    0, 0x01, 0x02, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x05, 0x04, 0x06, 0x02, 0x02, 
	0x01,    0, 0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x06, 0x05, 0x07, 0x02, 0x02, 0x01,    0, 
	0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x07, 
	0x05, 0x08, 0x02, 0x02, 0x01,    0, 0x01, 0x02, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x08, 0x06, 0x09, 
	0x02, 0x02, 0x01,    0, 0x01, 0x02, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x09, 0x06, 0x0a, 0x02, 0x02, 
	0x01,    0, 0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x0a, 0x07, 0x0b, 0x02, 0x02, 0x02,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x0b, 
	0x08, 0x0c, 0x02, 0x02, 0x01,    0, 0x01, 0x02, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x0c, 0x08, 0x0d, 
	0x02, 0x02, 0x01,    0, 0x01, 0x02, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x0d, 0x09, 0x0e, 0x02, 0x02, 
	0x01,    0, 0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x0e, 0x09, 0x0f, 0x02, 0x02, 0x01,    0, 
	0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x0f, 
	0x0a, 0x10, 0x02, 0x02, 0x01,    0, 0x01, 0x02, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x10, 0x0a, 0x11, 
	0x02, 0x02, 0x01,    0, 0x01, 0x02, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x11, 0x0b, 0x12, 0x02, 0x02, 
	0x01,    0, 0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x12, 0x0b, 0x13, 0x02, 0x02, 0x01,    0, 
	0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x13, 
	0x0c, 0x14, 0x02, 0x02, 0x01,    0, 0x01, 0x02, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x14, 0x0c, 0x15, 
	0x02, 0x02, 0x01,    0, 0x01, 0x02, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x15, 0x0d, 0x16, 0x02, 0x02, 
	0x01,    0, 0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x16, 0x0d, 0x17, 0x02, 0x02, 0x01,    0, 
	0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x17, 
	0x0e, 0x18, 0x02, 0x02, 0x01,    0, 0x01, 0x02, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x18, 0x0e, 0x19, 
	0x02, 0x02, 0x01,    0, 0x01, 0x02, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x19, 0x0f, 0x1a, 0x02, 0x02, 
	0x01,    0, 0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x1a, 0x0f, 0x1b, 0x02, 0x02, 0x01,    0, 
	0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x1b, 
	0x10, 0x1c, 0x02,    0,    0,    0, 0x01, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x1c, 0x10, 0x1d, 
	0x02,    0,    0,    0, 0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x1d, 0x11, 0x1e, 0x02, 0x02, 
	0x01,    0, 0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x1e, 0x11, 0x1f, 0x02, 0x02, 0x01,    0, 
	0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x1f, 
	0x12, 0x20, 0x02, 0x02, 0x01,    0, 0x01, 0x02, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x20, 0x12, 0x21, 
	0x02, 0x02, 0x01,    0, 0x01, 0x02, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x21, 0x13, 0x22, 0x02, 0x02, 
	0x01,    0, 0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x22, 0x13, 0x23, 0x02, 0x02, 0x01,    0, 
	0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x23, 
	0x14, 0x24, 0x02, 0x02, 0x01,    0, 0x01, 0x02, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x24, 0x14, 0x25, 
	0x02, 0x02, 0x01,    0, 0x01, 0x02, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x25, 0x15, 0x26, 0x02, 0x03, 
	0x01,    0, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x26, 0x16, 0x27, 0x02, 0x03, 0x01,    0, 
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x27, 
	0x16, 0x28, 0x02, 0x03, 0x01,    0, 0x01, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x28, 0x17, 0x29, 
	0x01, 0x04, 0x01,    0, 0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x29, 0x17, 0x2a, 0x01, 0x05, 
	0x01,    0, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x2a,    0, 0x2b, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x2b, 
	0x07, 0x2c, 0x02, 0x02, 0x03,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x2c, 0x18, 0x2d, 
	0x01, 0x03, 0x01,    0, 0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x2d, 0x18, 0x2e, 0x01, 0x03, 
	0x01,    0, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x2e, 0x19, 0x2f, 0x01, 0x03, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x2f, 
	0x18, 0x2d, 0x01, 0x01, 0x03,    0, 0x01, 0x03, 
	0x03, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x30, 0x18, 0x2e, 
	0x01, 0x01, 0x03,    0, 0x01, 0x03, 0x03, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x31, 0x18, 0x30, 0x01, 0x01, 
	0x03,    0, 0x01, 0x03, 0x03, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x32, 0x1a, 0x31, 0x01, 0x04, 0x01,    0, 
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x33, 
	0x1a, 0x32, 0x01, 0x05, 0x01,    0, 0x01, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x34, 0x1b, 0x33, 
	0x02, 0x02, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x35, 0x1b, 0x34, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x36, 0x1c, 0x35, 0x01, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x03, 0x01, 0x03, 0x02, 
	0x03, 0x01, 0x03, 0x01, 0x03, 0x02, 0x03, 0x37, 
	0x18, 0x2d, 0x01, 0x03, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x30, 0x18, 0x2e, 
	0x01, 0x03, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x31, 0x18, 0x30, 0x01, 0x03, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x32, 0x18, 0x2d, 0x01, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x02, 
	0x03, 0x01, 0x02, 0x01, 0x02, 0x02, 0x03, 0x30, 
	0x18, 0x2e, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x02, 0x03, 0x01, 
	0x02, 0x01, 0x02, 0x02, 0x03, 0x31, 0x18, 0x30, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x01, 
	0x02, 0x02, 0x03, 0x32, 0x1d, 0x36, 0x02, 0x03, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x02, 0x03, 0x01, 0x02, 0x01, 0x02, 0x02, 
	0x03, 0x38, 0x18, 0x2d, 0x01, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x2d, 
	0x18, 0x2e, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x2e, 0x18, 0x30, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x39, 0x18, 0x2d, 0x01, 0x01, 
	0x01,    0, 0x01, 0x04, 0x04, 0x02, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x2d, 0x18, 0x2e, 0x01, 0x01, 0x01,    0, 
	0x01, 0x04, 0x04, 0x02, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2e, 
	0x1e, 0x02, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x1f, 0x37, 
	0x02, 0x02, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x3a, 0x20, 0x02, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x02, 0x1c, 0x30, 0x01, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 
	0x1c, 0x38, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x3b, 0x21, 0x39, 
	0x02, 0x02, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x04, 0x3c, 0x18, 0x2d, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x30, 0x18, 0x2e, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 
	0x18, 0x30, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x22, 0x02, 
	0x02, 0x02, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 0x23, 0x3a, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x04, 0x3d, 0x24, 0x02, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x02, 
	0x25, 0x02, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 
	0x02, 0x02, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x26, 0x3b, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x3e, 0x18, 0x3c, 0x01, 0x03, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x3f, 
	0x27, 0x02, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x02, 0x28, 0x3d, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x40, 0x29, 0x02, 0x01, 0x01, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x02, 0x2a, 0x02, 0x01, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x02, 
	0x2b, 0x3e, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x41, 0x2c, 0x02, 
	0x02, 0x02, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x02, 0x2d, 0x02, 0x01, 0x01, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x02, 0x18, 0x2d, 0x01, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x30, 
	0x18, 0x2e, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x31, 0x18, 0x30, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x32, 0x2e, 0x3f, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x42, 0x2f, 0x40, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x43, 
	0x30, 0x02, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x02, 0x31, 0x41, 
	0x02, 0x02, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x44, 0x32, 0x42, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x45, 0x33, 0x43, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x46, 
	0x25, 0x02, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x02, 0x34, 0x44, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x47, 0x35, 0x45, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x48, 0x35, 0x46, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x49, 
	0x36, 0x47, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x4a, 0x37, 0x48, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x4b, 0x38, 0x35, 0x01, 0x04, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x37, 0x38, 0x35, 0x01, 0x05, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x37, 
	0x18, 0x2d, 0x01, 0x01, 0x01,    0, 0x01, 0x03, 
	0x03, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x30, 0x18, 0x2e, 
	0x01, 0x01, 0x01,    0, 0x01, 0x03, 0x03, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x31, 0x18, 0x30, 0x01, 0x01, 
	0x01,    0, 0x01, 0x03, 0x03, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x32, 0x39, 0x49, 0x03, 0x06, 0x01,    0, 
	0x01, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x4c, 
	0x18, 0x2d, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x02, 0x03, 0x02, 0x03, 0x01, 0x01, 0x02, 
	0x03, 0x02, 0x03, 0x01, 0x01, 0x2d, 0x18, 0x2e, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x02, 
	0x03, 0x02, 0x03, 0x01, 0x01, 0x02, 0x03, 0x02, 
	0x03, 0x01, 0x01, 0x2e, 0x18, 0x30, 0x01, 0x01, 
	0x01,    0, 0x01, 0x01, 0x01, 0x02, 0x03, 0x02, 
	0x03, 0x01, 0x01, 0x02, 0x03, 0x02, 0x03, 0x01, 
	0x01, 0x39, 0x20, 0x02, 0x01, 0x03, 0x01,    0, 
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x04, 0x02, 0x02, 0x02, 0x02, 0x01, 0x04, 0x4d, 
	0x18, 0x30, 0x01, 0x03, 0x01,    0, 0x01, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x39, 0x3a, 0x4a, 
	0x02, 0x02, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x03, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x03, 0x02, 0x4e, 0x3a, 0x4b, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x03, 0x02, 0x01, 0x02, 0x01, 0x02, 0x03, 
	0x02, 0x4f, 0x07, 0x4c, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x50, 
	0x3b, 0x4d, 0x01, 0x03, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x51, 0x3c, 0x4e, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x52, 0x3d, 0x4f, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x53, 0x3d, 0x50, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x54, 
	0x3e, 0x51, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x55, 0x3f, 0x35, 
	0x01, 0x01, 0x01,    0, 0x01, 0x03, 0x03, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x56, 0x40, 0x52, 0x02, 0x02, 
	0x01,    0, 0x01, 0x03, 0x03, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x03, 0x57, 0x41, 0x53, 0x01, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x58, 
	0x41, 0x54, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x59, 0x42, 0x55, 
	0x02, 0x02, 0x01,    0, 0x01, 0x03, 0x03, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x03, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x03, 0x5a, 0x43, 0x56, 0x01, 0x01, 
	0x01,    0, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x5b, 0x44, 0x57, 0x01, 0x04, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x04, 
	0x05, 0x01, 0x02, 0x01, 0x02, 0x04, 0x05, 0x5c, 
	0x44, 0x57, 0x01, 0x05, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x04, 0x05, 0x01, 
	0x02, 0x01, 0x02, 0x04, 0x05, 0x5c, 0x45, 0x58, 
	0x01, 0x03, 0x01,    0, 0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x5d, 0x45, 0x59, 0x01, 0x03, 
	0x01,    0, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x5e, 0x07, 0x5a, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x5f, 
	0x46, 0x5b, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x04, 0x60, 0x47, 0x5c, 
	0x02, 0x02, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x04, 0x61, 0x18, 0x2d, 0x01, 0x03, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x30, 0x18, 0x2e, 0x01, 0x03, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x31, 
	0x18, 0x30, 0x01, 0x03, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x02, 0x32, 0x48, 0x35, 
	0x01, 0x04, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x05, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x05, 0x37, 0x48, 0x35, 0x01, 0x05, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x05, 0x01, 0x02, 0x01, 0x01, 0x01, 
	0x05, 0x37, 0x48, 0x35, 0x01, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 
	0x03, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03, 0x37, 
	0x49, 0x5d, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x62, 0x49, 0x5e, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x63, 0x4a, 0x5f, 0x01, 0x01, 
	0x01,    0, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x64, 0x18, 0x2d, 0x04, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x2d, 
	0x18, 0x2e, 0x04, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x2e, 0x18, 0x30, 
	0x04, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x39, 0x4b, 0x60, 0x01, 0x01, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x65, 0x4c, 0x61, 0x02, 0x03, 0x01,    0, 
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x66, 
	0x4c, 0x62, 0x02, 0x03, 0x01,    0, 0x01, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x67, 0x4c, 0x28, 
	0x02, 0x03, 0x01,    0, 0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x28, 0x4d, 0x63, 0x02, 0x03, 
	0x01,    0, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x68, 0x4d, 0x64, 0x02, 0x03, 0x01,    0, 
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x69, 
	0x48, 0x65, 0x01, 0x01, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 
	0x01, 0x01, 0x01, 0x02, 0x03, 0x6a, 0x4e, 0x66, 
	0x01, 0x04, 0x01,    0, 0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x6b, 0x4e, 0x66, 0x01, 0x05, 
	0x01,    0, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x6b, 0x4f, 0x67, 0x01, 0x03, 0x01,    0, 
	0x01, 0x01, 0x01, 0x02, 0x03, 0x02, 0x03, 0x03, 
	0x02, 0x02, 0x03, 0x02, 0x03, 0x03, 0x02, 0x6c, 
	0x50, 0x68, 0x01, 0x01, 0x01,    0, 0x01, 0x02, 
	0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x6d, 0x51, 0x69, 
	0x01, 0x03, 0x01,    0, 0x01, 0x03, 0x03, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x6e, 0x51, 0x6a, 0x01, 0x03, 
	0x01,    0, 0x01, 0x03, 0x03, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x6f, 0x51, 0x6b, 0x01, 0x03, 0x01,    0, 
	0x01, 0x03, 0x03, 0x01, 0x02, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x70, 
	0x52, 0x35, 0x01, 0x03, 0x01,    0, 0x01, 0x01, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x01, 0x56, 0x07, 0x4c, 
	0x02, 0x02, 0x03,    0, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x01, 0x01, 0x50, 0x53, 0x6c, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x03, 0x01, 
	0x03, 0x02, 0x03, 0x01, 0x03, 0x01, 0x03, 0x02, 
	0x03, 0x71, 0x53, 0x6d, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x03, 0x01, 0x03, 0x02, 
	0x03, 0x01, 0x03, 0x01, 0x03, 0x02, 0x03, 0x72, 
	0x54, 0x02, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x23, 0x6e, 
	0x02, 0x02, 0x01,    0, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x01, 0x73, 0x55, 0x6f, 0x01, 0x01, 
	0x01,    0, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 
	0x01, 0x74, 0x56, 0x70, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x03, 
	0x01, 0x01, 0x02, 0x01, 0x01, 0x03, 0x01, 0x75, 
	0x57, 0x71, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x76, 0x58, 0x72, 
	0x01, 0x01, 0x01,    0, 0x01, 0x01, 0x01, 0x02, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x77, 0x25, 0x02, 0x02, 0x02, 
	0x01,    0, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x02, 0x03, 0x02, 0x01, 0x02, 0x01, 0x02, 0x03, 
	0x02, 0x02, 0x59, 0x52, 0x02, 0x02, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 
	0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 
	0x5a, 0x73, 0x02, 0x02, 0x01,    0, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x78, 
},
{	/* lc_monetary_item_offsets */
	     0, 0x005b, 0x00cf, 0x00d4, 0x00db, 0x00df, 0x00e0, 0x00e2, 
	0x00e7, 0x00ec, 0x00ef, 0x00f3, 0x00f6, 0x00fa, 0x00ff, 0x0105, 
	0x0108, 0x010c, 0x010f, 0x0113, 0x0118, 0x011e, 
},
{	/* lc_monetary_item_idx */
	     0, 0x0005, 0x0019, 0x0023, 0x0042, 0x0061, 0x0080, 0x009f, 
	0x00b0, 0x00cf, 0x00ee, 0x010d, 0x012c, 0x014b, 0x016a, 0x0189, 
	0x01a8, 0x01cb, 0x01ea, 0x0209, 0x0228, 0x0247, 0x0259, 0x0276, 
	0x02b9, 0x02d0, 0x02eb, 0x0300, 0x0311, 0x031f, 0x0330, 0x0335, 
	0x0341, 0x034d, 0x035b, 0x0360, 0x036e, 0x0373, 0x0378, 0x038a, 
	0x038f, 0x039b, 0x03a0, 0x03a5, 0x03af, 0x03b4, 0x03b9, 0x03c3, 
	0x03cf, 0x03d4, 0x03e0, 0x03ec, 0x03f8, 0x0406, 0x0417, 0x0423, 
	0x0431, 0x0436, 0x0457, 0x047d, 0x0489, 0x0495, 0x04a6, 0x04b2, 
	0x04bb, 0x04c9, 0x04dc, 0x04ea, 0x04f6, 0x0502, 0x052e, 0x053a, 
	0x0546, 0x054b, 0x0560, 0x056c, 0x057a, 0x0591, 0x05b1, 0x05bd, 
	0x05cb, 0x05d9, 0x05ff, 0x0604, 0x0617, 0x0625, 0x0631, 0x063d, 
	0x064d, 0x065b, 0x0660,      0, 0x000a, 0x001e, 0x0028, 0x0033, 
	0x0047, 0x0052, 0x0066, 0x0071, 0x0085, 0x0090, 0x00a4, 0x00b5, 
	0x00c0, 0x00d4, 0x00df, 0x00f3, 0x00fe, 0x0112, 0x011d, 0x0131, 
	0x013c, 0x0150, 0x015b, 0x016f, 0x017a, 0x018e, 0x0199, 0x01ad, 
	0x01b8, 0x01d0, 0x01db, 0x01ef, 0x01fa, 0x020e, 0x0219, 0x022d, 
	0x0238, 0x024c, 0x025e, 0x0267, 0x027b, 0x0284, 0x0292, 0x029b, 
	0x02be, 0x02c7, 0x02d5, 0x02e6, 0x02f0, 0x02f7, 0x0305, 0x030a, 
	0x0316, 0x0324, 0x033a, 0x0346, 0x0352, 0x0365, 0x037d, 0x02b9, 
	0x0394, 0x03aa, 0x03be, 0x03c8, 0x03d9, 0x03e5, 0x03f1, 0x03fd, 
	0x040b, 0x0410, 0x041c, 0x0428, 0x043b, 0x045c, 0x0463, 0x046e, 
	0x0482, 0x048e, 0x049a, 0x049f, 0x04ab, 0x04c0, 0x04ce, 0x04d3, 
	0x04e1, 0x04ef, 0x04fb, 0x0507, 0x0510, 0x051f, 0x0533, 0x053f, 
	0x0550, 0x0557, 0x0565, 0x0571, 0x057f, 0x0588, 0x0596, 0x059d, 
	0x05a8, 0x05b6, 0x05c2, 0x05d0, 0x05de, 0x05e7, 0x05f0, 0x0609, 
	0x060e, 0x061c, 0x062a, 0x0636, 0x0642, 0x0652, 0x0665,      0, 
	0x000c, 0x000e, 0x0444, 0x001e,      0, 0x000e, 0x000c, 0x0251, 
	0x027e, 0x0289, 0x0447,      0, 0x0010, 0x00a8, 0x02a8,      0, 
	     0, 0x0003, 0x0001, 0x0012, 0x0010,      0, 0x0319, 0x0001, 
	0x0012, 0x0010,      0, 0x0319, 0x0001, 0x0014,      0, 0x0001, 
	     0, 0x0014, 0x0012, 0x0001, 0x0014,      0, 0x0001,      0, 
	0x0014, 0x0012, 0x0001, 0x0014, 0x0319, 0x0012, 0x0010, 0x0001, 
	0x0014, 0x0012, 0x0319,      0, 0x0010, 0x0001, 0x0014,      0, 
	0x0001,      0, 0x0014, 0x0012, 0x0001, 0x0014,      0, 0x0001, 
	     0, 0x0014, 0x0012, 0x0001, 0x0014, 0x0319, 0x0012, 0x0010, 
	0x0001, 0x0014, 0x0012, 0x0319,      0, 0x0010, 0x0003, 0x0016, 
	0x0020, 0x002d, 0x003a, 0x004c, 0x0059, 0x006b, 0x0078, 0x008a, 
	0x0097, 0x00ab, 0x00ba, 0x00c7, 0x00d9, 0x00e6, 0x00f8, 0x0105, 
	0x0117, 0x0124, 0x0136, 0x0143, 0x0155, 0x0162, 0x0174, 0x0181, 
	0x0193, 0x01a0, 0x01b2, 0x01c1, 0x01d5, 0x01e2, 0x01f4, 0x0201, 
	0x0213, 0x0220, 0x0232, 0x023f, 0x0253, 0x0262, 0x026e, 0x0280, 
	0x028c, 0x0296, 0x02ab, 0x02c2, 0x02cb, 0x02d8, 0x02dc, 0x02e1, 
	0x02e8, 0x02f3, 0x02fb, 0x0307, 0x030d, 0x031b, 0x0328, 0x032d, 
	0x033d, 0x0349, 0x0356, 0x0369, 0x0380, 0x0384, 0x0397, 0x03ac, 
	0x03c0, 0x03cb, 0x03dc, 0x03e8, 0x03f4, 0x0401, 0x040d, 0x0413, 
	0x041f, 0x042c, 0x044a, 0x0454, 0x045f, 0x0468, 0x0475, 0x0485, 
	0x0491, 0x049c, 0x04a2, 0x04ae, 0x04b7, 0x04c4, 0x04d0, 0x04d7, 
	0x04e5, 0x04f2, 0x04fe, 0x050b, 0x0517, 0x0526, 0x0536, 0x0542, 
	0x0553, 0x055b, 0x0568, 0x0575, 0x0583, 0x058c, 0x0599, 0x05a2, 
	0x05ac, 0x05b9, 0x05c6, 0x05d4, 0x05e2, 0x05eb, 0x05f7, 0x060b, 
	0x0612, 0x0620, 0x062d, 0x0639, 0x0647, 0x0656, 0x0669, 
},
{	/* lc_time_rows */
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	   0,    0,    0,    0, 0x01,    0,    0,    0, 
	   0, 0x01,    0, 0x01, 0x01, 0x01, 0x01,    0, 
	0x01, 0x01, 0x01, 0x01,    0, 0x01,    0, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 
	0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x02, 
	0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,    0, 
	   0,    0,    0,    0,    0,    0, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 
	0x03, 0x02, 0x02, 0x02, 0x02, 0x03, 0x02, 0x03, 
	0x03, 0x03, 0x03, 0x02, 0x03, 0x03, 0x03, 0x03, 
	0x02, 0x03, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x02,    0,    0,    0,    0,    0,    0, 
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 
	0x03, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x04, 
	0x03, 0x04, 0x04, 0x04, 0x04, 0x03, 0x04, 0x04, 
	0x04, 0x04, 0x03, 0x04, 0x03, 0x04, 0x04, 0x04, 
	0x03, 0x03, 0x03, 0x02,    0,    0,    0,    0, 
	   0,    0, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 
	0x02, 0x02, 0x02, 0x02, 0x03, 0x02, 0x02, 0x02, 
	0x02, 0x03, 0x02, 0x03, 0x03, 0x03, 0x03, 0x02, 
	0x03, 0x03, 0x03, 0x03, 0x02, 0x03, 0x02, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x02,    0,    0, 
	   0,    0,    0,    0, 0x04, 0x04, 0x04, 0x04, 
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
	0x04, 0x06, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 
	0x03, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x04, 
	0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 0x03, 0x04, 
	0x03, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x02, 
	   0,    0,    0,    0,    0,    0, 0x04, 0x04, 
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
	0x04, 0x04, 0x04, 0x06, 0x03, 0x03, 0x03, 0x03, 
	0x04, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x04, 
	0x04, 0x04, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 
	0x03, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 
	0x04, 0x03,    0,    0,    0,    0,    0,    0, 
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x04, 0x04, 
	0x04, 0x04, 0x05, 0x04, 0x04, 0x04, 0x04, 0x05, 
	0x04, 0x05, 0x05, 0x05, 0x05, 0x04, 0x05, 0x05, 
	0x05, 0x05, 0x04, 0x05, 0x04, 0x05, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x02,    0,    0,    0,    0, 
	   0,    0, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
	0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 
	0x05, 0x05, 0x05, 0x05, 0x06, 0x05, 0x05, 0x05, 
	0x05, 0x06, 0x05, 0x06, 0x06, 0x06, 0x06, 0x05, 
	0x06, 0x06, 0x06, 0x06, 0x05, 0x06, 0x05, 0x06, 
	0x04, 0x04, 0x03, 0x03, 0x03, 0x02,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 0x03, 0x05, 0x03, 0x03, 0x03, 
	0x05, 0x05,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0x05, 0x05, 
	0x05, 0x06, 0x07, 0x05, 0x07, 0x05, 0x04, 0x05, 
	0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0, 0x04, 0x06, 0x04, 
	0x04, 0x04, 0x06, 0x06,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x06, 0x06, 0x06, 0x07, 0x08, 0x06, 0x08, 0x06, 
	0x05, 0x06, 0x05, 0x06, 0x05, 0x05, 0x05, 0x05, 
	0x05, 0x04,    0,    0,    0,    0,    0,    0, 
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x04, 0x04, 
	0x04, 0x04, 0x05, 0x04, 0x04, 0x04, 0x04, 0x05, 
	0x04, 0x05, 0x05, 0x05, 0x05, 0x04, 0x09, 0x07, 
	0x05, 0x05, 0x04, 0x05, 0x04, 0x05, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x02,    0,    0,    0,    0, 
	   0,    0, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
	0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 
	0x05, 0x05, 0x05, 0x05, 0x06, 0x05, 0x05, 0x05, 
	0x05, 0x06, 0x05, 0x06, 0x06, 0x06, 0x06, 0x05, 
	0x0a, 0x08, 0x06, 0x06, 0x05, 0x06, 0x05, 0x06, 
	0x04, 0x04, 0x03, 0x03, 0x03, 0x02,    0,    0, 
	   0,    0,    0,    0, 0x07, 0x07, 0x07, 0x07, 
	0x07, 0x07, 0x07, 0x05, 0x07, 0x05, 0x05, 0x05, 
	0x07, 0x07, 0x06, 0x06,    0,    0,    0, 0x06, 
	0x06, 0x06, 0x06, 0x01, 0x06, 0x07, 0x07, 0x07, 
	0x07, 0x08, 0x0b, 0x09, 0x09, 0x07, 0x06, 0x07, 
	0x06, 0x07, 0x05, 0x05, 0x06, 0x06, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x07, 0x07, 
	0x07, 0x08, 0x08, 0x08, 0x07, 0x06, 0x08, 0x06, 
	0x06, 0x06, 0x08, 0x08, 0x06, 0x06,    0,    0, 
	   0, 0x07, 0x07, 0x06, 0x06, 0x01, 0x06, 0x07, 
	0x07, 0x07, 0x07, 0x08, 0x0b, 0x09, 0x09, 0x07, 
	0x06, 0x07, 0x06, 0x07, 0x05, 0x05, 0x06, 0x06, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x08, 0x08, 0x08, 0x09, 0x09, 0x09, 0x08, 0x07, 
	0x09, 0x07, 0x07, 0x07, 0x09, 0x09, 0x07, 0x07, 
	0x06, 0x06, 0x07, 0x08, 0x08, 0x07, 0x07, 0x07, 
	0x07, 0x08, 0x08, 0x08, 0x08, 0x09, 0x0c, 0x0a, 
	0x0a, 0x08, 0x07, 0x08, 0x07, 0x08, 0x05, 0x05, 
	0x07, 0x06, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x09, 0x09, 0x09, 0x0a, 0x0a, 0x0a, 
	0x09, 0x08, 0x0a, 0x08, 0x08, 0x08, 0x0a, 0x0a, 
	0x08, 0x08, 0x07, 0x07, 0x08, 0x09, 0x09, 0x08, 
	0x08, 0x08, 0x08, 0x09, 0x09, 0x09, 0x09, 0x0a, 
	0x0d, 0x0b, 0x0b, 0x09, 0x08, 0x09, 0x08, 0x09, 
	0x05, 0x05, 0x07, 0x06, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x0a, 0x0a, 0x0a, 0x0b, 
	0x0b, 0x0b, 0x0a, 0x09, 0x0b, 0x09, 0x09, 0x09, 
	0x0b, 0x0b, 0x09, 0x09, 0x08, 0x08, 0x09, 0x0a, 
	0x0a, 0x09, 0x09, 0x09, 0x09, 0x0a, 0x0a, 0x0a, 
	0x0a, 0x0b, 0x0e, 0x0c, 0x0c, 0x0a, 0x09, 0x0a, 
	0x09, 0x0a, 0x05, 0x05, 0x08, 0x07, 0x06, 0x05, 
	   0,    0,    0,    0,    0,    0, 0x0b, 0x0b, 
	0x0b, 0x0c, 0x0c, 0x0c, 0x0b, 0x0a, 0x0c, 0x0a, 
	0x0a, 0x0a, 0x0c, 0x0c, 0x0a, 0x0a, 0x09, 0x09, 
	0x0a, 0x0b, 0x0b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0b, 
	0x0b, 0x0b, 0x0b, 0x0c, 0x0f, 0x0d, 0x0d, 0x0b, 
	0x0a, 0x0b, 0x0a, 0x0b, 0x05, 0x05, 0x08, 0x07, 
	0x06, 0x05,    0,    0,    0,    0,    0,    0, 
	0x0c, 0x0c, 0x0c, 0x0d, 0x0d, 0x0d, 0x0c, 0x0b, 
	0x0d, 0x0b, 0x0b, 0x0b, 0x0d, 0x0d, 0x0b, 0x0b, 
	0x0a, 0x0a, 0x0b, 0x0c, 0x0c, 0x0b, 0x0b, 0x0b, 
	0x0b, 0x0c, 0x0c, 0x0c, 0x0c, 0x0d, 0x10, 0x0e, 
	0x0e, 0x0c, 0x0b, 0x0c, 0x0b, 0x0c, 0x06, 0x06, 
	0x09, 0x08, 0x04, 0x03,    0,    0,    0,    0, 
	   0,    0, 0x0c, 0x0c, 0x0c, 0x0d, 0x0d, 0x0d, 
	0x0c, 0x0b, 0x0d, 0x0b, 0x0b, 0x0b, 0x0d, 0x0d, 
	0x0c, 0x0c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0c, 
	0x0c, 0x0b, 0x0b, 0x0c, 0x0c, 0x0c, 0x0c, 0x0d, 
	0x10, 0x0e, 0x0e, 0x0c, 0x0c, 0x0d, 0x0c, 0x0d, 
	0x07, 0x07, 0x09, 0x08, 0x04, 0x03,    0,    0, 
	   0,    0,    0,    0, 0x0d, 0x0d, 0x0d, 0x0e, 
	0x0e, 0x0e, 0x0d, 0x0c, 0x0e, 0x0c, 0x0c, 0x0c, 
	0x0e, 0x0e, 0x0d, 0x0d, 0x0c, 0x0c, 0x0c, 0x0d, 
	0x0e, 0x0d, 0x0d, 0x0c, 0x0c, 0x0d, 0x0d, 0x0d, 
	0x0d, 0x0e, 0x11, 0x0f, 0x0f, 0x0d, 0x0d, 0x0e, 
	0x0d, 0x0e, 0x08, 0x08, 0x0a, 0x06, 0x01, 0x06, 
	   0,    0,    0,    0,    0,    0, 0x0e, 0x0e, 
	0x0e, 0x0f, 0x0f, 0x0f, 0x0e, 0x0d, 0x0f, 0x0d, 
	0x0d, 0x0d, 0x0f, 0x0f,    0,    0,    0,    0, 
	0x0d,    0,    0,    0,    0, 0x01,    0,    0, 
	0x0e, 0x0e, 0x0e,    0, 0x12, 0x10, 0x10,    0, 
	0x0e, 0x0f, 0x0e, 0x0f, 0x05, 0x05, 0x07, 0x06, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x0e, 0x0e, 0x0e, 0x0f, 0x10, 0x0f, 0x0e, 0x0d, 
	0x0f, 0x0d, 0x0d, 0x0e, 0x0f, 0x0f,    0,    0, 
	   0,    0, 0x0d,    0,    0,    0,    0, 0x01, 
	   0,    0, 0x0e, 0x0e, 0x0e,    0, 0x12, 0x10, 
	0x10,    0, 0x0e, 0x0f, 0x0e, 0x0f, 0x05, 0x05, 
	0x07, 0x06, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x0f, 0x0f, 0x0f, 0x10, 0x11, 0x10, 
	0x0f, 0x0e, 0x10, 0x0e, 0x0e, 0x0f, 0x10, 0x10, 
	0x0e, 0x0e, 0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 0x0e, 
	0x0e, 0x0d, 0x0d, 0x0e, 0x0f, 0x0f, 0x0f, 0x0f, 
	0x13, 0x11, 0x11, 0x0e, 0x0f, 0x10, 0x0f, 0x10, 
	0x05, 0x05, 0x01, 0x01, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x0f, 0x0f, 0x0f, 0x10, 
	0x11, 0x10, 0x0f, 0x0e, 0x10, 0x0e, 0x0e, 0x0f, 
	0x10, 0x10, 0x0e, 0x0e, 0x0d, 0x0d, 0x0e, 0x0e, 
	0x0f, 0x0e, 0x0e, 0x0d, 0x0d, 0x0e, 0x0f, 0x0f, 
	0x10, 0x0f, 0x13, 0x11, 0x11, 0x0e, 0x0f, 0x10, 
	0x0f, 0x10, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x10, 0x10, 
	0x10, 0x11, 0x12, 0x11, 0x10, 0x0f, 0x11, 0x0f, 
	0x0f, 0x10, 0x11, 0x11, 0x0f, 0x0f, 0x0e, 0x0e, 
	0x0f, 0x0f, 0x10, 0x0f, 0x0f, 0x0e, 0x0e, 0x0f, 
	0x10, 0x10, 0x11, 0x10, 0x14, 0x12, 0x12, 0x0f, 
	0x10, 0x11, 0x10, 0x11, 0x05, 0x05, 0x0b, 0x06, 
	   0, 0x07,    0,    0,    0,    0,    0,    0, 
	0x10, 0x10, 0x11, 0x11, 0x13, 0x12, 0x10, 0x10, 
	0x12, 0x10, 0x10, 0x11, 0x12, 0x11, 0x0f, 0x10, 
	0x0f, 0x0e, 0x10, 0x10, 0x11, 0x0f, 0x10, 0x0f, 
	0x0e, 0x0f, 0x10, 0x11, 0x12, 0x10, 0x15, 0x13, 
	0x13, 0x0f, 0x11, 0x12, 0x10, 0x11, 0x05, 0x05, 
	0x0c, 0x06,    0, 0x07,    0,    0,    0,    0, 
	   0,    0, 0x11, 0x11, 0x12, 0x12, 0x14, 0x13, 
	0x11, 0x11, 0x13, 0x11, 0x11, 0x12, 0x13, 0x12, 
	0x10, 0x11, 0x10, 0x0f, 0x11, 0x11, 0x12, 0x10, 
	0x11, 0x10, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x11, 
	0x16, 0x14, 0x14, 0x10, 0x12, 0x13, 0x11, 0x12, 
	0x05, 0x05, 0x0d, 0x09, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x12, 0x12, 0x13, 0x13, 
	0x15, 0x14, 0x12, 0x12, 0x14, 0x12, 0x12, 0x13, 
	0x14, 0x13, 0x11, 0x0e, 0x0d, 0x10, 0x12, 0x0e, 
	0x0f, 0x11, 0x12, 0x11, 0x0d, 0x11, 0x12, 0x13, 
	0x14, 0x12, 0x17, 0x15, 0x15, 0x11, 0x13, 0x14, 
	0x12, 0x13, 0x05, 0x05, 0x01, 0x0a, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x13, 0x12, 
	0x13, 0x13, 0x15, 0x14, 0x13, 0x13, 0x14, 0x12, 
	0x12, 0x13, 0x14, 0x14, 0x11, 0x0e, 0x0d, 0x10, 
	0x12, 0x0e, 0x0f, 0x11, 0x12, 0x11, 0x0d, 0x11, 
	0x12, 0x13, 0x14, 0x12, 0x17, 0x15, 0x15, 0x11, 
	0x13, 0x14, 0x12, 0x13, 0x05, 0x05, 0x01, 0x0a, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x14,    0, 0x14, 0x14, 0x16, 0x15, 0x14, 0x14, 
	0x15, 0x13, 0x13, 0x14, 0x15, 0x15, 0x12,    0, 
	0x11,    0, 0x11,    0,    0,    0,    0, 0x01, 
	   0, 0x12, 0x13, 0x14, 0x15,    0, 0x16, 0x10, 
	0x10,    0,    0, 0x01,    0, 0x14, 0x05, 0x05, 
	0x01, 0x0b, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x14,    0, 0x14, 0x14, 0x16, 0x15, 
	0x14, 0x14, 0x15, 0x13, 0x13, 0x14, 0x15, 0x15, 
	0x13,    0, 0x12,    0, 0x11,    0,    0,    0, 
	   0, 0x01,    0, 0x12, 0x14, 0x14, 0x16,    0, 
	0x16, 0x10, 0x10,    0,    0, 0x01,    0, 0x14, 
	0x05, 0x05, 0x01, 0x0b, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x14,    0, 0x14, 0x14, 
	0x16, 0x15, 0x14, 0x14, 0x15, 0x13, 0x13, 0x14, 
	0x15, 0x15,    0,    0, 0x11,    0, 0x11,    0, 
	   0,    0,    0, 0x01,    0, 0x12, 0x0e, 0x0e, 
	0x15,    0, 0x16, 0x10, 0x10,    0,    0, 0x01, 
	   0, 0x14, 0x05, 0x05, 0x01, 0x0b, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x14,    0, 
	0x14, 0x14, 0x16, 0x15, 0x14, 0x14, 0x15, 0x13, 
	0x13, 0x14, 0x15, 0x15,    0,    0, 0x12,    0, 
	0x11,    0,    0,    0,    0, 0x01,    0, 0x12, 
	0x0e, 0x0e, 0x16,    0, 0x16, 0x10, 0x10,    0, 
	   0, 0x01,    0, 0x14, 0x05, 0x05, 0x01, 0x0b, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x14,    0, 0x14, 0x14, 0x16, 0x15, 0x14, 0x14, 
	0x15, 0x13, 0x13, 0x14, 0x15, 0x15,    0,    0, 
	0x11,    0, 0x11,    0,    0,    0,    0, 0x01, 
	   0, 0x12, 0x0e, 0x0e, 0x15,    0, 0x16, 0x10, 
	0x10,    0,    0, 0x01,    0, 0x14, 0x05, 0x05, 
	0x01, 0x06, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x14,    0, 0x14, 0x14, 0x16, 0x15, 
	0x14, 0x14, 0x15, 0x13, 0x13, 0x14, 0x15, 0x15, 
	   0,    0, 0x12,    0, 0x11,    0,    0,    0, 
	   0, 0x01,    0, 0x12, 0x0e, 0x0e, 0x16,    0, 
	0x16, 0x10, 0x10,    0,    0, 0x01,    0, 0x14, 
	0x05, 0x05, 0x01, 0x06, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x15, 0x13, 0x15, 0x15, 
	0x17, 0x16, 0x15, 0x15, 0x16, 0x14, 0x14, 0x15, 
	0x16, 0x16, 0x14, 0x12, 0x13, 0x11, 0x13, 0x12, 
	0x13, 0x12, 0x13, 0x12, 0x10, 0x13, 0x15, 0x15, 
	0x17, 0x13, 0x18, 0x16, 0x16, 0x12, 0x14, 0x15, 
	0x13, 0x15, 0x05, 0x05, 0x01, 0x02, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x16, 0x14, 
	0x16, 0x16, 0x18, 0x17, 0x16, 0x16, 0x17, 0x15, 
	0x15, 0x16, 0x17, 0x17, 0x15, 0x13, 0x14, 0x12, 
	0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x11, 0x14, 
	0x16, 0x16, 0x18, 0x14, 0x19, 0x17, 0x17, 0x13, 
	0x15, 0x16, 0x14, 0x16, 0x05, 0x05, 0x01, 0x02, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x01, 0x01, 0x01,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x05, 0x05, 0x01, 0x01, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x0e, 0x01, 0x02,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x05, 0x05, 0x0f, 0x0b, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x10, 0x0c, 0x07, 0x08,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0, 0x04, 0x04, 0x04, 0x03,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x11, 0x0d, 0x04, 0x03, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0x12, 0x0e, 
	0x04, 0x03,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x0e, 0x0f, 0x02,    0,    0,    0,    0,    0, 
	   0,    0, 0x17, 0x0d, 0x17, 0x0e, 0x19, 0x18, 
	0x17, 0x17, 0x18, 0x16, 0x16, 0x17, 0x18, 0x18, 
	   0,    0,    0,    0, 0x0d,    0,    0, 0x14, 
	   0, 0x01,    0,    0, 0x17, 0x17, 0x19, 0x15, 
	0x1a, 0x18, 0x18, 0x14, 0x16, 0x17, 0x15, 0x17, 
	0x05, 0x05, 0x13, 0x0b, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x18, 0x0d, 0x17, 0x17, 
	0x1a, 0x19, 0x18, 0x18, 0x19, 0x17, 0x17, 0x18, 
	0x19, 0x19, 0x16, 0x0e, 0x0d, 0x0d, 0x15, 0x0e, 
	0x0f, 0x0e, 0x12, 0x0d, 0x0d, 0x15, 0x18, 0x18, 
	0x1a, 0x0f, 0x1b, 0x19, 0x19, 0x15, 0x17, 0x10, 
	0x16, 0x18, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x18, 0x0d, 
	0x17, 0x18, 0x1a, 0x19, 0x19, 0x18, 0x19, 0x17, 
	0x18, 0x18, 0x19, 0x1a, 0x16, 0x0e, 0x0d, 0x0d, 
	0x15, 0x0e, 0x0f, 0x0e, 0x12, 0x0d, 0x0d, 0x15, 
	0x18, 0x18, 0x1a, 0x0f, 0x1b, 0x19, 0x19, 0x15, 
	0x17, 0x10, 0x16, 0x18, 0x05, 0x05, 0x01, 0x01, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x19, 0x15, 0x18, 0x19, 0x1b, 0x1a, 0x1a, 0x19, 
	0x1a, 0x18, 0x19, 0x19, 0x1a, 0x1b, 0x17, 0x14, 
	0x15, 0x13, 0x16, 0x14, 0x15, 0x15, 0x15, 0x14, 
	0x12, 0x16, 0x19, 0x19, 0x1b, 0x16, 0x1c, 0x1a, 
	0x1a, 0x11, 0x13, 0x18, 0x12, 0x19, 0x05, 0x05, 
	0x01, 0x06, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x19, 0x15, 0x18, 0x19, 0x1b, 0x1a, 
	0x1a, 0x1a, 0x1b, 0x19, 0x1a, 0x1a, 0x1a, 0x1c, 
	0x17, 0x14, 0x16, 0x13, 0x16, 0x14, 0x15, 0x15, 
	0x15, 0x14, 0x12, 0x16, 0x19, 0x19, 0x1c, 0x16, 
	0x1c, 0x1a, 0x1a, 0x11, 0x13, 0x18, 0x12, 0x19, 
	0x05, 0x05, 0x01, 0x06, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x1a, 0x16, 0x19, 0x1a, 
	0x1c, 0x1b, 0x1b, 0x1b, 0x1c, 0x1a, 0x1b, 0x1b, 
	0x1b, 0x1d, 0x18, 0x15, 0x0d, 0x14, 0x0e, 0x15, 
	0x16, 0x16, 0x16, 0x15, 0x13, 0x17, 0x1a, 0x1a, 
	0x1d, 0x17, 0x1d, 0x1b, 0x1b, 0x16, 0x18, 0x19, 
	0x17, 0x1a, 0x05, 0x05, 0x14, 0x10, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x1b, 0x17, 
	0x1a, 0x1b, 0x1d, 0x1c, 0x1c, 0x1c, 0x1d, 0x1b, 
	0x1c, 0x1c, 0x1c, 0x1e, 0x19, 0x16, 0x03, 0x15, 
	0x17, 0x16, 0x17, 0x17, 0x17, 0x16, 0x14, 0x18, 
	0x1b, 0x1b, 0x04, 0x18, 0x1e, 0x1c, 0x1c, 0x17, 
	0x19, 0x1a, 0x18, 0x1b, 0x09, 0x09, 0x15, 0x11, 
	   0, 0x09,    0,    0,    0,    0,    0,    0, 
	0x1c, 0x18, 0x1b, 0x1c, 0x1e, 0x1d, 0x1d, 0x1d, 
	0x1e, 0x1c, 0x1d, 0x1d, 0x1d, 0x1f, 0x1a, 0x17, 
	0x17, 0x16, 0x18, 0x17, 0x18, 0x18, 0x18, 0x17, 
	0x15, 0x19, 0x1c, 0x1c, 0x1e, 0x19, 0x1f, 0x1d, 
	0x1d, 0x18, 0x1a, 0x1b, 0x19, 0x1c, 0x05, 0x05, 
	0x16, 0x06, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x1c, 0x18, 0x1b, 0x1c, 0x1e, 0x1d, 
	0x1d, 0x1d, 0x1e, 0x1c, 0x1d, 0x1d, 0x1d, 0x1f, 
	0x1b, 0x18, 0x17, 0x17, 0x19, 0x18, 0x19, 0x19, 
	0x19, 0x18, 0x15, 0x1a, 0x1c, 0x1c, 0x1e, 0x19, 
	0x1f, 0x1e, 0x1e, 0x18, 0x1a, 0x1b, 0x19, 0x1c, 
	0x05, 0x05, 0x16, 0x06, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x1d, 0x19, 0x1c, 0x1d, 
	0x1f, 0x1e, 0x1e, 0x1e, 0x1f, 0x1d, 0x1e, 0x1e, 
	0x1e, 0x20, 0x11, 0x0e, 0x0d, 0x10, 0x0e, 0x0e, 
	0x0f, 0x11, 0x12, 0x11, 0x0d, 0x0e, 0x12, 0x13, 
	0x1f, 0x1a, 0x1c, 0x15, 0x15, 0x11, 0x13, 0x14, 
	0x12, 0x1d, 0x05, 0x05, 0x01, 0x12, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x1d, 0x1a, 
	0x1d, 0x1d, 0x20, 0x1f, 0x1e, 0x1e, 0x20, 0x1e, 
	0x1e, 0x1f, 0x1f, 0x20, 0x11, 0x0e, 0x0d, 0x10, 
	0x0e, 0x0e, 0x0f, 0x11, 0x12, 0x11, 0x0d, 0x0e, 
	0x12, 0x13, 0x1f, 0x1b, 0x1c, 0x15, 0x15, 0x11, 
	0x13, 0x14, 0x12, 0x1d, 0x05, 0x05, 0x01, 0x12, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x17, 0x0d, 0x17, 0x0e, 0x21, 0x18, 0x1f, 0x1f, 
	0x21, 0x1f, 0x1f, 0x20, 0x20, 0x21, 0x11, 0x19, 
	0x0d, 0x18, 0x0e, 0x0e, 0x1a, 0x1a, 0x12, 0x0d, 
	0x0d, 0x1b, 0x1d, 0x1d, 0x1f, 0x1c, 0x1c, 0x1f, 
	0x1f, 0x19, 0x1b, 0x1c, 0x0f, 0x1e, 0x05, 0x05, 
	0x01, 0x01, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x17, 0x0d, 0x17, 0x0e, 0x21, 0x18, 
	0x1f, 0x1f, 0x21, 0x1f, 0x1f, 0x20, 0x20, 0x21, 
	0x11, 0x1a, 0x0d, 0x18, 0x0e, 0x0e, 0x1a, 0x1b, 
	0x12, 0x0d, 0x0d, 0x1c, 0x1d, 0x1e, 0x1f, 0x1c, 
	0x1c, 0x1f, 0x1f, 0x1a, 0x1b, 0x1c, 0x0f, 0x1f, 
	0x05, 0x05, 0x01, 0x01, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x17, 0x0d, 0x17, 0x0e, 
	0x21, 0x18, 0x1f, 0x1f, 0x21, 0x1f, 0x1f, 0x20, 
	0x20, 0x21, 0x11, 0x19, 0x0d, 0x18, 0x0e, 0x0e, 
	0x1a, 0x1a, 0x12, 0x0d, 0x0d, 0x1b, 0x1d, 0x1d, 
	0x1f, 0x1c, 0x1c, 0x1f, 0x1f, 0x19, 0x1b, 0x1c, 
	0x0f, 0x1e, 0x05, 0x05, 0x01, 0x0b, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x17, 0x0d, 
	0x17, 0x0e, 0x21, 0x18, 0x1f, 0x1f, 0x21, 0x1f, 
	0x1f, 0x20, 0x20, 0x21, 0x11, 0x1a, 0x0d, 0x18, 
	0x0e, 0x0e, 0x1a, 0x1b, 0x12, 0x0d, 0x0d, 0x1c, 
	0x1d, 0x1e, 0x1f, 0x1c, 0x1c, 0x1f, 0x1f, 0x1a, 
	0x1b, 0x1c, 0x0f, 0x1f, 0x05, 0x05, 0x01, 0x0b, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x17, 0x0d, 0x17, 0x0e, 0x21, 0x18, 0x1f, 0x1f, 
	0x21, 0x1f, 0x1f, 0x20, 0x20, 0x21, 0x11, 0x19, 
	0x0d, 0x18, 0x0e, 0x0e, 0x1a, 0x1a, 0x12, 0x0d, 
	0x0d, 0x1b, 0x1d, 0x1d, 0x1f, 0x1c, 0x1c, 0x1f, 
	0x1f, 0x19, 0x1b, 0x1c, 0x0f, 0x1e, 0x05, 0x05, 
	0x01, 0x13, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x17, 0x0d, 0x17, 0x0e, 0x21, 0x18, 
	0x1f, 0x1f, 0x21, 0x1f, 0x1f, 0x20, 0x20, 0x21, 
	0x11, 0x1a, 0x0d, 0x18, 0x0e, 0x0e, 0x1a, 0x1b, 
	0x12, 0x0d, 0x0d, 0x1c, 0x1d, 0x1e, 0x1f, 0x1c, 
	0x1c, 0x1f, 0x1f, 0x1a, 0x1b, 0x1c, 0x0f, 0x1f, 
	0x05, 0x05, 0x01, 0x13, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x17, 0x0d, 0x17, 0x0e, 
	0x21, 0x18, 0x1f, 0x1f, 0x21, 0x1f, 0x1f, 0x20, 
	0x20, 0x21, 0x11, 0x19, 0x0d, 0x18, 0x0e, 0x0e, 
	0x1a, 0x1a, 0x12, 0x0d, 0x0d, 0x1b, 0x1d, 0x1d, 
	0x1f, 0x1c, 0x1c, 0x1f, 0x1f, 0x19, 0x1b, 0x1c, 
	0x0f, 0x1e, 0x05, 0x05, 0x01, 0x06, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x17, 0x0d, 
	0x17, 0x0e, 0x21, 0x18, 0x1f, 0x1f, 0x21, 0x1f, 
	0x1f, 0x20, 0x20, 0x21, 0x11, 0x1a, 0x0d, 0x18, 
	0x0e, 0x0e, 0x1a, 0x1b, 0x12, 0x0d, 0x0d, 0x1c, 
	0x1d, 0x1e, 0x1f, 0x1c, 0x1c, 0x1f, 0x1f, 0x1a, 
	0x1b, 0x1c, 0x0f, 0x1f, 0x05, 0x05, 0x01, 0x06, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x1e, 0x1b, 0x1e, 0x1e, 0x22, 0x20, 0x20, 0x20, 
	0x22, 0x20, 0x20, 0x21, 0x21, 0x22, 0x1c, 0x1b, 
	0x18, 0x19, 0x1a, 0x19, 0x1b, 0x1c, 0x1a, 0x19, 
	0x16, 0x1d, 0x1e, 0x1f, 0x20, 0x1d, 0x20, 0x20, 
	0x20, 0x1b, 0x1c, 0x1d, 0x1a, 0x20, 0x05, 0x05, 
	0x01, 0x09, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x1e, 0x1b, 0x1f, 0x1f, 0x23, 0x20, 
	0x20, 0x21, 0x23, 0x21, 0x21, 0x22, 0x22, 0x23, 
	0x1c, 0x1b, 0x19, 0x19, 0x1a, 0x19, 0x1c, 0x1d, 
	0x1b, 0x1a, 0x16, 0x1d, 0x1f, 0x1f, 0x21, 0x1e, 
	0x21, 0x20, 0x21, 0x1c, 0x1d, 0x1e, 0x1b, 0x21, 
	0x05, 0x05, 0x01, 0x09, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x1f, 0x1c, 0x20, 0x20, 
	0x24, 0x21, 0x21, 0x22, 0x24, 0x22, 0x22, 0x23, 
	0x23, 0x24, 0x1d, 0x1c, 0x1a, 0x1a, 0x1b, 0x1a, 
	0x1d, 0x1e, 0x1c, 0x1b, 0x17, 0x1e, 0x20, 0x20, 
	0x22, 0x1f, 0x22, 0x21, 0x22, 0x1d, 0x1e, 0x1f, 
	0x1c, 0x22, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x1f, 0x1c, 
	0x20, 0x20, 0x24, 0x21, 0x21, 0x23, 0x24, 0x23, 
	0x22, 0x23, 0x23, 0x24, 0x1d, 0x1c, 0x1b, 0x1a, 
	0x1c, 0x1a, 0x1d, 0x1f, 0x1c, 0x1b, 0x17, 0x1f, 
	0x20, 0x20, 0x23, 0x1f, 0x23, 0x22, 0x22, 0x1e, 
	0x1e, 0x1f, 0x1c, 0x23, 0x05, 0x05, 0x01, 0x01, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x20, 0x1d, 0x21, 0x21, 0x25, 0x22, 0x22, 0x24, 
	0x25, 0x24, 0x23, 0x24, 0x24, 0x25, 0x1e,    0, 
	   0, 0x1b, 0x11, 0x1b, 0x1e, 0x20, 0x1d, 0x1c, 
	   0,    0, 0x21, 0x21, 0x24, 0x20, 0x24, 0x23, 
	0x23, 0x1f, 0x1f, 0x20, 0x15, 0x17, 0x05, 0x05, 
	0x01, 0x01, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x20, 0x1d, 0x21, 0x22, 0x25, 0x22, 
	0x23, 0x24, 0x25, 0x24, 0x24, 0x24, 0x24, 0x26, 
	0x1e,    0,    0, 0x1b, 0x11, 0x1c, 0x1e, 0x20, 
	0x1d, 0x1c,    0,    0, 0x21, 0x21, 0x24, 0x20, 
	0x24, 0x24, 0x23, 0x1f, 0x1f, 0x20, 0x15, 0x17, 
	0x05, 0x05, 0x01, 0x01, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x21, 0x1e, 0x22, 0x23, 
	0x26, 0x23, 0x24, 0x25, 0x26, 0x25, 0x25, 0x25, 
	0x25, 0x27, 0x1f, 0x1d, 0x1c, 0x1c, 0x1d, 0x1d, 
	0x1f, 0x21, 0x1e, 0x1d, 0x18, 0x20, 0x22, 0x22, 
	0x25, 0x21, 0x25, 0x25, 0x24, 0x20, 0x20, 0x21, 
	0x1d, 0x24, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x22, 0x1f, 
	0x23, 0x24, 0x27, 0x24, 0x25, 0x26, 0x27, 0x26, 
	0x26, 0x26, 0x26, 0x28, 0x20, 0x1e, 0x1d, 0x1d, 
	0x1e, 0x1e, 0x20, 0x22, 0x1f, 0x1e, 0x19, 0x21, 
	0x23, 0x23, 0x26, 0x22, 0x26, 0x26, 0x25, 0x21, 
	0x21, 0x22, 0x1e, 0x25,    0,    0, 0x17, 0x01, 
	   0, 0x0a,    0,    0,    0,    0,    0,    0, 
	0x23, 0x20, 0x24, 0x25, 0x28, 0x25, 0x26, 0x27, 
	0x28, 0x27, 0x27, 0x27, 0x27, 0x29, 0x21, 0x1f, 
	0x1e, 0x1e, 0x1f, 0x1f, 0x21, 0x23, 0x20, 0x1f, 
	0x1a, 0x22, 0x24, 0x24, 0x27, 0x23, 0x27, 0x27, 
	0x26, 0x22, 0x22, 0x23, 0x1f, 0x26,    0,    0, 
	0x17, 0x01,    0, 0x0a,    0,    0,    0,    0, 
	   0,    0, 0x24, 0x21, 0x25, 0x26, 0x29, 0x26, 
	0x27, 0x28, 0x29, 0x28, 0x28, 0x28, 0x28, 0x2a, 
	0x22, 0x20, 0x1f, 0x1f, 0x20, 0x20, 0x22, 0x24, 
	0x21, 0x20, 0x1b, 0x23, 0x25, 0x25, 0x28, 0x24, 
	0x28, 0x28, 0x27, 0x23, 0x23, 0x24, 0x20, 0x27, 
	0x0a, 0x0a, 0x09, 0x08, 0x04, 0x03,    0,    0, 
	   0,    0,    0,    0, 0x0e, 0x0e, 0x0e, 0x0f, 
	0x0f, 0x0f, 0x0e, 0x0d, 0x0f, 0x0d, 0x0d, 0x0d, 
	0x0f, 0x0f, 0x23, 0x21, 0x20, 0x20, 0x21, 0x21, 
	0x23, 0x25, 0x22, 0x21, 0x1c, 0x24, 0x26, 0x26, 
	0x29, 0x25, 0x29, 0x29, 0x28, 0x24, 0x24, 0x25, 
	0x21, 0x28, 0x05, 0x05, 0x07, 0x06, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x0e, 0x0e, 
	0x0e, 0x0f, 0x10, 0x0f, 0x0e, 0x0d, 0x0f, 0x0d, 
	0x0d, 0x0e, 0x0f, 0x0f, 0x23, 0x21, 0x21, 0x20, 
	0x21, 0x21, 0x23, 0x25, 0x22, 0x21, 0x1c, 0x24, 
	0x27, 0x27, 0x2a, 0x25, 0x29, 0x29, 0x28, 0x24, 
	0x24, 0x25, 0x21, 0x28, 0x05, 0x05, 0x07, 0x06, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x25, 0x22, 0x26, 0x27, 0x2a, 0x27, 0x28, 0x29, 
	0x2a, 0x29, 0x29, 0x29, 0x29, 0x2b, 0x11, 0x0e, 
	0x22, 0x21, 0x22, 0x22, 0x24, 0x11, 0x23, 0x11, 
	0x0d, 0x11, 0x28, 0x28, 0x2b, 0x26, 0x2a, 0x2a, 
	0x29, 0x25, 0x25, 0x26, 0x12, 0x13, 0x05, 0x05, 
	0x18, 0x0b, 0x08, 0x0b,    0,    0,    0,    0, 
	   0,    0, 0x25, 0x22, 0x26, 0x27, 0x2a, 0x27, 
	0x28, 0x2a, 0x2b, 0x29, 0x29, 0x2a, 0x2a, 0x2b, 
	0x11, 0x0e, 0x23, 0x22, 0x23, 0x23, 0x25, 0x11, 
	0x23, 0x11, 0x0d, 0x11, 0x29, 0x29, 0x2c, 0x27, 
	0x2b, 0x2b, 0x2a, 0x25, 0x25, 0x27, 0x12, 0x13, 
	0x05, 0x05, 0x18, 0x0b, 0x08, 0x0b,    0,    0, 
	   0,    0,    0,    0, 0x26, 0x23, 0x27, 0x28, 
	0x2b, 0x28, 0x29, 0x2b, 0x2c, 0x2a, 0x2a, 0x2b, 
	0x2b, 0x2c, 0x24, 0x22, 0x24, 0x23, 0x24, 0x24, 
	0x26, 0x26, 0x24, 0x22, 0x1d, 0x25, 0x2a, 0x2a, 
	0x2d, 0x28, 0x2c, 0x2c, 0x2b, 0x26, 0x26, 0x28, 
	0x22, 0x29, 0x05, 0x05, 0x0e,    0, 0x02, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x27, 0x24, 
	0x28, 0x29, 0x2c, 0x29, 0x2a, 0x2c, 0x2d, 0x2b, 
	0x2b, 0x2c, 0x2c, 0x2d, 0x25, 0x23, 0x25, 0x24, 
	0x25, 0x25, 0x27, 0x27, 0x25, 0x23, 0x1e, 0x26, 
	0x2b, 0x2b, 0x2e, 0x29, 0x2d, 0x2d, 0x2c, 0x27, 
	0x27, 0x29, 0x23, 0x2a, 0x05, 0x05, 0x0e,    0, 
	0x02, 0x01,    0,    0,    0,    0,    0,    0, 
	0x28, 0x25, 0x29, 0x2a, 0x2d, 0x2a, 0x2b, 0x2d, 
	0x2e, 0x2c, 0x2c, 0x2d, 0x2d, 0x2e,    0, 0x24, 
	   0,    0, 0x01,    0,    0, 0x28,    0, 0x01, 
	   0, 0x01, 0x2c, 0x2c, 0x2f,    0, 0x01, 0x10, 
	0x10, 0x28,    0, 0x01,    0, 0x01, 0x05, 0x05, 
	0x0e, 0x01, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0,    0, 0x26, 0x2a, 0x2b, 0x2e, 0x2b, 
	0x2c, 0x2e, 0x2f, 0x2d, 0x2d, 0x2e, 0x2e, 0x2f, 
	   0,    0,    0,    0, 0x26, 0x26, 0x28, 0x29, 
	   0, 0x01, 0x1f, 0x01, 0x2d, 0x2d, 0x30, 0x2a, 
	0x2e, 0x2e, 0x2d, 0x29,    0, 0x2a, 0x24, 0x01, 
	0x0b, 0x0b, 0x19, 0x14, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0,    0, 0x27, 0x2b, 0x2c, 
	0x2e, 0x2c, 0x2c, 0x2e, 0x30, 0x2e, 0x2e, 0x2e, 
	0x2f, 0x2f,    0,    0,    0,    0, 0x27, 0x27, 
	0x29, 0x2a,    0, 0x01, 0x20, 0x01, 0x2e, 0x2e, 
	0x30, 0x2b, 0x2f, 0x2f, 0x2e, 0x2a,    0, 0x2b, 
	0x25, 0x01, 0x0b, 0x0b, 0x19, 0x14, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x18, 0x0d, 
	0x17, 0x0e, 0x2f, 0x18, 0x17, 0x2f, 0x31, 0x2f, 
	0x2f, 0x2f, 0x30, 0x18, 0x0e, 0x0e, 0x0d, 0x10, 
	0x28, 0x28, 0x2a, 0x0e, 0x0e, 0x24, 0x0d, 0x15, 
	0x2f, 0x2f, 0x1a, 0x2c, 0x30, 0x30, 0x2f, 0x15, 
	0x28, 0x2c, 0x0f, 0x2b, 0x05, 0x05, 0x01, 0x13, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x18, 0x0d, 0x17, 0x0e, 0x2f, 0x18, 0x17, 0x2f, 
	0x32, 0x30, 0x30, 0x30, 0x31, 0x18, 0x0e, 0x0e, 
	0x0d, 0x10, 0x28, 0x28, 0x2a, 0x0e, 0x0e, 0x24, 
	0x0d, 0x15, 0x2f, 0x2f, 0x1a, 0x2c, 0x30, 0x30, 
	0x2f, 0x15, 0x28, 0x2c, 0x0f, 0x2b, 0x05, 0x05, 
	0x01, 0x13, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x18, 0x0d, 0x17, 0x0e, 0x2f, 0x18, 
	0x17, 0x2f, 0x31, 0x2f, 0x2f, 0x2f, 0x30, 0x18, 
	0x0e, 0x0e, 0x0d, 0x10, 0x28, 0x28, 0x2a, 0x0e, 
	0x0e, 0x24, 0x0d, 0x15, 0x2f, 0x2f, 0x1a, 0x2c, 
	0x30, 0x30, 0x2f, 0x15, 0x28, 0x2c, 0x0f, 0x2b, 
	0x05, 0x05, 0x01, 0x02, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x18, 0x0d, 0x17, 0x0e, 
	0x2f, 0x18, 0x17, 0x2f, 0x32, 0x30, 0x30, 0x30, 
	0x31, 0x18, 0x0e, 0x0e, 0x0d, 0x10, 0x28, 0x28, 
	0x2a, 0x0e, 0x0e, 0x24, 0x0d, 0x15, 0x2f, 0x2f, 
	0x1a, 0x2c, 0x30, 0x30, 0x2f, 0x15, 0x28, 0x2c, 
	0x0f, 0x2b, 0x05, 0x05, 0x01, 0x02, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x29, 0x28, 
	0x2c, 0x2d, 0x30, 0x2d, 0x2d, 0x30, 0x33, 0x31, 
	0x31, 0x31, 0x32, 0x30, 0x26, 0x25, 0x26, 0x25, 
	0x29, 0x29, 0x2b, 0x2b, 0x26, 0x25, 0x21, 0x27, 
	0x30, 0x30, 0x31, 0x2d, 0x31, 0x31, 0x30, 0x2b, 
	0x29, 0x2d, 0x26, 0x2c, 0x0c, 0x0c, 0x1a, 0x15, 
	0x09, 0x0c, 0x01,    0, 0x01, 0x01, 0x01,    0, 
	0x2a, 0x29, 0x2d, 0x2e, 0x31, 0x2e, 0x2e, 0x31, 
	0x34, 0x32, 0x32, 0x32, 0x33, 0x31, 0x27, 0x26, 
	0x27, 0x26, 0x2a, 0x2a, 0x2c, 0x2c, 0x27, 0x26, 
	0x22, 0x28, 0x31, 0x31, 0x32, 0x2e, 0x32, 0x32, 
	0x31, 0x2c, 0x2a, 0x2e, 0x27, 0x2d, 0x05, 0x05, 
	0x1b, 0x0f, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x2b, 0x2a, 0x2e, 0x2f, 0x32, 0x2f, 
	0x2f, 0x32, 0x35, 0x33, 0x33, 0x33, 0x34, 0x32, 
	0x28, 0x27, 0x28, 0x27, 0x2b, 0x2b, 0x2d, 0x2d, 
	0x28, 0x27, 0x23, 0x29, 0x32, 0x32, 0x33, 0x2f, 
	0x33, 0x33, 0x32, 0x2d, 0x2b, 0x2f, 0x28, 0x2e, 
	0x05, 0x05, 0x1c, 0x0f, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x2c, 0x2b, 0x17, 0x30, 
	0x33, 0x30, 0x30, 0x33, 0x36, 0x34, 0x34, 0x34, 
	0x35, 0x33, 0x11, 0x0e, 0x0d, 0x10, 0x12, 0x0e, 
	0x0f, 0x11, 0x12, 0x11, 0x0d, 0x11, 0x33, 0x33, 
	0x34, 0x30, 0x34, 0x15, 0x15, 0x2e, 0x2c, 0x30, 
	0x29, 0x2f, 0x05, 0x05, 0x01, 0x16, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x2d, 0x2c, 
	0x2f, 0x31, 0x34, 0x31, 0x31, 0x34, 0x37, 0x35, 
	0x35, 0x35, 0x36, 0x34, 0x29, 0x28, 0x29, 0x28, 
	0x2c, 0x2c, 0x2e, 0x2e, 0x29, 0x28, 0x24, 0x2a, 
	0x34, 0x34, 0x35, 0x31, 0x35, 0x34, 0x33, 0x2f, 
	0x2d, 0x31, 0x2a, 0x30, 0x0d, 0x0d, 0x1d, 0x17, 
	0x0a, 0x0d,    0,    0,    0,    0,    0,    0, 
	0x11, 0x1d, 0x30, 0x32, 0x35, 0x13, 0x11, 0x35, 
	0x38, 0x36, 0x36, 0x36, 0x37, 0x35, 0x2a, 0x29, 
	0x2a, 0x0f, 0x2d, 0x2d, 0x12, 0x2f, 0x2a, 0x29, 
	0x25, 0x2b, 0x35, 0x35, 0x36, 0x32, 0x36, 0x35, 
	0x34, 0x30, 0x2e, 0x32, 0x2b, 0x31, 0x05, 0x05, 
	0x01, 0x01, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x2e, 0x2d, 0x31, 0x33, 0x36, 0x32, 
	0x32, 0x36, 0x39, 0x37, 0x37, 0x37, 0x38, 0x36, 
	0x2b, 0x2a, 0x2b, 0x29, 0x2e, 0x2e, 0x2f, 0x30, 
	0x2b, 0x2a, 0x26, 0x2c, 0x36, 0x36, 0x37, 0x33, 
	0x37, 0x36, 0x35, 0x31, 0x2f, 0x33, 0x2c, 0x32, 
	0x05, 0x05, 0x1e, 0x18, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x2e, 0x2d, 0x31, 0x33, 
	0x36, 0x32, 0x33, 0x36, 0x39, 0x37, 0x38, 0x37, 
	0x38, 0x37, 0x2b, 0x2a, 0x2b, 0x29, 0x2e, 0x2e, 
	0x2f, 0x30, 0x2b, 0x2a, 0x26, 0x2c, 0x36, 0x36, 
	0x37, 0x34, 0x38, 0x37, 0x35, 0x32, 0x30, 0x33, 
	0x2d, 0x33, 0x05, 0x05, 0x1e, 0x18, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x2f, 0x2e, 
	0x32, 0x34, 0x37, 0x33, 0x34, 0x37, 0x3a, 0x38, 
	0x39, 0x38, 0x39, 0x38, 0x11, 0x0e, 0x0d, 0x10, 
	0x0e, 0x2f, 0x30, 0x11, 0x12, 0x11, 0x0d, 0x11, 
	0x37, 0x37, 0x14, 0x35, 0x39, 0x38, 0x36, 0x33, 
	0x31, 0x34, 0x2e, 0x34, 0x05, 0x05, 0x1f, 0x19, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x2f, 0x2f, 0x33, 0x35, 0x38, 0x33, 0x35, 0x38, 
	0x3a, 0x38, 0x3a, 0x38, 0x39, 0x38, 0x11, 0x0e, 
	0x0d, 0x10, 0x0e, 0x30, 0x31, 0x11, 0x12, 0x11, 
	0x0d, 0x11, 0x38, 0x38, 0x14, 0x36, 0x39, 0x39, 
	0x37, 0x33, 0x31, 0x34, 0x2e, 0x34, 0x05, 0x05, 
	0x1f, 0x19, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x30, 0x01, 0x34, 0x36, 0x39, 0x34, 
	0x36, 0x39, 0x3b, 0x39, 0x3b, 0x39, 0x3a, 0x39, 
	0x2c, 0x2b, 0x2c, 0x2a, 0x2f, 0x31, 0x32, 0x31, 
	0x2c, 0x2b, 0x27, 0x2d, 0x39, 0x39, 0x38, 0x37, 
	0x3a, 0x3a, 0x38, 0x34, 0x32, 0x35, 0x2f, 0x35, 
	0x05, 0x05, 0x20, 0x01, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x30, 0x01, 0x35, 0x36, 
	0x3a, 0x34, 0x37, 0x3a, 0x3b, 0x3a, 0x3b, 0x3a, 
	0x3a, 0x3a, 0x2c, 0x2b, 0x2c, 0x2a, 0x2f, 0x31, 
	0x33, 0x31, 0x2c, 0x2b, 0x27, 0x2d, 0x3a, 0x39, 
	0x39, 0x38, 0x3a, 0x3a, 0x39, 0x35, 0x32, 0x36, 
	0x30, 0x35, 0x05, 0x05, 0x20, 0x01, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x31, 0x30, 
	0x36, 0x37, 0x3b, 0x35, 0x38, 0x3b, 0x3c, 0x3b, 
	0x3c, 0x3b, 0x3b, 0x3b, 0x2d, 0x2c, 0x2d, 0x2b, 
	0x30, 0x32, 0x34, 0x32, 0x2d, 0x2c, 0x28, 0x2e, 
	0x3b, 0x3a, 0x3a, 0x39, 0x3b, 0x3b, 0x3a, 0x36, 
	0x33, 0x37, 0x31, 0x36, 0x05, 0x05, 0x21, 0x06, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x32, 0x31, 0x37, 0x38, 0x3c, 0x36, 0x39, 0x3c, 
	0x0c, 0x0a, 0x3d, 0x3c, 0x3c, 0x3c, 0x2e, 0x0a, 
	0x09, 0x09, 0x31, 0x33, 0x35, 0x0a, 0x0a, 0x0a, 
	0x0a, 0x0b, 0x3c, 0x0b, 0x0b, 0x0c, 0x3c, 0x3c, 
	0x3b, 0x0b, 0x0a, 0x0b, 0x0a, 0x0b, 0x05, 0x05, 
	0x21, 0x06, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x33, 0x32, 0x38, 0x39, 0x3d, 0x37, 
	0x3a, 0x3d, 0x3d, 0x3c, 0x3e, 0x3d, 0x3d, 0x3d, 
	0x2f, 0x2d, 0x1f, 0x2c, 0x32, 0x20, 0x36, 0x33, 
	0x2e, 0x2d, 0x29, 0x2f, 0x3d, 0x3b, 0x28, 0x3a, 
	0x3d, 0x28, 0x3c, 0x37, 0x34, 0x38, 0x32, 0x37, 
	0x0e, 0x0e, 0x09, 0x08, 0x04, 0x03,    0,    0, 
	   0,    0,    0,    0, 0x34, 0x33, 0x29, 0x2a, 
	0x3e, 0x2a, 0x2b, 0x3e, 0x3e, 0x2c, 0x2c, 0x3e, 
	0x3e, 0x2e,    0,    0, 0x2e,    0, 0x01,    0, 
	   0, 0x34,    0, 0x01,    0, 0x30, 0x2c, 0x3c, 
	0x3b,    0, 0x01, 0x3d, 0x3d, 0x38,    0, 0x01, 
	   0, 0x38, 0x05, 0x05, 0x09, 0x08, 0x04, 0x03, 
	   0,    0,    0,    0,    0,    0, 0x35, 0x34, 
	0x39, 0x3a, 0x3f, 0x38, 0x3b, 0x3f, 0x3f, 0x3d, 
	0x3f, 0x3f, 0x3f, 0x3e,    0, 0x2e,    0,    0, 
	0x33, 0x34, 0x37, 0x35, 0x1d, 0x2e,    0, 0x31, 
	0x3e, 0x3d, 0x3c,    0, 0x3e, 0x3e, 0x3e, 0x39, 
	0x35, 0x39, 0x33, 0x39, 0x05, 0x05, 0x22, 0x1a, 
	0x04, 0x03,    0,    0,    0,    0,    0,    0, 
	0x36, 0x34, 0x39, 0x3a, 0x40, 0x39, 0x3b, 0x40, 
	0x3f, 0x3d, 0x40, 0x40, 0x40, 0x3e,    0, 0x2e, 
	   0,    0, 0x33, 0x35, 0x37, 0x35, 0x1d, 0x2e, 
	   0, 0x32, 0x3e, 0x3d, 0x3c,    0, 0x3e, 0x3f, 
	0x3e, 0x39, 0x35, 0x39, 0x33, 0x3a, 0x05, 0x05, 
	0x22, 0x1a, 0x04, 0x03,    0,    0,    0,    0, 
	   0,    0, 0x37, 0x18, 0x3a, 0x3b, 0x41, 0x3a, 
	0x3c, 0x41, 0x40, 0x3e, 0x41, 0x41, 0x41, 0x3f, 
	0x11, 0x0e, 0x2f, 0x10, 0x34, 0x0e, 0x0f, 0x11, 
	0x12, 0x11, 0x0d, 0x11, 0x33, 0x33, 0x3d, 0x12, 
	0x3f, 0x15, 0x15, 0x3a, 0x13, 0x14, 0x12, 0x13, 
	0x05, 0x05, 0x01, 0x1b, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x38, 0x35, 0x3b, 0x3c, 
	0x42, 0x3b, 0x3d, 0x42, 0x41, 0x3f, 0x42, 0x42, 
	0x42, 0x40, 0x11, 0x0e, 0x0d, 0x10, 0x0e, 0x0e, 
	0x0f, 0x11, 0x12, 0x11, 0x0d, 0x0e, 0x12, 0x13, 
	0x1f, 0x12, 0x1c, 0x15, 0x15, 0x11, 0x13, 0x14, 
	0x12, 0x1d, 0x05, 0x05, 0x23, 0x1c, 0x0b, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x38, 0x36, 
	0x3b, 0x3c, 0x42, 0x3b, 0x3d, 0x42, 0x42, 0x3f, 
	0x42, 0x42, 0x42, 0x40, 0x11, 0x0e, 0x0d, 0x10, 
	0x0e, 0x0e, 0x0f, 0x11, 0x12, 0x11, 0x0d, 0x0e, 
	0x12, 0x13, 0x1f, 0x12, 0x1c, 0x15, 0x15, 0x11, 
	0x13, 0x14, 0x12, 0x1d, 0x05, 0x05, 0x23, 0x1c, 
	0x0b, 0x01,    0,    0,    0,    0,    0,    0, 
	0x12, 0x12, 0x13, 0x13, 0x15, 0x14, 0x12, 0x12, 
	0x14, 0x12, 0x12, 0x13, 0x14, 0x13, 0x11, 0x0e, 
	0x0d, 0x10, 0x0e, 0x0e, 0x0f, 0x11, 0x12, 0x11, 
	0x0d, 0x0e, 0x12, 0x13, 0x1f, 0x12, 0x1c, 0x15, 
	0x15, 0x11, 0x13, 0x14, 0x12, 0x1d, 0x05, 0x05, 
	0x24, 0x0a, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x13, 0x12, 0x13, 0x13, 0x15, 0x14, 
	0x13, 0x13, 0x14, 0x12, 0x12, 0x13, 0x14, 0x14, 
	0x11, 0x0e, 0x0d, 0x10, 0x0e, 0x0e, 0x0f, 0x11, 
	0x12, 0x11, 0x0d, 0x0e, 0x12, 0x13, 0x1f, 0x12, 
	0x1c, 0x15, 0x15, 0x11, 0x13, 0x14, 0x12, 0x1d, 
	0x05, 0x05, 0x24, 0x0a, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x17, 0x0d, 0x17, 0x3d, 
	0x43, 0x18, 0x17, 0x43, 0x43, 0x40, 0x0e, 0x43, 
	0x10, 0x41, 0x0e, 0x0e, 0x0d, 0x0d, 0x0e, 0x0e, 
	0x0f, 0x36, 0x0e, 0x0d, 0x0d, 0x11, 0x3f, 0x3e, 
	0x0f, 0x3b, 0x1c, 0x40, 0x3f, 0x3b, 0x0f, 0x1c, 
	0x0f, 0x3b, 0x05, 0x05, 0x01, 0x06, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x17, 0x0d, 
	0x17, 0x3d, 0x44, 0x18, 0x17, 0x43, 0x43, 0x40, 
	0x0e, 0x44, 0x10, 0x41, 0x0e, 0x0e, 0x0d, 0x0d, 
	0x0e, 0x0e, 0x0f, 0x37, 0x0e, 0x0d, 0x0d, 0x11, 
	0x40, 0x3f, 0x10, 0x3b, 0x1c, 0x40, 0x3f, 0x3c, 
	0x0f, 0x1c, 0x0f, 0x3b, 0x05, 0x05, 0x01, 0x06, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x39, 0x37, 0x3c, 0x3e, 0x45, 0x3c, 0x3e, 0x44, 
	0x44, 0x41, 0x43, 0x45, 0x43, 0x42, 0x30, 0x2f, 
	0x0d, 0x2d, 0x12, 0x36, 0x38, 0x38, 0x2f, 0x2f, 
	0x0e, 0x33, 0x41, 0x40, 0x3e, 0x3c, 0x17, 0x41, 
	0x40, 0x3d, 0x36, 0x3a, 0x10, 0x3c, 0x05, 0x05, 
	0x01, 0x0b, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x39, 0x37, 0x3c, 0x3f, 0x45, 0x3d, 
	0x3e, 0x44, 0x45, 0x41, 0x44, 0x45, 0x44, 0x42, 
	0x30, 0x2f, 0x0d, 0x2d, 0x12, 0x36, 0x38, 0x38, 
	0x2f, 0x30, 0x0e, 0x33, 0x42, 0x40, 0x3e, 0x3d, 
	0x17, 0x41, 0x40, 0x3e, 0x37, 0x3b, 0x10, 0x3d, 
	0x05, 0x05, 0x01, 0x0b, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x20, 0x38, 0x3d, 0x40, 
	0x46, 0x3e, 0x22, 0x18, 0x46, 0x42, 0x45, 0x46, 
	0x45, 0x19,    0, 0x06,    0, 0x1b, 0x11,    0, 
	   0, 0x20, 0x1d, 0x1c,    0, 0x12, 0x43, 0x41, 
	0x3f, 0x0f, 0x40, 0x42, 0x41, 0x15, 0x38, 0x3c, 
	0x34, 0x3e, 0x05, 0x05, 0x01, 0x0a, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x20, 0x38, 
	0x3d, 0x40, 0x46, 0x3e, 0x23, 0x18, 0x46, 0x43, 
	0x45, 0x46, 0x45, 0x1a,    0, 0x06,    0, 0x1b, 
	0x11,    0,    0, 0x20, 0x1d, 0x1c,    0, 0x12, 
	0x43, 0x41, 0x40, 0x0f, 0x40, 0x42, 0x41, 0x15, 
	0x38, 0x3c, 0x34, 0x3e, 0x05, 0x05, 0x01, 0x0a, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x20, 0x38, 0x3d, 0x40, 0x46, 0x3e, 0x22, 0x24, 
	0x47, 0x44, 0x46, 0x47, 0x46, 0x25,    0, 0x06, 
	   0, 0x1b, 0x11,    0,    0, 0x20, 0x1d, 0x1c, 
	   0, 0x12, 0x44, 0x42, 0x41, 0x20, 0x24, 0x43, 
	0x42, 0x1f, 0x1f, 0x20, 0x15, 0x3f, 0x05, 0x05, 
	0x01, 0x0a, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x20, 0x38, 0x3d, 0x40, 0x46, 0x3e, 
	0x23, 0x24, 0x47, 0x45, 0x46, 0x47, 0x46, 0x26, 
	   0, 0x06,    0, 0x1b, 0x11,    0,    0, 0x20, 
	0x1d, 0x1c,    0, 0x12, 0x44, 0x42, 0x42, 0x20, 
	0x24, 0x43, 0x42, 0x1f, 0x1f, 0x20, 0x15, 0x3f, 
	0x05, 0x05, 0x01, 0x0a, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x3a, 0x39, 0x3e, 0x41, 
	0x47, 0x3f, 0x3f, 0x45, 0x48, 0x46, 0x47, 0x48, 
	0x47, 0x43, 0x31, 0x0e, 0x0d, 0x10, 0x0e, 0x37, 
	0x39, 0x11, 0x12, 0x0d, 0x0d, 0x11, 0x45, 0x01, 
	0x43, 0x3e, 0x16, 0x44, 0x43,    0, 0x39, 0x3d, 
	0x35, 0x40, 0x05, 0x05, 0x01, 0x0b, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x3a, 0x39, 
	0x3e, 0x41, 0x47, 0x3f, 0x40, 0x46, 0x48, 0x47, 
	0x47, 0x48, 0x47, 0x44, 0x31, 0x0e, 0x0d, 0x10, 
	0x0e, 0x37, 0x39, 0x11, 0x12, 0x0d, 0x0d, 0x11, 
	0x45, 0x01, 0x43, 0x3e, 0x16, 0x44, 0x43,    0, 
	0x39, 0x3d, 0x35, 0x40, 0x05, 0x05, 0x01, 0x0b, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x3b, 0x3a, 0x3f, 0x42, 0x48, 0x40, 0x41, 0x47, 
	0x49, 0x48, 0x48, 0x49, 0x48, 0x45, 0x32, 0x30, 
	0x30, 0x2e, 0x35, 0x38, 0x3a, 0x39, 0x30, 0x31, 
	0x2a, 0x34, 0x46, 0x43, 0x44, 0x3f, 0x41, 0x45, 
	0x44, 0x3f, 0x3a, 0x3e, 0x36, 0x41, 0x05, 0x05, 
	0x07, 0x06, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x3c, 0x3b, 0x40, 0x43, 0x49, 0x41, 
	0x42, 0x48, 0x4a, 0x49, 0x49, 0x4a, 0x49, 0x46, 
	0x33, 0x31, 0x31, 0x2f, 0x36, 0x39, 0x3b, 0x3a, 
	0x31, 0x32, 0x2b, 0x35, 0x47, 0x44, 0x45, 0x40, 
	0x42, 0x46, 0x45, 0x40, 0x3b, 0x3f, 0x37, 0x42, 
	0x05, 0x05, 0x07, 0x06, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x3d, 0x3c, 0x41, 0x0a, 
	0x4a, 0x42, 0x43, 0x49, 0x4b, 0x4a, 0x4a, 0x4b, 
	0x4a, 0x47, 0x34, 0x32, 0x32, 0x30, 0x37, 0x3a, 
	0x3c, 0x3b, 0x32, 0x33, 0x2c, 0x36, 0x48, 0x45, 
	0x46, 0x41, 0x43, 0x47, 0x46, 0x41, 0x3c, 0x40, 
	0x38, 0x43, 0x05, 0x05, 0x07, 0x06, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x3b, 0x3a, 
	0x42, 0x42, 0x48, 0x40, 0x44, 0x47, 0x49, 0x48, 
	0x48, 0x49, 0x48, 0x45, 0x32, 0x30, 0x30, 0x2e, 
	0x35, 0x38, 0x3a, 0x39, 0x30, 0x31, 0x2a, 0x34, 
	0x49, 0x46, 0x47, 0x42, 0x44, 0x48, 0x47, 0x42, 
	0x3d, 0x41, 0x39, 0x44, 0x05, 0x05, 0x07, 0x06, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x3d, 0x3c, 0x43, 0x0a, 0x4a, 0x42, 0x09, 0x49, 
	0x4b, 0x4a, 0x4a, 0x4b, 0x4a, 0x47, 0x34, 0x32, 
	0x32, 0x30, 0x37, 0x3a, 0x3c, 0x3b, 0x32, 0x33, 
	0x2c, 0x36, 0x4a, 0x47, 0x48, 0x43, 0x45, 0x49, 
	0x48, 0x43, 0x3e, 0x42, 0x3a, 0x45, 0x05, 0x05, 
	0x07, 0x06, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x3e, 0x3d, 0x44, 0x44, 0x4b, 0x43, 
	0x45, 0x4a, 0x4c, 0x4b, 0x4b, 0x4c, 0x4b, 0x48, 
	0x35, 0x33, 0x33, 0x31, 0x38, 0x3b, 0x3d, 0x3c, 
	0x33, 0x34, 0x2d, 0x37, 0x4b, 0x48, 0x49, 0x44, 
	0x46, 0x4a, 0x49, 0x44, 0x3f, 0x43, 0x3b, 0x46, 
	0x05, 0x05, 0x25, 0x0b, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x10, 0x10, 0x45, 0x11, 
	0x4c, 0x44, 0x10, 0x4b, 0x4d, 0x4c, 0x4c, 0x4d, 
	0x4c, 0x11, 0x11, 0x0e, 0x0d, 0x10, 0x22, 0x22, 
	0x24, 0x11, 0x12, 0x11, 0x0d, 0x11, 0x28, 0x28, 
	0x4a, 0x1a, 0x47, 0x4b, 0x4a, 0x11, 0x13, 0x26, 
	0x12, 0x13, 0x05, 0x05, 0x0b, 0x06,    0, 0x07, 
	   0,    0,    0,    0,    0,    0, 0x10, 0x10, 
	0x45, 0x11, 0x4d, 0x44, 0x10, 0x4c, 0x4d, 0x4c, 
	0x4c, 0x4e, 0x4c, 0x11, 0x11, 0x0e, 0x0d, 0x10, 
	0x23, 0x23, 0x25, 0x11, 0x12, 0x11, 0x0d, 0x11, 
	0x29, 0x29, 0x4a, 0x1b, 0x48, 0x4c, 0x4b, 0x11, 
	0x13, 0x27, 0x12, 0x13, 0x05, 0x05, 0x0c, 0x06, 
	   0, 0x07,    0,    0,    0,    0,    0,    0, 
	0x3f, 0x37, 0x46, 0x45, 0x4e, 0x45, 0x3e, 0x4d, 
	0x4e, 0x4d, 0x4d, 0x4f, 0x4d, 0x42, 0x11, 0x0e, 
	0x0d, 0x10, 0x12, 0x0e, 0x0f, 0x3d, 0x12, 0x11, 
	0x0d, 0x11, 0x12, 0x13, 0x4a, 0x12, 0x17, 0x4d, 
	0x4c, 0x45, 0x13, 0x14, 0x12, 0x13, 0x05, 0x05, 
	0x01, 0x06, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x3f, 0x37, 0x46, 0x45, 0x4f, 0x45, 
	0x3e, 0x4d, 0x4e, 0x4d, 0x4d, 0x50, 0x4d, 0x42, 
	0x11, 0x0e, 0x0d, 0x10, 0x12, 0x0e, 0x0f, 0x3d, 
	0x12, 0x11, 0x0d, 0x11, 0x12, 0x13, 0x4a, 0x12, 
	0x17, 0x4d, 0x4c, 0x45, 0x13, 0x14, 0x12, 0x13, 
	0x05, 0x05, 0x01, 0x06, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x40, 0x3e, 0x47, 0x46, 
	0x50, 0x46, 0x46, 0x4e, 0x4f, 0x4e, 0x4e, 0x51, 
	0x4e, 0x49,    0, 0x34,    0, 0x32, 0x0d, 0x3c, 
	0x3e, 0x3e, 0x34, 0x35, 0x2e, 0x38, 0x4c, 0x49, 
	0x1f, 0x45, 0x17, 0x4e, 0x4d, 0x46, 0x40, 0x44, 
	0x3c, 0x47, 0x0f, 0x0f, 0x26, 0x1d, 0x0c, 0x0e, 
	   0,    0,    0,    0,    0,    0, 0x40, 0x3f, 
	0x47, 0x47, 0x50, 0x46, 0x46, 0x4e, 0x50, 0x4f, 
	0x4f, 0x51, 0x4e, 0x4a,    0, 0x34,    0, 0x32, 
	0x0d, 0x3c, 0x3e, 0x3e, 0x34, 0x35, 0x2f, 0x38, 
	0x4c, 0x49, 0x1f, 0x45, 0x17, 0x4e, 0x4d, 0x46, 
	0x40, 0x44, 0x3d, 0x47, 0x0f, 0x0f, 0x26, 0x1d, 
	0x0c, 0x0e,    0,    0,    0,    0,    0,    0, 
	0x3f, 0x37, 0x48, 0x45, 0x4e, 0x45, 0x47, 0x4d, 
	0x51, 0x50, 0x4d, 0x52, 0x4f, 0x4b, 0x11, 0x0e, 
	0x0d, 0x10, 0x12, 0x0e, 0x0f, 0x3d, 0x12, 0x11, 
	0x0d, 0x11, 0x12, 0x13, 0x07, 0x12, 0x17, 0x15, 
	0x15, 0x45, 0x41, 0x45, 0x3e, 0x48, 0x05, 0x05, 
	0x01, 0x1e, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x3f, 0x37, 0x48, 0x45, 0x4f, 0x45, 
	0x47, 0x4d, 0x51, 0x50, 0x4d, 0x53, 0x4f, 0x4b, 
	0x11, 0x0e, 0x0d, 0x10, 0x12, 0x0e, 0x0f, 0x3d, 
	0x12, 0x11, 0x0d, 0x11, 0x12, 0x13, 0x07, 0x12, 
	0x17, 0x15, 0x15, 0x45, 0x41, 0x45, 0x3e, 0x48, 
	0x05, 0x05, 0x01, 0x1e, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x31, 0x30, 0x49, 0x37, 
	0x3b, 0x35, 0x48, 0x4f, 0x52, 0x51, 0x3c, 0x54, 
	0x50, 0x4c, 0x2d, 0x35, 0x2d, 0x2b, 0x30, 0x32, 
	0x34, 0x32, 0x2d, 0x2c, 0x30, 0x39, 0x4d, 0x4a, 
	0x3a, 0x39, 0x3b, 0x4f, 0x4e, 0x36, 0x42, 0x46, 
	0x3f, 0x49, 0x05, 0x05, 0x27, 0x1e, 0x01, 0x01, 
	   0,    0,    0,    0,    0,    0, 0x32, 0x31, 
	0x4a, 0x38, 0x3c, 0x36, 0x49, 0x50, 0x53, 0x52, 
	0x3d, 0x55, 0x51, 0x4d, 0x2e, 0x36, 0x09, 0x09, 
	0x31, 0x33, 0x35, 0x0a, 0x0a, 0x0a, 0x31, 0x3a, 
	0x4e, 0x4b, 0x0b, 0x0c, 0x3c, 0x50, 0x4f, 0x0b, 
	0x43, 0x47, 0x40, 0x4a, 0x05, 0x05, 0x27, 0x1e, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x41, 0x40, 0x4b, 0x13, 0x15, 0x14, 0x4a, 0x51, 
	0x54, 0x53, 0x12, 0x13, 0x14, 0x4e, 0x11, 0x0e, 
	0x0d, 0x10, 0x12, 0x0e, 0x0f, 0x11, 0x12, 0x11, 
	0x0d, 0x11, 0x33, 0x33, 0x1f, 0x12, 0x17, 0x15, 
	0x15, 0x47, 0x13, 0x14, 0x12, 0x13, 0x05, 0x05, 
	0x28, 0x0b, 0x08, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x42, 0x41, 0x4b, 0x13, 0x15, 0x14, 
	0x4b, 0x52, 0x55, 0x53, 0x12, 0x13, 0x14, 0x4f, 
	0x11, 0x0e, 0x0d, 0x10, 0x12, 0x0e, 0x0f, 0x11, 
	0x12, 0x11, 0x0d, 0x11, 0x33, 0x33, 0x1f, 0x12, 
	0x17, 0x15, 0x15, 0x47, 0x13, 0x14, 0x12, 0x13, 
	0x05, 0x05, 0x28, 0x0b, 0x08, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x43, 0x42, 0x4c, 0x48, 
	0x51, 0x47, 0x4c, 0x53, 0x56, 0x54, 0x50, 0x56, 
	0x52, 0x50, 0x36, 0x37, 0x34, 0x33, 0x39, 0x3d, 
	0x3f, 0x3f, 0x35, 0x36, 0x32, 0x3b, 0x4f, 0x4c, 
	0x4b, 0x46, 0x49, 0x51, 0x50, 0x48, 0x44, 0x48, 
	0x41, 0x4b, 0x10, 0x10, 0x04, 0x04, 0x04, 0x03, 
	   0,    0,    0,    0,    0,    0, 0x44, 0x43, 
	0x4d, 0x49, 0x52, 0x48, 0x4d, 0x54, 0x57, 0x55, 
	0x51, 0x57, 0x53, 0x51, 0x37, 0x38, 0x35, 0x34, 
	0x3a, 0x3e, 0x40, 0x40, 0x36, 0x37, 0x33, 0x3c, 
	0x50, 0x4d, 0x4c, 0x47, 0x4a, 0x52, 0x51, 0x49, 
	0x45, 0x49, 0x42, 0x4c, 0x11, 0x11, 0x09, 0x08, 
	0x04, 0x03,    0,    0,    0,    0,    0,    0, 
	0x45, 0x44, 0x4e, 0x4a, 0x53, 0x49, 0x4e, 0x55, 
	0x58, 0x56, 0x52, 0x58, 0x54, 0x52, 0x38, 0x39, 
	0x36, 0x35, 0x3b, 0x3f, 0x41, 0x41, 0x37, 0x38, 
	0x34, 0x3d, 0x51, 0x4e, 0x4d, 0x48, 0x4b, 0x53, 
	0x52, 0x4a, 0x46, 0x4a, 0x43, 0x4d,    0,    0, 
	0x29, 0x1f,    0,    0, 0x02,    0, 0x02,    0, 
	0x02, 0x01, 0x46, 0x45, 0x4f, 0x4b, 0x54, 0x4a, 
	0x4f, 0x56, 0x59, 0x57, 0x53, 0x59, 0x55, 0x53, 
	0x39, 0x3a, 0x37, 0x36, 0x3c, 0x40, 0x42, 0x42, 
	0x38, 0x39, 0x35, 0x3e, 0x52, 0x4f, 0x4e, 0x49, 
	0x4c, 0x54, 0x53, 0x4b, 0x47, 0x4b, 0x44, 0x4e, 
	   0,    0, 0x29, 0x1f,    0,    0, 0x03,    0, 
	0x02,    0, 0x03, 0x02, 0x47, 0x46, 0x50, 0x02, 
	0x55, 0x4b, 0x50, 0x57, 0x5a, 0x58, 0x02, 0x5a, 
	0x56, 0x54, 0x3a, 0x3b, 0x38, 0x37, 0x3d, 0x41, 
	0x43, 0x43, 0x39, 0x3a, 0x36, 0x3f, 0x53, 0x50, 
	0x4f, 0x4a, 0x4d, 0x55, 0x54, 0x4c, 0x48, 0x4c, 
	0x45, 0x4f, 0x12, 0x12, 0x2a, 0x02, 0x02,    0, 
	   0,    0,    0,    0,    0,    0, 0x47, 0x46, 
	0x50, 0x02, 0x55, 0x4b, 0x50, 0x57, 0x5a, 0x58, 
	0x02, 0x5a, 0x56, 0x54, 0x01, 0x01, 0x01, 0x01, 
	0x02, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 
	0x01, 0x02, 0x01, 0x02, 0x12, 0x12, 0x2a, 0x02, 
	0x02,    0,    0,    0,    0,    0,    0,    0, 
	0x48, 0x1d, 0x21, 0x4c, 0x56, 0x4c, 0x2b, 0x58, 
	0x5b, 0x24, 0x54, 0x5b, 0x57, 0x55, 0x3b, 0x24, 
	   0, 0x1b,    0, 0x42, 0x44, 0x20,    0, 0x01, 
	0x37, 0x30, 0x54, 0x51, 0x50, 0x20, 0x4e, 0x56, 
	0x55, 0x1f, 0x49, 0x4d, 0x46, 0x50,    0,    0, 
	0x0e,    0, 0x02,    0,    0,    0,    0,    0, 
	   0,    0, 0x49, 0x47, 0x51, 0x4d, 0x57, 0x4d, 
	0x51, 0x59, 0x5c, 0x59, 0x55, 0x5c, 0x58, 0x56, 
	0x3c, 0x3c,    0, 0x38,    0, 0x43, 0x45, 0x44, 
	0x3a, 0x3b, 0x38, 0x40, 0x55, 0x52, 0x0e, 0x4b, 
	0x4f, 0x57, 0x56, 0x4d, 0x4a, 0x4e, 0x47, 0x51, 
	0x13, 0x13, 0x01, 0x0a, 0x01,    0,    0,    0, 
	   0,    0,    0,    0, 0x49, 0x47, 0x51, 0x4e, 
	0x58, 0x4d, 0x51, 0x59, 0x5c, 0x5a, 0x56, 0x5d, 
	0x58, 0x56, 0x3c, 0x3d,    0, 0x38,    0, 0x43, 
	0x45, 0x45, 0x3a, 0x3b, 0x38, 0x40, 0x55, 0x53, 
	0x0e, 0x4b, 0x50, 0x57, 0x56, 0x4e, 0x4b, 0x4e, 
	0x48, 0x52, 0x14, 0x14, 0x01, 0x0a, 0x01,    0, 
	   0,    0,    0,    0,    0,    0, 0x4a, 0x48, 
	0x52, 0x4f, 0x59, 0x4e, 0x52, 0x5a, 0x5d, 0x5b, 
	0x57, 0x5e, 0x59, 0x57, 0x34, 0x32, 0x32, 0x30, 
	0x37, 0x3a, 0x3c, 0x3b, 0x32, 0x33, 0x2c, 0x36, 
	0x48, 0x45, 0x46, 0x41, 0x43, 0x47, 0x46, 0x41, 
	0x3c, 0x40, 0x38, 0x43, 0x05, 0x05, 0x07, 0x06, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x4b, 0x3a, 0x3f, 0x42, 0x48, 0x40, 0x41, 0x5b, 
	0x5e, 0x5c, 0x58, 0x5f, 0x5a, 0x58, 0x3d, 0x3e, 
	0x39, 0x39, 0x3e, 0x44, 0x46, 0x46, 0x3b, 0x3c, 
	0x39, 0x41, 0x56, 0x54, 0x51, 0x4c, 0x51, 0x58, 
	0x57, 0x4f, 0x4c, 0x4f, 0x49, 0x53, 0x05, 0x05, 
	0x07, 0x06, 0x01, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x4c, 0x3c, 0x41, 0x0a, 0x4a, 0x42, 
	0x43, 0x5c, 0x5f, 0x5d, 0x59, 0x60, 0x5b, 0x0a, 
	0x3e, 0x08, 0x3a, 0x3a, 0x08, 0x45, 0x47, 0x47, 
	0x3c, 0x3d, 0x3a, 0x42, 0x57, 0x55, 0x52, 0x4d, 
	0x0d, 0x59, 0x58, 0x50, 0x4d, 0x50, 0x4a, 0x54, 
	0x05, 0x05, 0x07, 0x06, 0x01, 0x01,    0,    0, 
	   0,    0,    0,    0, 0x4d, 0x49, 0x53, 0x50, 
	0x5a, 0x4f, 0x53, 0x5d, 0x60, 0x5e, 0x5a, 0x61, 
	0x1c, 0x59, 0x3f, 0x3f, 0x3b, 0x3b, 0x3f, 0x46, 
	0x48, 0x48, 0x3d, 0x3e, 0x3b, 0x43, 0x58, 0x56, 
	0x53, 0x4e, 0x52, 0x5a, 0x59, 0x51, 0x4e, 0x51, 
	0x4b, 0x55, 0x04, 0x15, 0x2b, 0x02,    0, 0x0f, 
	   0,    0,    0,    0,    0,    0, 0x4e, 0x4a, 
	0x54, 0x51, 0x5b, 0x50, 0x54, 0x5e, 0x61, 0x5f, 
	0x5b, 0x62, 0x5c, 0x5a, 0x40, 0x06,    0,    0, 
	   0, 0x47, 0x49, 0x49, 0x06, 0x01, 0x06, 0x07, 
	0x07, 0x07, 0x07, 0x08, 0x0b, 0x09, 0x09, 0x45, 
	0x4f, 0x07, 0x06, 0x07, 0x05, 0x05, 0x2c, 0x01, 
	0x01, 0x01,    0,    0,    0,    0,    0,    0, 
	0x4f, 0x4b, 0x55, 0x52, 0x5c, 0x51, 0x55, 0x5f, 
	0x62, 0x60, 0x5c, 0x63, 0x5d, 0x5b, 0x41, 0x40, 
	0x3c, 0x3c, 0x40, 0x48, 0x4a, 0x4a, 0x3e, 0x3f, 
	0x3c, 0x44, 0x59, 0x57, 0x54, 0x4f, 0x53, 0x5b, 
	0x5a, 0x52, 0x50, 0x52, 0x4c, 0x56, 0x05, 0x05, 
	0x2d, 0x08, 0x0d, 0x01,    0,    0,    0,    0, 
	   0,    0, 0x50, 0x4c, 0x56, 0x0e, 0x5d, 0x52, 
	0x56, 0x60, 0x63, 0x61, 0x5d, 0x64, 0x5e, 0x5c, 
	0x42, 0x41, 0x3d, 0x18, 0x15, 0x49, 0x4b, 0x4b, 
	0x0e, 0x0d, 0x3d, 0x11, 0x5a, 0x58, 0x55, 0x50, 
	0x0b, 0x5c, 0x5b, 0x53, 0x51, 0x53, 0x4d, 0x57, 
	   0,    0, 0x2e, 0x02,    0,    0,    0,    0, 
	   0,    0,    0,    0, 0x51, 0x4c, 0x57, 0x0e, 
	0x5d, 0x52, 0x56, 0x61, 0x63, 0x62, 0x5d, 0x64, 
	0x5e, 0x5c, 0x42, 0x41, 0x3e, 0x18, 0x15, 0x49, 
	0x4b, 0x4b, 0x0e, 0x0d, 0x3e, 0x11, 0x5b, 0x59, 
	0x56, 0x50, 0x0b, 0x5c, 0x5b, 0x53, 0x51, 0x54, 
	0x4e, 0x57,    0,    0, 0x2e, 0x02,    0,    0, 
	   0,    0,    0,    0,    0,    0, 0x52, 0x4d, 
	0x58, 0x53, 0x5e, 0x53, 0x57, 0x62, 0x64, 0x63, 
	0x5e, 0x65, 0x5f, 0x28, 0x43, 0x42, 0x3f, 0x3d, 
	0x41, 0x4a, 0x4c, 0x4c, 0x3f, 0x40, 0x3f, 0x45, 
	0x5c, 0x5a, 0x57, 0x51, 0x54, 0x26, 0x25, 0x54, 
	0x52, 0x55, 0x4f, 0x25,    0,    0, 0x17, 0x01, 
	   0, 0x0a,    0,    0,    0,    0,    0,    0, 
	0x53, 0x4e, 0x59, 0x54, 0x5f, 0x54, 0x58, 0x63, 
	0x65, 0x64, 0x5f, 0x66, 0x60, 0x29, 0x44, 0x43, 
	0x40, 0x3e, 0x42, 0x4b, 0x4d, 0x4d, 0x40, 0x41, 
	0x40, 0x46, 0x5d, 0x5b, 0x58, 0x52, 0x55, 0x27, 
	0x26, 0x55, 0x53, 0x56, 0x50, 0x26,    0,    0, 
	0x17, 0x01,    0, 0x0a,    0,    0,    0,    0, 
	   0,    0, 0x29, 0x4f, 0x5a, 0x55, 0x60, 0x55, 
	0x59, 0x64, 0x66, 0x65, 0x60, 0x67, 0x61, 0x5d, 
	0x26, 0x25, 0x26, 0x25, 0x29, 0x29, 0x2b, 0x2b, 
	0x26, 0x25, 0x21, 0x27, 0x5e, 0x5c, 0x59, 0x53, 
	0x56, 0x5d, 0x5c, 0x56, 0x54, 0x57, 0x51, 0x58, 
	0x15, 0x16, 0x2f, 0x15, 0x0e, 0x10,    0,    0, 
	   0,    0,    0,    0, 0x29, 0x4f, 0x5a, 0x55, 
	0x60, 0x55, 0x59, 0x64, 0x66, 0x65, 0x60, 0x67, 
	0x61, 0x5d, 0x45, 0x44, 0x41, 0x3f, 0x43, 0x4c, 
	0x4e, 0x4e, 0x41, 0x25, 0x21, 0x27, 0x5e, 0x5c, 
	0x59, 0x53, 0x56, 0x5d, 0x5c, 0x56, 0x54, 0x57, 
	0x51, 0x58, 0x15, 0x16, 0x30, 0x20, 0x0f, 0x11, 
	   0,    0,    0,    0,    0,    0, 0x54, 0x50, 
	0x5b, 0x56, 0x61, 0x56, 0x5a, 0x64, 0x66, 0x65, 
	0x60, 0x67, 0x61, 0x5d, 0x46, 0x45, 0x42, 0x40, 
	0x44, 0x4d, 0x4f, 0x4f, 0x42, 0x42, 0x41, 0x47, 
	0x5e, 0x5c, 0x59, 0x53, 0x56, 0x5d, 0x5c, 0x56, 
	0x54, 0x57, 0x51, 0x58, 0x15, 0x16, 0x31, 0x15, 
	0x10, 0x01,    0,    0,    0,    0,    0,    0, 
	0x29, 0x4f, 0x5a, 0x55, 0x60, 0x55, 0x59, 0x65, 
	0x67, 0x66, 0x61, 0x68, 0x62, 0x5e, 0x26, 0x25, 
	0x26, 0x25, 0x29, 0x29, 0x2b, 0x2b, 0x26, 0x25, 
	0x21, 0x27, 0x5e, 0x5c, 0x59, 0x53, 0x56, 0x5d, 
	0x5c, 0x56, 0x54, 0x57, 0x51, 0x58, 0x15, 0x16, 
	0x32, 0x21, 0x09, 0x12,    0,    0,    0,    0, 
	   0,    0, 
},
{	/* lc_time_item_offsets */
	     0, 0x0055, 0x00a6, 0x0102, 0x0159, 0x01bb, 0x0212, 0x026d, 
	0x02d3, 0x033b, 0x03a2, 0x0404, 0x046d, 0x04d0, 0x052f, 0x0576, 
	0x05bc, 0x05ff, 0x0640, 0x0685, 0x06d3, 0x0723, 0x0773, 0x07b6, 
	0x07f9, 0x083b, 0x0883, 0x08e2, 0x093f, 0x0999, 0x09ed, 0x0a44, 
	0x0aa2, 0x0aff, 0x0b56, 0x0bab, 0x0c03, 0x0c55, 0x0cae, 0x0cc4, 
	0x0cdb, 0x0d0e, 0x0d30, 0x0d41, 0x0d54, 0x0d58, 0x0d59, 0x0d5c, 
	0x0d5e, 0x0d62, 
},
{	/* lc_time_item_idx */
	0x0001, 0x0111, 0x01cf, 0x034c, 0x044d, 0x035a, 0x0462, 0x07b9, 
	0x092c, 0x0a22, 0x0bca, 0x0cb5, 0x0e16, 0x112d, 0x121b, 0x12c6, 
	0x139f, 0x1541, 0x161e, 0x16e2, 0x16fc, 0x1798, 0x1890, 0x1b1a, 
	0x1bd5, 0x1c8e, 0x1d95, 0x1e9e, 0x2022, 0x21b0, 0x2341, 0x2543, 
	0x26c1, 0x2792, 0x28c2, 0x2990, 0x2ab9, 0x2d56, 0x2eaa, 0x2f9e, 
	0x3160, 0x3405, 0x3a53, 0x3b55, 0x1b28, 0x3ec2, 0x40fc, 0x4280, 
	0x43d5, 0x459b, 0x4681, 0x4730, 0x48e5, 0x492f, 0x4a27, 0x4a7b, 
	0x4ae8, 0x4c17, 0x11ed, 0x4ef5, 0x4fd1, 0x50ad, 0x5320, 0x54d0, 
	0x5532, 0x584f, 0x5898, 0x58bf, 0x5a5d, 0x5c71, 0x5dd3, 0x6062, 
	0x61c1, 0x625f, 0x638b, 0x6429, 0x64f4, 0x663f, 0x671b, 0x679c, 
	0x6934, 0x69fa, 0x6a44, 0x6b22, 0x6cc4, 0x0005, 0x0114, 0x01d9, 
	0x034e, 0x0450, 0x0360, 0x046d, 0x07bd, 0x0930, 0x0a29, 0x0bcd, 
	0x0cba, 0x0e20, 0x1131, 0x121f, 0x12c9, 0x13a2, 0x1545, 0x1622, 
	0x179c, 0x1897, 0x1c90, 0x1d99, 0x1ea2, 0x2025, 0x21b4, 0x2233, 
	0x2346, 0x2548, 0x26c5, 0x2796, 0x28c5, 0x2994, 0x2ac4, 0x2d58, 
	0x2eae, 0x2fa5, 0x083b, 0x31ca, 0x32a7, 0x3409, 0x3a57, 0x3b5f, 
	0x3ded, 0x3ec6, 0x40ff, 0x4283, 0x4373, 0x459f, 0x4688, 0x473a, 
	0x48e9, 0x4933, 0x4aec, 0x4b6b, 0x4c1b, 0x4d50, 0x4e3d, 0x4ef9, 
	0x4fd5, 0x50b4, 0x5325, 0x5537, 0x5642, 0x5853, 0x589d, 0x58c3, 
	0x5a67, 0x5c75, 0x5ddb, 0x606f, 0x6263, 0x6392, 0x664a, 0x11ed, 
	0x67a0, 0x6938, 0x6a49, 0x6b2a, 0x6cac, 0x6cce, 0x0009, 0x0117, 
	0x01e0, 0x0350, 0x0453, 0x0368, 0x047c, 0x07c1, 0x0934, 0x0a30, 
	0x0bd0, 0x0cbf, 0x0e2a, 0x1135, 0x1223, 0x12cc, 0x13a5, 0x1487, 
	0x1549, 0x1626, 0x1700, 0x17a0, 0x189e, 0x131f, 0x1c92, 0x1d9d, 
	0x1ea6, 0x2028, 0x21b8, 0x2238, 0x234b, 0x2455, 0x254d, 0x005e, 
	0x279a, 0x28c8, 0x2998, 0x2acf, 0x2d5a, 0x2eb2, 0x2fac, 0x3164, 
	0x31ce, 0x32ac, 0x340d, 0x3a5b, 0x3b69, 0x3eca, 0x4018, 0x4102, 
	0x4286, 0x4377, 0x43d8, 0x44fb, 0x45a3, 0x468f, 0x4744, 0x4937, 
	0x4a7e, 0x4af0, 0x4c1f, 0x4d54, 0x0114, 0x4efd, 0x4fd9, 0x50bb, 
	0x5238, 0x528c, 0x532a, 0x5483, 0x162e, 0x553c, 0x5687, 0x56ef, 
	0x5777, 0x5857, 0x58c7, 0x5a71, 0x5c78, 0x5de0, 0x6079, 0x6267, 
	0x6399, 0x6651, 0x671f, 0x67a6, 0x693c, 0x69ff, 0x6a4f, 0x6b34, 
	0x6cb0, 0x6cd8, 0x000d, 0x011a, 0x01ed, 0x0352, 0x0456, 0x0371, 
	0x048d, 0x07c5, 0x08ad, 0x0938, 0x0a37, 0x0bd3, 0x0cc4, 0x0e37, 
	0x1139, 0x1227, 0x12cf, 0x13a8, 0x154d, 0x162a, 0x1704, 0x17a4, 
	0x18a5, 0x1bd9, 0x1c71, 0x1c94, 0x1da1, 0x1eaa, 0x202b, 0x21bc, 
	0x2351, 0x245c, 0x2551, 0x26c9, 0x276b, 0x279e, 0x28cb, 0x299c, 
	0x2add, 0x2d5c, 0x2eb6, 0x2fb3, 0x3168, 0x31d2, 0x32b1, 0x3411, 
	0x3a5f, 0x3b73, 0x3df1, 0x3ece, 0x401c, 0x4105, 0x4289, 0x437b, 
	0x43db, 0x45a7, 0x4696, 0x4751, 0x493b, 0x4a81, 0x4af4, 0x4b8b, 
	0x4c23, 0x4ce6, 0x4d58, 0x4e40, 0x4f01, 0x4fdd, 0x532f, 0x54d4, 
	0x5541, 0x5648, 0x58cb, 0x5a7e, 0x5c7b, 0x5de5, 0x61c5, 0x626b, 
	0x6325, 0x63a0, 0x665a, 0x6722, 0x67ac, 0x6a54, 0x6b3c, 0x6cb4, 
	0x6ce2, 0x0011, 0x011d, 0x01f7, 0x0354, 0x0459, 0x037a, 0x049e, 
	0x07c9, 0x08b4, 0x093c, 0x0a3e, 0x0bd6, 0x0cc9, 0x0e41, 0x113d, 
	0x122b, 0x12b7, 0x12d2, 0x13ab, 0x148b, 0x1551, 0x162e, 0x1708, 
	0x17a8, 0x18ac, 0x1b1e, 0x1bdd, 0x1c96, 0x1da5, 0x1eae, 0x202e, 
	0x21c0, 0x223d, 0x227b, 0x2356, 0x2462, 0x2555, 0x26cd, 0x27a3, 
	0x28ce, 0x29a0, 0x2ae8, 0x2d60, 0x2eba, 0x2fba, 0x316c, 0x31d6, 
	0x3349, 0x3415, 0x3a63, 0x3b7d, 0x3df5, 0x3ed2, 0x4020, 0x4108, 
	0x428c, 0x437f, 0x43de, 0x44ff, 0x45ab, 0x469d, 0x475b, 0x48ed, 
	0x493f, 0x4a2c, 0x4a84, 0x4af8, 0x4b8f, 0x4bed, 0x4c27, 0x4d5c, 
	0x4e43, 0x4f05, 0x4fe1, 0x50c2, 0x5334, 0x5486, 0x4217, 0x54d8, 
	0x5524, 0x5546, 0x58cf, 0x5a88, 0x5c7e, 0x5dea, 0x6083, 0x61c9, 
	0x626f, 0x632b, 0x63a9, 0x6661, 0x6726, 0x67b2, 0x6940, 0x6a59, 
	0x6b44, 0x6cb8, 0x6cec, 0x0015, 0x0120, 0x0201, 0x0356, 0x045c, 
	0x0381, 0x04ab, 0x07cd, 0x08b9, 0x0940, 0x0a45, 0x0bd9, 0x0cce, 
	0x0e5a, 0x1141, 0x122f, 0x12d5, 0x13ae, 0x148f, 0x1555, 0x1632, 
	0x170c, 0x17ac, 0x18b3, 0x1b24, 0x1be1, 0x1c98, 0x1da9, 0x1eb2, 
	0x2031, 0x21c4, 0x2242, 0x235b, 0x255a, 0x26d1, 0x27a8, 0x28d1, 
	0x29a4, 0x2af6, 0x2d63, 0x2ebe, 0x2fc1, 0x3170, 0x31da, 0x32b6, 
	0x3419, 0x3a67, 0x3b87, 0x3df9, 0x3ed6, 0x410b, 0x428f, 0x43e2, 
	0x45af, 0x46a4, 0x4768, 0x4943, 0x4a31, 0x4a87, 0x4afc, 0x4c2b, 
	0x4ceb, 0x4d60, 0x4e46, 0x4f09, 0x4fe5, 0x50c9, 0x5339, 0x5489, 
	0x54dc, 0x554b, 0x58cf, 0x5a95, 0x5c82, 0x5df2, 0x608d, 0x61cd, 
	0x6273, 0x63b2, 0x1f0a, 0x672a, 0x67b8, 0x6944, 0x6a5f, 0x6b4e, 
	0x6cbc, 0x6cf6, 0x0019, 0x0123, 0x020b, 0x0358, 0x045f, 0x05a8, 
	0x05ae, 0x07d1, 0x0944, 0x0a4c, 0x0bdc, 0x0cd3, 0x0e6a, 0x1145, 
	0x1233, 0x12d8, 0x0111, 0x1559, 0x1636, 0x16e7, 0x1710, 0x17b0, 
	0x18ba, 0x1b28, 0x1be5, 0x1c76, 0x1c9a, 0x1dad, 0x1eb6, 0x2034, 
	0x21c8, 0x227f, 0x2361, 0x255f, 0x26d5, 0x2770, 0x27ac, 0x28d4, 
	0x29a8, 0x2b07, 0x2d65, 0x2ec2, 0x2fc8, 0x3174, 0x31de, 0x341d, 
	0x3a6b, 0x3b91, 0x3dfd, 0x3eda, 0x410e, 0x4217, 0x4292, 0x4383, 
	0x43e5, 0x4504, 0x45b3, 0x46ab, 0x4778, 0x4947, 0x4a8a, 0x4b00, 
	0x4c2f, 0x4e49, 0x4ed5, 0x4f0d, 0x4fe9, 0x50d0, 0x523c, 0x533e, 
	0x5550, 0x568b, 0x56f3, 0x577e, 0x585b, 0x58a2, 0x58c7, 0x5aa5, 
	0x5c85, 0x5df7, 0x6097, 0x6277, 0x63b9, 0x666e, 0x672d, 0x67be, 
	0x6948, 0x28f8, 0x29e8, 0x6cc0, 0x6d00, 0x001d, 0x0126, 0x01cf, 
	0x035a, 0x0462, 0x07d5, 0x08be, 0x0948, 0x0a53, 0x0bdf, 0x0cd8, 
	0x0e74, 0x112d, 0x1237, 0x12db, 0x13b1, 0x1493, 0x1541, 0x163a, 
	0x16ec, 0x1714, 0x17b4, 0x18c1, 0x1b2c, 0x1be9, 0x1c9c, 0x1d4e, 
	0x1db1, 0x1eba, 0x2037, 0x21cc, 0x2283, 0x2366, 0x2468, 0x2564, 
	0x265c, 0x26d9, 0x27b0, 0x28d7, 0x29ac, 0x2b12, 0x2d69, 0x2e27, 
	0x2ec6, 0x2fcf, 0x3178, 0x31e2, 0x334d, 0x3421, 0x3a6f, 0x3b9b, 
	0x3e01, 0x3ede, 0x4024, 0x4111, 0x4295, 0x4387, 0x43e8, 0x4508, 
	0x45b7, 0x46b2, 0x4782, 0x48f1, 0x494b, 0x4a36, 0x4a8d, 0x4b05, 
	0x4b93, 0x4c33, 0x4e4c, 0x4ed9, 0x4f11, 0x4fed, 0x50d7, 0x5343, 
	0x548c, 0x54bf, 0x54e0, 0x5555, 0x56f7, 0x5785, 0x585f, 0x58a7, 
	0x58d3, 0x5aaf, 0x5c88, 0x5dfc, 0x6062, 0x61d1, 0x627b, 0x63c0, 
	0x642d, 0x64fb, 0x663f, 0x6731, 0x67c4, 0x694c, 0x6a04, 0x6a66, 
	0x6b5a, 0x6cc4, 0x6e3c, 0x0024, 0x012d, 0x01d9, 0x0360, 0x046d, 
	0x0700, 0x0756, 0x07e0, 0x08cb, 0x0950, 0x0a62, 0x0be6, 0x0ce5, 
	0x0e87, 0x1131, 0x1240, 0x12e4, 0x13b8, 0x149b, 0x155d, 0x1641, 
	0x171c, 0x17bc, 0x18d0, 0x1b35, 0x1bf1, 0x1ca5, 0x1d59, 0x1db9, 
	0x1eca, 0x2041, 0x21d7, 0x2247, 0x228c, 0x2373, 0x2476, 0x2570, 
	0x26e1, 0x27b9, 0x28dd, 0x29b7, 0x2b26, 0x2d72, 0x2e31, 0x2ecd, 
	0x2fdc, 0x317f, 0x31ed, 0x32bb, 0x3356, 0x33d7, 0x342b, 0x3a75, 
	0x3bab, 0x3e08, 0x3ee8, 0x402b, 0x411d, 0x429f, 0x43ef, 0x45be, 
	0x4795, 0x48f6, 0x4953, 0x4a94, 0x4b0d, 0x4b70, 0x4b9b, 0x4c3d, 
	0x4cf0, 0x4d64, 0x4de0, 0x4e55, 0x4f1d, 0x4ff9, 0x50ee, 0x534f, 
	0x5493, 0x54e8, 0x555d, 0x564e, 0x568f, 0x56fe, 0x5791, 0x5866, 
	0x58af, 0x58e6, 0x5ac5, 0x5c90, 0x5e12, 0x606f, 0x61d8, 0x6281, 
	0x63cf, 0x6434, 0x6508, 0x664a, 0x673b, 0x67d3, 0x6954, 0x6a6d, 
	0x6b67, 0x6cce, 0x6e43, 0x002b, 0x0135, 0x01e0, 0x0368, 0x047c, 
	0x07ec, 0x08d8, 0x095b, 0x0a77, 0x0bf1, 0x0cfa, 0x0e9a, 0x1149, 
	0x124c, 0x12ec, 0x13c0, 0x14a5, 0x1562, 0x1648, 0x1723, 0x17c4, 
	0x18df, 0x1b3b, 0x1bf7, 0x1caf, 0x1d64, 0x1dc4, 0x1ed7, 0x204b, 
	0x21e1, 0x2252, 0x2292, 0x237c, 0x2480, 0x2578, 0x2669, 0x26e6, 
	0x27c1, 0x28e1, 0x29be, 0x2b3a, 0x2d78, 0x2ed8, 0x2ff1, 0x3185, 
	0x31f7, 0x32c6, 0x335d, 0x33df, 0x3435, 0x3a7e, 0x3bc4, 0x3e17, 
	0x3ef2, 0x4032, 0x4129, 0x42a9, 0x43f4, 0x4510, 0x45c9, 0x47a8, 
	0x495c, 0x4a9c, 0x4b15, 0x4ba2, 0x4c4a, 0x4d6c, 0x4dd2, 0x4de8, 
	0x4e2f, 0x4e5a, 0x4ee3, 0x4f29, 0x5005, 0x5105, 0x535a, 0x549c, 
	0x54f3, 0x5565, 0x5658, 0x569a, 0x5708, 0x57a4, 0x586d, 0x58fc, 
	0x5adb, 0x5c97, 0x5e25, 0x6079, 0x628b, 0x6330, 0x63de, 0x643e, 
	0x651b, 0x6651, 0x6744, 0x67df, 0x695a, 0x6a0d, 0x6a75, 0x6b76, 
	0x6cd8, 0x6e4a, 0x0033, 0x013d, 0x01ed, 0x0371, 0x048d, 0x07f7, 
	0x08e4, 0x0963, 0x0a86, 0x0bf9, 0x0d09, 0x0eb0, 0x1150, 0x1253, 
	0x12f4, 0x13c6, 0x14ad, 0x1569, 0x1650, 0x172c, 0x17ca, 0x18ea, 
	0x1b41, 0x1bfe, 0x1c7b, 0x1cb9, 0x1d6f, 0x1dce, 0x1ee7, 0x2053, 
	0x21ea, 0x2298, 0x2385, 0x248b, 0x2580, 0x26ed, 0x2775, 0x27c9, 
	0x28e7, 0x29c9, 0x2b51, 0x2d7d, 0x2ee2, 0x3004, 0x318c, 0x3203, 
	0x32d4, 0x3365, 0x33e8, 0x343f, 0x3a88, 0x3be0, 0x3e25, 0x3efc, 
	0x403b, 0x4135, 0x421b, 0x42b2, 0x4392, 0x43fa, 0x45d1, 0x46bf, 
	0x47a8, 0x4966, 0x4a3f, 0x4aa4, 0x4b1d, 0x4c51, 0x4cfe, 0x4d72, 
	0x4dee, 0x4e60, 0x4f31, 0x500d, 0x5114, 0x5367, 0x54a3, 0x54f9, 
	0x556e, 0x5662, 0x5915, 0x5af4, 0x5c9e, 0x5e38, 0x61de, 0x6290, 
	0x6336, 0x63ed, 0x6447, 0x652c, 0x665a, 0x674d, 0x67ea, 0x6960, 
	0x6a7d, 0x6b85, 0x6ce2, 0x6e51, 0x003d, 0x0146, 0x01f7, 0x037a, 
	0x049e, 0x0802, 0x08f4, 0x096a, 0x0a93, 0x0bff, 0x0d14, 0x0ec3, 
	0x1159, 0x125b, 0x12bc, 0x12fd, 0x13cd, 0x14b5, 0x1551, 0x1657, 
	0x1735, 0x17d2, 0x18f9, 0x1b4a, 0x1c08, 0x1cc3, 0x1d7a, 0x1dd9, 
	0x1ef8, 0x205f, 0x21f4, 0x225c, 0x22a1, 0x2391, 0x2499, 0x258a, 
	0x26f6, 0x27d1, 0x28ed, 0x29d4, 0x2b65, 0x2d84, 0x2e39, 0x2eed, 
	0x3019, 0x3191, 0x3210, 0x336f, 0x33f3, 0x3449, 0x3a92, 0x3bfc, 
	0x3e35, 0x3f06, 0x4045, 0x4142, 0x42bc, 0x4402, 0x4517, 0x45d7, 
	0x46ca, 0x47be, 0x48fc, 0x496f, 0x4a49, 0x4aad, 0x4b25, 0x4ba9, 
	0x4bf2, 0x4c57, 0x4d79, 0x4df5, 0x4e69, 0x4f37, 0x5013, 0x511f, 
	0x5373, 0x54aa, 0x54c7, 0x54ff, 0x5529, 0x5579, 0x56a1, 0x56e5, 
	0x570f, 0x57b1, 0x5925, 0x5b0a, 0x5ca2, 0x5e42, 0x6083, 0x61e9, 
	0x6299, 0x6341, 0x6400, 0x644e, 0x6539, 0x6661, 0x6758, 0x67f6, 
	0x6968, 0x6a85, 0x6b94, 0x6cec, 0x6e58, 0x0046, 0x0150, 0x0201, 
	0x0381, 0x04ab, 0x0708, 0x0765, 0x080f, 0x0905, 0x0971, 0x0aa0, 
	0x0c09, 0x0d27, 0x0ee5, 0x115e, 0x1264, 0x1304, 0x13d5, 0x14be, 
	0x1571, 0x165f, 0x1740, 0x17d9, 0x1906, 0x1b52, 0x1c0f, 0x1ccd, 
	0x1de2, 0x1f0a, 0x2067, 0x21fd, 0x2266, 0x22a7, 0x239b, 0x24a4, 
	0x2594, 0x26fc, 0x27d9, 0x28f3, 0x29df, 0x2b7c, 0x2d8e, 0x2e46, 
	0x2ef7, 0x302c, 0x3197, 0x321c, 0x32e2, 0x3377, 0x33fc, 0x3453, 
	0x3a9c, 0x3c18, 0x3e44, 0x3f10, 0x404c, 0x4151, 0x42c8, 0x4408, 
	0x45e0, 0x46db, 0x47d4, 0x4903, 0x4978, 0x4a53, 0x4ab7, 0x4b2e, 
	0x4c60, 0x4d05, 0x4d80, 0x4dfc, 0x4e6d, 0x4f3f, 0x501b, 0x512e, 
	0x537d, 0x54b2, 0x5507, 0x5582, 0x56aa, 0x5718, 0x57c2, 0x593b, 
	0x5b23, 0x5cab, 0x5e5b, 0x608d, 0x61f1, 0x62a2, 0x6413, 0x6455, 
	0x6546, 0x6762, 0x6803, 0x696e, 0x6a90, 0x6ba9, 0x6cf6, 0x6e5f, 
	0x004d, 0x0157, 0x020b, 0x0388, 0x04b8, 0x05a8, 0x05ae, 0x081b, 
	0x0913, 0x0979, 0x0aaf, 0x0c0f, 0x0d32, 0x0efe, 0x1165, 0x126a, 
	0x130e, 0x13db, 0x1578, 0x1666, 0x16f4, 0x1748, 0x17e3, 0x1919, 
	0x1b5b, 0x1c17, 0x1c86, 0x1cd3, 0x1d85, 0x1deb, 0x1f13, 0x2071, 
	0x220a, 0x22b0, 0x23a5, 0x24af, 0x259d, 0x2703, 0x277f, 0x27e2, 
	0x28f8, 0x29e8, 0x2b96, 0x2d95, 0x2efe, 0x3039, 0x319d, 0x3227, 
	0x345d, 0x3aa6, 0x3c34, 0x3e54, 0x3f1a, 0x4056, 0x415e, 0x4229, 
	0x42d3, 0x4410, 0x451e, 0x45e6, 0x46e6, 0x47ed, 0x4982, 0x4abf, 
	0x4b36, 0x4bb0, 0x4c67, 0x4e74, 0x4eea, 0x4f47, 0x5023, 0x513d, 
	0x5387, 0x558c, 0x566f, 0x56b0, 0x571e, 0x57cd, 0x5874, 0x58b7, 
	0x594e, 0x5b3f, 0x5cb1, 0x5e6b, 0x6097, 0x61fa, 0x62a7, 0x641e, 
	0x645e, 0x666e, 0x6767, 0x6810, 0x6975, 0x6d00, 0x6e66, 0x0056, 
	0x0215, 0x038f, 0x04c4, 0x05fc, 0x0658, 0x0827, 0x0980, 0x0abc, 
	0x0c16, 0x0d3f, 0x0f11, 0x0fad, 0x116c, 0x1317, 0x13e2, 0x157f, 
	0x166d, 0x1750, 0x1780, 0x17eb, 0x1928, 0x1c1e, 0x1cdb, 0x1df5, 
	0x1f1c, 0x207a, 0x2146, 0x23b1, 0x25a9, 0x270a, 0x27e9, 0x28fc, 
	0x29ef, 0x2baa, 0x2ca8, 0x2f04, 0x3044, 0x3467, 0x3aad, 0x3c47, 
	0x3f24, 0x4060, 0x416a, 0x4418, 0x45ed, 0x46f3, 0x4800, 0x4c6e, 
	0x4e7c, 0x4f4f, 0x502b, 0x514c, 0x5392, 0x5958, 0x5b55, 0x5cb7, 
	0x5e7b, 0x60a1, 0x6201, 0x62b1, 0x6465, 0x6556, 0x6677, 0x676e, 
	0x681e, 0x697b, 0x6a99, 0x6bba, 0x34af, 0x6d0a, 0x005a, 0x021f, 
	0x0393, 0x04cb, 0x0609, 0x0670, 0x082b, 0x0984, 0x0ac3, 0x0c1a, 
	0x0d46, 0x0f1b, 0x0fc6, 0x1171, 0x131b, 0x13e6, 0x14c5, 0x1583, 
	0x17ef, 0x192f, 0x1ce1, 0x1df9, 0x1f23, 0x2081, 0x214e, 0x22b7, 
	0x230e, 0x23b5, 0x25ad, 0x27f0, 0x2900, 0x29f6, 0x2bba, 0x2cac, 
	0x2f08, 0x304b, 0x31a3, 0x346d, 0x3ab1, 0x3c51, 0x3f2a, 0x4064, 
	0x416e, 0x441d, 0x45f1, 0x4819, 0x498a, 0x4c72, 0x4f53, 0x502f, 
	0x5153, 0x5399, 0x5596, 0x5725, 0x57da, 0x5968, 0x5b65, 0x5cbc, 
	0x5e84, 0x60a8, 0x62b5, 0x634b, 0x6469, 0x6682, 0x6824, 0x697f, 
	0x6a9f, 0x6bc4, 0x34b4, 0x6d11, 0x005e, 0x0229, 0x0397, 0x04d2, 
	0x060e, 0x0679, 0x0988, 0x0aca, 0x0c1e, 0x0d4d, 0x0f25, 0x0fe5, 
	0x1176, 0x131f, 0x13ea, 0x14ca, 0x1549, 0x1754, 0x1785, 0x17f3, 
	0x1936, 0x1ce7, 0x1d8e, 0x2088, 0x23bb, 0x24bc, 0x25b1, 0x2672, 
	0x27f8, 0x2904, 0x29fd, 0x2bcd, 0x2cb0, 0x2d36, 0x2d9d, 0x2e4e, 
	0x2f0c, 0x3052, 0x3473, 0x3ab5, 0x3c5b, 0x3f30, 0x154d, 0x4172, 
	0x4421, 0x45f5, 0x490a, 0x4ac8, 0x4f57, 0x5033, 0x515a, 0x539e, 
	0x5981, 0x5b7e, 0x5cc1, 0x5e8d, 0x60b2, 0x646d, 0x655d, 0x668d, 
	0x682a, 0x6983, 0x6a14, 0x6aa5, 0x6bce, 0x34b9, 0x6d18, 0x0062, 
	0x0233, 0x039b, 0x04d9, 0x0613, 0x0682, 0x098c, 0x0ad1, 0x0c22, 
	0x0d54, 0x0f2f, 0x0ff5, 0x117b, 0x1323, 0x13ee, 0x1587, 0x1671, 
	0x17f7, 0x193d, 0x1ced, 0x1dfd, 0x1f2a, 0x208f, 0x2156, 0x22bb, 
	0x23c1, 0x25b5, 0x270e, 0x27ff, 0x2908, 0x2a04, 0x2bdd, 0x2cb4, 
	0x2da1, 0x2e53, 0x2f10, 0x3059, 0x3479, 0x3ab9, 0x3c65, 0x3f36, 
	0x4176, 0x4425, 0x45f9, 0x4832, 0x4c76, 0x4f5b, 0x5037, 0x5161, 
	0x53a3, 0x559a, 0x5994, 0x5b91, 0x5cc7, 0x5e99, 0x60bc, 0x62b9, 
	0x6471, 0x6564, 0x6696, 0x6830, 0x6aab, 0x6bd8, 0x34be, 0x6d1f, 
	0x0066, 0x0160, 0x023d, 0x039f, 0x04e0, 0x0619, 0x068d, 0x0990, 
	0x0ad8, 0x0c26, 0x0d5b, 0x0f3c, 0x1180, 0x1271, 0x1327, 0x13f2, 
	0x14cf, 0x158b, 0x1675, 0x17fb, 0x1944, 0x0860, 0x1cf3, 0x1f31, 
	0x2096, 0x215e, 0x23c5, 0x25b9, 0x2677, 0x2806, 0x290c, 0x2a0b, 
	0x2bf0, 0x2cb8, 0x2da5, 0x2e58, 0x2f14, 0x3060, 0x3233, 0x32ee, 
	0x337f, 0x347f, 0x3abd, 0x3c6f, 0x3f3c, 0x4069, 0x417a, 0x4429, 
	0x45fd, 0x46fa, 0x4845, 0x498e, 0x4acc, 0x4f5f, 0x503b, 0x5168, 
	0x53a9, 0x59a7, 0x5ba7, 0x5ccd, 0x5ea5, 0x60c6, 0x6475, 0x66a1, 
	0x6836, 0x6ab2, 0x6be4, 0x34c3, 0x6d26, 0x006a, 0x0244, 0x03a3, 
	0x04e7, 0x061e, 0x0696, 0x082f, 0x0922, 0x0994, 0x0adf, 0x0c2a, 
	0x0d62, 0x0f43, 0x1185, 0x132b, 0x13f6, 0x14d4, 0x158f, 0x17ff, 
	0x194b, 0x1cf9, 0x1e01, 0x1f38, 0x209d, 0x2166, 0x23ca, 0x25bd, 
	0x2712, 0x2787, 0x280e, 0x2910, 0x2a12, 0x2bf7, 0x2cbc, 0x2da9, 
	0x2e5d, 0x2f18, 0x3067, 0x3237, 0x32f3, 0x3383, 0x3485, 0x3ac1, 
	0x3c79, 0x3f42, 0x406c, 0x417e, 0x42dd, 0x439d, 0x442e, 0x4601, 
	0x4701, 0x4992, 0x4a5f, 0x4c7a, 0x4e80, 0x4f63, 0x503f, 0x516f, 
	0x53ae, 0x559e, 0x59ae, 0x5bae, 0x5cd2, 0x5eae, 0x60d0, 0x6205, 
	0x62bd, 0x6479, 0x656b, 0x66a8, 0x6772, 0x683c, 0x6987, 0x6ab6, 
	0x6beb, 0x34c8, 0x6d2d, 0x006e, 0x024b, 0x03a7, 0x04ee, 0x0625, 
	0x06a3, 0x0833, 0x0927, 0x0998, 0x0ae6, 0x0c2e, 0x0d69, 0x0f4d, 
	0x1008, 0x118a, 0x132f, 0x13fa, 0x14d9, 0x1593, 0x1804, 0x1954, 
	0x1cff, 0x1e05, 0x1f3f, 0x20a4, 0x2170, 0x22bf, 0x23d0, 0x24c3, 
	0x25c1, 0x2716, 0x2817, 0x2914, 0x2a19, 0x2c01, 0x2cc0, 0x2dad, 
	0x2e62, 0x2f1c, 0x306e, 0x323b, 0x32f8, 0x3387, 0x348b, 0x3ac5, 
	0x3c83, 0x3f48, 0x4182, 0x42e1, 0x43a2, 0x4433, 0x4527, 0x4605, 
	0x4708, 0x484c, 0x4996, 0x4c7e, 0x4e84, 0x4f67, 0x5043, 0x5176, 
	0x53b3, 0x55a2, 0x59bb, 0x5bbb, 0x5cd8, 0x5eba, 0x60d7, 0x6209, 
	0x62c1, 0x647d, 0x6572, 0x66af, 0x6776, 0x6842, 0x698b, 0x6abb, 
	0x6bf3, 0x34cd, 0x6d34, 0x0072, 0x0255, 0x03ab, 0x04f5, 0x062a, 
	0x06ac, 0x0837, 0x099c, 0x0aed, 0x0c32, 0x0d70, 0x0f57, 0x1018, 
	0x118f, 0x1333, 0x13fe, 0x1597, 0x1679, 0x1809, 0x195d, 0x1b62, 
	0x1d05, 0x1e09, 0x1f46, 0x20ab, 0x2179, 0x22c3, 0x2313, 0x23d5, 
	0x24c9, 0x25c5, 0x267c, 0x271a, 0x2820, 0x2918, 0x2a20, 0x2c11, 
	0x2cc4, 0x2f20, 0x3075, 0x31a7, 0x323f, 0x32fd, 0x3491, 0x3ac9, 
	0x3c8d, 0x3f4e, 0x4070, 0x4186, 0x11e8, 0x4609, 0x4859, 0x490e, 
	0x499a, 0x4bb8, 0x4bfa, 0x4c82, 0x4f6b, 0x5047, 0x517d, 0x53b8, 
	0x550d, 0x55a6, 0x59c8, 0x5bc8, 0x5cdd, 0x5ec3, 0x60e1, 0x62c5, 
	0x6350, 0x6481, 0x6579, 0x66ba, 0x677a, 0x6848, 0x698f, 0x6ac0, 
	0x6bfb, 0x34d2, 0x6d3b, 0x0076, 0x025f, 0x03af, 0x04fc, 0x062d, 
	0x06b1, 0x083b, 0x09a0, 0x0af4, 0x0c36, 0x0d77, 0x0f5e, 0x10dc, 
	0x1194, 0x1337, 0x1402, 0x14de, 0x159b, 0x167d, 0x180d, 0x1964, 
	0x1d0b, 0x1e0d, 0x1f4d, 0x20b2, 0x2183, 0x23d9, 0x24ce, 0x1541, 
	0x271e, 0x282a, 0x291c, 0x2a27, 0x2c21, 0x2cc8, 0x2d5c, 0x2f24, 
	0x307c, 0x3497, 0x3acd, 0x3c97, 0x3f54, 0x4074, 0x418a, 0x443a, 
	0x460d, 0x4869, 0x4c86, 0x4f6f, 0x504b, 0x5184, 0x53bd, 0x55aa, 
	0x59db, 0x5bdb, 0x5ce2, 0x5ecc, 0x60eb, 0x62c9, 0x6485, 0x6580, 
	0x66c3, 0x684e, 0x6ac5, 0x6c03, 0x34d7, 0x6d42, 0x007a, 0x0164, 
	0x0269, 0x03b3, 0x0503, 0x0633, 0x06bc, 0x09a4, 0x0afb, 0x0c3a, 
	0x0d7e, 0x0f68, 0x1199, 0x133b, 0x1406, 0x14e4, 0x159f, 0x1681, 
	0x1811, 0x196b, 0x1d11, 0x1e11, 0x1f54, 0x20b9, 0x218c, 0x23df, 
	0x24d5, 0x25c9, 0x2722, 0x2833, 0x2920, 0x2a2e, 0x2c37, 0x2ccc, 
	0x2f28, 0x3083, 0x338b, 0x349d, 0x3ad1, 0x3ca1, 0x3f5a, 0x4078, 
	0x418e, 0x443f, 0x4611, 0x4885, 0x499e, 0x4c8a, 0x4d0d, 0x4f73, 
	0x504f, 0x518b, 0x53c4, 0x55ae, 0x59fa, 0x5bfa, 0x5ce7, 0x5ed5, 
	0x60f5, 0x62cd, 0x6489, 0x6587, 0x66ce, 0x6854, 0x6acb, 0x6c0d, 
	0x6d49, 0x007e, 0x0273, 0x03b7, 0x050a, 0x063f, 0x06d2, 0x083f, 
	0x09a8, 0x0b02, 0x0c3e, 0x0d85, 0x0f7e, 0x119e, 0x133f, 0x140a, 
	0x15a3, 0x1815, 0x1972, 0x1d17, 0x1e15, 0x1f5b, 0x20c0, 0x23e5, 
	0x1710, 0x283c, 0x2924, 0x2a35, 0x2c4d, 0x2cd0, 0x2f2c, 0x308a, 
	0x3243, 0x3303, 0x34a3, 0x3ad5, 0x3cab, 0x3f60, 0x11ed, 0x4192, 
	0x4446, 0x4615, 0x489b, 0x4f77, 0x5053, 0x5192, 0x53c9, 0x55b2, 
	0x567a, 0x5729, 0x57e1, 0x5a13, 0x5c13, 0x5cec, 0x5ede, 0x60ff, 
	0x620d, 0x62d1, 0x648d, 0x658e, 0x66db, 0x685b, 0x6993, 0x6a19, 
	0x6ad1, 0x6c17, 0x6d50, 0x0082, 0x0168, 0x027d, 0x03bb, 0x0511, 
	0x064c, 0x06ea, 0x0843, 0x09ac, 0x0b09, 0x0c42, 0x0d8c, 0x0f94, 
	0x11a3, 0x1343, 0x140e, 0x15a8, 0x1685, 0x1758, 0x1819, 0x1979, 
	0x1c22, 0x1d1d, 0x1e19, 0x1f62, 0x20c7, 0x2195, 0x22c7, 0x2318, 
	0x23ea, 0x25cd, 0x2681, 0x2845, 0x2928, 0x2a3c, 0x2c60, 0x2cd4, 
	0x2f30, 0x3091, 0x34a9, 0x3ad9, 0x3cb5, 0x3f66, 0x407c, 0x4196, 
	0x444d, 0x4619, 0x48b7, 0x4913, 0x49a2, 0x4a64, 0x4c8e, 0x4f7b, 
	0x5057, 0x5199, 0x53cf, 0x55b6, 0x572d, 0x57e8, 0x5a29, 0x5c26, 
	0x5cf1, 0x5ee7, 0x6109, 0x62d5, 0x6491, 0x6595, 0x66e6, 0x6862, 
	0x6ad7, 0x6c21, 0x6d5a, 0x0086, 0x016c, 0x0287, 0x03bf, 0x0518, 
	0x05fc, 0x0658, 0x0847, 0x09b0, 0x0b10, 0x0c46, 0x0d93, 0x0fad, 
	0x11a8, 0x1275, 0x1347, 0x1412, 0x15ac, 0x1689, 0x175c, 0x178a, 
	0x181d, 0x1980, 0x1b67, 0x1c26, 0x1d23, 0x1e1d, 0x1f69, 0x20ce, 
	0x22cb, 0x23ef, 0x24dc, 0x25d1, 0x2726, 0x284f, 0x292c, 0x2a43, 
	0x2baa, 0x2cd8, 0x2d3b, 0x2db1, 0x2e67, 0x2f34, 0x3098, 0x31ab, 
	0x3247, 0x3308, 0x338f, 0x34af, 0x3add, 0x3cbf, 0x3e63, 0x3f6c, 
	0x4080, 0x419a, 0x42e5, 0x43a7, 0x4452, 0x452f, 0x461d, 0x470f, 
	0x4800, 0x49a6, 0x4bbc, 0x4bff, 0x4c92, 0x4d12, 0x4d86, 0x4e02, 
	0x4e88, 0x4f7f, 0x505b, 0x51a0, 0x5240, 0x5293, 0x53d4, 0x55ba, 
	0x5731, 0x57ef, 0x5958, 0x5b55, 0x5cf6, 0x5ef0, 0x60a1, 0x6211, 
	0x62d9, 0x6495, 0x659c, 0x6677, 0x6869, 0x6997, 0x6a1e, 0x6adc, 
	0x6c29, 0x6d0a, 0x008e, 0x0175, 0x0297, 0x03c5, 0x0523, 0x0609, 
	0x0670, 0x084e, 0x09b9, 0x0b21, 0x0c4d, 0x0da0, 0x0fc6, 0x11af, 
	0x127c, 0x134d, 0x1418, 0x14ea, 0x15b3, 0x1690, 0x1763, 0x1828, 
	0x1995, 0x1b6f, 0x1c2c, 0x1d2b, 0x1e27, 0x1f76, 0x20d7, 0x22d3, 
	0x231d, 0x23f6, 0x25df, 0x272e, 0x285d, 0x2932, 0x2a4e, 0x2bba, 
	0x2ce1, 0x2d45, 0x2db8, 0x2e6f, 0x2f3d, 0x30a9, 0x31b3, 0x324e, 
	0x3310, 0x3397, 0x34b4, 0x3ae5, 0x3cd5, 0x3e6b, 0x3f73, 0x408b, 
	0x41a1, 0x42ee, 0x43b1, 0x445d, 0x4625, 0x4819, 0x4917, 0x49ad, 
	0x4bc3, 0x4c07, 0x4c9a, 0x4d8e, 0x4e0a, 0x4f86, 0x5062, 0x51ad, 
	0x5247, 0x52a0, 0x53e4, 0x55c0, 0x5738, 0x57fc, 0x5968, 0x5b65, 
	0x5cfd, 0x5f03, 0x6113, 0x6217, 0x62de, 0x6355, 0x649c, 0x65a9, 
	0x6682, 0x6877, 0x699e, 0x6a26, 0x6ae5, 0x6c3a, 0x6d11, 0x0097, 
	0x017f, 0x0229, 0x03cc, 0x0530, 0x060e, 0x0679, 0x0855, 0x09be, 
	0x0b2a, 0x0c56, 0x0db1, 0x0fe5, 0x11b9, 0x1284, 0x1354, 0x1399, 
	0x141d, 0x14f0, 0x1562, 0x1698, 0x1769, 0x1792, 0x1834, 0x19ac, 
	0x1b78, 0x1c34, 0x1ce7, 0x1d8e, 0x1e2f, 0x20e0, 0x2216, 0x23bb, 
	0x24bc, 0x25ea, 0x2686, 0x2737, 0x27f8, 0x2904, 0x29fd, 0x2bcd, 
	0x2ce9, 0x2d4e, 0x2dc0, 0x2e78, 0x2f46, 0x30ba, 0x31bc, 0x3256, 
	0x34b9, 0x3aef, 0x3cf1, 0x3e74, 0x3f7a, 0x4097, 0x41a9, 0x4469, 
	0x453b, 0x462e, 0x490a, 0x49b2, 0x4ad0, 0x4c9f, 0x4d98, 0x4dd9, 
	0x4e14, 0x4e36, 0x4e91, 0x4f8e, 0x506a, 0x51bc, 0x524f, 0x52af, 
	0x53f0, 0x54b9, 0x5981, 0x5b7e, 0x5d08, 0x5f22, 0x6120, 0x621f, 
	0x64a2, 0x65b4, 0x668d, 0x6882, 0x69a4, 0x6a2d, 0x6aef, 0x6c4d, 
	0x6d18, 0x009d, 0x02a7, 0x03d1, 0x0539, 0x0613, 0x0682, 0x0710, 
	0x0774, 0x085a, 0x09c6, 0x0b39, 0x0c5b, 0x0dba, 0x0ff5, 0x11c0, 
	0x1359, 0x1424, 0x15bc, 0x169e, 0x183c, 0x19bb, 0x1b7e, 0x1d34, 
	0x1e37, 0x1f81, 0x20ea, 0x221b, 0x2274, 0x22db, 0x23fe, 0x24e4, 
	0x25f2, 0x273d, 0x286d, 0x2939, 0x2a5b, 0x2bdd, 0x2cf0, 0x2dc8, 
	0x2e81, 0x2f4c, 0x30c5, 0x325b, 0x3319, 0x33a0, 0x34be, 0x3af5, 
	0x3d01, 0x3e7b, 0x3f81, 0x40a1, 0x41ae, 0x4237, 0x42f8, 0x43bc, 
	0x4478, 0x454b, 0x4633, 0x4832, 0x4bcb, 0x4ca6, 0x4d1b, 0x4e98, 
	0x4f94, 0x5070, 0x51c7, 0x5254, 0x52b8, 0x53fd, 0x55c7, 0x5994, 
	0x5b91, 0x5d0f, 0x5f35, 0x612d, 0x62e4, 0x64ab, 0x65c5, 0x6696, 
	0x688c, 0x69a9, 0x6af5, 0x6c58, 0x6d1f, 0x0066, 0x0160, 0x023d, 
	0x03d7, 0x0544, 0x0619, 0x068d, 0x0717, 0x0781, 0x0797, 0x07a3, 
	0x0860, 0x09cf, 0x0b4a, 0x0c26, 0x0d5b, 0x0f3c, 0x11c6, 0x1271, 
	0x135f, 0x142a, 0x14f8, 0x158b, 0x1675, 0x1845, 0x19cc, 0x1b85, 
	0x1c3a, 0x1327, 0x1e3f, 0x1f8c, 0x20f3, 0x2406, 0x24ed, 0x25fd, 
	0x268f, 0x2743, 0x2806, 0x290c, 0x2a0b, 0x2bf0, 0x2cf8, 0x2dd0, 
	0x2e8a, 0x2f53, 0x30d2, 0x3233, 0x32ee, 0x33a7, 0x34c3, 0x3afc, 
	0x3d14, 0x3e82, 0x3f88, 0x40ab, 0x41b8, 0x4242, 0x4300, 0x4486, 
	0x45fd, 0x46fa, 0x4845, 0x49b8, 0x4acc, 0x4d9e, 0x4f9b, 0x5077, 
	0x51d4, 0x4f5f, 0x5168, 0x5409, 0x2da5, 0x2e58, 0x59a7, 0x5ba7, 
	0x5d16, 0x5f48, 0x613a, 0x6225, 0x62ea, 0x635c, 0x64b3, 0x66a1, 
	0x6897, 0x6ab2, 0x6be4, 0x6d26, 0x00a3, 0x0185, 0x0244, 0x03dc, 
	0x054d, 0x061e, 0x0696, 0x079e, 0x07b0, 0x0864, 0x09d7, 0x0b59, 
	0x0c2a, 0x0d62, 0x0f43, 0x11ca, 0x1289, 0x1364, 0x1431, 0x1500, 
	0x15c3, 0x16a4, 0x184b, 0x19d7, 0x1b8a, 0x1c3f, 0x1cf9, 0x1e47, 
	0x1f91, 0x20fc, 0x219d, 0x22e1, 0x23ca, 0x2607, 0x269a, 0x2748, 
	0x278c, 0x2874, 0x293f, 0x2a66, 0x2bf7, 0x2d00, 0x2dd6, 0x2e91, 
	0x2f5a, 0x30df, 0x3261, 0x3320, 0x33ae, 0x34c8, 0x3b02, 0x3d24, 
	0x3f8f, 0x40b2, 0x41c0, 0x424c, 0x4306, 0x43c5, 0x448e, 0x4639, 
	0x471e, 0x006a, 0x49be, 0x4a69, 0x4bd2, 0x4caf, 0x4da3, 0x4e1a, 
	0x4ea0, 0x4f9f, 0x507b, 0x51db, 0x525b, 0x52c5, 0x5415, 0x2da9, 
	0x2e5d, 0x5511, 0x55cd, 0x4601, 0x4701, 0x59ae, 0x5bae, 0x5d1e, 
	0x5f5e, 0x60d0, 0x622a, 0x62f0, 0x64bb, 0x65d4, 0x66a8, 0x68a3, 
	0x69ae, 0x6d2d, 0x00a8, 0x018b, 0x024b, 0x03e2, 0x0558, 0x0625, 
	0x06a3, 0x071c, 0x078a, 0x0869, 0x09df, 0x0b68, 0x0c2e, 0x0d69, 
	0x1008, 0x11d3, 0x128e, 0x1369, 0x1438, 0x1508, 0x15cb, 0x16a9, 
	0x1853, 0x19e6, 0x1b90, 0x1c45, 0x1cff, 0x1e4e, 0x1f9a, 0x2104, 
	0x21a6, 0x22e6, 0x23d0, 0x24c3, 0x2612, 0x274d, 0x2880, 0x2944, 
	0x2a6f, 0x2c01, 0x2d07, 0x2ddd, 0x2e99, 0x2f62, 0x30ee, 0x3266, 
	0x3327, 0x33b5, 0x34cd, 0x3b09, 0x3d37, 0x3f96, 0x40bb, 0x41c9, 
	0x430d, 0x43cd, 0x4495, 0x455b, 0x463e, 0x4727, 0x484c, 0x4920, 
	0x49c4, 0x4bd7, 0x4cb8, 0x4da9, 0x4e20, 0x4ea6, 0x4fa4, 0x5080, 
	0x51e4, 0x5260, 0x52ce, 0x5421, 0x2dad, 0x2e62, 0x5517, 0x55d5, 
	0x4605, 0x4708, 0x59bb, 0x5bbb, 0x5d27, 0x5f77, 0x60d7, 0x6230, 
	0x62f8, 0x64c3, 0x65e3, 0x66af, 0x68af, 0x69b3, 0x6d34, 0x00ad, 
	0x0191, 0x02b4, 0x03e8, 0x0563, 0x062a, 0x06ac, 0x086e, 0x09e6, 
	0x0b75, 0x0c61, 0x0dc5, 0x1018, 0x11da, 0x1370, 0x1441, 0x15d6, 
	0x16ae, 0x185b, 0x19f5, 0x1b96, 0x1c4b, 0x1e56, 0x1f46, 0x210d, 
	0x22ee, 0x2326, 0x2416, 0x24fe, 0x261e, 0x26a6, 0x2753, 0x2820, 
	0x2949, 0x2a78, 0x2c11, 0x2d0e, 0x2de4, 0x2f6a, 0x30fd, 0x31c2, 
	0x326b, 0x332e, 0x34d2, 0x3b10, 0x3d4a, 0x3e87, 0x3f9d, 0x40c9, 
	0x41d0, 0x4256, 0x4314, 0x44a0, 0x4567, 0x4643, 0x4859, 0x490e, 
	0x49ca, 0x4ad6, 0x4bde, 0x4c10, 0x4cbf, 0x4d25, 0x4fa9, 0x5085, 
	0x51ed, 0x5265, 0x52d7, 0x542e, 0x551d, 0x55dc, 0x587b, 0x59c8, 
	0x5bc8, 0x5d2f, 0x5f8d, 0x60e1, 0x62ff, 0x6363, 0x64ca, 0x65f0, 
	0x66ba, 0x68bc, 0x69bb, 0x6afd, 0x6c67, 0x6d3b, 0x00b4, 0x02c1, 
	0x03ee, 0x056e, 0x062d, 0x06b1, 0x0875, 0x09ee, 0x0b84, 0x0c68, 
	0x0dd2, 0x1028, 0x10dc, 0x11df, 0x1293, 0x1376, 0x1447, 0x1512, 
	0x15db, 0x16b5, 0x1865, 0x1a08, 0x1b9f, 0x1c52, 0x1e5e, 0x1fa5, 
	0x2114, 0x22f3, 0x241d, 0x2506, 0x262a, 0x275a, 0x288e, 0x2950, 
	0x2a85, 0x2c21, 0x2d16, 0x2dee, 0x2f73, 0x310e, 0x33bc, 0x34d7, 
	0x3b18, 0x3d60, 0x3e91, 0x3fa4, 0x40d1, 0x41da, 0x4262, 0x431c, 
	0x44af, 0x464a, 0x4869, 0x49d1, 0x4cc8, 0x4d2f, 0x4daf, 0x4eac, 
	0x4fb1, 0x508d, 0x51fc, 0x526c, 0x52e4, 0x5439, 0x55e2, 0x56b7, 
	0x5740, 0x580b, 0x59db, 0x5bdb, 0x5d37, 0x5fa3, 0x6147, 0x6236, 
	0x6307, 0x636c, 0x64d2, 0x65ff, 0x66c3, 0x677e, 0x68c8, 0x69c3, 
	0x6b03, 0x6c72, 0x6d42, 0x00be, 0x019a, 0x02d4, 0x03f5, 0x057b, 
	0x0633, 0x06bc, 0x087e, 0x09f7, 0x0b95, 0x0c72, 0x0de5, 0x104a, 
	0x0f68, 0x11e8, 0x129d, 0x137f, 0x144c, 0x151a, 0x15e0, 0x16bf, 
	0x1871, 0x1a1f, 0x1ba9, 0x1d3b, 0x1e65, 0x1fb4, 0x211c, 0x22fd, 
	0x242a, 0x2515, 0x2637, 0x2763, 0x289a, 0x2957, 0x2a92, 0x2c37, 
	0x2d1c, 0x2df9, 0x2ea1, 0x2f7e, 0x3123, 0x3271, 0x3336, 0x33c6, 
	0x349d, 0x3b23, 0x3d7f, 0x3e9c, 0x3fab, 0x40de, 0x41e2, 0x4327, 
	0x44b6, 0x4578, 0x4654, 0x4885, 0x49db, 0x4cd1, 0x4d39, 0x4db8, 
	0x4eb7, 0x4fba, 0x5096, 0x520d, 0x5275, 0x52f5, 0x5446, 0x55ea, 
	0x56c1, 0x574a, 0x581e, 0x59fa, 0x5bfa, 0x5d3f, 0x5fb9, 0x6157, 
	0x6242, 0x630d, 0x64db, 0x6610, 0x66ce, 0x68d5, 0x69cb, 0x6a33, 
	0x6b0e, 0x6c87, 0x6d49, 0x00c6, 0x02e7, 0x03fc, 0x0588, 0x063f, 
	0x06d2, 0x0886, 0x0a02, 0x0baa, 0x0c7b, 0x0df6, 0x1063, 0x0f7e, 
	0x11ed, 0x12a5, 0x1387, 0x1452, 0x15e7, 0x16c7, 0x187b, 0x1a32, 
	0x1bb1, 0x1c5d, 0x1e6b, 0x1fbf, 0x2124, 0x243b, 0x2527, 0x2642, 
	0x28a8, 0x295f, 0x2aa1, 0x2c4d, 0x2d25, 0x2f89, 0x3138, 0x3279, 
	0x333f, 0x34a3, 0x3b2d, 0x3d9b, 0x3ea5, 0x3fb2, 0x40e8, 0x41e9, 
	0x426b, 0x4330, 0x44c6, 0x4589, 0x465d, 0x489b, 0x49e3, 0x4dc0, 
	0x4ec1, 0x4fc2, 0x509e, 0x521c, 0x527d, 0x5304, 0x5453, 0x55f0, 
	0x567f, 0x56c9, 0x5752, 0x582d, 0x5a13, 0x5c13, 0x5d46, 0x5fcc, 
	0x60ff, 0x624a, 0x6312, 0x6373, 0x64e3, 0x661f, 0x66db, 0x68e5, 
	0x69d2, 0x6a3b, 0x6b18, 0x6c9a, 0x6d50, 0x00cf, 0x01a2, 0x02f7, 
	0x0403, 0x0595, 0x064c, 0x06ea, 0x088d, 0x0a0b, 0x0bbb, 0x0c83, 
	0x0e05, 0x107c, 0x0f94, 0x11f0, 0x12ae, 0x1390, 0x145b, 0x15f0, 
	0x16d0, 0x176e, 0x1885, 0x1a45, 0x1bba, 0x1c67, 0x1d44, 0x1e72, 
	0x1fcc, 0x212e, 0x2221, 0x2305, 0x232c, 0x2448, 0x2535, 0x264f, 
	0x26b3, 0x28b3, 0x2966, 0x2aae, 0x2c60, 0x2d2d, 0x2f93, 0x314b, 
	0x33ce, 0x34a9, 0x3b36, 0x3db4, 0x3eaf, 0x3fbc, 0x40ef, 0x41f3, 
	0x4276, 0x433a, 0x44d7, 0x4665, 0x48b7, 0x4926, 0x49ec, 0x4a70, 
	0x4be4, 0x4cdd, 0x4d46, 0x4dc9, 0x4e26, 0x4ecb, 0x4fc9, 0x50a5, 
	0x5229, 0x5284, 0x5311, 0x5460, 0x55f7, 0x56d2, 0x575b, 0x583e, 
	0x5a29, 0x5c26, 0x5d50, 0x5fe8, 0x6164, 0x6255, 0x6318, 0x637a, 
	0x64ec, 0x6630, 0x66e6, 0x68fc, 0x69da, 0x6d5a, 0x00d8, 0x01ab, 
	0x0307, 0x040a, 0x05a2,      0, 0x1098, 0x10fb, 0x11f6, 0x1fd9, 
	0x2c76, 0x3282, 0x34dc, 0x3fc6, 0x48cd, 0x55ff, 0x5a43, 0x5c3f, 
	0x6171, 0x631f, 0x6382, 0x6d64, 0x00db, 0x01ae, 0x0311, 0x040c, 
	0x05a5,      0, 0x10a5, 0x1117, 0x11f6, 0x1fe0, 0x2c92, 0x3285, 
	0x34e3, 0x3fcd, 0x48d9, 0x5602, 0x5a50, 0x5c5b, 0x6185, 0x6322, 
	0x6387, 0x66f1, 0x6d6b, 0x00de, 0x01b1, 0x031e, 0x040e, 0x05b9, 
	0x0723, 0x0894, 0x0a13, 0x0c8c, 0x10b5, 0x11f8, 0x1464, 0x1522, 
	0x15f8, 0x1a5a, 0x1a6c, 0x1a7b, 0x1abf, 0x1aea, 0x1bc3, 0x1e7a, 
	0x1fe7, 0x2137, 0x296c, 0x2e01, 0x3288, 0x34ea, 0x3b40, 0x3dd0, 
	0x3fd4, 0x41fc, 0x4344, 0x44df, 0x466e, 0x49f6, 0x4b3f, 0x4b79, 
	0x546c, 0x5605, 0x5764, 0x5883, 0x5d58, 0x6199, 0x66f4, 0x6786, 
	0x6910, 0x69e2, 0x6d72, 0x6db8, 0x6e06, 0x6e6d, 0x00f3, 0x01c3, 
	0x0340, 0x0427, 0x05d4, 0x073d, 0x08a4, 0x0c9a, 0x10d0, 0x1615, 
	0x16d9, 0x1777, 0x1a97, 0x1adc, 0x1b05, 0x1b11, 0x1e89, 0x2007, 
	0x222a, 0x2336, 0x329b, 0x350a, 0x3eb9, 0x3fdf, 0x420e, 0x4369, 
	0x4a16, 0x4adf, 0x4b55, 0x561d, 0x56db, 0x5d6f, 0x6dd4, 0x6e98, 
	0x00fc, 0x01cc, 0x0349, 0x0431, 0x05e0, 0x074b, 0x0ca3, 0x1aa5, 
	0x2e1e, 0x351a, 0x3ff1, 0x4b5f, 0x5626, 0x6928, 0x6d95, 0x6de7, 
	0x6e29, 0x0105,      0, 0x043e, 0x05ed, 0x074b, 0x0cac, 0x120f, 
	0x147e, 0x1ab1, 0x2010, 0x2984, 0x2e1e, 0x352a, 0x4003, 0x5633, 
	0x670f, 0x6da5, 0x6dfa, 0x6eae,      0, 0x353c, 0x5d79, 0x5ffe, 
	     0,      0, 0x36b4, 0x5d99,      0, 0x36c2,      0, 0x3a35, 
	0x5da3, 0x6022,      0, 0x5dc7, 0x6054, 
},
{	/* lc_messages_rows */
	   0,    0,    0,    0, 0x01, 0x01,    0,    0, 
	0x02, 0x02,    0,    0, 0x03, 0x03,    0,    0, 
	0x04, 0x04,    0,    0, 0x05, 0x05, 0x01, 0x01, 
	0x06, 0x06, 0x02, 0x02, 0x07, 0x07, 0x01, 0x01, 
	0x08, 0x08,    0,    0, 0x09, 0x09,    0,    0, 
	0x0a, 0x0a,    0, 0x03, 0x0a, 0x0a, 0x03, 0x03, 
	0x0b, 0x0b,    0,    0, 0x0c, 0x0c,    0,    0, 
	0x0d, 0x0d,    0,    0, 0x0e, 0x0e,    0,    0, 
	0x0f, 0x0f, 0x04, 0x04, 0x10, 0x10, 0x05, 0x05, 
	0x11, 0x01,    0,    0, 0x12, 0x11,    0,    0, 
	0x13, 0x01,    0,    0, 0x14, 0x02, 0x06, 0x06, 
	0x15, 0x01, 0x07, 0x07, 0x16, 0x12,    0,    0, 
	0x17, 0x02,    0,    0, 0x18, 0x13,    0,    0, 
	0x19, 0x14,    0,    0, 0x1a, 0x01,    0,    0, 
	0x1b, 0x02,    0,    0, 0x1c, 0x15,    0,    0, 
	   0,    0, 0x08, 0x08, 0x1d, 0x02,    0,    0, 
	0x1e, 0x02,    0,    0, 0x1d, 0x16,    0,    0, 
	0x1f, 0x17,    0,    0, 0x20, 0x18,    0,    0, 
	0x21, 0x19,    0,    0, 0x1d, 0x1a,    0,    0, 
	0x22, 0x1b,    0,    0, 0x23, 0x02,    0,    0, 
	0x24, 0x02,    0,    0, 0x25, 0x02,    0,    0, 
	0x26, 0x1c,    0,    0, 0x27, 0x1d,    0,    0, 
	0x28, 0x02,    0,    0, 0x29, 0x02,    0,    0, 
	0x2a, 0x1e, 0x09, 0x09, 0x1a, 0x1f,    0,    0, 
	0x2b, 0x02,    0,    0, 0x2c, 0x20, 0x0a, 0x0a, 
	0x2d, 0x21,    0,    0, 0x2e, 0x22,    0,    0, 
	0x2f, 0x1a,    0,    0, 0x30, 0x23,    0,    0, 
	0x31, 0x01,    0,    0, 0x32, 0x1a,    0,    0, 
	0x33, 0x24, 0x0b, 0x0b, 0x34, 0x24, 0x0c, 0x0c, 
	0x35, 0x25, 0x0d, 0x0d, 0x36, 0x26, 0x0e, 0x0e, 
	0x37, 0x27,    0,    0,    0, 0x28, 0x0f, 0x0f, 
	0x38, 0x01,    0,    0, 0x32, 0x02,    0,    0, 
	0x39, 0x02,    0,    0, 0x3a, 0x02,    0,    0, 
	0x3b, 0x29,    0,    0, 0x3c, 0x2a,    0,    0, 
	0x3d, 0x2b,    0,    0, 0x3e, 0x2c,    0,    0, 
	0x1d, 0x2d,    0,    0, 0x3f, 0x01, 0x10, 0x10, 
	0x40, 0x01, 0x11, 0x10, 0x41, 0x1a,    0,    0, 
	0x42, 0x2e,    0,    0, 0x43, 0x2f,    0,    0, 
	0x44, 0x30, 0x12, 0x11, 0x45, 0x31, 0x13, 0x12, 
	0x3b, 0x29, 0x14, 0x13, 0x0c, 0x0c, 0x0e, 0x14, 
	0x46, 0x32, 0x15, 0x15, 0x47, 0x33, 0x16, 0x16, 
	0x48, 0x34, 0x17, 0x17, 0x48, 0x34, 0x17, 0x18, 
	0x0c, 0x0c, 0x18, 0x19, 0x49, 0x2b,    0,    0, 
	0x4a, 0x2c,    0,    0, 0x4b, 0x35, 0x19, 0x1a, 
	0x4c, 0x36, 0x1a, 0x1b, 0x4d, 0x01, 0x1b, 0x1c, 
	0x4e, 0x37, 0x1c, 0x1d, 0x4f, 0x38, 0x1d, 0x1e, 
	0x50, 0x39,    0,    0, 
},
{	/* lc_messages_item_offsets */
	     0, 0x0051, 0x008b, 0x00a9, 
},
{	/* lc_messages_item_idx */
	0x0001, 0x000d, 0x001b, 0x002b, 0x0039, 0x0049, 0x0061, 0x0079, 
	0x0072, 0x0055, 0x0091, 0x00ad, 0x00c1, 0x00d9, 0x00f7, 0x0119, 
	0x013d, 0x0171, 0x017a, 0x018c, 0x0195, 0x01a6, 0x01b7, 0x01cb, 
	0x01d5, 0x01e9, 0x0201, 0x0208, 0x0212, 0x0231, 0x023b, 0x024f, 
	0x0265, 0x027b, 0x0299, 0x02af, 0x02b9, 0x02c7, 0x02d1, 0x02e3, 
	0x02f7, 0x0301, 0x030b, 0x032f, 0x033d, 0x038c, 0x03a4, 0x03c0, 
	0x03cc, 0x03e4, 0x03eb, 0x03f5, 0x0418, 0x0436, 0x0452, 0x0476, 
	0x049c, 0x04a5, 0x04af, 0x04b9, 0x04cd, 0x04e1, 0x04f3, 0x0511, 
	0x0524, 0x0536, 0x0540, 0x0552, 0x0564, 0x059e, 0x05d4, 0x05ed, 
	0x061c, 0x064a, 0x0653, 0x065e, 0x0686, 0x06a2, 0x06b8, 0x06d3, 
	0x06f7, 0x0007, 0x0014, 0x0023, 0x0032, 0x0041, 0x004f, 0x006a, 
	0x0086, 0x0076, 0x005c, 0x0099, 0x00b7, 0x00cd, 0x00e9, 0x0109, 
	0x0126, 0x0150, 0x0184, 0x01c2, 0x01df, 0x01f5, 0x0221, 0x0245, 
	0x025b, 0x026f, 0x0287, 0x0291, 0x02a6, 0x02da, 0x02ed, 0x0316, 
	0x0326, 0x0359, 0x0399, 0x03b3, 0x03d5, 0x0404, 0x0442, 0x0460, 
	0x0482, 0x048d, 0x04c3, 0x04d7, 0x04ea, 0x04fe, 0x0509, 0x054a, 
	0x055b, 0x0571, 0x05a5, 0x05db, 0x05f6, 0x0624, 0x066a, 0x0690, 
	0x06c1, 0x06dd, 0x0700,      0, 0x0055, 0x0072, 0x00a7, 0x0131, 
	0x015a, 0x019f, 0x01b1, 0x022a, 0x031f, 0x037b, 0x040f, 0x042b, 
	0x044c, 0x046c, 0x0493, 0x051c, 0x0531, 0x0584, 0x05ac, 0x05c6, 
	0x05e2, 0x05ff, 0x062c, 0x063e, 0x0674, 0x069a, 0x06af, 0x06cb, 
	0x06e9,      0, 0x005c, 0x0076, 0x00a3, 0x0138, 0x016a, 0x01a3, 
	0x01b4, 0x022e, 0x0323, 0x0382, 0x0412, 0x042f, 0x044f, 0x0471, 
	0x0496, 0x0520, 0x058e, 0x05b9, 0x05c9, 0x05cd, 0x05e6, 0x0609, 
	0x0631, 0x0637, 0x0645, 0x067d, 0x069d, 0x06b3, 0x06cf, 0x06f0, 
},
{	/* collate_data */
	0x0007, 0x0091, 0x0004, 0x14e8, 0x0487, 0x0b34, 0x250d, 0x30d8, 
	0x0004, 0x0026, 0x0005, 0x0003, 0x0100, 0x0240, 0x585f, 0x0482, 
	0x0657,      0, 0x4e00, 0x51a5, 0x06ac, 0x02eb,      0,      0, 
	     0,      0,      0, 0x0004, 0x000a, 0x0005, 0x0004, 0x0080, 
	0x01e0, 0x07f6, 0x069d, 0x079b,      0,      0,      0,      0, 
	     0, 0x0482, 0x0482, 0x07c2, 0x0988,      0, 0x0004, 0x0002, 
	0x0005, 0x0004, 0x0080, 0x01e0, 0x075e, 0x075d, 0x075e,      0, 
	     0,      0,      0,      0, 0x0b1f, 0x0b1f, 0x0882, 0x1758, 
	     0, 0x0002,      0, 0x0005, 0x0006, 0x0020, 0x0040, 0x00d5, 
	0x00d4, 0x00d5,      0,      0,      0,      0,      0, 0x127c, 
	0x127c,      0, 0x2518,      0, 0x0004, 0x0005, 0x0005, 0x0005, 
	0x0040, 0x0060, 0x0199, 0x0198, 0x0199,      0,      0,      0, 
	     0,      0, 0x1350, 0x1350, 0x0891, 0x26f8,      0, 0x0001, 
	     0, 0x0004, 0x0005, 0x0080, 0x0330, 0x3371, 0x3370, 0x3371, 
	     0,      0,      0,      0,      0, 0x14e8, 0x14e8,      0, 
	0x2878,      0, 0x0001,      0, 0x0005, 0x0002, 0x0200, 0x1820, 
	0x4314, 0x176f, 0x4314,      0, 0xac00, 0x2ba3, 0x0457, 0x0c35, 
	0x14e8, 0x14e8,      0, 0x8228,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483, 0x0005, 
	0x0072,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483, 0x0037, 0x00f6,      0, 0x0483,      0, 
	     0,      0, 0x0483, 0x004e,      0,      0, 0x0483, 0x005c, 
	     0,      0, 0x0483, 0x0112, 0x0174,      0, 0x0483, 0x012c, 
	     0,      0, 0x0483, 0x012c,      0,      0, 0x0483, 0x014b, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483, 0x0186,      0,      0, 0x0483, 0x01c0, 
	0x01f2,      0, 0x0483,      0,      0,      0, 0x0483, 0x0223, 
	     0,      0, 0x0483, 0x004e,      0,      0, 0x0483, 0x004e, 
	     0,      0, 0x0483, 0x02da,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483, 0x031e, 
	0x0288,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483, 0x036b, 
	0x0312,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483, 0x0394,      0,      0, 0x0483, 0x0433, 
	0x039c,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483, 0x0599, 
	0x05de,      0, 0x0483,      0,      0,      0, 0x0483, 0x06b9, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483, 0x06f4, 
	0x0662,      0, 0x0483, 0x077b, 0x01f2,      0, 0x0483, 0x07dc, 
	0x0734,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483, 0x0801,      0,      0, 0x0483, 0x004e, 
	     0,      0, 0x0483, 0x08bb,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483,      0,      0,      0, 0x0483,      0, 
	     0,      0, 0x0483, 0x012c,      0,      0, 0x0483,      0, 
	     0, 0x0001, 0x02a8, 0x094f, 0x07c2, 0x0001, 0x02a8, 0x0b40, 
	0x07c2, 0x0001, 0x02a8, 0x0d29, 0x07c2, 0x0001, 0x02a8, 0x0f1f, 
	0x07c2, 0x0001, 0x02a8, 0x1115, 0x07e0, 0x0001, 0x02a8, 0x1305, 
	0x07c2, 0x0001, 0x02a8, 0x14f6, 0x07c2, 0x0001, 0x02a8, 0x16ec, 
	0x07e0, 0x0001, 0x02a8, 0x18e1, 0x07c2, 0x0001, 0x02a8, 0x1b28, 
	0x080a, 0x0001, 0x02a8, 0x1d36, 0x07c2, 0x0001, 0x02a8, 0x1f28, 
	0x07c2, 0x0001, 0x02a8, 0x16ec, 0x07e0, 0x0001, 0x02a8, 0x0b40, 
	0x07c2, 0x0001, 0x02a8, 0x211c, 0x07c2, 0x0001, 0x02a8, 0x1d36, 
	0x07c2, 0x0001, 0x02a8, 0x1d36, 0x07c2, 0x0001, 0x02a8, 0x2307, 
	0x084c, 0x0001, 0x02a8, 0x1d36, 0x07c2, 0x0001, 0x02a8, 0x1d36, 
	0x07c2, 0x0001, 0x02a8, 0x1d36, 0x07c2, 0x0001, 0x02a8, 0x1d36, 
	0x07c2, 0x0001, 0x02a8, 0x1d36, 0x07c2, 0x0001, 0x02a8, 0x1d36, 
	0x07c2, 0x0001, 0x02a8, 0x1d36, 0x07c2, 0x0001, 0x02a8, 0x1d36, 
	0x07c2, 0x0001, 0x02a8, 0x1d36, 0x07c2, 0x0001, 0x02a8, 0x1d36, 
	0x07c2, 0x0001, 0x02a8, 0x2307, 0x084c, 0x0001, 0x02a8, 0x1d36, 
	0x07c2, 0x0001, 0x02a8, 0x1d36, 0x07c2, 0x0001, 0x02a8, 0x1d36, 
	0x07c2, 0x0001, 0x02a8, 0x1d36, 0x07c2, 0x0001, 0x02a8, 0x1d36, 
	0x07c2, 0x0001, 0x02a8, 0x1d36, 0x07c2, 0x0001, 0x02a8, 0x1f28, 
	0x07c2, 0x0001, 0x02a8, 0x16ec, 0x07e0, 0x0001, 0x02a8, 0x1d36, 
	0x07c2, 0x0002, 0x053a, 0x0003, 0x0882, 0x0002, 0x053a, 0x0003, 
	0x0882, 0x0003, 0x00d4, 0x0003,      0, 0x0004, 0x0006, 0x0003, 
	0x0891, 0x0005, 0x3370, 0x0003,      0, 0x0006, 0x4313, 0x0003, 
	     0, 0x0001, 0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 
	0x000e, 0x000f, 0x0015, 0x0016, 0x0017, 0x0018, 0x001e, 0x0028, 
	0x002c, 0x002d, 0x0032, 0x0033, 0x0034, 0x0036, 0x0037, 0x0038, 
	0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040, 
	0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 
	0x0049, 0x0078, 0x007d, 0x007e, 0x0087, 0x0089, 0x0090, 0x009d, 
	0x009f, 0x00a0, 0x00a2, 0x00a7, 0x00aa, 0x00ac, 0x00af, 0x00b1, 
	0x00b6, 0x00b7, 0x00ba, 0x00bc, 0x00c1, 0x00c9, 0x00ca, 0x00cb, 
	0x00cc, 0x00cd, 0x00ce, 0x00cf, 0x00d0, 0x00d1, 0x00d2, 0x00d3, 
	0x00d4, 0x00d5, 0x00d6, 0x00d7, 0x00d8, 0x00d9, 0x00da, 0x00db, 
	0x00dc, 0x00dd, 0x00de, 0x00df, 0x00e0, 0x00e1, 0x00e2, 0x00e3, 
	0x00e4, 0x00e5, 0x00e6, 0x00e7, 0x00e8, 0x00e9, 0x00ea, 0x00ec, 
	0x00ed, 0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f5, 0x00f6, 0x00f7, 
	0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fe, 0x00ff, 0x0100, 
	0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x0106, 0x0109, 0x010a, 
	0x010b, 0x010c, 0x010d, 0x010e, 0x010f, 0x0112, 0x0113, 0x0114, 
	0x0115, 0x0116, 0x0117, 0x0118, 0x0119, 0x011a, 0x011b, 0x011c, 
	0x011d, 0x011e, 0x011f, 0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 
	0x0125, 0x0126, 0x0127, 0x0128, 0x0129, 0x012a, 0x0164, 0x0165, 
	0x0166, 0x0167, 0x0168, 0x0169, 0x016a, 0x016b, 0x016c, 0x016d, 
	0x016e, 0x016f, 0x0170, 0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 
	0x0176, 0x0177, 0x0178, 0x0179, 0x017a, 0x017b, 0x017c, 0x017d, 
	0x017e, 0x017f, 0x0180, 0x0181, 0x0182, 0x0183, 0x0184, 0x0185, 
	0x0186, 0x0187, 0x0188, 0x0189, 0x018a, 0x018b, 0x018c, 0x018d, 
	0x018e, 0x018f, 0x0190, 0x0191, 0x0192, 0x0193, 0x0194, 0x0195, 
	0x0196, 0x0197, 0x0198, 0x0199, 0x019a, 0x019b, 0x019c, 0x019d, 
	0x019e, 0x019f, 0x01a0, 0x01a1, 0x01a2, 0x01a3, 0x01a4, 0x01a5, 
	0x01a6, 0x01a7, 0x01a8, 0x01a9, 0x01aa, 0x01ab, 0x01ac, 0x01ad, 
	0x01ae, 0x01af, 0x01b0, 0x01b1, 0x01b2, 0x01b3, 0x01b4, 0x01b5, 
	0x01b6, 0x01b7, 0x01b8, 0x01b9, 0x01ba, 0x01bb, 0x01bc, 0x01bd, 
	0x01be, 0x01bf, 0x01c0, 0x01c1, 0x01c2, 0x01c3, 0x01c4, 0x01c5, 
	0x01c6, 0x01c7, 0x01c8, 0x01c9, 0x01ca, 0x01cb, 0x01cc, 0x01cd, 
	0x01ce, 0x01cf, 0x01d0, 0x01d1, 0x01d2, 0x01d3, 0x01d4, 0x01d5, 
	0x01d6, 0x01d7, 0x01d8, 0x01d9, 0x01da, 0x01db, 0x01dc, 0x01dd, 
	0x01de, 0x01df, 0x01e0, 0x01e1, 0x0202, 0x0203, 0x0204, 0x0205, 
	0x0206, 0x0207, 0x020c, 0x020d, 0x020e, 0x020f, 0x0210, 0x0211, 
	0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217, 0x0218, 0x0219, 
	0x021a, 0x021b, 0x021c, 0x021d, 0x021e, 0x021f, 0x0220, 0x0221, 
	0x0222, 0x0223, 0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 
	0x022a, 0x022b, 0x022c, 0x022d, 0x022e, 0x022f, 0x0230, 0x0231, 
	0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237, 0x0238, 0x0239, 
	0x023a, 0x023b, 0x023c, 0x023d, 0x023e, 0x023f, 0x0240, 0x0241, 
	0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247, 0x0248, 0x0249, 
	0x024a, 0x024b, 0x024c, 0x024d, 0x024e, 0x024f, 0x0250, 0x0251, 
	0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257, 0x0258, 0x0259, 
	0x025a, 0x025b, 0x025c, 0x025d, 0x025e, 0x025f, 0x0260, 0x0261, 
	0x0262, 0x0263, 0x0264, 0x0265, 0x0266, 0x0267, 0x0268, 0x0269, 
	0x026a, 0x026b, 0x026c, 0x026d, 0x026e, 0x026f, 0x0270, 0x0271, 
	0x0272, 0x0273, 0x0274, 0x0275, 0x0276, 0x0277, 0x0278, 0x0279, 
	0x027a, 0x027b, 0x0280, 0x028b, 0x028c, 0x028e, 0x028f, 0x029d, 
	0x02ab, 0x02ad, 0x02af, 0x02b0, 0x02b1, 0x02b2, 0x02b3, 0x02b4, 
	0x02b5, 0x02b6, 0x02b7, 0x02ba, 0x02c4, 0x02c7, 0x02cf, 0x02d0, 
	0x02d2, 0x02d4, 0x02d5, 0x02d6, 0x02d7, 0x02d8, 0x02db, 0x02dc, 
	0x02dd, 0x02df, 0x02e6, 0x02e7, 0x02e8, 0x02e9, 0x02ea, 0x02eb, 
	0x02ec, 0x02f4, 0x02f5, 0x02f6, 0x02f7, 0x02f9, 0x02fc, 0x02fd, 
	0x02fe, 0x02ff, 0x0300, 0x0306, 0x0307, 0x0308, 0x030b, 0x030c, 
	0x030f, 0x0310, 0x0311, 0x0312, 0x0319, 0x031e, 0x0325, 0x0326, 
	0x0328, 0x032a, 0x032b, 0x032c, 0x0330, 0x0332, 0x0333, 0x0334, 
	0x0335, 0x033a, 0x033b, 0x033c, 0x033e, 0x033f, 0x0340, 0x0341, 
	0x0348, 0x034b, 0x034c, 0x035b, 0x035c, 0x035e, 0x035f, 0x036d, 
	0x037b, 0x037d, 0x037f, 0x0380, 0x0381, 0x0382, 0x0383, 0x0384, 
	0x0385, 0x0386, 0x0387, 0x038a, 0x0394, 0x0397, 0x039f, 0x03a0, 
	0x03a2, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03ab, 0x03ac, 
	0x03ae, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba, 0x03bb, 
	0x03c3, 0x03c4, 0x03c5, 0x03c7, 0x03ca, 0x03cb, 0x03cc, 0x03cd, 
	0x03d3, 0x03d4, 0x03d5, 0x03d8, 0x03d9, 0x03dc, 0x03dd, 0x03de, 
	0x03df, 0x03e6, 0x03ea, 0x03f1, 0x03f2, 0x03f4, 0x03f6, 0x03f7, 
	0x03f8, 0x03fc, 0x03fe, 0x03ff, 0x0400, 0x0401, 0x0406, 0x0407, 
	0x0408, 0x040a, 0x040b, 0x040c, 0x040d, 0x0414, 0x0417, 0x0454, 
	0x0455, 0x0457, 0x0458, 0x0459, 0x045a, 0x045b, 0x045c, 0x045d, 
	0x045e, 0x045f, 0x0460, 0x0461, 0x0462, 0x0463, 0x0464, 0x0465, 
	0x0466, 0x0467, 0x0468, 0x0469, 0x046a, 0x046b, 0x046c, 0x046d, 
	0x046e, 0x0473, 0x0474, 0x0475, 0x0476, 0x0477, 0x047b, 0x0485, 
	0x0486, 0x049f, 0x04a0, 0x04a1, 0x04a2, 0x04a3, 0x04a4, 0x04a5, 
	0x04a6, 0x04a9, 0x04aa, 0x04ab, 0x04ac, 0x04ad, 0x04ae, 0x04af, 
	0x04b0, 0x04b1, 0x04b2, 0x04b3, 0x04b4, 0x04b5, 0x04b6, 0x04b7, 
	0x04b8, 0x04b9, 0x04ba, 0x04bb, 0x04bc, 0x04bd, 0x04be, 0x04bf, 
	0x04c0, 0x04c1, 0x04c2, 0x04c3, 0x04c4, 0x04c5, 0x04c6, 0x04c7, 
	0x04c8, 0x04c9, 0x04ca, 0x04cb, 0x04cc, 0x04ce, 0x04cf, 0x04d0, 
	0x04d1, 0x04d2, 0x04d3, 0x04d4, 0x04d5, 0x04d6, 0x04d7, 0x04d8, 
	0x04d9, 0x04da, 0x04db, 0x04dc, 0x04dd, 0x04de, 0x04df, 0x04e0, 
	0x04e1, 0x04e2, 0x04e3, 0x04e4, 0x04e5, 0x04e6, 0x04e7, 0x04e8, 
	0x04e9, 0x04ea, 0x04eb, 0x04ec, 0x04ed, 0x04ee, 0x04ef, 0x04f0, 
	0x04f1, 0x04f2, 0x04f3, 0x04f4, 0x04f5, 0x04f6, 0x04f7, 0x04f8, 
	0x04f9, 0x04fa, 0x04fb, 0x050c, 0x050d, 0x050e, 0x050f, 0x0510, 
	0x0511, 0x0512, 0x0513, 0x0514, 0x0515, 0x0516, 0x0517, 0x0518, 
	0x0519, 0x051a, 0x051b, 0x051c, 0x051d, 0x0526, 0x0527, 0x0544, 
	0x0545, 0x0546, 0x0547, 0x054c, 0x054d, 0x054e, 0x054f, 0x0558, 
	0x0559, 0x055b, 0x055c, 0x055d, 0x055e, 0x0561, 0x0562, 0x0563, 
	0x0564, 0x0567, 0x0568, 0x0569, 0x056a, 0x056b, 0x056c, 0x056d, 
	0x056e, 0x056f, 0x0572, 0x0573, 0x0574, 0x0575, 0x0576, 0x0577, 
	0x0578, 0x057b, 0x057c, 0x057d, 0x057e, 0x057f, 0x0580, 0x0581, 
	0x0582, 0x0583, 0x0584, 0x0585, 0x0586, 0x0587, 0x0588, 0x0589, 
	0x058a, 0x058b, 0x058c, 0x058d, 0x058e, 0x058f, 0x0590, 0x0591, 
	0x0592, 0x0593, 0x0594, 0x0595, 0x0596, 0x0597, 0x0598, 0x0599, 
	0x059a, 0x059b, 0x059c, 0x059d, 0x059e, 0x059f, 0x05a0, 0x05a1, 
	0x05a2, 0x05a3, 0x05a4, 0x05a5, 0x05a6, 0x05a7, 0x05a8, 0x05a9, 
	0x05aa, 0x05ab, 0x05ac, 0x05ad, 0x05ae, 0x05af, 0x05b0, 0x05b1, 
	0x05b2, 0x05b3, 0x05b4, 0x05b5, 0x05b6, 0x05b7, 0x05b8, 0x05b9, 
	0x05ba, 0x05bb, 0x05bc, 0x05bd, 0x05be, 0x05bf, 0x05c0, 0x05c1, 
	0x05c2, 0x05c3, 0x05c4, 0x05c5, 0x05c6, 0x05c7, 0x05c8, 0x05c9, 
	0x05ca, 0x05cb, 0x05cc, 0x05cd, 0x05ce, 0x05cf, 0x05d0, 0x05d1, 
	0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7, 0x05d8, 0x05d9, 
	0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df, 0x05e0, 0x05e1, 
	0x05e3, 0x05e9, 0x05f0, 0x05f1, 0x05f3, 0x05f9, 0x05fa, 0x05fb, 
	0x05fd, 0x0600, 0x0601, 0x0604, 0x0606, 0x0607, 0x0608, 0x0609, 
	0x060c, 0x060f, 0x0610, 0x0612, 0x0613, 0x0616, 0x0617, 0x0618, 
	0x061a, 0x061c, 0x061d, 0x061e, 0x061f, 0x0620, 0x0621, 0x0623, 
	0x062a, 0x0630, 0x0631, 0x0633, 0x0639, 0x063c, 0x063e, 0x0641, 
	0x0642, 0x0645, 0x0647, 0x0648, 0x0649, 0x064a, 0x064d, 0x0650, 
	0x0651, 0x0653, 0x0654, 0x0657, 0x0658, 0x0659, 0x065b, 0x065d, 
	0x065e, 0x0002, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x0029, 
	0x0030, 0x0031, 0x0084, 0x008d, 0x0097, 0x0099, 0x009b, 0x00a9, 
	0x00b9, 0x00c7, 0x00c8, 0x00eb, 0x012b, 0x012c, 0x012d, 0x012e, 
	0x0130, 0x0131, 0x0133, 0x0134, 0x0136, 0x0137, 0x0138, 0x0139, 
	0x013a, 0x013b, 0x013d, 0x013e, 0x013f, 0x0140, 0x0141, 0x0143, 
	0x0144, 0x0145, 0x0146, 0x0148, 0x0149, 0x014b, 0x014c, 0x014d, 
	0x014e, 0x014f, 0x0150, 0x0151, 0x0153, 0x0155, 0x0156, 0x0158, 
	0x0159, 0x015b, 0x015c, 0x015d, 0x015e, 0x015f, 0x0160, 0x0161, 
	0x0162, 0x0163, 0x01f2, 0x01f3, 0x01f4, 0x01f5, 0x01f6, 0x01f7, 
	0x01f8, 0x01f9, 0x01fa, 0x01fb, 0x01fc, 0x01fd, 0x01fe, 0x01ff, 
	0x0200, 0x0201, 0x0281, 0x0282, 0x0283, 0x0284, 0x0288, 0x0289, 
	0x028a, 0x028d, 0x0296, 0x0297, 0x0298, 0x0299, 0x029a, 0x02aa, 
	0x02ac, 0x02c1, 0x02c2, 0x02c3, 0x02ca, 0x02cb, 0x02cc, 0x02d1, 
	0x02d3, 0x02da, 0x02f3, 0x02f8, 0x0303, 0x0304, 0x0305, 0x031a, 
	0x031b, 0x031c, 0x031d, 0x0327, 0x032e, 0x032f, 0x0331, 0x0337, 
	0x0349, 0x034a, 0x0351, 0x0352, 0x0353, 0x0354, 0x0358, 0x0359, 
	0x035a, 0x035d, 0x0366, 0x0367, 0x0368, 0x0369, 0x036a, 0x037a, 
	0x037c, 0x0391, 0x0392, 0x0393, 0x039a, 0x039b, 0x039c, 0x03a1, 
	0x03a3, 0x03aa, 0x03c2, 0x03c6, 0x03d0, 0x03d1, 0x03d2, 0x03e7, 
	0x03e8, 0x03e9, 0x03f3, 0x03fa, 0x03fb, 0x03fd, 0x0403, 0x0415, 
	0x0416, 0x0418, 0x043c, 0x043d, 0x043e, 0x043f, 0x0440, 0x0441, 
	0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 
	0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f, 0x0450, 0x0451, 
	0x0452, 0x0453, 0x0456, 0x0471, 0x0472, 0x0478, 0x0479, 0x047a, 
	0x0482, 0x0483, 0x0484, 0x0487, 0x0497, 0x0498, 0x0499, 0x049a, 
	0x049b, 0x049c, 0x049d, 0x049e, 0x04a7, 0x04a8, 0x0504, 0x0505, 
	0x0506, 0x0507, 0x0508, 0x0509, 0x050a, 0x050b, 0x051e, 0x051f, 
	0x0520, 0x0521, 0x0522, 0x0523, 0x0524, 0x0525, 0x0542, 0x0543, 
	0x0548, 0x0549, 0x054a, 0x054b, 0x0550, 0x0551, 0x0552, 0x0553, 
	0x0554, 0x0555, 0x0556, 0x0557, 0x05e7, 0x05ed, 0x05ee, 0x05ef, 
	0x05f2, 0x05f7, 0x05f8, 0x05ff, 0x0603, 0x060a, 0x060b, 0x060e, 
	0x0615, 0x0619, 0x061b, 0x0627, 0x0629, 0x062e, 0x062f, 0x0632, 
	0x0637, 0x0638, 0x063b, 0x0640, 0x0644, 0x064b, 0x064c, 0x064f, 
	0x0656, 0x065a, 0x065c, 0x0004, 0x0008, 0x0009, 0x000a, 0x000b, 
	0x000c, 0x000d, 0x000e, 0x000f, 0x0010, 0x0011, 0x0012, 0x0013, 
	0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001a, 0x001b, 
	0x001c, 0x001d, 0x001e, 0x001f, 0x0020, 0x0021, 0x0022, 0x0023, 
	0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002a, 0x002b, 
	0x002c, 0x002d, 0x002e, 0x002f, 0x0030, 0x0031, 0x0032, 0x0033, 
	0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x003a, 0x003b, 
	0x003c, 0x003d, 0x003e, 0x003f, 0x0040, 0x0041, 0x0042, 0x0043, 
	0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004a, 0x004b, 
	0x004c, 0x004d, 0x004e, 0x004f, 0x0050, 0x0054, 0x0055, 0x0056, 
	0x0057, 0x0058, 0x0059, 0x005a, 0x005b, 0x005d, 0x005e, 0x005f, 
	0x0060, 0x0061, 0x0062, 0x0063, 0x0065, 0x0066, 0x0067, 0x0068, 
	0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070, 
	0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 
	0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 0x0080, 
	0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 0x0088, 
	0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008e, 0x008f, 0x0090, 
	0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098, 
	0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f, 0x00a0, 
	0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 0x00a8, 
	0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 0x00b0, 
	0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 0x00b8, 
	0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 0x00c0, 
	0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 0x00c8, 
	0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00ce, 0x00cf, 0x00d0, 0x00d1, 
	0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 0x00d8, 0x00d9, 
	0x00da, 0x00db, 0x00dc, 0x00de, 0x00df, 0x00e0, 0x00e1, 0x00e2, 
	0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7, 0x00e8, 0x00e9, 0x00ea, 
	0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef, 0x00f0, 0x00f1, 0x00f2, 
	0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 0x00f8, 0x00f9, 0x00fa, 
	0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff, 0x0100, 0x0101, 0x0102, 
	0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010a, 
	0x010b, 0x010c, 0x010d, 0x010e, 0x010f, 0x0110, 0x0111, 0x0112, 
	0x0113, 0x0114, 0x0115, 0x0116, 0x0117, 0x0118, 0x0119, 0x011a, 
	0x011b, 0x011c, 0x011d, 0x011e, 0x011f, 0x0120, 0x0121, 0x0122, 
	0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128, 0x0129, 0x012a, 
	0x012b, 0x012c, 0x012d, 0x012e, 0x012f, 0x0130, 0x0131, 0x0132, 
	0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 0x0138, 0x0139, 0x013a, 
	0x013b, 0x013c, 0x013d, 0x013e, 0x013f, 0x0140, 0x0142, 0x0143, 
	0x0145, 0x0146, 0x0147, 0x0148, 0x0149, 0x014a, 0x014b, 0x014c, 
	0x014d, 0x014e, 0x014f, 0x0150, 0x0151, 0x0152, 0x0153, 0x0154, 
	0x0155, 0x0156, 0x0157, 0x0158, 0x0159, 0x015a, 0x015b, 0x015c, 
	0x015d, 0x015e, 0x015f, 0x0160, 0x0161, 0x0162, 0x0163, 0x0164, 
	0x0165, 0x0166, 0x0167, 0x0168, 0x0169, 0x016a, 0x016b, 0x016c, 
	0x016d, 0x016e, 0x016f, 0x0170, 0x0171, 0x0172, 0x0174, 0x0175, 
	0x0176, 0x0177, 0x0178, 0x0179, 0x017a, 0x017b, 0x017c, 0x017d, 
	0x017e, 0x017f, 0x0180, 0x0181, 0x0182, 0x0183, 0x0184, 0x0185, 
	0x0186, 0x0187, 0x0188, 0x0189, 0x018a, 0x018b, 0x018c, 0x018d, 
	0x018e, 0x018f, 0x0190, 0x0191, 0x0192, 0x0193, 0x0194, 0x0195, 
	0x0196, 0x0197, 0x0198, 0x0199, 0x019a, 0x019b, 0x019c, 0x019d, 
	0x019e, 0x019f, 0x01a0, 0x01a1, 0x01a2, 0x01a3, 0x01a4, 0x01a5, 
	0x01a6, 0x01a7, 0x01a8, 0x01a9, 0x01aa, 0x01ab, 0x01ac, 0x01ad, 
	0x01ae, 0x01af, 0x01b0, 0x01b1, 0x01b2, 0x01b3, 0x01b4, 0x01b5, 
	0x01b6, 0x01b7, 0x01b8, 0x01b9, 0x01ba, 0x01bb, 0x01bc, 0x01be, 
	0x01c0, 0x01c1, 0x01c2, 0x01c3, 0x01c4, 0x01c5, 0x01c6, 0x01c7, 
	0x01c8, 0x01cc, 0x01d0, 0x01d4, 0x01d8, 0x01da, 0x01db, 0x01dd, 
	0x01de, 0x01e0, 0x01e2, 0x01e3, 0x01e5, 0x01e6, 0x01e8, 0x01e9, 
	0x01ea, 0x01ed, 0x01ee, 0x01f0, 0x01f1, 0x01f2, 0x01f5, 0x01f6, 
	0x01f8, 0x01f9, 0x01fa, 0x01fc, 0x01fd, 0x01ff, 0x0200, 0x0201, 
	0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0224, 0x0225, 0x0226, 
	0x0227, 0x0228, 0x0229, 0x022a, 0x022b, 0x022c, 0x022d, 0x022e, 
	0x022f, 0x0230, 0x0231, 0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 
	0x0237, 0x0238, 0x0239, 0x023a, 0x023b, 0x023c, 0x023d, 0x023e, 
	0x023f, 0x0240, 0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 
	0x0247, 0x0248, 0x0249, 0x024a, 0x024b, 0x024c, 0x024d, 0x024e, 
	0x024f, 0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 
	0x0257, 0x0258, 0x0259, 0x025a, 0x025b, 0x025c, 0x025d, 0x025e, 
	0x025f, 0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 0x0265, 0x0266, 
	0x0267, 0x0268, 0x0269, 0x026a, 0x026b, 0x026c, 0x026d, 0x026e, 
	0x026f, 0x0270, 0x0271, 0x0272, 0x0273, 0x0274, 0x0275, 0x0276, 
	0x0277, 0x0278, 0x0279, 0x027a, 0x027b, 0x027c, 0x027d, 0x027e, 
	0x027f, 0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286, 
	0x0287, 0x0288, 0x0289, 0x028a, 0x028b, 0x028c, 0x028d, 0x028e, 
	0x028f, 0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 
	0x0297, 0x0298, 0x0299, 0x029a, 0x029b, 0x029c, 0x029d, 0x029e, 
	0x029f, 0x02a0, 0x02a1, 0x02a2, 0x02a3, 0x02a4, 0x02a5, 0x02a6, 
	0x02a7, 0x02a8, 0x02a9, 0x02aa, 0x02ab, 0x02ac, 0x02ad, 0x02ae, 
	0x02af, 0x02b0, 0x02b1, 0x02b2, 0x02b3, 0x02b4, 0x02b5, 0x02b6, 
	0x02b7, 0x02b8, 0x02b9, 0x02ba, 0x02bb, 0x02bc, 0x02bd, 0x02be, 
	0x02bf, 0x02c0, 0x02c1, 0x02c2, 0x02c3, 0x02c4, 0x02c5, 0x02c6, 
	0x02c7, 0x02c8, 0x02c9, 0x02ca, 0x02cb, 0x02cc, 0x02cd, 0x02ce, 
	0x02cf, 0x02d0, 0x02d1, 0x02d2, 0x02d3, 0x02d4, 0x02d5, 0x02d6, 
	0x02d7, 0x02d8, 0x02d9, 0x02da, 0x02db, 0x02dc, 0x02dd, 0x02de, 
	0x02df, 0x02e0, 0x02e1, 0x02e2, 0x02e3, 0x02e4, 0x02e5, 0x02e6, 
	0x02e7, 0x02e8, 0x02e9, 0x02ea, 0x02eb, 0x02ec, 0x02ed, 0x02ee, 
	0x02ef, 0x02f0, 0x02f3, 0x030f, 0x0310, 0x0311, 0x0314, 0x0315, 
	0x0316, 0x0317, 0x0318, 0x0319, 0x031a, 0x031b, 0x031c, 0x031d, 
	0x031e, 0x031f, 0x0320, 0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 
	0x0326, 0x0327, 0x0328, 0x0329, 0x032a, 0x032b, 0x032c, 0x032d, 
	0x032e, 0x032f, 0x0330, 0x0331, 0x0332, 0x0333, 0x0338, 0x0339, 
	0x033c, 0x033d, 0x033e, 0x033f, 0x0340, 0x0341, 0x0342, 0x0343, 
	0x0348, 0x0349, 0x034a, 0x0353, 0x0354, 0x0355, 0x0356, 0x0357, 
	0x0358, 0x0359, 0x035a, 0x035b, 0x035c, 0x035d, 0x0360, 0x0361, 
	0x0364, 0x0365, 0x0366, 0x0367, 0x036a, 0x036b, 0x036c, 0x0371, 
	0x0372, 0x0373, 0x0374, 0x0375, 0x0376, 0x0377, 0x0378, 0x037b, 
	0x037c, 0x037d, 0x037e, 0x037f, 0x0380, 0x0381, 0x0388, 0x0389, 
	0x038c, 0x038d, 0x038e, 0x038f, 0x0390, 0x0391, 0x0392, 0x0393, 
	0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039a, 0x039b, 
	0x039c, 0x039d, 0x039e, 0x039f, 0x03a0, 0x03a1, 0x03a2, 0x03a3, 
	0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0x03aa, 0x03ab, 
	0x03ac, 0x03ad, 0x03ae, 0x03af, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 
	0x03b8, 0x03b9, 0x03ba, 0x03bd, 0x03be, 0x03bf, 0x03c0, 0x03c1, 
	0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9, 
	0x03ca, 0x03cb, 0x03cc, 0x03d1, 0x03d2, 0x03d3, 0x03d4, 0x03d5, 
	0x03d6, 0x03d7, 0x03d8, 0x03db, 0x03dc, 0x03dd, 0x03e0, 0x03e1, 
	0x03e2, 0x03e3, 0x03e4, 0x03e5, 0x03e6, 0x03e7, 0x03e8, 0x03e9, 
	0x03ea, 0x03eb, 0x03ec, 0x03ed, 0x03ee, 0x03ef, 0x03f0, 0x03f4, 
	0x03f7, 0x03f8, 0x03f9, 0x03fa, 0x03fb, 0x03fc, 0x03fd, 0x03fe, 
	0x03ff, 0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 
	0x0407, 0x0408, 0x0409, 0x040a, 0x040b, 0x040c, 0x040f, 0x0410, 
	0x0411, 0x0412, 0x0415, 0x041d, 0x041e, 0x041f, 0x0420, 0x0421, 
	0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 
	0x042a, 0x042b, 0x042c, 0x042d, 0x0430, 0x0431, 0x0432, 0x0436, 
	0x0437, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 
	0x043f, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044a, 
	0x044f, 0x0450, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 
	0x0457, 0x0458, 0x0459, 0x045c, 0x045d, 0x0460, 0x0461, 0x0462, 
	0x0463, 0x0466, 0x0467, 0x0468, 0x0469, 0x046a, 0x046b, 0x0472, 
	0x0473, 0x0474, 0x0477, 0x0478, 0x0479, 0x047a, 0x047b, 0x047c, 
	0x047d, 0x047e, 0x047f, 0x0480, 0x0481, 0x0482, 0x0483, 0x0484, 
	0x0485, 0x0486, 0x0487, 0x0488, 0x0489, 0x048a, 0x048b, 0x048c, 
	0x0491, 0x0492, 0x0495, 0x0496, 0x0497, 0x0498, 0x0499, 0x049a, 
	0x049f, 0x04a0, 0x04a1, 0x04a2, 0x04a5, 0x04a6, 0x04a7, 0x04a8, 
	0x04a9, 0x04aa, 0x04ab, 0x04ac, 0x04ad, 0x04ae, 0x04af, 0x04b0, 
	0x04b1, 0x04b2, 0x04b3, 0x04b4, 0x04b5, 0x04ba, 0x04bb, 0x04bc, 
	0x04bd, 0x04be, 0x04bf, 0x04c0, 0x04c1, 0x04c2, 0x04c3, 0x04c5, 
	0x04c6, 0x04c7, 0x04c8, 0x04c9, 0x04ca, 0x04cb, 0x04cc, 0x04cd, 
	0x04ce, 0x04cf, 0x04d0, 0x04d1, 0x04d2, 0x04d5, 0x04d6, 0x04d7, 
	0x04d8, 0x04d9, 0x04dc, 0x04dd, 0x04de, 0x04e1, 0x04e2, 0x04e3, 
	0x04e4, 0x04e7, 0x04e8, 0x04e9, 0x04ea, 0x04eb, 0x04ec, 0x04ed, 
	0x04ee, 0x04f1, 0x04fc, 0x04fd, 0x04fe, 0x04ff, 0x0500, 0x0501, 
	0x0502, 0x0503, 0x0504, 0x0505, 0x0506, 0x0507, 0x0508, 0x0509, 
	0x050a, 0x050b, 0x050c, 0x050d, 0x050e, 0x050f, 0x0512, 0x0513, 
	0x0516, 0x0517, 0x0518, 0x0519, 0x051a, 0x051b, 0x051c, 0x051d, 
	0x051e, 0x051f, 0x0520, 0x0521, 0x0522, 0x0523, 0x0526, 0x0527, 
	0x0528, 0x0529, 0x052a, 0x052b, 0x052c, 0x052d, 0x0530, 0x0531, 
	0x0532, 0x0533, 0x0534, 0x0535, 0x0536, 0x0537, 0x0538, 0x0539, 
	0x053a, 0x053b, 0x053e, 0x053f, 0x0540, 0x0541, 0x0542, 0x0543, 
	0x0544, 0x0545, 0x0546, 0x0547, 0x0548, 0x0549, 0x054a, 0x054b, 
	0x054c, 0x054d, 0x054e, 0x054f, 0x0550, 0x0559, 0x0570, 0x0571, 
	0x0572, 0x0573, 0x0574, 0x0575, 0x0576, 0x0577, 0x057c, 0x057d, 
	0x057e, 0x057f, 0x0580, 0x0581, 0x0582, 0x0583, 0x0584, 0x0585, 
	0x0586, 0x0587, 0x0588, 0x0589, 0x0593, 0x0594, 0x0599, 0x059a, 
	0x059b, 0x059c, 0x059d, 0x059e, 0x059f, 0x05b8, 0x05b9, 0x05ba, 
	0x05bb, 0x05bc, 0x05bd, 0x05be, 0x05bf, 0x05c0, 0x05c1, 0x05c2, 
	0x05c3, 0x05c4, 0x05c5, 0x05c6, 0x05c7, 0x05c8, 0x05c9, 0x05ca, 
	0x05cb, 0x05cc, 0x05cd, 0x05ce, 0x05cf, 0x05d0, 0x05d1, 0x05d2, 
	0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7, 0x05d8, 0x05d9, 0x05da, 
	0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df, 0x05e0, 0x05e1, 0x05e2, 
	0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7, 0x05e8, 0x05e9, 0x05ea, 
	0x05eb, 0x05ec, 0x05ed, 0x05ee, 0x05ef, 0x05f0, 0x05f1, 0x05f2, 
	0x05f3, 0x05f4, 0x05f5, 0x05f6, 0x05f7, 0x05f8, 0x05f9, 0x05fa, 
	0x05fb, 0x05fc, 0x05fd, 0x05fe, 0x05ff, 0x0600, 0x0601, 0x0602, 
	0x0603, 0x0604, 0x0605, 0x0606, 0x0607, 0x0608, 0x0609, 0x060a, 
	0x060b, 0x060c, 0x060d, 0x060e, 0x060f, 0x0610, 0x0611, 0x0612, 
	0x0613, 0x0614, 0x0615, 0x0616, 0x0617, 0x0618, 0x0619, 0x061a, 
	0x061b, 0x061c, 0x061d, 0x061e, 0x061f, 0x0620, 0x0621, 0x0622, 
	0x0623, 0x0624, 0x0625, 0x0626, 0x0627, 0x0628, 0x0629, 0x062a, 
	0x062b, 0x062c, 0x062d, 0x062e, 0x062f, 0x0630, 0x0631, 0x0632, 
	0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 0x0638, 0x0639, 0x063a, 
	0x063b, 0x063c, 0x063d, 0x063e, 0x063f, 0x0640, 0x0641, 0x0642, 
	0x0643, 0x0644, 0x0645, 0x0646, 0x0647, 0x0648, 0x0649, 0x064a, 
	0x064b, 0x064c, 0x064d, 0x064e, 0x064f, 0x0650, 0x0651, 0x0652, 
	0x0653, 0x0654, 0x0655, 0x0656, 0x0657, 0x0658, 0x0659, 0x065a, 
	0x065b, 0x065c, 0x065d, 0x065e, 0x065f, 0x0660, 0x0661, 0x0662, 
	0x0663, 0x0664, 0x0665, 0x0666, 0x0667, 0x0668, 0x0669, 0x066a, 
	0x066b, 0x066c, 0x066d, 0x066e, 0x066f, 0x0670, 0x0671, 0x0672, 
	0x0673, 0x0674, 0x0675, 0x0676, 0x0677, 0x0678, 0x0679, 0x067a, 
	0x067b, 0x067c, 0x067d, 0x067e, 0x067f, 0x0680, 0x0681, 0x0682, 
	0x0683, 0x0684, 0x0685, 0x0686, 0x0687, 0x0688, 0x0689, 0x068a, 
	0x068b, 0x068c, 0x068d, 0x068e, 0x068f, 0x0690, 0x0691, 0x0692, 
	0x0693, 0x0694, 0x0695, 0x0696, 0x0697, 0x0698, 0x0699, 0x069a, 
	0x069b, 0x069c, 0x069d, 0x069e, 0x069f, 0x06a0, 0x06a1, 0x06a2, 
	0x06a3, 0x06a4, 0x06a5, 0x06a6, 0x06a7, 0x06a8, 0x06a9, 0x06aa, 
	0x06ab, 0x06ac, 0x06ad, 0x06ae, 0x06af, 0x06b0, 0x06b1, 0x06b2, 
	0x06b3, 0x06b4, 0x06b5, 0x06b6, 0x06b7, 0x06b8, 0x06b9, 0x06ba, 
	0x06bb, 0x06bc, 0x06bd, 0x06be, 0x06bf, 0x06c0, 0x06c1, 0x06c2, 
	0x06c3, 0x06c4, 0x06c5, 0x06c6, 0x06c7, 0x06c8, 0x06c9, 0x06ca, 
	0x06cb, 0x06cc, 0x06cd, 0x06ce, 0x06cf, 0x06d0, 0x06d1, 0x06d2, 
	0x06d3, 0x06d4, 0x06d5, 0x06d6, 0x06d7, 0x06d8, 0x06d9, 0x06da, 
	0x06db, 0x06dc, 0x06dd, 0x06de, 0x06df, 0x06e0, 0x06e1, 0x06e2, 
	0x06e3, 0x06e4, 0x06e5, 0x06e6, 0x06e7, 0x06e8, 0x06e9, 0x06ea, 
	0x06eb, 0x06ec, 0x06ed, 0x06ee, 0x06ef, 0x06f0, 0x06f1, 0x06f2, 
	0x06f3, 0x06f4, 0x06f5, 0x06f6, 0x06f7, 0x06f8, 0x06f9, 0x06fa, 
	0x06fb, 0x06fc, 0x06fd, 0x06fe, 0x06ff, 0x0700, 0x0701, 0x0702, 
	0x0703, 0x0704, 0x0705, 0x0706, 0x0707, 0x0708, 0x0709, 0x070a, 
	0x070b, 0x070c, 0x070d, 0x070e, 0x070f, 0x0710, 0x0711, 0x0712, 
	0x0713, 0x0714, 0x0715, 0x0716, 0x0717, 0x0718, 0x0719, 0x071a, 
	0x071b, 0x071c, 0x071d, 0x071e, 0x071f, 0x0720, 0x0721, 0x0722, 
	0x0723, 0x0724, 0x0725, 0x0726, 0x0727, 0x0728, 0x0729, 0x072a, 
	0x072b, 0x072c, 0x072d, 0x072e, 0x072f, 0x0730, 0x0731, 0x0732, 
	0x0733, 0x0734, 0x0735, 0x0736, 0x0737, 0x0738, 0x0739, 0x073a, 
	0x073b, 0x073c, 0x073d, 0x073e, 0x073f, 0x0740, 0x0741, 0x0742, 
	0x0743, 0x0744, 0x0745, 0x0746, 0x0747, 0x0748, 0x0749, 0x074a, 
	0x074b, 0x074c, 0x074d, 0x074e, 0x074f, 0x0750, 0x0751, 0x0752, 
	0x0753, 0x0754, 0x0755, 0x0756, 0x0757, 0x0758, 0x0759, 0x075a, 
	0x075b, 0x075c, 0x075d, 0x075e, 0x075f, 0x0760, 0x0761, 0x0762, 
	0x0763, 0x0764, 0x0765, 0x0766, 0x0767, 0x0768, 0x0769, 0x076a, 
	0x076b, 0x076c, 0x076d, 0x076e, 0x076f, 0x0770, 0x0771, 0x0772, 
	0x0773, 0x0774, 0x0775, 0x0776, 0x0777, 0x0778, 0x0779, 0x077a, 
	0x077b, 0x077c, 0x077d, 0x077e, 0x077f, 0x0780, 0x0781, 0x0782, 
	0x0783, 0x0784, 0x0785, 0x0786, 0x0787, 0x0788, 0x0789, 0x078a, 
	0x078b, 0x078c, 0x078d, 0x078e, 0x078f, 0x0790, 0x0791, 0x0792, 
	0x0793, 0x0794, 0x0795, 0x0796, 0x0797, 0x0798, 0x0799, 0x079a, 
	0x079b, 0x079c, 0x079d, 0x079e, 0x079f, 0x07a0, 0x07a1, 0x07a2, 
	0x07a3, 0x07a4, 0x07a5, 0x07a6, 0x07a7, 0x07a8, 0x07a9, 0x07aa, 
	0x07ab, 0x07ac, 0x07ad, 0x07ae, 0x07af, 0x07b0, 0x07b1, 0x07b2, 
	0x07b3, 0x07b4, 0x07b5, 0x07b6, 0x07b7, 0x07b8, 0x07b9, 0x07ba, 
	0x07bb, 0x07bc, 0x07bd, 0x07be, 0x07bf, 0x07c0, 0x07c1, 0x07c2, 
	0x07c3, 0x07c4, 0x07c5, 0x07c6, 0x07c7, 0x07c8, 0x07c9, 0x07ca, 
	0x07cb, 0x07cc, 0x07cd, 0x07ce, 0x07cf, 0x07d0, 0x07d1, 0x07d2, 
	0x07d3, 0x07d4, 0x07d5, 0x07d6, 0x07d7, 0x07d8, 0x07d9, 0x07da, 
	0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 
	0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f, 0x0010, 
	0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 
	0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f, 0x0020, 
	0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 
	0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030, 
	0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 
	0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040, 
	0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 
	0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050, 
	0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 
	0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 0x0060, 
	0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 
	0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070, 
	0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 
	0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 0x0080, 
	0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 0x0088, 
	0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008e, 0x008f, 0x0090, 
	0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098, 
	0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f, 0x00a0, 
	0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 0x00a8, 
	0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 0x00b0, 
	0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 0x00b8, 
	0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 0x00c0, 
	0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 0x00c8, 
	0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 0x00d0, 
	0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 0x00d8, 
	0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df, 0x00e0, 
	0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7, 0x00e8, 
	0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef, 0x00f0, 
	0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 0x00f8, 
	0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff, 0x0100, 
	0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108, 
	0x0109, 0x010a, 0x010b, 0x010c, 0x010d, 0x010e, 0x010f, 0x0110, 
	0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116, 0x0117, 0x0118, 
	0x0119, 0x011a, 0x011b, 0x011c, 0x011d, 0x011e, 0x011f, 0x0120, 
	0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128, 
	0x0129, 0x012a, 0x012b, 0x012c, 0x012d, 0x012e, 0x012f, 0x0130, 
	0x0131, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 0x0138, 
	0x0139, 0x013a, 0x013b, 0x013c, 0x013d, 0x013e, 0x013f, 0x0140, 
	0x0141, 0x0142, 0x0143, 0x0144, 0x0145, 0x0146, 0x0147, 0x0148, 
	0x0149, 0x014a, 0x014b, 0x014c, 0x014d, 0x014e, 0x014f, 0x0150, 
	0x0151, 0x0152, 0x0153, 0x0154, 0x0155, 0x0156, 0x0157, 0x0158, 
	0x0159, 0x015a, 0x015b, 0x015c, 0x015d, 0x015e, 0x015f, 0x0160, 
	0x0161, 0x0162, 0x0163, 0x0164, 0x0165, 0x0166, 0x0167, 0x0168, 
	0x0169, 0x016a, 0x016b, 0x016c, 0x016d, 0x016e, 0x016f, 0x0170, 
	0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 0x0176, 0x0177, 0x0178, 
	0x0179, 0x017a, 0x017b, 0x017c, 0x017d, 0x017e, 0x017f, 0x0180, 
	0x0181, 0x0182, 0x0183, 0x0184, 0x0185, 0x0186, 0x0187, 0x0188, 
	0x0189, 0x018a, 0x018b, 0x018c, 0x018d, 0x018e, 0x018f, 0x0190, 
	0x0191, 0x0192, 0x0193, 0x0194, 0x0195, 0x0196, 0x0197, 0x0198, 
	0x0199, 0x019a, 0x019b, 0x019c, 0x019d, 0x019e, 0x019f, 0x01a0, 
	0x01a1, 0x01a2, 0x01a3, 0x01a4, 0x01a5, 0x01a6, 0x01a7, 0x01a8, 
	0x01a9, 0x01aa, 0x01ab, 0x01ac, 0x01ad, 0x01ae, 0x01af, 0x01b0, 
	0x01b1, 0x01b2, 0x01b3, 0x01b4, 0x01b5, 0x01b6, 0x01b7, 0x01b8, 
	0x01b9, 0x01ba, 0x01bb, 0x01bc, 0x01bd, 0x01be, 0x01bf, 0x01c0, 
	0x01c1, 0x01c2, 0x01c3, 0x01c4, 0x01c5, 0x01c6, 0x01c7, 0x01c8, 
	0x01c9, 0x01ca, 0x01cb, 0x01cc, 0x01cd, 0x01ce, 0x01cf, 0x01d0, 
	0x01d1, 0x01d2, 0x01d3, 0x01d4, 0x01d5, 0x01d6, 0x01d7, 0x01d8, 
	0x01d9, 0x01da, 0x01db, 0x01dc, 0x01dd, 0x01de, 0x01df, 0x01e0, 
	0x01e1, 0x01e2, 0x01e3, 0x01e4, 0x01e5, 0x01e6, 0x01e7, 0x01e8, 
	0x01e9, 0x01ea, 0x01eb, 0x01ec, 0x01ed, 0x01ee, 0x01ef, 0x01f0, 
	0x01f1, 0x01f2, 0x01f3, 0x01f4, 0x01f5, 0x01f6, 0x01f7, 0x01f8, 
	0x01f9, 0x01fa, 0x01fb, 0x01fc, 0x01fd, 0x01fe, 0x01ff, 0x0200, 
	0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208, 
	0x0209, 0x020a, 0x020b, 0x020c, 0x020d, 0x020e, 0x020f, 0x0210, 
	0x0211, 0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217, 0x0218, 
	0x0219, 0x021a, 0x021b, 0x021c, 0x021d, 0x021e, 0x021f, 0x0220, 
	0x0221, 0x0222, 0x0223, 0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 
	0x0229, 0x022a, 0x022b, 0x022c, 0x022d, 0x022e, 0x022f, 0x0230, 
	0x0231, 0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237, 0x0238, 
	0x0239, 0x023a, 0x023b, 0x023c, 0x023d, 0x023e, 0x023f, 0x0240, 
	0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247, 0x0248, 
	0x0249, 0x024a, 0x024b, 0x024c, 0x024d, 0x024e, 0x024f, 0x0250, 
	0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257, 0x0258, 
	0x0259, 0x025a, 0x025b, 0x025c, 0x025d, 0x025e, 0x025f, 0x0260, 
	0x0261, 0x0262, 0x0263, 0x0264, 0x0265, 0x0266, 0x0267, 0x0268, 
	0x0269, 0x026a, 0x026b, 0x026c, 0x026d, 0x026e, 0x026f, 0x0270, 
	0x0271, 0x0272, 0x0273, 0x0274, 0x0275, 0x0276, 0x0277, 0x0278, 
	0x0279, 0x027a, 0x027b, 0x027c, 0x027d, 0x027e, 0x027f, 0x0280, 
	0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286, 0x0287, 0x0288, 
	0x0289, 0x028a, 0x028b, 0x028c, 0x028d, 0x028e, 0x028f, 0x0290, 
	0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297, 0x0298, 
	0x0299, 0x029a, 0x029b, 0x029c, 0x029d, 0x029e, 0x029f, 0x02a0, 
	0x02a1, 0x02a2, 0x02a3, 0x02a4, 0x02a5, 0x02a6, 0x02a7, 0x02a8, 
	0x02a9, 0x02aa, 0x02ab, 0x02ac, 0x02ad, 0x02ae, 0x02af, 0x02b0, 
	0x02b1, 0x02b2, 0x02b3, 0x02b4, 0x02b5, 0x02b6, 0x02b7, 0x02b8, 
	0x02b9, 0x02ba, 0x02bb, 0x02bc, 0x02bd, 0x02be, 0x02bf, 0x02c0, 
	0x02c1, 0x02c2, 0x02c3, 0x02c4, 0x02c5, 0x02c6, 0x02c7, 0x02c8, 
	0x02c9, 0x02ca, 0x02cb, 0x02cc, 0x02cd, 0x02ce, 0x02cf, 0x02d0, 
	0x02d1, 0x02d2, 0x02d3, 0x02d4, 0x02d5, 0x02d6, 0x02d7, 0x02d8, 
	0x02d9, 0x02da, 0x02db, 0x02dc, 0x02dd, 0x02de, 0x02df, 0x02e0, 
	0x02e1, 0x02e2, 0x02e3, 0x02e4, 0x02e5, 0x02e6, 0x02e7, 0x02e8, 
	0x02e9, 0x02ea, 0x02eb, 0x02ec, 0x02ed, 0x02ee, 0x02ef, 0x02f0, 
	0x02f1, 0x02f2, 0x02f3, 0x02f4, 0x02f5, 0x02f6, 0x02f7, 0x02f8, 
	0x02f9, 0x02fa, 0x02fb, 0x02fc, 0x02fd, 0x02fe, 0x02ff, 0x0300, 
	0x0301, 0x0302, 0x0303, 0x0304, 0x0305, 0x0306, 0x0307, 0x0308, 
	0x0309, 0x030a, 0x030b, 0x030c, 0x030d, 0x030e, 0x030f, 0x0310, 
	0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0317, 0x0318, 
	0x0319, 0x031a, 0x031b, 0x031c, 0x031d, 0x031e, 0x031f, 0x0320, 
	0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327, 0x0328, 
	0x0329, 0x032a, 0x032b, 0x032c, 0x032d, 0x032e, 0x032f, 0x0330, 
	0x0331, 0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337, 0x0338, 
	0x0339, 0x033a, 0x033b, 0x033c, 0x033d, 0x033e, 0x033f, 0x0340, 
	0x0341, 0x0342, 0x0343, 0x0344, 0x0345, 0x0346, 0x0347, 0x0348, 
	0x0349, 0x034a, 0x034b, 0x034c, 0x034d, 0x034e, 0x034f, 0x0350, 
	0x0351, 0x0352, 0x0353, 0x0354, 0x0355, 0x0356, 0x0357, 0x0358, 
	0x0359, 0x035a, 0x035b, 0x035c, 0x035d, 0x035e, 0x035f, 0x0360, 
	0x0361, 0x0362, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367, 0x0368, 
	0x0369, 0x036a, 0x036b, 0x036c, 0x036d, 0x036e, 0x036f, 0x0370, 
	0x0371, 0x0372, 0x0373, 0x0374, 0x0375, 0x0376, 0x0377, 0x0378, 
	0x0379, 0x037a, 0x037b, 0x037c, 0x037d, 0x037e, 0x037f, 0x0380, 
	0x0381, 0x0382, 0x0383, 0x0384, 0x0385, 0x0386, 0x0387, 0x0388, 
	0x0389, 0x038a, 0x038b, 0x038c, 0x038d, 0x038e, 0x038f, 0x0390, 
	0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 
	0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a0, 
	0x03a1, 0x03a2, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 
	0x03a9, 0x03aa, 0x03ab, 0x03ac, 0x03ad, 0x03ae, 0x03af, 0x03b0, 
	0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 
	0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0, 
	0x03c1, 0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 
	0x03c9, 0x03ca, 0x03cb, 0x03cc, 0x03cd, 0x03ce, 0x03cf, 0x03d0, 
	0x03d1, 0x03d2, 0x03d3, 0x03d4, 0x03d5, 0x03d6, 0x03d7, 0x03d8, 
	0x03d9, 0x03da, 0x03db, 0x03dc, 0x03dd, 0x03de, 0x03df, 0x03e0, 
	0x03e1, 0x03e2, 0x03e3, 0x03e4, 0x03e5, 0x03e6, 0x03e7, 0x03e8, 
	0x03e9, 0x03ea, 0x03eb, 0x03ec, 0x03ed, 0x03ee, 0x03ef, 0x03f0, 
	0x03f1, 0x03f2, 0x03f3, 0x03f4, 0x03f5, 0x03f6, 0x03f7, 0x03f8, 
	0x03f9, 0x03fa, 0x03fb, 0x03fc, 0x03fd, 0x03fe, 0x03ff, 0x0400, 
	0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407, 0x0408, 
	0x0409, 0x040a, 0x040b, 0x040c, 0x040d, 0x040e, 0x040f, 0x0410, 
	0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417, 0x0418, 
	0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f, 0x0420, 
	0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 
	0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f, 0x0430, 
	0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 0x0438, 
	0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f, 0x0440, 
	0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 
	0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f, 0x0450, 
	0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 0x0458, 
	0x0459, 0x045a, 0x045b, 0x045c, 0x045d, 0x045e, 0x045f, 0x0460, 
	0x0461, 0x0462, 0x0463, 0x0464, 0x0465, 0x0466, 0x0467, 0x0468, 
	0x0469, 0x046a, 0x046b, 0x046c, 0x046d, 0x046e, 0x046f, 0x0470, 
	0x0471, 0x0472, 0x0473, 0x0474, 0x0475, 0x0476, 0x0477, 0x0478, 
	0x0479, 0x047a, 0x047b, 0x047c, 0x047d, 0x047e, 0x047f, 0x0480, 
	0x0481, 0x0482, 0x0483, 0x0484, 0x0485, 0x0486, 0x0487, 0x0488, 
	0x0489, 0x048a, 0x048b, 0x048c, 0x048d, 0x048e, 0x048f, 0x0490, 
	0x0491, 0x0492, 0x0493, 0x0494, 0x0495, 0x0496, 0x0497, 0x0498, 
	0x0499, 0x049a, 0x049b, 0x049c, 0x049d, 0x049e, 0x049f, 0x04a0, 
	0x04a1, 0x04a2, 0x04a3, 0x04a4, 0x04a5, 0x04a6, 0x04a7, 0x04a8, 
	0x04a9, 0x04aa, 0x04ab, 0x04ac, 0x04ad, 0x04ae, 0x04af, 0x04b0, 
	0x04b1, 0x04b2, 0x04b3, 0x04b4, 0x04b5, 0x04b6, 0x04b7, 0x04b8, 
	0x04b9, 0x04ba, 0x04bb, 0x04bc, 0x04bd, 0x04be, 0x04bf, 0x04c0, 
	0x04c1, 0x04c2, 0x04c3, 0x04c4, 0x04c5, 0x04c6, 0x04c7, 0x04c8, 
	0x04c9, 0x04ca, 0x04cb, 0x04cc, 0x04cd, 0x04ce, 0x04cf, 0x04d0, 
	0x04d1, 0x04d2, 0x04d3, 0x04d4, 0x04d5, 0x04d6, 0x04d7, 0x04d8, 
	0x04d9, 0x04da, 0x04db, 0x04dc, 0x04dd, 0x04de, 0x04df, 0x04e0, 
	0x04e1, 0x04e2, 0x04e3, 0x04e4, 0x04e5, 0x04e6, 0x04e7, 0x04e8, 
	0x04e9, 0x04ea, 0x04eb, 0x04ec, 0x04ed, 0x04ee, 0x04ef, 0x04f0, 
	0x04f1, 0x04f2, 0x04f3, 0x04f4, 0x04f5, 0x04f6, 0x04f7, 0x04f8, 
	0x04f9, 0x04fa, 0x04fb, 0x04fc, 0x04fd, 0x04fe, 0x04ff, 0x0500, 
	0x0501, 0x0502, 0x0503, 0x0504, 0x0505, 0x0506, 0x0507, 0x0508, 
	0x0509, 0x050a, 0x050b, 0x050c, 0x050d, 0x050e, 0x050f, 0x0510, 
	0x0511, 0x0512, 0x0513, 0x0514, 0x0515, 0x0516, 0x0517, 0x0518, 
	0x0519, 0x051a, 0x051b, 0x051c, 0x051d, 0x051e, 0x051f, 0x0520, 
	0x0521, 0x0522, 0x0523, 0x0524, 0x0525, 0x0526, 0x0527, 0x0528, 
	0x0529, 0x052a, 0x052b, 0x052c, 0x052d, 0x052e, 0x052f, 0x0530, 
	0x0531, 0x0532, 0x0533, 0x0534, 0x0535, 0x0536, 0x0537, 0x0538, 
	0x0539, 0x053a, 0x053b, 0x053c, 0x053d, 0x053e, 0x053f, 0x0540, 
	0x0541, 0x0542, 0x0543, 0x0544, 0x0545, 0x0546, 0x0547, 0x0548, 
	0x0549, 0x054a, 0x054b, 0x054c, 0x054d, 0x054e, 0x054f, 0x0550, 
	0x0551, 0x0552, 0x0553, 0x0554, 0x0555, 0x0556, 0x0557, 0x0558, 
	0x0559, 0x055a, 0x055b, 0x055c, 0x055d, 0x055e, 0x055f, 0x0560, 
	0x0561, 0x0562, 0x0563, 0x0564, 0x0565, 0x0566, 0x0567, 0x0568, 
	0x0569, 0x056a, 0x056b, 0x056c, 0x056d, 0x056e, 0x056f, 0x0570, 
	0x0571, 0x0572, 0x0573, 0x0574, 0x0575, 0x0576, 0x0577, 0x0578, 
	0x0579, 0x057a, 0x057b, 0x057c, 0x057d, 0x057e, 0x057f, 0x0580, 
	0x0581, 0x0582, 0x0583, 0x0584, 0x0585, 0x0586, 0x0587, 0x0588, 
	0x0589, 0x058a, 0x058b, 0x058c, 0x058d, 0x058e, 0x058f, 0x0590, 
	0x0591, 0x0592, 0x0593, 0x0594, 0x0595, 0x0596, 0x0597, 0x0598, 
	0x0599, 0x059a, 0x059b, 0x059c, 0x059d, 0x059e, 0x059f, 0x05a0, 
	0x05a1, 0x05a2, 0x05a3, 0x05a4, 0x05a5, 0x05a6, 0x05a7, 0x05a8, 
	0x05a9, 0x05aa, 0x05ab, 0x05ac, 0x05ad, 0x05ae, 0x05af, 0x05b0, 
	0x05b1, 0x05b2, 0x05b3, 0x05b4, 0x05b5, 0x05b6, 0x05b7, 0x05b8, 
	0x05b9, 0x05ba, 0x05bb, 0x05bc, 0x05bd, 0x05be, 0x05bf, 0x05c0, 
	0x05c1, 0x05c2, 0x05c3, 0x05c4, 0x05c5, 0x05c6, 0x05c7, 0x05c8, 
	0x05c9, 0x05ca, 0x05cb, 0x05cc, 0x05cd, 0x05ce, 0x05cf, 0x05d0, 
	0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7, 0x05d8, 
	0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df, 0x05e0, 
	0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7, 0x05e8, 
	0x05e9, 0x05ea, 0x05eb, 0x05ec, 0x05ed, 0x05ee, 0x05ef, 0x05f0, 
	0x05f1, 0x05f2, 0x05f3, 0x05f4, 0x05f5, 0x05f6, 0x05f7, 0x05f8, 
	0x05f9, 0x05fa, 0x05fb, 0x05fc, 0x05fd, 0x05fe, 0x05ff, 0x0600, 
	0x0601, 0x0602, 0x0603, 0x0604, 0x0605, 0x0606, 0x0607, 0x0608, 
	0x0609, 0x060a, 0x060b, 0x060c, 0x060d, 0x060e, 0x060f, 0x0610, 
	0x0611, 0x0612, 0x0613, 0x0614, 0x0615, 0x0616, 0x0617, 0x0618, 
	0x0619, 0x061a, 0x061b, 0x061c, 0x061d, 0x061e, 0x061f, 0x0620, 
	0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627, 0x0628, 
	0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f, 0x0630, 
	0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 0x0638, 
	0x0639, 0x063a, 0x063b, 0x063c, 0x063d, 0x063e, 0x063f, 0x0640, 
	0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647, 0x0648, 
	0x0649, 0x064a, 0x064b, 0x064c, 0x064d, 0x064e, 0x064f, 0x0650, 
	0x0651, 0x0652, 0x0653, 0x0654, 0x0655, 0x0656, 0x0657, 0x0658, 
	0x0659, 0x065a, 0x065b, 0x065c, 0x065d, 0x065e, 0x065f, 0x0660, 
	0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667, 0x0668, 
	0x0669, 0x066a, 0x066b, 0x066c, 0x066d, 0x066e, 0x066f, 0x0670, 
	0x0671, 0x0672, 0x0673, 0x0674, 0x0675, 0x0676, 0x0677, 0x0678, 
	0x0679, 0x067a, 0x067b, 0x067c, 0x067d, 0x067e, 0x067f, 0x0680, 
	0x0681, 0x0682, 0x0683, 0x0684, 0x0685, 0x0686, 0x0687, 0x0688, 
	0x0689, 0x068a, 0x068b, 0x068c, 0x068d, 0x068e, 0x068f, 0x0690, 
	0x0691, 0x0692, 0x0693, 0x0694, 0x0695, 0x0696, 0x0697, 0x0698, 
	0x0699, 0x069a, 0x069b, 0x069c, 0x069d, 0x069e, 0x069f, 0x06a0, 
	0x06a1, 0x06a2, 0x06a3, 0x06a4, 0x06a5, 0x06a6, 0x06a7, 0x06a8, 
	0x06a9, 0x06aa, 0x06ab, 0x06ac, 0x06ad, 0x06ae, 0x06af, 0x06b0, 
	0x06b1, 0x06b2, 0x06b3, 0x06b4, 0x06b5, 0x06b6, 0x06b7, 0x06b8, 
	0x06b9, 0x06ba, 0x06bb, 0x06bc, 0x06bd, 0x06be, 0x06bf, 0x06c0, 
	0x06c1, 0x06c2, 0x06c3, 0x06c4, 0x06c5, 0x06c6, 0x06c7, 0x06c8, 
	0x06c9, 0x06ca, 0x06cb, 0x06cc, 0x06cd, 0x06ce, 0x06cf, 0x06d0, 
	0x06d1, 0x06d2, 0x06d3, 0x06d4, 0x06d5, 0x06d6, 0x06d7, 0x06d8, 
	0x06d9, 0x06da, 0x06db, 0x06dc, 0x06dd, 0x06de, 0x06df, 0x06e0, 
	0x06e1, 0x06e2, 0x06e3, 0x06e4, 0x06e5, 0x06e6, 0x06e7, 0x06e8, 
	0x06e9, 0x06ea, 0x06eb, 0x06ec, 0x06ed, 0x06ee, 0x06ef, 0x06f0, 
	0x06f1, 0x06f2, 0x06f3, 0x06f4, 0x06f5, 0x06f6, 0x06f7, 0x06f8, 
	0x06f9, 0x06fa, 0x06fb, 0x06fc, 0x06fd, 0x06fe, 0x06ff, 0x0700, 
	0x0701, 0x0702, 0x0703, 0x0704, 0x0705, 0x0706, 0x0707, 0x0708, 
	0x0709, 0x070a, 0x070b, 0x070c, 0x070d, 0x070e, 0x070f, 0x0710, 
	0x0711, 0x0712, 0x0713, 0x0714, 0x0715, 0x0716, 0x0717, 0x0718, 
	0x0719, 0x071a, 0x071b, 0x071c, 0x071d, 0x071e, 0x071f, 0x0720, 
	0x0721, 0x0722, 0x0723, 0x0724, 0x0725, 0x0726, 0x0727, 0x0728, 
	0x0729, 0x072a, 0x072b, 0x072c, 0x072d, 0x072e, 0x072f, 0x0730, 
	0x0731, 0x0732, 0x0733, 0x0734, 0x0735, 0x0736, 0x0737, 0x0738, 
	0x0739, 0x073a, 0x073b, 0x073c, 0x073d, 0x073e, 0x073f, 0x0740, 
	0x0741, 0x0742, 0x0743, 0x0744, 0x0745, 0x0746, 0x0747, 0x0748, 
	0x0749, 0x074a, 0x074b, 0x074c, 0x074d, 0x074e, 0x074f, 0x0750, 
	0x0751, 0x0752, 0x0753, 0x0754, 0x0755, 0x0756, 0x0757, 0x0758, 
	0x0759, 0x075a, 0x075b, 0x075c, 0x075d, 0x0001, 0x0002, 0x0003, 
	0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a, 0x000b, 
	0x000c, 0x000d, 0x000e, 0x000f, 0x0010, 0x0011, 0x0012, 0x0013, 
	0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001a, 0x001b, 
	0x001c, 0x001d, 0x001e, 0x001f, 0x0020, 0x0021, 0x0022, 0x0023, 
	0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002a, 0x002b, 
	0x002c, 0x002d, 0x002e, 0x002f, 0x0030, 0x0031, 0x0032, 0x0033, 
	0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x003a, 0x003b, 
	0x003c, 0x003d, 0x003e, 0x003f, 0x0040, 0x0041, 0x0042, 0x0043, 
	0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004a, 0x004b, 
	0x004c, 0x004d, 0x004e, 0x004f, 0x0050, 0x0051, 0x0052, 0x0053, 
	0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005a, 0x005b, 
	0x005c, 0x005d, 0x005e, 0x005f, 0x0060, 0x0061, 0x0062, 0x0063, 
	0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006a, 0x006b, 
	0x006c, 0x006d, 0x006e, 0x006f, 0x0070, 0x0071, 0x0072, 0x0073, 
	0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007a, 0x007b, 
	0x007c, 0x007d, 0x007e, 0x007f, 0x0080, 0x0081, 0x0082, 0x0083, 
	0x0084, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 0x008a, 0x008b, 
	0x008c, 0x008d, 0x008e, 0x008f, 0x0090, 0x0091, 0x0092, 0x0093, 
	0x0094, 0x0095, 0x0096, 0x0097, 0x0098, 0x0099, 0x009a, 0x009b, 
	0x009c, 0x009d, 0x009e, 0x009f, 0x00a0, 0x00a1, 0x00a2, 0x00a3, 
	0x00a4, 0x00a5, 0x00a6, 0x00a7, 0x00a8, 0x00a9, 0x00aa, 0x00ab, 
	0x00ac, 0x00ad, 0x00ae, 0x00af, 0x00b0, 0x00b1, 0x00b2, 0x00b3, 
	0x00b4, 0x00b5, 0x00b6, 0x00b7, 0x00b8, 0x00b9, 0x00ba, 0x00bb, 
	0x00bc, 0x00bd, 0x00be, 0x00bf, 0x00c0, 0x00c1, 0x00c2, 0x00c3, 
	0x00c4, 0x00c5, 0x00c6, 0x00c7, 0x00c8, 0x00c9, 0x00ca, 0x00cb, 
	0x00cc, 0x00cd, 0x00ce, 0x00cf, 0x00d0, 0x00d1, 0x00d2, 0x00d3, 
	0x00d4, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 
	0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f, 
	0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 
	0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f, 
	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
	0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
	0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
	0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
	0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
	0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
	0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 
	0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 
	0x0088, 0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008e, 0x008f, 
	0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 
	0x0098, 0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f, 
	0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 
	0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 
	0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 
	0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 
	0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 
	0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 
	0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 
	0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df, 
	0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7, 
	0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef, 
	0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 
	0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff, 
	0x0100, 0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 
	0x0108, 0x0109, 0x010a, 0x010b, 0x010c, 0x010d, 0x010e, 0x010f, 
	0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116, 0x0117, 
	0x0118, 0x0119, 0x011a, 0x011b, 0x011c, 0x011d, 0x011e, 0x011f, 
	0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 
	0x0128, 0x0129, 0x012a, 0x012b, 0x012c, 0x012d, 0x012e, 0x012f, 
	0x0130, 0x0131, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 
	0x0138, 0x0139, 0x013a, 0x013b, 0x013c, 0x013d, 0x013e, 0x013f, 
	0x0140, 0x0141, 0x0142, 0x0143, 0x0144, 0x0145, 0x0146, 0x0147, 
	0x0148, 0x0149, 0x014a, 0x014b, 0x014c, 0x014d, 0x014e, 0x014f, 
	0x0150, 0x0151, 0x0152, 0x0153, 0x0154, 0x0155, 0x0156, 0x0157, 
	0x0158, 0x0159, 0x015a, 0x015b, 0x015c, 0x015d, 0x015e, 0x015f, 
	0x0160, 0x0161, 0x0162, 0x0163, 0x0164, 0x0165, 0x0166, 0x0167, 
	0x0168, 0x0169, 0x016a, 0x016b, 0x016c, 0x016d, 0x016e, 0x016f, 
	0x0170, 0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 0x0176, 0x0177, 
	0x0178, 0x0179, 0x017a, 0x017b, 0x017c, 0x017d, 0x017e, 0x017f, 
	0x0180, 0x0181, 0x0182, 0x0183, 0x0184, 0x0185, 0x0186, 0x0187, 
	0x0188, 0x0189, 0x018a, 0x018b, 0x018c, 0x018d, 0x018e, 0x018f, 
	0x0190, 0x0191, 0x0192, 0x0193, 0x0194, 0x0195, 0x0196, 0x0197, 
	0x0198,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0001, 0x0003, 0x0001, 0x0004, 0x0005, 0x0006, 
	0x0007, 0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 
	0x000f, 0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 
	0x0017, 0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 
	0x001f, 0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 
	0x0027, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0028, 0x0029, 0x002a, 
	0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030, 0x0031, 0x0032, 
	0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x003a, 
	0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040, 0x0041, 0x0042, 
	0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004a, 
	0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050, 0x0051, 0x0052, 
	0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005a, 
	0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 0x0060, 0x0061, 0x0062, 
	0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006a, 
	0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070, 0x0071, 0x0072, 
	0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007a, 
	0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 0x0080, 0x0081, 0x0082, 
	0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 0x008a, 
	0x008b, 0x008c, 0x008d, 0x008e, 0x008f, 0x0090, 0x0091, 0x0092, 
	0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098, 0x0099, 0x009a, 
	0x009b, 0x009c, 0x009d, 0x009e, 0x009f, 0x00a0, 0x00a1, 0x00a2, 
	0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 0x00a8, 0x00a9, 0x00aa, 
	0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 0x00b0, 0x00b1, 0x00b2, 
	0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 0x00b8, 0x00b9, 0x00ba, 
	0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 0x00c0, 0x00c1, 0x00c2, 
	0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 0x00c8, 0x00c9, 0x00ca, 
	0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 0x00d0, 0x00d1, 0x00d2, 
	0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 0x00d8, 0x00d9, 0x00da, 
	0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df, 0x00e0, 0x00e1, 0x00e2, 
	0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7, 0x00e8, 0x00e9, 0x00ea, 
	0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef, 0x00f0, 0x00f1, 0x00f2, 
	0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 0x00f8, 0x00f9, 0x00fa, 
	0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff, 0x0100, 0x0101, 0x0102, 
	0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010a, 
	0x010b, 0x010c, 0x010d, 0x010e, 0x010f, 0x0110, 0x0111, 0x0112, 
	0x0113, 0x0114, 0x0115, 0x0116, 0x0117, 0x0118, 0x0119, 0x011a, 
	0x011b, 0x011c, 0x011d, 0x011e, 0x011f, 0x0120, 0x0121, 0x0122, 
	0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128, 0x0129, 0x012a, 
	0x012b, 0x012c, 0x012d, 0x012e, 0x012f, 0x0130, 0x0131, 0x0132, 
	0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 0x0138, 0x0139, 0x013a, 
	0x013b, 0x013c, 0x013d, 0x013e, 0x013f, 0x0140, 0x0141, 0x0142, 
	0x0143, 0x0144, 0x0145, 0x0146, 0x0147, 0x0148, 0x0149, 0x014a, 
	0x014b, 0x014c, 0x014d, 0x014e, 0x014f, 0x0150, 0x0151, 0x0152, 
	0x0153, 0x0154, 0x0155, 0x0156, 0x0157, 0x0158, 0x0159, 0x015a, 
	0x015b, 0x015c, 0x015d, 0x015e, 0x015f, 0x0160, 0x0161, 0x0162, 
	0x0163, 0x0164, 0x0165, 0x0166, 0x0167, 0x0168, 0x0169, 0x016a, 
	0x016b, 0x016c, 0x016d, 0x016e, 0x016f, 0x0170, 0x0171, 0x0172, 
	0x0173, 0x0174, 0x0175, 0x0176, 0x0177, 0x0178, 0x0179, 0x017a, 
	0x017b, 0x017c, 0x017d, 0x017e, 0x017f, 0x0180, 0x0181, 0x0182, 
	0x0183, 0x0184, 0x0185, 0x0186, 0x0187, 0x0188, 0x0189, 0x018a, 
	0x018b, 0x018c, 0x018d, 0x018e, 0x018f, 0x0190, 0x0191, 0x0192, 
	0x0193, 0x0194, 0x0195, 0x0196, 0x0197, 0x0198, 0x0199, 0x019a, 
	0x019b, 0x019c, 0x019d, 0x019e, 0x019f, 0x01a0, 0x01a1, 0x01a2, 
	0x01a3, 0x01a4, 0x01a5, 0x01a6, 0x01a7, 0x01a8, 0x01a9, 0x01aa, 
	0x01ab, 0x01ac, 0x01ad, 0x01ae, 0x01af, 0x01b0, 0x01b0, 0x01b1, 
	0x01b2, 0x01b3, 0x01b4, 0x01b5, 0x01b6, 0x01b7, 0x01b8, 0x01b9, 
	0x01ba, 0x01bb, 0x01bc, 0x01bd, 0x01be, 0x01bf, 0x01c0, 0x01c1, 
	0x01c2, 0x01c3, 0x01c4, 0x01c5, 0x01c6, 0x01c7, 0x01c8, 0x01c9, 
	0x01c9, 0x01ca, 0x01cb, 0x01cc, 0x01cd, 0x01ce, 0x01cf, 0x01d0, 
	0x01d1, 0x01d2, 0x01d3, 0x01d4, 0x01d5, 0x01d6, 0x01d7, 0x01d8, 
	0x01d9, 0x01da, 0x01db, 0x01dc, 0x01dd, 0x01de, 0x01df, 0x01e0, 
	0x01e1, 0x01e2, 0x01e3, 0x01e4, 0x01e5, 0x01e6, 0x01e7, 0x01e8, 
	0x01e9, 0x01ea, 0x01eb, 0x01ec, 0x01ed, 0x01ee, 0x01ef, 0x01f0, 
	0x01f1, 0x01f2, 0x01f3, 0x01f4, 0x01f5, 0x01f6, 0x01f7, 0x01f8, 
	0x01f9, 0x01fa, 0x01fb, 0x01fc, 0x01fd, 0x01fe, 0x01ff, 0x0200, 
	0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208, 
	0x0209, 0x020a, 0x020b, 0x020c, 0x020d, 0x020e, 0x020f, 0x0210, 
	0x0211, 0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217, 0x0218, 
	0x0219, 0x021a, 0x021b, 0x021c, 0x021d, 0x021e, 0x021f, 0x0220, 
	0x0221, 0x0222, 0x0223, 0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 
	0x0229, 0x022a, 0x022b, 0x022c, 0x022d, 0x022e, 0x022f, 0x0230, 
	0x0231,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237, 
	0x0238, 0x0239, 0x023a, 0x023b, 0x023c, 0x023d, 0x023e, 0x023f, 
	0x0240, 0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247, 
	0x0248, 0x0249, 0x024a, 0x024b, 0x024c, 0x024d, 0x024e, 0x024f, 
	0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257, 
	0x0258, 0x0259, 0x025a, 0x025b, 0x025c, 0x025d, 0x025e, 0x025f, 
	0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 0x0265, 0x0266, 0x0267, 
	0x0268, 0x0269, 0x026a, 0x026b, 0x026c, 0x026d, 0x026e, 0x026f, 
	0x0270, 0x0271, 0x0272, 0x0273, 0x0274, 0x0275, 0x0276, 0x0277, 
	0x0278, 0x0279, 0x027a, 0x027b, 0x027c, 0x027d, 0x027e, 0x027f, 
	0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286, 0x0287, 
	0x0288, 0x0289, 0x028a, 0x028b, 0x028c, 0x028d, 0x028e, 0x028f, 
	0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297, 
	0x0298, 0x0299, 0x029a, 0x029b, 0x029c, 0x029d, 0x029e, 0x029f, 
	0x02a0, 0x02a1, 0x02a2, 0x02a3, 0x02a4, 0x02a5, 0x02a6, 0x02a7, 
	0x02a8, 0x02a9, 0x02aa, 0x02ab, 0x02ac, 0x02ad, 0x02ae, 0x02af, 
	0x02b0, 0x02b1, 0x02b2, 0x02b3, 0x02b4, 0x02b5, 0x02b6, 0x02b7, 
	0x02b8, 0x02b9, 0x02ba, 0x02bb, 0x02bc, 0x02bd, 0x02be, 0x02bf, 
	0x02c0, 0x02c1, 0x02c2, 0x02c3, 0x02c4, 0x02c5, 0x02c6, 0x02c7, 
	0x02c8, 0x02c9, 0x02ca, 0x02cb, 0x02cc, 0x02cd, 0x02ce, 0x02cf, 
	0x02d0, 0x02d1, 0x02d2, 0x02d3, 0x02d4, 0x02d5, 0x02d6, 0x02d7, 
	0x02d8, 0x02d9, 0x02da, 0x02db, 0x02dc, 0x02dd, 0x02de, 0x02df, 
	0x02e0, 0x02e1, 0x02e2, 0x02e3, 0x02e4, 0x02e5, 0x02e6, 0x02e7, 
	0x02e8, 0x02e9, 0x02ea, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 
	0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 
	0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 
	0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 
	0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 
	0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 
	0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 
	0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 
	0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 
	0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a4, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x04a5, 0x04a5, 0x04a6, 0x04a7, 0x04a8, 0x04a9, 0x04aa, 
	0x04ab, 0x04ac, 0x04ad, 0x04ae, 0x04af, 0x04b0, 0x04b1, 0x04b2, 
	0x04b3, 0x04b4, 0x04b5, 0x04b6, 0x04b7, 0x04b8, 0x04b9, 0x04ba, 
	0x04bb, 0x04bc, 0x04bd, 0x04be, 0x04bf, 0x04c0, 0x04c1, 0x04c2, 
	0x04c3, 0x04c4, 0x04c5, 0x04c6, 0x04c7, 0x04c8, 0x04c9, 0x04ca, 
	0x04cb, 0x04cc, 0x04cd, 0x04ce, 0x04cf, 0x04d0, 0x04d1, 0x04d2, 
	0x04d3, 0x04d4, 0x04a3, 0x04a6, 0x04d5, 0x04d6, 0x04d7, 0x04d8, 
	0x04d9, 0x04da, 0x04db, 0x04a3, 0x04a6, 0x04dc, 0x04dd, 0x04de, 
	0x04df, 0x04e0, 0x04e1, 0x04e2, 0x04e3, 0x04e4, 0x04a3, 0x04a6, 
	0x04e5, 0x04e6, 0x04e7, 0x04e8, 0x04e9, 0x04ea, 0x04eb, 0x04ec, 
	0x04ed, 0x04ee, 0x04ef, 0x04f0, 0x04f1, 0x04a3, 0x04a6, 0x04f2, 
	0x04f3, 0x04f4, 0x04f5, 0x04f6, 0x04f7, 0x04f8, 0x04f9, 0x04fa, 
	0x04fb, 0x04fc, 0x04fd, 0x04fe, 0x04ff, 0x0500, 0x0501, 0x0502, 
	0x0503, 0x0504, 0x0505, 0x0506, 0x0507, 0x0508, 0x0509, 0x050a, 
	0x050b, 0x050c, 0x050d, 0x050e, 0x050f, 0x0510, 0x0511, 0x0512, 
	0x0513, 0x0514, 0x0515, 0x0516, 0x0517, 0x0518, 0x0519, 0x051a, 
	0x051b, 0x051c, 0x04a3, 0x04a6, 0x051d, 0x051e, 0x051f, 0x0520, 
	0x0521, 0x04a3, 0x0522, 0x0523, 0x0524, 0x0525, 0x0526, 0x04a6, 
	0x0527, 0x0528, 0x0529, 0x052a, 0x052b, 0x052c, 0x052d, 0x052e, 
	0x052f, 0x0530, 0x0531, 0x0532, 0x0533, 0x04a3, 0x04a6, 0x0534, 
	0x0535, 0x0536, 0x0537, 0x0538, 0x0539, 0x053a, 0x053b, 0x053c, 
	0x053d, 0x053e, 0x053f, 0x0540, 0x0541, 0x0542, 0x04a3, 0x0543, 
	0x0544, 0x0545, 0x0546, 0x0547, 0x0548, 0x0549, 0x054a, 0x054b, 
	0x054c, 0x054d, 0x054e, 0x054f, 0x0550, 0x0551, 0x0552, 0x0553, 
	0x0554, 0x0555, 0x0556, 0x0557, 0x0558, 0x0559, 0x055a, 0x055b, 
	0x055c, 0x055d, 0x04a3, 0x055e, 0x055f, 0x04a6, 0x0560, 0x0561, 
	0x0562, 0x04a3, 0x04a6, 0x0563, 0x0564, 0x0565, 0x0566, 0x0567, 
	0x0568, 0x0569, 0x056a, 0x056b, 0x056c, 0x056d, 0x04a3, 0x04a6, 
	0x056e, 0x056f, 0x0570, 0x0571, 0x0572, 0x0573, 0x0574, 0x0575, 
	0x0576, 0x0577, 0x0578, 0x0579, 0x057a, 0x057b, 0x057c, 0x04a3, 
	0x04a6, 0x057d, 0x057e, 0x057f, 0x0580, 0x0581, 0x0582, 0x0583, 
	0x04a3, 0x04a6, 0x0584, 0x0585, 0x0586, 0x0587, 0x0588, 0x0589, 
	0x058a, 0x058b, 0x058c, 0x058d, 0x058e, 0x058f, 0x04a3, 0x04a6, 
	0x0590, 0x0591, 0x0592, 0x0593, 0x0594, 0x0595, 0x0596, 0x0597, 
	0x0598, 0x0599, 0x059a, 0x059b, 0x059c, 0x059d, 0x059e, 0x059f, 
	0x05a0, 0x05a1, 0x05a2, 0x05a3, 0x05a4, 0x05a5, 0x05a6, 0x05a7, 
	0x05a8, 0x05a9, 0x05aa, 0x05ab, 0x05ac, 0x05ad, 0x05ae, 0x05af, 
	0x05b0, 0x05b1, 0x05b2, 0x05b3, 0x05b4, 0x05b5, 0x05b6, 0x05b7, 
	0x05b8, 0x05b9, 0x05ba, 0x05bb, 0x05bc, 0x05bd, 0x05be, 0x05bf, 
	0x05c0, 0x05c1, 0x05c2, 0x05c3, 0x04a3, 0x04a6, 0x05c4, 0x05c5, 
	0x05c6, 0x05c7, 0x05c8, 0x04a3, 0x04a6, 0x05c9, 0x04a3, 0x04a6, 
	0x05ca, 0x05cb, 0x05cc, 0x05cd, 0x05ce, 0x05cf, 0x05d0, 0x05d1, 
	0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7, 0x05d8, 0x05d9, 
	0x05da, 0x04a3, 0x04a6, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df, 
	0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7, 
	0x05e8, 0x04a3, 0x05e9, 0x05ea, 0x05eb, 0x04a6, 0x05ec, 0x05ed, 
	0x05ee, 0x05ef, 0x05f0, 0x05f1, 0x05f2, 0x05f3, 0x05f4, 0x05f5, 
	0x05f6, 0x05f7, 0x05f8, 0x05f9, 0x05fa, 0x04a3, 0x04a6, 0x05fb, 
	0x05fc, 0x05fd, 0x05fe, 0x05ff, 0x0600, 0x0601, 0x0602, 0x0603, 
	0x0604, 0x0605, 0x0606, 0x0607, 0x0608, 0x0609, 0x060a, 0x060b, 
	0x060c, 0x060d, 0x060e, 0x060f, 0x0610, 0x0611, 0x0612, 0x0613, 
	0x0614, 0x0615, 0x0616, 0x0617, 0x0618, 0x0619, 0x061a, 0x061b, 
	0x061c, 0x061d, 0x061e, 0x061f, 0x0620, 0x0621, 0x0622, 0x0623, 
	0x0624, 0x0625, 0x0626, 0x0627, 0x0628, 0x0629, 0x062a, 0x062b, 
	0x062c, 0x062d, 0x062e, 0x062f, 0x04a3, 0x04a3, 0x04a3, 0x04a6, 
	0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x04a3, 0x0635, 0x0636, 
	0x0637, 0x0638, 0x0639, 0x063a, 0x063b, 0x063c, 0x063d, 0x063e, 
	0x063f, 0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 
	0x0647, 0x0648, 0x0649, 0x064a, 0x04a3, 0x064b, 0x064c, 0x064d, 
	0x064e, 0x064b, 0x064f, 0x064b, 0x0650, 0x064b, 0x0651, 0x064b, 
	0x0652, 0x0653, 0x0654, 0x064b, 0x0655, 0x064b, 0x0656, 0x0657, 
	0x0658, 0x064b, 0x0659, 0x064b, 0x065a, 0x065b, 0x065c, 0x065d, 
	0x065e, 0x065f, 0x064b, 0x0660, 0x064b, 0x0661, 0x064b, 0x0662, 
	0x064b, 0x0663, 0x064b, 0x0664, 0x064b, 0x0665, 0x0666, 0x0667, 
	0x064b, 0x0668, 0x064b, 0x0669, 0x064b, 0x066a, 0x066b, 0x064b, 
	0x066c, 0x064b, 0x066d, 0x066e, 0x066f, 0x0670, 0x0671, 0x0672, 
	0x064b, 0x0673, 0x064b, 0x0674, 0x064b, 0x0675, 0x064b, 0x0676, 
	0x0677, 0x0678, 0x0679, 0x067a, 0x0679, 0x067b, 0x0679, 0x067c, 
	0x0679, 0x067d, 0x0679, 0x067e, 0x0679, 0x067f, 0x0679, 0x0680, 
	0x0679, 0x0681, 0x0679, 0x0682, 0x0679, 0x0683, 0x0679, 0x0684, 
	0x0679, 0x0685, 0x0679, 0x0686, 0x0679, 0x0687, 0x0679, 0x0688, 
	0x0679, 0x0689, 0x0679, 0x068a, 0x0679, 0x068b, 0x0679, 0x068c, 
	0x0679, 0x068d, 0x0679, 0x068e, 0x0679, 0x068f, 0x0679, 0x0690, 
	0x0679, 0x0691, 0x0679, 0x0692, 0x0679, 0x0693, 0x0679, 0x0694, 
	0x0679, 0x0695, 0x0679, 0x0696, 0x0679, 0x0697, 0x0679, 0x0698, 
	0x0679, 0x0699, 0x0679, 0x069a, 0x0679, 0x069b, 0x0679, 0x069c, 
	0x0679, 0x069d, 0x0679, 0x069e, 0x0679, 0x069f, 0x0679, 0x06a0, 
	0x0679, 0x06a1, 0x0679, 0x06a2, 0x06a3, 0x06a4, 0x0679, 0x06a5, 
	0x06a3, 0x06a6, 0x0679, 0x06a7, 0x0679, 0x06a8, 0x0679, 0x06a9, 
	0x0679, 0x06aa, 0x0679, 0x06ab, 0x0679, 0x06ac, 0x0679, 0x06ad, 
	0x0679, 0x06ae, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 
	0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 
	0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 
	0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x04a5, 0x04a5, 0x04a5, 
	0x04a5, 0x06b0, 0x06b0, 0x06b1, 0x06b2, 0x06b2, 0x06b2, 0x06b2, 
	0x06b2, 0x06b2, 0x06b0, 0x06b0, 0x06b3, 0x06b3, 0x06b3, 0x06b0, 
	0x06b4, 0x06b4, 0x06b4, 0x06b4, 0x06b0, 0x06b0, 0x06b0, 0x06b5, 
	0x06b5, 0x06b5, 0x06b5, 0x06b5, 0x06b5, 0x06b5, 0x06b0, 0x06b6, 
	0x06b6, 0x06b6, 0x06b6, 0x06b0, 0x06b7, 0x06b7, 0x06b7, 0x06b7, 
	0x06b0, 0x06b8, 0x06b8, 0x06b8, 0x06b8, 0x06b0, 0x06b9, 0x06b9, 
	0x06b9, 0x06b9, 0x06b0, 0x06ba, 0x06ba, 0x06b0, 0x06bb, 0x06bb, 
	0x06b0, 0x06bc, 0x06bc, 0x06b0, 0x06bd, 0x06bd, 0x06b0, 0x06be, 
	0x06be, 0x06be, 0x06be, 0x06b0, 0x06bf, 0x06bf, 0x06bf, 0x06bf, 
	0x06b0, 0x06c0, 0x06c0, 0x06c0, 0x06c0, 0x06b0, 0x06c1, 0x06c1, 
	0x06c1, 0x06c1, 0x06b0, 0x06c2, 0x06c2, 0x06c2, 0x06c2, 0x06b0, 
	0x06c3, 0x06c3, 0x06c3, 0x06c3, 0x06b0, 0x06c4, 0x06c4, 0x06c4, 
	0x06c4, 0x06b0, 0x06c5, 0x06c5, 0x06c5, 0x06c5, 0x06b0, 0x06c6, 
	0x06c6, 0x06c6, 0x06c6, 0x06b0, 0x06c7, 0x06c7, 0x06c7, 0x06c7, 
	0x06b0, 0x06c8, 0x06c8, 0x06c8, 0x06c8, 0x06b0, 0x06c9, 0x06c9, 
	0x06c9, 0x06c9, 0x06b0, 0x06ca, 0x06ca, 0x06ca, 0x06ca, 0x06b0, 
	0x06cb, 0x06cb, 0x06cb, 0x06cb, 0x06b0, 0x06cc, 0x06cc, 0x06cc, 
	0x06cc, 0x06b0, 0x06cd, 0x06cd, 0x06b0, 0x06ce, 0x06ce, 0x06b0, 
	0x06cf, 0x06cf, 0x06cf, 0x06cf, 0x06d0, 0x06d0, 0x06d0, 0x06d0, 
	0x06d0, 0x06d0, 0x06d0, 0x06d0, 0x06d0, 0x06d1, 0x06d2, 0x06d3, 
	0x06d4, 0x06d5, 0x06d6, 0x06d7, 0x06d8, 0x06d9, 0x06da, 0x06db, 
	0x06dc, 0x06dd, 0x06de, 0x06df, 0x06e0, 0x06e1, 0x06e2, 0x06b0, 
	0x06e3, 0x06e3, 0x06e3, 0x06b0, 0x06e4, 0x06e4, 0x06e4, 0x06b0, 
	0x06e5, 0x06e5, 0x06e5, 0x06e5, 0x06b0, 0x06e6, 0x06e6, 0x06e6, 
	0x06b0, 0x06e7, 0x06e7, 0x06e7, 0x06b0, 0x06e8, 0x06e8, 0x06e8, 
	0x06e8, 0x06b0, 0x06e9, 0x06e9, 0x06e9, 0x06b0, 0x06ea, 0x06ea, 
	0x06ea, 0x06b0, 0x06eb, 0x06eb, 0x06eb, 0x06eb, 0x06b0, 0x06ec, 
	0x06ec, 0x06ec, 0x06b0, 0x06ed, 0x06ed, 0x06ed, 0x06b0, 0x06ee, 
	0x06ee, 0x06ee, 0x06b0, 0x06ef, 0x06ef, 0x06ef, 0x06b0, 0x06f0, 
	0x06f0, 0x06f0, 0x06b0, 0x06f1, 0x06f1, 0x06f1, 0x06b0, 0x06f2, 
	0x06f2, 0x06f2, 0x06b0, 0x06f3, 0x06f3, 0x06f3, 0x06b0, 0x06f4, 
	0x06f4, 0x06f4, 0x06f4, 0x06f4, 0x06b0, 0x06f5, 0x06f5, 0x06f5, 
	0x06b0, 0x06f6, 0x06f6, 0x06f6, 0x06b0, 0x06f7, 0x06b0, 0x06f8, 
	0x06b0, 0x06f9, 0x06b0, 0x06fa, 0x06b0, 0x06fb, 0x06b0, 0x06fc, 
	0x06fc, 0x06fc, 0x06fc, 0x06fc, 0x06b0, 0x06fd, 0x06fd, 0x06fd, 
	0x06fd, 0x06fd, 0x06b0, 0x06fe, 0x06fe, 0x06fe, 0x06fe, 0x06fe, 
	0x06b0, 0x06ff, 0x06ff, 0x06ff, 0x06ff, 0x06ff, 0x06b0, 0x0700, 
	0x0700, 0x0700, 0x0700, 0x0700, 0x06b0, 0x0701, 0x06b0, 0x0702, 
	0x06b0, 0x0703, 0x06b0, 0x0704, 0x06b0, 0x0705, 0x06b0, 0x0706, 
	0x0706, 0x0706, 0x06b0, 0x0707, 0x0707, 0x0707, 0x06b0, 0x0708, 
	0x0708, 0x0708, 0x06b0, 0x0709, 0x06b0, 0x070a, 0x06b0, 0x070b, 
	0x06b0, 0x070c, 0x06b0, 0x070d, 0x06b0, 0x070e, 0x070e, 0x070e, 
	0x06b0, 0x070f, 0x06b0, 0x0710, 0x06b0, 0x0711, 0x06b0, 0x0712, 
	0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 
	0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 
	0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 
	0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 
	0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 
	0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 
	0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 
	0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 
	0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 
	0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082d, 0x082e, 0x082f, 
	0x0830, 0x0831, 0x0832, 0x0833, 0x0834, 0x0835, 0x0836, 0x0837, 
	0x0838, 0x0839, 0x083a, 0x083b, 0x083c, 0x083d, 0x083e, 0x083f, 
	0x0840, 0x0841, 0x0842, 0x0843, 0x0844, 0x0845, 0x0846, 0x0847, 
	0x0848, 0x0849, 0x084a, 0x084b, 0x084c, 0x084d, 0x084e, 0x084f, 
	0x0850, 0x0851, 0x0852, 0x0853, 0x0854, 0x0855, 0x0856, 0x0857, 
	0x0858, 0x0859, 0x085a, 0x085b, 0x085c, 0x085d, 0x085e, 0x085f, 
	0x0860, 0x0861, 0x0862, 0x0863, 0x0864, 0x0865, 0x0866, 0x0867, 
	0x082b, 0x0868, 0x0869, 0x086a, 0x086b, 0x086c, 0x086d, 0x082d, 
	0x086e, 0x086f, 0x0870, 0x0871, 0x0872, 0x0873, 0x0874, 0x082b, 
	0x082d, 0x0875, 0x0876, 0x0877, 0x0878, 0x0879, 0x087a, 0x087b, 
	0x087c, 0x087d, 0x087e, 0x087f, 0x0880, 0x0881, 0x0882, 0x0883, 
	0x082b, 0x082d, 0x0884, 0x0885, 0x0886, 0x0887, 0x0888, 0x0889, 
	0x088a, 0x088b, 0x088c, 0x088d, 0x088e, 0x088f, 0x0890, 0x0891, 
	0x0892, 0x082b, 0x082d, 0x0893, 0x0894, 0x0895, 0x0896, 0x0897, 
	0x0898, 0x0899, 0x089a, 0x089b, 0x089c, 0x089d, 0x089e, 0x089f, 
	0x08a0, 0x08a1, 0x08a2, 0x08a3, 0x08a4, 0x08a5, 0x08a6, 0x08a7, 
	0x08a8, 0x08a9, 0x08aa, 0x08ab, 0x08ac, 0x08ad, 0x08ae, 0x08af, 
	0x08b0, 0x08b1, 0x08b2, 0x08b3, 0x08b4, 0x08b5, 0x08b6, 0x08b7, 
	0x08b8, 0x08b9, 0x08ba, 0x08bb, 0x08bc, 0x08bd, 0x08be, 0x08bf, 
	0x08c0, 0x08c1, 0x08c2, 0x08c3, 0x082b, 0x082d, 0x08c4, 0x08c5, 
	0x08c6, 0x08c7, 0x08c8, 0x082b, 0x08c9, 0x08ca, 0x08cb, 0x08cc, 
	0x08cd, 0x082d, 0x08ce, 0x08cf, 0x08d0, 0x08d1, 0x08d2, 0x08d3, 
	0x08d4, 0x08d5, 0x08d6, 0x08d7, 0x08d8, 0x08d9, 0x08da, 0x08db, 
	0x08dc, 0x08dd, 0x08de, 0x082b, 0x082d, 0x08df, 0x08e0, 0x08e1, 
	0x08e2, 0x08e3, 0x08e4, 0x08e5, 0x08e6, 0x08e7, 0x08e8, 0x08e9, 
	0x08ea, 0x08eb, 0x08ec, 0x08ed, 0x082b, 0x082d, 0x08ee, 0x08ef, 
	0x082d, 0x08f0, 0x08f1, 0x08f2, 0x08f3, 0x08f4, 0x08f5, 0x08f6, 
	0x08f7, 0x08f8, 0x08f9, 0x08fa, 0x08fb, 0x08fc, 0x08fd, 0x08fe, 
	0x08ff, 0x0900, 0x0901, 0x0902, 0x0903, 0x0904, 0x0905, 0x0906, 
	0x0907, 0x0908, 0x0909, 0x090a, 0x090b, 0x090c, 0x090d, 0x090e, 
	0x090f, 0x0910, 0x082b, 0x0911, 0x0912, 0x082d, 0x0913, 0x0914, 
	0x0915, 0x082b, 0x082d, 0x0916, 0x0917, 0x0918, 0x0919, 0x091a, 
	0x091b, 0x091c, 0x091d, 0x091e, 0x091f, 0x0920, 0x0921, 0x0922, 
	0x082b, 0x0923, 0x082d, 0x0924, 0x0925, 0x0926, 0x0927, 0x0928, 
	0x0929, 0x092a, 0x092b, 0x092c, 0x092d, 0x092e, 0x092f, 0x0930, 
	0x0931, 0x0932, 0x0933, 0x0934, 0x0935, 0x0936, 0x082b, 0x082d, 
	0x0937, 0x0938, 0x0939, 0x093a, 0x093b, 0x093c, 0x093d, 0x082b, 
	0x082d, 0x093e, 0x093f, 0x0940, 0x0941, 0x0942, 0x0943, 0x0944, 
	0x0945, 0x0946, 0x0947, 0x0948, 0x0949, 0x094a, 0x094b, 0x094c, 
	0x094d, 0x094e, 0x094f, 0x082b, 0x0950, 0x0951, 0x082d, 0x0952, 
	0x0953, 0x0954, 0x0955, 0x0956, 0x0957, 0x0958, 0x0959, 0x095a, 
	0x095b, 0x095c, 0x095d, 0x095e, 0x095f, 0x0960, 0x0961, 0x0962, 
	0x0963, 0x0964, 0x0965, 0x0966, 0x0967, 0x0968, 0x0969, 0x096a, 
	0x096b, 0x096c, 0x096d, 0x096e, 0x096f, 0x0970, 0x0971, 0x0972, 
	0x0973, 0x0974, 0x0975, 0x0976, 0x0977, 0x0978, 0x0979, 0x097a, 
	0x097b, 0x097c, 0x097d, 0x097e, 0x097f, 0x0980, 0x0981, 0x0982, 
	0x0983, 0x0984, 0x0985, 0x0986, 0x0987, 0x0988, 0x0989, 0x098a, 
	0x098b, 0x098c, 0x098d, 0x098e, 0x098f, 0x0990, 0x0991, 0x0992, 
	0x0993, 0x082b, 0x0994, 0x0995, 0x082d, 0x0996, 0x0997, 0x0998, 
	0x0999, 0x099a, 0x082b, 0x082d, 0x099b, 0x082b, 0x082d, 0x099c, 
	0x099d, 0x099e, 0x099f, 0x09a0, 0x09a1, 0x09a2, 0x09a3, 0x09a4, 
	0x09a5, 0x09a6, 0x09a7, 0x09a8, 0x09a9, 0x09aa, 0x09ab, 0x09ac, 
	0x0882, 0x09ad, 0x082b, 0x082d, 0x09ae, 0x09af, 0x09b0, 0x09b1, 
	0x09b2, 0x09b3, 0x09b4, 0x09b5, 0x09b6, 0x09b7, 0x09b8, 0x09b9, 
	0x09ba, 0x09bb, 0x09bc, 0x09bd, 0x0882, 0x09be, 0x09bf, 0x09c0, 
	0x082b, 0x09c1, 0x09c2, 0x09c3, 0x082d, 0x09c4, 0x09c5, 0x09c6, 
	0x09c7, 0x09c8, 0x09c9, 0x09ca, 0x09cb, 0x09cc, 0x09cd, 0x09ce, 
	0x09cf, 0x09d0, 0x09d1, 0x09d2, 0x082b, 0x09d3, 0x09d4, 0x082d, 
	0x09d5, 0x09d6, 0x09d7, 0x09d8, 0x09d9, 0x09da, 0x09db, 0x09dc, 
	0x09dd, 0x09de, 0x09df, 0x09e0, 0x09e1, 0x09e2, 0x09e3, 0x09e4, 
	0x09e5, 0x09e6, 0x09e7, 0x09e8, 0x09e9, 0x09ea, 0x09eb, 0x09ec, 
	0x09ed, 0x09ee, 0x09ef, 0x09f0, 0x09f1, 0x09f2, 0x09f3, 0x09f4, 
	0x09f5, 0x09f6, 0x09f7, 0x09f8, 0x09f9, 0x09fa, 0x09fb, 0x09fc, 
	0x09fd, 0x09fe, 0x09ff, 0x0a00, 0x0a01, 0x0a02, 0x0a03, 0x0a04, 
	0x0a05, 0x0a06, 0x0a07, 0x0a08, 0x0a09, 0x0a0a, 0x0a0b, 0x0a0c, 
	0x0a0d, 0x0a0e, 0x0a0f, 0x0a10, 0x0a11, 0x082b, 0x082d, 0x0a12, 
	0x0a13, 0x0a14, 0x0a15, 0x0a16, 0x082b, 0x082d, 0x0a17, 0x0a18, 
	0x0a19, 0x0a1a, 0x0a1b, 0x0a1c, 0x0a1d, 0x0a1e, 0x0a1f, 0x0a20, 
	0x0a21, 0x0a22, 0x0a23, 0x082b, 0x082d, 0x0a24, 0x0a25, 0x0a26, 
	0x0a27, 0x0a28, 0x082b, 0x082d, 0x0a29, 0x0a2a, 0x0a2b, 0x0a2c, 
	0x0a2d, 0x0a2e, 0x0a2f, 0x0a30, 0x0a31, 0x0a32, 0x0a33, 0x0a34, 
	0x0a35, 0x0a36, 0x0a37, 0x0a38, 0x0a39, 0x082b, 0x082d, 0x0a3a, 
	0x0a3b, 0x0a3c, 0x0a3d, 0x0a3e, 0x0a3f, 0x0a40, 0x0a41, 0x0a42, 
	0x0a43, 0x0a44, 0x0a45, 0x0a46, 0x082b, 0x0882, 0x0a47, 0x0a48, 
	0x0a49, 0x0a49, 0x0a49, 0x0a49, 0x0a49, 0x0a49, 0x0a49, 0x0a49, 
	0x0a48, 0x0a48, 0x0a48, 0x0a48, 0x0a48, 0x0a48, 0x0a48, 0x0a48, 
	0x0a48, 0x0a4a, 0x0a4b, 0x0a4c, 0x0a4d, 0x0a4e, 0x0a4f, 0x0a50, 
	0x0a51, 0x0a52, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x0a53, 0x082c, 0x0a54, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x0a55, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 0x082c, 
	0x082c, 0x0a56, 0x0a57, 0x0a58, 0x0a59, 0x0a5a, 0x0a57, 0x0a5b, 
	0x0a57, 0x0a5c, 0x0a57, 0x0a5d, 0x0a57, 0x0a5e, 0x0a5f, 0x0a60, 
	0x0a57, 0x0a61, 0x0a57, 0x0a62, 0x0a63, 0x0a64, 0x0a57, 0x0a65, 
	0x0a57, 0x0a66, 0x0a67, 0x0a68, 0x0a69, 0x0a6a, 0x0a6b, 0x0a57, 
	0x0a6c, 0x0a57, 0x0a6d, 0x0a57, 0x0a6e, 0x0a57, 0x0a6f, 0x0a57, 
	0x0a70, 0x0a57, 0x0a71, 0x0a72, 0x0a73, 0x0a57, 0x0a74, 0x0a57, 
	0x0a75, 0x0a57, 0x0a76, 0x0a77, 0x0a57, 0x0a78, 0x0a57, 0x0a79, 
	0x0a7a, 0x0a7b, 0x0a7c, 0x0a7d, 0x0a7e, 0x0a57, 0x0a7f, 0x0a57, 
	0x0a80, 0x0a57, 0x0a81, 0x0a57, 0x0a82, 0x0a83, 0x0a84, 0x0a85, 
	0x0a86, 0x0a85, 0x0a87, 0x0a85, 0x0a88, 0x0a85, 0x0a89, 0x0a85, 
	0x0a8a, 0x0a85, 0x0a8b, 0x0a85, 0x0a8c, 0x0a85, 0x0a8d, 0x0a85, 
	0x0a8e, 0x0a85, 0x0a8f, 0x0a85, 0x0a90, 0x0a85, 0x0a91, 0x0a85, 
	0x0a92, 0x0a85, 0x0a93, 0x0a85, 0x0a94, 0x0a85, 0x0a95, 0x0a85, 
	0x0a96, 0x0a85, 0x0a97, 0x0a85, 0x0a98, 0x0a85, 0x0a99, 0x0a85, 
	0x0a9a, 0x0a85, 0x0a9b, 0x0a85, 0x0a9c, 0x0a85, 0x0a9d, 0x0a85, 
	0x0a9e, 0x0a85, 0x0a9f, 0x0a85, 0x0aa0, 0x0a85, 0x0aa1, 0x0a85, 
	0x0aa2, 0x0a85, 0x0aa3, 0x0a85, 0x0aa4, 0x0a85, 0x0aa5, 0x0a85, 
	0x0aa6, 0x0a85, 0x0aa7, 0x0a85, 0x0aa8, 0x0a85, 0x0aa9, 0x0a85, 
	0x0aaa, 0x0a85, 0x0aab, 0x0a85, 0x0aac, 0x0a85, 0x0aad, 0x0a85, 
	0x0aae, 0x0aaf, 0x0ab0, 0x0a85, 0x0ab1, 0x0aaf, 0x0ab2, 0x0a85, 
	0x0ab3, 0x0a85, 0x0ab4, 0x0a85, 0x0ab5, 0x0a85, 0x0ab6, 0x0a85, 
	0x0ab7, 0x0a85, 0x0ab8, 0x0a85, 0x0ab9, 0x0a85, 0x0aba, 0x0abb, 
	0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 
	0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 
	0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 0x0abb, 
	0x0abb, 0x0abb, 0x082c, 0x082c, 0x082c, 0x082c, 0x0a48, 0x0a48, 
	0x0abc, 0x0abd, 0x0abd, 0x0abd, 0x0abd, 0x0abd, 0x0abd, 0x0a48, 
	0x0a48, 0x0abe, 0x0abe, 0x0abe, 0x0a48, 0x0abf, 0x0abf, 0x0abf, 
	0x0abf, 0x0a48, 0x0a48, 0x0a48, 0x0ac0, 0x0ac0, 0x0ac0, 0x0ac0, 
	0x0ac0, 0x0ac0, 0x0ac0, 0x0a48, 0x0ac1, 0x0ac1, 0x0ac1, 0x0ac1, 
	0x0a48, 0x0ac2, 0x0ac2, 0x0ac2, 0x0ac2, 0x0a48, 0x0ac3, 0x0ac3, 
	0x0ac3, 0x0ac3, 0x0a48, 0x0ac4, 0x0ac4, 0x0ac4, 0x0ac4, 0x0a48, 
	0x0ac5, 0x0ac5, 0x0a48, 0x0ac6, 0x0ac6, 0x0a48, 0x0ac7, 0x0ac7, 
	0x0a48, 0x0ac8, 0x0ac8, 0x0a48, 0x0ac9, 0x0ac9, 0x0ac9, 0x0ac9, 
	0x0a48, 0x0aca, 0x0aca, 0x0aca, 0x0aca, 0x0a48, 0x0acb, 0x0acb, 
	0x0acb, 0x0acb, 0x0a48, 0x0acc, 0x0acc, 0x0acc, 0x0acc, 0x0a48, 
	0x0acd, 0x0acd, 0x0acd, 0x0acd, 0x0a48, 0x0ace, 0x0ace, 0x0ace, 
	0x0ace, 0x0a48, 0x0acf, 0x0acf, 0x0acf, 0x0acf, 0x0a48, 0x0ad0, 
	0x0ad0, 0x0ad0, 0x0ad0, 0x0a48, 0x0ad1, 0x0ad1, 0x0ad1, 0x0ad1, 
	0x0a48, 0x0ad2, 0x0ad2, 0x0ad2, 0x0ad2, 0x0a48, 0x0ad3, 0x0ad3, 
	0x0ad3, 0x0ad3, 0x0a48, 0x0ad4, 0x0ad4, 0x0ad4, 0x0ad4, 0x0a48, 
	0x0ad5, 0x0ad5, 0x0ad5, 0x0ad5, 0x0a48, 0x0ad6, 0x0ad6, 0x0ad6, 
	0x0ad6, 0x0a48, 0x0ad7, 0x0ad7, 0x0ad7, 0x0ad7, 0x0a48, 0x0ad8, 
	0x0ad8, 0x0a48, 0x0ad9, 0x0ad9, 0x0a48, 0x0ada, 0x0ada, 0x0ada, 
	0x0ada, 0x0adb, 0x0adb, 0x0adb, 0x0adb, 0x0adb, 0x0adb, 0x0adb, 
	0x0adb, 0x0adb, 0x0a49, 0x0a4a, 0x0a4b, 0x0a4c, 0x0a4d, 0x0a4e, 
	0x0a4f, 0x0a50, 0x0a51, 0x0a52, 0x0adc, 0x0add, 0x0ade, 0x0adf, 
	0x0ae0, 0x0ae1, 0x0ae2, 0x0ae3, 0x0a48, 0x0ae4, 0x0ae4, 0x0ae4, 
	0x0a48, 0x0ae5, 0x0ae5, 0x0ae5, 0x0a48, 0x0ae6, 0x0ae6, 0x0ae6, 
	0x0ae6, 0x0a48, 0x0ae7, 0x0ae7, 0x0ae7, 0x0a48, 0x0ae8, 0x0ae8, 
	0x0ae8, 0x0a48, 0x0ae9, 0x0ae9, 0x0ae9, 0x0ae9, 0x0a48, 0x0aea, 
	0x0aea, 0x0aea, 0x0a48, 0x0aeb, 0x0aeb, 0x0aeb, 0x0a48, 0x0aec, 
	0x0aec, 0x0aec, 0x0aec, 0x0a48, 0x0aed, 0x0aed, 0x0aed, 0x0a48, 
	0x0aee, 0x0aee, 0x0aee, 0x0a48, 0x0aef, 0x0aef, 0x0aef, 0x0a48, 
	0x0af0, 0x0af0, 0x0af0, 0x0a48, 0x0af1, 0x0af1, 0x0af1, 0x0a48, 
	0x0af2, 0x0af2, 0x0af2, 0x0a48, 0x0af3, 0x0af3, 0x0af3, 0x0a48, 
	0x0af4, 0x0af4, 0x0af4, 0x0a48, 0x0af5, 0x0af5, 0x0af5, 0x0af5, 
	0x0af5, 0x0a48, 0x0af6, 0x0af6, 0x0af6, 0x0a48, 0x0af7, 0x0af7, 
	0x0af7, 0x0a48, 0x0af8, 0x0a48, 0x0af9, 0x0a48, 0x0afa, 0x0a48, 
	0x0afb, 0x0a48, 0x0afc, 0x0a48, 0x0afd, 0x0afd, 0x0afd, 0x0afd, 
	0x0afd, 0x0a48, 0x0afe, 0x0afe, 0x0afe, 0x0afe, 0x0afe, 0x0a48, 
	0x0aff, 0x0aff, 0x0aff, 0x0aff, 0x0aff, 0x0a48, 0x0b00, 0x0b00, 
	0x0b00, 0x0b00, 0x0b00, 0x0a48, 0x0b01, 0x0b01, 0x0b01, 0x0b01, 
	0x0b01, 0x0a48, 0x0b02, 0x0a48, 0x0b03, 0x0a48, 0x0b04, 0x0a48, 
	0x0b05, 0x0a48, 0x0b06, 0x0a48, 0x0b07, 0x0b07, 0x0b07, 0x0a48, 
	0x0b08, 0x0b08, 0x0b08, 0x0a48, 0x0b09, 0x0b09, 0x0b09, 0x0a48, 
	0x0b0a, 0x0a48, 0x0b0b, 0x0a48, 0x0b0c, 0x0a48, 0x0b0d, 0x0a48, 
	0x0b0e, 0x0a48, 0x0b0f, 0x0b0f, 0x0b0f, 0x0a48, 0x0b10, 0x0a48, 
	0x0b11, 0x0a48, 0x0b12, 0x0a48, 0x0b13, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b15, 0x0b14, 0x0b16, 0x0b14, 0x0b17, 0x0b14, 0x0b18, 
	0x0b14, 0x0b19, 0x0b14, 0x0b1a, 0x0b14, 0x0b1b, 0x0b14, 0x0b1c, 
	0x0b14, 0x0b1d, 0x0b14, 0x0b1e, 0x0b14, 0x0b1f, 0x0b14, 0x0b20, 
	0x0b14, 0x0b21, 0x0b14, 0x0b22, 0x0b14, 0x0b23, 0x0b14, 0x0b24, 
	0x0b14, 0x0b25, 0x0b14, 0x0b26, 0x0b14, 0x0b27, 0x0b14, 0x0b28, 
	0x0b14, 0x0b29, 0x0b14, 0x0b2a, 0x0b14, 0x0b2b, 0x0b14, 0x0b2c, 
	0x0b14, 0x0b2d, 0x0b14, 0x0b2e, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 
	0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b14, 0x0b2f, 
	0x0b2f, 0x0b2f, 0x0b2f, 0x0b2f, 0x0b2f, 0x0b2f, 0x0b2f, 0x0b2f, 
	0x0b14, 0x082b, 0x082b, 0x082b, 0x082b, 0x082b, 0x0a56, 0x0b30, 
	0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 
	0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 
	0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 
	0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 
	0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b30, 0x0b31, 0x0b31, 
	0x0b31, 0x0b31, 0x0b31, 0x0b31, 0x0b31, 0x0b31, 0x0b32, 0x0b33, 
	0x0b32, 0x0b34, 0x0b32, 0x0b35, 0x0b32, 0x0b36, 0x0b32, 0x0b37, 
	0x0b32, 0x0b38, 0x0b32, 0x0b39, 0x0b32, 0x0b3a, 0x0b32, 0x0b3b, 
	0x0b32, 0x0b3c, 0x0b3d, 0x0b3e, 0x0b3d, 0x0b3f, 0x0b3d, 0x0b40, 
	0x0b3d, 0x0b41, 0x0b3d, 0x0b42, 0x0b3d, 0x0b43, 0x0b3d, 0x0b44, 
	0x0b3d, 0x0b45, 0x0b3d, 0x0b46, 0x0b3d, 0x0b47, 0x0b3d, 0x0b48, 
	0x0b3d, 0x0b49, 0x0b3d, 0x0b4a, 0x0b3d, 0x0b4b, 0x0b3d, 0x0b4c, 
	0x0b3d, 0x0b4d, 0x0b3d, 0x0b4e, 0x0b3d, 0x0b4f, 0x0b3d, 0x0b50, 
	0x0b3d, 0x0b51, 0x0b3d, 0x0b52, 0x0b3d, 0x0b53, 0x0b3d, 0x0b54, 
	0x0b3d, 0x0b55, 0x0b3d, 0x0b56, 0x0b3d, 0x0b57, 0x0b32, 0x0b58, 
	0x0b59, 0x0b5a, 0x0b5b, 0x0b5c, 0x0b32, 0x0b5d, 0x0b5e, 0x0b5f, 
	0x0b60, 0x0b61, 0x0b32, 0x0b62, 0x0b63, 0x0b64, 0x0b65, 0x0b66, 
	0x0b32, 0x0b67, 0x0b68, 0x0b69, 0x0b6a, 0x0b6b, 0x0b32, 0x0b6c, 
	0x0b6d, 0x0b6e, 0x0b6f, 0x0b70, 0x0b32, 0x0b71, 0x0b72, 0x0b73, 
	0x0b74, 0x0b75, 0x0b32, 0x0b76, 0x0b77, 0x0b78, 0x0b79, 0x0b7a, 
	0x0b32, 0x0b7b, 0x0b7c, 0x0b7d, 0x0b7e, 0x0b7f, 0x0b32, 0x0b80, 
	0x0b81, 0x0b82, 0x0b83, 0x0b84, 0x0b32, 0x0b85, 0x0b86, 0x0b87, 
	0x0b88, 0x0b89, 0x0b32, 0x0b8a, 0x0b8b, 0x0b8c, 0x0b8d, 0x0b8e, 
	0x0b32, 0x0b8f, 0x0b90, 0x0b91, 0x0b92, 0x0b93, 0x0b32, 0x0b94, 
	0x0b95, 0x0b96, 0x0b97, 0x0b98, 0x0b32, 0x0b99, 0x0b9a, 0x0b9b, 
	0x0b9c, 0x0b9d, 0x0b32, 0x0b9e, 0x0b9f, 0x0ba0, 0x0ba1, 0x0ba2, 
	0x0b32, 0x0ba3, 0x0ba4, 0x0ba5, 0x0ba6, 0x0ba7, 0x0b32, 0x0ba8, 
	0x0ba9, 0x0baa, 0x0bab, 0x0bac, 0x0b32, 0x0bad, 0x0bae, 0x0baf, 
	0x0bb0, 0x0bb1, 0x0b32, 0x0bb2, 0x0bb3, 0x0bb4, 0x0bb5, 0x0bb6, 
	0x0b32, 0x0bb7, 0x0bb8, 0x0bb9, 0x0bba, 0x0bbb, 0x0b32, 0x0bbc, 
	0x0bbd, 0x0bbe, 0x0bbf, 0x0bc0, 0x0b32, 0x0bc1, 0x0bc2, 0x0bc3, 
	0x0bc4, 0x0bc5, 0x0b32, 0x0bc6, 0x0bc7, 0x0bc8, 0x0bc9, 0x0bca, 
	0x0b32, 0x0bcb, 0x0bcc, 0x0bcd, 0x0bce, 0x0bcf, 0x0b32, 0x0bd0, 
	0x0bd1, 0x0bd2, 0x0bd3, 0x0bd4, 0x0b32, 0x0bd5, 0x0bd6, 0x0bd7, 
	0x0bd8, 0x0bd9, 0x0b32, 0x0bda, 0x0bdb, 0x0bdc, 0x0bdd, 0x0bde, 
	0x0b32, 0x0bdf, 0x0be0, 0x0be1, 0x0be2, 0x0be3, 0x0b32, 0x0be4, 
	0x0be5, 0x0be6, 0x0be7, 0x0be8, 0x0b32, 0x0be9, 0x0bea, 0x0beb, 
	0x0bec, 0x0bed, 0x0b32, 0x0bee, 0x0bef, 0x0bf0, 0x0bf1, 0x0bf2, 
	0x0b32, 0x0bf3, 0x0bf4, 0x0bf5, 0x0bf6, 0x0bf7, 0x0b32, 0x0bf8, 
	0x0bf9, 0x0bfa, 0x0bfb, 0x0bfc, 0x0b32, 0x0bfd, 0x0bfe, 0x0bff, 
	0x0c00, 0x0c01, 0x0b32, 0x0c02, 0x0c03, 0x0c04, 0x0c05, 0x0c06, 
	0x0b32, 0x0b32, 0x0c07, 0x0c08, 0x0c09, 0x0c0a, 0x0c0b, 0x0b32, 
	0x0b32, 0x0c0c, 0x0c0d, 0x0c0e, 0x0c0f, 0x0c10, 0x0b32, 0x0c11, 
	0x0c12, 0x0c13, 0x0c14, 0x0c15, 0x0b32, 0x0c16, 0x0c17, 0x0c18, 
	0x0c19, 0x0c1a, 0x0b32, 0x0c1b, 0x0c1c, 0x0c1d, 0x0c1e, 0x0c1f, 
	0x0b32, 0x0c20, 0x0c21, 0x0c22, 0x0c23, 0x0c24, 0x0b32, 0x0c25, 
	0x0c26, 0x0c27, 0x0c28, 0x0c29, 0x0b32, 0x0c2a, 0x0c2b, 0x0c2c, 
	0x0c2d, 0x0c2e, 0x0b32, 0x0c2f, 0x0c30, 0x0c31, 0x0c32, 0x0c33, 
	0x0b32, 0x0b32, 0x0b32, 0x0b32, 0x0c34, 0x0b32, 0x0b32, 0x0b32, 
	0x0b32, 0x0b32, 0x0b32, 0x0b32, 0x0b32, 0x0b32, 0x0b32, 0x0b32, 
	0x0b32, 0x0026, 0x0028, 0x002a, 0x002c, 0x002e, 0x0030, 0x0032, 
	0x0034, 0x0036, 0x0038, 0x003a, 0x003c, 0x003e, 0x0040, 0x0042, 
	0x0044, 0x0046, 0x0048, 0x004a, 0x004c, 0x004e, 0x0050, 0x0052, 
	0x0054, 0x0056, 0x0058, 0x005a, 0x005c, 0x005e, 0x0060, 0x0062, 
	0x0064, 0x0066, 0x0068, 0x006a, 0x006c, 0x006e, 0x0070, 0x01de, 
	     0, 0x01df,      0, 0x01ea,      0, 0x01eb,      0, 0x0406, 
	     0, 0x01f8,      0, 0x01ff,      0, 0x0203,      0, 0x020a, 
	     0, 0x020c,      0, 0x0210,      0, 0x0212,      0, 0x0416, 
	     0, 0x0224,      0, 0x018e,      0, 0x018f,      0, 0x019a, 
	     0, 0x019b,      0, 0x03de,      0, 0x01a9,      0, 0x01b0, 
	     0, 0x01b5,      0, 0x01bd,      0, 0x01bf,      0, 0x01c3, 
	     0, 0x01c5,      0, 0x03ef,      0, 0x01d7,      0, 0x02c0, 
	     0, 0x02ca,      0, 0x02d3,      0, 0x02d8,      0, 0x02d9, 
	     0, 0x0431,      0, 0x0246,      0, 0x0438,      0, 0x043a, 
	     0, 0x061c,      0, 0x0026, 0x0028, 0x002a, 0x002c, 0x002e, 
	0x0030, 0x0032, 0x0034, 0x0036, 0x0038, 0x003a, 0x003c, 0x003e, 
	0x0040, 0x0042, 0x0044, 0x0046, 0x0048, 0x004a, 0x004c, 0x004e, 
	0x0050, 0x0052, 0x0054, 0x0056, 0x0058, 0x005a, 0x005c, 0x005e, 
	0x0063, 0x0068, 0x0070, 0x0075, 0x007a, 0x007c, 0x007e, 0x0080, 
	0x0082, 0x01de,      0, 0x01df,      0, 0x01ea,      0, 0x01eb, 
	     0, 0x0406,      0, 0x01f8,      0, 0x01ff,      0, 0x0203, 
	     0, 0x020a,      0, 0x020c,      0, 0x0210,      0, 0x0212, 
	     0, 0x0416,      0, 0x0224,      0, 0x018e,      0, 0x018f, 
	     0, 0x019a,      0, 0x019b,      0, 0x03de,      0, 0x01a9, 
	     0, 0x01b0,      0, 0x01b5,      0, 0x01bd,      0, 0x01bf, 
	     0, 0x01c3,      0, 0x01c5,      0, 0x03ef,      0, 0x01d7, 
	     0, 0x048a, 0x0128,      0, 0x02c0,      0, 0x048e, 0x0125, 
	     0, 0x02ca,      0, 0x0490, 0x0128,      0, 0x048f, 0x0125, 
	     0, 0x02d3,      0, 0x0491, 0x012b,      0, 0x02d8,      0, 
	0x0492, 0x0125,      0, 0x02d9,      0, 0x0431,      0, 0x0246, 
	     0, 0x0438,      0, 0x043a,      0, 0x061c,      0, 0x0026, 
	0x0028, 0x002a, 0x002c, 0x0031, 0x0033, 0x0035, 0x0037, 0x003c, 
	0x003e, 0x0040, 0x0042, 0x0044, 0x0046, 0x0048, 0x004a, 0x004c, 
	0x004e, 0x0053, 0x0055, 0x0057, 0x0059, 0x005e, 0x0060, 0x0062, 
	0x0064, 0x0066, 0x0068, 0x006a, 0x006c, 0x006e, 0x0070, 0x0072, 
	0x0074, 0x0076, 0x0078, 0x007a, 0x007c, 0x01de,      0, 0x01df, 
	     0, 0x01ea,      0, 0x0496, 0x00a9,      0, 0x01eb,      0, 
	0x0406,      0, 0x01f8,      0, 0x01ff,      0, 0x0498, 0x00a9, 
	     0, 0x0203,      0, 0x020a,      0, 0x020c,      0, 0x0210, 
	     0, 0x0212,      0, 0x0416,      0, 0x0224,      0, 0x018e, 
	     0, 0x018f,      0, 0x019a,      0, 0x0495, 0x00a9,      0, 
	0x019b,      0, 0x03de,      0, 0x01a9,      0, 0x01b0,      0, 
	0x0497, 0x00a9,      0, 0x01b5,      0, 0x01bd,      0, 0x01bf, 
	     0, 0x01c3,      0, 0x01c5,      0, 0x03ef,      0, 0x01d7, 
	     0, 0x02c0,      0, 0x02ca,      0, 0x02d3,      0, 0x02d8, 
	     0, 0x02d9,      0, 0x0431,      0, 0x0246,      0, 0x0438, 
	     0, 0x043a,      0, 0x061c,      0, 0x0026, 0x0028, 0x002a, 
	0x002c, 0x002e, 0x0030, 0x0032, 0x003a, 0x003c, 0x003e, 0x0040, 
	0x0042, 0x0044, 0x0046, 0x0048, 0x004a, 0x004c, 0x004e, 0x0050, 
	0x0052, 0x0054, 0x005c, 0x005e, 0x0060, 0x0062, 0x0064, 0x0066, 
	0x0068, 0x006a, 0x006c, 0x006e, 0x0070, 0x0072, 0x0074, 0x0076, 
	0x0078, 0x007a, 0x007c, 0x01de,      0, 0x01df,      0, 0x01ea, 
	     0, 0x01eb,      0, 0x0406,      0, 0x01f8,      0, 0x04c6, 
	0x019b,      0, 0x04c5, 0x01eb,      0, 0x01ff,      0, 0x0203, 
	     0, 0x020a,      0, 0x020c,      0, 0x0210,      0, 0x0212, 
	     0, 0x0416,      0, 0x0224,      0, 0x018e,      0, 0x018f, 
	     0, 0x019a,      0, 0x019b,      0, 0x03de,      0, 0x01a9, 
	     0, 0x04c3, 0x019b,      0, 0x04c4, 0x01eb,      0, 0x01b0, 
	     0, 0x01b5,      0, 0x01bd,      0, 0x01bf,      0, 0x01c3, 
	     0, 0x01c5,      0, 0x03ef,      0, 0x01d7,      0, 0x02c0, 
	     0, 0x02ca,      0, 0x02d3,      0, 0x02d8,      0, 0x02d9, 
	     0, 0x0431,      0, 0x0246,      0, 0x0438,      0, 0x043a, 
	     0, 0x061c,      0, 0x0026, 0x0028, 0x0030, 0x0032, 0x0034, 
	0x0036, 0x003e, 0x0046, 0x0048, 0x004a, 0x004c, 0x004e, 0x0050, 
	0x0052, 0x0054, 0x0056, 0x005e, 0x0060, 0x0062, 0x0064, 0x006c, 
	0x0074, 0x0076, 0x0078, 0x007a, 0x007c, 0x007e, 0x0080, 0x0082, 
	0x0084, 0x0086, 0x0088, 0x008a, 0x008c, 0x008e, 0x0090, 0x0092, 
	0x0094, 0x01de,      0, 0x04f1, 0x03f0,      0, 0x04f0, 0x0417, 
	     0, 0x01df,      0, 0x01ea,      0, 0x01eb,      0, 0x0406, 
	     0, 0x04f5, 0x01a5,      0, 0x04f4, 0x01f5,      0, 0x01f8, 
	     0, 0x04f9, 0x01a5,      0, 0x04f8, 0x01f5,      0, 0x01ff, 
	     0, 0x0203,      0, 0x020a,      0, 0x020c,      0, 0x0210, 
	     0, 0x0212,      0, 0x0416,      0, 0x0224,      0, 0x018e, 
	     0, 0x04ee, 0x03f0,      0, 0x04ef, 0x0417,      0, 0x018f, 
	     0, 0x019a,      0, 0x019b,      0, 0x03de,      0, 0x04f2, 
	0x01a5,      0, 0x04f3, 0x01f5,      0, 0x01a9,      0, 0x04f6, 
	0x01a5,      0, 0x04f7, 0x01f5,      0, 0x01b0,      0, 0x01b5, 
	     0, 0x01bd,      0, 0x01bf,      0, 0x01c3,      0, 0x01c5, 
	     0, 0x03ef,      0, 0x01d7,      0, 0x02c0,      0, 0x02ca, 
	     0, 0x02d3,      0, 0x02d8,      0, 0x02d9,      0, 0x0431, 
	     0, 0x0246,      0, 0x0438,      0, 0x043a,      0, 0x061c, 
	     0, 0x0026, 0x0028, 0x002a, 0x002c, 0x0034, 0x003c, 0x003e, 
	0x0040, 0x0042, 0x0044, 0x0046, 0x0048, 0x004a, 0x004c, 0x004e, 
	0x0050, 0x0052, 0x0054, 0x005c, 0x0064, 0x0066, 0x0068, 0x006a, 
	0x006c, 0x006e, 0x0070, 0x0072, 0x0074, 0x0076, 0x0078, 0x007a, 
	0x007c, 0x007e, 0x0080, 0x0082, 0x0084, 0x0086, 0x0088, 0x01de, 
	     0, 0x01df,      0, 0x01ea,      0, 0x0526, 0x03dd,      0, 
	0x0525, 0x0405,      0, 0x01eb,      0, 0x052a, 0x0191,      0, 
	0x0529, 0x01e1,      0, 0x0406,      0, 0x01f8,      0, 0x01ff, 
	     0, 0x0203,      0, 0x020a,      0, 0x020c,      0, 0x0210, 
	     0, 0x0212,      0, 0x0416,      0, 0x0224,      0, 0x018e, 
	     0, 0x018f,      0, 0x019a,      0, 0x0523, 0x03dd,      0, 
	0x0524, 0x0405,      0, 0x019b,      0, 0x0527, 0x0191,      0, 
	0x0528, 0x01e1,      0, 0x03de,      0, 0x01a9,      0, 0x01b0, 
	     0, 0x01b5,      0, 0x01bd,      0, 0x01bf,      0, 0x01c3, 
	     0, 0x01c5,      0, 0x03ef,      0, 0x01d7,      0, 0x02c0, 
	     0, 0x02ca,      0, 0x02d3,      0, 0x02d8,      0, 0x02d9, 
	     0, 0x0431,      0, 0x0246,      0, 0x0438,      0, 0x043a, 
	     0, 0x061c,      0, 0x0026, 0x0028, 0x002a, 0x002c, 0x002e, 
	0x0030, 0x0032, 0x003a, 0x003c, 0x003e, 0x0040, 0x0042, 0x0044, 
	0x004c, 0x004e, 0x0050, 0x0052, 0x0054, 0x0056, 0x0058, 0x005a, 
	0x0062, 0x0064, 0x0066, 0x0068, 0x006a, 0x006c, 0x0074, 0x0076, 
	0x0078, 0x007a, 0x007c, 0x007e, 0x0080, 0x0082, 0x0084, 0x0086, 
	0x0088, 0x01de,      0, 0x01df,      0, 0x01ea,      0, 0x01eb, 
	     0, 0x0406,      0, 0x01f8,      0, 0x04c6, 0x019b,      0, 
	0x04c5, 0x01eb,      0, 0x01ff,      0, 0x0203,      0, 0x020a, 
	     0, 0x020c,      0, 0x0210,      0, 0x0212,      0, 0x0530, 
	0x019d,      0, 0x052f, 0x01ed,      0, 0x0416,      0, 0x0224, 
	     0, 0x018e,      0, 0x018f,      0, 0x019a,      0, 0x019b, 
	     0, 0x03de,      0, 0x01a9,      0, 0x04c3, 0x019b,      0, 
	0x04c4, 0x01eb,      0, 0x01b0,      0, 0x01b5,      0, 0x01bd, 
	     0, 0x01bf,      0, 0x01c3,      0, 0x01c5,      0, 0x052d, 
	0x019d,      0, 0x052e, 0x01ed,      0, 0x03ef,      0, 0x01d7, 
	     0, 0x02c0,      0, 0x02ca,      0, 0x02d3,      0, 0x02d8, 
	     0, 0x02d9,      0, 0x0431,      0, 0x0246,      0, 0x0438, 
	     0, 0x043a,      0, 0x061c,      0, 0x0026, 0x003e, 0x008e, 
	0x0090, 0x00a8, 0x00aa, 0x00c2, 0x00da, 0x00dc, 0x00de, 0x00e0, 
	0x00f8, 0x0110, 0x0112, 0x012a, 0x0142, 0x0192, 0x0194, 0x01ac, 
	0x01ae, 0x01c6, 0x01de, 0x01e0, 0x01e2, 0x01e4, 0x01fc, 0x0214, 
	0x0216, 0x022e, 0x0230, 0x0232, 0x0234, 0x0236, 0x0238, 0x023a, 
	0x023c, 0x023e, 0x0240, 0x0591, 0x01c3,      0, 0x0595, 0x018e, 
	0x01c3,      0, 0x0594, 0x018e, 0x0210,      0, 0x0590, 0x0210, 
	     0, 0x0593, 0x01de, 0x01c3,      0, 0x0592, 0x01de, 0x0210, 
	     0, 0x01de,      0, 0x05ab, 0x01d7, 0x01c3,      0, 0x05aa, 
	0x01d7, 0x0210,      0, 0x059d, 0x01d7,      0, 0x05b3, 0x018f, 
	0x01d7, 0x01c3,      0, 0x05b2, 0x018f, 0x01d7, 0x0210,      0, 
	0x05a1, 0x018f, 0x01d7,      0, 0x05b1, 0x018f, 0x0224, 0x01c3, 
	     0, 0x05b0, 0x018f, 0x0224, 0x0210,      0, 0x05a0, 0x018f, 
	0x0224,      0, 0x05a9, 0x0224, 0x01c3,      0, 0x05a8, 0x0224, 
	0x0210,      0, 0x059c, 0x0224,      0, 0x05af, 0x01df, 0x01d7, 
	0x01c3,      0, 0x05ae, 0x01df, 0x01d7, 0x0210,      0, 0x059f, 
	0x01df, 0x01d7,      0, 0x05ad, 0x01df, 0x0224, 0x01c3,      0, 
	0x05ac, 0x01df, 0x0224, 0x0210,      0, 0x059e, 0x01df, 0x0224, 
	     0, 0x01df,      0, 0x01ea,      0, 0x05c1, 0x01d3,      0, 
	0x05c5, 0x019b, 0x01d3,      0, 0x05c4, 0x019b, 0x0220,      0, 
	0x05c0, 0x0220,      0, 0x05c3, 0x01eb, 0x01d3,      0, 0x05c2, 
	0x01eb, 0x0220,      0, 0x01eb,      0, 0x0406,      0, 0x05cd, 
	0x01d3,      0, 0x05d1, 0x01a9, 0x01d3,      0, 0x05d0, 0x01a9, 
	0x0220,      0, 0x05cc, 0x0220,      0, 0x05cf, 0x01f8, 0x01d3, 
	     0, 0x05ce, 0x01f8, 0x0220,      0, 0x01f8,      0, 0x05d9, 
	0x01d3,      0, 0x05dd, 0x01b0, 0x01d3,      0, 0x05dc, 0x01b0, 
	0x0220,      0, 0x05d8, 0x0220,      0, 0x05db, 0x01ff, 0x01d3, 
	     0, 0x05da, 0x01ff, 0x0220,      0, 0x01ff,      0, 0x0203, 
	     0, 0x020a,      0, 0x020c,      0, 0x05e5, 0x01d7,      0, 
	0x05e9, 0x01c3, 0x01d7,      0, 0x05e8, 0x01c3, 0x0224,      0, 
	0x05e4, 0x0224,      0, 0x05e7, 0x0210, 0x01d7,      0, 0x05e6, 
	0x0210, 0x0224,      0, 0x0210,      0, 0x05f1, 0x01d3,      0, 
	0x05f5, 0x01c5, 0x01d3,      0, 0x05f4, 0x01c5, 0x0220,      0, 
	0x05f0, 0x0220,      0, 0x05f3, 0x0212, 0x01d3,      0, 0x05f2, 
	0x0212, 0x0220,      0, 0x0212,      0, 0x0416,      0, 0x0601, 
	0x01d7, 0x01c3,      0, 0x0600, 0x01d7, 0x0210,      0, 0x05fd, 
	0x01c3,      0, 0x05ff, 0x0224, 0x01c3,      0, 0x05fe, 0x0224, 
	0x0210,      0, 0x05fc, 0x0210,      0, 0x0224,      0, 0x0597, 
	0x01c3,      0, 0x059b, 0x018e, 0x01c3,      0, 0x059a, 0x018e, 
	0x0210,      0, 0x0596, 0x0210,      0, 0x0599, 0x01de, 0x01c3, 
	     0, 0x0598, 0x01de, 0x0210,      0, 0x018e,      0, 0x05b7, 
	0x01d7, 0x01c3,      0, 0x05b6, 0x01d7, 0x0210,      0, 0x05a3, 
	0x01d7,      0, 0x05bf, 0x018f, 0x01d7, 0x01c3,      0, 0x05be, 
	0x018f, 0x01d7, 0x0210,      0, 0x05a7, 0x018f, 0x01d7,      0, 
	0x05bd, 0x018f, 0x0224, 0x01c3,      0, 0x05bc, 0x018f, 0x0224, 
	0x0210,      0, 0x05a6, 0x018f, 0x0224,      0, 0x05b5, 0x0224, 
	0x01c3,      0, 0x05b4, 0x0224, 0x0210,      0, 0x05a2, 0x0224, 
	     0, 0x05bb, 0x01df, 0x01d7, 0x01c3,      0, 0x05ba, 0x01df, 
	0x01d7, 0x0210,      0, 0x05a5, 0x01df, 0x01d7,      0, 0x05b9, 
	0x01df, 0x0224, 0x01c3,      0, 0x05b8, 0x01df, 0x0224, 0x0210, 
	     0, 0x05a4, 0x01df, 0x0224,      0, 0x018f,      0, 0x019a, 
	     0, 0x05c6, 0x01d3,      0, 0x05cb, 0x019b, 0x01d3,      0, 
	0x05ca, 0x019b, 0x0220,      0, 0x05c7, 0x0220,      0, 0x05c9, 
	0x01eb, 0x01d3,      0, 0x05c8, 0x01eb, 0x0220,      0, 0x019b, 
	     0, 0x03de,      0, 0x05d2, 0x01d3,      0, 0x05d7, 0x01a9, 
	0x01d3,      0, 0x05d6, 0x01a9, 0x0220,      0, 0x05d3, 0x0220, 
	     0, 0x05d5, 0x01f8, 0x01d3,      0, 0x05d4, 0x01f8, 0x0220, 
	     0, 0x01a9,      0, 0x05de, 0x01d3,      0, 0x05e3, 0x01b0, 
	0x01d3,      0, 0x05e2, 0x01b0, 0x0220,      0, 0x05df, 0x0220, 
	     0, 0x05e1, 0x01ff, 0x01d3,      0, 0x05e0, 0x01ff, 0x0220, 
	     0, 0x01b0,      0, 0x01b5,      0, 0x01bd,      0, 0x01bf, 
	     0, 0x05eb, 0x01d7,      0, 0x05ef, 0x01c3, 0x01d7,      0, 
	0x05ee, 0x01c3, 0x0224,      0, 0x05ea, 0x0224,      0, 0x05ed, 
	0x0210, 0x01d7,      0, 0x05ec, 0x0210, 0x0224,      0, 0x01c3, 
	     0, 0x05f7, 0x01d3,      0, 0x05fb, 0x01c5, 0x01d3,      0, 
	0x05fa, 0x01c5, 0x0220,      0, 0x05f6, 0x0220,      0, 0x05f9, 
	0x0212, 0x01d3,      0, 0x05f8, 0x0212, 0x0220,      0, 0x01c5, 
	     0, 0x03ef,      0, 0x0607, 0x01d7, 0x01c3,      0, 0x0606, 
	0x01d7, 0x0210,      0, 0x0603, 0x01c3,      0, 0x0605, 0x0224, 
	0x01c3,      0, 0x0604, 0x0224, 0x0210,      0, 0x0602, 0x0210, 
	     0, 0x01d7,      0, 0x02c0,      0, 0x02ca,      0, 0x02d3, 
	     0, 0x02d8,      0, 0x02d9,      0, 0x0431,      0, 0x0246, 
	     0, 0x0438,      0, 0x043a,      0, 0x061c,      0, 0x0026, 
	0x0028, 0x002a, 0x002c, 0x002e, 0x0030, 0x0032, 0x0034, 0x0036, 
	0x0038, 0x003a, 0x003c, 0x003e, 0x0040, 0x0042, 0x0044, 0x0046, 
	0x0048, 0x004a, 0x004c, 0x004e, 0x0050, 0x0052, 0x0054, 0x0056, 
	0x0058, 0x005a, 0x005c, 0x005e, 0x0060, 0x0062, 0x0064, 0x0066, 
	0x0068, 0x0070, 0x0075, 0x007a, 0x007f, 0x01de,      0, 0x01df, 
	     0, 0x01ea,      0, 0x01eb,      0, 0x0406,      0, 0x01f8, 
	     0, 0x01ff,      0, 0x0203,      0, 0x020a,      0, 0x020c, 
	     0, 0x0210,      0, 0x0212,      0, 0x0416,      0, 0x0224, 
	     0, 0x018e,      0, 0x018f,      0, 0x019a,      0, 0x019b, 
	     0, 0x03de,      0, 0x01a9,      0, 0x01b0,      0, 0x01b5, 
	     0, 0x01bd,      0, 0x01bf,      0, 0x01c3,      0, 0x01c5, 
	     0, 0x03ef,      0, 0x01d7,      0, 0x02c0,      0, 0x02ca, 
	     0, 0x02d3,      0, 0x02d8,      0, 0x02d9,      0, 0x0617, 
	0x0612,      0, 0x0614, 0x0610,      0, 0x0431,      0, 0x0618, 
	0x0611,      0, 0x0246,      0, 0x061a, 0x0611,      0, 0x0438, 
	     0, 0x061b, 0x0611,      0, 0x043a,      0, 0x0619, 0x0611, 
	     0, 0x061c,      0, 0x0026, 0x002e, 0x0036, 0x003e, 0x0040, 
	0x0042, 0x004a, 0x0052, 0x0054, 0x005c, 0x0064, 0x0066, 0x006e, 
	0x0070, 0x0072, 0x007a, 0x0082, 0x008a, 0x008c, 0x008e, 0x0096, 
	0x009e, 0x00a0, 0x00a8, 0x00b0, 0x00b2, 0x00ba, 0x00bc, 0x00be, 
	0x00c0, 0x00c2, 0x00c4, 0x00c6, 0x00c8, 0x00ca, 0x00cc, 0x00ce, 
	0x00d0, 0x0637, 0x019d,      0, 0x0636, 0x01ed,      0, 0x01de, 
	     0, 0x063b, 0x018f,      0, 0x063a, 0x01df,      0, 0x01df, 
	     0, 0x063f, 0x019a,      0, 0x063e, 0x01ea,      0, 0x01ea, 
	     0, 0x01eb,      0, 0x0406,      0, 0x0643, 0x01a9,      0, 
	0x0642, 0x01f8,      0, 0x01f8,      0, 0x04c6, 0x019b,      0, 
	0x04c5, 0x01eb,      0, 0x01ff,      0, 0x0203,      0, 0x0647, 
	0x019d,      0, 0x0646, 0x01ed,      0, 0x020a,      0, 0x064b, 
	0x019d,      0, 0x064a, 0x01ed,      0, 0x020c,      0, 0x0210, 
	     0, 0x064f, 0x019d,      0, 0x064e, 0x01ed,      0, 0x0212, 
	     0, 0x0416,      0, 0x0224,      0, 0x0634, 0x019d,      0, 
	0x0635, 0x01ed,      0, 0x018e,      0, 0x0638, 0x018f,      0, 
	0x0639, 0x01df,      0, 0x018f,      0, 0x063c, 0x019a,      0, 
	0x063d, 0x01ea,      0, 0x019a,      0, 0x019b,      0, 0x03de, 
	     0, 0x0640, 0x01a9,      0, 0x0641, 0x01f8,      0, 0x01a9, 
	     0, 0x04c3, 0x019b,      0, 0x04c4, 0x01eb,      0, 0x01b0, 
	     0, 0x01b5,      0, 0x0644, 0x019d,      0, 0x0645, 0x01ed, 
	     0, 0x01bd,      0, 0x0648, 0x019d,      0, 0x0649, 0x01ed, 
	     0, 0x01bf,      0, 0x01c3,      0, 0x064c, 0x019d,      0, 
	0x064d, 0x01ed,      0, 0x01c5,      0, 0x03ef,      0, 0x01d7, 
	     0, 0x02c0,      0, 0x02ca,      0, 0x02d3,      0, 0x02d8, 
	     0, 0x02d9,      0, 0x0431,      0, 0x0246,      0, 0x0438, 
	     0, 0x043a,      0, 0x061c,      0, 0x0026, 0x0036, 0x0038, 
	0x003a, 0x003c, 0x003e, 0x0040, 0x0042, 0x0044, 0x0046, 0x0048, 
	0x004a, 0x004c, 0x004e, 0x0050, 0x0060, 0x0062, 0x0064, 0x0066, 
	0x0068, 0x006a, 0x006c, 0x006e, 0x0070, 0x0072, 0x0074, 0x0076, 
	0x0078, 0x007a, 0x007c, 0x007e, 0x0080, 0x0082, 0x0084, 0x0086, 
	0x0088, 0x008a, 0x008c, 0x0637, 0x019d,      0, 0x0636, 0x01ed, 
	     0, 0x0655, 0x00a9, 0x019d,      0, 0x0654, 0x00a9, 0x01ed, 
	     0, 0x01de,      0, 0x01df,      0, 0x01ea,      0, 0x01eb, 
	     0, 0x0406,      0, 0x01f8,      0, 0x01ff,      0, 0x0203, 
	     0, 0x020a,      0, 0x020c,      0, 0x0210,      0, 0x0212, 
	     0, 0x0416,      0, 0x0224,      0, 0x0634, 0x019d,      0, 
	0x0635, 0x01ed,      0, 0x0652, 0x00a9, 0x019d,      0, 0x0653, 
	0x00a9, 0x01ed,      0, 0x018e,      0, 0x018f,      0, 0x019a, 
	     0, 0x019b,      0, 0x03de,      0, 0x01a9,      0, 0x01b0, 
	     0, 0x01b5,      0, 0x01bd,      0, 0x01bf,      0, 0x01c3, 
	     0, 0x01c5,      0, 0x03ef,      0, 0x01d7,      0, 0x02c0, 
	     0, 0x02ca,      0, 0x02d3,      0, 0x02d8,      0, 0x02d9, 
	     0, 0x0431,      0, 0x0246,      0, 0x0438,      0, 0x043a, 
	     0, 0x061c,      0, 0x000a, 0x000c, 0x000e, 0x0010, 0x0012, 
	0x0014, 0x0016, 0x0018, 0x001a, 0x001c, 0x02a9,      0, 0x02e2, 
	     0, 0x02ed,      0, 0x0385,      0, 0x039f,      0, 0x02aa, 
	     0, 0x02e3,      0, 0x02ee,      0, 0x0386,      0, 0x03a0, 
	     0, 0x000a, 0x0012, 0x0014, 0x0016, 0x0018, 0x001a, 0x0022, 
	0x0024, 0x0026, 0x0028, 0x075c, 0x02aa,      0, 0x075b, 0x02a9, 
	     0, 0x02a9,      0, 0x02e2,      0, 0x02ed,      0, 0x0385, 
	     0, 0x039f,      0, 0x075e, 0x02aa,      0, 0x075d, 0x02a9, 
	     0, 0x02aa,      0, 0x02e3,      0, 0x02ee,      0, 0x0386, 
	     0, 0x03a0,      0, 0x000a, 0x000c, 0x000e, 0x0016, 0x001e, 
	0x0026, 0x0028, 0x002a, 0x0032, 0x003a, 0x02a9,      0, 0x02e2, 
	     0, 0x0788, 0x0758,      0, 0x0787, 0x0757,      0, 0x02ed, 
	     0, 0x078c, 0x0374,      0, 0x078b, 0x0373,      0, 0x0385, 
	     0, 0x0790, 0x0374,      0, 0x078f, 0x0373,      0, 0x039f, 
	     0, 0x02aa,      0, 0x02e3,      0, 0x078a, 0x0758,      0, 
	0x0789, 0x0757,      0, 0x02ee,      0, 0x078e, 0x0374,      0, 
	0x078d, 0x0373,      0, 0x0386,      0, 0x0792, 0x0374,      0, 
	0x0791, 0x0373,      0, 0x03a0,      0, 0x000a, 0x000c, 0x0014, 
	0x0016, 0x001e, 0x0020, 0x0022, 0x002a, 0x002c, 0x0034, 0x02a9, 
	     0, 0x0794, 0x0345,      0, 0x0793, 0x0344,      0, 0x02e2, 
	     0, 0x02ed,      0, 0x0798, 0x0386,      0, 0x0797, 0x0385, 
	     0, 0x0385,      0, 0x039f,      0, 0x02aa,      0, 0x0796, 
	0x0345,      0, 0x0795, 0x0344,      0, 0x02e3,      0, 0x02ee, 
	     0, 0x079a, 0x0386,      0, 0x0799, 0x0385,      0, 0x0386, 
	     0, 0x03a0,      0, 0x0002, 0x000a, 0x0127, 0x0116,      0, 
	0x0126, 0x0115,      0, 0x00a1,      0, 0x0128, 0x0116,      0, 
	0x00a2,      0, 0x0005, 0x008b, 0x0111, 0x0197, 0x021d, 0x0183, 
	0x0182,      0, 0x017d, 0x017c,      0, 0x0177, 0x0176,      0, 
	0x0171, 0x0170,      0, 0x016b, 0x016a,      0, 0x0165, 0x0164, 
	     0, 0x015f, 0x015e,      0, 0x0159, 0x0158,      0, 0x0152, 
	0x0151,      0, 0x014b, 0x014a,      0, 0x0145, 0x0144,      0, 
	0x013f, 0x013e,      0, 0x0139, 0x0138,      0, 0x0133, 0x0132, 
	     0, 0x012d, 0x012c,      0, 0x0127, 0x0126,      0, 0x0121, 
	0x0120,      0, 0x011b, 0x011a,      0, 0x0115, 0x0114,      0, 
	0x010f, 0x010e,      0, 0x0109, 0x0108,      0, 0x0103, 0x0102, 
	     0, 0x00fd, 0x00fc,      0, 0x00f7, 0x00f6,      0, 0x00f1, 
	0x00f0,      0, 0x00eb, 0x00ea,      0, 0x00e5, 0x00e4,      0, 
	0x00df, 0x00de,      0, 0x00d9, 0x00d8,      0, 0x00d3, 0x00d2, 
	     0, 0x00cd, 0x00cc,      0, 0x00c7, 0x00c6,      0, 0x00c1, 
	0x00c0,      0, 0x00bb, 0x00ba,      0, 0x00b5, 0x00b4,      0, 
	0x00af, 0x00ae,      0, 0x00a9, 0x00a8,      0, 0x00a3, 0x00a2, 
	     0, 0x009d, 0x009c,      0, 0x0097, 0x0096,      0, 0x0091, 
	0x0090,      0, 0x008b, 0x008a,      0, 0x0085, 0x0084,      0, 
	0x007f, 0x007e,      0, 0x0194,      0, 0x0184, 0x0182,      0, 
	0x017e, 0x017c,      0, 0x0178, 0x0176,      0, 0x0172, 0x0170, 
	     0, 0x016c, 0x016a,      0, 0x0166, 0x0164,      0, 0x0160, 
	0x015e,      0, 0x015a, 0x0158,      0, 0x0153, 0x0151,      0, 
	0x014c, 0x014a,      0, 0x0146, 0x0144,      0, 0x0140, 0x013e, 
	     0, 0x013a, 0x0138,      0, 0x0134, 0x0132,      0, 0x012e, 
	0x012c,      0, 0x0128, 0x0126,      0, 0x0122, 0x0120,      0, 
	0x011c, 0x011a,      0, 0x0116, 0x0114,      0, 0x0110, 0x010e, 
	     0, 0x010a, 0x0108,      0, 0x0104, 0x0102,      0, 0x00fe, 
	0x00fc,      0, 0x00f8, 0x00f6,      0, 0x00f2, 0x00f0,      0, 
	0x00ec, 0x00ea,      0, 0x00e6, 0x00e4,      0, 0x00e0, 0x00de, 
	     0, 0x00da, 0x00d8,      0, 0x00d4, 0x00d2,      0, 0x00ce, 
	0x00cc,      0, 0x00c8, 0x00c6,      0, 0x00c2, 0x00c0,      0, 
	0x00bc, 0x00ba,      0, 0x00b6, 0x00b4,      0, 0x00b0, 0x00ae, 
	     0, 0x00aa, 0x00a8,      0, 0x00a4, 0x00a2,      0, 0x009e, 
	0x009c,      0, 0x0098, 0x0096,      0, 0x0092, 0x0090,      0, 
	0x008c, 0x008a,      0, 0x0086, 0x0084,      0, 0x0080, 0x007e, 
	     0, 0x0195,      0, 0x0185, 0x0182,      0, 0x017f, 0x017c, 
	     0, 0x0179, 0x0176,      0, 0x0173, 0x0170,      0, 0x016d, 
	0x016a,      0, 0x0167, 0x0164,      0, 0x0161, 0x015e,      0, 
	0x015b, 0x0158,      0, 0x0154, 0x0151,      0, 0x014d, 0x014a, 
	     0, 0x0147, 0x0144,      0, 0x0141, 0x013e,      0, 0x013b, 
	0x0138,      0, 0x0135, 0x0132,      0, 0x012f, 0x012c,      0, 
	0x0129, 0x0126,      0, 0x0123, 0x0120,      0, 0x011d, 0x011a, 
	     0, 0x0117, 0x0114,      0, 0x0111, 0x010e,      0, 0x010b, 
	0x0108,      0, 0x0105, 0x0102,      0, 0x00ff, 0x00fc,      0, 
	0x00f9, 0x00f6,      0, 0x00f3, 0x00f0,      0, 0x00ed, 0x00ea, 
	     0, 0x00e7, 0x00e4,      0, 0x00e1, 0x00de,      0, 0x00db, 
	0x00d8,      0, 0x00d5, 0x00d2,      0, 0x00cf, 0x00cc,      0, 
	0x00c9, 0x00c6,      0, 0x00c3, 0x00c0,      0, 0x00bd, 0x00ba, 
	     0, 0x00b7, 0x00b4,      0, 0x00b1, 0x00ae,      0, 0x00ab, 
	0x00a8,      0, 0x00a5, 0x00a2,      0, 0x009f, 0x009c,      0, 
	0x0099, 0x0096,      0, 0x0093, 0x0090,      0, 0x008d, 0x008a, 
	     0, 0x0087, 0x0084,      0, 0x0081, 0x007e,      0, 0x0196, 
	     0, 0x0186, 0x0182,      0, 0x0180, 0x017c,      0, 0x017a, 
	0x0176,      0, 0x0174, 0x0170,      0, 0x016e, 0x016a,      0, 
	0x0168, 0x0164,      0, 0x0162, 0x015e,      0, 0x015c, 0x0158, 
	     0, 0x0155, 0x0151,      0, 0x014e, 0x014a,      0, 0x0148, 
	0x0144,      0, 0x0142, 0x013e,      0, 0x013c, 0x0138,      0, 
	0x0136, 0x0132,      0, 0x0130, 0x012c,      0, 0x012a, 0x0126, 
	     0, 0x0124, 0x0120,      0, 0x011e, 0x011a,      0, 0x0118, 
	0x0114,      0, 0x0112, 0x010e,      0, 0x010c, 0x0108,      0, 
	0x0106, 0x0102,      0, 0x0100, 0x00fc,      0, 0x00fa, 0x00f6, 
	     0, 0x00f4, 0x00f0,      0, 0x00ee, 0x00ea,      0, 0x00e8, 
	0x00e4,      0, 0x00e2, 0x00de,      0, 0x00dc, 0x00d8,      0, 
	0x00d6, 0x00d2,      0, 0x00d0, 0x00cc,      0, 0x00ca, 0x00c6, 
	     0, 0x00c4, 0x00c0,      0, 0x00be, 0x00ba,      0, 0x00b8, 
	0x00b4,      0, 0x00b2, 0x00ae,      0, 0x00ac, 0x00a8,      0, 
	0x00a6, 0x00a2,      0, 0x00a0, 0x009c,      0, 0x009a, 0x0096, 
	     0, 0x0094, 0x0090,      0, 0x008e, 0x008a,      0, 0x0088, 
	0x0084,      0, 0x0082, 0x007e,      0, 0x0197,      0, 0x0187, 
	0x0182,      0, 0x0181, 0x017c,      0, 0x017b, 0x0176,      0, 
	0x0175, 0x0170,      0, 0x016f, 0x016a,      0, 0x0169, 0x0164, 
	     0, 0x0163, 0x015e,      0, 0x015d, 0x0158,      0, 0x0156, 
	0x0151,      0, 0x014f, 0x014a,      0, 0x0149, 0x0144,      0, 
	0x0143, 0x013e,      0, 0x013d, 0x0138,      0, 0x0137, 0x0132, 
	     0, 0x0131, 0x012c,      0, 0x012b, 0x0126,      0, 0x0125, 
	0x0120,      0, 0x011f, 0x011a,      0, 0x0119, 0x0114,      0, 
	0x0113, 0x010e,      0, 0x010d, 0x0108,      0, 0x0107, 0x0102, 
	     0, 0x0101, 0x00fc,      0, 0x00fb, 0x00f6,      0, 0x00f5, 
	0x00f0,      0, 0x00ef, 0x00ea,      0, 0x00e9, 0x00e4,      0, 
	0x00e3, 0x00de,      0, 0x00dd, 0x00d8,      0, 0x00d7, 0x00d2, 
	     0, 0x00d1, 0x00cc,      0, 0x00cb, 0x00c6,      0, 0x00c5, 
	0x00c0,      0, 0x00bf, 0x00ba,      0, 0x00b9, 0x00b4,      0, 
	0x00b3, 0x00ae,      0, 0x00ad, 0x00a8,      0, 0x00a7, 0x00a2, 
	     0, 0x00a1, 0x009c,      0, 0x009b, 0x0096,      0, 0x0095, 
	0x0090,      0, 0x008f, 0x008a,      0, 0x0089, 0x0084,      0, 
	0x0083, 0x007e,      0, 0x0198,      0, 0x0001, 0x0483, 0x5853, 
	0x0001,      0, 0x0002, 0x0107, 0x0486,      0, 0x0487,      0, 
	0x0002, 0x0110, 0x0488,      0, 0x0489,      0, 0x0002, 0x055f, 
	0x048b, 0x02ec, 0x048c, 0x02ed, 0x0002, 0x0565, 0x048d, 0x02ee, 
	0x048e, 0x02ef, 0x0002, 0x0570, 0x048f, 0x02f0, 0x0490, 0x02f1, 
	0x0002, 0x0579, 0x0491, 0x02f2, 0x0492, 0x02f3, 0x0001, 0x0484, 
	0x00f4,      0, 0x0485, 0x00fd,      0, 0x048a, 0x055a, 0x02f4, 
	0x0483, 0x5853, 0x0001,      0, 0x0001, 0x0493, 0x008e,      0, 
	0x0494, 0x00a3,      0, 0x0495, 0x02bb, 0x02f5, 0x0496, 0x038b, 
	0x02f6, 0x0497, 0x02fa, 0x02f7, 0x0498, 0x03c8, 0x02f8, 0x0483, 
	0x5853, 0x0001,      0, 0x0001, 0x0499, 0x0132,      0, 0x049a, 
	0x05e8, 0x02f9, 0x049b, 0x0628, 0x02fa, 0x0483, 0x5853, 0x0001, 
	     0, 0x0005, 0x0091, 0x0384,      0, 0x049f,      0, 0x0385, 
	     0, 0x0386,      0, 0x0387,      0, 0x0002, 0x027c, 0x04ac, 
	0x02fb, 0x03ce, 0x02fc, 0x0002, 0x034d, 0x04ad, 0x02fd, 0x03f6, 
	0x02fe, 0x0002, 0x02c8, 0x03e0, 0x02ff, 0x03de, 0x0300, 0x0002, 
	0x0398, 0x0406, 0x0301, 0x0408, 0x0302, 0x0002, 0x02ed, 0x03e3, 
	0x0303, 0x03e2, 0x0304, 0x0002, 0x03bc, 0x040b, 0x0305, 0x040a, 
	0x0306, 0x0002, 0x02fa, 0x04ae, 0x0307, 0x03e4, 0x0307, 0x0002, 
	0x03c8, 0x04af, 0x0308, 0x040c, 0x0308, 0x0001, 0x049c, 0x0079, 
	     0, 0x049d, 0x007f,      0, 0x049e, 0x008e,      0, 0x04a0, 
	0x00a1,      0, 0x04a1, 0x00a3,      0, 0x04a2, 0x00ad,      0, 
	0x04a3, 0x00b2,      0, 0x04a4, 0x012f,      0, 0x04a5, 0x0135, 
	     0, 0x04a6, 0x0142,      0, 0x04a7, 0x0147,      0, 0x04a8, 
	0x014a,      0, 0x04a9, 0x0154,      0, 0x04aa, 0x0157,      0, 
	0x04ab, 0x015a,      0, 0x03d2, 0x0290, 0x0309, 0x03fa, 0x0360, 
	0x030a, 0x03d9, 0x02bb, 0x030b, 0x0401, 0x038b, 0x030c, 0x03e9, 
	0x0313, 0x030d, 0x0411, 0x03e0, 0x030e, 0x03ec, 0x0329, 0x030f, 
	0x0413, 0x03f5, 0x0310, 0x04b0, 0x05e2, 0x0311, 0x04b1, 0x0622, 
	0x0312, 0x04b2, 0x05ea, 0x0313, 0x04b3, 0x062b, 0x0314, 0x04b4, 
	0x05fc, 0x0315, 0x04b5, 0x063d, 0x0316, 0x04b6, 0x0602, 0x0317, 
	0x04b7, 0x0643, 0x0318, 0x04b8, 0x0605, 0x0319, 0x04b9, 0x0646, 
	0x031a, 0x04ba, 0x060d, 0x031b, 0x04bb, 0x064e, 0x031c, 0x04bc, 
	0x0611, 0x031d, 0x04bd, 0x0652, 0x031e, 0x04be, 0x0614, 0x031f, 
	0x04bf, 0x0655, 0x0320, 0x0483, 0x5853, 0x0001,      0, 0x0002, 
	0x02ed, 0x04c3, 0x0321, 0x04c4, 0x0322, 0x0002, 0x03bc, 0x04c5, 
	0x0323, 0x04c6, 0x0324, 0x0001, 0x04c0, 0x0003,      0, 0x04c1, 
	0x0010,      0, 0x04c2, 0x00a1,      0, 0x0483, 0x5853, 0x0001, 
	     0, 0x000c, 0x5853, 0x04c7, 0x0325, 0x04c8, 0x0325, 0x04c9, 
	0x0325, 0x04ca, 0x0325, 0x04cb, 0x0325, 0x04cc, 0x0325, 0x04cd, 
	0x0325, 0x04ce, 0x0325, 0x04cf, 0x0325, 0x04d0, 0x0325, 0x04d1, 
	0x0325, 0x04d2, 0x0325, 0x0001, 0x0483, 0x585f, 0x0001,      0, 
	0x0001, 0x04a4, 0x012f,      0, 0x04d3, 0x013c,      0, 0x04d4, 
	0x0142,      0, 0x04d5, 0x0152,      0, 0x04d6, 0x0157,      0, 
	0x04d7, 0x015a,      0, 0x04b0, 0x05e2, 0x0311, 0x04b1, 0x0622, 
	0x0312, 0x04d8, 0x05f4, 0x0326, 0x04d9, 0x0634, 0x0327, 0x04da, 
	0x05fc, 0x0328, 0x04db, 0x063d, 0x0329, 0x04dc, 0x060d, 0x032a, 
	0x04dd, 0x064e, 0x032b, 0x04de, 0x0611, 0x032c, 0x04df, 0x0652, 
	0x032d, 0x04e0, 0x0614, 0x032e, 0x04e1, 0x0655, 0x032f, 0x0483, 
	0x5853, 0x0001,      0, 0x0004, 0x00bd, 0x04e2,      0, 0x04e3, 
	     0, 0x04e4,      0, 0x04e5,      0, 0x0003, 0x0285, 0x03ce, 
	0x0330, 0x03cf, 0x0331, 0x03d1, 0x0332, 0x0002, 0x0301, 0x03e4, 
	0x0333, 0x03e5, 0x0334, 0x0003, 0x0355, 0x03f6, 0x0335, 0x03f7, 
	0x0336, 0x03f9, 0x0337, 0x0002, 0x03ce, 0x040c, 0x0338, 0x040d, 
	0x0339, 0x0001, 0x037f, 0x0035,      0, 0x0416, 0x0402, 0x033a, 
	0x03ef, 0x0336, 0x033b, 0x03ec, 0x032d, 0x033c, 0x0413, 0x03f9, 
	0x033d, 0x0483, 0x5853, 0x0001,      0, 0x0005, 0x007f, 0x04e6, 
	     0, 0x04e7,      0, 0x0382,      0, 0x04e8,      0, 0x04e9, 
	     0, 0x0002, 0x0290, 0x03d3, 0x033e, 0x03d5, 0x033f, 0x0002, 
	0x0360, 0x03fb, 0x0340, 0x03fd, 0x0341, 0x0003, 0x029e, 0x04ee, 
	0x0342, 0x04ef, 0x0343, 0x03d8, 0x0344, 0x0003, 0x036e, 0x04f0, 
	0x0345, 0x04f1, 0x0346, 0x0400, 0x0347, 0x0002, 0x02e0, 0x04f2, 
	0x0348, 0x04f3, 0x0349, 0x0002, 0x03af, 0x04f4, 0x034a, 0x04f5, 
	0x034b, 0x0002, 0x02ed, 0x04f6, 0x034c, 0x04f7, 0x034d, 0x0002, 
	0x03bc, 0x04f8, 0x034e, 0x04f9, 0x034f, 0x0001, 0x04c0, 0x0003, 
	     0, 0x04c1, 0x0010,      0, 0x04ea, 0x009e,      0, 0x04eb, 
	0x00a1,      0, 0x04ec, 0x00ad,      0, 0x04ed, 0x00bd,      0, 
	0x03e8, 0x0313, 0x0350, 0x0410, 0x03e0, 0x0351, 0x03f0, 0x0342, 
	0x0352, 0x0417, 0x040e, 0x0353, 0x0483, 0x5853, 0x0001,      0, 
	0x0004, 0x0079, 0x04fa,      0, 0x04fb,      0, 0x04fc,      0, 
	0x04fd,      0, 0x0004, 0x007f, 0x04e7,      0, 0x04fe,      0, 
	0x04ff,      0, 0x0500,      0, 0x0002, 0x0085, 0x0501,      0, 
	0x0502,      0, 0x0002, 0x008e, 0x0504,      0, 0x0505,      0, 
	0x0002, 0x00ad, 0x0507,      0, 0x04ec,      0, 0x0005, 0x00c2, 
	0x0508,      0, 0x04e5,      0, 0x04e2,      0, 0x0509,      0, 
	0x04e4,      0, 0x0004, 0x027c, 0x03cb, 0x0354, 0x03ca, 0x0355, 
	0x03cc, 0x0356, 0x03cd, 0x0357, 0x0004, 0x034d, 0x03f3, 0x0358, 
	0x03f2, 0x0359, 0x03f4, 0x035a, 0x03f5, 0x035b, 0x0002, 0x0290, 
	0x03d2, 0x035c, 0x03d5, 0x035d, 0x0002, 0x0360, 0x03fa, 0x035e, 
	0x03fd, 0x035f, 0x0002, 0x029b, 0x050a, 0x0360, 0x050b, 0x0361, 
	0x0002, 0x036b, 0x050c, 0x0360, 0x050d, 0x0362, 0x0002, 0x029e, 
	0x03d7, 0x0363, 0x03d8, 0x0364, 0x0002, 0x036e, 0x03ff, 0x0365, 
	0x0400, 0x0366, 0x0002, 0x02c5, 0x050f, 0x0367, 0x0510, 0x0368, 
	0x0002, 0x0395, 0x0511, 0x0367, 0x0512, 0x0368, 0x0003, 0x03e0, 
	0x03ea, 0x0369, 0x03e8, 0x036a, 0x0410, 0x036b, 0x0003, 0x0285, 
	0x03ce, 0x036c, 0x03cf, 0x0331, 0x03d1, 0x036d, 0x0002, 0x0301, 
	0x03e4, 0x0333, 0x03e5, 0x0334, 0x0003, 0x0355, 0x03f6, 0x036e, 
	0x03f7, 0x0336, 0x03f9, 0x036f, 0x0002, 0x03ce, 0x040c, 0x0338, 
	0x040d, 0x0339, 0x0001, 0x0379, 0x0010,      0, 0x0503, 0x008a, 
	     0, 0x0506, 0x009c,      0, 0x050e, 0x02b8, 0x0370, 0x0513, 
	0x02de, 0x0371, 0x0514, 0x03ad, 0x0372, 0x03ec, 0x032d, 0x033c, 
	0x0413, 0x03f9, 0x033d, 0x0483, 0x5853, 0x0001,      0, 0x0002, 
	0x002e, 0x0381,      0, 0x0380,      0, 0x0002, 0x0079, 0x0515, 
	     0, 0x0516,      0, 0x0002, 0x027c, 0x03cc, 0x0373, 0x03d0, 
	0x0374, 0x0002, 0x034d, 0x03f4, 0x0375, 0x03f8, 0x0376, 0x0002, 
	0x0313, 0x0519, 0x030d, 0x03e9, 0x030d, 0x0002, 0x03e0, 0x051a, 
	0x030d, 0x0411, 0x030e, 0x0002, 0x031f, 0x051b, 0x0377, 0x03eb, 
	0x0377, 0x0002, 0x03eb, 0x051c, 0x0377, 0x0412, 0x0378, 0x0001, 
	0x0517, 0x0098,      0, 0x04a2, 0x00ad,      0, 0x0518, 0x00b0, 
	     0, 0x03df, 0x02cd, 0x0379, 0x0407, 0x039d, 0x037a, 0x0483, 
	0x5853, 0x0001,      0, 0x0002, 0x02bb, 0x0523, 0x037b, 0x0524, 
	0x037c, 0x0002, 0x038b, 0x0525, 0x037d, 0x0526, 0x037e, 0x0002, 
	0x02cd, 0x0527, 0x037f, 0x0528, 0x0380, 0x0002, 0x039d, 0x0529, 
	0x0381, 0x052a, 0x0382, 0x0001, 0x04c0, 0x0003,      0, 0x04c1, 
	0x0010,      0, 0x051d, 0x007f,      0, 0x051e, 0x008a,      0, 
	0x051f, 0x008e,      0, 0x0520, 0x0091,      0, 0x0521, 0x0098, 
	     0, 0x0522, 0x00bb,      0, 0x03d6, 0x0290, 0x0383, 0x03fe, 
	0x0360, 0x0384, 0x03db, 0x02b8, 0x0385, 0x0403, 0x0388, 0x0386, 
	0x03dd, 0x02c8, 0x0387, 0x0405, 0x0398, 0x0388, 0x03f1, 0x033d, 
	0x0389, 0x0418, 0x0409, 0x038a, 0x0483, 0x5853, 0x0001,      0, 
	0x0002, 0x02ed, 0x04c3, 0x038b, 0x04c4, 0x038c, 0x0002, 0x03bc, 
	0x04c5, 0x038d, 0x04c6, 0x038e, 0x0002, 0x0338, 0x052d, 0x038f, 
	0x052e, 0x0390, 0x0002, 0x0404, 0x052f, 0x0391, 0x0530, 0x0392, 
	0x0001, 0x04c0, 0x0003,      0, 0x04c1, 0x0010,      0, 0x052b, 
	0x00a1,      0, 0x052c, 0x00b8,      0, 0x0483, 0x5853, 0x0001, 
	     0, 0x004c, 0x0660, 0x0531, 0x0393, 0x0532, 0x0393, 0x0533, 
	0x0393, 0x0534, 0x0393, 0x0535, 0x0393, 0x0536, 0x0393, 0x0537, 
	0x0393, 0x0538, 0x0393, 0x0539, 0x0393, 0x053a, 0x0393, 0x053b, 
	0x0393, 0x053c, 0x0393, 0x053d, 0x0393, 0x053e, 0x0393, 0x053f, 
	0x0393, 0x0540, 0x0393, 0x0541, 0x0393, 0x0542, 0x0393, 0x0543, 
	0x0393, 0x0544, 0x0393, 0x0545, 0x0393, 0x0546, 0x0393, 0x0547, 
	0x0393, 0x0548, 0x0393, 0x0549, 0x0393, 0x054a, 0x0393, 0x054b, 
	0x0393, 0x054c, 0x0393, 0x054d, 0x0393, 0x054e, 0x0393, 0x054f, 
	0x0393, 0x0550, 0x0393, 0x0551, 0x0393, 0x0552, 0x0393, 0x0553, 
	0x0393, 0x0554, 0x0393, 0x0555, 0x0393, 0x0556, 0x0393, 0x0557, 
	0x0394, 0x0558, 0x0394, 0x0559, 0x0394, 0x055a, 0x0394, 0x055b, 
	0x0394, 0x055c, 0x0394, 0x055d, 0x0394, 0x055e, 0x0394, 0x055f, 
	0x0394, 0x0560, 0x0394, 0x0561, 0x0394, 0x0562, 0x0394, 0x0563, 
	0x0394, 0x0564, 0x0394, 0x0565, 0x0394, 0x0566, 0x0394, 0x0567, 
	0x0394, 0x0568, 0x0394, 0x0569, 0x0394, 0x056a, 0x0394, 0x056b, 
	0x0394, 0x056c, 0x0394, 0x056d, 0x0394, 0x056e, 0x0394, 0x056f, 
	0x0394, 0x0570, 0x0394, 0x0571, 0x0394, 0x0572, 0x0394, 0x0573, 
	0x0394, 0x0574, 0x0394, 0x0575, 0x0394, 0x0576, 0x0394, 0x0577, 
	0x0394, 0x0578, 0x0394, 0x0579, 0x0394, 0x057a, 0x0394, 0x057b, 
	0x0394, 0x057c, 0x0394, 0x0001, 0x0483, 0x5853, 0x0001,      0, 
	0x0005, 0x0003, 0x04c0,      0, 0x057d,      0, 0x057e,      0, 
	0x057f,      0, 0x0580,      0, 0x0005, 0x0010, 0x04c1,      0, 
	0x0581,      0, 0x0582,      0, 0x0583,      0, 0x0584,      0, 
	0x0002, 0x0085, 0x0586,      0, 0x0587,      0, 0x0004, 0x00a3, 
	0x03e4, 0x0395, 0x03e6, 0x0396, 0x040c, 0x0397, 0x040e, 0x0398, 
	0x0004, 0x00b2, 0x03ec, 0x0399, 0x03ee, 0x039a, 0x0413, 0x039b, 
	0x0415, 0x039c, 0x0006, 0x0360, 0x0590, 0x039d, 0x0591, 0x039e, 
	0x0592, 0x039f, 0x0593, 0x03a0, 0x0594, 0x03a1, 0x0595, 0x03a2, 
	0x0006, 0x0290, 0x0596, 0x03a3, 0x0597, 0x03a4, 0x0598, 0x03a5, 
	0x0599, 0x03a6, 0x059a, 0x03a7, 0x059b, 0x03a8, 0x0006, 0x036e, 
	0x059c, 0x03a9, 0x059d, 0x03aa, 0x059e, 0x03ab, 0x059f, 0x03ac, 
	0x05a0, 0x03ad, 0x05a1, 0x03ae, 0x0006, 0x029e, 0x05a2, 0x03af, 
	0x05a3, 0x03b0, 0x05a4, 0x03b1, 0x05a5, 0x03b2, 0x05a6, 0x03b3, 
	0x05a7, 0x03b4, 0x000c, 0x036e, 0x05a8, 0x03b5, 0x05a9, 0x03b6, 
	0x05aa, 0x03b7, 0x05ab, 0x03b8, 0x05ac, 0x03b9, 0x05ad, 0x03ba, 
	0x05ae, 0x03bb, 0x05af, 0x03bc, 0x05b0, 0x03b9, 0x05b1, 0x03ba, 
	0x05b2, 0x03bb, 0x05b3, 0x03bc, 0x000c, 0x029e, 0x05b4, 0x03bd, 
	0x05b5, 0x03be, 0x05b6, 0x03bf, 0x05b7, 0x03c0, 0x05b8, 0x03c1, 
	0x05b9, 0x03c2, 0x05ba, 0x03c3, 0x05bb, 0x03c4, 0x05bc, 0x03c1, 
	0x05bd, 0x03c2, 0x05be, 0x03c3, 0x05bf, 0x03c4, 0x0006, 0x038b, 
	0x05c0, 0x03c5, 0x05c1, 0x03c6, 0x05c2, 0x03c7, 0x05c3, 0x03c8, 
	0x05c4, 0x03c9, 0x05c5, 0x03ca, 0x0006, 0x02bb, 0x05c6, 0x03cb, 
	0x05c7, 0x03cc, 0x05c8, 0x03cd, 0x05c9, 0x03ce, 0x05ca, 0x03cf, 
	0x05cb, 0x03d0, 0x0006, 0x03af, 0x05cc, 0x03d1, 0x05cd, 0x03d2, 
	0x05ce, 0x03d3, 0x05cf, 0x03d4, 0x05d0, 0x03d5, 0x05d1, 0x03d6, 
	0x0006, 0x02e0, 0x05d2, 0x03d7, 0x05d3, 0x03d8, 0x05d4, 0x03d9, 
	0x05d5, 0x03da, 0x05d6, 0x03db, 0x05d7, 0x03dc, 0x0006, 0x03bc, 
	0x05d8, 0x03dd, 0x05d9, 0x03de, 0x05da, 0x03df, 0x05db, 0x03e0, 
	0x05dc, 0x03e1, 0x05dd, 0x03e2, 0x0006, 0x02ed, 0x05de, 0x03e3, 
	0x05df, 0x03e4, 0x05e0, 0x03e5, 0x05e1, 0x03e6, 0x05e2, 0x03e7, 
	0x05e3, 0x03e8, 0x0006, 0x03e0, 0x05e4, 0x03e9, 0x05e5, 0x03ea, 
	0x05e6, 0x03eb, 0x05e7, 0x03ec, 0x05e8, 0x03ed, 0x05e9, 0x03ee, 
	0x0006, 0x0313, 0x05ea, 0x03ef, 0x05eb, 0x03f0, 0x05ec, 0x03f1, 
	0x05ed, 0x03f2, 0x05ee, 0x03f3, 0x05ef, 0x03f4, 0x0006, 0x03eb, 
	0x05f0, 0x03f5, 0x05f1, 0x03f6, 0x05f2, 0x03f7, 0x05f3, 0x03f8, 
	0x05f4, 0x03f9, 0x05f5, 0x03fa, 0x0006, 0x031f, 0x05f6, 0x03fb, 
	0x05f7, 0x03fc, 0x05f8, 0x03fd, 0x05f9, 0x03fe, 0x05fa, 0x03ff, 
	0x05fb, 0x0400, 0x0006, 0x040e, 0x05fc, 0x0401, 0x05fd, 0x0402, 
	0x05fe, 0x0403, 0x05ff, 0x0404, 0x0600, 0x0405, 0x0601, 0x0406, 
	0x0006, 0x0342, 0x0602, 0x0407, 0x0603, 0x0408, 0x0604, 0x0409, 
	0x0605, 0x040a, 0x0606, 0x040b, 0x0607, 0x040c, 0x0001, 0x0585, 
	0x007f,      0, 0x0588, 0x008e,      0, 0x0589, 0x009e,      0, 
	0x058a, 0x00a1,      0, 0x058b, 0x00a3,      0, 0x058c, 0x00ad, 
	     0, 0x058d, 0x00b0,      0, 0x058e, 0x00b2,      0, 0x058f, 
	0x00bd,      0, 0x0483, 0x5853, 0x0001,      0, 0x0009, 0x001f, 
	0x037a,      0, 0x037c,      0, 0x0608,      0, 0x037b,      0, 
	0x0609,      0, 0x060a,      0, 0x060b,      0, 0x037d,      0, 
	0x037e,      0, 0x0002, 0x002a, 0x060c,      0, 0x060d,      0, 
	0x0003, 0x00c2, 0x060e,      0, 0x038a,      0, 0x0389,      0, 
	0x0002, 0x00ee, 0x038b,      0, 0x060f,      0, 0x0010, 0x01e2, 
	0x03c1, 0x040d, 0x03c2, 0x040d, 0x03c3, 0x040d, 0x03c7, 0x040d, 
	0x03c8, 0x040d, 0x03c9, 0x040d, 0x03c4, 0x040d, 0x03c5, 0x040d, 
	0x03c6, 0x040d, 0x03ba, 0x040d, 0x03bb, 0x040d, 0x03bc, 0x040d, 
	0x03bf, 0x040d, 0x03c0, 0x040d, 0x03bd, 0x040d, 0x03be, 0x040d, 
	0x0004, 0x0208, 0x0610, 0x040d, 0x0611, 0x040d, 0x0612, 0x040d, 
	0x0613, 0x040d, 0x0023, 0x0419, 0x041a, 0x0281, 0x0419, 0x0282, 
	0x041c, 0x0283, 0x041b, 0x0284, 0x041e, 0x0285, 0x041d, 0x0286, 
	0x0420, 0x0287, 0x041f, 0x0288, 0x0422, 0x0289, 0x0421, 0x028a, 
	0x0424, 0x028b, 0x0423, 0x028c, 0x0426, 0x028d, 0x0425, 0x028e, 
	0x0428, 0x028f, 0x0427, 0x0290, 0x042a, 0x0291, 0x0429, 0x0292, 
	0x042c, 0x0293, 0x042b, 0x0294, 0x042e, 0x040e, 0x0614, 0x040e, 
	0x0431, 0x0299, 0x0615, 0x040f, 0x042d, 0x0295, 0x042f, 0x0410, 
	0x0616, 0x0410, 0x0430, 0x0411, 0x0617, 0x0411, 0x0437, 0x0412, 
	0x0618, 0x0412, 0x0439, 0x0413, 0x0619, 0x0414, 0x061a, 0x0415, 
	0x061b, 0x0413, 0x0002, 0x046f, 0x0434, 0x029b, 0x0433, 0x0416, 
	0x0006, 0x047c, 0x0435, 0x029d, 0x0432, 0x0417, 0x0436, 0x0418, 
	0x061c, 0x0419, 0x0438, 0x041a, 0x043a, 0x041b, 0x000f, 0x0488, 
	0x043c, 0x041c, 0x043d, 0x041d, 0x0442, 0x041e, 0x0443, 0x041f, 
	0x061d, 0x0420, 0x061e, 0x0421, 0x043b, 0x0422, 0x043e, 0x0423, 
	0x043f, 0x0424, 0x0440, 0x0425, 0x0441, 0x0426, 0x0454, 0x0427, 
	0x0455, 0x0428, 0x061f, 0x0429, 0x0620, 0x042a, 0x0008, 0x04fc, 
	0x044a, 0x042b, 0x044b, 0x042c, 0x044c, 0x042d, 0x044d, 0x042e, 
	0x0446, 0x042f, 0x0447, 0x0430, 0x0448, 0x0431, 0x0449, 0x0432, 
	0x001a, 0x0528, 0x044e, 0x0433, 0x044f, 0x0434, 0x0450, 0x0435, 
	0x0451, 0x0436, 0x0444, 0x0437, 0x0445, 0x0438, 0x0452, 0x0439, 
	0x0453, 0x043a, 0x0622, 0x043b, 0x0623, 0x043c, 0x0624, 0x043d, 
	0x0625, 0x043e, 0x0456, 0x043f, 0x0457, 0x0440, 0x0458, 0x0441, 
	0x0459, 0x0442, 0x045a, 0x0443, 0x045b, 0x0444, 0x045c, 0x0445, 
	0x045d, 0x0446, 0x045e, 0x0447, 0x045f, 0x0448, 0x0460, 0x0449, 
	0x0461, 0x044a, 0x0462, 0x044b, 0x0463, 0x044c, 0x0001, 0x0621, 
	0x04cd, 0x044d, 0x0483, 0x5853, 0x0001,      0, 0x0001, 0x0626, 
	0x007f,      0, 0x0627, 0x008e,      0, 0x0628, 0x0091,      0, 
	0x0629, 0x009a,      0, 0x062a, 0x00ad,      0, 0x062b, 0x00b2, 
	     0, 0x03fc, 0x0360, 0x044e, 0x03d4, 0x0290, 0x044f, 0x0402, 
	0x038b, 0x0450, 0x03da, 0x02bb, 0x0451, 0x0404, 0x0398, 0x0452, 
	0x03dc, 0x02c8, 0x0453, 0x0409, 0x03a9, 0x0454, 0x03e1, 0x02d9, 
	0x0455, 0x040f, 0x03e0, 0x0456, 0x03e7, 0x0313, 0x0457, 0x0414, 
	0x03f5, 0x0458, 0x03ed, 0x0329, 0x0459, 0x0483, 0x5853, 0x0001, 
	     0, 0x0003, 0x007f, 0x062c,      0, 0x0382,      0, 0x062d, 
	     0, 0x0003, 0x008a, 0x062e,      0, 0x0383,      0, 0x062f, 
	     0, 0x0002, 0x0290, 0x0634, 0x045a, 0x0635, 0x045b, 0x0002, 
	0x0360, 0x0636, 0x045c, 0x0637, 0x045d, 0x0002, 0x029e, 0x0638, 
	0x045e, 0x0639, 0x045f, 0x0002, 0x036e, 0x063a, 0x0460, 0x063b, 
	0x0461, 0x0002, 0x02b8, 0x063c, 0x0462, 0x063d, 0x0463, 0x0002, 
	0x0388, 0x063e, 0x0464, 0x063f, 0x0465, 0x0002, 0x02bb, 0x04c3, 
	0x0466, 0x04c4, 0x0467, 0x0002, 0x038b, 0x04c5, 0x0468, 0x04c6, 
	0x0469, 0x0002, 0x02e0, 0x0640, 0x046a, 0x0641, 0x046b, 0x0002, 
	0x03af, 0x0642, 0x046c, 0x0643, 0x046d, 0x0002, 0x0309, 0x0644, 
	0x046e, 0x0645, 0x046f, 0x0002, 0x03d6, 0x0646, 0x0470, 0x0647, 
	0x0471, 0x0002, 0x030d, 0x0648, 0x0472, 0x0649, 0x0473, 0x0002, 
	0x03da, 0x064a, 0x0474, 0x064b, 0x0475, 0x0002, 0x031f, 0x064c, 
	0x0476, 0x064d, 0x0477, 0x0002, 0x03eb, 0x064e, 0x0478, 0x064f, 
	0x0479, 0x0001, 0x04c0, 0x0003,      0, 0x04c1, 0x0010,      0, 
	0x0630, 0x009e,      0, 0x0631, 0x00a8,      0, 0x0632, 0x00ab, 
	     0, 0x0633, 0x00b0,      0, 0x0483, 0x5853, 0x0001,      0, 
	0x0005, 0x007f, 0x04e6,      0, 0x04e7,      0, 0x0382,      0, 
	0x04e8,      0, 0x04e9,      0, 0x0002, 0x0290, 0x03d3, 0x033e, 
	0x03d5, 0x033f, 0x0002, 0x0360, 0x03fb, 0x0340, 0x03fd, 0x0341, 
	0x0003, 0x029e, 0x04ee, 0x0342, 0x04ef, 0x0343, 0x03d8, 0x0344, 
	0x0005, 0x036e, 0x04f0, 0x0345, 0x04f1, 0x0346, 0x0400, 0x0347, 
	0x04f2, 0x0348, 0x04f3, 0x0349, 0x0002, 0x03af, 0x04f4, 0x034a, 
	0x04f5, 0x034b, 0x0002, 0x02ed, 0x04f6, 0x034c, 0x04f7, 0x034d, 
	0x0002, 0x03bc, 0x04f8, 0x034e, 0x04f9, 0x034f, 0x0001, 0x04c0, 
	0x0003,      0, 0x04c1, 0x0010,      0, 0x04ea, 0x009e,      0, 
	0x04eb, 0x00a1,      0, 0x04ec, 0x00ad,      0, 0x04ed, 0x00bd, 
	     0, 0x03e8, 0x0313, 0x0350, 0x0410, 0x03e0, 0x0351, 0x03f0, 
	0x0342, 0x0352, 0x0417, 0x040e, 0x0353, 0x0483, 0x5853, 0x0001, 
	     0, 0x0002, 0x007f, 0x0650,      0, 0x0651,      0, 0x0004, 
	0x0290, 0x0634, 0x047a, 0x0635, 0x047b, 0x0652, 0x047c, 0x0653, 
	0x047d, 0x0004, 0x0360, 0x0636, 0x047e, 0x0637, 0x047f, 0x0654, 
	0x0480, 0x0655, 0x0481, 0x0001, 0x04c0, 0x0003,      0, 0x04c1, 
	0x0010,      0, 0x0483, 0x5853, 0x0001,      0, 0x002e, 0x004a, 
	0x038c,      0, 0x038d,      0, 0x038e,      0, 0x038f,      0, 
	0x0390,      0, 0x0391,      0, 0x0392,      0, 0x0393,      0, 
	0x0394,      0, 0x0395,      0, 0x0396,      0, 0x0397,      0, 
	0x0398,      0, 0x0399,      0, 0x039a,      0, 0x039b,      0, 
	0x039c,      0, 0x039d,      0, 0x039e,      0, 0x039f,      0, 
	0x03a0,      0, 0x03a1,      0, 0x03a2,      0, 0x03a3,      0, 
	0x03a4,      0, 0x03a5,      0, 0x03a6,      0, 0x03a7,      0, 
	0x03a8,      0, 0x03a9,      0, 0x03aa,      0, 0x03ab,      0, 
	0x03ac,      0, 0x03ad,      0, 0x03ae,      0, 0x03af,      0, 
	0x03b0,      0, 0x03b1,      0, 0x03b2,      0, 0x03b3,      0, 
	0x03b4,      0, 0x03b5,      0, 0x03b6,      0, 0x03b7,      0, 
	0x03b8,      0, 0x03b9,      0, 0x0003, 0x05e4, 0x0465, 0x0482, 
	0x0470, 0x0483, 0x0468, 0x0484, 0x0003, 0x05ea, 0x0466, 0x0485, 
	0x0467, 0x0486, 0x0472, 0x0487, 0x0003, 0x05f4, 0x0478, 0x0488, 
	0x046a, 0x0489, 0x0471, 0x048a, 0x0003, 0x0624, 0x0474, 0x048b, 
	0x0480, 0x048c, 0x0477, 0x048d, 0x0003, 0x062b, 0x0475, 0x048e, 
	0x0476, 0x048f, 0x0482, 0x0490, 0x0003, 0x0634, 0x0469, 0x0491, 
	0x0479, 0x0492, 0x0481, 0x0493, 0x0001, 0x0464, 0x05e2, 0x0494, 
	0x046d, 0x05fc, 0x0495, 0x046b, 0x05fe, 0x0496, 0x046c, 0x0602, 
	0x0497, 0x046f, 0x060d, 0x0498, 0x046e, 0x0614, 0x0499, 0x0473, 
	0x0622, 0x049a, 0x047a, 0x063a, 0x049b, 0x047d, 0x063d, 0x049c, 
	0x047b, 0x063f, 0x049d, 0x047c, 0x0643, 0x049e, 0x047f, 0x064e, 
	0x049f, 0x047e, 0x0655, 0x04a0, 0x0483, 0x5853, 0x0001,      0, 
	0x0006, 0x0091, 0x0388,      0, 0x0384,      0, 0x049f,      0, 
	0x0385,      0, 0x0386,      0, 0x0387,      0, 0x0002, 0x02c8, 
	0x03e0, 0x02ff, 0x03de, 0x0300, 0x0002, 0x0398, 0x0406, 0x0301, 
	0x0408, 0x0302, 0x0001, 0x049d, 0x007f,      0, 0x049c, 0x0088, 
	     0, 0x049e, 0x008e,      0, 0x0656, 0x00a3,      0, 0x04a2, 
	0x00ad,      0, 0x04a3, 0x00b2,      0, 0x04a4, 0x012f,      0, 
	0x04a5, 0x0135,      0, 0x04a6, 0x0142,      0, 0x04a8, 0x014a, 
	     0, 0x04a9, 0x0154,      0, 0x04aa, 0x0157,      0, 0x04ab, 
	0x015a,      0, 0x03d2, 0x0290, 0x0309, 0x03fa, 0x0360, 0x030a, 
	0x04ac, 0x02ae, 0x02fb, 0x04ad, 0x037e, 0x02fd, 0x03d9, 0x02bb, 
	0x030b, 0x0401, 0x038b, 0x030c, 0x03e4, 0x02fa, 0x04a1, 0x040c, 
	0x03c8, 0x04a2, 0x03e9, 0x0313, 0x030d, 0x0411, 0x03e0, 0x030e, 
	0x03ec, 0x0329, 0x030f, 0x0413, 0x03f5, 0x0310, 0x04b0, 0x05e2, 
	0x0311, 0x04b1, 0x0622, 0x0312, 0x04b2, 0x05ea, 0x0313, 0x04b3, 
	0x062b, 0x0314, 0x04b4, 0x05fc, 0x0315, 0x04b5, 0x063d, 0x0316, 
	0x04b8, 0x0605, 0x0319, 0x04b9, 0x0646, 0x031a, 0x04ba, 0x060d, 
	0x031b, 0x04bb, 0x064e, 0x031c, 0x04bc, 0x0611, 0x031d, 0x04bd, 
	0x0652, 0x031e, 0x04be, 0x0614, 0x031f, 0x04bf, 0x0655, 0x0320, 
	0x0483, 0x5853, 0x0001,      0, 0x0003, 0x0005, 0x069e, 0x04a3, 
	0x069f, 0x04a3, 0x06a0, 0x04a3, 0x0003, 0x01c9, 0x06a9, 0x04a5, 
	0x06aa, 0x04a5, 0x06ab, 0x04a5, 0x0003, 0x01cd, 0x06ac, 0x04a5, 
	0x06ad, 0x04a5, 0x06ae, 0x04a5, 0x0003, 0x01d1, 0x06af, 0x04a5, 
	0x06b0, 0x04a5, 0x06b1, 0x04a5, 0x0003, 0x01d5, 0x06b2, 0x04a5, 
	0x06b3, 0x04a5, 0x06b4, 0x04a5, 0x0002, 0x01eb, 0x06bb, 0x04a5, 
	0x06bc, 0x04a5, 0x0002, 0x01f3, 0x06be, 0x04a5, 0x06bf, 0x04a5, 
	0x001b, 0x02f4, 0x06c3, 0x06b0, 0x06c4, 0x06d1, 0x06c5, 0x06d1, 
	0x06c6, 0x06d1, 0x06c7, 0x06d1, 0x06c8, 0x06d1, 0x06c9, 0x06d1, 
	0x06ca, 0x06d1, 0x06cb, 0x06d1, 0x06cc, 0x06b0, 0x06cd, 0x06b0, 
	0x06ce, 0x06b0, 0x06cf, 0x06b0, 0x06d0, 0x06b0, 0x06d1, 0x06b0, 
	0x06d2, 0x06b0, 0x06d3, 0x06b0, 0x06d4, 0x06b0, 0x06d5, 0x06d2, 
	0x06d6, 0x06d3, 0x06d7, 0x06d4, 0x06d8, 0x06d5, 0x06d9, 0x06d6, 
	0x06da, 0x06d7, 0x06db, 0x06d8, 0x06dc, 0x06d9, 0x06dd, 0x06da, 
	0x0002, 0x0312, 0x06de, 0x0713, 0x06df, 0x0714, 0x0004, 0x0334, 
	0x06e0, 0x0715, 0x06e1, 0x0716, 0x06e2, 0x0717, 0x06e3, 0x0718, 
	0x0002, 0x033a, 0x06e4, 0x0719, 0x06e5, 0x071a, 0x0004, 0x0344, 
	0x06e6, 0x071b, 0x06e7, 0x071c, 0x06e8, 0x071d, 0x06e9, 0x071e, 
	0x0006, 0x034b, 0x06ea, 0x071f, 0x06eb, 0x0720, 0x06ec, 0x0721, 
	0x06ed, 0x0722, 0x06ee, 0x0723, 0x06ef, 0x0724, 0x0002, 0x035e, 
	0x06f0, 0x0725, 0x06f1, 0x0726, 0x0002, 0x0362, 0x06f2, 0x0727, 
	0x06f3, 0x0728, 0x0002, 0x036d, 0x06f4, 0x04a6, 0x06f5, 0x0729, 
	0x0002, 0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 0x038a, 
	0x06f8, 0x072c, 0x06f9, 0x072d, 0x0004, 0x03b0, 0x06fa, 0x072e, 
	0x06fb, 0x072f, 0x06fc, 0x0730, 0x06fd, 0x0731, 0x0002, 0x03d9, 
	0x06fe, 0x0732, 0x06ff, 0x0733, 0x0002, 0x03de, 0x0700, 0x04a6, 
	0x0701, 0x0734, 0x0003, 0x03f1, 0x0702, 0x0735, 0x0703, 0x0736, 
	0x0704, 0x0737, 0x0002, 0x03f5, 0x0705, 0x0738, 0x0706, 0x0739, 
	0x0002, 0x0413, 0x0707, 0x073a, 0x0708, 0x073b, 0x0002, 0x042e, 
	0x0709, 0x073c, 0x070a, 0x073d, 0x0004, 0x0440, 0x070c, 0x073e, 
	0x070d, 0x073f, 0x070e, 0x0740, 0x070f, 0x0741, 0x0002, 0x045a, 
	0x0710, 0x0742, 0x0711, 0x0743, 0x0002, 0x045e, 0x0712, 0x0744, 
	0x0713, 0x0745, 0x0002, 0x0464, 0x0714, 0x0746, 0x0715, 0x0747, 
	0x0002, 0x046c, 0x0716, 0x0748, 0x0717, 0x0749, 0x0002, 0x0475, 
	0x0718, 0x074a, 0x0719, 0x074b, 0x0002, 0x048d, 0x071a, 0x074c, 
	0x071b, 0x074d, 0x0002, 0x0493, 0x071c, 0x074e, 0x071d, 0x074f, 
	0x0004, 0x049b, 0x071e, 0x0750, 0x071f, 0x0751, 0x0720, 0x0752, 
	0x0721, 0x0753, 0x0002, 0x04a3, 0x0722, 0x0754, 0x0723, 0x0755, 
	0x0004, 0x04b6, 0x0724, 0x04a6, 0x0725, 0x0756, 0x0726, 0x0757, 
	0x0727, 0x0758, 0x0002, 0x04d3, 0x0728, 0x0759, 0x0729, 0x075a, 
	0x0002, 0x04df, 0x072a, 0x075b, 0x072b, 0x075c, 0x0002, 0x04e5, 
	0x072c, 0x075d, 0x072d, 0x075e, 0x0002, 0x04f2, 0x072e, 0x04a6, 
	0x072f, 0x075f, 0x0002, 0x0510, 0x0730, 0x0760, 0x0731, 0x0761, 
	0x0002, 0x0514, 0x0732, 0x0762, 0x0733, 0x0763, 0x0002, 0x052e, 
	0x0734, 0x0764, 0x0735, 0x0765, 0x0002, 0x053c, 0x0736, 0x0766, 
	0x0737, 0x0767, 0x0008, 0x0551, 0x0738, 0x04a6, 0x0739, 0x0768, 
	0x073a, 0x04a6, 0x073b, 0x0769, 0x073c, 0x076a, 0x073d, 0x076b, 
	0x073e, 0x076c, 0x073f, 0x076d, 0x000e, 0x055a, 0x0740, 0x04a6, 
	0x0741, 0x076e, 0x0742, 0x076f, 0x0743, 0x0770, 0x0744, 0x0771, 
	0x0745, 0x0772, 0x0746, 0x0773, 0x0747, 0x0774, 0x0748, 0x0775, 
	0x0749, 0x0776, 0x074a, 0x0777, 0x074b, 0x0778, 0x074c, 0x0779, 
	0x074d, 0x077a, 0x0004, 0x0578, 0x074e, 0x04a6, 0x074f, 0x077b, 
	0x0750, 0x077c, 0x0751, 0x077d, 0x0005, 0x058a, 0x0752, 0x04a3, 
	0x0753, 0x04a6, 0x0754, 0x077e, 0x0755, 0x077f, 0x0756, 0x0780, 
	0x0004, 0x0595, 0x0757, 0x0781, 0x0758, 0x0782, 0x0759, 0x0783, 
	0x075a, 0x0784, 0x0001, 0x06a1, 0x0051, 0x04a5, 0x06a2, 0x005c, 
	0x04a5, 0x06a3, 0x0064, 0x04a5, 0x06a4, 0x00cd, 0x04a5, 0x06a5, 
	0x0141, 0x04a5, 0x06a6, 0x0144, 0x04a5, 0x06a7, 0x01bd, 0x04a5, 
	0x06a8, 0x01bf, 0x04a5, 0x06b5, 0x01d9, 0x04a5, 0x06b6, 0x01dc, 
	0x04a5, 0x06b7, 0x01df, 0x04a5, 0x06b8, 0x01e1, 0x04a5, 0x06b9, 
	0x01e4, 0x04a5, 0x06ba, 0x01e7, 0x04a5, 0x06bd, 0x01ef, 0x04a5, 
	0x06c0, 0x01f7, 0x04a5, 0x06c1, 0x01fb, 0x04a5, 0x06c2, 0x01fe, 
	0x04a5, 0x070b, 0x0433, 0x0785,      0, 0x0002, 0x0005, 0x069e, 
	0x04a3, 0x069f, 0x04a3, 0x0003, 0x01c9, 0x06a9, 0x04a5, 0x06aa, 
	0x04a5, 0x06ab, 0x04a5, 0x0003, 0x01cd, 0x06ac, 0x04a5, 0x06ad, 
	0x04a5, 0x06ae, 0x04a5, 0x0003, 0x01d1, 0x06af, 0x04a5, 0x06b0, 
	0x04a5, 0x06b1, 0x04a5, 0x0003, 0x01d5, 0x06b2, 0x04a5, 0x06b3, 
	0x04a5, 0x06b4, 0x04a5, 0x0002, 0x01eb, 0x06bb, 0x04a5, 0x06bc, 
	0x04a5, 0x0002, 0x01f3, 0x06be, 0x04a5, 0x06bf, 0x04a5, 0x0002, 
	0x0312, 0x06de, 0x0713, 0x06df, 0x0714, 0x0004, 0x0344, 0x06e6, 
	0x071b, 0x06e7, 0x071c, 0x06e8, 0x071d, 0x06e9, 0x071e, 0x0002, 
	0x035e, 0x06f0, 0x0725, 0x06f1, 0x0726, 0x0002, 0x0362, 0x06f2, 
	0x0727, 0x06f3, 0x0728, 0x0002, 0x0368, 0x06f4, 0x0786, 0x06f5, 
	0x0787, 0x0002, 0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 
	0x038a, 0x06f8, 0x072c, 0x06f9, 0x072d, 0x0004, 0x03b0, 0x06fa, 
	0x072e, 0x06fb, 0x072f, 0x06fc, 0x0730, 0x06fd, 0x0731, 0x0002, 
	0x03cd, 0x0700, 0x0788, 0x0701, 0x0789, 0x0002, 0x03d9, 0x06fe, 
	0x0732, 0x06ff, 0x0733, 0x0002, 0x03f5, 0x0705, 0x0738, 0x0706, 
	0x0739, 0x0002, 0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 0x0002, 
	0x0413, 0x0707, 0x073a, 0x0708, 0x073b, 0x0002, 0x042e, 0x0709, 
	0x073c, 0x070a, 0x073d, 0x0004, 0x0440, 0x070c, 0x073e, 0x070d, 
	0x073f, 0x070e, 0x0740, 0x070f, 0x0741, 0x0002, 0x045a, 0x0710, 
	0x0742, 0x0711, 0x0743, 0x0002, 0x045e, 0x0712, 0x0744, 0x0713, 
	0x0745, 0x0002, 0x0464, 0x0714, 0x0746, 0x0715, 0x0747, 0x0002, 
	0x046c, 0x0716, 0x0748, 0x0717, 0x0749, 0x0002, 0x0475, 0x0718, 
	0x074a, 0x0719, 0x074b, 0x0002, 0x048d, 0x071a, 0x074c, 0x071b, 
	0x074d, 0x0002, 0x04a3, 0x0722, 0x0754, 0x0723, 0x0755, 0x0002, 
	0x04b6, 0x0726, 0x0757, 0x0727, 0x0758, 0x0002, 0x04d3, 0x0728, 
	0x0759, 0x0729, 0x075a, 0x0002, 0x04df, 0x072a, 0x075b, 0x072b, 
	0x075c, 0x0002, 0x04e5, 0x072c, 0x075d, 0x072d, 0x075e, 0x0002, 
	0x04ef, 0x072e, 0x078c, 0x072f, 0x078d, 0x0002, 0x0510, 0x0730, 
	0x0760, 0x0731, 0x0761, 0x0002, 0x0514, 0x0732, 0x0762, 0x0733, 
	0x0763, 0x0002, 0x052e, 0x0734, 0x0764, 0x0735, 0x0765, 0x0002, 
	0x053c, 0x0736, 0x0766, 0x0737, 0x0767, 0x0014, 0x055a, 0x073a, 
	0x078e, 0x073b, 0x078f, 0x073c, 0x0790, 0x073d, 0x0791, 0x073e, 
	0x0792, 0x073f, 0x0793, 0x0740, 0x078e, 0x0741, 0x0794, 0x0742, 
	0x0795, 0x0743, 0x0796, 0x0744, 0x0797, 0x0745, 0x0798, 0x0746, 
	0x0799, 0x0747, 0x079a, 0x0748, 0x079b, 0x0749, 0x079c, 0x074a, 
	0x079d, 0x074b, 0x079e, 0x074c, 0x079f, 0x074d, 0x07a0, 0x0004, 
	0x0578, 0x074e, 0x04a6, 0x074f, 0x077b, 0x0750, 0x077c, 0x0751, 
	0x077d, 0x0007, 0x058a, 0x0752, 0x04a3, 0x0738, 0x07a1, 0x0739, 
	0x07a2, 0x0753, 0x04a6, 0x0754, 0x077e, 0x0755, 0x077f, 0x0756, 
	0x0780, 0x0004, 0x0595, 0x0757, 0x0781, 0x0758, 0x0782, 0x0759, 
	0x0783, 0x075a, 0x0784, 0x0014, 0x05a0, 0x06e0, 0x04a6, 0x06e1, 
	0x07a3, 0x06e2, 0x07a4, 0x06e3, 0x07a5, 0x06e4, 0x04a6, 0x06e5, 
	0x07a6, 0x06ea, 0x07a7, 0x06eb, 0x07a8, 0x06ec, 0x07a7, 0x06ed, 
	0x07a9, 0x06ee, 0x07a7, 0x06ef, 0x07aa, 0x0724, 0x04a6, 0x0725, 
	0x0756, 0x071e, 0x07ab, 0x071f, 0x07ac, 0x0720, 0x07ab, 0x0721, 
	0x07ad, 0x071c, 0x07ae, 0x071d, 0x07af, 0x001b, 0x07db, 0x06c3, 
	0x06b0, 0x06c4, 0x06d1, 0x06c5, 0x06d1, 0x06c6, 0x06d1, 0x06c7, 
	0x06d1, 0x06c8, 0x06d1, 0x06c9, 0x06d1, 0x06ca, 0x06d1, 0x06cb, 
	0x06d1, 0x06cc, 0x06b0, 0x06cd, 0x06b0, 0x06ce, 0x06b0, 0x06cf, 
	0x06b0, 0x06d0, 0x06b0, 0x06d1, 0x06b0, 0x06d2, 0x06b0, 0x06d3, 
	0x06b0, 0x06d4, 0x06b0, 0x06d5, 0x06d2, 0x06d6, 0x06d3, 0x06d7, 
	0x06d4, 0x06d8, 0x06d5, 0x06d9, 0x06d6, 0x06da, 0x06d7, 0x06db, 
	0x06d8, 0x06dc, 0x06d9, 0x06dd, 0x06da, 0x0001, 0x06a0, 0x0001, 
	0x04a3, 0x06a1, 0x0051, 0x04a5, 0x06a2, 0x005c, 0x04a5, 0x06a3, 
	0x0064, 0x04a5, 0x06a4, 0x00cd, 0x04a5, 0x06a5, 0x0141, 0x04a5, 
	0x06a6, 0x0144, 0x04a5, 0x06a7, 0x01bd, 0x04a5, 0x06a8, 0x01bf, 
	0x04a5, 0x06b5, 0x01d9, 0x04a5, 0x06b6, 0x01dc, 0x04a5, 0x06b7, 
	0x01df, 0x04a5, 0x06b8, 0x01e1, 0x04a5, 0x06b9, 0x01e4, 0x04a5, 
	0x06ba, 0x01e7, 0x04a5, 0x06bd, 0x01ef, 0x04a5, 0x06c0, 0x01f7, 
	0x04a5, 0x06c1, 0x01fb, 0x04a5, 0x06c2, 0x01fe, 0x04a5, 0x0702, 
	0x03f1, 0x04a6, 0x070b, 0x0433, 0x0785,      0, 0x0003, 0x0001, 
	0x06a0, 0x04a3, 0x069f, 0x04a3, 0x069e, 0x04a3, 0x0003, 0x01c9, 
	0x06a9, 0x04a5, 0x06aa, 0x04a5, 0x06ab, 0x04a5, 0x0003, 0x01cd, 
	0x06ac, 0x04a5, 0x06ad, 0x04a5, 0x06ae, 0x04a5, 0x0003, 0x01d1, 
	0x06af, 0x04a5, 0x06b0, 0x04a5, 0x06b1, 0x04a5, 0x0003, 0x01d5, 
	0x06b2, 0x04a5, 0x06b3, 0x04a5, 0x06b4, 0x04a5, 0x0002, 0x01eb, 
	0x06bb, 0x04a5, 0x06bc, 0x04a5, 0x0002, 0x01f3, 0x06be, 0x04a5, 
	0x06bf, 0x04a5, 0x001b, 0x02f4, 0x06c3, 0x06b0, 0x06c4, 0x06d1, 
	0x06c5, 0x06d1, 0x06c6, 0x06d1, 0x06c7, 0x06d1, 0x06c8, 0x06d1, 
	0x06c9, 0x06d1, 0x06ca, 0x06d1, 0x06cb, 0x06d1, 0x06cc, 0x06b0, 
	0x06cd, 0x06b0, 0x06ce, 0x06b0, 0x06cf, 0x06b0, 0x06d0, 0x06b0, 
	0x06d1, 0x06b0, 0x06d2, 0x06b0, 0x06d3, 0x06b0, 0x06d4, 0x06b0, 
	0x06d5, 0x06d2, 0x06d6, 0x06d3, 0x06d7, 0x06d4, 0x06d8, 0x06d5, 
	0x06d9, 0x06d6, 0x06da, 0x06d7, 0x06db, 0x06d8, 0x06dc, 0x06d9, 
	0x06dd, 0x06da, 0x0002, 0x0312, 0x06de, 0x0713, 0x06df, 0x0714, 
	0x0004, 0x0334, 0x06e0, 0x0715, 0x06e1, 0x0716, 0x06e2, 0x0717, 
	0x06e3, 0x0718, 0x0002, 0x033a, 0x06e4, 0x0719, 0x06e5, 0x071a, 
	0x0004, 0x0344, 0x06e6, 0x071b, 0x06e7, 0x071c, 0x06e8, 0x071d, 
	0x06e9, 0x071e, 0x0006, 0x034b, 0x06ea, 0x071f, 0x06eb, 0x0720, 
	0x06ec, 0x0721, 0x06ed, 0x0722, 0x06ee, 0x0723, 0x06ef, 0x0724, 
	0x0002, 0x035e, 0x06f0, 0x0725, 0x06f1, 0x0726, 0x0002, 0x0368, 
	0x06f4, 0x0786, 0x06f5, 0x0787, 0x0002, 0x036d, 0x06f2, 0x07b0, 
	0x06f3, 0x0736, 0x0002, 0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 
	0x0002, 0x038a, 0x06f8, 0x072c, 0x06f9, 0x072d, 0x0004, 0x03b0, 
	0x06fa, 0x072e, 0x06fb, 0x072f, 0x06fc, 0x0730, 0x06fd, 0x0731, 
	0x0002, 0x03cd, 0x0700, 0x0788, 0x0701, 0x0789, 0x0002, 0x03d9, 
	0x06fe, 0x0732, 0x06ff, 0x0733, 0x0002, 0x03f5, 0x0705, 0x0738, 
	0x0706, 0x0739, 0x0002, 0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 
	0x0002, 0x0413, 0x0707, 0x073a, 0x0708, 0x073b, 0x0002, 0x042e, 
	0x0709, 0x073c, 0x070a, 0x073d, 0x0004, 0x0440, 0x070c, 0x073e, 
	0x070d, 0x073f, 0x070e, 0x0740, 0x070f, 0x0741, 0x0002, 0x045a, 
	0x0710, 0x0742, 0x0711, 0x0743, 0x0002, 0x045e, 0x0712, 0x0744, 
	0x0713, 0x0745, 0x0002, 0x0464, 0x0714, 0x0746, 0x0715, 0x0747, 
	0x0002, 0x046c, 0x0716, 0x0748, 0x0717, 0x0749, 0x0002, 0x0475, 
	0x0718, 0x074a, 0x0719, 0x074b, 0x0004, 0x048d, 0x0724, 0x07b1, 
	0x0725, 0x07b2, 0x071a, 0x074c, 0x071b, 0x074d, 0x0002, 0x0493, 
	0x071c, 0x074e, 0x071d, 0x074f, 0x0004, 0x049b, 0x071e, 0x0750, 
	0x071f, 0x0751, 0x0720, 0x0752, 0x0721, 0x0753, 0x0002, 0x04a3, 
	0x0722, 0x0754, 0x0723, 0x0755, 0x0002, 0x04b6, 0x0726, 0x0757, 
	0x0727, 0x0758, 0x0002, 0x04d3, 0x0728, 0x0759, 0x0729, 0x075a, 
	0x0002, 0x04df, 0x072a, 0x075b, 0x072b, 0x075c, 0x0002, 0x04ef, 
	0x072e, 0x078c, 0x072f, 0x078d, 0x0002, 0x04f2, 0x072c, 0x07b3, 
	0x072d, 0x0736, 0x0002, 0x0510, 0x0730, 0x0760, 0x0731, 0x0761, 
	0x0002, 0x0514, 0x0732, 0x0762, 0x0733, 0x0763, 0x0002, 0x0524, 
	0x0738, 0x07b4, 0x0739, 0x07b5, 0x0002, 0x052e, 0x0734, 0x0764, 
	0x0735, 0x0765, 0x0002, 0x053c, 0x0736, 0x0766, 0x0737, 0x0767, 
	0x0006, 0x0551, 0x073a, 0x04a6, 0x073b, 0x0769, 0x073c, 0x076a, 
	0x073d, 0x076b, 0x073e, 0x076c, 0x073f, 0x076d, 0x000e, 0x055a, 
	0x0740, 0x04a6, 0x0741, 0x076e, 0x0742, 0x076f, 0x0743, 0x0770, 
	0x0744, 0x0771, 0x0745, 0x0772, 0x0746, 0x0773, 0x0747, 0x0774, 
	0x0748, 0x0775, 0x0749, 0x0776, 0x074a, 0x0777, 0x074b, 0x0778, 
	0x074c, 0x0779, 0x074d, 0x077a, 0x0004, 0x0578, 0x074e, 0x04a6, 
	0x074f, 0x077b, 0x0750, 0x077c, 0x0751, 0x077d, 0x0005, 0x058a, 
	0x0752, 0x04a3, 0x0753, 0x04a6, 0x0754, 0x077e, 0x0755, 0x077f, 
	0x0756, 0x0780, 0x0002, 0x0595, 0x0759, 0x0783, 0x075a, 0x0784, 
	0x0002, 0x05a0, 0x0757, 0x07b6, 0x0758, 0x0736, 0x0001, 0x06a1, 
	0x0051, 0x04a5, 0x06a2, 0x005c, 0x04a5, 0x06a3, 0x0064, 0x04a5, 
	0x06a4, 0x00cd, 0x04a5, 0x06a5, 0x0141, 0x04a5, 0x06a6, 0x0144, 
	0x04a5, 0x06a7, 0x01bd, 0x04a5, 0x06a8, 0x01bf, 0x04a5, 0x06b5, 
	0x01d9, 0x04a5, 0x06b6, 0x01dc, 0x04a5, 0x06b7, 0x01df, 0x04a5, 
	0x06b8, 0x01e1, 0x04a5, 0x06b9, 0x01e4, 0x04a5, 0x06ba, 0x01e7, 
	0x04a5, 0x06bd, 0x01ef, 0x04a5, 0x06c0, 0x01f7, 0x04a5, 0x06c1, 
	0x01fb, 0x04a5, 0x06c2, 0x01fe, 0x04a5, 0x0702, 0x03f1, 0x04a6, 
	0x070b, 0x0433, 0x0785,      0, 0x0003, 0x0001, 0x06a0, 0x04a3, 
	0x069f, 0x04a3, 0x069e, 0x04a3, 0x0003, 0x01c9, 0x06a9, 0x04a5, 
	0x06aa, 0x04a5, 0x06ab, 0x04a5, 0x0003, 0x01cd, 0x06ac, 0x04a5, 
	0x06ad, 0x04a5, 0x06ae, 0x04a5, 0x0003, 0x01d1, 0x06af, 0x04a5, 
	0x06b0, 0x04a5, 0x06b1, 0x04a5, 0x0003, 0x01d5, 0x06b2, 0x04a5, 
	0x06b3, 0x04a5, 0x06b4, 0x04a5, 0x0002, 0x01eb, 0x06bb, 0x04a5, 
	0x06bc, 0x04a5, 0x0002, 0x01f3, 0x06be, 0x04a5, 0x06bf, 0x04a5, 
	0x001b, 0x02f4, 0x06c3, 0x06b0, 0x06c4, 0x06d1, 0x06c5, 0x06d1, 
	0x06c6, 0x06d1, 0x06c7, 0x06d1, 0x06c8, 0x06d1, 0x06c9, 0x06d1, 
	0x06ca, 0x06d1, 0x06cb, 0x06d1, 0x06cc, 0x06b0, 0x06cd, 0x06b0, 
	0x06ce, 0x06b0, 0x06cf, 0x06b0, 0x06d0, 0x06b0, 0x06d1, 0x06b0, 
	0x06d2, 0x06b0, 0x06d3, 0x06b0, 0x06d4, 0x06b0, 0x06d5, 0x06d2, 
	0x06d6, 0x06d3, 0x06d7, 0x06d4, 0x06d8, 0x06d5, 0x06d9, 0x06d6, 
	0x06da, 0x06d7, 0x06db, 0x06d8, 0x06dc, 0x06d9, 0x06dd, 0x06da, 
	0x0002, 0x0312, 0x06de, 0x0713, 0x06df, 0x0714, 0x0004, 0x0334, 
	0x06e0, 0x0715, 0x06e1, 0x0716, 0x06e2, 0x0717, 0x06e3, 0x0718, 
	0x0002, 0x033a, 0x06e4, 0x0719, 0x06e5, 0x071a, 0x0002, 0x0344, 
	0x06e8, 0x071d, 0x06e9, 0x071e, 0x0008, 0x034b, 0x06e6, 0x04a6, 
	0x06e7, 0x07b7, 0x06ea, 0x071f, 0x06eb, 0x0720, 0x06ec, 0x0721, 
	0x06ed, 0x0722, 0x06ee, 0x0723, 0x06ef, 0x0724, 0x0002, 0x0362, 
	0x06f2, 0x0727, 0x06f3, 0x0728, 0x0002, 0x0368, 0x06f4, 0x0786, 
	0x06f5, 0x0787, 0x0002, 0x036d, 0x06f0, 0x04a6, 0x06f1, 0x07b8, 
	0x0002, 0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 0x038a, 
	0x06f8, 0x072c, 0x06f9, 0x072d, 0x0002, 0x03b0, 0x06fc, 0x0730, 
	0x06fd, 0x0731, 0x0002, 0x03bb, 0x06fa, 0x04a6, 0x06fb, 0x07b9, 
	0x0002, 0x03cd, 0x0700, 0x0788, 0x0701, 0x0789, 0x0002, 0x03d9, 
	0x06fe, 0x0732, 0x06ff, 0x0733, 0x0002, 0x03f5, 0x0705, 0x0738, 
	0x0706, 0x0739, 0x0002, 0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 
	0x0002, 0x0413, 0x0707, 0x073a, 0x0708, 0x073b, 0x0002, 0x042e, 
	0x0709, 0x073c, 0x070a, 0x073d, 0x0002, 0x0440, 0x070e, 0x0740, 
	0x070f, 0x0741, 0x0002, 0x044b, 0x070c, 0x04a6, 0x070d, 0x07ba, 
	0x0002, 0x045e, 0x0712, 0x0744, 0x0713, 0x0745, 0x0002, 0x0464, 
	0x0714, 0x0746, 0x0715, 0x0747, 0x0004, 0x046c, 0x0710, 0x04a6, 
	0x0711, 0x07bb, 0x0716, 0x0748, 0x0717, 0x0749, 0x0004, 0x048d, 
	0x0724, 0x07b1, 0x0725, 0x07b2, 0x071a, 0x074c, 0x071b, 0x074d, 
	0x0002, 0x0493, 0x071c, 0x074e, 0x071d, 0x074f, 0x0004, 0x049b, 
	0x071e, 0x0750, 0x071f, 0x0751, 0x0720, 0x0752, 0x0721, 0x0753, 
	0x0002, 0x04a3, 0x0722, 0x0754, 0x0723, 0x0755, 0x0004, 0x04b6, 
	0x0718, 0x04a6, 0x0719, 0x07bc, 0x0726, 0x0757, 0x0727, 0x0758, 
	0x0002, 0x04d3, 0x0728, 0x0759, 0x0729, 0x075a, 0x0002, 0x04e5, 
	0x072c, 0x075d, 0x072d, 0x075e, 0x0002, 0x04ef, 0x072e, 0x078c, 
	0x072f, 0x078d, 0x0002, 0x04f2, 0x072a, 0x04a6, 0x072b, 0x07bd, 
	0x0002, 0x0510, 0x0730, 0x0760, 0x0731, 0x0761, 0x0002, 0x0514, 
	0x0732, 0x0762, 0x0733, 0x0763, 0x0002, 0x0524, 0x0738, 0x07b4, 
	0x0739, 0x07b5, 0x0002, 0x052e, 0x0734, 0x0764, 0x0735, 0x0765, 
	0x0002, 0x053c, 0x0736, 0x0766, 0x0737, 0x0767, 0x0006, 0x0551, 
	0x073a, 0x04a6, 0x073b, 0x0769, 0x073c, 0x076a, 0x073d, 0x076b, 
	0x073e, 0x076c, 0x073f, 0x076d, 0x000e, 0x055a, 0x0740, 0x04a6, 
	0x0741, 0x076e, 0x0742, 0x076f, 0x0743, 0x0770, 0x0744, 0x0771, 
	0x0745, 0x0772, 0x0746, 0x0773, 0x0747, 0x0774, 0x0748, 0x0775, 
	0x0749, 0x0776, 0x074a, 0x0777, 0x074b, 0x0778, 0x074c, 0x0779, 
	0x074d, 0x077a, 0x0004, 0x0578, 0x074e, 0x04a6, 0x074f, 0x077b, 
	0x0750, 0x077c, 0x0751, 0x077d, 0x0003, 0x058a, 0x0752, 0x04a3, 
	0x0753, 0x04a6, 0x0754, 0x077e, 0x0002, 0x0595, 0x0757, 0x0781, 
	0x0758, 0x0782, 0x0004, 0x05a0, 0x0755, 0x04a6, 0x0756, 0x07be, 
	0x0759, 0x04a6, 0x075a, 0x07bf, 0x0001, 0x06a1, 0x0051, 0x04a5, 
	0x06a2, 0x005c, 0x04a5, 0x06a3, 0x0064, 0x04a5, 0x06a4, 0x00cd, 
	0x04a5, 0x06a5, 0x0141, 0x04a5, 0x06a6, 0x0144, 0x04a5, 0x06a7, 
	0x01bd, 0x04a5, 0x06a8, 0x01bf, 0x04a5, 0x06b5, 0x01d9, 0x04a5, 
	0x06b6, 0x01dc, 0x04a5, 0x06b7, 0x01df, 0x04a5, 0x06b8, 0x01e1, 
	0x04a5, 0x06b9, 0x01e4, 0x04a5, 0x06ba, 0x01e7, 0x04a5, 0x06bd, 
	0x01ef, 0x04a5, 0x06c0, 0x01f7, 0x04a5, 0x06c1, 0x01fb, 0x04a5, 
	0x06c2, 0x01fe, 0x04a5, 0x0702, 0x03f1, 0x04a6, 0x070b, 0x0433, 
	0x0785,      0, 0x0003, 0x0005, 0x069e, 0x04a3, 0x069f, 0x04a3, 
	0x06a0, 0x04a3, 0x0003, 0x01c9, 0x06a9, 0x04a5, 0x06aa, 0x04a5, 
	0x06ab, 0x04a5, 0x0003, 0x01cd, 0x06ac, 0x04a5, 0x06ad, 0x04a5, 
	0x06ae, 0x04a5, 0x0003, 0x01d1, 0x06af, 0x04a5, 0x06b0, 0x04a5, 
	0x06b1, 0x04a5, 0x0003, 0x01d5, 0x06b2, 0x04a5, 0x06b3, 0x04a5, 
	0x06b4, 0x04a5, 0x0002, 0x01eb, 0x06bb, 0x04a5, 0x06bc, 0x04a5, 
	0x0002, 0x01f3, 0x06be, 0x04a5, 0x06bf, 0x04a5, 0x001b, 0x02f4, 
	0x06c3, 0x06b0, 0x06c4, 0x06d1, 0x06c5, 0x06d1, 0x06c6, 0x06d1, 
	0x06c7, 0x06d1, 0x06c8, 0x06d1, 0x06c9, 0x06d1, 0x06ca, 0x06d1, 
	0x06cb, 0x06d1, 0x06cc, 0x06b0, 0x06cd, 0x06b0, 0x06ce, 0x06b0, 
	0x06cf, 0x06b0, 0x06d0, 0x06b0, 0x06d1, 0x06b0, 0x06d2, 0x06b0, 
	0x06d3, 0x06b0, 0x06d4, 0x06b0, 0x06d5, 0x06d2, 0x06d6, 0x06d3, 
	0x06d7, 0x06d4, 0x06d8, 0x06d5, 0x06d9, 0x06d6, 0x06da, 0x06d7, 
	0x06db, 0x06d8, 0x06dc, 0x06d9, 0x06dd, 0x06da, 0x0002, 0x0312, 
	0x06de, 0x0713, 0x06df, 0x0714, 0x0004, 0x0344, 0x06e6, 0x071b, 
	0x06e7, 0x071c, 0x06e8, 0x071d, 0x06e9, 0x071e, 0x0002, 0x035e, 
	0x06f0, 0x0725, 0x06f1, 0x0726, 0x0002, 0x0362, 0x06f2, 0x0727, 
	0x06f3, 0x0728, 0x0002, 0x0368, 0x06f4, 0x0786, 0x06f5, 0x0787, 
	0x0002, 0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 0x038a, 
	0x06f8, 0x072c, 0x06f9, 0x072d, 0x0004, 0x03b0, 0x06fa, 0x072e, 
	0x06fb, 0x072f, 0x06fc, 0x0730, 0x06fd, 0x0731, 0x0002, 0x03cd, 
	0x0700, 0x0788, 0x0701, 0x0789, 0x0002, 0x03d9, 0x06fe, 0x0732, 
	0x06ff, 0x0733, 0x0002, 0x03f5, 0x0705, 0x0738, 0x0706, 0x0739, 
	0x0002, 0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 0x0002, 0x0413, 
	0x0707, 0x073a, 0x0708, 0x073b, 0x0002, 0x042e, 0x0709, 0x073c, 
	0x070a, 0x073d, 0x0004, 0x0440, 0x070c, 0x073e, 0x070d, 0x073f, 
	0x070e, 0x0740, 0x070f, 0x0741, 0x0002, 0x045a, 0x0710, 0x0742, 
	0x0711, 0x0743, 0x0002, 0x045e, 0x0712, 0x0744, 0x0713, 0x0745, 
	0x0002, 0x0464, 0x0714, 0x0746, 0x0715, 0x0747, 0x0002, 0x046c, 
	0x0716, 0x0748, 0x0717, 0x0749, 0x0002, 0x0475, 0x0718, 0x074a, 
	0x0719, 0x074b, 0x0002, 0x0493, 0x071c, 0x074e, 0x071d, 0x074f, 
	0x0002, 0x04a3, 0x0722, 0x0754, 0x0723, 0x0755, 0x0002, 0x04b6, 
	0x0726, 0x0757, 0x0727, 0x0758, 0x0002, 0x04d3, 0x0728, 0x0759, 
	0x0729, 0x075a, 0x0002, 0x04df, 0x072a, 0x075b, 0x072b, 0x075c, 
	0x0002, 0x04e5, 0x072c, 0x075d, 0x072d, 0x075e, 0x0002, 0x04ef, 
	0x072e, 0x078c, 0x072f, 0x078d, 0x0002, 0x0510, 0x0730, 0x0760, 
	0x0731, 0x0761, 0x0002, 0x0514, 0x0732, 0x0762, 0x0733, 0x0763, 
	0x0002, 0x053c, 0x0736, 0x0766, 0x0737, 0x0767, 0x0006, 0x0551, 
	0x073a, 0x04a6, 0x073b, 0x0769, 0x073c, 0x076a, 0x073d, 0x076b, 
	0x073e, 0x076c, 0x073f, 0x076d, 0x000e, 0x055a, 0x0740, 0x04a6, 
	0x0741, 0x076e, 0x0742, 0x076f, 0x0743, 0x0770, 0x0744, 0x0771, 
	0x0745, 0x0772, 0x0746, 0x0773, 0x0747, 0x0774, 0x0748, 0x0775, 
	0x0749, 0x0776, 0x074a, 0x0777, 0x074b, 0x0778, 0x074c, 0x0779, 
	0x074d, 0x077a, 0x0004, 0x0578, 0x074e, 0x04a6, 0x074f, 0x077b, 
	0x0750, 0x077c, 0x0751, 0x077d, 0x0009, 0x058a, 0x0752, 0x04a3, 
	0x0738, 0x07c0, 0x0739, 0x07c1, 0x0734, 0x07c0, 0x0735, 0x07c2, 
	0x0753, 0x04a6, 0x0754, 0x077e, 0x0755, 0x077f, 0x0756, 0x0780, 
	0x0004, 0x0595, 0x0757, 0x0781, 0x0758, 0x0782, 0x0759, 0x0783, 
	0x075a, 0x0784, 0x0018, 0x05a0, 0x06ea, 0x04a6, 0x06eb, 0x07c3, 
	0x06ec, 0x07c4, 0x06ed, 0x07c5, 0x06ee, 0x07c6, 0x06ef, 0x07c7, 
	0x06e4, 0x07c8, 0x06e5, 0x07c9, 0x071e, 0x04a6, 0x071f, 0x07ca, 
	0x0720, 0x07cb, 0x0721, 0x07cc, 0x0724, 0x07cd, 0x0725, 0x07ce, 
	0x071a, 0x07cf, 0x071b, 0x07d0, 0x06e0, 0x04a6, 0x06e1, 0x07a3, 
	0x075b, 0x07d1, 0x075c, 0x07d2, 0x075d, 0x07d3, 0x075e, 0x07d4, 
	0x06e2, 0x07d1, 0x06e3, 0x07d5, 0x0001, 0x06a1, 0x0051, 0x04a5, 
	0x06a2, 0x005c, 0x04a5, 0x06a3, 0x0064, 0x04a5, 0x06a4, 0x00cd, 
	0x04a5, 0x06a5, 0x0141, 0x04a5, 0x06a6, 0x0144, 0x04a5, 0x06a7, 
	0x01bd, 0x04a5, 0x06a8, 0x01bf, 0x04a5, 0x06b5, 0x01d9, 0x04a5, 
	0x06b6, 0x01dc, 0x04a5, 0x06b7, 0x01df, 0x04a5, 0x06b8, 0x01e1, 
	0x04a5, 0x06b9, 0x01e4, 0x04a5, 0x06ba, 0x01e7, 0x04a5, 0x06bd, 
	0x01ef, 0x04a5, 0x06c0, 0x01f7, 0x04a5, 0x06c1, 0x01fb, 0x04a5, 
	0x06c2, 0x01fe, 0x04a5, 0x0702, 0x03f1, 0x04a6, 0x070b, 0x0433, 
	0x0785,      0, 0x0003, 0x0005, 0x069e, 0x04a3, 0x069f, 0x04a3, 
	0x06a0, 0x04a3, 0x0003, 0x01c9, 0x06a9, 0x04a5, 0x06aa, 0x04a5, 
	0x06ab, 0x04a5, 0x0003, 0x01cd, 0x06ac, 0x04a5, 0x06ad, 0x04a5, 
	0x06ae, 0x04a5, 0x0003, 0x01d1, 0x06af, 0x04a5, 0x06b0, 0x04a5, 
	0x06b1, 0x04a5, 0x0003, 0x01d5, 0x06b2, 0x04a5, 0x06b3, 0x04a5, 
	0x06b4, 0x04a5, 0x0002, 0x01eb, 0x06bb, 0x04a5, 0x06bc, 0x04a5, 
	0x0002, 0x01f3, 0x06be, 0x04a5, 0x06bf, 0x04a5, 0x001b, 0x02f4, 
	0x06c3, 0x06b0, 0x06c4, 0x06d1, 0x06c5, 0x06d1, 0x06c6, 0x06d1, 
	0x06c7, 0x06d1, 0x06c8, 0x06d1, 0x06c9, 0x06d1, 0x06ca, 0x06d1, 
	0x06cb, 0x06d1, 0x06cc, 0x06b0, 0x06cd, 0x06b0, 0x06ce, 0x06b0, 
	0x06cf, 0x06b0, 0x06d0, 0x06b0, 0x06d1, 0x06b0, 0x06d2, 0x06b0, 
	0x06d3, 0x06b0, 0x06d4, 0x06b0, 0x06d5, 0x06d2, 0x06d6, 0x06d3, 
	0x06d7, 0x06d4, 0x06d8, 0x06d5, 0x06d9, 0x06d6, 0x06da, 0x06d7, 
	0x06db, 0x06d8, 0x06dc, 0x06d9, 0x06dd, 0x06da, 0x0002, 0x0312, 
	0x06de, 0x0713, 0x06df, 0x0714, 0x0004, 0x0334, 0x06e0, 0x0715, 
	0x06e1, 0x0716, 0x06e2, 0x0717, 0x06e3, 0x0718, 0x0002, 0x033a, 
	0x06e4, 0x0719, 0x06e5, 0x071a, 0x0002, 0x0344, 0x06e6, 0x071b, 
	0x06e7, 0x071c, 0x0008, 0x034b, 0x06e8, 0x04a6, 0x06e9, 0x07d6, 
	0x06ea, 0x071f, 0x06eb, 0x0720, 0x06ec, 0x0721, 0x06ed, 0x0722, 
	0x06ee, 0x0723, 0x06ef, 0x0724, 0x0002, 0x035e, 0x06f0, 0x0725, 
	0x06f1, 0x0726, 0x0002, 0x0368, 0x06f4, 0x0786, 0x06f5, 0x0787, 
	0x0002, 0x036d, 0x06f2, 0x04a6, 0x06f3, 0x07d7, 0x0002, 0x0379, 
	0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 0x038a, 0x06f8, 0x072c, 
	0x06f9, 0x072d, 0x0002, 0x03b0, 0x06fa, 0x072e, 0x06fb, 0x072f, 
	0x0002, 0x03bb, 0x06fc, 0x04a6, 0x06fd, 0x07d8, 0x0002, 0x03cd, 
	0x0700, 0x0788, 0x0701, 0x0789, 0x0002, 0x03de, 0x06fe, 0x04a6, 
	0x06ff, 0x07d9, 0x0002, 0x03f5, 0x0705, 0x0738, 0x0706, 0x0739, 
	0x0002, 0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 0x0007, 0x0416, 
	0x074e, 0x04a6, 0x074f, 0x077b, 0x0750, 0x077c, 0x0751, 0x077d, 
	0x0752, 0x04a3, 0x0707, 0x04a6, 0x0708, 0x07da, 0x0003, 0x0433, 
	0x0709, 0x04a6, 0x070a, 0x07db, 0x070b, 0x0785, 0x0002, 0x0440, 
	0x070c, 0x073e, 0x070d, 0x073f, 0x0002, 0x044b, 0x070e, 0x04a6, 
	0x070f, 0x07dc, 0x0002, 0x045a, 0x0710, 0x0742, 0x0711, 0x0743, 
	0x0002, 0x045e, 0x0712, 0x0744, 0x0713, 0x0745, 0x0004, 0x046c, 
	0x0714, 0x04a6, 0x0715, 0x07dd, 0x0716, 0x0748, 0x0717, 0x0749, 
	0x0002, 0x0475, 0x0718, 0x074a, 0x0719, 0x074b, 0x0004, 0x048d, 
	0x0724, 0x07b1, 0x0725, 0x07b2, 0x071a, 0x074c, 0x071b, 0x074d, 
	0x0002, 0x0493, 0x071c, 0x074e, 0x071d, 0x074f, 0x0004, 0x049b, 
	0x071e, 0x0750, 0x071f, 0x0751, 0x0720, 0x0752, 0x0721, 0x0753, 
	0x0004, 0x04b6, 0x0722, 0x04a6, 0x0723, 0x07de, 0x0726, 0x0757, 
	0x0727, 0x0758, 0x0002, 0x04da, 0x0728, 0x04a6, 0x0729, 0x07df, 
	0x0002, 0x04df, 0x072a, 0x075b, 0x072b, 0x075c, 0x0002, 0x04ef, 
	0x072e, 0x078c, 0x072f, 0x078d, 0x0002, 0x04f2, 0x072c, 0x04a6, 
	0x072d, 0x07e0, 0x0002, 0x0510, 0x0730, 0x0760, 0x0731, 0x0761, 
	0x0002, 0x0514, 0x0732, 0x0762, 0x0733, 0x0763, 0x0002, 0x0524, 
	0x0738, 0x07b4, 0x0739, 0x07b5, 0x0002, 0x052e, 0x0734, 0x0764, 
	0x0735, 0x0765, 0x0008, 0x0551, 0x0736, 0x04a6, 0x0737, 0x07e1, 
	0x073a, 0x04a6, 0x073b, 0x0769, 0x073c, 0x076a, 0x073d, 0x076b, 
	0x073e, 0x076c, 0x073f, 0x076d, 0x000e, 0x055a, 0x0740, 0x04a6, 
	0x0741, 0x076e, 0x0742, 0x076f, 0x0743, 0x0770, 0x0744, 0x0771, 
	0x0745, 0x0772, 0x0746, 0x0773, 0x0747, 0x0774, 0x0748, 0x0775, 
	0x0749, 0x0776, 0x074a, 0x0777, 0x074b, 0x0778, 0x074c, 0x0779, 
	0x074d, 0x077a, 0x0004, 0x058a, 0x0753, 0x04a6, 0x0754, 0x077e, 
	0x0755, 0x077f, 0x0756, 0x0780, 0x0002, 0x0595, 0x0759, 0x0783, 
	0x075a, 0x0784, 0x0002, 0x05a0, 0x0757, 0x04a6, 0x0758, 0x07e2, 
	0x0001, 0x06a1, 0x0051, 0x04a5, 0x06a2, 0x005c, 0x04a5, 0x06a3, 
	0x0064, 0x04a5, 0x06a4, 0x00cd, 0x04a5, 0x06a5, 0x0141, 0x04a5, 
	0x06a6, 0x0144, 0x04a5, 0x06a7, 0x01bd, 0x04a5, 0x06a8, 0x01bf, 
	0x04a5, 0x06b5, 0x01d9, 0x04a5, 0x06b6, 0x01dc, 0x04a5, 0x06b7, 
	0x01df, 0x04a5, 0x06b8, 0x01e1, 0x04a5, 0x06b9, 0x01e4, 0x04a5, 
	0x06ba, 0x01e7, 0x04a5, 0x06bd, 0x01ef, 0x04a5, 0x06c0, 0x01f7, 
	0x04a5, 0x06c1, 0x01fb, 0x04a5, 0x06c2, 0x01fe, 0x04a5, 0x0702, 
	0x03f1, 0x04a6,      0, 0x0003, 0x0005, 0x069e, 0x04a3, 0x069f, 
	0x04a3, 0x06a0, 0x04a3, 0x0003, 0x01c9, 0x06a9, 0x04a5, 0x06aa, 
	0x04a5, 0x06ab, 0x04a5, 0x0003, 0x01cd, 0x06ac, 0x04a5, 0x06ad, 
	0x04a5, 0x06ae, 0x04a5, 0x0003, 0x01d1, 0x06af, 0x04a5, 0x06b0, 
	0x04a5, 0x06b1, 0x04a5, 0x0003, 0x01d5, 0x06b2, 0x04a5, 0x06b3, 
	0x04a5, 0x06b4, 0x04a5, 0x0002, 0x01eb, 0x06bb, 0x04a5, 0x06bc, 
	0x04a5, 0x0002, 0x01f3, 0x06be, 0x04a5, 0x06bf, 0x04a5, 0x001b, 
	0x02f4, 0x06c3, 0x06b0, 0x06c4, 0x06d1, 0x06c5, 0x06d1, 0x06c6, 
	0x06d1, 0x06c7, 0x06d1, 0x06c8, 0x06d1, 0x06c9, 0x06d1, 0x06ca, 
	0x06d1, 0x06cb, 0x06d1, 0x06cc, 0x06b0, 0x06cd, 0x06b0, 0x06ce, 
	0x06b0, 0x06cf, 0x06b0, 0x06d0, 0x06b0, 0x06d1, 0x06b0, 0x06d2, 
	0x06b0, 0x06d3, 0x06b0, 0x06d4, 0x06b0, 0x06d5, 0x06d2, 0x06d6, 
	0x06d3, 0x06d7, 0x06d4, 0x06d8, 0x06d5, 0x06d9, 0x06d6, 0x06da, 
	0x06d7, 0x06db, 0x06d8, 0x06dc, 0x06d9, 0x06dd, 0x06da, 0x0002, 
	0x0312, 0x06de, 0x0713, 0x06df, 0x0714, 0x0004, 0x0334, 0x06e0, 
	0x0715, 0x06e1, 0x0716, 0x06e2, 0x0717, 0x06e3, 0x0718, 0x0002, 
	0x033a, 0x06e4, 0x0719, 0x06e5, 0x071a, 0x0004, 0x0344, 0x06e6, 
	0x071b, 0x06e7, 0x071c, 0x06e8, 0x071d, 0x06e9, 0x071e, 0x0006, 
	0x034b, 0x06ea, 0x071f, 0x06eb, 0x0720, 0x06ec, 0x0721, 0x06ed, 
	0x0722, 0x06ee, 0x0723, 0x06ef, 0x0724, 0x0002, 0x035e, 0x06f0, 
	0x0725, 0x06f1, 0x0726, 0x0002, 0x0362, 0x06f2, 0x0727, 0x06f3, 
	0x0728, 0x0002, 0x0368, 0x06f4, 0x0786, 0x06f5, 0x0787, 0x0002, 
	0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 0x038a, 0x06f8, 
	0x072c, 0x06f9, 0x072d, 0x0004, 0x03b0, 0x06fa, 0x072e, 0x06fb, 
	0x072f, 0x06fc, 0x0730, 0x06fd, 0x0731, 0x0002, 0x03cd, 0x0700, 
	0x0788, 0x0701, 0x0789, 0x0002, 0x03d9, 0x06fe, 0x0732, 0x06ff, 
	0x0733, 0x0002, 0x03f5, 0x0705, 0x0738, 0x0706, 0x0739, 0x0002, 
	0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 0x0002, 0x0413, 0x0707, 
	0x073a, 0x0708, 0x073b, 0x0002, 0x0416, 0x074e, 0x04a6, 0x074f, 
	0x077b, 0x0002, 0x042e, 0x0709, 0x073c, 0x070a, 0x073d, 0x0004, 
	0x0440, 0x070c, 0x073e, 0x070d, 0x073f, 0x070e, 0x0740, 0x070f, 
	0x0741, 0x0002, 0x045a, 0x0710, 0x0742, 0x0711, 0x0743, 0x0002, 
	0x045e, 0x0712, 0x0744, 0x0713, 0x0745, 0x0002, 0x0464, 0x0714, 
	0x0746, 0x0715, 0x0747, 0x0002, 0x046c, 0x0716, 0x0748, 0x0717, 
	0x0749, 0x0002, 0x0475, 0x0718, 0x074a, 0x0719, 0x074b, 0x0004, 
	0x048d, 0x0724, 0x07b1, 0x0725, 0x07b2, 0x071a, 0x074c, 0x071b, 
	0x074d, 0x0002, 0x0493, 0x071c, 0x074e, 0x071d, 0x074f, 0x0004, 
	0x049b, 0x071e, 0x0750, 0x071f, 0x0751, 0x0720, 0x0752, 0x0721, 
	0x0753, 0x0002, 0x04a3, 0x0722, 0x0754, 0x0723, 0x0755, 0x0002, 
	0x04b6, 0x0726, 0x0757, 0x0727, 0x0758, 0x0002, 0x04d3, 0x0728, 
	0x0759, 0x0729, 0x075a, 0x0002, 0x04df, 0x072a, 0x075b, 0x072b, 
	0x075c, 0x0002, 0x04e5, 0x072c, 0x075d, 0x072d, 0x075e, 0x0002, 
	0x04ef, 0x072e, 0x078c, 0x072f, 0x078d, 0x0002, 0x0510, 0x0730, 
	0x0760, 0x0731, 0x0761, 0x0002, 0x0514, 0x0732, 0x0762, 0x0733, 
	0x0763, 0x0002, 0x0524, 0x0738, 0x07b4, 0x0739, 0x07b5, 0x0002, 
	0x052e, 0x0734, 0x0764, 0x0735, 0x0765, 0x0002, 0x053c, 0x0736, 
	0x0766, 0x0737, 0x0767, 0x0006, 0x0551, 0x073a, 0x04a6, 0x073b, 
	0x0769, 0x073c, 0x076a, 0x073d, 0x076b, 0x073e, 0x076c, 0x073f, 
	0x076d, 0x000e, 0x055a, 0x0740, 0x04a6, 0x0741, 0x076e, 0x0742, 
	0x076f, 0x0743, 0x0770, 0x0744, 0x0771, 0x0745, 0x0772, 0x0746, 
	0x0773, 0x0747, 0x0774, 0x0748, 0x0775, 0x0749, 0x0776, 0x074a, 
	0x0777, 0x074b, 0x0778, 0x074c, 0x0779, 0x074d, 0x077a, 0x0002, 
	0x0578, 0x0750, 0x077c, 0x0751, 0x077d, 0x0005, 0x058a, 0x0752, 
	0x04a3, 0x0753, 0x04a6, 0x0754, 0x077e, 0x0755, 0x077f, 0x0756, 
	0x0780, 0x0004, 0x0595, 0x0757, 0x0781, 0x0758, 0x0782, 0x0759, 
	0x0783, 0x075a, 0x0784, 0x0001, 0x06a1, 0x0051, 0x04a5, 0x06a2, 
	0x005c, 0x04a5, 0x06a3, 0x0064, 0x04a5, 0x06a4, 0x00cd, 0x04a5, 
	0x06a5, 0x0141, 0x04a5, 0x06a6, 0x0144, 0x04a5, 0x06a7, 0x01bd, 
	0x04a5, 0x06a8, 0x01bf, 0x04a5, 0x06b5, 0x01d9, 0x04a5, 0x06b6, 
	0x01dc, 0x04a5, 0x06b7, 0x01df, 0x04a5, 0x06b8, 0x01e1, 0x04a5, 
	0x06b9, 0x01e4, 0x04a5, 0x06ba, 0x01e7, 0x04a5, 0x06bd, 0x01ef, 
	0x04a5, 0x06c0, 0x01f7, 0x04a5, 0x06c1, 0x01fb, 0x04a5, 0x06c2, 
	0x01fe, 0x04a5, 0x0702, 0x03f1, 0x04a6, 0x070b, 0x0433, 0x0785, 
	     0, 0x0003, 0x0005, 0x069e, 0x04a3, 0x069f, 0x04a3, 0x06a0, 
	0x04a3, 0x0003, 0x0051, 0x06a1, 0x06b0, 0x06a2, 0x07e3, 0x06a3, 
	0x07e3, 0x0003, 0x01c9, 0x06a9, 0x04a5, 0x06aa, 0x04a5, 0x06ab, 
	0x04a5, 0x0003, 0x01cd, 0x06ac, 0x04a5, 0x06ad, 0x04a5, 0x06ae, 
	0x04a5, 0x0003, 0x01d1, 0x06af, 0x04a5, 0x06b0, 0x04a5, 0x06b1, 
	0x04a5, 0x0003, 0x01d5, 0x06b2, 0x04a5, 0x06b3, 0x04a5, 0x06b4, 
	0x04a5, 0x0002, 0x01eb, 0x06bb, 0x04a5, 0x06bc, 0x04a5, 0x0002, 
	0x01f3, 0x06be, 0x04a5, 0x06bf, 0x04a5, 0x001b, 0x02f4, 0x06c3, 
	0x06b0, 0x06c4, 0x06d1, 0x06c5, 0x06d1, 0x06c6, 0x06d1, 0x06c7, 
	0x06d1, 0x06c8, 0x06d1, 0x06c9, 0x06d1, 0x06ca, 0x06d1, 0x06cb, 
	0x06d1, 0x06cc, 0x06b0, 0x06cd, 0x06b0, 0x06ce, 0x06b0, 0x06cf, 
	0x06b0, 0x06d0, 0x06b0, 0x06d1, 0x06b0, 0x06d2, 0x06b0, 0x06d3, 
	0x06b0, 0x06d4, 0x06b0, 0x06d5, 0x06d2, 0x06d6, 0x06d3, 0x06d7, 
	0x06d4, 0x06d8, 0x06d5, 0x06d9, 0x06d6, 0x06da, 0x06d7, 0x06db, 
	0x06d8, 0x06dc, 0x06d9, 0x06dd, 0x06da, 0x0002, 0x0312, 0x06de, 
	0x0713, 0x06df, 0x0714, 0x0004, 0x0344, 0x06e6, 0x071b, 0x06e7, 
	0x071c, 0x06e8, 0x071d, 0x06e9, 0x071e, 0x0002, 0x035e, 0x06f0, 
	0x0725, 0x06f1, 0x0726, 0x0002, 0x0362, 0x06f2, 0x0727, 0x06f3, 
	0x0728, 0x0002, 0x0368, 0x06f4, 0x0786, 0x06f5, 0x0787, 0x0002, 
	0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 0x0382, 0x075f, 
	0x07e4, 0x0760, 0x07e5, 0x0002, 0x038a, 0x06f8, 0x072c, 0x06f9, 
	0x072d, 0x0004, 0x03b0, 0x06fa, 0x072e, 0x06fb, 0x072f, 0x06fc, 
	0x0730, 0x06fd, 0x0731, 0x0002, 0x03cd, 0x0700, 0x0788, 0x0701, 
	0x0789, 0x0002, 0x03d9, 0x06fe, 0x0732, 0x06ff, 0x0733, 0x0002, 
	0x03f5, 0x0705, 0x0738, 0x0706, 0x0739, 0x0002, 0x040d, 0x0704, 
	0x078a, 0x0703, 0x078b, 0x0002, 0x0413, 0x0707, 0x073a, 0x0708, 
	0x073b, 0x0002, 0x042e, 0x0709, 0x073c, 0x070a, 0x073d, 0x0004, 
	0x0440, 0x070c, 0x073e, 0x070d, 0x073f, 0x070e, 0x0740, 0x070f, 
	0x0741, 0x0002, 0x045a, 0x0710, 0x0742, 0x0711, 0x0743, 0x0002, 
	0x045e, 0x0712, 0x0744, 0x0713, 0x0745, 0x0002, 0x0464, 0x0714, 
	0x0746, 0x0715, 0x0747, 0x0002, 0x046c, 0x0716, 0x0748, 0x0717, 
	0x0749, 0x0002, 0x0475, 0x0718, 0x074a, 0x0719, 0x074b, 0x0002, 
	0x0493, 0x071c, 0x074e, 0x071d, 0x074f, 0x0002, 0x04a3, 0x0722, 
	0x0754, 0x0723, 0x0755, 0x0002, 0x04b6, 0x0726, 0x0757, 0x0727, 
	0x0758, 0x0002, 0x04d3, 0x0728, 0x0759, 0x0729, 0x075a, 0x0002, 
	0x04df, 0x072a, 0x075b, 0x072b, 0x075c, 0x0002, 0x04e5, 0x072c, 
	0x075d, 0x072d, 0x075e, 0x0002, 0x04ef, 0x072e, 0x078c, 0x072f, 
	0x078d, 0x0002, 0x0510, 0x0730, 0x0760, 0x0731, 0x0761, 0x0002, 
	0x0514, 0x0732, 0x0762, 0x0733, 0x0763, 0x0002, 0x053c, 0x0736, 
	0x0766, 0x0737, 0x0767, 0x0006, 0x0551, 0x073a, 0x04a6, 0x073b, 
	0x0769, 0x073c, 0x076a, 0x073d, 0x076b, 0x073e, 0x076c, 0x073f, 
	0x076d, 0x000e, 0x055a, 0x0740, 0x04a6, 0x0741, 0x076e, 0x0742, 
	0x076f, 0x0743, 0x0770, 0x0744, 0x0771, 0x0745, 0x0772, 0x0746, 
	0x0773, 0x0747, 0x0774, 0x0748, 0x0775, 0x0749, 0x0776, 0x074a, 
	0x0777, 0x074b, 0x0778, 0x074c, 0x0779, 0x074d, 0x077a, 0x0004, 
	0x0578, 0x074e, 0x04a6, 0x074f, 0x077b, 0x0750, 0x077c, 0x0751, 
	0x077d, 0x0009, 0x058a, 0x0752, 0x04a3, 0x0738, 0x07c0, 0x0739, 
	0x07c1, 0x0734, 0x07c0, 0x0735, 0x07c2, 0x0753, 0x04a6, 0x0754, 
	0x077e, 0x0755, 0x077f, 0x0756, 0x0780, 0x0004, 0x0595, 0x0757, 
	0x0781, 0x0758, 0x0782, 0x0759, 0x0783, 0x075a, 0x0784, 0x0018, 
	0x05a0, 0x06ea, 0x04a6, 0x06eb, 0x07c3, 0x06ec, 0x07c4, 0x06ed, 
	0x07c5, 0x06ee, 0x07c6, 0x06ef, 0x07c7, 0x06e4, 0x07c8, 0x06e5, 
	0x07c9, 0x071e, 0x04a6, 0x071f, 0x07ca, 0x0720, 0x07cb, 0x0721, 
	0x07cc, 0x0724, 0x07cd, 0x0725, 0x07ce, 0x071a, 0x07cf, 0x071b, 
	0x07d0, 0x06e0, 0x04a6, 0x06e1, 0x07a3, 0x075b, 0x07d1, 0x075c, 
	0x07d2, 0x075d, 0x07d3, 0x075e, 0x07d4, 0x06e2, 0x07d1, 0x06e3, 
	0x07d5, 0x0001, 0x06a4, 0x00cd, 0x04a5, 0x06a5, 0x0141, 0x04a5, 
	0x06a6, 0x0144, 0x04a5, 0x06a7, 0x01bd, 0x04a5, 0x06a8, 0x01bf, 
	0x04a5, 0x06b5, 0x01d9, 0x04a5, 0x06b6, 0x01dc, 0x04a5, 0x06b7, 
	0x01df, 0x04a5, 0x06b8, 0x01e1, 0x04a5, 0x06b9, 0x01e4, 0x04a5, 
	0x06ba, 0x01e7, 0x04a5, 0x06bd, 0x01ef, 0x04a5, 0x06c0, 0x01f7, 
	0x04a5, 0x06c1, 0x01fb, 0x04a5, 0x06c2, 0x01fe, 0x04a5, 0x0702, 
	0x03f1, 0x04a6, 0x070b, 0x04c4, 0x07e6,      0, 0x0003, 0x0001, 
	0x06a0, 0x04a3, 0x069f, 0x04a3, 0x069e, 0x04a3, 0x0003, 0x01c9, 
	0x0764, 0x04a5, 0x0765, 0x04a5, 0x0766, 0x04a5, 0x0003, 0x01cd, 
	0x0767, 0x04a5, 0x0768, 0x04a5, 0x0769, 0x04a5, 0x0003, 0x01d1, 
	0x076a, 0x04a5, 0x076b, 0x04a5, 0x076c, 0x04a5, 0x0003, 0x01d5, 
	0x076d, 0x04a5, 0x076e, 0x04a5, 0x076f, 0x04a5, 0x0002, 0x01eb, 
	0x0776, 0x04a5, 0x0777, 0x04a5, 0x0002, 0x01f3, 0x0779, 0x04a5, 
	0x077a, 0x04a5, 0x001d, 0x0207, 0x077e, 0x04a5, 0x06a7, 0x04a5, 
	0x06a8, 0x04a5, 0x06a9, 0x04a5, 0x06aa, 0x04a5, 0x06ab, 0x04a5, 
	0x06ac, 0x04a5, 0x06ad, 0x04a5, 0x06ae, 0x04a5, 0x06af, 0x04a5, 
	0x06b0, 0x04a5, 0x06b1, 0x04a5, 0x06b2, 0x04a5, 0x06b3, 0x04a5, 
	0x06b4, 0x04a5, 0x06b5, 0x04a5, 0x06b6, 0x04a5, 0x06b7, 0x04a5, 
	0x06b8, 0x04a5, 0x06b9, 0x04a5, 0x06ba, 0x04a5, 0x06bb, 0x04a5, 
	0x06bc, 0x04a5, 0x06bd, 0x04a5, 0x06be, 0x04a5, 0x06bf, 0x04a5, 
	0x06c0, 0x04a5, 0x06c1, 0x04a5, 0x06c2, 0x04a5, 0x0002, 0x02f1, 
	0x077f, 0x04a5, 0x0780, 0x04a5, 0x001b, 0x02f4, 0x06c3, 0x06b0, 
	0x06c4, 0x06d1, 0x06c5, 0x06d1, 0x06c6, 0x06d1, 0x06c7, 0x06d1, 
	0x06c8, 0x06d1, 0x06c9, 0x06d1, 0x06ca, 0x06d1, 0x06cb, 0x06d1, 
	0x06cc, 0x06b0, 0x06cd, 0x06b0, 0x06ce, 0x06b0, 0x06cf, 0x06b0, 
	0x06d0, 0x06b0, 0x06d1, 0x06b0, 0x06d2, 0x06b0, 0x06d3, 0x06b0, 
	0x06d4, 0x06b0, 0x06d5, 0x06d2, 0x06d6, 0x06d3, 0x06d7, 0x06d4, 
	0x06d8, 0x06d5, 0x06d9, 0x06d6, 0x06da, 0x06d7, 0x06db, 0x06d8, 
	0x06dc, 0x06d9, 0x06dd, 0x06da, 0x0004, 0x0334, 0x06e0, 0x0715, 
	0x06e1, 0x0716, 0x06e2, 0x0717, 0x06e3, 0x0718, 0x0002, 0x033a, 
	0x06e4, 0x0719, 0x06e5, 0x071a, 0x0004, 0x0344, 0x06e6, 0x071b, 
	0x06e7, 0x071c, 0x06e8, 0x071d, 0x06e9, 0x071e, 0x0006, 0x034b, 
	0x06df, 0x0736, 0x06de, 0x07e7, 0x06ec, 0x0721, 0x06ed, 0x0722, 
	0x06ee, 0x0723, 0x06ef, 0x0724, 0x0002, 0x035e, 0x06f0, 0x0725, 
	0x06f1, 0x0726, 0x0002, 0x0362, 0x06f2, 0x0727, 0x06f3, 0x0728, 
	0x0002, 0x0368, 0x06f4, 0x0786, 0x06f5, 0x0787, 0x0002, 0x0379, 
	0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 0x0382, 0x0760, 0x0736, 
	0x075f, 0x07e8, 0x0004, 0x03b0, 0x06fa, 0x072e, 0x06fb, 0x072f, 
	0x06fc, 0x0730, 0x06fd, 0x0731, 0x0002, 0x03bb, 0x06f9, 0x0736, 
	0x06f8, 0x07e9, 0x0004, 0x03cd, 0x0700, 0x0788, 0x0701, 0x0789, 
	0x0781, 0x07ea, 0x0782, 0x07eb, 0x0002, 0x03d9, 0x06fe, 0x0732, 
	0x06ff, 0x0733, 0x0002, 0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 
	0x0002, 0x0413, 0x0707, 0x073a, 0x0708, 0x073b, 0x0002, 0x0416, 
	0x0706, 0x0736, 0x0705, 0x07ec, 0x0002, 0x042e, 0x0709, 0x073c, 
	0x070a, 0x073d, 0x0004, 0x0440, 0x070c, 0x073e, 0x070d, 0x073f, 
	0x070e, 0x0740, 0x070f, 0x0741, 0x0002, 0x045a, 0x0710, 0x0742, 
	0x0711, 0x0743, 0x0002, 0x045e, 0x0712, 0x0744, 0x0713, 0x0745, 
	0x0002, 0x0464, 0x0714, 0x0746, 0x0715, 0x0747, 0x0002, 0x046c, 
	0x0716, 0x07ed, 0x0717, 0x07ee, 0x0002, 0x048d, 0x071a, 0x074c, 
	0x071b, 0x074d, 0x0002, 0x0493, 0x071c, 0x074e, 0x071d, 0x074f, 
	0x0002, 0x049b, 0x0720, 0x0752, 0x0721, 0x0753, 0x0002, 0x04a3, 
	0x0722, 0x0754, 0x0723, 0x0755, 0x0002, 0x04b6, 0x0719, 0x0736, 
	0x0718, 0x07ef, 0x0002, 0x04d3, 0x0728, 0x0759, 0x0729, 0x075a, 
	0x0002, 0x04df, 0x072a, 0x075b, 0x072b, 0x075c, 0x0002, 0x04e5, 
	0x072c, 0x075d, 0x072d, 0x075e, 0x0002, 0x04ef, 0x072e, 0x078c, 
	0x072f, 0x078d, 0x0002, 0x0524, 0x0738, 0x07b4, 0x0739, 0x07b5, 
	0x0002, 0x052e, 0x0734, 0x0764, 0x0735, 0x0765, 0x0002, 0x053c, 
	0x0736, 0x0766, 0x0737, 0x0767, 0x0008, 0x0551, 0x0733, 0x0736, 
	0x0732, 0x07f0, 0x073a, 0x04a6, 0x073b, 0x0769, 0x073c, 0x076a, 
	0x073d, 0x076b, 0x073e, 0x076c, 0x073f, 0x076d, 0x000e, 0x055a, 
	0x0740, 0x04a6, 0x0741, 0x076e, 0x0742, 0x076f, 0x0743, 0x0770, 
	0x0744, 0x0771, 0x0745, 0x0772, 0x0746, 0x0773, 0x0747, 0x0774, 
	0x0748, 0x0775, 0x0749, 0x0776, 0x074a, 0x0777, 0x074b, 0x0778, 
	0x074c, 0x0779, 0x074d, 0x077a, 0x0002, 0x0578, 0x074e, 0x04a6, 
	0x074f, 0x077b, 0x0007, 0x058a, 0x0752, 0x04a3, 0x0751, 0x0736, 
	0x0750, 0x07f1, 0x0753, 0x04a6, 0x0754, 0x077e, 0x0755, 0x077f, 
	0x0756, 0x0780, 0x0004, 0x0595, 0x0757, 0x0781, 0x0758, 0x0782, 
	0x0759, 0x0783, 0x075a, 0x0784, 0x000a, 0x05a0, 0x0731, 0x0736, 
	0x0730, 0x07f2, 0x06eb, 0x0736, 0x06ea, 0x07f3, 0x0727, 0x07f4, 
	0x0726, 0x07f5, 0x0725, 0x0736, 0x0724, 0x07f6, 0x071f, 0x07f7, 
	0x071e, 0x07f8, 0x0004, 0x07db, 0x0783, 0x06d0, 0x0784, 0x07f9, 
	0x0785, 0x07fa, 0x0786, 0x07fb, 0x0001, 0x06a1, 0x0051, 0x04a5, 
	0x06a2, 0x005c, 0x04a5, 0x06a3, 0x0064, 0x04a5, 0x06a6, 0x00cd, 
	0x04a5, 0x06a5, 0x00dd, 0x04a5, 0x06a4, 0x0144, 0x04a5, 0x0761, 
	0x0173, 0x04a5, 0x0762, 0x01bd, 0x04a5, 0x0763, 0x01bf, 0x04a5, 
	0x0770, 0x01d9, 0x04a5, 0x0771, 0x01dc, 0x04a5, 0x0772, 0x01df, 
	0x04a5, 0x0773, 0x01e1, 0x04a5, 0x0774, 0x01e4, 0x04a5, 0x0775, 
	0x01e7, 0x04a5, 0x0778, 0x01ef, 0x04a5, 0x077b, 0x01f7, 0x04a5, 
	0x077c, 0x01fb, 0x04a5, 0x077d, 0x01fe, 0x04a5, 0x0702, 0x03f1, 
	0x04a6, 0x070b, 0x0433, 0x0785,      0, 0x0003, 0x0001, 0x06a0, 
	0x04a3, 0x069f, 0x04a3, 0x069e, 0x04a3, 0x0003, 0x01c9, 0x06a9, 
	0x04a5, 0x06aa, 0x04a5, 0x06ab, 0x04a5, 0x0003, 0x01cd, 0x06ac, 
	0x04a5, 0x06ad, 0x04a5, 0x06ae, 0x04a5, 0x0003, 0x01d1, 0x06af, 
	0x04a5, 0x06b0, 0x04a5, 0x06b1, 0x04a5, 0x0003, 0x01d5, 0x06b2, 
	0x04a5, 0x06b3, 0x04a5, 0x06b4, 0x04a5, 0x0002, 0x01eb, 0x06bb, 
	0x04a5, 0x06bc, 0x04a5, 0x0002, 0x01f3, 0x06be, 0x04a5, 0x06bf, 
	0x04a5, 0x001b, 0x02f4, 0x06c3, 0x06b0, 0x06c4, 0x06d1, 0x06c5, 
	0x06d1, 0x06c6, 0x06d1, 0x06c7, 0x06d1, 0x06c8, 0x06d1, 0x06c9, 
	0x06d1, 0x06ca, 0x06d1, 0x06cb, 0x06d1, 0x06cc, 0x06b0, 0x06cd, 
	0x06b0, 0x06ce, 0x06b0, 0x06cf, 0x06b0, 0x06d0, 0x06b0, 0x06d1, 
	0x06b0, 0x06d2, 0x06b0, 0x06d3, 0x06b0, 0x06d4, 0x06b0, 0x06d5, 
	0x06d2, 0x06d6, 0x06d3, 0x06d7, 0x06d4, 0x06d8, 0x06d5, 0x06d9, 
	0x06d6, 0x06da, 0x06d7, 0x06db, 0x06d8, 0x06dc, 0x06d9, 0x06dd, 
	0x06da, 0x0002, 0x0312, 0x06de, 0x0713, 0x06df, 0x0714, 0x0004, 
	0x0334, 0x06e0, 0x0715, 0x06e1, 0x0716, 0x06e2, 0x0717, 0x06e3, 
	0x0718, 0x0002, 0x033a, 0x06e4, 0x0719, 0x06e5, 0x071a, 0x0004, 
	0x0344, 0x06e6, 0x071b, 0x06e7, 0x071c, 0x06e8, 0x071d, 0x06e9, 
	0x071e, 0x0006, 0x034b, 0x06ea, 0x071f, 0x06eb, 0x0720, 0x06ec, 
	0x0721, 0x06ed, 0x0722, 0x06ee, 0x0723, 0x06ef, 0x0724, 0x0002, 
	0x0368, 0x06f4, 0x0786, 0x06f5, 0x0787, 0x0004, 0x036d, 0x06f2, 
	0x04a6, 0x06f3, 0x07d7, 0x06f0, 0x04a6, 0x06f1, 0x07b8, 0x0006, 
	0x0382, 0x0787, 0x04a6, 0x0788, 0x07fc, 0x0789, 0x07fd, 0x078a, 
	0x07fe, 0x06f6, 0x04a6, 0x06f7, 0x07ff, 0x0002, 0x038a, 0x06f8, 
	0x072c, 0x06f9, 0x072d, 0x0004, 0x03b0, 0x06fa, 0x072e, 0x06fb, 
	0x072f, 0x06fc, 0x0730, 0x06fd, 0x0731, 0x0002, 0x03cd, 0x0700, 
	0x0788, 0x0701, 0x0789, 0x0002, 0x03d9, 0x06fe, 0x0732, 0x06ff, 
	0x0733, 0x0002, 0x03f5, 0x0705, 0x0738, 0x0706, 0x0739, 0x0002, 
	0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 0x0002, 0x0413, 0x0707, 
	0x073a, 0x0708, 0x073b, 0x0002, 0x042e, 0x0709, 0x073c, 0x070a, 
	0x073d, 0x0004, 0x0440, 0x070c, 0x073e, 0x070d, 0x073f, 0x070e, 
	0x0740, 0x070f, 0x0741, 0x0004, 0x044b, 0x078b, 0x04a6, 0x078c, 
	0x0800, 0x078d, 0x0801, 0x078e, 0x0802, 0x0002, 0x045a, 0x0710, 
	0x0742, 0x0711, 0x0743, 0x0002, 0x045e, 0x0712, 0x0744, 0x0713, 
	0x0745, 0x0002, 0x0464, 0x0714, 0x0746, 0x0715, 0x0747, 0x0006, 
	0x046c, 0x078f, 0x04a6, 0x0790, 0x0803, 0x0791, 0x0804, 0x0792, 
	0x0805, 0x0716, 0x0748, 0x0717, 0x0749, 0x0002, 0x0475, 0x0718, 
	0x074a, 0x0719, 0x074b, 0x0004, 0x048d, 0x0724, 0x07b1, 0x0725, 
	0x07b2, 0x071a, 0x074c, 0x071b, 0x074d, 0x0002, 0x0493, 0x071c, 
	0x074e, 0x071d, 0x074f, 0x0004, 0x049b, 0x071e, 0x0750, 0x071f, 
	0x0751, 0x0720, 0x0752, 0x0721, 0x0753, 0x0002, 0x04a3, 0x0722, 
	0x0754, 0x0723, 0x0755, 0x0002, 0x04b6, 0x0726, 0x0757, 0x0727, 
	0x0758, 0x0002, 0x04d3, 0x0728, 0x0759, 0x0729, 0x075a, 0x0002, 
	0x04df, 0x072a, 0x075b, 0x072b, 0x075c, 0x0002, 0x04ef, 0x072e, 
	0x078c, 0x072f, 0x078d, 0x0002, 0x04f2, 0x072c, 0x04a6, 0x072d, 
	0x07e0, 0x0002, 0x0510, 0x0730, 0x0760, 0x0731, 0x0761, 0x0002, 
	0x0514, 0x0732, 0x0762, 0x0733, 0x0763, 0x0002, 0x0524, 0x0738, 
	0x07b4, 0x0739, 0x07b5, 0x0002, 0x052e, 0x0734, 0x0764, 0x0735, 
	0x0765, 0x0002, 0x053c, 0x0736, 0x0766, 0x0737, 0x0767, 0x0006, 
	0x0551, 0x073a, 0x04a6, 0x073b, 0x0769, 0x073c, 0x076a, 0x073d, 
	0x076b, 0x073e, 0x076c, 0x073f, 0x076d, 0x000e, 0x055a, 0x0740, 
	0x04a6, 0x0741, 0x076e, 0x0742, 0x076f, 0x0743, 0x0770, 0x0744, 
	0x0771, 0x0745, 0x0772, 0x0746, 0x0773, 0x0747, 0x0774, 0x0748, 
	0x0775, 0x0749, 0x0776, 0x074a, 0x0777, 0x074b, 0x0778, 0x074c, 
	0x0779, 0x074d, 0x077a, 0x0004, 0x0578, 0x074e, 0x04a6, 0x074f, 
	0x077b, 0x0750, 0x077c, 0x0751, 0x077d, 0x0005, 0x058a, 0x0752, 
	0x04a3, 0x0753, 0x04a6, 0x0754, 0x077e, 0x0755, 0x077f, 0x0756, 
	0x0780, 0x0002, 0x0595, 0x0759, 0x0783, 0x075a, 0x0784, 0x0002, 
	0x05a0, 0x0757, 0x04a6, 0x0758, 0x07e2, 0x0001, 0x06a1, 0x0051, 
	0x04a5, 0x06a2, 0x005c, 0x04a5, 0x06a3, 0x0064, 0x04a5, 0x06a4, 
	0x00cd, 0x04a5, 0x06a5, 0x0141, 0x04a5, 0x06a6, 0x0144, 0x04a5, 
	0x06a7, 0x01bd, 0x04a5, 0x06a8, 0x01bf, 0x04a5, 0x06b5, 0x01d9, 
	0x04a5, 0x06b6, 0x01dc, 0x04a5, 0x06b7, 0x01df, 0x04a5, 0x06b8, 
	0x01e1, 0x04a5, 0x06b9, 0x01e4, 0x04a5, 0x06ba, 0x01e7, 0x04a5, 
	0x06bd, 0x01ef, 0x04a5, 0x06c0, 0x01f7, 0x04a5, 0x06c1, 0x01fb, 
	0x04a5, 0x06c2, 0x01fe, 0x04a5, 0x0702, 0x03f1, 0x04a6, 0x070b, 
	0x0433, 0x0785,      0, 0x0003, 0x0001, 0x06a0, 0x04a3, 0x069f, 
	0x04a3, 0x069e, 0x04a3, 0x0003, 0x01c9, 0x06a9, 0x04a5, 0x06aa, 
	0x04a5, 0x06ab, 0x04a5, 0x0003, 0x01cd, 0x06ac, 0x04a5, 0x06ad, 
	0x04a5, 0x06ae, 0x04a5, 0x0003, 0x01d1, 0x06af, 0x04a5, 0x06b0, 
	0x04a5, 0x06b1, 0x04a5, 0x0003, 0x01d5, 0x06b2, 0x04a5, 0x06b3, 
	0x04a5, 0x06b4, 0x04a5, 0x0002, 0x01eb, 0x06bb, 0x04a5, 0x06bc, 
	0x04a5, 0x0002, 0x01f3, 0x06be, 0x04a5, 0x06bf, 0x04a5, 0x001b, 
	0x02f4, 0x06c3, 0x06b0, 0x06c4, 0x06d1, 0x06c5, 0x06d1, 0x06c6, 
	0x06d1, 0x06c7, 0x06d1, 0x06c8, 0x06d1, 0x06c9, 0x06d1, 0x06ca, 
	0x06d1, 0x06cb, 0x06d1, 0x06cc, 0x06b0, 0x06cd, 0x06b0, 0x06ce, 
	0x06b0, 0x06cf, 0x06b0, 0x06d0, 0x06b0, 0x06d1, 0x06b0, 0x06d2, 
	0x06b0, 0x06d3, 0x06b0, 0x06d4, 0x06b0, 0x06d5, 0x06d2, 0x06d6, 
	0x06d3, 0x06d7, 0x06d4, 0x06d8, 0x06d5, 0x06d9, 0x06d6, 0x06da, 
	0x06d7, 0x06db, 0x06d8, 0x06dc, 0x06d9, 0x06dd, 0x06da, 0x0002, 
	0x0312, 0x06de, 0x0713, 0x06df, 0x0714, 0x0004, 0x0334, 0x06e0, 
	0x0715, 0x06e1, 0x0716, 0x06e2, 0x0717, 0x06e3, 0x0718, 0x0002, 
	0x033a, 0x06e4, 0x0719, 0x06e5, 0x071a, 0x0004, 0x0344, 0x06e6, 
	0x071b, 0x06e7, 0x071c, 0x06e8, 0x071d, 0x06e9, 0x071e, 0x0006, 
	0x034b, 0x06ea, 0x071f, 0x06eb, 0x0720, 0x06ec, 0x0721, 0x06ed, 
	0x0722, 0x06ee, 0x0723, 0x06ef, 0x0724, 0x0002, 0x035e, 0x06f0, 
	0x0725, 0x06f1, 0x0726, 0x0002, 0x0362, 0x06f2, 0x0727, 0x06f3, 
	0x0728, 0x0002, 0x0368, 0x06f4, 0x0786, 0x06f5, 0x0787, 0x0002, 
	0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 0x038a, 0x06f8, 
	0x072c, 0x06f9, 0x072d, 0x0004, 0x03b0, 0x06fa, 0x072e, 0x06fb, 
	0x072f, 0x06fc, 0x0730, 0x06fd, 0x0731, 0x0002, 0x03cd, 0x0700, 
	0x0788, 0x0701, 0x0789, 0x0002, 0x03d9, 0x06fe, 0x0732, 0x06ff, 
	0x0733, 0x0002, 0x03f5, 0x0705, 0x0738, 0x0706, 0x0739, 0x0002, 
	0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 0x0002, 0x0413, 0x0707, 
	0x073a, 0x0708, 0x073b, 0x0002, 0x042e, 0x0709, 0x073c, 0x070a, 
	0x073d, 0x0004, 0x0440, 0x070c, 0x073e, 0x070d, 0x073f, 0x070e, 
	0x0740, 0x070f, 0x0741, 0x0002, 0x045a, 0x0710, 0x0742, 0x0711, 
	0x0743, 0x0002, 0x0464, 0x0714, 0x0746, 0x0715, 0x0747, 0x0004, 
	0x046c, 0x0712, 0x04a6, 0x0713, 0x0806, 0x0716, 0x0748, 0x0717, 
	0x0749, 0x0002, 0x0475, 0x0718, 0x074a, 0x0719, 0x074b, 0x0004, 
	0x048d, 0x0724, 0x07b1, 0x0725, 0x07b2, 0x071a, 0x074c, 0x071b, 
	0x074d, 0x0002, 0x0493, 0x071c, 0x074e, 0x071d, 0x074f, 0x0004, 
	0x049b, 0x071e, 0x0750, 0x071f, 0x0751, 0x0720, 0x0752, 0x0721, 
	0x0753, 0x0002, 0x04a3, 0x0722, 0x0754, 0x0723, 0x0755, 0x0002, 
	0x04b6, 0x0726, 0x0757, 0x0727, 0x0758, 0x0002, 0x04d3, 0x0728, 
	0x0759, 0x0729, 0x075a, 0x0002, 0x04df, 0x072a, 0x075b, 0x072b, 
	0x075c, 0x0002, 0x04e5, 0x072c, 0x075d, 0x072d, 0x075e, 0x0002, 
	0x04ef, 0x072e, 0x078c, 0x072f, 0x078d, 0x0002, 0x0510, 0x0730, 
	0x0760, 0x0731, 0x0761, 0x0002, 0x0514, 0x0732, 0x0762, 0x0733, 
	0x0763, 0x0002, 0x0524, 0x0738, 0x07b4, 0x0739, 0x07b5, 0x0002, 
	0x052e, 0x0734, 0x0764, 0x0735, 0x0765, 0x0002, 0x053c, 0x0736, 
	0x0766, 0x0737, 0x0767, 0x0006, 0x0551, 0x073a, 0x04a6, 0x073b, 
	0x0769, 0x073c, 0x076a, 0x073d, 0x076b, 0x073e, 0x076c, 0x073f, 
	0x076d, 0x000e, 0x055a, 0x0740, 0x04a6, 0x0741, 0x076e, 0x0742, 
	0x076f, 0x0743, 0x0770, 0x0744, 0x0771, 0x0745, 0x0772, 0x0746, 
	0x0773, 0x0747, 0x0774, 0x0748, 0x0775, 0x0749, 0x0776, 0x074a, 
	0x0777, 0x074b, 0x0778, 0x074c, 0x0779, 0x074d, 0x077a, 0x0004, 
	0x0578, 0x074e, 0x04a6, 0x074f, 0x077b, 0x0750, 0x077c, 0x0751, 
	0x077d, 0x0005, 0x058a, 0x0752, 0x04a3, 0x0753, 0x04a6, 0x0754, 
	0x077e, 0x0755, 0x077f, 0x0756, 0x0780, 0x0004, 0x0595, 0x0757, 
	0x0781, 0x0758, 0x0782, 0x0759, 0x0783, 0x075a, 0x0784, 0x0001, 
	0x06a1, 0x0051, 0x04a5, 0x06a2, 0x005c, 0x04a5, 0x06a3, 0x0064, 
	0x04a5, 0x06a4, 0x00cd, 0x04a5, 0x06a5, 0x0141, 0x04a5, 0x06a6, 
	0x0144, 0x04a5, 0x06a7, 0x01bd, 0x04a5, 0x06a8, 0x01bf, 0x04a5, 
	0x06b5, 0x01d9, 0x04a5, 0x06b6, 0x01dc, 0x04a5, 0x06b7, 0x01df, 
	0x04a5, 0x06b8, 0x01e1, 0x04a5, 0x06b9, 0x01e4, 0x04a5, 0x06ba, 
	0x01e7, 0x04a5, 0x06bd, 0x01ef, 0x04a5, 0x06c0, 0x01f7, 0x04a5, 
	0x06c1, 0x01fb, 0x04a5, 0x06c2, 0x01fe, 0x04a5, 0x0702, 0x03f1, 
	0x04a6, 0x070b, 0x0433, 0x0785,      0, 0x0003, 0x0005, 0x069e, 
	0x04a3, 0x069f, 0x04a3, 0x06a0, 0x04a3, 0x0003, 0x01c9, 0x06a9, 
	0x04a5, 0x06aa, 0x04a5, 0x06ab, 0x04a5, 0x0003, 0x01cd, 0x06ac, 
	0x04a5, 0x06ad, 0x04a5, 0x06ae, 0x04a5, 0x0003, 0x01d1, 0x06af, 
	0x04a5, 0x06b0, 0x04a5, 0x06b1, 0x04a5, 0x0003, 0x01d5, 0x06b2, 
	0x04a5, 0x06b3, 0x04a5, 0x06b4, 0x04a5, 0x0002, 0x01eb, 0x06bb, 
	0x04a5, 0x06bc, 0x04a5, 0x0002, 0x01f3, 0x06be, 0x04a5, 0x06bf, 
	0x04a5, 0x001b, 0x02f4, 0x06c3, 0x06b0, 0x06c4, 0x06d1, 0x06c5, 
	0x06d1, 0x06c6, 0x06d1, 0x06c7, 0x06d1, 0x06c8, 0x06d1, 0x06c9, 
	0x06d1, 0x06ca, 0x06d1, 0x06cb, 0x06d1, 0x06cc, 0x06b0, 0x06cd, 
	0x06b0, 0x06ce, 0x06b0, 0x06cf, 0x06b0, 0x06d0, 0x06b0, 0x06d1, 
	0x06b0, 0x06d2, 0x06b0, 0x06d3, 0x06b0, 0x06d4, 0x06b0, 0x06d5, 
	0x06d2, 0x06d6, 0x06d3, 0x06d7, 0x06d4, 0x06d8, 0x06d5, 0x06d9, 
	0x06d6, 0x06da, 0x06d7, 0x06db, 0x06d8, 0x06dc, 0x06d9, 0x06dd, 
	0x06da, 0x0002, 0x0312, 0x06de, 0x0713, 0x06df, 0x0714, 0x0004, 
	0x0334, 0x06e0, 0x0715, 0x06e1, 0x0716, 0x06e2, 0x0717, 0x06e3, 
	0x0718, 0x0002, 0x033a, 0x06e4, 0x0719, 0x06e5, 0x071a, 0x0004, 
	0x0344, 0x06e6, 0x071b, 0x06e7, 0x071c, 0x06e8, 0x071d, 0x06e9, 
	0x071e, 0x0006, 0x034b, 0x06ea, 0x071f, 0x06eb, 0x0720, 0x06ec, 
	0x0721, 0x06ed, 0x0722, 0x06ee, 0x0723, 0x06ef, 0x0724, 0x0002, 
	0x035e, 0x06f0, 0x0725, 0x06f1, 0x0726, 0x0002, 0x0362, 0x06f2, 
	0x0727, 0x06f3, 0x0728, 0x0002, 0x0368, 0x06f4, 0x0786, 0x06f5, 
	0x0787, 0x0002, 0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 
	0x038a, 0x06f8, 0x072c, 0x06f9, 0x072d, 0x0004, 0x03b0, 0x06fa, 
	0x072e, 0x06fb, 0x072f, 0x06fc, 0x0730, 0x06fd, 0x0731, 0x0002, 
	0x03cd, 0x0700, 0x0788, 0x0701, 0x0789, 0x0002, 0x03d9, 0x06fe, 
	0x0732, 0x06ff, 0x0733, 0x0002, 0x03f5, 0x0705, 0x0738, 0x0706, 
	0x0739, 0x0002, 0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 0x0002, 
	0x0413, 0x0707, 0x073a, 0x0708, 0x073b, 0x0002, 0x042e, 0x0709, 
	0x073c, 0x070a, 0x073d, 0x0004, 0x0440, 0x070c, 0x073e, 0x070d, 
	0x073f, 0x070e, 0x0740, 0x070f, 0x0741, 0x0002, 0x045a, 0x0710, 
	0x0742, 0x0711, 0x0743, 0x0002, 0x045e, 0x0712, 0x0744, 0x0713, 
	0x0745, 0x0002, 0x0464, 0x0714, 0x0746, 0x0715, 0x0747, 0x0002, 
	0x046c, 0x0716, 0x0748, 0x0717, 0x0749, 0x0002, 0x0475, 0x0718, 
	0x074a, 0x0719, 0x074b, 0x0004, 0x048d, 0x0724, 0x07b1, 0x0725, 
	0x07b2, 0x071a, 0x074c, 0x071b, 0x074d, 0x0002, 0x0493, 0x071c, 
	0x074e, 0x071d, 0x074f, 0x0004, 0x049b, 0x071e, 0x0750, 0x071f, 
	0x0751, 0x0720, 0x0752, 0x0721, 0x0753, 0x0002, 0x04a3, 0x0722, 
	0x0754, 0x0723, 0x0755, 0x0002, 0x04b6, 0x0726, 0x0757, 0x0727, 
	0x0758, 0x0002, 0x04d3, 0x0728, 0x0759, 0x0729, 0x075a, 0x0002, 
	0x04df, 0x072a, 0x075b, 0x072b, 0x075c, 0x0002, 0x04e5, 0x072c, 
	0x075d, 0x072d, 0x075e, 0x0002, 0x04ef, 0x072e, 0x078c, 0x072f, 
	0x078d, 0x0002, 0x0510, 0x0730, 0x0760, 0x0731, 0x0761, 0x0002, 
	0x0514, 0x0732, 0x0762, 0x0733, 0x0763, 0x0002, 0x0524, 0x0738, 
	0x07b4, 0x0739, 0x07b5, 0x0002, 0x052e, 0x0734, 0x0764, 0x0735, 
	0x0765, 0x0002, 0x053c, 0x0736, 0x0766, 0x0737, 0x0767, 0x0006, 
	0x0551, 0x073a, 0x04a6, 0x073b, 0x0769, 0x073c, 0x076a, 0x073d, 
	0x076b, 0x073e, 0x076c, 0x073f, 0x076d, 0x000e, 0x055a, 0x0740, 
	0x04a6, 0x0741, 0x076e, 0x0742, 0x076f, 0x0743, 0x0770, 0x0744, 
	0x0771, 0x0745, 0x0772, 0x0746, 0x0773, 0x0747, 0x0774, 0x0748, 
	0x0775, 0x0749, 0x0776, 0x074a, 0x0777, 0x074b, 0x0778, 0x074c, 
	0x0779, 0x074d, 0x077a, 0x0004, 0x0578, 0x074e, 0x04a6, 0x074f, 
	0x077b, 0x0750, 0x077c, 0x0751, 0x077d, 0x0005, 0x058a, 0x0752, 
	0x04a3, 0x0753, 0x04a6, 0x0754, 0x077e, 0x0755, 0x077f, 0x0756, 
	0x0780, 0x0004, 0x0595, 0x0757, 0x0781, 0x0758, 0x0782, 0x0759, 
	0x0783, 0x075a, 0x0784, 0x0001, 0x06a1, 0x0051, 0x04a5, 0x06a2, 
	0x005c, 0x04a5, 0x06a3, 0x0064, 0x04a5, 0x06a4, 0x00cd, 0x04a5, 
	0x06a5, 0x0141, 0x04a5, 0x06a6, 0x0144, 0x04a5, 0x06a7, 0x01bd, 
	0x04a5, 0x06a8, 0x01bf, 0x04a5, 0x06b5, 0x01d9, 0x04a5, 0x06b6, 
	0x01dc, 0x04a5, 0x06b7, 0x01df, 0x04a5, 0x06b8, 0x01e1, 0x04a5, 
	0x06b9, 0x01e4, 0x04a5, 0x06ba, 0x01e7, 0x04a5, 0x06bd, 0x01ef, 
	0x04a5, 0x06c0, 0x01f7, 0x04a5, 0x06c1, 0x01fb, 0x04a5, 0x06c2, 
	0x01fe, 0x04a5, 0x0702, 0x03f1, 0x04a6, 0x070b, 0x0433, 0x0785, 
	     0, 0x0003, 0x0005, 0x069e, 0x04a3, 0x069f, 0x04a3, 0x06a0, 
	0x04a3, 0x0003, 0x01c9, 0x06a9, 0x04a5, 0x06aa, 0x04a5, 0x06ab, 
	0x04a5, 0x0003, 0x01cd, 0x06ac, 0x04a5, 0x06ad, 0x04a5, 0x06ae, 
	0x04a5, 0x0003, 0x01d1, 0x06af, 0x04a5, 0x06b0, 0x04a5, 0x06b1, 
	0x04a5, 0x0003, 0x01d5, 0x06b2, 0x04a5, 0x06b3, 0x04a5, 0x06b4, 
	0x04a5, 0x0002, 0x01eb, 0x06bb, 0x04a5, 0x06bc, 0x04a5, 0x0002, 
	0x01f3, 0x06be, 0x04a5, 0x06bf, 0x04a5, 0x001b, 0x02f4, 0x06c3, 
	0x06b0, 0x06c4, 0x06d1, 0x06c5, 0x06d1, 0x06c6, 0x06d1, 0x06c7, 
	0x06d1, 0x06c8, 0x06d1, 0x06c9, 0x06d1, 0x06ca, 0x06d1, 0x06cb, 
	0x06d1, 0x06cc, 0x06b0, 0x06cd, 0x06b0, 0x06ce, 0x06b0, 0x06cf, 
	0x06b0, 0x06d0, 0x06b0, 0x06d1, 0x06b0, 0x06d2, 0x06b0, 0x06d3, 
	0x06b0, 0x06d4, 0x06b0, 0x06d5, 0x06d2, 0x06d6, 0x06d3, 0x06d7, 
	0x06d4, 0x06d8, 0x06d5, 0x06d9, 0x06d6, 0x06da, 0x06d7, 0x06db, 
	0x06d8, 0x06dc, 0x06d9, 0x06dd, 0x06da, 0x0002, 0x0312, 0x06de, 
	0x0713, 0x06df, 0x0714, 0x0004, 0x0334, 0x06e0, 0x0715, 0x06e1, 
	0x0716, 0x06e2, 0x0717, 0x06e3, 0x0718, 0x0004, 0x0344, 0x06e6, 
	0x071b, 0x06e7, 0x071c, 0x06e8, 0x071d, 0x06e9, 0x071e, 0x0006, 
	0x034b, 0x06ea, 0x071f, 0x06eb, 0x0720, 0x06ec, 0x0721, 0x06ed, 
	0x0722, 0x06ee, 0x0723, 0x06ef, 0x0724, 0x0002, 0x035e, 0x06f0, 
	0x0725, 0x06f1, 0x0726, 0x0002, 0x0362, 0x06f2, 0x0727, 0x06f3, 
	0x0728, 0x0002, 0x0368, 0x06f4, 0x0786, 0x06f5, 0x0787, 0x0002, 
	0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 0x0002, 0x038a, 0x06f8, 
	0x072c, 0x06f9, 0x072d, 0x0004, 0x03b0, 0x06fa, 0x072e, 0x06fb, 
	0x072f, 0x06fc, 0x0730, 0x06fd, 0x0731, 0x0002, 0x03cd, 0x0700, 
	0x0788, 0x0701, 0x0789, 0x0002, 0x03d9, 0x06fe, 0x0732, 0x06ff, 
	0x0733, 0x0002, 0x03f5, 0x0705, 0x0738, 0x0706, 0x0739, 0x0002, 
	0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 0x0002, 0x0413, 0x0707, 
	0x073a, 0x0708, 0x073b, 0x0002, 0x042e, 0x0709, 0x073c, 0x070a, 
	0x073d, 0x0004, 0x0440, 0x070c, 0x073e, 0x070d, 0x073f, 0x070e, 
	0x0740, 0x070f, 0x0741, 0x0002, 0x045a, 0x0710, 0x0742, 0x0711, 
	0x0743, 0x0002, 0x045e, 0x0712, 0x0744, 0x0713, 0x0745, 0x0002, 
	0x0464, 0x0714, 0x0746, 0x0715, 0x0747, 0x0002, 0x046c, 0x0716, 
	0x0748, 0x0717, 0x0749, 0x0002, 0x0475, 0x0718, 0x074a, 0x0719, 
	0x074b, 0x0002, 0x048d, 0x071a, 0x074c, 0x071b, 0x074d, 0x0004, 
	0x049b, 0x071e, 0x0750, 0x071f, 0x0751, 0x0720, 0x0752, 0x0721, 
	0x0753, 0x0002, 0x04a3, 0x0722, 0x0754, 0x0723, 0x0755, 0x0002, 
	0x04b6, 0x0726, 0x0757, 0x0727, 0x0758, 0x0002, 0x04d3, 0x0728, 
	0x0759, 0x0729, 0x075a, 0x0002, 0x04df, 0x072a, 0x075b, 0x072b, 
	0x075c, 0x0002, 0x04ef, 0x072e, 0x078c, 0x072f, 0x078d, 0x000a, 
	0x04f2, 0x072c, 0x0807, 0x072d, 0x0808, 0x0753, 0x0809, 0x0754, 
	0x080a, 0x0755, 0x080b, 0x0756, 0x080c, 0x0759, 0x080d, 0x075a, 
	0x080e, 0x0757, 0x080f, 0x0758, 0x0810, 0x0002, 0x0510, 0x0730, 
	0x0760, 0x0731, 0x0761, 0x0002, 0x0514, 0x0732, 0x0762, 0x0733, 
	0x0763, 0x0002, 0x052e, 0x0734, 0x0764, 0x0735, 0x0765, 0x0002, 
	0x053c, 0x0736, 0x0766, 0x0737, 0x0767, 0x0006, 0x0551, 0x073a, 
	0x04a6, 0x073b, 0x0769, 0x073c, 0x076a, 0x073d, 0x076b, 0x073e, 
	0x076c, 0x073f, 0x076d, 0x0016, 0x055a, 0x0740, 0x0811, 0x0741, 
	0x0812, 0x0742, 0x0813, 0x0743, 0x0814, 0x0744, 0x0815, 0x0745, 
	0x0816, 0x0746, 0x0817, 0x0747, 0x0818, 0x074c, 0x0819, 0x074d, 
	0x081a, 0x074a, 0x081b, 0x074b, 0x081c, 0x0748, 0x081d, 0x0749, 
	0x081e, 0x071c, 0x081f, 0x071d, 0x0820, 0x06e4, 0x0821, 0x06e5, 
	0x0822, 0x0724, 0x0821, 0x0725, 0x0823, 0x0738, 0x0821, 0x0739, 
	0x0824, 0x0004, 0x0578, 0x074e, 0x04a6, 0x074f, 0x077b, 0x0750, 
	0x077c, 0x0751, 0x077d, 0x0001, 0x06a1, 0x0051, 0x04a5, 0x06a2, 
	0x005c, 0x04a5, 0x06a3, 0x0064, 0x04a5, 0x06a4, 0x00cd, 0x04a5, 
	0x06a5, 0x0141, 0x04a5, 0x06a6, 0x0144, 0x04a5, 0x06a7, 0x01bd, 
	0x04a5, 0x06a8, 0x01bf, 0x04a5, 0x06b5, 0x01d9, 0x04a5, 0x06b6, 
	0x01dc, 0x04a5, 0x06b7, 0x01df, 0x04a5, 0x06b8, 0x01e1, 0x04a5, 
	0x06b9, 0x01e4, 0x04a5, 0x06ba, 0x01e7, 0x04a5, 0x06bd, 0x01ef, 
	0x04a5, 0x06c0, 0x01f7, 0x04a5, 0x06c1, 0x01fb, 0x04a5, 0x06c2, 
	0x01fe, 0x04a5, 0x0702, 0x03f1, 0x04a6, 0x070b, 0x0433, 0x0785, 
	0x0752, 0x058a, 0x04a3,      0, 0x0003, 0x0001, 0x06a0, 0x04a3, 
	0x069f, 0x04a3, 0x069e, 0x04a3, 0x0003, 0x01c9, 0x06a9, 0x04a5, 
	0x06aa, 0x04a5, 0x06ab, 0x04a5, 0x0003, 0x01cd, 0x06ac, 0x04a5, 
	0x06ad, 0x04a5, 0x06ae, 0x04a5, 0x0003, 0x01d1, 0x06af, 0x04a5, 
	0x06b0, 0x04a5, 0x06b1, 0x04a5, 0x0003, 0x01d5, 0x06b2, 0x04a5, 
	0x06b3, 0x04a5, 0x06b4, 0x04a5, 0x0002, 0x01eb, 0x06bb, 0x04a5, 
	0x06bc, 0x04a5, 0x0002, 0x01f3, 0x06be, 0x04a5, 0x06bf, 0x04a5, 
	0x001b, 0x02f4, 0x06c3, 0x06b0, 0x06c4, 0x06d1, 0x06c5, 0x06d1, 
	0x06c6, 0x06d1, 0x06c7, 0x06d1, 0x06c8, 0x06d1, 0x06c9, 0x06d1, 
	0x06ca, 0x06d1, 0x06cb, 0x06d1, 0x06cc, 0x06b0, 0x06cd, 0x06b0, 
	0x06ce, 0x06b0, 0x06cf, 0x06b0, 0x06d0, 0x06b0, 0x06d1, 0x06b0, 
	0x06d2, 0x06b0, 0x06d3, 0x06b0, 0x06d4, 0x06b0, 0x06d5, 0x06d2, 
	0x06d6, 0x06d3, 0x06d7, 0x06d4, 0x06d8, 0x06d5, 0x06d9, 0x06d6, 
	0x06da, 0x06d7, 0x06db, 0x06d8, 0x06dc, 0x06d9, 0x06dd, 0x06da, 
	0x0002, 0x0312, 0x06de, 0x0713, 0x06df, 0x0714, 0x0004, 0x0334, 
	0x06e0, 0x0715, 0x06e1, 0x0716, 0x06e2, 0x0717, 0x06e3, 0x0718, 
	0x0002, 0x033a, 0x06e4, 0x0719, 0x06e5, 0x071a, 0x0004, 0x0344, 
	0x06e6, 0x071b, 0x06e7, 0x071c, 0x06e8, 0x071d, 0x06e9, 0x071e, 
	0x0006, 0x034b, 0x06ea, 0x071f, 0x06eb, 0x0720, 0x06ec, 0x0721, 
	0x06ed, 0x0722, 0x06ee, 0x0723, 0x06ef, 0x0724, 0x0002, 0x035e, 
	0x06f0, 0x0725, 0x06f1, 0x0726, 0x0002, 0x0362, 0x06f2, 0x0727, 
	0x06f3, 0x0728, 0x0002, 0x0368, 0x06f4, 0x0786, 0x06f5, 0x0787, 
	0x0004, 0x036d, 0x0793, 0x04a6, 0x0794, 0x0825, 0x0795, 0x0826, 
	0x0796, 0x0827, 0x0002, 0x0379, 0x06f6, 0x072a, 0x06f7, 0x072b, 
	0x0002, 0x038a, 0x06f8, 0x072c, 0x06f9, 0x072d, 0x0004, 0x03b0, 
	0x06fa, 0x072e, 0x06fb, 0x072f, 0x06fc, 0x0730, 0x06fd, 0x0731, 
	0x0002, 0x03cd, 0x0700, 0x0788, 0x0701, 0x0789, 0x0002, 0x03d9, 
	0x06fe, 0x0732, 0x06ff, 0x0733, 0x0002, 0x03f5, 0x0705, 0x0738, 
	0x0706, 0x0739, 0x0002, 0x040d, 0x0704, 0x078a, 0x0703, 0x078b, 
	0x0002, 0x0413, 0x0707, 0x073a, 0x0708, 0x073b, 0x0002, 0x042e, 
	0x0709, 0x073c, 0x070a, 0x073d, 0x0004, 0x0440, 0x070c, 0x073e, 
	0x070d, 0x073f, 0x070e, 0x0740, 0x070f, 0x0741, 0x0004, 0x044b, 
	0x0797, 0x04a6, 0x0798, 0x0828, 0x0799, 0x0829, 0x079a, 0x082a, 
	0x0002, 0x045a, 0x0710, 0x0742, 0x0711, 0x0743, 0x0002, 0x0464, 
	0x0714, 0x0746, 0x0715, 0x0747, 0x0004, 0x046c, 0x0712, 0x04a6, 
	0x0713, 0x0806, 0x0716, 0x0748, 0x0717, 0x0749, 0x0002, 0x0475, 
	0x0718, 0x074a, 0x0719, 0x074b, 0x0004, 0x048d, 0x0724, 0x07b1, 
	0x0725, 0x07b2, 0x071a, 0x074c, 0x071b, 0x074d, 0x0002, 0x0493, 
	0x071c, 0x074e, 0x071d, 0x074f, 0x0004, 0x049b, 0x071e, 0x0750, 
	0x071f, 0x0751, 0x0720, 0x0752, 0x0721, 0x0753, 0x0002, 0x04a3, 
	0x0722, 0x0754, 0x0723, 0x0755, 0x0002, 0x04b6, 0x0726, 0x0757, 
	0x0727, 0x0758, 0x0002, 0x04d3, 0x0728, 0x0759, 0x0729, 0x075a, 
	0x0002, 0x04df, 0x072a, 0x075b, 0x072b, 0x075c, 0x0002, 0x04e5, 
	0x072c, 0x075d, 0x072d, 0x075e, 0x0002, 0x04ef, 0x072e, 0x078c, 
	0x072f, 0x078d, 0x0002, 0x0510, 0x0730, 0x0760, 0x0731, 0x0761, 
	0x0002, 0x0514, 0x0732, 0x0762, 0x0733, 0x0763, 0x0002, 0x0524, 
	0x0738, 0x07b4, 0x0739, 0x07b5, 0x0002, 0x052e, 0x0734, 0x0764, 
	0x0735, 0x0765, 0x0002, 0x053c, 0x0736, 0x0766, 0x0737, 0x0767, 
	0x0006, 0x0551, 0x073a, 0x04a6, 0x073b, 0x0769, 0x073c, 0x076a, 
	0x073d, 0x076b, 0x073e, 0x076c, 0x073f, 0x076d, 0x000e, 0x055a, 
	0x0740, 0x04a6, 0x0741, 0x076e, 0x0742, 0x076f, 0x0743, 0x0770, 
	0x0744, 0x0771, 0x0745, 0x0772, 0x0746, 0x0773, 0x0747, 0x0774, 
	0x0748, 0x0775, 0x0749, 0x0776, 0x074a, 0x0777, 0x074b, 0x0778, 
	0x074c, 0x0779, 0x074d, 0x077a, 0x0004, 0x0578, 0x074e, 0x04a6, 
	0x074f, 0x077b, 0x0750, 0x077c, 0x0751, 0x077d, 0x0005, 0x058a, 
	0x0752, 0x04a3, 0x0753, 0x04a6, 0x0754, 0x077e, 0x0755, 0x077f, 
	0x0756, 0x0780, 0x0004, 0x0595, 0x0757, 0x0781, 0x0758, 0x0782, 
	0x0759, 0x0783, 0x075a, 0x0784, 0x0001, 0x06a1, 0x0051, 0x04a5, 
	0x06a2, 0x005c, 0x04a5, 0x06a3, 0x0064, 0x04a5, 0x06a4, 0x00cd, 
	0x04a5, 0x06a5, 0x0141, 0x04a5, 0x06a6, 0x0144, 0x04a5, 0x06a7, 
	0x01bd, 0x04a5, 0x06a8, 0x01bf, 0x04a5, 0x06b5, 0x01d9, 0x04a5, 
	0x06b6, 0x01dc, 0x04a5, 0x06b7, 0x01df, 0x04a5, 0x06b8, 0x01e1, 
	0x04a5, 0x06b9, 0x01e4, 0x04a5, 0x06ba, 0x01e7, 0x04a5, 0x06bd, 
	0x01ef, 0x04a5, 0x06c0, 0x01f7, 0x04a5, 0x06c1, 0x01fb, 0x04a5, 
	0x06c2, 0x01fe, 0x04a5, 0x0702, 0x03f1, 0x04a6, 0x070b, 0x0433, 
	0x0785,      0, 0x7ffe, 0x7ffe, 0x7ffe, 0xfffe, 0x4000,      0, 
	0x4000, 0xfffe, 0x4000,      0, 0x4000, 0xc0b2, 0x4000,      0, 
	0x4000, 0xc0b4, 0x4000,      0, 0x4000, 0xc01f, 0x4000,      0, 
	0x4000, 0xc020, 0x4000,      0, 0x4000, 0xc021, 0x4000,      0, 
	0x4000, 0xc022, 0x4000,      0, 0x4000, 0xc023, 0x4000,      0, 
	0x4000, 0xc024, 0x4000,      0, 0x4000, 0xc025, 0x4000,      0, 
	0x4000, 0xc026, 0x4000,      0, 0x4000, 0xc027, 0x4000,      0, 
	0x4000, 0xc028, 0x4000,      0, 0x4000, 0xc029, 0x4000,      0, 
	0x4000, 0xc02a, 0x4000,      0, 0x4000, 0xc02b, 0x4000,      0, 
	0x4000, 0xc382, 0x4000,      0, 0x4000, 0xc02c, 0x4000,      0, 
	0x4000, 0xc02d, 0x4000,      0, 0x4000, 0xc383, 0x4000,      0, 
	0x4000, 0xc02e, 0x4000,      0, 0x4000, 0xc384, 0x4000,      0, 
	0x4000, 0xc385, 0x4000,      0, 0x4000, 0xc386, 0x4000,      0, 
	0x4000, 0xc02f, 0x4000,      0, 0x4000, 0xc030, 0x4000,      0, 
	0x4000, 0xc031, 0x4000,      0, 0x4000, 0xc032, 0x4000,      0, 
	0x4000, 0xc033, 0x4000,      0, 0x4000, 0xc387, 0x4000,      0, 
	0x4000, 0xc034, 0x4000,      0, 0x4000, 0xc035, 0x4000,      0, 
	0x4000, 0xc036, 0x4000,      0, 0x4000, 0xc037, 0x4000,      0, 
	0x4000, 0xc038, 0x4000,      0, 0x4000, 0xc039, 0x4000,      0, 
	0x4000, 0xc388, 0x4000,      0, 0x4000, 0xc03a, 0x4000,      0, 
	0x4000, 0xc03b, 0x4096, 0x000e, 0x4379, 0xc000, 0x401f, 0x000e, 
	0x4379, 0xc000, 0x4020, 0x000e, 0x4379, 0xc000, 0x4021, 0x000e, 
	0x4379, 0xc000, 0x4022, 0x000e, 0x4379, 0xc000, 0x4023, 0x000e, 
	0x4379, 0xc000, 0x4024, 0x000e, 0x4379, 0xc000, 0x4025, 0x000e, 
	0x4379, 0xc000, 0x4026, 0x000e, 0x4379, 0xc000, 0x4027, 0x000e, 
	0x4379, 0xc000, 0x4028, 0x000e, 0x4379, 0xc000, 0x401f, 0x0011, 
	0x4379, 0xc000, 0x401f, 0x0380, 0x4379, 0xc000, 0x401f, 0x0381, 
	0x4379, 0xc000, 0x401f, 0x0013, 0x4379, 0xc000, 0x401f, 0x0015, 
	0x4379, 0xc000, 0x401f, 0x0012, 0x4379, 0xc000, 0x401f, 0x0014, 
	0x4379, 0xc000, 0x401f, 0x000e, 0x4008, 0xc000, 0x4020, 0x000e, 
	0x4008, 0xc000, 0x4021, 0x000e, 0x4008, 0xc000, 0x4022, 0x000e, 
	0x4008, 0xc000, 0x4023, 0x000e, 0x4008, 0xc000, 0x4024, 0x000e, 
	0x4008, 0xc000, 0x4025, 0x000e, 0x4008, 0xc000, 0x4026, 0x000e, 
	0x4008, 0xc000, 0x4027, 0x000e, 0x4008, 0xc000, 0x4028, 0x000e, 
	0x4008, 0xc000, 0x4029, 0x000e, 0x4379, 0xc000, 0x4029, 0x000f, 
	0x4008, 0xc000, 0x4029, 0x001a, 0x4379, 0xc000, 0x4029, 0x001b, 
	0x4379, 0xc000, 0x402a, 0x000e, 0x4379, 0xc000, 0x402b, 0x000e, 
	0x4379, 0xc000, 0x4382, 0x000e, 0x4379, 0xc000, 0x4382, 0x0012, 
	0x4379, 0xc000, 0x402c, 0x000e, 0x4379, 0xc000, 0x402c, 0x0010, 
	0x4379, 0xc000, 0x402c, 0x0011, 0x4379, 0xc000, 0x402c, 0x0381, 
	0x4379, 0xc000, 0x402c, 0x0014, 0x4379, 0xc000, 0x402c, 0x0012, 
	0x4379, 0xc000, 0x402c, 0x0017, 0x4379, 0xc000, 0x402c, 0x001a, 
	0x4379, 0xc000, 0x402c, 0x001b, 0x4379, 0xc000, 0x402d, 0x000e, 
	0x4379, 0xc000, 0x4383, 0x000e, 0x4379, 0xc000, 0x4383, 0x0019, 
	0x4379, 0xc000, 0x402e, 0x000e, 0x4379, 0xc000, 0x4384, 0x0010, 
	0x4379, 0xc000, 0x4384, 0x0011, 0x4379, 0xc000, 0x4384, 0x0014, 
	0x4379, 0xc000, 0x4384, 0x0016, 0x4379, 0xc000, 0x4384, 0x001a, 
	0x4379, 0xc000, 0x4384, 0x001b, 0x4379, 0xc000, 0x4659, 0x065c, 
	0x465f, 0xc000, 0x4385, 0x000e, 0x4379, 0xc000, 0x4386, 0x000e, 
	0x4379, 0xc000, 0x4386, 0x000f, 0x4379, 0xc000, 0x4386, 0x0019, 
	0x4379, 0xc000, 0x402f, 0x000e, 0x4379, 0xc000, 0x402f, 0x0010, 
	0x4379, 0xc000, 0x402f, 0x0012, 0x4379, 0xc000, 0x402f, 0x0018, 
	0x4379, 0xc000, 0x402f, 0x0019, 0x4379, 0xc000, 0x402f, 0x0017, 
	0x4379, 0xc000, 0x4030, 0x000e, 0x4379, 0xc000, 0x4031, 0x000e, 
	0x4379, 0xc000, 0x4031, 0x000f, 0x4379, 0xc000, 0x4031, 0x0010, 
	0x4379, 0xc000, 0x4031, 0x0012, 0x4379, 0xc000, 0x4031, 0x0019, 
	0x4379, 0xc000, 0x4032, 0x000e, 0x4379, 0xc000, 0x4032, 0x000f, 
	0x4008, 0xc000, 0x4032, 0x0010, 0x4379, 0xc000, 0x4032, 0x0011, 
	0x4379, 0xc000, 0x4032, 0x0381, 0x4379, 0xc000, 0x4032, 0x0016, 
	0x4379, 0xc000, 0x4032, 0x001b, 0x4379, 0xc000, 0x4662, 0x065c, 
	0x465f, 0xc000, 0x4033, 0x000e, 0x4379, 0xc000, 0x4387, 0x000e, 
	0x4379, 0xc000, 0x4034, 0x000e, 0x4379, 0xc000, 0x4034, 0x0010, 
	0x4379, 0xc000, 0x4034, 0x0012, 0x4379, 0xc000, 0x4034, 0x0019, 
	0x4379, 0xc000, 0x4035, 0x000e, 0x4379, 0xc000, 0x4035, 0x0010, 
	0x4379, 0xc000, 0x4036, 0x000e, 0x4379, 0xc000, 0x4036, 0x0012, 
	0x4379, 0xc000, 0x4036, 0x0018, 0x4379, 0xc000, 0x4037, 0x000e, 
	0x4379, 0xc000, 0x4037, 0x0010, 0x4379, 0xc000, 0x4037, 0x0011, 
	0x4379, 0xc000, 0x4037, 0x0381, 0x4379, 0xc000, 0x4037, 0x0013, 
	0x4379, 0xc000, 0x4037, 0x0016, 0x4379, 0xc000, 0x4037, 0x001a, 
	0x4379, 0xc000, 0x4037, 0x001b, 0x4379, 0xc000, 0x4038, 0x000e, 
	0x4379, 0xc000, 0x4039, 0x0381, 0x4379, 0xc000, 0x4388, 0x000e, 
	0x4379, 0xc000, 0x403a, 0x000e, 0x4379, 0xc000, 0x403a, 0x0010, 
	0x4379, 0xc000, 0x403a, 0x0014, 0x4379, 0xc000, 0x403a, 0x0381, 
	0x4379, 0xc000, 0x403b, 0x000e, 0x4379, 0xc000, 0x403b, 0x0010, 
	0x4379, 0xc000, 0x403c, 0x000e, 0x4379, 0xc000, 0x4029, 0x000e, 
	0x4009, 0xc000, 0x4029, 0x001a, 0x4009, 0xc000, 0x4029, 0x001b, 
	0x4009, 0xc000, 0x402a, 0x000e, 0x4009, 0xc000, 0x402b, 0x000e, 
	0x4009, 0xc000, 0x4382, 0x000e, 0x4009, 0xc000, 0x4382, 0x0012, 
	0x4009, 0xc000, 0x402c, 0x000e, 0x4009, 0xc000, 0x402c, 0x0010, 
	0x4009, 0xc000, 0x402c, 0x0011, 0x4009, 0xc000, 0x402c, 0x0381, 
	0x4009, 0xc000, 0x402c, 0x0014, 0x4009, 0xc000, 0x402c, 0x0012, 
	0x4009, 0xc000, 0x402c, 0x0017, 0x4009, 0xc000, 0x402c, 0x001a, 
	0x4009, 0xc000, 0x402c, 0x001b, 0x4009, 0xc000, 0x402d, 0x000e, 
	0x4009, 0xc000, 0x4383, 0x000e, 0x4009, 0xc000, 0x4383, 0x0019, 
	0x4009, 0xc000, 0x402e, 0x000e, 0x4009, 0xc000, 0x4384, 0x0010, 
	0x4009, 0xc000, 0x4384, 0x0011, 0x4009, 0xc000, 0x4384, 0x0014, 
	0x4009, 0xc000, 0x4384, 0x0016, 0x4009, 0xc000, 0x4384, 0x001a, 
	0x4009, 0xc000, 0x4384, 0x001b, 0x4009, 0xc000, 0x4659, 0x065c, 
	0x4665, 0xc000, 0x4385, 0x000e, 0x4009, 0xc000, 0x4386, 0x000e, 
	0x4009, 0xc000, 0x4386, 0x0019, 0x4009, 0xc000, 0x402f, 0x000e, 
	0x4009, 0xc000, 0x402f, 0x0010, 0x4009, 0xc000, 0x402f, 0x0012, 
	0x4009, 0xc000, 0x402f, 0x0018, 0x4009, 0xc000, 0x402f, 0x0019, 
	0x4009, 0xc000, 0x402f, 0x0017, 0x4009, 0xc000, 0x4030, 0x000e, 
	0x4009, 0xc000, 0x4031, 0x000e, 0x4009, 0xc000, 0x4031, 0x0010, 
	0x4009, 0xc000, 0x4031, 0x0012, 0x4009, 0xc000, 0x4031, 0x0019, 
	0x4009, 0xc000, 0x4032, 0x000e, 0x4009, 0xc000, 0x4032, 0x0010, 
	0x4009, 0xc000, 0x4032, 0x0011, 0x4009, 0xc000, 0x4032, 0x0381, 
	0x4009, 0xc000, 0x4032, 0x0016, 0x4009, 0xc000, 0x4032, 0x001b, 
	0x4009, 0xc000, 0x4662, 0x065c, 0x4665, 0xc000, 0x4033, 0x000e, 
	0x4009, 0xc000, 0x4387, 0x000e, 0x4009, 0xc000, 0x4034, 0x000e, 
	0x4009, 0xc000, 0x4034, 0x0010, 0x4009, 0xc000, 0x4034, 0x0012, 
	0x4009, 0xc000, 0x4034, 0x0019, 0x4009, 0xc000, 0x4035, 0x000e, 
	0x4009, 0xc000, 0x4035, 0x0010, 0x4009, 0xc000, 0x4036, 0x000e, 
	0x4009, 0xc000, 0x4036, 0x0012, 0x4009, 0xc000, 0x4036, 0x0018, 
	0x4009, 0xc000, 0x4037, 0x000e, 0x4009, 0xc000, 0x4037, 0x0010, 
	0x4009, 0xc000, 0x4037, 0x0011, 0x4009, 0xc000, 0x4037, 0x0381, 
	0x4009, 0xc000, 0x4037, 0x0013, 0x4009, 0xc000, 0x4037, 0x0016, 
	0x4009, 0xc000, 0x4037, 0x001a, 0x4009, 0xc000, 0x4037, 0x001b, 
	0x4009, 0xc000, 0x4038, 0x000e, 0x4009, 0xc000, 0x4039, 0x0381, 
	0x4009, 0xc000, 0x4388, 0x000e, 0x4009, 0xc000, 0x403a, 0x000e, 
	0x4009, 0xc000, 0x403a, 0x0010, 0x4009, 0xc000, 0x403a, 0x0381, 
	0x4009, 0xc000, 0x403a, 0x0014, 0x4009, 0xc000, 0x403b, 0x000e, 
	0x4009, 0xc000, 0x403b, 0x0010, 0x4009, 0xc000, 0x403c, 0x000e, 
	0x4009, 0xc000, 0x403d, 0x400e, 0x4379, 0xc000, 0x403e, 0x400e, 
	0x4379, 0xc000, 0x4040, 0x400e, 0x4379, 0xc000, 0x4041, 0x400e, 
	0x4379, 0xc000, 0x4042, 0x400e, 0x4379, 0xc000, 0x4043, 0x400e, 
	0x4379, 0xc000, 0x4044, 0x400e, 0x4379, 0xc000, 0x4045, 0x400e, 
	0x4379, 0xc000, 0x4046, 0x400e, 0x4379, 0xc000, 0x4047, 0x400e, 
	0x4379, 0xc000, 0x4048, 0x400e, 0x4379, 0xc000, 0x4049, 0x400e, 
	0x4379, 0xc000, 0x404a, 0x400e, 0x4379, 0xc000, 0x404b, 0x400e, 
	0x4379, 0xc000, 0x404c, 0x400e, 0x4379, 0xc000, 0x404d, 0x400e, 
	0x4379, 0xc000, 0x404e, 0x400e, 0x4379, 0xc000, 0x404f, 0x400e, 
	0x4379, 0xc000, 0x4050, 0x400e, 0x4379, 0xc000, 0x4051, 0x400e, 
	0x4379, 0xc000, 0x4052, 0x400e, 0x4379, 0xc000, 0x4053, 0x400e, 
	0x4379, 0xc000, 0x4054, 0x400e, 0x4379, 0xc000, 0x4055, 0x400e, 
	0x4379, 0xc000, 0x4056, 0x400e, 0x4379, 0xc000, 0x4057, 0x400e, 
	0x4379, 0xc000, 0x405a, 0x400e, 0x4379, 0xc000, 0x405b, 0x400e, 
	0x4379, 0xc000, 0x405c, 0x400e, 0x4379, 0xc000, 0x405d, 0x400e, 
	0x4379, 0xc000, 0x405e, 0x400e, 0x4379, 0xc000, 0x4060, 0x400e, 
	0x4379, 0xc000, 0x4062, 0x437e, 0x4379, 0xc000, 0x4062, 0x400e, 
	0x4379, 0xc000, 0x003d, 0x000e, 0x0003, 0xc000, 0x003d, 0x000e, 
	0x0004, 0xc000, 0x003d, 0x000e, 0x0005, 0xc000, 0x003d, 0x000e, 
	0x0006, 0xc000, 0x003e, 0x000e, 0x0003, 0xc000, 0x003e, 0x000e, 
	0x0004, 0xc000, 0x003e, 0x000e, 0x0005, 0xc000, 0x003e, 0x000e, 
	0x0006, 0xc000, 0x0040, 0x000e, 0x0003, 0xc000, 0x0040, 0x000e, 
	0x0004, 0xc000, 0x0040, 0x000e, 0x0005, 0xc000, 0x0040, 0x000e, 
	0x0006, 0xc000, 0x0041, 0x000e, 0x0003, 0xc000, 0x0041, 0x000e, 
	0x0004, 0xc000, 0x0041, 0x000e, 0x0005, 0xc000, 0x0041, 0x000e, 
	0x0006, 0xc000, 0x0042, 0x000e, 0x0003, 0xc000, 0x0042, 0x000e, 
	0x0004, 0xc000, 0x0042, 0x000e, 0x0005, 0xc000, 0x0042, 0x000e, 
	0x0006, 0xc000, 0x0043, 0x000e, 0x0003, 0xc000, 0x0043, 0x000e, 
	0x0004, 0xc000, 0x0043, 0x000e, 0x0005, 0xc000, 0x0043, 0x000e, 
	0x0006, 0xc000, 0x0044, 0x000e, 0x0003, 0xc000, 0x0044, 0x000e, 
	0x0004, 0xc000, 0x0044, 0x000e, 0x0005, 0xc000, 0x0044, 0x000e, 
	0x0006, 0xc000, 0x0045, 0x000e, 0x0003, 0xc000, 0x0045, 0x000e, 
	0x0004, 0xc000, 0x0045, 0x000e, 0x0005, 0xc000, 0x0045, 0x000e, 
	0x0006, 0xc000, 0x0046, 0x000e, 0x0003, 0xc000, 0x0046, 0x000e, 
	0x0004, 0xc000, 0x0046, 0x000e, 0x0005, 0xc000, 0x0046, 0x000e, 
	0x0006, 0xc000, 0x0047, 0x000e, 0x0003, 0xc000, 0x0047, 0x000e, 
	0x0004, 0xc000, 0x0048, 0x000e, 0x0003, 0xc000, 0x0048, 0x000e, 
	0x0004, 0xc000, 0x0049, 0x000e, 0x0003, 0xc000, 0x0049, 0x000e, 
	0x0004, 0xc000, 0x004a, 0x000e, 0x0003, 0xc000, 0x004a, 0x000e, 
	0x0004, 0xc000, 0x004b, 0x000e, 0x0003, 0xc000, 0x004b, 0x000e, 
	0x0004, 0xc000, 0x004c, 0x000e, 0x0003, 0xc000, 0x004c, 0x000e, 
	0x0004, 0xc000, 0x004d, 0x000e, 0x0003, 0xc000, 0x004d, 0x000e, 
	0x0004, 0xc000, 0x004e, 0x000e, 0x0003, 0xc000, 0x004e, 0x000e, 
	0x0004, 0xc000, 0x004e, 0x000e, 0x0005, 0xc000, 0x004e, 0x000e, 
	0x0006, 0xc000, 0x004f, 0x000e, 0x0003, 0xc000, 0x004f, 0x000e, 
	0x0004, 0xc000, 0x004f, 0x000e, 0x0005, 0xc000, 0x004f, 0x000e, 
	0x0006, 0xc000, 0x0050, 0x000e, 0x0003, 0xc000, 0x0050, 0x000e, 
	0x0004, 0xc000, 0x0050, 0x000e, 0x0005, 0xc000, 0x0050, 0x000e, 
	0x0006, 0xc000, 0x0051, 0x000e, 0x0003, 0xc000, 0x0051, 0x000e, 
	0x0004, 0xc000, 0x0051, 0x000e, 0x0005, 0xc000, 0x0051, 0x000e, 
	0x0006, 0xc000, 0x0052, 0x000e, 0x0003, 0xc000, 0x0052, 0x000e, 
	0x0004, 0xc000, 0x0052, 0x000e, 0x0005, 0xc000, 0x0052, 0x000e, 
	0x0006, 0xc000, 0x0053, 0x000e, 0x0003, 0xc000, 0x0053, 0x000e, 
	0x0004, 0xc000, 0x0053, 0x000e, 0x0005, 0xc000, 0x0053, 0x000e, 
	0x0006, 0xc000, 0x0054, 0x000e, 0x0003, 0xc000, 0x0054, 0x000e, 
	0x0004, 0xc000, 0x0054, 0x000e, 0x0005, 0xc000, 0x0054, 0x000e, 
	0x0006, 0xc000, 0x0055, 0x000e, 0x0003, 0xc000, 0x0055, 0x000e, 
	0x0004, 0xc000, 0x0055, 0x000e, 0x0005, 0xc000, 0x0055, 0x000e, 
	0x0006, 0xc000, 0x0056, 0x000e, 0x0003, 0xc000, 0x0056, 0x000e, 
	0x0004, 0xc000, 0x0056, 0x000e, 0x0005, 0xc000, 0x0056, 0x000e, 
	0x0006, 0xc000, 0x0057, 0x000e, 0x0003, 0xc000, 0x0057, 0x000e, 
	0x0004, 0xc000, 0x0057, 0x000e, 0x0005, 0xc000, 0x0057, 0x000e, 
	0x0006, 0xc000, 0x005a, 0x000e, 0x0003, 0xc000, 0x005a, 0x000e, 
	0x0004, 0xc000, 0x005a, 0x000e, 0x0005, 0xc000, 0x005a, 0x000e, 
	0x0006, 0xc000, 0x005b, 0x000e, 0x0003, 0xc000, 0x005b, 0x000e, 
	0x0004, 0xc000, 0x005b, 0x000e, 0x0005, 0xc000, 0x005b, 0x000e, 
	0x0006, 0xc000, 0x005c, 0x000e, 0x0003, 0xc000, 0x005c, 0x000e, 
	0x0004, 0xc000, 0x005c, 0x000e, 0x0005, 0xc000, 0x005c, 0x000e, 
	0x0006, 0xc000, 0x005d, 0x000e, 0x0003, 0xc000, 0x005d, 0x000e, 
	0x0004, 0xc000, 0x005d, 0x000e, 0x0005, 0xc000, 0x005d, 0x000e, 
	0x0006, 0xc000, 0x005e, 0x000e, 0x0003, 0xc000, 0x005e, 0x000e, 
	0x0004, 0xc000, 0x0060, 0x000e, 0x0003, 0xc000, 0x0060, 0x000e, 
	0x0004, 0xc000, 0x0668, 0x066b, 0x066e, 0xc000, 0x0668, 0x066b, 
	0x0671, 0xc000, 0x0668, 0x066b, 0x0674, 0xc000, 0x0668, 0x066b, 
	0x0677, 0xc000, 0x0062, 0x037e, 0x0003, 0xc000, 0x0062, 0x037e, 
	0x0004, 0xc000, 0x0062, 0x000e, 0x0003, 0xc000, 0x0062, 0x000e, 
	0x0004, 0xc000, 0x4063, 0x400e, 0x4000, 0xc000, 0x4064, 0x400e, 
	0x4000, 0xc000, 0x4065, 0x400e, 0x4000, 0xc000, 0x4066, 0x400e, 
	0x4000, 0xc000, 0x4067, 0x400e, 0x4000, 0xc000, 0x4068, 0x400e, 
	0x4000, 0xc000, 0x4069, 0x400e, 0x4000, 0xc000, 0x406a, 0x400e, 
	0x4000, 0xc000, 0x406b, 0x400e, 0x4000, 0xc000, 0x406c, 0x400e, 
	0x4000, 0xc000, 0x406d, 0x400e, 0x4000, 0xc000, 0x406e, 0x400e, 
	0x4000, 0xc000, 0x406f, 0x400e, 0x4000, 0xc000, 0x4070, 0x400e, 
	0x4000, 0xc000, 0x4071, 0x400e, 0x4000, 0xc000, 0x4072, 0x400e, 
	0x4000, 0xc000, 0x4073, 0x400e, 0x4000, 0xc000, 0x4074, 0x400e, 
	0x4000, 0xc000, 0x4075, 0x400e, 0x4000, 0xc000, 0x4076, 0x400e, 
	0x4000, 0xc000, 0x4077, 0x400e, 0x4000, 0xc000, 0x4078, 0x400e, 
	0x4000, 0xc000, 0x4079, 0x400e, 0x4000, 0xc000, 0x407a, 0x400e, 
	0x4000, 0xc000, 0x407b, 0x400e, 0x4000, 0xc000, 0x407c, 0x400e, 
	0x4000, 0xc000, 0x407d, 0x400e, 0x4000, 0xc000, 0x407e, 0x000e, 
	0x4009, 0xc000, 0x407e, 0x001c, 0x4009, 0xc000, 0x407f, 0x000e, 
	0x4009, 0xc000, 0x4080, 0x000e, 0x4009, 0xc000, 0x4080, 0x000f, 
	0x4009, 0xc000, 0x4081, 0x000e, 0x4009, 0xc000, 0x4081, 0x000f, 
	0x4009, 0xc000, 0x4082, 0x000e, 0x4009, 0xc000, 0x4082, 0x001c, 
	0x4009, 0xc000, 0x4083, 0x000e, 0x4009, 0xc000, 0x4083, 0x000f, 
	0x4009, 0xc000, 0x4084, 0x000e, 0x4009, 0xc000, 0x4084, 0x001c, 
	0x4009, 0xc000, 0x4085, 0x000e, 0x4009, 0xc000, 0x4086, 0x000e, 
	0x4009, 0xc000, 0x4086, 0x001c, 0x4009, 0xc000, 0x4086, 0x001d, 
	0x4009, 0xc000, 0x4087, 0x000e, 0x4009, 0xc000, 0x4087, 0x000f, 
	0x4009, 0xc000, 0x4087, 0x037f, 0x4009, 0xc000, 0x4088, 0x000e, 
	0x4009, 0xc000, 0x4089, 0x000e, 0x4009, 0xc000, 0x408a, 0x000e, 
	0x4009, 0xc000, 0x408b, 0x000e, 0x4009, 0xc000, 0x408c, 0x000e, 
	0x4009, 0xc000, 0x408c, 0x001c, 0x4009, 0xc000, 0x408d, 0x000e, 
	0x4009, 0xc000, 0x408e, 0x000e, 0x4009, 0xc000, 0x408f, 0x000e, 
	0x4009, 0xc000, 0x408f, 0x000f, 0x4009, 0xc000, 0x408f, 0x037f, 
	0x4009, 0xc000, 0x4090, 0x000e, 0x4009, 0xc000, 0x4090, 0x000f, 
	0x4009, 0xc000, 0x4091, 0x000e, 0x4009, 0xc000, 0x4091, 0x001c, 
	0x4009, 0xc000, 0x4091, 0x001d, 0x4009, 0xc000, 0x4091, 0x001e, 
	0x4009, 0xc000, 0x4091, 0x001a, 0x4009, 0xc000, 0x4091, 0x001b, 
	0x4009, 0xc000, 0x4092, 0x000e, 0x4009, 0xc000, 0x4092, 0x037f, 
	0x4009, 0xc000, 0x4093, 0x000e, 0x4009, 0xc000, 0x4093, 0x000f, 
	0x4009, 0xc000, 0x4094, 0x000e, 0x4009, 0xc000, 0x4094, 0x000f, 
	0x4009, 0xc000, 0x4095, 0x000e, 0x4009, 0xc000, 0x4095, 0x001c, 
	0x4009, 0xc000, 0x407e, 0x000e, 0x400c, 0xc000, 0x407e, 0x001c, 
	0x400c, 0xc000, 0x407f, 0x000e, 0x400c, 0xc000, 0x407f, 0x000f, 
	0x400c, 0xc000, 0x4080, 0x000e, 0x400c, 0xc000, 0x4081, 0x000e, 
	0x400c, 0xc000, 0x4082, 0x000e, 0x400c, 0xc000, 0x4082, 0x001c, 
	0x400c, 0xc000, 0x4083, 0x000e, 0x400c, 0xc000, 0x4083, 0x000f, 
	0x400c, 0xc000, 0x4084, 0x000e, 0x400c, 0xc000, 0x4084, 0x001c, 
	0x400c, 0xc000, 0x4085, 0x000e, 0x400c, 0xc000, 0x4085, 0x000f, 
	0x400c, 0xc000, 0x4086, 0x000e, 0x400c, 0xc000, 0x4086, 0x001c, 
	0x400c, 0xc000, 0x4086, 0x001d, 0x400c, 0xc000, 0x4086, 0x001e, 
	0x400c, 0xc000, 0x4086, 0x001a, 0x400c, 0xc000, 0x4087, 0x000e, 
	0x400c, 0xc000, 0x4087, 0x000f, 0x400c, 0xc000, 0x4087, 0x037f, 
	0x400c, 0xc000, 0x4088, 0x000e, 0x400c, 0xc000, 0x4089, 0x000e, 
	0x400c, 0xc000, 0x408a, 0x000e, 0x400c, 0xc000, 0x408b, 0x000e, 
	0x400c, 0xc000, 0x408c, 0x000e, 0x400c, 0xc000, 0x408c, 0x001c, 
	0x400c, 0xc000, 0x408d, 0x000e, 0x400c, 0xc000, 0x408d, 0x000f, 
	0x400c, 0xc000, 0x408e, 0x000f, 0x400c, 0xc000, 0x408f, 0x000e, 
	0x400c, 0xc000, 0x408f, 0x000f, 0x400c, 0xc000, 0x408f, 0x037f, 
	0x400c, 0xc000, 0x408f, 0x001a, 0x400c, 0xc000, 0x4090, 0x000e, 
	0x400c, 0xc000, 0x4090, 0x000f, 0x400c, 0xc000, 0x4091, 0x000e, 
	0x400c, 0xc000, 0x4091, 0x001c, 0x400c, 0xc000, 0x4091, 0x001d, 
	0x400c, 0xc000, 0x4091, 0x001e, 0x400c, 0xc000, 0x4092, 0x000e, 
	0x400c, 0xc000, 0x4092, 0x000f, 0x400c, 0xc000, 0x4092, 0x037f, 
	0x400c, 0xc000, 0x4093, 0x000e, 0x400c, 0xc000, 0x4094, 0x000e, 
	0x400c, 0xc000, 0x4094, 0x000f, 0x400c, 0xc000, 0x4095, 0x000e, 
	0x400c, 0xc000, 0x4095, 0x001c, 0x400c, 0xc000, 0x438c, 0x400e, 
	0x4379, 0xc000, 0x438d, 0x400e, 0x4379, 0xc000, 0x438e, 0x400e, 
	0x4379, 0xc000, 0x438f, 0x400e, 0x4379, 0xc000, 0x4390, 0x400e, 
	0x4379, 0xc000, 0x4393, 0x400e, 0x4379, 0xc000, 0x4396, 0x400e, 
	0x4379, 0xc000, 0x4397, 0x400e, 0x4379, 0xc000, 0x4399, 0x400e, 
	0x4379, 0xc000, 0x439c, 0x400e, 0x4379, 0xc000, 0x439d, 0x400e, 
	0x4379, 0xc000, 0x439e, 0x400e, 0x4379, 0xc000, 0x439f, 0x400e, 
	0x4379, 0xc000, 0x43a1, 0x400e, 0x4379, 0xc000, 0x43a2, 0x400e, 
	0x4379, 0xc000, 0x43a4, 0x400e, 0x4379, 0xc000, 0x43a5, 0x400e, 
	0x4379, 0xc000, 0x43a6, 0x400e, 0x4379, 0xc000, 0x43a7, 0x400e, 
	0x4379, 0xc000, 0x43a8, 0x400e, 0x4379, 0xc000, 0x43ab, 0x400e, 
	0x4379, 0xc000, 0x43ad, 0x400e, 0x4379, 0xc000, 0x43ae, 0x400e, 
	0x4379, 0xc000, 0x43af, 0x400e, 0x4379, 0xc000, 0x43b0, 0x400e, 
	0x4379, 0xc000, 0x43b2, 0x400e, 0x4379, 0xc000, 0x43b3, 0x400e, 
	0x4379, 0xc000, 0x43b4, 0x400e, 0x4379, 0xc000, 0x43b6, 0x400e, 
	0x4379, 0xc000, 0x43b8, 0x400e, 0x4379, 0xc000, 0x43b9, 0x400e, 
	0x4379, 0xc000, 0x438c, 0x400e, 0x4009, 0xc000, 0x438d, 0x400e, 
	0x4009, 0xc000, 0x438e, 0x400e, 0x4009, 0xc000, 0x438f, 0x400e, 
	0x4009, 0xc000, 0x4390, 0x400e, 0x4009, 0xc000, 0x4393, 0x400e, 
	0x4009, 0xc000, 0x4396, 0x400e, 0x4009, 0xc000, 0x4397, 0x400e, 
	0x4009, 0xc000, 0x4399, 0x400e, 0x4009, 0xc000, 0x439c, 0x400e, 
	0x4009, 0xc000, 0x439e, 0x400e, 0x4009, 0xc000, 0x439f, 0x400e, 
	0x4009, 0xc000, 0x43a1, 0x400e, 0x4009, 0xc000, 0x43a2, 0x400e, 
	0x4009, 0xc000, 0x43a4, 0x400e, 0x4009, 0xc000, 0x43a5, 0x400e, 
	0x4009, 0xc000, 0x43a6, 0x400e, 0x4009, 0xc000, 0x43a7, 0x400e, 
	0x4009, 0xc000, 0x43a8, 0x400e, 0x4009, 0xc000, 0x43ab, 0x400e, 
	0x4009, 0xc000, 0x43ad, 0x400e, 0x4009, 0xc000, 0x43ae, 0x400e, 
	0x4009, 0xc000, 0x43af, 0x400e, 0x4009, 0xc000, 0x43b0, 0x400e, 
	0x4009, 0xc000, 0x43b2, 0x400e, 0x4009, 0xc000, 0x43b3, 0x400e, 
	0x4009, 0xc000, 0x43b4, 0x400e, 0x4009, 0xc000, 0x43b6, 0x400e, 
	0x4009, 0xc000, 0x43b8, 0x400e, 0x4009, 0xc000, 0x43b9, 0x400e, 
	0x4009, 0xc000, 0x4029, 0x0010, 0x4379, 0xc000, 0x4029, 0x0011, 
	0x4379, 0xc000, 0x4029, 0x0381, 0x4379, 0xc000, 0x4029, 0x0016, 
	0x4379, 0xc000, 0x4029, 0x0014, 0x4379, 0xc000, 0x4029, 0x0013, 
	0x4379, 0xc000, 0x4029, 0x0380, 0x4379, 0xc000, 0x467a, 0x065c, 
	0x465f, 0xc000, 0x402b, 0x0019, 0x4379, 0xc000, 0x402b, 0x0010, 
	0x4379, 0xc000, 0x402b, 0x0381, 0x4379, 0xc000, 0x402b, 0x0012, 
	0x4379, 0xc000, 0x402b, 0x0017, 0x4379, 0xc000, 0x4382, 0x000f, 
	0x4379, 0xc000, 0x4382, 0x0018, 0x4379, 0xc000, 0x4383, 0x0380, 
	0x4379, 0xc000, 0x4383, 0x0381, 0x4379, 0xc000, 0x4383, 0x0017, 
	0x4379, 0xc000, 0x402e, 0x0381, 0x4379, 0xc000, 0x402e, 0x0018, 
	0x4379, 0xc000, 0x4384, 0x000e, 0x4379, 0xc000, 0x4384, 0x0381, 
	0x4379, 0xc000, 0x4384, 0x000f, 0x4379, 0xc000, 0x4385, 0x0381, 
	0x4379, 0xc000, 0x4031, 0x0016, 0x4379, 0xc000, 0x467d, 0x065c, 
	0x465f, 0xc000, 0x4032, 0x0014, 0x4379, 0xc000, 0x4032, 0x0018, 
	0x4379, 0xc000, 0x4032, 0x0015, 0x4379, 0xc000, 0x4035, 0x0381, 
	0x4379, 0xc000, 0x4035, 0x0012, 0x4379, 0xc000, 0x4035, 0x0019, 
	0x4379, 0xc000, 0x4680, 0x065c, 0x465f, 0xc000, 0x4036, 0x0019, 
	0x4379, 0xc000, 0x4037, 0x0014, 0x4379, 0xc000, 0x4037, 0x0380, 
	0x4379, 0xc000, 0x4037, 0x0015, 0x4379, 0xc000, 0x4039, 0x000e, 
	0x4379, 0xc000, 0x403b, 0x0012, 0x4379, 0xc000, 0x403b, 0x0017, 
	0x4379, 0xc000, 0x4029, 0x0010, 0x4009, 0xc000, 0x4029, 0x0011, 
	0x4009, 0xc000, 0x4029, 0x0381, 0x4009, 0xc000, 0x4029, 0x0016, 
	0x4009, 0xc000, 0x4029, 0x0014, 0x4009, 0xc000, 0x4029, 0x0013, 
	0x4009, 0xc000, 0x4029, 0x0380, 0x4009, 0xc000, 0x467a, 0x065c, 
	0x4665, 0xc000, 0x402b, 0x0019, 0x4009, 0xc000, 0x402b, 0x0010, 
	0x4009, 0xc000, 0x402b, 0x0381, 0x4009, 0xc000, 0x402b, 0x0012, 
	0x4009, 0xc000, 0x402b, 0x0017, 0x4009, 0xc000, 0x4382, 0x000f, 
	0x4009, 0xc000, 0x4382, 0x0018, 0x4009, 0xc000, 0x4383, 0x0380, 
	0x4009, 0xc000, 0x4383, 0x0381, 0x4009, 0xc000, 0x4383, 0x0017, 
	0x4009, 0xc000, 0x402e, 0x0381, 0x4009, 0xc000, 0x402e, 0x0018, 
	0x4009, 0xc000, 0x4384, 0x000e, 0x4009, 0xc000, 0x4384, 0x0381, 
	0x4009, 0xc000, 0x4384, 0x000f, 0x4009, 0xc000, 0x4385, 0x0381, 
	0x4009, 0xc000, 0x4031, 0x0016, 0x4009, 0xc000, 0x467d, 0x065c, 
	0x4665, 0xc000, 0x4032, 0x0014, 0x4009, 0xc000, 0x4032, 0x0018, 
	0x4009, 0xc000, 0x4032, 0x0015, 0x4009, 0xc000, 0x4035, 0x0381, 
	0x4009, 0xc000, 0x4035, 0x0012, 0x4009, 0xc000, 0x4035, 0x0019, 
	0x4009, 0xc000, 0x4036, 0x0019, 0x4009, 0xc000, 0x4037, 0x0014, 
	0x4009, 0xc000, 0x4037, 0x0380, 0x4009, 0xc000, 0x4037, 0x0015, 
	0x4009, 0xc000, 0x4039, 0x000e, 0x4009, 0xc000, 0x403b, 0x0012, 
	0x4009, 0xc000, 0x403b, 0x0017, 0x4009, 0xc000, 0x401f, 0x400e, 
	0x4379, 0xc000, 0x401f, 0x400f, 0x4379, 0xc000, 0x4020, 0x400e, 
	0x4379, 0xc000, 0x4020, 0x400f, 0x4379, 0xc000, 0x4021, 0x400e, 
	0x4379, 0xc000, 0x4021, 0x400f, 0x4379, 0xc000, 0x4022, 0x400e, 
	0x4379, 0xc000, 0x4022, 0x400f, 0x4379, 0xc000, 0x4023, 0x400e, 
	0x4379, 0xc000, 0x4023, 0x400f, 0x4379, 0xc000, 0x4024, 0x400e, 
	0x4379, 0xc000, 0x4024, 0x400f, 0x4379, 0xc000, 0x4025, 0x400e, 
	0x4379, 0xc000, 0x4025, 0x400f, 0x4379, 0xc000, 0x4026, 0x400e, 
	0x4379, 0xc000, 0x4026, 0x400f, 0x4379, 0xc000, 0x4027, 0x400e, 
	0x4379, 0xc000, 0x4027, 0x400f, 0x4379, 0xc000, 0x4028, 0x400e, 
	0x4379, 0xc000, 0x4028, 0x400f, 0x4379, 0xc000, 0x4389, 0x400e, 
	0x4379, 0xc000, 0x438a, 0x400d, 0x4379, 0xc000, 0x438a, 0x437a, 
	0x4379, 0xc000, 0x438a, 0x437c, 0x4379, 0xc000, 0x438a, 0x400e, 
	0x4379, 0xc000, 0x403f, 0x400e, 0x4379, 0xc000, 0x4058, 0x400e, 
	0x4379, 0xc000, 0x4059, 0x400e, 0x4379, 0xc000, 0x438b, 0x400e, 
	0x4379, 0xc000, 0x405f, 0x400e, 0x4379, 0xc000, 0x4060, 0x437b, 
	0x4379, 0xc000, 0x4061, 0x400e, 0x4379, 0xc000, 0x4683, 0x4686, 
	0x465f, 0xc000, 0x4061, 0x437d, 0x4379, 0xc000, 0x0389, 0x000e, 
	0x0003, 0xc000, 0x038a, 0x000d, 0x0003, 0xc000, 0x038a, 0x000d, 
	0x0004, 0xc000, 0x038a, 0x037a, 0x0003, 0xc000, 0x038a, 0x037a, 
	0x0004, 0xc000, 0x038a, 0x037c, 0x0003, 0xc000, 0x038a, 0x037c, 
	0x0004, 0xc000, 0x038a, 0x000e, 0x0003, 0xc000, 0x038a, 0x000e, 
	0x0004, 0xc000, 0x003f, 0x000e, 0x0003, 0xc000, 0x003f, 0x000e, 
	0x0004, 0xc000, 0x0058, 0x000e, 0x0003, 0xc000, 0x0058, 0x000e, 
	0x0004, 0xc000, 0x0058, 0x000e, 0x0005, 0xc000, 0x0058, 0x000e, 
	0x0006, 0xc000, 0x0059, 0x000e, 0x0003, 0xc000, 0x0059, 0x000e, 
	0x0004, 0xc000, 0x0059, 0x000e, 0x0005, 0xc000, 0x0059, 0x000e, 
	0x0006, 0xc000, 0x038b, 0x000e, 0x0003, 0xc000, 0x038b, 0x000e, 
	0x0004, 0xc000, 0x038b, 0x000e, 0x0005, 0xc000, 0x038b, 0x000e, 
	0x0006, 0xc000, 0x005f, 0x000e, 0x0003, 0xc000, 0x005f, 0x000e, 
	0x0004, 0xc000, 0x0060, 0x037b, 0x0003, 0xc000, 0x0060, 0x037b, 
	0x0004, 0xc000, 0x0061, 0x000e, 0x0003, 0xc000, 0x0061, 0x000e, 
	0x0004, 0xc000, 0x0061, 0x037d, 0x0003, 0xc000, 0x0061, 0x037d, 
	0x0004, 0xc000, 0x0061, 0x037d, 0x0005, 0xc000, 0x0061, 0x037d, 
	0x0006, 0xc000, 0x0689, 0x068c, 0x068f, 0xc000, 0x0689, 0x068c, 
	0x0692, 0xc000, 0x0689, 0x0695, 0x068f, 0xc000, 0x0689, 0x0695, 
	0x0692, 0xc000, 0x0689, 0x0698, 0x068f, 0xc000, 0x0689, 0x0698, 
	0x0692, 0xc000, 0x0689, 0x066b, 0x068f, 0xc000, 0x0689, 0x066b, 
	0x0692, 0xc000, 0x4391, 0x400e, 0x4379, 0xc000, 0x4392, 0x400e, 
	0x4379, 0xc000, 0x4394, 0x400e, 0x4379, 0xc000, 0x4395, 0x400e, 
	0x4379, 0xc000, 0x4398, 0x400e, 0x4379, 0xc000, 0x439a, 0x400e, 
	0x4379, 0xc000, 0x439b, 0x400e, 0x4379, 0xc000, 0x43a0, 0x400e, 
	0x4379, 0xc000, 0x43a3, 0x400e, 0x4379, 0xc000, 0x43a9, 0x400e, 
	0x4379, 0xc000, 0x43aa, 0x400e, 0x4379, 0xc000, 0x43ac, 0x400e, 
	0x4379, 0xc000, 0x43b1, 0x400e, 0x4379, 0xc000, 0x43b5, 0x400e, 
	0x4379, 0xc000, 0x43b7, 0x400e, 0x4379, 0xc000, 0x4391, 0x400e, 
	0x4009, 0xc000, 0x4392, 0x400e, 0x4009, 0xc000, 0x4394, 0x400e, 
	0x4009, 0xc000, 0x4395, 0x400e, 0x4009, 0xc000, 0x4398, 0x400e, 
	0x4009, 0xc000, 0x439a, 0x400e, 0x4009, 0xc000, 0x439b, 0x400e, 
	0x4009, 0xc000, 0x439d, 0x400e, 0x4009, 0xc000, 0x43a0, 0x400e, 
	0x4009, 0xc000, 0x43a3, 0x400e, 0x4009, 0xc000, 0x43a9, 0x400e, 
	0x4009, 0xc000, 0x43aa, 0x400e, 0x4009, 0xc000, 0x43ac, 0x400e, 
	0x4009, 0xc000, 0x43b1, 0x400e, 0x4009, 0xc000, 0x43b5, 0x400e, 
	0x4009, 0xc000, 0x43b7, 0x400e, 0x4009, 0xc000, 0x7fff, 0x4000, 
	0x4000, 0xc000, 0x469b, 0x469e, 0x4000, 0xc000, 0x46a1, 0x469e, 
	0x4000, 0xc000, 0x46a4, 0x469e, 0x4000, 0xc000, 0x4485, 0x4017, 
	0x4379, 0xc000, 0x4486, 0x4017, 0x4379, 0xc000, 0x4487, 0x4017, 
	0x4379, 0xc000, 0x4488, 0x4017, 0x4379, 0xc000, 0x4489, 0x4017, 
	0x4379, 0xc000, 0x4484, 0x4017, 0x4379, 0xc000, 0x4493, 0x400f, 
	0x4379, 0xc000, 0x4493, 0x400f, 0x4009, 0xc000, 0x4494, 0x400f, 
	0x4379, 0xc000, 0x4494, 0x400f, 0x4009, 0xc000, 0x4499, 0x400e, 
	0x4379, 0xc000, 0x4499, 0x400e, 0x4009, 0xc000, 0x449c, 0x400f, 
	0x4379, 0xc000, 0x449c, 0x4014, 0x4379, 0xc000, 0x449c, 0x400f, 
	0x4009, 0xc000, 0x449c, 0x4014, 0x4009, 0xc000, 0x4384, 0x400e, 
	0x4379, 0xc000, 0x449f, 0x4017, 0x4379, 0xc000, 0x4384, 0x400e, 
	0x4009, 0xc000, 0x449f, 0x4017, 0x4009, 0xc000, 0x44a0, 0x400f, 
	0x4379, 0xc000, 0x44a0, 0x4016, 0x4379, 0xc000, 0x44a0, 0x400f, 
	0x4009, 0xc000, 0x44a0, 0x4016, 0x4009, 0xc000, 0x44a1, 0x4014, 
	0x4379, 0xc000, 0x44a1, 0x4014, 0x4009, 0xc000, 0x449d, 0x4019, 
	0x4379, 0xc000, 0x449d, 0x4019, 0x4009, 0xc000, 0x449e, 0x4380, 
	0x4379, 0xc000, 0x449e, 0x4380, 0x4009, 0xc000, 0x44a2, 0x4019, 
	0x4379, 0xc000, 0x44a2, 0x4019, 0x4009, 0xc000, 0x44a3, 0x4014, 
	0x4379, 0xc000, 0x44a3, 0x4014, 0x4009, 0xc000, 0x44a4, 0x400f, 
	0x4379, 0xc000, 0x44a4, 0x400f, 0x4009, 0xc000, 0x44a5, 0x400f, 
	0x4379, 0xc000, 0x44a5, 0x400f, 0x4009, 0xc000, 0x44a6, 0x400f, 
	0x4379, 0xc000, 0x44a6, 0x400f, 0x4009, 0xc000, 0x44a7, 0x400f, 
	0x4379, 0xc000, 0x44a7, 0x400f, 0x4009, 0xc000, 0x44a8, 0x400f, 
	0x4379, 0xc000, 0x44a8, 0x400f, 0x4009, 0xc000, 0x44a9, 0x400f, 
	0x4379, 0xc000, 0x44a9, 0x400f, 0x4009, 0xc000, 0x44aa, 0x400f, 
	0x4379, 0xc000, 0x44aa, 0x400f, 0x4009, 0xc000, 0x44ab, 0x400f, 
	0x4379, 0xc000, 0x44ab, 0x400f, 0x4009, 0xc000, 0x44c2, 0x4017, 
	0x4379, 0xc000, 0x44c2, 0x4017, 0x44c0, 0xc000, 0x44c2, 0x4017, 
	0x4009, 0xc000, 0x44c2, 0x4017, 0x44c1, 0xc000, 0x7ffe, 0x4000, 
	0x4000, 0x4000, 0x44d3, 0x400f, 0x4379, 0xc000, 0x44d3, 0x400f, 
	0x4009, 0xc000, 0x44d4, 0x400f, 0x4379, 0xc000, 0x44d4, 0x400f, 
	0x4009, 0xc000, 0x44d5, 0x400f, 0x4379, 0xc000, 0x44d5, 0x400f, 
	0x4009, 0xc000, 0x44d6, 0x400f, 0x4379, 0xc000, 0x44d6, 0x400f, 
	0x4009, 0xc000, 0x44d7, 0x400f, 0x4379, 0xc000, 0x44d7, 0x400f, 
	0x4009, 0xc000, 0x44e3, 0x4014, 0x4379, 0xc000, 0x44e2, 0x4013, 
	0x4379, 0xc000, 0x44e3, 0x437f, 0x4379, 0xc000, 0x44e4, 0x4014, 
	0x4379, 0xc000, 0x44e5, 0x4018, 0x4379, 0xc000, 0x44e3, 0x4014, 
	0x4009, 0xc000, 0x44e2, 0x4013, 0x4009, 0xc000, 0x44e3, 0x437f, 
	0x4009, 0xc000, 0x44e4, 0x4014, 0x4009, 0xc000, 0x44e5, 0x4018, 
	0x4009, 0xc000, 0x4038, 0x400e, 0x4009, 0xc039, 0x4038, 0x400e, 
	0x4379, 0xc039, 0x403a, 0x4014, 0x4379, 0xc000, 0x403a, 0x4014, 
	0x4009, 0xc000, 0x44e6, 0x4017, 0x4379, 0xc000, 0x44e7, 0x4017, 
	0x4379, 0xc000, 0x44e6, 0x4017, 0x4009, 0xc000, 0x44e7, 0x4017, 
	0x4009, 0xc000, 0x44e8, 0x4017, 0x4379, 0xc000, 0x44e8, 0x4017, 
	0x44c0, 0xc000, 0x44e9, 0x4017, 0x4379, 0xc000, 0x44e8, 0x4017, 
	0x4009, 0xc000, 0x44e8, 0x4017, 0x44c1, 0xc000, 0x44e9, 0x4017, 
	0x4009, 0xc000, 0x44ea, 0x4017, 0x4379, 0xc000, 0x44ea, 0x4017, 
	0x44c0, 0xc000, 0x44ea, 0x4017, 0x4009, 0xc000, 0x44ea, 0x4017, 
	0x44c1, 0xc000, 0x44eb, 0x4017, 0x4379, 0xc000, 0x44eb, 0x4017, 
	0x44c0, 0xc000, 0x44eb, 0x4017, 0x4009, 0xc000, 0x44eb, 0x4017, 
	0x44c1, 0xc000, 0x44ec, 0x4017, 0x4379, 0xc000, 0x44ec, 0x4017, 
	0x4009, 0xc000, 0x44ed, 0x4017, 0x4379, 0xc000, 0x44ed, 0x4017, 
	0x4009, 0xc000, 0x44fa, 0x4011, 0x4379, 0xc000, 0x44fc, 0x4010, 
	0x4379, 0xc000, 0x44fd, 0x4381, 0x4379, 0xc000, 0x44fb, 0x4016, 
	0x4379, 0xc000, 0x44fa, 0x4011, 0x4009, 0xc000, 0x44fc, 0x4010, 
	0x4009, 0xc000, 0x44fd, 0x4381, 0x4009, 0xc000, 0x44fb, 0x4016, 
	0x4009, 0xc000, 0x44fe, 0x4019, 0x4379, 0xc000, 0x44e7, 0x4012, 
	0x4379, 0xc000, 0x44fe, 0x4019, 0x4009, 0xc000, 0x44e7, 0x4012, 
	0x4009, 0xc000, 0x44ff, 0x400e, 0x4379, 0xc000, 0x4500, 0x4012, 
	0x4379, 0xc000, 0x4500, 0x4012, 0x4009, 0xc000, 0x4502, 0x400f, 
	0x4379, 0xc000, 0x4501, 0x4018, 0x4379, 0xc000, 0x4502, 0x400f, 
	0x4009, 0xc000, 0x4501, 0x4018, 0x4009, 0xc000, 0x4504, 0x4012, 
	0x4379, 0xc000, 0x4505, 0x4018, 0x4379, 0xc000, 0x4507, 0x469e, 
	0x465f, 0xc000, 0x44ec, 0x4012, 0x4379, 0xc000, 0x44ec, 0x4012, 
	0x4009, 0xc000, 0x4509, 0x4014, 0x4379, 0xc000, 0x4508, 0x437f, 
	0x4379, 0xc000, 0x4509, 0x4014, 0x4009, 0xc000, 0x4508, 0x437f, 
	0x4009, 0xc000, 0x4503, 0x400e, 0x4379, 0xc000, 0x4506, 0x4012, 
	0x4379, 0xc000, 0x4506, 0x4012, 0x4009, 0xc000, 0x4515, 0x4381, 
	0x4379, 0xc000, 0x4516, 0x4380, 0x4379, 0xc000, 0x4515, 0x4381, 
	0x4009, 0xc000, 0x4516, 0x4380, 0x4009, 0xc000, 0x4518, 0x4019, 
	0x4379, 0xc000, 0x4518, 0x4019, 0x4009, 0xc000, 0x4517, 0x4381, 
	0x4379, 0xc000, 0x4517, 0x4381, 0x4009, 0xc000, 0x451f, 0x400f, 
	0x4379, 0xc000, 0x451f, 0x400f, 0x44c0, 0xc000, 0x451f, 0x400f, 
	0x4009, 0xc000, 0x451f, 0x400f, 0x44c1, 0xc000, 0x4521, 0x400f, 
	0x4379, 0xc000, 0x4521, 0x400f, 0x44c0, 0xc000, 0x4521, 0x400f, 
	0x4009, 0xc000, 0x4521, 0x400f, 0x44c1, 0xc000, 0x451d, 0x4017, 
	0x4379, 0xc000, 0x451d, 0x4017, 0x4009, 0xc000, 0x451e, 0x4017, 
	0x4379, 0xc000, 0x451e, 0x4017, 0x4009, 0xc000, 0x4520, 0x4018, 
	0x4379, 0xc000, 0x4520, 0x4018, 0x4009, 0xc000, 0x4522, 0x4017, 
	0x4379, 0xc000, 0x4522, 0x4017, 0x4009, 0xc000, 0x452b, 0x4017, 
	0x4379, 0xc000, 0x452b, 0x4017, 0x44c0, 0xc000, 0x452b, 0x4017, 
	0x4009, 0xc000, 0x452b, 0x4017, 0x44c1, 0xc000, 0x452c, 0x4017, 
	0x4379, 0xc000, 0x452c, 0x4017, 0x44c0, 0xc000, 0x452c, 0x4017, 
	0x4009, 0xc000, 0x452c, 0x4017, 0x44c1, 0xc000, 0x7ffe, 0x400e, 
	0x4379, 0xc000, 0x7ffe, 0x400e, 0x4009, 0xc000, 0x458b, 0x4014, 
	0x4379, 0xc000, 0x458b, 0x4015, 0x4379, 0xc000, 0x458b, 0x4014, 
	0x4009, 0xc000, 0x458b, 0x4015, 0x4009, 0xc000, 0x458e, 0x4014, 
	0x4379, 0xc000, 0x458e, 0x4015, 0x4379, 0xc000, 0x458e, 0x4014, 
	0x4009, 0xc000, 0x458e, 0x4015, 0x4009, 0xc000, 0x4585, 0x400e, 
	0x4009, 0xc000, 0x4585, 0x400e, 0x44c1, 0xc000, 0x46a7, 0x4686, 
	0x4665, 0xc000, 0x46a7, 0x4686, 0x46aa, 0xc000, 0x46a7, 0x4686, 
	0x46ad, 0xc000, 0x46a7, 0x4686, 0x46b0, 0xc000, 0x4585, 0x400e, 
	0x44c0, 0xc000, 0x4585, 0x400e, 0x4379, 0xc000, 0x46a7, 0x4686, 
	0x46b3, 0xc000, 0x46a7, 0x4686, 0x46b6, 0xc000, 0x46a7, 0x4686, 
	0x46b9, 0xc000, 0x46a7, 0x4686, 0x465f, 0xc000, 0x4586, 0x400e, 
	0x4009, 0xc000, 0x4586, 0x400e, 0x44c1, 0xc000, 0x46bc, 0x4686, 
	0x4665, 0xc000, 0x46bc, 0x4686, 0x46aa, 0xc000, 0x46bc, 0x4686, 
	0x46ad, 0xc000, 0x46bc, 0x4686, 0x46b0, 0xc000, 0x4586, 0x400e, 
	0x44c0, 0xc000, 0x4586, 0x400e, 0x4379, 0xc000, 0x46bc, 0x4686, 
	0x46b3, 0xc000, 0x46bc, 0x4686, 0x46b6, 0xc000, 0x46bc, 0x4686, 
	0x46b9, 0xc000, 0x46bc, 0x4686, 0x465f, 0xc000, 0x4587, 0x400e, 
	0x4584, 0xc000, 0x4587, 0x400e, 0x4583, 0xc000, 0x4587, 0x400e, 
	0x4582, 0xc000, 0x4587, 0x400e, 0x4581, 0xc000, 0x46bf, 0x4686, 
	0x46c2, 0xc000, 0x46bf, 0x4686, 0x46c5, 0xc000, 0x46bf, 0x4686, 
	0x46c8, 0xc000, 0x46bf, 0x4686, 0x46cb, 0xc000, 0x4587, 0x400e, 
	0x4580, 0xc000, 0x4587, 0x400e, 0x457f, 0xc000, 0x4587, 0x400e, 
	0x457e, 0xc000, 0x4587, 0x400e, 0x457d, 0xc000, 0x46bf, 0x4686, 
	0x46ce, 0xc000, 0x46bf, 0x4686, 0x46d1, 0xc000, 0x46bf, 0x4686, 
	0x46d4, 0xc000, 0x46bf, 0x4686, 0x46d7, 0xc000, 0x4588, 0x400e, 
	0x4009, 0xc000, 0x4588, 0x400e, 0x44c1, 0xc000, 0x46da, 0x4686, 
	0x4665, 0xc000, 0x46da, 0x4686, 0x46aa, 0xc000, 0x46da, 0x4686, 
	0x46ad, 0xc000, 0x46da, 0x4686, 0x46b0, 0xc000, 0x4588, 0x400e, 
	0x4379, 0xc000, 0x4588, 0x400e, 0x44c0, 0xc000, 0x46da, 0x4686, 
	0x46b3, 0xc000, 0x46da, 0x4686, 0x46b6, 0xc000, 0x46da, 0x4686, 
	0x46b9, 0xc000, 0x46da, 0x4686, 0x465f, 0xc000, 0x4589, 0x400e, 
	0x4009, 0xc000, 0x4589, 0x400e, 0x44c1, 0xc000, 0x46dd, 0x4686, 
	0x4665, 0xc000, 0x46dd, 0x4686, 0x46aa, 0xc000, 0x46dd, 0x4686, 
	0x46ad, 0xc000, 0x46dd, 0x4686, 0x46b0, 0xc000, 0x4589, 0x400e, 
	0x4379, 0xc000, 0x4589, 0x400e, 0x44c0, 0xc000, 0x46dd, 0x4686, 
	0x46b3, 0xc000, 0x46dd, 0x4686, 0x46b6, 0xc000, 0x46dd, 0x4686, 
	0x46b9, 0xc000, 0x46dd, 0x4686, 0x465f, 0xc000, 0x458a, 0x400e, 
	0x4009, 0xc000, 0x458a, 0x400e, 0x44c1, 0xc000, 0x46e0, 0x4686, 
	0x4665, 0xc000, 0x46e0, 0x4686, 0x46aa, 0xc000, 0x46e0, 0x4686, 
	0x46ad, 0xc000, 0x46e0, 0x4686, 0x46b0, 0xc000, 0x458a, 0x400e, 
	0x4379, 0xc000, 0x458a, 0x400e, 0x44c0, 0xc000, 0x46e0, 0x4686, 
	0x46b3, 0xc000, 0x46e0, 0x4686, 0x46b6, 0xc000, 0x46e0, 0x4686, 
	0x46b9, 0xc000, 0x46e0, 0x4686, 0x465f, 0xc000, 0x458c, 0x400e, 
	0x4009, 0xc000, 0x458c, 0x400e, 0x44c1, 0xc000, 0x46e3, 0x4686, 
	0x4665, 0xc000, 0x46e3, 0x4686, 0x46aa, 0xc000, 0x46e3, 0x4686, 
	0x46ad, 0xc000, 0x46e3, 0x4686, 0x46b0, 0xc000, 0x458c, 0x400e, 
	0x44c0, 0xc000, 0x458c, 0x400e, 0x4379, 0xc000, 0x46e3, 0x4686, 
	0x46b3, 0xc000, 0x46e3, 0x4686, 0x46b6, 0xc000, 0x46e3, 0x4686, 
	0x46b9, 0xc000, 0x46e3, 0x4686, 0x465f, 0xc000, 0x458d, 0x400e, 
	0x4009, 0xc000, 0x458d, 0x400e, 0x44c1, 0xc000, 0x46e6, 0x4686, 
	0x4665, 0xc000, 0x46e6, 0x4686, 0x46aa, 0xc000, 0x46e6, 0x4686, 
	0x46ad, 0xc000, 0x46e6, 0x4686, 0x46b0, 0xc000, 0x458d, 0x400e, 
	0x44c0, 0xc000, 0x458d, 0x400e, 0x4379, 0xc000, 0x46e6, 0x4686, 
	0x46b3, 0xc000, 0x46e6, 0x4686, 0x46b6, 0xc000, 0x46e6, 0x4686, 
	0x46b9, 0xc000, 0x46e6, 0x4686, 0x465f, 0xc000, 0x458f, 0x400e, 
	0x4009, 0xc000, 0x458f, 0x400e, 0x44c1, 0xc000, 0x46e9, 0x4686, 
	0x4665, 0xc000, 0x46e9, 0x4686, 0x46aa, 0xc000, 0x46e9, 0x4686, 
	0x46ad, 0xc000, 0x46e9, 0x4686, 0x46b0, 0xc000, 0x458f, 0x400e, 
	0x44c0, 0xc000, 0x458f, 0x400e, 0x4379, 0xc000, 0x46e9, 0x4686, 
	0x46b3, 0xc000, 0x46e9, 0x4686, 0x46b6, 0xc000, 0x46e9, 0x4686, 
	0x46b9, 0xc000, 0x46e9, 0x4686, 0x465f, 0xc000, 0x4000, 0x4000, 
	0x4000, 0xfffe, 0x460e, 0x400e, 0x4379, 0xc000, 0x438a, 0x4608, 
	0x4379, 0xc000, 0x4389, 0x437a, 0x4379, 0xc000, 0x4389, 0x437c, 
	0x4379, 0xc000, 0x4389, 0x437b, 0x4379, 0xc000, 0x4389, 0x4609, 
	0x4379, 0xc000, 0x4389, 0x4609, 0x460c, 0xc000, 0x4389, 0x4609, 
	0x460d, 0xc000, 0x4058, 0x400f, 0x4379, 0xc000, 0x438b, 0x460b, 
	0x4379, 0xc000, 0x438b, 0x437a, 0x4379, 0xc000, 0x460f, 0x400e, 
	0x4379, 0xc000, 0x460f, 0x460a, 0x4379, 0xc000, 0x460f, 0x437d, 
	0x4379, 0xc000, 0x460e, 0x400e, 0x4003, 0xc000, 0x460e, 0x400e, 
	0x4004, 0xc000, 0x438a, 0x400e, 0x4003, 0xc000, 0x438a, 0x400e, 
	0x4004, 0xc000, 0x438a, 0x4608, 0x4003, 0xc000, 0x438a, 0x4608, 
	0x4004, 0xc000, 0x4389, 0x400e, 0x4003, 0xc000, 0x4389, 0x437a, 
	0x4003, 0xc000, 0x4389, 0x437a, 0x4004, 0xc000, 0x4389, 0x437c, 
	0x4003, 0xc000, 0x4389, 0x437c, 0x4004, 0xc000, 0x4389, 0x437b, 
	0x4003, 0xc000, 0x4389, 0x437b, 0x4004, 0xc000, 0x4389, 0x4609, 
	0x4003, 0xc000, 0x4389, 0x4609, 0x4004, 0xc000, 0x4058, 0x400e, 
	0x4003, 0xc000, 0x4058, 0x400e, 0x4004, 0xc000, 0x4058, 0x400e, 
	0x4005, 0xc000, 0x4058, 0x400e, 0x4006, 0xc000, 0x4058, 0x400f, 
	0x4003, 0xc000, 0x4058, 0x400f, 0x4004, 0xc000, 0x4058, 0x400f, 
	0x4005, 0xc000, 0x4058, 0x400f, 0x4006, 0xc000, 0x438b, 0x400e, 
	0x4003, 0xc000, 0x438b, 0x400e, 0x4004, 0xc000, 0x438b, 0x400e, 
	0x4005, 0xc000, 0x438b, 0x400e, 0x4006, 0xc000, 0x438b, 0x460b, 
	0x4003, 0xc000, 0x438b, 0x460b, 0x4004, 0xc000, 0x438b, 0x437a, 
	0x4003, 0xc000, 0x438b, 0x437a, 0x4004, 0xc000, 0x460f, 0x400e, 
	0x4003, 0xc000, 0x460f, 0x400e, 0x4004, 0xc000, 0x460f, 0x400e, 
	0x4005, 0xc000, 0x460f, 0x400e, 0x4006, 0xc000, 0x460f, 0x460a, 
	0x4003, 0xc000, 0x460f, 0x460a, 0x4004, 0xc000, 0x460f, 0x437d, 
	0x4003, 0xc000, 0x460f, 0x437d, 0x4004, 0xc000, 0x460f, 0x437d, 
	0x4005, 0xc000, 0x460f, 0x437d, 0x4006, 0xc000, 0x46ec, 0x4686, 
	0x46ef, 0xc000, 0x46ec, 0x4686, 0x46f2, 0xc000, 0x46f5, 0x46f8, 
	0x46ef, 0xc000, 0x46f5, 0x46f8, 0x46f2, 0xc000, 0x46f5, 0x46fb, 
	0x46ef, 0xc000, 0x46f5, 0x46fb, 0x46f2, 0xc000, 0x46fe, 0x4686, 
	0x46ef, 0xc000, 0x46fe, 0x4686, 0x46f2, 0xc000, 0x4701, 0x4706, 
	0x470b, 0xc000, 0x4626, 0x4381, 0x4009, 0xc000, 0x4626, 0x4381, 
	0x4379, 0xc000, 0x4627, 0x4381, 0x4009, 0xc000, 0x4627, 0x4381, 
	0x4379, 0xc000, 0x4628, 0x4381, 0x4009, 0xc000, 0x4628, 0x4381, 
	0x4379, 0xc000, 0x4629, 0x4381, 0x4009, 0xc000, 0x4629, 0x4381, 
	0x4379, 0xc000, 0x462a, 0x4381, 0x4009, 0xc000, 0x462a, 0x4381, 
	0x4379, 0xc000, 0x462b, 0x4380, 0x4009, 0xc000, 0x462b, 0x4380, 
	0x4379, 0xc000, 0x462c, 0x4017, 0x4379, 0xc000, 0x462c, 0x4017, 
	0x44c0, 0xc000, 0x462c, 0x4017, 0x4009, 0xc000, 0x462c, 0x4017, 
	0x44c1, 0xc000, 0x462d, 0x4017, 0x4379, 0xc000, 0x462d, 0x4017, 
	0x44c0, 0xc000, 0x462d, 0x4017, 0x4009, 0xc000, 0x462d, 0x4017, 
	0x44c1, 0xc000, 0x462e, 0x4017, 0x4379, 0xc000, 0x462e, 0x4017, 
	0x44c0, 0xc000, 0x462e, 0x4017, 0x4009, 0xc000, 0x462e, 0x4017, 
	0x44c1, 0xc000, 0x462f, 0x4017, 0x4379, 0xc000, 0x462f, 0x4017, 
	0x44c0, 0xc000, 0x462f, 0x4017, 0x4009, 0xc000, 0x462f, 0x4017, 
	0x44c1, 0xc000, 0x4630, 0x4017, 0x4379, 0xc000, 0x4630, 0x4017, 
	0x44c0, 0xc000, 0x4630, 0x4017, 0x4009, 0xc000, 0x4630, 0x4017, 
	0x44c1, 0xc000, 0x4631, 0x4017, 0x4379, 0xc000, 0x4631, 0x4017, 
	0x44c0, 0xc000, 0x4631, 0x4017, 0x4009, 0xc000, 0x4631, 0x4017, 
	0x44c1, 0xc000, 0x4632, 0x4017, 0x4379, 0xc000, 0x4632, 0x4017, 
	0x44c0, 0xc000, 0x4632, 0x4017, 0x4009, 0xc000, 0x4632, 0x4017, 
	0x44c1, 0xc000, 0x4633, 0x4017, 0x4379, 0xc000, 0x4633, 0x4017, 
	0x44c0, 0xc000, 0x4633, 0x4017, 0x4009, 0xc000, 0x4633, 0x4017, 
	0x44c1, 0xc000, 0x4650, 0x4017, 0x4379, 0xc000, 0x4650, 0x4017, 
	0x44c0, 0xc000, 0x4651, 0x4017, 0x4379, 0xc000, 0x4651, 0x4017, 
	0x44c0, 0xc000, 0x4650, 0x4017, 0x4009, 0xc000, 0x4650, 0x4017, 
	0x44c1, 0xc000, 0x4651, 0x4017, 0x4009, 0xc000, 0x4651, 0x4017, 
	0x44c1, 0xc000, 0x4710, 0x469e, 0x465f, 0xc000, 0x4710, 0x4713, 
	0x465f, 0xc000, 0x4716, 0x469e, 0x465f, 0xc000, 0x4393, 0x4394, 
	0x4379, 0xc000, 0x4393, 0x4395, 0x4379, 0xc000, 0x4393, 0x43b7, 
	0x4379, 0xc000, 0x4399, 0x439a, 0x4379, 0xc000, 0x4399, 0x439b, 
	0x4379, 0xc000, 0x4399, 0x43b5, 0x4379, 0xc000, 0x4710, 0x469e, 
	0x4665, 0xc000, 0x4710, 0x4713, 0x4665, 0xc000, 0x4716, 0x469e, 
	0x4665, 0xc000, 0x4393, 0x4394, 0x4009, 0xc000, 0x4393, 0x4395, 
	0x4009, 0xc000, 0x4393, 0x43b7, 0x4009, 0xc000, 0x4399, 0x439a, 
	0x4009, 0xc000, 0x4399, 0x439b, 0x4009, 0xc000, 0x4399, 0x43b5, 
	0x4009, 0xc000, 0x438f, 0x4391, 0x4379, 0xc000, 0x439e, 0x43a9, 
	0x4379, 0xc000, 0x4719, 0x469e, 0x465f, 0xc000, 0x471c, 0x469e, 
	0x465f, 0xc000, 0x43ab, 0x43ac, 0x4379, 0xc000, 0x43b0, 0x43aa, 
	0x4379, 0xc000, 0x438f, 0x4391, 0x4009, 0xc000, 0x439c, 0x439d, 
	0x4009, 0xc000, 0x439e, 0x43a9, 0x4009, 0xc000, 0x4719, 0x469e, 
	0x4665, 0xc000, 0x471c, 0x469e, 0x4665, 0xc000, 0x43ab, 0x43ac, 
	0x4009, 0xc000, 0x43b0, 0x43aa, 0x4009, 0xc000, 0x4656, 0x4014, 
	0x4379, 0xc000, 0x4656, 0x4014, 0x4009, 0xc000, 0x7ffe, 0x3ffe, 
	0x7ffe, 0xbffe, 0x7ffe, 0x3ffe, 0x7ffe, 0x8000, 0x4000,      0, 
	0x4000, 0xbffe, 0x7ffe, 0x0002, 0x4001, 0x8000, 0x42a9, 0x0002, 
	0x46a0, 0x8000, 0x42a9, 0x0002, 0x7ffe, 0x8000, 0x42a9, 0x0005, 
	0x4001, 0x8000, 0x42a9, 0x0005, 0x46a0, 0x8000, 0x42a9, 0x0006, 
	0x4001, 0x8000, 0x42a9, 0x0006, 0x46a0, 0x8000, 0x42a9, 0x0007, 
	0x4001, 0x8000, 0x42a9, 0x0007, 0x46a0, 0x8000, 0x42a9, 0x0008, 
	0x4001, 0x8000, 0x42a9, 0x0008, 0x46a0, 0x8000, 0x42a9, 0x0009, 
	0x4001, 0x8000, 0x42a9, 0x0009, 0x46a0, 0x8000, 0x42a9, 0x000b, 
	0x4001, 0x8000, 0x42a9, 0x000b, 0x46a0, 0x8000, 0x42a9, 0x000c, 
	0x4001, 0x8000, 0x42a9, 0x000c, 0x46a0, 0x8000, 0x42a9, 0x000d, 
	0x4001, 0x8000, 0x42a9, 0x000d, 0x46a0, 0x8000, 0x42a9, 0x000f, 
	0x4001, 0x8000, 0x42a9, 0x000f, 0x46a0, 0x8000, 0x42a9, 0x0010, 
	0x4001, 0x8000, 0x42a9, 0x0010, 0x46a0, 0x8000, 0x42a9, 0x0011, 
	0x4001, 0x8000, 0x42a9, 0x0011, 0x46a0, 0x8000, 0x42a9, 0x0012, 
	0x4001, 0x8000, 0x42a9, 0x0012, 0x46a0, 0x8000, 0x42a9, 0x0013, 
	0x4001, 0x8000, 0x42a9, 0x0013, 0x46a0, 0x8000, 0x42a9, 0x0014, 
	0x4001, 0x8000, 0x42a9, 0x0014, 0x46a0, 0x8000, 0x42a9, 0x0015, 
	0x4001, 0x8000, 0x42a9, 0x0015, 0x46a0, 0x8000, 0x42a9, 0x0016, 
	0x4001, 0x8000, 0x42a9, 0x0016, 0x46a0, 0x8000, 0x42a9, 0x001b, 
	0x4001, 0x8000, 0x42a9, 0x001b, 0x46a0, 0x8000, 0x42a9, 0x001d, 
	0x4001, 0x8000, 0x42a9, 0x001d, 0x46a0, 0x8000, 0x42a9, 0x0022, 
	0x4001, 0x8000, 0x42a9, 0x0022, 0x46a0, 0x8000, 0x42a9, 0x0023, 
	0x4001, 0x8000, 0x42a9, 0x0023, 0x46a0, 0x8000, 0x42a9, 0x0028, 
	0x4001, 0x8000, 0x42a9, 0x0028, 0x46a0, 0x8000, 0x42a9, 0x0037, 
	0x4001, 0x8000, 0x42a9, 0x0037, 0x46a0, 0x8000, 0x42d9, 0x0002, 
	0x46a0, 0x8000, 0x42d9, 0x0027, 0x4001, 0x8000, 0x42d9, 0x0027, 
	0x46a0, 0x8000, 0x42d9, 0x0028, 0x4001, 0x8000, 0x42d9, 0x0028, 
	0x46a0, 0x8000, 0x42d9, 0x003a, 0x4001, 0x8000, 0x42d9, 0x003a, 
	0x46a0, 0x8000, 0x42e2, 0x0002, 0x46a0, 0x8000, 0x42e2, 0x0010, 
	0x4001, 0x8000, 0x42e2, 0x0010, 0x46a0, 0x8000, 0x42e2, 0x0022, 
	0x4001, 0x8000, 0x42e2, 0x0022, 0x46a0, 0x8000, 0x42e2, 0x0027, 
	0x4001, 0x8000, 0x42e2, 0x0027, 0x46a0, 0x8000, 0x42e2, 0x002d, 
	0x4001, 0x8000, 0x42e2, 0x002d, 0x46a0, 0x8000, 0x42ed, 0x0002, 
	0x46a0, 0x8000, 0x42ed, 0x0016, 0x4001, 0x8000, 0x42ed, 0x0016, 
	0x46a0, 0x8000, 0x42ed, 0x0027, 0x4001, 0x8000, 0x42ed, 0x0027, 
	0x46a0, 0x8000, 0x42ed, 0x0028, 0x4001, 0x8000, 0x42ed, 0x0028, 
	0x46a0, 0x8000, 0x42ed, 0x002c, 0x4001, 0x8000, 0x42ed, 0x002c, 
	0x46a0, 0x8000, 0x42ed, 0x0039, 0x4001, 0x8000, 0x42ed, 0x0039, 
	0x46a0, 0x8000, 0x42ed, 0x003a, 0x4001, 0x8000, 0x42ed, 0x003a, 
	0x46a0, 0x8000, 0x42fc, 0x0002, 0x46a0, 0x8000, 0x42fc, 0x0005, 
	0x4001, 0x8000, 0x42fc, 0x0005, 0x46a0, 0x8000, 0x42fc, 0x0006, 
	0x4001, 0x8000, 0x42fc, 0x0006, 0x46a0, 0x8000, 0x42fc, 0x0007, 
	0x4001, 0x8000, 0x42fc, 0x0007, 0x46a0, 0x8000, 0x42fc, 0x000f, 
	0x4001, 0x8000, 0x42fc, 0x000f, 0x46a0, 0x8000, 0x42fc, 0x0010, 
	0x4001, 0x8000, 0x42fc, 0x0010, 0x46a0, 0x8000, 0x42fc, 0x0011, 
	0x4001, 0x8000, 0x42fc, 0x0011, 0x46a0, 0x8000, 0x42fc, 0x0012, 
	0x4001, 0x8000, 0x42fc, 0x0012, 0x46a0, 0x8000, 0x42fc, 0x0013, 
	0x4001, 0x8000, 0x42fc, 0x0013, 0x46a0, 0x8000, 0x42fc, 0x0014, 
	0x4001, 0x8000, 0x42fc, 0x0014, 0x46a0, 0x8000, 0x42fc, 0x0015, 
	0x4001, 0x8000, 0x42fc, 0x0015, 0x46a0, 0x8000, 0x42fc, 0x0016, 
	0x4001, 0x8000, 0x42fc, 0x0016, 0x46a0, 0x8000, 0x42fc, 0x001c, 
	0x4001, 0x8000, 0x42fc, 0x001c, 0x46a0, 0x8000, 0x42fc, 0x0022, 
	0x4001, 0x8000, 0x42fc, 0x0022, 0x46a0, 0x8000, 0x42fc, 0x0023, 
	0x4001, 0x8000, 0x42fc, 0x0023, 0x46a0, 0x8000, 0x42fc, 0x0026, 
	0x4001, 0x8000, 0x42fc, 0x0026, 0x46a0, 0x8000, 0x42fc, 0x0027, 
	0x4001, 0x8000, 0x42fc, 0x0027, 0x46a0, 0x8000, 0x42fc, 0x0028, 
	0x4001, 0x8000, 0x42fc, 0x0028, 0x46a0, 0x8000, 0x42fc, 0x002f, 
	0x4001, 0x8000, 0x42fc, 0x002f, 0x46a0, 0x8000, 0x42fc, 0x0033, 
	0x4001, 0x8000, 0x42fc, 0x0033, 0x46a0, 0x8000, 0x42fc, 0x0034, 
	0x4001, 0x8000, 0x42fc, 0x0034, 0x46a0, 0x8000, 0x42fc, 0x0039, 
	0x4001, 0x8000, 0x42fc, 0x0039, 0x46a0, 0x8000, 0x4329, 0x0002, 
	0x46a0, 0x8000, 0x4329, 0x0022, 0x4001, 0x8000, 0x4329, 0x0022, 
	0x46a0, 0x8000, 0x4329, 0x0027, 0x4001, 0x8000, 0x4329, 0x0027, 
	0x46a0, 0x8000, 0x4863, 0x0866, 0x4869, 0x8000, 0x486c, 0x0866, 
	0x486f, 0x8000, 0x4872, 0x0866, 0x4875, 0x8000, 0x4878, 0x087c, 
	0x4880, 0x8000, 0x4884, 0x087c, 0x4888, 0x8000, 0x4335, 0x0002, 
	0x46a0, 0x8000, 0x4335, 0x0003, 0x4001, 0x8000, 0x4335, 0x0003, 
	0x46a0, 0x8000, 0x4335, 0x0010, 0x4001, 0x8000, 0x4335, 0x0010, 
	0x46a0, 0x8000, 0x4335, 0x0016, 0x4001, 0x8000, 0x4335, 0x0016, 
	0x46a0, 0x8000, 0x4335, 0x0027, 0x4001, 0x8000, 0x4335, 0x0027, 
	0x46a0, 0x8000, 0x4335, 0x002a, 0x4001, 0x8000, 0x4335, 0x002a, 
	0x46a0, 0x8000, 0x4335, 0x0032, 0x4001, 0x8000, 0x4335, 0x0032, 
	0x46a0, 0x8000, 0x4344, 0x0002, 0x46a0, 0x8000, 0x4344, 0x000e, 
	0x4001, 0x8000, 0x4344, 0x000e, 0x46a0, 0x8000, 0x4344, 0x0010, 
	0x4001, 0x8000, 0x4344, 0x0010, 0x46a0, 0x8000, 0x4344, 0x001c, 
	0x4001, 0x8000, 0x4344, 0x001c, 0x46a0, 0x8000, 0x4344, 0x0027, 
	0x4001, 0x8000, 0x4344, 0x0027, 0x46a0, 0x8000, 0x4344, 0x0028, 
	0x4001, 0x8000, 0x4344, 0x0028, 0x46a0, 0x8000, 0x4344, 0x002a, 
	0x4001, 0x8000, 0x4344, 0x002a, 0x46a0, 0x8000, 0x4344, 0x002c, 
	0x4001, 0x8000, 0x4344, 0x002c, 0x46a0, 0x8000, 0x4702, 0x0002, 
	0x46a0, 0x8000, 0x4702, 0x0005, 0x4001, 0x8000, 0x4702, 0x0005, 
	0x46a0, 0x8000, 0x4702, 0x0006, 0x4001, 0x8000, 0x4702, 0x0006, 
	0x46a0, 0x8000, 0x4702, 0x0007, 0x4001, 0x8000, 0x4702, 0x0007, 
	0x46a0, 0x8000, 0x4702, 0x000f, 0x4001, 0x8000, 0x4702, 0x000f, 
	0x46a0, 0x8000, 0x4702, 0x0010, 0x4001, 0x8000, 0x4702, 0x0010, 
	0x46a0, 0x8000, 0x4702, 0x0016, 0x4001, 0x8000, 0x4702, 0x0016, 
	0x46a0, 0x8000, 0x4702, 0x001c, 0x4001, 0x8000, 0x4702, 0x001c, 
	0x46a0, 0x8000, 0x4702, 0x001e, 0x4001, 0x8000, 0x4702, 0x001e, 
	0x46a0, 0x8000, 0x4702, 0x0022, 0x4001, 0x8000, 0x4702, 0x0022, 
	0x46a0, 0x8000, 0x4702, 0x0023, 0x4001, 0x8000, 0x4702, 0x0023, 
	0x46a0, 0x8000, 0x4702, 0x0026, 0x4001, 0x8000, 0x4702, 0x0026, 
	0x46a0, 0x8000, 0x4702, 0x0028, 0x4001, 0x8000, 0x4702, 0x0028, 
	0x46a0, 0x8000, 0x4702, 0x0030, 0x4001, 0x8000, 0x4702, 0x0030, 
	0x46a0, 0x8000, 0x488c, 0x088f, 0x4892, 0x8000, 0x488c, 0x088f, 
	0x4895, 0x8000, 0x4373, 0x0002, 0x46a0, 0x8000, 0x4373, 0x0010, 
	0x4001, 0x8000, 0x4373, 0x0010, 0x46a0, 0x8000, 0x4378, 0x0002, 
	0x46a0, 0x8000, 0x4378, 0x0003, 0x4001, 0x8000, 0x4378, 0x0003, 
	0x46a0, 0x8000, 0x4378, 0x0016, 0x4001, 0x8000, 0x4378, 0x0016, 
	0x46a0, 0x8000, 0x4378, 0x0022, 0x4001, 0x8000, 0x4378, 0x0022, 
	0x46a0, 0x8000, 0x4378, 0x0028, 0x4001, 0x8000, 0x4378, 0x0028, 
	0x46a0, 0x8000, 0x4378, 0x003a, 0x4001, 0x8000, 0x4378, 0x003a, 
	0x46a0, 0x8000, 0x4385, 0x0002, 0x46a0, 0x8000, 0x4385, 0x0003, 
	0x4001, 0x8000, 0x4385, 0x0003, 0x46a0, 0x8000, 0x4385, 0x0016, 
	0x4001, 0x8000, 0x4385, 0x0016, 0x46a0, 0x8000, 0x4385, 0x0027, 
	0x4001, 0x8000, 0x4385, 0x0027, 0x46a0, 0x8000, 0x4385, 0x0028, 
	0x4001, 0x8000, 0x4385, 0x0028, 0x46a0, 0x8000, 0x4385, 0x0038, 
	0x4001, 0x8000, 0x4385, 0x0038, 0x46a0, 0x8000, 0x4385, 0x0039, 
	0x4001, 0x8000, 0x4385, 0x0039, 0x46a0, 0x8000, 0x4385, 0x003a, 
	0x4001, 0x8000, 0x4385, 0x003a, 0x46a0, 0x8000, 0x4396, 0x0002, 
	0x46a0, 0x8000, 0x4396, 0x0003, 0x4001, 0x8000, 0x4396, 0x0003, 
	0x46a0, 0x8000, 0x4396, 0x0027, 0x4001, 0x8000, 0x4396, 0x0027, 
	0x46a0, 0x8000, 0x4396, 0x0028, 0x4001, 0x8000, 0x4396, 0x0028, 
	0x46a0, 0x8000, 0x439f, 0x0002, 0x46a0, 0x8000, 0x439f, 0x0016, 
	0x4001, 0x8000, 0x439f, 0x0016, 0x46a0, 0x8000, 0x439f, 0x0027, 
	0x4001, 0x8000, 0x439f, 0x0027, 0x46a0, 0x8000, 0x439f, 0x0028, 
	0x4001, 0x8000, 0x439f, 0x0028, 0x46a0, 0x8000, 0x439f, 0x0039, 
	0x4001, 0x8000, 0x439f, 0x0039, 0x46a0, 0x8000, 0x439f, 0x003a, 
	0x4001, 0x8000, 0x439f, 0x003a, 0x46a0, 0x8000, 0x439f, 0x0041, 
	0x46a0, 0x8000, 0x43ad, 0x0002, 0x46a0, 0x8000, 0x43ad, 0x0002, 
	0x7ffe, 0x8000, 0x43ad, 0x0005, 0x4001, 0x8000, 0x43ad, 0x0005, 
	0x46a0, 0x8000, 0x43ad, 0x0006, 0x4001, 0x8000, 0x43ad, 0x0006, 
	0x46a0, 0x8000, 0x43ad, 0x0007, 0x4001, 0x8000, 0x43ad, 0x0007, 
	0x46a0, 0x8000, 0x43ad, 0x000f, 0x4001, 0x8000, 0x43ad, 0x000f, 
	0x46a0, 0x8000, 0x43ad, 0x0010, 0x4001, 0x8000, 0x43ad, 0x0010, 
	0x46a0, 0x8000, 0x43ad, 0x0011, 0x4001, 0x8000, 0x43ad, 0x0011, 
	0x46a0, 0x8000, 0x43ad, 0x0012, 0x4001, 0x8000, 0x43ad, 0x0012, 
	0x46a0, 0x8000, 0x43ad, 0x0013, 0x4001, 0x8000, 0x43ad, 0x0013, 
	0x46a0, 0x8000, 0x43ad, 0x0014, 0x4001, 0x8000, 0x43ad, 0x0014, 
	0x46a0, 0x8000, 0x43ad, 0x0015, 0x4001, 0x8000, 0x43ad, 0x0015, 
	0x46a0, 0x8000, 0x43ad, 0x0016, 0x4001, 0x8000, 0x43ad, 0x0016, 
	0x46a0, 0x8000, 0x43ad, 0x0022, 0x4001, 0x8000, 0x43ad, 0x0022, 
	0x46a0, 0x8000, 0x43ad, 0x0024, 0x4001, 0x8000, 0x43ad, 0x0024, 
	0x46a0, 0x8000, 0x43ad, 0x0025, 0x4001, 0x8000, 0x43ad, 0x0025, 
	0x46a0, 0x8000, 0x43ad, 0x0028, 0x4001, 0x8000, 0x43ad, 0x0028, 
	0x46a0, 0x8000, 0x43ad, 0x0030, 0x4001, 0x8000, 0x43ad, 0x0030, 
	0x46a0, 0x8000, 0x43ad, 0x0031, 0x4001, 0x8000, 0x43ad, 0x0031, 
	0x46a0, 0x8000, 0x43ad, 0x0033, 0x4001, 0x8000, 0x43ad, 0x0033, 
	0x46a0, 0x8000, 0x43ad, 0x0034, 0x4001, 0x8000, 0x43ad, 0x0034, 
	0x46a0, 0x8000, 0x43ad, 0x003b, 0x4001, 0x8000, 0x43ad, 0x003b, 
	0x46a0, 0x8000, 0x43ad, 0x003c, 0x4001, 0x8000, 0x43ad, 0x003c, 
	0x46a0, 0x8000, 0x43ad, 0x003d, 0x4001, 0x8000, 0x43ad, 0x003d, 
	0x46a0, 0x8000, 0x43ad, 0x003e, 0x4001, 0x8000, 0x43ad, 0x003e, 
	0x46a0, 0x8000, 0x43ad, 0x003f, 0x4001, 0x8000, 0x43ad, 0x003f, 
	0x46a0, 0x8000, 0x43ad, 0x0040, 0x4001, 0x8000, 0x43ad, 0x0040, 
	0x46a0, 0x8000, 0x43e3, 0x0002, 0x46a0, 0x8000, 0x43e3, 0x0003, 
	0x4001, 0x8000, 0x43e3, 0x0003, 0x46a0, 0x8000, 0x43e3, 0x0027, 
	0x4001, 0x8000, 0x43e3, 0x0027, 0x46a0, 0x8000, 0x43ea, 0x0002, 
	0x46a0, 0x8000, 0x43ed, 0x0002, 0x46a0, 0x8000, 0x43ed, 0x0003, 
	0x4001, 0x8000, 0x43ed, 0x0003, 0x46a0, 0x8000, 0x43ed, 0x0006, 
	0x4001, 0x8000, 0x43ed, 0x0006, 0x46a0, 0x8000, 0x43ed, 0x000f, 
	0x4001, 0x8000, 0x43ed, 0x000f, 0x46a0, 0x8000, 0x43ed, 0x0016, 
	0x4001, 0x8000, 0x43ed, 0x0016, 0x46a0, 0x8000, 0x43ed, 0x0027, 
	0x4001, 0x8000, 0x43ed, 0x0027, 0x46a0, 0x8000, 0x43ed, 0x0028, 
	0x4001, 0x8000, 0x43ed, 0x0028, 0x46a0, 0x8000, 0x43ed, 0x0038, 
	0x4001, 0x8000, 0x43ed, 0x0038, 0x46a0, 0x8000, 0x43ed, 0x003a, 
	0x4001, 0x8000, 0x43ed, 0x003a, 0x46a0, 0x8000, 0x4400, 0x0002, 
	0x46a0, 0x8000, 0x4898, 0x0866, 0x489b, 0x8000, 0x4400, 0x0004, 
	0x4001, 0x8000, 0x4400, 0x0004, 0x46a0, 0x8000, 0x4400, 0x0010, 
	0x4001, 0x8000, 0x4400, 0x0010, 0x46a0, 0x8000, 0x4400, 0x0018, 
	0x4001, 0x8000, 0x4400, 0x0018, 0x46a0, 0x8000, 0x4400, 0x0027, 
	0x4001, 0x8000, 0x4400, 0x0027, 0x46a0, 0x8000, 0x4400, 0x0028, 
	0x4001, 0x8000, 0x4400, 0x0028, 0x46a0, 0x8000, 0x4400, 0x0029, 
	0x4001, 0x8000, 0x4400, 0x0029, 0x46a0, 0x8000, 0x4400, 0x3ffe, 
	0x46a0, 0x8000, 0x489e, 0x0866, 0x48a1, 0x8000, 0x4898, 0x0866, 
	0x48a4, 0x8000, 0x4413, 0x0002, 0x46a0, 0x8000, 0x4413, 0x0016, 
	0x4001, 0x8000, 0x4413, 0x0016, 0x46a0, 0x8000, 0x4413, 0x0027, 
	0x4001, 0x8000, 0x4413, 0x0027, 0x46a0, 0x8000, 0x4413, 0x0028, 
	0x4001, 0x8000, 0x4413, 0x0028, 0x46a0, 0x8000, 0x4413, 0x002a, 
	0x4001, 0x8000, 0x4413, 0x002a, 0x46a0, 0x8000, 0x4413, 0x002c, 
	0x4001, 0x8000, 0x4413, 0x002c, 0x46a0, 0x8000, 0x4413, 0x0039, 
	0x4001, 0x8000, 0x4413, 0x0039, 0x46a0, 0x8000, 0x4413, 0x003a, 
	0x4001, 0x8000, 0x4413, 0x003a, 0x46a0, 0x8000, 0x4424, 0x0002, 
	0x46a0, 0x8000, 0x4424, 0x0005, 0x4001, 0x8000, 0x4424, 0x0005, 
	0x46a0, 0x8000, 0x4424, 0x0006, 0x4001, 0x8000, 0x4424, 0x0006, 
	0x46a0, 0x8000, 0x4424, 0x0007, 0x4001, 0x8000, 0x4424, 0x0007, 
	0x46a0, 0x8000, 0x4424, 0x000f, 0x4001, 0x8000, 0x4424, 0x000f, 
	0x46a0, 0x8000, 0x4424, 0x0010, 0x4001, 0x8000, 0x4424, 0x0010, 
	0x46a0, 0x8000, 0x4424, 0x0016, 0x4001, 0x8000, 0x4424, 0x0016, 
	0x46a0, 0x8000, 0x4424, 0x0019, 0x4001, 0x8000, 0x4424, 0x0019, 
	0x46a0, 0x8000, 0x4424, 0x001d, 0x4001, 0x8000, 0x4424, 0x001d, 
	0x46a0, 0x8000, 0x4424, 0x001e, 0x4001, 0x8000, 0x4424, 0x001e, 
	0x46a0, 0x8000, 0x4424, 0x001f, 0x4001, 0x8000, 0x4424, 0x001f, 
	0x46a0, 0x8000, 0x4424, 0x0020, 0x4001, 0x8000, 0x4424, 0x0020, 
	0x46a0, 0x8000, 0x4424, 0x0022, 0x4001, 0x8000, 0x4424, 0x0022, 
	0x46a0, 0x8000, 0x4424, 0x0023, 0x4001, 0x8000, 0x4424, 0x0023, 
	0x46a0, 0x8000, 0x4424, 0x0024, 0x4001, 0x8000, 0x4424, 0x0024, 
	0x46a0, 0x8000, 0x4424, 0x0026, 0x4001, 0x8000, 0x4424, 0x0026, 
	0x46a0, 0x8000, 0x4424, 0x0028, 0x4001, 0x8000, 0x4424, 0x0028, 
	0x46a0, 0x8000, 0x4424, 0x0030, 0x4001, 0x8000, 0x4424, 0x0030, 
	0x46a0, 0x8000, 0x4424, 0x0035, 0x4001, 0x8000, 0x4424, 0x0035, 
	0x46a0, 0x8000, 0x4424, 0x0036, 0x4001, 0x8000, 0x4424, 0x0036, 
	0x46a0, 0x8000, 0x4424, 0x0039, 0x4001, 0x8000, 0x4424, 0x0039, 
	0x46a0, 0x8000, 0x4424, 0x003b, 0x4001, 0x8000, 0x4424, 0x003b, 
	0x46a0, 0x8000, 0x4424, 0x003c, 0x4001, 0x8000, 0x4424, 0x003c, 
	0x46a0, 0x8000, 0x4424, 0x003d, 0x4001, 0x8000, 0x4424, 0x003d, 
	0x46a0, 0x8000, 0x4424, 0x003e, 0x4001, 0x8000, 0x4424, 0x003e, 
	0x46a0, 0x8000, 0x4424, 0x003f, 0x4001, 0x8000, 0x4424, 0x003f, 
	0x46a0, 0x8000, 0x4424, 0x0040, 0x4001, 0x8000, 0x4424, 0x0040, 
	0x46a0, 0x8000, 0x445d, 0x0002, 0x46a0, 0x8000, 0x445d, 0x001c, 
	0x4001, 0x8000, 0x445d, 0x001c, 0x46a0, 0x8000, 0x445d, 0x0027, 
	0x4001, 0x8000, 0x445d, 0x0027, 0x46a0, 0x8000, 0x474e, 0x0005, 
	0x4001, 0x8000, 0x474e, 0x0005, 0x46a0, 0x8000, 0x474e, 0x0010, 
	0x4001, 0x8000, 0x474e, 0x0010, 0x46a0, 0x8000, 0x474e, 0x001c, 
	0x4001, 0x8000, 0x474e, 0x001c, 0x46a0, 0x8000, 0x474e, 0x0022, 
	0x4001, 0x8000, 0x474e, 0x0022, 0x46a0, 0x8000, 0x474e, 0x0023, 
	0x4001, 0x8000, 0x474e, 0x0023, 0x46a0, 0x8000, 0x474e, 0x0027, 
	0x4001, 0x8000, 0x474e, 0x0027, 0x46a0, 0x8000, 0x474e, 0x0028, 
	0x4001, 0x8000, 0x474e, 0x0028, 0x46a0, 0x8000, 0x4753, 0x0010, 
	0x4001, 0x8000, 0x4753, 0x0010, 0x46a0, 0x8000, 0x4753, 0x0028, 
	0x4001, 0x8000, 0x4753, 0x0028, 0x46a0, 0x8000, 0x4753, 0x002a, 
	0x4001, 0x8000, 0x4753, 0x002a, 0x46a0, 0x8000, 0x4753, 0x003a, 
	0x4001, 0x8000, 0x4753, 0x003a, 0x46a0, 0x8000, 0x7ffe, 0x0001, 
	0x4042, 0x8000, 0x447b, 0x0001, 0x4043, 0x8000, 0x447b, 0x06a0, 
	0x4042, 0x8000, 0x447b, 0x06a0, 0x4043, 0x8000, 0x447f, 0x06a0, 
	0x4042, 0x8000, 0x4481, 0x06a0, 0x4042, 0x8000, 0x4483, 0x06a0, 
	0x4042, 0x8000, 0x4485, 0x0001, 0x4043, 0x8000, 0x4485, 0x06a0, 
	0x4042, 0x8000, 0x4485, 0x06a0, 0x4043, 0x8000, 0x4489, 0x06a0, 
	0x4042, 0x8000, 0x448b, 0x0001, 0x4043, 0x8000, 0x448b, 0x06a0, 
	0x4042, 0x8000, 0x448b, 0x06a0, 0x4043, 0x8000, 0x448f, 0x06a0, 
	0x4042, 0x8000, 0x4491, 0x0001, 0x4043, 0x8000, 0x4491, 0x0001, 
	0x4044, 0x8000, 0x4491, 0x06a0, 0x4042, 0x8000, 0x4491, 0x06a0, 
	0x4043, 0x8000, 0x4491, 0x06a0, 0x4044, 0x8000, 0x4491, 0x06a0, 
	0x4045, 0x8000, 0x4498, 0x06a0, 0x4042, 0x8000, 0x449a, 0x06a0, 
	0x4042, 0x8000, 0x449c, 0x06a0, 0x4042, 0x8000, 0x449e, 0x06a0, 
	0x4042, 0x8000, 0x44a0, 0x06a0, 0x4042, 0x8000, 0x44a2, 0x0001, 
	0x4043, 0x8000, 0x44a2, 0x06a0, 0x4042, 0x8000, 0x44a2, 0x06a0, 
	0x4043, 0x8000, 0x44a6, 0x06a0, 0x4042, 0x8000, 0x44a8, 0x06a0, 
	0x4042, 0x8000, 0x44aa, 0x06a0, 0x4042, 0x8000, 0x44aa, 0x06a0, 
	0x7ffe, 0x8000, 0x44ad, 0x06a0, 0x4042, 0x8000, 0x44af, 0x0001, 
	0x4043, 0x8000, 0x44af, 0x0001, 0x4044, 0x8000, 0x44af, 0x06a0, 
	0x4042, 0x8000, 0x44af, 0x06a0, 0x4043, 0x8000, 0x44af, 0x06a0, 
	0x4044, 0x8000, 0x44af, 0x06a0, 0x4045, 0x8000, 0x44b6, 0x06a0, 
	0x4042, 0x8000, 0x44b8, 0x06a0, 0x4042, 0x8000, 0x44ba, 0x06a0, 
	0x4042, 0x8000, 0x44bc, 0x0001, 0x4043, 0x8000, 0x44bc, 0x06a0, 
	0x4042, 0x8000, 0x44bc, 0x06a0, 0x4043, 0x8000, 0x7ffe, 0x0046, 
	0x4001, 0x8000, 0x44c0, 0x0046, 0x46a0, 0x8000, 0x44c2, 0x0046, 
	0x46a0, 0x8000, 0x44c4, 0x0046, 0x46a0, 0x8000, 0x44c6, 0x0046, 
	0x46a0, 0x8000, 0x44c8, 0x0046, 0x46a0, 0x8000, 0x44ca, 0x0046, 
	0x46a0, 0x8000, 0x44cc, 0x0046, 0x46a0, 0x8000, 0x44ce, 0x0046, 
	0x46a0, 0x8000, 0x44d0, 0x0046, 0x46a0, 0x8000, 0x44d2, 0x0046, 
	0x46a0, 0x8000, 0x44d4, 0x0046, 0x46a0, 0x8000, 0x44d6, 0x0046, 
	0x46a0, 0x8000, 0x44d8, 0x0046, 0x46a0, 0x8000, 0x44da, 0x0046, 
	0x46a0, 0x8000, 0x44dc, 0x0046, 0x46a0, 0x8000, 0x44de, 0x0046, 
	0x46a0, 0x8000, 0x44e0, 0x0046, 0x46a0, 0x8000, 0x44e2, 0x0046, 
	0x46a0, 0x8000, 0x44e4, 0x0046, 0x46a0, 0x8000, 0x44e6, 0x0046, 
	0x46a0, 0x8000, 0x44e8, 0x0046, 0x46a0, 0x8000, 0x44ea, 0x0046, 
	0x46a0, 0x8000, 0x44ec, 0x0046, 0x46a0, 0x8000, 0x44ee, 0x0046, 
	0x46a0, 0x8000, 0x44f0, 0x0046, 0x46a0, 0x8000, 0x44f2, 0x0046, 
	0x46a0, 0x8000, 0x44f4, 0x0046, 0x46a0, 0x8000, 0x44f6, 0x0046, 
	0x46a0, 0x8000, 0x44f8, 0x0046, 0x46a0, 0x8000, 0x44fa, 0x0046, 
	0x46a0, 0x8000, 0x44fc, 0x0046, 0x46a0, 0x8000, 0x44fe, 0x0046, 
	0x46a0, 0x8000, 0x4500, 0x0046, 0x46a0, 0x8000, 0x4502, 0x0046, 
	0x46a0, 0x8000, 0x4504, 0x0046, 0x46a0, 0x8000, 0x4506, 0x0046, 
	0x46a0, 0x8000, 0x4508, 0x0046, 0x46a0, 0x8000, 0x450a, 0x0046, 
	0x46a0, 0x8000, 0x450c, 0x0046, 0x46a0, 0x8000, 0x450e, 0x0046, 
	0x46a0, 0x8000, 0x4510, 0x0046, 0x46a0, 0x8000, 0x7ffe, 0x0046, 
	0x46a0, 0x8000, 0x4512, 0x0046, 0x4001, 0x8000, 0x4514, 0x0046, 
	0x46a0, 0x8000, 0x4516, 0x0046, 0x4001, 0x8000, 0x4518, 0x0046, 
	0x46a0, 0x8000, 0x451a, 0x0046, 0x46a0, 0x8000, 0x451c, 0x0046, 
	0x46a0, 0x8000, 0x451e, 0x0046, 0x46a0, 0x8000, 0x4520, 0x0046, 
	0x46a0, 0x8000, 0x4522, 0x0046, 0x46a0, 0x8000, 0x4524, 0x0046, 
	0x46a0, 0x8000, 0x4526, 0x0046, 0x46a0, 0x8000, 0x7ffe,      0, 
	0x4000, 0x8000, 0x7ffe, 0x3ffe, 0x4000, 0x8000, 0x4548, 0x3ffe, 
	0x4000, 0x8000, 0x4547, 0x3ffe, 0x4000, 0x8000, 0x4551, 0x3ffe, 
	0x4000, 0x8000, 0x4555, 0x3ffe, 0x4000, 0x8000, 0x455c, 0x3ffe, 
	0x4000, 0x8000, 0x4564, 0x3ffe, 0x4000, 0x8000, 0x4569, 0x3ffe, 
	0x4000, 0x8000, 0x456e, 0x3ffe, 0x4000, 0x8000, 0x4573, 0x3ffe, 
	0x4000, 0x8000, 0x4578, 0x3ffe, 0x4000, 0x8000, 0x457b, 0x3ffe, 
	0x4000, 0x8000, 0x457e, 0x3ffe, 0x4000, 0x8000, 0x4581, 0x3ffe, 
	0x4000, 0x8000, 0x4584, 0x3ffe, 0x4000, 0x8000, 0x4589, 0x3ffe, 
	0x4000, 0x8000, 0x458e, 0x3ffe, 0x4000, 0x8000, 0x4593, 0x3ffe, 
	0x4000, 0x8000, 0x4598, 0x3ffe, 0x4000, 0x8000, 0x459d, 0x3ffe, 
	0x4000, 0x8000, 0x45a2, 0x3ffe, 0x4000, 0x8000, 0x45a7, 0x3ffe, 
	0x4000, 0x8000, 0x45ac, 0x3ffe, 0x4000, 0x8000, 0x45b1, 0x3ffe, 
	0x4000, 0x8000, 0x45b6, 0x3ffe, 0x4000, 0x8000, 0x45bb, 0x3ffe, 
	0x4000, 0x8000, 0x45c0, 0x3ffe, 0x4000, 0x8000, 0x45c5, 0x3ffe, 
	0x4000, 0x8000, 0x45ca, 0x3ffe, 0x4000, 0x8000, 0x45cf, 0x3ffe, 
	0x4000, 0x8000, 0x45d2, 0x3ffe, 0x4000, 0x8000, 0x45d5, 0x3ffe, 
	0x4000, 0x8000, 0x4000,      0, 0x7ffe, 0x8000, 0x46c3, 0x3ffe, 
	0x4000, 0x8000, 0x46cc, 0x3ffe, 0x4000, 0x8000, 0x46cd, 0x3ffe, 
	0x4000, 0x8000, 0x46ce, 0x3ffe, 0x4000, 0x8000, 0x46cf, 0x3ffe, 
	0x4000, 0x8000, 0x46d0, 0x3ffe, 0x4000, 0x8000, 0x46d1, 0x3ffe, 
	0x4000, 0x8000, 0x46d2, 0x3ffe, 0x4000, 0x8000, 0x46d3, 0x3ffe, 
	0x4000, 0x8000, 0x46d4, 0x3ffe, 0x4000, 0x8000, 0x48a7, 0x08aa, 
	0x48ad, 0x8000, 0x48a7, 0x08b0, 0x48b3, 0x8000, 0x48b6, 0x08b9, 
	0x48bc, 0x8000, 0x48b6, 0x08bf, 0x48c2, 0x8000, 0x48c5, 0x08c8, 
	0x48cb, 0x8000, 0x48c5, 0x08ce, 0x48d1, 0x8000, 0x48d4, 0x08d7, 
	0x48da, 0x8000, 0x48d4, 0x08dd, 0x48e0, 0x8000, 0x45f5, 0x3ffe, 
	0x4000, 0x8000, 0x45f9, 0x3ffe, 0x4000, 0x8000, 0x45fd, 0x3ffe, 
	0x4000, 0x8000, 0x4602, 0x3ffe, 0x4000, 0x8000, 0x4606, 0x3ffe, 
	0x4000, 0x8000, 0x460a, 0x3ffe, 0x4000, 0x8000, 0x460f, 0x3ffe, 
	0x4000, 0x8000, 0x4613, 0x3ffe, 0x4000, 0x8000, 0x4617, 0x3ffe, 
	0x4000, 0x8000, 0x461c, 0x3ffe, 0x4000, 0x8000, 0x4620, 0x3ffe, 
	0x4000, 0x8000, 0x4624, 0x3ffe, 0x4000, 0x8000, 0x4628, 0x3ffe, 
	0x4000, 0x8000, 0x462c, 0x3ffe, 0x4000, 0x8000, 0x4630, 0x3ffe, 
	0x4000, 0x8000, 0x4634, 0x3ffe, 0x4000, 0x8000, 0x4638, 0x3ffe, 
	0x4000, 0x8000, 0x463c, 0x3ffe, 0x4000, 0x8000, 0x4642, 0x3ffe, 
	0x4000, 0x8000, 0x4646, 0x3ffe, 0x4000, 0x8000, 0x464a, 0x3ffe, 
	0x4000, 0x8000, 0x464c, 0x3ffe, 0x4000, 0x8000, 0x464e, 0x3ffe, 
	0x4000, 0x8000, 0x4650, 0x3ffe, 0x4000, 0x8000, 0x4652, 0x3ffe, 
	0x4000, 0x8000, 0x4654, 0x3ffe, 0x4000, 0x8000, 0x465a, 0x3ffe, 
	0x4000, 0x8000, 0x4660, 0x3ffe, 0x4000, 0x8000, 0x4666, 0x3ffe, 
	0x4000, 0x8000, 0x466c, 0x3ffe, 0x4000, 0x8000, 0x4672, 0x3ffe, 
	0x4000, 0x8000, 0x4674, 0x3ffe, 0x4000, 0x8000, 0x4676, 0x3ffe, 
	0x4000, 0x8000, 0x4678, 0x3ffe, 0x4000, 0x8000, 0x467a, 0x3ffe, 
	0x4000, 0x8000, 0x467c, 0x3ffe, 0x4000, 0x8000, 0x4680, 0x3ffe, 
	0x4000, 0x8000, 0x4684, 0x3ffe, 0x4000, 0x8000, 0x4688, 0x3ffe, 
	0x4000, 0x8000, 0x468a, 0x3ffe, 0x4000, 0x8000, 0x468c, 0x3ffe, 
	0x4000, 0x8000, 0x468e, 0x3ffe, 0x4000, 0x8000, 0x4690, 0x3ffe, 
	0x4000, 0x8000, 0x4692, 0x3ffe, 0x4000, 0x8000, 0x4696, 0x3ffe, 
	0x4000, 0x8000, 0x4698, 0x3ffe, 0x4000, 0x8000, 0x469a, 0x3ffe, 
	0x4000, 0x8000, 0x469c, 0x3ffe, 0x4000, 0x8000, 0x42a9, 0x0003, 
	0x4001, 0x8000, 0x42a9, 0x0003, 0x46a0, 0x8000, 0x42a9, 0x0019, 
	0x4001, 0x8000, 0x42a9, 0x0019, 0x46a0, 0x8000, 0x42a9, 0x001a, 
	0x4001, 0x8000, 0x42a9, 0x001a, 0x46a0, 0x8000, 0x42a9, 0x001c, 
	0x4001, 0x8000, 0x42a9, 0x001c, 0x46a0, 0x8000, 0x42a9, 0x0030, 
	0x4001, 0x8000, 0x42a9, 0x0030, 0x46a0, 0x8000, 0x42a9, 0x0032, 
	0x4001, 0x8000, 0x42a9, 0x0032, 0x46a0, 0x8000, 0x48e3, 0x08e6, 
	0x4892, 0x8000, 0x48e3, 0x08e6, 0x4895, 0x8000, 0x48e3, 0x08e9, 
	0x4892, 0x8000, 0x48e3, 0x08e9, 0x4895, 0x8000, 0x48e3, 0x08ec, 
	0x4892, 0x8000, 0x48e3, 0x08ec, 0x4895, 0x8000, 0x42e2, 0x0003, 
	0x4001, 0x8000, 0x42e2, 0x0003, 0x46a0, 0x8000, 0x42e2, 0x0016, 
	0x4001, 0x8000, 0x42e2, 0x0016, 0x46a0, 0x8000, 0x46f4, 0x0002, 
	0x46a0, 0x8000, 0x42ed, 0x002a, 0x4001, 0x8000, 0x42ed, 0x002a, 
	0x46a0, 0x8000, 0x42fc, 0x0003, 0x4001, 0x8000, 0x42fc, 0x0003, 
	0x46a0, 0x8000, 0x42fc, 0x0030, 0x4001, 0x8000, 0x42fc, 0x0030, 
	0x46a0, 0x8000, 0x42fc, 0x0032, 0x4001, 0x8000, 0x42fc, 0x0032, 
	0x46a0, 0x8000, 0x4335, 0x002c, 0x4001, 0x8000, 0x4335, 0x002c, 
	0x46a0, 0x8000, 0x4700, 0x0002, 0x46a0, 0x8000, 0x4703, 0x0002, 
	0x4001, 0x8000, 0x7ffe, 0x0002, 0x46a0, 0x8000, 0x4702, 0x0002, 
	0x4001, 0x8000, 0x4702, 0x0003, 0x4001, 0x8000, 0x4702, 0x0003, 
	0x46a0, 0x8000, 0x4702, 0x0032, 0x4001, 0x8000, 0x4702, 0x0032, 
	0x46a0, 0x8000, 0x4378, 0x002c, 0x4001, 0x8000, 0x4378, 0x002c, 
	0x46a0, 0x8000, 0x4385, 0x002a, 0x4001, 0x8000, 0x4385, 0x002a, 
	0x46a0, 0x8000, 0x4385, 0x002c, 0x4001, 0x8000, 0x4385, 0x002c, 
	0x46a0, 0x8000, 0x439f, 0x0003, 0x4001, 0x8000, 0x439f, 0x0003, 
	0x46a0, 0x8000, 0x439f, 0x0023, 0x4001, 0x8000, 0x439f, 0x0023, 
	0x46a0, 0x8000, 0x439f, 0x002c, 0x4001, 0x8000, 0x439f, 0x002c, 
	0x46a0, 0x8000, 0x48ef, 0x08f2, 0x4892, 0x8000, 0x48ef, 0x08f2, 
	0x4895, 0x8000, 0x43ad, 0x0003, 0x4001, 0x8000, 0x43ad, 0x0003, 
	0x46a0, 0x8000, 0x43ad, 0x0021, 0x4001, 0x8000, 0x43ad, 0x0021, 
	0x46a0, 0x8000, 0x43ad, 0x0023, 0x4001, 0x8000, 0x43ad, 0x0023, 
	0x46a0, 0x8000, 0x43ad, 0x002a, 0x4001, 0x8000, 0x43ad, 0x002a, 
	0x46a0, 0x8000, 0x43ad, 0x002b, 0x4001, 0x8000, 0x43ad, 0x002b, 
	0x46a0, 0x8000, 0x43ad, 0x0032, 0x4001, 0x8000, 0x43ad, 0x0032, 
	0x46a0, 0x8000, 0x4724, 0x0002, 0x46a0, 0x8000, 0x48f5, 0x08f8, 
	0x4892, 0x8000, 0x48f5, 0x08f8, 0x4895, 0x8000, 0x43ed, 0x002c, 
	0x4001, 0x8000, 0x43ed, 0x002c, 0x46a0, 0x8000, 0x4400, 0x0003, 
	0x4001, 0x8000, 0x4400, 0x0003, 0x46a0, 0x8000, 0x4400, 0x0016, 
	0x4001, 0x8000, 0x4400, 0x0016, 0x46a0, 0x8000, 0x472e, 0x0002, 
	0x46a0, 0x8000, 0x48fb, 0x08fe, 0x4892, 0x8000, 0x48fb, 0x08fe, 
	0x4895, 0x8000, 0x4424, 0x0003, 0x4001, 0x8000, 0x4424, 0x0003, 
	0x46a0, 0x8000, 0x4424, 0x0021, 0x4001, 0x8000, 0x4424, 0x0021, 
	0x46a0, 0x8000, 0x4424, 0x0032, 0x4001, 0x8000, 0x4424, 0x0032, 
	0x46a0, 0x8000, 0x4738, 0x0002, 0x46a0, 0x8000, 0x473a, 0x0002, 
	0x46a0, 0x8000, 0x473a, 0x0023, 0x4001, 0x8000, 0x473a, 0x0023, 
	0x46a0, 0x8000, 0x473a, 0x0028, 0x4001, 0x8000, 0x473a, 0x0028, 
	0x46a0, 0x8000, 0x4740, 0x0002, 0x46a0, 0x8000, 0x4740, 0x0003, 
	0x4001, 0x8000, 0x4740, 0x0003, 0x46a0, 0x8000, 0x4740, 0x0005, 
	0x4001, 0x8000, 0x4740, 0x0005, 0x46a0, 0x8000, 0x4740, 0x0010, 
	0x4001, 0x8000, 0x4740, 0x0010, 0x46a0, 0x8000, 0x4740, 0x001c, 
	0x4001, 0x8000, 0x4740, 0x001c, 0x46a0, 0x8000, 0x4740, 0x0027, 
	0x4001, 0x8000, 0x4740, 0x0027, 0x46a0, 0x8000, 0x4740, 0x0028, 
	0x4001, 0x8000, 0x4740, 0x0028, 0x46a0, 0x8000, 0x474e, 0x0002, 
	0x46a0, 0x8000, 0x474e, 0x0003, 0x4001, 0x8000, 0x474e, 0x0003, 
	0x46a0, 0x8000, 0x4753, 0x0002, 0x46a0, 0x8000, 0x4753, 0x0003, 
	0x4001, 0x8000, 0x4753, 0x0003, 0x46a0, 0x8000, 0x4753, 0x0016, 
	0x4001, 0x8000, 0x4753, 0x0016, 0x46a0, 0x8000, 0x4753, 0x0027, 
	0x4001, 0x8000, 0x4753, 0x0027, 0x46a0, 0x8000, 0x4378, 0x3ffe, 
	0x46a0, 0x8000, 0x42e2, 0x002c, 0x4001, 0x8000, 0x42e2, 0x002c, 
	0x46a0, 0x8000, 0x4335, 0x0007, 0x4001, 0x8000, 0x4335, 0x0007, 
	0x46a0, 0x8000, 0x4702, 0x0027, 0x4001, 0x8000, 0x4702, 0x0027, 
	0x46a0, 0x8000, 0x4400, 0x002c, 0x4001, 0x8000, 0x4400, 0x002c, 
	0x46a0, 0x8000, 0x7ffe, 0x3ffe, 0x4002, 0x8001, 0x473a, 0x073a, 
	0x4002, 0x86a0, 0x473a, 0x073a, 0x4023, 0x8001, 0x473a, 0x073a, 
	0x4023, 0x86a0, 0x473a, 0x073a, 0x4028, 0x8001, 0x473a, 0x073a, 
	0x4028, 0x86a0, 0x4740, 0x0740, 0x4002, 0x86a0, 0x4740, 0x0740, 
	0x4003, 0x8001, 0x4740, 0x0740, 0x4003, 0x86a0, 0x4740, 0x0740, 
	0x4005, 0x8001, 0x4740, 0x0740, 0x4005, 0x86a0, 0x4740, 0x0740, 
	0x4010, 0x8001, 0x4740, 0x0740, 0x4010, 0x86a0, 0x4740, 0x0740, 
	0x401c, 0x8001, 0x4740, 0x0740, 0x401c, 0x86a0, 0x4740, 0x0740, 
	0x4027, 0x8001, 0x4740, 0x0740, 0x4027, 0x86a0, 0x4740, 0x0740, 
	0x4028, 0x8001, 0x4740, 0x0740, 0x4028, 0x86a0, 0x474e, 0x0049, 
	0x4001, 0x8000, 0x474e, 0x0049, 0x46a0, 0x8000, 0x46e0, 0x0002, 
	0x46a0, 0x8000, 0x46e0, 0x0003, 0x4001, 0x8000, 0x46e0, 0x0003, 
	0x46a0, 0x8000, 0x46e4, 0x0002, 0x46a0, 0x8000, 0x46e4, 0x3ffe, 
	0x4001, 0x8000, 0x46e4, 0x06ea, 0x46a0, 0x8000, 0x46e4, 0x06ec, 
	0x46a0, 0x8000, 0x46e4, 0x06ee, 0x46a0, 0x8000, 0x4724, 0x3ffe, 
	0x4001, 0x8000, 0x4724, 0x071e, 0x46a0, 0x8000, 0x4724, 0x0720, 
	0x46a0, 0x8000, 0x4724, 0x0023, 0x4001, 0x8000, 0x4724, 0x0023, 
	0x46a0, 0x8000, 0x46f3, 0x0002, 0x4001, 0x8000, 0x43ad, 0x001c, 
	0x4001, 0x8000, 0x43ad, 0x001c, 0x46a0, 0x8000, 0x472d, 0x0002, 
	0x4001, 0x8000, 0x4424, 0x001c, 0x4001, 0x8000, 0x4424, 0x001c, 
	0x46a0, 0x8000, 0x4758, 0x0002, 0x4001, 0x8000, 0x46e6, 0x0002, 
	0x46a0, 0x8000, 0x46f0, 0x0002, 0x46a0, 0x8000, 0x46fa, 0x0002, 
	0x46a0, 0x8000, 0x470c, 0x0002, 0x46a0, 0x8000, 0x4710, 0x0002, 
	0x46a0, 0x8000, 0x4718, 0x0002, 0x46a0, 0x8000, 0x472a, 0x0002, 
	0x46a0, 0x8000, 0x4755, 0x0002, 0x46a0, 0x8000, 0x4759, 0x0002, 
	0x46a0, 0x8000, 0x474e, 0x3ffe, 0x4001, 0x8000, 0x474e, 0x0738, 
	0x46a0, 0x8000, 0x474e, 0x0734, 0x46a0, 0x8000, 0x46ea, 0x0002, 
	0x46a0, 0x8000, 0x46ea, 0x0003, 0x4001, 0x8000, 0x46ea, 0x0003, 
	0x46a0, 0x8000, 0x46ea, 0x0032, 0x4001, 0x8000, 0x46ea, 0x0032, 
	0x46a0, 0x8000, 0x46ea, 0x0049, 0x4001, 0x8000, 0x46ea, 0x0049, 
	0x46a0, 0x8000, 0x471e, 0x0002, 0x46a0, 0x8000, 0x471e, 0x0003, 
	0x4001, 0x8000, 0x471e, 0x0003, 0x46a0, 0x8000, 0x471e, 0x001c, 
	0x4001, 0x8000, 0x471e, 0x001c, 0x46a0, 0x8000, 0x471e, 0x0021, 
	0x4001, 0x8000, 0x471e, 0x0021, 0x46a0, 0x8000, 0x46e0, 0x3ffe, 
	0x4001, 0x8000, 0x46e0, 0x075b, 0x469e, 0x8000, 0x46e0, 0x075b, 
	0x469f, 0x8000, 0x46e0, 0x075b, 0x46a0, 0x8000, 0x46e0, 0x06e2, 
	0x46a0, 0x8000, 0x46e8, 0x0002, 0x46a0, 0x8000, 0x46f2, 0x0002, 
	0x46a0, 0x8000, 0x46fc, 0x0002, 0x46a0, 0x8000, 0x46fe, 0x0002, 
	0x46a0, 0x8000, 0x4707, 0x0002, 0x46a0, 0x8000, 0x4709, 0x0002, 
	0x46a0, 0x8000, 0x470e, 0x0002, 0x46a0, 0x8000, 0x4714, 0x0002, 
	0x46a0, 0x8000, 0x4722, 0x0002, 0x46a0, 0x8000, 0x4728, 0x0002, 
	0x46a0, 0x8000, 0x472c, 0x0002, 0x46a0, 0x8000, 0x4736, 0x0002, 
	0x46a0, 0x8000, 0x4757, 0x0002, 0x46a0, 0x8000, 0x46a1, 0x3ffe, 
	0x4000, 0x8000, 0x42ed, 0x3ffe, 0x4001, 0x8000, 0x42ed, 0x075f, 
	0x46a0, 0x8000, 0x43ea, 0x0049, 0x46a0, 0x8000, 0x46df, 0x0002, 
	0x4001, 0x8000, 0x4760, 0x0002, 0x4001, 0x8000, 0x46f9, 0x0002, 
	0x4001, 0x8000, 0x4335, 0x0008, 0x4001, 0x8000, 0x4335, 0x0008, 
	0x46a0, 0x8000, 0x4706, 0x0002, 0x4001, 0x8000, 0x439f, 0x3ffe, 
	0x4001, 0x8000, 0x439f, 0x0716, 0x46a0, 0x8000, 0x4719, 0x0002, 
	0x4001, 0x8000, 0x4733, 0x0002, 0x4001, 0x8000, 0x4751, 0x0002, 
	0x4001, 0x8000, 0x4731, 0x0002, 0x4001, 0x8000, 0x46eb, 0x0002, 
	0x4001, 0x8000, 0x46eb, 0x0049, 0x46a0, 0x8000, 0x46eb, 0x0049, 
	0x4001, 0x8000, 0x4725, 0x0002, 0x4001, 0x8000, 0x4725, 0x0049, 
	0x46a0, 0x8000, 0x4725, 0x0049, 0x4001, 0x8000, 0x4000,      0, 
	0x4010, 0x8000, 0x4000,      0, 0x4032, 0x8000, 0x4000,      0, 
	0x4005, 0x8000, 0x4787, 0x0002, 0x469e, 0x8000, 0x4787, 0x0002, 
	0x469f, 0x8000, 0x4787, 0x0002, 0x46a0, 0x8000, 0x46f6, 0x0002, 
	0x46a0, 0x8000, 0x478b, 0x0002, 0x469e, 0x8000, 0x478b, 0x0002, 
	0x469f, 0x8000, 0x478b, 0x0002, 0x46a0, 0x8000, 0x478f, 0x0002, 
	0x469e, 0x8000, 0x478f, 0x0002, 0x469f, 0x8000, 0x478f, 0x0002, 
	0x46a0, 0x8000, 0x4712, 0x0002, 0x46a0, 0x8000, 0x7ffe, 0x0016, 
	0x4001, 0xbffe, 0x472c, 0x0016, 0x46a0, 0xbffe, 0x7ffe, 0x0002, 
	0x4001, 0xbffe, 0x4753, 0x0002, 0x46a0, 0xbffe, 0x4753, 0x0003, 
	0x4001, 0xbffe, 0x4753, 0x0003, 0x46a0, 0xbffe, 0x4753, 0x0027, 
	0x4001, 0xbffe, 0x4753, 0x0027, 0x46a0, 0xbffe, 0x4753, 0x0016, 
	0x4001, 0xbffe, 0x4753, 0x0016, 0x46a0, 0xbffe, 0x473a, 0x3ffe, 
	0x4002, 0x8001, 0x473a, 0x0740, 0x4002, 0x86a0, 0x473a, 0x0740, 
	0x4003, 0x8001, 0x473a, 0x0740, 0x4003, 0x86a0, 0x473a, 0x0740, 
	0x4005, 0x8001, 0x473a, 0x0740, 0x4005, 0x86a0, 0x473a, 0x0740, 
	0x4010, 0x8001, 0x473a, 0x0740, 0x4010, 0x86a0, 0x473a, 0x0740, 
	0x4032, 0x8001, 0x473a, 0x0740, 0x4032, 0x86a0, 0x473a, 0x0740, 
	0x4027, 0x8001, 0x473a, 0x0740, 0x4027, 0x86a0, 0x473a, 0x0740, 
	0x401c, 0x8001, 0x473a, 0x0740, 0x401c, 0x86a0, 0x7ffe, 0x0023, 
	0x4001, 0xbffe, 0x471c, 0x0023, 0x46a0, 0xbffe, 0x7ffe, 0x001c, 
	0x4001, 0xbffe, 0x46e4, 0x001c, 0x46a0, 0xbffe, 0x4724, 0x001c, 
	0x46a0, 0xbffe, 0x4738, 0x001c, 0x46a0, 0xbffe, 0x4793, 0x0002, 
	0x469e, 0x8000, 0x4793, 0x0002, 0x469f, 0x8000, 0x4793, 0x0002, 
	0x46a0, 0x8000, 0x4797, 0x0002, 0x469e, 0x8000, 0x4797, 0x0002, 
	0x469f, 0x8000, 0x4797, 0x0002, 0x46a0, 0x8000, 0x7ffe, 0x7ffe, 
	0x7ffe, 0x7ffe, 0x4000, 0x4000, 0x4000, 0x7ffe, 0x7ffe, 0x4005, 
	0x4001, 0x7ffe, 0x4056, 0x4005, 0x4004, 0x4056, 0x4056, 0x4005, 
	0x7ffe, 0x4056, 0x4056, 0x4008, 0x4001, 0x4056, 0x4056, 0x4008, 
	0x4004, 0x4056, 0x4056, 0x4009, 0x4001, 0x4056, 0x4056, 0x4009, 
	0x4004, 0x4056, 0x4056, 0x4015, 0x4001, 0x4056, 0x4056, 0x4015, 
	0x4004, 0x4056, 0x4056, 0x400d, 0x4001, 0x4056, 0x4056, 0x400d, 
	0x4004, 0x4056, 0x4056, 0x4018, 0x4001, 0x4056, 0x4056, 0x4018, 
	0x4004, 0x4056, 0x4056, 0x4019, 0x4001, 0x4056, 0x4056, 0x4019, 
	0x4004, 0x4056, 0x4056, 0x401b, 0x4001, 0x4056, 0x4056, 0x401b, 
	0x4004, 0x4056, 0x4056, 0x401a, 0x4001, 0x4056, 0x4056, 0x401a, 
	0x4004, 0x4056, 0x4056, 0x4033, 0x4001, 0x4056, 0x4056, 0x4033, 
	0x4004, 0x4056, 0x4056, 0x400e, 0x4001, 0x4056, 0x4056, 0x400e, 
	0x4004, 0x4056, 0x4056, 0x400a, 0x4001, 0x4056, 0x4056, 0x400a, 
	0x4004, 0x4056, 0x4056, 0x401c, 0x4001, 0x4056, 0x4056, 0x401c, 
	0x4004, 0x4056, 0x4056, 0x401d, 0x4001, 0x4056, 0x4056, 0x401d, 
	0x4004, 0x4056, 0x4056, 0x401f, 0x4001, 0x4056, 0x4056, 0x401f, 
	0x4004, 0x4056, 0x4056, 0x401e, 0x4001, 0x4056, 0x4056, 0x401e, 
	0x4004, 0x4056, 0x4056, 0x4034, 0x4001, 0x4056, 0x4056, 0x4034, 
	0x4004, 0x4056, 0x4056, 0x400b, 0x4001, 0x4056, 0x4056, 0x400b, 
	0x4004, 0x4056, 0x4056, 0x400f, 0x4001, 0x4056, 0x4056, 0x400f, 
	0x4004, 0x4056, 0x4056, 0x4021, 0x4001, 0x4056, 0x4056, 0x4021, 
	0x4004, 0x4056, 0x4056, 0x4042, 0x4001, 0x4056, 0x4056, 0x4042, 
	0x4004, 0x4056, 0x4056, 0x4012, 0x4001, 0x4056, 0x4056, 0x4012, 
	0x4004, 0x4056, 0x4056, 0x402a, 0x4001, 0x4056, 0x4056, 0x402a, 
	0x4004, 0x4056, 0x4056, 0x4010, 0x4001, 0x4056, 0x4056, 0x4010, 
	0x4004, 0x4056, 0x4056, 0x400c, 0x4001, 0x4056, 0x4056, 0x400c, 
	0x4004, 0x4056, 0x4056, 0x403c, 0x4001, 0x4056, 0x4056, 0x403c, 
	0x4004, 0x4056, 0x4056, 0x4041, 0x4001, 0x4056, 0x4056, 0x4041, 
	0x4004, 0x4056, 0x4056, 0x4007, 0x4001, 0x4056, 0x4056, 0x4007, 
	0x4004, 0x4056, 0x4056, 0x4022, 0x4001, 0x4056, 0x4056, 0x4022, 
	0x4004, 0x4056, 0x48c4, 0x48c7, 0x4855, 0x48c4, 0x48c4, 0x48c7, 
	0x47f9, 0x48c4, 0x48c4, 0x48ca, 0x4855, 0x48c4, 0x48c4, 0x48ca, 
	0x47f9, 0x48c4, 0x48c4, 0x48cd, 0x4855, 0x48c4, 0x48c4, 0x48cd, 
	0x47f9, 0x48c4, 0x4098, 0x4005, 0x4004, 0x4098, 0x4098, 0x4006, 
	0x4001, 0x4098, 0x4098, 0x4006, 0x4004, 0x4098, 0x4098, 0x403c, 
	0x4001, 0x4098, 0x4098, 0x403c, 0x4004, 0x4098, 0x4098, 0x403d, 
	0x4001, 0x4098, 0x4098, 0x403d, 0x4004, 0x4098, 0x40a1, 0x4005, 
	0x4004, 0x40a1, 0x40a1, 0x4008, 0x4001, 0x40a1, 0x40a1, 0x4008, 
	0x4004, 0x40a1, 0x40a1, 0x400a, 0x4001, 0x40a1, 0x40a1, 0x400a, 
	0x4004, 0x40a1, 0x40a1, 0x4010, 0x4001, 0x40a1, 0x40a1, 0x4010, 
	0x4004, 0x40a1, 0x40a1, 0x4006, 0x4001, 0x40a1, 0x40a1, 0x4006, 
	0x4004, 0x40a1, 0x40a1, 0x4040, 0x4001, 0x40a1, 0x40a1, 0x4040, 
	0x4004, 0x40a1, 0x40a1, 0x4035, 0x4001, 0x40a1, 0x40a1, 0x4035, 
	0x4004, 0x40a1, 0x7ffe, 0x400b, 0x4001, 0x7ffe, 0x40af, 0x400b, 
	0x4004, 0x40af, 0x40b2, 0x4005, 0x4004, 0x40b2, 0x40b2, 0x400b, 
	0x4001, 0x40b2, 0x40b2, 0x400b, 0x4004, 0x40b2, 0x40b2, 0x4006, 
	0x4001, 0x40b2, 0x40b2, 0x4006, 0x4004, 0x40b2, 0x40b2, 0x403c, 
	0x4001, 0x40b2, 0x40b2, 0x403c, 0x4004, 0x40b2, 0x40b2, 0x4044, 
	0x4001, 0x40b2, 0x40b2, 0x4044, 0x4004, 0x40b2, 0x40b2, 0x4040, 
	0x4001, 0x40b2, 0x40b2, 0x4040, 0x4004, 0x40b2, 0x40b2, 0x4025, 
	0x4001, 0x40b2, 0x40b2, 0x4025, 0x4004, 0x40b2, 0x40b2, 0x403d, 
	0x4001, 0x40b2, 0x40b2, 0x403d, 0x4004, 0x40b2, 0x40c3, 0x4005, 
	0x4004, 0x40c3, 0x40c3, 0x4008, 0x4001, 0x40c3, 0x40c3, 0x4008, 
	0x4004, 0x40c3, 0x40c3, 0x4009, 0x4001, 0x40c3, 0x40c3, 0x4009, 
	0x4004, 0x40c3, 0x40c3, 0x4015, 0x4001, 0x40c3, 0x40c3, 0x4015, 
	0x4004, 0x40c3, 0x40c3, 0x400d, 0x4001, 0x40c3, 0x40c3, 0x400d, 
	0x4004, 0x40c3, 0x40c3, 0x400e, 0x4001, 0x40c3, 0x40c3, 0x400e, 
	0x4004, 0x40c3, 0x40c3, 0x400a, 0x4001, 0x40c3, 0x40c3, 0x400a, 
	0x4004, 0x40c3, 0x40c3, 0x401c, 0x4001, 0x40c3, 0x40c3, 0x401c, 
	0x4004, 0x40c3, 0x40c3, 0x401d, 0x4001, 0x40c3, 0x40c3, 0x401d, 
	0x4004, 0x40c3, 0x40c3, 0x401f, 0x4001, 0x40c3, 0x40c3, 0x401f, 
	0x4004, 0x40c3, 0x40c3, 0x401e, 0x4001, 0x40c3, 0x40c3, 0x401e, 
	0x4004, 0x40c3, 0x40c3, 0x4034, 0x4001, 0x40c3, 0x40c3, 0x4034, 
	0x4004, 0x40c3, 0x40c3, 0x400b, 0x4001, 0x40c3, 0x40c3, 0x400b, 
	0x4004, 0x40c3, 0x40c3, 0x4012, 0x4001, 0x40c3, 0x40c3, 0x4012, 
	0x4004, 0x40c3, 0x40c3, 0x4010, 0x4001, 0x40c3, 0x40c3, 0x4010, 
	0x4004, 0x40c3, 0x40c3, 0x400c, 0x4001, 0x40c3, 0x40c3, 0x400c, 
	0x4004, 0x40c3, 0x40c3, 0x403e, 0x4001, 0x40c3, 0x40c3, 0x403e, 
	0x4004, 0x40c3, 0x40c3, 0x4006, 0x4001, 0x40c3, 0x40c3, 0x4006, 
	0x4004, 0x40c3, 0x40c3, 0x403c, 0x4001, 0x40c3, 0x40c3, 0x403c, 
	0x4004, 0x40c3, 0x40c3, 0x4037, 0x4001, 0x40c3, 0x40c3, 0x4037, 
	0x4004, 0x40c3, 0x40c3, 0x4041, 0x4001, 0x40c3, 0x40c3, 0x4041, 
	0x4004, 0x40c3, 0x40c3, 0x4007, 0x4001, 0x40c3, 0x40c3, 0x4007, 
	0x4004, 0x40c3, 0x40c3, 0x4023, 0x4001, 0x40c3, 0x40c3, 0x4023, 
	0x4004, 0x40c3, 0x40c3, 0x4024, 0x4001, 0x40c3, 0x40c3, 0x4024, 
	0x4004, 0x40c3, 0x40c3, 0x4025, 0x4001, 0x40c3, 0x40c3, 0x4025, 
	0x4004, 0x40c3, 0x40f6, 0x4005, 0x4004, 0x40f6, 0x40f6, 0x4010, 
	0x4001, 0x40f6, 0x40f6, 0x4010, 0x4004, 0x40f6, 0x40f6, 0x4006, 
	0x4001, 0x40f6, 0x40f6, 0x4006, 0x4004, 0x40f6, 0x48d0, 0x48d3, 
	0x48d6, 0x48d0, 0x48d9, 0x48d3, 0x48dc, 0x48d9, 0x48df, 0x48d3, 
	0x48e2, 0x48df, 0x48e5, 0x48e9, 0x48ed, 0x48e5, 0x48f1, 0x48e9, 
	0x48f5, 0x48f1, 0x4102, 0x4005, 0x4004, 0x4102, 0x4102, 0x4008, 
	0x4001, 0x4102, 0x4102, 0x4008, 0x4004, 0x4102, 0x4102, 0x400d, 
	0x4001, 0x4102, 0x4102, 0x400d, 0x4004, 0x4102, 0x4102, 0x400a, 
	0x4001, 0x4102, 0x4102, 0x400a, 0x4004, 0x4102, 0x4102, 0x400b, 
	0x4001, 0x4102, 0x4102, 0x400b, 0x4004, 0x4102, 0x4102, 0x4006, 
	0x4001, 0x4102, 0x4102, 0x4006, 0x4004, 0x4102, 0x4102, 0x4044, 
	0x4001, 0x4102, 0x4102, 0x4044, 0x4004, 0x4102, 0x4102, 0x4040, 
	0x4001, 0x4102, 0x4102, 0x4040, 0x4004, 0x4102, 0x4102, 0x4007, 
	0x4001, 0x4102, 0x4102, 0x4007, 0x4004, 0x4102, 0x4115, 0x4005, 
	0x4004, 0x4115, 0x4115, 0x403f, 0x4001, 0x4115, 0x4115, 0x403f, 
	0x4004, 0x4115, 0x4115, 0x400a, 0x4001, 0x4115, 0x4115, 0x400a, 
	0x4004, 0x4115, 0x4115, 0x4012, 0x4001, 0x4115, 0x4115, 0x4012, 
	0x4004, 0x4115, 0x4115, 0x4006, 0x4001, 0x4115, 0x4115, 0x4006, 
	0x4004, 0x4115, 0x4115, 0x403c, 0x4001, 0x4115, 0x4115, 0x403c, 
	0x4004, 0x4115, 0x4115, 0x4044, 0x4001, 0x4115, 0x4115, 0x4044, 
	0x4004, 0x4115, 0x4115, 0x4040, 0x4001, 0x4115, 0x4115, 0x4040, 
	0x4004, 0x4115, 0x4126, 0x4005, 0x4002, 0x4126, 0x4126, 0x4005, 
	0x4004, 0x4126, 0x4129, 0x4005, 0x4004, 0x4129, 0x4129, 0x4008, 
	0x4001, 0x4129, 0x4129, 0x4008, 0x4004, 0x4129, 0x4129, 0x4009, 
	0x4001, 0x4129, 0x4129, 0x4009, 0x4004, 0x4129, 0x4129, 0x4015, 
	0x4001, 0x4129, 0x4129, 0x4015, 0x4004, 0x4129, 0x4129, 0x400d, 
	0x4001, 0x4129, 0x4129, 0x400d, 0x4004, 0x4129, 0x4129, 0x400e, 
	0x4001, 0x4129, 0x4129, 0x400e, 0x4004, 0x4129, 0x4129, 0x400a, 
	0x4001, 0x4129, 0x4129, 0x400a, 0x4004, 0x4129, 0x4129, 0x400b, 
	0x4001, 0x4129, 0x4129, 0x400b, 0x4004, 0x4129, 0x4129, 0x4012, 
	0x4001, 0x4129, 0x4129, 0x4012, 0x4004, 0x4129, 0x4129, 0x402b, 
	0x4001, 0x4129, 0x4129, 0x402b, 0x4004, 0x4129, 0x4129, 0x4010, 
	0x4001, 0x4129, 0x4129, 0x4010, 0x4004, 0x4129, 0x4129, 0x400c, 
	0x4001, 0x4129, 0x4129, 0x400c, 0x4004, 0x4129, 0x4129, 0x403e, 
	0x4001, 0x4129, 0x4129, 0x403e, 0x4004, 0x4129, 0x4129, 0x4006, 
	0x4001, 0x4129, 0x4129, 0x4006, 0x4004, 0x4129, 0x4129, 0x403c, 
	0x4001, 0x4129, 0x4129, 0x403c, 0x4004, 0x4129, 0x4129, 0x4041, 
	0x4001, 0x4129, 0x4129, 0x4041, 0x4004, 0x4129, 0x4129, 0x4007, 
	0x4001, 0x4129, 0x4129, 0x4007, 0x4004, 0x4129, 0x48f9, 0x48fc, 
	0x4855, 0x48f9, 0x48f9, 0x48fc, 0x47f9, 0x48f9, 0x414e, 0x4005, 
	0x4004, 0x414e, 0x414e, 0x400a, 0x4001, 0x414e, 0x414e, 0x400a, 
	0x4004, 0x414e, 0x4153, 0x4005, 0x4004, 0x4153, 0x4153, 0x4008, 
	0x4001, 0x4153, 0x4153, 0x4008, 0x4004, 0x4153, 0x4153, 0x400b, 
	0x4001, 0x4153, 0x4153, 0x400b, 0x4004, 0x4153, 0x4153, 0x4010, 
	0x4001, 0x4153, 0x4153, 0x4010, 0x4004, 0x4153, 0x4153, 0x403c, 
	0x4001, 0x4153, 0x4153, 0x403c, 0x4004, 0x4153, 0x4153, 0x4040, 
	0x4001, 0x4153, 0x4153, 0x4040, 0x4004, 0x4153, 0x4153, 0x403d, 
	0x4001, 0x4153, 0x4153, 0x403d, 0x4004, 0x4153, 0x4153, 0x7ffe, 
	0x4004, 0x4153, 0x4163, 0x4005, 0x4004, 0x4163, 0x4163, 0x4008, 
	0x4001, 0x4163, 0x4163, 0x4008, 0x4004, 0x4163, 0x4163, 0x400b, 
	0x4001, 0x4163, 0x4163, 0x400b, 0x4004, 0x4163, 0x4163, 0x4006, 
	0x4001, 0x4163, 0x4163, 0x4006, 0x4004, 0x4163, 0x4163, 0x403c, 
	0x4001, 0x4163, 0x4163, 0x403c, 0x4004, 0x4163, 0x4163, 0x4044, 
	0x4001, 0x4163, 0x4163, 0x4044, 0x4004, 0x4163, 0x4163, 0x4040, 
	0x4001, 0x4163, 0x4163, 0x4040, 0x4004, 0x4163, 0x4163, 0x4032, 
	0x4001, 0x4163, 0x4163, 0x4032, 0x4004, 0x4163, 0x4163, 0x4025, 
	0x4001, 0x4163, 0x4163, 0x4025, 0x4004, 0x4163, 0x4163, 0x403d, 
	0x4001, 0x4163, 0x4163, 0x403d, 0x4004, 0x4163, 0x4178, 0x4005, 
	0x4004, 0x4178, 0x4178, 0x4008, 0x4001, 0x4178, 0x4178, 0x4008, 
	0x4004, 0x4178, 0x4178, 0x4006, 0x4001, 0x4178, 0x4178, 0x4006, 
	0x4004, 0x4178, 0x4178, 0x403c, 0x4001, 0x4178, 0x4178, 0x403c, 
	0x4004, 0x4178, 0x4181, 0x4005, 0x4004, 0x4181, 0x4181, 0x4008, 
	0x4001, 0x4181, 0x4181, 0x4008, 0x4004, 0x4181, 0x4181, 0x400b, 
	0x4001, 0x4181, 0x4181, 0x400b, 0x4004, 0x4181, 0x4181, 0x400c, 
	0x4001, 0x4181, 0x4181, 0x400c, 0x4004, 0x4181, 0x4181, 0x4006, 
	0x4001, 0x4181, 0x4181, 0x4006, 0x4004, 0x4181, 0x4181, 0x403c, 
	0x4001, 0x4181, 0x4181, 0x403c, 0x4004, 0x4181, 0x4181, 0x4040, 
	0x4001, 0x4181, 0x4181, 0x4040, 0x4004, 0x4181, 0x4181, 0x4025, 
	0x4001, 0x4181, 0x4181, 0x4025, 0x4004, 0x4181, 0x4181, 0x403d, 
	0x4001, 0x4181, 0x4181, 0x403d, 0x4004, 0x4181, 0x4181, 0x4043, 
	0x4004, 0x4181, 0x48ff, 0x4902, 0x4855, 0x48ff, 0x48ff, 0x4902, 
	0x47f9, 0x48ff, 0x4197, 0x4005, 0x4004, 0x4197, 0x4197, 0x4005, 
	0x7ffe, 0x4197, 0x4197, 0x4008, 0x4001, 0x4197, 0x4197, 0x4008, 
	0x4004, 0x4197, 0x4197, 0x4009, 0x4001, 0x4197, 0x4197, 0x4009, 
	0x4004, 0x4197, 0x4197, 0x4015, 0x4001, 0x4197, 0x4197, 0x4015, 
	0x4004, 0x4197, 0x4197, 0x400d, 0x4001, 0x4197, 0x4197, 0x400d, 
	0x4004, 0x4197, 0x4197, 0x400e, 0x4001, 0x4197, 0x4197, 0x400e, 
	0x4004, 0x4197, 0x4197, 0x400a, 0x4001, 0x4197, 0x4197, 0x400a, 
	0x4004, 0x4197, 0x4197, 0x401c, 0x4001, 0x4197, 0x4197, 0x401c, 
	0x4004, 0x4197, 0x4197, 0x401d, 0x4001, 0x4197, 0x4197, 0x401d, 
	0x4004, 0x4197, 0x4197, 0x401f, 0x4001, 0x4197, 0x4197, 0x401f, 
	0x4004, 0x4197, 0x4197, 0x401e, 0x4001, 0x4197, 0x4197, 0x401e, 
	0x4004, 0x4197, 0x4197, 0x4034, 0x4001, 0x4197, 0x4197, 0x4034, 
	0x4004, 0x4197, 0x4197, 0x400b, 0x4001, 0x4197, 0x4197, 0x400b, 
	0x4004, 0x4197, 0x4197, 0x4012, 0x4001, 0x4197, 0x4197, 0x4012, 
	0x4004, 0x4197, 0x4197, 0x4014, 0x4001, 0x4197, 0x4197, 0x4014, 
	0x4004, 0x4197, 0x4197, 0x4010, 0x4001, 0x4197, 0x4197, 0x4010, 
	0x4004, 0x4197, 0x4197, 0x400c, 0x4001, 0x4197, 0x4197, 0x400c, 
	0x4004, 0x4197, 0x4197, 0x4016, 0x4001, 0x4197, 0x4197, 0x4016, 
	0x4004, 0x4197, 0x4197, 0x402f, 0x4001, 0x4197, 0x4197, 0x402f, 
	0x4004, 0x4197, 0x4197, 0x403c, 0x4001, 0x4197, 0x4197, 0x403c, 
	0x4004, 0x4197, 0x4197, 0x4044, 0x4001, 0x4197, 0x4197, 0x4044, 
	0x4004, 0x4197, 0x4197, 0x403b, 0x4001, 0x4197, 0x4197, 0x403b, 
	0x4004, 0x4197, 0x4197, 0x4041, 0x4001, 0x4197, 0x4197, 0x4041, 
	0x4004, 0x4197, 0x4197, 0x4038, 0x4001, 0x4197, 0x4197, 0x4038, 
	0x4004, 0x4197, 0x4197, 0x4007, 0x4001, 0x4197, 0x4197, 0x4007, 
	0x4004, 0x4197, 0x4197, 0x4023, 0x4001, 0x4197, 0x4197, 0x4023, 
	0x4004, 0x4197, 0x4197, 0x4024, 0x4001, 0x4197, 0x4197, 0x4024, 
	0x4004, 0x4197, 0x4197, 0x4011, 0x4001, 0x4197, 0x4197, 0x4011, 
	0x4004, 0x4197, 0x4197, 0x4026, 0x4001, 0x4197, 0x4197, 0x4026, 
	0x4004, 0x4197, 0x4197, 0x4027, 0x4001, 0x4197, 0x4197, 0x4027, 
	0x4004, 0x4197, 0x4197, 0x4029, 0x4001, 0x4197, 0x4197, 0x4029, 
	0x4004, 0x4197, 0x4197, 0x4028, 0x4001, 0x4197, 0x4197, 0x4028, 
	0x4004, 0x4197, 0x4197, 0x4039, 0x4001, 0x4197, 0x4197, 0x4039, 
	0x4004, 0x4197, 0x4905, 0x4908, 0x4855, 0x4905, 0x4905, 0x4908, 
	0x47f9, 0x4905, 0x41dd, 0x4005, 0x4004, 0x41dd, 0x41dd, 0x4008, 
	0x4001, 0x41dd, 0x41dd, 0x4008, 0x4004, 0x41dd, 0x41dd, 0x4006, 
	0x4001, 0x41dd, 0x41dd, 0x4006, 0x4004, 0x41dd, 0x41e4, 0x4005, 
	0x4004, 0x41e4, 0x41e7, 0x4005, 0x4004, 0x41e7, 0x41e7, 0x4008, 
	0x4001, 0x41e7, 0x41e7, 0x4008, 0x4004, 0x41e7, 0x41e7, 0x4015, 
	0x4001, 0x41e7, 0x41e7, 0x4015, 0x4004, 0x41e7, 0x41e7, 0x400e, 
	0x4001, 0x41e7, 0x41e7, 0x400e, 0x4004, 0x41e7, 0x41e7, 0x4006, 
	0x4001, 0x41e7, 0x41e7, 0x4006, 0x4004, 0x41e7, 0x41e7, 0x403c, 
	0x4001, 0x41e7, 0x41e7, 0x403c, 0x4004, 0x41e7, 0x41e7, 0x4040, 
	0x4001, 0x41e7, 0x41e7, 0x4040, 0x4004, 0x41e7, 0x41e7, 0x4032, 
	0x4001, 0x41e7, 0x41e7, 0x4032, 0x4004, 0x41e7, 0x41e7, 0x403d, 
	0x4001, 0x41e7, 0x41e7, 0x403d, 0x4004, 0x41e7, 0x41f9, 0x400b, 
	0x4004, 0x41f9, 0x41fc, 0x4005, 0x4004, 0x41fc, 0x490b, 0x48d3, 
	0x490e, 0x490b, 0x41fc, 0x4008, 0x4001, 0x41fc, 0x41fc, 0x4008, 
	0x4004, 0x41fc, 0x41fc, 0x4013, 0x4001, 0x41fc, 0x41fc, 0x4013, 
	0x4004, 0x41fc, 0x41fc, 0x400a, 0x4001, 0x41fc, 0x41fc, 0x400a, 
	0x4004, 0x41fc, 0x41fc, 0x4006, 0x4001, 0x41fc, 0x41fc, 0x4006, 
	0x4004, 0x41fc, 0x41fc, 0x403c, 0x4001, 0x41fc, 0x41fc, 0x403c, 
	0x4004, 0x41fc, 0x41fc, 0x4031, 0x4001, 0x41fc, 0x41fc, 0x4031, 
	0x4004, 0x41fc, 0x41fc, 0x4040, 0x4001, 0x41fc, 0x41fc, 0x4040, 
	0x4004, 0x41fc, 0x420d, 0x400b, 0x4004, 0x420d, 0x420d, 0x4020, 
	0x4001, 0x420d, 0x420d, 0x4020, 0x4004, 0x420d, 0x41fc, 0x7ffe, 
	0x4004, 0x41fc, 0x4911, 0x48d3, 0x4914, 0x4911, 0x490b, 0x48d3, 
	0x4917, 0x4000, 0x4215, 0x4005, 0x4004, 0x4215, 0x4215, 0x400b, 
	0x4001, 0x4215, 0x4215, 0x400b, 0x4004, 0x4215, 0x4215, 0x4006, 
	0x4001, 0x4215, 0x4215, 0x4006, 0x4004, 0x4215, 0x4215, 0x403c, 
	0x4001, 0x4215, 0x4215, 0x403c, 0x4004, 0x4215, 0x4215, 0x4044, 
	0x4001, 0x4215, 0x4215, 0x4044, 0x4004, 0x4215, 0x4215, 0x4040, 
	0x4001, 0x4215, 0x4215, 0x4040, 0x4004, 0x4215, 0x4215, 0x4025, 
	0x4001, 0x4215, 0x4215, 0x4025, 0x4004, 0x4215, 0x4215, 0x403d, 
	0x4001, 0x4215, 0x4215, 0x403d, 0x4004, 0x4215, 0x491a, 0x491d, 
	0x4855, 0x491a, 0x491a, 0x491d, 0x47f9, 0x491a, 0x4228, 0x4005, 
	0x4004, 0x4228, 0x4228, 0x4008, 0x4001, 0x4228, 0x4228, 0x4008, 
	0x4004, 0x4228, 0x4228, 0x4009, 0x4001, 0x4228, 0x4228, 0x4009, 
	0x4004, 0x4228, 0x4228, 0x4015, 0x4001, 0x4228, 0x4228, 0x4015, 
	0x4004, 0x4228, 0x4228, 0x400d, 0x4001, 0x4228, 0x4228, 0x400d, 
	0x4004, 0x4228, 0x4228, 0x400e, 0x4001, 0x4228, 0x4228, 0x400e, 
	0x4004, 0x4228, 0x4228, 0x400a, 0x4001, 0x4228, 0x4228, 0x400a, 
	0x4004, 0x4228, 0x4228, 0x400b, 0x4001, 0x4228, 0x4228, 0x400b, 
	0x4004, 0x4228, 0x4228, 0x400f, 0x4001, 0x4228, 0x4228, 0x400f, 
	0x4004, 0x4228, 0x4228, 0x4012, 0x4001, 0x4228, 0x4228, 0x4012, 
	0x4004, 0x4228, 0x4228, 0x402a, 0x4001, 0x4228, 0x4228, 0x402a, 
	0x4004, 0x4228, 0x4228, 0x402b, 0x4001, 0x4228, 0x4228, 0x402b, 
	0x4004, 0x4228, 0x4228, 0x402c, 0x4001, 0x4228, 0x4228, 0x402c, 
	0x4004, 0x4228, 0x4228, 0x402d, 0x4001, 0x4228, 0x4228, 0x402d, 
	0x4004, 0x4228, 0x4228, 0x4014, 0x4001, 0x4228, 0x4228, 0x4014, 
	0x4004, 0x4228, 0x4228, 0x4010, 0x4001, 0x4228, 0x4228, 0x4010, 
	0x4004, 0x4228, 0x4228, 0x400c, 0x4001, 0x4228, 0x4228, 0x400c, 
	0x4004, 0x4228, 0x4228, 0x4016, 0x4001, 0x4228, 0x4228, 0x4016, 
	0x4004, 0x4228, 0x4228, 0x403e, 0x4001, 0x4228, 0x4228, 0x403e, 
	0x4004, 0x4228, 0x4228, 0x403c, 0x4001, 0x4228, 0x4228, 0x403c, 
	0x4004, 0x4228, 0x4228, 0x4041, 0x4001, 0x4228, 0x4228, 0x4041, 
	0x4004, 0x4228, 0x4228, 0x4007, 0x4001, 0x4228, 0x4228, 0x4007, 
	0x4004, 0x4228, 0x4228, 0x402e, 0x4001, 0x4228, 0x4228, 0x402e, 
	0x4004, 0x4228, 0x4228, 0x403a, 0x4001, 0x4228, 0x4228, 0x403a, 
	0x4004, 0x4228, 0x4228, 0x4025, 0x4001, 0x4228, 0x4228, 0x4025, 
	0x4004, 0x4228, 0x4228, 0x4011, 0x4001, 0x4228, 0x4228, 0x4011, 
	0x4004, 0x4228, 0x4228, 0x4026, 0x4001, 0x4228, 0x4228, 0x4026, 
	0x4004, 0x4228, 0x4228, 0x4027, 0x4001, 0x4228, 0x4228, 0x4027, 
	0x4004, 0x4228, 0x4228, 0x4029, 0x4001, 0x4228, 0x4228, 0x4029, 
	0x4004, 0x4228, 0x4228, 0x4028, 0x4001, 0x4228, 0x4228, 0x4028, 
	0x4004, 0x4228, 0x4228, 0x4039, 0x4001, 0x4228, 0x4228, 0x4039, 
	0x4004, 0x4228, 0x4267, 0x4005, 0x4004, 0x4267, 0x4267, 0x400c, 
	0x4001, 0x4267, 0x4267, 0x400c, 0x4004, 0x4267, 0x4267, 0x403c, 
	0x4001, 0x4267, 0x4267, 0x403c, 0x4004, 0x4267, 0x426e, 0x4005, 
	0x4004, 0x426e, 0x426e, 0x4008, 0x4001, 0x426e, 0x426e, 0x4008, 
	0x4004, 0x426e, 0x426e, 0x4009, 0x4001, 0x426e, 0x426e, 0x4009, 
	0x4004, 0x426e, 0x426e, 0x400a, 0x4001, 0x426e, 0x426e, 0x400a, 
	0x4004, 0x426e, 0x426e, 0x4012, 0x4001, 0x426e, 0x426e, 0x4012, 
	0x4004, 0x426e, 0x426e, 0x4006, 0x4001, 0x426e, 0x426e, 0x4006, 
	0x4004, 0x426e, 0x426e, 0x403c, 0x4001, 0x426e, 0x426e, 0x403c, 
	0x4004, 0x426e, 0x427d, 0x4005, 0x4004, 0x427d, 0x427d, 0x4012, 
	0x4001, 0x427d, 0x427d, 0x4012, 0x4004, 0x427d, 0x427d, 0x4006, 
	0x4001, 0x427d, 0x427d, 0x4006, 0x4004, 0x427d, 0x4284, 0x4005, 
	0x4004, 0x4284, 0x4284, 0x4008, 0x4001, 0x4284, 0x4284, 0x4008, 
	0x4004, 0x4284, 0x4284, 0x4009, 0x4001, 0x4284, 0x4284, 0x4009, 
	0x4004, 0x4284, 0x4284, 0x400a, 0x4001, 0x4284, 0x4284, 0x400a, 
	0x4004, 0x4284, 0x4284, 0x4012, 0x4001, 0x4284, 0x4284, 0x4012, 
	0x4004, 0x4284, 0x4284, 0x4010, 0x4001, 0x4284, 0x4284, 0x4010, 
	0x4004, 0x4284, 0x4284, 0x400c, 0x4001, 0x4284, 0x4284, 0x400c, 
	0x4004, 0x4284, 0x4284, 0x4006, 0x4001, 0x4284, 0x4284, 0x4006, 
	0x4004, 0x4284, 0x4284, 0x403c, 0x4001, 0x4284, 0x4284, 0x403c, 
	0x4004, 0x4284, 0x4297, 0x4005, 0x4004, 0x4297, 0x4297, 0x4008, 
	0x4001, 0x4297, 0x4297, 0x4008, 0x4004, 0x4297, 0x4297, 0x400a, 
	0x4001, 0x4297, 0x4297, 0x400a, 0x4004, 0x4297, 0x4297, 0x4006, 
	0x4001, 0x4297, 0x4297, 0x4006, 0x4004, 0x4297, 0x4297, 0x403c, 
	0x4001, 0x4297, 0x4297, 0x403c, 0x4004, 0x4297, 0x4297, 0x4044, 
	0x4001, 0x4297, 0x4297, 0x4044, 0x4004, 0x4297, 0x4297, 0x403d, 
	0x4001, 0x4297, 0x4297, 0x403d, 0x4004, 0x4297, 0x42a6, 0x400b, 
	0x4004, 0x42a6, 0x7ffe, 0x7ffe, 0x4000, 0x7ffe, 0x42a8, 0x7ffe, 
	0x4000, 0x42a8, 0x42b1, 0x7ffe, 0x4000, 0x42b1, 0x42b2, 0x7ffe, 
	0x4000, 0x42b2, 0x42b3, 0x7ffe, 0x4000, 0x42b3, 0x42b4, 0x7ffe, 
	0x4000, 0x42b4, 0x42b5, 0x7ffe, 0x4000, 0x42b5, 0x42b6, 0x7ffe, 
	0x4000, 0x42b6, 0x42b7, 0x7ffe, 0x4000, 0x42b7, 0x42b8, 0x7ffe, 
	0x4000, 0x42b8, 0x42b9, 0x7ffe, 0x4000, 0x42b9, 0x4000, 0x4000, 
	0x4000, 0x42ed, 0x4000, 0x4000, 0x4000, 0x42ef, 0x4000, 0x4000, 
	0x4000, 0x432d, 0x4000, 0x4000, 0x4000, 0x4000, 0x7ffe, 0x4001, 
	0x4045, 0x7ffe, 0x453b, 0x4001, 0x4046, 0x453b, 0x453b, 0x4004, 
	0x4045, 0x453b, 0x453b, 0x4004, 0x4046, 0x453b, 0x453f, 0x4004, 
	0x4045, 0x453f, 0x4541, 0x4004, 0x4045, 0x4541, 0x4543, 0x4004, 
	0x4045, 0x4543, 0x4545, 0x4001, 0x4046, 0x4545, 0x4545, 0x4004, 
	0x4045, 0x4545, 0x4545, 0x4004, 0x4046, 0x4545, 0x4549, 0x4004, 
	0x4045, 0x4549, 0x454b, 0x4001, 0x4046, 0x454b, 0x454b, 0x4004, 
	0x4045, 0x454b, 0x454b, 0x4004, 0x4046, 0x454b, 0x454f, 0x4004, 
	0x4045, 0x454f, 0x4551, 0x4001, 0x4046, 0x4551, 0x4551, 0x4001, 
	0x4047, 0x4551, 0x4551, 0x4004, 0x4045, 0x4551, 0x4551, 0x4004, 
	0x4046, 0x4551, 0x4551, 0x4004, 0x4047, 0x4551, 0x4551, 0x4004, 
	0x4048, 0x4551, 0x4558, 0x4004, 0x4045, 0x4558, 0x455a, 0x4004, 
	0x4045, 0x455a, 0x455c, 0x4004, 0x4045, 0x455c, 0x455e, 0x4004, 
	0x4045, 0x455e, 0x4560, 0x4004, 0x4045, 0x4560, 0x4562, 0x4001, 
	0x4046, 0x4562, 0x4562, 0x4004, 0x4045, 0x4562, 0x4562, 0x4004, 
	0x4046, 0x4562, 0x4566, 0x4004, 0x4045, 0x4566, 0x4568, 0x4004, 
	0x4045, 0x4568, 0x456a, 0x4004, 0x4045, 0x456a, 0x456a, 0x4004, 
	0x7ffe, 0x456a, 0x456d, 0x4004, 0x4045, 0x456d, 0x456f, 0x4001, 
	0x4046, 0x456f, 0x456f, 0x4001, 0x4047, 0x456f, 0x456f, 0x4004, 
	0x4045, 0x456f, 0x456f, 0x4004, 0x4046, 0x456f, 0x456f, 0x4004, 
	0x4047, 0x456f, 0x456f, 0x4004, 0x4048, 0x456f, 0x4576, 0x4004, 
	0x4045, 0x4576, 0x4578, 0x4004, 0x4045, 0x4578, 0x457a, 0x4004, 
	0x4045, 0x457a, 0x457c, 0x4001, 0x4046, 0x457c, 0x457c, 0x4004, 
	0x4045, 0x457c, 0x457c, 0x4004, 0x4046, 0x457c, 0x7ffe, 0x4049, 
	0x4001, 0x7ffe, 0x4580, 0x4049, 0x4004, 0x4580, 0x4582, 0x4049, 
	0x4004, 0x4582, 0x4584, 0x4049, 0x4004, 0x4584, 0x4586, 0x4049, 
	0x4004, 0x4586, 0x4588, 0x4049, 0x4004, 0x4588, 0x458a, 0x4049, 
	0x4004, 0x458a, 0x458c, 0x4049, 0x4004, 0x458c, 0x458e, 0x4049, 
	0x4004, 0x458e, 0x4590, 0x4049, 0x4004, 0x4590, 0x4592, 0x4049, 
	0x4004, 0x4592, 0x4594, 0x4049, 0x4004, 0x4594, 0x4596, 0x4049, 
	0x4004, 0x4596, 0x4598, 0x4049, 0x4004, 0x4598, 0x459a, 0x4049, 
	0x4004, 0x459a, 0x459c, 0x4049, 0x4004, 0x459c, 0x459e, 0x4049, 
	0x4004, 0x459e, 0x45a0, 0x4049, 0x4004, 0x45a0, 0x45a2, 0x4049, 
	0x4004, 0x45a2, 0x45a4, 0x4049, 0x4004, 0x45a4, 0x45a6, 0x4049, 
	0x4004, 0x45a6, 0x45a8, 0x4049, 0x4004, 0x45a8, 0x45aa, 0x4049, 
	0x4004, 0x45aa, 0x45ac, 0x4049, 0x4004, 0x45ac, 0x45ae, 0x4049, 
	0x4004, 0x45ae, 0x45b0, 0x4049, 0x4004, 0x45b0, 0x45b2, 0x4049, 
	0x4004, 0x45b2, 0x45b4, 0x4049, 0x4004, 0x45b4, 0x45b6, 0x4049, 
	0x4004, 0x45b6, 0x45b8, 0x4049, 0x4004, 0x45b8, 0x45ba, 0x4049, 
	0x4004, 0x45ba, 0x45bc, 0x4049, 0x4004, 0x45bc, 0x45be, 0x4049, 
	0x4004, 0x45be, 0x45c0, 0x4049, 0x4004, 0x45c0, 0x45c2, 0x4049, 
	0x4004, 0x45c2, 0x45c4, 0x4049, 0x4004, 0x45c4, 0x45c6, 0x4049, 
	0x4004, 0x45c6, 0x45c8, 0x4049, 0x4004, 0x45c8, 0x45ca, 0x4049, 
	0x4004, 0x45ca, 0x45cc, 0x4049, 0x4004, 0x45cc, 0x45ce, 0x4049, 
	0x4004, 0x45ce, 0x45d0, 0x4049, 0x4004, 0x45d0, 0x7ffe, 0x4049, 
	0x4004, 0x7ffe, 0x45d2, 0x4049, 0x4001, 0x45d2, 0x45d4, 0x4049, 
	0x4004, 0x45d4, 0x45d6, 0x4049, 0x4001, 0x45d6, 0x45d8, 0x4049, 
	0x4004, 0x45d8, 0x45da, 0x4049, 0x4004, 0x45da, 0x45dc, 0x4049, 
	0x4004, 0x45dc, 0x45de, 0x4049, 0x4004, 0x45de, 0x45e0, 0x4049, 
	0x4004, 0x45e0, 0x45e2, 0x4049, 0x4004, 0x45e2, 0x45e4, 0x4049, 
	0x4004, 0x45e4, 0x45e6, 0x4049, 0x4004, 0x45e6, 0x7ffe, 0x4000, 
	0x4000, 0x7ffe, 0x4608, 0x7ffe, 0x4000, 0x4608, 0x4607, 0x7ffe, 
	0x4000, 0x4607, 0x4611, 0x7ffe, 0x4000, 0x4611, 0x4615, 0x7ffe, 
	0x4000, 0x4615, 0x461c, 0x7ffe, 0x4000, 0x461c, 0x4624, 0x7ffe, 
	0x4000, 0x4624, 0x4629, 0x7ffe, 0x4000, 0x4629, 0x462e, 0x7ffe, 
	0x4000, 0x462e, 0x4633, 0x7ffe, 0x4000, 0x4633, 0x4638, 0x7ffe, 
	0x4000, 0x4638, 0x463b, 0x7ffe, 0x4000, 0x463b, 0x463e, 0x7ffe, 
	0x4000, 0x463e, 0x4641, 0x7ffe, 0x4000, 0x4641, 0x4644, 0x7ffe, 
	0x4000, 0x4644, 0x4649, 0x7ffe, 0x4000, 0x4649, 0x464e, 0x7ffe, 
	0x4000, 0x464e, 0x4653, 0x7ffe, 0x4000, 0x4653, 0x4658, 0x7ffe, 
	0x4000, 0x4658, 0x465d, 0x7ffe, 0x4000, 0x465d, 0x4662, 0x7ffe, 
	0x4000, 0x4662, 0x4667, 0x7ffe, 0x4000, 0x4667, 0x466c, 0x7ffe, 
	0x4000, 0x466c, 0x4671, 0x7ffe, 0x4000, 0x4671, 0x4676, 0x7ffe, 
	0x4000, 0x4676, 0x467b, 0x7ffe, 0x4000, 0x467b, 0x4680, 0x7ffe, 
	0x4000, 0x4680, 0x4685, 0x7ffe, 0x4000, 0x4685, 0x468a, 0x7ffe, 
	0x4000, 0x468a, 0x468f, 0x7ffe, 0x4000, 0x468f, 0x4692, 0x7ffe, 
	0x4000, 0x4692, 0x4695, 0x7ffe, 0x4000, 0x4695, 0x4000, 0x4000, 
	0x7ffe, 0x7ffe, 0x4920, 0x4920, 0x4923, 0x4920, 0x4920, 0x4926, 
	0x4929, 0x4920, 0x492c, 0x492c, 0x492f, 0x492c, 0x492c, 0x4932, 
	0x4935, 0x492c, 0x4938, 0x4938, 0x493b, 0x4938, 0x4938, 0x493e, 
	0x4941, 0x4938, 0x4944, 0x4947, 0x494a, 0x4944, 0x4944, 0x494d, 
	0x4950, 0x4944, 0x46b5, 0x7ffe, 0x4000, 0x46b5, 0x46b9, 0x7ffe, 
	0x4000, 0x46b9, 0x46bd, 0x7ffe, 0x4000, 0x46bd, 0x46c2, 0x7ffe, 
	0x4000, 0x46c2, 0x46c6, 0x7ffe, 0x4000, 0x46c6, 0x46ca, 0x7ffe, 
	0x4000, 0x46ca, 0x46cf, 0x7ffe, 0x4000, 0x46cf, 0x46d3, 0x7ffe, 
	0x4000, 0x46d3, 0x46d7, 0x7ffe, 0x4000, 0x46d7, 0x46dc, 0x7ffe, 
	0x4000, 0x46dc, 0x46e0, 0x7ffe, 0x4000, 0x46e0, 0x46e4, 0x7ffe, 
	0x4000, 0x46e4, 0x46e8, 0x7ffe, 0x4000, 0x46e8, 0x46ec, 0x7ffe, 
	0x4000, 0x46ec, 0x46f0, 0x7ffe, 0x4000, 0x46f0, 0x46f4, 0x7ffe, 
	0x4000, 0x46f4, 0x46f8, 0x7ffe, 0x4000, 0x46f8, 0x46fc, 0x7ffe, 
	0x4000, 0x46fc, 0x4702, 0x7ffe, 0x4000, 0x4702, 0x4706, 0x7ffe, 
	0x4000, 0x4706, 0x470a, 0x7ffe, 0x4000, 0x470a, 0x470c, 0x7ffe, 
	0x4000, 0x470c, 0x470e, 0x7ffe, 0x4000, 0x470e, 0x4710, 0x7ffe, 
	0x4000, 0x4710, 0x4712, 0x7ffe, 0x4000, 0x4712, 0x4714, 0x7ffe, 
	0x4000, 0x4714, 0x471a, 0x7ffe, 0x4000, 0x471a, 0x4720, 0x7ffe, 
	0x4000, 0x4720, 0x4726, 0x7ffe, 0x4000, 0x4726, 0x472c, 0x7ffe, 
	0x4000, 0x472c, 0x4732, 0x7ffe, 0x4000, 0x4732, 0x4734, 0x7ffe, 
	0x4000, 0x4734, 0x4736, 0x7ffe, 0x4000, 0x4736, 0x4738, 0x7ffe, 
	0x4000, 0x4738, 0x473a, 0x7ffe, 0x4000, 0x473a, 0x473c, 0x7ffe, 
	0x4000, 0x473c, 0x4740, 0x7ffe, 0x4000, 0x4740, 0x4744, 0x7ffe, 
	0x4000, 0x4744, 0x4748, 0x7ffe, 0x4000, 0x4748, 0x474a, 0x7ffe, 
	0x4000, 0x474a, 0x474c, 0x7ffe, 0x4000, 0x474c, 0x474e, 0x7ffe, 
	0x4000, 0x474e, 0x4750, 0x7ffe, 0x4000, 0x4750, 0x4752, 0x7ffe, 
	0x4000, 0x4752, 0x4756, 0x7ffe, 0x4000, 0x4756, 0x4758, 0x7ffe, 
	0x4000, 0x4758, 0x475a, 0x7ffe, 0x4000, 0x475a, 0x475c, 0x7ffe, 
	0x4000, 0x475c, 0x7ffe, 0x7ffe, 0x4000, 0x4000, 0x400c, 0x7ffe, 
	0x4000, 0x4000, 0x400e, 0x7ffe, 0x4000, 0x4000, 0x4010, 0x7ffe, 
	0x4000, 0x4000, 0x4012, 0x7ffe, 0x4000, 0x4000, 0x4014, 0x7ffe, 
	0x4000, 0x4000, 0x4016, 0x7ffe, 0x4000, 0x4000, 0x4018, 0x7ffe, 
	0x4000, 0x4000, 0x401a, 0x7ffe, 0x4000, 0x4000, 0x401c, 0x7ffe, 
	0x4000, 0x4000, 0x401e, 0x7ffe, 0x4000, 0x4000, 0x4020, 0x7ffe, 
	0x4000, 0x4000, 0x4022, 0x7ffe, 0x4000, 0x4000, 0x4024, 0x7ffe, 
	0x4000, 0x4000, 0x4026, 0x7ffe, 0x4000, 0x4000, 0x4028, 0x7ffe, 
	0x4000, 0x4000, 0x402a, 0x7ffe, 0x4000, 0x4000, 0x402c, 0x7ffe, 
	0x4000, 0x4000, 0x402e, 0x7ffe, 0x4000, 0x4000, 0x4030, 0x7ffe, 
	0x4000, 0x4000, 0x4032, 0x7ffe, 0x4000, 0x4000, 0x4034, 0x7ffe, 
	0x4000, 0x4000, 0x4036, 0x7ffe, 0x4000, 0x4000, 0x4038, 0x7ffe, 
	0x4000, 0x4000, 0x403a, 0x7ffe, 0x4000, 0x4000, 0x403c, 0x7ffe, 
	0x4000, 0x4000, 0x403e, 0x7ffe, 0x4000, 0x4000, 0x4000, 0x7ffe, 
	0x4000, 0x4000, 0x4000, 0x4000, 0x7ffe, 0x4000, 0x4000, 0x7ffe, 
	0x4001, 0x4001, 0x7ffe, 0x4001, 0x4001, 0x4001, 0x4036, 0x4002, 
	0x4001, 0x4001, 0x4038, 0x4002, 0x4001, 0x4001, 0x403a, 0x4002, 
	0x4001, 0x4001, 0x403c, 0x4002, 0x4001, 0x4001, 0x403e, 0x4002, 
	0x4001, 0x4001, 0x4040, 0x4002, 0x4001, 0x4001, 0x4042, 0x4002, 
	0x4001, 0x4001, 0x4044, 0x4002, 0x4001, 0x4001, 0x4046, 0x4002, 
	0x4001, 0x4001, 0x4048, 0x4002, 0x4001, 0x4001, 0x7ffe, 0x4001, 
	0x4001, 0x4003, 0x404a, 0x4001, 0x4001, 0x4004, 0x404c, 0x4001, 
	0x4001, 0x4004, 0x404e, 0x4001, 0x4001, 0x4004, 0x4050, 0x4001, 
	0x4001, 0x4004, 0x4052, 0x4001, 0x4001, 0x4004, 0x4054, 0x4001, 
	0x4001, 0x4004, 0x4056, 0x4001, 0x4001, 0x4004, 0x4058, 0x4001, 
	0x4001, 0x4004, 0x405a, 0x4001, 0x4001, 0x4004, 0x405c, 0x4001, 
	0x4001, 0x4004, 0x405e, 0x4001, 0x4001, 0x4004, 0x4060, 0x4001, 
	0x4001, 0x4004, 0x4062, 0x4001, 0x4001, 0x4004, 0x4064, 0x4001, 
	0x4001, 0x4004, 0x4066, 0x4001, 0x4001, 0x4004, 0x4068, 0x4001, 
	0x4001, 0x4004, 0x406a, 0x4001, 0x4001, 0x4004, 0x406c, 0x4001, 
	0x4001, 0x4004, 0x406e, 0x4001, 0x4001, 0x4004, 0x4070, 0x4001, 
	0x4001, 0x4004, 0x4072, 0x4001, 0x4001, 0x4004, 0x4074, 0x4001, 
	0x4001, 0x4004, 0x4076, 0x4001, 0x4001, 0x4004, 0x4078, 0x4001, 
	0x4001, 0x4004, 0x407a, 0x4001, 0x4001, 0x4004, 0x407c, 0x4001, 
	0x4001, 0x4004, 0x438e, 0x4001, 0x4001, 0x4001, 0x4391, 0x4001, 
	0x4001, 0x4001, 0x4394, 0x4001, 0x4001, 0x4001, 0x4397, 0x4001, 
	0x4001, 0x4001, 0x439a, 0x4001, 0x4001, 0x4001, 0x439d, 0x4001, 
	0x4001, 0x4001, 0x43a0, 0x4001, 0x4001, 0x4001, 0x43a3, 0x4001, 
	0x4001, 0x4001, 0x43a6, 0x4001, 0x4001, 0x4001, 0x43a9, 0x4001, 
	0x4001, 0x4001, 0x43ac, 0x4001, 0x4001, 0x4001, 0x43af, 0x4001, 
	0x4001, 0x4001, 0x43b2, 0x4001, 0x4001, 0x4001, 0x43b5, 0x4001, 
	0x4001, 0x4001, 0x43b8, 0x4001, 0x4001, 0x4001, 0x43bb, 0x4001, 
	0x4001, 0x4001, 0x43be, 0x4001, 0x4001, 0x4001, 0x43c1, 0x4001, 
	0x4001, 0x4001, 0x43c4, 0x4001, 0x4001, 0x4001, 0x43c7, 0x4001, 
	0x4001, 0x4001, 0x43ca, 0x4001, 0x4001, 0x4001, 0x43cd, 0x4001, 
	0x4001, 0x4001, 0x43d0, 0x4001, 0x4001, 0x4001, 0x43d3, 0x4001, 
	0x4001, 0x4001, 0x43d6, 0x4001, 0x4001, 0x4001, 0x43d9, 0x4001, 
	0x4001, 0x4001, 0x43dc, 0x4001, 0x4001, 0x4001, 0x43df, 0x4001, 
	0x4001, 0x4001, 0x43e2, 0x4001, 0x4001, 0x4001, 0x43e5, 0x4001, 
	0x4001, 0x4001, 0x43e8, 0x4001, 0x4001, 0x4001, 0x43eb, 0x4001, 
	0x4001, 0x4001, 0x43ee, 0x4001, 0x4001, 0x4001, 0x43f1, 0x4001, 
	0x4001, 0x4001, 0x43f4, 0x4001, 0x4001, 0x4001, 0x43f7, 0x4001, 
	0x4001, 0x4001, 0x43fa, 0x4001, 0x4001, 0x4001, 0x43fd, 0x4001, 
	0x4001, 0x4001, 0x4400, 0x4001, 0x4001, 0x4001, 0x4403, 0x4001, 
	0x4001, 0x4001, 0x4406, 0x4001, 0x4001, 0x4001, 0x4409, 0x4001, 
	0x4001, 0x4001, 0x440c, 0x4001, 0x4001, 0x4001, 0x440f, 0x4001, 
	0x4001, 0x4001, 0x4412, 0x4001, 0x4001, 0x4001, 0x4415, 0x4001, 
	0x4001, 0x4001, 0x4418, 0x4001, 0x4001, 0x4001, 0x441b, 0x4001, 
	0x4001, 0x4001, 0x441e, 0x4001, 0x4001, 0x4001, 0x4421, 0x4001, 
	0x4001, 0x4001, 0x4424, 0x4001, 0x4001, 0x4001, 0x4427, 0x4001, 
	0x4001, 0x4001, 0x442a, 0x4001, 0x4001, 0x4001, 0x442d, 0x4001, 
	0x4001, 0x4001, 0x4430, 0x4001, 0x4001, 0x4001, 0x4433, 0x4001, 
	0x4001, 0x4001, 0x4436, 0x4001, 0x4001, 0x4001, 0x4439, 0x4001, 
	0x4001, 0x4001, 0x443c, 0x4001, 0x4001, 0x4001, 0x443f, 0x4001, 
	0x4001, 0x4001, 0x4442, 0x4001, 0x4001, 0x4001, 0x4445, 0x4001, 
	0x4001, 0x4001, 0x4448, 0x4001, 0x4001, 0x4001, 0x444b, 0x4001, 
	0x4001, 0x4001, 0x444e, 0x4001, 0x4001, 0x4001, 0x4451, 0x4001, 
	0x4001, 0x4001, 0x4454, 0x4001, 0x4001, 0x4001, 0x4457, 0x4001, 
	0x4001, 0x4001, 0x445a, 0x4001, 0x4001, 0x4001, 0x445d, 0x4001, 
	0x4001, 0x4001, 0x4460, 0x4001, 0x4001, 0x4001, 0x4463, 0x4001, 
	0x4001, 0x4001, 0x4466, 0x4001, 0x4001, 0x4001, 0x4469, 0x4001, 
	0x4001, 0x4001, 0x446c, 0x4001, 0x4001, 0x4001, 0x446f, 0x4001, 
	0x4001, 0x4001, 0x4472, 0x4001, 0x4001, 0x4001, 0x4475, 0x4001, 
	0x4001, 0x4001, 0x4478, 0x4001, 0x4001, 0x4001, 0x447b, 0x4001, 
	0x4001, 0x4001, 0x447e, 0x4001, 0x4001, 0x4001, 0x4481, 0x4001, 
	0x4001, 0x4001, 0x4484, 0x4001, 0x4001, 0x4001, 0x4487, 0x4001, 
	0x4001, 0x4001, 0x448a, 0x4001, 0x4001, 0x4001, 0x448d, 0x4001, 
	0x4001, 0x4001, 0x4490, 0x4001, 0x4001, 0x4001, 0x4493, 0x4001, 
	0x4001, 0x4001, 0x4496, 0x4001, 0x4001, 0x4001, 0x4499, 0x4001, 
	0x4001, 0x4001, 0x449c, 0x4001, 0x4001, 0x4001, 0x449f, 0x4001, 
	0x4001, 0x4001, 0x44a2, 0x4001, 0x4001, 0x4001, 0x44a5, 0x4001, 
	0x4001, 0x4001, 0x44a8, 0x4001, 0x4001, 0x4001, 0x44ab, 0x4001, 
	0x4001, 0x4001, 0x44ae, 0x4001, 0x4001, 0x4001, 0x44b1, 0x4001, 
	0x4001, 0x4001, 0x44b4, 0x4001, 0x4001, 0x4001, 0x44b7, 0x4001, 
	0x4001, 0x4001, 0x44ba, 0x4001, 0x4001, 0x4001, 0x44bd, 0x4001, 
	0x4001, 0x4001, 0x44c0, 0x4001, 0x4001, 0x4001, 0x44c3, 0x4001, 
	0x4001, 0x4001, 0x44c6, 0x4001, 0x4001, 0x4001, 0x44c9, 0x4001, 
	0x4001, 0x4001, 0x44cc, 0x4001, 0x4001, 0x4001, 0x44cf, 0x4001, 
	0x4001, 0x4001, 0x44d2, 0x4001, 0x4001, 0x4001, 0x44d5, 0x4001, 
	0x4001, 0x4001, 0x44d8, 0x4001, 0x4001, 0x4001, 0x44db, 0x4001, 
	0x4001, 0x4001, 0x44de, 0x4001, 0x4001, 0x4001, 0x44e1, 0x4001, 
	0x4001, 0x4001, 0x44e4, 0x4001, 0x4001, 0x4001, 0x44e7, 0x4001, 
	0x4001, 0x4001, 0x44ea, 0x4001, 0x4001, 0x4001, 0x44ed, 0x4001, 
	0x4001, 0x4001, 0x44f0, 0x4001, 0x4001, 0x4001, 0x44f3, 0x4001, 
	0x4001, 0x4001, 0x44f6, 0x4001, 0x4001, 0x4001, 0x44f9, 0x4001, 
	0x4001, 0x4001, 0x44fc, 0x4001, 0x4001, 0x4001, 0x44ff, 0x4001, 
	0x4001, 0x4001, 0x4502, 0x4001, 0x4001, 0x4001, 0x4505, 0x4001, 
	0x4001, 0x4001, 0x4508, 0x4001, 0x4001, 0x4001, 0x450b, 0x4001, 
	0x4001, 0x4001, 0x450e, 0x4001, 0x4001, 0x4001, 0x4511, 0x4001, 
	0x4001, 0x4001, 0x4514, 0x4001, 0x4001, 0x4001, 0x4517, 0x4001, 
	0x4001, 0x4001, 0x451a, 0x4001, 0x4001, 0x4001, 0x451d, 0x4001, 
	0x4001, 0x4001, 0x4520, 0x4001, 0x4001, 0x4001, 0x4523, 0x4001, 
	0x4001, 0x4001, 0x4526, 0x4001, 0x4001, 0x4001, 0x4529, 0x4001, 
	0x4001, 0x4001, 0x452c, 0x4001, 0x4001, 0x4001, 0x452f, 0x4001, 
	0x4001, 0x4001, 0x4532, 0x4001, 0x4001, 0x4001, 0x4535, 0x4001, 
	0x4001, 0x4001, 0x4538, 0x4001, 0x4001, 0x4001, 0x453b, 0x4001, 
	0x4001, 0x4001, 0x453e, 0x4001, 0x4001, 0x4001, 0x4541, 0x4001, 
	0x4001, 0x4001, 0x4544, 0x4001, 0x4001, 0x4001, 0x4547, 0x4001, 
	0x4001, 0x4001, 0x454a, 0x4001, 0x4001, 0x4001, 0x454d, 0x4001, 
	0x4001, 0x4001, 0x4550, 0x4001, 0x4001, 0x4001, 0x4553, 0x4001, 
	0x4001, 0x4001, 0x4556, 0x4001, 0x4001, 0x4001, 0x4559, 0x4001, 
	0x4001, 0x4001, 0x455c, 0x4001, 0x4001, 0x4001, 0x455f, 0x4001, 
	0x4001, 0x4001, 0x4562, 0x4001, 0x4001, 0x4001, 0x4565, 0x4001, 
	0x4001, 0x4001, 0x4568, 0x4001, 0x4001, 0x4001, 0x456b, 0x4001, 
	0x4001, 0x4001, 0x456e, 0x4001, 0x4001, 0x4001, 0x4571, 0x4001, 
	0x4001, 0x4001, 0x4574, 0x4001, 0x4001, 0x4001, 0x4577, 0x4001, 
	0x4001, 0x4001, 0x457a, 0x4001, 0x4001, 0x4001, 0x457d, 0x4001, 
	0x4001, 0x4001, 0x4580, 0x4001, 0x4001, 0x4001, 0x4583, 0x4001, 
	0x4001, 0x4001, 0x4586, 0x4001, 0x4001, 0x4001, 0x4589, 0x4001, 
	0x4001, 0x4001, 0x458c, 0x4001, 0x4001, 0x4001, 0x458f, 0x4001, 
	0x4001, 0x4001, 0x4592, 0x4001, 0x4001, 0x4001, 0x4595, 0x4001, 
	0x4001, 0x4001, 0x4598, 0x4001, 0x4001, 0x4001, 0x459b, 0x4001, 
	0x4001, 0x4001, 0x459e, 0x4001, 0x4001, 0x4001, 0x45a1, 0x4001, 
	0x4001, 0x4001, 0x45a4, 0x4001, 0x4001, 0x4001, 0x45a7, 0x4001, 
	0x4001, 0x4001, 0x45aa, 0x4001, 0x4001, 0x4001, 0x45ad, 0x4001, 
	0x4001, 0x4001, 0x45b0, 0x4001, 0x4001, 0x4001, 0x45b3, 0x4001, 
	0x4001, 0x4001, 0x45b6, 0x4001, 0x4001, 0x4001, 0x45b9, 0x4001, 
	0x4001, 0x4001, 0x45bc, 0x4001, 0x4001, 0x4001, 0x45bf, 0x4001, 
	0x4001, 0x4001, 0x45c2, 0x4001, 0x4001, 0x4001, 0x45c5, 0x4001, 
	0x4001, 0x4001, 0x45c8, 0x4001, 0x4001, 0x4001, 0x45cb, 0x4001, 
	0x4001, 0x4001, 0x45ce, 0x4001, 0x4001, 0x4001, 0x45d1, 0x4001, 
	0x4001, 0x4001, 0x45d4, 0x4001, 0x4001, 0x4001, 0x45d7, 0x4001, 
	0x4001, 0x4001, 0x45da, 0x4001, 0x4001, 0x4001, 0x45dd, 0x4001, 
	0x4001, 0x4001, 0x45e0, 0x4001, 0x4001, 0x4001, 0x45e3, 0x4001, 
	0x4001, 0x4001, 0x45e6, 0x4001, 0x4001, 0x4001, 0x45e9, 0x4001, 
	0x4001, 0x4001, 0x45ec, 0x4001, 0x4001, 0x4001, 0x45ef, 0x4001, 
	0x4001, 0x4001, 0x45f2, 0x4001, 0x4001, 0x4001, 0x45f5, 0x4001, 
	0x4001, 0x4001, 0x45f8, 0x4001, 0x4001, 0x4001, 0x45fb, 0x4001, 
	0x4001, 0x4001, 0x45fe, 0x4001, 0x4001, 0x4001, 0x4601, 0x4001, 
	0x4001, 0x4001, 0x4604, 0x4001, 0x4001, 0x4001, 0x4607, 0x4001, 
	0x4001, 0x4001, 0x460a, 0x4001, 0x4001, 0x4001, 0x460d, 0x4001, 
	0x4001, 0x4001, 0x4610, 0x4001, 0x4001, 0x4001, 0x4613, 0x4001, 
	0x4001, 0x4001, 0x4616, 0x4001, 0x4001, 0x4001, 0x4619, 0x4001, 
	0x4001, 0x4001, 0x461c, 0x4001, 0x4001, 0x4001, 0x461f, 0x4001, 
	0x4001, 0x4001, 0x418b, 0x4001, 0x4001, 0x4005, 0x7fff, 0x4000, 
	0x4000, 0x4000, 0x4384, 0x4385,      0, 0x037f, 0x037f,      0, 
	0x4379, 0x4379,      0, 0x4032, 0x402c,      0, 0x4009, 0x4009, 
	     0, 0x0061, 0x0389,      0, 0x000e, 0x000e,      0, 0x0003, 
	0x0003,      0, 0x0004, 0x0003,      0, 0x0005, 0x0003,      0, 
	0x0006, 0x0003,      0, 0x4029, 0x402c,      0, 0x4031, 0x4383, 
	     0, 0x4035, 0x4035,      0, 0x4061, 0x4389,      0, 0x400e, 
	0x400e,      0, 0x005b, 0x038a,      0, 0x000e, 0x000d,      0, 
	0x0003, 0x0004,      0, 0x0004, 0x0004,      0, 0x000e, 0x037a, 
	     0, 0x000e, 0x037c,      0, 0x4068, 0x4068,      0, 0x437f, 
	0x437f,      0, 0x4068, 0x406c,      0, 0x406c, 0x406c,      0, 
	0x4585, 0x4585,      0, 0x4009, 0x44c1,      0, 0x4009, 0x44c0, 
	     0, 0x4009, 0x4379,      0, 0x4379, 0x4009,      0, 0x4379, 
	0x44c1,      0, 0x4379, 0x44c0,      0, 0x4586, 0x4586,      0, 
	0x4587, 0x4587,      0, 0x4009, 0x4584,      0, 0x4009, 0x4583, 
	     0, 0x4009, 0x4582,      0, 0x4009, 0x4581,      0, 0x4379, 
	0x4584,      0, 0x4379, 0x4583,      0, 0x4379, 0x4582,      0, 
	0x4379, 0x4581,      0, 0x4588, 0x4588,      0, 0x4589, 0x4589, 
	     0, 0x458a, 0x458a,      0, 0x458c, 0x458c,      0, 0x458d, 
	0x458d,      0, 0x458f, 0x458f,      0, 0x405b, 0x460e,      0, 
	0x4003, 0x4004,      0, 0x4004, 0x4004,      0, 0x405b, 0x4389, 
	     0, 0x400e, 0x437a,      0, 0x400e, 0x437c,      0, 0x405b, 
	0x438a,      0, 0x404a, 0x460f, 0x438a, 0x405b,      0, 0x437f, 
	0x437f, 0x437f, 0x437f,      0, 0x4005, 0x4006, 0x4004, 0x4003, 
	     0, 0x4390, 0x4396,      0, 0x43b1, 0x437f,      0, 0x4390, 
	0x4397,      0, 0x439f, 0x43b6,      0, 0x43a2, 0x43b6,      0, 
	0x4329, 0x4329,      0, 0x0002, 0x0002,      0, 0x4330, 0x4330, 
	     0, 0x4329, 0x4702,      0, 0x4331, 0x4331,      0, 0x4329, 
	0x4385,      0, 0x4332, 0x4332,      0, 0x4329, 0x4329, 0x4702, 
	     0, 0x0002, 0x0002, 0x0002,      0, 0x4333, 0x4333, 0x4333, 
	     0, 0x4329, 0x4329, 0x4385,      0, 0x4334, 0x4334, 0x4334, 
	     0, 0x4702, 0x4373,      0, 0x0371, 0x0371,      0, 0x4001, 
	0x4001,      0, 0x46a0, 0x46a0,      0, 0x4400, 0x4413,      0, 
	0x4402, 0x4402,      0, 0x4400, 0x4400,      0, 0x46a0, 0x4411, 
	     0, 0x4412, 0x4412,      0, 0x45bb, 0x4548,      0, 0x05bb, 
	0x0548,      0, 0x45ed, 0x45ed,      0, 0x05bb, 0x0549,      0, 
	0x45ee, 0x45ee,      0, 0x45bb, 0x454a,      0, 0x05bb, 0x054a, 
	     0, 0x45ef, 0x45ef,      0, 0x05bb, 0x054b,      0, 0x45f0, 
	0x45f0,      0, 0x45bb, 0x454d,      0, 0x05bb, 0x054d,      0, 
	0x45f1, 0x45f1,      0, 0x05bb, 0x054e,      0, 0x45f2, 0x45f2, 
	     0, 0x45bb, 0x4551,      0, 0x05bb, 0x0552,      0, 0x45f3, 
	0x45f3,      0, 0x05bb, 0x0553,      0, 0x45f4, 0x45f4,      0, 
	0x42a9, 0x42fc,      0, 0x06ea, 0x06ea,      0, 0x06ec, 0x06ec, 
	     0, 0x06ee, 0x06ee,      0, 0x439f, 0x4335,      0, 0x0716, 
	0x0716,      0, 0x43ad, 0x42fc,      0, 0x0726, 0x0726,      0, 
	0x4413, 0x4344,      0, 0x0730, 0x0730,      0, 0x4056, 0x40c3, 
	     0, 0x4092, 0x4092,      0, 0x4094, 0x4094,      0, 0x4096, 
	0x4096,      0, 0x40f6, 0x40f6,      0, 0x4005, 0x4005,      0, 
	0x40fd, 0x40fd,      0, 0x40f6, 0x4129,      0, 0x40fe, 0x40fe, 
	     0, 0x40f6, 0x4163,      0, 0x40ff, 0x40ff,      0, 0x40f6, 
	0x40f6, 0x4129,      0, 0x4005, 0x4005, 0x4005,      0, 0x4100, 
	0x4100, 0x4100,      0, 0x40f6, 0x40f6, 0x4163,      0, 0x4101, 
	0x4101, 0x4101,      0, 0x4129, 0x414e,      0, 0x414c, 0x414c, 
	     0, 0x4181, 0x4102,      0, 0x4195, 0x4195,      0, 0x4197, 
	0x40c3,      0, 0x41db, 0x41db,      0, 0x41fc, 0x4215,      0, 
	0x41fe, 0x41fe,      0, 0x41fc, 0x41fc,      0, 0x4004, 0x4213, 
	     0, 0x4214, 0x4214,      0, 0x4215, 0x4115,      0, 0x4226, 
	0x4226,      0, 0x467b, 0x4608,      0, 0x46ad, 0x46ad,      0, 
	0x467b, 0x4609,      0, 0x46ae, 0x46ae,      0, 0x467b, 0x460a, 
	     0, 0x46af, 0x46af,      0, 0x467b, 0x460b,      0, 0x46b0, 
	0x46b0,      0, 0x467b, 0x460d,      0, 0x46b1, 0x46b1,      0, 
	0x467b, 0x460e,      0, 0x46b2, 0x46b2,      0, 0x467b, 0x4611, 
	     0, 0x467b, 0x4612,      0, 0x46b3, 0x46b3,      0, 0x467b, 
	0x4613,      0, 0x46b4, 0x46b4,      0, 0x407e, 0x4194,      0, 
	0x407e, 0x4195,      0, 0x407e, 0x4196,      0, 0x407e, 0x4197, 
	     0, 0x407e, 0x4198,      0, 0x4084, 0x4194,      0, 0x4084, 
	0x4195,      0, 0x4084, 0x4196,      0, 0x4084, 0x4197,      0, 
	0x4084, 0x4198,      0, 0x408a, 0x4194,      0, 0x408a, 0x4195, 
	     0, 0x408a, 0x4196,      0, 0x408a, 0x4197,      0, 0x408a, 
	0x4198,      0, 0x4090, 0x4194,      0, 0x4090, 0x4195,      0, 
	0x4090, 0x4196,      0, 0x4090, 0x4197,      0, 0x4090, 0x4198, 
	     0, 0x4096, 0x4194,      0, 0x4096, 0x4195,      0, 0x4096, 
	0x4196,      0, 0x4096, 0x4197,      0, 0x4096, 0x4198,      0, 
	0x409c, 0x4194,      0, 0x409c, 0x4195,      0, 0x409c, 0x4196, 
	     0, 0x409c, 0x4197,      0, 0x409c, 0x4198,      0, 0x40a2, 
	0x4194,      0, 0x40a2, 0x4195,      0, 0x40a2, 0x4196,      0, 
	0x40a2, 0x4197,      0, 0x40a2, 0x4198,      0, 0x40a8, 0x4194, 
	     0, 0x40a8, 0x4195,      0, 0x40a8, 0x4196,      0, 0x40a8, 
	0x4197,      0, 0x40a8, 0x4198,      0, 0x40ae, 0x4194,      0, 
	0x40ae, 0x4195,      0, 0x40ae, 0x4196,      0, 0x40ae, 0x4197, 
	     0, 0x40ae, 0x4198,      0, 0x40b4, 0x4194,      0, 0x40b4, 
	0x4195,      0, 0x40b4, 0x4196,      0, 0x40b4, 0x4197,      0, 
	0x40b4, 0x4198,      0, 0x40ba, 0x4194,      0, 0x40ba, 0x4195, 
	     0, 0x40ba, 0x4196,      0, 0x40ba, 0x4197,      0, 0x40ba, 
	0x4198,      0, 0x40c0, 0x4194,      0, 0x40c0, 0x4195,      0, 
	0x40c0, 0x4196,      0, 0x40c0, 0x4197,      0, 0x40c0, 0x4198, 
	     0, 0x40c6, 0x4194,      0, 0x40c6, 0x4195,      0, 0x40c6, 
	0x4196,      0, 0x40c6, 0x4197,      0, 0x40c6, 0x4198,      0, 
	0x40cc, 0x4194,      0, 0x40cc, 0x4195,      0, 0x40cc, 0x4196, 
	     0, 0x40cc, 0x4197,      0, 0x40cc, 0x4198,      0, 0x40d2, 
	0x4194,      0, 0x40d2, 0x4195,      0, 0x40d2, 0x4196,      0, 
	0x40d2, 0x4197,      0, 0x40d2, 0x4198,      0, 0x40d8, 0x4194, 
	     0, 0x40d8, 0x4195,      0, 0x40d8, 0x4196,      0, 0x40d8, 
	0x4197,      0, 0x40d8, 0x4198,      0, 0x40de, 0x4194,      0, 
	0x40de, 0x4195,      0, 0x40de, 0x4196,      0, 0x40de, 0x4197, 
	     0, 0x40de, 0x4198,      0, 0x40e4, 0x4194,      0, 0x40e4, 
	0x4195,      0, 0x40e4, 0x4196,      0, 0x40e4, 0x4197,      0, 
	0x40e4, 0x4198,      0, 0x40ea, 0x4194,      0, 0x40ea, 0x4195, 
	     0, 0x40ea, 0x4196,      0, 0x40ea, 0x4197,      0, 0x40ea, 
	0x4198,      0, 0x40f0, 0x4194,      0, 0x40f0, 0x4195,      0, 
	0x40f0, 0x4196,      0, 0x40f0, 0x4197,      0, 0x40f0, 0x4198, 
	     0, 0x40f6, 0x4194,      0, 0x40f6, 0x4195,      0, 0x40f6, 
	0x4196,      0, 0x40f6, 0x4197,      0, 0x40f6, 0x4198,      0, 
	0x40fc, 0x4194,      0, 0x40fc, 0x4195,      0, 0x40fc, 0x4196, 
	     0, 0x40fc, 0x4197,      0, 0x40fc, 0x4198,      0, 0x4102, 
	0x4194,      0, 0x4102, 0x4195,      0, 0x4102, 0x4196,      0, 
	0x4102, 0x4197,      0, 0x4102, 0x4198,      0, 0x4108, 0x4194, 
	     0, 0x4108, 0x4195,      0, 0x4108, 0x4196,      0, 0x4108, 
	0x4197,      0, 0x4108, 0x4198,      0, 0x410e, 0x4194,      0, 
	0x410e, 0x4195,      0, 0x410e, 0x4196,      0, 0x410e, 0x4197, 
	     0, 0x410e, 0x4198,      0, 0x4114, 0x4194,      0, 0x4114, 
	0x4195,      0, 0x4114, 0x4196,      0, 0x4114, 0x4197,      0, 
	0x4114, 0x4198,      0, 0x411a, 0x4194,      0, 0x411a, 0x4195, 
	     0, 0x411a, 0x4196,      0, 0x411a, 0x4197,      0, 0x411a, 
	0x4198,      0, 0x4120, 0x4194,      0, 0x4120, 0x4195,      0, 
	0x4120, 0x4196,      0, 0x4120, 0x4197,      0, 0x4120, 0x4198, 
	     0, 0x4126, 0x4194,      0, 0x4126, 0x4195,      0, 0x4126, 
	0x4196,      0, 0x4126, 0x4197,      0, 0x4126, 0x4198,      0, 
	0x412c, 0x4194,      0, 0x412c, 0x4195,      0, 0x412c, 0x4196, 
	     0, 0x412c, 0x4197,      0, 0x412c, 0x4198,      0, 0x4132, 
	0x4194,      0, 0x4132, 0x4195,      0, 0x4132, 0x4196,      0, 
	0x4132, 0x4197,      0, 0x4132, 0x4198,      0, 0x4138, 0x4194, 
	     0, 0x4138, 0x4195,      0, 0x4138, 0x4196,      0, 0x4138, 
	0x4197,      0, 0x4138, 0x4198,      0, 0x413e, 0x4194,      0, 
	0x413e, 0x4195,      0, 0x413e, 0x4196,      0, 0x413e, 0x4197, 
	     0, 0x413e, 0x4198,      0, 0x4144, 0x4194,      0, 0x4144, 
	0x4195,      0, 0x4144, 0x4196,      0, 0x4144, 0x4197,      0, 
	0x4144, 0x4198,      0, 0x414a, 0x4194,      0, 0x414a, 0x4195, 
	     0, 0x414a, 0x4196,      0, 0x414a, 0x4197,      0, 0x414a, 
	0x4198,      0, 0x4151, 0x4194,      0, 0x4151, 0x4195,      0, 
	0x4151, 0x4196,      0, 0x4151, 0x4197,      0, 0x4151, 0x4198, 
	     0, 0x4158, 0x4194,      0, 0x4158, 0x4195,      0, 0x4158, 
	0x4196,      0, 0x4158, 0x4197,      0, 0x4158, 0x4198,      0, 
	0x415e, 0x4194,      0, 0x415e, 0x4195,      0, 0x415e, 0x4196, 
	     0, 0x415e, 0x4197,      0, 0x415e, 0x4198,      0, 0x4164, 
	0x4194,      0, 0x4164, 0x4195,      0, 0x4164, 0x4196,      0, 
	0x4164, 0x4197,      0, 0x4164, 0x4198,      0, 0x416a, 0x4194, 
	     0, 0x416a, 0x4195,      0, 0x416a, 0x4196,      0, 0x416a, 
	0x4197,      0, 0x416a, 0x4198,      0, 0x4170, 0x4194,      0, 
	0x4170, 0x4195,      0, 0x4170, 0x4196,      0, 0x4170, 0x4197, 
	     0, 0x4170, 0x4198,      0, 0x4176, 0x4194,      0, 0x4176, 
	0x4195,      0, 0x4176, 0x4196,      0, 0x4176, 0x4197,      0, 
	0x4176, 0x4198,      0, 0x417c, 0x4194,      0, 0x417c, 0x4195, 
	     0, 0x417c, 0x4196,      0, 0x417c, 0x4197,      0, 0x417c, 
	0x4198,      0, 0x4182, 0x4194,      0, 0x4182, 0x4195,      0, 
	0x4182, 0x4196,      0, 0x4182, 0x4197,      0, 0x4182, 0x4198, 
	     0, 0x000e, 0x0011, 0x0008, 0x000d, 0x000f, 0x0006, 0x000c, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0005, 0x000a,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0009, 0x0007, 0x000b,      0,      0, 0x0010, 0x0003, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0004,      0, 0x0001, 0x0002, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x000f,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x00a8, 
	0x00ad, 0x0064, 0x0069, 0x006e, 0x0074, 0x007d, 0x0083, 0x008c, 
	0x0090, 0x0092, 0x0094, 0x0097, 0x009a, 0x00a0, 0x00a3, 0x0078, 
	0x007c,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x001a,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0052, 0x0072, 0x0005, 0x0077,      0, 
	0x0020,      0, 0x0088, 0x006f, 0x0006, 0x0011, 0x0008, 0x00a7, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0010,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x0024,      0, 0x0025,      0,      0,      0, 
	     0,      0, 0x0026,      0,      0,      0,      0, 0x0027, 
	     0, 0x0028,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x0037, 
	0x007b, 0x0081, 0x0086, 0x008b,      0, 0x0034, 0x0063, 0x0068, 
	0x006d, 0x0073,      0,      0,      0,      0,      0, 0x004d, 
	0x0055, 0x0059,      0, 0x00aa, 0x00ae, 0x00b2, 0x00b4, 0x0093, 
	     0,      0,      0,      0,      0, 0x0023,      0,      0, 
	     0,      0,      0,      0, 0x0019,      0,      0,      0, 
	     0,      0,      0, 0x003d,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0050,      0,      0,      0, 
	     0,      0,      0,      0, 0x003a,      0,      0, 0x000c, 
	     0,      0,      0, 0x001c,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x009f,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x008f, 
	0x0091,      0,      0,      0,      0, 0x00ac, 0x00b1,      0, 
	     0,      0,      0, 0x002f,      0,      0,      0,      0, 
	     0,      0,      0, 0x0029,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x000b,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x00bf,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x000d,      0, 0x0018, 0x0033, 0x0057, 0x005d, 
	0x0066, 0x0046, 0x008e, 0x00af,      0, 0x004c, 0x005a, 0x0048, 
	0x0031, 0x0004, 0x005c, 0x0035, 0x0060,      0, 0x0036,      0, 
	0x001e, 0x0061, 0x0012, 0x001f,      0,      0,      0, 0x004f, 
	0x005b, 0x000a, 0x002d,      0,      0,      0, 0x009e, 0x0021, 
	0x009b,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0009, 0x00b8, 0x0051, 0x00bd, 0x00c4, 0x0040, 0x005e, 
	0x004b, 0x0058, 0x0062, 0x0042, 0x002e, 0x003f, 0x00bb, 0x0054, 
	     0, 0x0032, 0x005f, 0x0065, 0x006a, 0x0096, 0x00a2, 0x0085, 
	0x008a, 0x00a9, 0x00c0, 0x007e, 0x0053, 0x00b7, 0x0099, 0x0087, 
	0x00b3, 0x0070, 0x0075, 0x007a, 0x0080, 0x0084, 0x00b9, 0x00c2, 
	0x009c, 0x00c3, 0x00ba, 0x00c8, 0x0043, 0x00b0, 0x0095, 0x00b5, 
	0x00bc, 0x0039, 0x008d, 0x0079, 0x007f, 0x0082, 0x0089, 0x0067, 
	0x006b, 0x0071, 0x0076, 0x0038, 0x006c,      0,      0,      0, 
	     0,      0,      0, 0x0098, 0x002b, 0x0022, 0x0007, 0x002c, 
	0x00ab,      0,      0,      0, 0x00a5, 0x002a, 0x00a6,      0, 
	     0, 0x003b, 0x0013, 0x00c5, 0x00c7, 0x0016, 0x0014, 0x0017, 
	0x0015,      0,      0,      0,      0,      0,      0, 0x0030, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x001b,      0,      0, 
	     0, 0x00b6, 0x00c6, 0x003c, 0x00be, 0x003e, 0x00c1, 0x0041, 
	0x009d, 0x00a1, 0x00a4, 0x0045, 0x0044, 0x0047, 0x004e, 0x004a, 
	0x0056,      0, 0x0002, 0x001d, 0x0003,      0,      0, 0x0001, 
	     0,      0,      0,      0,      0, 0x000e, 0x0049,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x050c,      0,      0,      0,      0,      0,      0,      0, 
	0x04ad,      0,      0,      0,      0,      0,      0,      0, 
	0x04af,      0,      0,      0,      0,      0,      0, 0x022d, 
	     0,      0,      0,      0,      0,      0,      0, 0x0255, 
	0x0256,      0,      0,      0,      0,      0,      0, 0x02b3, 
	0x02b4,      0,      0,      0,      0,      0,      0, 0x04bb, 
	0x04ba,      0,      0,      0,      0,      0,      0, 0x02bd, 
	0x02be,      0,      0,      0,      0,      0,      0, 0x02db, 
	     0,      0,      0,      0,      0,      0,      0, 0x00df, 
	0x00e6,      0,      0,      0,      0,      0,      0, 0x00f5, 
	     0,      0,      0,      0,      0,      0, 0x04ae,      0, 
	     0,      0,      0,      0,      0, 0x010c,      0,      0, 
	     0,      0,      0,      0,      0, 0x0512, 0x0510, 0x0511, 
	0x050f,      0,      0,      0,      0, 0x0621,      0,      0, 
	     0,      0,      0,      0,      0, 0x0622, 0x0623, 0x0624, 
	0x0625,      0,      0,      0,      0, 0x0452, 0x0453,      0, 
	     0,      0,      0,      0,      0, 0x067d,      0,      0, 
	     0,      0,      0,      0,      0, 0x00f6,      0,      0, 
	     0,      0,      0,      0,      0, 0x00f7,      0,      0, 
	     0,      0,      0,      0,      0, 0x00fa,      0,      0, 
	     0,      0,      0,      0,      0, 0x00fb,      0,      0, 
	     0,      0,      0,      0,      0, 0x00fd,      0,      0, 
	     0,      0,      0,      0, 0x010d,      0,      0,      0, 
	0x010e,      0,      0,      0, 0x0178, 0x017a, 0x017b, 0x017c, 
	     0,      0,      0, 0x0107,      0,      0,      0,      0, 
	     0,      0,      0, 0x010a, 0x010b,      0,      0,      0, 
	     0,      0,      0, 0x050a,      0,      0,      0,      0, 
	     0,      0,      0, 0x050e,      0,      0,      0,      0, 
	     0,      0,      0, 0x0245,      0,      0,      0,      0, 
	     0,      0,      0, 0x0248, 0x0247,      0,      0,      0, 
	     0,      0,      0, 0x0261, 0x0262, 0x0263, 0x0264,      0, 
	     0,      0,      0, 0x0098,      0,      0,      0,      0, 
	     0,      0,      0, 0x04b7, 0x04b6,      0,      0,      0, 
	     0,      0,      0, 0x00bd,      0,      0,      0, 0x00f4, 
	     0,      0,      0, 0x04c8,      0,      0, 0x04c7,      0, 
	     0,      0,      0, 0x04ca,      0,      0, 0x04c9,      0, 
	     0,      0,      0, 0x04cc,      0,      0, 0x04cb,      0, 
	     0,      0,      0, 0x04ce,      0,      0, 0x04cd,      0, 
	     0,      0,      0, 0x04d0,      0,      0, 0x04cf,      0, 
	     0,      0,      0, 0x04d2,      0,      0, 0x04d1,      0, 
	     0,      0,      0, 0x04d9, 0x04d8,      0,      0,      0, 
	     0,      0,      0, 0x04db, 0x04da, 0x04b5, 0x04b4,      0, 
	     0,      0,      0, 0x04df, 0x04de,      0,      0, 0x04e1, 
	0x04e0,      0,      0, 0x00e2, 0x00e4, 0x00e1,      0,      0, 
	     0,      0,      0, 0x02f8,      0, 0x02de,      0, 0x02ec, 
	     0,      0, 0x0104,      0,      0,      0,      0,      0, 
	     0,      0, 0x0108, 0x0109,      0,      0,      0,      0, 
	     0,      0, 0x022a,      0,      0,      0,      0, 0x0228, 
	     0,      0, 0x012d, 0x012e, 0x012f, 0x0130, 0x0131, 0x0132, 
	0x0133,      0, 0x042d, 0x042e, 0x042f, 0x0437, 0x0430, 0x0439, 
	0x0679,      0, 0x0531, 0x0532, 0x0533, 0x0534, 0x0535, 0x0536, 
	0x0537,      0, 0x0234,      0,      0,      0,      0,      0, 
	     0,      0, 0x0434,      0,      0,      0,      0,      0, 
	0x0241,      0, 0x0557, 0x0558, 0x0559, 0x055a, 0x055b, 0x055c, 
	0x055d,      0, 0x0467, 0x0465, 0x0464, 0x0466, 0x0468, 0x0469, 
	0x046a,      0, 0x0476, 0x0474, 0x0473, 0x0475, 0x0477, 0x0478, 
	0x0479,      0, 0x04ac,      0,      0,      0,      0,      0, 
	     0, 0x0100, 0x0101, 0x00ff,      0,      0,      0,      0, 
	     0, 0x0400, 0x03d8, 0x01e9, 0x0199,      0,      0, 0x01e7, 
	0x0197, 0x0102, 0x0105, 0x0103, 0x0106,      0,      0,      0, 
	     0, 0x0403, 0x03db, 0x01ec, 0x019c, 0x0404, 0x03dc, 0x0405, 
	0x03dd, 0x0305,      0, 0x0307, 0x0339, 0x0303, 0x0336, 0x02ed, 
	0x0320, 0x0306, 0x0308, 0x02ea, 0x02fe, 0x030b, 0x0312, 0x0316, 
	0x031a, 0x0408, 0x03e0, 0x01f4, 0x01a4, 0x0409, 0x03e1, 0x01f7, 
	0x01a8, 0x030d, 0x0318, 0x0300, 0x0301, 0x02ff, 0x0335, 0x0328, 
	     0, 0x040d, 0x0217, 0x0216, 0x0218, 0x0413, 0x0221, 0x0226, 
	0x03ea, 0x020e, 0x01c1, 0x0211, 0x01c4, 0x040f, 0x03e7, 0x0411, 
	0x03e9, 0x040e, 0x03e6, 0x0209, 0x01bc, 0x020d, 0x01c0, 0x020f, 
	0x01c2, 0x010f, 0x023f, 0x0240, 0x0433, 0x0242, 0x0243, 0x0244, 
	0x0435, 0x0410, 0x03e8, 0x0412, 0x03eb, 0x0213, 0x01c6, 0x0214, 
	0x01c7, 0x0613, 0x0615,      0,      0,      0,      0,      0, 
	     0, 0x0514, 0x0513,      0,      0,      0,      0, 0x050d, 
	0x050b, 0x0415, 0x03ee, 0x021b, 0x01ce, 0x021e, 0x01d1, 0x0222, 
	0x01d6, 0x0317, 0x0319, 0x031e, 0x0321, 0x0322, 0x0323, 0x0324, 
	0x0325, 0x0419, 0x041b, 0x041d, 0x041f, 0x0421, 0x0423, 0x0425, 
	0x0427, 0x011a, 0x011b, 0x011c, 0x011d, 0x011e, 0x011f, 0x0120, 
	0x0121, 0x021a, 0x01cd, 0x021c, 0x01cf, 0x0414, 0x03ed, 0x0219, 
	0x01cc, 0x041a, 0x041c, 0x041e, 0x0420, 0x0422, 0x0424, 0x0426, 
	0x0428, 0x051a, 0x0519, 0x051c, 0x051b,      0,      0,      0, 
	     0, 0x031c, 0x02da, 0x02dc, 0x02dd, 0x02df, 0x02e1, 0x02e3, 
	0x02e5, 0x061d, 0x061e,      0,      0,      0,      0, 0x024d, 
	0x024e, 0x021f, 0x0220, 0x0665, 0x00b5, 0x00d5, 0x00b6, 0x00e0, 
	0x0097, 0x031f, 0x0329, 0x032d, 0x031d,      0,      0,      0, 
	     0, 0x0122, 0x0123,      0, 0x0124, 0x0125, 0x0126, 0x0127, 
	0x0128, 0x0223, 0x0225, 0x01d8, 0x0418, 0x03f1, 0x0417, 0x03f0, 
	     0, 0x0227, 0x0432, 0x0229, 0x022b, 0x022c, 0x022e, 0x022f, 
	0x0230, 0x0327, 0x02f6, 0x032b, 0x032a, 0x032e, 0x0330, 0x0334, 
	0x0337, 0x0129, 0x012a, 0x012b, 0x012c,      0,      0,      0, 
	     0, 0x0429, 0x042b, 0x0110, 0x0111, 0x0112, 0x0113,      0, 
	     0, 0x042a, 0x042c,      0,      0,      0,      0,      0, 
	     0, 0x0231, 0x061f, 0x0620,      0,      0,      0,      0, 
	     0, 0x0232, 0x0233, 0x0235, 0x0237, 0x0238, 0x0239, 0x023a, 
	0x023b, 0x0333, 0x030a, 0x030c, 0x030e, 0x030f, 0x0311, 0x0313, 
	0x0315, 0x0134, 0x0135, 0x0136, 0x0137, 0x0138, 0x0139, 0x013a, 
	0x013b, 0x0236,      0,      0,      0,      0,      0,      0, 
	     0, 0x0436,      0,      0,      0,      0,      0,      0, 
	     0, 0x0338, 0x033a, 0x031b, 0x0332, 0x0326, 0x0331, 0x033b, 
	     0, 0x0538, 0x0539, 0x053a, 0x053b, 0x053c, 0x053d, 0x053e, 
	0x053f, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f, 0x0454, 0x0455, 
	0x0440, 0x013c, 0x013d, 0x013e, 0x013f, 0x0140, 0x0141, 0x0142, 
	0x0143, 0x023c, 0x023d, 0x023e,      0,      0,      0,      0, 
	     0, 0x033c, 0x033d, 0x033e, 0x033f, 0x0340, 0x0341, 0x0342, 
	0x0343, 0x0540, 0x0541, 0x0542, 0x0543, 0x0544, 0x0545, 0x0546, 
	0x0547, 0x0441, 0x02b7, 0x02b8, 0x02b9, 0x02ba, 0x0442, 0x0443, 
	0x0249, 0x0144, 0x0145, 0x0146, 0x0147, 0x0148, 0x0149, 0x014a, 
	0x014b, 0x0344, 0x0345, 0x0347, 0x0348, 0x0349, 0x034a, 0x034b, 
	0x034c, 0x0346, 0x046b, 0x046c, 0x046e, 0x046d,      0, 0x046f, 
	0x0470, 0x0548, 0x0549, 0x054a, 0x054b, 0x054c, 0x054d, 0x054e, 
	0x054f, 0x024a, 0x024b, 0x024c, 0x0444, 0x0445, 0x0251, 0x0252, 
	0x0253, 0x044c, 0x044d, 0x02a3, 0x02a4, 0x02a5, 0x02a6,      0, 
	     0, 0x014d, 0x014e, 0x014f, 0x0150, 0x0151, 0x0152, 0x0153, 
	0x0154, 0x034d, 0x034e, 0x034f, 0x0350, 0x0351, 0x0352, 0x0353, 
	0x0354, 0x024f, 0x0250,      0,      0,      0,      0,      0, 
	     0, 0x0550, 0x0551, 0x0552, 0x0553, 0x0554, 0x0555, 0x0556, 
	     0, 0x0254, 0x0259, 0x025a, 0x025b, 0x025c, 0x025d, 0x025e, 
	0x025f, 0x0155, 0x0156, 0x0157, 0x0158, 0x0159, 0x015a, 0x015b, 
	0x015c, 0x0355, 0x0356, 0x0357, 0x0471, 0x0358, 0x0472, 0x0359, 
	0x035a, 0x0257, 0x0258,      0,      0,      0,      0,      0, 
	     0, 0x0457, 0x0458, 0x0459, 0x045a, 0x045b, 0x045c, 0x045d, 
	0x045e, 0x035b, 0x035c, 0x035d, 0x035e, 0x035f, 0x0360, 0x0361, 
	0x0362, 0x015d, 0x015e, 0x015f, 0x0160, 0x0161, 0x0162, 0x0163, 
	0x0164, 0x055e, 0x055f, 0x0560, 0x0561, 0x0562, 0x0563, 0x0564, 
	0x0565, 0x045f, 0x0460, 0x0461, 0x0462, 0x0463,      0,      0, 
	     0, 0x0260, 0x0265, 0x0266, 0x0267, 0x0268, 0x0269, 0x026a, 
	0x026b, 0x0660, 0x020b, 0x0661, 0x0662, 0x0663, 0x0215, 0x021d, 
	0x0664, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367, 0x0368, 0x0369, 
	0x036a, 0x0165, 0x0166, 0x0167, 0x0168, 0x0169, 0x016a, 0x016b, 
	0x016c, 0x0566, 0x0567, 0x0568, 0x0569, 0x056a, 0x056b, 0x056c, 
	0x056d, 0x036b, 0x036c, 0x036d, 0x036e, 0x036f, 0x0370, 0x0371, 
	0x0372, 0x026c, 0x026d, 0x026e, 0x0271, 0x0272, 0x0273, 0x0274, 
	0x0277, 0x016d, 0x00a0, 0x00c0, 0x00c2, 0x00bf, 0x00c3, 0x00f1, 
	0x00b9, 0x016e, 0x016f, 0x0170, 0x0171, 0x0172, 0x0173, 0x0174, 
	0x0175, 0x056e, 0x056f, 0x0570, 0x0571, 0x0572, 0x0573, 0x0574, 
	0x0575, 0x066e, 0x01be, 0x066f, 0x0670, 0x0671, 0x01c8, 0x01d0, 
	0x0672, 0x026f, 0x0270, 0x0279, 0x027a, 0x0275, 0x0276, 0x044a, 
	0x044b, 0x0373, 0x0374, 0x0375, 0x0481, 0x0376, 0x0482, 0x0377, 
	0x0378, 0x0176, 0x0177, 0x009e, 0x009d, 0x00ea, 0x00ec, 0x00ee, 
	0x00a1, 0x0576, 0x0577, 0x0578, 0x0579, 0x057a, 0x057b, 0x057c, 
	     0, 0x0278, 0x027b, 0x027c, 0x027d, 0x027e, 0x027f, 0x0280, 
	0x0281, 0x047a, 0x047b, 0x047c, 0x047e, 0x047d,      0, 0x047f, 
	0x0480, 0x067a, 0x067b, 0x067c, 0x03ba, 0x03bd, 0x03bf, 0x03c1, 
	0x03c4, 0x017f,      0,      0,      0, 0x0183, 0x0184, 0x0185, 
	0x0186, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286, 0x0287, 0x0288, 
	0x0289, 0x0187, 0x0188, 0x00db, 0x00d9,      0, 0x00b2, 0x00b4, 
	     0, 0x028a, 0x028b, 0x028c, 0x028d, 0x028e, 0x028f, 0x0290, 
	0x0291, 0x048b, 0x048c, 0x048d,      0,      0,      0,      0, 
	     0, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297, 0x0298, 
	0x0299, 0x0193, 0x0192, 0x0194, 0x0195, 0x019f, 0x019e, 0x03df, 
	0x01a0, 0x0096, 0x009f, 0x00ac, 0x00d7, 0x00c1, 0x00d8, 0x00d6, 
	0x00a9, 0x029a, 0x029b, 0x029c, 0x029d, 0x029e, 0x029f, 0x02a0, 
	0x02a1, 0x049b, 0x049a, 0x04b1, 0x04b0,      0,      0,      0, 
	     0, 0x019d, 0x066a, 0x01a5, 0x01a6, 0x066b, 0x01af, 0x066c, 
	0x066d, 0x02a2, 0x0446, 0x0447, 0x0448, 0x0449, 0x02a7, 0x02a8, 
	0x02a9, 0x00a4,      0,      0,      0,      0,      0,      0, 
	     0, 0x00a7, 0x0180, 0x01b6, 0x00b0, 0x0179, 0x017d, 0x017e, 
	0x00a2, 0x01a7, 0x01f9, 0x01aa, 0x01fc, 0x01ad, 0x01fa, 0x01ab, 
	0x01fd, 0x00a8,      0,      0,      0,      0,      0,      0, 
	     0, 0x00aa, 0x00ab,      0,      0, 0x00ad, 0x00ae,      0, 
	     0, 0x02aa, 0x02ab, 0x02ac, 0x02ad, 0x02ae, 0x02af, 0x02b0, 
	0x02b1, 0x01ae, 0x01fb, 0x01ac, 0x0200, 0x01b2, 0x0202, 0x01b4, 
	0x0201, 0x00b1, 0x00b3, 0x00d4, 0x00da, 0x009c, 0x009b, 0x00a5, 
	0x00a3, 0x02b2, 0x044e, 0x044f, 0x0450, 0x0451, 0x02b5, 0x02b6, 
	0x0456, 0x01b3, 0x01b1, 0x040b, 0x03e3, 0x0208, 0x01bb,      0, 
	     0, 0x04b3, 0x04b2,      0,      0,      0,      0,      0, 
	     0, 0x04b9, 0x04b8,      0,      0,      0,      0, 0x04dd, 
	0x04dc, 0x02bb, 0x02bc,      0,      0,      0,      0,      0, 
	     0, 0x03bb, 0x03bc, 0x03be,      0, 0x03c0,      0, 0x03c2, 
	0x03c3, 0x00be, 0x01da, 0x01dd, 0x0658, 0x0659, 0x01e1, 0x065a, 
	0x065b, 0x02bf, 0x0674, 0x02c1, 0x02c2, 0x02c3, 0x02c4, 0x02c5, 
	0x02c6, 0x04bf, 0x04be, 0x04bd, 0x04bc,      0,      0,      0, 
	     0, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 0x00c8, 0x00c9, 0x00ca, 
	0x00cb, 0x03c5, 0x03c6, 0x03c8, 0x03c9, 0x0115, 0x0116, 0x0118, 
	0x0119, 0x02c7, 0x02c8, 0x02c9, 0x0675, 0x02cb, 0x02cc, 0x02cd, 
	0x02ce, 0x03c7, 0x0114, 0x0117, 0x0610, 0x0611, 0x0612,      0, 
	     0, 0x03cb, 0x03ca, 0x03cc, 0x03cd, 0x03ce, 0x03cf, 0x03d1, 
	0x03d2, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 0x00d0, 0x00d1, 0x00d2, 
	0x00d3, 0x02cf, 0x02d0, 0x02d1, 0x02d2, 0x0676, 0x02d4, 0x02d5, 
	0x02d6, 0x01d2, 0x01d3, 0x0673, 0x00b7, 0x00f0, 0x00b8, 0x00e5, 
	0x014c, 0x02d7, 0x0677, 0x0678,      0,      0,      0,      0, 
	     0, 0x03d7, 0x03e2, 0x01b8, 0x01b7, 0x01b9, 0x01ba, 0x03e4, 
	0x00e7, 0x01dc, 0x018c, 0x03f8, 0x03d0, 0x01db, 0x018b, 0x03fb, 
	0x03d3, 0x00de, 0x0189, 0x018d, 0x0666, 0x0667, 0x0191, 0x0668, 
	0x0669, 0x02e2, 0x02e6, 0x02e9,      0, 0x02f3,      0, 0x02fd, 
	0x0309, 0x00e3, 0x00bb, 0x018a, 0x00af, 0x00ef, 0x009a, 0x00bc, 
	0x0099, 0x01e3, 0x01e2, 0x01e4, 0x01e5, 0x01ef, 0x01ee, 0x0407, 
	0x01f0, 0x02e4, 0x0314, 0x02e0, 0x0310, 0x02f9, 0x032c, 0x02fb, 
	0x032f, 0x03e5, 0x01ca, 0x01c9, 0x01cb, 0x03ec, 0x01d4, 0x01d9, 
	0x01d5, 0x02e7, 0x02e8, 0x02eb, 0x02ee, 0x02ef, 0x02f0, 0x02f1, 
	0x02f2, 0x01e8, 0x0198, 0x01e6, 0x0196, 0x0402, 0x03da, 0x0401, 
	0x03d9, 0x00e9,      0,      0,      0, 0x00eb, 0x00ed,      0, 
	     0, 0x01ed, 0x065c, 0x01f5, 0x01f6, 0x065d, 0x01fe, 0x065e, 
	0x065f, 0x01f1, 0x01a1, 0x01f3, 0x01a3,      0,      0, 0x01f2, 
	0x01a2, 0x00f2, 0x00dc, 0x0181, 0x0182, 0x00dd, 0x00f3, 0x00ba, 
	0x00a6, 0x03f3, 0x03f2, 0x03f4, 0x03f5, 0x03f6, 0x03f7, 0x03f9, 
	0x03fa, 0x02f4, 0x02f5,      0, 0x02f7, 0x02fa, 0x02fc, 0x0302, 
	0x0304, 0x00f8,      0,      0,      0, 0x00fc,      0,      0, 
	     0, 0x03fc, 0x03d4, 0x03fe, 0x03d6, 0x03fd, 0x03d5, 0x01e0, 
	0x0190, 0x00fe,      0,      0,      0, 0x00f9,      0,      0, 
	     0, 0x03ff, 0x040a, 0x0205, 0x0204, 0x0206, 0x0207, 0x040c, 
	0x00e8, 0x0008, 0x000d, 0x0009, 0x0005,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x000e, 0x0007, 0x000b, 0x0003, 0x0006,      0,      0,      0, 
	     0, 0x000a, 0x0004,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x000c,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0001,      0, 
	0x0002,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0051,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0008, 0x002a, 0x0062, 0x006d, 0x007a, 0x0082, 0x008c, 0x0097, 
	0x00a4,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0023,      0, 0x006c,      0, 0x006e, 
	0x0078, 0x007d, 0x0085,      0,      0,      0,      0, 0x000f, 
	     0, 0x008d, 0x0094, 0x0070, 0x0075, 0x00a0, 0x008b, 0x0095, 
	0x0039, 0x00a7, 0x00aa, 0x00ae, 0x002f, 0x003c, 0x003d, 0x0027, 
	     0,      0, 0x000b, 0x005c,      0,      0,      0,      0, 
	0x0001,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x002b, 0x0012,      0, 
	     0, 0x000a, 0x000c, 0x0033, 0x0077, 0x005d, 0x00a9, 0x00ac, 
	0x0060,      0,      0, 0x001c,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0017, 0x0009,      0, 0x000e, 0x0042,      0, 0x0043, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x0020, 0x004b,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x002e, 0x0093, 0x0098, 0x009c, 0x001f,      0,      0, 
	0x009d, 0x00a1,      0, 0x0024,      0,      0,      0,      0, 
	     0, 0x0025, 0x0016, 0x00b0,      0,      0, 0x0026, 0x00b5, 
	0x003f, 0x0046, 0x0030, 0x0011,      0, 0x0049, 0x004a,      0, 
	     0, 0x0034, 0x0066, 0x0087, 0x009b, 0x0072, 0x00ab, 0x0065, 
	0x00ad, 0x006f, 0x0079, 0x005e, 0x007f, 0x008e, 0x0067, 0x008f, 
	0x0068, 0x00af, 0x00b4, 0x0059, 0x003e, 0x007c, 0x0047, 0x0050, 
	0x0053, 0x0014, 0x0031, 0x00a6, 0x005f, 0x0007, 0x006a, 0x00a5, 
	0x001a, 0x0037, 0x0099, 0x00b3, 0x009a, 0x00b6, 0x0038, 0x0028, 
	0x0029, 0x004d, 0x009e,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x004f, 0x0056, 
	     0, 0x004c, 0x0052, 0x0058,      0, 0x003b, 0x0045, 0x0055, 
	0x0063, 0x0074, 0x0083, 0x003a, 0x0044, 0x0054, 0x0061, 0x0073, 
	0x0080,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x004e, 0x0032, 0x0057, 0x001b, 0x0021, 0x0022, 0x007b, 
	     0, 0x002c, 0x0010, 0x0018,      0, 0x0019,      0, 0x0003, 
	     0, 0x002d, 0x0069, 0x006b,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x007e, 0x0036,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0090, 0x00b1,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x000d, 0x0015, 0x0013,      0, 
	     0, 0x0035,      0,      0,      0,      0,      0,      0, 
	0x001d, 0x001e, 0x0081, 0x0089, 0x0092, 0x008a, 0x0086,      0, 
	     0, 0x009f, 0x00b2, 0x005a, 0x0076, 0x0084, 0x00a3, 0x0040, 
	0x0048, 0x005b, 0x0071, 0x00a2, 0x0091, 0x0041, 0x0096, 0x00a8, 
	0x0064,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0002, 0x0088, 0x0005, 0x0006, 
	0x0004,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0250,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x00a1,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x015b, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x00ac, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x00a7, 0x00a8, 
	0x00a9,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x00aa,      0, 
	0x00ab,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x02ca, 0x02cb, 
	0x0360,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x05e1,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x020c,      0, 0x020d, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0543,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0245,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0544,      0,      0,      0, 
	0x0545,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0783,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x020e, 0x020f, 0x0210,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x01ab,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x0157, 0x0158,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0122,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0252,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x02e6, 0x02e7,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x0784, 
	0x0092,      0, 0x0785,      0, 0x0786,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x00e8, 
	0x00e9,      0,      0,      0,      0,      0,      0, 0x00ea, 
	     0,      0,      0,      0,      0,      0, 0x0208, 0x0209, 
	     0,      0,      0,      0,      0,      0,      0, 0x020a, 
	0x020b,      0,      0,      0,      0,      0, 0x0159,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x015a,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0337, 0x0338,      0, 
	     0,      0,      0, 0x06e2, 0x06e3, 0x06ec, 0x06ed, 0x0720, 
	0x0721,      0,      0,      0,      0, 0x0143, 0x0144, 0x0145, 
	0x0146,      0,      0,      0,      0, 0x0147,      0, 0x0148, 
	     0,      0,      0,      0,      0, 0x055b,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0099, 0x009a,      0, 
	     0,      0,      0, 0x009b,      0,      0,      0, 0x009c, 
	     0,      0,      0,      0,      0, 0x009d, 0x009e, 0x047c, 
	0x009f, 0x0486, 0x048c, 0x0492,      0, 0x04a3,      0, 0x04b0, 
	0x04bd,      0,      0,      0,      0, 0x06a5,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0222,      0,      0,      0, 
	0x0223,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0149,      0, 0x014a,      0, 
	     0, 0x014b,      0,      0,      0, 0x014c,      0,      0, 
	     0,      0,      0,      0, 0x014d,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0166,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x00e1, 0x00e2,      0,      0, 
	0x00e3,      0, 0x00e4,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x00e5,      0, 0x00e6,      0, 
	     0,      0, 0x00e7,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x00ef, 0x00f0, 0x00f1, 0x00f2, 
	0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x06c5, 0x06c7, 0x06c9, 0x06cb, 
	     0,      0,      0, 0x0205, 0x0206,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0207,      0,      0, 0x051e, 0x051f,      0,      0,      0, 
	     0,      0,      0, 0x0520, 0x0521,      0,      0,      0, 
	     0,      0,      0, 0x0522, 0x0523, 0x0524, 0x0525,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0549,      0, 0x054b,      0,      0, 
	     0, 0x054e,      0,      0,      0,      0, 0x0552, 0x0553, 
	0x0556,      0,      0, 0x0251,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0153, 0x0154,      0,      0, 0x0155, 
	0x0156,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x015c,      0,      0,      0,      0, 
	     0, 0x015d, 0x015e, 0x015f, 0x0160,      0,      0,      0, 
	     0,      0,      0, 0x00ad, 0x00ae, 0x00af, 0x00b0, 0x00b1, 
	     0,      0, 0x00b4, 0x00b5,      0,      0,      0, 0x00b2, 
	0x00b3,      0,      0, 0x01f3, 0x01f4,      0,      0,      0, 
	0x01f5,      0,      0, 0x01f6,      0, 0x01f7, 0x01f8,      0, 
	     0,      0, 0x011a,      0, 0x011b, 0x011c, 0x011d, 0x011e, 
	0x011f, 0x0120, 0x0121,      0,      0,      0,      0,      0, 
	     0,      0, 0x032b, 0x032c,      0,      0,      0,      0, 
	     0, 0x037e, 0x037f,      0,      0,      0,      0,      0, 
	     0,      0, 0x0130, 0x0131, 0x0132, 0x0133,      0,      0, 
	0x0134, 0x0135, 0x06a4, 0x0136,      0,      0, 0x0137, 0x0138, 
	0x0139,      0, 0x0547, 0x0548, 0x054a, 0x054c, 0x054d, 0x054f, 
	0x0551, 0x0555, 0x055c, 0x055f, 0x0564, 0x0569, 0x056e, 0x0573, 
	0x0578,      0, 0x0254, 0x0255, 0x0256, 0x0257, 0x0258, 0x0259, 
	0x025a, 0x025b, 0x004b, 0x004e, 0x004c, 0x004f, 0x004d, 0x025c, 
	0x025d,      0, 0x0292,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x02a0, 0x02a1, 0x02a2, 0x02a3, 0x02a4, 0x0554, 
	0x02a5, 0x02a6, 0x02a7,      0,      0,      0,      0,      0, 
	     0,      0, 0x04d2, 0x04ce, 0x04c8, 0x04d4, 0x0508, 0x04dc, 
	0x04de, 0x04e0, 0x04ea, 0x04f0, 0x04fc, 0x04e6,      0, 0x0500, 
	0x050c,      0, 0x04d3, 0x04cf, 0x04c9, 0x04d5, 0x0509, 0x04dd, 
	0x04df, 0x04e1, 0x04eb, 0x04f1, 0x04fd, 0x04e7,      0, 0x0501, 
	0x050d,      0, 0x01dc, 0x01dd,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x05f5, 0x05f7, 0x05f9, 0x05fb, 0x05fd, 0x05ff, 
	0x0602, 0x0604, 0x0606, 0x0608, 0x060b, 0x060d, 0x060f, 0x0611, 
	0x0613,      0, 0x05f6, 0x05f8, 0x05fa, 0x05fc, 0x05fe, 0x0600, 
	0x0603, 0x0605, 0x0607, 0x0609, 0x060c, 0x060e, 0x0610, 0x0612, 
	0x0614,      0, 0x01f9,      0,      0, 0x01fa,      0, 0x01fb, 
	0x01fc,      0,      0, 0x01fd, 0x01fe,      0,      0, 0x01ff, 
	0x0200, 0x0201, 0x0202,      0,      0,      0,      0,      0, 
	     0, 0x0203, 0x0204,      0,      0,      0,      0,      0, 
	     0, 0x0704, 0x0703, 0x0371, 0x0372, 0x0375, 0x0376, 0x0709, 
	0x070a, 0x070b, 0x0387, 0x0388, 0x070e, 0x070f, 0x0389, 0x038a, 
	0x038b, 0x0107, 0x0108, 0x0109, 0x010a, 0x010b, 0x010c, 0x010d, 
	0x010e, 0x010f, 0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 
	0x0116, 0x0409, 0x040a, 0x040b, 0x040c, 0x0403, 0x0404, 0x0407, 
	0x0408, 0x040d, 0x040e, 0x0417, 0x0418, 0x0419, 0x041a, 0x0421, 
	0x0422, 0x030a, 0x030b, 0x030c, 0x030d, 0x030e, 0x030f, 0x0310, 
	0x0311, 0x0366, 0x0367, 0x036c, 0x036d, 0x03cc, 0x03cd, 0x03c6, 
	0x03c7, 0x0211,      0, 0x0212,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217, 0x0218, 0x0219, 
	0x021a,      0, 0x021b, 0x021c, 0x021d, 0x021e, 0x021f, 0x0220, 
	0x0221, 0x0615, 0x0618, 0x061a, 0x061c, 0x061e, 0x0620, 0x0622, 
	0x0624, 0x0626, 0x0628, 0x062a, 0x062c, 0x062e, 0x0630, 0x0632, 
	0x0634, 0x0616, 0x0619, 0x061b, 0x061d, 0x061f, 0x0621, 0x0623, 
	0x0625, 0x0627, 0x0629, 0x062b, 0x062d, 0x062f, 0x0631, 0x0633, 
	0x0635, 0x0117, 0x0118, 0x0119,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x071a, 0x071b, 0x0726, 0x0727, 0x03ef, 0x03f0, 0x0728, 
	0x0729, 0x03f5, 0x03f6, 0x072a, 0x072b, 0x0405, 0x0406, 0x072e, 
	0x072f, 0x041f, 0x0420, 0x044a, 0x044b, 0x0442, 0x0443, 0x044c, 
	0x044d, 0x0440, 0x0441, 0x0448, 0x0449, 0x073c, 0x073d, 0x073e, 
	0x073f, 0x0123,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0124,      0, 0x0125,      0, 0x0126,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0224,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x022a, 0x022b, 
	0x022c,      0,      0, 0x022d, 0x022e, 0x022f, 0x0230, 0x0231, 
	0x0232, 0x0526, 0x0527,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0127,      0, 0x0128, 0x0129,      0, 0x012a, 0x012b, 
	0x012c, 0x012d,      0,      0, 0x012e,      0,      0,      0, 
	0x012f, 0x0528, 0x0529, 0x052a, 0x052b, 0x052c, 0x052d, 0x052e, 
	0x052f, 0x0530, 0x0531, 0x0532, 0x0533, 0x0534, 0x0535, 0x0536, 
	0x0537, 0x072c, 0x072d, 0x041d, 0x041e, 0x0415, 0x0416, 0x041b, 
	0x041c, 0x043e, 0x043f, 0x0736, 0x0737, 0x042a, 0x042b, 0x0432, 
	0x0433, 0x0330, 0x0331, 0x0332, 0x0333, 0x0334, 0x0412, 0x0402, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237, 0x0238, 0x0239, 
	0x023a,      0,      0,      0,      0, 0x023b,      0,      0, 
	     0, 0x0734, 0x0735, 0x0446, 0x0447, 0x0746, 0x0747, 0x0466, 
	0x0467, 0x0468, 0x0755, 0x0756, 0x0759, 0x075a, 0x0757, 0x0758, 
	0x0410, 0x0636, 0x0638, 0x063a, 0x063c, 0x063e, 0x0640, 0x0642, 
	0x0644, 0x0646, 0x0648, 0x064a, 0x064c, 0x064e, 0x0650, 0x0652, 
	0x0654, 0x0637, 0x0639, 0x063b, 0x063d, 0x063f, 0x0641, 0x0643, 
	0x0645, 0x0647, 0x0649, 0x064b, 0x064d, 0x064f, 0x0651, 0x0653, 
	0x0655, 0x0538, 0x0539, 0x053a, 0x053b, 0x053c, 0x053d, 0x053e, 
	0x053f, 0x0540, 0x0541, 0x0542,      0,      0,      0,      0, 
	     0, 0x013a,      0,      0,      0,      0, 0x013b,      0, 
	0x013c, 0x013d, 0x013e, 0x013f, 0x0140, 0x0141,      0, 0x0142, 
	     0, 0x023c,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x033d, 0x033e, 0x06fe, 0x06ff, 0x0348, 0x0349, 0x0350, 
	0x0351, 0x0368, 0x0369, 0x0707, 0x0708, 0x035a, 0x035b, 0x036e, 
	0x036f, 0x0341, 0x0342, 0x034c, 0x034d, 0x034e, 0x034f, 0x034a, 
	0x034b, 0x0352, 0x0353, 0x0346, 0x0347, 0x036a, 0x036b, 0x0364, 
	0x0365, 0x0744, 0x0745, 0x0742, 0x0743, 0x0748, 0x0749, 0x074a, 
	0x074b, 0x074c, 0x074d, 0x0461, 0x0462, 0x045f, 0x0460, 0x046e, 
	0x046f, 0x0246, 0x0247, 0x0248, 0x0249, 0x024a, 0x024b, 0x024c, 
	0x024d, 0x024e, 0x024f,      0,      0,      0,      0,      0, 
	     0, 0x0546, 0x05ac, 0x05b1, 0x05b6, 0x05bb, 0x05c0, 0x05c5, 
	0x05ca, 0x05cf, 0x05d2, 0x05d5, 0x05da, 0x05db, 0x05dc, 0x05dd, 
	0x05de, 0x004a, 0x0057, 0x0078, 0x007a, 0x0077, 0x007b, 0x008f, 
	0x0072, 0x005e, 0x0074, 0x02ab, 0x0068, 0x008d, 0x0052, 0x0075, 
	0x0051, 0x044f,      0,      0,      0,      0, 0x0476, 0x0477, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0550,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x055a, 
	     0, 0x0656, 0x0658, 0x065a, 0x065c, 0x065e, 0x0660, 0x0662, 
	0x0664, 0x0666, 0x0668, 0x066a, 0x066c, 0x066e, 0x0670, 0x0672, 
	0x0674, 0x0557, 0x0558, 0x0559, 0x055d, 0x055e, 0x0560, 0x0561, 
	0x0562, 0x0563, 0x0565, 0x0566, 0x0567, 0x0568, 0x056a, 0x056b, 
	0x056c, 0x0657, 0x0659, 0x065b, 0x065d, 0x065f, 0x0661, 0x0663, 
	0x0665, 0x0667, 0x0669, 0x066b, 0x066d, 0x066f, 0x0671, 0x0673, 
	0x0675, 0x0458, 0x0459, 0x0464, 0x0465, 0x0470, 0x0471, 0x046a, 
	0x046b, 0x046c, 0x046d,      0,      0,      0,      0,      0, 
	     0, 0x005c, 0x07a1, 0x02da, 0x07a2, 0x07a3, 0x02fd, 0x032a, 
	0x0336, 0x0345, 0x0355, 0x0374, 0x0379, 0x07a4, 0x0397, 0x07a5, 
	0x03ae, 0x025e, 0x025f, 0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 
	0x0265, 0x0266, 0x0267, 0x0268, 0x0269, 0x026a, 0x026b, 0x026c, 
	0x026d, 0x075f, 0x0712, 0x03b0, 0x0718, 0x03b8, 0x071c, 0x0724, 
	0x0086, 0x071e, 0x0426, 0x0732, 0x042e, 0x0738, 0x0750, 0x0730, 
	0x0411, 0x0760, 0x0713, 0x03b1, 0x0719, 0x03b9, 0x071d, 0x0725, 
	0x0085, 0x071f, 0x0427, 0x0733, 0x042f, 0x0739, 0x0751, 0x0731, 
	0x0469, 0x0161,      0, 0x0162,      0,      0, 0x0163,      0, 
	     0, 0x0761,      0,      0,      0,      0,      0,      0, 
	     0, 0x0361, 0x03c4, 0x03c5, 0x0430, 0x0431, 0x0434, 0x0435, 
	0x0436, 0x0437, 0x043a, 0x043b, 0x0438, 0x0439,      0, 0x02ce, 
	0x02cf, 0x0164, 0x0165,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0167, 0x0168, 0x0169, 0x016a,      0,      0, 0x016b, 
	0x016c, 0x016d, 0x016e,      0,      0,      0,      0,      0, 
	     0, 0x056d, 0x056f, 0x0570, 0x0571, 0x0572, 0x0574, 0x0575, 
	0x0576, 0x0577, 0x0579, 0x057a, 0x057c, 0x057d, 0x057f, 0x0580, 
	0x0582, 0x016f, 0x0170, 0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 
	0x0176, 0x0177, 0x0178, 0x0179, 0x017a, 0x017b, 0x017c, 0x017d, 
	0x017e, 0x026f, 0x0270, 0x0271, 0x0272, 0x0273, 0x0274, 0x0275, 
	0x0276, 0x0277, 0x0278, 0x0279, 0x027a, 0x027b, 0x027c, 0x027d, 
	0x027e, 0x0771, 0x01bd, 0x01be, 0x0772, 0x01bf, 0x0773, 0x01c0, 
	0x01c1, 0x0774, 0x01c2, 0x01c3, 0x0775, 0x01c4, 0x01c5, 0x01c6, 
	0x0776, 0x0472, 0x0473, 0x0474, 0x0475, 0x0478, 0x0479,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0076, 0x079c, 0x02d9, 0x079d, 0x079e, 0x02fc, 0x0329, 
	0x0335, 0x0344, 0x0702, 0x0373, 0x0378, 0x079f, 0x0396, 0x07a0, 
	0x03ad, 0x0676, 0x0678, 0x067a, 0x067c, 0x067e, 0x0680, 0x0682, 
	0x0684, 0x0686, 0x0688, 0x068a, 0x068c, 0x068e, 0x0690, 0x0692, 
	0x0694, 0x0677, 0x0679, 0x067b, 0x067d, 0x067f, 0x0681, 0x0683, 
	0x0685, 0x0687, 0x0689, 0x068b, 0x068d, 0x068f, 0x0691, 0x0693, 
	0x0695, 0x0777, 0x01c7, 0x01c8, 0x0778, 0x01c9, 0x01ca, 0x01cb, 
	0x0779, 0x077a, 0x01cc, 0x01cd, 0x077b, 0x01ce, 0x01cf, 0x01d0, 
	0x077c, 0x037a, 0x037b, 0x0380, 0x0381, 0x0382, 0x0383, 0x038d, 
	0x038e, 0x038f, 0x0390, 0x0393, 0x0394, 0x0391, 0x0392, 0x0398, 
	0x0399, 0x057b, 0x057e, 0x0581, 0x0584, 0x0589, 0x058e, 0x0593, 
	0x0598, 0x059d, 0x05a2, 0x05a7,      0,      0,      0,      0, 
	     0, 0x017f, 0x0180, 0x0181, 0x0182, 0x0183, 0x0184, 0x0185, 
	0x0186, 0x0187, 0x0188, 0x0189, 0x018a, 0x018b, 0x018c, 0x018d, 
	0x018e, 0x027f, 0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 
	0x0286, 0x0287, 0x0288, 0x0289, 0x028a, 0x028b, 0x028c, 0x028d, 
	0x028e, 0x0583, 0x0585, 0x0586, 0x0587, 0x0588, 0x058a, 0x058b, 
	0x058c, 0x058d, 0x058f, 0x0590, 0x0591, 0x0592, 0x0594, 0x0595, 
	0x0596, 0x0087, 0x014e,      0,      0, 0x0089, 0x008b,      0, 
	     0,      0,      0, 0x014f, 0x0150,      0,      0, 0x0151, 
	0x0152, 0x038c, 0x070c, 0x070d, 0x0710, 0x0711, 0x0714, 0x0715, 
	0x03a1, 0x03a2, 0x03ab, 0x0716, 0x0717, 0x0722, 0x0723, 0x03b4, 
	0x03b5, 0x018f, 0x0190, 0x0191, 0x0192, 0x0193, 0x0194, 0x0195, 
	0x0196, 0x0197, 0x0198, 0x0199, 0x019a, 0x019b, 0x019c, 0x019d, 
	0x019e, 0x028f, 0x0290, 0x0291,      0, 0x0293, 0x0294, 0x0295, 
	0x0296, 0x0297, 0x0298, 0x0299, 0x029a, 0x029b, 0x029c, 0x029d, 
	0x029e, 0x0090, 0x0084, 0x06d6, 0x06d7, 0x005b, 0x0091, 0x0073, 
	0x0060, 0x0061, 0x06d5, 0x03af, 0x0069, 0x06c6, 0x06c8, 0x06ca, 
	0x0059, 0x0696, 0x0698, 0x069a, 0x069c, 0x0601, 0x060a, 0x0617, 
	     0,      0,      0,      0, 0x0241, 0x0242, 0x0243, 0x0244, 
	     0, 0x0497, 0x047b, 0x047f, 0x0481, 0x0483, 0x0485, 0x0489, 
	0x048b, 0x048f, 0x0491, 0x0498, 0x049a, 0x049c, 0x049e, 0x04a0, 
	0x04a2, 0x0597, 0x0599, 0x059a, 0x059b, 0x059c, 0x059e, 0x059f, 
	0x05a0, 0x05a1, 0x05a3, 0x05a4, 0x05a5, 0x05a6, 0x05a8, 0x05a9, 
	0x05aa, 0x0697, 0x0699, 0x069b, 0x069d,      0,      0,      0, 
	     0,      0,      0,      0, 0x023d, 0x023e, 0x023f, 0x0240, 
	     0, 0x039a, 0x039b, 0x039c, 0x039d, 0x03a3, 0x03a4, 0x03a5, 
	0x03a6, 0x03a9, 0x03aa, 0x03a7, 0x03a8, 0x03c8, 0x03c9, 0x03ca, 
	0x03cb, 0x019f, 0x01a0, 0x01a1, 0x01a2, 0x01a3, 0x01a4, 0x01a5, 
	0x01a6, 0x01a7, 0x01a8, 0x01a9, 0x01aa,      0,      0,      0, 
	     0, 0x00a0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x06a1, 0x0056, 0x0065, 0x007f, 0x0079, 0x0080, 0x007e, 
	0x0062, 0x006a, 0x006c, 0x007c, 0x0082, 0x0053, 0x06a2, 0x005a, 
	0x06a3, 0x00a2, 0x00a3,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x00a4, 0x00a5, 
	0x00a6, 0x04a6, 0x04a8,      0, 0x04aa, 0x04ad, 0x04af, 0x04b6, 
	0x04b8, 0x04ba, 0x04bc, 0x0493, 0x04b1, 0x047e, 0x0488, 0x048e, 
	0x0495, 0x04a7, 0x04a9, 0x04ac, 0x04ab, 0x04ae, 0x04b2, 0x04b7, 
	0x04b9, 0x04bb, 0x04be, 0x0496, 0x04b4, 0x04a5, 0x04b3, 0x04bf, 
	     0, 0x06a7, 0x06a8, 0x06a9, 0x06aa, 0x06ab, 0x06ac, 0x06ad, 
	0x06ae, 0x06af, 0x06b0, 0x06b1, 0x06b2, 0x06b3, 0x06b4, 0x06b5, 
	0x06b6, 0x05ab, 0x05ad, 0x05ae, 0x05af, 0x05b0, 0x05b2, 0x05b3, 
	0x05b4, 0x05b5, 0x05b7, 0x05b8, 0x05b9, 0x05ba, 0x05bc, 0x05bd, 
	0x05be, 0x01ac, 0x0762, 0x01ad, 0x0763, 0x01ae, 0x01af, 0x01b0, 
	0x01b1, 0x01b2, 0x01b3, 0x01b4, 0x01b5, 0x01b6, 0x0764, 0x0765, 
	0x0766, 0x02ac, 0x06de, 0x02be, 0x02d2, 0x06e4, 0x06e0, 0x06ea, 
	0x06f4, 0x02fe, 0x06f8, 0x0306, 0x0314, 0x0356, 0x0705, 0x035e, 
	0x0362, 0x02ad, 0x06df, 0x02bf, 0x02d3, 0x06e5, 0x06e1, 0x06eb, 
	0x06f5, 0x02ff, 0x06f9, 0x0307, 0x0315, 0x0357, 0x0706, 0x035f, 
	0x0363, 0x02ae, 0x02af, 0x02bc, 0x02bd, 0x0300, 0x0301, 0x0304, 
	0x0305, 0x0358, 0x0359, 0x035c, 0x035d, 0x03b2, 0x03b3, 0x03b6, 
	0x03b7, 0x02b4, 0x02b5, 0x02b6, 0x02b7, 0x02b8, 0x02b9, 0x02ba, 
	0x02bb, 0x031e, 0x031f, 0x0316, 0x0317, 0x0318, 0x0319, 0x0308, 
	0x0309, 0x04b5, 0x047d, 0x0480, 0x0482, 0x0484, 0x0487, 0x048a, 
	0x048d, 0x0490, 0x0494, 0x0499, 0x049b, 0x049d, 0x049f, 0x04a1, 
	0x04a4, 0x00b6,      0,      0, 0x00b7, 0x00b8, 0x00b9, 0x00ba, 
	0x00bb, 0x0063, 0x0064, 0x00bc, 0x00bd, 0x0066, 0x0067, 0x00be, 
	0x00bf, 0x01b7, 0x0767, 0x0768, 0x0769, 0x01b8, 0x076a, 0x076b, 
	0x076c, 0x01b9, 0x076d, 0x076e, 0x076f, 0x01ba, 0x0770, 0x01bb, 
	0x01bc, 0x06b7, 0x06b8, 0x06b9, 0x06ba, 0x06bb, 0x06bc, 0x06bd, 
	0x06be, 0x06bf, 0x06c0, 0x06c1, 0x06c2, 0x01db,      0,      0, 
	     0, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0, 
	0x03c1, 0x03c2, 0x03c3, 0x03d8, 0x03d9, 0x03da, 0x03db, 0x03dc, 
	0x03dd, 0x05bf, 0x05c1, 0x05c2, 0x05c3, 0x05c4, 0x05c6, 0x05c7, 
	0x05c8, 0x05c9, 0x05cb, 0x05cc, 0x05cd, 0x05ce, 0x05d0, 0x05d1, 
	0x05d3, 0x00c0, 0x00c1, 0x06a6,      0,      0, 0x00c2, 0x00c3, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x04c0, 0x04c2, 0x04c4, 0x04c6, 0x04cc, 0x04d0, 0x04d6, 
	0x04d8, 0x04da, 0x04e2, 0x04e4, 0x04e8, 0x04ec, 0x04ee, 0x04f2, 
	0x04f4, 0x04c1, 0x04c3, 0x04c5, 0x04c7, 0x04cd, 0x04d1, 0x04d7, 
	0x04d9, 0x04db, 0x04e3, 0x04e5, 0x04e9, 0x04ed, 0x04ef, 0x04f3, 
	0x04f5, 0x06c3, 0x06cc, 0x06cd, 0x06ce, 0x06cf, 0x06d0, 0x06d1, 
	0x06d2, 0x06d3, 0x06d4, 0x0055, 0x0054, 0x0088, 0x008a, 0x008c, 
	0x0058, 0x00c4,      0, 0x00c5, 0x00c6, 0x00c7, 0x00c8, 0x00c9, 
	0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,      0, 0x00d0, 
	     0, 0x06c4,      0,      0,      0, 0x06d8, 0x06d9, 0x06da, 
	0x06db, 0x06dc, 0x06dd, 0x0083, 0x0081, 0x00d1, 0x006b, 0x006d, 
	     0, 0x04ca, 0x04cb,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x02cc, 0x02cd, 0x02db, 0x02dc, 0x02dd, 0x02de, 0x02df, 
	0x02e0, 0x02ea, 0x02eb, 0x02f1, 0x02f2, 0x02f3, 0x02f4, 0x02f9, 
	0x02fa, 0x01d1, 0x01d2, 0x077d, 0x01d3, 0x01d4, 0x01d5, 0x01d6, 
	0x01d7, 0x01d8, 0x01d9, 0x01da, 0x077e,      0,      0,      0, 
	     0, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 0x00d8, 
	0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df, 0x00e0, 
	     0, 0x02d4, 0x02d5, 0x02d0, 0x02d1, 0x02c0, 0x02c1, 0x02c2, 
	0x02c3, 0x02c4, 0x02c5, 0x02c6, 0x02c7, 0x02c8, 0x02c9, 0x02b2, 
	0x02b3, 0x03d4, 0x03d5, 0x03d2, 0x03d3, 0x03e5, 0x03e6, 0x03e7, 
	0x03e8, 0x03f7, 0x03f8, 0x03f9, 0x03fa, 0x03fb, 0x03fc, 0x03fd, 
	0x03fe, 0x05d4, 0x05d6, 0x05d7, 0x05d8, 0x05d9, 0x05ed, 0x05ee, 
	0x05ef, 0x05f0, 0x05f1, 0x05f2, 0x05f3, 0x05f4,      0,      0, 
	     0, 0x02d6, 0x02d7, 0x06ee, 0x06ef, 0x033f, 0x0340, 0x033b, 
	0x033c, 0x037c, 0x037d, 0x03ce, 0x03cf, 0x03d0, 0x03d1,      0, 
	     0, 0x03d6, 0x03d7, 0x0781, 0x0782,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x044e, 0x01de,      0,      0,      0, 0x01df,      0,      0, 
	     0, 0x01e0,      0,      0,      0, 0x01e1,      0,      0, 
	     0, 0x03de, 0x03df, 0x03e0, 0x03e1, 0x0444, 0x0445, 0x043c, 
	0x043d, 0x0450, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 
	0x0457, 0x05df, 0x05e0, 0x05e2,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x01e2, 0x01e3, 0x01e4, 0x01e5,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x03e3, 0x03ea, 0x03ed, 0x0400, 0x0413, 0x0424, 0x073a, 
	0x0740, 0x045d, 0x074e, 0x0753, 0x006e, 0x007d, 0x006f, 0x005d, 
	0x0050, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7, 0x05e8, 0x05e9, 
	0x05ea, 0x05eb, 0x05ec,      0,      0,      0,      0,      0, 
	     0, 0x03e4, 0x03eb, 0x03ee, 0x0401, 0x0414, 0x0425, 0x073b, 
	0x0741, 0x045e, 0x074f, 0x0754, 0x0070, 0x008e, 0x0071, 0x005f, 
	0x026e, 0x01e6, 0x01e7, 0x01e8, 0x01e9, 0x01ea, 0x01eb, 0x01ec, 
	0x01ed, 0x01ee, 0x01ef, 0x01f0,      0, 0x01f1, 0x01f2,      0, 
	     0, 0x06e8, 0x06e9, 0x02b0, 0x02b1, 0x06e6, 0x06e7, 0x06f0, 
	0x06f1, 0x02e4, 0x02e5, 0x02e8, 0x02e9, 0x06f2, 0x06f3, 0x02ef, 
	0x02f0, 0x00eb,      0, 0x00ec,      0,      0,      0, 0x00ed, 
	     0,      0,      0,      0, 0x00ee,      0,      0,      0, 
	     0, 0x03f1, 0x03f2, 0x03f3, 0x03f4, 0x0428, 0x0429, 0x042c, 
	0x042d,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x02f5, 0x02f6, 0x02f7, 0x02f8, 0x0324, 0x0325, 0x0322, 
	0x0323, 0x0326, 0x0327, 0x031a, 0x031b, 0x0320, 0x0321, 0x032d, 
	0x032e, 0x04f6, 0x04f8, 0x04fa, 0x04fe, 0x0502, 0x0504, 0x0506, 
	0x050a, 0x050e, 0x0510, 0x0513, 0x0514, 0x0517, 0x0518, 0x051a, 
	0x051c, 0x06f6, 0x06f7, 0x06fc, 0x06fd, 0x0302, 0x0303, 0x031c, 
	0x031d, 0x06fa, 0x06fb, 0x0312, 0x0313, 0x0339, 0x033a, 0x0700, 
	0x0701, 0x00f7, 0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 
	0x00fe, 0x00ff, 0x0100, 0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 
	0x0106, 0x04f7, 0x04f9, 0x04fb, 0x04ff, 0x0503, 0x0505, 0x0507, 
	0x050b, 0x050f, 0x0511, 0x0512, 0x0515, 0x0516, 0x0519, 0x051b, 
	0x051d, 0x0009, 0x000b, 0x0008, 0x0005,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x000c, 0x0007, 0x000d, 0x0003, 0x0006,      0,      0,      0, 
	     0, 0x000e, 0x0004,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x000a,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0001,      0, 
	0x0002,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x00b5,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0008, 0x0026, 0x004c, 0x0054, 0x005e, 0x0068, 0x0075, 0x007e, 
	0x0087,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0024,      0, 0x00aa,      0, 0x00ab, 
	0x00b0, 0x0042, 0x004a,      0,      0,      0,      0, 0x000d, 
	     0, 0x0051, 0x0056, 0x0031, 0x0032, 0x0070, 0x0052, 0x0060, 
	0x0033, 0x0076, 0x0078, 0x007b, 0x0028, 0x0036, 0x0086, 0x0029, 
	     0,      0, 0x000b, 0x00a5,      0,      0,      0,      0, 
	0x0002,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x002e, 0x0012,      0, 
	     0, 0x0009, 0x000c, 0x002f, 0x005a, 0x0043, 0x008a, 0x008d, 
	0x0047,      0,      0, 0x001a,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0016, 0x000a,      0, 0x000e, 0x008e,      0, 0x0091, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x0022, 0x0096,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0027, 0x00a9, 0x0062, 0x0064, 0x001d,      0,      0, 
	0x0093, 0x006e,      0, 0x0025,      0,      0,      0,      0, 
	     0, 0x0020, 0x0015, 0x0041,      0,      0, 0x0021, 0x007a, 
	0x0081, 0x0088, 0x0039, 0x0011,      0, 0x008b, 0x008c,      0, 
	     0, 0x0037, 0x007f, 0x0095, 0x0080, 0x0097, 0x0038, 0x002c, 
	0x002d, 0x00ac, 0x0083,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x00ad, 0x00b3, 
	     0, 0x003d, 0x00af, 0x0063, 0x0092, 0x00b4, 0x00a7, 0x00a0, 
	0x00a8, 0x003f, 0x0049, 0x0061, 0x0053, 0x006a, 0x0034, 0x006c, 
	0x0035, 0x0084, 0x009a, 0x0044, 0x005d, 0x0074, 0x0094, 0x0046, 
	0x005f, 0x0014, 0x003e, 0x009e, 0x006b, 0x0007, 0x0059, 0x0085, 
	0x0019, 0x0050, 0x0055,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x006d, 0x00ae,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0013, 0x0010,      0, 
	     0, 0x0030,      0,      0,      0,      0,      0,      0, 
	0x001b, 0x001c, 0x0067, 0x0072, 0x0079, 0x0073, 0x005b,      0, 
	     0, 0x007d, 0x009b, 0x0048, 0x0065, 0x007c, 0x009d, 0x0040, 
	0x004f, 0x0077, 0x0089, 0x0082, 0x006f, 0x00a1, 0x008f, 0x00a3, 
	0x0071,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0001, 0x005c, 0x0005, 0x0006, 
	0x0003, 0x0090, 0x003a, 0x0098, 0x001e, 0x001f, 0x0023, 0x004e, 
	     0, 0x002a, 0x000f, 0x0017,      0, 0x0018,      0, 0x0004, 
	     0, 0x002b, 0x0045, 0x00a6,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0099, 0x009c, 0x009f,      0, 0x003c, 0x00a4, 0x00b2, 
	0x004d, 0x0058, 0x0069, 0x003b, 0x00a2, 0x00b1, 0x004b, 0x0057, 
	0x0066,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x033f,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x04e3,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x034a, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x03d3, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0345, 0x0346, 
	0x0347,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0348,      0, 
	0x0349,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0079, 0x007a, 
	0x0137,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x06a1,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0603,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x049f,      0, 0x04a0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x04d8,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0604,      0,      0,      0, 
	0x0605,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0422,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x04a1, 0x04a2, 0x04a3,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x03cf, 0x03d0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0330, 0x032b, 0x0333, 0x0332, 0x0320, 0x0335,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x03a1,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x04e5,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x032f,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x00a7, 0x00a8,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x0303, 
	0x0304,      0,      0,      0,      0,      0,      0, 0x036d, 
	     0,      0,      0,      0,      0,      0, 0x049b, 0x049c, 
	     0,      0,      0,      0,      0,      0,      0, 0x049d, 
	0x049e,      0,      0,      0,      0,      0, 0x03d1,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x03d2,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0104, 0x0105,      0, 
	     0,      0,      0, 0x007d, 0x007e, 0x0094, 0x0095, 0x01c2, 
	0x01c3,      0,      0,      0,      0, 0x061b,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0337, 0x0338,      0, 
	     0,      0,      0, 0x0339,      0,      0,      0, 0x033a, 
	     0,      0,      0,      0,      0, 0x033b, 0x033c, 0x053c, 
	0x033d, 0x0546, 0x054c, 0x0552,      0, 0x0563,      0, 0x0570, 
	0x057d,      0,      0,      0,      0, 0x03b2,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x03c1, 0x03c2, 0x03c3, 
	0x03c4,      0,      0,      0,      0, 0x0323,      0, 0x03c5, 
	     0,      0,      0,      0, 0x0324,      0, 0x0325,      0, 
	     0, 0x0326,      0,      0,      0, 0x0322,      0,      0, 
	     0,      0,      0,      0, 0x0328,      0, 0x036c,      0, 
	     0,      0, 0x0329,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x036e, 0x036f, 0x0370, 0x0371, 
	0x0372, 0x0373, 0x0374, 0x0375, 0x02aa, 0x02ac, 0x02ae, 0x02b0, 
	     0,      0,      0,      0, 0x04b5,      0,      0,      0, 
	0x04b6,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x03c6,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x03dd,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x02ff, 0x0300,      0,      0, 
	0x0301,      0, 0x0302,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0609,      0, 0x060b,      0,      0, 
	     0, 0x060e,      0,      0,      0,      0, 0x0612, 0x0613, 
	0x0616,      0,      0, 0x004f, 0x0050, 0x0051, 0x0052, 0x0053, 
	     0,      0, 0x0054, 0x0055,      0,      0,      0, 0x034b, 
	0x034c,      0,      0, 0x0486, 0x0487,      0,      0,      0, 
	0x0488,      0,      0, 0x0489,      0, 0x048a, 0x048b,      0, 
	     0,      0,      0, 0x0498, 0x0499,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x049a,      0,      0, 0x03cb, 0x03cc,      0,      0, 0x03cd, 
	0x03ce,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x03d4,      0,      0,      0,      0, 
	     0, 0x03d5, 0x03d6, 0x03d7, 0x03d8,      0,      0,      0, 
	     0,      0,      0, 0x05de, 0x05df,      0,      0,      0, 
	     0,      0,      0, 0x05e0, 0x05e1,      0,      0,      0, 
	     0,      0,      0, 0x05e2, 0x05e3, 0x05e4, 0x05e5,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x04e4,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x0607, 0x0608, 0x060a, 0x060c, 0x060d, 0x060f, 
	0x0611, 0x0615, 0x061c, 0x061f, 0x0624, 0x0629, 0x062e, 0x0633, 
	0x0638,      0, 0x0525,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x0444, 0x0445,      0, 0x0447,      0, 0x0449, 
	0x044a,      0, 0x044c, 0x044d,      0, 0x044f, 0x0450, 0x0451, 
	     0,      0, 0x0454, 0x0455,      0, 0x0457, 0x0458, 0x0459, 
	     0,      0, 0x045c, 0x045d,      0, 0x045f, 0x0460, 0x0461, 
	     0,      0, 0x046f, 0x0470,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x0187, 0x019c, 0x019a, 0x01a4, 0x01b8, 0x01b2, 
	0x0317, 0x01c0, 0x022c, 0x022a, 0x0234, 0x023a, 0x0286, 0x0226, 
	0x0213,      0, 0x0188, 0x019d, 0x019b, 0x01a5, 0x01b9, 0x01b3, 
	0x0313, 0x01c1, 0x022d, 0x022b, 0x0235, 0x023b, 0x0287, 0x0227, 
	0x028d,      0, 0x048c,      0,      0, 0x048d,      0, 0x048e, 
	0x048f,      0,      0, 0x0490, 0x0491,      0,      0, 0x0492, 
	0x0493,      0, 0x0592, 0x058e, 0x0588, 0x0594, 0x05c8, 0x059c, 
	0x059e, 0x05a0, 0x05aa, 0x05b0, 0x05bc, 0x05a6,      0, 0x05c0, 
	0x05cc,      0, 0x0593, 0x058f, 0x0589, 0x0595, 0x05c9, 0x059d, 
	0x059f, 0x05a1, 0x05ab, 0x05b1, 0x05bd, 0x05a7,      0, 0x05c1, 
	0x05cd,      0, 0x0399,      0, 0x039a, 0x039b, 0x039c, 0x039d, 
	0x039e, 0x039f, 0x03a0,      0,      0,      0,      0,      0, 
	     0,      0, 0x03af, 0x02df, 0x03b0, 0x03b1,      0,      0, 
	0x0319, 0x03b3, 0x034f, 0x0314,      0,      0, 0x03b5, 0x03b6, 
	0x03b7,      0, 0x06b5, 0x06b7, 0x06b9, 0x06bb, 0x06bd, 0x06bf, 
	0x06c2, 0x06c4, 0x06c6, 0x06c8, 0x06cb, 0x06cd, 0x06cf, 0x06d1, 
	0x06d3,      0, 0x06b6, 0x06b8, 0x06ba, 0x06bc, 0x06be, 0x06c0, 
	0x06c3, 0x06c5, 0x06c7, 0x06c9, 0x06cc, 0x06ce, 0x06d0, 0x06d2, 
	0x06d4,      0, 0x04e7, 0x04e8, 0x04e9, 0x04ea, 0x04eb, 0x04ec, 
	0x04ed, 0x04ee, 0x02c3, 0x02c6, 0x02c4, 0x02c7, 0x02c5, 0x04ef, 
	0x04f0,      0, 0x00f8, 0x00f9,      0,      0,      0,      0, 
	     0, 0x0159, 0x015a,      0,      0,      0,      0,      0, 
	     0, 0x0502, 0x0503, 0x0504, 0x0505, 0x0506, 0x0507, 0x0508, 
	0x0509, 0x050a, 0x050b, 0x050c, 0x050d, 0x050e, 0x050f, 0x0510, 
	0x0511, 0x0205, 0x0206, 0x0207, 0x0208, 0x0201, 0x0202, 0x020f, 
	0x0210, 0x0209, 0x020a, 0x0219, 0x021a, 0x021b, 0x021c, 0x0223, 
	0x0224, 0x0305,      0, 0x0306,      0,      0,      0, 0x0307, 
	     0,      0,      0,      0, 0x0308,      0,      0,      0, 
	     0, 0x0406, 0x0407, 0x0408, 0x0409, 0x040a, 0x040b, 0x040c, 
	0x040d, 0x040e, 0x040f, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 
	0x0415, 0x0606, 0x066c, 0x0671, 0x0676, 0x067b, 0x0680, 0x0685, 
	0x068a, 0x068f, 0x0692, 0x0695, 0x069a, 0x069b, 0x069c, 0x069d, 
	0x069e, 0x010c, 0x010d, 0x0110, 0x0111, 0x0119, 0x011a, 0x0121, 
	0x0122, 0x013f, 0x0140, 0x0149, 0x014a, 0x0131, 0x0132, 0x0147, 
	0x0148, 0x030c,      0, 0x03d9,      0,      0, 0x03da,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x020d, 0x020e, 0x021f, 0x0220, 0x0217, 0x0218, 0x021d, 
	0x021e, 0x0248, 0x0249, 0x0252, 0x0253, 0x0230, 0x0231, 0x0238, 
	0x0239, 0x0610,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x061a, 
	     0, 0x0112, 0x0113, 0x011d, 0x011e, 0x011f, 0x0120, 0x011b, 
	0x011c, 0x0123, 0x0124, 0x0117, 0x0118, 0x0141, 0x0142, 0x013b, 
	0x013c, 0x0512, 0x0513, 0x0514, 0x0515, 0x0516, 0x0517, 0x0518, 
	0x0519, 0x051a, 0x051b, 0x051c, 0x051d, 0x051e, 0x051f, 0x0520, 
	0x0521, 0x0416, 0x0417, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 
	0x041d, 0x041e, 0x041f, 0x0420, 0x0421,      0,      0,      0, 
	     0, 0x0716, 0x0718, 0x071a, 0x071c, 0x071e, 0x0720, 0x0722, 
	0x0724, 0x0726, 0x0728, 0x072a, 0x072c, 0x072e, 0x0730, 0x0732, 
	0x0734, 0x0617, 0x0618, 0x0619, 0x061d, 0x061e, 0x0620, 0x0621, 
	0x0622, 0x0623, 0x0625, 0x0626, 0x0627, 0x0628, 0x062a, 0x062b, 
	0x062c, 0x0717, 0x0719, 0x071b, 0x071d, 0x071f, 0x0721, 0x0723, 
	0x0725, 0x0727, 0x0729, 0x072b, 0x072d, 0x072f, 0x0731, 0x0733, 
	0x0735, 0x031b, 0x0310,      0,      0, 0x031c, 0x031d,      0, 
	     0,      0,      0, 0x03c7, 0x03c8,      0,      0, 0x03c9, 
	0x03ca, 0x0221, 0x0222, 0x0256, 0x0257, 0x024c, 0x024d, 0x0258, 
	0x0259, 0x024a, 0x024b, 0x0254, 0x0255, 0x0269, 0x026a, 0x026b, 
	0x026c, 0x0522, 0x0523, 0x0524,      0, 0x0526, 0x0321, 0x0527, 
	0x0528, 0x0529, 0x052a, 0x052b, 0x052c, 0x052d, 0x052e, 0x052f, 
	0x0530, 0x0423,      0, 0x0425,      0, 0x0427, 0x0428, 0x0429, 
	0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f,      0,      0, 
	     0, 0x0424, 0x0426, 0x0430, 0x0431, 0x0432, 0x0434, 0x0435, 
	0x0436, 0x0438, 0x0439, 0x043a, 0x043c, 0x043d, 0x043e, 0x0440, 
	0x0443, 0x0327, 0x031a, 0x02bb, 0x02bc, 0x032e, 0x02fe, 0x02fa, 
	0x0336, 0x0331, 0x02ba, 0x0199, 0x0312, 0x02ab, 0x02ad, 0x02af, 
	0x02cc, 0x062d, 0x062f, 0x0630, 0x0631, 0x0632, 0x0634, 0x0635, 
	0x0636, 0x0637, 0x0639, 0x063a, 0x063c, 0x063d, 0x063f, 0x0640, 
	0x0642, 0x0531, 0x0532, 0x0533, 0x0534, 0x0535, 0x0536, 0x0614, 
	0x0537, 0x0538, 0x0539,      0,      0,      0,      0,      0, 
	     0, 0x0433,      0,      0,      0, 0x0437,      0,      0, 
	     0, 0x043b,      0,      0,      0, 0x043f,      0, 0x0441, 
	0x0442, 0x0736, 0x0738, 0x073a, 0x073c, 0x073e, 0x0740, 0x0742, 
	0x0744, 0x0746, 0x0748, 0x074a, 0x074c, 0x074e, 0x0750, 0x0752, 
	0x0754, 0x0737, 0x0739, 0x073b, 0x073d, 0x073f, 0x0741, 0x0743, 
	0x0745, 0x0747, 0x0749, 0x074b, 0x074d, 0x074f, 0x0751, 0x0753, 
	0x0755, 0x0138, 0x01b0, 0x01b1, 0x0236, 0x0237, 0x023c, 0x023d, 
	0x023e, 0x023f, 0x0242, 0x0243, 0x0240, 0x0241,      0, 0x0083, 
	0x0084, 0x063b, 0x063e, 0x0641, 0x0644, 0x0649, 0x064e, 0x0653, 
	0x0658, 0x065d, 0x0662, 0x0667,      0,      0,      0,      0, 
	     0, 0x033e,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0340, 0x0341,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0342, 0x0343, 
	0x0344, 0x0143, 0x0144, 0x014c, 0x014d, 0x0150, 0x0151, 0x015d, 
	0x015e, 0x0162, 0x0165, 0x0166, 0x016f, 0x0170, 0x0167, 0x0168, 
	0x0169, 0x0643, 0x0645, 0x0646, 0x0647, 0x0648, 0x064a, 0x064b, 
	0x064c, 0x064d, 0x064f, 0x0650, 0x0651, 0x0652, 0x0654, 0x0655, 
	0x0656, 0x0244, 0x0245, 0x0250, 0x0251, 0x0274, 0x0275, 0x028a, 
	0x028b, 0x028c, 0x0299, 0x029a, 0x029d, 0x029e, 0x02a6, 0x02a7, 
	0x0212, 0x0446, 0x0448, 0x044b, 0x044e, 0x0452, 0x0453, 0x0456, 
	0x045a, 0x045b, 0x045e, 0x0462, 0x0465, 0x046e,      0,      0, 
	     0, 0x004d, 0x02ce, 0x02fc, 0x02f4, 0x032a, 0x02fd, 0x02e3, 
	0x02f5, 0x0334, 0x02f9, 0x0058, 0x0311, 0x030d, 0x02dd, 0x02f8, 
	0x032c, 0x034d, 0x034e, 0x03b4,      0,      0, 0x0350, 0x0351, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x004e, 0x02cd, 0x02d0, 0x031e, 0x02f7, 0x02f6, 0x02f3, 
	0x02d1, 0x02e7, 0x02e9, 0x0318, 0x0315, 0x02c9, 0x02db, 0x02c8, 
	0x02e5, 0x0352,      0, 0x0353, 0x0354, 0x0355, 0x0356, 0x0357, 
	0x0358, 0x0359, 0x02ee, 0x02f0, 0x035a, 0x035b,      0, 0x032d, 
	     0, 0x0155, 0x0156, 0x015b, 0x015c, 0x015f, 0x0160, 0x016b, 
	0x016c, 0x0171, 0x0172, 0x0175, 0x0176, 0x0173, 0x0174, 0x017a, 
	0x017b, 0x0756, 0x0758, 0x075a, 0x075c, 0x06c1, 0x06ca, 0x06d7, 
	     0,      0,      0,      0, 0x04d4, 0x04d5, 0x04d6, 0x04d7, 
	     0, 0x0557, 0x053b, 0x053f, 0x0541, 0x0543, 0x0545, 0x0549, 
	0x054b, 0x054f, 0x0551, 0x0558, 0x055a, 0x055c, 0x055e, 0x0560, 
	0x0562, 0x0657, 0x0659, 0x065a, 0x065b, 0x065c, 0x065e, 0x065f, 
	0x0660, 0x0661, 0x0663, 0x0664, 0x0665, 0x0666, 0x0668, 0x0669, 
	0x066a, 0x0757, 0x0759, 0x075b, 0x075d,      0,      0,      0, 
	     0,      0,      0,      0, 0x04d0, 0x04d1, 0x04d2, 0x04d3, 
	     0, 0x005b, 0x0059, 0x006d, 0x0087, 0x0081, 0x007b, 0x0092, 
	0x00ab, 0x00c7, 0x00c5, 0x00cf, 0x00dd, 0x012d, 0x012b, 0x0135, 
	0x0139, 0x025b,      0,      0,      0,      0, 0x02a1, 0x02a2, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x005c, 0x005a, 0x006e, 0x0088, 0x0082, 0x007c, 0x0093, 
	0x00ac, 0x00c8, 0x00c6, 0x00d0, 0x00de, 0x012e, 0x012c, 0x0136, 
	0x013a, 0x005d, 0x005e, 0x006b, 0x006c, 0x00c9, 0x00ca, 0x00cd, 
	0x00ce, 0x012f, 0x0130, 0x0133, 0x0134, 0x019e, 0x019f, 0x01a2, 
	0x01a3, 0x035d, 0x035e, 0x035f, 0x0360, 0x0361, 0x0362, 0x0363, 
	0x0364, 0x0365, 0x0366, 0x0367, 0x0368, 0x0369, 0x036a, 0x036b, 
	     0, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 
	0x006a, 0x00e7, 0x00e8, 0x00df, 0x00e0, 0x00e1, 0x00e2, 0x00d1, 
	0x00d2, 0x0463, 0x0464,      0, 0x0466, 0x0467, 0x0468, 0x0469, 
	0x046a, 0x046b, 0x046c, 0x046d,      0,      0,      0,      0, 
	     0, 0x0264, 0x0265, 0x0288, 0x0289, 0x0294, 0x0295, 0x028e, 
	0x028f, 0x0290, 0x0291,      0,      0,      0,      0,      0, 
	     0, 0x0566, 0x0568,      0, 0x056a, 0x056d, 0x056f, 0x0576, 
	0x0578, 0x057a, 0x057c, 0x0553, 0x0571, 0x053e, 0x0548, 0x054e, 
	0x0555, 0x0567, 0x0569, 0x056c, 0x056b, 0x056e, 0x0572, 0x0577, 
	0x0579, 0x057b, 0x057e, 0x0556, 0x0574, 0x0565, 0x0573, 0x057f, 
	     0, 0x016a, 0x016d, 0x016e, 0x0183, 0x0184, 0x018d, 0x018e, 
	0x0185, 0x0186, 0x0193, 0x0195, 0x0196, 0x01c8, 0x01c9, 0x01a0, 
	0x01a1, 0x066b, 0x066d, 0x066e, 0x066f, 0x0670, 0x0672, 0x0673, 
	0x0674, 0x0675, 0x0677, 0x0678, 0x0679, 0x067a, 0x067c, 0x067d, 
	0x067e, 0x0471,      0,      0,      0, 0x0472,      0,      0, 
	     0, 0x0473,      0,      0,      0, 0x0474,      0,      0, 
	     0, 0x0272, 0x0273, 0x0270, 0x0271, 0x0276, 0x0277, 0x0278, 
	0x0279, 0x027a, 0x027b, 0x0281, 0x0282, 0x027f, 0x0280, 0x0292, 
	0x0293, 0x0475, 0x0476, 0x0477, 0x0478,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0575, 0x053d, 0x0540, 0x0542, 0x0544, 0x0547, 0x054a, 
	0x054d, 0x0550, 0x0554, 0x0559, 0x055b, 0x055d, 0x055f, 0x0561, 
	0x0564, 0x0376, 0x0377, 0x0378, 0x0379, 0x037a, 0x037b, 0x037c, 
	0x037d, 0x037e, 0x037f, 0x0380, 0x0381, 0x0382, 0x0383, 0x0384, 
	0x0385, 0x0479, 0x047a, 0x047b, 0x047c, 0x047d, 0x047e, 0x047f, 
	0x0480, 0x0481, 0x0482, 0x0483,      0, 0x0484, 0x0485,      0, 
	     0, 0x017c, 0x017d, 0x017e, 0x017f, 0x0189, 0x018a, 0x018b, 
	0x018c, 0x0191, 0x0192, 0x018f, 0x0190, 0x01ba, 0x01bb, 0x01bc, 
	0x01bd, 0x007f, 0x0080, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 
	0x009f, 0x00ad, 0x00ae, 0x00b6, 0x00b7, 0x00b8, 0x00b9, 0x00c0, 
	0x00c1, 0x067f, 0x0681, 0x0682, 0x0683, 0x0684, 0x0686, 0x0687, 
	0x0688, 0x0689, 0x068b, 0x068c, 0x068d, 0x068e, 0x0690, 0x0691, 
	0x0693, 0x0580, 0x0582, 0x0584, 0x0586, 0x058c, 0x0590, 0x0596, 
	0x0598, 0x059a, 0x05a2, 0x05a4, 0x05a8, 0x05ac, 0x05ae, 0x05b2, 
	0x05b4, 0x0581, 0x0583, 0x0585, 0x0587, 0x058d, 0x0591, 0x0597, 
	0x0599, 0x059b, 0x05a3, 0x05a5, 0x05a9, 0x05ad, 0x05af, 0x05b3, 
	0x05b5, 0x0386, 0x0387, 0x0388, 0x0389, 0x038a, 0x038b, 0x038c, 
	0x038d, 0x038e, 0x038f, 0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 
	0x0395, 0x0089, 0x008a, 0x0085, 0x0086, 0x006f, 0x0070, 0x0071, 
	0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0061, 
	0x0062, 0x058a, 0x058b,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x008d, 0x008e, 0x005f, 0x0060, 0x008b, 0x008c, 0x00a3, 
	0x00a4, 0x00a5, 0x00a6, 0x00a9, 0x00aa, 0x00af, 0x00b0, 0x00b4, 
	0x00b5, 0x008f, 0x0090, 0x0096, 0x0097, 0x010e, 0x010f, 0x010a, 
	0x010b, 0x0157, 0x0158, 0x01c4, 0x01c5, 0x01c6, 0x01c7,      0, 
	     0, 0x0494, 0x0495,      0,      0,      0,      0,      0, 
	     0, 0x0496, 0x0497,      0,      0,      0,      0,      0, 
	     0, 0x0694, 0x0696, 0x0697, 0x0698, 0x0699, 0x06ad, 0x06ae, 
	0x06af, 0x06b0, 0x06b1, 0x06b2, 0x06b3, 0x06b4,      0,      0, 
	     0, 0x0396, 0x0397, 0x0398,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x029b, 0x029c, 0x029f, 0x02a0, 0x02a3, 0x02a4,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x069f, 0x06a0, 0x06a2,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x03a2,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x03a3,      0, 0x03a4,      0, 0x03a5,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x06a3, 0x06a4, 0x06a5, 0x06a6, 0x06a7, 0x06a8, 0x06a9, 
	0x06aa, 0x06ab, 0x06ac,      0,      0,      0,      0,      0, 
	     0, 0x04a4,      0, 0x04a5,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x01a6, 0x01a7, 0x01a8, 0x01a9, 0x01aa, 0x01ab, 0x01ac, 
	0x01ad, 0x01ae, 0x01af, 0x01d0, 0x01d1, 0x01d2, 0x01d3, 0x01d4, 
	0x01d5, 0x03a6,      0, 0x03a7, 0x03a8,      0, 0x03a9, 0x03aa, 
	0x03ab, 0x03ac,      0,      0, 0x03ad,      0,      0,      0, 
	0x03ae, 0x04a6, 0x04a7, 0x04a8, 0x04a9, 0x04aa, 0x04ab, 0x04ac, 
	0x04ad,      0, 0x04ae, 0x04af, 0x04b0, 0x04b1, 0x04b2, 0x04b3, 
	0x04b4, 0x02a8, 0x02b1, 0x02b2, 0x02b3, 0x02b4, 0x02b5, 0x02b6, 
	0x02b7, 0x02b8, 0x02b9, 0x02cf, 0x02ca, 0x02ed, 0x030a, 0x02ef, 
	0x02cb, 0x02a9,      0,      0,      0, 0x02bd, 0x02be, 0x02bf, 
	0x02c0, 0x02c1, 0x02c2, 0x0316, 0x02dc, 0x035c, 0x02e8, 0x02ea, 
	     0, 0x01b4, 0x01b5, 0x01db, 0x01dc, 0x01e9, 0x01ea, 0x01f3, 
	0x01f4, 0x01f9, 0x01fa, 0x01ff, 0x0200, 0x0203, 0x0204, 0x020b, 
	0x020c, 0x05b6, 0x05b8, 0x05ba, 0x05be, 0x05c2, 0x05c4, 0x05c6, 
	0x05ca, 0x05ce, 0x05d0, 0x05d3, 0x05d4, 0x05d7, 0x05d8, 0x05da, 
	0x05dc, 0x04b7,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x05b7, 0x05b9, 0x05bb, 0x05bf, 0x05c3, 0x05c5, 0x05c7, 
	0x05cb, 0x05cf, 0x05d1, 0x05d2, 0x05d5, 0x05d6, 0x05d9, 0x05db, 
	0x05dd, 0x03b8,      0,      0,      0,      0, 0x03b9,      0, 
	0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,      0, 0x03c0, 
	     0, 0x04b8, 0x04b9, 0x04ba, 0x04bb, 0x04bc, 0x04bd, 0x04be, 
	0x04bf,      0,      0, 0x04c0, 0x04c1, 0x04c2, 0x04c3, 0x04c4, 
	0x04c5, 0x00ba, 0x00bb, 0x00ed, 0x00ee, 0x00cb, 0x00cc, 0x00e5, 
	0x00e6, 0x00eb, 0x00ec, 0x00db, 0x00dc, 0x0108, 0x0109, 0x0106, 
	0x0107, 0x00bc, 0x00bd, 0x00be, 0x00bf, 0x00f1, 0x00f2, 0x00ef, 
	0x00f0, 0x00f3, 0x00f4, 0x00e3, 0x00e4, 0x00e9, 0x00ea, 0x00fa, 
	0x00fb, 0x04c6, 0x04c7, 0x04c8, 0x04c9, 0x04ca, 0x04cb, 0x04cc, 
	0x04cd,      0,      0,      0,      0, 0x04ce,      0,      0, 
	     0, 0x01cc, 0x01cd, 0x01ca, 0x01cb, 0x01df, 0x01e0, 0x01e1, 
	0x01e2, 0x01ef, 0x01f0, 0x01f1, 0x01f2, 0x01f5, 0x01f6, 0x01f7, 
	0x01f8, 0x01ce, 0x01cf,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x025a, 0x04cf,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x02d2, 0x0057, 0x0099, 0x0760, 0x00b3, 0x00c4, 0x00f7, 
	0x0103, 0x0116, 0x012a, 0x014f, 0x0154, 0x0164, 0x0179, 0x0182, 
	0x0198, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 0x00d8, 0x00d9, 
	0x00da, 0x013d, 0x013e, 0x0145, 0x0146, 0x01be, 0x01bf, 0x01b6, 
	0x01b7, 0x06d5, 0x06d8, 0x06da, 0x06dc, 0x06de, 0x06e0, 0x06e2, 
	0x06e4, 0x06e6, 0x06e8, 0x06ea, 0x06ec, 0x06ee, 0x06f0, 0x06f2, 
	0x06f4, 0x01d6, 0x01d7, 0x01d8, 0x01d9, 0x024e, 0x024f, 0x0246, 
	0x0247, 0x025c, 0x025d, 0x025e, 0x025f, 0x0260, 0x0261, 0x0262, 
	0x0263, 0x06d6, 0x06d9, 0x06db, 0x06dd, 0x06df, 0x06e1, 0x06e3, 
	0x06e5, 0x06e7, 0x06e9, 0x06eb, 0x06ed, 0x06ef, 0x06f1, 0x06f3, 
	0x06f5, 0x04d9, 0x04da, 0x04db, 0x04dc, 0x04dd, 0x04de, 0x04df, 
	0x04e0, 0x04e1, 0x04e2,      0,      0,      0,      0,      0, 
	     0, 0x03db, 0x03dc,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x01dd, 0x01e4, 0x01e7, 0x01fc, 0x0215, 0x0228, 0x0267, 
	0x026e, 0x027d, 0x0284, 0x0297, 0x02eb, 0x02e6, 0x02ec, 0x030b, 
	0x0309, 0x01de, 0x01e5, 0x01e8, 0x01fd, 0x0216, 0x0229, 0x0268, 
	0x026f, 0x027e, 0x0285, 0x0298, 0x02f1, 0x02e4, 0x02f2, 0x031f, 
	0x0501, 0x02de,      0,      0, 0x02e0, 0x02e1, 0x02e2, 0x030e, 
	0x030f, 0x02d9, 0x02da, 0x02d3, 0x02d8, 0x02d6, 0x02d7, 0x02d4, 
	0x02d5, 0x03de, 0x03df, 0x03e0, 0x03e1,      0,      0, 0x03e2, 
	0x03e3, 0x03e4, 0x03e5,      0,      0,      0,      0,      0, 
	     0, 0x03e6, 0x03e7, 0x03e8, 0x03e9, 0x03ea, 0x03eb, 0x03ec, 
	0x03ed, 0x03ee, 0x03ef, 0x03f0, 0x03f1, 0x03f2, 0x03f3, 0x03f4, 
	0x03f5, 0x05e6, 0x05e7,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x05e8, 0x05e9, 0x05ea, 0x05eb, 0x05ec, 0x05ed, 0x05ee, 
	0x05ef, 0x05f0, 0x05f1, 0x05f2, 0x05f3, 0x05f4, 0x05f5, 0x05f6, 
	0x05f7, 0x01eb, 0x01ec, 0x01ed, 0x01ee, 0x022e, 0x022f, 0x0232, 
	0x0233,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x04f1, 0x04f2, 0x04f3, 0x04f4, 0x04f5, 0x04f6, 0x04f7, 
	0x04f8, 0x04f9, 0x04fa, 0x04fb, 0x04fc, 0x04fd, 0x04fe, 0x04ff, 
	0x0500, 0x03f6, 0x03f7, 0x03f8, 0x03f9, 0x03fa, 0x03fb, 0x03fc, 
	0x03fd, 0x03fe, 0x03ff, 0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 
	0x0405, 0x06f6, 0x06f8, 0x06fa, 0x06fc, 0x06fe, 0x0700, 0x0702, 
	0x0704, 0x0706, 0x0708, 0x070a, 0x070c, 0x070e, 0x0710, 0x0712, 
	0x0714, 0x06f7, 0x06f9, 0x06fb, 0x06fd, 0x06ff, 0x0701, 0x0703, 
	0x0705, 0x0707, 0x0709, 0x070b, 0x070d, 0x070f, 0x0711, 0x0713, 
	0x0715, 0x05f8, 0x05f9, 0x05fa, 0x05fb, 0x05fc, 0x05fd, 0x05fe, 
	0x05ff, 0x0600, 0x0601, 0x0602,      0,      0,      0,      0, 
	     0, 0x02fb, 0x0056, 0x0098, 0x075f, 0x00b2, 0x00c3, 0x00f6, 
	0x0102, 0x0115, 0x0129, 0x014e, 0x0153, 0x0163, 0x0178, 0x0181, 
	0x0197, 0x00fd, 0x00fe, 0x00ff, 0x0100, 0x0101, 0x0214, 0x01fe, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0001,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0002, 0x0003, 0x0004,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0001, 0x0005,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0086,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0088,      0,      0,      0, 
	0x0089,      0, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 
	0x0067, 0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 
	0x006f, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 
	0x0077, 0x0078, 0x0079, 0x007a,      0,      0,      0,      0, 
	     0,      0, 0x008b, 0x008c, 0x008d, 0x008e, 0x008f, 0x0090, 
	0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098, 
	0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f, 0x00a0, 
	0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 0x00a8, 
	0x00a9, 0x0001, 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 
	0x0046, 0x0047, 0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 
	0x004e, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 
	0x0009, 0x000a, 0x000b, 0x004f, 0x0050, 0x0051, 0x0052, 0x0053, 
	0x0054, 0x0055, 0x000c, 0x000e, 0x0010, 0x0012, 0x0014, 0x0016, 
	0x0018, 0x001a, 0x001c, 0x001e, 0x0020, 0x0022, 0x0024, 0x0026, 
	0x0028, 0x002a, 0x002c, 0x002e, 0x0030, 0x0032, 0x0034, 0x0036, 
	0x0038, 0x003a, 0x003c, 0x003e, 0x0056, 0x0057, 0x0058, 0x0059, 
	0x005a, 0x005b, 0x000d, 0x000f, 0x0011, 0x0013, 0x0015, 0x0017, 
	0x0019, 0x001b, 0x001d, 0x001f, 0x0021, 0x0023, 0x0025, 0x0027, 
	0x0029, 0x002b, 0x002d, 0x002f, 0x0031, 0x0033, 0x0035, 0x0037, 
	0x0039, 0x003b, 0x003d, 0x003f, 0x005c, 0x005d, 0x005e, 0x005f, 
	0x00ca, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 0x00b0, 
	0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 0x00b8, 
	0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 0x00c0, 
	0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 0x00c8, 
	0x00c9, 0x0060,      0,      0,      0, 0x0085,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0087,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x00cb, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 0x0080, 
	0x0081, 0x0082, 0x0083, 0x0084, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 
	0x00d0, 0x00d1, 0x00d2, 0x00d3,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0002,      0,      0, 0x0001,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0001, 0x0005, 0x0006,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x0002, 0x0004, 0x0003,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x007e, 0x0084, 0x008a, 0x0090, 0x0096, 0x009c, 
	0x00a2, 0x00a8, 0x00ae, 0x00b4, 0x00ba, 0x00c0, 0x00c6, 0x00cc, 
	0x00d2, 0x00d8, 0x00de, 0x00e4, 0x00ea, 0x00f0, 0x00f6, 0x00fc, 
	0x0102, 0x0108, 0x010e, 0x0114, 0x011a, 0x0120, 0x0126, 0x012c, 
	0x0132, 0x0007, 0x000d, 0x0017, 0x0027, 0x0020, 0x0028, 0x0026, 
	0x0016, 0x0018, 0x001d, 0x0024, 0x0029, 0x000a, 0x0009, 0x0010, 
	0x000f, 0x0036, 0x0038, 0x003a, 0x003c, 0x003e, 0x0040, 0x0042, 
	0x0044, 0x0046, 0x0048, 0x000c, 0x000b, 0x002a, 0x002b, 0x002c, 
	0x000e, 0x0013, 0x004b, 0x004d, 0x004f, 0x0051, 0x0053, 0x0055, 
	0x0057, 0x0059, 0x005b, 0x005d, 0x005f, 0x0061, 0x0063, 0x0065, 
	0x0067, 0x0069, 0x006b, 0x006d, 0x006f, 0x0071, 0x0073, 0x0075, 
	0x0077, 0x0079, 0x007b, 0x007d, 0x001a, 0x002d, 0x001b, 0x0015, 
	     0, 0x001e, 0x004a, 0x004c, 0x004e, 0x0050, 0x0052, 0x0054, 
	0x0056, 0x0058, 0x005a, 0x005c, 0x005e, 0x0060, 0x0062, 0x0064, 
	0x0066, 0x0068, 0x006a, 0x006c, 0x006e, 0x0070, 0x0072, 0x0074, 
	0x0076, 0x0078, 0x007a, 0x007c, 0x0019, 0x0025, 0x001c, 0x0014, 
	0x0008, 0x0138, 0x013e, 0x0144, 0x014a, 0x0150, 0x0151, 0x0157, 
	0x0158, 0x015e, 0x0164, 0x016a, 0x0170, 0x0176, 0x017c, 0x0182, 
	0x0011, 0x0189, 0x018a, 0x018b, 0x018d, 0x018e, 0x018f, 0x0190, 
	0x0191, 0x0192, 0x0193, 0x002f,      0,      0,      0,      0, 
	0x001f, 0x019a, 0x019b, 0x019c, 0x019d, 0x019e, 0x018c, 0x0012, 
	0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0030, 0x0188, 0x002e, 
	0x0021, 0x0037, 0x0039, 0x003b, 0x003d, 0x003f, 0x0041, 0x0043, 
	0x0045, 0x0047, 0x0049, 0x0022, 0x0023,      0,      0,      0, 
	     0, 0x0020, 0x0003, 0x002d,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0007, 0x0025, 0x0002, 0x000c,      0,      0,      0, 
	     0, 0x001b,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0019, 0x0021, 0x001c, 0x002c, 0x000b, 0x000e, 0x001d, 0x0028, 
	0x0017, 0x0009, 0x0014, 0x000a, 0x0026, 0x0016, 0x002a, 0x001f, 
	0x0031, 0x0024, 0x002b, 0x0010, 0x000f, 0x001a, 0x0015, 0x0023, 
	0x0011, 0x0012, 0x000d, 0x002f, 0x0018, 0x0006, 0x0022, 0x0004, 
	0x0027, 0x0013, 0x0008, 0x0029, 0x0005, 0x0030, 0x0032, 0x002e, 
	0x001e,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0001,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x010a, 0x0175, 0x0295, 0x00ec, 0x0253,      0,      0, 
	0x005e,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0267, 0x0287, 0x0088,      0,      0, 0x0186, 0x0024, 
	0x000f,      0,      0,      0,      0,      0,      0, 0x001f, 
	     0,      0,      0,      0,      0, 0x003c, 0x01c7, 0x01f3, 
	     0,      0, 0x0004, 0x0103, 0x00c0, 0x0085, 0x01bd, 0x029d, 
	0x0226, 0x00ac,      0,      0, 0x003e, 0x0099, 0x0185, 0x0199, 
	0x0091, 0x0001, 0x00b4, 0x023a, 0x0102, 0x0105, 0x019e, 0x0262, 
	0x008c, 0x0236, 0x0118, 0x0096, 0x01d4, 0x014d, 0x028f, 0x00b0, 
	0x0192, 0x0104, 0x00ad, 0x025f, 0x0119, 0x0125, 0x0132, 0x013f, 
	0x010b, 0x00a8, 0x0170, 0x017e, 0x01c8, 0x00f9, 0x01b5, 0x01f4, 
	0x005f, 0x000e, 0x01d1,      0,      0,      0,      0,      0, 
	     0, 0x0044, 0x0081,      0,      0, 0x000c,      0, 0x0009, 
	     0, 0x0215, 0x0054, 0x024b, 0x025e, 0x01bf, 0x028c, 0x029c, 
	0x0123, 0x013e, 0x01cb, 0x003d, 0x0293, 0x018b, 0x00c3, 0x00ca, 
	0x00ba, 0x001e, 0x024e, 0x0269, 0x01a6, 0x00d1, 0x0217, 0x0089, 
	0x01e5, 0x01ff, 0x00de, 0x00a5, 0x0151, 0x0163, 0x0173, 0x0181, 
	0x00be, 0x0023, 0x0273, 0x0062, 0x0294, 0x0055, 0x0116, 0x00f4, 
	0x0178, 0x0187, 0x0065, 0x0045, 0x0179, 0x00b9, 0x0191, 0x00cd, 
	0x01c5, 0x0026, 0x0018, 0x014b, 0x0160, 0x0284, 0x0289, 0x0296, 
	0x018e, 0x02a1, 0x01c6, 0x011f, 0x0098, 0x00df, 0x0133, 0x0126, 
	0x01a3, 0x0027,      0, 0x0165, 0x0016,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0128, 0x00a0, 0x016b, 0x0156, 0x0168, 0x017a, 0x002a, 
	0x019f, 0x01b2, 0x00ce, 0x01af, 0x000d, 0x01ea, 0x01ce, 0x0209, 
	0x01e6, 0x0130, 0x0251, 0x020d, 0x00fd, 0x026e, 0x0285, 0x00ea, 
	0x010d, 0x0068, 0x0117, 0x003f, 0x01a9, 0x00c7, 0x004e, 0x00ae, 
	0x0048, 0x0239, 0x0127, 0x026c, 0x00a1, 0x0154, 0x0292, 0x0111, 
	0x02a8, 0x0121, 0x0194, 0x0169, 0x0167, 0x0174, 0x01a7, 0x0049, 
	0x01a1, 0x013b, 0x0084, 0x0164, 0x016a, 0x017d, 0x019c, 0x001a, 
	0x0252, 0x0057, 0x01d7, 0x01f1, 0x0259, 0x00e3, 0x0076, 0x021e, 
	0x022d, 0x013d, 0x0161, 0x0109, 0x00b6, 0x00bc,      0,      0, 
	     0,      0, 0x0005, 0x004a, 0x0220, 0x01c0, 0x00d3, 0x01db, 
	0x023f, 0x0257, 0x020c, 0x0221, 0x0228, 0x00ef, 0x009d, 0x0042, 
	0x0249, 0x0067, 0x0266, 0x0030, 0x0278, 0x02af, 0x011a, 0x0134, 
	0x0149, 0x025c, 0x0202, 0x00b7, 0x0219, 0x0212, 0x0146, 0x00b1, 
	0x00e2, 0x017c, 0x0196, 0x004c, 0x00cc, 0x00d0, 0x00d7, 0x0248, 
	0x00f7, 0x025d, 0x01ac, 0x02a7, 0x027a, 0x027d, 0x0025, 0x008a, 
	0x013c, 0x00c4, 0x0022, 0x00e6, 0x002c, 0x011e, 0x02a4, 0x0138, 
	0x025b, 0x0261, 0x0225, 0x0201, 0x0136, 0x0145, 0x015a, 0x004d, 
	0x0184, 0x0080, 0x018f, 0x019b, 0x01a2, 0x0036, 0x01bc, 0x012b, 
	0x01e0, 0x0071, 0x00c5, 0x025a, 0x0059, 0x009e, 0x027b, 0x003b, 
	0x029e, 0x01ed, 0x0114, 0x0069, 0x01a0, 0x01ad, 0x014e, 0x009f, 
	0x006e, 0x0172, 0x0180, 0x02ac, 0x00f8, 0x01a8, 0x012d, 0x009c, 
	0x0157, 0x00f2, 0x00d6, 0x01f8, 0x0203, 0x022c, 0x0193, 0x0051, 
	0x016c, 0x0176, 0x00bd, 0x019d, 0x01ab, 0x001c, 0x00cf, 0x01d9, 
	0x01ee, 0x02a0, 0x00e4, 0x021c, 0x011b, 0x0064, 0x024a, 0x0143, 
	0x0158, 0x0177, 0x009b, 0x0276, 0x007c, 0x0272, 0x020e, 0x0265, 
	0x0299, 0x02a5, 0x0010, 0x0131, 0x0122, 0x00a7, 0x0153, 0x017f, 
	0x0198, 0x007a, 0x01c1, 0x0050, 0x01d3, 0x00a9, 0x00da, 0x00c8, 
	0x0214, 0x021f, 0x0231, 0x01fc, 0x01fe, 0x0229, 0x0100, 0x0246, 
	0x028d, 0x0283,      0, 0x00f1, 0x026b, 0x029a, 0x0093, 0x015c, 
	0x018d,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0288, 0x008d, 0x0052, 0x0124, 0x0135, 0x0260, 0x0162, 
	0x019a, 0x0182, 0x0137, 0x01b7, 0x0141, 0x006d, 0x01cc, 0x01e1, 
	0x01f2, 0x018a, 0x01ef, 0x01cd, 0x0070, 0x0013, 0x01c9, 0x00fe, 
	0x01e9, 0x01f7, 0x00dd, 0x0200, 0x0056, 0x020f, 0x008b, 0x0238, 
	0x0244, 0x008f,      0,      0, 0x0007, 0x012c, 0x0031, 0x0039, 
	0x0210, 0x0066, 0x01ae, 0x00c2, 0x0234, 0x0011, 0x0243,      0, 
	     0, 0x0090, 0x0053, 0x0213, 0x0144, 0x00e5, 0x009a, 0x00b3, 
	0x0183, 0x0035, 0x002b, 0x0115, 0x00c9, 0x006c, 0x0015, 0x0271, 
	0x01e3, 0x0092, 0x015b, 0x018c, 0x01be, 0x01f9, 0x00fc, 0x0150, 
	0x01dd, 0x015f, 0x017b, 0x0142, 0x01b4,      0,      0, 0x0012, 
	0x0008, 0x01a4, 0x00fa, 0x01c2, 0x01d8, 0x0279, 0x0206, 0x0211, 
	0x0077, 0x0277, 0x010c, 0x02a2, 0x008e, 0x02ae, 0x01ca, 0x0086, 
	0x0148, 0x02a6, 0x01e8, 0x01fd, 0x01eb, 0x021d, 0x0291, 0x0078, 
	0x0233, 0x02a3, 0x0247, 0x00f5, 0x005b, 0x026a,      0,      0, 
	     0, 0x02ab, 0x0204, 0x013a, 0x02a9, 0x00c1, 0x023c, 0x0166, 
	0x01bb, 0x0263, 0x01a5, 0x0286, 0x0106, 0x0110, 0x006b, 0x0063, 
	0x021a, 0x02ad, 0x0120, 0x0040, 0x0046, 0x00a6, 0x0032, 0x0019, 
	0x0034, 0x0047, 0x0188, 0x00bf, 0x01aa, 0x01b1, 0x01ba, 0x01c3, 
	0x01b9, 0x01b3, 0x01b6, 0x000b, 0x0152, 0x006a, 0x0028,      0, 
	     0, 0x000a,      0,      0,      0,      0,      0,      0, 
	     0, 0x01b8, 0x01d2, 0x01de, 0x01f5, 0x020b, 0x0218, 0x022a, 
	0x020a, 0x0250, 0x0245, 0x00e9, 0x022b, 0x00fb, 0x01dc, 0x027c, 
	0x0108, 0x00cb, 0x01c4, 0x01da, 0x016d, 0x00b2, 0x00bb, 0x021b, 
	0x007e, 0x0235, 0x0242, 0x0258, 0x00dc, 0x0002, 0x0270, 0x027f, 
	0x028e, 0x00d4, 0x0232, 0x0197, 0x0268, 0x0021, 0x028a, 0x002f, 
	0x014c, 0x010f, 0x0083, 0x0061, 0x012a, 0x00a2, 0x0155, 0x0041, 
	0x016f, 0x00d5, 0x0095, 0x0097, 0x012e, 0x00a3,      0,      0, 
	     0,      0,      0,      0, 0x0003, 0x01e4, 0x0159, 0x0043, 
	0x024f, 0x01d5, 0x01e7, 0x0033, 0x00ab, 0x012f, 0x0190, 0x00af, 
	0x003a, 0x007d, 0x0256, 0x004f, 0x0274, 0x01cf, 0x028b, 0x015e, 
	0x0112, 0x01d6, 0x0038, 0x01d0, 0x0208, 0x0264, 0x0280, 0x00ee, 
	0x01fb, 0x007b, 0x007f, 0x0058, 0x026f, 0x0282, 0x0298, 0x0224, 
	0x0223, 0x00d8, 0x02aa, 0x01ec, 0x0074, 0x0207, 0x00f0, 0x029b, 
	0x024c, 0x0255, 0x0017, 0x022f, 0x0281, 0x0241, 0x005d, 0x010e, 
	0x0060, 0x00e1, 0x0216, 0x024d,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x01e2, 0x00b8, 0x00e0, 0x0189,      0,      0,      0, 
	0x0029, 0x0079, 0x004b, 0x00c6, 0x0205, 0x005a, 0x0107, 0x00d2, 
	0x029f, 0x00e7, 0x01f0, 0x002d, 0x023e, 0x00f6, 0x00eb, 0x026d, 
	0x0020, 0x01df, 0x00ed, 0x0230, 0x011c, 0x023b, 0x0147, 0x00d9, 
	0x016e, 0x00e8, 0x01b0, 0x0037, 0x006f,      0, 0x001b, 0x0072, 
	0x00db, 0x0073, 0x023d, 0x0222, 0x0237, 0x0006, 0x002e, 0x00f3, 
	0x0082, 0x01f6, 0x0140, 0x005c, 0x0075, 0x0171, 0x0227, 0x022e, 
	0x0014, 0x00a4, 0x0240, 0x0113, 0x0101, 0x0129, 0x0290, 0x0254, 
	0x01fa, 0x00ff, 0x0275, 0x027e, 0x0087,      0, 0x001d, 0x0297, 
	0x011d, 0x0139, 0x015d, 0x0094, 0x00b5, 0x0195, 0x014a, 0x014f, 
	0x00aa,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0c63, 0x30be, 0x30bf, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0894, 0x1967, 0x2ed1, 0x075e, 
	0x1968,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0a5a, 0x3099, 0x309a,      0,      0,      0,      0, 0x309b, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x09ee, 0x2dec, 0x2ded, 0x18d4,      0,      0, 0x2dee, 0x2def, 
	0x18d6,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x048d, 
	     0, 0x1691,      0, 0x1692, 0x2a4a, 0x2a49, 0x2a4b, 0x2a4c, 
	0x2a4d,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x07a4, 
	0x1ac0, 0x1ac1, 0x0678,      0, 0x31ad,      0, 0x31ae,      0, 
	0x31af,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x1b7b,      0, 
	     0, 0x05ed, 0x1b7c, 0x3307, 0x3308, 0x3309, 0x1b7d,      0, 
	0x0760,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x1c8a,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0155,      0, 0x0156,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x015b,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x015f,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0146, 0x0147, 0x0145, 0x0148,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x2b75,      0,      0, 0x1768,      0, 0x1769,      0, 
	0x03de, 0x2b76,      0,      0, 0x03b3, 0x1766, 0x2b77,      0, 
	0x2b78,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x00fb,      0,      0,      0,      0, 0x00fa, 0x00ff, 
	     0, 0x0103, 0x0104,      0,      0, 0x0105, 0x0106,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0170,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x1d03, 
	0x0ba7, 0x0ea4, 0x1d04,      0, 0x1d06, 0x0bd5, 0x1d07, 0x0e2f, 
	0x1d08, 0x0878, 0x1d09, 0x071a, 0x1d0a, 0x074a, 0x03c5, 0x1d0b, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0e03,      0, 
	0x3364, 0x3365, 0x3366, 0x3367,      0, 0x3368, 0x1bb4, 0x3369, 
	0x336a,      0,      0,      0,      0, 0x1bb5, 0x15ac, 0x336b, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x1c21, 0x1c77, 
	0x1c3d, 0x1c93, 0x1c4f, 0x1ca4, 0x1c61, 0x1cb6, 0x1c6a, 0x1cbf, 
	0x1c67, 0x1cbc, 0x1c69, 0x1cbe, 0x1c68, 0x1cbd,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x205f,      0,      0,      0, 
	     0, 0x2060,      0, 0x0b99, 0x2061,      0,      0, 0x2062, 
	     0,      0, 0x2063, 0x106f, 0x0c29, 0x2064,      0, 0x2065, 
	0x2066,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x25b1, 0x13f8, 0x25b2, 0x25b3, 
	0x13fe,      0,      0, 0x13fc,      0, 0x0aa8,      0,      0, 
	0x1403, 0x13f9, 0x25b4,      0, 0x25b5,      0, 0x25b6, 0x13fa, 
	0x13e2,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x2566,      0, 0x2567,      0,      0, 
	0x0419,      0,      0, 0x037c,      0, 0x2568, 0x13c0,      0, 
	0x2569, 0x13c3, 0x256a,      0,      0, 0x0e10, 0x256b,      0, 
	0x256c,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x016c,      0,      0, 0x016b,      0, 
	0x016a,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x1eca, 0x1ecb,      0,      0, 0x0fac, 
	0x0d92,      0, 0x0814, 0x1ecc, 0x0fb2,      0, 0x1ecd, 0x1ece, 
	     0, 0x0fb1, 0x0fa8,      0, 0x1ecf, 0x1ed0, 0x1ed1, 0x09a8, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x03e3,      0,      0, 0x1f0e,      0,      0, 
	0x0fda, 0x1f0f, 0x0869, 0x0fd6, 0x1f10, 0x0fd4, 0x1f11, 0x0fd5, 
	0x1f12, 0x0fd7, 0x1f13,      0, 0x1f14, 0x1f15, 0x1f16,      0, 
	0x1f17,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0e42,      0, 0x262c, 0x143e,      0,      0,      0, 
	0x034f,      0, 0x262d,      0, 0x262e, 0x262f, 0x2630, 0x2631, 
	     0, 0x2632, 0x1440,      0,      0, 0x2633, 0x143f,      0, 
	0x143d,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x2758, 0x2759, 0x14b9,      0, 0x275a,      0,      0, 
	0x14ba, 0x275b,      0,      0, 0x275c, 0x14bb,      0,      0, 
	     0, 0x275d,      0, 0x275e, 0x275f, 0x0362,      0, 0x2760, 
	0x2761,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0c6e,      0, 0x1aa0, 0x3170,      0, 0x3171, 0x3172, 
	0x1aa1, 0x3173, 0x1aa2,      0,      0, 0x3174,      0, 0x1aa3, 
	0x3175, 0x3176,      0, 0x3177, 0x3178,      0,      0,      0, 
	0x3179,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x2c7f,      0, 0x03e8, 0x17de, 0x17df, 0x2c5e,      0, 
	     0,      0, 0x2c5f,      0, 0x17da,      0, 0x0710, 0x2c60, 
	     0, 0x2c61,      0, 0x2c62,      0, 0x2c63,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0693,      0, 0x31ea,      0, 0x31eb, 0x1ae8, 0x31ec, 
	0x31ed, 0x1ae9,      0, 0x31ee,      0, 0x31ef, 0x31f0, 0x31f1, 
	     0, 0x041f, 0x31f2,      0, 0x31f3, 0x1aea,      0, 0x31f4, 
	0x31f5,      0,      0,      0,      0,      0,      0,      0, 
	0x21bd,      0,      0, 0x21be,      0,      0, 0x21bf, 0x1153, 
	0x1159, 0x1151,      0, 0x0adb, 0x21c0, 0x21c1, 0x1156, 0x0c54, 
	0x21c2, 0x21c3, 0x1150, 0x21c4, 0x1155, 0x0e34, 0x072a,      0, 
	0x21c5,      0,      0,      0,      0,      0,      0,      0, 
	0x1bbe,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x1bbd, 0x1bc0, 0x1bc4, 0x1bc3,      0, 0x1bc1,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x2bd6,      0,      0, 0x2bd7,      0, 0x0cdc,      0, 0x0e4c, 
	0x2bd8, 0x2bd9, 0x2bda, 0x2bdb,      0, 0x17a1,      0,      0, 
	0x2bdc,      0,      0, 0x2bde, 0x2bdf, 0x17a8, 0x2be0,      0, 
	0x17a0,      0,      0,      0,      0,      0,      0,      0, 
	0x20d9, 0x20da,      0, 0x20db,      0, 0x10bb,      0,      0, 
	0x20dc, 0x04b5, 0x10bc, 0x20dd,      0, 0x10bd,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x20de,      0, 
	0x20df,      0,      0,      0,      0,      0,      0,      0, 
	0x11f7, 0x02f0, 0x228c, 0x228d, 0x06b8,      0, 0x228e,      0, 
	0x0881,      0,      0,      0,      0,      0, 0x228f, 0x2290, 
	     0,      0, 0x2291, 0x0a93,      0, 0x2292, 0x0bed, 0x11fd, 
	0x0965,      0,      0,      0,      0,      0,      0, 0x1218, 
	     0,      0, 0x22cd, 0x22ce,      0,      0, 0x09a0,      0, 
	0x121f, 0x22cf,      0, 0x22d0, 0x1219, 0x22d1,      0, 0x1216, 
	0x121d, 0x22d2,      0,      0,      0, 0x11ff,      0, 0x22d3, 
	     0,      0,      0,      0,      0,      0,      0, 0x013c, 
	0x013b,      0,      0,      0, 0x0138,      0,      0, 0x013a, 
	0x0139,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x2271, 
	     0, 0x2272,      0,      0, 0x0bfd, 0x1237,      0,      0, 
	     0,      0, 0x0ccf,      0, 0x2273,      0, 0x0a92, 0x2274, 
	0x2275,      0, 0x0d28, 0x2276, 0x11e7, 0x03a6, 0x0a2d, 0x2277, 
	0x2278,      0,      0,      0,      0,      0, 0x1f04, 0x09f5, 
	     0, 0x1f05, 0x03ca, 0x1f06,      0,      0, 0x1f07, 0x1f08, 
	0x1f09, 0x1f0a, 0x1f0b, 0x1f0c,      0, 0x0fca,      0, 0x0fcc, 
	0x0815, 0x035a, 0x1f0d,      0, 0x0fcf,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0137, 0x0136, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x015a,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0a5c, 0x32a9, 
	0x1b44,      0, 0x0bd0,      0, 0x1b49, 0x1b45,      0,      0, 
	     0, 0x1b46,      0, 0x32aa, 0x0ce4, 0x0d55,      0, 0x0b2d, 
	0x32ab,      0, 0x32ac,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0464, 0x2b46, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x2b47, 0x0398, 0x1742, 0x0e37, 0x09c2, 0x2b48,      0, 
	0x0c3b,      0, 0x174e, 0x2b49, 0x03dc, 0x174c,      0, 0x174a, 
	0x1741,      0,      0,      0,      0,      0, 0x0a66, 0x254b, 
	0x254c, 0x254d, 0x0373, 0x0656, 0x13ab,      0,      0, 0x254f, 
	0x2550,      0, 0x2551, 0x07b6, 0x13b0,      0, 0x13af, 0x13aa, 
	     0, 0x13ad, 0x2552,      0, 0x044b, 0x2553, 0x13ac, 0x0b84, 
	0x2554,      0,      0,      0,      0,      0, 0x22a0, 0x22a1, 
	0x0cd0, 0x077f, 0x120c,      0, 0x120b, 0x22a2, 0x22a3, 0x08c3, 
	     0,      0, 0x22a4, 0x05d9,      0, 0x22a5, 0x22a6, 0x1205, 
	0x0826, 0x22a7,      0, 0x0b45, 0x0b6c, 0x22a8, 0x22a9,      0, 
	0x22aa,      0,      0,      0,      0,      0, 0x2ba5, 0x178c, 
	0x2ba6, 0x2ba7, 0x0dc4, 0x2ba8,      0,      0, 0x2ba9, 0x0df7, 
	0x2baa,      0, 0x2bab, 0x2bac,      0,      0,      0, 0x2bad, 
	0x0a3b, 0x2bae, 0x2baf, 0x2bb0, 0x044e, 0x2bb1,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x1ac2, 0x31b0, 
	     0, 0x0421,      0,      0,      0, 0x0b8a, 0x1ac3, 0x1ac4, 
	     0, 0x31b1, 0x31b2, 0x31b3, 0x0a1d, 0x0b48, 0x31b4,      0, 
	     0,      0, 0x31b5, 0x31b6,      0, 0x1ac5, 0x31b7,      0, 
	0x31b8,      0,      0,      0,      0,      0, 0x10c4,      0, 
	0x10c6,      0, 0x20e9,      0, 0x20ea,      0,      0,      0, 
	     0,      0,      0, 0x20eb,      0,      0,      0,      0, 
	0x20ed,      0, 0x10c7,      0,      0,      0, 0x20ec,      0, 
	     0,      0,      0,      0,      0,      0, 0x2ad1, 0x16f2, 
	0x2ad2,      0,      0, 0x2ad3, 0x16f0, 0x2ad4,      0, 0x08a0, 
	     0, 0x0c5c, 0x16f5, 0x2ad5, 0x16f4, 0x0667, 0x0e7e,      0, 
	0x2ad6,      0,      0,      0,      0,      0,      0,      0, 
	0x1705,      0,      0,      0,      0, 0x3316, 0x1b86, 0x0bb9, 
	     0, 0x3317, 0x1b87, 0x1b89,      0, 0x3318, 0x1b8a, 0x3319, 
	0x331a, 0x331b,      0,      0, 0x331c, 0x331d, 0x331e,      0, 
	     0, 0x1b88, 0x0684, 0x0d5e, 0x0d16, 0x1109,      0, 0x1384, 
	0x0d2e,      0,      0,      0,      0, 0x2626,      0,      0, 
	     0,      0,      0,      0, 0x2627, 0x1439, 0x09fd, 0x143c, 
	0x1437, 0x2628, 0x2629,      0, 0x143b, 0x262a,      0,      0, 
	0x262b, 0x143a, 0x0abf, 0x0322,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x1333, 0x2482, 0x2483, 
	0x1338, 0x133c, 0x2484, 0x2485, 0x0533,      0,      0, 0x2486, 
	     0, 0x2487, 0x2488, 0x2489,      0,      0, 0x248a, 0x248b, 
	     0, 0x04eb, 0x133a,      0, 0x248c,      0,      0,      0, 
	0x04c0,      0,      0,      0,      0, 0x2634,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x1438,      0,      0,      0,      0,      0, 
	     0,      0, 0x0cd6, 0x2635,      0,      0, 0x1442,      0, 
	     0,      0,      0,      0,      0, 0x2543,      0,      0, 
	0x2544,      0,      0, 0x2545, 0x0dbd, 0x13b2,      0, 0x2546, 
	0x2547,      0, 0x2548, 0x13b1, 0x2549,      0,      0,      0, 
	0x091f,      0, 0x13ae, 0x254a, 0x0ddb,      0,      0, 0x0b13, 
	0x13a8,      0,      0,      0,      0, 0x2956,      0, 0x0ca4, 
	0x03da,      0, 0x2957,      0, 0x15eb,      0, 0x15e8, 0x2958, 
	0x15ed, 0x2959, 0x295a, 0x15ec,      0, 0x0bae, 0x0d38, 0x295b, 
	0x070e, 0x15e6, 0x15ef, 0x15ea, 0x295c, 0x15e9, 0x15e5, 0x295d, 
	0x15e7,      0,      0,      0,      0, 0x3160,      0, 0x1a97, 
	0x3161,      0,      0, 0x3162, 0x1a99, 0x09cf, 0x043e, 0x043f, 
	0x1a98,      0, 0x3163, 0x3164, 0x3165, 0x04aa, 0x05eb, 0x3166, 
	0x3167, 0x04ab, 0x3168, 0x3169, 0x0abe,      0,      0, 0x0e2d, 
	     0,      0,      0,      0,      0, 0x2679,      0,      0, 
	     0, 0x1464,      0, 0x0a7f, 0x267a, 0x1466, 0x1465,      0, 
	0x267b, 0x1467,      0, 0x1468,      0, 0x267c, 0x0790, 0x0c5a, 
	     0, 0x267d, 0x267e, 0x0d7d, 0x1469, 0x146a, 0x095d, 0x0755, 
	0x146b,      0,      0,      0,      0, 0x03b0,      0, 0x331f, 
	     0, 0x3320,      0,      0, 0x3321, 0x1b8c, 0x04ef, 0x1b8d, 
	0x1b8e, 0x1b8f,      0, 0x068c,      0, 0x1b90, 0x3322,      0, 
	     0, 0x1492, 0x0d6c,      0, 0x09c8, 0x1b91, 0x1b93, 0x1b92, 
	0x3323,      0,      0,      0,      0, 0x24b1,      0,      0, 
	0x24b2, 0x0bc0,      0, 0x1352,      0, 0x24b3,      0,      0, 
	     0, 0x24b4, 0x24b5, 0x24b6,      0,      0,      0,      0, 
	     0,      0,      0, 0x1356, 0x1353, 0x24b7, 0x24b8,      0, 
	     0,      0,      0,      0,      0, 0x04bf, 0x241b, 0x12f8, 
	     0, 0x241c, 0x0d5a, 0x12df, 0x04be, 0x241d, 0x12e6,      0, 
	0x241e, 0x241f, 0x2420, 0x0cf3, 0x2421, 0x12e7, 0x12e9, 0x2422, 
	0x12ed, 0x12e1, 0x2423, 0x09ed,      0, 0x2424, 0x2425,      0, 
	0x0aee,      0,      0,      0,      0, 0x1bc6, 0x1bc7, 0x1bd2, 
	     0, 0x1bd3, 0x1bd4, 0x1bd5,      0, 0x1bd7,      0, 0x1bd8, 
	0x1bda, 0x1be0, 0x0258, 0x0259, 0x025a, 0x025b, 0x025c, 0x025d, 
	0x025e, 0x025f, 0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 0x0265, 
	0x0266,      0,      0,      0,      0, 0x19df,      0,      0, 
	0x3026, 0x3027, 0x3028,      0, 0x0b46,      0, 0x0ad4,      0, 
	     0, 0x3029, 0x302a, 0x302b,      0, 0x0a78, 0x302c, 0x19ec, 
	0x302d, 0x302e,      0, 0x302f, 0x0a06, 0x19e8,      0, 0x3030, 
	     0,      0,      0,      0,      0, 0x08ff, 0x2e2e, 0x0780, 
	0x1905,      0, 0x2e2f,      0, 0x0435, 0x2e30, 0x1906, 0x2e31, 
	     0, 0x097d, 0x1907,      0, 0x1908, 0x0c62,      0,      0, 
	0x04ce,      0,      0,      0,      0,      0,      0,      0, 
	0x2e32,      0,      0,      0, 0x2008, 0x0389,      0, 0x2009, 
	0x04b2, 0x0b3d, 0x0cc9,      0,      0,      0,      0, 0x104d, 
	0x095c, 0x104c, 0x059b, 0x200a, 0x200b, 0x0d0e, 0x104b,      0, 
	0x0ae4, 0x104f, 0x200c, 0x104e, 0x200d,      0, 0x200e, 0x200f, 
	0x2010,      0,      0,      0, 0x260b, 0x260c,      0,      0, 
	     0, 0x260d, 0x260e, 0x260f, 0x2610, 0x13f7,      0, 0x2615, 
	     0,      0, 0x1433,      0,      0, 0x2611, 0x2612,      0, 
	     0, 0x0b44,      0,      0,      0,      0, 0x2613, 0x2614, 
	     0,      0,      0,      0, 0x2126,      0,      0,      0, 
	0x2127,      0, 0x10ec,      0, 0x2128, 0x04a1, 0x10ed, 0x212a, 
	     0, 0x2129,      0, 0x10ef, 0x10ee,      0,      0, 0x10f0, 
	     0, 0x212b, 0x212c,      0, 0x10f1,      0, 0x0917, 0x07b2, 
	     0,      0,      0,      0, 0x0328, 0x16e6,      0, 0x0a03, 
	     0, 0x2ab0,      0,      0,      0, 0x0b93, 0x2ab1, 0x09c0, 
	0x2ab2,      0,      0, 0x2ab3,      0, 0x2ab4, 0x2ab5, 0x16e8, 
	0x2ab6, 0x2ab7, 0x16e4, 0x16e7, 0x16e2,      0, 0x16e5, 0x0cd9, 
	     0,      0,      0,      0, 0x1a2a,      0,      0, 0x30ae, 
	0x0310, 0x30af, 0x30b0, 0x1a28, 0x30b1, 0x1a2c, 0x1a2b,      0, 
	     0, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x1a2e, 0x1a2d, 0x1a2f, 
	     0, 0x0b0b, 0x30b6, 0x30b7,      0, 0x1a30, 0x30b8, 0x30b9, 
	0x30ba,      0,      0,      0, 0x012b,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x1bd1, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x232e,      0, 0x0607,      0, 
	0x232f, 0x124d, 0x2330,      0,      0,      0, 0x1250,      0, 
	0x0c49, 0x2331, 0x04fe, 0x2332,      0, 0x2333, 0x124f, 0x124e, 
	0x0b8f, 0x1251, 0x0532,      0,      0,      0, 0x1253, 0x1252, 
	0x2334,      0,      0,      0, 0x1434, 0x2616, 0x2617,      0, 
	     0,      0,      0,      0, 0x03d5, 0x2618,      0, 0x2619, 
	0x0af3, 0x0408,      0,      0,      0,      0, 0x261a, 0x261b, 
	     0, 0x0503,      0,      0,      0, 0x078f, 0x06c7, 0x261c, 
	     0,      0,      0,      0, 0x2636, 0x2637, 0x2638, 0x2639, 
	0x263a,      0, 0x1441,      0, 0x263b, 0x263c,      0,      0, 
	0x263d,      0,      0,      0,      0, 0x0392,      0,      0, 
	     0,      0, 0x1444, 0x0c87,      0, 0x1443,      0, 0x263e, 
	     0,      0,      0,      0, 0x2037, 0x2038, 0x035f, 0x0470, 
	0x2039, 0x105d,      0, 0x0d56, 0x0c28,      0,      0, 0x203a, 
	0x203b,      0, 0x203c, 0x203d,      0, 0x203e,      0, 0x02f1, 
	0x203f,      0,      0,      0, 0x0342,      0,      0,      0, 
	0x0724,      0,      0,      0, 0x2844,      0,      0,      0, 
	0x1558,      0, 0x2845,      0,      0,      0, 0x1559,      0, 
	     0,      0, 0x2846, 0x2847,      0,      0, 0x2848,      0, 
	0x155a,      0, 0x2849, 0x155b, 0x0d48, 0x155c,      0, 0x284a, 
	0x284b,      0,      0,      0, 0x2a4e, 0x2a4f, 0x1693,      0, 
	0x2a50,      0,      0,      0,      0, 0x1694, 0x1695, 0x1696, 
	0x2a51, 0x1697, 0x1698, 0x2a52, 0x2a53, 0x169a, 0x1699,      0, 
	     0, 0x169b,      0,      0, 0x2a54, 0x2a55, 0x2a56,      0, 
	0x169c,      0,      0,      0, 0x1b4f,      0,      0, 0x1b4d, 
	     0, 0x045e,      0, 0x1b4c, 0x0763, 0x03ae,      0,      0, 
	0x32b5, 0x32b6,      0, 0x32b7, 0x32b8, 0x32b9,      0,      0, 
	     0,      0,      0, 0x32ba, 0x067a, 0x32bb, 0x32bd, 0x1b56, 
	0x1b55,      0,      0,      0, 0x2f55,      0,      0,      0, 
	0x2f56, 0x2f57, 0x0b30, 0x19a6, 0x07c5, 0x0791, 0x0b96, 0x0a34, 
	0x2f58,      0,      0, 0x07a3, 0x2f59, 0x08b7,      0, 0x19a7, 
	0x2f5a, 0x19a8, 0x2f5b, 0x2f5c, 0x2f5d,      0,      0,      0, 
	     0,      0,      0,      0, 0x0459, 0x15ba, 0x15b9, 0x2928, 
	0x15bd, 0x15b6, 0x2929, 0x15be, 0x0df6, 0x292a, 0x15bf, 0x292b, 
	0x15c0,      0, 0x292c, 0x104a, 0x15c2,      0, 0x15c1,      0, 
	     0,      0, 0x15c3, 0x15c4, 0x292d, 0x0e02, 0x15c5,      0, 
	0x1a8d,      0,      0,      0, 0x105a, 0x2023, 0x09aa,      0, 
	0x2024, 0x0ceb,      0,      0,      0, 0x0ac9, 0x2025, 0x2026, 
	0x2027, 0x2028,      0, 0x105b, 0x2029,      0,      0,      0, 
	0x202a,      0, 0x0d18, 0x202b, 0x06bf, 0x202c,      0, 0x0817, 
	     0,      0,      0,      0, 0x1361,      0,      0, 0x24cd, 
	0x1360,      0, 0x1362, 0x24ce,      0, 0x03d3, 0x24cf, 0x09fa, 
	     0, 0x1363,      0, 0x24d0, 0x0480, 0x1365,      0, 0x24d1, 
	     0, 0x24d2, 0x1364,      0, 0x1366,      0, 0x24d3,      0, 
	0x1367,      0,      0,      0, 0x2865, 0x2866, 0x1565,      0, 
	0x2867, 0x2868,      0,      0,      0, 0x2869,      0, 0x286a, 
	     0,      0,      0, 0x286b,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x286c, 0x0838, 0x286d, 
	     0,      0,      0,      0, 0x087f, 0x21a4, 0x0c23,      0, 
	0x21a5, 0x21a6, 0x21a7,      0, 0x21a8, 0x04b8, 0x0b61,      0, 
	     0, 0x21a9, 0x21aa, 0x21ab, 0x21ac, 0x21ad,      0, 0x1146, 
	0x0729, 0x0ced, 0x0cee,      0,      0, 0x03a5, 0x114b, 0x21ae, 
	     0,      0,      0,      0, 0x0a87, 0x0f29, 0x1dfe,      0, 
	0x098c,      0, 0x1dff, 0x06e4, 0x0f2a, 0x0f2b, 0x0937,      0, 
	0x0f28,      0,      0,      0,      0, 0x0f2d, 0x1e00, 0x0ce9, 
	0x1e01, 0x1e02,      0, 0x1e03, 0x067b, 0x1e04,      0, 0x0f2c, 
	0x1e05,      0,      0,      0, 0x138a, 0x1389,      0, 0x2507, 
	0x2508, 0x2509,      0,      0,      0, 0x250a,      0, 0x250b, 
	     0,      0,      0,      0, 0x250c, 0x08b0, 0x250d, 0x250e, 
	0x0c30, 0x0371,      0, 0x250f, 0x2510,      0,      0, 0x0bde, 
	0x2511,      0,      0,      0, 0x2fa8, 0x2fa9, 0x2faa, 0x2fab, 
	     0, 0x2fac, 0x1a0f,      0,      0, 0x19c7,      0, 0x2fad, 
	0x2fae, 0x2faf,      0,      0, 0x2fb0, 0x0e38, 0x2fb1, 0x2fb2, 
	0x0613, 0x2fb3, 0x2fb4, 0x2fb5,      0, 0x2fb6,      0, 0x2fb7, 
	0x19d1,      0,      0,      0, 0x05bd,      0, 0x22f2,      0, 
	0x22f3, 0x1229,      0,      0,      0,      0,      0,      0, 
	0x22f4, 0x22f5, 0x22f6, 0x0708, 0x1226,      0, 0x1225,      0, 
	     0, 0x22f7, 0x22f8, 0x0b6d, 0x22f9,      0, 0x22fa, 0x0b12, 
	0x22fb,      0,      0,      0, 0x04c7, 0x0602, 0x108b, 0x043b, 
	     0, 0x2092, 0x108c,      0, 0x099e,      0,      0, 0x2093, 
	0x2094, 0x108d, 0x10b5,      0, 0x108e,      0, 0x108f,      0, 
	     0, 0x1090,      0, 0x1092,      0, 0x2095, 0x2096, 0x2097, 
	0x2098,      0,      0,      0, 0x14c8, 0x14c7, 0x14c9, 0x276c, 
	     0,      0,      0,      0,      0, 0x14ca, 0x14cc, 0x14cb, 
	     0,      0, 0x0690, 0x276d, 0x14ce,      0, 0x14cd, 0x276e, 
	0x276f, 0x0486,      0, 0x089e,      0, 0x0abb,      0, 0x14cf, 
	0x08e1,      0,      0,      0, 0x26c8, 0x068d, 0x0735,      0, 
	     0,      0,      0,      0,      0,      0, 0x26c9, 0x1490, 
	0x1491, 0x26ca,      0, 0x26cb,      0,      0,      0, 0x26cc, 
	0x1493, 0x26cd,      0,      0,      0,      0, 0x26ce, 0x26cf, 
	0x26d0,      0,      0,      0, 0x12cb,      0,      0,      0, 
	0x0c27,      0,      0,      0, 0x2400,      0,      0, 0x2401, 
	0x2402, 0x2403, 0x2404, 0x2405,      0, 0x12d7, 0x2406, 0x03b8, 
	0x12cc,      0, 0x2407, 0x2408, 0x2409, 0x240a,      0, 0x12dd, 
	0x12cd,      0,      0,      0, 0x32d1, 0x32d2,      0, 0x32d3, 
	0x1b61,      0, 0x1b60, 0x32d4,      0,      0, 0x32d5, 0x32d6, 
	0x05b7,      0,      0, 0x32d7, 0x32d8,      0, 0x32d9, 0x32da, 
	0x32db, 0x32dc,      0, 0x1b65,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x2dda,      0,      0, 0x05b4, 
	     0,      0,      0,      0, 0x18c6, 0x18c8, 0x2ddb,      0, 
	0x18c9, 0x04e3, 0x16b3, 0x0866,      0, 0x18ca,      0, 0x2ddc, 
	0x0627, 0x2ddd, 0x2dde,      0,      0, 0x2ddf, 0x18cb, 0x2de0, 
	     0,      0,      0,      0, 0x13de, 0x2589, 0x258a,      0, 
	     0, 0x258b, 0x258c, 0x0d3c, 0x258d,      0, 0x13dc, 0x13e0, 
	0x258e,      0, 0x258f, 0x2590, 0x2591, 0x2592,      0, 0x0609, 
	0x2593, 0x0832,      0,      0, 0x09fc, 0x2594, 0x2595, 0x2596, 
	0x13d6,      0,      0,      0, 0x1eed, 0x1eee,      0,      0, 
	0x05d1, 0x0fc2, 0x0fc0, 0x095a, 0x04e9, 0x0529, 0x1eef, 0x0fbd, 
	     0, 0x0571,      0, 0x1ef0,      0,      0,      0, 0x036b, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x1ef1,      0,      0,      0, 0x00ee,      0, 0x012c,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x03f7,      0, 0x2d65, 0x0873, 
	0x1883,      0, 0x2d66,      0, 0x2d67,      0, 0x2d68,      0, 
	     0,      0, 0x2d69,      0, 0x2d6a, 0x1884,      0, 0x2d6b, 
	     0, 0x1885, 0x2d6c,      0,      0,      0, 0x2d6d,      0, 
	0x2d6e,      0,      0, 0x1f00, 0x071f, 0x0fc8,      0,      0, 
	     0,      0, 0x1f01,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x1f02, 
	0x0fcb,      0, 0x0fd0,      0,      0,      0, 0x0fce, 0x0fcd, 
	0x1f03,      0,      0, 0x2100, 0x2101,      0,      0, 0x2102, 
	     0, 0x2103,      0, 0x2107, 0x10dd, 0x10da,      0, 0x10dc, 
	     0, 0x0de1, 0x2105, 0x10db,      0,      0, 0x2104,      0, 
	     0,      0, 0x2106,      0,      0, 0x10d1,      0,      0, 
	0x2108,      0,      0, 0x0906,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x22df,      0,      0, 0x1223, 
	0x22e0,      0, 0x22e1, 0x22e2, 0x22e3, 0x22e4,      0,      0, 
	     0, 0x0aa5,      0, 0x22e5, 0x22e6, 0x22e7, 0x22e8,      0, 
	0x22e9,      0,      0, 0x2a07, 0x2a08, 0x2a09, 0x2a0a, 0x2a0b, 
	0x1652,      0,      0, 0x0558, 0x0c05, 0x2a0c, 0x2a0d, 0x2a0e, 
	0x0974,      0, 0x0e1d, 0x07fe,      0,      0, 0x1682,      0, 
	0x2a0f, 0x165c, 0x2a10, 0x0927,      0, 0x1658, 0x165d, 0x165f, 
	     0,      0,      0, 0x1811, 0x2ca8, 0x2ca9, 0x2caa, 0x2cab, 
	0x2cac, 0x2cad, 0x2cae,      0, 0x2caf, 0x2cb0, 0x0daa,      0, 
	     0, 0x2cb1,      0,      0, 0x2cb2,      0, 0x2cb3,      0, 
	0x2cb4, 0x2cb5, 0x2cb6,      0,      0,      0,      0, 0x2cb7, 
	0x1810,      0,      0, 0x2326, 0x1245, 0x1244,      0, 0x2327, 
	     0,      0, 0x2328, 0x1224, 0x1246, 0x123a,      0, 0x2329, 
	0x072c,      0, 0x232a,      0,      0, 0x1247, 0x1248, 0x124a, 
	0x1249, 0x124b, 0x0403, 0x232b, 0x064d, 0x232c, 0x232d, 0x0cd1, 
	0x08d8,      0,      0, 0x332f, 0x3330,      0,      0,      0, 
	0x1b9f, 0x1ba0, 0x3331,      0,      0,      0,      0, 0x0aa3, 
	0x3332, 0x3333, 0x3334, 0x3335, 0x0616, 0x3336, 0x1ba2, 0x3337, 
	0x3338,      0, 0x3339, 0x333a, 0x333b,      0,      0,      0, 
	0x333c,      0,      0, 0x073c, 0x2ac2,      0, 0x0539, 0x08f1, 
	0x0e71, 0x0d3f, 0x16e9, 0x08fd, 0x2ac3,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x2ac4, 
	0x2ac5, 0x2ac6,      0, 0x04f2, 0x16ec, 0x2ac7,      0, 0x2ac8, 
	     0,      0,      0, 0x103f,      0,      0, 0x1ff5, 0x1ff6, 
	     0,      0, 0x0ca6, 0x1040, 0x1ff7, 0x1ff8,      0,      0, 
	0x03cb, 0x1041,      0, 0x1ff9, 0x1ffa, 0x1ffb, 0x0dab, 0x0413, 
	     0, 0x0f63, 0x07d7, 0x09a4, 0x1042, 0x0d7c, 0x1ffd,      0, 
	     0,      0,      0, 0x2440,      0,      0, 0x2441,      0, 
	     0,      0, 0x2442, 0x0dbb,      0,      0,      0, 0x2443, 
	     0,      0,      0,      0, 0x0c6d, 0x12fe, 0x09af,      0, 
	0x2444,      0, 0x1304, 0x0946, 0x2445, 0x12fb, 0x1308, 0x1307, 
	     0,      0,      0, 0x014e, 0x014f,      0,      0, 0x014c, 
	0x014d,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x1656, 0x1650,      0,      0, 0x2a00, 
	0x2a01,      0,      0, 0x2a02, 0x1654, 0x07ab, 0x0326, 0x164f, 
	0x1657, 0x165b, 0x0662, 0x0d67, 0x2a03, 0x0a77, 0x1651, 0x2a04, 
	0x2a05, 0x1659, 0x2a06, 0x164e, 0x0a01,      0, 0x1653, 0x0306, 
	0x0d5b,      0,      0, 0x255e,      0,      0, 0x13bc,      0, 
	0x255f, 0x0830,      0,      0,      0, 0x0d9f,      0, 0x13b9, 
	     0,      0, 0x2560, 0x2561, 0x13b4, 0x2562, 0x13ba, 0x2563, 
	0x2564, 0x2565, 0x0e2b,      0, 0x0af2, 0x0b1f,      0,      0, 
	     0,      0,      0, 0x0f66, 0x1e61, 0x0d82,      0,      0, 
	0x1e62, 0x1e63,      0,      0,      0,      0,      0, 0x1e64, 
	     0,      0,      0,      0, 0x1e65, 0x1e66,      0, 0x0f67, 
	     0, 0x0e1f, 0x1e67, 0x0635,      0,      0, 0x1e68,      0, 
	0x05ef,      0,      0, 0x2468,      0,      0, 0x2469,      0, 
	0x1327, 0x1320,      0,      0, 0x132d,      0, 0x132b, 0x246a, 
	0x246b,      0, 0x246c, 0x1326, 0x246d,      0, 0x246e,      0, 
	     0,      0, 0x1325,      0, 0x0a71,      0, 0x096c, 0x246f, 
	0x1323,      0,      0, 0x316a, 0x316b,      0, 0x316c, 0x316d, 
	0x0615,      0,      0, 0x316e, 0x1a9a, 0x316f,      0,      0, 
	0x1a9b, 0x1a9c, 0x1a9d,      0, 0x1a9f, 0x1a9e,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x106d, 0x2057,      0, 0x2058, 0x0c4f, 
	0x2059,      0,      0, 0x106e,      0, 0x1069, 0x205a,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x205b,      0,      0, 0x205c, 0x205d,      0,      0, 0x205e, 
	0x0d4c,      0,      0, 0x0a6f, 0x0b27, 0x0370,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x091b, 0x23ea,      0, 0x08dd, 
	0x0585,      0, 0x23eb,      0,      0,      0, 0x23ec, 0x12c1, 
	0x23ed,      0,      0, 0x317a, 0x1aa5, 0x1aa4, 0x317b, 0x1aa6, 
	     0, 0x317c,      0,      0,      0, 0x317d,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0c0d, 0x16be,      0,      0, 
	0x0874,      0,      0, 0x3186, 0x1aa9,      0, 0x0d70,      0, 
	0x3187, 0x3188, 0x1aaa, 0x0dcb,      0, 0x0369,      0,      0, 
	     0, 0x0714, 0x3189, 0x1aab, 0x03f3, 0x1aac, 0x318a, 0x318b, 
	0x318c, 0x1aad,      0, 0x318d, 0x318e, 0x318f, 0x1aaf, 0x1ab0, 
	0x3190,      0,      0, 0x1e93,      0, 0x1e94,      0, 0x1e95, 
	0x1e96, 0x07af, 0x1e97, 0x07a7, 0x1e98,      0, 0x1e99, 0x1e9a, 
	     0, 0x0f89, 0x0f87,      0, 0x0d34, 0x1e9b, 0x0f84, 0x0f8d, 
	0x0f88,      0,      0,      0, 0x0f8b, 0x05ff, 0x0d50,      0, 
	0x1e9c,      0,      0, 0x2597, 0x2598,      0,      0,      0, 
	0x0d9e, 0x2599,      0,      0, 0x13d9,      0,      0, 0x13d2, 
	0x0af1,      0,      0, 0x13d5, 0x259a,      0,      0, 0x13db, 
	     0,      0,      0,      0, 0x259b,      0, 0x259c, 0x0e7c, 
	0x076f,      0,      0, 0x2797, 0x14eb, 0x2798, 0x14ea,      0, 
	     0,      0,      0,      0, 0x037d,      0,      0,      0, 
	     0,      0, 0x14f3, 0x0c01, 0x14ed, 0x2799, 0x14ef,      0, 
	     0, 0x14f1, 0x0889, 0x279a,      0, 0x14f2, 0x14f0, 0x0771, 
	0x279b,      0,      0, 0x1da1, 0x0ee5, 0x1da2, 0x0ee3, 0x1da3, 
	0x0955, 0x1da4, 0x1da5,      0,      0,      0, 0x0ee4, 0x0ee6, 
	0x1da6,      0, 0x1da7, 0x1db3,      0,      0, 0x0ee8, 0x1da8, 
	     0,      0, 0x0ee7, 0x1da9, 0x0c9d,      0,      0, 0x1daa, 
	     0,      0,      0, 0x18a3, 0x2daf, 0x18a1,      0, 0x2db0, 
	0x0a0f, 0x2db1, 0x2db2, 0x2db3, 0x08ea, 0x0493, 0x18a2,      0, 
	0x08a6,      0, 0x2db4, 0x0e17, 0x2db5, 0x2db6, 0x2db7, 0x0e6b, 
	0x2db8,      0,      0, 0x18a4, 0x18af, 0x0a56, 0x2db9, 0x18ae, 
	0x2dba,      0,      0, 0x32ae, 0x1b4a,      0,      0, 0x1b4b, 
	0x0b1b, 0x1b48, 0x1b47,      0, 0x32ad,      0,      0, 0x03af, 
	     0,      0, 0x32af, 0x1b53,      0,      0, 0x1b52,      0, 
	0x32b0, 0x32b1,      0,      0, 0x039c, 0x32b2, 0x32b3, 0x32b4, 
	0x1b50,      0,      0, 0x06b2,      0,      0, 0x2856, 0x2857, 
	     0,      0, 0x2858,      0,      0, 0x1560, 0x2859, 0x285a, 
	     0,      0, 0x285b, 0x1561,      0, 0x05df, 0x06ca,      0, 
	     0,      0,      0,      0,      0,      0, 0x285c,      0, 
	     0,      0,      0, 0x26b2,      0, 0x26b3, 0x26b4,      0, 
	0x26b5,      0,      0, 0x1487, 0x26b6,      0, 0x26b7,      0, 
	     0,      0,      0, 0x26b8, 0x26b9,      0,      0, 0x1489, 
	0x1486, 0x26ba, 0x26bb,      0, 0x0d65, 0x1488, 0x148a, 0x26bc, 
	0x0e11,      0,      0, 0x10b8, 0x1cdc,      0,      0,      0, 
	     0, 0x1cdd, 0x1cde,      0,      0,      0,      0,      0, 
	     0,      0, 0x0ddf,      0, 0x0b5a, 0x1cdf, 0x1ce0,      0, 
	     0,      0, 0x1ce1,      0,      0,      0,      0, 0x0466, 
	0x1ce2,      0,      0, 0x24b9, 0x24ba, 0x0de2, 0x1354, 0x24bb, 
	0x24bc,      0, 0x24bd, 0x1324,      0,      0,      0,      0, 
	0x24be, 0x24bf, 0x24c0, 0x1357,      0,      0,      0, 0x1358, 
	0x24c1,      0,      0,      0, 0x24c2,      0, 0x035c, 0x24c3, 
	0x135a,      0,      0, 0x0abd, 0x1948,      0,      0,      0, 
	     0, 0x2ea3,      0,      0, 0x194b,      0, 0x2eaa, 0x2ea4, 
	     0, 0x2ea5, 0x2ea6,      0,      0,      0,      0,      0, 
	0x2ea7, 0x0765, 0x2ea8, 0x2ea9, 0x194a, 0x1949, 0x05b5, 0x194c, 
	     0,      0,      0, 0x26bd,      0, 0x26be, 0x148e,      0, 
	0x26bf, 0x26c0, 0x148d, 0x0a39, 0x0b68, 0x26c1,      0, 0x05de, 
	0x148c,      0, 0x26c2, 0x26c3,      0, 0x148b, 0x26c4, 0x0da0, 
	0x0da1,      0,      0, 0x26c5, 0x26c6,      0, 0x26c7, 0x148f, 
	0x0395,      0,      0, 0x15cb,      0, 0x15d8,      0, 0x15ce, 
	0x2937, 0x0507,      0, 0x15cd, 0x15da,      0,      0,      0, 
	0x15cc,      0, 0x083d,      0,      0, 0x2938,      0,      0, 
	     0, 0x15d0, 0x15d1,      0, 0x0aaa,      0,      0, 0x15d2, 
	0x2939,      0,      0, 0x1bcf,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0168,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x1ad4,      0,      0,      0,      0, 
	0x31c1,      0,      0, 0x31c2, 0x31c3, 0x31c4, 0x1acb, 0x1acc, 
	     0, 0x31c5, 0x1acd, 0x1ace,      0, 0x31c6, 0x31c7,      0, 
	     0, 0x1ad0, 0x31c8,      0, 0x1acf,      0, 0x31c9, 0x31ca, 
	0x07e8,      0,      0, 0x10d6, 0x20f7, 0x20f8,      0, 0x20f9, 
	0x20fa,      0, 0x0ccd,      0, 0x20f6,      0,      0,      0, 
	     0,      0, 0x20fb,      0,      0, 0x20fc,      0,      0, 
	     0,      0, 0x20fd,      0,      0,      0, 0x20fe,      0, 
	0x20ff,      0,      0, 0x09db,      0, 0x2718, 0x14a6, 0x2719, 
	     0, 0x271a, 0x271b, 0x271c, 0x271d, 0x271e, 0x271f, 0x2720, 
	0x2721, 0x2722, 0x2723, 0x14a8, 0x0e23, 0x0554, 0x0c15, 0x0b85, 
	     0,      0, 0x2724, 0x14a9,      0,      0,      0,      0, 
	0x14ab,      0,      0, 0x18e0,      0,      0, 0x18e2, 0x2e08, 
	0x2e09,      0, 0x18e1, 0x18e3, 0x2e0a, 0x0cf9, 0x18e4, 0x18e5, 
	     0, 0x2e0b,      0, 0x2e0c, 0x2e0d, 0x18e6,      0,      0, 
	     0, 0x18e8, 0x2e0e,      0, 0x2e0f, 0x2e10, 0x0410, 0x0a88, 
	     0,      0,      0, 0x1de0,      0, 0x08d1, 0x0f15, 0x07e9, 
	     0, 0x1de1, 0x0f16,      0, 0x0a3f, 0x0e0c, 0x0adf,      0, 
	0x1de2,      0, 0x1de3, 0x1de4, 0x1de5,      0, 0x1de6, 0x0f5f, 
	     0, 0x1de7,      0,      0, 0x0f17, 0x1bbb, 0x0542, 0x1de8, 
	     0,      0,      0, 0x1ae2,      0, 0x1ae4, 0x1ae3,      0, 
	     0,      0, 0x1ae5, 0x1ae7, 0x1ae6,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x02e9,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x02df,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x21ed,      0, 0x21ee, 0x085d, 0x117d, 
	0x0b34, 0x21ef, 0x21f0, 0x21f1, 0x21f2,      0,      0, 0x21f3, 
	0x21f4,      0, 0x0e72,      0, 0x1179, 0x21f5, 0x21f6,      0, 
	     0, 0x117f, 0x21f7, 0x0692, 0x21f8, 0x08f4, 0x21f9, 0x21fa, 
	0x031d,      0,      0, 0x11f0,      0, 0x2279, 0x09f7, 0x11ea, 
	0x11f1, 0x11ec, 0x11f3, 0x11ef,      0, 0x11ee, 0x0baa, 0x227a, 
	0x11e8, 0x0402, 0x11e6, 0x0510, 0x09d8, 0x11e2, 0x227b, 0x227c, 
	0x11e5, 0x064b, 0x0904, 0x227d, 0x0824, 0x11ed, 0x0b8d,      0, 
	     0,      0,      0, 0x04f1, 0x0914, 0x076d, 0x0d97, 0x1095, 
	     0, 0x20a3, 0x20a4,      0,      0, 0x20a5, 0x20a6, 0x04fb, 
	0x20a7, 0x06c0, 0x20a8, 0x20a9, 0x0415, 0x038a, 0x0819, 0x03cd, 
	0x20aa, 0x1096, 0x0db5, 0x20ab,      0, 0x20ac,      0,      0, 
	0x07d8,      0,      0, 0x0df2, 0x0b4e,      0,      0,      0, 
	     0, 0x0352, 0x30f4, 0x090c, 0x0767,      0,      0,      0, 
	0x30f5, 0x0c8c, 0x30f6, 0x0367,      0,      0,      0, 0x0e3a, 
	0x0dda,      0, 0x1a59, 0x30f7, 0x0ac4,      0,      0,      0, 
	     0,      0,      0, 0x1df8,      0, 0x0bd6, 0x0ca1,      0, 
	0x0f23, 0x1df9, 0x0de7, 0x0f24,      0,      0,      0, 0x0f25, 
	     0, 0x0afd, 0x1dfa, 0x1dfb, 0x0f26,      0, 0x1dfc, 0x08d2, 
	0x06f3, 0x05cf, 0x0f27, 0x071c, 0x0686, 0x1dfd,      0,      0, 
	     0,      0,      0, 0x0efa,      0, 0x1dcf, 0x0b5b, 0x1dd0, 
	     0, 0x093b, 0x0efc, 0x0efd, 0x0bc5, 0x0631, 0x0e66, 0x0efe, 
	     0,      0, 0x0523,      0,      0,      0, 0x0c91, 0x099b, 
	0x056e, 0x0ab4,      0,      0,      0, 0x05ce,      0, 0x1dd1, 
	     0,      0,      0, 0x32fc,      0,      0,      0,      0, 
	0x32fd,      0,      0, 0x32fb,      0,      0,      0, 0x32fe, 
	     0, 0x32ff, 0x3300, 0x3301,      0,      0, 0x3302, 0x3303, 
	     0,      0, 0x3304, 0x1b78, 0x1b79, 0x3305, 0x3306, 0x1b7a, 
	     0,      0,      0, 0x24fd,      0, 0x24fe, 0x24ff,      0, 
	     0, 0x1385, 0x2500,      0,      0,      0, 0x2501, 0x2502, 
	0x0734, 0x2503, 0x0d42, 0x2504, 0x1386, 0x1387,      0,      0, 
	0x04c3,      0, 0x2505,      0, 0x1388,      0,      0,      0, 
	0x2506,      0, 0x0900,      0, 0x1917, 0x2e52, 0x2e53,      0, 
	0x2e54, 0x0612,      0, 0x1914, 0x1915, 0x2e55,      0,      0, 
	0x0e54, 0x2e56, 0x2e58, 0x2e59, 0x0a58, 0x2e5a, 0x0930,      0, 
	     0,      0,      0,      0,      0, 0x1918, 0x2e5b,      0, 
	0x191b,      0, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 
	0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f, 
	0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 
	0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f, 
	0x0020,      0, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 
	0x0208, 0x0209, 0x020a, 0x020b, 0x020c, 0x020d, 0x020e, 0x020f, 
	0x0210, 0x0211, 0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217, 
	0x0218, 0x0219, 0x021a, 0x021b, 0x021c, 0x021d, 0x021e, 0x021f, 
	0x0220,      0, 0x0404, 0x06a7, 0x1b0b, 0x1b0a, 0x0d36,      0, 
	     0, 0x322c,      0,      0, 0x322d, 0x322e, 0x1b0d, 0x1b0e, 
	0x1b0c,      0, 0x1b0f,      0,      0, 0x0d15, 0x322f, 0x3230, 
	0x3231, 0x1b10,      0, 0x051a, 0x3232,      0,      0, 0x3233, 
	     0,      0, 0x1a05,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x1a03,      0,      0, 0x307c, 
	0x307d,      0, 0x307e, 0x307f, 0x3080, 0x3081, 0x1a04, 0x1a02, 
	     0, 0x09dd,      0, 0x1a06, 0x3082,      0, 0x3084,      0, 
	0x3083,      0, 0x3105, 0x1a6c, 0x3106, 0x1a69,      0, 0x1a6a, 
	     0, 0x1a6b, 0x1a6d, 0x3107,      0,      0,      0, 0x3108, 
	0x3109,      0,      0, 0x08ed,      0,      0, 0x310a, 0x0d88, 
	0x310b, 0x310c, 0x08ee, 0x310d, 0x310e, 0x1a6e,      0, 0x0c0c, 
	     0,      0, 0x1a07,      0, 0x3085, 0x1a09, 0x3086,      0, 
	     0, 0x3087,      0, 0x3088,      0, 0x3089,      0,      0, 
	     0,      0, 0x0496, 0x1a08, 0x0d8b,      0, 0x308a,      0, 
	     0,      0, 0x308b, 0x1a14, 0x1a0a, 0x308c,      0, 0x1a0d, 
	0x308d,      0, 0x1009, 0x1f79,      0, 0x069a, 0x1f7a, 0x09f6, 
	0x1f7b, 0x1f7c, 0x1006, 0x0a7b, 0x1f7d,      0, 0x1f7e, 0x1f7f, 
	0x1f80, 0x1f81, 0x1f82,      0, 0x1f83, 0x1f84, 0x1f85,      0, 
	0x1f86,      0, 0x1f87, 0x1f88, 0x1f89, 0x1f8a,      0, 0x1f8b, 
	0x100a,      0, 0x1909, 0x2e33,      0, 0x2e34, 0x0a57,      0, 
	     0, 0x2e35,      0, 0x0382,      0,      0, 0x2e36,      0, 
	     0, 0x2e37, 0x2e38,      0,      0,      0, 0x2e39,      0, 
	     0,      0, 0x190a,      0,      0,      0,      0, 0x2e3a, 
	0x2e3b,      0, 0x0d0a, 0x09d9,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0d2a,      0,      0, 0x13a0, 
	     0, 0x252d, 0x13a1, 0x252e, 0x03d4, 0x252f,      0,      0, 
	     0, 0x0c7d, 0x0d8e, 0x13a3, 0x0754, 0x082f, 0x139c, 0x13a2, 
	0x038f,      0, 0x0e0b,      0, 0x1ccd, 0x1cce,      0, 0x0c97, 
	     0, 0x1ccf,      0, 0x0e82, 0x1cd0,      0, 0x0a29, 0x1cd1, 
	0x1cd2, 0x1cd3, 0x0e83, 0x0577,      0,      0, 0x1cd4, 0x0e84, 
	     0, 0x049e, 0x09f3,      0, 0x0798, 0x0e85,      0,      0, 
	0x0e86,      0, 0x110c, 0x110d, 0x0b8c,      0,      0, 0x215e, 
	     0, 0x110e, 0x0e44, 0x0e58, 0x2160, 0x215f,      0, 0x2161, 
	0x1110, 0x110f, 0x2162, 0x2163, 0x042a, 0x2164, 0x2165, 0x1111, 
	     0,      0,      0, 0x1114, 0x1115, 0x2166, 0x1113, 0x2167, 
	0x0c37,      0, 0x060d, 0x073b,      0,      0, 0x0c07, 0x2aab, 
	0x2aac,      0, 0x05e3, 0x0cf6, 0x2aad, 0x16e1, 0x16df,      0, 
	0x0665,      0, 0x0666, 0x0332,      0, 0x06dd,      0,      0, 
	     0, 0x2aae, 0x2aaf, 0x0b94,      0,      0,      0,      0, 
	     0,      0, 0x0e0f, 0x240b, 0x12d4, 0x240c, 0x0b9a, 0x240d, 
	     0, 0x240e,      0,      0,      0,      0, 0x12dc,      0, 
	0x12cf,      0,      0,      0, 0x02fd, 0x12d1,      0, 0x240f, 
	0x0653, 0x2410,      0, 0x2411, 0x12d3, 0x2412, 0x12d2,      0, 
	0x12ce,      0, 0x130f,      0, 0x1317,      0, 0x2463,      0, 
	0x1bb8, 0x2464,      0, 0x1314, 0x0654, 0x0a69, 0x096b, 0x1312, 
	     0, 0x130d, 0x2465,      0, 0x1310,      0,      0, 0x2466, 
	0x2467, 0x0dbc, 0x0d1d,      0,      0,      0, 0x1315, 0x131f, 
	     0,      0, 0x2b0f, 0x2b10,      0,      0,      0,      0, 
	     0, 0x2b11, 0x1725, 0x0669, 0x1726, 0x0be5,      0, 0x1734, 
	     0,      0,      0, 0x2b12, 0x1728, 0x2b13, 0x09ae, 0x0bb0, 
	0x05f8, 0x1727, 0x092c, 0x2b14,      0,      0,      0,      0, 
	     0,      0, 0x1513, 0x1514,      0, 0x27d8, 0x27d9,      0, 
	0x1518, 0x1515, 0x1516, 0x1517,      0, 0x1519, 0x27da, 0x27db, 
	0x27dc, 0x151a, 0x27dd, 0x151b,      0, 0x27de,      0, 0x151c, 
	     0, 0x151d,      0, 0x0bc8, 0x0acf, 0x151e, 0x0bad, 0x0c2b, 
	     0,      0, 0x2114, 0x10e3, 0x2115, 0x10e2,      0,      0, 
	0x10e1, 0x2116,      0, 0x2117, 0x0ae7, 0x10cc,      0,      0, 
	     0, 0x10e9,      0, 0x2118, 0x2119, 0x211a, 0x211b,      0, 
	     0,      0, 0x211c,      0, 0x211d,      0, 0x10e5,      0, 
	0x211e,      0, 0x1a17,      0, 0x3098, 0x3097,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x0518, 0x0c31,      0, 0x25b7,      0, 0x0770, 
	     0, 0x25b8, 0x068e, 0x25b9,      0, 0x25ba, 0x25bb,      0, 
	0x0e5e,      0, 0x13f6,      0, 0x1402, 0x0390, 0x096d, 0x25bc, 
	     0, 0x25bd,      0, 0x25be, 0x25bf,      0,      0,      0, 
	     0,      0, 0x2219, 0x1198,      0, 0x1199, 0x221a, 0x221b, 
	0x118e, 0x074f, 0x221c, 0x1192, 0x09bb, 0x0649, 0x1180, 0x0880, 
	     0,      0,      0,      0, 0x11a6,      0, 0x0cbe,      0, 
	     0, 0x119c, 0x119d, 0x119e,      0,      0, 0x11a5, 0x221d, 
	0x11a4,      0, 0x261d,      0,      0,      0, 0x261e, 0x261f, 
	     0,      0, 0x0e52, 0x08b1,      0,      0,      0, 0x0391, 
	     0,      0,      0, 0x1436,      0, 0x2620, 0x2621, 0x2622, 
	0x2623, 0x2624, 0x1435,      0, 0x2625,      0,      0,      0, 
	     0,      0, 0x1d22, 0x1d23, 0x0467, 0x1d24, 0x1d25, 0x0eb2, 
	     0, 0x0eaa, 0x1d26, 0x1d27, 0x0e30, 0x1d28, 0x074b, 0x1d29, 
	0x0eab, 0x1d2a, 0x0eb0, 0x1d2b, 0x1d2c, 0x1d2d,      0, 0x0eb3, 
	0x1d2e, 0x0eac, 0x1d2f, 0x1d30, 0x051e,      0, 0x0316, 0x1d31, 
	0x1d32,      0, 0x2d23, 0x1852,      0, 0x1857,      0, 0x2d24, 
	0x0c78,      0,      0, 0x1859,      0, 0x1858, 0x2d25, 0x2d26, 
	0x2d27, 0x044f,      0, 0x0cde, 0x185a,      0, 0x2d28, 0x2d29, 
	     0, 0x2d2a, 0x2d2b, 0x2d2c,      0, 0x2d2d, 0x1866, 0x185c, 
	     0,      0, 0x0624,      0,      0,      0,      0, 0x1568, 
	0x0a97,      0,      0, 0x2877,      0, 0x156b, 0x041a, 0x1566, 
	0x2878,      0, 0x0c03,      0, 0x0357, 0x2879, 0x06e1,      0, 
	0x0e7d, 0x287a,      0, 0x156a,      0,      0, 0x287c, 0x287d, 
	0x287e,      0, 0x1b26, 0x1b23, 0x1b22, 0x1b24, 0x3269,      0, 
	0x326a, 0x05ba,      0, 0x326b, 0x326c,      0,      0,      0, 
	0x326d, 0x1b2a, 0x1b29, 0x1b28, 0x326e,      0, 0x02fc,      0, 
	0x326f, 0x3270, 0x3271, 0x3272,      0,      0, 0x3273,      0, 
	0x3274,      0, 0x0b28, 0x1339,      0, 0x248d,      0, 0x133b, 
	0x248e,      0,      0, 0x248f,      0,      0,      0,      0, 
	     0,      0, 0x2490, 0x1335, 0x2491,      0,      0,      0, 
	     0, 0x1337,      0,      0,      0,      0,      0, 0x2492, 
	0x0443,      0, 0x2e28,      0, 0x2e29, 0x18f9, 0x18fa,      0, 
	0x18fc, 0x0988, 0x2e2a, 0x18fb, 0x04a7,      0, 0x18fe,      0, 
	0x18fd, 0x18ff,      0, 0x2e2b, 0x1901, 0x1903,      0, 0x1904, 
	0x2e2c,      0,      0,      0, 0x2e2d,      0,      0,      0, 
	     0,      0, 0x182c, 0x182b, 0x17e6,      0,      0,      0, 
	0x1830, 0x2ce9,      0,      0,      0,      0, 0x2cea, 0x2ceb, 
	     0, 0x2cec, 0x182d, 0x2ced,      0,      0, 0x2cee, 0x182e, 
	     0,      0, 0x182f, 0x2cef, 0x1831, 0x2cf0,      0,      0, 
	     0,      0, 0x202d,      0, 0x202e, 0x202f,      0, 0x105c, 
	     0, 0x2030, 0x0723, 0x2031, 0x0722,      0, 0x2032,      0, 
	     0, 0x0302, 0x0601, 0x2033, 0x08d4, 0x031a,      0,      0, 
	     0,      0, 0x1060, 0x1061,      0, 0x105e, 0x2034, 0x2035, 
	0x2036,      0, 0x1330, 0x1349, 0x1348,      0,      0, 0x24a7, 
	     0, 0x24a9, 0x24a8,      0,      0, 0x24aa,      0,      0, 
	     0, 0x24ab, 0x134e,      0, 0x0e51, 0x24ac, 0x24ad, 0x24ae, 
	     0,      0,      0, 0x1351, 0x0578, 0x24af, 0x24b0, 0x134d, 
	0x134f,      0, 0x3130,      0, 0x1a85, 0x3131, 0x3132, 0x1a86, 
	0x3133, 0x1a87, 0x3134, 0x3135, 0x1a88, 0x3136, 0x3137, 0x3138, 
	     0, 0x3139, 0x313a,      0, 0x049b, 0x313b,      0,      0, 
	0x313c, 0x313d, 0x313e,      0, 0x3142, 0x1a89, 0x313f, 0x3140, 
	     0,      0, 0x0333,      0, 0x2f22, 0x2f23, 0x2f24,      0, 
	0x2f25, 0x2f26,      0, 0x0670,      0, 0x2f20,      0, 0x0e65, 
	     0,      0,      0, 0x2f2f,      0,      0, 0x2f27,      0, 
	0x2f28, 0x2f29, 0x2f2a,      0, 0x19a0, 0x2f2b, 0x2f2c,      0, 
	0x2f2d,      0, 0x1933, 0x2e87, 0x2e88, 0x1936, 0x1935,      0, 
	0x1934,      0, 0x2e89, 0x1938, 0x1937,      0, 0x0d87,      0, 
	     0, 0x2e8a, 0x193a, 0x2e8b, 0x1939, 0x193b, 0x2e8c,      0, 
	     0,      0, 0x193c, 0x2e8d, 0x2e8e,      0, 0x2e8f, 0x2e90, 
	     0,      0, 0x0534, 0x2530,      0, 0x1399, 0x139e, 0x2531, 
	     0,      0, 0x091d, 0x0bac,      0, 0x0c00, 0x2532,      0, 
	0x2533, 0x2534, 0x2535, 0x2536, 0x139b, 0x2537, 0x0cd4, 0x2538, 
	0x139d,      0, 0x13a6, 0x2539, 0x13a4, 0x253a, 0x139f,      0, 
	     0,      0, 0x1a34, 0x30c0,      0, 0x30c1, 0x30c2, 0x30c3, 
	     0, 0x1a35,      0, 0x06da,      0, 0x30c4,      0, 0x1a36, 
	0x1a37,      0, 0x30c5, 0x0cfc, 0x30c6,      0,      0,      0, 
	0x30c7, 0x30c8, 0x30c9, 0x30ca, 0x0952, 0x30cb, 0x30cc,      0, 
	0x02ed,      0, 0x3234,      0, 0x3235,      0, 0x3236, 0x3237, 
	     0, 0x3238,      0, 0x3239, 0x323a, 0x323b, 0x323c, 0x323d, 
	0x0e50,      0,      0,      0, 0x323e, 0x1b11, 0x323f,      0, 
	0x3240, 0x3241, 0x3242,      0,      0,      0,      0,      0, 
	0x3243,      0, 0x2a35, 0x2a36,      0,      0, 0x2a37, 0x166e, 
	0x1676,      0, 0x167e, 0x167d, 0x2a38,      0, 0x0d2d, 0x2a39, 
	0x2a3a, 0x0586,      0,      0, 0x2a3b,      0,      0,      0, 
	     0, 0x2a3c, 0x167c,      0, 0x1680, 0x167f, 0x1683, 0x2a3d, 
	0x1685,      0, 0x0b38, 0x08b6, 0x2eff, 0x2f00, 0x0a1c,      0, 
	0x0575,      0, 0x1988, 0x0da6, 0x0366, 0x2f01, 0x0cac, 0x03e6, 
	0x1983, 0x1984, 0x1985, 0x1986, 0x0b18, 0x09e6, 0x032c, 0x198a, 
	     0, 0x198b, 0x1bb9,      0, 0x2f02, 0x09a2, 0x2f03, 0x198c, 
	     0,      0, 0x1b39, 0x3280, 0x3281, 0x1b38, 0x1b37, 0x3282, 
	0x3283, 0x3284, 0x3285, 0x3286,      0,      0, 0x0c40, 0x1b35, 
	0x033c, 0x1b3a, 0x3287, 0x1b3c,      0,      0, 0x3288, 0x3289, 
	0x328a,      0, 0x0452, 0x1b27, 0x035e,      0, 0x328b, 0x1b3e, 
	     0,      0, 0x233a, 0x1256, 0x1257,      0, 0x233b,      0, 
	0x0c8d, 0x1091, 0x08ef, 0x233c,      0, 0x0c43,      0, 0x06cd, 
	     0, 0x0bfe, 0x0bdc, 0x233d,      0,      0, 0x233e,      0, 
	0x0acc, 0x233f, 0x0e0e,      0, 0x1259, 0x0781, 0x2340,      0, 
	0x125a,      0, 0x053d, 0x3067,      0, 0x19fb, 0x19f5, 0x3068, 
	0x3069, 0x19f4,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x306b, 0x306c, 0x306a, 0x306d, 0x306e,      0, 0x306f,      0, 
	     0,      0, 0x193e, 0x2e91,      0,      0,      0,      0, 
	0x2e92,      0, 0x2e93, 0x193d, 0x0893, 0x193f, 0x2e94, 0x2e95, 
	0x056a, 0x1940, 0x1942,      0, 0x2e96,      0, 0x2e97,      0, 
	     0,      0,      0, 0x2e98, 0x2e99,      0,      0, 0x1943, 
	     0,      0, 0x2a3e, 0x070f, 0x1681,      0,      0, 0x2a3f, 
	0x2a40, 0x1686, 0x1687, 0x2a41,      0, 0x1688, 0x2a42, 0x168e, 
	0x0aba, 0x168a, 0x2a43, 0x1689, 0x168b, 0x168c, 0x2a44, 0x168d, 
	     0, 0x2a45,      0, 0x2a46, 0x168f, 0x1690, 0x2a47, 0x2a48, 
	     0,      0, 0x2c40, 0x17d0,      0,      0,      0,      0, 
	0x2c41,      0, 0x2c42,      0,      0,      0, 0x0de5,      0, 
	0x1536, 0x17d2,      0,      0,      0,      0,      0, 0x2c43, 
	     0, 0x2c44,      0, 0x2c45,      0, 0x2c46, 0x2c47,      0, 
	0x17d3,      0, 0x2244, 0x2245, 0x11be,      0, 0x2248, 0x11bd, 
	0x2246,      0, 0x2247,      0,      0, 0x2249, 0x224a,      0, 
	0x224b,      0,      0, 0x0a49,      0, 0x11c1,      0, 0x11bf, 
	0x11b5, 0x05d7,      0, 0x11c0,      0, 0x11c4, 0x11c3, 0x11c5, 
	0x11c2,      0, 0x2646,      0,      0,      0, 0x2647, 0x2648, 
	0x2649,      0, 0x0e48, 0x264a, 0x264b, 0x144a,      0, 0x0922, 
	     0, 0x264c,      0, 0x264d,      0,      0, 0x1446, 0x144b, 
	0x264e,      0, 0x0393, 0x264f,      0, 0x2650,      0, 0x2651, 
	     0,      0, 0x084a, 0x18dc, 0x2dfd, 0x2dfe,      0, 0x2dff, 
	     0, 0x2e00, 0x2e01, 0x0682, 0x0e8c, 0x18dd, 0x2e02,      0, 
	     0,      0,      0,      0, 0x2e03,      0, 0x2e04, 0x2e05, 
	     0, 0x18de, 0x0c36, 0x18df, 0x2e06, 0x18e7,      0, 0x2e07, 
	     0,      0, 0x054b, 0x0584, 0x1619,      0,      0, 0x29ac, 
	0x29ad,      0, 0x0c89,      0, 0x08b3,      0, 0x0d41,      0, 
	0x29ae, 0x161a,      0, 0x0e00,      0, 0x29af, 0x0baf,      0, 
	0x094d, 0x0b6f,      0,      0, 0x07dc,      0,      0, 0x29b0, 
	0x0309,      0, 0x334b,      0, 0x334c, 0x334d, 0x334e, 0x334f, 
	0x3350,      0,      0, 0x1ba6, 0x158f,      0,      0, 0x1900, 
	0x1a8b,      0,      0, 0x1ba7, 0x3351, 0x1ba8, 0x3352, 0x3353, 
	0x3354, 0x3355,      0, 0x3356,      0,      0, 0x3357, 0x3358, 
	0x1baa,      0, 0x304d,      0, 0x304e, 0x304f,      0, 0x3050, 
	0x041e, 0x3051, 0x3057,      0, 0x3052, 0x19ee, 0x19ef, 0x0a64, 
	     0, 0x19ed,      0,      0,      0, 0x3053, 0x3054, 0x3055, 
	     0,      0, 0x19f1, 0x3056,      0,      0,      0,      0, 
	     0,      0, 0x0750, 0x11f8, 0x2283, 0x2284,      0,      0, 
	0x072b, 0x11f9, 0x030d, 0x2285, 0x2286, 0x11f4, 0x2287,      0, 
	     0, 0x2288, 0x0a4a,      0, 0x2289,      0,      0, 0x228a, 
	     0, 0x228b, 0x0512,      0,      0,      0,      0,      0, 
	0x0531,      0, 0x0652, 0x045f,      0,      0,      0,      0, 
	0x23ef, 0x23ee, 0x12c3, 0x0457, 0x12c9, 0x23f0, 0x23f1,      0, 
	0x23f2, 0x23f3, 0x23f4, 0x12c6, 0x23f5, 0x091c,      0,      0, 
	     0, 0x042e, 0x06a1,      0, 0x23f6, 0x042d, 0x06c4,      0, 
	0x23f7,      0, 0x1b54, 0x32be, 0x32bf, 0x1b51, 0x32bc, 0x1b57, 
	0x32c0, 0x1b58,      0, 0x32c1,      0,      0,      0,      0, 
	     0, 0x1b5d, 0x1b5c,      0, 0x32c2, 0x32c3,      0,      0, 
	     0,      0, 0x1b5e,      0,      0, 0x0354, 0x1b59, 0x1b5a, 
	0x32c4,      0, 0x1056, 0x0b5c, 0x0bf7, 0x0d62,      0,      0, 
	     0,      0,      0, 0x0b60, 0x201c, 0x201d, 0x105f, 0x201e, 
	     0,      0,      0, 0x201f, 0x04d7,      0, 0x2020, 0x0db4, 
	0x2021,      0, 0x0d40,      0, 0x10be,      0, 0x1057,      0, 
	0x2022,      0, 0x0758,      0,      0,      0, 0x1576, 0x1571, 
	0x288a, 0x288b, 0x288c, 0x1577, 0x1572, 0x288d,      0, 0x288e, 
	     0, 0x0bf1, 0x1570, 0x288f, 0x2890, 0x1573, 0x2891, 0x2892, 
	     0,      0,      0, 0x157a, 0x2894,      0,      0,      0, 
	0x2895,      0, 0x2558,      0, 0x13b3, 0x13b5, 0x2559, 0x0361, 
	0x255a,      0, 0x0657, 0x0e5d,      0, 0x0420,      0, 0x0c59, 
	0x255b, 0x255c,      0,      0,      0, 0x0dd0,      0,      0, 
	0x0407, 0x0886, 0x13b7,      0,      0, 0x255d,      0,      0, 
	     0,      0, 0x3058,      0, 0x19f7, 0x3059, 0x305a, 0x305b, 
	0x305c, 0x19fa, 0x305d, 0x305e, 0x305f, 0x3060, 0x3061,      0, 
	     0, 0x19f9, 0x0aac,      0, 0x3062,      0,      0, 0x19f2, 
	0x19f3, 0x19f6, 0x3063,      0,      0, 0x3064, 0x19f8, 0x3065, 
	0x3066,      0, 0x2e5c,      0,      0, 0x2e5d, 0x2e5e, 0x2e5f, 
	     0, 0x1919, 0x191a, 0x0dc8, 0x2e60,      0,      0,      0, 
	0x0b04, 0x191e, 0x2e61,      0,      0, 0x2e62,      0, 0x2e63, 
	     0,      0,      0,      0,      0,      0, 0x191c, 0x191d, 
	0x191f,      0, 0x2f5e, 0x08a8, 0x19a9, 0x2f5f, 0x19aa,      0, 
	0x2f60,      0, 0x19ab, 0x0dde,      0, 0x07c6, 0x2f61,      0, 
	     0,      0,      0, 0x19ad, 0x19ac, 0x2f62, 0x0671,      0, 
	0x068a, 0x0713, 0x2f63, 0x2f64, 0x2f65,      0,      0,      0, 
	     0,      0, 0x125f, 0x2349, 0x125d, 0x1260, 0x0e06, 0x125e, 
	     0, 0x234a, 0x234b,      0, 0x0924, 0x1261,      0, 0x234c, 
	0x0997, 0x234d,      0, 0x1262,      0, 0x234e,      0, 0x234f, 
	0x04bb, 0x2350, 0x1264,      0, 0x1263,      0,      0,      0, 
	0x2351,      0, 0x2b60, 0x2b61, 0x1762,      0,      0,      0, 
	     0, 0x033a,      0,      0, 0x1759, 0x2b62, 0x2b63, 0x2b64, 
	0x1758, 0x2b65, 0x1753, 0x1752, 0x2b66, 0x1750, 0x174f, 0x0a26, 
	0x2b67, 0x09e0, 0x1755, 0x2b68,      0, 0x2b69, 0x2b6a,      0, 
	     0,      0, 0x2c64,      0, 0x17db, 0x0b7d,      0, 0x2c65, 
	0x2c66, 0x2c67, 0x17dc, 0x17dd, 0x17e7,      0, 0x2c68,      0, 
	0x17e1, 0x17e4, 0x2c69,      0, 0x2c6a, 0x2c6b, 0x2c6c, 0x17e0, 
	0x2c6d, 0x2c6e, 0x2c6f,      0,      0,      0,      0,      0, 
	0x2c70,      0, 0x2f66, 0x19b0, 0x2f67,      0, 0x2f68, 0x2f69, 
	0x07f5,      0, 0x19af, 0x2f6a, 0x19ae,      0, 0x09ce, 0x2f6b, 
	     0, 0x0628, 0x2f6c, 0x08ec, 0x2f6d, 0x2f6e, 0x2f6f,      0, 
	0x0bc9, 0x2f70,      0,      0,      0, 0x07c8,      0, 0x2f71, 
	     0,      0, 0x116a, 0x21d9, 0x116d, 0x116f,      0, 0x21da, 
	     0, 0x21db, 0x076e, 0x21dc, 0x1175, 0x0a91, 0x116b, 0x21dd, 
	     0,      0, 0x21de, 0x1173, 0x21df, 0x03fe, 0x21e0, 0x1171, 
	0x1172, 0x21e1,      0, 0x116e, 0x1170,      0, 0x21e2, 0x21e3, 
	0x0620,      0, 0x1b6a, 0x1b70, 0x32e6, 0x1b69,      0, 0x1b6e, 
	0x32e7,      0, 0x32e8, 0x32e9,      0,      0,      0,      0, 
	0x1b6f,      0,      0,      0, 0x1b72, 0x32ea, 0x32eb, 0x32ec, 
	0x32ed,      0, 0x1b71, 0x32ee,      0,      0,      0, 0x32ef, 
	0x32f0,      0, 0x2a6a, 0x2a6b, 0x16ac, 0x058d,      0, 0x2a6c, 
	     0, 0x0929, 0x04e0, 0x2a6d,      0,      0, 0x2a6e, 0x16b0, 
	0x16ad,      0,      0, 0x16ae,      0, 0x2a6f,      0, 0x16b1, 
	     0, 0x16b2, 0x16af,      0,      0, 0x2a70, 0x0350,      0, 
	0x2a71,      0, 0x0c6c, 0x0915,      0, 0x077e, 0x10a5, 0x081a, 
	0x10a6, 0x10a7, 0x031c, 0x099f, 0x089d, 0x20bb, 0x10a8, 0x0b10, 
	0x081b,      0, 0x081c,      0, 0x10a9,      0,      0, 0x0916, 
	0x20bc,      0,      0, 0x081d,      0,      0,      0, 0x20bd, 
	0x20be,      0, 0x3070, 0x3071, 0x19ff, 0x3072,      0,      0, 
	0x1a00, 0x3073, 0x3074,      0,      0,      0, 0x3075, 0x3076, 
	0x3077, 0x1a01,      0,      0, 0x19fe, 0x19fd, 0x3078, 0x3079, 
	0x307a, 0x084f, 0x0b07, 0x19fc,      0,      0,      0,      0, 
	0x307b,      0, 0x2172, 0x2173, 0x2174, 0x2175, 0x0d80, 0x05f2, 
	0x0605, 0x2176, 0x1128,      0, 0x2177, 0x2178, 0x1129, 0x2179, 
	0x112f, 0x217a, 0x0796,      0,      0, 0x217b, 0x0a46, 0x217c, 
	0x052c, 0x112a,      0,      0, 0x217d, 0x0c22, 0x217e, 0x0a09, 
	0x217f,      0, 0x2f72, 0x19b1,      0, 0x084c,      0, 0x2f73, 
	     0, 0x2f74,      0, 0x19b4, 0x19b2, 0x2f75, 0x2f76, 0x2f77, 
	0x19b3, 0x2f78, 0x2f79, 0x2f7a, 0x2f7b, 0x19b6, 0x19b5, 0x2f7c, 
	     0, 0x0867,      0, 0x19b7, 0x2f7d, 0x2f7e, 0x2f7f,      0, 
	0x2f80,      0, 0x0f78, 0x1e82, 0x04e8, 0x0429,      0,      0, 
	     0, 0x067e, 0x04e7, 0x0a80, 0x034c, 0x0b0e, 0x0d4f, 0x0638, 
	0x0de8, 0x0ac6, 0x0637,      0, 0x1e83,      0,      0,      0, 
	     0,      0,      0, 0x1e84, 0x058a,      0, 0x0f81,      0, 
	0x0560,      0, 0x0e79, 0x2c23,      0,      0,      0,      0, 
	0x2c24,      0, 0x17c0, 0x2c25, 0x2c26,      0, 0x0de4, 0x2c27, 
	0x17c2, 0x17c4,      0,      0,      0,      0, 0x17c5,      0, 
	     0, 0x2c29,      0, 0x2c2a,      0, 0x17c8, 0x17c6,      0, 
	0x2c2b,      0, 0x287b,      0, 0x156c, 0x287f,      0,      0, 
	0x0ca0, 0x2880, 0x0902, 0x156e,      0, 0x2881, 0x2882,      0, 
	0x156f, 0x2883, 0x2884, 0x2885, 0x2886,      0, 0x156d,      0, 
	     0,      0,      0, 0x0431, 0x2887, 0x1575, 0x2888, 0x1574, 
	0x2889,      0, 0x317e, 0x04d1, 0x317f,      0, 0x3180, 0x3181, 
	0x3182,      0, 0x1aa7, 0x3183, 0x1aa8,      0, 0x0f46, 0x135f, 
	0x0bec,      0,      0, 0x0344, 0x3184, 0x0304,      0, 0x3185, 
	     0,      0,      0,      0,      0, 0x0747, 0x0ce3, 0x086b, 
	     0,      0, 0x0580, 0x1964, 0x1965, 0x1966, 0x2ed0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x2088, 0x085b,      0,      0, 0x2089,      0, 
	     0,      0,      0, 0x1081,      0, 0x0a7d, 0x208a,      0, 
	     0, 0x036c,      0, 0x107f,      0, 0x2084,      0, 0x1082, 
	     0, 0x208b,      0,      0,      0,      0,      0, 0x1083, 
	     0,      0, 0x1189, 0x2210,      0,      0,      0,      0, 
	0x1191, 0x1190,      0, 0x2211, 0x2212, 0x1195,      0,      0, 
	     0, 0x2213, 0x2214,      0,      0, 0x1196, 0x2215, 0x2216, 
	0x2217,      0, 0x2218,      0,      0, 0x1194, 0x1197, 0x118f, 
	0x1193,      0, 0x1f8c, 0x08ad, 0x1f8d,      0,      0,      0, 
	     0, 0x1008, 0x100b,      0, 0x059a, 0x1f8e,      0,      0, 
	     0,      0,      0,      0, 0x100c, 0x1f8f, 0x1f98,      0, 
	0x1f90,      0, 0x1f91, 0x1f92,      0, 0x1f93, 0x1f94, 0x1f95, 
	0x1f96,      0, 0x328c,      0, 0x328d, 0x328e, 0x328f, 0x1b3d, 
	0x1b3b, 0x09f0, 0x3290, 0x3291,      0,      0,      0, 0x3292, 
	0x3293, 0x3294,      0, 0x0d23, 0x3295, 0x3296,      0, 0x3297, 
	0x0e27, 0x3298,      0, 0x1b3f, 0x3299, 0x32a0, 0x329a, 0x329b, 
	0x329c,      0, 0x028e, 0x1be7, 0x1be8, 0x1be9, 0x1bea, 0x1beb, 
	0x1bec, 0x1bed, 0x1bee, 0x1bef, 0x1bf0, 0x1bf1,      0, 0x1bf2, 
	0x1bf3, 0x0288, 0x0289, 0x028a, 0x028b, 0x028c, 0x028d, 0x028f, 
	0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297, 
	0x0298,      0, 0x058f, 0x199d,      0, 0x199e, 0x2f2e,      0, 
	     0, 0x0c6b,      0,      0, 0x2f31,      0, 0x0437,      0, 
	0x2f32, 0x2f33,      0,      0,      0, 0x2f34, 0x0da8, 0x2f30, 
	0x053c,      0,      0,      0,      0,      0, 0x0ad3, 0x2f35, 
	0x2f36,      0, 0x278f, 0x14e6,      0,      0, 0x2790, 0x14e1, 
	0x14e2,      0, 0x14e5, 0x14e4, 0x0c1c,      0,      0, 0x0949, 
	0x0948, 0x2791, 0x04de, 0x2792, 0x2793, 0x14e7, 0x2794,      0, 
	     0,      0, 0x2795, 0x14e8,      0, 0x2796, 0x14e9,      0, 
	     0,      0, 0x2c8f,      0, 0x2c90,      0, 0x17fe,      0, 
	     0, 0x2c91, 0x17ff,      0,      0,      0,      0, 0x2c92, 
	0x2c93,      0, 0x2c94, 0x2c95,      0, 0x17fa,      0,      0, 
	0x17fc,      0, 0x2c96, 0x2c97, 0x17fd, 0x2c98, 0x2c99, 0x2c9a, 
	0x17fb,      0, 0x1392, 0x138f, 0x0dcf,      0, 0x2523, 0x2524, 
	0x2525, 0x0a61, 0x2526,      0,      0, 0x0b36, 0x1390,      0, 
	     0, 0x1398,      0, 0x1397, 0x057e, 0x2527, 0x2528, 0x03b2, 
	0x2529, 0x252a, 0x06b0, 0x1391, 0x1393, 0x252b,      0,      0, 
	0x252c,      0, 0x2293, 0x2294, 0x2295, 0x2296,      0, 0x2297, 
	     0,      0, 0x098f, 0x2298, 0x2299, 0x06fe, 0x11fe, 0x229a, 
	0x1200, 0x11fc,      0, 0x229b, 0x229c, 0x229d, 0x0cb6,      0, 
	0x0a5e, 0x229e,      0,      0, 0x229f, 0x0963,      0,      0, 
	     0,      0, 0x2b9b,      0, 0x1772, 0x0b17,      0, 0x2b9c, 
	0x1777,      0,      0, 0x2b9d, 0x1774, 0x0cdb, 0x177a, 0x0329, 
	0x2b9e,      0, 0x2b9f,      0, 0x176e,      0, 0x2ba0,      0, 
	     0,      0, 0x2ba1,      0,      0,      0,      0,      0, 
	     0,      0, 0x0c9c, 0x0a5b, 0x0697,      0, 0x0677, 0x07f6, 
	0x314b, 0x08a7,      0, 0x314c,      0, 0x1a91, 0x314e, 0x314f, 
	0x1a90, 0x0db1, 0x04a9, 0x0beb, 0x0b39, 0x3150,      0, 0x3151, 
	0x08c7, 0x0e1b, 0x314d, 0x05b6,      0, 0x3152,      0, 0x3153, 
	     0,      0, 0x129d,      0,      0,      0, 0x23ba, 0x12a0, 
	0x23bb, 0x23bc, 0x08c4,      0,      0, 0x23bd,      0, 0x0dea, 
	0x0312, 0x06d5, 0x09a1,      0, 0x078e, 0x23be, 0x23bf, 0x0860, 
	     0,      0, 0x12a3,      0,      0, 0x0acd, 0x23c0, 0x12a1, 
	0x0990,      0, 0x0c9e, 0x1fe7,      0, 0x1fe5, 0x102f,      0, 
	0x0a08, 0x1fe8,      0, 0x03fa,      0, 0x085a, 0x1fe9, 0x1fea, 
	     0, 0x1feb, 0x1031, 0x1fec, 0x1030, 0x1fed, 0x067f, 0x1fee, 
	0x1032, 0x1034, 0x1033, 0x1fef,      0, 0x1036, 0x1ff0, 0x102b, 
	0x1038,      0, 0x179e,      0,      0,      0,      0, 0x2bc4, 
	     0, 0x2bc5, 0x2bc6, 0x2bc7,      0,      0, 0x1788,      0, 
	0x2bc8,      0, 0x2bc9, 0x045a,      0, 0x2bca,      0,      0, 
	     0, 0x0865, 0x1793, 0x2bcb, 0x1798, 0x097a, 0x2bcc, 0x2bcd, 
	0x1794,      0, 0x009f, 0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 
	0x00a5, 0x00a6, 0x00a7, 0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 
	0x00ad, 0x00ae, 0x00af, 0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 
	0x00b5, 0x00b6, 0x00b7, 0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 
	0x00bd,      0, 0x179f, 0x2be9, 0x2bea, 0x2beb, 0x2bec, 0x0a76, 
	0x2bed,      0,      0, 0x2bee, 0x2bef, 0x17a4, 0x0347,      0, 
	0x2bf0,      0,      0, 0x2bdd, 0x2bf1, 0x2bf2, 0x0987, 0x2bf3, 
	     0,      0,      0,      0,      0,      0, 0x0c98,      0, 
	0x2bf4,      0, 0x26a4, 0x0535, 0x147b, 0x147d,      0, 0x147c, 
	0x26a5,      0, 0x26a6,      0,      0, 0x26a7,      0, 0x147e, 
	     0, 0x060a,      0, 0x147f,      0,      0, 0x26a8, 0x26a9, 
	0x0566, 0x26aa, 0x0947,      0, 0x0694,      0,      0,      0, 
	0x26ab,      0, 0x2aa6,      0,      0, 0x16d9, 0x16db, 0x16da, 
	0x0bbe, 0x2aa7, 0x0b56,      0, 0x0e69, 0x0bc2,      0, 0x2aa8, 
	     0,      0,      0,      0, 0x16dd,      0,      0, 0x0840, 
	     0, 0x0c21,      0, 0x16de, 0x16dc, 0x2aa9, 0x048f, 0x2aaa, 
	     0,      0, 0x1ea8, 0x0f92,      0, 0x0f9b, 0x0f94, 0x1ea9, 
	0x1eaa, 0x0f98, 0x1eab, 0x1eac, 0x0f99, 0x0f95, 0x1ead, 0x1eae, 
	0x0fb6,      0, 0x1eaf, 0x06de, 0x0414,      0,      0,      0, 
	0x1eb0, 0x0f93, 0x1eb1, 0x1eb2, 0x1eb3, 0x0f9d, 0x033f, 0x0f9c, 
	0x1eb4,      0, 0x01af, 0x01b0, 0x01b1, 0x01b2, 0x01b3, 0x01b4, 
	0x01b5, 0x01b6, 0x01b7, 0x01b8, 0x01b9, 0x01ba, 0x01bb, 0x01bc, 
	0x01bd, 0x01be, 0x01bf, 0x01c0, 0x01c1, 0x01c2, 0x01c3, 0x01c4, 
	0x01c5, 0x01c6, 0x01c7, 0x01c8, 0x01c9, 0x01ca, 0x01cb, 0x01cc, 
	0x01cd,      0, 0x0cb0, 0x216a, 0x1121, 0x0e59,      0, 0x216b, 
	0x216c, 0x216d, 0x1122, 0x0c95, 0x1125, 0x0e7f, 0x0e8f, 0x216e, 
	0x0761, 0x0b52, 0x1126,      0, 0x04fc, 0x0a45, 0x0343, 0x1127, 
	0x0c7b, 0x0647, 0x216f,      0, 0x0a13, 0x2170, 0x2171,      0, 
	0x0a90,      0, 0x0bb8,      0, 0x31b9, 0x09b1, 0x037f, 0x056b, 
	     0, 0x056c, 0x31ba,      0,      0,      0,      0,      0, 
	     0, 0x0a36, 0x1aca, 0x056d, 0x31bb, 0x31bc, 0x03f4,      0, 
	     0, 0x1ac9, 0x31bd, 0x31be, 0x1ac7, 0x31bf, 0x1ac8, 0x31c0, 
	0x1ac6,      0, 0x0db9, 0x1231,      0, 0x2305, 0x122d,      0, 
	0x122e,      0, 0x2306, 0x2307, 0x2308, 0x2309, 0x0967, 0x230a, 
	     0, 0x230b, 0x230c, 0x122c,      0, 0x11eb, 0x230d,      0, 
	0x230e, 0x1230,      0, 0x122b,      0,      0,      0,      0, 
	     0,      0, 0x18be, 0x2dce, 0x2dcf, 0x2dd0, 0x2dd1, 0x2dd2, 
	     0, 0x2dd3, 0x18c2,      0,      0, 0x18bf, 0x2dd8, 0x18c1, 
	0x18c0,      0,      0, 0x2dd4, 0x2dd5, 0x2dd6,      0, 0x18c3, 
	     0, 0x0762, 0x2dd7, 0x18c5, 0x18c4, 0x0c5f,      0, 0x2dd9, 
	0x18c7,      0, 0x2bbe, 0x178a,      0, 0x1785, 0x2bbf,      0, 
	     0,      0,      0,      0, 0x0842,      0,      0,      0, 
	     0, 0x07be,      0, 0x2bc0, 0x2bc1, 0x075d, 0x2bc2,      0, 
	     0,      0, 0x0d69,      0,      0, 0x0c3e,      0, 0x2bc3, 
	0x1795,      0, 0x19bf,      0, 0x0a81, 0x2f8a, 0x2f8b, 0x0d08, 
	0x0579,      0, 0x2f8c, 0x2f8d,      0, 0x2f8e, 0x2f8f, 0x2f90, 
	0x2f91, 0x2f92, 0x2f93,      0,      0,      0, 0x19c2, 0x19c3, 
	0x2f94,      0, 0x2f95,      0, 0x2f96, 0x19c1, 0x2f97,      0, 
	0x19c5,      0, 0x0bc1, 0x1103, 0x0c93, 0x1104,      0,      0, 
	     0, 0x2149,      0, 0x214a, 0x214b, 0x214c, 0x214d, 0x214e, 
	     0, 0x214f,      0, 0x0474, 0x0c94, 0x0b6a, 0x1106, 0x1107, 
	     0, 0x0643, 0x0475, 0x1108, 0x05f1, 0x0db3, 0x0d98, 0x04b7, 
	0x110a,      0, 0x0dc6,      0, 0x1871,      0,      0, 0x0c79, 
	0x0b81, 0x1872, 0x2d50, 0x1873, 0x05e4,      0, 0x2d51,      0, 
	0x04cb, 0x2d52,      0,      0, 0x1874, 0x2d53, 0x2d54, 0x073e, 
	0x0b7c, 0x1875,      0, 0x0433, 0x2d55, 0x2d56,      0,      0, 
	0x2d57,      0, 0x0ec7, 0x1d5c, 0x0cc4, 0x0a10, 0x0ec3, 0x05cc, 
	0x1d5d, 0x0ec0, 0x0ec8, 0x0ec2, 0x0e1e, 0x0ec9, 0x0e6c, 0x1d5e, 
	     0, 0x1d5f,      0, 0x1d60, 0x1d61,      0, 0x1d62, 0x0563, 
	     0,      0, 0x05cb,      0, 0x1d7a,      0,      0,      0, 
	     0,      0, 0x23c7,      0,      0, 0x23c8, 0x12af,      0, 
	0x0c13,      0, 0x12a6,      0, 0x12ac, 0x12ab,      0, 0x23c9, 
	0x23ca, 0x08f8, 0x23cb,      0, 0x23cc,      0, 0x0d20, 0x23cd, 
	0x0e20, 0x23ce, 0x23cf, 0x0d1a, 0x23d0, 0x03d1, 0x0731,      0, 
	     0,      0, 0x1bc8, 0x012e, 0x012f, 0x1bd0,      0, 0x1bc9, 
	0x0135, 0x00ec, 0x1bcd, 0x1bcc,      0, 0x0154,      0, 0x1bce, 
	0x1bc2, 0x0128, 0x011b,      0,      0, 0x00ea,      0, 0x016f, 
	     0, 0x1bbf,      0, 0x1bcb,      0,      0,      0,      0, 
	0x1bca,      0, 0x1fca, 0x101f,      0, 0x1fcb,      0,      0, 
	0x1fcc, 0x1fcd, 0x039d,      0, 0x0ab5,      0,      0,      0, 
	     0, 0x1021,      0, 0x101d,      0,      0, 0x089b,      0, 
	     0, 0x1fce, 0x1025,      0,      0, 0x1fcf,      0, 0x07dd, 
	0x1fd0,      0, 0x03cc, 0x1073,      0, 0x2073,      0, 0x2074, 
	     0, 0x2075, 0x076c,      0, 0x1072, 0x05d4,      0,      0, 
	0x2076, 0x1080,      0,      0,      0,      0,      0, 0x1079, 
	0x1076,      0,      0, 0x2077,      0, 0x2078,      0,      0, 
	     0,      0, 0x1ad1, 0x31cb, 0x31cc, 0x31cd, 0x1ad3,      0, 
	     0,      0,      0,      0, 0x31ce, 0x31cf,      0, 0x04d2, 
	0x1ad2, 0x31d0, 0x31d1, 0x0982, 0x05ec,      0,      0, 0x31d2, 
	     0,      0, 0x1ad5,      0,      0,      0,      0, 0x31d3, 
	     0,      0, 0x28d1,      0,      0,      0,      0, 0x0519, 
	0x158e, 0x28d2, 0x28d3, 0x1590, 0x28d4,      0,      0, 0x1591, 
	0x28d5, 0x0b64, 0x28d6,      0, 0x1592, 0x28d7,      0,      0, 
	     0, 0x28d8, 0x1593, 0x1594, 0x28d9,      0, 0x0556, 0x03d8, 
	0x0b22,      0, 0x25d3, 0x25d4,      0, 0x07f0,      0, 0x1413, 
	     0, 0x25d5,      0,      0,      0, 0x25d6, 0x140c, 0x0a4d, 
	0x1409, 0x0a7a,      0,      0,      0, 0x142c,      0,      0, 
	     0, 0x1406,      0, 0x1405,      0, 0x140e, 0x25d7, 0x25d8, 
	     0,      0, 0x30d3, 0x0348, 0x08a3, 0x080b, 0x049a, 0x1a41, 
	     0,      0,      0, 0x0ba1,      0, 0x1a43,      0, 0x30d4, 
	     0, 0x0349,      0, 0x1a42, 0x0a65, 0x30d5, 0x0e1a, 0x0b08, 
	0x1a3c, 0x0df3,      0, 0x05ea, 0x30d6, 0x30d7, 0x0dca, 0x30d8, 
	0x30d9,      0, 0x18d5,      0,      0,      0, 0x2df0, 0x0b03, 
	0x2df1, 0x18d7, 0x2df2, 0x0ce0, 0x2df3, 0x18d8,      0, 0x18d9, 
	0x2df4, 0x18da, 0x2df5,      0, 0x2df6, 0x2df7, 0x18db,      0, 
	0x2df8, 0x2df9, 0x2dfc, 0x0b37, 0x2dfa,      0, 0x2dfb,      0, 
	     0,      0, 0x2cd8,      0, 0x2cd9,      0, 0x180e, 0x2cda, 
	     0,      0, 0x2cdb, 0x2cdc, 0x2cdd,      0, 0x1822, 0x1826, 
	0x1821, 0x2cde, 0x1828, 0x2ce0, 0x2ce1, 0x2ce2, 0x182a, 0x1829, 
	     0, 0x2ce3, 0x2cdf, 0x2ce4, 0x2ce5, 0x2ce6,      0, 0x2ce7, 
	0x2ce8,      0, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x0576, 0x0e01, 
	     0, 0x0583, 0x30de, 0x09c7, 0x16f1,      0, 0x1a44, 0x040f, 
	0x08ba,      0, 0x30df,      0,      0, 0x0439, 0x1a46, 0x30e0, 
	0x1a47, 0x1a45, 0x05bf, 0x30e1, 0x06d2, 0x0850, 0x30e2,      0, 
	0x30e3,      0, 0x0ddc, 0x0305, 0x1647,      0, 0x29ea, 0x050a, 
	0x29eb, 0x1644,      0, 0x29ec,      0,      0,      0, 0x1645, 
	     0, 0x29ed, 0x0afc, 0x1643, 0x1640,      0, 0x040b, 0x090d, 
	     0, 0x29ee, 0x05e1, 0x29ef, 0x29f0,      0, 0x164c,      0, 
	0x29f1,      0, 0x32dd,      0,      0, 0x1b66,      0,      0, 
	     0,      0, 0x1b67, 0x32de, 0x1b62, 0x32df,      0, 0x32e0, 
	0x1b4e,      0, 0x32e1, 0x1b68,      0, 0x0a82, 0x32e2,      0, 
	     0, 0x1b6c, 0x32e3, 0x1b6d, 0x1b6b, 0x32e4,      0,      0, 
	0x32e5,      0, 0x23e3, 0x12ba,      0, 0x12b7,      0, 0x23e4, 
	0x12bf,      0, 0x12b5,      0,      0, 0x12b3,      0, 0x12bb, 
	0x12b1, 0x23e5, 0x0a2f, 0x23e6, 0x0d89, 0x0777, 0x06e9, 0x23e7, 
	0x23e8,      0, 0x23d8,      0, 0x06af,      0,      0, 0x0d22, 
	0x0424,      0, 0x0be4,      0, 0x1672, 0x2a2d, 0x2a2e, 0x166d, 
	0x2a2f,      0,      0, 0x0928, 0x05ad,      0, 0x07ba, 0x2a30, 
	     0, 0x2a31,      0, 0x2a32,      0, 0x0870, 0x093d, 0x1678, 
	     0, 0x2a33, 0x167a, 0x167b,      0,      0, 0x1677, 0x1679, 
	0x2a34,      0, 0x00e7,      0, 0x0131, 0x012d, 0x0130, 0x0132, 
	     0, 0x0107, 0x0108, 0x0133, 0x0119, 0x00e1,      0, 0x00e2, 
	0x00fc, 0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 0x0176, 0x0177, 
	0x0178, 0x0179, 0x017a, 0x00e4, 0x00e5, 0x0120, 0x011e, 0x0121, 
	0x00e6,      0, 0x0df0,      0,      0,      0,      0,      0, 
	0x2d1d, 0x1855,      0,      0,      0,      0,      0,      0, 
	0x2d1e, 0x2d1f, 0x2d20, 0x1856, 0x0845, 0x1854, 0x2d21,      0, 
	0x2d22, 0x0dd6, 0x1851,      0,      0, 0x1853, 0x08e6, 0x08c9, 
	     0,      0, 0x0ef0,      0, 0x1dbb,      0,      0,      0, 
	0x1dbc, 0x1dbd,      0, 0x0d94,      0, 0x1dbe, 0x1dbf,      0, 
	0x1dc0,      0, 0x1dc1, 0x0d6a, 0x1dc2, 0x1dc3, 0x1dc4,      0, 
	0x0ef2, 0x1dc5, 0x1dc6, 0x0ef1, 0x0ef4, 0x0ef3,      0,      0, 
	0x0ef5,      0, 0x1ff1, 0x1ff2,      0, 0x1037, 0x1035,      0, 
	     0,      0, 0x1ff3,      0, 0x0721, 0x089c,      0, 0x095b, 
	0x1039, 0x08e5, 0x0336, 0x0b9f, 0x1ff4,      0,      0,      0, 
	0x0a7c,      0, 0x103b, 0x103a, 0x103c, 0x103d, 0x103e,      0, 
	     0,      0, 0x1ef2,      0, 0x1ef3, 0x0fc6, 0x0fc4, 0x1ef4, 
	0x0ffd,      0, 0x1ef5,      0, 0x1ef6, 0x1ef7,      0, 0x1ef8, 
	     0,      0, 0x1ef9, 0x1efa, 0x1efb, 0x0fc9,      0,      0, 
	0x1efc, 0x1efd,      0, 0x0fc3, 0x1efe, 0x0fc7,      0, 0x1eff, 
	0x0fc5,      0, 0x20f2,      0,      0,      0,      0, 0x20f3, 
	0x08bd,      0,      0,      0, 0x10ce,      0, 0x20f4, 0x06df, 
	     0,      0, 0x10d4, 0x20f5,      0, 0x10d5, 0x10cf, 0x0416, 
	0x10d0, 0x10d9, 0x10d8, 0x10d7, 0x10d3,      0,      0,      0, 
	0x10d2,      0, 0x29f2, 0x29f3, 0x29f4,      0, 0x29f5, 0x29f6, 
	     0, 0x29f7, 0x1649,      0, 0x29f8, 0x29f9, 0x29fa,      0, 
	0x164b,      0, 0x29fb,      0, 0x1648,      0,      0, 0x29fc, 
	0x29fd,      0, 0x05ac, 0x0998, 0x164d, 0x0975, 0x29fe, 0x29ff, 
	0x165a,      0, 0x27f3, 0x152d, 0x0b91,      0, 0x27f4, 0x0d12, 
	     0, 0x0375, 0x27f5, 0x037e, 0x27f6, 0x27f7, 0x152e, 0x27f8, 
	     0,      0,      0, 0x1530,      0, 0x27f9,      0, 0x152f, 
	0x0aef,      0, 0x27fa,      0, 0x08e2, 0x135d,      0, 0x1531, 
	0x0d52,      0, 0x24f4,      0, 0x24f5,      0,      0, 0x24f6, 
	0x24f7,      0,      0,      0, 0x1381, 0x1380,      0, 0x24f8, 
	0x1383,      0, 0x24f9,      0, 0x1382,      0,      0,      0, 
	0x24fa,      0, 0x24fb,      0,      0,      0,      0,      0, 
	0x24fc,      0, 0x13f5,      0,      0,      0, 0x0484,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x25ca,      0, 0x25cb, 0x25cc, 0x25cd, 0x05c4,      0,      0, 
	0x25ce, 0x140f, 0x25cf, 0x25d0, 0x140a, 0x0921, 0x25d1, 0x25d2, 
	0x0446,      0, 0x12f7, 0x12e2, 0x12f6,      0, 0x12ef, 0x12e3, 
	     0, 0x12f3,      0, 0x12f4,      0,      0,      0,      0, 
	     0, 0x1305, 0x243b,      0, 0x243c, 0x0b2b, 0x243d, 0x12ea, 
	     0, 0x243e, 0x1301,      0, 0x243f,      0, 0x1303,      0, 
	0x0a79,      0, 0x0dfb,      0,      0, 0x0861, 0x091e,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x2555,      0, 0x13b8, 0x13b6,      0, 0x0c44,      0, 0x2556, 
	0x2557,      0, 0x22fc,      0, 0x22fd, 0x0ab0, 0x1227, 0x22fe, 
	     0, 0x22ff, 0x1228,      0, 0x0c66, 0x2300, 0x0b80, 0x06f6, 
	     0, 0x091a,      0, 0x0d03, 0x2301,      0,      0,      0, 
	     0,      0, 0x042c,      0, 0x122f, 0x122a, 0x2302, 0x2303, 
	0x2304,      0, 0x1ffe, 0x0d45, 0x1fff, 0x2000, 0x1044,      0, 
	0x09cc, 0x2001, 0x0ab6, 0x09a5, 0x0c4e, 0x1045, 0x1046, 0x03a2, 
	0x2002, 0x2003, 0x076b, 0x1047, 0x2004,      0, 0x2005, 0x2006, 
	0x0319, 0x1048,      0,      0,      0,      0,      0, 0x1049, 
	0x2007,      0, 0x30ff, 0x3100, 0x3101, 0x1a63,      0,      0, 
	0x0d49, 0x3102,      0, 0x1a64,      0,      0,      0,      0, 
	     0, 0x1a65, 0x3103, 0x0e55, 0x3104,      0,      0,      0, 
	     0, 0x1299, 0x1a66,      0,      0,      0, 0x1a67, 0x1a68, 
	     0, 0x2d00, 0x066c, 0x1837, 0x032a, 0x2d01,      0,      0, 
	     0, 0x0c34, 0x2d02,      0, 0x1838,      0,      0,      0, 
	     0, 0x08b5, 0x2d03, 0x183f,      0,      0, 0x183c,      0, 
	0x0a32,      0, 0x2d04,      0, 0x2d05,      0, 0x183d, 0x183a, 
	0x055b, 0x1701,      0, 0x2aea, 0x1704, 0x1703,      0,      0, 
	     0, 0x0cf7, 0x1707,      0,      0,      0,      0, 0x2aeb, 
	     0, 0x1708,      0, 0x2aec, 0x093e, 0x2aed, 0x1709,      0, 
	     0, 0x170b,      0, 0x170f, 0x2aee,      0, 0x170c, 0x170a, 
	0x0b7a, 0x1801, 0x2ca1,      0, 0x180c, 0x2ca2, 0x2ca3, 0x03e1, 
	     0, 0x1808,      0, 0x180d,      0,      0,      0, 0x1809, 
	0x2ca4,      0, 0x2ca5, 0x2ca6,      0, 0x1806,      0, 0x0a54, 
	     0, 0x1803,      0,      0, 0x2ca7,      0,      0,      0, 
	0x0ba3, 0x2c01, 0x2c02, 0x2c03, 0x17aa, 0x2c04,      0,      0, 
	     0, 0x0e7a, 0x0aff, 0x0c6a, 0x2c05,      0, 0x17b7,      0, 
	0x2c06,      0,      0,      0,      0,      0,      0,      0, 
	0x17bd,      0, 0x2c07, 0x2c08, 0x2c09,      0, 0x2c0a, 0x17be, 
	0x2c0b, 0x3202,      0, 0x1af2, 0x1af3, 0x3203, 0x3204, 0x1af4, 
	0x3205,      0, 0x3206, 0x0bca, 0x1af6, 0x3207, 0x0c1d, 0x1af7, 
	0x1af5,      0, 0x1af9, 0x3208, 0x3209, 0x1af8, 0x320a,      0, 
	0x1afa,      0, 0x320b, 0x320c, 0x1afb,      0, 0x320d,      0, 
	0x320e, 0x1203,      0, 0x22ab, 0x0964, 0x22ac,      0,      0, 
	0x22ad, 0x07a9, 0x1208, 0x22ae,      0, 0x0825,      0, 0x1202, 
	0x1207, 0x22af,      0, 0x0b8e,      0, 0x22b0, 0x22b1, 0x1201, 
	     0, 0x057c, 0x22b2, 0x22b3, 0x0440,      0,      0, 0x22b4, 
	0x1209, 0x1004,      0, 0x06d9,      0,      0, 0x1f74, 0x1f75, 
	0x054e,      0,      0, 0x0cea,      0, 0x1f76, 0x1f77, 0x1002, 
	0x1005, 0x06b6, 0x063a, 0x1f78,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x2604,      0,      0, 0x2605,      0,      0, 0x0a38, 
	0x09d2,      0,      0,      0,      0, 0x08ce,      0,      0, 
	0x2606, 0x1430,      0, 0x1432,      0, 0x2607,      0,      0, 
	0x2608,      0, 0x2609,      0,      0, 0x260a,      0, 0x1431, 
	     0, 0x2804, 0x0837,      0,      0, 0x153a,      0, 0x2805, 
	0x1539, 0x1538, 0x0c16, 0x2806, 0x0488, 0x05e2,      0, 0x2807, 
	     0,      0,      0, 0x2808,      0, 0x2809, 0x280a,      0, 
	0x280b,      0, 0x280c, 0x280d, 0x1540, 0x280e,      0, 0x153d, 
	0x088a, 0x1d05,      0,      0, 0x1d17,      0,      0,      0, 
	     0,      0, 0x0eae, 0x1d18,      0, 0x1d19,      0, 0x1d1a, 
	0x0eb1, 0x0eaf, 0x1d1b,      0, 0x03c7,      0, 0x0c90, 0x0ea9, 
	0x1d1c, 0x1d1d, 0x1d1e, 0x1d1f, 0x0ead, 0x062c, 0x1d20, 0x1d21, 
	0x071b, 0x3005, 0x3006,      0, 0x3007, 0x080a, 0x3008,      0, 
	0x3009, 0x300a, 0x19dc, 0x0cb4,      0, 0x300b, 0x037b, 0x300c, 
	     0, 0x300d,      0, 0x0c3d, 0x0a35,      0,      0,      0, 
	     0, 0x0517, 0x300e, 0x19de, 0x300f, 0x0674,      0,      0, 
	0x3010, 0x1e06, 0x1e07,      0, 0x05d0, 0x06d3, 0x0ba8, 0x1e08, 
	     0,      0, 0x0f30, 0x0f2e,      0,      0,      0, 0x1e09, 
	0x0c72, 0x0857, 0x0f37, 0x0447, 0x0f31, 0x0f2f, 0x0956,      0, 
	0x1e0a, 0x1e0b, 0x1e0c,      0,      0,      0, 0x0f33,      0, 
	0x0f32, 0x2d06, 0x1839, 0x1840,      0,      0,      0,      0, 
	     0, 0x0591,      0,      0, 0x09c3,      0, 0x1846,      0, 
	     0,      0,      0, 0x1842,      0,      0,      0, 0x099a, 
	0x1841, 0x2d07, 0x1844, 0x2d08, 0x2d09, 0x2d0a,      0, 0x183b, 
	0x2d0b, 0x1007,      0,      0, 0x1012,      0,      0, 0x1013, 
	0x1f9f, 0x1fa0,      0,      0, 0x0d17, 0x1fa1,      0, 0x0858, 
	0x1fa2,      0,      0, 0x1015, 0x1016, 0x1014, 0x1fa3, 0x1018, 
	     0,      0,      0,      0,      0, 0x0b73, 0x1fa4, 0x1fa5, 
	0x0331, 0x1507, 0x1508, 0x1509, 0x27c1, 0x150a, 0x27c2, 0x27c3, 
	0x1506,      0, 0x27c4,      0,      0,      0, 0x27c5,      0, 
	     0, 0x150c,      0, 0x27c6, 0x27c7, 0x150b, 0x27c8,      0, 
	     0, 0x27c9, 0x27ca, 0x27cb, 0x150d, 0x27cc,      0,      0, 
	     0, 0x2b07, 0x171d, 0x171e, 0x2b08,      0, 0x171f,      0, 
	0x1720, 0x053a, 0x1234, 0x1721,      0, 0x090e, 0x1722, 0x077c, 
	0x2b09, 0x1723,      0, 0x0e8e, 0x2b0a, 0x2b0b,      0, 0x1724, 
	0x0cb3, 0x049d, 0x2b0c, 0x2b0d, 0x092b, 0x07e7, 0x2b0e, 0x0c68, 
	0x07bd, 0x1408, 0x1407, 0x140d, 0x25d9, 0x08ca,      0, 0x1404, 
	0x25da, 0x25db,      0,      0, 0x25dc, 0x25dd, 0x25de, 0x1410, 
	     0, 0x25df, 0x1411, 0x25e0, 0x25e1, 0x25e2,      0, 0x25e3, 
	0x0483,      0,      0, 0x25e4,      0,      0,      0,      0, 
	0x25e5, 0x2109, 0x210a, 0x210b,      0, 0x210c,      0,      0, 
	     0,      0, 0x08be, 0x210d,      0, 0x10de, 0x210e,      0, 
	0x06ac, 0x210f,      0,      0, 0x10df,      0,      0, 0x10e0, 
	     0,      0, 0x2110, 0x2111,      0,      0,      0, 0x2112, 
	0x2113, 0x090a, 0x15f1, 0x296a,      0, 0x0be8, 0x296b, 0x15f5, 
	0x0ca8, 0x296c, 0x0a1e, 0x296d, 0x15f0, 0x15f2,      0,      0, 
	0x15f3,      0,      0,      0,      0, 0x296e,      0, 0x296f, 
	0x2970,      0, 0x2971, 0x2972, 0x2973,      0, 0x15f6,      0, 
	     0, 0x330a, 0x1b7e, 0x330b, 0x330c, 0x330d, 0x330e,      0, 
	0x330f, 0x1b7f,      0,      0, 0x1b80, 0x1b81,      0, 0x3310, 
	0x3311,      0, 0x1b84, 0x1b82, 0x0e67,      0, 0x1b83, 0x3312, 
	0x0e3c, 0x3313,      0,      0, 0x3314,      0, 0x1b85, 0x3315, 
	0x0e28, 0x110b,      0, 0x2153,      0, 0x2154, 0x2155, 0x0ad8, 
	0x06b7, 0x2156,      0, 0x2157, 0x0604, 0x2158, 0x0a8e,      0, 
	     0,      0, 0x2159,      0, 0x215a,      0, 0x030c, 0x07fd, 
	0x0646, 0x0db6,      0,      0,      0,      0, 0x215b, 0x215c, 
	0x215d, 0x1a0b, 0x308e, 0x1a0c, 0x308f,      0,      0,      0, 
	     0, 0x3090,      0, 0x1a0e, 0x3091,      0, 0x3092, 0x3093, 
	0x3094, 0x1a10, 0x3095, 0x3096,      0,      0, 0x1a11,      0, 
	0x1a12,      0,      0,      0,      0, 0x1a15, 0x1a13, 0x1a16, 
	0x1a18, 0x0a0c, 0x2493,      0, 0x2494, 0x1342,      0, 0x2495, 
	0x2496,      0, 0x2497,      0, 0x2498,      0, 0x1340, 0x0622, 
	     0, 0x133f, 0x2499,      0,      0,      0,      0,      0, 
	0x1345,      0,      0,      0, 0x249a, 0x12c0, 0x249b, 0x249c, 
	0x249d, 0x0d0c,      0, 0x0b0f, 0x1fb2, 0x1fb3, 0x05d3, 0x09b4, 
	     0, 0x1fb4, 0x1fb5, 0x1017, 0x101a, 0x1fb7, 0x1fb8,      0, 
	     0,      0,      0,      0,      0,      0, 0x09a9,      0, 
	     0,      0, 0x101b,      0, 0x1fb9,      0, 0x101c, 0x1fba, 
	0x1fbb, 0x1d0c,      0, 0x1d0d, 0x0a72,      0,      0, 0x09e5, 
	0x0ea8, 0x1d0e, 0x1d0f,      0, 0x1d10, 0x1d11, 0x0315, 0x0a84, 
	0x07ca, 0x06a9, 0x0d93, 0x1d12, 0x09b3, 0x1d13, 0x03c4, 0x1d14, 
	0x0ea7, 0x1d15, 0x0dad, 0x0ea3, 0x0ea5, 0x06e3, 0x0ea6, 0x1058, 
	0x1d16, 0x2d0c,      0, 0x1845,      0, 0x1847,      0,      0, 
	     0, 0x2d0d,      0, 0x2d0e, 0x0c08,      0,      0, 0x1843, 
	     0, 0x1848, 0x184a,      0,      0, 0x060c, 0x183e,      0, 
	0x030a,      0,      0, 0x2d0f,      0,      0, 0x2d10, 0x2d11, 
	0x1849, 0x100d, 0x1f97, 0x063b, 0x0423, 0x100f,      0,      0, 
	0x1f99, 0x1f9a, 0x1f9b, 0x1010,      0, 0x1f9c,      0,      0, 
	     0, 0x1011,      0,      0, 0x100e,      0,      0,      0, 
	     0, 0x1f9d,      0,      0,      0,      0, 0x1f9e,      0, 
	     0, 0x170d,      0, 0x170e, 0x2af0,      0, 0x2af1, 0x03b7, 
	     0, 0x1715, 0x1710, 0x2af2, 0x2aef,      0, 0x1711, 0x2af3, 
	0x2af4,      0, 0x1712,      0, 0x0986,      0, 0x2af5,      0, 
	0x2af6, 0x1714, 0x1713, 0x1716, 0x2af7,      0, 0x2af8, 0x2af9, 
	0x1717, 0x1e0d,      0, 0x1e0e, 0x0427,      0, 0x1e0f,      0, 
	0x05bb, 0x0f38, 0x0dfa, 0x1e10,      0, 0x1e11, 0x0f34,      0, 
	     0,      0, 0x0f39, 0x0f36, 0x1e12, 0x0f35, 0x1e13, 0x1e14, 
	0x1e15, 0x1e16,      0, 0x1e17, 0x0e1c, 0x1e18,      0,      0, 
	0x0632, 0x290e, 0x15a9, 0x15aa, 0x0864,      0, 0x290f,      0, 
	0x2910,      0, 0x15ab, 0x2911, 0x0432,      0, 0x2912,      0, 
	     0, 0x15ad,      0,      0,      0, 0x05c5, 0x2913, 0x0505, 
	     0, 0x2914, 0x15ae, 0x0572,      0,      0, 0x15af, 0x2915, 
	0x0925, 0x080f, 0x0526,      0, 0x0f54,      0, 0x1e47,      0, 
	0x1e48, 0x1e49, 0x1e4a, 0x0bf4, 0x1e4b, 0x1e4c, 0x1e4d,      0, 
	0x0f55, 0x1e4e, 0x0f56, 0x1e4f, 0x0f57,      0, 0x1e50,      0, 
	     0, 0x0f58, 0x0c1b, 0x0565, 0x032e, 0x1e51, 0x1e52, 0x1e53, 
	0x0b1c, 0x120f, 0x22bb,      0, 0x099c, 0x1215, 0x22bc, 0x1210, 
	     0, 0x22bd, 0x1212,      0,      0,      0,      0, 0x22be, 
	0x0c38, 0x0a94, 0x22bf, 0x1213, 0x22c0, 0x22c1, 0x22c2, 0x0d9b, 
	     0,      0,      0, 0x0db7, 0x047a, 0x22c3,      0,      0, 
	     0, 0x320f, 0x3210, 0x3211, 0x3212, 0x3213, 0x3214, 0x1afc, 
	     0, 0x3215, 0x3216,      0, 0x3217, 0x3218, 0x3219, 0x321a, 
	     0, 0x321b,      0, 0x321c,      0,      0,      0, 0x321d, 
	     0, 0x1afd, 0x321e, 0x1afe, 0x321f, 0x3220,      0,      0, 
	0x1aff, 0x1610,      0,      0, 0x160d,      0,      0, 0x2995, 
	     0,      0,      0, 0x2996,      0, 0x160c, 0x08fb,      0, 
	0x160f, 0x1611, 0x2998, 0x2999, 0x299a, 0x160e, 0x2997, 0x1615, 
	     0, 0x1612, 0x299b, 0x299c, 0x299d, 0x299e, 0x299f, 0x29a0, 
	0x1613, 0x2710, 0x2711,      0, 0x0504, 0x2712, 0x14a4, 0x0dec, 
	0x2713,      0, 0x0dfd, 0x2714,      0,      0,      0,      0, 
	     0,      0, 0x2715,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x2716, 0x2717,      0,      0,      0, 
	     0, 0x0511, 0x042b,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x227e,      0, 0x044a, 0x086c, 0x11f5, 
	0x11fa,      0, 0x11f6, 0x227f, 0x05d8, 0x2280, 0x11fb, 0x06f5, 
	0x0680,      0,      0,      0,      0, 0x2281, 0x2282, 0x07b5, 
	0x11e9, 0x2a11, 0x0396,      0,      0, 0x0b49, 0x1663,      0, 
	     0, 0x2a1d, 0x166a, 0x1664, 0x166b,      0,      0,      0, 
	     0, 0x2a1e, 0x2a1f, 0x1667,      0,      0, 0x2a20,      0, 
	0x2a21,      0,      0,      0, 0x0bb6, 0x2a22, 0x2a23, 0x077b, 
	0x1669, 0x3011,      0, 0x3012,      0,      0,      0, 0x06ff, 
	     0, 0x3013,      0,      0,      0,      0, 0x3014,      0, 
	0x19dd, 0x08b8, 0x3015,      0,      0, 0x3016, 0x3017,      0, 
	     0, 0x08b9, 0x19e1, 0x19e3,      0, 0x3018, 0x3019, 0x301a, 
	0x301b, 0x2d12, 0x06d0, 0x0e43, 0x184b, 0x184c, 0x097c,      0, 
	     0,      0,      0, 0x2d13, 0x2d14, 0x2d15, 0x2d16, 0x2d17, 
	0x0def,      0, 0x2d18, 0x2d19, 0x2d1a, 0x184d, 0x0da4,      0, 
	     0, 0x184e, 0x184f,      0, 0x2d1b, 0x0cb9, 0x1850, 0x2d1c, 
	0x06b5, 0x0513, 0x0ace, 0x2582, 0x13d8, 0x13e1, 0x02f8, 0x0359, 
	0x2583,      0, 0x03be,      0, 0x13da, 0x0991, 0x13d1, 0x13d3, 
	0x0658,      0,      0, 0x2584,      0,      0,      0, 0x2585, 
	     0, 0x13e4, 0x2586, 0x13df, 0x2587, 0x2588,      0, 0x13d7, 
	     0, 0x0913, 0x1e59,      0, 0x1e5a,      0, 0x1e5b, 0x0590, 
	     0,      0, 0x0f61,      0,      0, 0x1e5c, 0x1e5d, 0x0f62, 
	0x0353, 0x033e, 0x04ae, 0x1e5e, 0x098d, 0x04f0, 0x0de0,      0, 
	0x0f65, 0x03bc, 0x1e5f,      0, 0x0f64,      0,      0, 0x1e60, 
	0x0527, 0x1c14, 0x1c05, 0x1c13, 0x1c47, 0x1c9c, 0x1c49, 0x1c9e, 
	0x1c48, 0x1c9d, 0x1c15, 0x1c07, 0x1c16, 0x1c51, 0x1ca6,      0, 
	     0, 0x1c50, 0x1ca5, 0x1c09, 0x1c18, 0x1c53, 0x1ca8, 0x1c55, 
	0x1caa, 0x1c54, 0x1ca9, 0x1c56, 0x1cab, 0x1c57, 0x1cac, 0x1c59, 
	0x1cae, 0x1815, 0x2cc2,      0,      0, 0x1819,      0, 0x181c, 
	0x181b, 0x2cc3, 0x2cc4, 0x2cc5, 0x1813,      0,      0, 0x2cc6, 
	     0, 0x1816,      0, 0x1827,      0,      0, 0x2cc7, 0x2cc8, 
	     0,      0, 0x2cc9, 0x2cca,      0, 0x2ccb,      0,      0, 
	0x2ccc, 0x0a16,      0, 0x138d,      0,      0,      0,      0, 
	0x254e, 0x1395,      0, 0x138e, 0x251b,      0, 0x251c,      0, 
	0x251d, 0x09a6,      0, 0x0501, 0x1396, 0x251e,      0, 0x251f, 
	     0, 0x2520, 0x2521, 0x05c3, 0x2522,      0, 0x04c4, 0x1394, 
	     0, 0x2916, 0x0b2a, 0x2917, 0x0909, 0x06ea, 0x2918, 0x2919, 
	     0, 0x15b0,      0, 0x291a, 0x291b,      0,      0,      0, 
	     0, 0x291c, 0x291d, 0x0a25, 0x0972, 0x291e, 0x15b2, 0x15b4, 
	0x15b1, 0x15b3,      0,      0,      0,      0,      0, 0x291f, 
	0x057d, 0x2f16, 0x2f17, 0x2f18, 0x0b3e,      0, 0x2f19, 0x0ce1, 
	     0, 0x1999,      0, 0x078a,      0,      0,      0,      0, 
	0x199a, 0x2f1a, 0x199b, 0x2f1b, 0x2f1c, 0x2f1d, 0x199c, 0x2f1e, 
	     0, 0x0aa0,      0,      0,      0,      0, 0x2f1f, 0x2f21, 
	     0, 0x2c17,      0, 0x2c18,      0, 0x17b2, 0x2c19, 0x092d, 
	0x2c1a, 0x17b6, 0x06fa, 0x0890, 0x058b, 0x0d85, 0x2c28, 0x0d8a, 
	0x0801,      0,      0,      0,      0, 0x2c1b,      0, 0x2c1c, 
	0x2c1d, 0x2c1e, 0x17c3, 0x17c1,      0, 0x2c1f, 0x2c20, 0x2c21, 
	0x2c22, 0x0f18, 0x0d11, 0x1de9,      0,      0, 0x1dea, 0x07f7, 
	0x09e1,      0, 0x0f1a, 0x0b41,      0,      0, 0x0f1b, 0x1deb, 
	     0, 0x0f1c, 0x0411, 0x1dec, 0x1ded, 0x1dee, 0x0f1d, 0x0524, 
	0x1def, 0x0b29, 0x03a1, 0x07df,      0,      0, 0x0bba, 0x0f1e, 
	     0, 0x1718, 0x2afa,      0, 0x088e, 0x2afb, 0x03ee,      0, 
	0x1719, 0x0e24,      0, 0x075c, 0x2afc, 0x2afd, 0x07bc,      0, 
	     0, 0x2afe, 0x2aff, 0x2b00, 0x073d, 0x0a1a, 0x2b01, 0x2b02, 
	     0, 0x2b03, 0x2b04, 0x171a, 0x171b, 0x0358, 0x2b05, 0x171c, 
	0x2b06, 0x1b18,      0,      0,      0,      0,      0, 0x3253, 
	0x3254, 0x1b19, 0x3255, 0x0d21, 0x0700, 0x3256, 0x06ef, 0x0936, 
	     0, 0x3257, 0x3258, 0x3259,      0, 0x1b1a,      0,      0, 
	0x325a, 0x325b, 0x1b1d,      0, 0x325c, 0x325d,      0, 0x325e, 
	0x325f, 0x1f18, 0x1f19, 0x0364, 0x1f1a, 0x1f1b,      0, 0x1f1c, 
	     0,      0, 0x1f1d,      0, 0x1f1e, 0x0940, 0x1f1f, 0x0fd1, 
	0x1f20, 0x0fd2,      0,      0,      0, 0x1f21,      0,      0, 
	     0,      0,      0,      0, 0x045d,      0,      0, 0x1f22, 
	     0, 0x0b1a, 0x052b,      0,      0,      0,      0,      0, 
	     0, 0x03ea, 0x10c8, 0x10cd,      0,      0, 0x10cb, 0x20ee, 
	0x0ccc, 0x0ccb, 0x20ef, 0x20f0,      0, 0x20f1,      0, 0x0ae6, 
	     0,      0,      0, 0x10ca, 0x07e3,      0, 0x10c9,      0, 
	     0, 0x311a, 0x1a79,      0,      0, 0x0456, 0x1a77, 0x1a7b, 
	     0,      0, 0x311b,      0, 0x1a7c,      0, 0x0311,      0, 
	0x1a7d, 0x1a7e,      0,      0,      0,      0, 0x311c, 0x311d, 
	0x311e, 0x0851, 0x311f, 0x3120,      0, 0x1a7f,      0, 0x3121, 
	0x3122, 0x131b, 0x2458,      0,      0,      0, 0x2459, 0x245a, 
	0x1318, 0x245b,      0,      0, 0x245c,      0, 0x245d, 0x130c, 
	0x245e,      0, 0x1329, 0x130b,      0, 0x131e,      0,      0, 
	0x245f, 0x2460,      0, 0x2461, 0x1316, 0x2462,      0, 0x1311, 
	0x130e, 0x1b1b, 0x3260,      0,      0,      0,      0, 0x1b1e, 
	0x3261, 0x3262, 0x062a, 0x1b1c,      0,      0,      0, 0x3263, 
	0x1b1f, 0x3264, 0x1b20, 0x1b21,      0, 0x1b25,      0, 0x06fd, 
	0x3265, 0x3266,      0,      0, 0x09c9,      0, 0x3267,      0, 
	0x3268, 0x1c1d, 0x1c1c, 0x1c1f, 0x1c25, 0x1c1e, 0x1c24, 0x1c01, 
	0x1c29, 0x1c2d, 0x1c2c, 0x1c2f, 0x1c2e, 0x1c3a, 0x1c39, 0x1c3c, 
	0x1c3b,      0, 0x1c4a, 0x1c4c, 0x1c4b, 0x1c4e, 0x1c52, 0x1c4d, 
	0x011c, 0x1c08, 0x1c5d, 0x1c5c, 0x1c5f, 0x1c5e, 0x1c6c, 0x1c0b, 
	0x1c19, 0x221e,      0, 0x0d30, 0x0478,      0, 0x11a2,      0, 
	0x05a0, 0x0417,      0,      0, 0x119f, 0x221f,      0, 0x0e05, 
	0x11a1, 0x031f, 0x11a3, 0x2220, 0x119a, 0x11a0, 0x11a7, 0x059f, 
	0x119b, 0x2221,      0,      0, 0x2222, 0x2223,      0, 0x0dcc, 
	0x2224, 0x011f, 0x015e,      0,      0,      0,      0, 0x0122, 
	0x0123,      0,      0, 0x0160, 0x0161,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x051f, 0x03c6,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x1059,      0, 0x0d2c, 0x0c65, 
	0x062d,      0,      0, 0x1d33,      0,      0, 0x087a, 0x0e04, 
	0x1d34,      0, 0x1d35,      0, 0x1d36, 0x1d37, 0x1d38, 0x1d39, 
	0x0cad, 0x151f, 0x27df,      0, 0x1520, 0x0aa9, 0x27e0, 0x040a, 
	0x065b, 0x1521,      0,      0, 0x1522, 0x27e1, 0x27e2, 0x1523, 
	     0, 0x06fc,      0,      0, 0x1525,      0, 0x27e3, 0x1524, 
	     0,      0, 0x1526, 0x1527, 0x27e4, 0x27e5, 0x27e6,      0, 
	0x27e7, 0x211f,      0, 0x10e4,      0,      0,      0,      0, 
	0x2120,      0,      0,      0, 0x2121, 0x10e6,      0, 0x10e7, 
	     0, 0x2122,      0, 0x30ee,      0, 0x2123,      0,      0, 
	0x10ea, 0x2124, 0x2125, 0x0e33,      0, 0x10eb, 0x10e8,      0, 
	     0, 0x2b1f,      0, 0x1730, 0x2b20, 0x172f,      0, 0x0490, 
	0x2b21, 0x1731,      0, 0x1732, 0x1733,      0, 0x2b22, 0x06a6, 
	0x0e16,      0, 0x1735, 0x0872,      0, 0x2b23,      0, 0x0397, 
	0x1736, 0x1737,      0,      0, 0x2b24,      0, 0x2b25, 0x1738, 
	0x2b26, 0x0820, 0x1117, 0x1116, 0x1112,      0, 0x2168,      0, 
	     0, 0x1118, 0x1119,      0, 0x2169, 0x111a,      0,      0, 
	     0, 0x111d, 0x111b,      0, 0x111c, 0x111e,      0, 0x038b, 
	0x0a8f, 0x111f,      0, 0x05d5, 0x03fb, 0x0b71,      0, 0x1120, 
	0x0b58, 0x1820,      0, 0x2ccd, 0x2cce, 0x2ccf,      0,      0, 
	     0,      0,      0, 0x2cd0, 0x2cd1,      0, 0x2cd2,      0, 
	0x181e,      0, 0x2cd3, 0x181f, 0x2cd4,      0,      0, 0x1824, 
	0x1825, 0x2cd5, 0x040d, 0x2cd6, 0x04e1,      0,      0, 0x1823, 
	0x2cd7, 0x1a20, 0x30a4, 0x0499, 0x0438, 0x0675, 0x0bcf, 0x30a5, 
	0x1a22, 0x1a21, 0x30a6,      0, 0x30a7, 0x30a8, 0x1a23,      0, 
	     0,      0,      0, 0x0383,      0, 0x30a9,      0, 0x30aa, 
	     0,      0, 0x1a26, 0x30ab, 0x1a25, 0x1a24, 0x30ac, 0x1a27, 
	0x30ad, 0x2920,      0,      0, 0x2921,      0,      0,      0, 
	     0,      0, 0x15b5, 0x0581,      0, 0x2922,      0, 0x0506, 
	0x0dc1, 0x15b7,      0,      0, 0x2923,      0, 0x2924, 0x15b8, 
	     0,      0, 0x2925, 0x0355, 0x2926, 0x2927,      0,      0, 
	0x15bb, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
	0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
	0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
	0x0040, 0x0221, 0x0222, 0x0223, 0x0224, 0x0225, 0x0226, 0x0227, 
	0x0228, 0x0229, 0x022a, 0x022b, 0x022c, 0x022d, 0x022e, 0x022f, 
	0x0230, 0x0231, 0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237, 
	0x0238, 0x0239, 0x023a, 0x023b, 0x023c, 0x023d, 0x023e, 0x023f, 
	0x0240, 0x3221,      0, 0x1b00, 0x1b01,      0, 0x1b02, 0x3222, 
	0x1b03, 0x1b04, 0x1b05, 0x1b06, 0x3223,      0, 0x3224, 0x1b07, 
	0x1b08,      0, 0x1359, 0x1b09, 0x3225, 0x3226, 0x3227,      0, 
	0x3228,      0, 0x3229, 0x322a, 0x162e, 0x04d3, 0x322b,      0, 
	     0, 0x1022,      0,      0, 0x24ee, 0x24ef, 0x04c2, 0x137c, 
	     0,      0, 0x24f0,      0, 0x137d, 0x24f1, 0x0cc1, 0x0d1b, 
	     0,      0,      0, 0x0b24, 0x137e, 0x0bff,      0, 0x24f2, 
	     0, 0x0c14,      0, 0x24f3, 0x0d64,      0,      0,      0, 
	0x137f, 0x1c22, 0x1c78, 0x1c20, 0x1c76, 0x1c23, 0x1c79, 0x1c26, 
	0x1c7c, 0x1c27, 0x1c7d, 0x1c2a, 0x1c80, 0x1c28, 0x1c7e, 0x1c2b, 
	0x1c81, 0x1c02, 0x1c0d, 0x1c32, 0x1c88,      0,      0, 0x1c31, 
	0x1c87, 0x1c33, 0x1c89, 0x1c30, 0x1c86, 0x1c34, 0x1c8b, 0x1c35, 
	0x1c8c, 0x1f23, 0x1f24, 0x1f25, 0x1f26, 0x0fd9,      0, 0x1f27, 
	     0, 0x04b0, 0x1f28, 0x0fdc, 0x0fd8, 0x0fdb, 0x1f29,      0, 
	0x1f2a,      0, 0x1f2b, 0x1f2c,      0, 0x0c83, 0x1f2d,      0, 
	     0, 0x0b32,      0, 0x0bd1,      0,      0,      0,      0, 
	     0, 0x2a24, 0x1666, 0x166c, 0x1665,      0,      0, 0x07d3, 
	0x2a25, 0x2a26,      0,      0, 0x0cd8, 0x2a27, 0x2a28, 0x07db, 
	0x2a29,      0, 0x1668, 0x1674, 0x2a2a,      0, 0x1670, 0x2a2b, 
	0x1673,      0, 0x1671, 0x1675, 0x166f,      0, 0x1655, 0x08fc, 
	0x2a2c, 0x1e25, 0x0f40,      0, 0x0d09, 0x1e26, 0x0a5d, 0x1e27, 
	0x0d95, 0x1e28, 0x0cae,      0,      0, 0x1e29, 0x0f41,      0, 
	0x1e2a,      0, 0x1e2b, 0x1a73,      0, 0x1e2c, 0x0b0d, 0x1e2d, 
	0x0f42, 0x046b, 0x0d44,      0, 0x1e2e, 0x1e2f, 0x080e, 0x0f43, 
	0x0cbc, 0x2225, 0x2226, 0x0d9a, 0x2227, 0x2228,      0,      0, 
	0x11aa,      0,      0, 0x11ae, 0x2229,      0, 0x222a, 0x0985, 
	     0, 0x0e46, 0x11af, 0x222b, 0x222c, 0x11ac,      0, 0x11a9, 
	0x222d, 0x222e, 0x11a8, 0x11ad,      0, 0x222f, 0x2230,      0, 
	0x2231, 0x2725, 0x14ae,      0, 0x2726, 0x2727,      0, 0x2728, 
	0x2729,      0,      0,      0, 0x272a,      0, 0x272b,      0, 
	     0,      0, 0x272c, 0x272d,      0,      0, 0x14aa,      0, 
	0x272e,      0, 0x14ad, 0x0623, 0x0374, 0x14af, 0x272f, 0x08bb, 
	0x14ac, 0x0127,      0, 0x0126,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x1627,      0, 0x1629,      0, 0x29ba, 0x1628,      0, 
	0x29bb, 0x29bc, 0x29bd, 0x060b,      0,      0, 0x29be, 0x093f, 
	0x29bf,      0,      0, 0x162b, 0x29c0, 0x29c1, 0x29c2, 0x0afb, 
	0x29c3, 0x162a, 0x29c4, 0x29c5,      0, 0x162c, 0x29c6, 0x0c8a, 
	0x0973, 0x2827, 0x08b2, 0x2828, 0x0b21, 0x2829, 0x1548, 0x0d06, 
	0x282a, 0x1545,      0, 0x282b, 0x1546, 0x282c,      0,      0, 
	     0, 0x282d,      0, 0x282e, 0x282f, 0x2830,      0,      0, 
	     0,      0, 0x154b, 0x2831,      0,      0, 0x2832, 0x154a, 
	0x1549, 0x2b27, 0x2b28,      0, 0x2b29, 0x2b2a,      0,      0, 
	0x2b2b,      0, 0x2b2c, 0x2b2d, 0x033b,      0, 0x1739, 0x2b2e, 
	     0,      0, 0x2b2f, 0x173a,      0, 0x2b30,      0, 0x2b31, 
	     0, 0x2b32, 0x0c5e, 0x2b33, 0x2b34,      0, 0x0778,      0, 
	0x173c, 0x0a28,      0, 0x281a,      0,      0, 0x281b, 0x281c, 
	0x1543,      0,      0, 0x281d,      0,      0, 0x281e, 0x281f, 
	0x2820,      0,      0, 0x2821,      0,      0,      0, 0x2822, 
	0x2823,      0,      0, 0x1544, 0x1547, 0x2824,      0, 0x2825, 
	0x2826, 0x0e29,      0, 0x2730, 0x14b2, 0x1bba,      0, 0x2731, 
	0x2732, 0x2733, 0x14b0, 0x14b3, 0x2734,      0, 0x2735, 0x2736, 
	0x14a5, 0x14b1, 0x2737, 0x2738, 0x06b1,      0,      0, 0x14b4, 
	     0,      0,      0,      0,      0,      0,      0, 0x14b5, 
	     0, 0x1729,      0,      0, 0x2b15, 0x2b16, 0x2b17, 0x2b18, 
	0x0a9b,      0,      0,      0, 0x2b19,      0,      0, 0x2b1a, 
	0x2b1b,      0, 0x2b1c,      0,      0,      0,      0, 0x2b1d, 
	     0, 0x172b, 0x172a, 0x172d,      0, 0x2b1e, 0x172c,      0, 
	0x172e, 0x0a2c, 0x21af, 0x21b0,      0, 0x1148,      0,      0, 
	     0, 0x21b1, 0x21b2, 0x21b3, 0x03fc, 0x21b4, 0x21b5, 0x21b6, 
	0x21b7, 0x117b, 0x114a, 0x21b8, 0x21b9,      0, 0x0b6b, 0x21ba, 
	     0, 0x1149,      0, 0x21bb, 0x1147, 0x21bc, 0x0691,      0, 
	0x114d, 0x192c, 0x2e7c, 0x2e7d, 0x192e, 0x192b,      0,      0, 
	     0,      0, 0x2e7e,      0,      0, 0x2e7f, 0x2e80,      0, 
	0x2e81, 0x2e82, 0x2e83, 0x1931,      0, 0x07c2,      0, 0x1930, 
	     0,      0, 0x2e84, 0x2e85, 0x2e86, 0x1932,      0,      0, 
	     0, 0x2c2c,      0,      0,      0, 0x0b00, 0x17c7, 0x2c2d, 
	     0, 0x2c2e, 0x0be6, 0x17ba,      0,      0, 0x2c2f,      0, 
	     0,      0,      0,      0, 0x2c30,      0,      0, 0x2c31, 
	0x0802,      0, 0x17c9, 0x17ce, 0x097b, 0x2c32,      0, 0x17cd, 
	0x2c33, 0x212d, 0x07f3,      0, 0x096a, 0x212e, 0x0640, 0x06ad, 
	0x0641, 0x050f, 0x212f,      0, 0x10f2,      0,      0, 0x06ae, 
	     0,      0, 0x0603, 0x10f3, 0x0d37, 0x0b7e, 0x10f4,      0, 
	0x0642, 0x2130, 0x2131,      0, 0x046d,      0, 0x09ea, 0x054f, 
	     0, 0x2d2e,      0,      0,      0,      0, 0x185d, 0x2d2f, 
	0x2d30, 0x2d31,      0, 0x185e, 0x185f,      0,      0,      0, 
	     0, 0x2d32, 0x2d33, 0x2d34,      0,      0, 0x2d35, 0x1863, 
	     0, 0x1864, 0x2d36, 0x2d37, 0x1862,      0,      0, 0x2d38, 
	     0, 0x0d31,      0, 0x13e5,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0bc7, 0x259d,      0, 
	0x13f1, 0x05f4,      0,      0, 0x259e,      0,      0, 0x07ef, 
	     0, 0x13e7, 0x259f,      0,      0, 0x0dfc, 0x0659,      0, 
	0x13f4, 0x2132,      0, 0x0727, 0x0c52,      0,      0, 0x0bda, 
	0x2133,      0,      0,      0, 0x10f5, 0x04b6, 0x2134,      0, 
	     0,      0, 0x10f8, 0x2135,      0, 0x2136, 0x2137, 0x0a42, 
	     0, 0x2138, 0x10f7, 0x10f6, 0x10f9,      0, 0x0a8c,      0, 
	0x2139, 0x2232,      0,      0,      0, 0x0c85, 0x2233,      0, 
	0x0b11, 0x2234, 0x05a1, 0x2235, 0x11b0, 0x11ab, 0x2236, 0x11b1, 
	     0,      0,      0, 0x05d6,      0,      0,      0, 0x03b6, 
	     0, 0x2237, 0x2238, 0x11b9,      0, 0x2239,      0, 0x0479, 
	     0, 0x2833,      0,      0,      0, 0x2834,      0,      0, 
	     0,      0,      0,      0, 0x154d, 0x2835, 0x2836, 0x154c, 
	     0,      0, 0x154e,      0,      0, 0x2837, 0x2838, 0x2839, 
	     0,      0,      0, 0x283a,      0,      0,      0, 0x1550, 
	0x283b, 0x0134, 0x017b, 0x017c, 0x017d, 0x017e, 0x017f, 0x0180, 
	0x0181, 0x0182, 0x0183, 0x0184, 0x0185, 0x0186, 0x0187, 0x0188, 
	0x0189, 0x018a, 0x018b, 0x018c, 0x018d, 0x018e, 0x018f, 0x0190, 
	0x0191, 0x0192, 0x0193, 0x0194, 0x010b, 0x00fd, 0x010c, 0x00ed, 
	0x00ef, 0x2c34,      0, 0x17ae,      0, 0x2c35, 0x2c36, 0x17cf, 
	0x0950,      0,      0, 0x17ca, 0x17cc,      0, 0x2c37, 0x2c38, 
	     0, 0x2c39, 0x2c3a, 0x2c3b, 0x17cb,      0,      0, 0x1355, 
	0x1346, 0x2c3c, 0x2c3d, 0x17d1, 0x2c3e,      0,      0, 0x2c3f, 
	     0, 0x0335, 0x0a3d, 0x1cc7, 0x0768, 0x1cc8, 0x1cc9,      0, 
	0x0d2f, 0x0853, 0x0703, 0x0852, 0x03c1, 0x1cca, 0x0c4b, 0x0dae, 
	     0, 0x0e80, 0x0356, 0x1ccb,      0, 0x0451, 0x0e81, 0x08cd, 
	0x0f5c, 0x04f5, 0x0c8f,      0,      0,      0,      0, 0x0854, 
	0x1ccc, 0x1235, 0x1236, 0x0aa6, 0x1238, 0x230f, 0x2310, 0x06f7, 
	0x1233,      0, 0x2311, 0x2312,      0, 0x04db, 0x2313,      0, 
	0x1239, 0x2314, 0x1232, 0x123d,      0, 0x123c, 0x2315, 0x123b, 
	0x2316,      0,      0, 0x123e, 0x2317,      0, 0x1240, 0x085e, 
	0x2318, 0x2335,      0, 0x047b, 0x0709,      0,      0, 0x0b35, 
	0x2336,      0,      0,      0, 0x2337, 0x05a4,      0,      0, 
	     0, 0x08bf,      0, 0x1254,      0, 0x08d9, 0x0aa7,      0, 
	0x0c56, 0x1255,      0, 0x2338,      0,      0, 0x2339,      0, 
	     0, 0x2b35, 0x2b36,      0, 0x2b37, 0x2b38, 0x040c, 0x02fb, 
	0x2b39, 0x2b3a, 0x2b3b, 0x2b3c, 0x173b, 0x173e, 0x0b89, 0x2b3d, 
	0x088f, 0x2b3e, 0x03db, 0x2b3f, 0x0cda, 0x2b40,      0,      0, 
	0x2b41, 0x05b8, 0x0559, 0x2b42, 0x173d, 0x2b43, 0x03ef, 0x2b44, 
	0x2b45, 0x1c37, 0x1c8d, 0x1c36,      0, 0x1c38, 0x1c8e, 0x1c03, 
	0x1c0f, 0x1c41, 0x1c96, 0x1c3f, 0x1c94,      0,      0, 0x1c40, 
	0x1c95, 0x1c3e, 0x1c10, 0x1c04, 0x1c11, 0x1c42, 0x1c97, 0x1c43, 
	0x1c98, 0x1c12, 0x1c44, 0x1c99, 0x1c46, 0x1c9b, 0x1c45, 0x1c9a, 
	0x1c06, 0x2f37,      0, 0x19a1,      0, 0x2f38, 0x2f39, 0x2f3a, 
	     0, 0x2f3b,      0,      0,      0,      0, 0x2f3c,      0, 
	     0, 0x2f3d,      0, 0x19a2,      0, 0x2f3e,      0, 0x2f3f, 
	0x2f40, 0x2f41, 0x19a3, 0x2f42,      0, 0x2f43,      0, 0x2f44, 
	     0, 0x2739, 0x273a,      0, 0x0ded,      0, 0x273b, 0x273c, 
	0x273d,      0, 0x273e,      0, 0x14b6,      0,      0,      0, 
	0x273f, 0x2740, 0x2741, 0x2742,      0,      0,      0,      0, 
	     0, 0x2743, 0x2744, 0x2745,      0, 0x2746,      0, 0x14b7, 
	0x2747, 0x2d39, 0x1860, 0x2d3a, 0x185b, 0x1861, 0x2d3b, 0x2d3c, 
	     0,      0, 0x2d3d,      0,      0, 0x1865, 0x1a55,      0, 
	0x2d3e,      0,      0, 0x2d3f,      0,      0,      0, 0x03ad, 
	0x2d40,      0,      0, 0x2d41, 0x2d42, 0x2d43,      0, 0x1868, 
	0x055c, 0x1d3a, 0x1d3b, 0x0593, 0x098a, 0x03e9, 0x1d3c, 0x1d3d, 
	     0, 0x1d3e, 0x1d3f, 0x07e2, 0x1d40, 0x1d41, 0x1d42, 0x0eb7, 
	0x1d43, 0x0ebc, 0x0eba, 0x1d44,      0, 0x0eb5,      0,      0, 
	0x0994, 0x0eb8,      0, 0x0ebb, 0x0eb9, 0x1d45, 0x0cb2,      0, 
	0x0eb6, 0x213a,      0,      0,      0,      0, 0x08ae,      0, 
	     0, 0x213c,      0,      0, 0x0728,      0, 0x08f3, 0x213b, 
	0x09b8, 0x04c1,      0, 0x213d, 0x0a43,      0, 0x213e, 0x10fa, 
	0x10fb, 0x085c,      0,      0,      0,      0, 0x0cec, 0x213f, 
	     0, 0x223a, 0x223b, 0x223c, 0x11b7,      0,      0, 0x11b8, 
	0x069e, 0x11b6, 0x11b4, 0x11b3, 0x11ba, 0x11b2, 0x11bc, 0x223d, 
	0x223e, 0x0400,      0,      0,      0,      0, 0x223f,      0, 
	     0,      0,      0,      0,      0, 0x2240, 0x2241, 0x2242, 
	0x2243, 0x1e3b, 0x0d79, 0x0b54, 0x1e3c,      0, 0x0cc6, 0x0f4c, 
	     0, 0x0f4d,      0, 0x1e3d, 0x1e3e, 0x1e3f, 0x0f4f,      0, 
	0x0f51, 0x0f50, 0x1e40,      0, 0x1e41,      0, 0x0f52, 0x03c2, 
	0x0cff, 0x1e42, 0x06f1, 0x0f53, 0x1e43, 0x1e44, 0x0960, 0x1e45, 
	0x1e46, 0x253b, 0x0cd5, 0x0b83, 0x0502,      0, 0x0aa4,      0, 
	0x253c, 0x0a30, 0x253d, 0x13a7, 0x253e, 0x253f,      0, 0x2540, 
	0x13a5, 0x09be, 0x139a, 0x2541, 0x0372, 0x2542,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x083c, 0x15c6, 0x15c7, 0x07e6,      0, 0x0b15, 0x15c8, 
	     0, 0x292e, 0x292f, 0x09eb, 0x2930, 0x2931, 0x15c9,      0, 
	0x09ff, 0x15ca, 0x2932,      0,      0, 0x2933,      0, 0x0522, 
	     0, 0x0efb, 0x0a20, 0x0764, 0x2934,      0, 0x2935, 0x2936, 
	0x0489, 0x2e3c,      0,      0, 0x07a2,      0,      0, 0x2e3d, 
	     0, 0x08c1,      0,      0, 0x2e3e, 0x2e3f,      0,      0, 
	0x2e40,      0,      0, 0x2e41, 0x0992,      0, 0x2e42,      0, 
	0x2e43,      0, 0x2e44, 0x190d, 0x2e45, 0x2e57,      0, 0x190c, 
	     0, 0x013e, 0x013d,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0140, 0x013f,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x0142, 0x0141,      0, 
	     0, 0x123f, 0x2319,      0,      0, 0x231a, 0x1243,      0, 
	     0, 0x231b, 0x231c, 0x231d,      0,      0,      0,      0, 
	0x231e,      0,      0,      0, 0x231f, 0x2320,      0, 0x2321, 
	     0, 0x1241, 0x2322,      0, 0x2323, 0x1242, 0x121c, 0x2324, 
	0x2325, 0x263f, 0x0d46,      0,      0,      0,      0, 0x0834, 
	     0,      0,      0,      0, 0x2640,      0, 0x2641,      0, 
	0x2642, 0x2643, 0x2644,      0,      0,      0,      0, 0x093a, 
	     0, 0x2645,      0,      0,      0, 0x0833,      0,      0, 
	     0, 0x1b40,      0,      0, 0x329d,      0,      0,      0, 
	0x1b41, 0x32a2, 0x329e, 0x329f, 0x32a1,      0,      0, 0x32a3, 
	     0, 0x32a4,      0, 0x32a5,      0,      0, 0x32a6, 0x1b42, 
	0x32a7, 0x1b43,      0,      0, 0x32a8,      0,      0,      0, 
	     0, 0x2040, 0x031b,      0, 0x02ec, 0x2041,      0,      0, 
	     0,      0, 0x1066,      0,      0, 0x2042, 0x2043, 0x2044, 
	     0,      0, 0x1064, 0x2045, 0x2046,      0,      0,      0, 
	     0, 0x0d4d,      0, 0x1067,      0, 0x1065,      0, 0x2047, 
	0x1063, 0x3040, 0x3041, 0x3042,      0,      0,      0,      0, 
	     0, 0x3043,      0, 0x3044, 0x3045, 0x045c, 0x3046,      0, 
	0x3047,      0,      0, 0x3048,      0, 0x19f0, 0x3049, 0x06b4, 
	0x0980, 0x304a,      0, 0x0a6b, 0x304b,      0,      0, 0x304c, 
	     0, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
	0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
	0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
	0x0060, 0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247, 
	0x0248, 0x0249, 0x024a, 0x024b, 0x024c, 0x024d, 0x024e, 0x024f, 
	0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257, 
	     0,      0,      0,      0, 0x00e3, 0x00f9, 0x00f0, 0x00f1, 
	     0, 0x0341, 0x1f50,      0, 0x0a07, 0x1f51, 0x1f52, 0x1f53, 
	0x1f54, 0x1f55,      0,      0, 0x1f57,      0, 0x1f58, 0x0ff1, 
	     0, 0x0699, 0x1f56, 0x0318, 0x08a9,      0,      0, 0x1f59, 
	0x1f5a,      0, 0x0ff2, 0x0600,      0,      0, 0x0688,      0, 
	0x0ff4, 0x0441,      0,      0, 0x293a,      0, 0x08a5, 0x0c5b, 
	0x293b, 0x15d4, 0x293c, 0x293d, 0x293e, 0x09cd, 0x293f, 0x2940, 
	0x2941, 0x2942, 0x2943,      0, 0x15cf, 0x2944, 0x15d3, 0x15d5, 
	     0,      0, 0x06f0,      0,      0,      0, 0x2945,      0, 
	0x2946, 0x1341,      0, 0x1343, 0x1344,      0, 0x249e,      0, 
	     0,      0,      0, 0x1350, 0x249f, 0x134c,      0, 0x12d5, 
	0x24a0, 0x24a1, 0x24a2,      0, 0x134b, 0x24a3,      0,      0, 
	     0, 0x134a,      0,      0, 0x1347,      0, 0x24a4, 0x24a5, 
	0x24a6, 0x2341, 0x02ff,      0, 0x2342, 0x0551, 0x08f6, 0x2343, 
	0x0c57,      0,      0,      0, 0x125b, 0x0715, 0x0a0a, 0x2344, 
	0x072e, 0x0882,      0, 0x2345, 0x2346, 0x2347,      0,      0, 
	0x125c,      0, 0x0cd2,      0,      0, 0x039e, 0x072f,      0, 
	0x2348, 0x3141, 0x3143,      0,      0, 0x3144,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x1a8a, 0x0b5e, 
	0x3145,      0, 0x3146, 0x1a8c, 0x03c0, 0x3147, 0x1a8f, 0x1a8e, 
	0x3148, 0x3149,      0, 0x314a, 0x034b,      0,      0,      0, 
	0x053e, 0x1142, 0x061f, 0x219b,      0, 0x219e,      0,      0, 
	0x219c, 0x1143, 0x0c73, 0x07ea, 0x219d, 0x219f, 0x1144, 0x0c12, 
	0x21a0, 0x21a1, 0x21a2,      0, 0x0b1e, 0x0a48,      0,      0, 
	     0, 0x21a3, 0x0aaf,      0,      0, 0x1145, 0x04ca,      0, 
	     0, 0x0d43,      0, 0x280f,      0, 0x153c, 0x153e, 0x153f, 
	     0, 0x2810, 0x153b,      0,      0,      0, 0x2811, 0x2812, 
	0x2813,      0,      0,      0,      0, 0x2814, 0x2815, 0x2816, 
	0x1541, 0x1542, 0x2817, 0x0a50,      0, 0x04a4, 0x2818, 0x2819, 
	     0, 0x3244,      0,      0, 0x1b13, 0x3245, 0x3246, 0x3247, 
	0x3248,      0, 0x3249, 0x324a, 0x324b,      0, 0x324c, 0x0307, 
	0x324d, 0x324e, 0x1b14, 0x0c80, 0x1b12, 0x324f,      0, 0x1b15, 
	0x1b16,      0,      0, 0x3250,      0,      0, 0x3251, 0x3252, 
	0x1b17, 0x2f45,      0, 0x2f47, 0x2f48,      0, 0x2f46,      0, 
	0x2f49,      0, 0x2f4a,      0,      0,      0, 0x0aa1, 0x2f4b, 
	0x2f4c, 0x19a5, 0x2f4d, 0x19a4,      0, 0x2f4e,      0, 0x2f4f, 
	0x2f50,      0, 0x2f51, 0x2f52,      0, 0x2f53, 0x2f54,      0, 
	     0, 0x0546, 0x10af,      0,      0,      0, 0x050e, 0x10b0, 
	     0, 0x057b,      0, 0x0b2c, 0x03b5,      0, 0x0726, 0x10b1, 
	0x10b4, 0x10b3, 0x057a,      0, 0x10b2,      0, 0x0ab7,      0, 
	     0,      0, 0x20c9, 0x20ca,      0, 0x20cb,      0, 0x0995, 
	     0, 0x1d46, 0x0879, 0x1d47, 0x0d26, 0x0ebd, 0x0ebe,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x07b3, 
	0x0ecb, 0x1d48,      0, 0x1d49, 0x0b8b,      0, 0x0c2d, 0x0ec6, 
	     0, 0x0cc5,      0, 0x03bb,      0, 0x1d4a, 0x1d4b, 0x0eca, 
	0x1d4c, 0x2e46,      0, 0x190b,      0,      0, 0x2e47, 0x2e48, 
	0x2e49, 0x2e4a,      0, 0x2e4b, 0x1913, 0x1911,      0, 0x2e4c, 
	0x190e,      0, 0x2e4d,      0,      0, 0x2e4e, 0x2e4f, 0x1910, 
	0x2e50,      0, 0x2e51, 0x190f, 0x1912,      0, 0x0516,      0, 
	0x1916, 0x0f47, 0x1e30, 0x08d3, 0x0f44, 0x054d, 0x1e31, 0x0f45, 
	0x046c, 0x1e32, 0x1e33, 0x1e34,      0, 0x1e35,      0,      0, 
	     0, 0x1e36, 0x1e37, 0x0589, 0x0f48, 0x1e38, 0x0f49, 0x1e39, 
	0x1e3a, 0x0f4a, 0x0f4b, 0x078c,      0,      0,      0, 0x0634, 
	0x0d6f, 0x2947, 0x2948,      0,      0,      0, 0x15dc, 0x0c25, 
	0x2949, 0x0bbf, 0x0af8,      0, 0x0557, 0x15db, 0x15d9, 0x294a, 
	0x0bce, 0x15d6, 0x0a21, 0x0afa,      0, 0x0af9, 0x294b, 0x06eb, 
	     0,      0,      0,      0,      0,      0, 0x15ee,      0, 
	     0, 0x2748, 0x2749, 0x14a3, 0x274a,      0,      0, 0x274b, 
	0x14b8, 0x274c, 0x274d, 0x274e, 0x274f,      0,      0, 0x2750, 
	0x2751, 0x0485, 0x2752, 0x2753,      0,      0, 0x2754,      0, 
	     0,      0, 0x2755,      0, 0x2756,      0, 0x0756,      0, 
	0x2757, 0x2c48, 0x1ffc, 0x2c49,      0,      0,      0, 0x2c4a, 
	     0,      0,      0,      0,      0,      0, 0x17d4, 0x0610, 
	     0, 0x04f3,      0, 0x2c4b, 0x2c4c, 0x17d6, 0x0f19, 0x2c4d, 
	0x2c4e, 0x2c4f, 0x2c50, 0x0514,      0, 0x0e07, 0x2c51, 0x0570, 
	0x17d7, 0x034a,      0,      0, 0x0e26, 0x30e4, 0x30e5, 0x30e6, 
	0x1a49, 0x1990, 0x30e7, 0x1a48,      0,      0,      0, 0x30e8, 
	0x30e9, 0x1a4c, 0x1a4a, 0x1a4b, 0x30ea, 0x1a4d,      0, 0x1a4e, 
	0x0e39, 0x1a4f, 0x1a50, 0x30eb, 0x08f2, 0x0bd4,      0,      0, 
	     0, 0x2b4a, 0x173f, 0x2b4b, 0x1740, 0x2b4c, 0x0794, 0x0569, 
	0x0a3a, 0x2b4d,      0, 0x2b4e, 0x0b2e,      0, 0x2b4f,      0, 
	0x2b50,      0, 0x0378,      0, 0x1744, 0x1743,      0, 0x2b51, 
	0x2b52,      0, 0x1749, 0x1745, 0x1748,      0, 0x2b53, 0x2b54, 
	     0, 0x0b4c, 0x1306, 0x0b47, 0x2446, 0x2447, 0x2448, 0x2449, 
	     0, 0x244a, 0x244b, 0x130a, 0x12fd, 0x244c, 0x0545, 0x1300, 
	0x07ec, 0x244d, 0x244e, 0x244f, 0x0b9b, 0x1302, 0x0548,      0, 
	0x12fa, 0x12fc, 0x12f9, 0x2450, 0x2451, 0x0e5b, 0x043d, 0x12ff, 
	0x2452, 0x284c,      0, 0x0d81, 0x155d, 0x284d, 0x0a11, 0x284e, 
	0x0ba5,      0, 0x0568, 0x284f,      0, 0x2850, 0x09fe, 0x155e, 
	0x0537, 0x2851, 0x2852,      0, 0x08f9, 0x2853,      0,      0, 
	     0, 0x2854,      0,      0, 0x2855, 0x155f,      0,      0, 
	     0, 0x294c,      0,      0,      0, 0x294d, 0x15de, 0x294e, 
	0x15e0,      0, 0x294f, 0x2950,      0, 0x15e3, 0x2951, 0x15e4, 
	0x2952, 0x15e1, 0x15e2, 0x2953, 0x2954, 0x15df, 0x15dd,      0, 
	0x2955,      0,      0, 0x15d7,      0,      0,      0,      0, 
	     0, 0x0c4d, 0x1fb6,      0, 0x1019, 0x1fa6,      0, 0x1fa7, 
	0x1fa8,      0, 0x1fa9,      0,      0,      0, 0x1faa,      0, 
	     0, 0x1fab,      0,      0,      0, 0x086a, 0x1fac, 0x1fad, 
	0x076a, 0x1fae, 0x0b98, 0x04b1,      0, 0x06e0, 0x1faf, 0x1fb0, 
	0x1fb1, 0x1d4d, 0x1d4e,      0,      0, 0x1d4f, 0x0ec4, 0x0ecd, 
	0x1d50,      0, 0x0959, 0x1d51, 0x05fd, 0x1d52, 0x0b97, 0x1d53, 
	0x1485, 0x1d54, 0x0ecc, 0x0adc, 0x1d55, 0x0ec1,      0, 0x062f, 
	0x1d56, 0x1d57, 0x062e, 0x0ebf, 0x1d58, 0x1d59, 0x1d5a, 0x1d5b, 
	0x078b, 0x094e, 0x0cf5, 0x06ec, 0x29d6,      0,      0, 0x29d7, 
	     0,      0,      0, 0x29d8, 0x073a, 0x0a7e, 0x29d9, 0x163b, 
	0x0e2c, 0x06ce, 0x29da, 0x163c, 0x088d,      0, 0x163e,      0, 
	     0,      0, 0x083f, 0x06a5,      0, 0x29db, 0x29dc, 0x29dd, 
	0x163d, 0x114f, 0x21d4, 0x03ff, 0x1163, 0x1165, 0x0a14,      0, 
	0x21d5, 0x069d, 0x03bd, 0x115d, 0x1168, 0x1167, 0x0530,      0, 
	0x098e, 0x0449, 0x21d6,      0,      0,      0, 0x059e,      0, 
	0x115e,      0,      0,      0,      0,      0,      0, 0x21d7, 
	0x21d8, 0x154f,      0, 0x283c,      0,      0, 0x0ca2,      0, 
	0x283d,      0,      0, 0x283e,      0, 0x07e5, 0x0e13, 0x283f, 
	0x2840, 0x1551, 0x2841,      0, 0x0b14,      0, 0x2842, 0x1552, 
	     0,      0, 0x1553,      0, 0x1557, 0x1555, 0x1556, 0x2843, 
	0x1554, 0x2150, 0x0a44,      0, 0x0644, 0x081e,      0,      0, 
	0x0bf8,      0,      0, 0x081f, 0x2151,      0,      0, 0x2152, 
	0x0807,      0,      0,      0,      0,      0, 0x0a8d, 0x0cce, 
	0x0ab8,      0,      0, 0x0645,      0, 0x0c53,      0,      0, 
	     0, 0x1051, 0x2011, 0x1050, 0x2012,      0, 0x03a3,      0, 
	0x1052, 0x0816, 0x1054, 0x09e8, 0x2013, 0x1053, 0x2014, 0x0c88, 
	0x2015,      0,      0, 0x2016, 0x0806, 0x0ada, 0x2017, 0x2018, 
	     0, 0x1055, 0x2019,      0, 0x201a, 0x201b, 0x063c,      0, 
	     0, 0x2652,      0, 0x1449,      0, 0x0b9c, 0x1445, 0x1448, 
	0x0835, 0x2653, 0x0bea,      0,      0, 0x144c,      0, 0x0782, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0, 0x2654,      0,      0,      0, 0x0923,      0, 
	     0, 0x2c52, 0x2c53, 0x2c54, 0x2c55, 0x2c56,      0,      0, 
	0x17d8,      0, 0x2c57,      0, 0x0a31, 0x2c58,      0,      0, 
	0x2c59,      0, 0x17d9,      0,      0,      0, 0x2c5a, 0x2c5b, 
	0x2c5c,      0, 0x0b57, 0x2c5d, 0x0303,      0,      0,      0, 
	     0, 0x2253, 0x11ce, 0x2254, 0x2255,      0,      0, 0x0918, 
	0x2256,      0, 0x2257, 0x11cf, 0x2258,      0,      0, 0x11d0, 
	0x04d9, 0x11d1,      0, 0x11d2, 0x11d3, 0x09bc,      0,      0, 
	     0, 0x0606, 0x2259,      0, 0x0d72,      0, 0x225a,      0, 
	0x0cef, 0x2453, 0x1309, 0x0418,      0,      0,      0,      0, 
	     0,      0,      0, 0x06dc,      0,      0, 0x2454, 0x0384, 
	     0,      0, 0x131a, 0x2455,      0, 0x0e5c, 0x131d, 0x2456, 
	     0, 0x2457,      0,      0, 0x0885, 0x131c,      0,      0, 
	     0, 0x0954, 0x1ba3, 0x333d,      0,      0,      0, 0x333e, 
	     0,      0,      0, 0x333f, 0x3340, 0x1ba4,      0,      0, 
	0x3341,      0, 0x3342, 0x3343,      0, 0x3344,      0,      0, 
	0x3345,      0, 0x3346, 0x3347, 0x0c18, 0x3348, 0x3349, 0x1ba5, 
	0x334a, 0x1754,      0, 0x2b6b, 0x2b6c, 0x2b6d, 0x1757,      0, 
	0x2b6e,      0, 0x0977, 0x05b0,      0,      0, 0x2b6f, 0x2b70, 
	0x0368, 0x1756, 0x2b71, 0x066a, 0x2b94, 0x2b5b, 0x2b72, 0x2b73, 
	0x2b74, 0x0978,      0,      0,      0,      0,      0,      0, 
	     0, 0x3154, 0x1a94,      0, 0x3155, 0x1a93, 0x315e, 0x3156, 
	     0,      0,      0,      0, 0x3157, 0x0cfe, 0x0b09, 0x3158, 
	0x3159, 0x315a,      0, 0x315b, 0x315c, 0x0377, 0x315d,      0, 
	0x1a95, 0x1a92,      0,      0, 0x0c48, 0x0dd9, 0x1a96, 0x315f, 
	     0, 0x2655,      0,      0,      0, 0x144f, 0x2656,      0, 
	0x2657, 0x1447,      0, 0x0582,      0, 0x2658,      0,      0, 
	0x144d,      0,      0, 0x2659,      0, 0x0dbf, 0x1450,      0, 
	     0,      0, 0x1bbc, 0x265a, 0x265b,      0,      0,      0, 
	0x07de, 0x2b55, 0x2b56, 0x0d61, 0x1747, 0x03dd, 0x0460, 0x174b, 
	0x2b57, 0x2b58, 0x174d, 0x2b59, 0x2b5a,      0,      0, 0x05af, 
	     0,      0,      0,      0,      0,      0,      0, 0x1751, 
	0x175a, 0x175b,      0,      0, 0x2b5c, 0x02f4, 0x2b5d, 0x2b5e, 
	0x2b5f, 0x0157,      0, 0x015c, 0x0158,      0,      0,      0, 
	0x015d, 0x014a,      0,      0, 0x014b,      0,      0,      0, 
	     0,      0,      0, 0x011a,      0,      0,      0,      0, 
	     0,      0,      0, 0x0162,      0,      0, 0x0164, 0x0124, 
	     0, 0x1c58, 0x1cad, 0x1c5b, 0x1cb0, 0x1c5a, 0x1caf, 0x1c0a, 
	0x1c1a, 0x1c66, 0x1cbb, 0x1c63, 0x1cb8, 0x1c60, 0x1cb5, 0x1c65, 
	0x1cba, 0x1c62, 0x1cb7, 0x1c64, 0x1cb9, 0x1c6b, 0x1cc0, 0x1c6e, 
	0x1cc3, 0x1c6d, 0x1c6f, 0x1cc4, 0x1c71, 0x1cc6, 0x1c70, 0x1cc5, 
	     0, 0x2d58, 0x1876,      0,      0,      0, 0x2d59, 0x1878, 
	0x0de6,      0, 0x1877, 0x0891,      0, 0x1879,      0,      0, 
	0x187a, 0x2d5a,      0, 0x187b, 0x0492, 0x2d5b, 0x2d5c, 0x2d5d, 
	0x2d5e,      0,      0, 0x187c,      0, 0x2d5f, 0x187d,      0, 
	0x187e, 0x0159,      0,      0,      0,      0,      0,      0, 
	0x0152, 0x0153, 0x0151, 0x0150, 0x0166, 0x0167,      0,      0, 
	     0,      0,      0,      0,      0, 0x0125, 0x0165,      0, 
	     0,      0,      0,      0,      0,      0, 0x0163,      0, 
	     0, 0x0f59, 0x07cc, 0x1e54, 0x0912,      0, 0x0f5b, 0x0f5a, 
	0x0810, 0x061a, 0x0f5d, 0x0bd7, 0x1e56, 0x1e55, 0x0f5e,      0, 
	     0,      0, 0x0bf5, 0x0999, 0x09d3, 0x0525,      0,      0, 
	0x0b4b, 0x09f4, 0x1e57, 0x0ba9, 0x1e58, 0x0d01,      0, 0x0f60, 
	     0, 0x2359,      0, 0x064e, 0x126a, 0x235a,      0, 0x06a0, 
	0x0827, 0x235b, 0x235c, 0x1269,      0, 0x0828, 0x235d, 0x0d51, 
	0x069f,      0, 0x235e, 0x235f, 0x0320, 0x08f7, 0x2360, 0x2361, 
	     0,      0,      0,      0,      0, 0x1270, 0x2362, 0x2363, 
	0x08da, 0x145a,      0,      0,      0,      0, 0x096e, 0x070b, 
	0x145c,      0,      0,      0,      0, 0x145b, 0x086f, 0x0f73, 
	     0,      0,      0,      0,      0,      0, 0x145d,      0, 
	     0, 0x266e, 0x145f,      0, 0x144e, 0x145e,      0, 0x266f, 
	0x1460, 0x265c,      0, 0x265d,      0,      0,      0,      0, 
	     0, 0x1451,      0,      0,      0, 0x1452,      0,      0, 
	0x265e, 0x265f, 0x0b69, 0x2660, 0x2661,      0,      0,      0, 
	     0,      0, 0x1454, 0x2662,      0,      0,      0, 0x1455, 
	0x2663, 0x065e,      0, 0x162d,      0,      0,      0, 0x29c7, 
	0x0e15,      0, 0x29c8,      0, 0x29c9,      0,      0,      0, 
	0x162f,      0,      0, 0x1630,      0, 0x1631, 0x29ca, 0x1632, 
	     0, 0x0738,      0, 0x1633, 0x05aa,      0,      0, 0x0509, 
	     0, 0x295e, 0x048a,      0,      0,      0, 0x295f,      0, 
	     0,      0,      0, 0x0a00,      0, 0x2960, 0x0926,      0, 
	0x2961, 0x2962, 0x0bbb, 0x2963,      0, 0x15f4, 0x2964, 0x2965, 
	     0, 0x0bbd,      0, 0x2966, 0x2967, 0x2968, 0x2969,      0, 
	     0, 0x0c60, 0x06d7, 0x066e,      0, 0x2e11,      0,      0, 
	0x0c46, 0x03e4, 0x0be7, 0x18eb, 0x0494, 0x08fe, 0x18ea, 0x18ef, 
	0x0a3c, 0x0d74,      0, 0x18ed, 0x18ee, 0x04cd,      0, 0x18f0, 
	0x0b9e, 0x09c4, 0x2e12, 0x2e13, 0x0c0a, 0x0abc, 0x18ec,      0, 
	0x0cfa, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
	0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
	0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 
	0x0080, 0x0561,      0,      0, 0x07d5,      0, 0x0b19,      0, 
	     0, 0x2fd8, 0x2fd9, 0x2fda,      0,      0, 0x2fdb, 0x2fdc, 
	     0,      0, 0x0934, 0x2fdd, 0x19d6,      0, 0x19d0, 0x19d5, 
	0x2fde, 0x0d54, 0x2fdf, 0x0a59, 0x19d7, 0x19d4,      0,      0, 
	0x2fe0, 0x2a61,      0, 0x16a2, 0x16a4,      0, 0x0dd4, 0x16a3, 
	0x16a6, 0x16a5,      0, 0x0dc2, 0x2a62, 0x16a7, 0x2a63, 0x0c17, 
	0x2a64, 0x2a65, 0x2a66,      0,      0, 0x16a8,      0, 0x2a67, 
	0x2a68,      0,      0, 0x16ab,      0, 0x2a69, 0x16aa, 0x16a9, 
	     0, 0x1563, 0x285d, 0x285e, 0x285f,      0, 0x0ad5, 0x06cb, 
	0x04ed,      0,      0,      0,      0,      0, 0x2860, 0x2861, 
	     0, 0x2862,      0, 0x0cd7,      0, 0x0b86, 0x2863,      0, 
	0x2864,      0,      0, 0x0ad6,      0,      0,      0,      0, 
	0x0673, 0x1d63, 0x1d64, 0x1d65, 0x0ece,      0, 0x1d66, 0x1d67, 
	0x0ecf, 0x0ed3, 0x0317, 0x1d68,      0, 0x1d69,      0, 0x1d6a, 
	0x0ca5, 0x0ed2, 0x1d6b, 0x1d6c, 0x1d6d,      0, 0x0ed1, 0x0ed5, 
	0x1d6e,      0, 0x1d6f, 0x0ed4,      0, 0x0a85,      0,      0, 
	0x1d70, 0x2664, 0x2665,      0, 0x0b6e, 0x2666,      0,      0, 
	     0, 0x0af4, 0x1457,      0, 0x2667, 0x2668,      0, 0x1459, 
	     0, 0x0e22,      0, 0x1456, 0x2669, 0x1458, 0x0394, 0x266a, 
	0x1453,      0, 0x266b, 0x266c,      0, 0x266d,      0,      0, 
	0x0fd3, 0x2e64, 0x2e65, 0x2e66, 0x2e67,      0,      0, 0x2e68, 
	0x2e69,      0,      0, 0x192d,      0,      0,      0,      0, 
	     0, 0x1922, 0x2e6a,      0, 0x2e6b, 0x1923, 0x1921, 0x2e6c, 
	0x2e6d, 0x2e6e, 0x2e6f,      0,      0,      0, 0x2e70,      0, 
	     0, 0x1265, 0x1266, 0x04bc,      0,      0, 0x0b59, 0x09f9, 
	0x050b, 0x0730, 0x0968,      0,      0, 0x07eb, 0x02f9,      0, 
	     0, 0x2352, 0x1267, 0x2353,      0, 0x2354, 0x2355,      0, 
	     0,      0, 0x2356, 0x03a7, 0x126b,      0,      0, 0x2357, 
	0x2358, 0x1f65,      0, 0x1f66, 0x1f67, 0x1f68, 0x1f69, 0x0fff, 
	0x02fe, 0x06d4, 0x1f6a, 0x1f6b,      0, 0x1f6c, 0x0598, 0x1f6d, 
	0x1f6e, 0x0a12,      0,      0, 0x1f6f, 0x1f70,      0,      0, 
	0x1000, 0x1001,      0,      0, 0x1003,      0, 0x1f71, 0x1f72, 
	0x1f73, 0x0267, 0x0268,      0, 0x0269, 0x026a, 0x026b, 0x026c, 
	0x026d, 0x026e, 0x026f, 0x1bd6, 0x1bd9, 0x1bdb, 0x1bdc, 0x1bdd, 
	0x1bde, 0x1be5, 0x0270, 0x0271, 0x0272, 0x0273, 0x0274, 0x0275, 
	0x0276, 0x0277, 0x0278, 0x0279, 0x027a, 0x027b, 0x027c, 0x027d, 
	0x027e, 0x1867, 0x2d44, 0x2d45, 0x2d46, 0x186a,      0, 0x1869, 
	     0,      0,      0, 0x186c, 0x2d47,      0, 0x186b, 0x2d48, 
	0x186d, 0x2d49,      0, 0x07c0, 0x2d4a, 0x186e, 0x2d4b,      0, 
	0x186f,      0,      0, 0x2d4c, 0x2d4d, 0x2d4e, 0x2d4f, 0x1870, 
	0x08e7, 0x2067,      0, 0x2068,      0,      0,      0,      0, 
	0x2069,      0,      0,      0,      0, 0x206a,      0,      0, 
	     0,      0, 0x206b, 0x206c, 0x206d,      0, 0x206e,      0, 
	     0, 0x206f,      0, 0x2070, 0x2071, 0x1070, 0x1074, 0x1071, 
	0x2072, 0x0468, 0x1dd8, 0x0f0b, 0x1dd9, 0x0f09, 0x0d4e, 0x0f0a, 
	     0, 0x0c51, 0x0f0c, 0x0f0d, 0x0f0e, 0x0ade, 0x1dda,      0, 
	     0, 0x0f12, 0x0f10, 0x0f11, 0x0f0f, 0x06d8, 0x0f13, 0x0d7b, 
	0x0e31, 0x1ddb,      0, 0x1ddc,      0, 0x1ddd, 0x0f14, 0x1dde, 
	0x1ddf, 0x0868, 0x301c, 0x19e2, 0x19e4, 0x301d, 0x301e, 0x0550, 
	0x301f, 0x0c3c, 0x3020, 0x3021, 0x0793, 0x0e4e,      0, 0x19e0, 
	0x06ed,      0,      0, 0x0e6a, 0x3022, 0x3023, 0x19e6, 0x3024, 
	0x3025,      0,      0, 0x19e5, 0x19e7,      0,      0,      0, 
	     0, 0x0f68, 0x1e69,      0,      0, 0x1e6a, 0x0f6a, 0x0f69, 
	     0, 0x08aa, 0x0360, 0x1e6b, 0x1e6c,      0, 0x0385, 0x0f6b, 
	0x1e6d, 0x0f6c,      0, 0x1e6e, 0x05f0, 0x1e6f, 0x1e70, 0x0f6d, 
	0x1e71, 0x1e72,      0, 0x1e73, 0x050d,      0, 0x1e74,      0, 
	     0, 0x1068, 0x0e57,      0,      0, 0x204f, 0x2050, 0x0b87, 
	0x2051, 0x2052, 0x106a,      0,      0, 0x2053,      0,      0, 
	     0, 0x2054,      0,      0,      0,      0, 0x2055,      0, 
	     0,      0,      0, 0x069c,      0,      0,      0, 0x2056, 
	     0, 0x176a,      0, 0x1760,      0,      0,      0, 0x2b86, 
	0x2b87, 0x176c, 0x2b88, 0x175e, 0x0bb7, 0x2b89, 0x2ba2,      0, 
	     0,      0, 0x0dd8,      0,      0,      0, 0x1767,      0, 
	     0,      0,      0,      0,      0,      0, 0x177d, 0x2b8a, 
	0x2b8b, 0x136c,      0, 0x24dc, 0x136e, 0x136d, 0x24dd, 0x0d0b, 
	     0,      0, 0x07ed, 0x079d, 0x0717,      0, 0x136f,      0, 
	     0,      0,      0,      0,      0,      0, 0x1371, 0x086e, 
	0x24de, 0x1370,      0,      0, 0x24df,      0,      0, 0x1372, 
	0x24e0, 0x146c, 0x267f, 0x2680, 0x2681,      0, 0x2682, 0x146d, 
	0x0ca7, 0x0be0,      0,      0, 0x146e, 0x0b92,      0, 0x2683, 
	0x2684, 0x2685,      0, 0x0a4e, 0x2686,      0, 0x2687, 0x2688, 
	     0, 0x146f, 0x03ec, 0x2689, 0x050c, 0x268a, 0x0d57, 0x268b, 
	0x0d47, 0x016d, 0x016e,      0,      0,      0, 0x0102, 0x0101, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0169,      0, 0x0129, 0x012a,      0,      0,      0, 
	     0,      0,      0,      0, 0x0143,      0,      0,      0, 
	     0, 0x036e, 0x2364, 0x2365, 0x2366, 0x2367, 0x07e4, 0x2368, 
	0x0d19, 0x06e7, 0x2369, 0x236a, 0x236b, 0x236c, 0x0829, 0x236d, 
	0x08d0, 0x236e, 0x236f,      0, 0x2370, 0x126f, 0x126d, 0x126e, 
	0x2372,      0, 0x2371,      0,      0, 0x0a2e,      0,      0, 
	0x128e, 0x286e, 0x286f,      0, 0x2870, 0x2871,      0,      0, 
	     0, 0x2872,      0, 0x2873, 0x0dff, 0x065c,      0, 0x2874, 
	0x05e0,      0,      0, 0x0bbc,      0, 0x1567,      0,      0, 
	     0,      0,      0, 0x2875,      0, 0x1569,      0, 0x2876, 
	     0, 0x1a6f, 0x1b8b, 0x0d5d, 0x310f, 0x1a70,      0, 0x1a71, 
	0x3110, 0x1a72, 0x043a, 0x3111, 0x1a74,      0, 0x08a4, 0x3112, 
	     0,      0, 0x1a75,      0, 0x3113, 0x057f,      0, 0x3114, 
	0x3115, 0x3116, 0x1a76, 0x1a7a, 0x3117, 0x1a78, 0x3118,      0, 
	0x3119, 0x2470, 0x2471, 0x1321, 0x2472,      0, 0x1328,      0, 
	     0,      0,      0, 0x132e, 0x0c0e, 0x1334,      0,      0, 
	0x2473,      0, 0x2474, 0x132f, 0x1332, 0x132c, 0x2475,      0, 
	0x0a37,      0, 0x0c2f, 0x2476, 0x1322,      0, 0x2477, 0x132a, 
	0x082d, 0x2670,      0,      0,      0,      0,      0, 0x0bb5, 
	0x2671, 0x2672, 0x2673,      0,      0,      0, 0x1461,      0, 
	     0, 0x1462,      0,      0, 0x2674,      0,      0,      0, 
	0x2675,      0,      0, 0x2676, 0x1463,      0, 0x2677,      0, 
	0x2678, 0x2770, 0x2771,      0, 0x070d, 0x2772, 0x03a0, 0x14d0, 
	0x2773, 0x0dc0, 0x2774, 0x2775, 0x0cb8, 0x14d1,      0,      0, 
	0x2776, 0x0ac3, 0x0da2, 0x065a, 0x0888,      0,      0, 0x2777, 
	0x0a0e, 0x0f4e, 0x2778, 0x0a4f, 0x03ed, 0x14d2, 0x2779, 0x277a, 
	0x277b, 0x1d71,      0, 0x1d72, 0x1d73,      0, 0x05cd, 0x1d74, 
	0x1d75,      0,      0, 0x1d76,      0, 0x0ed6, 0x1d77,      0, 
	     0, 0x1d78, 0x1d79, 0x0776,      0, 0x098b, 0x0a86, 0x0573, 
	     0, 0x0ed7,      0,      0,      0,      0, 0x04d5,      0, 
	     0, 0x2c71, 0x2c72,      0, 0x2c73, 0x17e2, 0x2c74, 0x17e3, 
	0x0789,      0, 0x17e5,      0, 0x0a04,      0, 0x05b1, 0x0425, 
	     0,      0, 0x2c75, 0x2c76,      0, 0x17e8, 0x2c77,      0, 
	0x2c78,      0, 0x0422, 0x2c79, 0x17ed, 0x2c7a,      0, 0x17e9, 
	0x17ec, 0x2e71, 0x2e72, 0x1920,      0, 0x0a9e,      0,      0, 
	0x1925, 0x1929, 0x1926, 0x1924, 0x2e73, 0x1927, 0x2e74, 0x2e75, 
	0x2e76, 0x1928,      0,      0,      0, 0x2e77, 0x192f,      0, 
	     0,      0, 0x192a,      0, 0x2e78, 0x2e79, 0x2e7a, 0x2e7b, 
	0x0901, 0x2a72, 0x03ac,      0, 0x2a73,      0, 0x16b4, 0x16b5, 
	     0, 0x2a74,      0, 0x16b6,      0, 0x0dd1,      0, 0x2a75, 
	0x2a76,      0,      0, 0x07bb,      0, 0x16b8, 0x16b7,      0, 
	     0,      0,      0,      0, 0x2a77,      0,      0,      0, 
	0x2a78, 0x0e73, 0x12ae, 0x08c0,      0,      0,      0, 0x12ad, 
	     0,      0, 0x12a8,      0,      0,      0,      0,      0, 
	0x0608, 0x23d1, 0x23d2, 0x23d3, 0x12b4, 0x12b2, 0x23d4, 0x03d2, 
	0x12b0, 0x12b6, 0x12bc,      0, 0x23d5, 0x23d6, 0x23d7,      0, 
	     0, 0x1c73, 0x1c72, 0x1c75, 0x1c7b, 0x1c74, 0x1c7a, 0x1c0c, 
	0x1c7f, 0x1c83, 0x1c82, 0x1c85, 0x1c84, 0x1c90, 0x1c8f, 0x1c92, 
	0x1c91, 0x1c0e, 0x1c9f, 0x1ca1, 0x1ca0, 0x1ca3, 0x1ca7, 0x1ca2, 
	0x011d, 0x1c17, 0x1cb2, 0x1cb1, 0x1cb4, 0x1cb3, 0x1cc1, 0x1c1b, 
	0x1cc2, 0x2373, 0x1274, 0x0751, 0x064f, 0x1272, 0x2374, 0x2375, 
	     0,      0, 0x1273, 0x2376, 0x0883, 0x2377,      0, 0x2379, 
	0x1271,      0, 0x2378, 0x0702,      0,      0,      0,      0, 
	0x237a, 0x237b, 0x237c,      0, 0x237d, 0x237e, 0x1276, 0x1275, 
	0x127a, 0x0774,      0, 0x2be1, 0x2be2,      0,      0, 0x177f, 
	0x2be3,      0,      0,      0,      0, 0x2be4,      0, 0x2be5, 
	     0, 0x2be6, 0x0ca3,      0, 0x0d33, 0x17a7, 0x17a6,      0, 
	0x17a2, 0x17a3,      0, 0x035d,      0, 0x2be7,      0, 0x2be8, 
	0x17a5, 0x0775,      0,      0,      0, 0x0b23, 0x15fb, 0x15fa, 
	     0, 0x2974, 0x15f7, 0x2975,      0,      0, 0x0e61,      0, 
	     0,      0,      0, 0x2976, 0x1600, 0x2977, 0x2978, 0x1604, 
	0x1601, 0x2979, 0x297a, 0x297b,      0, 0x297c,      0, 0x297d, 
	     0, 0x1e75,      0, 0x0705, 0x0f6e,      0, 0x1e76,      0, 
	     0, 0x0d27, 0x06aa, 0x04f9, 0x0d96, 0x0957, 0x0bd8, 0x07ae, 
	0x1e77,      0,      0, 0x1e78, 0x1e79, 0x07d6, 0x1e7a, 0x0799, 
	0x07a6,      0, 0x0805, 0x1e7b, 0x0bd9,      0, 0x1e7c, 0x1e7d, 
	0x0f71, 0x3275,      0, 0x3276,      0, 0x1b34,      0, 0x1b30, 
	     0, 0x1b31, 0x1b2d, 0x1b33, 0x3277, 0x1b2f, 0x0445,      0, 
	0x3278, 0x0e77, 0x3279, 0x1b32, 0x1b2e, 0x1b2c, 0x1b2b, 0x327a, 
	     0, 0x327b, 0x327c, 0x327d, 0x1b36, 0x327e,      0, 0x327f, 
	     0, 0x2576, 0x09fb, 0x2577,      0, 0x13cd, 0x2578, 0x13c2, 
	     0, 0x13c8, 0x2579, 0x13cf, 0x0345, 0x13c5,      0, 0x13d0, 
	0x257a, 0x257b, 0x0887,      0, 0x07ee, 0x257c, 0x0c7a, 0x257d, 
	0x06a3,      0, 0x13bd, 0x13cb, 0x0ab9, 0x257e,      0,      0, 
	     0, 0x0d78,      0, 0x1a19, 0x0935, 0x309c,      0,      0, 
	0x1a1a, 0x309d, 0x0c99, 0x1a1b, 0x040e, 0x309e, 0x309f, 0x30a0, 
	0x0363,      0, 0x0498,      0, 0x0497, 0x1a1c,      0, 0x1a1d, 
	     0, 0x1a1e, 0x1a1f,      0,      0,      0, 0x30a1, 0x30a2, 
	0x30a3, 0x1178, 0x1176, 0x21fb, 0x0961,      0, 0x21fc,      0, 
	0x116c, 0x0707,      0,      0,      0,      0,      0,      0, 
	     0, 0x09ab, 0x118b, 0x21fd, 0x0962, 0x1186, 0x21fe, 0x1183, 
	0x1184, 0x21ff, 0x0797, 0x1187, 0x118a, 0x2200, 0x2201,      0, 
	     0, 0x1778,      0,      0,      0,      0,      0,      0, 
	     0, 0x2b95, 0x0cc3, 0x2b96, 0x176f,      0,      0,      0, 
	0x03df, 0x060f, 0x0c20, 0x1779,      0, 0x176d,      0, 0x2b97, 
	0x1776, 0x2b98, 0x2b99,      0, 0x1780, 0x2b9a, 0x1771,      0, 
	     0, 0x2478, 0x0d60, 0x133e, 0x1331, 0x2479,      0,      0, 
	     0, 0x247a, 0x05db, 0x03a8, 0x0442,      0,      0, 0x1319, 
	     0, 0x247b,      0, 0x247c,      0, 0x247d, 0x082e, 0x1336, 
	0x247e, 0x133d, 0x07aa, 0x0455, 0x247f,      0, 0x09f1, 0x2480, 
	0x2481, 0x2d78,      0, 0x2d79, 0x05c8, 0x2d7a, 0x188c, 0x2d7b, 
	     0,      0,      0, 0x0cdf, 0x2d7c, 0x2d7d, 0x0908,      0, 
	0x2d7e,      0, 0x0515,      0, 0x0d86, 0x0951, 0x2d7f, 0x188d, 
	0x2d80,      0,      0, 0x0892, 0x0a33, 0x0847, 0x2d81, 0x2d82, 
	     0, 0x2079, 0x0a27,      0, 0x1075,      0, 0x207a, 0x1077, 
	     0,      0, 0x1078, 0x207b,      0,      0,      0, 0x207c, 
	     0,      0,      0,      0,      0,      0, 0x207d, 0x207e, 
	     0,      0,      0, 0x107a, 0x107b,      0, 0x207f,      0, 
	     0, 0x2b79,      0, 0x2b7a,      0, 0x2b7b, 0x175c, 0x2b7c, 
	0x1764,      0, 0x176b, 0x1765,      0,      0, 0x2b7d, 0x1763, 
	     0,      0,      0, 0x2b7e, 0x1746, 0x2b7f, 0x2b80, 0x1761, 
	     0, 0x2b81, 0x2b82, 0x175d, 0x2b83, 0x2b84, 0x2b85, 0x0491, 
	0x175f, 0x037a, 0x2d90, 0x1896, 0x05b3,      0, 0x2d91, 0x0741, 
	0x2d92,      0, 0x0740,      0, 0x0e78, 0x1895, 0x1894, 0x092e, 
	     0, 0x04ec, 0x0e6e, 0x041d, 0x0849,      0, 0x2d93, 0x2d94, 
	0x2d95,      0, 0x2d96, 0x2d97, 0x2d98, 0x1893,      0, 0x2d99, 
	0x2d9a, 0x0f7a,      0, 0x0e4f, 0x1e8d, 0x1e8e,      0, 0x0cc7, 
	0x1e8f, 0x0a89, 0x061b, 0x0687,      0,      0, 0x1e90, 0x0f82, 
	0x1e91,      0, 0x0b3a,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x1e92, 
	0x0f86, 0x0e7b, 0x12de,      0,      0, 0x12ec, 0x0321, 0x2433, 
	     0, 0x12e0, 0x2434, 0x2435, 0x0d4b, 0x12e5, 0x086d, 0x0a68, 
	0x12db, 0x2436, 0x2437, 0x12eb, 0x2438,      0,      0, 0x2439, 
	0x243a,      0, 0x08c5, 0x12f5, 0x0454, 0x05da,      0,      0, 
	     0, 0x2c7b,      0,      0, 0x2c7c, 0x0bd3, 0x2c7d,      0, 
	0x2c7e,      0, 0x17ea,      0,      0, 0x17eb, 0x0c3f, 0x0bf3, 
	0x17ee,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x09e2, 0x17f8, 0x2c80, 0x17f4, 0x2c81, 0x2c82, 0x03f0, 
	     0, 0x087c,      0,      0, 0x2048, 0x2049, 0x1062,      0, 
	0x204a, 0x204b, 0x0caf, 0x204c,      0,      0, 0x204d,      0, 
	0x061d, 0x204e,      0,      0,      0,      0, 0x106b, 0x106c, 
	     0,      0,      0,      0,      0, 0x0818,      0,      0, 
	     0, 0x177c,      0, 0x177b,      0,      0,      0,      0, 
	     0,      0, 0x0ba6, 0x1782,      0, 0x178d,      0,      0, 
	0x2ba3,      0, 0x0461,      0,      0,      0, 0x1790,      0, 
	     0, 0x177e, 0x2ba4,      0,      0, 0x1783, 0x0ddd,      0, 
	     0, 0x277c,      0,      0, 0x277d, 0x14d3,      0, 0x14d8, 
	0x277e, 0x277f, 0x14d6, 0x14d5, 0x124c, 0x0409, 0x14d4, 0x2780, 
	0x0323, 0x2781, 0x0bc3, 0x2782,      0, 0x0be3,      0,      0, 
	0x2783,      0, 0x0dfe, 0x14d9, 0x14d7, 0x0a1f, 0x08cf, 0x2784, 
	0x2785, 0x1e7e, 0x036a, 0x0958, 0x0636, 0x05fe, 0x0564, 0x1e7f, 
	0x1e80, 0x0f75, 0x09e4, 0x09e3, 0x0528, 0x0811, 0x0f76, 0x0f74, 
	0x03c9, 0x09cb, 0x0769, 0x071e, 0x034d,      0, 0x1e81, 0x0453, 
	0x067d, 0x071d,      0, 0x0f77,      0,      0,      0,      0, 
	     0, 0x027f, 0x0280, 0x1be2, 0x0281, 0x0282, 0x0283, 0x0284, 
	0x0285, 0x0286, 0x0287, 0x1bdf, 0x1be4, 0x1be1, 0x1be3, 0x1be6, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x187f,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x0434,      0, 0x2d60, 0x2d61, 0x2d62, 
	0x2d63, 0x2d64,      0, 0x1880,      0, 0x1881, 0x1882,      0, 
	     0, 0x237f, 0x2380, 0x127b,      0, 0x1277,      0, 0x0405, 
	0x1278, 0x1279, 0x0bee, 0x2382, 0x2383, 0x2384,      0, 0x0c58, 
	0x05a5, 0x127c,      0,      0, 0x2386, 0x08db, 0x2387, 0x082a, 
	0x2389, 0x238a, 0x238b, 0x0a15, 0x238c, 0x238e,      0, 0x2385, 
	0x2388, 0x257f,      0,      0,      0, 0x2580, 0x08df,      0, 
	0x044c, 0x06c6, 0x0831, 0x13bf, 0x07d1,      0,      0,      0, 
	     0,      0,      0,      0, 0x05a7,      0, 0x13be,      0, 
	     0,      0, 0x13d4, 0x07fc, 0x05f3,      0, 0x13e3, 0x2581, 
	0x13dd, 0x2080, 0x2081,      0,      0,      0,      0,      0, 
	     0, 0x2082, 0x04b3,      0, 0x107d, 0x107c,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x107e, 
	0x2083,      0, 0x2085,      0, 0x2086,      0, 0x2087,      0, 
	     0, 0x2180, 0x112b,      0,      0, 0x2181, 0x2182,      0, 
	0x2183, 0x112c,      0, 0x052d,      0, 0x112d, 0x2184, 0x112e, 
	     0, 0x2185, 0x1130,      0, 0x0af5, 0x2186,      0, 0x1131, 
	0x1132, 0x2187, 0x1133,      0, 0x2188, 0x1124, 0x1123,      0, 
	     0, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 
	0x0088, 0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008e,      0, 
	     0, 0x008f, 0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 
	0x0096, 0x0097, 0x0098, 0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 
	0x009e, 0x0681, 0x0b63,      0,      0, 0x13bb,      0,      0, 
	     0, 0x25f7, 0x25f8,      0, 0x0de3, 0x141d,      0, 0x1421, 
	0x09da, 0x25f9, 0x1420,      0, 0x140b,      0, 0x25fa, 0x1a29, 
	     0,      0, 0x25fb, 0x1425,      0, 0x25fc, 0x25fd, 0x1429, 
	     0, 0x1481, 0x1482, 0x1480,      0,      0, 0x26ac,      0, 
	     0,      0, 0x079e,      0,      0, 0x0b25, 0x0536,      0, 
	     0,      0,      0,      0, 0x26ad, 0x26ae,      0,      0, 
	0x1484, 0x09ef, 0x1483, 0x26af, 0x26b0, 0x0e60, 0x0b9d, 0x26b1, 
	     0, 0x1583, 0x0592,      0,      0, 0x28b4, 0x28b5, 0x28b6, 
	0x04df, 0x04c6, 0x0736, 0x28b7, 0x28b8,      0,      0,      0, 
	0x28b9, 0x0da3, 0x28ba,      0, 0x1589, 0x28bb, 0x1588, 0x094b, 
	0x1585, 0x28bc,      0, 0x1587, 0x28bd, 0x28be, 0x07da, 0x088b, 
	0x1586, 0x2d83, 0x188e,      0, 0x2d84,      0, 0x2d85, 0x1891, 
	0x2d86, 0x1892, 0x2d87,      0,      0,      0, 0x2d88, 0x2d89, 
	     0, 0x06b3, 0x09a7, 0x1890, 0x2d8a, 0x0848, 0x0c35, 0x2d8b, 
	0x2d8c, 0x2d8d,      0,      0, 0x188f, 0x2d8e, 0x2d8f, 0x073f, 
	     0, 0x1584,      0, 0x0b65,      0,      0, 0x083a,      0, 
	0x28bf, 0x0c33, 0x28c0,      0, 0x28c1,      0, 0x06cc,      0, 
	     0,      0,      0, 0x28c2,      0,      0,      0,      0, 
	0x0af7,      0, 0x28c3, 0x158a, 0x28c4, 0x28c5,      0, 0x28c6, 
	0x158b, 0x1185, 0x07b4, 0x2202, 0x1188,      0,      0, 0x1182, 
	0x2203, 0x0d8d, 0x0d8c, 0x2204,      0, 0x2205, 0x118c, 0x118d, 
	0x031e, 0x2206, 0x2207, 0x2208, 0x2209, 0x220a, 0x1181, 0x220b, 
	0x220c,      0, 0x220d, 0x056f, 0x02ef, 0x220e,      0, 0x220f, 
	0x0477, 0x1086, 0x208c,      0, 0x1084,      0, 0x1085,      0, 
	     0,      0,      0,      0, 0x208d, 0x208e,      0,      0, 
	     0, 0x0725, 0x1087, 0x208f,      0, 0x063d, 0x1088, 0x2090, 
	0x074d, 0x099d,      0, 0x1089, 0x108a, 0x072d, 0x063e, 0x2091, 
	0x0d63, 0x0689,      0, 0x0cbb, 0x15a6, 0x2903, 0x2904, 0x0d07, 
	0x2905, 0x2906, 0x15a8,      0,      0, 0x2907, 0x08fa, 0x0376, 
	0x03bf, 0x02f5,      0,      0,      0,      0, 0x2908, 0x2909, 
	0x15a7,      0, 0x290a,      0,      0, 0x290b, 0x290c,      0, 
	0x290d, 0x0989, 0x1979, 0x02f2, 0x0e4d,      0,      0,      0, 
	0x197e, 0x2ef5, 0x2ef6, 0x2ef8,      0, 0x2ef9, 0x2efa, 0x09c6, 
	0x2ef7,      0, 0x07c4, 0x0895, 0x2efb, 0x2efc, 0x1980, 0x197f, 
	0x2efd, 0x0338, 0x1981,      0,      0, 0x0c26,      0, 0x1989, 
	0x2efe, 0x2189, 0x1134, 0x059c, 0x218a, 0x218b,      0, 0x0c1e, 
	0x218c,      0, 0x06c1, 0x0c2e, 0x0a47, 0x0c42, 0x1135,      0, 
	0x218d, 0x0821, 0x036d, 0x218e, 0x1136, 0x218f, 0x2190,      0, 
	0x1137, 0x2191, 0x0d83, 0x2192,      0, 0x0bf9, 0x2193, 0x2194, 
	0x113a, 0x298a, 0x048b,      0, 0x1605,      0, 0x298b, 0x298c, 
	0x1606, 0x298d,      0, 0x1607, 0x160a, 0x298e,      0,      0, 
	     0,      0, 0x298f,      0, 0x2990, 0x2991,      0, 0x2992, 
	0x1609, 0x0c0f, 0x2993, 0x2994,      0,      0, 0x160b, 0x0e49, 
	0x0cc2, 0x068b, 0x0d4a, 0x32c6, 0x32c5, 0x1b5b, 0x32c7,      0, 
	     0,      0, 0x32c8, 0x32c9, 0x32ca, 0x0ce5,      0,      0, 
	0x1b63, 0x32cb,      0, 0x1b5f,      0,      0,      0, 0x32cc, 
	0x32cd,      0,      0, 0x1b64, 0x32ce, 0x32cf,      0, 0x32d0, 
	     0, 0x1d8b, 0x1d8c, 0x1d8d,      0,      0,      0,      0, 
	     0,      0,      0, 0x1d8e,      0, 0x06ba, 0x0db2,      0, 
	0x1d8f, 0x1d90,      0, 0x0edc, 0x0edf, 0x0edb, 0x06b9,      0, 
	0x080c,      0, 0x1d91, 0x1d92,      0,      0, 0x1d93, 0x0594, 
	     0, 0x0f8c, 0x1e9d,      0, 0x1e9e, 0x0f8e, 0x1e9f, 0x0f90, 
	     0, 0x1ea0, 0x1ea1,      0, 0x06e5, 0x0e6d, 0x1ea2, 0x0f85, 
	0x0f83, 0x0f8f, 0x1ea3, 0x0f8a,      0,      0, 0x1ea4, 0x1ea5, 
	     0,      0,      0,      0,      0, 0x1ea6,      0,      0, 
	0x1ea7, 0x268c, 0x03b9, 0x0e5f, 0x268d,      0,      0,      0, 
	0x0d05, 0x268e, 0x0c7f,      0, 0x268f,      0,      0, 0x2690, 
	0x2691,      0, 0x2692, 0x08e0,      0, 0x1470,      0,      0, 
	0x2693, 0x2694, 0x0b20,      0, 0x2695, 0x2696, 0x05dc, 0x1471, 
	0x2697, 0x2b8c, 0x1775,      0,      0,      0, 0x08c6,      0, 
	0x2b8d,      0, 0x2b8e, 0x04e5,      0, 0x055a,      0, 0x1770, 
	0x2b8f, 0x2b90, 0x2b91,      0, 0x03e0, 0x2b92,      0, 0x0841, 
	     0, 0x1773,      0,      0,      0, 0x06cf, 0x2b93,      0, 
	0x0ad0, 0x128d,      0,      0,      0,      0,      0, 0x128f, 
	     0, 0x23ab, 0x1290,      0, 0x23ac, 0x23ad,      0, 0x23ae, 
	     0, 0x1291,      0, 0x0547, 0x036f, 0x0650, 0x1292,      0, 
	0x1293, 0x0800, 0x0969, 0x23af, 0x2381, 0x0f72, 0x0945, 0x0944, 
	0x09bd, 0x238d, 0x0544,      0, 0x127d, 0x1281,      0,      0, 
	0x03d0, 0x127e, 0x1280,      0, 0x238f, 0x2390, 0x2391, 0x127f, 
	     0, 0x2392, 0x07fa, 0x2393,      0,      0,      0, 0x0a0b, 
	0x030e, 0x1282, 0x2394, 0x2395, 0x2396, 0x2397, 0x1283,      0, 
	0x2398, 0x2a91, 0x16c6,      0,      0, 0x2a92,      0, 0x2a93, 
	     0, 0x16c7,      0,      0,      0, 0x2a94,      0, 0x2a95, 
	     0, 0x2a96,      0,      0, 0x075b, 0x2a97, 0x2a98, 0x0d7e, 
	0x2a99,      0, 0x2a9a, 0x2a9b, 0x16c9, 0x2a9c, 0x0a02, 0x2a9d, 
	0x16c8, 0x0c92, 0x0e2a,      0,      0,      0,      0,      0, 
	     0,      0, 0x1fc3, 0x03f9, 0x1020, 0x1fc4, 0x1fc5,      0, 
	0x1fc6, 0x1fc7, 0x0941, 0x1023,      0, 0x0ae2, 0x1fc8,      0, 
	0x0ac8, 0x0ae3, 0x0bd2, 0x0a6e,      0,      0,      0, 0x06be, 
	0x1fc9, 0x0e93, 0x0ce7, 0x0e94,      0, 0x062b, 0x0330, 0x0d25, 
	     0, 0x051b,      0,      0, 0x051c, 0x051d, 0x0a83, 0x0e09, 
	0x1ce7, 0x0e95,      0,      0, 0x0e96,      0,      0, 0x0e97, 
	     0,      0, 0x1ce8, 0x0898,      0,      0,      0,      0, 
	     0, 0x1093, 0x2099,      0, 0x1094, 0x209a, 0x09d5, 0x209b, 
	0x034e, 0x079a, 0x030b, 0x209c, 0x095e, 0x0471, 0x0766, 0x209d, 
	0x063f, 0x209e, 0x209f,      0, 0x20a0, 0x20a1, 0x0ae5, 0x20a2, 
	0x07b0, 0x0472, 0x0a2b, 0x0a8b, 0x0301, 0x04d8, 0x0cca,      0, 
	0x0773, 0x1b94,      0,      0,      0, 0x3324, 0x1b95,      0, 
	0x3325, 0x1b96,      0,      0,      0, 0x3326, 0x3327, 0x3328, 
	0x1b97, 0x3329, 0x332a, 0x332b,      0, 0x1b98, 0x332c, 0x1b99, 
	0x1b9a, 0x332d, 0x1b9b,      0, 0x1b9c, 0x1b9d, 0x1b9e,      0, 
	0x332e, 0x1d94,      0, 0x0ee0, 0x1d95, 0x1d96, 0x054c,      0, 
	0x1d97,      0, 0x0edd, 0x0ede,      0, 0x1d98, 0x0b0c, 0x1d99, 
	0x0983, 0x1d9a, 0x0520,      0, 0x1d9b, 0x1d9c, 0x0d00, 0x0ee1, 
	     0, 0x1d9d,      0, 0x0e0a,      0, 0x1d9e, 0x1d9f, 0x0ee2, 
	0x1da0, 0x1995, 0x1994, 0x1992, 0x15bc, 0x0495, 0x2f0b,      0, 
	0x1972, 0x2f0c, 0x1997, 0x1996, 0x2f0d, 0x2f0e,      0, 0x2f0f, 
	0x1998, 0x2f10, 0x0da7,      0,      0,      0, 0x2f11,      0, 
	0x2f12, 0x2f13, 0x2f14,      0, 0x2f15,      0,      0,      0, 
	     0, 0x0a96, 0x07d0, 0x0500,      0,      0,      0,      0, 
	     0,      0,      0, 0x2512, 0x2513,      0, 0x2514, 0x0bdf, 
	0x2515, 0x075f,      0, 0x2516,      0, 0x2517, 0x138c,      0, 
	0x0481,      0, 0x2518, 0x039f, 0x2519, 0x251a, 0x0b4f, 0x138b, 
	0x0655, 0x2896, 0x2897,      0,      0, 0x2893,      0, 0x2898, 
	0x1579, 0x0d14,      0, 0x2899,      0, 0x1578,      0,      0, 
	0x0334,      0,      0, 0x289a, 0x289b, 0x157c,      0, 0x289d, 
	0x289e,      0,      0, 0x289f, 0x28a0,      0, 0x157b,      0, 
	0x28a1, 0x2f98, 0x2f99,      0,      0, 0x2f9a, 0x2f9b, 0x2f9c, 
	0x2f9d,      0, 0x2f9e, 0x2f9f,      0, 0x2fa0, 0x0b3c, 0x0426, 
	     0, 0x2fa1, 0x19c9, 0x2fa2, 0x2fa3, 0x19c6, 0x19c8, 0x2fa4, 
	     0, 0x2fa5,      0,      0,      0, 0x2fa6, 0x2fa7, 0x19c4, 
	     0, 0x0299, 0x029a, 0x029b, 0x029c, 0x029d, 0x029e, 0x029f, 
	0x02a0, 0x02a1, 0x02a2, 0x02a3, 0x02a4, 0x02a5, 0x02a6, 0x02a7, 
	0x02a8, 0x02a9, 0x02aa, 0x02ab, 0x02ac, 0x02ad, 0x02ae, 0x02b0, 
	0x02b1, 0x02b2, 0x02b3, 0x02b4, 0x02b5, 0x02b6, 0x02b7, 0x02b8, 
	0x02b9, 0x0d99,      0, 0x21e4, 0x0476, 0x21e5, 0x21e6, 0x0380, 
	0x1174, 0x21e7, 0x0b75, 0x02f6,      0,      0,      0,      0, 
	     0, 0x21e8, 0x21e9, 0x0bfa, 0x114c, 0x117a, 0x117e, 0x0d76, 
	0x21ea, 0x1177,      0,      0, 0x21eb, 0x0ae8, 0x117c, 0x21ec, 
	     0, 0x2399,      0, 0x0a4b,      0, 0x239a,      0, 0x0e3e, 
	     0,      0,      0,      0, 0x0716,      0, 0x239b, 0x0cc0, 
	     0,      0, 0x239c, 0x239d,      0, 0x0cf0, 0x239e,      0, 
	     0, 0x128a, 0x1285,      0, 0x239f, 0x1288,      0, 0x1287, 
	0x23a0, 0x039a, 0x0953, 0x2f04, 0x05e8,      0, 0x0dc9, 0x2f05, 
	0x2f06, 0x198d, 0x0aab,      0,      0, 0x2f07, 0x097f, 0x0788, 
	0x198e, 0x2f08,      0, 0x1991,      0, 0x2f09, 0x07f4, 0x198f, 
	0x0932, 0x0931, 0x2f0a, 0x032d,      0, 0x0e18, 0x1993,      0, 
	0x0c0b, 0x0a9a, 0x1662, 0x2a12,      0, 0x165e, 0x2a13, 0x2a14, 
	     0, 0x0ca9, 0x048c, 0x2a15, 0x2a16, 0x0d5c, 0x2a17,      0, 
	0x0327,      0, 0x2a18, 0x1661,      0, 0x0e4a, 0x2a19, 0x2a1a, 
	     0,      0, 0x2a1b, 0x2a1c, 0x1660,      0,      0,      0, 
	     0, 0x2e9a, 0x2e9b,      0, 0x2e9c, 0x2e9d, 0x1944, 0x1941, 
	0x2e9e, 0x1945,      0, 0x0787, 0x1946, 0x04cf, 0x058e,      0, 
	0x2e9f,      0, 0x2ea0, 0x05e7,      0, 0x2ea1,      0,      0, 
	     0,      0,      0,      0, 0x1947, 0x2ea2,      0,      0, 
	0x0b4d, 0x2c9b,      0,      0, 0x2c9c,      0, 0x2c9d,      0, 
	     0,      0, 0x090f,      0, 0x0e64, 0x1804, 0x2c9e, 0x1805, 
	     0,      0,      0,      0, 0x180b,      0, 0x0875,      0, 
	0x1807, 0x2c9f, 0x180a,      0,      0,      0, 0x2ca0,      0, 
	0x1802, 0x2d9b,      0, 0x1898, 0x2d9c, 0x1899, 0x1897, 0x2d9d, 
	0x0611,      0, 0x0daf,      0, 0x2d9e, 0x0742, 0x0b62,      0, 
	0x2d9f, 0x2da0, 0x189c, 0x2da1, 0x08e9,      0, 0x0a05, 0x2da2, 
	0x2da3, 0x0da5, 0x2da4, 0x189f,      0,      0,      0, 0x0625, 
	0x2da5, 0x279c, 0x279d, 0x14ec, 0x14ee, 0x279e, 0x0c39, 0x279f, 
	0x0836,      0,      0, 0x14f5,      0, 0x27a0, 0x14f4, 0x27a1, 
	0x27a2,      0,      0, 0x14f6,      0, 0x0757, 0x06a4,      0, 
	0x27a3, 0x0af6, 0x14f7,      0, 0x0a6c, 0x27a4,      0, 0x14f9, 
	0x27a5, 0x289c, 0x0839,      0,      0,      0,      0, 0x28a2, 
	0x157d,      0,      0,      0,      0, 0x28a3,      0, 0x094a, 
	     0, 0x28a4, 0x157f, 0x157e,      0,      0,      0,      0, 
	     0,      0, 0x1580, 0x28a5,      0, 0x28a6,      0, 0x28a7, 
	0x28a8, 0x169d, 0x2a57,      0, 0x2a58, 0x2a59, 0x2a5a, 0x2a5b, 
	0x16a0, 0x169e, 0x169f, 0x06d6, 0x05ae,      0, 0x2a5c, 0x0a19, 
	     0, 0x0bcc, 0x2a5d, 0x07ff,      0,      0, 0x0b88,      0, 
	0x0c06, 0x16a1, 0x11bb,      0,      0,      0, 0x2a5e, 0x2a5f, 
	0x2a60, 0x2a9e,      0,      0,      0, 0x2a9f,      0, 0x16cb, 
	     0,      0,      0, 0x16ca,      0,      0,      0,      0, 
	     0,      0,      0, 0x16cc,      0,      0,      0, 0x08e4, 
	     0, 0x16cd,      0, 0x16ce,      0,      0,      0, 0x0c8e, 
	0x16cf, 0x319e, 0x319f, 0x1ab7,      0,      0, 0x1ab9, 0x31a0, 
	0x31a1, 0x31a2, 0x1ab8,      0, 0x1abb, 0x1abe, 0x31a3, 0x31a4, 
	     0, 0x1aba, 0x1abc, 0x1abd,      0, 0x31a5, 0x1abf,      0, 
	0x053f, 0x31a6, 0x31a7,      0, 0x31a8, 0x31a9,      0, 0x31aa, 
	0x31ab, 0x079f, 0x2703,      0, 0x2704,      0, 0x14a0, 0x2705, 
	0x2706,      0, 0x2707, 0x0599,      0,      0, 0x0be2, 0x14a1, 
	     0,      0, 0x14bc,      0,      0, 0x2708, 0x2709,      0, 
	0x270a, 0x14a7, 0x270b, 0x270c, 0x270d,      0, 0x270e, 0x05f6, 
	0x270f, 0x149f,      0, 0x03d6,      0,      0, 0x26f8, 0x26f9, 
	     0, 0x149b, 0x26fa, 0x070c, 0x26fb, 0x26fc, 0x0a62, 0x149d, 
	0x26fd,      0,      0, 0x26fe, 0x26ff,      0,      0, 0x2700, 
	     0,      0, 0x2701,      0,      0,      0, 0x2702, 0x14a2, 
	     0, 0x159f, 0x28f8,      0,      0,      0,      0,      0, 
	0x28f9,      0,      0,      0, 0x28fa,      0, 0x28fb, 0x07a0, 
	0x28fc, 0x28fd, 0x15a2, 0x0339,      0, 0x28fe, 0x28ff,      0, 
	0x15a5, 0x2900, 0x2901, 0x2902, 0x15a3, 0x03d9, 0x05a9, 0x15a4, 
	0x065d, 0x0ba0, 0x2e1d, 0x05e6, 0x18f4, 0x18f3,      0, 0x0c61, 
	     0, 0x2e1e,      0, 0x0772,      0, 0x2e1f, 0x0ad1,      0, 
	0x2e20, 0x2e21,      0, 0x2e22,      0,      0, 0x2e23,      0, 
	0x2e24, 0x2e25,      0, 0x18f7, 0x18f8, 0x066f, 0x18f6, 0x2e26, 
	0x2e27, 0x25a0,      0, 0x0337,      0,      0, 0x13f2,      0, 
	0x25a1,      0,      0, 0x13e6,      0,      0, 0x25a2, 0x25a3, 
	0x13ec,      0, 0x25a4, 0x13ee, 0x25a5,      0,      0, 0x0dbe, 
	0x13e9,      0,      0, 0x0aad, 0x25a6,      0, 0x13eb,      0, 
	0x25a7, 0x2aa0, 0x0976, 0x16d0,      0, 0x2aa1,      0, 0x2aa2, 
	     0, 0x16d1,      0,      0,      0,      0, 0x2aa3,      0, 
	0x0e4b, 0x16d4, 0x2aa4, 0x16d3, 0x16d2, 0x0a51, 0x2aa5, 0x16d5, 
	0x0871,      0, 0x16d6,      0,      0,      0, 0x16d7, 0x0e63, 
	0x16d8, 0x15a1, 0x0555,      0,      0, 0x0e68, 0x093c,      0, 
	     0,      0,      0, 0x158c, 0x28c7, 0x28c8, 0x03d7, 0x0a98, 
	0x0c76,      0, 0x28c9,      0, 0x28ca, 0x28cb, 0x28cc, 0x28cd, 
	     0, 0x28ce,      0,      0, 0x28cf, 0x28d0, 0x158d,      0, 
	     0, 0x23a1, 0x1284, 0x23a2, 0x23a3, 0x1289,      0,      0, 
	0x0b3b, 0x23a4, 0x1286,      0,      0, 0x23a5,      0, 0x23a6, 
	0x23a7,      0,      0,      0,      0, 0x23a8,      0, 0x128b, 
	     0,      0, 0x07fb, 0x128c, 0x23a9, 0x0dba, 0x0bb3,      0, 
	0x23aa, 0x12a2, 0x085f, 0x0d6e, 0x12a4, 0x12a5, 0x0dd7, 0x23c1, 
	     0,      0,      0, 0x12aa,      0, 0x23c2, 0x0651, 0x23c3, 
	0x0b90, 0x12a7, 0x0aeb, 0x1268, 0x126c, 0x23c4, 0x04ee, 0x23c5, 
	0x0b82,      0,      0,      0, 0x23c6, 0x12a9,      0, 0x082b, 
	0x0bdd, 0x03a4, 0x08d5, 0x1139, 0x1138, 0x059d, 0x09b9,      0, 
	0x113e, 0x113c, 0x2195, 0x113b, 0x0df4, 0x061e, 0x2196,      0, 
	0x2197, 0x0808, 0x113d, 0x0acb, 0x07cd,      0,      0, 0x2198, 
	0x0b1d, 0x1141, 0x1140,      0,      0, 0x2199, 0x219a, 0x113f, 
	     0, 0x27a6, 0x27a7, 0x0dee, 0x14f8, 0x27a8,      0,      0, 
	0x27a9,      0, 0x0970,      0,      0, 0x27aa,      0, 0x27ab, 
	0x27ac, 0x14fe, 0x27ad, 0x1500, 0x1501, 0x0a17,      0,      0, 
	     0,      0, 0x27ae, 0x14ff,      0, 0x14fc,      0, 0x14fa, 
	0x14fb, 0x25a8, 0x25a9, 0x13f3, 0x25aa, 0x13ed, 0x0d58,      0, 
	0x25ab, 0x25ac, 0x13e8, 0x25ad, 0x0753, 0x1400, 0x25ae, 0x25af, 
	0x25b0,      0, 0x044d,      0, 0x13ea, 0x13ef, 0x13f0,      0, 
	     0,      0,      0,      0,      0,      0, 0x09d1, 0x09bf, 
	     0, 0x0fa9, 0x1ed2,      0,      0, 0x09d4, 0x0fae, 0x0813, 
	0x1ed3,      0, 0x1ed4, 0x1ed5,      0, 0x0fab, 0x1ed6,      0, 
	0x0d75, 0x1ed7, 0x1ed8,      0, 0x0597,      0,      0, 0x0faf, 
	0x0fb0, 0x1ed9,      0, 0x1eda, 0x1edb, 0x0fad, 0x0fb3, 0x1edc, 
	     0, 0x17a9, 0x17ad,      0, 0x0bf2,      0,      0, 0x2bf5, 
	     0, 0x17ac, 0x0843, 0x077a, 0x17af,      0,      0, 0x053b, 
	0x2bf6, 0x2bf7, 0x2bf8, 0x2bf9, 0x2bfa,      0, 0x17b0, 0x2bfb, 
	0x0c70, 0x17ab, 0x2bfc, 0x1784,      0, 0x2bfd, 0x2bfe, 0x2bff, 
	0x2c00, 0x28a9,      0,      0,      0,      0, 0x28aa, 0x1562, 
	0x28ab,      0, 0x28ac, 0x1564, 0x1582, 0x1581, 0x28ad,      0, 
	     0,      0, 0x28ae,      0,      0, 0x28af, 0x28b0,      0, 
	     0,      0,      0, 0x0759, 0x28b1, 0x0e36, 0x28b2, 0x0783, 
	0x28b3, 0x10aa,      0, 0x10ab, 0x20bf, 0x0d71,      0, 0x20c0, 
	     0, 0x10ac, 0x20c1,      0, 0x20c2, 0x20c3, 0x0543, 0x20c4, 
	     0, 0x20c5, 0x07b1, 0x20c6,      0,      0, 0x20c7, 0x20c8, 
	     0, 0x10ad, 0x10ae, 0x078d, 0x0877, 0x0b51, 0x089f, 0x0c11, 
	0x0b5d, 0x18ab, 0x18b3, 0x18ac,      0, 0x18a8,      0, 0x0a9d, 
	0x18a7,      0,      0,      0, 0x18a5, 0x2dbb, 0x0d90, 0x0743, 
	     0, 0x2dbc, 0x18a9,      0, 0x18a6, 0x2dbd, 0x2dbe, 0x2dbf, 
	0x18ad, 0x0803,      0, 0x05fa,      0, 0x2dc0,      0, 0x09df, 
	0x2dc1, 0x1bab, 0x1bac, 0x0e3d, 0x1ba9,      0,      0, 0x1bad, 
	0x1bae, 0x3359, 0x335a, 0x1bb0,      0, 0x1baf, 0x335b, 0x335c, 
	0x335d, 0x335e, 0x335f, 0x1bb2, 0x3360,      0, 0x3361, 0x1bb3, 
	0x1bb1,      0,      0, 0x3362,      0,      0, 0x3363,      0, 
	     0, 0x2eab,      0, 0x2eac, 0x0436,      0, 0x194e,      0, 
	0x2ead, 0x2eae, 0x06d1, 0x194d,      0, 0x1956,      0,      0, 
	0x2eaf, 0x2eb0,      0, 0x1950, 0x1952, 0x0cba, 0x194f, 0x2eb1, 
	0x2eb2, 0x2eb3, 0x1951,      0, 0x1955, 0x1953, 0x04d0, 0x2eb4, 
	0x1954, 0x07ac,      0, 0x30f8, 0x30f9, 0x1a5a, 0x30fa, 0x1a5b, 
	0x0897, 0x1a5c, 0x30fb, 0x0e3b,      0,      0, 0x1a57, 0x1a5e, 
	0x1a60,      0, 0x1a5f,      0, 0x1a5d,      0,      0, 0x1a61, 
	     0,      0, 0x1a62, 0x30fc, 0x30fd, 0x0981, 0x30fe, 0x03e7, 
	     0, 0x31ac,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x20ad, 0x20ae, 0x0795, 0x1097, 0x04b4, 0x0b2f, 0x0d3a, 
	0x1098,      0, 0x1099,      0,      0, 0x0c50, 0x20af,      0, 
	0x20b0, 0x109b,      0, 0x0469, 0x0574, 0x109a,      0, 0x20b1, 
	0x20b2, 0x20b3, 0x20b4, 0x20b5, 0x0473,      0, 0x087d, 0x109f, 
	0x06f4, 0x27af, 0x14fd, 0x27b0, 0x27b1, 0x27b2,      0,      0, 
	0x27b3, 0x27b4, 0x1504, 0x27b5, 0x1502, 0x27b6, 0x1503,      0, 
	0x27b7,      0,      0, 0x27b8, 0x27b9,      0, 0x27ba, 0x27bb, 
	     0,      0, 0x27bc,      0, 0x27bd, 0x27be, 0x27bf, 0x27c0, 
	0x1505, 0x09b0, 0x30cd, 0x1a38,      0, 0x0c64,      0,      0, 
	     0,      0,      0,      0, 0x1a3b, 0x1a39, 0x0676,      0, 
	0x1a3a, 0x05fb,      0, 0x30ce,      0, 0x30cf,      0, 0x30d0, 
	0x30d1, 0x30d2,      0,      0, 0x0c9a, 0x1a3d, 0x1a3f, 0x1a3e, 
	0x1a40, 0x17b1, 0x2c0c,      0,      0, 0x0bb1, 0x2c0d, 0x2c0e, 
	0x17bb, 0x17b3, 0x2c0f, 0x17b5, 0x2c10, 0x2c11,      0,      0, 
	0x2c12, 0x17bf, 0x17b4,      0, 0x2c13, 0x17b8,      0,      0, 
	0x0399, 0x2c14, 0x0b42,      0, 0x17b9, 0x17bc, 0x2c15,      0, 
	0x2c16, 0x29b1, 0x161f, 0x161d,      0, 0x161b, 0x0462, 0x29b2, 
	0x083e, 0x1620,      0,      0, 0x161e,      0, 0x161c, 0x1624, 
	     0, 0x29b3, 0x1623, 0x1622, 0x1621,      0,      0, 0x29b4, 
	0x29b5,      0, 0x1625, 0x29b6, 0x29b7, 0x29b8, 0x1626, 0x08e3, 
	0x29b9, 0x1ab2, 0x1aae, 0x3191,      0, 0x1ab1,      0, 0x3192, 
	0x3193, 0x049c,      0,      0, 0x3194, 0x1ab3,      0, 0x1ab4, 
	     0,      0, 0x3195, 0x3196, 0x3197, 0x3198, 0x3199,      0, 
	     0,      0, 0x319a, 0x319b, 0x319c, 0x319d, 0x1ab5, 0x1ab6, 
	     0, 0x2bb2, 0x0c69, 0x1792, 0x0afe, 0x2bb3, 0x2bb4, 0x02fa, 
	0x2bb5,      0, 0x178b, 0x2bb6, 0x1787, 0x0979, 0x1781, 0x1789, 
	0x178e, 0x2bb7, 0x0b67,      0, 0x2bb8, 0x2bb9, 0x02f3, 0x2bba, 
	0x1786, 0x2bbb, 0x178f, 0x0c6f,      0, 0x2bbc, 0x2bbd,      0, 
	     0, 0x08b4, 0x16b9,      0, 0x2a79,      0, 0x2a7a, 0x16ba, 
	     0, 0x2a7b, 0x16bb,      0, 0x04a6, 0x2a7c,      0, 0x2a7d, 
	0x2a7e, 0x048e,      0, 0x2a7f, 0x16bc,      0,      0,      0, 
	     0,      0, 0x16bd, 0x2a80, 0x0d10, 0x0dd2, 0x2a81, 0x2a82, 
	0x2a83, 0x0bb4,      0, 0x0482, 0x0e47,      0,      0, 0x25c0, 
	     0,      0, 0x25c1, 0x25c2, 0x0d32, 0x0a73, 0x25c9,      0, 
	0x25c3, 0x25c4, 0x13fd, 0x13ff, 0x25c5,      0,      0, 0x25c6, 
	     0, 0x0939,      0,      0, 0x25c7, 0x25c8,      0, 0x1401, 
	0x13fb, 0x0fb5, 0x1ee2, 0x1ee3, 0x0fbf, 0x0938,      0, 0x1ee4, 
	0x0fc1, 0x1ee5, 0x0639, 0x0fb7, 0x0a40,      0,      0, 0x1ee6, 
	0x1ee7,      0, 0x1ee8, 0x1ee9, 0x1eea, 0x1eeb,      0,      0, 
	0x1eec, 0x0fbb, 0x0fb4, 0x046e,      0, 0x04af, 0x0448, 0x0fbc, 
	0x0fb8, 0x2eb5, 0x2eb6,      0, 0x2eb7,      0, 0x2eb8, 0x1957, 
	0x2eb9, 0x2eba, 0x0b95, 0x0e25,      0, 0x2ebb, 0x2ebc, 0x2ebd, 
	0x07c3,      0,      0,      0, 0x1958, 0x2ebe, 0x2ebf, 0x2ec0, 
	0x2ec1, 0x0d91, 0x195a, 0x2ec2, 0x1959,      0,      0, 0x195d, 
	0x0db0, 0x1bb6, 0x336c, 0x336d, 0x336e,      0, 0x336f,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x20b6, 0x03ce, 0x109e,      0, 0x109c, 0x10a0, 0x109d, 
	0x0b66, 0x1313, 0x087e,      0, 0x10a1,      0,      0, 0x0e0d, 
	0x20b7, 0x10a2, 0x20b8,      0, 0x10a4, 0x20b9, 0x0a41, 0x10a3, 
	     0, 0x08cc,      0, 0x074e,      0,      0, 0x20ba, 0x09b5, 
	0x07a8, 0x23b6,      0, 0x23b7,      0,      0,      0, 0x1297, 
	0x1298, 0x0d6b,      0, 0x0d35, 0x0d29, 0x0d0f, 0x06f8, 0x129a, 
	     0,      0, 0x079c,      0, 0x23b8, 0x0d04,      0, 0x129c, 
	0x129f, 0x129e,      0, 0x04ba,      0,      0, 0x04ff, 0x23b9, 
	0x129b, 0x07b7, 0x0737, 0x28da,      0, 0x28db,      0,      0, 
	0x28dc, 0x28dd, 0x1595, 0x28de, 0x07b8,      0,      0,      0, 
	0x28df,      0, 0x03cf, 0x0c3a,      0, 0x28e0, 0x1596, 0x28e1, 
	     0, 0x0c04,      0, 0x28e2,      0,      0, 0x28e3, 0x28e4, 
	0x094c, 0x18b7, 0x0dc7,      0,      0,      0,      0, 0x18ba, 
	     0, 0x18bd,      0,      0, 0x18bb, 0x0c2c, 0x2dca,      0, 
	     0, 0x2dcb,      0,      0, 0x18b8,      0,      0,      0, 
	0x2dcc,      0, 0x055d,      0,      0, 0x2dcd,      0, 0x18bc, 
	     0, 0x19b8, 0x19b9, 0x2f81, 0x2f82,      0, 0x2f83, 0x0be9, 
	0x06c8, 0x0792, 0x19ba,      0, 0x19bb, 0x0df1, 0x07d4, 0x0d7f, 
	0x0e19, 0x19bc, 0x055f,      0, 0x2f84, 0x2f85,      0, 0x19bd, 
	0x2f86, 0x0aa2, 0x2f87, 0x2f88, 0x19c0, 0x045b, 0x0896, 0x2f89, 
	0x19be, 0x2ab8, 0x060e,      0,      0, 0x0346, 0x16e3,      0, 
	     0,      0,      0,      0,      0,      0, 0x2ab9, 0x2aba, 
	0x16ea, 0x2abb, 0x16eb, 0x2abc, 0x2abd, 0x0b16,      0, 0x2abe, 
	     0, 0x0538, 0x2abf, 0x2ac0,      0, 0x16f6, 0x0b78, 0x2ac1, 
	     0, 0x2cb8,      0, 0x180f, 0x2cb9,      0,      0,      0, 
	0x2cba,      0,      0,      0, 0x1818, 0x2cbb, 0x2cbc, 0x2cbd, 
	0x1812,      0, 0x2cbe,      0, 0x181a,      0, 0x2cbf,      0, 
	     0,      0,      0, 0x0dd5, 0x181d,      0, 0x1814, 0x2cc0, 
	0x2cc1, 0x2fb8,      0, 0x2fb9, 0x2fba, 0x0ab3, 0x19cc, 0x2fbb, 
	0x2fbc, 0x19cf, 0x19cd, 0x2fbd, 0x19d2,      0, 0x2fbe, 0x2fbf, 
	0x2fc0, 0x19d3, 0x2fc1,      0,      0,      0,      0,      0, 
	0x19cb, 0x2fc2, 0x2fc3, 0x19d8, 0x039b, 0x2fc4, 0x2fc5, 0x19ca, 
	     0, 0x1eb9, 0x0340, 0x0fa7,      0,      0, 0x0f9f, 0x0fa0, 
	     0, 0x0812, 0x0d1c, 0x1eba,      0, 0x1ebb, 0x0fa5, 0x0fa4, 
	0x1ebc,      0,      0, 0x0aae,      0,      0,      0, 0x1ebd, 
	     0,      0,      0, 0x0fa6,      0, 0x1ebe, 0x0fa3, 0x1ebf, 
	0x1ec0, 0x02ba, 0x02bb, 0x02bc, 0x02bd, 0x02be, 0x02bf, 0x02c0, 
	0x02c1, 0x02c2, 0x02c3, 0x02c4, 0x02c5, 0x02c6, 0x02c7, 0x02c8, 
	0x02c9,      0, 0x02af, 0x1bf4, 0x1bf5, 0x1bf6, 0x1bf7, 0x1bf8, 
	0x1bf9, 0x1bfa, 0x1bfb, 0x1bfc, 0x1bfd, 0x1bfe,      0, 0x1bff, 
	0x1c00, 0x09ba, 0x114e,      0,      0, 0x21c6, 0x04fd, 0x1158, 
	0x08d6, 0x038c, 0x1152, 0x03fd, 0x1157,      0, 0x21c7,      0, 
	0x052e,      0, 0x1154,      0, 0x21c8,      0, 0x21c9,      0, 
	     0,      0,      0, 0x115a,      0,      0,      0,      0, 
	     0, 0x30bb, 0x1a31, 0x1a33,      0, 0x30bc, 0x1a32, 0x30bd, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x06bc,      0,      0, 0x0ed0,      0, 0x23b0,      0, 
	0x23b1, 0x05c9, 0x0d9c,      0, 0x0cd3,      0, 0x0c75, 0x23b2, 
	0x1294,      0,      0,      0, 0x23b3, 0x06e8, 0x0a60, 0x1295, 
	0x0e5a,      0, 0x23b4,      0, 0x0cf1, 0x23b5, 0x0a4c, 0x1296, 
	0x04bd, 0x1fbc, 0x101e,      0,      0, 0x0a8a,      0, 0x1fbd, 
	0x1fbe,      0,      0, 0x046f,      0,      0, 0x1fbf,      0, 
	0x1bb7, 0x0388, 0x0cc8, 0x1fc0,      0, 0x0859, 0x0ac7,      0, 
	     0,      0, 0x1fc1, 0x06db,      0,      0, 0x1024,      0, 
	0x1fc2, 0x14bd,      0, 0x0c32, 0x14be, 0x2762,      0, 0x0465, 
	0x14bf, 0x2763, 0x14c0, 0x2764, 0x2765,      0,      0, 0x14c1, 
	0x2766, 0x14c3, 0x14c4, 0x14c2,      0, 0x2767,      0, 0x0c4a, 
	0x14c6, 0x14c5,      0, 0x2768, 0x2769, 0x276a,      0,      0, 
	0x276b, 0x00be, 0x00bf, 0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 
	0x00c5, 0x00c6, 0x00c7, 0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 
	0x00cd, 0x00ce, 0x00cf, 0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 
	0x00d5, 0x00d6, 0x00d7, 0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 
	0x00dd, 0x05be, 0x09de, 0x1412, 0x0b76,      0, 0x25f1, 0x1419, 
	0x25f2, 0x25f3,      0, 0x25f4,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x141e, 0x141c,      0, 
	     0, 0x141f,      0, 0x25f5, 0x1422,      0,      0, 0x25f6, 
	0x141b, 0x1ec1, 0x1ec2,      0,      0, 0x035b, 0x1ec3, 0x06ab, 
	0x087b, 0x1ec4, 0x1ec5,      0,      0, 0x1ec6, 0x1ec7, 0x1ec8, 
	0x0fa1, 0x0ae1,      0,      0,      0, 0x0fa2, 0x1ec9, 0x02eb, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x05c2, 0x0752,      0, 0x0552, 0x24c4,      0,      0, 
	0x03a9, 0x24c5,      0,      0, 0x24c6, 0x24c7,      0,      0, 
	0x24c8,      0,      0, 0x0dce,      0,      0, 0x24c9, 0x24ca, 
	0x135c, 0x135b, 0x135e, 0x04dc, 0x24cb,      0, 0x0553, 0x047f, 
	0x24cc, 0x0dc3, 0x0e62,      0, 0x0664, 0x16c0, 0x0785, 0x16bf, 
	0x2a84, 0x2a85,      0, 0x2a86, 0x16c1, 0x075a, 0x2a87, 0x2a88, 
	0x2a89, 0x09b6, 0x2a8a, 0x16c2, 0x2a8b, 0x2a8c, 0x0663, 0x2a8d, 
	0x0d68, 0x16c3, 0x16c4,      0,      0, 0x16c5, 0x2a8e, 0x2a8f, 
	0x2a90, 0x2ec3, 0x2ec4, 0x195c, 0x2ec5, 0x0450, 0x195b, 0x1960, 
	0x2ec6,      0, 0x195f,      0,      0, 0x195e, 0x0ab1, 0x1961, 
	0x2ec7,      0, 0x2ec8, 0x2ec9, 0x2eca, 0x2ecb, 0x2ecc,      0, 
	0x1962, 0x2ecd,      0,      0,      0, 0x1963, 0x2ece, 0x2ecf, 
	0x0683, 0x0bc4, 0x2786, 0x0c24,      0, 0x14db, 0x0df9, 0x05a8, 
	0x14dc,      0, 0x14da, 0x0bef, 0x14dd,      0, 0x14de,      0, 
	0x2787, 0x0324, 0x2788,      0, 0x0863, 0x14e3,      0, 0x14e0, 
	0x0b4a, 0x14df, 0x2789, 0x278a, 0x278b, 0x278c, 0x278d, 0x278e, 
	0x04c5, 0x12c4, 0x05c0, 0x05a6, 0x0aec, 0x23f8, 0x23f9, 0x12c2, 
	     0, 0x030f,      0, 0x23fa,      0, 0x23fb, 0x12c5, 0x12c7, 
	     0, 0x054a, 0x0587, 0x23e9, 0x047d, 0x04ea, 0x23fc,      0, 
	0x23fd, 0x23fe, 0x12ca,      0, 0x23ff, 0x06ee, 0x0d24,      0, 
	0x070a, 0x22c4, 0x02f7,      0, 0x1211,      0, 0x22c5,      0, 
	     0,      0, 0x120e, 0x22c6,      0, 0x22c7,      0, 0x04b9, 
	     0,      0,      0, 0x22c8, 0x22c9, 0x038e, 0x22ca, 0x1214, 
	     0, 0x22cb, 0x22cc, 0x0db8,      0,      0,      0,      0, 
	     0, 0x09c5, 0x097e, 0x2eef, 0x0b05, 0x2ef0, 0x1974, 0x04f4, 
	     0, 0x2ef1,      0,      0, 0x197d, 0x2ef2, 0x197a, 0x1987, 
	0x0b06, 0x0a23, 0x1977,      0, 0x0a9f, 0x0ad2, 0x1978, 0x197c, 
	0x08ab, 0x2ef3, 0x0ba2, 0x0a6d, 0x2ef4,      0, 0x08eb, 0x197b, 
	0x0993, 0x11c6, 0x224c,      0, 0x224d, 0x224e,      0,      0, 
	0x224f, 0x11c7, 0x11c8, 0x0cbf,      0, 0x11ca, 0x11c9, 0x07ce, 
	     0, 0x08d7, 0x03eb, 0x0401, 0x2250, 0x11cb, 0x2251, 0x0308, 
	     0,      0,      0, 0x08f5, 0x11cc, 0x2252, 0x18e9, 0x11cd, 
	0x05bc, 0x2fc6, 0x2fc7, 0x0bc6,      0, 0x19ce, 0x2fc8, 0x084d, 
	0x2fc9, 0x2fca, 0x2fcb,      0,      0,      0,      0, 0x2fcc, 
	0x2fcd, 0x2fce, 0x0672,      0,      0,      0, 0x2fcf, 0x2fd0, 
	0x2fd1, 0x2fd2, 0x2fd3,      0, 0x2fd4, 0x2fd5, 0x2fd6, 0x0cfb, 
	0x2fd7, 0x05c7, 0x2cf1, 0x1833, 0x2cf2, 0x1832, 0x2cf3, 0x07bf, 
	     0, 0x2cf4, 0x2cf5, 0x2cf6, 0x2cf7, 0x066b, 0x13a9, 0x2cf8, 
	     0,      0, 0x2cf9, 0x1834, 0x07e0,      0, 0x2cfa, 0x2cfb, 
	0x041c, 0x2cfc, 0x1835, 0x2cfd, 0x0379, 0x2cfe, 0x0844, 0x1836, 
	0x2cff, 0x03c8,      0,      0, 0x0e41, 0x1e19, 0x1e1a, 0x1e1b, 
	0x1e1c,      0, 0x0804, 0x0ad7, 0x067c, 0x0f3c, 0x0f3d,      0, 
	0x1e1d, 0x1e1e, 0x0e32,      0,      0, 0x0e56, 0x0f3f, 0x1e1f, 
	0x1e20, 0x1e21, 0x0633, 0x1e22, 0x1e23, 0x0f3e, 0x1e24, 0x0412, 
	     0, 0x04c8,      0, 0x28ee, 0x28ef,      0,      0,      0, 
	0x28f0, 0x159b, 0x28f1, 0x28f2, 0x0a99, 0x28f3, 0x159c, 0x08f0, 
	     0,      0, 0x28f4,      0,      0, 0x0d3e, 0x28f5,      0, 
	0x0c1a, 0x159d, 0x159e, 0x0a18, 0x28f6, 0x0e14,      0, 0x28f7, 
	0x15a0, 0x08c8, 0x04a8,      0,      0, 0x0da9, 0x03f2, 0x07c7, 
	0x0614,      0, 0x1a53, 0x30ec, 0x1a52, 0x0746, 0x1a54, 0x1a51, 
	     0,      0, 0x06fb, 0x30ed,      0,      0, 0x1a58, 0x1817, 
	     0, 0x30ef, 0x0f70, 0x30f0, 0x08c2, 0x1a56, 0x30f1, 0x30f2, 
	0x30f3, 0x04c9,      0, 0x1635, 0x29cb, 0x0d84, 0x065f, 0x1634, 
	0x29cc, 0x29cd, 0x29ce, 0x1638, 0x0d77,      0, 0x0b77,      0, 
	0x29cf, 0x0c2a, 0x29d0, 0x29d1, 0x29d2, 0x07f2, 0x1637, 0x29d3, 
	0x0784, 0x0660, 0x0739, 0x0508, 0x0c8b, 0x1636, 0x29d4, 0x29d5, 
	     0, 0x06c9, 0x1473, 0x1472,      0, 0x2698,      0,      0, 
	0x1474,      0, 0x2699,      0,      0,      0, 0x269a, 0x269b, 
	     0,      0,      0, 0x1475, 0x269c,      0,      0, 0x1476, 
	     0,      0,      0,      0, 0x269d,      0,      0,      0, 
	     0, 0x07c9, 0x0899, 0x0e9c, 0x1ce9, 0x0e9a,      0, 0x0e9b, 
	0x04f7,      0,      0, 0x0698, 0x03f5,      0, 0x0e99, 0x0e98, 
	0x0c7e, 0x1cea,      0,      0,      0, 0x0719, 0x0718, 0x09a3, 
	0x0e9d, 0x0c4c, 0x0910, 0x1ceb, 0x1cec,      0, 0x00f5, 0x0e9e, 
	0x0ea0, 0x2ac9,      0,      0, 0x16ee, 0x2aca,      0,      0, 
	0x2acb,      0, 0x16ed,      0,      0, 0x2acc,      0,      0, 
	0x16ef, 0x2acd, 0x09e9,      0, 0x0b79,      0, 0x2ace,      0, 
	     0,      0, 0x0a52, 0x2acf,      0, 0x2ad0,      0, 0x16f3, 
	     0, 0x02ca, 0x02d5, 0x02cb, 0x02d6,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x02cc,      0,      0, 
	0x02d7, 0x02cd,      0,      0, 0x02d8, 0x02cf,      0,      0, 
	0x02da, 0x02ce,      0,      0, 0x02d9, 0x02d0, 0x02e5,      0, 
	     0, 0x0aca, 0x0779, 0x20cc, 0x20cd, 0x095f, 0x0de9,      0, 
	0x20ce, 0x20cf, 0x20d0,      0,      0, 0x10b6, 0x20d1, 0x10b7, 
	0x0b33, 0x20d2, 0x0706,      0,      0, 0x20d3, 0x20d4, 0x10b9, 
	     0,      0, 0x10ba, 0x20d5, 0x20d6, 0x20d7, 0x20d8,      0, 
	     0, 0x21ca, 0x115c, 0x1166, 0x1164,      0,      0, 0x1161, 
	0x21cb, 0x21cc, 0x21cd, 0x1160, 0x0e45, 0x21ce, 0x1162,      0, 
	     0, 0x052f, 0x21cf, 0x0648,      0, 0x21d0, 0x0809, 0x21d1, 
	0x21d2,      0, 0x1169, 0x115b,      0,      0, 0x21d3,      0, 
	0x115f, 0x18cc, 0x2de1,      0, 0x0711, 0x2de2, 0x2de3,      0, 
	     0,      0,      0, 0x1258, 0x2de4, 0x18cd, 0x2de5, 0x18ce, 
	0x2de6, 0x07c1,      0, 0x18cf, 0x18d0, 0x2de7, 0x2de8, 0x18d1, 
	     0,      0, 0x18d2, 0x18d3,      0, 0x2de9,      0, 0x2dea, 
	0x2deb, 0x01ce, 0x01cf, 0x01d0, 0x01d1, 0x01d2, 0x01d3, 0x01d4, 
	0x01d5, 0x01d6, 0x01d7, 0x01d8, 0x01d9, 0x01da, 0x01db, 0x01dc, 
	0x01dd, 0x01de, 0x01df, 0x01e0, 0x01e1, 0x01e2, 0x01e3, 0x01e4, 
	0x01e5, 0x01e6, 0x01e7, 0x01e8, 0x01e9, 0x01ea, 0x01eb, 0x01ec, 
	0x01ed, 0x27ce, 0x27cf, 0x0e12, 0x27d0, 0x27d1, 0x27d2, 0x1510, 
	0x150e, 0x150f, 0x27d3, 0x27cd, 0x27d4, 0x04a3,      0,      0, 
	     0,      0,      0, 0x0d8f,      0,      0, 0x27d5, 0x0c9f, 
	     0, 0x1512, 0x27d6,      0,      0, 0x1511,      0,      0, 
	0x27d7, 0x2bce, 0x179b, 0x2bcf,      0, 0x0a22,      0, 0x179c, 
	0x2bd0, 0x2bd1, 0x0dc5, 0x1791, 0x041b, 0x2bd2, 0x1797,      0, 
	0x2bd3, 0x179a, 0x0d3d,      0, 0x2bd4,      0,      0, 0x179d, 
	     0,      0, 0x1796, 0x1799,      0, 0x2bd5,      0,      0, 
	     0, 0x1fd1, 0x1fd2,      0, 0x052a,      0, 0x1026,      0, 
	0x1fd3, 0x1fd4, 0x1fd5, 0x1fd6,      0, 0x1fd7, 0x1fd8,      0, 
	0x1fd9, 0x1fda,      0,      0, 0x0cbd, 0x1fdb,      0, 0x1fdc, 
	0x0984,      0,      0,      0,      0, 0x0a67, 0x1fdd,      0, 
	0x1028, 0x26d1,      0,      0, 0x07d2,      0,      0, 0x26d2, 
	0x26d3, 0x1495, 0x26d4, 0x1494, 0x26d5, 0x26d6,      0, 0x26d7, 
	0x26d8, 0x1496, 0x26d9, 0x0430,      0,      0, 0x1498,      0, 
	0x26da, 0x1497, 0x26db, 0x149a, 0x1499, 0x26dc,      0,      0, 
	     0, 0x2ed2, 0x2ed3,      0, 0x1969, 0x2ed4, 0x2ed5, 0x2ed6, 
	0x0f3b, 0x0f3a,      0,      0,      0,      0, 0x196a, 0x1684, 
	0x196b, 0x09e7, 0x0876, 0x0b7b,      0,      0, 0x2ed7, 0x2ed8, 
	0x196c, 0x2ed9,      0, 0x0caa, 0x0a75, 0x0695,      0, 0x2eda, 
	0x09ec, 0x0dd3,      0,      0,      0, 0x256d, 0x13ca, 0x13c4, 
	0x13c1, 0x256e,      0, 0x256f, 0x0e21, 0x13c7,      0, 0x2570, 
	0x2571,      0, 0x07d9, 0x13c9,      0,      0, 0x13ce, 0x2572, 
	     0, 0x0af0, 0x13cc,      0, 0x2573,      0, 0x2574, 0x13c6, 
	0x2575, 0x04d4,      0, 0x0e8a,      0,      0, 0x0e8b, 0x0e08, 
	     0, 0x0dac, 0x096f, 0x0e8d, 0x0749, 0x0b50, 0x1ce3, 0x0e90, 
	     0,      0, 0x0365, 0x0618,      0, 0x0617, 0x032f, 0x1ce4, 
	0x1ce5, 0x0e76, 0x0e75,      0, 0x06a8, 0x02ea, 0x1ce6, 0x0e91, 
	0x0e92, 0x22d4,      0, 0x22d5,      0, 0x22d6, 0x22d7, 0x121a, 
	     0, 0x121e, 0x22d8, 0x22d9,      0, 0x0bdb, 0x0aea,      0, 
	0x22da, 0x22db,      0,      0,      0, 0x1217, 0x22dc, 0x121b, 
	     0,      0,      0, 0x05a3,      0,      0, 0x22dd, 0x06e6, 
	0x22de, 0x24d4, 0x1368, 0x0732, 0x08de, 0x0696,      0, 0x0c67, 
	0x24d5,      0, 0x0cb7, 0x0e6f, 0x24d6,      0,      0, 0x24d7, 
	0x0748, 0x24d8,      0,      0, 0x06c5, 0x0e3f, 0x24d9,      0, 
	     0, 0x1369, 0x136a,      0, 0x0733,      0, 0x24da, 0x24db, 
	0x136b, 0x31d4,      0, 0x31d5, 0x31d6, 0x31d7,      0,      0, 
	0x31d8, 0x09b2,      0,      0, 0x1ad6,      0, 0x31d9, 0x31da, 
	     0, 0x0b0a,      0,      0, 0x31db,      0, 0x31dc, 0x31dd, 
	0x1ad7, 0x31de,      0,      0,      0,      0,      0, 0x1adc, 
	     0, 0x1cd5, 0x1cd6, 0x0e87, 0x0b70, 0x1cd7, 0x04f6,      0, 
	0x1cd8,      0,      0,      0, 0x0b72,      0, 0x0b40, 0x05fc, 
	0x0ce6,      0, 0x1cd9,      0,      0,      0, 0x17d5, 0x0e88, 
	0x0855, 0x0e89, 0x03ba, 0x1cda,      0, 0x1cdb, 0x0562, 0x0629, 
	0x0d7a, 0x04d6, 0x0eea, 0x0eeb, 0x1dab, 0x03b4,      0, 0x1dac, 
	0x1dad, 0x1dae, 0x0ee9,      0, 0x1daf, 0x1db0, 0x1db1, 0x1db2, 
	     0, 0x1db4,      0, 0x07a5,      0, 0x0eee, 0x0eed, 0x0eec, 
	0x1db5, 0x0eb4, 0x1db6, 0x0eef, 0x1db7, 0x1db8, 0x1db9, 0x1dba, 
	0x080d, 0x2ad7, 0x2ad8,      0,      0,      0, 0x16f9, 0x16fa, 
	0x2ad9, 0x2ada, 0x2adb,      0, 0x07a1,      0, 0x2adc, 0x16f8, 
	0x2add, 0x068f, 0x16f7,      0,      0, 0x16fb,      0,      0, 
	0x2ade, 0x0a53, 0x0c77, 0x092a,      0,      0,      0,      0, 
	0x09c1, 0x0ed8, 0x1d7b,      0, 0x1d7c, 0x1d7d, 0x0eda, 0x1d7e, 
	     0,      0,      0, 0x1d7f,      0,      0, 0x0ce8, 0x1d80, 
	0x1d81, 0x1d82, 0x05c1, 0x1d83, 0x1d84, 0x1d85,      0, 0x1d86, 
	     0, 0x0704, 0x0c10, 0x0ed9, 0x1d87, 0x1d88,      0, 0x1d89, 
	0x1d8a, 0x11d9,      0,      0, 0x11d7, 0x2267,      0,      0, 
	     0, 0x11da,      0,      0,      0,      0, 0x2268, 0x0c86, 
	0x2269,      0, 0x0300,      0, 0x226a,      0,      0, 0x0c55, 
	     0,      0, 0x0bfc, 0x226b,      0, 0x11db, 0x226c, 0x11de, 
	0x0822, 0x12d9, 0x2413, 0x082c, 0x2414,      0, 0x2415, 0x1043, 
	0x0621, 0x0deb, 0x2416, 0x2417,      0,      0, 0x12d0, 0x2418, 
	0x0a95, 0x0406, 0x06a2, 0x2419, 0x12c8,      0, 0x12d8, 0x0444, 
	     0,      0, 0x12d6, 0x12da, 0x241a, 0x0aed,      0,      0, 
	     0, 0x23d9, 0x09ad, 0x23da, 0x23db, 0x0c96, 0x23dc, 0x12be, 
	     0, 0x23dd, 0x23de, 0x0c19,      0,      0,      0, 0x12bd, 
	0x0bab, 0x0cf2, 0x047c, 0x23df, 0x0920, 0x07cf,      0,      0, 
	0x23e0, 0x0a74, 0x23e1, 0x0d9d,      0, 0x23e2, 0x12b9, 0x12b8, 
	     0, 0x04da,      0, 0x11dc, 0x11e3, 0x0823,      0,      0, 
	     0,      0, 0x11dd, 0x0b7f,      0,      0, 0x226d, 0x226e, 
	0x226f, 0x2270, 0x0dcd, 0x11df, 0x11e0, 0x11e4, 0x0ae9, 0x11e1, 
	0x064a, 0x0907,      0,      0, 0x11f2, 0x0bcd,      0, 0x09d7, 
	     0, 0x1ada, 0x31e0, 0x1ad9, 0x1adb, 0x31e1, 0x1ad8,      0, 
	0x31df,      0,      0, 0x31e2, 0x31e3, 0x31e4, 0x1ade, 0x31e5, 
	     0,      0, 0x31e6,      0,      0, 0x31e7, 0x1add, 0x31e8, 
	0x1ae0,      0,      0, 0x0540, 0x1adf,      0, 0x31e9,      0, 
	0x1ae1, 0x2edb, 0x2edc, 0x0351,      0, 0x0d2b, 0x08a2, 0x2edd, 
	     0,      0,      0, 0x2ede, 0x2edf,      0, 0x2ee0, 0x05b9, 
	     0, 0x2ee1, 0x055e, 0x2ee2, 0x2ee3, 0x0cab, 0x2ee4,      0, 
	     0,      0,      0, 0x196d,      0,      0,      0,      0, 
	     0, 0x04dd,      0, 0x1477,      0,      0,      0,      0, 
	0x1478, 0x269e,      0,      0,      0, 0x05dd, 0x269f, 0x26a0, 
	0x0be1,      0, 0x26a1, 0x147a,      0, 0x26a2,      0, 0x0862, 
	     0,      0, 0x1479,      0,      0,      0,      0, 0x26a3, 
	     0, 0x1edd, 0x1ede,      0, 0x0faa, 0x1edf,      0, 0x1ee0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0, 0x0fb9, 0x0fbe,      0, 0x0fba, 
	0x1ee1, 0x26dd, 0x26de,      0, 0x26df, 0x05f5, 0x26e0, 0x26e1, 
	0x0df5,      0, 0x0549,      0, 0x03ab,      0,      0, 0x26e2, 
	     0, 0x26e3,      0,      0, 0x26e4,      0, 0x26e5, 0x0567, 
	0x26e6, 0x26e7,      0,      0,      0, 0x26e8,      0, 0x26e9, 
	0x26ea, 0x00de, 0x00df, 0x00e0, 0x00f4,      0, 0x00f6, 0x00f7, 
	0x00f8, 0x010f, 0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 
	0x0116, 0x0117, 0x0118, 0x0144, 0x0149, 0x0109, 0x010a,      0, 
	     0,      0,      0,      0,      0, 0x00fe,      0,      0, 
	     0, 0x0fde,      0,      0,      0, 0x1f2e, 0x1f2f, 0x0fdd, 
	0x0428, 0x1f30,      0, 0x0fdf, 0x1f31, 0x1f32,      0,      0, 
	0x0fe2,      0,      0,      0,      0, 0x0fe1, 0x1f33,      0, 
	     0,      0, 0x1f34, 0x1f35,      0,      0, 0x1f36, 0x1f37, 
	0x1f38, 0x1fde, 0x1fdf, 0x1fe0,      0,      0,      0, 0x1fe1, 
	     0, 0x0d02, 0x1fe2,      0, 0x1029,      0,      0, 0x102e, 
	     0,      0, 0x1fe3, 0x1fe4, 0x0c84,      0,      0,      0, 
	     0, 0x102d, 0x1027, 0x102a, 0x102c, 0x1fe6,      0, 0x069b, 
	     0, 0x29de, 0x29df, 0x07b9, 0x05f7, 0x094f, 0x1639, 0x163f, 
	0x29e0, 0x29e1,      0,      0, 0x163a, 0x05ab, 0x29e2, 0x1642, 
	0x1646, 0x05c6, 0x29e3,      0, 0x29e4,      0,      0, 0x1641, 
	0x29e5,      0, 0x29e6, 0x29e7, 0x164a, 0x29e8, 0x29e9, 0x0661, 
	     0, 0x02e0,      0,      0, 0x02db, 0x02d2, 0x02e7,      0, 
	     0, 0x02e2,      0,      0, 0x02dd, 0x02d1,      0,      0, 
	0x02e1, 0x02e6,      0,      0, 0x02dc, 0x02d3,      0,      0, 
	0x02e3, 0x02e8,      0,      0, 0x02de, 0x02d4,      0,      0, 
	0x02e4, 0x0ae0, 0x1df0, 0x1df1, 0x089a, 0x0f1f, 0x1df2, 0x0c81, 
	0x0903, 0x0463,      0, 0x046a, 0x0f20,      0,      0, 0x0f22, 
	     0,      0, 0x0595, 0x1df3, 0x1df4, 0x0f21, 0x1df5, 0x1df6, 
	0x0e40, 0x1df7,      0,      0,      0,      0, 0x07f8,      0, 
	     0, 0x0fe0,      0, 0x0b74,      0,      0, 0x0fe3, 0x1f39, 
	0x1f3a, 0x1f3b, 0x1f3c,      0, 0x1f3d, 0x1f3e, 0x1f3f, 0x0fe4, 
	     0,      0, 0x1f40,      0, 0x1f41, 0x0fe6,      0, 0x0fe5, 
	0x1f42,      0,      0,      0,      0, 0x0fe8,      0, 0x1f43, 
	     0, 0x20e0, 0x03b1, 0x20e1, 0x20e2,      0,      0, 0x20e3, 
	     0, 0x0942, 0x04a5, 0x20e4, 0x10bf, 0x0d39,      0,      0, 
	     0,      0, 0x09b7, 0x20e5, 0x043c, 0x20e6, 0x20e7, 0x10c1, 
	0x10c3, 0x04a0,      0, 0x20e8, 0x10c0, 0x10c2,      0, 0x10c5, 
	     0, 0x24e1,      0, 0x24e2, 0x24e3, 0x1373,      0,      0, 
	     0, 0x24e4, 0x24e5, 0x1374, 0x1375, 0x24e6, 0x24e7, 0x24e8, 
	0x1376, 0x24e9, 0x1378, 0x1377, 0x1379, 0x03aa, 0x0a0d,      0, 
	0x137a, 0x24ea, 0x24eb, 0x06f9, 0x042f, 0x137b, 0x24ec, 0x24ed, 
	0x0ac1, 0x2fe1,      0,      0,      0, 0x2fe2, 0x2fe3,      0, 
	0x2fe4, 0x2fe5,      0,      0, 0x2fe6,      0, 0x0933,      0, 
	0x2fe7,      0,      0, 0x2fe8,      0,      0,      0, 0x2fe9, 
	0x19db, 0x2fea, 0x19da, 0x2feb, 0x2fec, 0x2fed, 0x2fee,      0, 
	0x2fef, 0x28e5, 0x1599, 0x28e6, 0x159a, 0x0ba4, 0x28e7, 0x088c, 
	0x1597,      0, 0x0a24, 0x28e8, 0x28e9, 0x1598, 0x28ea,      0, 
	     0, 0x083b, 0x28eb,      0,      0,      0,      0,      0, 
	     0, 0x28ec,      0,      0, 0x0325, 0x28ed,      0,      0, 
	     0, 0x2ee5,      0, 0x196f, 0x2ee6, 0x2ee7, 0x196e, 0x03e5, 
	     0, 0x2ee8, 0x0b53, 0x1970, 0x0bb2,      0, 0x0ab2, 0x2ee9, 
	0x1971, 0x07e1, 0x2eea,      0,      0, 0x1973, 0x2eeb, 0x2eec, 
	0x0d53, 0x1982, 0x1975, 0x1976, 0x2eed,      0, 0x0a6a, 0x2eee, 
	     0, 0x04e6,      0, 0x3123, 0x1a82,      0,      0, 0x1a81, 
	     0, 0x1a80,      0,      0, 0x18b9, 0x3124, 0x0cb1, 0x3125, 
	     0,      0, 0x3126, 0x3127, 0x1a83, 0x1a84, 0x3128, 0x3129, 
	     0, 0x312a, 0x312b, 0x312c,      0, 0x312d,      0, 0x312e, 
	0x312f, 0x25e6, 0x1416,      0, 0x1415, 0x1417, 0x25e7, 0x25e8, 
	0x25e9, 0x25ea,      0, 0x141a,      0,      0,      0, 0x25eb, 
	0x25ec, 0x25ed, 0x0ac2,      0, 0x1414,      0, 0x25ee, 0x25ef, 
	     0,      0, 0x1418,      0,      0, 0x25f0,      0,      0, 
	     0, 0x08e8, 0x189b,      0, 0x18a0, 0x0626, 0x189d, 0x189e, 
	0x2da6, 0x189a, 0x2da7,      0,      0, 0x090b, 0x0b26, 0x2da8, 
	0x2da9, 0x09f2,      0, 0x03e2, 0x2daa,      0,      0, 0x2dab, 
	0x2dac,      0, 0x0c09,      0, 0x2dad, 0x04e2,      0, 0x2dae, 
	0x0a55, 0x27e8,      0, 0x27e9, 0x27ea, 0x27eb, 0x27ec, 0x27ed, 
	0x27ee, 0x27ef,      0, 0x27f0,      0,      0, 0x27f1, 0x0c02, 
	     0, 0x1528,      0,      0,      0, 0x1529,      0,      0, 
	0x1ba1, 0x152a, 0x152b, 0x152c,      0,      0, 0x27f2,      0, 
	0x0701, 0x19e9,      0,      0,      0, 0x3031, 0x3032,      0, 
	0x3033,      0, 0x3034, 0x3035,      0, 0x0588, 0x3036, 0x19eb, 
	0x3037, 0x3038, 0x3039,      0, 0x303a, 0x303b, 0x05e9, 0x303c, 
	     0,      0,      0, 0x303d,      0, 0x19ea, 0x303e, 0x084e, 
	0x303f, 0x22ea, 0x22eb,      0, 0x22ec,      0,      0,      0, 
	0x1220,      0, 0x0d13,      0,      0,      0, 0x22ed,      0, 
	0x1221,      0,      0,      0, 0x22ee, 0x22ef,      0, 0x1222, 
	     0, 0x0d5f,      0, 0x08cb, 0x22f0,      0, 0x22f1,      0, 
	     0, 0x00eb, 0x0195, 0x0196, 0x0197, 0x0198, 0x0199, 0x019a, 
	0x019b, 0x019c, 0x019d, 0x019e, 0x019f, 0x01a0, 0x01a1, 0x01a2, 
	0x01a3, 0x01a4, 0x01a5, 0x01a6, 0x01a7, 0x01a8, 0x01a9, 0x01aa, 
	0x01ab, 0x01ac, 0x01ad, 0x01ae, 0x010d, 0x0100, 0x010e, 0x1bc5, 
	     0, 0x0feb, 0x0fe9, 0x0fe7, 0x0fea,      0, 0x1f44,      0, 
	     0, 0x0fec, 0x1f45, 0x1f46, 0x1f47, 0x1f4a, 0x1f4b, 0x0fed, 
	0x1f48, 0x1f49, 0x0fee,      0, 0x0fef,      0,      0,      0, 
	0x0ff0, 0x0f01, 0x1f4c, 0x07ad, 0x0720, 0x1f4d, 0x1f4e, 0x03f8, 
	0x1f4f, 0x1aeb, 0x31f6,      0, 0x31f7, 0x08bc,      0, 0x31f8, 
	     0, 0x31f9,      0,      0,      0,      0,      0, 0x31fa, 
	0x1aec, 0x31fb, 0x1aed, 0x31fc, 0x1aee, 0x1aef, 0x31fd, 0x31fe, 
	0x31ff, 0x0679,      0,      0, 0x3200, 0x3201,      0, 0x1af0, 
	0x1af1, 0x26eb,      0, 0x26ec,      0,      0, 0x26ed, 0x26ee, 
	     0,      0, 0x04a2, 0x26ef, 0x26f0,      0, 0x26f1,      0, 
	     0,      0,      0, 0x0e35, 0x149c,      0, 0x26f2,      0, 
	0x26f3,      0, 0x26f4,      0, 0x149e, 0x26f5, 0x26f6,      0, 
	0x26f7, 0x1ced, 0x1cee, 0x1cef, 0x09ca, 0x0e2e, 0x0313,      0, 
	     0, 0x1cf0,      0,      0,      0,      0, 0x0e9f, 0x03c3, 
	0x1cf1, 0x0541, 0x1cf2, 0x0a2a, 0x1cf3,      0, 0x1cf4, 0x05ca, 
	0x0ea1,      0,      0,      0, 0x0b5f,      0, 0x1cf5, 0x1cf6, 
	0x1cf7, 0x01ee, 0x01ef, 0x01f0, 0x01f1, 0x01f2, 0x01f3, 0x01f4, 
	0x01f5, 0x01f6, 0x01f7, 0x01f8, 0x01f9, 0x01fa, 0x01fb, 0x01fc, 
	0x01fd, 0x01fe, 0x01ff, 0x0200, 0x0201,      0,      0,      0, 
	     0,      0,      0,      0, 0x00e8, 0x00e9, 0x00f2, 0x00f3, 
	     0, 0x02ee, 0x0c41, 0x0f9a,      0, 0x0f96,      0, 0x1eb5, 
	0x0f91, 0x0f97, 0x06bd, 0x1eb6,      0,      0, 0x1eb7, 0x1eb8, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0f9e,      0,      0,      0,      0,      0,      0, 
	     0, 0x2ff0, 0x2ff1, 0x2ff2, 0x2ff3,      0, 0x2ff4, 0x2ff5, 
	0x2ff6, 0x2ff7,      0,      0, 0x2ff8, 0x2ff9, 0x2ffa, 0x2ffb, 
	0x19d9, 0x2ffc,      0, 0x0ce2, 0x2ffd,      0, 0x2ffe,      0, 
	0x2fff, 0x3000, 0x3001,      0,      0, 0x3002, 0x3003,      0, 
	0x3004, 0x03f1, 0x18f2, 0x0e53, 0x0a63, 0x0e70, 0x2e14, 0x2e15, 
	0x0744, 0x18f1, 0x2e16, 0x0996, 0x2e17,      0, 0x1902, 0x092f, 
	0x2e18,      0, 0x0b55,      0, 0x0c47,      0, 0x2e1a, 0x2e19, 
	     0,      0, 0x2e1b, 0x18f5, 0x0712, 0x0745, 0x2e1c, 0x084b, 
	     0, 0x12f1, 0x12e4,      0, 0x12ee,      0, 0x2426,      0, 
	0x12e8, 0x2427,      0, 0x2428, 0x2429, 0x242a, 0x242b, 0x0884, 
	0x12f2, 0x242c, 0x242d, 0x08dc,      0,      0, 0x242e, 0x242f, 
	     0,      0, 0x12f0, 0x047e, 0x2430, 0x2431, 0x2432,      0, 
	     0, 0x32f1,      0,      0,      0,      0, 0x32f2, 0x1b74, 
	0x32f3,      0, 0x32f4,      0, 0x32f5,      0, 0x1b75, 0x32f6, 
	0x1b76, 0x32f7,      0, 0x0e74, 0x32f8, 0x32f9,      0,      0, 
	     0, 0x1b73, 0x09d0, 0x06e2,      0,      0, 0x1b77, 0x32fa, 
	     0, 0x17f2,      0, 0x0cdd, 0x17f3, 0x2c83, 0x2c84, 0x17f0, 
	0x2c85, 0x17f1, 0x17f6, 0x17f9, 0x2c86,      0, 0x17f7, 0x2c87, 
	0x2c88, 0x2c89, 0x17f5, 0x17ef, 0x2c8a, 0x2c8b,      0,      0, 
	     0, 0x0a1b, 0x2c8c, 0x1800,      0, 0x0d3b,      0, 0x2c8d, 
	0x2c8e, 0x0ff3, 0x1f5b, 0x1f5c, 0x0cb5, 0x0ff5,      0,      0, 
	0x1f5d, 0x0ff7, 0x0ff6, 0x1f5e, 0x0ff8, 0x1f5f, 0x0ff9,      0, 
	0x05d2,      0, 0x1f60, 0x0387, 0x0ffa,      0, 0x1f61, 0x0ffc, 
	     0, 0x0ffb,      0, 0x1f62, 0x1f63, 0x0ffe, 0x1f64,      0, 
	0x0ad9, 0x0ef6, 0x033d, 0x1dc7, 0x05ee, 0x0596, 0x07cb, 0x0a3e, 
	0x0521, 0x0911, 0x0630, 0x1dc8, 0x0685, 0x0ef8, 0x0d59, 0x0ac5, 
	0x1dc9, 0x074c,      0, 0x0ef7, 0x1dca, 0x0ef9, 0x1dcb,      0, 
	0x1dcc, 0x1dcd,      0, 0x0add,      0, 0x0458,      0,      0, 
	0x1dce, 0x0cf8, 0x0381, 0x032b,      0, 0x0b02, 0x2dc2, 0x2dc3, 
	0x18b1,      0,      0, 0x2dc9, 0x2dc4, 0x18b0,      0, 0x0b43, 
	     0, 0x18b5, 0x2dc5,      0,      0, 0x18aa,      0, 0x18b4, 
	0x18b6,      0, 0x05e5, 0x18b2, 0x066d, 0x2dc6, 0x0786, 0x2dc7, 
	0x2dc8, 0x0df8, 0x06c3, 0x09f8, 0x1206, 0x22b5, 0x0905, 0x22b6, 
	0x064c, 0x08af, 0x038d, 0x0943, 0x1204, 0x04e4, 0x22b7, 0x22b8, 
	0x22b9,      0,      0, 0x05a2,      0, 0x0a70, 0x120a,      0, 
	     0,      0,      0,      0, 0x0966,      0, 0x22ba, 0x120d, 
	     0, 0x1cf8, 0x04ac, 0x1cf9, 0x1cfa,      0,      0,      0, 
	     0, 0x1cfb, 0x0ea2, 0x0314, 0x1cfc, 0x1cfd, 0x0619, 0x04ad, 
	0x0c71, 0x0bcb, 0x04f8, 0x1cfe,      0,      0, 0x1cff, 0x1d00, 
	0x1d01,      0, 0x1d02, 0x03f6,      0, 0x0ec5, 0x0ac0,      0, 
	     0, 0x05f9,      0, 0x0a9c, 0x1886, 0x2d6f, 0x2d70,      0, 
	0x2d71, 0x05b2,      0, 0x08a1,      0, 0x1889,      0, 0x0b01, 
	0x2d72, 0x1888, 0x2d73, 0x2d74, 0x058c, 0x2d75, 0x2d76, 0x1887, 
	0x09dc, 0x04cc,      0,      0, 0x188a,      0, 0x188b, 0x2d77, 
	0x0846, 0x07f9, 0x11d4, 0x225b, 0x225c, 0x225d,      0, 0x225e, 
	0x0919, 0x199f, 0x0bfb,      0, 0x079b, 0x225f, 0x06c2, 0x11d5, 
	     0, 0x2260, 0x2261, 0x2262, 0x09ac, 0x2263, 0x0c7c, 0x2264, 
	     0, 0x09d6,      0, 0x2265, 0x11d8, 0x2266,      0, 0x11d6, 
	     0, 0x27fb, 0x1532,      0, 0x0487, 0x0bf0, 0x1533, 0x27fc, 
	0x1534, 0x27fd,      0, 0x1535,      0, 0x27fe,      0, 0x0d6d, 
	     0, 0x27ff, 0x2800, 0x0d66,      0, 0x0a5f,      0, 0x2801, 
	     0, 0x0971, 0x2802,      0, 0x1537, 0x2803,      0, 0x07f1, 
	     0, 0x15fc, 0x29a1,      0, 0x29a2, 0x1614, 0x1616,      0, 
	0x29a3,      0, 0x29a4,      0,      0, 0x1617, 0x29a5, 0x29a6, 
	     0, 0x29a7,      0, 0x29a8, 0x0c9b,      0, 0x1618,      0, 
	     0,      0, 0x29a9,      0,      0, 0x29aa, 0x29ab, 0x0d73, 
	     0, 0x0cfd, 0x1e85,      0,      0,      0,      0, 0x0bf6, 
	0x1e86, 0x1e87, 0x0f80, 0x1e88, 0x049f, 0x0f7b, 0x0f7c, 0x0f7e, 
	0x1e89,      0, 0x1e8a,      0,      0, 0x1e8b, 0x1e8c, 0x0f7f, 
	     0, 0x04fa, 0x08ac,      0, 0x0c82, 0x0f7d, 0x0f79, 0x061c, 
	     0, 0x15fd, 0x297e, 0x297f, 0x2980, 0x2981,      0, 0x2982, 
	0x15fe,      0, 0x2983,      0, 0x2984, 0x2985, 0x1603, 0x2986, 
	0x2987,      0, 0x15f8, 0x0f6f, 0x15ff, 0x15f9,      0,      0, 
	0x1602,      0, 0x2988,      0, 0x2989,      0,      0,      0, 
	0x1608, 0x10fe,      0,      0, 0x10fd, 0x10fc, 0x0c74,      0, 
	0x1105,      0, 0x2142,      0, 0x2140, 0x0d0d,      0, 0x10ff, 
	     0, 0x2141, 0x2143,      0,      0, 0x1101, 0x0d1e, 0x2144, 
	0x1100, 0x2145,      0,      0, 0x2146, 0x2147,      0, 0x2148, 
	0x1102, 0x25fe, 0x1427,      0,      0,      0, 0x25ff, 0x2600, 
	0x2601,      0, 0x1423,      0, 0x1424,      0, 0x2602,      0, 
	0x1428,      0, 0x1426,      0,      0,      0, 0x0c45,      0, 
	0x2603, 0x142e,      0, 0x142b, 0x142a,      0, 0x142d, 0x0b31, 
	0x142f, 0x0eff,      0, 0x0f00, 0x1dd2, 0x1dd3, 0x0b3f, 0x0386, 
	     0,      0, 0x0f03, 0x06f2, 0x1dd4, 0x0f02, 0x06bb, 0x1dd5, 
	0x0f04, 0x16e0, 0x0f05, 0x0cf4, 0x0f06,      0, 0x0f07, 0x0f08, 
	0x0856, 0x1dd6, 0x077d,      0,      0,      0, 0x1dd7,      0, 
	     0, 0x16ff, 0x2adf, 0x1700, 0x16fc, 0x2ae1, 0x2ae2, 0x2ae3, 
	     0, 0x16fd,      0, 0x16fe, 0x2ae4,      0,      0, 0x2ae5, 
	0x0668, 0x2ae0,      0,      0, 0x1706,      0, 0x1702, 0x2ae6, 
	     0, 0x2ae7,      0, 0x0c5d, 0x2ae8, 0x0d1f, 0x0c1f, 0x2ae9, 
	     0, 0x0078, 0x000c, 0x0019,      0,      0, 0x0005,      0, 
	0x0017, 0x009c,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0011, 0x009d, 0x006b, 0x0015, 0x0093, 0x00ae, 0x0018, 
	     0, 0x0003, 0x00ad, 0x0089, 0x001e, 0x0058,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x008f, 0x0091, 0x0008, 0x0075, 0x0084,      0,      0, 
	0x00b1,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0, 0x00bb, 0x005f, 0x00b6, 
	0x00a1, 0x0081, 0x007f, 0x0061, 0x0087, 0x0067, 0x006c, 0x0053, 
	0x0056, 0x00a6, 0x008b, 0x0059, 0x00ac, 0x0038, 0x004d, 0x006a, 
	0x00a2, 0x00bd, 0x009b, 0x0029, 0x008d, 0x007c, 0x001c, 0x004a, 
	0x0044, 0x0071, 0x001b, 0x0043, 0x0055, 0x0090, 0x0046, 0x007e, 
	0x0060, 0x0023, 0x003d, 0x00be, 0x007b, 0x00b0, 0x00ab, 0x0094, 
	0x00b7, 0x0026, 0x0036, 0x008e, 0x00ba, 0x0057, 0x004b, 0x005e, 
	0x004c, 0x0020, 0x0062, 0x00a3, 0x0014, 0x0085, 0x009a, 0x0042, 
	0x008a, 0x0034, 0x0065, 0x002c, 0x003f, 0x0013, 0x0016, 0x00a4, 
	0x00bf, 0x0088, 0x0050, 0x0041, 0x005b, 0x0072, 0x00b5, 0x0033, 
	0x004f, 0x00b8, 0x0074, 0x0097, 0x005c, 0x008c, 0x0040, 0x00a7, 
	0x0032, 0x006e, 0x0082, 0x00c0, 0x0098, 0x0064, 0x0063, 0x0024, 
	0x005d, 0x0048, 0x0092, 0x0083, 0x0021, 0x002f, 0x0077, 0x0007, 
	0x0049, 0x00b9, 0x0039, 0x00a0, 0x0096, 0x004e, 0x002d, 0x0076, 
	0x0031, 0x0073, 0x001d, 0x001f, 0x0045, 0x00bc, 0x0035, 0x0095, 
	0x0079, 0x0037, 0x006d, 0x0052, 0x0099, 0x00b2, 0x005a, 0x007a, 
	0x0068, 0x0006, 0x00af, 0x003c, 0x003b, 0x002b, 0x00b4, 0x007d, 
	0x0010, 0x00b3, 0x0066, 0x0086, 0x003e, 0x0025, 0x009e, 0x0047, 
	0x0028, 0x0054,      0, 0x0001, 0x009f, 0x000d, 0x0051, 0x006f, 
	0x002e, 0x0069, 0x0009, 0x0080, 0x0012, 0x00aa, 0x000b, 0x000f, 
	0x0027, 0x0022, 0x0002, 0x0030, 0x000a, 0x000e, 0x001a, 0x003a, 
	0x002a,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0, 0x00a9, 0x0070, 0x00a8,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0, 0x00a5, 
	0x0004,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0, 0x0054,      0, 
	     0,      0,      0,      0,      0,      0,     