/*
 *      error.c         logo error module                       dvb
 *
 *	Copyright (C) 1993 by the Regents of the University of California
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "logo.h"
#include "globals.h"

#ifdef HAVE_TERMIO_H
#include <termio.h>
#else
#ifdef HAVE_SGTTY_H
#include <sgtty.h>
#endif
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef mac
#include <console.h>
#endif

NODE *throw_node = NIL;
NODE *err_mesg = NIL;
ERR_TYPES erract_errtype;

char *message_texts[MAX_MESSAGE];

void err_print(void) {
    int save_flag = stopping_flag;
    int errtype;
    NODE *errargs, *oldfullp;
    
    if (!err_mesg) return;

    stopping_flag = RUN;
	oldfullp = valnode__caseobj(Fullprintp);
    setvalnode__caseobj(Fullprintp, True);

    errtype = getint(car(err_mesg));
    errargs = cadr(err_mesg);

    force_printdepth = 5;
    force_printwidth = 80;
    if (errargs == NIL)
	ndprintf(stdout, message_texts[errtype]);
    else if (cdr(errargs) == NIL)
	ndprintf(stdout, message_texts[errtype], car(errargs));
    else
	ndprintf(stdout, message_texts[errtype], car(errargs), cadr(errargs));

    if (car(cddr(err_mesg)) != NIL) {
	ndprintf(stdout, message_texts[ERROR_IN], car(cddr(err_mesg)),
						  cadr(cddr(err_mesg)));
    }
    err_mesg = NIL;
    new_line(stdout);

    setvalnode__caseobj(Fullprintp, oldfullp);
    stopping_flag = save_flag;
}

NODE *err_logo(ERR_TYPES error_type, NODE *error_desc) {
    BOOLEAN recoverable = FALSE, warning = FALSE, uplevel = FALSE;
    NODE *err_act, *val = UNBOUND;

    switch(error_type) {
	case FATAL:
	    prepare_to_exit(FALSE);
	    ndprintf(stdout,"%s\n",message_texts[FATAL]);
	    exit(1);
	case OUT_OF_MEM_UNREC:
	    prepare_to_exit(FALSE);
	    ndprintf(stdout,"%s\n",message_texts[OUT_OF_MEM_UNREC]);
	    exit(1);
	case OUT_OF_MEM:
	    use_reserve_tank();
	    break;
	case DIDNT_OUTPUT:
	    if (didnt_output_name != NIL) {
		last_call = didnt_output_name;
	    }
	    if (error_desc == NIL) {
		error_desc = car(didnt_get_output);
		ufun = cadr(didnt_get_output);
		this_line = cadr(cdr(didnt_get_output));
	    }
	    err_mesg = cons_list(0, last_call, error_desc, END_OF_LIST);
	    recoverable = TRUE;
	    break;
	case NOT_ENOUGH:
	    if (error_desc == NIL)
		err_mesg = cons_list(0, fun, END_OF_LIST);
	    else
		err_mesg = cons_list(0, error_desc, END_OF_LIST);
	    break;
	case BAD_DATA:
	    recoverable = TRUE;
	case BAD_DATA_UNREC:
	    err_mesg = cons_list(0, fun, error_desc, END_OF_LIST);
	    break;
	case DK_WHAT_UP:
	    uplevel = TRUE;
	case DK_WHAT:
	    err_mesg = cons_list(0, error_desc, END_OF_LIST);
	    break;
	case DK_HOW:
	case APPLY_BAD_DATA:
	case NO_VALUE:
	    recoverable = TRUE;
	case DK_HOW_UNREC:
	case NO_CATCH_TAG:
	case ALREADY_DEFINED:
	case FILE_ERROR:
	case IS_PRIM:
	case AT_TOPLEVEL:
	case ERR_MACRO:
	case DEEPEND:
	    err_mesg = cons_list(0, error_desc, END_OF_LIST);
	    break;
	case SHADOW_WARN:
	    err_mesg = cons_list(0, error_desc, END_OF_LIST);
	case IF_WARNING:
	    warning = TRUE;
	    break;
	case USER_ERR_MESSAGE:
	    uplevel = TRUE;
	    err_mesg = cons_list(0, error_desc, END_OF_LIST);
	    break;
	case NO_TEST:
	    err_mesg = cons_list(0, fun, END_OF_LIST);
	    break;
	default:
	    err_mesg = NIL;
    }
    didnt_output_name = NIL;
    if (uplevel && ufun != NIL) {
	ufun = last_ufun;
	this_line = last_line;
    }
    if (ufun != NIL)
	err_mesg = cons_list(0, err_mesg, ufun, this_line, END_OF_LIST);
    else
	err_mesg = cons_list(0, err_mesg, NIL, NIL, END_OF_LIST);
    err_mesg = cons(make_intnode((FIXNUM)error_type), err_mesg);
    if (warning) {
	err_print();
	return(UNBOUND);
    }
    err_act = valnode__caseobj(Erract);
    if (err_act != NIL && err_act != UNDEFINED) {
	if (error_type != erract_errtype) {
	    int sv_val_status = val_status;

	    erract_errtype = error_type;
	    setvalnode__caseobj(Erract, NIL);
	    val_status = 5;
	    val = err_eval_driver(err_act);
	    val_status = sv_val_status;
	    setvalnode__caseobj(Erract, err_act);
	    if (recoverable == TRUE && val != UNBOUND) {
		return(val);
	    } else if (recoverable == FALSE && val != UNBOUND) {
		ndprintf(stdout, message_texts[DK_WHAT], val);
		ndprintf(stdout, "\n");
		val = UNBOUND;
		throw_node = Toplevel;
	    } else {
		/* if (err_mesg != NIL) */  {	/* is this ever wrong? */
		    throw_node = Error;
		    stopping_flag = THROWING;
		    output_node = UNBOUND;
		}
		return(UNBOUND);
	    }
	} else {
	    ndprintf(stdout,"%t\n", message_texts[ERRACT_LOOP]);
	    throw_node = Toplevel;
	}
    } else {	/* no erract */
	throw_node = Error;
    }
    stopping_flag = THROWING;
    output_node = UNBOUND;
    return(val);
}

NODE *lerror(NODE *args) {
    NODE *val;

    val = err_mesg;
    err_mesg = NIL;
    return(val);
}

#ifndef HAVE_MEMCPY
void memcpy(char *to, char *from, size_t len) {
    while (--len >= 0)
	*to++ = *from++;
}
#endif

NODE *lpause(NODE *args) {
    NODE *elist = NIL, *val = UNBOUND, *uname = NIL;
    int sav_input_blocking;
    int sv_val_status;
#ifndef TIOCSTI
    jmp_buf sav_iblk;
#endif

    if (err_mesg != NIL) err_print();
 /* if (ufun != NIL) */ {
	uname = ufun;
	ndprintf(stdout, "%t\n", message_texts[PAUS_ING]);
#ifndef TIOCSTI
	memcpy((char *)(&sav_iblk), (char *)(&iblk_buf), sizeof(jmp_buf));
#endif
	sav_input_blocking = input_blocking;
	input_blocking = 0;
#ifdef mac
	csetmode(C_ECHO, stdin);
	fflush(stdin);
#endif
	sv_val_status = val_status;
	while (RUNNING) {
	    if (uname != NIL) print_node(stdout, uname);
	    elist = reader(stdin, "? ");
	    if (NOT_THROWING) elist = parser(elist, TRUE);
	    else elist = NIL;
#ifndef WIN32
	    if (feof(stdin) && !isatty(0)) lbye(NIL);
#endif
#ifdef __RZTC__
	    if (feof(stdin)) rewind(stdin);
#endif
	    val_status = 5;
	    if (elist != NIL) eval_driver(elist);
	    if (stopping_flag == THROWING) {
		if (compare_node(throw_node, Pause, TRUE) == 0) {
		    val = output_node;
		    output_node = UNBOUND;
		    stopping_flag = RUN;
#ifndef TIOCSTI
		    memcpy((char *)(&iblk_buf), (char *)(&sav_iblk),
			   sizeof(jmp_buf));
#endif
		    input_blocking = sav_input_blocking;
		    val_status = sv_val_status;
			if (uname != NIL) {
				ufun = uname;
			}
		    return(val);
		} else if (compare_node(throw_node, Error, TRUE) == 0) {
		    err_print();
		    stopping_flag = RUN;
		}
	    }
	}
#ifndef TIOCSTI
	memcpy((char *)(&iblk_buf), (char *)(&sav_iblk), sizeof(jmp_buf));
#endif
	input_blocking = sav_input_blocking;
	unblock_input();
	val_status = sv_val_status;
	if (uname != NIL) {
		ufun = uname;
	}
/*  } else {
	stopping_flag = THROWING;
	throw_node = Toplevel;
 */ }
    return(val);
}

NODE *lcontinue(NODE *args) {
    stopping_flag = THROWING;
    throw_node = Pause;
    if (args != NIL)
	output_node = car(args);
    else
	output_node = UNBOUND;
    return(UNBOUND);
}
