/* ==================================================== ======== ======= *
 *
 *  ustyle.hh
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _ustyle_hh
#define	_ustyle_hh
//pragma ident	"@(#)ustyle.hh	ubit:03.02.00"
#include <ubit/ucontext.hpp>

/** Box Style.
 * specify the appearanace of UGroup / UBox  / UWin objects and subclasses.
 * - Note that a same class may use several UStyles depending on context
 *   (ie. on them class of the object's parents)    
 */
class UStyle {
public:
  mutable ULocalProps local;
  mutable UFont   *font;
  mutable UCursor *cursor;
  mutable UBackground *background;
  mutable UColor  **fgcolors;
  mutable UColor  **bgcolors;
  mutable class UViewStyle *viewStyle;
  // text separator between two children when printing
  mutable UStr    *textSeparator;
  mutable char orient;

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  UStyle();
  //virtual void adapt(const class UContext*) const {}

  void set(const UStyle *model) {*this = *model;}
  ///< copies the model

  const UColor* getColor(const UCtrl*) const;
  const UColor* getBgcolor(const UCtrl*) const;

  void setColors(int action, UColor&, 
		 bool when_unselected = true, bool when_selected = true);
  void setBgcolors(int action, UColor&,
		 bool when_unselected = true, bool when_selected = true);

  static UColor** makeColors(UColor *off, UColor *on);
  static void setColor(UColor**, int action, UColor*);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
