/* ==================================================== ======== ======= *
 *
 *  unatappli.hpp  [Native Layer: platform dependent implementation]
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _unatappli_hpp_
#define	_unatappli_hpp_
//pragma ident	"@(#)unatappli.hpp	ubit:03.06.04"
#include <ubit/config.h>
#include <ubit/unatdisp.hpp>


class UNatAppli { // : public UNatDisp {
public:
  UNatAppli(class UAppli&, class UNatDisp&);
  virtual ~UNatAppli();

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  void setProperties(int argc, char** argv);
  ///< initializes actual X data.

  void eventLoop(int& loop_status);
  ///< starts the mainloop or a subloop

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  static void getTime(struct timeval&);
  static u_time convertToMilliSec(struct timeval&);
  bool resetTimers(UGroup* timers, struct timeval& delay);
  void fireTimers(UGroup* timers);

  void resetInputs(UGroup* inputs, fd_set& read_set, int& maxfd);
  void cleanInputs(UGroup* inputs);
  void fireInputs(UGroup* inputs, fd_set& read_set);

  private:
  class UAppli& appli;
  class UNatDisp& natdisp;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
