
#include <ubit/ubit.hpp>

class TTMain : public UFrame { 
public:
  UBox *statusbar;
  UBox    *scene;
  UScrollpane  *main_pane;
  URadioSelect *show_mode;
  UStr  *xpos, *ypos, *message;
  int rowCount, colCount;
  UScale *scene_scale;

  TTMain();

  void makeSmallView();
  void closeSmallView(UEvent&);

  void addTool(int tooltype);
  void moveMouseCB(UEvent&);
  void pressMouseCB(UEvent&);
};

class Cell : public UTextbox {
  UColor   fg;
  UFont    font;
public:
  Cell(const char*);
  void applyTool(UEvent&);
};

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

class Lens : public UVbox {
protected:
  UPos   pos;
  u_pos  last_x, last_y;
  ULabel lens_handle;
  UVbox  help_message;
  virtual void pressLens(UEvent&);
  virtual void dragLens(UEvent&);
  virtual void deleteLens(UEvent&);
public:
  Lens(const char* title, u_pos x, u_pos y);
};

// Transparent Note
class Note : public Lens {
  UColor text_color;
public:
  Note(const char* title, u_pos x, u_pos y);
};


// Transparent Tool
class TTool : public Lens {
public:
  TTool(const char* title, u_pos x, u_pos y);
protected:
  void flag(UEvent&, UProp*);
  void flag(UEvent&, UColor*);
  void flag(UEvent&, UFont*);
};

// Cross Tool
class CTool : public Lens {
  UHbox crossbox;
public:
  CTool(const char* title, u_pos x, u_pos y);
protected:
  void flag(UEvent&, UProp*);
    void flag(UEvent&, UColor*);
  void flag(UEvent&, UFont*);
  
  void paintCross(UEvent&);
};


