/* ==================================================== ======== ======= *
 *
 *  dchart.cc  [demo]
 *  Ubit Project [Elc::00]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:00] ======= *
 * ==================================================== ======== ======= */


#include <ubit/ubit.hpp>
#include <ubit/ugraph.hpp>
#include "dmisc.hh"
#include "dchart.hh"


/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */


ChartDialog::ChartDialog(CHART *chart) {

  //adds children to "this" object (= the Dialog)
  addlist
    ( utitle("Charts")
      + uvflex()
      + (chartbox = &uhbox( UBorder::shadowIn
			    + UBgcolor::white
			    + ubottom() // buttons located on the bottom 
			    + uheight(150)    // height of the bchartbox
			    //+ ucall(this, &paintDrawing, UOn::paint) 
			    ))
      + utop()
      + ubar(ulabel(UBorder::shadowIn + "Click on Bar to Select "))

      + uhbox(UBorder::shadowIn 
	      // closes the dialog box when the Close button is pressed
	      + ubutton(UFont::bold + "Close" + ucloseWin()))
      );
  
  //Conditionnal colors
#if TOTO
    UBgcolor &enter_color = 
      ubgcolor(UColor::wheat)
      .condset(UColor::wheat, UOn::enter);

    UBgcolor &on_bgcolor =
      ubgcolor(UColor::orange)
      .condset(UColor::orange, UOn::select);

    UColor &on_fgcolor = 
      ucolor(UColor::wheat)
      .condset(UColor::wheat, UOn::select);
#endif

    UButton *btn = null;
    for (int k = 0; chart[k].name != null; k++) {

      // initialize fields 'sval' and 'sname' for further modifications
      char buf[10]; 
      sprintf(buf, "%d", chart[k].value);
      chart[k].strval = &ustr(buf);
      chart[k].strname = &ustr(chart[k].name);

      chartbox->add(btn = &ubutton());

      btn->addlist
	(
	 UOrient::vertical + utop() + uhcenter()
	 + UMode::canSelect // button can be selected
	 // color when entered and when on
	 + UOn::unselect / UBgcolor::grey
	 + UOn::select / UBgcolor::orange
	 + UOn::enter / UBgcolor::wheat

	 // height of the button (depends on chart[] value)
	 + uheight(chart[k].value)

	 // blue bold name
	 + UColor::blue + UFont::bold + chart[k].strname

	 // red value (except when selected)
	 + UOn::unselect / UColor::red
	 + UOn::select / UColor::white
	 + UOn::enter / UColor::black

	 + chart[k].strval
	 );
    }
};


/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */
