/* ==================================================== ======== ======= *
 *
 *  uucolor.cc
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//#pragma ident	"@(#)uucolor.cc		ubit:b1.11.7"
#include <udefs.hh>
#include <ubrick.hh>
#include <ucontext.hh>
#include <ustr.hh>
#include <uctrl.hh>
#include <ucolor.hh>
#include <uappli.hh>
#include <ubox.hh>

const UClass UColor::uclass("UColor");
const UClass UBgcolor::uclass("UBgcolor");

UColor UColor::inherit(-3,"inherit", UMode::UCONST);
UColor UColor::none(-2,"none", UMode::UCONST);
UColor UColor::disabled("grey55", UMode::UCONST);
UBgcolor UBgcolor::inherit(-3,"inherit", UMode::UCONST);
UBgcolor UBgcolor::none(-2,"none", UMode::UCONST);

UColor UColor::white("white",     UMode::UCONST);
UColor UColor::black("black",     UMode::UCONST);
//UColor UColor::grey("gray84",     UMode::UCONST);
UColor UColor::grey("#dadada",     UMode::UCONST);
UColor UColor::lightgrey("grey94",UMode::UCONST);
//UColor UColor::darkgrey("grey75", UMode::UCONST);
UColor UColor::darkgrey("#bababa", UMode::UCONST);
UColor UColor::navy("navy",       UMode::UCONST);
UColor UColor::blue("blue",       UMode::UCONST);
UColor UColor::red("red",         UMode::UCONST);
//UColor UColor::green("green",     UMode::UCONST); trop clair!
UColor UColor::green("#00dd00",     UMode::UCONST);
UColor UColor::yellow("yellow",   UMode::UCONST);
UColor UColor::orange("orange",   UMode::UCONST);
UColor UColor::wheat("wheat",     UMode::UCONST);
UColor UColor::teal("CadetBlue",  UMode::UCONST);

UBgcolor UBgcolor::white("white", UMode::UCONST);
UBgcolor UBgcolor::black("black", UMode::UCONST);
//UBgcolor UBgcolor::grey("gray85", UMode::UCONST);
UBgcolor UBgcolor::grey("#dadada", UMode::UCONST);
UBgcolor UBgcolor::lightgrey("grey95",UMode::UCONST);
//UBgcolor UBgcolor::darkgrey("grey75", UMode::UCONST);
UBgcolor UBgcolor::darkgrey("#bababa", UMode::UCONST);
UBgcolor UBgcolor::navy("navy",   UMode::UCONST);
UBgcolor UBgcolor::blue("blue",   UMode::UCONST);
UBgcolor UBgcolor::red("red",     UMode::UCONST);
//UBgcolor UBgcolor::green ("green",UMode::UCONST);
UBgcolor UBgcolor::green("#00dd00",   UMode::UCONST);
UBgcolor UBgcolor::yellow("yellow",   UMode::UCONST);
UBgcolor UBgcolor::orange("orange",   UMode::UCONST);
UBgcolor UBgcolor::wheat("wheat",     UMode::UCONST);
UBgcolor UBgcolor::teal("CadetBlue",  UMode::UCONST);

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UColor& ucolor(const UColor &col) {
  return *(new UColor(col));
}

// reserve a l'usage interne
UColor::UColor(int _ix, const char *colname, u_modes m) : UProp(m) {
  natspec = null;
  natspec = colname ? u_strdup(colname) : null;
  //ne sert que pour none et inherit
  ix = _ix;  //valeurs speciales negatives => couleur jamais allouee
}

UColor::UColor(const char *colspec, u_modes m) : UProp(m) {
  natspec = colspec ? u_strdup(colspec) : null;
  ix = 0;  //0 means 'unitialized'
}

UColor::UColor(const UColor &c, u_modes m) : UProp(m) {
  natspec = c.natspec ? u_strdup(c.natspec) : null;
  ix = c.ix;
}

UColor::~UColor() {
  if (natspec) free(natspec);
}

void UColor::set(const UColor *c, u_bool upd) {
  if (!c) error("set", "null argument!");
  else set(*c, upd);
}

void UColor::set(const UColor &c, u_bool upd) {
  if (equals(c)) return;

  if (natspec) free(natspec);
  natspec = c.natspec ? u_strdup(c.natspec) : null;
  ix = c.ix;
  changed(upd);
}

void UColor::set(const char* colspec, u_bool upd) {
  if (!colspec || !*colspec || !natspec) {
    error("set", "null argument or unspecified color");
    return;
  }
  if (strcmp(natspec,colspec)==0) return;

  if (natspec) free(natspec);
  natspec = u_strdup(colspec);
  ix = 0;  //0 means 'unitialized' color
  changed(upd);
}

void UColor::set(const UStr &colspec, u_bool upd) {
  set(colspec.chars(), upd);
}
void UColor::set(const UStr* colspec, u_bool upd) {
  set(colspec->chars(), upd);
}

u_bool UColor::equals(const UColor &c) const {
  // cas ou les couleurs n'ont pas encore ete realisees
  // (nb: exclut cas speciaux des couleurs -1, -2, -3)
  if (ix == 0 || c.ix == 0) {
    if (!natspec || !c.natspec) {
      error("equals", "unspecified colors");
      return false;
    }
    else return (strcmp(natspec, c.natspec) == 0);
  }
  else return (ix == c.ix);
}

u_bool UColor::equals(const UColor *c) const {
  if (c) return equals(*c);
  else {
    error("equals", "null argument");
    return false;
  }
}

void UColor::update() {
  parents.updateParents(UUpdate::paint); //size unchanged
}

void UColor::putProp(UContext *props, UCtrl *state) {
  props->color = this;
}

// - la valeur ix==0 est reservee pour "the unknown color"
//   Cette valeur 0 de la virtualColormap est initialisee a une color
//   par defaut (typiquement black or white) par: UDispCtx::realize()
//
// - realize() cherche a allouer la couleur par XAllocColor quand ix == 0
//   en cas d'echec (ou si on a oublie de faire realize) ix reste == 0
//   et c'est donc "the unknown color" qui est utilisee
//
u_bool UColor::realize(UDisp *d) {
  return d->realizeColor(this);
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UBgcolor& ubgcolor(const UColor &c) {
  return *(new UBgcolor(c));
}

// ce constructeur est reserve a l'usage interne
UBgcolor::UBgcolor(int _ix, const char *colname, u_modes m): 
  UColor(_ix, colname, m){}

UBgcolor::UBgcolor(const char *colspec, u_modes m) : 
  UColor(colspec, m) {}

UBgcolor::UBgcolor(const UColor &c, u_modes m) : 
  UColor(c, m) {}

void UBgcolor::putProp(UContext *props, UCtrl *state) {
  props->bgcolor = this;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
