/* ==================================================== ======== ======= *
 *
 *  uucall.cc
 *  Ubit Project  [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)ucall.cc	ubit:b1.10.1"
#include <udefs.hh>
#include <ubrick.hh>
#include <uprop.hh>
#include <ucall.hh>
#include <ubox.hh>
#include <uevent.hh>
#include <uwin.hh>
#include <uview.hh>
#include <umenu.hh>


const UClass UCall::uclass("UCall");
 
UCall::UCall() {
  //  cond = null;
  cond = &UOn::action;  //default
}
UCall::UCall(UCond *_cond) {
  cond = _cond;
}
UCall::UCall(UCond &_cond) {
  cond = &_cond;
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

void UCall::addingTo(ULink *selflink, UGroup *parent) {

  // compatibilite avec ancient style (UOn dans le UCond) :
  // si le champ 'cond' est defini alors on le reporte dans
  // le champ 'cond' du link (sauf si lui-meme est deja defini)

  // Attention:
  // -- les UCall peuvent etre partages : il ne faut donc en aucun cas
  //    recopier le 'cond' d'un link dans un UCall
  // -- attention a la mise en place d'un 'cond' defaut
  //    autrefois on mettait &UOn::action comme defaut ce qui avait
  //    pour effet d'ecraser les valeurs definies dans les links

  //!! FAUX: if (!cond) cond = &UOn::action; //default

  if (cond) {
    if (!selflink->cond) selflink->cond = cond;
  }

  // ensuite!
  UBrick::addingTo(selflink, parent);
  //NB: cette fct fera: parent->setModes(selflink->cond);
}

void UCall::removingFrom(ULink *selflink, UGroup *parent) {
  // ne PAS faire " par->setCmodes(on, false) " car il peut y avoir
  // plusieurs callbacks avec la meme condition
  // (et de toute facon ce n'est pas une erreur, juste un peu plus long)

  // A TERME: liberer le CACHE !!
  UBrick::removingFrom(selflink, parent);
}

UCall& ucloseWin() {
  return ucall(&UGroup::closeWin, (const UClass*)null);
}

UCall& ucloseDialog() {
  return ucall(&UGroup::closeWin, &UDialog::uclass);
}

UCall& ucloseMenu() {
  return ucall(&UGroup::closeWin, &UMenu::uclass);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */

