// ungif.hh
// 
#ifndef _ungif_hh
#define _ungif_hh

/* =========================================================================

This package makes it possible to read gif files (but not to create them)
from the Ubit library. It was adapted from the libungif library (see notes
and COPYRIGHT below). This package is an optional extension that is not part
of the core Ubit library (and thus have a specific copyright).
As the gif image format is based on the (patented) LZW compression algorithm, 
this file does not contain code for compressing gif images.
Code which does gif decoding only seems not to be covered by the patent;
check the ungif web site (or your own lawyer :-) for details.

   ========================================================================= 
   ========================================================================= 

This is libungif, a library for manipulating gif files in a manner compatible
with libgif, the gif library authored and maintainer by Eric S. Raymond.
The observant builder of this package may in fact notice that this package
is mostly Eric S. Raymond s libgif with a few changes (Please see the NEWS
file)

Latest versions of libungif are available from:
    ftp://prtr-13.ucsc.edu/pub/libungif/

You can see a web page with late breaking announcements at:
    http://prtr-13.ucsc.edu/~badger/software/libungif.shtml

   ========================================================================= 
   ========================================================================= 

The GIFLIB distribution is Copyright (c) 1997  Eric S. Raymond

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

* ========================================================================= */

struct UngifAttributes {
  int from_stdin;
  int width, height;
  unsigned char **buffer;
  // number of colors that are actually used - always <= 256
  int    colorCount;
  XColor colorTable[256];
};

extern int readGifFile(const char *filename, UngifAttributes *attr);

//NOTE:
// readGifFile initializes attr.buffer that must be freed by client.
// for (int i = 0; i < attr.height; i++) free(attr.buffer[i]);
// free(attr.buffer);

#endif
