/* ==================================================== ======== ======= *
 *
 *  udefs.hh
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _udefs_hh
#define	_udefs_hh

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define _UBIT_VERSION_STRING	"UbiX:b1.11.7"
#define _UBIT_VERSION_NO	11107

typedef unsigned char u_bool;
typedef signed int    u_pos;	// !!must be signed!!
typedef signed int    u_dim;	// !!must be signed!!
typedef signed int    u_card;	// !!must be signed!!
typedef unsigned long u_time;	// !!must not be signed!
typedef unsigned long u_modes;	// !!must be coherent with uctrl.hh!!
typedef signed char   u_state;	// !!must be coherent with uctrl.hh!!
typedef unsigned long u_eid;	// !!must be coherent with uevent.hh!!

#define null  0
#define false ((const u_bool)0)
#define true  ((const u_bool)1)
#define U_MAX(x,y)	(((x) > (y)) ? (x) : (y))
#define U_MIN(x,y)	(((x) < (y)) ? (x) : (y))

class UBrick;
class UProp;
class UBack;
class UBorder;
class UFont;
class UColor;
class UBgcolor;
class UCursor;
class UItem;
class UStr;
class UPix;
class UIma;
class UMode;
class UCond;
class UFlag;
class UCall;
class UOn;
class UGroup;
class UBox;
class UWin;
class UDisp;
class UAppli;
class UStyle;
class UEvent;
class UContext;
class UView;
class UWinGraph;
class UGraph;
class ULink;
class UBoxLink;
class UWinLink;
class UFloating;
class UShape;

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

struct URegion {
  u_pos x, y;
  u_dim width, height;
 
  URegion() {};
  URegion(const URegion &r) {*this = r;}
  URegion(const URegion *r) {*this = *r;}
  URegion(u_pos rx, u_pos ry, u_dim rwidth, u_dim rheight) {
    x = rx; y = ry; width = rwidth; height = rheight;
  }

  void set(const URegion &r) {*this = r;}
  void set(const URegion *r) {*this = *r;}
  void set(u_pos rx, u_pos ry, u_dim rwidth, u_dim rheight) {
    x = rx; y = ry; width = rwidth; height = rheight;
  }
  
  // effectue l'intersection de this avec clip
  // this est mis a jour (contient l'intersection), clip ne change pas.
  // renvoie:
  // - false si pas d'intersection (region inchangee)
  // - true sinon si region est incluse dans clip (ie. clipping inutile)
  //
  u_bool setInter(const URegion &clip2);
  u_bool setInter(const URegion *clip2);
  u_bool setInter(u_pos x, u_pos y, u_dim w, u_dim h);

  //Note: les regions vides ne sont pas prises en compte!
  void setClosure(const URegion &clip2);
  void setClosure(const URegion *clip2);
  void setClosure(u_pos x, u_pos y, u_dim w, u_dim h);
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

struct UMargin {
  short top, right, bottom, left;

  UMargin() {}
  UMargin(const UMargin &m) {*this = m;}
  UMargin(short _top_bottom, short _left_right) {
    top  = bottom = _top_bottom; 
    left = right = _left_right;
  }
  UMargin(short _top, short _right, short _bottom, short _left) {
    top = _top; bottom = _bottom; 
    left = _left; right = _right;
  }
  void set(const UMargin &m) {*this = m;}
  void set(short _top_bottom, short _left_right) {
    top = bottom = _top_bottom; 
    left = right = _left_right;
  }
  void set(short _top, short _right, short _bottom, short _left) {
    top  = _top; bottom = _bottom;
    left = _left; right = _right;
  }
  void add(const UMargin &m) {
    top  += m.top; bottom += m.bottom; 
    left += m.left; right += m.right;
  }

};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
