#include "FileType.hh"
#include "AccessVariable.hh"
#include "VHDLKernel.hh"
#include "std_textioPkg.hh"

using std::fstream;

const int maxExtraInFilesInProcedure = 5;
const int maxExtraOutFilesInProcedure = 5;

FileType::FileType(bool alias) : VHDLType(alias) {
  //  object = NULL;
}

FileType::FileType(const FileType &ft)
  : VHDLType(){
  fileHandle = ft.fileHandle;
  (_savant_file_open_kind &) openKind   = ft.openKind;
}

FileType::FileType( VHDLKernel* proc, 
		    const char* fileName, 
		    const _savant_file_open_kind mode) {
  set_fileHandle(proc->openFile(fileName, mode));
  set_fileOpenKind(mode);
}

FileType::FileType(VHDLKernel* proc, const ArrayType& fileName, const _savant_file_open_kind mode) {
  char *file_name_string = fileName.getString();
  set_fileHandle(proc->openFile(file_name_string, mode));
  set_fileOpenKind(mode);

  delete [] file_name_string;
}

FileType::~FileType() { }

Type
FileType::get_kind() const {
  return FILE_TYPE;
}


ObjectBase::ObjectType
FileType::getKind() const {
  return ObjectBase::VARIABLE;
}

void
FileType::print(ostream& ) const {
}

void
FileType::openFile( VHDLKernel *proc, 
		    const char *fileName, 
		    const _savant_file_open_kind &mode, 
		    ios::openmode opening_mode) {
  set_fileHandle(proc->openFile(fileName, mode, opening_mode));
  set_fileOpenKind(mode);
}

void
FileType::openFile( VHDLKernel *proc, 
		    const ArrayType& fileName, 
		    const _savant_file_open_kind &mode, 
		    ios::openmode opening_mode ){
  char* ptr = fileName.getString();
  set_fileHandle( proc->openFile(ptr, mode, opening_mode ));
  set_fileOpenKind(mode);

  delete [] ptr;
}

void
FileType::closeFile(VHDLKernel *proc)
{
  proc->closeFile(get_fileOpenKind(), get_fileHandle());
}

void
FileType::reset(const char *fileName) {
  // Reset a shared file.
  fstream tempFile;

  tempFile.open(fileName, ios::out);
  tempFile.close();
}

void
FileType::reset(const ArrayType &fileName) {
  char *file_name_string = fileName.getString();
  reset(file_name_string);

  delete [] file_name_string;
}

VHDLType *
FileType::clone() const{
  VHDLType *retval = new FileType(is_alias);

  return retval;
}

int
FileType::savantwriteline(VHDLKernel *base, AccessVariable  &line) {
  base->savantwriteline( base, get_fileHandle(), line );

  return NORMAL_RETURN;
}

int
FileType::savantwriteline(VHDLKernel *base, AccessType &line) 
{
  base->savantwriteline(base, get_fileHandle(), line);

  return NORMAL_RETURN;
}

int
FileType::savantreadline(VHDLKernel *base, AccessType &line)
{
  base->savantreadline(base, get_fileHandle(), line);

  return NORMAL_RETURN;
}

int
FileType::savantreadline(VHDLKernel *base, AccessVariable &line)
{
  base->savantreadline(base, get_fileHandle(), line);

  return NORMAL_RETURN;
}

int
FileType::get_fileHandle() const {
  return fileHandle;
}

_savant_file_open_kind&
FileType::get_fileOpenKind() {
  return openKind;
}

void
FileType::set_fileHandle(const int handle) {
  fileHandle = handle;
}

void
FileType::set_fileOpenKind(const _savant_file_open_kind& kind)
{
  (_savant_file_open_kind&) openKind = kind;
}

FileType&
FileType::operator=(const FileType &val) {
  (_savant_file_open_kind&) openKind = val.openKind;
  fileHandle = val.fileHandle;

  return *this;
}

VHDLType&
FileType::operator=(const VHDLType &val) {
  ASSERT ( val.get_kind() == FILE_TYPE );

  return operator=((const FileType &) val);
}

bool
FileType::operator==( const RValue &val ) const {
  return (fileHandle == (dynamic_cast<const FileType &>(val).fileHandle ));
}
bool
FileType::operator!=( const RValue &val ) const {
  return !operator==(val);
}
bool
FileType::operator<( const RValue & ) const {
  abort();
}
bool
FileType::operator<=( const RValue & ) const {
  abort();
}
bool
FileType::operator>( const RValue & ) const {
  abort();
}
bool
FileType::operator>=( const RValue & ) const {
  abort();
}

EnumerationType
FileType::savantendfile_boolean(VHDLKernel *base, int fileHandle)
{
  return base->savantendfile_boolean(base, fileHandle);
}

int
FileType::savantreadline( VHDLKernel *base, AccessType& line, IntegerType &count){
  base->savantreadline(base, get_fileHandle(), line, count);

  return NORMAL_RETURN;
}


int
savantwrite(VHDLKernel *process, FileType &file, const VHDLType &val) {
  AccessType line;
  savantwrite( process, line, val, VHDLData::LEFT, 1 );
  return file.savantwriteline( process, line );
}

int
savantread(VHDLKernel *process, FileType &file, VHDLType &val) {
  AccessType line;
  file.savantreadline(process, line);
  return savantread(process, line, val);
}

int
savantfile_close( VHDLKernel *process, const FileType &type ){
  process->closeFile( _savant_file_open_kind(),
		      type.get_fileHandle() );
  return 0;
}

EnumerationType 
savantendfile_boolean( VHDLKernel *process, FileType &type ){
  return process->savantendfile_boolean( process, type );
}
