//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef VHDL_HH
#define VHDL_HH

#include "Types.hh"
#include "STDTypes.hh"

//===========================================================================
// sensitivity list & wait resumption stuff
#define MAX_SENS_SIZE 5000

struct EventSigs {
  int sig[MAX_SENS_SIZE];
  int num;
  
  EventSigs() {
    num = MAX_SENS_SIZE; // so reset() will clear the entire array
    reset();
  }

  void reset() {
    for (register int i = 0; i < num; i++) {
      sig[i] = -1;
    }
    num = 0;
  }

  void add(int newsig) {
    ASSERT(num <= MAX_SENS_SIZE);
    sig[num] = newsig;
    num++;
  }
};

//===========================================================================
// Signal association data structure

struct Association_t {
  int sig;
  int src;
};

inline ostream& operator<<(ostream& os, const Association_t& a) {
  os << a.sig << "(" << a.src << ")";
  return os;
}


//===========================================================================
//Signal fanout data structure--allows for slices of a signal to have
//different ID's

struct FanDest_t {
  int objid;
  int sigid;

  FanDest_t(int obj, int sig) {
    objid = obj;
    sigid = sig;
  }

  FanDest_t() {
    objid = 0;
    sigid = 0;
  }

  FanDest_t& operator=(const FanDest_t& fd) {
    this->objid = fd.objid;
    this->sigid = fd.sigid;
    return *this;
  }
};

inline ostream& operator<<(ostream& os, const FanDest_t& f) {
  os << "Object: " << f.objid << ", sigId: " << f.sigid;
  return os;
}

#endif
