//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef SOURCEDATA_HH
#define SOURCEDATA_HH

#include "SourceBase.hh"
#include "VHDLType.hh"
#include "VHDLData.hh"

class VHDLKernelBase;

class SourceData : public SourceBase {
public:
  SourceData() : SourceBase() {
    connected = true;
  };

  SourceData(int myId) : SourceBase() {
    sourceId = myId;
    connected = true;
  };
  virtual ~SourceData() {};

  SourceKind get_kind(void) const { return SOURCE_DATA; };

  void disConnect() {
    connected = false;
  }

private:
  SourceId_t sourceId;
  VHDLType *data;
  bool connected;
public:
  SourceId_t getSourceId() const;
  void setSourceId(SourceId_t);

  VHDLType* getData() const;
  void setData(VHDLType *);
  void setData(VHDLData *);
  int addChild(VHDLType*, SourceId_t);
  int addChild(SourceBase *);

  void updateData(const VHDLType&);
  void updateData(const VHDLData&);

  bool _is_child_present(SourceId_t);
  bool _is_driver_connected() { return connected; }
  bool _is_anonymous_driver();
  
  SourceData* getDriver(const SourceId_t) const;

  SourceData* getDriveratIndex(int) const;

  VHDLType* resolve(VHDLKernelBase*, SigType type = EXPLICIT);

  void print(ostream&) const;
};
  
#endif
