/*
typespeed.h - main header file
*/

#include <ctype.h>
#include <ncurses.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>
#include <dirent.h>
#include <unistd.h>

#include <getopt.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define TVERSION "v0.4.4" 

#define CONFIGFILE "/etc/typespeedrc"
#define LOCALCONF ".typespeedrc"

#define WORD_MAX 10000
#define WORDFILE_MAX 100

#define DEFAULT_PORT 6025
#define DEFAULT_COLORS 1
#define DEFAULT_SERVER 0
#define DEFAULT_CLIENT 0
#define DEFAULT_TRAINING 0
#define DEFAULT_TRAININGSPEED 2
#define DEFAULT_CHEAT 0

typedef struct
{
	int score;
    int level;
    float speed;
    float totalspeed;
    float ratio;
} stats_struct;

typedef struct
{
    int cheat;
    int training;
    int traspeed;
    int usecolors;
    int server;
    int client;
    int port;
} opt_struct;

/* global variables..huuuuu */

extern opt_struct opt;
extern stats_struct now;
extern stats_struct best;

extern char *word[WORD_MAX];
extern int wordcount;
extern int ttss;
extern int typesocket;

extern int misses;
/*extern int warp;*/
extern float rate;

extern char *usedwordfile;

extern char *hakemisto;

extern char *rankki[11];
extern char *typorank[12];

/* misc.c: */

int r(int range);
clock_t timenow(void);
void liima_mvgetnstr(int y, int x, char *buf, int maxlen);
void dcolor_set(unsigned char col, void *ptr);
int clower(int lchar);
int typorankkaus(float typorate);
void endcursestuff();
void initcursestuff();
int level(int points);

/* file.c: */

int loadwords(char *stringi);
void freewords();
int choose_wordfile(int kumpi);
int resetscorefile(char *sanafile);
void loadhighscores(char *sanafile);
/*int addtop10(char *sanaf, int pointsgot, int levelgot, float speedgot, float truecps, float typosgot); */
int addtop10(char *sanaf, stats_struct *stat);
void readconfig();
int makescorefiles(void);

/* menu.c: */

void drawmenu();
void tell_story();
void multipmenu();
void optionmenu();
int showhighscores();
void drawscreen();

/* network.c: */

int init_network(char *serv,int graph);
int net_ident(int typesock,int tss,int graph);
void net_waitgame(int typesock);
void net_swapscore(int typesock, stats_struct *stat,stats_struct *stat2);
int close_network();



