/*
   typespeed.c - the main code
 */

#include "typespeed.h"

/* globals */

char *rankki[11] =
{"None", "Loser", "ADP-Pro", "NoGood", "Average",
 "Good", "VeryGood", "Pro", "3l33t", "*(GOD)*", "Computer"};

char *typorank[12] =
{"XMunkki", "Alien", "Secretary", "Human", "IT Person", "Handicap",
 "Monkey", "Pencil", "T-Bone", "E-Typo", "TypOmatiC", "TypoKing"};


opt_struct opt;
stats_struct now;
stats_struct best;
stats_struct other;

char *word[WORD_MAX];
int wordcount;
/* char wordfilename[256]; */
int wordpos[22];
char wordstring[22][21];

int misses;
/*int warp; */
int ttss;

float rate;

char *usedwordfile;
char *hakemisto;

int typesocket = 0;


void movewords() {
    int i;

    dcolor_set(1, NULL);

    for (i = 0; i < 22; i++) {
	dcolor_set(1, NULL);
	if (wordpos[i] > (50 - strlen(wordstring[i])))
	    dcolor_set(7, NULL);
	if (wordpos[i] > (65 - strlen(wordstring[i])))
	    dcolor_set(3, NULL);
	if (wordpos[i] > 0) {
	    wordpos[i]++;
	    mvprintw(i, wordpos[i], "%s", wordstring[i]);
	    mvprintw(i, wordpos[i] - 1, " ");
	}
	if (wordpos[i] > (79 - strlen(wordstring[i]))) {
	    mvprintw(i, wordpos[i], "                   ");
	    if (i == 21) {
		dcolor_set(4, NULL);
		mvprintw(i + 1, 1, "-------------------");
		dcolor_set(2, NULL);
	    }
	    misses++;
	    wordpos[i] = 0;
	}
    }
    dcolor_set(2, NULL);

}

int addnewword(int force, char *newword) {
    
    int tmp, tmp2, nwrd, worddupe;
    int x;

    if (force) {
	/* just find a random place to put the word... no dupes though */
	int free_slots = 0, slot;

	for (tmp = 0; tmp < 22; tmp++) {
	    if (wordpos[tmp] == 0) {
		free_slots++;
	    } else {
		if (strcmp(wordstring[tmp], newword) == 0) {
		    return FALSE;
		}
	    }
	}

	if (free_slots == 0)
	    return FALSE;
	/* the player has enough trouble... */

	slot = r(free_slots);

	for (tmp = 0; tmp < 22; tmp++) {
	    if (wordpos[tmp] == 0) {
		if (slot == 0)
		    break;
		slot--;
	    }
	}

	strcpy(wordstring[tmp], newword);
	wordpos[tmp] = 1;
	return TRUE;
    }
    for (tmp = 0; tmp < 22; tmp++) {
	if (wordpos[tmp] == 0) {
	    worddupe = TRUE;
	    while (worddupe) {
		worddupe = FALSE;
		nwrd = r(wordcount);
		for (tmp2 = 0; tmp2 < 22; tmp2++) {
		    if (strcmp(wordstring[tmp2],
			       word[nwrd]) == 0) {
			worddupe = TRUE;
		    }
		}
	    }
	    worddupe = TRUE;
	    while (worddupe) {
		tmp = r(22);
		if (wordpos[tmp] == 0) {
		    worddupe = FALSE;
		}
	    }
	    /* loweroi stringi */
	    for (x = 0; x < strlen(word[nwrd]); x++) {
		word[nwrd][x] = clower(word[nwrd][x]);
	    }

	    strcpy(wordstring[tmp], word[nwrd]);
	    wordpos[tmp] = 1;
	    return TRUE;
	}
    }
    return FALSE;
}

void cwords() {
    int piipaa;
    int i;

    piipaa = 0;
    for (i = 0; i < 22; i++) {
	if (wordpos[i] > 0) {
	    piipaa += strlen(wordstring[i]) + 1;
	}
    }
    if (piipaa < (now.score / 4 + 1)) {
	addnewword(FALSE, NULL);
/*              if (addnewword(FALSE,NULL) == FALSE) {
   warp = (int) (((now.score / 4) + 1 - piipaa) / 2);
   if (warp > 28) {
   warp = 28;
   /

   } else {
   warp = 0;
   } */
	//rate = now.score / 100 + 3;
	rate = now.score / 175 + 3;

    }
}


int play() {
    
    char *input;
    char buf[256];

    clock_t oldtimes, starttime;
    clock_t pausetime = 0;

    int inputpos;
    int i, wordwritten = 0;
    int nappaykset;
    int wordswritten = 0;
    int tra = 0, pause = 0;
    float min10;
    float pausespeed = 0, pausespeedtotal = 0;
    int nappi, escend;
    srand((unsigned) time(NULL));

    i = 0;
    drawscreen();
    i = choose_wordfile(0);
    if (i == 1) {
	return 1;
    }
    clear();
    drawscreen();
    nodelay(stdscr, 1);
    cbreak();
    noecho();

    if (opt.server || opt.client) {
		mvprintw(12, 20, "Waiting for the other party to join in...");
		do {
    		} while ((nappi = getch()) != ERR);
	        net_waitgame(typesocket);
    		flushinp();
    		clear();
    		drawscreen();
    }

    misses = 0;
    min10 = 0;
    nappaykset = 0;
    now.score = 0;
    input = malloc(20 * sizeof(char));
    inputpos = 0;
    /*warp = 0; */
    escend = 0;
    rate = 1;
    now.ratio = 0;

    for (i = 0; i < 22; i++) {
	wordpos[i] = 0;
    }

    halfdelay(1);
    oldtimes = timenow();

    starttime = timenow();
    input[0]=0x00;

    while (misses < 10 && escend < 1) {
	/*
	   while ((timenow()) < (oldtimes + 30 - warp)||pause) { */
	while ((timenow()) < (oldtimes + (1 / rate) * 100) || pause) {
	
	    /* debug: */ 
	    //mvprintw(24,1,"%d %d",inputpos,strlen(input));

	    if ((nappi = getch()) != ERR) {
		nappi = clower(nappi);

		switch (nappi) {
		case 127:
		    {
			if ((inputpos > 0) && (!pause)) {
			    mvprintw(23, inputpos + 1, " ");
			    mvprintw(23, inputpos + 1, "");
			    input[inputpos] = 0x00;
			    inputpos--;
			    input[inputpos] = 0x00;

			}
			break;
		    }
		case 27:
		    {
			for (i = 0; i < 3; i++) {
			    if ((nappi = getch()) != ERR) {
				if (nappi == 65 && !opt.client && !opt.server) {
				    if (pause == 0) {
					pause = 1;
					pausespeed = now.speed;
					pausespeedtotal = now.totalspeed;
					pausetime = timenow();
					endcursestuff();
					initcursestuff();
					drawscreen();
					mvprintw(23, 8, "PAUSED");
				    } else {
					pause = 0;
					now.speed = pausespeed;
					now.totalspeed = pausespeedtotal;
					starttime += timenow() - pausetime;
					mvprintw(23, 8, "      ");
				    }
				}
			    } else {
				escend = 1;
			    }
			}
			break;
		    }
		case 21:
		    {
			if ((inputpos > 0) && (!pause)) {
				inputpos=0;
				input[0] = 0x00;
				mvprintw(23, 2, "                   ");
			}
			break;
		    }
		case 32:
		case 10:
		    {
			nappaykset++;
			if ((inputpos > 0) && (!pause)) {
			    input[inputpos] = 0x00;
			    if (!opt.cheat)
				for (i = 0; i < 22; i++)
				    if (strcmp(input, wordstring[i]) == 0) {
					now.score += inputpos;
					wordswritten++;
					mvprintw(i, wordpos[i], "                   ");
					wordpos[i] = 0;
					if (i == 21) {
					    dcolor_set(4, NULL);
					    mvprintw(i + 1, 1, "-------------------");
					    dcolor_set(2, NULL);
					}
					/* send 50% words in multiplayer */
					if (opt.server || opt.client) {
		                        	sprintf(buf, "%s\n", wordstring[i]);
                		        	if (r(2) == 0) send(typesocket, buf, strlen(buf), 0);
				    	}
					strcpy(wordstring[i], "THIS-IS-NOT-A-CHEAT");
				    }
			    inputpos = 0;
			    mvprintw(23, 2, "                   ");
			}
			break;
		    }
		case 11: 
		    {
			if (strlen(input)>inputpos && (!pause)) {
				for (i=inputpos;i<19;i++) {
					input[i]=0x00;
		                        mvprintw(23,i + 2, " ");
				}
				mvprintw(23,inputpos+2,"");
			}
			
			break;
		    }
		case 8:
		    {
			if ((inputpos > 0) && (!pause)) {
			    mvprintw(23, inputpos + 1, " ");
			    mvprintw(23, inputpos + 1, "");
			    input[inputpos] = 0x00;
			    inputpos--;
			    input[inputpos] = 0x00;
			}
			break;
		    }
		case 6:
		    {
			if ((inputpos < 19) && (strlen(input)>inputpos) && (!pause)) {
				inputpos++;
				mvprintw(23,inputpos + 2,"");
			}
			break;
		    }
		case 5:
		    {
			if ((inputpos != strlen(input)) && (!pause)) {
				inputpos=strlen(input);
				mvprintw(23,inputpos + 2,"");
			}
			break;
		    }
		case 2: 
		    {
			if ((inputpos > 0) && (!pause)) {
				inputpos--;
				mvprintw(23,inputpos + 2,"");
			}
			break;
		    }
		case 1:
		    {
			if ((inputpos > 0) && (!pause)) {
				inputpos=0;
			}
			break;
		    }
		default:
		    {
			if (!pause)
			    nappaykset++;
			if ((inputpos < 19) && (!pause)) {
			    mvprintw(23, 2 + inputpos, "%c", nappi);
			    if (inputpos==strlen(input)) input[inputpos + 1] = 0x00;
			    input[inputpos] = nappi;
			    inputpos++;
			    if (opt.cheat) {
				for (i = 0; i < 22; i++)
				    if (strcmp(input, wordstring[i]) == 0) {
					now.score += inputpos;
					mvprintw(i, wordpos[i], "                   ");
					wordpos[i] = 0;
					wordwritten = 1;
					if (i == 21) {
					    dcolor_set(4, NULL);
					    mvprintw(i + 1, 1, "-------------------");
					    dcolor_set(2, NULL);
					}
					strcpy(wordstring[i], "THIS-IS-NOT-A-CHEAT");
				    }
				if (wordwritten) {
				    inputpos = 0;
				    wordwritten = 0;
				    mvprintw(23, 2, "                   ");
				}
			    }
			}
			break;
		    }
		}
	    }
	}

	if (!pause) {

	    oldtimes = timenow();

            if (!opt.training || opt.client || opt.server) {
		movewords();
		cwords();
	    }
	    if (!opt.client && !opt.server) {
	    	if (opt.training) {
			if (tra == opt.traspeed) {
		    		movewords();
		    		cwords();
		    		tra = 0;
			}
			tra++;
	    	}
	    }

	    now.speed = (now.score + wordswritten) * 100.0 / (timenow() - starttime);

	    now.totalspeed = nappaykset * 100.0 / (timenow() - starttime);

	}
	dcolor_set(5, NULL);
	mvprintw(23, 25,
	      "                                                       ");
	mvprintw(23, 23, "Rank: ");
	mvprintw(23, 38, "Score: ");
	mvprintw(23, 49, "tCPS: ");
	mvprintw(23, 60, "cCPS: ");
	mvprintw(23, 71, "Misses: ");
	/*level(score); */
	mvprintw(23, 29, "%s", rankki[level(now.score)]);
	dcolor_set(3, NULL);
	mvprintw(23, 45, "%d", now.score);
	mvprintw(23, 55, "%2.2f", now.totalspeed);
	mvprintw(23, 66, "%2.2f", now.speed);
	mvprintw(23, 78, "%d", misses);
	dcolor_set(2, NULL);

        /* last, we check if the opponent has any new words for us... */
        
	if(opt.server || opt.client) {

		i = recv(typesocket, buf, 256, MSG_PEEK);

        	if (i == -1 && errno != EWOULDBLOCK) {
        		perror("recv()");
                	exit(1);
        	}

        	if (i > 0) {
        		char *j = strchr(buf, '\n');

                	if (j != NULL) {
                		j[0] = 0;
                       		addnewword(TRUE, buf);
                        	recv(typesocket, buf, strlen(buf) + 1, 0);
	                	if(strstr(buf,"ENDOFTHEGAME") > 0) {
					escend=2;
				}
			}
        	}

	}


	refresh();
    }
    free(input);

    if (opt.server || opt.client) {
	if (escend!=2) {
		strcpy(buf,"ENDOFTHEGAME\n");
		send(typesocket, buf, strlen(buf), 0);
	}	
    }

    endcursestuff();
    initcursestuff();
    drawscreen();
    now.level = level(now.score);
    if ((now.level >= best.level) && (now.score >= best.score)) {
	best.level = now.level;
	best.score = now.score;
	best.speed = now.speed;
	best.totalspeed = now.totalspeed;
	if ((now.totalspeed != 0) && (now.speed != 0))
	    best.ratio = (now.totalspeed - now.speed) / now.totalspeed;
    }

    if (opt.server || opt.client) {

    	net_swapscore(typesocket, &now,&other);
	do {
    	}
    	while ((nappi = getch()) != ERR);
    }
    dcolor_set(5, NULL);

    mvprintw(12, 30, "GAME OVER!");
    refresh();

    sleep(3);

    /* total speed */
    min10 = now.speed * 600;

    /* let's get speed away from your mistakes or not? 
       min10=min10-(ratio*100)
     */

    mvprintw(12, 30, "          ");
    dcolor_set(5, NULL);
    mvprintw(3, 20, "Typespeed %s ", TVERSION);

    mvprintw(5, 20, "Your score was: ");
    if(opt.client||opt.server) mvprintw(5, 60, "Opponents: ");
    mvprintw(7, 20, "Rank:\t\t");
    /*      level(score); */
    mvprintw(7, 40, "%s", rankki[level(now.score)]);
    dcolor_set(5, NULL);
    mvprintw(8, 20, "Score:\t\t%d", now.score);
    mvprintw(9, 20, "10MRS:\t\t%1.0f", min10);
    mvprintw(10, 20, "Total CPS:\t\t%2.3f  ", now.totalspeed);
    mvprintw(11, 20, "Correct CPS:\t%2.3f  ", now.speed);
    if ((now.totalspeed != 0) && (now.speed != 0))
	now.ratio = (now.totalspeed - now.speed) / now.totalspeed * 100;
    mvprintw(12, 20, "Typo ratio:\t\t%2.1f%%\t", now.ratio);
    mvprintw(13, 20, "Typorank:\t\t");

    if (now.score!=0) {
	    mvprintw(13, 40, "%s", typorank[typorankkaus(now.ratio)]);
    } else {
            mvprintw(13, 40, "None");
    }

    if (opt.server || opt.client) {

	mvprintw(7, 60, "%s", rankki[level(other.score)]);
        dcolor_set(5, NULL);
	mvprintw(8, 60, "%d", other.score);
        mvprintw(9, 60, "%1.0f", other.speed*600);
        mvprintw(10, 60, "%2.3f  ", other.totalspeed);
        mvprintw(11, 60, "%2.3f  ", other.speed);
        if ((other.totalspeed != 0) && (other.speed != 0))
		other.ratio = (other.totalspeed - other.speed) / other.totalspeed * 100;
        mvprintw(12, 60, "%2.1f%%", other.ratio);
        if (other.score!=0) {
		mvprintw(13, 60, "%s", typorank[typorankkaus(other.ratio)]);
        } else {
        	mvprintw(13, 60, "None");
    	}
    }

    dcolor_set(5, NULL);
    if (opt.training) {
	dcolor_set(2, NULL);
	mvprintw(17, 15, "TRAINING MODE - YOU CANNOT GET TO TOP10");
	dcolor_set(5, NULL);
    }
    if (opt.client || opt.server) {
	dcolor_set(2, NULL);
	mvprintw(17, 20, "NETWORK MODE - YOU CANNOT GET TO TOP10");
	dcolor_set(5, NULL);
    }
    nodelay(stdscr, 0);
    cbreak();
    flushinp();

    dcolor_set(4, NULL);
    mvprintw(15, 20, "Press any key to continue...");
    do {
    }
    while ((nappi = getch()) == ERR);

    dcolor_set(2, NULL);

    echo();
    if (!opt.training && !opt.client && !opt.server) {
	/*addtop10(usedwordfile, now.score, now.level, now.speed, now.totalspeed, now.ratio); */
	addtop10(usedwordfile, &now);
    }
    loadhighscores(usedwordfile);
    dcolor_set(4, NULL);
    mvprintw(16, 3, "Press any key to continue...");
    do {
    }
    while ((nappi = getch()) == ERR);
    dcolor_set(2, NULL);
    free(usedwordfile);
    freewords();
    return 0;
}

struct option options[] = {
    {"nocolors", no_argument, &opt.usecolors, 0},
    {"cheat", no_argument, &opt.cheat, 1},
    {"training", optional_argument, NULL, 't'},
    {"client", required_argument, NULL, 'o'},
    {"server", no_argument, &opt.server, 1},
    {"port", required_argument, NULL, 'p'},
    {"makescores", no_argument, NULL, 'm'},
    {"help", no_argument, NULL, 'h'},
    {0, 0, 0, 0}
};

int main(int argc, char *argv[]) {

    int wheretogo=0;
    int want_help = 0;

    char serv[64];

    opt.cheat = DEFAULT_CHEAT;
    opt.training = DEFAULT_TRAINING;
    opt.traspeed = DEFAULT_TRAININGSPEED;
    opt.usecolors = DEFAULT_COLORS;
    opt.server = DEFAULT_SERVER;
    opt.client = DEFAULT_CLIENT;
    opt.port = DEFAULT_PORT;

    now.score = 0;
    now.level = 0;
    now.speed = 0;
    now.totalspeed = 0;
    now.ratio = 0;

    best.score = 0;
    best.level = 0;
    best.speed = 0;
    best.totalspeed = 0;
    best.ratio = 0;

    readconfig();
    printf("Typespeed %s, Copyright (C) Jani Ollikainen & Jaakko Manelius\n", TVERSION);
    printf("Typespeed comes with ABSOLUTELY NO WARRANTY; for details read COPYING.\n");

    for (;;) {
	int optind = 0;
	int i;

	i = getopt_long(argc, argv, "to:h", options, &optind);

	if (i == -1)
	    break;

	switch (i) {
	case 0:
	    /* flag already set by getopt */
	    break;
	case 't':
	    opt.training = 1;
	    if (optarg)
		opt.traspeed = atoi(optarg);
	    if (opt.traspeed < 2 || opt.traspeed > 10)
		opt.traspeed = 2;
	    break;
	case 'o':
	    opt.client = 1;
	    if (!optarg)
		abort();	/* getopt should handle this... */
	    strcpy(serv, optarg);
	    break;
	case 'p':
	    if (optarg) opt.port = atoi(optarg);    
	    if (opt.port <= 1024) {
		printf("DON'T USE PRIVILEDGED PORT\n");
		exit(1);
	    }
	    break;
	case 'm':
	    makescorefiles();	   
	    exit(0);
	    break;
	case ':':
	case '?':
	    /* getopt already printed error */
	case 'h':
	default:
	    want_help = 1;
	}

	if (want_help) {
	    printf("\nCommand line options: --nocolors      == don't use colors\n");
	    printf("                      --cheat         == multimedia cheat(?)\n");
	    printf("                      --training[=nm] == training mode\n");
	    printf("                                         (where nm is speed number)\n");
	    printf("                      --server        == start typespeed in server mode\n");
	    printf("                      --client=addr   == IP address of server\n");
	    printf("                      --port=port     == Port number in the network play.\n");
	    printf("                      --makescores    == Reset/Make new scorefiles.\n");
	    printf("                      --help          == this help!\n\n");
	    printf("Usage: %s options\n\n", argv[0]);
	    exit(1);
	}
    }

    do {
    	if (opt.server || opt.client) typesocket = init_network(serv,0);
    } while(typesocket<0);

    sleep(1);

    initcursestuff();
    noecho();

    if(typesocket>0) {
	echo();
        clear();
        play();
        noecho();
    }

    clear();
    drawscreen();
    /* THIS IS OLD NEWS - LEFT HERE TO PUT SOME FUTURE NEWS IN */
    // mvprintw(15,20, "NOTE THIS VERSION HAS NEW WAY TO CALCULATE SPEED!");
    // mvprintw(16,26, "SCORES ARE NOT THE SAME AS THEY WERE");
    drawmenu();


    do {
	nodelay(stdscr, 0);
	cbreak();

	wheretogo = getch();

	switch (wheretogo) {
	case 53: { 
	    echo();
	    optionmenu();
	    break;
	}
	case 52: {
	    echo();
	    showhighscores();
	    break;
	}
	case 51: {
	    tell_story();
	    break;
	}
	case 50: {
	    multipmenu();
	    if(typesocket>0) {
		echo();
	  	clear();
		play();
		echo();
	    }
	    break;
	}
	case 49: {
	    echo();
	    clear();
	    play();
	    echo();
	    break;
	}
	}
	clear();
	drawscreen();
	drawmenu();

    }
    while (wheretogo != 54);

    endcursestuff();

    printf("\e[H\e[JTypespeed %s\n\n", TVERSION);
    printf("Best score was: \n\n");
    printf("Rank:\t\t%s\n", rankki[best.level]);
    printf("Score:\t\t%d\n", best.score);
    printf("Total CPS:\t%2.3f\n", best.totalspeed);
    printf("Correct CPS:\t%2.3f\n", best.speed);
    printf("Typo ratio:\t%2.1f%%\n", best.ratio * 100);
    if (best.score != 0) {
	printf("Typorank:\t%s\n\n\n", typorank[typorankkaus(best.ratio * 100)]);
    } else {
        printf("Typorank:\tNone\n\n\n");
    }
    chdir(hakemisto);
    free(hakemisto);
    return 0;

}
