#!/bin/sh
# bashdump-rmdup.sh
#   remove the duplicated entries generated by bash --dump-po-strings
# needs: mktemp, cat, rm, sed, sort, uniq
# 20010609 <verde@verde666.org> ** debut

[ "$1" ] || { echo "usage: $0 potfile" ; exit 1 ; }
potfile="$1"
tmp=`mktemp /tmp/bashdump.XXXXXX`

# numbering lines at the end and sorting
cat -n $potfile |
  sed -n 's/^[[:blank:]]*\([0-9]\+\)[[:blank:]]*msgid "\(.*\)"$/\2#\1/p' |
  sort > $tmp

repeatedlines=`sed 's/#[0-9]\+$//' $tmp | uniq -d`
IFS='
'
for LINE in $repeatedlines; do
  # getting the first line of the repeated message
  lines=`sed -n "s/^$LINE#\([0-9]\+\)$/\1/p" $tmp | sort -n | sed 1d`

  for line in $lines; do
    linebefore=$((line-1))
    lineafter=$((line+1))
    sedcmd="$sedcmd  ${linebefore}s/^#/##duplicated##/; ${lines}d; ${lineafter}d;"
  done
done
unset IFS
rm $tmp

sed "$sedcmd" $potfile
#> $tmp
#cat $tmp > $potfile
#sed -n '/##duplicated##/p' $potfile

