/* twpsk  - PSK31 for Linux with a Lesstif interface
 * Copyright (C) 1999 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 2.1 - Aug 2002
 *
 * Portions derived from:
 * Soundcard-based implementation of the PSK31 HF keyboard-to-keyboard mode
 * Copyright (C) 1998  Hansi Reiser, DL9RDZ
 */

#include "GUI.h"
#include "../server/server.h"
#include "twpskWids.h"
#include "twpskCB.h"
#include "twpskScope.h"
#include "twpskDisp.h"
#include "callbox.h"
#include <signal.h>

int OPTnew = 0;   // TODO: rausdamit (-> filter and sync alg selection for RX)


#if 0
#define DMA_BUF_BITS 6
// Audio parameters
int full_duplex=0;
static int audio_fd;
#endif

static char *sound_device="/dev/audio";

/* Globals */
int transmit=0;
AppRes appRes;
Position winlocs[MAX_DECODERS][2];
Wids pskwids;
Scope scope;
Disp disp;
TwpskCB twpskCB;
XtAppContext ac;

/* @@@ DL9RDZ */
#include "catWids.h"
#include "decoderWids.h"

Cat catwids;

DecoderWid decoderWids[MAX_DECODERS];

   
/*
 * main - main function for twpsk
 */
int main(int argc, char *argv[])
{

   Widget shell, temp;
   Widget  noTwpskMessBox;
   int val; 
   int height = 0, width = 0;
   XmString messStr;
   char *str = "";
   Atom wm_delete_win;

   String fallback_resources[] =
     {
     "twpsk.noTwpskMessBox*forground:     black",
     "twpsk.noTwpskMessBox*background:    tan",
     "twpsk.noTwpskMessBox.messageString: Can't find the resource file, Twpsk.",
      NULL
      };

   XtResource appRes_desc[] =
   {
      {
      XmNbuttonNames,                    /* Resource Name */ 
      XmCButtonNames,                    /* Resource Class */
      XmRString,                         /* Resource Data Type */
      sizeof (char),                     /* Size of Resource */
      XtOffsetOf (AppRes, buttonNames),  /* Offset into Struct */
      XtRString,                         /* Default Data Type */
      (XtPointer) "Bogus Name"           /* Default Value */
      },

      {
      XmNrxFreq,                         /* Same as above */
      XmCRxFreq,
      XmRFloat,
      sizeof (float),
      XtOffsetOf (AppRes, rxFreq),
      XtRFloat,
      (XtPointer) 0
      },

      {
      XmNtxFreq,                         /* Same as above */
      XmCTxFreq,
      XmRFloat,
      sizeof (float),
      XtOffsetOf (AppRes, txFreq),
      XtRFloat,
      (XtPointer) 0
      },

      {
      XmNafc,                            /* Same as above */
      XmCAfc,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, afc),
      XtRInt,
      (XtPointer) 0
      },

      {
      XmNnet,                            /* Same as above */
      XmCNet,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, net),
      XtRInt,
      (XtPointer) 0
      },

      {
      XmNnoMixer,                        /* Same as above */
      XmCNoMixer,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, noMixer),
      XtRInt,
      (XtPointer) 1
      },

      {
      XmNmainVol,                        /* Same as above */
      XmCMainVol,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, mainVol),
      XtRFloat,
      (XtPointer) 0
      },

      {
      XmNoutVol,                         /* Same as above */
      XmCOutVol,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, outVol),
      XtRFloat,
      (XtPointer) 0
      },

      {
      XmNinVol,                          /* Same as above */
      XmCInVol,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, inVol),
      XtRImmediate,
      (XtPointer) 0
      },

      {
      XmNcall,                           /* Same as above */
      XmCCall,
      XmRString,
      sizeof (char),
      XtOffsetOf (AppRes, call),
      XtRImmediate,
      (XtPointer) " ",
      },

      {
      XmNzero,                           /* Same as above */
      XmCZero,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, zero),
      XtRImmediate,
      (XtPointer) 0
      },

      {
      XmNptt,                            /* Same as above */
      XmCPtt,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, ptt),
      XtRImmediate,
      (XtPointer) 0
      },

      {
      XmNserDev,                         /* Same as above */
      XmCSerDev,
      XmRString,
      sizeof (char),
      XtOffsetOf (AppRes, serDev),
      XtRImmediate,
      (XtPointer) "/dev/ttyS1",
      },

      {
      XmNcallBox,                            /* Same as above */
      XmCCallBox,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, callBox),
      XtRImmediate,
      (XtPointer) 0
      },
   };


#ifdef XmVERSION_STRING
   extern const char _XmVersionString[];
   printf ("Compiled with %s\n", XmVERSION_STRING);
   printf ("Running  with %s\n", _XmVersionString); 
#endif

   /*
    * Create the shell, register a callback for the WM Close button,
    * catch the INT, QUIT, and TERM signals, and read the resource file
    * if Twpsk was found.
    */
   shell = XtVaAppInitialize (&ac, "Twpsk", NULL, 0, &argc, argv,
      fallback_resources,
      XmNiconName, "TWPSK",
      NULL);

   wm_delete_win = XmInternAtom (XtDisplay(shell), "WM_DELETE_WINDOW", False);
   XmAddWMProtocolCallback (shell, wm_delete_win, quitCB, NULL);

   signal (SIGINT,  gotSig);
   signal (SIGQUIT, gotSig);
   signal (SIGTERM, gotSig);

   /*
    * Create an error message box just in case.
    * If the label != "OK", then we're running on
    * the fallback resources.  Popup the dialog
    * and tell them to fix Twpsk
    */
   noTwpskMessBox = XtVaCreateManagedWidget("noTwpskMessBox",
      xmMessageBoxWidgetClass, shell, 
      NULL);

   XtVaGetValues (noTwpskMessBox,
      XmNmessageString, &messStr,
      NULL);

   XmStringGetLtoR (messStr, XmFONTLIST_DEFAULT_TAG, &str);

   if (strcmp(str,"OK") != 0)  /* didn't find Twpsk in X11's app-defaults*/
                               /* did you run make install_twpsk as root? */
   {
      /* Get rid of the Cancel and Help buttons */
      temp = XmMessageBoxGetChild (noTwpskMessBox, XmDIALOG_CANCEL_BUTTON);
      XtUnmanageChild(temp);

      temp = XmMessageBoxGetChild (noTwpskMessBox, XmDIALOG_HELP_BUTTON);
      XtUnmanageChild(temp);

      /* Have the OK button call the quitCB. cdata = -1 (stops 2Rx save) */
      temp = XmMessageBoxGetChild (noTwpskMessBox, XmDIALOG_OK_BUTTON);
      XtAddCallback (temp, XmNactivateCallback, quitCB, (XtPointer) -1);

      /* bail out to the event loop with just the message box */
      XtRealizeWidget(shell);
      XtAppMainLoop(ac);
   }

   /* Got Twpsk, so don't need the message box */
   XtDestroyWidget (noTwpskMessBox);

   /* Get the app resources from the resource file */
   XtGetApplicationResources (shell, &appRes, appRes_desc,
      XtNumber (appRes_desc), NULL, 0);

   /*
    * initialize server
    * psk31.cod is now installed in /usr/local/share/psk31
    */
   if( server_main(sound_device,
       appRes.ptt ? appRes.serDev : NULL, "/usr/local/share/psk31"))
   {
	   fprintf(stderr,"failed to initialize psk31 server\n");
	   exit(1);
   }

   /*
    * Create widgets
    */
   pskwids.buildWidgets (shell, &appRes);  

   /* This creates a toplevel shell in the upper left corner and registers
    * an expose callback.  The callback gets the x-y location and now we know
    * the width of the borders.  Needed to position the secondary decoders.
    */
   Widget sh, da;

   sh= XtVaAppCreateShell("sh", "sh",topLevelShellWidgetClass, XtDisplay(shell),
      NULL);
   da = XtVaCreateManagedWidget ("da",xmDrawingAreaWidgetClass, sh,
      NULL);
   XtAddCallback (da, XmNexposeCallback, bordersCB, NULL);
   XtRealizeWidget(sh);


   /* @@@DL9RDZ
    * test 2nd window
    */
// catwids.buildWidgets(shell, &appRes);

   DecoderWid::shell = shell;
   for(int i=0; i<MAX_DECODERS; i++)
   {
       decoderWids[i].visible = -1;
   }

   /* Add callbox if desired */
   if ( appRes.callBox == 1 )
   {
      fprintf (stderr,"starting callbox\n");
      Callbox a_callbox (shell);
      a_callbox.quiet();
   }

   /*
    * setup and initialize the scope, and the display
    */
   scope.setup (shell, pskwids.getScope());
   disp.setup(pskwids.getWF());
   
   /*
    * Configure mixer if desired
    */
   if (appRes.noMixer == 0)
   {
      int mixer_fd;
      mixer_fd = open("/dev/mixer",O_RDWR);
      if (mixer_fd < 0)
      {
         perror ("twcw - Can't open mixer");
         exit (1);
      }
      val=SOUND_MASK_LINE | SOUND_MASK_MIC;
      if (ioctl (mixer_fd, SOUND_MIXER_WRITE_RECSRC, &val) < 0)
      {
         fprintf (stderr, "mixer recsrc failed\n");
      }  

      val = 0;  // no input sigs get to output
      if (ioctl(mixer_fd, MIXER_WRITE(SOUND_MIXER_OUTSRC), &val) < 0)
      {
         fprintf (stderr, "mixer outsrc failed\n");
      }
      close (mixer_fd);
   }
   else
      fprintf (stderr, "Mixer disabled\n");

   /*
    * Set min size
    */
   XtVaGetValues (shell,
      XmNwidth, &width,
      XmNheight, &height,
      NULL);

   XtVaSetValues (shell,
      XmNminWidth, width,
      XmNminHeight, height,
      NULL);
   
   iniProc ('r');  /* read window locations */

   /*
    * Start the application work proc
    * and enter the main loop
    */
   XtAppAddWorkProc (ac, workProc, (XtPointer) NULL);
   XtAppMainLoop (ac); 
}


/*
 * iniProc - read/write the window locations to a file 
 * read - stat to see if file exists. If it does, read it
 * if not, skip it.  We will create it on exit for next time
 *
 * write - just over writes the ini file with the current array
 */
void iniProc (char mode)
{
   struct stat file_stat;
   char *filepath, *homepath;
   FILE *fp = NULL;
   int len=0;
   int i;

   homepath = getenv("HOME");
   filepath = (char *) malloc (strlen (homepath) + strlen (DAT_FILE) + 2);
   strcpy (filepath, homepath);
   strcat (filepath, DAT_FILE);

   if (mode == 'r')
   {
      if (stat (filepath, &file_stat) == -1)
      {
         fprintf (stderr, "iniProc: no %s file yet.\n", filepath);
         /* no file so set winlocs to some defaults */
         for (i=0; i<MAX_DECODERS; i++)
         {
            winlocs[i][0] = 50;
            winlocs[i][1] = 50;
         }
      }
      else
      {
         if ((fp = fopen (filepath, "r")) != NULL)
         {
            fprintf (stderr, "reading %s \n", filepath);
            fread (&winlocs, (size_t)1, (size_t)sizeof(winlocs), fp);
         }
         else
         {
            fprintf (stderr, "stat OK but open failed\n");
         }
      }
      free (filepath);
      return;
   }
   if (mode =='w')
   {
      fprintf (stderr, "writing %s\n", filepath);
      if ((fp = fopen (filepath, "w")) == NULL)
      {
         fprintf (stderr, "iniProc: can't open %s\n", filepath);
         return;
      }
      len = fwrite (winlocs, (size_t) 1, (size_t)sizeof(winlocs), fp);
      free (filepath);
      fclose (fp);
   }
   else
   {
      printf ("iniProc: illegal call\n");
   }
   return;
}  


#ifndef USE_PTHREAD
void master_handler(void);
#endif


/*
 * workProcFunction
 * Work Proceedure for receive and transmit
 */
Boolean workProc(XtPointer cdata)
{
   PSK31info rxinfo, txinfo;
   char str[8];
//   int dcd;
   static float rxfreqOld;
   int phdelta;  
   int l;   
   int rxecho;

#ifndef USE_PTHREAD
   // 4 is an empirical value.
   // If choosen too low, sound card buffer will run empty, and thus sound
   // will have interruptions (fatal!). A value too high isn't that critical...
   for(int i=0; i<4; i++) 
   {
      master_handler();
#endif
      // handle FFT!
      int N = disp.getsamplecnt();
      float fftval[N];
      l = commGetData(COMM_FFTCH, (char *)fftval, sizeof(fftval));
      if (l > 0)
      {
         if (l != N)
         {
            fprintf(stderr,"FFT len mismatch: l=%d N=%d\n",l,N);
         }
         disp.getFFT (fftval, N);
      }
#ifndef USE_PTHREAD
   }
#endif
   char buf[256];
   
   /*
    * handle transmit echo!  We could use a different color?
    * Sri, Hansi.  Best I can do is to underline or highlight it.
    * and that causes a lot of flicker
    */
   rxecho = commGetData(COMM_ECHOCH, buf, sizeof buf);
   if(rxecho > 0)
   {
      for(int i=0; i<rxecho; i++)
      {
         appendRXtext(pskwids.getRxText(), buf[i],
                      appRes.zero, XmHIGHLIGHT_SELECTED);
                      //appRes.zero, XmHIGHLIGHT_SECONDARY_SELECTED);
      }
   }
   commGetInfo(COMM_TXCH, &txinfo, sizeof(txinfo));
   //(TODO) well I probably dont really need this info... 
   //txfreq = 0.01 * txinfo.freq;

   /*
    * handle receive!
    */
   l = commGetData(COMM_RXCH, buf, sizeof buf);
   if(l > 0)
   {
      for(int i=0; i<l; i++)
         appendRXtext(pskwids.getRxText(), buf[i],
                      appRes.zero, XmHIGHLIGHT_NORMAL);
   }

   commGetInfo(COMM_RXCH, &rxinfo, sizeof(rxinfo));
   appRes.rxFreq = 0.01 * rxinfo.freq;
   phdelta = rxinfo.phdelta;
   
   /*update DCD toggle button*/
   XtVaSetValues(pskwids.getDcdTB(), XmNset, rxinfo.dcd, NULL);

   if(rxinfo.ptt == 0)
   {
      /* receiving */
      /* update scope */
      scope.drawline(rxinfo.phdelta, rxinfo.strength, rxinfo.dcd);

      /* update rx freq */
      /* but only if focusFlag == 0 */
      if (pskwids.getRxFreqFocus() == 0 )
      {
         if (fabs(appRes.rxFreq - rxfreqOld) > .05)
         {
            sprintf (str, "%4.1f", appRes.rxFreq);
            XmTextFieldSetString (pskwids.getRxFreqTF(), str);
            /* tell the fft about it */
            disp.offset(appRes.rxFreq);
            rxfreqOld = appRes.rxFreq;
         }
      }
   }
   else
   {
      /* scope display for each tx character put in the echo (rx) window */
      if(rxecho>0)
         phdelta = 0;
      else
         phdelta = 128;
      scope.drawline(phdelta, 35, GREEN);
   }

   /* handle receive for additional receivers! */
   for(int ch=0; ch<MAX_DECODERS; ch++)
   {
      if( decoderWids[ch].visible!=1) continue;
         l = commGetData(ch+3, buf, sizeof buf);
      if(l>0)
      {
         for(int i=0; i<l; i++)
            appendRXtext(decoderWids[ch].getTextWid(), buf[i],
                         appRes.zero, XmHIGHLIGHT_NORMAL);
      }
      l = commGetInfo(decoderWids[ch].commChannel, &rxinfo, sizeof(rxinfo));
      if(l==0)
      {
         decoderWids[ch].updateDisplay(0.01*rxinfo.freq, rxinfo.dcd, 0);
         decoderWids[ch].getScope().drawline(rxinfo.phdelta, 
            rxinfo.strength, rxinfo.dcd);
      }
   }

#ifdef USE_PTHREAD
   usleep(10000);
#else
   usleep(5000);
#endif

   return (False);
}


#if 1
void gotSig (int stat)
{
   if (stat == SIGINT)
   {
      printf ("INTERUPT\n");
      signal (SIGINT, SIG_IGN);
      quitCB ((Widget)0, (XtPointer)0, (XtPointer)0);
      exit (0);
   }
   if (stat == SIGQUIT)
   {
      printf ("QUIT\n");
      signal (SIGINT, SIG_IGN);
      quitCB ((Widget)0, (XtPointer)0, (XtPointer)0);
      exit (0);
   }
}
#endif
