<?php  
  /*********************************************/
  /*  PHP3 TreeMenu                            */
  /*                                           */
  /*  (c)1999 Bjorge Dijkstra                  */
  /*  email : bjorge@gmx.net                   */
  /*                                           */  
  /*  Updated by Greg Ross                     */  
  /*  email : greg@darkphoton.com              */
  /*                                           */  
  /*********************************************/

  Function TreeGenerateMenu( $maxlevel, $tree, $script, $images, $varname, $varvalue )
	{
        /*********************************************/
        /* Allow the images to be defined by the     */  
        /* user.                                     */  
        /*********************************************/
	if( !is_array( $images ) )
		{
	  	$img_expand   	= "tree_expand.gif";
  		$img_collapse 	= "tree_collapse.gif";
	  	$img_line     	= "tree_vertline.gif";  
  		$img_split    	= "tree_split.gif";
	  	$img_end      	= "tree_end.gif";
  		$img_leaf     	= "tree_leaf.gif";
	  	$img_spc      	= "tree_space.gif";
		}
	else
		{
	  	$img_expand   	= $images["expand"];
  		$img_collapse 	= $images["collapse"];
	  	$img_line     	= $images["line"];
  		$img_split    	= $images["split"];
	  	$img_end      	= $images["end"];
  		$img_leaf     	= $images["leaf"];
	  	$img_spc      	= $images["spc"];
		}

        /*********************************************/
        /* Ensure all array's are clear before we    */  
        /* do anything.                              */  
        /*********************************************/
	for( $i = 0; $i < count( $tree ); $i++ ) 
		{
	     	$expand[$i]  = 0;
	     	$visible[$i] = 0;
	     	$levels[$i]  = 0;
  		}

	/*********************************************/
	/*  Get Node numbers to expand               */
	/*********************************************/
	if( $varvalue != "" ) { $explevels = explode( "|", $varvalue ); }
  
	$expandalllevels = 0;
	$i = 0;
	while( $i < count( $explevels ) )
		{
		/*********************************************/
		/*  The special key of 'all' means that      */
		/*  every item will be expanded so we can    */
		/*  skip to the next loop                    */
		/*********************************************/
		if( $explevels[$i] == "all" )
			{
			$expandalllevels = 1;
			$i = count( $explevels );
			}
		else
			{
			/*********************************************/
			/*  Ranges are allowed by defining them with */
			/*  two numbers with a dash between them.    */
			/*********************************************/
			$subvalues = explode( "-", $explevels[$i] );

			if( count( $subvalues ) > 1 )
				{
				for( $j = $subvalues[0]; $j <= $subvalues[1]; $j++ )
					{
			    		$expand[$j] = 1;
					}
				}
			else
				{
			    	$expand[$explevels[$i]] = 1;
				}

			$i++;
			}
  		}

	/*********************************************/
	/*  If we found the special 'all' tag above  */
	/*  then everything will be expanded and     */
	/*  visible.                                 */
	/*********************************************/
	if( $expandalllevels == 1 )
		{
		for( $i = 0; $i < count( $tree ); $i++ ) 
			{
	     		$expand[$i]  = 1;
			$visible[$i] = 1;
	  		}
		}

	/*********************************************/
	/*  Find last nodes of subtrees              */
	/*********************************************/
  	$lastlevel = $maxlevel;
	for( $i = count( $tree ) - 1; $i >= 0; $i-- )
  		{
	     	if( $tree[$i][0] < $lastlevel )
     			{
       			for( $j = $tree[$i][0] + 1; $j <= $maxlevel; $j++ )
	       			{
	          		$levels[$j] = 0;
       				}
     			}

	     	if( $levels[$tree[$i][0]] == 0 )
     			{
       			$levels[$tree[$i][0]] = 1;
	       		$tree[$i][4] = 1;
     			}
     		else
			{
       			$tree[$i][4]=0;
			}

	     	$lastlevel=$tree[$i][0];  
	  	}
  
  
	  /*********************************************/
	  /*  Determine visible nodes                  */
	  /*********************************************/
  	  $visible[0] = 1;   // root is always visible
	  for( $i = 0; $i < count( $explevels ); $i++ )
	  	{
    		$n = $explevels[$i];

		$subvalues = explode( "-", $n );

		if( count( $subvalues ) > 1 )
			{
			for( $n = $subvalues[0]; $n <= $subvalues[1]; $n++ )
				{
		    		if( ( $visible[$n] == 1 ) && ( $expand[$n] == 1 ) )
	    				{
        				$j = $n + 1;

		       			while( $tree[$j][0] > $tree[$n][0] )
       						{
	        		 		if( $tree[$j][0] == $tree[$n][0] + 1 ) { $visible[$j] = 1; }
			         		$j++;
       						}
	    				}
				}
			}
		else
			{
		    	if( ( $visible[$n] == 1 ) && ( $expand[$n] == 1 ) )
	    			{
        			$j = $n + 1;

	       			while( $tree[$j][0] > $tree[$n][0] )
       					{
	        	 		if( $tree[$j][0] == $tree[$n][0] + 1 ) { $visible[$j] = 1; }
		         		$j++;
       					}
    				}
			}
  		}
  
  
	  /*********************************************/
	  /*  Output nicely formatted tree             */
	  /*********************************************/
  	  for( $i = 0; $i < $maxlevel; $i++) 
		{
		$levels[$i] = 1;
		}

	  $maxlevel++;
  
	  echo "<div class=\"treemenu\">\n";  
	  echo "<table cellspacing=0 cellpadding=0 border=0 cols=" . ( $maxlevel + 3 ) . " width=" . ( $maxlevel * 16 + 100 ) . ">\n";
	  echo "<tr>";
	  for( $i = 0; $i < $maxlevel; $i++) { echo "<td width=16></td>"; }
	  echo "<td width=100></td></tr>\n";
	  $cnt=0;
	  while( $cnt < count( $tree ) )
  		{
	    	if( $visible[$cnt] )
    			{
			/****************************************/
	      		/* start new row                        */
      			/****************************************/      
      			echo "<tr>";
      
	      		/****************************************/
      			/* vertical lines from higher levels    */
      			/****************************************/
	      		$i = 0;
      			while( $i < $tree[$cnt][0] - 1 ) 
	      			{
        			if( $levels[$i] == 1 )
					{
            				echo "<td><img src=\"".$img_line."\" border=0 alt=\"|\"></td>";
					}
        			else
					{
            				echo "<td><img src=\"".$img_spc."\" border=0 alt=\"\"></td>";
					}
        			$i++;
      				}
      
	      		/****************************************/
      			/* corner at end of subtree or t-split. */
			/* don't bother with the first one.	*/
      			/****************************************/         
			if( $cnt > 0 )
				{
		      		if( $tree[$cnt][4] == 1 ) 
      					{
        				echo "<td><img src=\"" . $img_end . "\" border=0 alt=\"|\"></td>";
	        			$levels[$tree[$cnt][0]-1] = 0;
      					}
	      			else
      					{
	        			echo "<td><img src=\"" . $img_split . "\" border=0 alt=\"|\"></td>";                  
        				$levels[$tree[$cnt][0]-1] = 1;    
      					} 
				}
			else
				{
        			$levels[$tree[$cnt][0]-1] = 0;
				}
      
      			/********************************************/
	      		/* Node (with subtree) or Leaf (no subtree) */
      			/********************************************/
      			if( $tree[$cnt+1][0] > $tree[$cnt][0] )
	      			{
        
	        		/****************************************/
        			/* Create expand/collapse parameters    */
        			/* First, run through and deterime if   */
        			/* are expanding or collapsiing the     */
				/* current item.   			*/
        			/****************************************/
        			$i = 0; 
				$j = 0;
				$subvalue = array();

        			while( $i < count( $expand ) )
        				{
        	  			if( ( $expand[$i] == 1) && ( $cnt != $i ) || ( $expand[$i] == 0 && $cnt == $i ) )
	          				{
						$subvalue[$j] = $i;
						$j++;
          					}
          				$i++;
        				}

        			/****************************************/
        			/* Now it gets complex ;)               */
        			/*                                      */
        			/* We want to create the display list   */
        			/* so that it uses as little space as   */
        			/* possible, so if we need to only hide */
        			/* entries 5-10 we want a list          */
        			/* list this:                           */
        			/*   0-4|11-15|                         */
        			/* instead of:                          */
        			/*   0|1|2|3|4|11|12|13|14|15|          */
        			/****************************************/
				$j = 0;
				$lastparam = $subvalue[0];
				$newlist = $subvalue[0];

				for( $i = 1; $i < count( $subvalue ); $i++ )
					{
					if( $subvalue[$i] - $subvalue[$i-1] > 1 )
						{
						$newparams[$j][1] = $subvalue[$i-1];

						if( $lastparam == $subvalue[$i-1] )
							{
							$newlist = $newlist . "|" . $subvalue[$i];
							}
						else
							{
							$newlist = $newlist . "-" . $subvalue[$i-1] . "|" . $subvalue[$i];
							}

						$j++;
						$lastparam = $subvalue[$i];
						}
					}

        			/****************************************/
        			/* We need to take care of the last     */
        			/* item in the list otherwise it will   */
        			/* get dropped and things would be bad  */
        			/****************************************/
				if( $lastparam == $subvalue[$i - 1] )
					{
					$newlist = $newlist . "|";
					}
				else
					{
					$newlist = $newlist . "-" . $subvalue[$i-1] . "|";
					}

				if( strchr( $script, "?" ) )
					{
					$params = "&" . $varname . "=" . $newlist;
					}
				else
					{
					$params = "?" . $varname . "=" . $newlist;
					}
               
	        		if( $expand[$cnt] == 0 )
					{
            				echo "<td><a href=\"" . $script . $params . "\"><img src=\"" . $img_expand . "\" border=0 alt=\"+\"></a></td>";
					}
        			else
					{
            				echo "<td><a href=\"" . $script . $params . "\"><img src=\"" . $img_collapse . "\" border=0 alt=\"-\"></a></td>";         
					}
      				}
      			else
	      			{
        			/*************************/
        			/* Tree Leaf             */
        			/*************************/

	        		echo "<td><img src=\"" . $img_leaf . "\" border=0 alt=\"\"></td>";         
      				}
      
      			/****************************************/
      			/* output item text                     */
	      		/****************************************/
      			if( $tree[$cnt][2] == "" )
				{
	          		echo "<td colspan=" . ( $maxlevel - $tree[$cnt][0] ) . " NOWRAP>" . $tree[$cnt][1] . "</td>";
				}
      			else
				{
				if( $tree[$cnt][3] == "" )
					{
		          		echo "<td colspan=" . ( $maxlevel - $tree[$cnt][0] ) . " NOWRAP><a href=\"" . $tree[$cnt][2] . "\">" . $tree[$cnt][1] . "</a></td>";
					}
				else
					{
		          		echo "<td colspan=" . ( $maxlevel - $tree[$cnt][0] ) . " NOWRAP><a href=\"" . $tree[$cnt][2] . "\" target=\"" . $tree[$cnt][3] . "\">" . $tree[$cnt][1] . "</a></td>";
					}
				}
          
      			/****************************************/
      			/* end row                              */
	      		/****************************************/
              
      			echo "</tr>\n";      
    			}
    		$cnt++;    
  		}

  	echo "</table>\n";
	echo "</div>\n";
	}

  /***************************************************/
  /* Tree file format                                */
  /*                                                 */
  /*                                                 */
  /* The first line is always of format :            */
  /* .[rootname]                                     */
  /*                                                 */
  /* each line contains one item, the line starts    */ 
  /* with a series of dots(.). Each dot is one level */
  /* deeper. Only one level at a time once is allowed*/
  /* Next comes the come the item name, link and     */
  /* link target, seperated by a |.                  */
  /*                                                 */  
  /* example:                                        */
  /*                                                 */  
  /* .top                                            */
  /* ..category 1                                    */
  /* ...item 1.1|item11.htm|main                     */
  /* ...item 2.2|item12.htm|main                     */
  /* ..category 2|cat2overview.htm|main              */
  /* ...item 2.1|item21.htm|main                     */
  /* ...item 2.2|item22.htm|main                     */
  /* ...item 2.3|item23.htm|main                     */
  /*                                                 */  
  /***************************************************/
  /*********************************************/
  /* read file to $tree array                  */
  /* tree[x][0] -> tree level                  */
  /* tree[x][1] -> item text                   */
  /* tree[x][2] -> item link                   */
  /* tree[x][3] -> link target                 */
  /* tree[x][4] -> last item in subtree        */
  /*********************************************/

  Function TreeLoadMenuFile( $filename )
	{
    	$maxlevel = 0;
	$cnt = 0;

	$fd = fopen( $filename, "r" );

  	if( $fd == 0 ) { die( "TreeLoadMenuFile(): Unable to open file " . $filename ); }

  	while( $buffer = fgets( $fd, 4096 ) ) 
  		{
    		$tree[$cnt][0] = strspn( $buffer, "." );
    		$tmp = rtrim( substr( $buffer, $tree[$cnt][0] ) );

    		$node = explode( "|", $tmp ); 

    		$tree[$cnt][1] = $node[0];
    		$tree[$cnt][2] = $node[1];
    		$tree[$cnt][3] = $node[2];
    		$tree[$cnt][4] = 0;

    		if( $tree[$cnt][0] > $maxlevel ) { $maxlevel = $tree[$cnt][0]; }

    		$cnt++;
  		}

  	fclose( $fd );

	return array( $maxlevel, $tree );
	}
?>
