<?php	// TWIG		Search Feature Module for Schedule ?>
<?php 
 TWIGLoadLanguageFile( "features/schedule/strings/", "", $config["language"] );

 if( !$global )
 	{
	echo "<form action=" . $config["baseurl"] . " method=post>\n";
	echo TWIGSession( "put" );
	echo TWIGContext( "put" );

	$entry = 0;

	$tableheaders = array( $TWIGphrase["Item"], "&nbsp", $TWIGphrase["Criteria"] );

 	if( !isset( $search_groups ) )
 		{
		$search_groups = GetPref( "dgroup", $dbconfig["schedule_prefs_table"], $config["defaults"]["schedule"]["dgroup"] );
		}
 	$temp = "<select name=search_groups>\n";
 	$temp .= TWIGGroupsSelect( $login["username"], $search_groups, 1 );
 	$temp .= "</select>\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Group"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=text name=search_subject value=" . stripslashes( $search_subject ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Subject"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=text name=search_description value=" . stripslashes( $search_description ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Description"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

 	list( $search_afterHour, $search_afterMinute, $extra_afterDays ) = TWIGTimeCleanup( $search_afterHour, $search_afterMinute, $search_afterAMPM );
 	list( $search_afterYear, $search_afterMonth, $search_afterDay )  = TWIGDateCleanup( $search_afterYear, $search_afterMonth, $search_afterDay, $extra_afterDays );
 	$temp = TWIGTimeSelector( "search_after", $search_afterHour, $search_afterMinute );
 	$temp .= TWIGDateSelector( "search_after", $search_afterYear, $search_afterMonth, $search_afterDay );
 	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["After date"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

 	list( $search_beforeHour, $search_beforeMinute, $extra_beforeDays ) = TWIGTimeCleanup( $search_beforeHour, $search_beforeMinute, $search_beforeAMPM );
 	list( $search_beforeYear, $search_beforeMonth, $search_beforeDay )  = TWIGDateCleanup( $search_beforeYear, $search_beforeMonth, $search_beforeDay, $extra_beforeDays);
 	$temp = TWIGTimeSelector( "search_before", $search_beforeHour, $search_beforeMinute );
 	$temp .= TWIGDateSelector( "search_before", $search_beforeYear, $search_beforeMonth, $search_beforeDay );
 	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Before date"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	echo "<table><tr><td>\n";
	echo TWIGGenerateTable( $tableheaders, $tablecontents );
	echo "</td></tr>";
	echo "<tr><td align=center><input type=submit name=search value=\"" . $TWIGphrase["Search"] . "\">";

	echo "</td></tr></table>\n";
	echo "</form>\n";
	}

 unset( $tableheaders );
 unset( $tablecontents );

 if( $search ) 
	{
	// Yeah, do the search

	// Build a WHERE clause
	$searchquery = "";
	if( $global )
		{
		if( $search_text )
			{
			// The first four characters are going away anyhow.
			// Might as well have a little fun ;-)
			$searchquery .= "Bla ( item LIKE '%$search_text%' ";
			$searchquery .= "OR description LIKE '%$search_text%' )";
			}
		}
	else
		{
		if( $search_subject )
			{
			$searchquery .= "AND item LIKE '%$search_subject%' ";
			}
		if( $search_description )
			{
			$searchquery .= "AND description LIKE '%$search_description%' ";
			}
		}
	if( true )
		{
		// Is there a decent condition I can check for?
		// These values are 99.44% to exist...
		$search_afterTime = convertUTimeToSQLTime( mktime( $search_afterHour, $search_afterMinute, $search_afterSecond, $search_afterMonth, $search_afterDay, $search_afterYear ) );
		$search_beforeTime = convertUTimeToSQLTime( mktime( $search_beforeHour, $search_beforeMinute, $search_beforeSecond, $search_beforeMonth, $search_beforeDay, $search_beforeYear ) );
		$searchquery .= "AND ( ( itemstart > '" . $search_afterTime . "' AND itemstart < '" . $search_beforeTime . "' ) OR ( itemstart < '" . $search_afterTime . "' AND itemstop > '" . $search_beforeTime . "' ) OR ( itemstop > '" . $search_afterTime . "' AND itemstop < '" . $search_beforeTime . "' ) )";
		}
	if( isset( $search_groups ) )
		{
		$searchquery .= "AND (" . TWIGGroupsCreateSQLGroupQuery( $login["username"], array( $search_groups ) ). ") ";
		}
	if( $searchquery )
		{
		// If there is no $searchquery (ie we failed all the above) then why bother searching?

		// Strip the first four characters because we know they are 'AND '
		$searchquery = substr( $searchquery, 4 );

 		$tableheaders = array( $TWIGphrase["Status"], "&nbsp;", $TWIGphrase["Start Time"], "&nbsp;", $TWIGphrase["End Time"], "&nbsp;", $TWIGphrase["Group"], "&nbsp;", $TWIGphrase["Description"], "&nbsp;", $TWIGphrase["Notes"] );

 		$query = "SELECT * FROM " . $dbconfig["schedule_table"] . " WHERE (" . $searchquery . ") ORDER BY itemstart";
 		$result = dbQuery( $query );
 		TWIGDebug( $query );

 		for( $i = 0, $j = dbnumrows( $result ); $i < $j; $i++ )
			{
 		 	$data = dbResultArray( $result, $i );

			if( !$data["item"] ) { $data["item"] = "[no name]"; }

			if( $data["recurtype"] == 1 ) { $recimage = "&nbsp;<img src=\"" . $img["recurring"] . "\" border=0 alt=\"[rec]\">"; } else { $recimage = ""; }
			$tablecontents[$i][0] = twigLink( "<img src=" . $img["appointment"] . " border=0 alt=\"*\">", "schedule", "view", "action=Edit&ItemID=" . $data[id] ) . $recimage;
  
 	 		if( $data["notime"] )
        	 		{
  			      	$tablecontents[$i][2] = TWIGdate( $config["shortdateformat"], convertSQLTimetoUTime( $data["itemstart"] ) ) . " " . $TWIGphrase["[None]"];
         		      	$tablecontents[$i][4] = TWIGdate( $config["shortdateformat"], convertSQLTimetoUTime( $data["itemstop"] ) ) . " " . $TWIGphrase["[None]"];
         			}
               		else
         			{
         		      	$tablecontents[$i][2] = TWIGdate( $config["shortdateformat"] . " " . TWIGGetTimeFormat(), convertSQLTimetoUTime( $data["itemstart"] ) );
				$tablecontents[$i][4] = TWIGdate( $config["shortdateformat"] . " " . TWIGGetTimeFormat(), convertSQLTimetoUTime( $data["itemstop"] ) );
  	       			}
        		
	      	 	$tablecontents[$i][6] = TWIGGroupsGetName( $data["groupid"] );
	       		$tablecontents[$i][8] = twigLink( $data["item"], "schedule", "view", "action=Edit&ItemID=" . $data["id"] );
			$tablecontents[$i][10] = $data["description"];
               		
			$tablecontents[$i][1] = "&nbsp;";
	       		$tablecontents[$i][3] = "&nbsp;";
			$tablecontents[$i][5] = "&nbsp;";
	       		$tablecontents[$i][7] = "&nbsp;";
	       		$tablecontents[$i][9] = "&nbsp;";
	        }
               	
?>             	
<table width=100% border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td valign=top bgcolor="<?php echo $config["cellheadcolor"]?>">
   <font face="<?php echo $config["cellfont"]?>" size=<?php echo $config["textfontsize"];?>><b>
    <?php echo TWIGLink( "<font color=\"" . $config["cellheadtext"] . "\">" . $TWIGphrase["Schedule"] . "</font>", "schedule" ); ?>
   </b></font>
  </td>
 </tr>
 <tr>
  <td bgcolor=<?php echo $config["cellcolor"]?>>
   &nbsp;
  </td>
 </tr>
 <tr>
  <td valign=top bgcolor=<?php echo $config["cellcolor"]?>>
   <?php
   if( $tablecontents )
	{
	echo TWIGGenerateTable( $tableheaders, $tablecontents, "", "95%", "center" );
	}
   else
	{
	echo "<font face=" . $config["cellfont"] . " size=" . $config["textfontsize"] . ">";
	echo "<b><i>" . $TWIGphrase["No matches"] . "</i></b></font>\n";
	}
   ?>
  </td>
 </tr>
 <tr>
  <td bgcolor=<?php echo $config["cellcolor"]?>>
   &nbsp;
  </td>
 </tr>
</table>
<?php
		}
	}

?>
