<?php

 // We need a few functions from the contacts feature to display the contact lists
 if( !$included["features/shared/contacts.inc.php3"] ) { include( "features/shared/contacts.inc.php3" ); }

 if( !isset( $ItemID ) && isset( $data["id"] ) ) { $ItemID = $data["id"]; }

 list( $thisHour, $thisMinute, $extra_thisDays ) = TWIGTimeCleanup( $thisHour, $thisMinute, $thisAMPM );
 list( $thisYear, $thisMonth, $thisDay )  = TWIGDateCleanup( $thisYear, $thisMonth, $thisDay, $extra_thisDays );
 $data["itemdone"] = createSqlDateTime( $thisYear,  $thisMonth,  $thisDay, $thisHour, $thisMinute, 0 );

 $ret = TWIGListItemEditProcess(  "edit", $dbconfig["meetings_table"], $groupquery, $data );
 if( $ret != FALSE && $ret != TRUE )
 	{
 	TWIGPrintError( $ret );
 	}

 $i = 0;
 $menu[$i] = array( "command" => "meetings", "desc" => $TWIGphrase["Back to Meetings"], "action" => "main", "options" => "list=0", "target" => "", "image" => "registered.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => $TWIGphrase["View details"], "action" => "view", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => $TWIGphrase["Edit notes"], "action" => "notes", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => $TWIGphrase["Edit todo"], "action" => "todo", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => $TWIGphrase["Edit invitees"], "action" => "invite", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => $TWIGphrase["Reschedule"], "action" => "edit", "options" => "ItemID=$ItemID", "target" => "", "image" => "private.gif" ); $i++;

 $data = TWIGListGetItem( $ItemID, $dbconfig["meeting_table"], "*", $GroupQuery);
 echo TWIGListItemHeader( $data, "edit", $menu );

 // I'm not sure if this works as intended.
 // What I mean to do is to ignore the db (and thereby use today's date)
 // in the event that the db has not had a date set yet.
 if( $thisDate != 0 )
 	{
 	$thisDate = convertSQLTimetoUTime( $data["itemdone"] );
 	list( $thisYear, $thisMonth, $thisDay, $thisHour, $thisMinute ) = TWIGDateTimeFromUTime( $thisDate );
 	}
?>

<TABLE BORDER="0" CELLSPACING="0">
 <tr>
  <td colspan=2 bgcolor="<?php echo $config["cellheadcolor"]; ?>">
   <table width=100%><tr><td>
   <font face="<?php echo $config["cellfont"]; ?>" size=<?php echo $config["largetitlefontsize"];?> color="<?php echo $config["cellheadtext"]; ?>">
   <?php 
     echo $TWIGphrase["Edit Meeting ToDo"];
   ?>
   </font>
   </td><td align=right>
   <font face="<?php echo $config["cellfont"]; ?>" size=<?php echo $config["textfontsize"];?> color="<?php echo $config["cellheadtext"]; ?>">
   <?php echo $TWIGphrase["Added by"];?>:
   <?php echo TWIGMailto( $data["username"], $data["username"] ); ?>
   </font>
   </td></tr></table>
  </td>
 </tr>
  <TR>
    <TD BGCOLOR="<?php echo $config["cellcolor"]; ?>" COLSPAN="2">
      <font face=<?php echo $config["cellfont"]?> size=<?php echo $config["textfontsize"];?> color=<?php echo $fontcolor?>><b><?php echo $TWIGphrase["Meeting Name"]; ?></b>:</font><br>
      <?php echo TWIGmassage( $data["item"] ); ?>
    </TD>
  </TR>
<?php
// Tags were broken with a - between <> and ?. Remove to enable. 
//  <TR>
//    <TD BGCOLOR="<-?php echo $config["cellcolor"]; ?->" COLSPAN="1">
//      <font face=<-?php echo $config["cellfont"]?-> size=<-?php echo $config["textfontsize"];?-> color=<-?php echo $fontcolor?->><b><-?php echo $TWIGphrase["Type"]; ?-></b>:</font><br>
//      <-?php echo TWIGmassage( $data["type"] ); ?->
//    </TD>
//    <TD BGCOLOR="<-?php echo $config["cellcolor"]; ?->" COLSPAN="1">
//      <font face=<-?php echo $config["cellfont"]?-> size=<-?php echo $config["textfontsize"];?-> color=<-?php echo $fontcolor?->><b><-?php echo $TWIGphrase["Location"]; ?-></b>:</font><br>
//      <-?php echo TWIGmassage( $data["location"] ); ?->
//    </TD>
//  </TR>
?>
  <TR>
    <TD BGCOLOR="<?php echo $config["cellcolor"]; ?>" COLSPAN="2">
      <font face=<?php echo $config["cellfont"]?> size=<?php echo $config["textfontsize"];?> color=<?php echo $fontcolor?>><b><?php echo $TWIGphrase["Last Modified"]; ?></b>:</font><br>
      <?php echo date( $config["longdateformat"], convertSQLTimetoUTime( $data["thedate"] )); ?>
    </TD>
  </TR>
  <TR>
    <TD BGCOLOR="<?php echo $config["cellcolor"]; ?>" NOWRAP VALIGN="top">
      <font face=<?php echo $config["cellfont"]?> size=<?php echo $config["textfontsize"];?> color=<?php echo $fontcolor?>><b><?php echo $TWIGphrase["Person Responsible"]; ?></b>:</font><br>
      <?php
        // Unfortunately, TWIGGenerateContactsList does no good for us,
	// since we need to display a SELECTED item.
	// We still check to see if you're allowed to get at the contacts.
	if( TWIGCheckACL( $login["username"], 2003, TWIGConvertAccess( "read" ) ) )
		{
		echo "<SELECT NAME=data[responsible] SIZE=5>\n";
		$grouplist  = TWIGGroupsMembership( $login["username"] );
	
 		$sortorder = array( "nickname"=>"item", "name"=>"lastname,firstname", "company"=>"company", "group"=>"groupid", "email"=>"email" );
 		$orderby = $sortorder[GetPref( "sortby", $dbconfig["contacts_prefs_table"], $config["defaults"]["contacts"]["sortby"] )];
 		if( !$orderby ) { $orderby = "item"; }
	
		$query = "SELECT username, item, firstname, lastname, email, email2, email3, type FROM " . $dbconfig["contact_table"] . " WHERE (" . TWIGGroupsCreateSQLGroupQuery( $login["username"], $grouplist ) . ") AND userpers = 1 ORDER BY " . $orderby;
		TWIGDebug( $query );
	
		$result = dbquery( $query );
	
		for( $i = 0, $j = dbnumrows( $result ); $i < $j; $i++ )
			{
			$cdata = dbresultarray( $result, $i );
	
			$personal = trim( $cdata["firstname"] . " " . $cdata["lastname"] );
			if( $cdata["email"]  )
				{
				$ret .= "<option value='" . $data[username] . "'";
				if( $cdata[username] == $data[responsible] ) { $ret .= " SELECTED>"; } else { $ret .= ">"; }
				if( $personal ) {$ret .= "&quot;$personal&quot; ";}
				$ret .= "&lt;" . $cdata["email"]  . "&gt;</option>";
				}
			if( $cdata["email2"] )
				{
				$ret .= "<option value='" . $data[username] . "'";
				if( $cdata[username] == $data[responsible] ) { $ret .= " SELECTED>"; } else { $ret .= ">"; }
				if ($personal) {$ret .= "&quot;$personal&quot; ";}
				$ret .= "&lt;" . $cdata["email2"] . "&gt;</option>";
				}
			if( $cdata["email3"] )
				{
				$ret .= "<option value='" . $data[username] . "'";
				if( $cdata[username] == $data[responsible] ) { $ret .= " SELECTED>"; } else { $ret .= ">"; }
				if ($personal) {$ret .= "&quot;$personal&quot; ";}
				$ret .= "&lt;" . $cdata["email3"] . "&gt;</option>";
				}
			if( $cdata["type"] == 2 )
				{
				$ret .= "<option value=\"" . $cdata["item"] . "\">List: " . $cdata["item"] . "</option>";
				}
			}
		echo $ret;
		echo "      </SELECT>\n";
		}
      ?>
    </TD>
    <TD BGCOLOR="<?php echo $config["cellcolor"]; ?>" NOWRAP VALIGN="top">
      <font face=<?php echo $config["cellfont"]?> size=<?php echo $config["textfontsize"];?> color=<?php echo $fontcolor?>><b><?php echo $TWIGphrase["Due Date"]; ?></b>:</font><br>
      <?php echo TWIGDateSelector( "this", $thisYear, $thisMonth, $thisDay ); ?>
    </TD>
  </TR>
  <TR>
    <TD BGCOLOR="<?php echo $config["cellcolor"]; ?>" COLSPAN="2">
      <font face=<?php echo $config["cellfont"]?> size=<?php echo $config["textfontsize"];?> color=<?php echo $fontcolor?>><b><?php echo $TWIGphrase["Action Items"]; ?></b>:</font><br>
      <?php
		echo "<TEXTAREA NAME='data[actionitems]' ROWS='15' COLS='78' WRAP='hard'>\n";
		echo TWIGmassage( $data["actionitems"] ) . "\n";
		echo "      </TEXTAREA>\n";
      ?>
    </TD>
  </TR>
</TABLE>

<?php
 if( TWIGGroupsMemberOf( $data["groupid"], 2 ) )
 	{
	$buttons = "<input type=submit name=submitbutton[update] value=\"" . $TWIGphrase["Update"] . "\">\n";
	}
 echo TWIGListItemFooter( $data, "edit", $buttons );
?>

