#ifndef TWCLOCK_H_INCLUDED
#define TWCLOCK_H_INCLUDED
/*
 *	HEADER FILE FOR TEDSCLOCK
 */
#include <time.h> 
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/types.h>
	
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/xpm.h>

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/TextF.h>
#include <Xm/Scale.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/FileSB.h>
#include <Xm/DialogS.h>
#include <Xm/ToggleB.h>
#include <Xm/MwmUtil.h>
#include <Xm/MessageB.h>
#include <Xm/Separator.h>
#include <Xm/RowColumn.h>

#define LOCAL_BTN  0
#define GMT_BTN    1
#define OTHERS_BTN 2
#define SET_TIMER_BTN 3
#define ID_NOW_BTN 4
#define QRT 5

/*
 * APPLICATION DEFINED RESOURCES
 */
#define XmNtzone           "tzone"
#define XmCTzone           "Tzone"

#define XmNblink           "blink"
#define XmCBlink           "Blink"

#define XmNbeep            "beep"
#define XmCBeep            "Beep"

#define XmNcwID            "cwID"
#define XmCCwID            "CwID"

#define XmNcwStr           "cwStr"
#define XmCCwStr           "CwStr"

#define XmNcwSpeed         "cwSpeed"
#define XmCCwSpeed         "CwSpeed"

#define XmNcwLevel         "cwLevel"
#define XmCCwLevel         "CwLevel"

#define XmNautoReset       "autoReset"
#define XmCAutoReset       "AutoReset"

#define XmNautobeeps       "autobeeps"
#define XmCAutobeeps       "Autobeeps"

#define XmNflashColor      "flashColor"
#define XmCFlashColor      "FlashColor"

#define XmNminutes         "minutes"
#define XmCMinutes         "Minutes"

#define XmNseconds         "seconds"
#define XmCSeconds         "Seconds"

typedef struct
   {
      int     tzone;
      int     blink;
      int     beep;
      int     cwID;
      char    *cwStr;
      int     cwSpeed;
      int     cwLevel;
      int     autoReset;
      int     autobeeps;
      Pixel   flashColor;
      int     minutes;
      int     seconds;
   } AppRes;

/*
 * Globals and Forward Declarations
 */
XtAppContext app;
AppRes appRes;

Widget clock_shell;
Widget call_toggleB;
Widget hr_scale;
Widget min_scale;
Widget sec_scale;
Widget date_label;

int doit;
int count;
int flashFlag;
int cwIDdone;
XtIntervalId alarm_id;
XtIntervalId auto_id;
XtIntervalId time_id;

void build_widgets(void);
void input_event(Widget, XtPointer, XEvent *, Boolean *);
void popup_cb (Widget, XtPointer, XtPointer);
void TBchangeCB (Widget, XtPointer, XtPointer);
void optionsCB (Widget, XtPointer, XtPointer);
void scalesCB (Widget, XtPointer, XtPointer);
void timer (void);
void gettime (void);
void fsbOkCB (Widget , XtPointer, XtPointer);
void fsbCancelCB (Widget , XtPointer, XtPointer);
void timerOkCB (Widget , XtPointer, XtPointer);
void timerModVerCB (Widget , XtPointer, XtPointer);
void settimer (void);

#endif
