/*
	TuxPuck - board.h
	Copyright (C) 2001-2002 Jacob Kroon

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Jacob Kroon - d00jkr@efd.lth.se
*/

#ifndef _BOARD_H
#define _BOARD_H

/* includes */
#include "entity.h"

/* defines */
#define BOARD_STATE_PLAY	1
#define BOARD_STATE_NEW_PUCK	2
#define BOARD_STATE_CRASH_GLASS	3
#define BOARD_TOP		((float)175)
#define BOARD_BOTTOM		((float)465)
#define BOARD_LEFT		((float)203)
#define BOARD_RIGHT		((float)517)

/* functions */
void board_init(void);
void board_deinit(void);
void board_blit(void);
void board_reblit(void);
void board_clean_up(void);
Uint8 board_update(Uint32);
Pad *board_get_pad(Uint8);
Puck *board_get_puck(void);
Uint8 board_get_state(void);
Uint8 board_get_turn(void);
float board_calc_y(float);
float board_calc_scale(float);

#endif /* _BOARD_H */
