<?php
/**
 * Copyright 2000 - 2003 by Gero Kohnert
 *
 * @modulegroup note
 * @module note_show
 * @package note
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';


 /* Check if user is allowed to use it */
 check_user();
 loadmodules("note","show");
 loadmodule("note");
 loadlayout();
 
 /**
  * display a note 
  */
 class note_show extends layout {
   /**
    *
    */
   Function info() {
     global $lang,$tutos;

     echo $this->DataTableStart();
     echo "<tr><th colspan=\"4\">". $lang['Note'] ."</th></tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['createdby']);
     echo $this->showdata($this->obj->creator->getLink(),1);
     echo $this->showfield($lang['atDateTime']);
     echo $this->showdata($this->obj->creation->getLinkDateTime(),1);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['NoteName']);
     echo "<td colspan=\"3\"><b><font size=\"+1\">". myentities($this->obj->name) ."</font><b></td>";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['NoteReference']);
     echo $this->showdata($this->obj->getRefLink(),3);
     echo "</tr>\n";

     if ( $this->obj->remember->notime != 1 ) {
       echo "<tr>\n";
       echo $this->showfield($lang['NoteRemember']);
       echo "<td colspan=\"3\">". $this->obj->remember->getDateTime() ."</td>";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo " <td colspan=\"4\" class=\"pre\"><pre>". urlReplace($this->obj->note) ."</pre></td>";
     echo "</tr>\n";

     # References to modules
     show_module_infolists($this->user,$this->obj,4);
     echo $this->obj->getHistoryLink(4);

     echo $this->DataTableEnd();
   }
   /**
    * navigation
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['NoteDetail'];
     $this->obj = new note($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
	 } else {
       $msg .= $lang['Err0048'] ."<br>";
       $this->stop = true;
	 }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->obj->read_reference();
	 }
     # menu
     $m = note::getSelectLink($this->user, $lang['Search']);
     $m[category][] = "obj";
     $this->addmenu($m);

     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => $this->obj->getModURL(),
                   text => $lang['Modify'],
                   info => $lang['NoteMod'],
                   category => array("note","mod","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => $this->obj->getDelURL(),
                   text => $lang['Delete'],
                   info => $lang['NoteDelete'],
                   confirm => true,
                   category => array("note","del","obj")
                 );
       $this->addMenu($x);
     }

     add_module_addlinks($this,$this->obj);
     # add this page to the browsehistory of the users session
	 $this->addtohistory();
	 web_StackStartLayoutObj($this); 
   }
 }

 $l = new note_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: note_show.php,v 1.22 2004/01/16 19:29:41 gokohnert Exp $
    $Author: gokohnert $
-->
