<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 *   CVS Info:  $Id: ldap_show.php,v 1.9.2.1 2004/09/09 10:39:38 tapoueh Exp $
 *   $Author: tapoueh $
 *
 * @modulegroup address
 * @module adr_ldap_overview
 * @package address
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("ldap","show");
 loadmodule("ldap");

 /**
  * display a address
  */
 class ldap_show extends layout {
   /**
    * Display a ldap entry (all data)
    */
   Function info() {
     global $lang,$tutos;

     if ( ! $this->obj->connect() ) {
       echo $this->error($lang['LDAP_Err001']);
       return;
     }
#    var_dump(ldap_explode_dn($this->filter,0));
     echo $this->filter ."<br>";
     if (!isset($this->attribs) ) {
       $this->attribs = array( $this->keyname,"cn","l","sn","o","c","ou","mail","department","*");
     }
     if ( $this->keyname == "dn" ) {
       $sr = ldap_read($this->obj->ds,$this->filter,"(objectClass=*)",$this->attribs,0,40,10,LDAP_DEREF_ALWAYS);
     } else {
       $sr = ldap_search($this->obj->ds,$this->obj->basedn,"(&(". $this->filter.")(objectClass=*))",$this->attribs,0,40,10,LDAP_DEREF_ALWAYS);
     }
     #$sr = ldap_search($this->obj->ds,$this->obj->basedn,"(". $this->filter.")",$this->attribs,0,40,10,LDAP_DEREF_ALWAYS);
     if (!$sr) {
       echo $this->error($this->obj->error());
       return;
     }
     $cnt = ldap_count_entries($this->obj->ds,$sr);
     if ($cnt == 0) {
       echo $this->error($this->obj->error());
       return;
    }
     echo $this->DataTableStart();
     echo "<tr><th colspan=\"2\">". $this->obj->getFullName() ."</th></tr>\n";
     $x = ldap_first_entry($this->obj->ds,$sr);
     while ($x != false ) {
       $y = ldap_first_attribute($this->obj->ds,$x,$info);
       while ($y) {
         $d = ldap_get_values_len($this->obj->ds,$x,$y);
         echo "<tr>\n";
         echo $this->showfield($y);
         echo "<td>\n";
         if ( isset($d['count']) ) {
           for ($k = 0;$k < $d['count'];$k++) {
             if ( eregi("certificate",$y) ) {
# TODO make some cool OPSENSSL Stuff here
               echo "<br><pre>skipped (". strlen($d[$k]) ." Bytes)</pre><br>";
             } else if ( $y == "jpegPhoto" ) {
               echo "<br><pre>skipped (". strlen($d[$k]) ." Bytes)</pre><br>";
             } else if (eregi("facsimile",$y)){
               echo handle('fax',$y,$this->obj->decode($d[$k]));
             } else if (eregi("telephone",$y)){
               echo handle('phone',$y,$this->obj->decode($d[$k]));
             } else if (eregi("mobile",$y)){
               echo handle('phone',$y,$this->obj->decode($d[$k]));
             } else if (eregi("mail",$y)){
               echo AsEmail($d[$k],$d[$k],$d[$k]);
             } else if (eregi("postalAddress",$y)){
               echo eregi_replace("[$]","<br>",$d[$k]);
             } else if (eregi("street",$y)){
               echo eregi_replace("[$]","<br>",$d[$k]);
             } else if (eregi("uri",$y)){
               $desc = "";
               $uri = "";
               foreach(explode(" ",$d[$k]) as $f) {
                 if (eregi("^http",$f)) {
                   $uri = $f;
                 } else {
                   $desc .= $f." ";
                 }
               }
               echo "<br><a target=\"_blank\" href=\"". $uri ."\">". $desc ."(". $uri .")</a>";
             } else {
               echo $this->obj->decode($d[$k])  ."<br>";
             }
           }
         } else {
           echo ":". $this->obj->decode($d);
         }
         echo "</td>";
         echo "</tr>\n";
         $y = ldap_next_attribute($this->obj->ds,$x,$info);
       }
       $x = @ldap_next_entry($this->obj->ds,$x);
       if ($x != false) {
         echo "<tr><td colspan=\"2\"><hr></td></tr>\n";
       }
     }
     echo $this->DataTableEnd();

     echo "<form name=\"ldap_adr_ins\" action=\"ldap_import.php\" method=\"post\">";
     if ( $this->adr == -1 ) {
       echo $lang['LDAPNotSynced'];
       echo "&nbsp;<input type=\"submit\" value=\"". $lang['LDAPImport']."\">";
     } else {
       echo $this->adr->getLink();
       $this->addHidden("adr_id",$this->adr->id);
       echo "&nbsp;<input type=\"submit\" value=\"". $lang['LDAPUpdate']."\">";
     }
     $this->addHidden("key",$this->filter);
     $this->addHidden("host",$this->obj->host);
     $this->addHidden("port",$this->obj->port);
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>";
     $this->obj->close();
   }
   /**
    * navigation
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $lang,$tutos;
     $this->name = $lang['LDAPDetail'];
     $this->obj = new ldap($this->dbconn);

     if ( isset($_GET['sv']) ) {
       # remember this
       $_SESSION['ldapserver'] = $_GET['sv'];
       $this->obj->setserver($_GET['sv']);
     }
     if ( isset($_GET['host']) && isset($_GET['port'])) {
       $this->obj->sethost($_GET['host'],$_GET['port']);
     }

     if ($this->obj->host == "") {
       $msg .= "NO Server defined !";
       $this->stop = true;
     }
     $this->keyname = $tutos['ldap:'.$this->obj->host.':'.$this->obj->port]['uniquekey'];
     if ( isset($_GET['key']) ) {
       $this->filter = $_GET['key'];
       $this->adr = $this->obj->getData($_GET['key']);
       # Search for this person in TUTOS database entries
     }
     if (isset($_GET['attribs']) ) {
       $this->attribs =$_GET['attribs'];
     }

     $x = tutos_address::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);
     # close the session in order to handle ldap timeouts
     session_write_close();
   }
 }

 $l = new ldap_show($current_user);
 $l->display();
 $dbconn->Close();

?>
