<?php
/*
 * Checklist: Copyright 2002 by Markus Leist under GNU GPL
 * TUTOS:     Copyright 1999 - 2002 by Gero Kohnert
 *
 *  CVS Info:  $Id: checkfield_show.php,v 1.5 2003/02/19 16:54:27 gokohnert Exp $
 *  $Author: gokohnert $
 *
 */

 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include 'webelements.p3';
 include 'permission.p3';
 include 'checklist/checkfield.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("checklist","show");
 loadmodule("checklist");
 loadlayout();
 /**
  * display a checkfield and its usage
  */
 class checkfield_show extends layout {
   /**
    *
    */
   Function info() {
     global $tutos,$lang;

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">". sprintf($lang['Showing'],$lang['Checkfield'] ." ".$this->obj->getFullName()) ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['createdby']);
     echo $this->showdata($this->obj->creator->getLink());
     echo $this->showfield($lang['atDateTime']);
     echo $this->showdata($this->obj->creation->getDateTime());

     echo "</tr><tr>\n";
     echo $this->showfield($lang['CheckfieldName']);
     echo $this->showdata(myentities($this->obj->name),3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['CheckfieldReference']);
     echo $this->showdata($this->obj->getRefLink(),3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['CheckfieldType']);
     echo $this->showdata($this->obj->getObjType(),1);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['CheckfieldDescription']);
     echo $this->showdata(myentities($this->obj->description),3);
     echo "</TR>\n";

     echo "</tr><tr>\n";
     echo $this->showfield($lang['CheckfieldHelp']);
     echo $this->showdata(myentities($this->obj->help_text),3);
     echo "</tr>\n";

     checkfield::infolist($this->user,$this->obj,4,$this->format);

     # References to modules
     show_module_infolists($this->user,$this->obj,4,$this->format);
     echo $this->obj->getHistoryLink(4);
     echo $this->DataTableEnd();
   }
   /**
    * naviagte
    */
   Function navigate() {
     global $tutos,$lang;

     echo "<tr><td>";
     if ( $this->user->feature_ok(usechecklists,PERM_NEW) ) {
       echo menulink("checklist/checkfield_new.php?link_id=".$this->obj->ref->id,$lang['NewEntry'],$lang['CheckfieldCreate']) ."<BR>";
     }
     if ( $this->obj->mod_ok() ) {
       echo menulink("checklist/checkfield_new.php?id=". $this->obj->id ,$lang['Modify'],sprintf($lang['CheckfieldModify'],$this->obj->getFullName())) ."<br>\n";
     }
     
     if ( isset($this->obj->ref) && $this->obj->ref->see_ok() ) {
       echo menulink($this->obj->ref->getUrl() ,$lang['ChecklistDetail'],sprintf($lang['ChecklistDetail4'],$this->obj->ref->getFullName())) ."<br>\n";
     }
     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['Checkfield'];
     $this->obj = new checkfield($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->obj->read_reference();
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     $m = checklist::getSelectLink($this->user,$lang['Search']);
     $this->addmenu($m);
     add_module_addlinks($this,$this->obj);
   }
 }

 $l = new checkfield_show($current_user);
 $l->display();
 $dbconn->Close();

// CVS Info:  $Id: checkfield_show.php,v 1.5 2003/02/19 16:54:27 gokohnert Exp $
//  $Author: gokohnert $

?>
