<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup bug
 * @module bug_overview
 * @package bug
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bug","overview");
 loadlayout();

 /**
  * show a overview of bugs
  */
 class bug_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $n = $this->result->numrows();
     if ( $this->format == "stat") {
       $this->statinfo();
       return;
     }

     # Make a big array of all visible bugs
     $blist = array();
     $x = 0;
     while ( $x < $n ) {
       $b = new bug($this->dbconn);
       $b->read_result($this->result,$x);
       $x++;
       if ( ! $b->see_ok() ) {
         continue;
       }
       $blist[] = &$b;
       unset($b);
     }
     $n = count($blist);
     $this->result->free();
  
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       return;
     }

     echo $this->actionformStart("bug_overview.php");
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo $this->orderHeader("",$lang['BugID'],$this->link2);
     echo $this->orderHeader("creation",$lang['Date'],$this->link2);
     echo $this->orderHeader("",$lang['BugReference'],$this->link2);
     echo $this->orderHeader("",$lang['BugShort'],$this->link2);
     echo $this->orderHeader("state",$lang['BugState'],$this->link2);
     echo $this->orderHeader("class",$lang['BugClass'],$this->link2);
     echo $this->orderHeader("",$lang['BugCreator'],$this->link2);
     echo $this->orderHeader("",$lang['BugAssignedTo'],$this->link2);
     if ( $tutos[massupdate] == 1 ) {
       echo "  <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     }
     echo "</tr>\n";
     echo "</thead>\n";

     if ( $this->format == "paper" ) {
       $a = 0;
       $end = $n;
     } else if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     $this->filter['name'] = prepare_regpattern($this->filter['name']);

     echo "<tbody>\n";
     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $b = &$blist[$a];

       echo $this->OverviewRowStart($line);
       $x = myentities($b->getFullName());
       if ( $this->filter['name'] != "" ) {
         $x = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</SPAN>",$x);
       }
       echo " <td nowrap align=\"right\">". makelink($b->getUrl(),$x) ."</td>\n";
       echo " <td>". $b->creation->getDate() ."</td>\n";
       if ( $b->parent->id > 0 ) {
         echo " <td>&nbsp;". $b->parent->getLink() ."</td>\n";
       } else {
         echo " <td>&nbsp;". $lang['HistoryDeleted'] ."</td>\n";
       }
       $x = myentities($b->short);
       if ( $this->filter['name'] != "" ) {
         $x = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$x);
       }
       echo " <td>&nbsp;". $x ."</td>\n";
       echo " <td>&nbsp;". $b->getState() ."</td>\n";
       echo " <td>&nbsp;". $b->getClass() ."</td>\n";
       echo " <td>&nbsp;". $b->creator->getLink($b->creator->getShortname()) ."</td>\n";
       echo " <td>&nbsp;". $b->solver->getLink($b->solver->getShortname()) ."</td>\n";
       if ( $tutos[massupdate] == 1 ) {
         echo " <td align=\"center\">\n";
         if ( $b->mod_ok() ) {
           echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $b->id ."\">\n";
         } else {
           echo "-\n";
         }
         echo "</td>\n";
       }
       echo $this->OverviewRowEnd($line++);
       $a++;
     }
     echo "</tbody>\n";

     echo $this->list_navigation($this->link1,8 + $tutos[massupdate] ,$this->start,$a,$n);

     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart(7);
       echo sprintf($lang['withmarked'],$lang['Bugs']);
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       if ( $tutos[bugdelete] == 1 ) {
         echo " <option VALUE=\"-2\">". $lang['Delete'] ."</option>\n";
       }
       @reset($lang['BugClasses']);
       while ( list ($f,$i) = @each ($lang['BugClasses']) ) {
         echo " <option value=\"C". $f ."\">". sprintf($lang['SetTo'],$lang['BugClass'],$i) ."</option>\n";
       }
       @reset($lang['BugStates']);
       while ( list ($f,$i) = @each ($lang['BugStates']) ) {
         echo " <option value=\"S". $f ."\">". sprintf($lang['SetTo'],$lang['BugState'],$i) ."</option>\n";
       }
       echo " <option value=\"-4\">". $lang['AclModify'] ."</option>\n";
       echo "</select>\n";
       echo $this->UpdateRowEnd(2);
     }
     echo $this->OverviewTableEnd();
     echo $this->actionformEnd("bug_overview.php");
   }
   /**
    * Statistical Bug Info
    */
   Function statinfo() {
     global $lang,$tutos;

     $n = $this->result->numrows();
     $a = 0;

     $cmin = time();
     $cmax = -1;
     $tmin = time();
     $tmax = -1;
     $ttl = 0.0;
     $tts = 0.0;
     $ttc = 0.0;
     $ns = 0;
     $nc = 0;

     $cnt = 0;
     while ( $a < $n ) {
       $b = new bug($this->dbconn);
       $b->read_result($this->result,$a);
       $a++;

       if ( ! $b->see_ok() ) {
         unset($b);
         continue;
       }
       if ( !isset($states[$b->state]) ) {
         $states[$b->state] = 0;
       }
       if ( !isset($classes[$b->class]) ) {
         $classes[$b->class] = 0;
       }
       $states[$b->state]++;
       $classes[$b->class]++;
       $t1 = $b->creation->getTimestamp();
       $cmin = min($t1,$cmin);
       $tmin = min($t1,$tmin);
       $cmax = max($t1,$cmax);
       $tmax = max($t1,$tmax);

       if ( ($b->state == BUG_STATE_SOLVED) && ($b->solvedate->notime != 1) ) {
         $t2 = $b->solvedate->getTimestamp();
         $tts += ( $t2 - $t1 );
         $tmax = max($t2,$tmax);
         $ns++;
       } else if ( ($b->state == BUG_STATE_CLOSED) && ($b->solvedate->notime != 1)) {
         $t2 = $b->solvedate->getTimestamp();
         $ttc += ( $t2 - $t1 );
         $tmax = max($t2,$tmax);
         $nc++;
       } else {
         $t2 = time();
       }
       $ttl += ( $t2 - $t1 );
       $bl[] = &$b;
       $cnt++;
       unset($b);
     }

     # we need it 
     $b = new bug($this->dbconn);

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"5\">". $lang['BugStatsTitle'] ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['Count']);
     echo " <td colspan=\"4\">". $cnt ."\n";
     $pre = "filterd by ";
     while ( list ($i,$f) = @each ($this->filter) ) {
       if ( $i == 'state' ) {
         echo $pre . $lang['BugState'];
         if ( $f == -2 ) {
           echo " ". $lang['BugAnyButClosed'];
         } else {
           echo " ". $lang['BugStates'][$f];
         }
       } else if ( $i == 'classes' ) {
         echo $pre . $lang['BugClass'];
         echo " ". $lang['BugClasses'][$f];
       } else if ( ($i == 'name') && ($f != "") ) {
         echo $pre . $lang['ProdDesc'];
         echo " ". $f;
       } else if ( $i == 'from' ) {
         echo $pre . $lang['DateTimeFrom'];
         echo " ". $f->getDateTime();
       } else if ( $i == 'to' ) {
         echo $pre . $lang['DateTimeTill'];
         echo " ". $f->getDateTime();
       } else if ( $i == 'parent' ) {
         $p = getObject($this->dbconn,$f);
         echo $pre . $lang[$p->getType()];
         echo " ". $p->getLink();
       } else if ( $f != "" ) {
         echo $pre . $i;
         echo " ". $f;
       }
       $pre = " and ";
     }

     echo " </td>\n";
     echo "</tr>\n";

     # Creation Times
     $c1 = new DateTime();
     $c2 = new DateTime();
     $t1 = new DateTime();
     $t2 = new DateTime();
     $c1->setDateTimeTS($cmin);
     $c2->setDateTimeTS($cmax);
     $t1->setDateTimeTS($tmin);
     $t2->setDateTimeTS($tmax);
     echo "<tr>\n";
     echo $this->showfield($lang['BugBetween']);
     echo " <td colspan=\"2\">". $c1->getDateTime() ."</td>\n";
     echo " <td colspan=\"2\">". $c2->getDateTime() ."</td>\n";
     echo "</tr>\n";

     # Average Times
     echo "<tr>\n";
     echo $this->showfield($lang['BugAverage']);
     echo " <td>". sprintf($lang['BugAvgEnd'],($ttl /$cnt)/3600) ."<br>\n";
     if ( $ns > 0 ) {
       echo sprintf($lang['BugAvgSolve'],($tts /$ns)/3600,$ns) ."<br>\n";
     }
     if ( $nc > 0 ) {
       echo " ". sprintf($lang['BugAvgClose'],($ttc /$nc)/3600,$nc) ."\n";
     }
     echo "</td></tr>\n";

     # State distribution
     $link = "graph_bars.php";
     $link = addSessionKey($link);
     $link = addUrlParameter($link,"type=pie");
     @reset($states);
     echo "<tr>\n";
     if ( !function_exists('ImageCreate') ) {
       echo " <td valign=\"top\" rowspan=\"". count($states) ."\"><b>". $lang['BugState'] ."</b></td>";
     } else {
       echo $this->showfield($lang['BugState']);
     }
     $c = 0;
     while ( list ($i,$f) = @each ($states) ) {
       $val = number_format($f * 100.0 / $cnt ,2);
       if ( !function_exists('ImageCreate') ) {
         echo " <td>". $lang['BugStates'][$i] ."</td>\n";
         echo " <td align=\"right\">". $f ."</td>\n";
         echo " <td align=\"right\">". $val ."%</td>\n";
         echo "</tr>\n";
       }
       $link = addUrlParameter($link,"f[". $c ."]=".$val);
       $link = addUrlParameter($link,"t0[". $c ."]=". UrlEncode($lang['BugStates'][$i]));
       $link = addUrlParameter($link,"t1[". $c ."]=". $f );
       $link = addUrlParameter($link,"col[". $c ."]=". UrlEncode($b->c_state[$i]));
       $c++;
     }
     if ( function_exists('ImageCreate') ) {
       echo " <td colspan=\"4\" valign=\"top\"><img src=\"". $link ."\"></td>";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo " <td>&nbsp;</td>\n";
     echo " <td colspan=\"4\">\n";
     echo " <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
     echo " <tr>\n";
     echo "  <th align=\"left\">". $t1->getDateTime() ."</th>\n";
     echo " </tr>\n";
     @reset($bl);
     $h = 10;
     $w = 400;
     $xx = ($tmax - $tmin) / $w;
     if ( $xx > 0 ) {
       while ( list ($i,$b) = @each ($bl) ) {
         $x1 = $b->creation->getTimeStamp();
         if ( ($b->state == 3) || ($b->state == 4) ) {
           $x2 = $b->solvedate->getTimeStamp();
         } else {
           $x2 = time();
         }
         if ( $x2 > $tmax ) {
           $x2 = $tmax;
         }
         $part1 = number_format(($x1 - $tmin) / $xx);
         $part2 = number_format(($x2 - $x1) / $xx);
         $part3 = number_format(($tmax - $x2) / $xx);

         if ( $part2 < 1 ) {
           $part2 = 1;
         }
         if ( ($part1 + $part2 + $part3) < ($w + 1) ) {
           $part3 = $w + 1 - $part2 - $part1;
         }

         echo " <tr>\n";
         echo "<td width=\"". ($w +1) ."\">";
         if ( $part1 > 0 ) {
           $text = "<img border=\"0\" src=\"". $tutos['base'] ."/html/white.png\" width=\"". $part1 ."\" height=\"". $h ."\">";
           echo makelink($b->getURL(),$text,sprintf($lang['BugShow'],$b->getFullName()) );
         }
         $text = "<img border=\"0\" src=\"". $tutos['base'] ."/html/". $b->c_state[$b->state] .".png\" width=\"". $part2 ."\" height=\"". $h ."\">";
         echo makelink($b->getURL(),$text,sprintf($lang['BugShow'],$b->getFullName()) );

         if ( $part3 > 0 ) {
           $text = "<img border=\"0\" src=\"". $tutos['base'] ."/html/white.png\" width=\"". $part3 ."\" height=\"". $h ."\">";
           echo makelink($b->getURL(),$text,sprintf($lang['BugShow'],$b->getFullName()) );
         }
         echo "</td>\n";
         echo " </tr>\n";
       }
     }
     echo " <tr>\n";
     echo "  <th align=\"right\">". $t2->getDateTime() ."</th>\n";
     echo " </tr>\n";
     echo " </table>\n";
     echo " </td>\n";
     echo "</tr>\n";

     # Class distribution
     $b = new bug($this->dbconn);
     $link = "graph_bars.php";
     $link = addSessionKey($link);
     $link = addUrlParameter($link,"type=pie");
     @reset($classes);
     echo "<tr>\n";
     if ( !function_exists('ImageCreate') ) {
       echo " <td valign=\"top\" rowspan=\"". count($classes) ."\"><b>". $lang['BugClass'] ."</b></td>";
     } else {
       echo $this->showfield($lang['BugClass']);
     }
     $c = 0;
     while ( list ($i,$f) = @each ($classes) ) {
       $val = number_format($f * 100.0 / $cnt ,2);
       if ( !function_exists('ImageCreate') ) {
         echo " <td>". $lang['BugClasses'][$i] ."</td>\n";
         echo " <td align=\"right\">". $f ."</td>\n";
         echo " <td align=\"right\">". $val ."%</td>\n";
         echo "</tr>\n";
       }
       $link = addUrlParameter($link,"f[". $c ."]=".$val);
       $link = addUrlParameter($link,"t0[". $c ."]=". UrlEncode($lang['BugClasses'][$i]));
       $link = addUrlParameter($link,"t1[". $c ."]=". $f );
       $link = addUrlParameter($link,"col[". $c ."]=". UrlEncode($b->c_class[$i]));
       $c++;
     }
     if ( function_exists('ImageCreate') ) {
       echo " <td colspan=\"5\" valign=\"top\"><img src=\"". $link ."\"></td>";
       echo "</tr>\n";
     }

     echo $this->DataTableEnd();
     $this->result->free();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * action via massupdate
    */
   Function action() {
     global $lang,$msg;

     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $b = new bug($this->dbconn);
         $b->read($val);
         if ( $b->id != $val ) {
           continue;
         }
         if ( $b->del_ok() ) {
           $msg .= sprintf($lang['BugDeleteI'], $b->getFullName()) ."<br>";
           $msg .= $b->delete();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0023'],$lang[$b->getType()]) ."<br>\n";
         }
         unset($b);
       }
       $this->dbconn->Commit("WORK");
     } else if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
     } else if ( ereg("^([SC])(.*)",$_GET['action'],$a) ) {
       # Setting State or Class

       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $b = new bug($this->dbconn);
         $b->read($val);
         if ( $b->id != $val ) {
           continue;
         }
         if ( $b->mod_ok() ) {
           if ( $a[1] == "S" ) {
             $msg .= $b->getLink() ." ". $lang['BugState'] ." = ". $lang['BugStates'][$a[2]] ."<br>";
             $msg .= $b->setState($a[2]);
           } else if ( $a[1] == "C" ) {
             $msg .= $b->getLink() ." ". $lang['BugClass'] ." = ". $lang['BugClasses'][$a[2]] ."<br>";
             $msg .= $b->setClass($a[2]);
           } else {
             $msg .= "A:".$_GET['action'] ." M: '". $val[1] ."'  V:". $val[2] ."<br>";
           }
           $msg .= $b->save();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0024'],$lang[$b->getType()])."<br>\n";
         }
         unset ($b);
       }
       $this->dbconn->Commit("WORK");
     }
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     if ( $this->format == "stat") {
       $this->name = $lang['BugStatsTitle'];
     } else {
       $this->name = $lang['BugsOverview'];
     }

     $this->link1 = "bug_overview.php";
     $this->filter = array();

     $this->link1 = addUrlParameter($this->link1,"format=".UrlEncode($this->format));

     if ( isset($_GET['id']) ) {
       $id = $_GET['id'];
     }
     if ( isset($_GET['pid']) ) {
       $pid = $_GET['pid'];
     }
     if ( isset($_GET['solverid']) ) {
       $solverid = $_GET['solverid'];
     }
     if ( isset($_GET['state']) ) {
       $state = $_GET['state'];
     } else {
       $state = "";
     }
     if ( isset($_GET['class']) ) {
       $class = $_GET['class'];
     } else {
       $class = "";
     }
     if ( isset($_GET['name']) ) {
       $name = $_GET['name'];
     } else {
       $name = "";
     }
     $this->filter['name'] = "";

     $q = "SELECT * FROM ". $this->dbconn->prefix ."bugs ";
     $pre = " WHERE ";

     if ( ($name != "*") && ($name != "") ) {
       $q .= " " . $pre ."(". $this->dbconn->Like("description",$name) ." OR ". $this->dbconn->Like("short",$name) ." OR ". $this->dbconn->Like("id",$name)." OR ". $this->dbconn->Like("name",$name) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=".UrlEncode($name));
       $this->addHidden("name",$name);
       $this->filter['name'] = $name;
     }

     if ( isset($id) ) {
       $q .= " ". $pre ." id = ".$id;
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"id=". $id);
       $this->addHidden("id",$id);
     }
     # States to display
     if ( $state == -2 )  {
       $q .= " ". $pre ." state != ". BUG_STATE_SOLVED;
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"state=". $state);
       # remember this
#       session_register('bugsearchstate');
       $_SESSION['bugsearchstate'] = $state;
       $this->filter['state'] = $state;
       $this->addHidden("state",$state);
     } else if ( $state > 0 )  {
       $q .= " ". $pre ." state=".$state;
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"state=". $state);
       # remember this
#       session_register('bugsearchstate');
       $_SESSION['bugsearchstate'] = $state;
       $this->filter['state'] = $state;
       $this->addHidden("state",$state);
     }
     # Classes to display
     if ( $class > 0 ) {
       $q .= " ". $pre ." class=". $class;
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"class=". $class);
       # remember this
#       session_register('bugsearchclass');
       $_SESSION['bugsearchclass'] = $class;
       $this->filter['classes'] = $class;
       $this->addHidden("class",$class);
     }
     # Parent to display
     if ( isset($pid) ) {
       $ref = getObject($this->dbconn,$pid);
       $this->name .= " : ".$ref->getFullName();
       $q .= $pre ." product_id in (". $pid;
       $sep = ",";
       if ( isset($_GET['show']) && ($_GET['show'] == "all") ) {
         $this->link1 = addUrlParameter($this->link1,"show=". $_GET['show']);
         $this->addHidden("show",$_GET['show']);
         add_task_ids($ref,$q,$sep);
         add_inst_ids($ref,$q,$sep);
       }
       $q .= ")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"pid=". $pid);
       $this->filter['parent'] = $pid;
       $this->addHidden("pid",$pid);
     }
     # Start Date for search
     $from = new DateTime(0);
     if ( isset($_GET['fd']) ) {
       $from->setDateTime($_GET['fd']);
     } else {
       $from->setDateTimeF("f");
       # remember this
#       session_register('bugsearchfrom');
       $_SESSION['bugsearchfrom'] = $from->getYYYYMMDD();
     }
     if ( $from->notime != 1 ) {
       $q .= $pre ."(creation >= ". $this->dbconn->Date($from) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"fd=".$from->getYYYYMMDD());
       $this->filter['from'] = $from;
       $this->addHidden("fd",$from->getYYYYMMDD());
     }
     # End Date for search
     $to = new DateTime(0);
     if ( isset($_GET['td']) ) {
       $to->setDateTime($_GET['td']);
     } else {
       $to->setDateTimeF("t");
       # remember this
#       session_register('bugsearchto');
       $_SESSION['bugsearchto'] = $to->getYYYYMMDD();
     }
     if ( $to->notime != 1 ) {
       $q .= $pre ."(creation <= ". $this->dbconn->Date($to) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"td=".$to->getYYYYMMDD());
       $this->filter['to'] = $to;
       $this->addHidden("td",$to->getYYYYMMDD());
     }

     # user to display
     if ( isset($solverid) ) {
       $q .= $pre ." solver = ". $solverid;
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"solverid=". $solverid);
       $this->filter['solver'] = $solverid;
       $this->addHidden("solverid",$solverid);
     }

     check_dbacl( $q, $this->user->id);

     # sorting
     $xxx = "";
     $this->link2 = $this->link1;
     order_parse($q,$this->link1,$xxx,$hidden,"state,creation");

     $this->result = $this->dbconn->Exec($q);
     if ( 0 == $this->result->numrows()) {
       $this->redirect = "bug_select.php?msg=". UrlEncode($lang['Err0048']);
       $this->result->free();
     } else if ( ($this->format == "html") && ($this->result->numrows() == 1) ) {
       $b = new bug($this->dbconn);
       $b->read_result($this->result,0);
       if ( $b->see_ok() ) {
         $this->redirect =  "bug_show.php?id=".$b->id;
         $this->result->free();
       }
     }

     # menu
     $x = bug::getSelectLink($this->user,$lang['Search']);
	 $x[category][] = "obj";
     $this->addmenu($x);

     if ( $this->user->feature_ok(usebugtracking,PERM_NEW) ) {
       $x = array( url => "bug_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['CreateNewBug'],
                   category => array("bug","new","obj")
                 );
       $this->addMenu($x);
     }

     if ( $this->format != "stat" ) {
       $l = addUrlParameter($this->link1,"format=paper");
       $x = array( url => $l,
                   image => $this->user->layout->theme->getImage(bug::getHtmlIcon(),'menu'),
                   text => $lang['Printable'],
                   info => $lang['PrintableInfo'],
                   category => array("view","bug")
                 );

       $this->addMenu($x);
       $l = addUrlParameter($this->link1,"format=stat");
       $x = array( url => $l,
                   image => $this->user->layout->theme->getImage(bug::getHtmlIcon(),'menu'),
                   text => $lang['BugStats'],
                   info => $lang['BugStatsInfo'],
                   category => array("view","bug")
                 );


       $this->addMenu($x);
     }

   }
 }

 $l = new bug_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: bug_overview.php,v 1.77.2.1 2003/07/14 17:48:48 gokohnert Exp $
    $Author: gokohnert $
-->