//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef DATASETTOOLS_H
#define DATASETTOOLS_H

#include <tulip/TulipPlugin.h>
#include <tulip/LayoutProperty.h>
#include <tulip/SizeProperty.h>
#include "Orientation.h"

void addOrientationParameters(tlp::LayoutAlgorithm* pLayout);
tlp::DataSet setOrientationParameters(int orientation);
void addOrthogonalParameters(tlp::LayoutAlgorithm* pLayout);
void addSpacingParameters(tlp::LayoutAlgorithm* pLayout);
void getSpacingParameters(tlp::DataSet* dataSet, float& nodeSpacing, float& layerSpacing);
void addNodeSizePropertyParameter(tlp::LayoutAlgorithm* pLayout);
bool getNodeSizePropertyParameter(tlp::DataSet* dataSet, tlp::SizeProperty *&sizes);
	
orientationType getMask(tlp::DataSet* dataSet);
bool hasOrthogonalEdge(tlp::DataSet* dataSet);


#endif
