/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of web browser Links 0.96

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

int session_id = 1;

struct session *create_session(struct window *win)
{
 /*   struct terminal *term = win->term;*/
    struct session *ses;
    struct subwin *sw;
    struct config_subwin *csw;
    int i;
    
/*    dbg("create_session()\n");*/
    if ((ses = mem_alloc(sizeof(struct session)))) {
    /*    dbg("create_session allocated %p\n", ses);*/
        memset(ses, 0, sizeof(struct session));
        ses->win = win;
        ses->id = session_id++;
        gses = ses;
        /**/
        /*memcpy(&ses->ds, &dds, sizeof(struct document_setup));*/

        ctest=NULL;
        
        ses->subwins = g_ptr_array_new();

        if (cfg->sws->len){
            for (i=0;i<cfg->sws->len;i++){
                csw=(struct config_subwin *)g_ptr_array_index(cfg->sws, i);
                switch(csw->type){
                    case SWT_QSOS:
                        sw = new_subwin(SWT_QSOS, VTEXT(T_SW_QSOS), NULL);
                        break;
                    case SWT_LOG:
                        sw = new_subwin(SWT_LOG,  VTEXT(T_SW_LOG),  NULL);
                        break;
                    case SWT_TALK:
                        sw = new_subwin(SWT_TALK, VTEXT(T_SW_TALK), NULL);
                        break;
                    case SWT_DXC:
                        sw = new_subwin(SWT_DXC,  VTEXT(T_SW_DXC),  NULL);
                        break;
                    case SWT_SKED:
                        sw = new_subwin(SWT_SKED, VTEXT(T_SW_SKED), NULL);
                        break;
                    case SWT_SWAP:
                        break;
                    case SWT_UNFI:
                        sw = new_subwin(SWT_UNFI, VTEXT(T_SW_UNFI), NULL);
                        break;
                    case SWT_STAT:
                        sw = new_subwin(SWT_STAT, VTEXT(T_SW_STAT), NULL);
                        break;
                    case SWT_PIPE:
                        sw = new_subwin(SWT_PIPE, VTEXT(T_SW_SHELL), sw_pipe_enter);
                        break;
                    case SWT_MAP:
                        sw = new_subwin(SWT_MAP,  VTEXT(T_SW_MAP), NULL);
                        break;
                        
                    default:
                        log_addf("invalid window type in tucnakrc (%d)\n", csw->type);
                        break;
                }
            }
        }else{
            /* default values when no subwins are defined in tucnakrc */
            sw = new_subwin(SWT_QSOS, VTEXT(T_SW_QSOS), NULL);
            sw = new_subwin(SWT_SKED, VTEXT(T_SW_SKED), NULL);
            sw = new_subwin(SWT_TALK, VTEXT(T_SW_TALK), NULL);
            sw = new_subwin(SWT_DXC,  VTEXT(T_SW_DXC),  NULL);
            sw = new_subwin(SWT_UNFI, VTEXT(T_SW_UNFI), NULL);
            sw = new_subwin(SWT_STAT, VTEXT(T_SW_STAT), NULL);
            sw = new_subwin(SWT_PIPE, VTEXT(T_SW_SHELL), sw_pipe_enter);
            sw = new_subwin(SWT_PIPE, VTEXT(T_SW_SHELL), sw_pipe_enter);
            sw = new_subwin(SWT_PIPE, VTEXT(T_SW_SHELL), sw_pipe_enter);
            sw = new_subwin(SWT_LOG,  VTEXT(T_SW_LOG),  NULL);

        }
        
        sw_set_ontop(0);
        
        
    }
    /*if (first_use) {
        first_use = 0;
        msg_box(NULL, VTEXT(T_WELCOME), AL_CENTER | AL_EXTD_TEXT, VTEXT(T_WELCOME_TO_TUCNAK), "\n\n", VTEXT(T_BASIC_HELP), NULL, NULL, 1, VTEXT(T_OK), NULL, B_ENTER | B_ESC);
    }*/
    if (strlen(cfg->pcall)==0 || strlen(cfg->pwwlo)==0){
        register_bottom_half(contest_def, CBA0);
        first_contest_def=1;
    }

    ses->il = g_new0(struct inputln,1);
    ses->il->upconvert=1;
    gses->qs = g_ptr_array_new();
    gses->qs_mutex = g_mutex_new();
    gses->hicalls=g_hash_table_new(g_str_hash, g_str_equal);    
    
    return ses;
}


void win_func(struct window *win, struct event *ev, int fw)
{
/*    if (ev->ev==EV_KBD) dbg("\n");*/
/****   dbg("win_func [%d,%d,%d,%d]\n",ev->ev,ev->x,ev->y,ev->b);*/
    switch (ev->ev) {
        case EV_ABORT:
            sw_all_func(ev,fw);
            free_ctest();
            if (gses->timer_id) kill_timer(gses->timer_id);
            free_subwins();
            inputln_func(gses->il, ev);
            g_free(gses->il);
            qs_thread_kill();
            g_ptr_array_free_all(gses->qs);
            g_mutex_free(gses->qs_mutex);
            CONDGFREE(gses->qs_str);
            free_hash(gses->hicalls);

            /*mem_free(gses); no, freeed in delete_window */
            gses=NULL;
            break;
        case EV_INIT:
            gses = win->data = create_session(win);
            
            if (ctest && aband) inputln_func(aband->il,ev);
            else inputln_func(gses->il, ev);
            il_set_focus(INPUTLN(aband));
            gses->timer_id = install_timer(1, time_func, CBA0);
            gses->mode = MOD_SSB_SSB;
            
        case EV_RESIZE:
     /*       dbg("win_func: EV_RESIZE %dx%d\n", term->x, term->y);*/
            fifo_resize(glog, 1, term->y-cfg->loglines, term->x-2, cfg->loglines);
       /*     draw_root_window();*/
            if (ctest) {
                int i;
                for (i=0;i<ctest->bands->len;i++) {
                    struct band *b;
                    b=(struct band*)g_ptr_array_index(ctest->bands,i);
                    inputln_func(b->il,ev);
                    /*b->il->band=b;*/
                }
            }
            inputln_func(gses->il, ev);
            sw_all_func(ev, fw);
            redraw_later();
            break;
        case EV_REDRAW:
            if (!gses) return;
/*            dbg("win_func: EV_REDRAW\n");*/
            draw_root_window();
            inputln_func(INPUTLN(aband),ev);
            if (show_qs()){
                sw_qs_redraw();
            }else{
                sw_ontop_func(ev, fw);
            }
            
            /*if (ctest && aband) {
                inputln_func(aband->il,ev);
                if (show_qs()){
                    sw_qs_redraw();
                }else{
                    sw_ontop_func(ev, fw);
                }
            }else{
                inputln_func(gses->il, ev);
                sw_ontop_func(ev, fw);
            } */
            draw_titles(COL_INV, COL_NORM); 
            break;
        case EV_KBD:
            send_event(ev);
            break;
        case EV_MOUSE:

            
            send_event(ev);
            break;
        default:
            error("ERROR: unknown event");
    }
}


void rxtx(void){
    if (gses->win->prev->handler==cwwindow_func) return;
    gses->tx=!gses->tx;
    if (gses->tx && can_tx(aband)){
        cq_abort(1);
        if (get_mode() == MOD_SSB_SSB){
            cwdaemon_ptt(cwda, 1);
        }
        if (get_mode() == MOD_CW_CW){
            add_window(cwwindow_func, NULL);
        }
        peer_tx(aband, 1);
    }else{
        rx();
    }
    redraw_later();
}   

void esc(void){
    /*if (!ctest || !aband) return;*/
    if (gses->focused){ /* look at sw_dxc_kbd_func, ACT_ENTER */
        sw_unset_focus();
        il_set_focus(INPUTLN(aband));
    }else{
        rx();
    }
    
    redraw_later();
}


void rx(void){
    gses->tx=0;
    gses->tune=0;
    cq_abort(0);
    cwdaemon_ptt(cwda, 0);
    peer_tx(aband, 0);
}

    /* for global events such as keying */
int preferred_func(struct event *ev){

    switch (kbd_action(KM_MAIN, ev)) {
        case ACT_RXTX:
            rxtx();
            return 0;
            break;    
#ifdef HAVE_SDL            
        case ACT_SCREENSHOT:
            sdl_screenshot(0);
            break;
            
        case ACT_WINDOWSHOT:
            sdl_screenshot(1);
            break;
#endif
            
    }
    return 1;
}

gpointer delay_func(gpointer data){
    sleep(2);
    return NULL;
}

    
void send_event(struct event *ev)
{
    struct qso *qso;
    gchar *c;
    gchar *qrv_str;

    /*dbg("send_event ev=%d, x=%d, y=%d, b=%d\n",ev->ev,ev->x,ev->y ,ev->b);*/
    if (ev->ev == EV_KBD) {
        
        if (gses->ontop && gses->focused){
            if (sw_focus_func(ev,1)) return;
        }else{
            switch (kbd_action(KM_MAIN, ev)) {
                case ACT_SCROLL_LEFT:
                    if (glog->ho>0) glog->ho--;
                    redraw_later();
                    goto x;
                case ACT_SCROLL_RIGHT:
                    if (glog->ho<70) glog->ho++;
                    redraw_later();
                    goto x;
                default:
                    if (!inputln_func(INPUTLN(aband), ev)) break;
                    /*dbg("inputln_func\n");*/
                    if (ev->x!=KBD_LEFT &&
                        ev->x!=KBD_RIGHT &&
                        ev->x!=KBD_HOME &&
                        ev->x!=KBD_END){    

                        char *qsstr;
                        if (aband){
                            qsstr=rindex(aband->il->cdata, ' ');
                            if (!qsstr) qsstr=aband->il->cdata;
                            else qsstr++;
                        }else{
                            qsstr=rindex(gses->il->cdata, ' ');
                            if (!qsstr) qsstr=gses->il->cdata;
                            else qsstr++;
                        }
                        
                        if (aband){
                            get_band_qs(aband, qsstr);
                            get_oband_qs(aband, qsstr);
                        }
                        get_cw_qs(qsstr);
                        send_inputline(aband);
                        
                        redraw_later();
                    }
                    return;
                
            }
        }
/*    dbg("send_event2 %d,%d,%d,%d\n",ev->ev,ev->x,ev->y ,ev->b);*/
        
        switch (kbd_action(KM_MAIN, ev)) {
            case ACT_MENU:
                activate_bfu_technology(-1);
                goto x;
            case ACT_FILE_MENU:
                activate_bfu_technology(0);
                goto x;
            case ACT_REALLYQUIT:
                exit_prog((union cba_t)1);
                goto x;
            case ACT_QUIT:
                exit_prog((union cba_t)(ev->x == KBD_CTRL_C));
                goto x;
            case ACT_NEXT_SUBWIN:
 /*               dbg("send_event: next subwin\n");*/
                sw_totop_next(1);
                if (gses->focused){
                    sw_set_focus();
                    il_unset_focus(INPUTLN(aband));
                }else{
                    sw_unset_focus();
                    il_set_focus(INPUTLN(aband));
                }
                redraw_later();
                goto x;    
            case ACT_PREV_SUBWIN:
 /*               dbg("send_event: next subwin\n");*/
                sw_totop_next(-1);
                if (gses->focused){
                    sw_set_focus();
                    il_unset_focus(INPUTLN(aband));
                }else{
                    sw_unset_focus();
                    il_set_focus(INPUTLN(aband));
                }
                redraw_later();
                goto x;    
            case ACT_UP:
/*                dbg("send_event: focus\n");*/
/*                if (!ctest || !aband) goto x; */
                if (gses->ontop->type!=SWT_QSOS || (aband && aband->qsos->len)){
                    /*dbg("focusing...\n"); */
                    il_unset_focus(INPUTLN(aband));
                    sw_set_focus();
                    redraw_later();
                }
                goto x;

            case ACT_ESC:
            case ACT_RX:
                /*dbg("send_event: esc\n");*/
                esc();
                goto x;    
                
            case ACT_RXTX:
                preferred_func(ev);
                break;    
                
            case ACT_MODE:
                gses->tx = 0;
                /*cwdaemon_abort(cwda);*/
                cq_abort(0);
                peer_tx(aband, 0);
                if (get_mode() == MOD_CW_CW) {
                    set_mode(MOD_SSB_SSB);
                    default_rst_to_tmpqsos(aband);
                    redraw_later();
                    break;
                }
                if (get_mode() == MOD_SSB_SSB){
                    set_mode(MOD_CW_CW);
                    default_rst_to_tmpqsos(aband);
                    redraw_later();
                    break;
                }
            case ACT_CQ_0:
                if (can_cq(aband)) cq_run_by_number(0);
                break;
            case ACT_CQ_1:
                if (can_cq(aband)) cq_run_by_number(1);
                break;
            case ACT_CQ_2:
                if (can_cq(aband)) cq_run_by_number(2);
                break;
            case ACT_CQ_3:
                if (can_cq(aband)) cq_run_by_number(3);
                break;
            case ACT_CQ_4:
                if (can_cq(aband)) cq_run_by_number(4);
                break;
            case ACT_CQ_5:
                if (can_cq(aband)) cq_run_by_number(5);
                break;
            case ACT_PAGE_UP:
                cwdaemon_qrq(cwda, 2);
                redraw_later();
                break;
            case ACT_PAGE_DOWN:
                cwdaemon_qrs(cwda, 2);
                redraw_later();
                break;  

            case ACT_CLEAR_TMPQSOS:
/*                dbg("clear_tmpqsos\n");*/
                if (!ctest || !aband) goto x;
                clear_tmpqsos(aband);
                add_swap(aband, "CLR");
                map_clear_qso(&aband->tmplocqso);
                redraw_later();
                goto x;
                
            case ACT_CLEAR_TMPQSOS_INPUTLINE:
                /*dbg("clear_tmpqsos_inputline\n");*/
                if (!ctest || !aband) {  /* HACK F3 */
                    menu_contest_open((union cba_t)NULL);
                    goto x;
                }
                clear_tmpqsos(aband);
                add_swap(aband, "CLR");
                clear_inputline(aband->il);
                get_cw_qs(aband->il->cdata); /* clears */ 
                get_band_qs(aband, aband->il->cdata);
                get_oband_qs(aband, aband->il->cdata);
                send_inputline(aband);
                map_clear_qso(&aband->tmplocqso);
                redraw_later();
                goto x;
                
            case ACT_CONFIRM_CALL:
                if (!ctest || !aband) goto x;
                c = TMPQ.callsign;
                if (!c) goto x;
                if (TMPQ.ucallsign) goto x;
    
                CONDGFREE(aband->qrv_str);
                qrv_str=find_qrv_str_by_call(cw, uc(c));
                if (qrv_str){
                    aband->qrv_str = g_strdup(qrv_str);
                }
                
                qso = get_qso_by_callsign(aband, c);
                if (qso){
                    aband->dupe_in_tmpqso = atoi(qso->qsonrs);
                    redraw_terminal(CBA0);
                    duplicate_callsign(qso);
                    goto x;
                }
                add_tmpxchg(aband, aband->tmpqsos[0].callsign);
                aband->tmpqsos[0].ucallsign = 1;
                CLEAR_TMPQSO_STRING_UU(aband, callsign, ucallsign);
                wkd_tmpqso(aband, WT_CALLSIGN, c);
                redraw_later();
                
                break;
            case ACT_CONFIRM_WWL:
                if (!ctest || !aband) goto x;
                if (!aband->tmpqsos[0].locator) break;
                if (strlen(aband->tmpqsos[0].locator)!=6) break;

                add_tmpxchg(aband, aband->tmpqsos[0].locator);
                
                aband->tmpqsos[0].ulocator = 1;
                aband->tmpqsos[0].uqrb = 1;
                aband->tmpqsos[0].uqtf = 1;
                CLEAR_TMPQSO_STRING_UU(aband, locator, ulocator);
                CLEAR_TMPQSO_GDOUBLE_UU  (aband, qrb, uqrb);
                CLEAR_TMPQSO_QTF_UU   (aband);
                wkd_tmpqso(aband, WT_LOCATOR, TMPQ.locator);
                /*map_clear_qso(&aband->tmplocqso); */
                redraw_later();
                break;
            case ACT_SWAP_CALL:
                if (!ctest || !aband) goto x;
                if (aband->tmpqsos[0].callsign && aband->tmpqsos[1].callsign){
                    int susp;
                    gchar *c;

                    c = aband->tmpqsos[0].callsign;
                    aband->tmpqsos[0].callsign = aband->tmpqsos[1].callsign;
                    aband->tmpqsos[1].callsign = c;
                    add_tmpxchg(aband, aband->tmpqsos[0].callsign);
                    if ((susp=get_susp_call(cw, dw, aband->tmpqsos[0].callsign, aband->tmpqsos[0].locator))!=0){
                        aband->tmpqsos[0].suspcallsign = susp;
                    }else{
                        aband->tmpqsos[0].suspcallsign = 0;
                        aband->tmpqsos[0].susplocator = 0;
                    }
                    wkd_tmpqso(aband, WT_CALLSIGN, TMPQ.callsign);
                    redraw_later();
                }
                break;
                
            case ACT_SWAP_WWL:
                if (!ctest || !aband) goto x;
                if (aband->tmpqsos[0].locator && aband->tmpqsos[1].locator){
                    int susp;
                    gchar *c;
                    gdouble qrb;
                    gint qtf;

                    map_clear_qso(&aband->tmplocqso);
                    c = aband->tmpqsos[0].locator;
                    aband->tmpqsos[0].locator = aband->tmpqsos[1].locator;
                    aband->tmpqsos[1].locator = c;
                    add_tmpxchg(aband, aband->tmpqsos[0].locator);

                    qrb = aband->tmpqsos[0].qrb;
                    aband->tmpqsos[0].qrb = aband->tmpqsos[1].qrb;
                    aband->tmpqsos[1].qrb = qrb;

                    qtf = aband->tmpqsos[0].qtf;
                    aband->tmpqsos[0].qtf = aband->tmpqsos[1].qtf;
                    aband->tmpqsos[1].qtf = qtf;
                    if ((susp=get_susp(cw, dw, aband->tmpqsos[0].callsign, aband->tmpqsos[0].locator, 1))!=0){
                        aband->tmpqsos[0].susplocator = susp & 0xff;
                        aband->tmpqsos[0].suspcallsign = susp >> 8;
                    }else{
                        aband->tmpqsos[0].susplocator = 0;
                        aband->tmpqsos[0].suspcallsign = 0;
                    }

                    wkd_tmpqso(aband, WT_LOCATOR, TMPQ.locator);
                    
                    CONDGFREE(aband->tmplocqso.locator);
                    aband->tmplocqso.locator=g_strdup(TMPQ.locator);
                    compute_qrbqtf(&aband->tmplocqso);
                    map_add_qso(&aband->tmplocqso);
                    redraw_later();
                }
                break;    
            case ACT_SAVE_ALL:
                save_all_bands_txt(0);
                break;
            case ACT_CHOP:
                if (!ctest) break;
                menu_chop(CBA0);
                break;
            case ACT_CALLINFO:
                call_info(CBA0);
                break;
            case ACT_SKED:
                if (!ctest || !aband) break;
                if ((!TMPQ.callsign || !strlen(TMPQ.callsign)) && aband->qsos->len>0){
                    sked_from_qso((struct qso *)g_ptr_array_index(aband->qsos, aband->qsos->len-1));
                }else{
                    sked_from_tmpqso(&(aband->tmpqsos[0]));
                }
                break;
            case ACT_SKED_QRG:
                if (!ctest) break;
                menu_skedqrg(CBA0);
                break;
            case ACT_UNFINISHED:

                if (!ctest || !aband) break;
                if (!TMPQ.callsign && !TMPQ.locator) break;
             
                menu_unfinished(CBA0);
                goto x;
            case ACT_PLAY_LAST:
                ssbd_play_last_sample(ssbd);
                break;
            case ACT_SEEK_A:
                if (!ctest || !aband) goto x;
                if (TMPQ.locator)
                    rot_seek(get_rotar(0), TMPQ.qtf);
                break;
                
            case ACT_SEEK_B:
                if (!ctest || !aband) goto x;
                if (TMPQ.locator)
                    rot_seek(get_rotar(0), TMPQ.qtf);
                break;

            case ACT_GRAB_BAND:
                menu_grabband(CBA0);
                break;

            case ACT_ROTAR:
                menu_rotar(CBA0);
                break;

            case ACT_TUNE:
                if (get_mode() != MOD_CW_CW) break;
                gses->tune++;
                if (gses->tune == 3) gses->tune = 0;
                cwdaemon_tune(cwda, gses->tune);
                break; 
                
            default:
                /*if (ev->x == KBD_CTRL_C) goto quit;*/
                if (ev->y & KBD_ALT) {
                    struct window *m;

                    if (ev->x>='0' && ev->x<='9'){
                        int a = ev->x - '0';
                        
                        if (a==0) a=10;
                        if (sw_set_ontop(a-1)){
                            if (!gses->focused ||
                                (gses->ontop && gses->ontop->type == SWT_QSOS)){
                                sw_unset_focus();
                                il_set_focus(INPUTLN(aband));
                            }else{
                                sw_set_focus();
                                il_unset_focus(INPUTLN(aband));
                            }
                            redraw_later();
                        }
                        goto x;                       
                    }
#if 1                    
                    if (ctest && upcase(ev->x)=='L'){
/*                        printf("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n");
                        g_thread_create(delay_func, NULL, TRUE, NULL);  */
                        log_adds("---dump request---");
                        dbg_qsos("---dump request---");
                        dump_all_sources(ctest);
                    }
#endif                            

                    
                    ev->y &= ~KBD_ALT;
                    activate_bfu_technology(-1);
                    m = term->windows.next;
                    m->handler(m, ev, 0);
                    if (term->windows.next == m) {
                        delete_window(m);
                    } else goto x;
                
                    ev->y &= ~KBD_ALT;
                }

                if (ev->y & KBD_CTRL){
                    char bandchar;
                    struct band *b;
                    
                    if (ev->x>='0' && ev->x<='9'){
                        int a = ev->x - '0';
                        
                       /* if (a==0) a=10; Ctrl+0 means subwin 10  */ 
                        a+=10;
                        if (sw_set_ontop(a-1)){
                            if (!gses->focused ||
                                (gses->ontop && gses->ontop->type == SWT_QSOS)){
                                sw_unset_focus();
                                il_set_focus(INPUTLN(aband));
                            }else{
                                sw_set_focus();
                                il_unset_focus(INPUTLN(aband));
                            }
                            redraw_later();
                        }
                        goto x;                       
                    }

                    if (!ctest || !aband) goto x;
                    bandchar=lowcase((char)ev->x);
                    b=find_band_by_bandchar(bandchar);
                    activate_band(b);
                    break;
                }
            

        }
    }
   if (ev->ev == EV_MOUSE) {
        int y;
/*        dbg("mouse event x=%d y=%d b=%d\n", ev->x, ev->y, ev->b); */
        /* menu */
        if (ev->y == 0 && (ev->b & BM_ACT) == B_DOWN) {
            struct window *m;
            activate_bfu_technology(-1);
            m = term->windows.next;
            m->handler(m, ev, 0);
            goto x;
        }
        
        /* input line */
        y = term->y - 1 - cfg->loglines;
        if (ctest && aband) y -= aband->spypeers->len;
        if (ev->y==y){    
            sw_unset_focus();
            il_set_focus(INPUTLN(aband));
            inputln_func(INPUTLN(aband), ev);
            redraw_later();
        }
    
        /* subwin tabs */
        if (ev->y==gses->ontop->y-1 && (ev->b & BM_ACT) == B_DOWN){

            int i;
            struct subwin *sw;
            for (i=0; i<gses->subwins->len; i++){
                sw = g_ptr_array_index( gses->subwins, i);
                if (ev->x >= sw->titl1 && ev->x <= sw->titl2){
                    sw_set_ontop(i);
                    redraw_later();
                    break;
                }
            }
        }
            
        /* subwin */
        if (ev->y >= gses->ontop->y && 
            ev->y < gses->ontop->y+gses->ontop->hh){
            
            sw_default_func(gses->ontop,ev,1);
        }
    }
    x:;
    return;
}

void draw_root_window(){
    gchar *c;                       
    int i,a;
    char dtime[6];
    char s[100];
    int spypeers=0;
    struct rotar *rot;
    char degree;

    degree=' ';
#ifdef HAVE_SDL    
    if (sdl) degree='';
#endif
    
   /* dbg("draw_root_window\n");*/

    fill_area(0,0,term->x,term->y,COL_BG);
    if (ctest && ctest->tname && *ctest->tname){
        char s[256];
        strcpy(s,"  Tucnak "VERSION_STRING);
        print_text(1,0,-1,ctest->tname,COL_NORM);
        print_text(term->x-QSONR_WIDTH-strlen(s)-2,0,-1,s,COL_NORM);
    }else{
        print_text(0,0,-1," The ultimate contestlog - necessary as known  ver. "VERSION,COL_NORM);
    }

    log_draw(glog);
    if (ctest) spypeers=aband->spypeers->len;

    draw_frame(0,ORIG_Y,term->x-QSONR_WIDTH-BAND_WIDTH,3,COL_NORM,1);
    draw_frame(0,ORIG_Y+2,term->x-QSONR_WIDTH-BAND_WIDTH,4,COL_NORM,1);
    draw_frame(term->x-QSONR_WIDTH-BAND_WIDTH-1,ORIG_Y,BAND_WIDTH+1,QSONR_HEIGHT-1,COL_NORM,1);
    draw_frame(term->x-QSONR_WIDTH-1,0,QSONR_WIDTH+1,QSONR_HEIGHT,COL_NORM,1);
    
    draw_frame(0,QSONR_HEIGHT-1,term->x,term->y-QSONR_HEIGHT-2-cfg->loglines-spypeers,COL_NORM,1);
    
    set_only_char(term->x-QSONR_WIDTH-BAND_WIDTH-1,ORIG_Y,FRAME_RDL);
    set_only_char(term->x-QSONR_WIDTH-1,ORIG_Y,FRAME_UDL);
    set_only_char(0,ORIG_Y+2,FRAME_URD);
    set_only_char(term->x-QSONR_WIDTH-BAND_WIDTH-1,ORIG_Y+2,FRAME_UDL);
    set_only_char(0,QSONR_HEIGHT-1,FRAME_URD);
    set_only_char(term->x-QSONR_WIDTH-1,QSONR_HEIGHT-1,FRAME_URL);
    set_only_char(term->x-QSONR_WIDTH-BAND_WIDTH-1,QSONR_HEIGHT-1,FRAME_URL);
    set_only_char(term->x-1,QSONR_HEIGHT-1,FRAME_UDL);


    print_text(11,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1,VTEXT(T_SES_QTR),COL_NORM);
    print_text(19,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1,VTEXT(T_SES_QRA),COL_NORM);
    print_text(31,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1,VTEXT(T_SES_RST),COL_NORM);
    if (ctest && ctest->excused) print_text(49,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1,VTEXT(T_SES_EXC),COL_NORM);
    if (ctest && ctest->wwlused) print_text(54,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1,VTEXT(T_SES_QTH),COL_NORM);
    print_text(62,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1,VTEXT(T_SES_QRB),COL_NORM);
    print_text(74,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1,VTEXT(T_SES_FLG),COL_NORM);
    print_text(80,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1,VTEXT(T_SES_OPE),COL_NORM);
    print_text(88,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1,VTEXT(T_SES_REM),COL_NORM);

    if (can_cq(aband)){
        if (gses && gses->last_cq && gses->last_cq->type!=MOD_NONE){
            if (gses->last_cq->type==MOD_CW_CW)
                sprintf(s, " CW%d", gses->last_cq->nr);
            else
                sprintf(s, "SSB%d", gses->last_cq->nr);
        }else{    
            if (gses->tx)
                strcpy(s, "  TX");
            else
                strcpy(s, "  rx");
        }
    }else{
        strcpy(s, "LOCK");
    }
    print_text(15,term->y-1-cfg->loglines-spypeers,-1,s,COL_NORM);
        
    if (cwda){
        c = g_strdup_printf(VTEXT(T_SES_WPM), cwda->speed);
        print_text(term->x-QSONR_WIDTH-BAND_WIDTH,ORIG_Y+2,BAND_WIDTH-1, c, COL_NORM); 
        g_free(c);
    }

    rot=get_rotar(0);
    if (rot){
        sprintf(s,"RotA: %3d%c%+d%c",rot->qtf, degree, rot->elev, degree); 
        print_text(term->x-QSONR_WIDTH-BAND_WIDTH,ORIG_Y+3,BAND_WIDTH-1, s, COL_NORM); 
    }
    rot=get_rotar(1);
    if (rot){
        sprintf(s,"RotB: %3d%c%+d%c",rot->qtf, degree, rot->elev, degree); 
        print_text(term->x-QSONR_WIDTH-BAND_WIDTH,ORIG_Y+4,BAND_WIDTH-1, s, COL_NORM); 
    }
    

    if (aband){

        if (aband->ctrlstate==CTRL_REQR){
            print_text(19,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1," QSO request from S&P  ",COL_INV);
        }
        if (aband->ctrlstate==CTRL_REQS){
            print_text(19,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1," QSO request sent to RUN  ",COL_INV);
        }
        if (aband->ctrlstate==CTRL_RUNING){
            print_text(19,term->y-ORIG_Y-2-cfg->loglines-spypeers-1,-1," GO!  ",COL_INV);
        }
    
        g_snprintf(s, 98, " %s %s (%s) ", ctest->pcall, ctest->pwwlo, aband->operator);
        uc(s);
        print_text(4,ORIG_Y,97,s,COL_NORM);
        
        draw_bigdigit(term->x-20+2,1,aband->qsos->len+1);
        redraw_stats(aband);

        c=g_strconcat(aband->pband,":", NULL);
        print_text(14-strlen(c),term->y-1-cfg->loglines-spypeers,-1,c,COL_NORM);
        g_free(c);
        
        

        for (i=0;i<spypeers;i++){
            struct spypeer *sp;
            sp=(struct spypeer *)g_ptr_array_index(aband->spypeers, i);

            c=sp->operator;
            if (c) print_text(1,term->y-cfg->loglines-spypeers+i,-1,c,COL_NORM);
            
            strcpy(s,"");
            if (sp->peertx==0) strcpy(s, "rx");
            if (sp->peertx==1) strcpy(s, "tx");
            if (sp->peertx==2) strcpy(s, "cq");
            print_text(15,term->y-cfg->loglines-spypeers+i,-1,s,COL_NORM);

            c=sp->callsign;
            if (c)  print_text(18,term->y-cfg->loglines-spypeers+i,-1,c,COL_NORM);
            c=sp->rsts;
            if (c) print_text(36-strlen(c),term->y-cfg->loglines-spypeers+i,-1,c,COL_NORM);
            c=sp->qsonrs;
            if (c) print_text(40-strlen(c),term->y-cfg->loglines-spypeers+i,-1,c,COL_NORM);
            c=sp->rstr;
            if (c) print_text(45-strlen(c),term->y-cfg->loglines-spypeers+i,-1,c,COL_NORM);
            c=sp->qsonrr;
            if (c) print_text(49-strlen(c),term->y-cfg->loglines-spypeers+i,-1,c,COL_NORM);
            c=sp->exc;
            if (c) print_text(50-strlen(c),term->y-cfg->loglines-spypeers+i,-1,c,COL_NORM);
            c=sp->locator;
            if (c) print_text(55,term->y-cfg->loglines-spypeers+i,-1,c,COL_NORM);
            c=sp->inputline;
            if (c) print_text(62,term->y-cfg->loglines-spypeers+i,-1,c,COL_NORM);
            
        }
        

        for (i=0;i<DISP_QSOS; i++){
            if (i==0 && aband->dupe_in_tmpqso!=0){
                struct qso *q;
                q=get_qso(aband, aband->dupe_in_tmpqso-1);
                
                print_text(3,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,q->date_str,COL_INV);
                dtime[0]=q->time_str[0]; dtime[1]=q->time_str[1]; dtime[2]='.';
                dtime[3]=q->time_str[2]; dtime[4]=q->time_str[3]; dtime[5]='\0';
                print_text(17-strlen(dtime),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,dtime,COL_INV);
                print_text(18,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,q->callsign,COL_INV);
                print_text(36-strlen(q->rsts),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,q->rsts,COL_INV);
                print_text(40-strlen(q->qsonrs),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,q->qsonrs,COL_INV);
                print_text(45-strlen(q->rstr),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,q->rstr,COL_INV);
                print_text(49-strlen(q->qsonrr),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,q->qsonrr,COL_INV);
                print_text(55,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,q->locator,COL_INV);
                print_text(50,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,q->exc,COL_INV);
                if ((int)q->qrb<100000)
                    c=g_strdup_printf("%dkm",(int)q->qrb);
                else
                    c=g_strdup_printf("%d",(int)q->qrb);
                print_text(70-strlen(c),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_INV);
                g_free(c);
                if (q->qtf>=0) {
                    c=g_strdup_printf("%d%c",q->qtf, degree);
                    print_text(75-strlen(c),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_INV);
                    g_free(c);
                    /*c=g_strdup_printf("(%d)",((int)q->qtf+180)%360);
                    print_text(75,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_INV);
                    g_free(c); */
                }
                print_text(81,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,q->operator,COL_INV);
                print_text(89,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,q->remark,COL_INV);
                
                continue; /* don't draw normal QSO in line 0 */
            }

            c=aband->tmpqsos[i].date_str;
            if (c) print_text(3,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_NORM);
               
            c=aband->tmpqsos[i].time_str;
            if (c) {
                dtime[0]=c[0]; dtime[1]=c[1]; dtime[2]='.';
                dtime[3]=c[2]; dtime[4]=c[3]; dtime[5]='\0';
                print_text(17-strlen(dtime),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,dtime,COL_NORM);
            }
            
            
            c=aband->tmpqsos[i].callsign;
            if (c) {
                char *susp_c/*,*unkcall*/;
               
               /* if (aband->tmpqsos[i].unkcall) unkcall="n";
                else unkcall=" ";
                print_text(16,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,
                    unkcall, COL_NORM);  */
                
                switch (aband->tmpqsos[i].suspcallsign){
                    case 1:
                        susp_c="?";
                        break;
                    case 2:
                        susp_c="!";
                        break;    
                    default:
                        susp_c=" ";
                        break;
                }
                print_text(17,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,
                    susp_c, COL_NORM);
                print_text(18,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,
                    aband->tmpqsos[i].ucallsign?COL_NORM:COL_INV);
                if (aband->tmpqsos[i].unkcall){
                        int x;
                        x=18+1+strlen(c);
                        print_text(x, term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,32-x,
                                VTEXT(T_NEW_CALL), 
                                aband->tmpqsos[i].ucallsign?COL_NORM:COL_INV);
                }else{
                    if (aband->tmpqsos[i].name){
                        int x;
                        x=18+1+strlen(c);
                        print_text(x, term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,32-x,
                                aband->tmpqsos[i].name, 
                                aband->tmpqsos[i].ucallsign?COL_NORM:COL_INV);
                    }
                }
            }
               
            c=aband->tmpqsos[i].rsts;
            if (c) print_text(36-strlen(c),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_NORM);
               
            c=aband->tmpqsos[i].qsonrs;
            if (c) print_text(40-strlen(c),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_NORM);
               
            c=aband->tmpqsos[i].rstr;
            if (c) print_text(45-strlen(c),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_NORM);
            
            c=aband->tmpqsos[i].qsonrr;
            if (c) print_text(49-strlen(c),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_NORM);
            
            c=aband->tmpqsos[i].exc;
            if (c) print_text(50,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_NORM);

            c=aband->tmpqsos[i].locator;
            if (c) {
                char *susp_c;
                switch (aband->tmpqsos[i].susplocator){
                    case 1:
                        susp_c="?";
                        break;
                    case 2:
                        susp_c="!";
                        break;    
                    default:
                        susp_c=" ";
                        break;
                }
                print_text(55,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,
                    aband->tmpqsos[i].ulocator?COL_NORM:COL_INV);
                
                print_text(62,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,
                    susp_c, COL_NORM);
            }
            
            a=(int)aband->tmpqsos[i].qrb;
            if (a) {
                if (a<100000)
                    c=g_strdup_printf("%dkm",a);
                else
                    c=g_strdup_printf("%d",a);
                print_text(70-strlen(c),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,
                    aband->tmpqsos[i].uqrb?COL_NORM:COL_INV);
                g_free(c);
            }

            a=aband->tmpqsos[i].qtf;
            if (a>=0) {
                c=g_strdup_printf("%d%c",a, degree);
                print_text(75-strlen(c),term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,
                    aband->tmpqsos[i].uqtf?COL_NORM:COL_INV);
                g_free(c);
               /* c=g_strdup_printf("(%d)",(a+180)%360);
                print_text(75,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,
                    aband->tmpqsos[i].uqtf?COL_NORM:COL_INV);
                g_free(c); */
            }
            if (i==0 && aband->tmpqsos[0].qsl){
                print_text(79,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,"q",COL_NORM);
            }
            c=aband->operator;
            if (i==0 && c) print_text(81,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_NORM);
            c=aband->tmpqsos[i].remark;
            if (c) print_text(89,term->y-cfg->loglines-spypeers-DISP_QSOS+i-1,-1,c,COL_NORM);
        }
        
        if (aband->unres) {
            int x;
            const int QRA_X=17;

            c=aband->unres;
            x=QRA_X-strlen(c);
            if (x<0) x=0;
            fill_area(0,term->y-2-cfg->loglines-spypeers, QRA_X,1,COL_BG);
            print_text(x,term->y-2-cfg->loglines-spypeers, QRA_X, c,COL_INV);
        }else{
            if (aband->qrv_str){
                int x;
                const int QRA_X=17;

                c=g_strdup_printf(VTEXT(T_QRV_ON_S), aband->qrv_str);
                x=QRA_X-strlen(c);
                if (x<0) x=0;
                fill_area(0,term->y-2-cfg->loglines-spypeers, QRA_X,1,COL_BG);
                print_text(x,term->y-2-cfg->loglines-spypeers, QRA_X, c,COL_NORM);
                g_free(c);
            }
        }
    }else{
        strcpy(s,mode_msg[get_mode()]);
        print_text(36-strlen(s),term->y-cfg->loglines-spypeers-DISP_QSOS-1,-1,s,COL_NORM);
    }
        
/*        sw_default_redraw(g_ptr_array_index(ses->subwins,0));*/
    draw_time();
#if 0    
    else {
         c = VTEXT(T_SES_WELCOME);
         print_text((term->x-strlen(c))/2, term->y/2-3, -1, c, COL_NORM);
         c = VTEXT(T_SES_PRESS_F10);
         print_text((term->x-strlen(c))/2, term->y/2-1, -1, c, COL_NORM);
         c = VTEXT(T_SES_HAVE_FUN);
         print_text((term->x-strlen(c))/2, term->y/2+0, -1, c, COL_NORM);
         
         c = VTEXT(T_SES_URL);
         print_text((term->x-strlen(c))/2, term->y-5, -1, c, COL_NORM);
        
         print_tucnak(term->x-26,(term->y-12)/2-1);
#endif         
#if 0
         {
             int i,j;
             for (j=0;j<16;j++){
                for (i=0;i<16;i++){
                    unsigned char s[2];
                    
                    s[0]=i+j*16;
                    /*if (s[0]<32 || 
                        s[0]==127 ||
                        (s[0]>=128+0 && s[0]<128+32)) s[0]='.';*/
                    s[1]=0;
                    print_text(i+5,j+3, 1,s, COL((i&7)+j*8)); 
                }
                print_text(j,2, 1,"X", COL(j)); 
            }
         }
#endif         
#if 0
    }
#endif    
}


#define DELIM "\t\r\n "

#define FREE_Cx if (c1) {mem_free(c1); c1=NULL;}\
                if (c2) {mem_free(c2); c2=NULL;}\
                if (c3) {mem_free(c3); c3=NULL;}\
                if (c4) {mem_free(c4); c4=NULL;}\
                if (c5) {mem_free(c5); c5=NULL;}



void add_tmpqso_locator(struct band *b,gchar *wwl,int isu, int isshort) {
    int qtf_int;
    double qrb, qtf;
    char s[8];
    
    /* CHANGE look at recalc_all_qrbqtf */
    qrbqtf(ctest->pwwlo, wwl, &qrb, &qtf, NULL, 2);
    qtf_int=(int)(qtf+0.5);
    if (qrb < 0.1) {
        qrb=0;
        qtf_int=0;
    }  

    ADD_TMPQSO_GDOUBLE(b, qrb, qrb, isu, uqrb);
    ADD_TMPQSO_GINT(b, qtf, qtf_int, isu, uqtf);
    
    if (isshort)
        safe_strncpy(s, wwl, 4+1);
    else
        safe_strncpy(s, wwl, 6+1);
    
    ADD_TMPQSO_STRING(b,locator,s,isu,ulocator);
}


void after_callsign(struct band *band,char *c){
    gchar *wwl0, *wwl1, *wwl2, *name, *d;
    int done=0;
    char raw[20],raw1[20];
    gchar *qrv_str;
    int unkcall=1;

    CONDGFREE(band->tmpqsos[0].name);
    get_raw_call(raw,c);
    name = find_name_by_call(namedb, raw);
    if (name){
        band->tmpqsos[0].name = g_strdup(name);
        unkcall=0;
    }
     
    CONDGFREE(band->tmpqsos[1].name);
    get_raw_call(raw1, band->tmpqsos[1].callsign);
    name = find_name_by_call(namedb, raw1);
    if (name){
        band->tmpqsos[1].name = g_strdup(name);
    }
     
    CONDGFREE(band->qrv_str);
    qrv_str=find_qrv_str_by_call(cw, uc(c));
    if (qrv_str){
        band->qrv_str = g_strdup(qrv_str);
    }
        
    if (!band->tmpqsos[0].ulocator){

        wwl0 = find_wwl_by_call(cw, uc(c)); 
        wwl1 = find_wwl_by_call(cw, NULL); 
        wwl2 = find_wwl_by_oband(band, raw); /* yes, raw not c */
        
        if (wwl1) {add_tmpqso_locator(band, wwl1, 0, 0); done=1; unkcall=0;}
        if (wwl0) {add_tmpqso_locator(band, wwl0, 0, 0); done=1; unkcall=0;}
        if (wwl2) {add_tmpqso_locator(band, wwl2, 0, 0); done=1; unkcall=0;}
    }    

    /* try remove /p */
    if (!done && 
        !band->tmpqsos[0].ulocator){
        
        wwl0 = find_wwl_by_call(cw, uc(raw)); 
        wwl1 = find_wwl_by_call(cw, NULL); 
        wwl2 = find_wwl_by_oband(band, raw);
        
        if (wwl1) {add_tmpqso_locator(band, wwl1, 0, 0); done=1; unkcall=0;}
        if (wwl0) {add_tmpqso_locator(band, wwl0, 0, 0); done=1; unkcall=0;}
        if (wwl2) {add_tmpqso_locator(band, wwl2, 0, 0); done=1; unkcall=0;}
    }
        
    /* try add /p */
    if (!done && 
        !band->tmpqsos[0].ulocator){
        
        strcat(raw,"/P");
        wwl0 = find_wwl_by_call(cw, uc(raw)); 
        wwl1 = find_wwl_by_call(cw, NULL); 
        wwl2 = find_wwl_by_oband(band, raw);
        
        if (wwl1) {add_tmpqso_locator(band, wwl1, 0, 0); done=1; unkcall=0;}
        if (wwl0) {add_tmpqso_locator(band, wwl0, 0, 0); done=1; unkcall=0;}
        if (wwl2) {add_tmpqso_locator(band, wwl2, 0, 0); done=1; unkcall=0;}
    }
        
    if (!done && !band->tmpqsos[0].ulocator){
        char dxc[30];
            
        get_dxcc(dw, dxc, uc(c));
        wwl0 = find_wwl_by_dxc(dw, uc(dxc)); 
        wwl1 = find_wwl_by_dxc(dw, NULL); 
        
        if (wwl1) add_tmpqso_locator(band, wwl1, 0, 1);
        if (wwl0) add_tmpqso_locator(band, wwl0, 0, 1);
    }
    
    if (band->tmpqsos[0].ulocator){
        int susp;
        if ((susp=get_susp_call(cw, dw, band->tmpqsos[0].callsign, band->tmpqsos[0].locator))!=0){
            band->tmpqsos[0].suspcallsign = susp;
        }else{
            band->tmpqsos[0].susplocator = 0;
            band->tmpqsos[0].suspcallsign = 0;
        }
    }else{ /* v kazdem pripade se bude kontrolovat susp_call */
        int susp;
        if ((susp=get_susp_call(cw, dw, band->tmpqsos[0].callsign, NULL))!=0){
            band->tmpqsos[0].suspcallsign = susp;
        }else{
            band->tmpqsos[0].susplocator = 0;
            band->tmpqsos[0].suspcallsign = 0;
        }

    }

    band->tmpqsos[0].unkcall=unkcall;
    ssbd_callsign(ssbd, c);
    wkd_tmpqso(band, WT_CALLSIGN, c);
    
    d=TMPQ.locator;
    map_clear_qso(&aband->tmplocqso);
    CONDGFREE(aband->tmplocqso.locator);
    aband->tmplocqso.locator=g_strdup(d);
    if (d && *d){
        compute_qrbqtf(&aband->tmplocqso);
        map_add_qso(&aband->tmplocqso);
    }
}

void after_locator(struct band *band,char *c){
    gchar *call0, *call1;
    gchar *dxc0, *dxc1;
    int done=0;
    char raw[20], *name;

    if (!band->tmpqsos[0].ucallsign){
        call0 = find_call_by_wwl(cw, uc(c));
        call1 = find_call_by_wwl(cw, NULL);


        if (call1) {
            ADD_TMPQSO_STRING(band,callsign,call1,0,ucallsign); 
            get_raw_call(raw,call1);
            name = find_name_by_call(namedb, raw);
            ADD_TMPQSO_STRING(band,name,name,0,udummy); 
            done=1;
        }
        if (call0) {
            ADD_TMPQSO_STRING(band,callsign,call0,0,ucallsign); 
            done=1;
            get_raw_call(raw,call0);
            name = find_name_by_call(namedb, raw);
            ADD_TMPQSO_STRING(band,name,name,0,udummy); 
        }
    }
    
    if (!done && !band->tmpqsos[0].ucallsign){
        dxc0 = find_dxc_by_wwl(dw, uc(c));
        dxc1 = find_dxc_by_wwl(dw, NULL);

        if (dxc1) ADD_TMPQSO_STRING(band,callsign,dxc1,0,ucallsign); 
        if (dxc0) ADD_TMPQSO_STRING(band,callsign,dxc0,0,ucallsign);
    }
    if (band->tmpqsos[0].ucallsign){
        int susp;
        if ((susp=get_susp(cw, dw, band->tmpqsos[0].callsign, band->tmpqsos[0].locator, 1))!=0){
            dbg("susp=%d\n", susp);
            band->tmpqsos[0].susplocator = susp & 0xff;
            aband->tmpqsos[0].suspcallsign = susp >> 8;
        }else{
            band->tmpqsos[0].suspcallsign = 0;
            band->tmpqsos[0].susplocator = 0;
        }
    }
    wkd_tmpqso(band, WT_LOCATOR, c);
        
    map_clear_qso(&aband->tmplocqso);

    CONDGFREE(aband->tmplocqso.locator);
    aband->tmplocqso.locator=g_strdup(c);
    if (c && *c){
        compute_qrbqtf(&aband->tmplocqso);
        map_add_qso(&aband->tmplocqso);
        redraw_later();
    }
    

}

void add_unres(struct band *band, gchar *c){
    gchar *tmpc;
    
    if (!band->unres){
        band->unres=g_strdup(c);
        return;
    }
    tmpc=g_strconcat(band->unres, " ", c, NULL);
    g_free(band->unres);
    band->unres=tmpc;
}

void add_date_time(struct band *band){
    char *d;
    time_t now;
    struct tm utc;

    time(&now);
    gmtime_r(&now, &utc);
   
    if (!band->tmpqsos[0].date_str){
        d=g_strdup_printf("%4d%02d%02d",1900+utc.tm_year, 1+utc.tm_mon, utc.tm_mday);
        ADD_TMPQSO_STRING(band,date_str,d,1,udummy);
        g_free(d);
    }
   
    if (!band->tmpqsos[0].time_str){
        d=g_strdup_printf("%02d%02d",utc.tm_hour, utc.tm_min);
        ADD_TMPQSO_STRING(band,time_str,d,1,udummy);
        g_free(d);
    }
}

void fix_date_time(struct band *band){
    struct qso *q;
    int i;
    gchar *last,*cur;

    if (!band->tmpqsos[0].date_str || 
        !band->tmpqsos[0].time_str){

        CONDGFREE(band->tmpqsos[0].date_str);
        CONDGFREE(band->tmpqsos[0].time_str);
        band->tmpqsos[0].date_str=NULL;
        band->tmpqsos[0].time_str=NULL;
        return;
    }
    /* tmpqso->date/time filled in */
    q=NULL;
    for (i=band->qsos->len-1;i>=0;i--){
        q=(struct qso *)g_ptr_array_index(band->qsos, i);
        if (q->error || q->dupe) {
            q=NULL;
            continue;
        }
        break;
    }
    if (!q) return;

    last=g_strconcat(q->date_str, q->time_str, NULL);
    cur=g_strconcat(band->tmpqsos[0].date_str, band->tmpqsos[0].time_str, NULL);
    if ((i=strcmp(last,cur))>0){
        CONDGFREE(band->tmpqsos[0].date_str);
        CONDGFREE(band->tmpqsos[0].time_str);
        band->tmpqsos[0].date_str=NULL;
        band->tmpqsos[0].time_str=NULL;
        return;
    }
/*    dbg("last=%s cur=%s ret=%d\n", last, cur, i);*/
    
    g_free(last);
    g_free(cur);
}

void process_input(void *enterdata, gchar *text){
    char *s,*c;
/*    struct tmpqsos tq[TMP_QSOS];*/
    int num;
    char *c1,*c2,*c3,*c4,*c5;
    char *token_ptr;
    struct band *band = enterdata;
        
    c1=c2=c3=c4=c5=NULL;
    CONDGFREE(band->unres);
   /* CONDGFREE(band->qrv_str);*/
    ssbd_watchdog(ssbd);
    s=g_strdup(text);
    
    num=0;
    for (c=strtok_r(s,DELIM, &token_ptr); c!=NULL; c=strtok_r(NULL,DELIM, &token_ptr) ){
        num++;
/*        dbg("item='%s'\n",c);   */      /* /m /mm dl/ok1mzm/p */
        add_tmpxchg(band, c);
        FREE_Cx;

        /***** LOCATOR *************************************************/
        if (regcmp(c,"^[A-R]{2}[0-9]{2}[A-X]{2}$")==0){
            add_tmpqso_locator(band,c,1,0);
            band->last_item = LI_WWL;
            after_locator(band, c);
            continue;
        }
        FREE_Cx;
        
        /***** RST SENT *************************************************/
        if (regcmp(c,"^[R1-5][1-9]{1,2}[ARMS]{0,2}$")==0){
            ADD_TMPQSO_STRING(band,rsts,c,1,udummy);
                
            band->last_item = LI_NONE;
            wkd_tmpqso(band, WT_RSTS, c);
            continue;
        }
        FREE_Cx;
        
        /***** RST RCVD (useful when no qsonr used) **********************/
        if (regmatch(c,"^([R1-5][1-9]{1,2}[ARMS]{0,2}),$", &c1, &c2, &c3, NULL)==0){
            ADD_TMPQSO_STRING(band,rstr,c2,1,udummy);
            add_date_time(band);
            band->last_item = LI_NONE;
            wkd_tmpqso(band, WT_RSTR, c2);
            continue;
        }
        FREE_Cx;   
        
        /***** RST RECV + QSONR RECV ************************************/
        if (regmatch(c,"^([R1-5][1-9]{1,2}[ARMS]{0,2})[-_]?([0-9]{3,4})$",&c1,&c2,&c3,NULL)==0){ 
            char *d;
           
            d=c3;
            if (strlen(d)==4 && d[0]=='0') d++; /* 0123 -> 123 */
            if (strcmp(d, "000")==0) {add_unres(band, c); continue;}
            ADD_TMPQSO_STRING(band,qsonrr,d,1,udummy);

            ADD_TMPQSO_STRING(band,rstr,c2,1,udummy);
            add_date_time(band);
            band->last_item = LI_NONE;
            wkd_tmpqso(band, WT_QSONRR, d);
            wkd_tmpqso(band, WT_RSTR, c2);
            continue;
        }
        FREE_Cx;
        
        /***** TIME ****************************************************/
        if (regmatch(c,"^([0-2]?[0-9])[:\\.]([0-5]?[0-9])$",&c1,&c2,&c3,NULL)==0){
            if (atoi(c2)>=24) { add_unres(band, c); continue;}
            c4=g_strdup_printf("%02d%02d",atoi(c2),atoi(c3)); 
            ADD_TMPQSO_STRING(band,time_str,c4,1,udummy);
            g_free(c4); c4=NULL;
            continue;
        }
        FREE_Cx;
        if (regmatch(c,"^[:\\.]([0-5]?[0-9])$",&c1,&c2,NULL)==0){
            time_t now;
            struct tm utc;

            time(&now);
            gmtime_r(&now, &utc);
            c4=g_strdup_printf("%02d%02d",utc.tm_hour, atoi(c2)); 
            ADD_TMPQSO_STRING(band,time_str,c4,1,udummy);
            g_free(c4); c4=NULL;
            continue;
        }
        FREE_Cx;
        
        /****** DATE **************************************************/
        if (regmatch(c,"^([0-9]{4})([0-9]{2})([0-9]{2})$",&c1,&c2,&c3,&c4, NULL)==0){
            int year,month,day;
                        
            /*dbg("%s %s %s %s\n",c1,c2,c3,c4);*/
/*            year  = atoi(c1);*/
            year  = atoi(c2);
            month = atoi(c3);
            day   = atoi(c4);
            if (year  < 1900 || year  > 3000 ||
                month < 1    || month > 12   ||
                day   < 1    || day   > 31) {
                    add_unres(band, c);
                    continue;             
            }

            ADD_TMPQSO_STRING(band,date_str,c,1,udummy);
            continue;
        }
        FREE_Cx;
        if (regmatch(c,"^([0-9]{2})([0-9]{2})$",&c1,&c2,&c3, NULL)==0){
            int month,day;
            time_t now;
            struct tm utc;
            char s[40];
                        
            /*dbg("%s %s %s %s\n",c1,c2,c3,c4);*/
            month = atoi(c2);
            day   = atoi(c3);
            if (month < 1    || month > 12   ||
                day   < 1    || day   > 31) {
                    add_unres(band,c);
                    continue;   
            }

            time(&now);
            gmtime_r(&now, &utc);
            sprintf(s, "%04d%02d%02d", 1900+utc.tm_year, month, day);
            
            ADD_TMPQSO_STRING(band,date_str,s,1,udummy);
            continue;
        }
        FREE_Cx;
        
        /****** /X, e.g. /P ***********************************************/
        if (regmatch(c,"^(\\/([A-Z0-9]{1,3})+)+$",&c1,&c2,&c3,&c4,NULL)==0){
            gchar *stroke, *newcall;
                        
            /*dbg("%s %s %s %s\n",c1,c2,c3,c4);*/
            if (!band->tmpqsos[0].callsign) { add_unres(band,c); continue;}

            stroke = g_strdup(c1);
            FREE_Cx;

            if (regmatch(band->tmpqsos[0].callsign, 
                        "^([0-9A-Z]{1,3}\\/)?([0-9][A-Z]|[A-Z]{1,2}[0-9]{1,4}[A-Z]{1,3})(\\/([A-Z0-9]{1,3})+)+$", &c1, &c2, &c3, &c4, &c5, NULL)==0){
                if (c4 && strcmp(c4, stroke)==0)
                    newcall = g_strconcat(c2?c2:"", c3, NULL);
                else    
                    newcall = g_strconcat(c2?c2:"", c3, stroke, NULL);  
            }else{
                newcall = g_strconcat(band->tmpqsos[0].callsign, stroke, NULL);  
            }
            
            ADD_TMPQSO_STRING(band, callsign, newcall, 1, ucallsign); 
            after_callsign(band,newcall);
            g_free(newcall);
            g_free(stroke);
            continue;
        }
        FREE_Cx;
        
        /***** CALLSIGN 1 *************************************************/
        if (regcmp(c,"^([0-9A-Z]{1,3}\\/)?([0-9][A-Z]|[A-Z]{1,2}[0-9]?)[0-9]{1,3}[A-Z]{1,3}(\\/[A-Z0-9]{1,3})*$")==0){
            struct qso *qso;
            
            qso = get_qso_by_callsign(band, c);
            if (qso){
                if (!band->ignoreswap){
                    band->dupe_in_tmpqso = atoi(qso->qsonrs);
                    duplicate_callsign(qso);
                }
                continue;
            }

            ADD_TMPQSO_STRING(band,callsign,c,1,ucallsign);
            band->last_item = LI_CALL;
            after_callsign(band,c);
            continue;
        }
        FREE_Cx;
        
       /***** TWO LETTERS ****************************************************/
        if (regcmp(c,"^([A-Z][A-Z])$")==0){
            /*dbg("TWO %s \n", c);*/
            if (band->last_item==LI_WWL){
                if (band->tmpqsos[0].locator &&
                    band->tmpqsos[0].ulocator){

                    band->tmpqsos[0].locator[4]='\0';
                    strcat(band->tmpqsos[0].locator, c);
                    after_locator(band,TMPQ.locator);
                }
            }
            if (band->last_item==LI_CALL){
                goto nasty_hack;
            }
            continue;
        }
        FREE_Cx;
        
        
        /***** QSL CARD PROMISED *********************************************/
        if (strcasecmp(c,"q")==0){
            band->tmpqsos[0].qsl = !band->tmpqsos[0].qsl;
            continue;
        }

       /***** TWO DIGITS and TWO LETTERS ********************************************/
        if (regcmp(c,"^([0-9][0-9][A-Z][A-Z])$")==0){
/*          dbg("TWO and TWO %s \n", c);*/
            if (band->last_item==LI_WWL){
                if (band->tmpqsos[0].locator &&
                    band->tmpqsos[0].ulocator){

                    band->tmpqsos[0].locator[2]='\0';
                    strcat(band->tmpqsos[0].locator, c);
                    after_locator(band,TMPQ.locator);
                }
            }
            continue;
        }
        FREE_Cx;
        
        
        /***** ONE OR THREE LETTERS *******************************************/
        if (regcmp(c,"^([A-Z]{1,3})$")==0){
            struct qso *qso;

            /*dbg("ONE OR THREE %s \n", c);*/
nasty_hack:;            
            FREE_Cx;
            if (band->tmpqsos[0].callsign && 
                band->tmpqsos[0].ucallsign &&
                regmatch(band->tmpqsos[0].callsign, 
                         "^([0-9A-Z]{1,3}\\/)?([0-9][A-Z]|[A-Z]{1,2}[0-9]{1,4})([A-Z]{1,3})((\\/[A-Z0-9]{1,3})*)$", 
                         &c1, &c2, &c3, &c4, &c5, NULL)==0){
                
                GString *gs;
                /*dbg("c1=%s\nc2=%s\nc3=%s\nc4=%s\nc5=%s\n", c1, c2, c3, c4, c5);*/

                gs=g_string_sized_new(20);

                if (c2) g_string_append(gs, c2);
                if (c3) g_string_append(gs, c3);
                if (c)  g_string_append(gs, c);
                if (c5) g_string_append(gs, c5);
                
                qso = get_qso_by_callsign(band, gs->str);
                if (qso){
                    if (!band->ignoreswap){
                        band->dupe_in_tmpqso = atoi(qso->qsonrs);
                        duplicate_callsign(qso);
                    }
                    g_string_free(gs, TRUE);
                    continue;
                }

                g_free(band->tmpqsos[0].callsign);
                band->tmpqsos[0].callsign=g_strdup(gs->str); /* ADD_TMPQSO_STRING */
                
                after_callsign(band,gs->str);
                g_string_free(gs, TRUE);
                
            }
            continue;
        }
        FREE_Cx;
        
        /***** REMARK ************************************************************/
        if (regmatch(c,"^#(.*)",&c1,&c2,&c3,&c4,NULL)==0){
            if (TMPQ.remark) g_free(TMPQ.remark);
            TMPQ.remark=g_strdup(c2);
            fixsemi(TMPQ.remark);
            continue;    
        }

        /***** EXC ************************************************************/
        if (regmatch(c,"(.*)\\.",&c1,&c2,&c3,&c4,NULL)==0){
            if (TMPQ.exc) g_free(TMPQ.exc);
            TMPQ.exc=g_strdup(c2);
            wkd_tmpqso(band, WT_EXC, c);
            continue;    
        }
        FREE_Cx;

        /***** CALLSIGN 2 *************************************************/
        if (regmatch(c,"^([0-9A-Z]+)/$",&c1,&c2,&c3,&c4,NULL)==0){
            struct qso *qso;
            
            qso = get_qso_by_callsign(band, c2);
            if (qso){
                if (!band->ignoreswap){
                    band->dupe_in_tmpqso = atoi(qso->qsonrs);
                    duplicate_callsign(qso);
                }
                continue;
            }

            ADD_TMPQSO_STRING(band,callsign,c2,1,ucallsign);
            band->last_item = LI_CALL;
            after_callsign(band,c2);
            continue;
        }
        FREE_Cx;
        
        
    /* item is unresolved */
        add_unres(band, c);
        FREE_Cx;
    }
    FREE_Cx;

    if (!num){
        if (band->tmpqsos[0].callsign && band->tmpqsos[0].ucallsign &&
            (band->tmpqsos[0].rsts    || !ctest->rstused) &&  /* 0=no/1=yes */
            (band->tmpqsos[0].rstr    || !ctest->rstused) &&
            (band->tmpqsos[0].qsonrr  || !ctest->qsoused) &&
            (band->tmpqsos[0].exc     || !ctest->excused) &&
             ((band->tmpqsos[0].locator && band->tmpqsos[0].ulocator) || !ctest->wwlused) &&
             can_cq(aband)
           )
            {    
            struct qso *q;
            
            fix_date_time(band);
            
            add_date_time(band);
            
            q=g_new0(struct qso,1);
            

            q->source   = g_strdup(net->myid);
            q->stamp    = time(NULL);
            q->date_str = g_strdup(TMPQ.date_str);
            q->time_str = g_strdup(TMPQ.time_str);
            q->callsign = g_strdup(TMPQ.callsign);
            q->operator = g_strdup(band->operator);
            q->rsts     = g_strdup(TMPQ.rsts?TMPQ.rsts:"");
            q->rstr     = g_strdup(TMPQ.rstr?TMPQ.rstr:"");
            q->qsonrs   = g_strdup(TMPQ.qsonrs?TMPQ.qsonrs:"");
            q->qsonrr   = g_strdup(TMPQ.qsonrr?TMPQ.qsonrr:"");
            if (band->tmpqsos[0].ulocator){
                q->locator  = g_strdup(TMPQ.locator);
                q->qrb      = band->tmpqsos[0].qrb;
                q->qtf      = band->tmpqsos[0].qtf;
            }else{
                q->locator  = g_strdup("");
            }
            
            q->dupe     = band->tmpqsos[0].dupe;
            q->qsop     = 0; /* update_stats */
            q->qsl      = band->tmpqsos[0].qsl;
            q->remark   = g_strdup(TMPQ.remark?TMPQ.remark:"");
            fixsemi(q->remark);
            q->exc      = g_strdup(TMPQ.exc?TMPQ.exc:"");
/*            q->serial   = ctest->serial++;*/
            
            if (get_mode() == MOD_SSB_SSB ||
                get_mode() == MOD_CW_CW){
                
                int s,r;
                /* CHANGE menu2.c refresh_edit_qso */
                s=strlen(q->rsts);
                r=strlen(q->rstr);
                if (s==3 && r==3) q->mode=MOD_CW_CW;
                if (s==2 && r==2) q->mode=MOD_SSB_SSB;
                if (s==3 && r==2) q->mode=MOD_CW_SSB;
                if (s==2 && r==3) q->mode=MOD_SSB_CW;
            }
            
            q->ser_id=-1; /* computed by add_qso_to_index */
            compute_qrbqtf(q);  /* for kx & ky */
            add_qso(band,q);
            write_qso_to_swap(band, q);
            replicate_qso(NULL, q);
            update_stats(band, band->stats, q);
            minute_stats(band);
            recalc_statsfifo(band);
            
            if (ssbd_recording(ssbd)){
                ssbd_abort(ssbd,1);
                ssbd_abort(ssbd,0);
            }
            
            clear_tmpqsos(band);  
            check_autosave();
            map_add_qso(q);
            map_clear_qso(&band->tmplocqso);
            ctrl_back(band);
        }
    }
    
    g_free(s);
    redraw_later();

}

void draw_time(void){
    char s[16];
    time_t now;
    struct tm utc;

    time(&now);
    gmtime_r(&now, &utc);
           
    sprintf(s, " %d:%02d:%02d ", utc.tm_hour, utc.tm_min, utc.tm_sec);
    print_text(term->x-6-strlen(s),0,11,s,COL_NORM);
}


void time_func(union cba_t cba){
    struct timeval tv;
    int remains;

    /*gettimeofday(&tv, NULL);
    dbg("usec=%06d\n", tv.tv_usec);*/
    /* disable time drawing when bfu is active */
    if (term->windows.next == term->windows.prev)
        draw_time();

    gettimeofday(&tv, NULL);
    remains=1000-(tv.tv_usec/1000);
    /*dbg("usec=%06d remains=%d\n", tv.tv_usec, remains);*/
    
    gses->timer_id = install_timer(remains, time_func, CBA0);
}


void print_tucnak(int x, int y){
    int col_black, col_white, col_yellow;
    
    
    if (term->spec->col){
        col_black=COL(0x38);/* 3f */
        col_white=COL(0x7f);
        col_yellow=COL(0x7b);
    }else{
        col_black=COL(0x70);
        col_white=COL(0x3f);
        col_yellow=COL(0x7b);
    }

    fill_area( x-1, y-1, 23, 14, col_black);
    print_text(x+8, y,   -1,"#####",col_black);
    print_text(x+7, y+1, -1,"#######",col_black);
    print_text(x+7, y+2, -1,"#######",col_black);
    print_text(x+9, y+2,  1,"O",col_white);
    print_text(x+11,y+2,  1,"O",col_white);
    print_text(x+7, y+3, -1,"#######",col_black);
    print_text(x+8, y+3, -1,"#####",col_yellow);
    
    print_text(x+5, y+4, -1,"##",col_black);
    print_text(x+7, y+4, -1,"##",col_white);
    print_text(x+9 ,y+4, -1,"###",col_yellow);
    print_text(x+12,y+4, -1,"##",col_white);
    print_text(x+14,y+4, -1,"##",col_black);
    
    print_text(x+4, y+5, -1,"#",col_black);
    print_text(x+5, y+5, -1,"##########",col_white);
    print_text(x+15,y+5, -1,"##",col_black);
    
    print_text(x+3, y+6, -1,"#",col_black);
    print_text(x+4, y+6, -1,"############",col_white);
    print_text(x+16,y+6, -1,"##",col_black);
    
    print_text(x+3, y+7, -1,"#",col_black);
    print_text(x+4, y+7, -1,"############",col_white);
    print_text(x+16,y+7, -1,"###",col_black);
    
    print_text(x+2 ,y+8, -1,"##",col_yellow);
    print_text(x+4, y+8, -1,"#",col_black);
    print_text(x+5, y+8, -1,"###########",col_white);
    print_text(x+16,y+8, -1,"##",col_black);
    print_text(x+18,y+8,-1,"#",col_yellow);
    
    print_text(x   ,y+9, -1,"######",col_yellow);
    print_text(x+6, y+9, -1,"#",col_black);
    print_text(x+7, y+9, -1,"########",col_white);
    print_text(x+14,y+9, -1,"#",col_black);
    print_text(x+15,y+9,-1,"######",col_yellow);
    
    print_text(x   ,y+10,-1,"#######",col_yellow);
    print_text(x+7, y+10,-1,"#",col_black);
    print_text(x+8, y+10,-1,"######",col_white);
    print_text(x+13,y+10,-1,"#",col_black);
    print_text(x+14,y+10,-1,"#######",col_yellow);
    
    print_text(x+2, y+11,-1,"#####",col_yellow);
    print_text(x+7, y+11,-1,"########",col_black);
    print_text(x+14,y+11,-1,"#####",col_yellow);
    
}


