/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"

char *keys[MAX_CQ]={"F5", "F6", "F7", "F8", "F11", "F12"};

struct menu_item no_cq_defined_menu[] = {
    {CTEXT(T_NO_CQ), "", M_BAR, NULL, NULL, 0, 0},
    {NULL, NULL, 0, NULL, NULL, 0, 0},
};


/************************** CW *******************************/
 
char cw_str[MAX_STR_LEN], cw_speed_str[EQSO_LEN];
int cw_repeat;
char cw_ts_str[EQSO_LEN];
int cw_allowifundef;    


void refresh_cq_cw(void *xxx){
    struct cq *cq;

    cq = (struct cq *)xxx;
    
    STORE_STR(cq, cw_str);
    cq->cw_speed = atoi(cw_speed_str);
    cq->cw_repeat = cw_repeat;
    cq->cw_ts  = atoi(cw_ts_str);
    cq->cw_allowifundef = cw_allowifundef;
}

char *cq_cw_msg[] = {
   CTEXT(T_TEXT), 
   CTEXT(T_SPEED), 
   CTEXT(T_REPEAT),
   CTEXT(T_DELAY), 
   CTEXT(T_ALLOW_UNDEF),
   "", /* OK */
   "", /* Cancel */
};


void cq_cw_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, cq_cw_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, cq_cw_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, cq_cw_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, cq_cw_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, cq_cw_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, cq_cw_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, cq_cw_msg + 3, dlg->items + 2, 1, &max);
    min_group_width(term, cq_cw_msg + 3, dlg->items + 2, 1, &min);
    max_group_width(term, cq_cw_msg + 4, dlg->items + 2, 1, &max);
    min_group_width(term, cq_cw_msg + 4, dlg->items + 2, 1, &min);
    
    max_buttons_width(term, dlg->items + 5, 2, &max);
    min_buttons_width(term, dlg->items + 5, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, cq_cw_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_cw_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_cw_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_cw_msg + 3, dlg->items + 3, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_cw_msg + 4, dlg->items + 4, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items + 5, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, cq_cw_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_cw_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_cw_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_cw_msg + 3, dlg->items + 3, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_cw_msg + 4, dlg->items + 4, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 5, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void cq_cw(struct terminal *term, void *xxx, struct session *ses){

    struct dialog *d;
    int i;
    int no;
    struct cq *cq;


    no = (vint)xxx;               
    cq = g_ptr_array_index(cfg->cqs, no);
    
    safe_strncpy0(cw_str, cq->cw_str, MAX_STR_LEN);
    g_snprintf(cw_speed_str, EQSO_LEN, "%d", cq->cw_speed);
    cw_repeat = cq->cw_repeat;
    g_snprintf(cw_ts_str, EQSO_LEN, "%d", cq->cw_ts);
    cw_allowifundef = cq->cw_allowifundef;

    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = TEXT(T_CW_CQ);
    d->fn = cq_cw_fn;
    d->refresh = (void (*)(void *))refresh_cq_cw;
    d->refresh_data = (void *)cq;
    
    d->items[i=0].type = D_FIELD;     /* 0 */
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = cw_str;
    d->items[i].maxl = 60;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = cw_speed_str;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cw_repeat;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = cw_ts_str;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cw_allowifundef;
    

    d->items[++i].type = D_BUTTON; /* 5 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
                               
}

void menu_cq_cw(struct terminal *term, void *xxx, struct session *ses){
    int i;
    char *c;
    struct menu_item *mi = NULL;
    struct cq *cq;
    char example[20];
    

    for (i=0; i<cfg->cqs->len; i++){
        cq = (struct cq *) g_ptr_array_index(cfg->cqs, i);
        
        safe_strncpy0(example, cq->cw_str, 20);
        c = g_strdup_printf(TEXT(T_CW_DSCS), i, keys[i], cq->cw_repeat?'R':' ', example);
        if (!mi) if (!(mi = new_menu(3))) return;
        add_to_menu(&mi, 
                stracpy(c), 
                "", "", 
                MENU_FUNC cq_cw, (void *)(vint)i, 0);    
        g_free(c);
    }
    if (i) 
        do_menu_(term, mi, ses);
    else
        do_menu_(term, no_cq_defined_menu, ses);
}


/*********************** SSB ****************************/

char ssb_file[MAX_STR_LEN];
int ssb_repeat;
char ssb_ts_str[EQSO_LEN];

void refresh_cq_ssb(void *xxx){
    struct cq *cq;

    cq = (struct cq *)xxx;
    
    STORE_STR(cq, ssb_file);
    cq->ssb_repeat = ssb_repeat;
    cq->ssb_ts  = atoi(ssb_ts_str);
}

char *cq_ssb_msg[] = {
   CTEXT(T_FILENAME), 
   CTEXT(T_REPEAT),
   CTEXT(T_DELAY), 
   "", /* OK */
   "", /* Cancel */
};


void cq_ssb_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, cq_ssb_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, cq_ssb_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, cq_ssb_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, cq_ssb_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, cq_ssb_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, cq_ssb_msg + 2, dlg->items + 2, 1, &min);
    
    max_buttons_width(term, dlg->items + 3, 2, &max);
    min_buttons_width(term, dlg->items + 3, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, cq_ssb_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_ssb_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_ssb_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items + 3, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, cq_ssb_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_ssb_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_ssb_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 3, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void cq_ssb(struct terminal *term, void *xxx, struct session *ses){

    struct dialog *d;
    int i;
    int no;
    struct cq *cq;


    no = (vint)xxx;               
    cq = g_ptr_array_index(cfg->cqs, no);
    
    safe_strncpy0(ssb_file, cq->ssb_file, MAX_STR_LEN);
    ssb_repeat = cq->ssb_repeat;
    g_snprintf(ssb_ts_str, EQSO_LEN, "%d", cq->ssb_ts);

    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = TEXT(T_SSB_CQ);
    d->fn = cq_ssb_fn;
    d->refresh = (void (*)(void *))refresh_cq_ssb;
    d->refresh_data = (void *)cq;
    
    d->items[i=0].type = D_FIELD;     /* 0 */
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = ssb_file;
    d->items[i].maxl = 60;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssb_repeat;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssb_ts_str;
    
    d->items[++i].type = D_BUTTON; /* 3 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
                               
}


void menu_cq_ssb(struct terminal *term, void *xxx, struct session *ses){
    int i;
    char *c;
    struct menu_item *mi = NULL;
    struct cq *cq;
    char example[20];
    

    for (i=0; i<cfg->cqs->len; i++){
        cq = (struct cq *) g_ptr_array_index(cfg->cqs, i);

        safe_strncpy0(example, cq->ssb_file, 20);
        c = g_strdup_printf(TEXT(T_SSB_DSCS), i, keys[i], cq->ssb_repeat?'R':' ', example);
        if (!mi) if (!(mi = new_menu(3))) return;
        add_to_menu(&mi, 
                stracpy(c), 
                "", "", 
                MENU_FUNC cq_ssb, (void *)(vint)i, 0);    
        g_free(c);
    }
    if (i) 
        do_menu_(term, mi, ses);
    else
        do_menu_(term, no_cq_defined_menu, ses);
}



/******************* CWDAEMON **********************************/

char cwda_hostname[MAX_STR_LEN];
char udp_port_str[EQSO_LEN];
char cwda_device_s[EQSO_LEN];
char speed_str[EQSO_LEN];
char weight_str[EQSO_LEN];
int spkdev;
char spkvol_str[EQSO_LEN];
char pttdelay_str[EQSO_LEN];

void refresh_cwda(void *xxx){
    
    STORE_STR(cfg, cwda_hostname);
    cfg->cwda_udp_port = atoi(udp_port_str);
    STORE_STR(cfg, cwda_device_s);
    cfg->cwda_speed = atoi(speed_str);
    cfg->cwda_weight = atoi(weight_str);
    cfg->cwda_spkdev = spkdev;
    cfg->cwda_spkvol = atoi(spkvol_str);
    cfg->cwda_pttdelay = atoi(pttdelay_str);
	free_cwdaemon(cwda);
	cwda=init_cwdaemon();
}

char *cwda_msg[] = {
   CTEXT(T_HOSTNAME),     /* 0 */
   CTEXT(T_UDPPORT),
   CTEXT(T_DEVICE), 
   CTEXT(T_INIT_SPEED),
   CTEXT(T_INIT_WEIGHT),
   CTEXT(T_USE_SPK),      /* 5 */
   CTEXT(T_USE_SOUNDCARD),    
   CTEXT(T_SPKVOL),
   CTEXT(T_PTTDELAY),
   "", /* OK */          /* 9 */
   "", /* Cancel */
};


void cwda_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, cwda_msg + 0, dlg->items + 0, 2, &max);
    min_group_width(term, cwda_msg + 0, dlg->items + 0, 2, &min);
    max_group_width(term, cwda_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, cwda_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, cwda_msg + 3, dlg->items + 3, 2, &max);
    min_group_width(term, cwda_msg + 3, dlg->items + 3, 2, &min);
    max_group_width(term, cwda_msg + 5, dlg->items + 5, 2, &max);
    min_group_width(term, cwda_msg + 5, dlg->items + 5, 2, &min);
    max_group_width(term, cwda_msg + 7, dlg->items + 7, 1, &max);
    min_group_width(term, cwda_msg + 7, dlg->items + 7, 1, &min);
    max_group_width(term, cwda_msg + 8, dlg->items + 8, 1, &max);
    min_group_width(term, cwda_msg + 8, dlg->items + 8, 1, &min);
    
    max_buttons_width(term, dlg->items + 9, 2, &max);
    min_buttons_width(term, dlg->items + 9, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, cwda_msg + 0, dlg->items + 0, 2, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cwda_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cwda_msg + 3, dlg->items + 3, 2, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cwda_msg + 5, dlg->items + 5, 2, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cwda_msg + 7, dlg->items + 7, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cwda_msg + 8, dlg->items + 8, 1, 0, &y, w, &rw);
    
    y++;
    dlg_format_buttons(NULL, term, dlg->items + 9, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, cwda_msg + 0, dlg->items + 0, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cwda_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cwda_msg + 3, dlg->items + 3, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cwda_msg + 5, dlg->items + 5, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cwda_msg + 7, dlg->items + 7, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cwda_msg + 8, dlg->items + 8, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 9, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void menu_cwda(struct terminal *term, void *xxx, struct session *ses){

    struct dialog *d;
    int i;
    
    safe_strncpy0(cwda_hostname, cfg->cwda_hostname, MAX_STR_LEN);
    g_snprintf(udp_port_str, EQSO_LEN, "%d", cfg->cwda_udp_port);
    safe_strncpy0(cwda_device_s, cfg->cwda_device_s, EQSO_LEN);
    g_snprintf(speed_str, EQSO_LEN, "%d", cfg->cwda_speed);
    g_snprintf(weight_str, EQSO_LEN, "%d", cfg->cwda_weight);
    spkdev=cfg->cwda_spkdev;
    g_snprintf(spkvol_str, EQSO_LEN, "%d", cfg->cwda_spkvol);
    g_snprintf(pttdelay_str, EQSO_LEN, "%d", cfg->cwda_pttdelay);

    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = TEXT(T_CW_DAEMON);
    d->fn = cwda_fn;
    d->refresh = (void (*)(void *))refresh_cwda;
    d->refresh_data = NULL;
    
    d->items[i=0].type = D_FIELD;     /* 0 */
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = cwda_hostname;
    d->items[i].maxl = 20;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = udp_port_str;
    d->items[i].maxl = 6;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = cwda_device_s;
    d->items[i].maxl = 15;
    
    d->items[++i].type = D_FIELD;      
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = speed_str;
    d->items[i].maxl = 3;
    
    d->items[++i].type = D_FIELD;      
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = weight_str;
    d->items[i].maxl = 3;
    
    d->items[++i].type = D_CHECKBOX;  /* 5 */
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&spkdev;
    
    d->items[++i].type = D_CHECKBOX; 
    d->items[i].gid = 0;
    d->items[i].gnum = 2;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&spkdev;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = spkvol_str;
    d->items[i].maxl = 3;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = pttdelay_str;
    d->items[i].maxl = 3;
    
    d->items[++i].type = D_BUTTON;    /* 9 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;   /* 10 */
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
                               
}

/*********************** SSBD ****************************/

char ssbd_hostname[MAX_STR_LEN],ssbd_udp_port_str[EQSO_LEN],ssbd_dsp[MAX_STR_LEN];
int ssbd_record;
char ssbd_template[MAX_STR_LEN];
int ssbd_format;
char ssbd_channels_str[EQSO_LEN], ssbd_samplerate_str[EQSO_LEN];
char ssbd_mixer[MAX_STR_LEN];
int ssbd_recsrc;

void refresh_ssbd(void *xxx){
    
    STORE_STR(cfg, ssbd_hostname);
    STORE_SINT(cfg, ssbd_udp_port);
    STORE_STR(cfg, ssbd_dsp);
    STORE_INT(cfg, ssbd_record);
    STORE_STR(cfg, ssbd_template);
    STORE_INT(cfg, ssbd_format);
    STORE_SINT(cfg, ssbd_channels);
    STORE_SINT(cfg, ssbd_samplerate);
    STORE_STR(cfg, ssbd_mixer);
    STORE_INT(cfg, ssbd_recsrc);
    free_ssbd(ssbd);
    ssbd=init_ssbd();
}

char *ssbd_msg[] = {
   CTEXT(T_HOSTNAME),  /* 0 */
   CTEXT(T_UDPPORT),
   CTEXT(T_DSP), 
   CTEXT(T_RECORD), 
   CTEXT(T_TEMPLATE), 
   CTEXT(T_PCM8),      /* 5 */
   CTEXT(T_PCM16), 
   CTEXT(T_ULAW), 
   CTEXT(T_ALAW), 
   CTEXT(T_IMAADPCM), 
   CTEXT(T_MSADPCM),   /* 10 */
   CTEXT(T_GSM610), 
   CTEXT(T_CHANNELS), 
   CTEXT(T_SAMPLERATE), 
   CTEXT(T_MIXER),
   CTEXT(T_RECSRC_NONE),   /* 15 */
   CTEXT(T_RECSRC_MIC),   
   CTEXT(T_RECSRC_LINE),   
   "", /* OK */       /* 18 */ 
   "", /* Cancel */
};


void ssbd_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, ssbd_msg + 0, dlg->items + 0, 2, &max);
    min_group_width(term, ssbd_msg + 0, dlg->items + 0, 2, &min);
    
    max_group_width(term, ssbd_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, ssbd_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, ssbd_msg + 3, dlg->items + 3, 1, &max);
    min_group_width(term, ssbd_msg + 3, dlg->items + 3, 1, &min);
    max_group_width(term, ssbd_msg + 4, dlg->items + 4, 1, &max);
    min_group_width(term, ssbd_msg + 4, dlg->items + 4, 1, &min);
    
    max_group_width(term, ssbd_msg + 5, dlg->items + 5, 7, &max);
    min_group_width(term, ssbd_msg + 5, dlg->items + 5, 7, &min);
    
    max_group_width(term, ssbd_msg +12, dlg->items +12, 2, &max);
    min_group_width(term, ssbd_msg +12, dlg->items +12, 2, &min);
    
    max_group_width(term, ssbd_msg +14, dlg->items +14, 4, &max);
    min_group_width(term, ssbd_msg +14, dlg->items +14, 4, &min);
    
    max_buttons_width(term, dlg->items +18, 2, &max);
    min_buttons_width(term, dlg->items +18, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group1(NULL, term, ssbd_msg + 0, dlg->items + 0, 2, 0, &y, w, &rw);
    dlg_format_group(NULL, term, ssbd_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    y++;
    dlg_format_group(NULL, term, ssbd_msg + 3, dlg->items + 3, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, ssbd_msg + 4, dlg->items + 4, 1, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, ssbd_msg + 5, dlg->items + 5, 7, 0, &y, w, &rw);
    dlg_format_group(NULL, term, ssbd_msg +12, dlg->items +12, 2, 0, &y, w, &rw);
    y++;
    dlg_format_group1(NULL, term, ssbd_msg +14, dlg->items +14, 4, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +18, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group1(term, term, ssbd_msg + 0, dlg->items + 0, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, ssbd_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group(term, term, ssbd_msg + 3, dlg->items + 3, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, ssbd_msg + 4, dlg->items + 4, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, ssbd_msg + 5, dlg->items + 5, 7, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, ssbd_msg +12, dlg->items +12, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group1(term, term, ssbd_msg +14, dlg->items +14, 4, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 18, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void do_ssbd(struct terminal *term, void *xxx, struct session *ses){

    struct dialog *d;
    int i;
    
    safe_strncpy0(ssbd_hostname, cfg->ssbd_hostname, MAX_STR_LEN);
    g_snprintf(ssbd_udp_port_str, EQSO_LEN, "%d", cfg->ssbd_udp_port);
    safe_strncpy0(ssbd_dsp, cfg->ssbd_dsp, MAX_STR_LEN);
    ssbd_record = cfg->ssbd_record;
    safe_strncpy0(ssbd_template, cfg->ssbd_template, MAX_STR_LEN);
    ssbd_format = cfg->ssbd_format;
    g_snprintf(ssbd_channels_str, EQSO_LEN, "%d", cfg->ssbd_channels);
    g_snprintf(ssbd_samplerate_str, EQSO_LEN, "%d", cfg->ssbd_samplerate);
    safe_strncpy0(ssbd_mixer, cfg->ssbd_mixer, MAX_STR_LEN);
    ssbd_recsrc = cfg->ssbd_recsrc;
    

    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = TEXT(T_SSBD);
    d->fn = ssbd_fn;
    d->refresh = (void (*)(void *))refresh_ssbd;
    
    d->items[i=0].type = D_FIELD;     /* 0 */
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = ssbd_hostname;
    d->items[i].maxl = 20;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_udp_port_str;
    d->items[i].maxl = 6;
    
    d->items[++i].type = D_FIELD;     
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = ssbd_dsp;
    d->items[i].maxl = 30;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_record;
    
    d->items[++i].type = D_FIELD;     
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = ssbd_template;
    d->items[i].maxl = 30;
    
    d->items[++i].type = D_CHECKBOX;  /* 5 */
    d->items[i].gid = 1;
    d->items[i].gnum = 0x10005;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_format;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = 0x10002;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_format;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = 0x10010;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_format;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = 0x10011;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_format;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = 0x10012;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_format;
    
    d->items[++i].type = D_CHECKBOX;  /* 10 */
    d->items[i].gid = 1;
    d->items[i].gnum = 0x10013;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_format;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = 0x10020;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_format;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_channels_str;
    d->items[i].maxl = 3;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_samplerate_str;
    d->items[i].maxl = 6;
    
    d->items[++i].type = D_FIELD;     
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = ssbd_mixer;
    d->items[i].maxl = 30;

    d->items[++i].type = D_CHECKBOX;  /* 15 */
    d->items[i].gid = 2;
    d->items[i].gnum = 0;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_recsrc;
    
    d->items[++i].type = D_CHECKBOX; 
    d->items[i].gid = 2;
    d->items[i].gnum = (1<<SOUND_MIXER_MIC);
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_recsrc;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 2;
    d->items[i].gnum = (1<<SOUND_MIXER_LINE);
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_recsrc;
    
    d->items[++i].type = D_BUTTON; /* 18 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
                               
}


void menu_ssbd(struct terminal *term, void *xxx, struct session *ses){
    
    do_ssbd(term,xxx,ses);
}



/*********************** NETWORK ****************************/

char net_if_ignore[MAX_STR_LEN],net_ip_ignore[MAX_STR_LEN],net_ip_announce[MAX_STR_LEN];
int trace_bcast, trace_sock, trace_recv, trace_send, trace_qsos ;

void refresh_net(void *xxx){
    
    STORE_STR(cfg, net_if_ignore);
    STORE_STR(cfg, net_ip_ignore);
    STORE_STR(cfg, net_ip_announce);
    STORE_INT(cfg, trace_bcast);
    STORE_INT(cfg, trace_sock);
    STORE_INT(cfg, trace_recv);
    STORE_INT(cfg, trace_send);
    STORE_INT(cfg, trace_qsos);
    free_net_ifaces(net);
    init_net_ifaces(net);
}

char *net_msg[] = {
   CTEXT(T_IF_IGNORE),  /* 0 */
   CTEXT(T_IP_IGNORE),
   CTEXT(T_IP_ANNOUNCE), 
   CTEXT(T_TRACE_BCAST), 
   CTEXT(T_TRACE_SOCK),  
   CTEXT(T_TRACE_RECV),      /* 5 */    
   CTEXT(T_TRACE_SEND),      
   CTEXT(T_TRACE_QSOS), 
   "", /* OK */       /* 8 */ 
   "", /* Cancel */
};


void net_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, net_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, net_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, net_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, net_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, net_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, net_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, net_msg + 3, dlg->items + 3, 2, &max);
    min_group_width(term, net_msg + 3, dlg->items + 3, 2, &min);
    max_group_width(term, net_msg + 5, dlg->items + 5, 2, &max);
    min_group_width(term, net_msg + 5, dlg->items + 5, 2, &min);
    max_group_width(term, net_msg + 7, dlg->items + 7, 1, &max);
    min_group_width(term, net_msg + 7, dlg->items + 7, 1, &min);
    
    max_buttons_width(term, dlg->items +8, 2, &max);
    min_buttons_width(term, dlg->items +8, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group1(NULL, term, net_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, net_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, net_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    y++;
    dlg_format_group1(NULL, term, net_msg + 3, dlg->items + 3, 2, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, net_msg + 5, dlg->items + 5, 2, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, net_msg + 7, dlg->items + 7, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +8, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group1(term, term, net_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, net_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, net_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group1(term, term, net_msg + 3, dlg->items + 3, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, net_msg + 5, dlg->items + 5, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, net_msg + 7, dlg->items + 7, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 8, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void do_net(struct terminal *term, void *xxx, struct session *ses){

    struct dialog *d;
    int i;
    
    safe_strncpy0(net_if_ignore, cfg->net_if_ignore, MAX_STR_LEN);
    safe_strncpy0(net_ip_ignore, cfg->net_ip_ignore, MAX_STR_LEN);
    safe_strncpy0(net_ip_announce, cfg->net_ip_announce, MAX_STR_LEN);
    trace_bcast=cfg->trace_bcast;
    trace_sock=cfg->trace_sock;
    trace_recv=cfg->trace_recv;
    trace_send=cfg->trace_send;
    trace_qsos=cfg->trace_qsos;

    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = TEXT(T_NETWORK);
    d->fn = net_fn;
    d->refresh = (void (*)(void *))refresh_net;
    
    d->items[i=0].type = D_FIELD;     /* 0 */
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = net_if_ignore;
    d->items[i].maxl = 20;
    
    d->items[++i].type = D_FIELD;     
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = net_ip_ignore;
    d->items[i].maxl = 20;
    
    d->items[++i].type = D_FIELD;     
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = net_ip_announce;
    d->items[i].maxl = 20;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_bcast;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_sock;
    
    d->items[++i].type = D_CHECKBOX;   /* 5 */
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_recv;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_send;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_qsos;
    
    
    d->items[++i].type = D_BUTTON; /* 8 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
                               
}


void menu_network(struct terminal *term, void *xxx, struct session *ses){
    
    do_net(term,xxx,ses);
}



