/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"

#define CWW_MAXSTR 100

struct window *cwwindow;

struct cwwin_data{
    int x,y,w,h;
    char text[CWW_MAXSTR];
    int speed;
};

void draw_cwwindow(struct cwwin_data *cwwdata){
    fill_area(term, cwwdata->x-2, cwwdata->y-1, cwwdata->w+4, cwwdata->h+2, COL_INV); 
    draw_frame(term, cwwdata->x, cwwdata->y, cwwdata->w, cwwdata->h, COL_INV, 1); 
    print_text(term, cwwdata->x + 5, cwwdata->y, -1, TEXT(T__CW_), COL_NORM);
    print_text(term, cwwdata->x + 5, cwwdata->y + cwwdata->h -1 , -1, TEXT(T_CWW_KEYS), COL_NORM);

    print_text(term, cwwdata->x + 3, cwwdata->y +2 , CWW_MAXSTR>cwwdata->w-4? cwwdata->w-4:CWW_MAXSTR, cwwdata->text , COL_INV);
        
    /*dbg("draw_cwwindow: set_cursor %d %d \n", cwwdata->x +
	 * strlen(cwwdata->text), cwwdata->y+2, 0, 0);*/
    set_cursor(term, cwwdata->x + strlen(cwwdata->text) + 3, cwwdata->y+2, 
                     cwwdata->x + strlen(cwwdata->text) + 3 , cwwdata->y+2);
    
}

void cwwindow_func(struct window *win, struct event *ev, int fwd){
    struct terminal *term;
    struct cwwin_data *cwwdata;
    
    term = win->term;
    cwwdata = (struct cwwin_data *)win->data;
    
    dbg("cwwindow_func [%d,%d,%d,%d]\n",ev->ev,ev->x,ev->y,ev->b);

    switch (ev->ev) {
        case EV_INIT:
            win->data = cwwdata = mem_alloc(sizeof(struct cwwin_data));
            memset(win->data, 0, sizeof(struct cwwin_data));

        case EV_RESIZE:
            cwwdata->x = 10;
            cwwdata->y = (ev->y - 6) / 2;
            cwwdata->w = ev->x - 20;
            cwwdata->h = 5;
            
        case EV_REDRAW:
            draw_cwwindow(cwwdata);
            break;
        case EV_MOUSE:
            break;
        case EV_KBD:
            switch(ev->x){
                case KBD_ESC:
                case KBD_TAB:
                    /*delete_window_ev(win, (void *)win->next != &win->term->windows && 
                            win->next->handler == cwwindow_func ? ev : NULL);*/
                    delete_window_ev(win, ev);
                    break;
                case KBD_ENTER: /* delete window, CW text play on */
					ev->x=KBD_TAB;
                    delete_window_ev(win, ev);
                    break;
                case KBD_PAGE_UP:
					cwdaemon_qrq(cwda, 2);
					redraw_later(term);
					break;  
                case KBD_PAGE_DOWN:
					cwdaemon_qrs(cwda, 2);
					redraw_later(term);
                    break;  
                default:    
                    if (ev->x >= ' ' && ev->x < 256) {
                        dbg("key=%c\n", ev->x);
                        if (strlen(cwwdata->text)<CWW_MAXSTR-1)
                            cwwdata->text[strlen(cwwdata->text)]=ev->x;
                        cwdaemon_cw_char(cwda, ev->x);
                        draw_cwwindow(cwwdata);
                    }
            }
            break;
        case EV_ABORT:
            /* mem_free(cwwdata);  already in terminal.c:196 (delete_window) */ 
            break;
    }
}

