#ifndef INCLUDED_TEXTS_H
#define INCLUDED_TEXTS_H
/* vim:ts=4:sw=4:noet
 * (tabspace=4)
 * 
 * Copyright (C) 2004, 2005 Walter Doekes, <walter@djcvt.net>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * Texts for tthsum
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

enum text_id {
	BASE32_INVALID_CHARACTER,
	ESCAPE_INVALID_ESCAPE,
	TEXTS_UNKNOWN_ERROR,
	THEX_INVALID_BLOCK_SIZE,
	TTHSUM_FILENAME_TOO_LARGE,
	TTHSUM_LINE_CORRUPT,
	TTHSUM_MISMATCHED_TTH,
	UTF8_INVALID_UNICODE,
	UTF8_INVALID_UTF8
};

/**
 * Set the last error.
 * The error number is a text_id, unless it is -1,
 * in which case the OS specific error is stored.
 */
void set_error(const char* context, int error);

/**
 * Get the set error.
 */
const char* get_error();

/**
 * Get a specific text.
 */
const char* get_text(enum text_id id);

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* INCLUDED_TEXTS_H */

