#ifndef INCLUDED_ESCAPE_H
#define INCLUDED_ESCAPE_H
/* vim:ts=4:sw=4:noet
 * (tabspace=4)
 * 
 * Copyright (C) 2004, 2005 Walter Doekes, <walter@djcvt.net>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * Conversion routines to and from \xNN escaping for <0x20 characters.
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * Escape all characters below 0x20 and the backslash in a C-string.
 * The destination dest must be at least 4*strlen(src)+1 characters long.
 */
void strtoctrlesc(unsigned char* dest, const unsigned char* src);

/**
 * Unescape a string escaped by strtoctrlesc.
 * The destination dest must be at least strlen(src)+1 characters long.
 * Returns 0 on success and -1 when an invalid escape sequence is encountered
 * (and the state of dest will be undefined).
 */
int ctrlesctostr(unsigned char* dest, unsigned const char* src);

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* INCLUDED_ESCAPE_H */
