/* @HEADER@ */
/* ***********************************************************************
// 
//           TSFExtended: Trilinos Solver Framework Extended
//                 Copyright (2004) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// Questions? Contact Michael A. Heroux (maherou@sandia.gov) 
// 
// **********************************************************************/
/* @HEADER@ */

#ifndef TSFPRECONDITIONERFACTORY_HPP
#define TSFPRECONDITIONERFACTORY_HPP

#include "SundanceDefs.hpp"
#include "SundanceHandle.hpp"
#include "TSFPreconditionerFactoryBase.hpp"

namespace TSFExtended
{
  /**
   * PreconditionerFactory builds an implementation-specific preconditioner
   * from an abstract specification. 
   * 
   * Preconditioners are constructed indirectly through factories
   * rather then directly by preconditioner ctor calls. 
   * The reason for this is that when we create a solver and want to 
   * specify the preconditioner, we don't yet know the matrix (or even
   * the type or size of matrix) on which the solver is going to operate.
   * Thus we have to defer construction of the preconditioner until 
   * the solve() call when the matrix is available. The factory gives
   * us a means by which we can build a preconditioner at that point.
   */
  template <class Scalar> 
  class PreconditionerFactory 
    : public SundanceUtils::Handle<PreconditionerFactoryBase<Scalar> >
  {
  public:
    /* Boilerplate ctors */
    HANDLE_CTORS(PreconditionerFactory<Scalar>, PreconditionerFactoryBase<Scalar>);

    /** create a concrete preconditioner */
    Preconditioner<Scalar> createPreconditioner(const LinearOperator<Scalar>& A) const
    {return this->ptr()->createPreconditioner(A);}
    
  };
}

#endif
