/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* main.c by Gopal Narayanan
 * This file containes the main program.
 */

#include <stdio.h>
#include "transcalc.h"
#include <config.h>
#include "help.h"

char version[] = "transcalc " VERSION;

void
usage (void)
{
  char *help_txt;
  /* allocate memory for the Help text */
  
  if ((help_txt = (char *) malloc(2000*sizeof(char)))  == NULL){
    perror("help text error: malloc");
    return;
  } else {
    sprintf(help_txt, "\n TRANSCALC %s\n",VERSION);
    strcat(help_txt, HELPTEXT);
  }
  printf("usage: transcalc [-h] [-v] \n");
  printf("%s\n",help_txt);
  exit (0);
}



int 
main( int   argc,
               char *argv[] )
{
  /* GtkWidget is the storage type for widgets */
  /*         GtkWidget *mainwindow;*/
  GtkWidget *button;
  /*         GtkWidget *vbox1;*/
  /*         GtkWidget *menu;*/
  /*         GtkWidget *body;*/
  
  
  /* This is called in all GTK applications. Arguments are parsed
   * from the command line and are returned to the application. */
  gtk_init(&argc, &argv);
  
   if (argc > 1)
    {
      if (strcmp (argv[1], "--help") == 0 || strcmp (argv[1], "-h") == 0)
        usage ();
      else if (strcmp (argv[1], "--version") == 0
               || strcmp (argv[1], "-v") == 0)
        {
          printf ("%s\n", version);
          exit (0);
        }
    }
 
  
  length_unit = LENGTH_MIL;
  freq_unit = FREQ_GHZ;
  res_unit = RES_OHM;
  ang_unit = ANG_DEG;
  statusint = CONSISTENT;
  statusexists = FALSE;
  
  /*allocate memory for structure of main GUI */
  tgui = g_malloc(sizeof(*tgui));
  
  /*allocate memory for structure of transmission line window */
  twin = g_malloc(sizeof(*twin));
  
  /* Any command line options for program should follow here */
  
  /* create a new window */
  tgui->mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  
  /* set title of main window */
  
  gtk_window_set_title (GTK_WINDOW (tgui->mainwindow), "transcalc");
  
  /* When the window is given the "delete_event" signal (this is given
   * by the window manager, usually by the "close" option, or on the
   * titlebar), we ask it to call the delete_event () function
   * as defined above. The data passed to the callback
   * function is NULL and is ignored in the callback function. */
  gtk_signal_connect (GTK_OBJECT (tgui->mainwindow), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL);
  
  /* Here we connect the "destroy" event to a signal handler.  
   * This event occurs when we call gtk_widget_destroy() on the window,
   * or if we return FALSE in the "delete_event" callback. */
  gtk_signal_connect (GTK_OBJECT (tgui->mainwindow), "destroy",
		      GTK_SIGNAL_FUNC (destroy), NULL);
  
  /* Sets the border width of the window. */
  gtk_container_set_border_width (GTK_CONTAINER (tgui->mainwindow), 10);
  
  /* Create a virtual vertical box that will hold everything */
  /* First argument - homogeneous, 2nd vert. spacing */
  tgui->vertbox = gtk_vbox_new (FALSE, 0);
  
  
  /* Put this box in the main window */
  gtk_container_add (GTK_CONTAINER (tgui->mainwindow), tgui->vertbox);
  
  
  /* setup the menu */
  tgui->menu = GTK_WIDGET (setup_menu (tgui));
  
  /* setup the main area of calculations */
  tgui->body = setup_body (tgui);
  
  
  /* setup the status field at the botttom */
  /*  status = GTK_WIDGET (setup_status (tgui)); 
      statusexists = TRUE; */
  
  gtk_widget_show (tgui->vertbox);
  gtk_widget_show (tgui->mainwindow);
  
  
  
  /* All GTK applications must have a gtk_main(). Control ends here
   * and waits for an event to occur (like a key press or
   * mouse event). */
  gtk_main ();
  
  
  /*	 free(twin);*/
  
  return(0);
}
/* end of transcalc main */
