#ifndef _TRAFSTATS_H_
  #define _TRAFSTATS_H_

#ifndef _STDIO_H
#include <stdio.h>
#endif

#ifndef _STDLIB_H
#include <stdlib.h>
#endif

#ifndef _ERRNO_H
#include <errno.h>
#endif

#ifndef _SYS_SOCKET_H
#include <sys/socket.h>
#endif

#ifndef _ARPA_INET_H
#include <arpa/inet.h>
#endif

#ifndef _NETINET_IN_H
#include <netinet/in.h>
#endif

#ifndef __NETINET_IF_ETHER_H
#include <netinet/if_ether.h>
#endif 

#ifndef __NET_ETHERNET_H
#include <net/ethernet.h>
#endif

#ifndef _NETINET_ETHER_H
#include <netinet/ether.h> 
#endif

#ifndef _NETINET_TCP_H
#include <netinet/tcp.h>
#endif

#ifndef __NETINET_UDP_H
#include <netinet/udp.h>
#endif

#ifndef _SYS_SYSLOG_H
#include <syslog.h>
#endif

#ifndef _PTHREAD_H
#include <pthread.h>
#endif

#ifndef _UNISTD_H
#include <unistd.h>
#endif

#ifndef _CTRAFSTATSLIST_H_
#include "CTrafStatsList.h" 
#endif

#ifndef LIBPQXX_H
#include "libpq++.h"
#endif

#ifndef _SIGNAL_H
#include <signal.h>
#endif

#ifndef lib_pcap_h
// libpcap-dev bug workaround; remove when fixed
extern "C" {
#include <pcap.h>
}
#endif


/*
 * Structure of an internet header, naked of options.
 *
 * Stolen from tcpdump source, modified slightly.
 *
 * In turn gleefully stolen from a libpcap tutorial. I hope
 * They won't be mad at little ole me... ^_^;;;
 */
struct my_ip {
	u_int8_t	ip_vhl;		/* header length, version */
#define IP_V(ip)	(((ip)->ip_vhl & 0xf0) >> 4)
#define IP_HL(ip)	((ip)->ip_vhl & 0x0f)
	u_int8_t	ip_tos;		/* type of service */
	u_int16_t	ip_len;		/* total length */
	u_int16_t	ip_id;		/* identification */
	u_int16_t	ip_off;		/* fragment offset field */
#define	IP_DF 0x4000			/* dont fragment flag */
#define	IP_MF 0x2000			/* more fragments flag */
#define	IP_OFFMASK 0x1fff		/* mask for fragmenting bits */
	u_int8_t	ip_ttl;		/* time to live */
	u_int8_t	ip_p;		/* protocol */
	u_int16_t	ip_sum;		/* checksum */
	struct	in_addr ip_src;
	struct	in_addr	ip_dst;
};

// options structs carrying all the parameters for the various threads.
// 

struct storage_options {
	unsigned short 		interval;	// Delay between storage 
						// sessions
	char*			db_connstr;	// Connection string to connect
						// to the database.
};

struct sniffer_options {
	bool			do_promisc;	// Use promiscuous mode or not?
	bool			do_castrate;	// Ignore ports or not?
};

struct timer_options {
	unsigned short		interval;	// How long between retrieving
						// a new timestamp from the 
						// database?
	char*			db_connstr;	// as in storage_options.
};

#define TS_TIMESTAMP_SIZE	32
#define TS_QUERY_SIZE_MAX	100
#ifdef _DEBUG_
#define DLOG(x) cerr << x;
#else
#define DLOG(x) 
#endif

#endif
