<?cs set:html.stylesheet = 'css/changeset.css' ?>
<?cs include "header.cs"?>
<?cs include "macros.cs"?>

<div id="ctxtnav" class="nav">
 <h2>チェンジセットナビゲーション</h2>
 <ul><?cs
  if:len(links.prev) ?>
   <li class="first<?cs if:!len(links.next) ?> last<?cs /if ?>">
    <a class="prev" href="<?cs var:links.prev.0.href ?>" title="<?cs
      var:links.prev.0.title ?>">前のリビジョン</a>
   </li><?cs
  /if ?><?cs
  if:len(links.next) ?>
   <li class="<?cs if:len(links.prev) ?>first <?cs /if ?>last">
    <a class="next" href="<?cs var:links.next.0.href ?>" title="<?cs
      var:links.next.0.title ?>">後のリビジョン</a>
   </li><?cs
  /if ?>
 </ul>
</div>

<div id="content" class="changeset">
<h1>リビジョン <?cs var:changeset.revision ?> のチェンジセット</h1>

<?cs if:len(changeset.diff.files) ?><form method="post" id="prefs" action="">
 <div>
  <label for="style">diffの表示方法</label>
  <select id="style" name="style">
   <option value="inline"<?cs
     if:diff.style == 'inline' ?> selected="selected"<?cs
     /if ?>>インライン</option>
   <option value="sidebyside"<?cs
     if:diff.style == 'sidebyside' ?> selected="selected"<?cs
     /if ?>>並べて表示</option>
  </select>
  <div class="field">
   差分発生行の前後 <input type="text" name="contextlines" id="contextlines" size="2"
     maxlength="2" value="<?cs var:diff.options.contextlines ?>" />
   <label for="contextlines">行を表示</label>
  </div>
  <fieldset id="ignore">
   <legend>無視リスト:</legend>
   <div class="field">
    <input type="checkbox" id="blanklines" name="ignoreblanklines"<?cs
      if:diff.options.ignoreblanklines ?> checked="checked"<?cs /if ?> />
    <label for="blanklines">空行</label>
   </div>
   <div class="field">
    <input type="checkbox" id="case" name="ignorecase"<?cs
      if:diff.options.ignorecase ?> checked="checked"<?cs /if ?> />
    <label for="case">大文字小文字の変更</label>
   </div>
   <div class="field">
    <input type="checkbox" id="whitespace" name="ignorewhitespace"<?cs
      if:diff.options.ignorewhitespace ?> checked="checked"<?cs /if ?> />
    <label for="whitespace">空白文字の変更</label>
   </div>
  </fieldset>
  <div class="buttons">
   <input type="submit" name="update" value="更新" />
  </div>
 </div>
</form><?cs /if ?>

<dl id="overview">
 <dt class="time">コミット日時:</dt>
 <dd class="time"><?cs var:changeset.time ?></dd>
 <dt class="author">コミッタ:</dt>
 <dd class="author"><?cs var:changeset.author ?></dd>
 <dt class="message">ログメッセージ:</dt>
 <dd class="message" id="searchable"><?cs var:changeset.message ?></dd>
 <dt class="files">更新ファイル:</dt>
 <dd class="files"><?cs set:anchor_idx = #0 ?>
  <ul><?cs each:item = changeset.changes ?>
   <li>
    <?cs if:item.change == "A" ?>
     <div class="add"></div>
     <a href="<?cs var:item.browser_href ?>" title="ファイルを表示"><?cs
       var:item.name ?></a> <span class="comment">(追加)</span>
    <?cs elif:item.change == "M" ?>
     <div class="mod"></div>
     <a href="<?cs var:item.browser_href ?>" title="ファイルを表示"><?cs
       var:item.name ?></a> <span class="comment">(更新)</span><?cs
     if:len(changeset.diff.files[anchor_idx].changes) ?>
      (<a href="#file<?cs var:anchor_idx ?>" title="diffを表示">diff</a>)<?cs
     /if ?><?cs set:anchor_idx = anchor_idx + #1 ?>
    <?cs elif:item.change == "D" ?>
     <div class="rem"></div>
     <?cs var:item.name ?> <span class="comment">(削除)</span>
    <?cs /if ?>
   </li>
  <?cs /each ?></ul>
 </dd>
</dl>

<div class="diff">
 <div id="legend">
  <h3>Legend:</h3>
  <dl>
   <dt class="unmod"></dt><dd>変更無し</dd>
   <dt class="add"></dt><dd>追加</dd>
   <dt class="rem"></dt><dd>削除</dd>
   <dt class="mod"></dt><dd>更新</dd>
  </dl>
 </div>
 <ul>
  <?cs each:file = changeset.diff.files ?>
   <?cs if:len(file.changes) ?>
    <li id="file<?cs var:name(file) ?>">
     <h2><a href="<?cs
       var:file.browser_href.new ?>" title="リビジョン <?cs
       var:file.rev.new ?> の内容をリポジトリブラウザで表示する"><?cs
       var:file.name.new ?></a></h2>
     <?cs if:diff.style == 'sidebyside' ?>
      <table class="sidebyside" summary="Differences" cellspacing="0">
       <colgroup class="base">
        <col class="lineno" /><col class="content" />
       <colgroup class="chg">
        <col class="lineno" /><col class="content" />
       </colgroup>
       <thead><tr>
        <th colspan="2"><a href="<?cs var:file.browser_href.old ?>">リビジョン <?cs
          var:file.rev.old ?></a></th>
        <th colspan="2"><a href="<?cs var:file.browser_href.new ?>">リビジョン <?cs
          var:file.rev.new ?></a></th>
       </tr></thead>
       <?cs each:change = file.changes ?>
        <tbody>
         <?cs call:diff_display(change, diff.style) ?>
        </tbody>
        <?cs if:name(change) < len(file.changes) - 1 ?>
         <tbody class="skippedlines">
          <tr><th>&hellip;</th><td>&nbsp;</td>
          <th>&hellip;</th><td>&nbsp;</td></tr>
         </tbody>
        <?cs /if ?>
       <?cs /each ?>
      </table>
     <?cs else ?>
      <table class="inline" summary="Differences" cellspacing="0">
       <colgroup>
        <col class="lineno" />
        <col class="lineno" />
        <col class="content" />
       </colgroup>
       <thead><tr>
        <th title="Revision <?cs var:file.rev.old ?>"><a href="<?cs
          var:file.browser_href.old ?>" title="リビジョン <?cs
          var:file.rev.old ?> の内容をリポジトリブラウザで表示する">r<?cs
          var:file.rev.old ?></a></th>
        <th title="Revision <?cs var:file.rev.new ?>"><a href="<?cs
          var:file.browser_href.new ?>" title="リビジョン <?cs
          var:file.rev.new ?> の内容をリポジトリブラウザで表示する">r<?cs
          var:file.rev.new ?></a></th>
        <th>&nbsp;</th>
       </tr></thead>
       <?cs each:change = file.changes ?>
        <?cs call:diff_display(change, diff.style) ?>
        <?cs if:name(change) < len(file.changes) - 1 ?>
         <tbody class="skippedlines">
          <tr><th>&hellip;</th><th>&hellip;</th><td>&nbsp;</td></tr>
         </tbody>
        <?cs /if ?>
       <?cs /each ?>
      </table>
     <?cs /if ?>
    </li>
   <?cs /if ?>
  <?cs /each ?>
 </ul>
</div>

</div>
<?cs include "footer.cs"?>
