typedef long long vlong;
typedef unsigned long long uvlong;
typedef unsigned short Rune;
typedef unsigned long ulong;
typedef unsigned char uchar;

/* Move thread routines out of the way of broken libc */
#define	send	p9send
#define recv	p9recv
#define panic	p9panic

#include "../libunix/unix.h"

typedef u_int32_t u32int;

#define LABELDPC 0
typedef struct Label Label;	/* Must be 8-byte aligned (for FPR, VR save) */
struct Label
{
	ulong	pc;		/* lr */
	ulong	cr;		/* mfcr */
	ulong	ctr;		/* mfcr */
	ulong	xer;		/* mfcr */
	ulong	sp;		/* callee saved: r1 */
	ulong	toc;		/* callee saved: r2 */
	ulong	gpr[19];	/* callee saved: r13-r31 */
// XXX: currently do not save vector registers or floating-point state
//	ulong	pad;
//	uvlong	fpr[18];	/* callee saved: f14-f31 */
//	ulong	vr[4*12];	/* callee saved: v20-v31, 256-bits each */
};

extern vlong	strtoll(const char*, char**, int);
extern uvlong	strtoull(const char*, char**, int);
extern ulong	pread(int, void*, ulong, ulong);
extern ulong	pwrite(int, void*, ulong, ulong);
