#include "os.h"
#include "fmtdef.h"

static int
fmtStrFlush(Fmt *f)
{
	char *s;
	int n;

	n = (int)(intptr)f->farg; /* casts silence 64-bit compiler */
	n += 256;
	f->farg = (void*)(intptr)n; /* casts silence 64-bit compiler */
	s = f->start;
	f->start = realloc(s, n);
	if(f->start == nil){
		f->start = s;
		return 0;
	}
	f->to = (char*)f->start + ((char*)f->to - s);
	f->stop = (char*)f->start + n - 1;
	return 1;
}

int
fmtstrinit(Fmt *f)
{
	int n;

	f->runes = 0;
	n = 32;
	f->start = malloc(n);
	if(f->start == nil)
		return -1;
	f->to = f->start;
	f->stop = (char*)f->start + n - 1;
	f->flush = fmtStrFlush;
	f->farg = (void*)(intptr)n;  /* casts silence 64-bit compiler */
	f->nfmt = 0;
	return 0;
}

/*
 * print into an allocated string buffer
 */
char*
vsmprint(char *fmt, va_list args)
{
	Fmt f;
	int n;

	if(fmtstrinit(&f) < 0)
		return nil;
	f.args = args;
	n = dofmt(&f, fmt);
	if(n < 0)
		return nil;
	*(char*)f.to = '\0';
	return f.start;
}
