
/*********************************************************************
 *                
 * Filename:      thinkpadpm.h
 * Description:   header file for the thinkpadpm driver
 * Author:        Thomas Hood
 * Created:       27 January 2001
 *
 * Please report bugs to the author ASAP.
 * 
 *     Copyright (c) 2001 J.D. Thomas Hood, All rights reserved
 *     
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 * 
 *     To receive a copy of the GNU General Public License, please write
 *     to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *     Boston, MA 02111-1307 USA
 *     
 ********************************************************************/

#ifndef __THINKPADPM_H__
#define __THINKPADPM_H__

#include <linux/apm_bios.h>

/****** defines ******/

#define THINKPADPM_FUNC_STATE_GET  ((word)0x100)
#define THINKPADPM_FUNC_STATE_SET  ((word)0x101)

#define THINKPADPM_DEVICE_SERIAL_1   (APM_DEVICE_SERIAL)
#define THINKPADPM_DEVICE_SERIAL_2   (APM_DEVICE_SERIAL | 0x0001)
#define THINKPADPM_DEVICE_PARALLEL   (APM_DEVICE_PARALLEL)

#define THINKPADPM_STATE_READY     (APM_STATE_READY)
#define THINKPADPM_STATE_OFF       (APM_STATE_OFF)


/*** thinpadpm module input parameters ***/
typedef struct _thinkpadpm_inparm {
	word	wFunc;
	word	wParm0;
	dword	dwParm1;
} thinkpadpm_inparm_t;

/*** thinkpadpm module output parameters ***/
typedef struct _thinkpadpm_outparm {
	word	wRc;
	word	wParm0;
	dword	dwParm1;
} thinkpadpm_outparm_t;

typedef union _thinkpadpm_ioparm_t {
	thinkpadpm_inparm_t in;
	thinkpadpm_outparm_t out;
} thinkpadpm_ioparm_t;

/****** declarations ******/

int thinkpadpm_do(
	unsigned long ulongIoctlArg,
	flag_t fCallerHasWritePerm
);

#endif /* __THINKPADPM_H__ */
