// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "Object.h"

namespace Torch {

Object::Object()
{
  is_already_initialized = false;
  n_options = 0;
  options = NULL;
}

void Object::init()
{
  is_already_initialized = true;
}

void Object::addOption(const char *name, int size, void *ptr, const char *help, bool is_allowed_after_init)
{
  options = (Option *)xrealloc((void *)options, (n_options+1)*sizeof(Option));

  Option *optr = options+n_options;

  optr->name = (char *)xalloc(strlen(name)+1);
  optr->help = (char *)xalloc(strlen(help)+1);
  strcpy(optr->name, name);
  strcpy(optr->help, help);
  optr->size = size;
  optr->ptr = ptr;
  optr->is_allowed_after_init = is_allowed_after_init;
  n_options++;
}

void Object::addIOption(const char *name, int *ptr,  int init_value,  const char *help, bool is_allowed_after_init)
{
  *ptr = init_value;
  addOption(name, sizeof(int), ptr, help, is_allowed_after_init);
}

void Object::addROption(const char *name, real *ptr, real init_value, const char *help, bool is_allowed_after_init)
{
  *ptr = init_value;
  addOption(name, sizeof(real), ptr, help, is_allowed_after_init);
}

void Object::addBOption(const char *name, bool *ptr, bool init_value, const char *help, bool is_allowed_after_init)
{
  *ptr = init_value;
  addOption(name, sizeof(bool), ptr, help, is_allowed_after_init);
}

void Object::setOption(const char *name, void *ptr)
{
  Option *optr = options;

  bool flag = false;
  for(int i = 0; i < n_options; i++, optr++)
  {
    if( !strcmp(optr->name, name) )
    {
      flag = true;
      break;
    }
  }

  if(!flag)
    error("Object: option doesn't exists: %s", name);

  if(is_already_initialized && !optr->is_allowed_after_init)
    error("Object: the option <%s> cannot be set after initialization", name);

  char *odata = (char *)optr->ptr;
  char *odatao = (char *)ptr;

  for(int i = 0; i < optr->size; i++)
  {
    *odata = *odatao;
    odata++;
    odatao++;
  }
}

void Object::setIOption(const char *name, int option)
{
  setOption(name, (void *)&option);
}

void Object::setROption(const char *name, real option)
{
  setOption(name, (void *)&option);
}

void Object::setBOption(const char *name, bool option)
{
  setOption(name, (void *)&option);
}

void Object::load(const char *filename)
{
  FILE *file;

  if( (file = fopen(filename, "r")) == NULL)
    error("Object: cannot open the file <%s>", filename);

  loadFILE(file);

  fclose(file);
}

void Object::save(const char *filename)
{
  FILE *file;

  if( (file = fopen(filename, "w")) == NULL)
    error("Object: cannot open the file <%s>", filename);

  saveFILE(file);

  fclose(file);
}

void Object::loadFILE(FILE *file)
{
}

void Object::saveFILE(FILE *file)
{
}

Object::~Object()
{
  for(int i = 0; i < n_options; i++)
  {
    free(options[i].name);
    free(options[i].help);
  }
  free(options);
}

}

