// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef LOG_SOFTMAX_INC
#define LOG_SOFTMAX_INC

#include "GradientMachine.h"

namespace Torch {

/** LogSoftmax layer for #GradientMachine#.

    The number of inputs/outputs is the number
    of units in the machine.

    Formally speaking, $ouputs[i] = log(1/a * exp(inputs[i]))$
    where $a = \sum_j exp(inputs[j])$.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class LogSoftmax : public GradientMachine
{
  public:

    //-----

    /// Create a Sigmoid layer with #n_units# units.
    LogSoftmax(int n_units);

    //-----

    virtual int numberOfParams();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);

    virtual ~LogSoftmax();
};


}

#endif
