// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "GMTrainer.h"

namespace Torch {

GMTrainer::GMTrainer(GradientMachine *g_machine_, DataSet *data_,
                     Criterion *criterion_, Optimizer *optimizer_) : Trainer(g_machine_, data_)
{
  // Boaf
  g_machine = g_machine_;
  criterion = criterion_;
  optimizer = optimizer_;  
}

void GMTrainer::train(List *measurers)
{
  // Links
  criterion->setDataSet(data);
  optimizer->setMachine(g_machine);
  optimizer->setDataSet(data);
  optimizer->setCriterion(criterion);

  optimizer->train(measurers);
}

GMTrainer::~GMTrainer()
{
}

}

