// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef CLASS_FORMAT_INC
#define CLASS_FORMAT_INC

#include "Object.h"
#include "List.h"

namespace Torch {

/** Used to define a class code.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class ClassFormat : public Object
{
  public:

    /// Number of classes that the object currently handles
    int n_classes;
    /// The label of each class
    real **class_labels;
    
    ///
    ClassFormat();

    /// Returns #n_classes#
    int getNumberOfClasses();

    /// Returns the output size;
    virtual int getOutputSize() = 0;

    /// Transforms the output from a OneHot representation
    virtual void fromOneHot(List *outputs, List *one_hot_outputs) = 0;

    /// Transforms the output to a OneHot representation
    virtual void toOneHot(List *outputs, List *one_hot_outputs) = 0;

    /// Returns the class of #target#
    virtual int getTargetClass(void *target) = 0;

    /// Returns the class of #outputs#
    virtual int getOutputClass(List *outputs) = 0;

    virtual ~ClassFormat();
};


}

#endif
