// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "WordSegMeasurer.h"

namespace Torch {

WordSegMeasurer::WordSegMeasurer(SpeechHMM *shmm_, DataSet *data_, FILE *file_, bool print_targets_) : Measurer(data_, file_)
{
  shmm = shmm_;
  print_targets = print_targets_;
}

WordSegMeasurer::WordSegMeasurer(SpeechHMM *shmm_, DataSet *data_, const char *filename, bool print_targets_) : Measurer(data_, filename)
{
  shmm = shmm_;
  print_targets = print_targets_;
}

void WordSegMeasurer::measureEx()
{
  fprintf(file,"obtained: ");
  for (int j=0;j<shmm->word_sequence_size;j++)
    fprintf(file,"%s ",shmm->dict->words_string[shmm->word_sequence[j]]);
  fprintf(file,"\n");

  if (print_targets) {
    fprintf(file,"desired: ");
    for (int j=0;j<shmm->target_word_sequence_size;j++)
      fprintf(file,"%s ",shmm->dict->words_string[shmm->target_word_sequence[j]]);
    fprintf(file,"\n");
  }
  fflush(file);
}

void WordSegMeasurer::measureIter()
{
  fflush(file);
}

void WordSegMeasurer::init()
{
  Measurer::init();
  reset();
}

void WordSegMeasurer::reset()
{
}

WordSegMeasurer::~WordSegMeasurer()
{
}


}

