// Copyright (C) 2002 Johnny Mariethoz (Johnny.Mariethoz@idiap.ch)
//                and Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef HTK_SEQ_DATASET_INC
#define HTK_SEQ_DATASET_INC

#include "SeqDataSet.h"
#include "IOHtk.h"
#include "Dictionary.h"

namespace Torch {

/** This class is used to read Htk seqdatasets
 *
 * @author Samy Bengio (bengio@idiap.ch)
 * @author Johnny Mariethoz (Johnny.Mariethoz@idiap.ch)
 */
class HtkSeqDataSet : public SeqDataSet
{
  public:
    
    /// the files, in htk format
    IOHtk** htk;

    /// used to read targets and alignments
    Dictionary* dict;

    /// number of miliseconds per frame (used during alignment)
    int n_per_frame;

    ///
    HtkSeqDataSet(char* file, int max_load=-1);
    ///
    HtkSeqDataSet(char** files,int n_files, int max_load=-1);

    virtual ~HtkSeqDataSet();
    
    
    /** destroys data allocated by #createData# 
     */
    virtual void freeMemory();
		
		/** save the data set on htk binary format in specifing directory
		 */
		virtual void write(char* dir_to_save);

    virtual void setDictionary(Dictionary* dict);
    virtual void setNPerFrame(int n_per_frame);
    virtual void readTargets(char* file);
    virtual void readAlignments(char* file, bool needs_all_examples = false);
    virtual int findExample(char* name);
    virtual void prepareData();
    virtual void createMaskFromParam(bool* mask);
    
};

}

#endif


