	!
	! 12/31/96
	! A.B. Maccabe
	!
	! write a simple message to the UART
	!

	UARTSTATUS	= 0X140000 
	UARTCREG	= 0x140000
	UARTTXREG	= 0x140004
	UARTRXREG	= 0x140004

	.data
msg:	.asciz	"hello\n"

	.text
	.global start
	
start:	
	set	UARTSTATUS, %l0
	
	! set the UART control register -- disable interrupts and set the
	! rx/tx rate fairly low
	set	0x40, %l2
	st	%l2, [%l0]
	set	msg, %g1

top:
	! poll the uart, waiting until the transmit buffer is empty
poll:	ld	[%l0], %l1
	andcc	%l1, 1, %g0
	be	poll
	nop

	! get the next character to send
	ldub	[%g1], %g2
	inc	%g1
	cmp	%g2, 0
	bne,a	top
	st	%g2, [%l0+4]

	! all done
	ta	0
